/*
 *			GPAC - Multimedia Framework C SDK
 *
 *			Authors: Jean Le Feuvre
 *			Copyright (c) Telecom ParisTech 2000-2012
 *					All rights reserved
 *
 *  This file is part of GPAC
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*this file is only used with Win32&MSVC to export the symbols from libgpac(static) to libgpac(dynamic) based on the GPAC configuration*/
#include <gpac/setup.h>

#if defined(_WIN32_WCE) || defined(_WIN64)
#define EXPORT_SYMBOL(a) "/export:"#a
#else
#define EXPORT_SYMBOL(a) "/export:_"#a
#endif

#ifdef _WIN32_WCE
#pragma comment (linker, EXPORT_SYMBOL(CE_Assert) )
#pragma comment (linker, EXPORT_SYMBOL(CE_CharToWide) )
#pragma comment (linker, EXPORT_SYMBOL(CE_WideToChar) )
#endif


#pragma comment (linker, EXPORT_SYMBOL(gpac_features) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sys_init) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sys_close) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sleep) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mkdir) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rmdir) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cleanup_dir) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sys_clock) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sys_clock_high_res) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sys_get_rti) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sys_get_battery_state) )
#pragma comment (linker, EXPORT_SYMBOL(gf_get_default_cache_directory) )
#pragma comment (linker, EXPORT_SYMBOL(gf_4cc_to_str) )
#pragma comment (linker, EXPORT_SYMBOL(gf_error_to_string) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rand_init) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rand) )
#pragma comment (linker, EXPORT_SYMBOL(gf_get_user_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_enum_directory) )

#pragma comment (linker, EXPORT_SYMBOL(gf_log_modify_tools_levels) )
#pragma comment (linker, EXPORT_SYMBOL(gf_log_set_tools_levels) )
#pragma comment (linker, EXPORT_SYMBOL(gf_log_set_tool_level) )
#pragma comment (linker, EXPORT_SYMBOL(gf_log_set_strict_error) )
#pragma comment (linker, EXPORT_SYMBOL(gf_log_set_callback) )
#pragma comment (linker, EXPORT_SYMBOL(gf_log_get_tools_levels) )

#ifndef GPAC_DISABLE_LOG
#pragma comment (linker, EXPORT_SYMBOL(gf_log_tool_level_on) )
#pragma comment (linker, EXPORT_SYMBOL(gf_log) )
#pragma comment (linker, EXPORT_SYMBOL(gf_log_lt) )
#endif

#pragma comment (linker, EXPORT_SYMBOL(gf_set_progress) )
#pragma comment (linker, EXPORT_SYMBOL(gf_set_progress_callback) )
#pragma comment (linker, EXPORT_SYMBOL(gf_delete_file) )
#pragma comment (linker, EXPORT_SYMBOL(gf_move_file) )
#pragma comment (linker, EXPORT_SYMBOL(gf_temp_file_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_file_modification_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_fwrite) )
#pragma comment (linker, EXPORT_SYMBOL(gf_f64_open) )
#pragma comment (linker, EXPORT_SYMBOL(gf_f64_seek) )
#pragma comment (linker, EXPORT_SYMBOL(gf_f64_tell) )
#pragma comment (linker, EXPORT_SYMBOL(gf_prompt_has_input) )
#pragma comment (linker, EXPORT_SYMBOL(gf_prompt_get_char) )
#pragma comment (linker, EXPORT_SYMBOL(gf_prompt_set_echo_off) )
#pragma comment (linker, EXPORT_SYMBOL(gf_crc_32) )
#ifndef GPAC_DISABLE_ZLIB
#pragma comment (linker, EXPORT_SYMBOL(gf_gz_compress_payload) )
#pragma comment (linker, EXPORT_SYMBOL(gf_gz_decompress_payload) )
#endif

/* Memory */
#ifdef GPAC_MEMORY_TRACKING
#pragma comment (linker, EXPORT_SYMBOL(gf_mem_malloc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mem_calloc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mem_realloc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mem_free) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mem_strdup) )
#pragma comment (linker, EXPORT_SYMBOL(gf_memory_print) )
#pragma comment (linker, EXPORT_SYMBOL(gf_memory_size) )
#else
#pragma comment (linker, EXPORT_SYMBOL(gf_malloc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_calloc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_realloc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_free) )
#pragma comment (linker, EXPORT_SYMBOL(gf_strdup) )
#endif /*GPAC_MEMORY_TRACKING*/

/* Print */
#pragma comment (linker, EXPORT_SYMBOL(gf_asprintf) )

/* Ring Buffer */
#ifndef GPAC_DISABLE_PLAYER
#pragma comment (linker, EXPORT_SYMBOL(gf_ringbuffer_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_ringbuffer_read) )
#pragma comment (linker, EXPORT_SYMBOL(gf_ringbuffer_write) )
#pragma comment (linker, EXPORT_SYMBOL(gf_ringbuffer_available_for_read ) )
#pragma comment (linker, EXPORT_SYMBOL(gf_ringbuffer_del) )
#endif


/* Sound */
#ifndef GPAC_DISABLE_PLAYER
#pragma comment (linker, EXPORT_SYMBOL(gf_mixer_set_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mixer_get_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mixer_reconfig) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mixer_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mixer_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mixer_empty) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mixer_lock) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mixer_add_input) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mixer_get_output) )
#endif


/* List */
#pragma comment (linker, EXPORT_SYMBOL(gf_list_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_add) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_insert) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_rem) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_get) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_enum) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_find) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_del_item) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_reset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_last) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_rem_last) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_swap) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_transfer) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_reverse) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_clone) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_rev_enum) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_pop_front) )
#pragma comment (linker, EXPORT_SYMBOL(gf_list_pop_back) )


/* Map */
#ifndef GPAC_DISABLE_PLAYER
#pragma comment (linker, EXPORT_SYMBOL(gf_map_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_map_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_map_reset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_map_find) )
#pragma comment (linker, EXPORT_SYMBOL(gf_map_insert) )
#pragma comment (linker, EXPORT_SYMBOL(gf_map_rem) )
#pragma comment (linker, EXPORT_SYMBOL(gf_map_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_map_has_key) )
#pragma comment (linker, EXPORT_SYMBOL(gf_map_iter_set) )
#pragma comment (linker, EXPORT_SYMBOL(gf_map_iter_has_next) )
#pragma comment (linker, EXPORT_SYMBOL(gf_map_iter_reset) )
#endif

/* Bitstream */
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_from_file) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_read_bit) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_read_int) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_read_long_int) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_read_u8) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_read_u8_until_delimiter) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_read_u16) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_read_u24) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_read_u32) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_read_u64) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_read_float) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_read_double) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_read_data) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_write_int) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_write_long_int) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_write_u8) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_write_u16) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_write_u24) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_write_u32) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_write_u64) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_write_float) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_write_double) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_write_data) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_set_eos_callback) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_align) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_available) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_get_content) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_skip_bytes) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_seek) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_peek_bits) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_get_position) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_get_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_get_refreshed_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_set_output_buffering) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_transfer) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bs_flush) )


/* Thread */
#pragma comment (linker, EXPORT_SYMBOL(gf_th_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_th_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_th_run) )
#pragma comment (linker, EXPORT_SYMBOL(gf_th_stop) )
#pragma comment (linker, EXPORT_SYMBOL(gf_th_status) )
#pragma comment (linker, EXPORT_SYMBOL(gf_th_set_priority) )
#pragma comment (linker, EXPORT_SYMBOL(gf_th_id) )

/* Lock */
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_v) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_p) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_try_lock) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sema_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sema_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sema_notify) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sema_wait) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sema_wait_for) )
#pragma comment (linker, EXPORT_SYMBOL(gf_global_resource_lock) )
#pragma comment (linker, EXPORT_SYMBOL(gf_global_resource_unlock) )

/* Socket */
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_reset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_set_buffer_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_set_block_mode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_get_handle) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_bind) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_connect) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_send) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_receive) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_listen) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_accept) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_server_mode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_get_host_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_get_local_ip) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_get_local_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_get_remote_address) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_send_to) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_setup_multicast) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_is_multicast_address) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_send_wait) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sk_receive_wait) )
#pragma comment (linker, EXPORT_SYMBOL(gf_url_is_local) )
#pragma comment (linker, EXPORT_SYMBOL(gf_url_get_absolute_path) )
#pragma comment (linker, EXPORT_SYMBOL(gf_url_concatenate) )
#pragma comment (linker, EXPORT_SYMBOL(gf_url_get_resource_path) )
#pragma comment (linker, EXPORT_SYMBOL(gf_url_get_resource_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_url_remove_last_delimiter) )
#pragma comment (linker, EXPORT_SYMBOL(gf_url_get_ressource_extension) )
#pragma comment (linker, EXPORT_SYMBOL(gf_utc_time_since_1970) )
#pragma comment (linker, EXPORT_SYMBOL(gf_gettimeofday) )
#pragma comment (linker, EXPORT_SYMBOL(gf_net_get_ntp) )
#pragma comment (linker, EXPORT_SYMBOL(gf_net_get_utc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_net_parse_date) )
#pragma comment (linker, EXPORT_SYMBOL(gf_net_get_timezone) )
#pragma comment (linker, EXPORT_SYMBOL(gf_net_has_ipv6) )
#pragma comment (linker, EXPORT_SYMBOL(gf_net_is_ipv6) )
#pragma comment (linker, EXPORT_SYMBOL(gf_net_mobileip_set_callback) )

#ifndef GPAC_DISABLE_CORE_TOOLS
#pragma comment (linker, EXPORT_SYMBOL(gf_base64_encode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_base64_decode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_base16_encode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_base16_decode) )
#endif

#pragma comment (linker, EXPORT_SYMBOL(gf_bin128_parse) )

#pragma comment (linker, EXPORT_SYMBOL(gf_token_get) )
#pragma comment (linker, EXPORT_SYMBOL(gf_token_get_line) )
#pragma comment (linker, EXPORT_SYMBOL(gf_token_find) )

#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_init) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_force_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_remove) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_save) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_get_key) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_get_sub_key) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_set_key) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_get_section_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_get_section_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_get_key_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_get_key_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_insert_key) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_del_section) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_get_filename) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_set_filename) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cfg_discard_changes) )

#ifndef GPAC_DISABLE_PLAYER
#pragma comment (linker, EXPORT_SYMBOL(gf_modules_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_modules_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_modules_refresh) )
#pragma comment (linker, EXPORT_SYMBOL(gf_modules_get_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_modules_get_module_directories) )
#pragma comment (linker, EXPORT_SYMBOL(gf_modules_get_file_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_module_get_file_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_modules_load_interface) )
#pragma comment (linker, EXPORT_SYMBOL(gf_modules_load_interface_by_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_modules_close_interface) )
#pragma comment (linker, EXPORT_SYMBOL(gf_modules_get_option) )
#pragma comment (linker, EXPORT_SYMBOL(gf_modules_set_option) )
#pragma comment (linker, EXPORT_SYMBOL(gf_modules_get_config) )
#endif

#pragma comment (linker, EXPORT_SYMBOL(gf_utf8_wcstombs) )
#pragma comment (linker, EXPORT_SYMBOL(gf_utf8_mbstowcs) )
#pragma comment (linker, EXPORT_SYMBOL(gf_utf8_wcslen) )
#ifndef GPAC_DISABLE_PLAYER
#pragma comment (linker, EXPORT_SYMBOL(gf_utf8_is_right_to_left) )
#pragma comment (linker, EXPORT_SYMBOL(gf_utf8_reorder_bidi) )
#endif

#ifndef GPAC_DISABLE_CORE_TOOLS
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_new_simple) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_process) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_process_headers) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_get_cache_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_get_stats) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_get_utc_start) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_fetch_data) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_last_error) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_get_resource_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_reset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_mime_type) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_get_header) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_set_data_rate) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_get_data_rate) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_reassign) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cache_get_url) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cache_get_cache_filename) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cache_create_entry) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cache_get_mime_type) )
#pragma comment (linker, EXPORT_SYMBOL(appendHttpCacheHeaders) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cache_open_write_cache) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cache_set_last_modified_on_server) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cache_set_etag_on_server) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cache_set_content_length) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cache_set_mime_type) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cache_get_cache_filename_range) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_delete_cached_file_entry_session) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_url_info_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_get_url_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_url_info_init) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_is_thread_dead) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_abort) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_set_range) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_setup_from_url) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_get_file_memory) )


#pragma comment (linker, EXPORT_SYMBOL(gf_dm_sess_can_be_cached_on_disk) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_wget) )

#pragma comment (linker, EXPORT_SYMBOL(gf_xml_sax_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_sax_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_sax_init) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_sax_parse) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_sax_suspend) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_sax_parse_file) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_sax_get_line) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_sax_get_file_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_sax_get_file_pos) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_sax_peek_node) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_sax_binary_file) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_sax_get_error) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_get_root_type) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_sax_get_node_start_pos) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_sax_get_node_end_pos) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_dom_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_dom_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_dom_parse) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_dom_create_root) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_dom_get_attribute) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_dom_set_attribute) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_dom_append_child) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_dom_node_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_dom_get_root) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_dom_get_error) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_dom_get_line) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_dom_serialize) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_dom_node_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_dom_parse_string) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_parse_bit_sequence) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_dom_detach_root) )
#endif

#ifndef GPAC_DISABLE_SVG
#pragma comment (linker, EXPORT_SYMBOL(gf_dom_get_key_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dom_get_key_type) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dom_event_get_name) )
#endif

#ifdef GPAC_FIXED_POINT
#pragma comment (linker, EXPORT_SYMBOL(gf_invfix) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mulfix) )
#pragma comment (linker, EXPORT_SYMBOL(gf_muldiv) )
#pragma comment (linker, EXPORT_SYMBOL(gf_divfix) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cos) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sin) )
#pragma comment (linker, EXPORT_SYMBOL(gf_tan) )
#pragma comment (linker, EXPORT_SYMBOL(gf_atan2) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sqrt) )
#pragma comment (linker, EXPORT_SYMBOL(gf_ceil) )
#pragma comment (linker, EXPORT_SYMBOL(gf_floor) )
#pragma comment (linker, EXPORT_SYMBOL(gf_acos) )
#pragma comment (linker, EXPORT_SYMBOL(gf_asin) )
#endif /*GPAC_FIXED_POINT*/

#ifndef GPAC_DISABLE_PLAYER
#pragma comment (linker, EXPORT_SYMBOL(gf_angle_diff) )
#pragma comment (linker, EXPORT_SYMBOL(gf_v2d_len) )
#pragma comment (linker, EXPORT_SYMBOL(gf_v2d_from_polar) )
#pragma comment (linker, EXPORT_SYMBOL(gf_v2d_distance) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rect_union) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rect_center) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rect_overlaps) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rect_equal) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rect_pixelize) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx2d_add_matrix) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx2d_pre_multiply) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx2d_add_translation) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx2d_add_rotation) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx2d_add_scale) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx2d_add_scale_at) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx2d_add_skew) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx2d_add_skew_x) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx2d_add_skew_y) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx2d_inverse) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx2d_apply_coords) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx2d_apply_point) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx2d_apply_rect) )
#pragma comment (linker, EXPORT_SYMBOL(gf_get_bit_size) )

/*exported for 3D tools*/
#pragma comment (linker, EXPORT_SYMBOL(gf_vec_len) )
#pragma comment (linker, EXPORT_SYMBOL(gf_vec_lensq) )
#pragma comment (linker, EXPORT_SYMBOL(gf_vec_dot) )
#pragma comment (linker, EXPORT_SYMBOL(gf_vec_norm) )
#pragma comment (linker, EXPORT_SYMBOL(gf_vec_scale) )
#pragma comment (linker, EXPORT_SYMBOL(gf_vec_cross) )
#pragma comment (linker, EXPORT_SYMBOL(gf_quat_to_rotation) )
#pragma comment (linker, EXPORT_SYMBOL(gf_quat_from_matrix) )
#pragma comment (linker, EXPORT_SYMBOL(gf_quat_from_rotation) )
#pragma comment (linker, EXPORT_SYMBOL(gf_quat_get_inv) )
#pragma comment (linker, EXPORT_SYMBOL(gf_quat_multiply) )
#pragma comment (linker, EXPORT_SYMBOL(gf_quat_rotate) )
#pragma comment (linker, EXPORT_SYMBOL(gf_quat_from_axis_cos) )
#pragma comment (linker, EXPORT_SYMBOL(gf_quat_slerp) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bbox_refresh) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bbox_from_rect) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rect_from_bbox) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bbox_grow_point) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bbox_union) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bbox_equal) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bbox_point_inside) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bbox_get_vertices) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_from_mx2d) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_equal) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_add_translation) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_add_scale) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_add_rotation) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_add_matrix) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_add_matrix_2d) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_inverse) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_apply_vec) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_apply_rect) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_ortho) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_perspective) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_lookat) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_apply_bbox) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_add_matrix_4x4) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_inverse_4x4) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_apply_vec_4x4) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_decompose) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_rotate_vector) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_rotation_matrix_from_vectors) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx2d_from_mx) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_apply_plane) )
#pragma comment (linker, EXPORT_SYMBOL(gf_plane_get_distance) )
#pragma comment (linker, EXPORT_SYMBOL(gf_plane_intersect_line) )
#pragma comment (linker, EXPORT_SYMBOL(gf_closest_point_to_line) )
#pragma comment (linker, EXPORT_SYMBOL(gf_plane_get_p_vertex_idx) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bbox_plane_relation) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mx_apply_ray) )
#pragma comment (linker, EXPORT_SYMBOL(gf_ray) )
#pragma comment (linker, EXPORT_SYMBOL(gf_ray_hit_box) )
#pragma comment (linker, EXPORT_SYMBOL(gf_ray_hit_sphere) )
#pragma comment (linker, EXPORT_SYMBOL(gf_ray_hit_triangle) )
#pragma comment (linker, EXPORT_SYMBOL(gf_ray_hit_triangle_backcull) )

/*color.h exports*/
#pragma comment (linker, EXPORT_SYMBOL(gf_stretch_bits) )
#pragma comment (linker, EXPORT_SYMBOL(gf_color_write_yv12_10_to_yuv) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cmx_init) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cmx_set) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cmx_set_all) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cmx_copy) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cmx_multiply) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cmx_apply) )
#pragma comment (linker, EXPORT_SYMBOL(gf_cmx_apply_fixed) )

/*path2d.h exports*/
#pragma comment (linker, EXPORT_SYMBOL(gf_path_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_reset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_close) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_add_move_to) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_add_move_to_vec) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_add_line_to) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_add_line_to_vec) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_add_cubic_to) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_add_cubic_to_vec) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_add_quadratic_to) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_add_quadratic_to_vec) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_add_rect_center) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_add_rect) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_add_ellipse) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_add_bezier) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_add_arc_to) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_add_svg_arc_to) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_add_arc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_get_control_bounds) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_get_bounds) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_flatten) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_get_flatten) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_iterator_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_iterator_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_iterator_get_length) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_iterator_get_transform) )
#pragma comment (linker, EXPORT_SYMBOL(gf_polygone2d_get_convexity) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_get_outline) )
#pragma comment (linker, EXPORT_SYMBOL(gf_path_point_over) )

#endif //GPAC_DISABLE_PLAYER

/*mpeg4_odf.h exports*/
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_desc_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_desc_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_desc_esd_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_parse_descriptor) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_write_descriptor) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_desc_read) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_desc_copy) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_codec_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_codec_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_codec_add_com) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_codec_encode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_codec_get_au) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_codec_set_au) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_codec_decode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_codec_get_com) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_com_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_com_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_afx_get_type_description) )
#pragma comment (linker, EXPORT_SYMBOL(gf_esd_get_textual_description) )

#pragma comment (linker, EXPORT_SYMBOL(gf_odf_slc_set_pref) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_get_bifs_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_get_text_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_get_ui_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_get_laser_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_encode_ui_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sl_depacketize) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_desc_write) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_desc_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_stream_type_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_stream_type_by_name) )

#pragma comment (linker, EXPORT_SYMBOL(gf_odf_avc_cfg_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_avc_cfg_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_hevc_cfg_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_hevc_cfg_read) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_hevc_cfg_del) )

#ifndef GPAC_MINIMAL_ODF
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_desc_add_desc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_desc_list_read) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_desc_list_write) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_desc_list_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_desc_list_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_qos_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_qos_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_qos_add_qualif) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_event_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_event_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_event_set_start_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_event_set_duration) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_event_add_desc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_event_get_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_event_get_start_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_event_get_duration) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_event_get_desc_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_event_get_desc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_event_rem_desc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_codec_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_codec_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_codec_add_event) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_codec_encode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_codec_decode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_codec_get_event) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_avc_cfg_read) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_avc_cfg_write) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sl_packetize) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sl_get_header_size) )
#endif /*GPAC_MINIMAL_ODF*/

/*isomedia.h exports*/
#ifndef GPAC_DISABLE_ISOM
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_sample_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_sample_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_last_error) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_probe_file) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_open) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_close) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_delete) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_mode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_file_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_moov_first) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_timed_meta_data_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_box_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_box_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_parse_box) )
#ifndef GPAC_DISABLE_ISOM_WRITE
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_box_write) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_box_size) )
#endif
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_open_progressive) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_missing_bytes) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_is_fragmented) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_fragmented_duration) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_fragments_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_fragmented_samples_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_is_track_fragmented) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_reset_tables) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_reset_data_offset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_single_moof_mode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_release_segment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_open_segment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_highest_track_in_scalable_segment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_refresh_fragmented) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_track_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_timescale) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_duration) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_creation_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_track_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_track_by_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_is_track_enabled) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_is_track_encrypted) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_track_duration) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_media_type) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_media_subtype) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_mpeg4_subtype) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_media_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_sample_description_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_sample_description_index) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_is_self_contained) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_media_duration) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_media_timescale) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_chunks_infos) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_handler_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_media_language) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_check_data_reference) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_data_reference) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_sample_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_sample_padding) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_sample) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_sample_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_sample_for_media_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_sample_for_movie_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_sample_dts) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_sample_duration) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_sample_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_sample_sync) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_edit_list_type) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_edit_segment_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_edit_segment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_copyright_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_copyright) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_watermark) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_has_sync_points) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_has_time_offset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_sync_point_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_has_root_od) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_root_od) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_is_track_in_root_od) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_esd) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_decoder_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_reference_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_reference) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_reference_ID) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_has_track_reference) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_filename) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_brand_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_alternate_brand) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_has_padding_bits) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_visual_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_pixel_aspect_ratio) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_audio_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_chapter_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_chapter) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_user_data_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_user_data) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_generic_sample_description) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_fragment_defaults) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_sample_fragment_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_sample_fragment_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_default_sync_track) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_3gp_config_get) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_ac3_config_get) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_text_set_streaming_mode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_track_layout_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_track_matrix) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_pl_indication) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_is_media_encrypted) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_ismacryp_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_is_ismacryp_media) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_ismacryp_delete_sample) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_ismacryp_sample) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_cenc_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_original_format_type) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_pssh_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_pssh_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_is_cenc_media) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_sample_cenc_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_cenc_get_sample_aux_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_cenc_samp_aux_info_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_cenc_get_default_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_avc_svc_type) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_avc_config_get) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_svc_config_get) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_3gp_config_get) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_hevc_config_get) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_shvc_config_get) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_hevc_shvc_type) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_meta_item_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_meta_item_by_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_meta_item_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_meta_type) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_has_meta_xml) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_extract_meta_xml) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_extract_meta_item) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_has_movie) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_has_segment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_segment_get_fragment_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_segment_get_track_fragment_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_segment_get_track_fragment_decode_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_is_single_av) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_guess_specification) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_keep_utc_times) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_has_sync_shadows) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_has_sample_dependency) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_find_od_for_track) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_apple_get_tag) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_media_data_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_omadrm_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_is_omadrm_media) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_dims_description) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_track_switch_group_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_track_switch_parameter) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_next_alternate_group_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_meta_primary_item_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_is_JPEG2000) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_rvc_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_sample_rap_roll_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_reset_fragment_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_track_original_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_nalu_extract_mode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_nalu_extract_mode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_composition_offset_shift) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_has_scalable_layer) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_last_producer_time_box) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_current_tfdt) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_is_adobe_protection_media) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_adobe_protection_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_sample_group_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_tile_info) )

#ifndef GPAC_DISABLE_ISOM_WRITE
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_sync_table) )
#endif

# ifndef GPAC_DISABLE_ISOM_DUMP
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_dump) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_text_dump) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_dump_ismacryp_protection) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_dump_ismacryp_sample) )
#endif

#ifndef GPAC_DISABLE_ISOM_HINTING
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_payt_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_payt_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_reset_hint_reader) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_next_hint_packet) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_sdp_get) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_sdp_track_get) )
# ifndef GPAC_DISABLE_ISOM_DUMP
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_dump_hint_sample) )
#endif
#endif

#ifndef GPAC_DISABLE_ISOM_WRITE
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_timescale) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_new_track) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_track) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_creation_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_track_creation_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_track_enabled) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_track_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_rewrite_track_dependencies) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_add_sample) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_add_sample_shadow) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_append_sample_data) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_refresh_size_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_add_sample_reference) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_last_sample_duration) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_track_reference) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_track_reference) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_update_sample) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_update_sample_reference) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_sample) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_final_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_storage_mode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_storage_mode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_interleave_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_interleave_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_copyright) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_media_type) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_media_subtype) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_copyright) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_watermark) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_edit_segment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_modify_edit_segment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_append_edit_segment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_edit_segments) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_edit_segment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_media_language) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_handler_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_add_user_data) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_user_data) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_user_data_item) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_use_compact_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_brand_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_modify_alternate_brand) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_sample_padding_bits) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_visual_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_pixel_aspect_ratio) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_track_layout_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_track_matrix) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_audio_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_cts_packing) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_modify_cts_offset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_cts_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_track_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_track_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_pl_indication) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_root_od_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_root_od_url) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_root_od) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_add_desc_to_root_od) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_add_track_to_root_od) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_track_from_root_od) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_new_mpeg4_description) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_change_mpeg4_description) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_add_desc_to_description) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_new_generic_sample_description) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_change_generic_sample_description) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_sample_description) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_clone_sample_description) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_clone_track) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_clone_pl_indications) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_clone_root_od) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_is_same_sample_description) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_add_chapter) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_chapter) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_sync_shadows) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_sync_shadow) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_track_group) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_track_priority_in_group) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_max_samples_per_chunk) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_extraction_slc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_extraction_slc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_track_group) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_track_priority_in_group) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_store_movie_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_load_movie_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_make_interleave) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_3gp_config_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_3gp_config_update) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_new_text_description) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_new_text_sample) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_text_reset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_text_add_text) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_text_add_style) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_text_add_highlight) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_text_set_highlight_color) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_text_add_karaoke) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_text_set_karaoke_segment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_text_set_scroll_delay) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_text_add_hyperlink) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_text_set_box) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_text_add_blink) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_text_set_wrap) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_text_to_sample) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_track_protection) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_ismacryp_protection) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_change_ismacryp_protection) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_avc_config_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_avc_config_update) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_avc_set_inband_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_svc_config_update) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_hevc_config_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_hevc_config_update) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_hevc_set_inband_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_shvc_config_update) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_3gp_config_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_3gp_config_update) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_media_timescale) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_estimate_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_meta_type) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_add_meta_item) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_add_meta_item_memory) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_meta_item) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_meta_primary_item) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_meta_xml) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_meta_xml_memory) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_meta_xml) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_apple_set_tag) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_get_next_alternate_group_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_ipod_compatible) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_reset_switch_parameters) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_reset_track_switch_parameter) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_track_switch_parameter) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_alternate_group_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_new_dims_description) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_update_dims_description) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_rvc_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_sample_rap_group) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_sample_roll_group) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_sample_cenc_group) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_composition_offset_mode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_output_buffering) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_add_sample_group_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_add_sample_info) )

#ifndef GPAC_DISABLE_ISOM_HINTING
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_setup_hint_track) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_new_hint_description) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_begin_hint_sample) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_end_hint_sample) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_hint_blank_data) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_hint_direct_data) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_hint_sample_data) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_hint_sample_description_data) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_rtp_packet_begin) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_rtp_packet_set_flags) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_rtp_packet_set_offset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_rtp_set_timescale) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_rtp_set_time_offset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_rtp_set_time_sequence_offset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_sdp_add_track_line) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_sdp_clean_track) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_sdp_add_line) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_sdp_clean) )
#endif /*GPAC_DISABLE_ISOM_HINTING*/

#ifndef GPAC_DISABLE_ISOM_FRAGMENTS
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_add_sample_fragment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_remove_sample_fragment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_setup_track_fragment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_finalize_for_fragment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_start_fragment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_flush_fragments) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_fragment_reference_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_fragment_option) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_fragment_add_sample) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_fragment_append_data) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_fragment_add_sai) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_clone_pssh) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_start_segment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_close_segment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_set_traf_base_media_decode_time) )
#endif

#endif /*GPAC_DISABLE_ISOM_WRITE*/

/*isomedia_dev.h exports*/
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_parse_texte_sample) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_delete_text_sample) )

#ifndef GPAC_DISABLE_STREAMING
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_streamer_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_streamer_new_extended) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_streamer_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_streamer_append_sdp) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_streamer_append_sdp_extended) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_streamer_append_sdp_decoding_dependency) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_streamer_send_au) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_streamer_send_au_with_sn) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_streamer_send_data) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_streamer_format_sdp_header) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_streamer_disable_auto_rtcp) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_streamer_send_rtcp) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_streamer_get_payload_type) )


#pragma comment (linker, EXPORT_SYMBOL(gf_isom_streamer_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_streamer_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_streamer_write_sdp) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_streamer_get_sdp) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_streamer_send_next_packet) )
#pragma comment (linker, EXPORT_SYMBOL(gf_isom_streamer_reset) )
#endif

#pragma comment (linker, EXPORT_SYMBOL(gf_media_map_esd) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_get_file_hash) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_reduce_aspect_ratio) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_get_reduced_frame_rate) )

#endif /*GPAC_DISABLE_ISOM*/


/*service.h exports*/
#ifndef GPAC_DISABLE_PLAYER
#pragma comment (linker, EXPORT_SYMBOL(gf_service_connect_ack) )
#pragma comment (linker, EXPORT_SYMBOL(gf_service_disconnect_ack) )
#pragma comment (linker, EXPORT_SYMBOL(gf_service_command) )
#pragma comment (linker, EXPORT_SYMBOL(gf_service_send_packet) )
#pragma comment (linker, EXPORT_SYMBOL(gf_service_get_url) )
#pragma comment (linker, EXPORT_SYMBOL(gf_service_declare_media) )
#pragma comment (linker, EXPORT_SYMBOL(gf_service_get_interface) )
#pragma comment (linker, EXPORT_SYMBOL(gf_service_register_mime) )
#pragma comment (linker, EXPORT_SYMBOL(gf_service_check_mime_register) )
#pragma comment (linker, EXPORT_SYMBOL(gf_service_download_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_service_download_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_service_download_update_stats) )

/*mediaobject.h exports*/
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_register) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_unregister) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_play) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_stop) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_restart) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_pause) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_resume) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_set_speed) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_get_speed) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_get_loop) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_get_duration) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_should_deactivate) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_url_changed) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_fetch_data) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_release_data) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_get_object_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_is_muted) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_is_done) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_adjust_clock) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_get_last_frame_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_get_visual_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_get_audio_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_get_current_speed) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_has_audio) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_is_private_media) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_set_position) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_get_flags) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_set_flag) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_get_min_frame_dur) )

#ifndef GPAC_DISABLE_SVG
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_load_xlink_resource) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_unload_xlink_resource) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_get_scenegraph) )
#endif

#endif

/*ietf.h exports*/
#ifndef GPAC_DISABLE_STREAMING
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_nc_to_string) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_range_parse) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_range_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_range_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_transport_clone) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_transport_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_command_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_command_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_command_reset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_response_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_response_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_response_reset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_session_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_session_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_set_mobile_ip) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_set_buffer_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_session_reset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_is_my_session) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_get_last_session_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_get_server_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_get_service_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_get_response) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_get_session_state) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_get_last_request) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_reset_aggregation) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_send_command) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_set_interleave_callback) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_session_read) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_register_interleave) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_unregister_interleave) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_session_new_server) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_get_command) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_load_service_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_generate_session_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_send_response) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_get_session_ip) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_get_next_interleave_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_get_remote_address) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtsp_get_session_port) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_setup_transport) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_set_ports) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_setup_payload) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_enable_nat_keepalive) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_initialize) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_stop) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_set_info_rtp) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_get_current_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_reset_buffers) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_read_rtp) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_read_rtcp) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_decode_rtp) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_decode_rtcp) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_send_rtcp_report) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_send_bye) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_send_packet) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_set_info_rtcp) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_is_unicast) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_is_interleaved) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_get_clockrate) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_is_active) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_get_low_interleave_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_get_hight_interleave_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_get_transport) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_get_local_ssrc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_get_loss) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_get_tcp_bytes_sent) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_get_ports) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sdp_info_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sdp_info_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sdp_info_reset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sdp_info_parse) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sdp_info_check) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sdp_info_write) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sdp_media_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sdp_media_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sdp_conn_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sdp_conn_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sdp_fmtp_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sdp_fmtp_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_builder_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_builder_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_builder_init) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_builder_process) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_builder_format_sdp) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_builder_get_payload_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_depacketizer_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_depacketizer_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_depacketizer_reset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_depacketizer_process) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_depacketizer_get_slconfig) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_reorderer_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_reorderer_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_reorderer_reset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_reorderer_add) )
#pragma comment (linker, EXPORT_SYMBOL(gf_rtp_reorderer_get) )

#endif /*GPAC_DISABLE_STREAMING*/



#ifndef GPAC_DISABLE_AVILIB
/*avilib exports*/
#pragma comment (linker, EXPORT_SYMBOL(AVI_open_output_file) )
#pragma comment (linker, EXPORT_SYMBOL(AVI_close) )
#pragma comment (linker, EXPORT_SYMBOL(AVI_set_video) )
#pragma comment (linker, EXPORT_SYMBOL(AVI_write_frame) )
#pragma comment (linker, EXPORT_SYMBOL(AVI_set_audio) )
#pragma comment (linker, EXPORT_SYMBOL(AVI_write_audio) )

#endif /*GPAC_DISABLE_AVILIB*/

/*media.h exports*/
#ifndef GPAC_DISABLE_ISOM_HINTING
#pragma comment (linker, EXPORT_SYMBOL(gf_hinter_track_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_hinter_track_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_hinter_track_process) )
#pragma comment (linker, EXPORT_SYMBOL(gf_hinter_track_finalize) )
#pragma comment (linker, EXPORT_SYMBOL(gf_hinter_finalize) )
#pragma comment (linker, EXPORT_SYMBOL(gf_hinter_track_get_bandwidth) )
#pragma comment (linker, EXPORT_SYMBOL(gf_hinter_track_get_flags) )
#pragma comment (linker, EXPORT_SYMBOL(gf_hinter_track_get_payload_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_hinter_can_embbed_data) )
#endif

#ifndef GPAC_DISABLE_MEDIA_IMPORT
#pragma comment (linker, EXPORT_SYMBOL(gf_media_make_isma) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_make_3gpp) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_make_psp) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_import) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_import_chapters) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_change_pl) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_nalu_next_start_code_bs) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_avc_rewrite_samples) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_split_svc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_merge_svc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_split_hevc_tiles) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_split_shvc) )

#endif /*GPAC_DISABLE_MEDIA_IMPORT*/

#ifndef GPAC_DISABLE_ISOM_WRITE
#pragma comment (linker, EXPORT_SYMBOL(gf_media_change_par) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_remove_non_rap) )
#endif

#ifndef GPAC_DISABLE_AV_PARSERS
#pragma comment (linker, EXPORT_SYMBOL(gf_media_nalu_next_start_code) )

#pragma comment (linker, EXPORT_SYMBOL(gf_avc_get_sps_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_avc_get_pps_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_avc_get_profile_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_avc_parse_nalu) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_avc_read_sps) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_avc_read_pps) )

#ifndef GPAC_DISABLE_HEVC
#pragma comment (linker, EXPORT_SYMBOL(gf_media_hevc_read_vps) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_hevc_read_sps) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_hevc_read_pps) )
#pragma comment (linker, EXPORT_SYMBOL(gf_hevc_get_sps_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_hevc_get_profile_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_hevc_get_sps_info_with_state) )
#pragma comment (linker, EXPORT_SYMBOL(gf_media_hevc_parse_nalu) )

#endif //GPAC_DISABLE_HEVC

#endif /*GPAC_DISABLE_AV_PARSERS*/


#ifndef GPAC_DISABLE_MEDIA_EXPORT
#pragma comment (linker, EXPORT_SYMBOL(gf_media_export) )
#endif /*GPAC_DISABLE_MEDIA_EXPORT*/

/*mcrypt exports*/
#ifndef GPAC_DISABLE_MCRYPT
#pragma comment (linker, EXPORT_SYMBOL(gf_crypt_open) )
#pragma comment (linker, EXPORT_SYMBOL(gf_crypt_close) )
#pragma comment (linker, EXPORT_SYMBOL(gf_crypt_init) )
#pragma comment (linker, EXPORT_SYMBOL(gf_crypt_decrypt) )
#pragma comment (linker, EXPORT_SYMBOL(gf_crypt_encrypt) )
#pragma comment (linker, EXPORT_SYMBOL(gf_crypt_set_key) )
#pragma comment (linker, EXPORT_SYMBOL(gf_crypt_set_state) )
#endif GPAC_DISABLE_MCRYPT
#pragma comment (linker, EXPORT_SYMBOL(gf_sha1_csum) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sha1_csum_hexa) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sha1_file) )

#ifndef GPAC_DISABLE_AV_PARSERS
#pragma comment (linker, EXPORT_SYMBOL(gf_m4v_parser_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m4v_parser_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m4v_parse_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m4v_parse_frame) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m4v_get_object_start) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m4v_is_valid_object_type) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m4v_get_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m4v_rewrite_pl) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mp3_num_channels) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mp3_sampling_rate) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mp3_window_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mp3_object_type_indication) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mp3_layer) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mp3_frame_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mp3_get_next_header) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mp3_get_next_header_mem) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m4a_get_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m4a_write_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m4a_write_config_bs) )

#pragma comment (linker, EXPORT_SYMBOL(gf_ac3_parser_bs) )
#pragma comment (linker, EXPORT_SYMBOL(gf_ac3_get_channels) )
#pragma comment (linker, EXPORT_SYMBOL(gf_ac3_get_bitrate) )
#ifndef GPAC_DISABLE_OGG
#pragma comment (linker, EXPORT_SYMBOL(gf_vorbis_parse_header) )
#pragma comment (linker, EXPORT_SYMBOL(gf_vorbis_check_frame) )
#endif

#endif

#pragma comment (linker, EXPORT_SYMBOL(gf_img_parse) )
#pragma comment (linker, EXPORT_SYMBOL(gf_img_jpeg_dec) )
#pragma comment (linker, EXPORT_SYMBOL(gf_img_png_dec) )
#pragma comment (linker, EXPORT_SYMBOL(gf_img_png_enc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_img_png_enc_file) )
#pragma comment (linker, EXPORT_SYMBOL(gf_img_file_dec) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m4v_get_profile_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mp3_version) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mp3_version_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m4a_object_type_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m4a_get_profile_name) )

#ifndef GPAC_DISABLE_AV_PARSERS
#pragma comment (linker, EXPORT_SYMBOL(gf_m4a_get_profile) )
#endif

#if !defined(GPAC_DISABLE_MCRYPT) && !defined(GPAC_DISABLE_ISOM_WRITE)
/*ismacryp.h exports*/
#pragma comment (linker, EXPORT_SYMBOL(gf_crypt_file) )
#pragma comment (linker, EXPORT_SYMBOL(gf_decrypt_file) )
#pragma comment (linker, EXPORT_SYMBOL(gf_ismacryp_encrypt_track) )
#pragma comment (linker, EXPORT_SYMBOL(gf_ismacryp_decrypt_track) )
#pragma comment (linker, EXPORT_SYMBOL(gf_ismacryp_gpac_get_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_ismacryp_mpeg4ip_get_info) )


#endif

/*scene_manager.h exports*/

#ifndef GPAC_DISABLE_SCENE_STATS
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_stats_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_stats_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_stats_reset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_stats_get) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_stats_for_graph) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_stats_for_scene) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_stats_for_command) )
#endif

#ifndef GPAC_DISABLE_SMGR
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_stream_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_stream_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_stream_au_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_aggregate) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_reset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_load_init) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_load_done) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_load_string) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_load_run) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_load_suspend) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_import_bifs_subtitle) )
#endif

#ifndef GPAC_DISABLE_LOADER_BT
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_load_bt_from_string) )
#endif

#if !defined(GPAC_DISABLE_SCENE_ENCODER) && !defined(GPAC_DISABLE_ISOM_WRITE)
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_encode_to_file) )
#endif

#ifndef GPAC_DISABLE_SCENE_DUMP
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_dumper_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_dumper_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_dump) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_dump_command_list) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sm_dump_graph) )
#ifndef GPAC_DISABLE_OD_DUMP
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_dump_au) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_dump_com) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_dump_desc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odf_dump_com_list) )
#ifndef GPAC_MINIMAL_ODF
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_dump_event) )
#pragma comment (linker, EXPORT_SYMBOL(gf_oci_dump_au) )
#endif
#endif
#endif

#ifndef GPAC_DISABLE_SENG
/*bifsengine exports*/
#pragma comment (linker, EXPORT_SYMBOL(gf_seng_init) )
#pragma comment (linker, EXPORT_SYMBOL(gf_seng_init_from_string) )
#pragma comment (linker, EXPORT_SYMBOL(gf_seng_init_from_context) )
#pragma comment (linker, EXPORT_SYMBOL(gf_seng_get_stream_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_seng_get_stream_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_seng_encode_context) )
#pragma comment (linker, EXPORT_SYMBOL(gf_seng_encode_from_file) )
#pragma comment (linker, EXPORT_SYMBOL(gf_seng_encode_from_string) )
#pragma comment (linker, EXPORT_SYMBOL(gf_seng_encode_from_commands) )
#pragma comment (linker, EXPORT_SYMBOL(gf_seng_save_context) )
#pragma comment (linker, EXPORT_SYMBOL(gf_seng_enable_aggregation) )
#pragma comment (linker, EXPORT_SYMBOL(gf_seng_aggregate_context) )
#pragma comment (linker, EXPORT_SYMBOL(gf_seng_get_base64_iod) )
#pragma comment (linker, EXPORT_SYMBOL(gf_seng_get_iod) )
#pragma comment (linker, EXPORT_SYMBOL(gf_seng_terminate) )
#pragma comment (linker, EXPORT_SYMBOL(gf_seng_get_stream_carousel_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_seng_dump_rap_on) )
#endif

/*bifs.h exports*/
#ifndef GPAC_DISABLE_BIFS
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_decoder_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_decoder_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_decoder_set_extraction_path) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_decoder_ignore_size_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_decoder_configure_stream) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_decoder_remove_stream) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_decode_au) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_decode_command_list) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_get_aq_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_get_node_type) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_proto_field_set_aq_info) )
#ifndef GPAC_DISABLE_BIFS_ENC
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_encoder_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_encoder_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_encoder_new_stream) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_encode_au) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_encoder_get_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_encoder_get_version) )
#pragma comment (linker, EXPORT_SYMBOL(gf_bifs_encoder_get_rap) )
#endif
#endif /*GPAC_DISABLE_BIFS*/

#if !defined(GPAC_DISABLE_VRML) && !defined(GPAC_DISABLE_X3D) && !defined(GPAC_DISABLE_SVG)

/*scenegraph.h exports*/
#pragma comment (linker, EXPORT_SYMBOL(gf_node_get_tag) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_set_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_get_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_get_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_get_name_and_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_get_private) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_set_private) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_set_callback_function) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_register) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_unregister) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_replace) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_unregister_children) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_allow_cyclic_traverse) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_traverse) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_traverse_children) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_get_parent_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_get_parent) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_parent_of) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_get_class_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_dirty_set) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_dirty_clear) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_dirty_get) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_dirty_reset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_get_field) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_get_field_by_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_get_graph) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_init) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_get_scene_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_in_table_by_tag) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_new_subscene) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_set_scene_time_callback) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_set_node_callback) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_set_private) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_get_private) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_set_scene_size_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_use_pixel_metrics) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_get_scene_size_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_reset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_get_root_node) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_set_root_node) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_find_node) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_find_node_by_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_add_namespace) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_changed) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_clone) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_has_scripting) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_command_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_command_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_command_apply) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_command_apply_list) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_command_field_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_get_next_available_node_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_get_max_node_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_get_field_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_list_add_child) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_list_add_child_last) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_list_insert_child) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_list_del_child) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_list_find_child) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_list_get_child) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_list_get_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_list_del_child_idx) )

#pragma comment (linker, EXPORT_SYMBOL(gf_node_dump_attribute) )


#ifndef GPAC_DISABLE_SVG
#pragma comment (linker, EXPORT_SYMBOL(gf_node_dom_listener_add) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dom_event_type_by_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dom_event_fire) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dom_add_text_node) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dom_set_textContent) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dom_flatten_textContent) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_get_attribute_by_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dom_listener_build) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dom_listener_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_handle_dom_event) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_fire_dom_event) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_event_target_get) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_event_target_remove_by_node) )
#pragma comment (linker, EXPORT_SYMBOL(gf_event_target_get_node) )

#pragma comment (linker, EXPORT_SYMBOL(gf_svg_parse_attribute) )
#pragma comment (linker, EXPORT_SYMBOL(gf_svg_parse_style) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_get_attribute_by_tag) )
#pragma comment (linker, EXPORT_SYMBOL(gf_svg_create_attribute_value) )
#pragma comment (linker, EXPORT_SYMBOL(gf_svg_flatten_attributes) )
#pragma comment (linker, EXPORT_SYMBOL(gf_svg_apply_inheritance) )
#pragma comment (linker, EXPORT_SYMBOL(gf_svg_properties_init_pointers) )
#pragma comment (linker, EXPORT_SYMBOL(gf_svg_properties_reset_pointers) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_register_iri) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_unregister_iri) )
#pragma comment (linker, EXPORT_SYMBOL(gf_svg_parse_element_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_svg_is_animation_tag) )
#pragma comment (linker, EXPORT_SYMBOL(gf_xml_get_element_tag) )


#endif


#ifdef GPAC_HAS_SPIDERMONKEY
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_js_get_node) )
#pragma comment (linker, EXPORT_SYMBOL(gf_js_add_root) )
#pragma comment (linker, EXPORT_SYMBOL(gf_js_add_named_root) )
#pragma comment (linker, EXPORT_SYMBOL(gf_js_remove_root) )
#pragma comment (linker, EXPORT_SYMBOL(gf_js_vrml_flush_event_out) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_js_has_instance) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_lock_javascript) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_try_lock_javascript) )

#ifndef GPAC_DISABLE_SVG
#pragma comment (linker, EXPORT_SYMBOL(dom_js_pre_destroy) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_js_event_add_listener) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_js_event_remove_listener) )
#endif

#endif /*GPAC_HAS_SPIDERMONKEY*/

/* scenegraph_vrml.h exports*/
#pragma comment (linker, EXPORT_SYMBOL(gf_node_replace_child) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_sfrotation_interpolate) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_mfurl_del) )
#ifndef GPAC_DISABLE_VRML
#pragma comment (linker, EXPORT_SYMBOL(gf_node_get_num_fields_in_mode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_insert_child) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_remove_child) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_event_out) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_event_out_str) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_vrml_get_event_type_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_vrml_get_field_type_by_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_vrml_field_pointer_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_vrml_field_pointer_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_vrml_is_sf_field) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_vrml_get_sf_type) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_vrml_mf_insert) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_vrml_mf_append) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_vrml_mf_remove) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_vrml_mf_alloc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_vrml_mf_get_item) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_vrml_mf_reset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_vrml_field_copy) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_vrml_field_equal) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_route_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_route_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_route_del_by_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_route_find) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_route_find_by_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_route_set_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_route_get_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_route_set_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_route_get_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_activate_routes) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_set_in_graph) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_get_graph) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_set_private) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_get_private) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_get_extern_url) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_add_node_code) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_get_field_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_field_find_by_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_field_find) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_field_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_field_set_ised) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_field_set_private) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_field_get_private) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_field_get_field) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_create_instance) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_load_code) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_find_proto) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_delete_all_protos) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_get_proto) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_get_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_get_class_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_field_is_sftime_offset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_proto_instance_set_ised) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_script_field_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_script_field_get_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_script_load) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_script_event_in) )
#pragma comment (linker, EXPORT_SYMBOL(gf_node_mpeg4_type_by_class_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_get_next_available_route_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_set_max_defined_route_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_get_next_available_proto_id) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_set_proto_loader) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_sfcolor_to_rgba) )

#ifndef GPAC_DISABLE_X3D
#pragma comment (linker, EXPORT_SYMBOL(gf_node_x3d_type_by_class_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_x3d_get_node_type) )
#endif

#ifdef GPAC_HAS_SPIDERMONKEY
#ifndef GPAC_DISABLE_SVG
#pragma comment (linker, EXPORT_SYMBOL(gf_sg_handle_dom_event_for_vrml) )
#endif
#endif

#endif /*GPAC_DISABLE_VRML*/

#endif //!defined(GPAC_DISABLE_VRML) && !defined(GPAC_DISABLE_X3D) && !defined(GPAC_DISABLE_SVG)


#ifndef GPAC_DISABLE_PLAYER
/*terminal.h exports*/
#pragma comment (linker, EXPORT_SYMBOL(gf_term_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_connect) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_disconnect) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_navigate_to) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_play_from_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_set_option) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_option) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_framerate) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_time_in_ms) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_viewpoint) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_set_viewpoint) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_root_object) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_object_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_object) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_object_subscene_type) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_select_object) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_select_service) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_toggle_addons) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_object_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_download_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_channel_net_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_world_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_dump_scene) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_set_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_user_event) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_mouse_input) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_keyboard_input) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_string_input) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_connect_from_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_add_object) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_is_supported_url) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_attach_service) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_set_simulation_frame_rate) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_simulation_frame_rate) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_step_clocks) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_process_flush) )
#pragma comment (linker, EXPORT_SYMBOL(gf_service_get_interface) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_service_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_text_selection) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_paste_text) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_url) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_relocate_url) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_connect_with_path) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_register) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_unregister) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mo_get_scenegraph) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_send_event) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_lock_compositor) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_switch_quality) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_visual_output_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_scene_update) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_process_step) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_screen_buffer) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_release_screen_buffer) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_offscreen_buffer) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_process_shortcut) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_set_speed) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_relocate_url) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_add_event_filter) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_remove_event_filter) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_lock_media_queue) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_get_current_service_id) )

/*terminal_dev exports*/
#pragma comment (linker, EXPORT_SYMBOL(gf_scene_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_scene_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_scene_get_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_scene_attach_to_compositor) )
#pragma comment (linker, EXPORT_SYMBOL(gf_scene_find_odm) )
#pragma comment (linker, EXPORT_SYMBOL(gf_scene_set_duration) )
#pragma comment (linker, EXPORT_SYMBOL(gf_scene_setup_object) )
#pragma comment (linker, EXPORT_SYMBOL(gf_scene_register_extra_graph) )
#pragma comment (linker, EXPORT_SYMBOL(gf_scene_force_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_scene_process_anchor) )
#pragma comment (linker, EXPORT_SYMBOL(gf_scene_disconnect) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odm_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odm_setup_object) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odm_disconnect) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odm_setup_es) )
#pragma comment (linker, EXPORT_SYMBOL(gf_odm_remove_es) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_node_callback) )
#pragma comment (linker, EXPORT_SYMBOL(gf_term_message) )
#pragma comment (linker, EXPORT_SYMBOL(gf_clock_time) )
//for Ivica
#pragma comment (linker, EXPORT_SYMBOL(gf_scene_get_media_object_ex) )

#endif

#ifndef GPAC_DISABLE_PLAYER
/*compositor.h exports*/
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_set_fps) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_set_scene) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_draw_frame) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_on_node_init) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_invalidate) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_get_clock) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_lock) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_user_event) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_map_point) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_set_option) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_get_option) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_get_fps) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_get_screen_buffer) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_release_screen_buffer) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_simulation_tick) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_reset_graphics) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_pick_node) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_get_viewpoint) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_set_viewpoint) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_set_size) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_register_extra_graph) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_get_compositor) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_reload_audio_filters) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_add_video_listener) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_remove_video_listener) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_add_audio_listener) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_remove_audio_listener) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_focus_switch_ring) )

#ifndef GPAC_DISABLE_SVG
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_animation_get_scenegraph) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_svg_convert_length_to_display) )
#endif

/*compositor_dev.h exports*/
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_register_time_node) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_unregister_time_node) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_texture_setup) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_texture_destroy) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_texture_get_handler) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_texture_check_url_change) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_texture_play) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_texture_play_from_to) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_texture_stop) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_texture_restart) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_texture_update_frame) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_texture_release_stream) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_audio_register) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_audio_unregister) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_audio_setup) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_audio_open) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_audio_stop) )
#pragma comment (linker, EXPORT_SYMBOL(gf_sc_audio_restart) )

#pragma comment (linker, EXPORT_SYMBOL(gf_font_manager_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_font_manager_set_font) )
#pragma comment (linker, EXPORT_SYMBOL(gf_font_manager_create_span) )
#pragma comment (linker, EXPORT_SYMBOL(gf_font_manager_refresh_span_bounds) )

#endif

/*mpegts.h exports*/
#ifndef GPAC_DISABLE_MPEG2TS
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_get_esd) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_demux_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_demux_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_process_data) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_reset_parsers) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_es_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_set_pes_framing) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_get_stream_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_crc32_check) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_restamp) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_demux_file) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_pes_get_framing_mode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_get_sdt_info) )


/* carousel.h */
#ifdef GPAC_ENABLE_DSMCC
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_get_channel_application_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_process_dsmcc) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_init_dsmcc_overlord) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_get_dmscc_overlord) )
#endif
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_demux_dmscc_init) )


#ifndef GPAC_DISABLE_MPEG2TS_MUX
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_mux_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_mux_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_mux_set_pcr_max_interval) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_mux_program_add) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_program_stream_add) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_program_stream_update_ts_scale) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_mux_update_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_mux_process) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_get_sys_clock) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_get_ts_clock) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_mux_use_single_au_pes_mode) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_mux_set_initial_pcr) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_mux_program_set_name) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_mux_enable_sdt) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_mux_program_find) )

#endif /*GPAC_DISABLE_MPEG2TS_MUX*/
/* M3U8 & MPD related functions */
#pragma comment (linker, EXPORT_SYMBOL(gf_mpd_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mpd_init_from_dom) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mpd_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m3u8_to_mpd) )
#pragma comment (linker, EXPORT_SYMBOL(parse_root_playlist) )
#pragma comment (linker, EXPORT_SYMBOL(variant_playlist_del) )


#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_demuxer_setup))
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_demuxer_play) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_demuxer_close) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_get_socket) )

#endif /*GPAC_DISABLE_MPEG2TS*/

/*laser.h exports*/
#ifndef GPAC_DISABLE_LASER
#pragma comment (linker, EXPORT_SYMBOL(gf_laser_decoder_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_laser_decoder_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_laser_decoder_set_clock) )
#pragma comment (linker, EXPORT_SYMBOL(gf_laser_decoder_configure_stream) )
#pragma comment (linker, EXPORT_SYMBOL(gf_laser_decoder_remove_stream) )
#pragma comment (linker, EXPORT_SYMBOL(gf_laser_decode_au) )
#pragma comment (linker, EXPORT_SYMBOL(gf_laser_decode_command_list) )
#pragma comment (linker, EXPORT_SYMBOL(gf_laser_encoder_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_laser_encoder_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_laser_encoder_new_stream) )
#pragma comment (linker, EXPORT_SYMBOL(gf_laser_encode_au) )
#pragma comment (linker, EXPORT_SYMBOL(gf_laser_encoder_get_config) )
#pragma comment (linker, EXPORT_SYMBOL(gf_laser_encoder_get_rap) )
#endif /*GPAC_DISABLE_LASER*/

#ifndef GPAC_DISABLE_CORE_TOOLS
/*download.h exports*/
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_wget) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dm_wget_with_cache) )
#endif

#ifndef GPAC_DISABLE_ISOM_WRITE
/*to be removed once TS fragmenter is moved to libgpac */
#pragma comment (linker, EXPORT_SYMBOL(gf_media_mpd_format_segment_name) )

#pragma comment (linker, EXPORT_SYMBOL(gf_media_get_rfc_6381_codec_name) )
#ifndef GPAC_DISABLE_ISOM_FRAGMENTS
#pragma comment (linker, EXPORT_SYMBOL(gf_media_fragment_file) )
#endif
#endif

#ifndef GPAC_DISABLE_ISOM_WRITE
#pragma comment (linker, EXPORT_SYMBOL(gf_dasher_segment_files) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dasher_next_update_time) )
#endif

/* dvb_mpe.h */
#ifdef GPAC_ENST_PRIVATE
#pragma comment (linker, EXPORT_SYMBOL(gf_dvb_mpe_section_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dvb_mpe_init) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dvb_mpe_section_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dvb_mpe_shutdown) )
#pragma comment (linker, EXPORT_SYMBOL(gf_m2ts_print_mpe_info) )
#endif

#ifndef GPAC_DISABLE_DASH_CLIENT
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_new) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_open) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_close) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_get_url) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_get_group_count) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_get_group_udta) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_set_group_udta) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_is_group_selected) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_is_group_selectable) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_debug_group) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_get_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_switch_quality) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_get_duration) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_check_mpd_root_type) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_group_get_segment_mime) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_group_get_segment_init_url) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_group_select) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_groups_set_language) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_in_last_period) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_get_period_switch_status) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_request_period_switch) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_is_running) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_group_get_num_segments_ready) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_group_discard_segment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_group_get_next_segment_location) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_group_probe_current_download_segment_location) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_group_get_max_segments_in_cache) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_set_group_done) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_in_period_setup) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_seek) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_get_playback_start_range) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_group_get_start_range) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_group_segment_switch_forced) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_group_current_segment_start_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_group_get_presentation_time_offset) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_group_get_video_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_group_get_representation_info) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_get_buffer_info_buffering) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_group_check_bandwidth) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_resync_to_segment) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_group_loop_detected) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_is_dynamic_mpd) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_get_min_buffer_time) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_set_idle_interval) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_set_utc_shift) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_enable_utc_drift_compensation) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_set_max_resolution) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_set_min_timeout_between_404) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_set_segment_expiration_threshold) )
#pragma comment (linker, EXPORT_SYMBOL(gf_dash_set_user_buffer) )
#endif

#ifndef GPAC_DISABLE_ISOM_WRITE
#pragma comment (linker, EXPORT_SYMBOL(gf_webvtt_js_addCue) )
#pragma comment (linker, EXPORT_SYMBOL(gf_webvtt_js_removeCues) )
#pragma comment (linker, EXPORT_SYMBOL(gf_webvtt_parse_cues_from_data) )
#pragma comment (linker, EXPORT_SYMBOL(gf_webvtt_parse_iso_cues) )
#pragma comment (linker, EXPORT_SYMBOL(gf_webvtt_cue_del) )
#endif

#ifndef GPAC_DISABLE_MSE
#pragma comment (linker, EXPORT_SYMBOL(gf_mse_track_buffer_get_next_packet) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mse_track_buffer_release_packet) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mse_mediasource_del) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mse_mediasource_open) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mse_mediasource_close) )
#pragma comment (linker, EXPORT_SYMBOL(gf_mse_mediasource_end) )
#endif

#pragma comment (linker, EXPORT_SYMBOL(utf8_to_ucs4) )




















