/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.l2fprod.gui.nativeskin.NativeSkin;
import com.l2fprod.gui.region.ImageRegion;
import com.l2fprod.gui.region.Region;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Clock
extends Component
implements Runnable {
    Image backgroundImage;
    Thread timer;
    int lastxs;
    int lastys;
    int lastxm;
    int lastym;
    int lastxh;
    int lastyh;
    Date currentDate;
    Color handColor;
    Color numberColor;

    public Clock(Image back) throws Exception {
        this.backgroundImage = back;
        this.lastyh = 0;
        this.lastxh = 0;
        this.lastym = 0;
        this.lastxm = 0;
        this.lastys = 0;
        this.lastxs = 0;
        this.currentDate = new Date();
        this.handColor = Color.blue;
        this.numberColor = Color.darkGray;
        this.setSize(this.backgroundImage.getWidth(this), this.backgroundImage.getHeight(this));
    }

    public void paint(Graphics g) {
        g.drawImage(this.backgroundImage, 0, 0, this);
        int width = this.getWidth();
        int height = this.getHeight();
        int s = 0;
        int m = 10;
        int h = 10;
        this.currentDate = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("s", Locale.getDefault());
        try {
            s = Integer.parseInt(formatter.format(this.currentDate));
        }
        catch (NumberFormatException n) {
            s = 0;
        }
        formatter.applyPattern("m");
        try {
            m = Integer.parseInt(formatter.format(this.currentDate));
        }
        catch (NumberFormatException n) {
            m = 10;
        }
        formatter.applyPattern("h");
        try {
            h = Integer.parseInt(formatter.format(this.currentDate));
        }
        catch (NumberFormatException n) {
            h = 10;
        }
        formatter.applyPattern("EEE MMM dd HH:mm:ss yyyy");
        int xcenter = width / 2;
        int ycenter = height / 2;
        int xs = (int)(Math.cos((float)s * 3.14f / 30.0f - 1.57f) * 45.0 + (double)xcenter);
        int ys = (int)(Math.sin((float)s * 3.14f / 30.0f - 1.57f) * 45.0 + (double)ycenter);
        int xm = (int)(Math.cos((float)m * 3.14f / 30.0f - 1.57f) * 40.0 + (double)xcenter);
        int ym = (int)(Math.sin((float)m * 3.14f / 30.0f - 1.57f) * 40.0 + (double)ycenter);
        int xh = (int)(Math.cos((float)(h * 30 + m / 2) * 3.14f / 180.0f - 1.57f) * 30.0 + (double)xcenter);
        int yh = (int)(Math.sin((float)(h * 30 + m / 2) * 3.14f / 180.0f - 1.57f) * 30.0 + (double)ycenter);
        g.setColor(this.getBackground());
        if (xs != this.lastxs || ys != this.lastys) {
            g.drawLine(xcenter, ycenter, this.lastxs, this.lastys);
        }
        if (xm != this.lastxm || ym != this.lastym) {
            g.drawLine(xcenter, ycenter - 1, this.lastxm, this.lastym);
            g.drawLine(xcenter - 1, ycenter, this.lastxm, this.lastym);
        }
        if (xh != this.lastxh || yh != this.lastyh) {
            g.drawLine(xcenter, ycenter - 1, this.lastxh, this.lastyh);
            g.drawLine(xcenter - 1, ycenter, this.lastxh, this.lastyh);
        }
        g.setColor(this.handColor);
        g.drawLine(xcenter, ycenter, xs, ys);
        g.drawLine(xcenter, ycenter - 1, xm, ym);
        g.drawLine(xcenter - 1, ycenter, xm, ym);
        g.drawLine(xcenter, ycenter - 1, xh, yh);
        g.drawLine(xcenter - 1, ycenter, xh, yh);
        this.lastxs = xs;
        this.lastys = ys;
        this.lastxm = xm;
        this.lastym = ym;
        this.lastxh = xh;
        this.lastyh = yh;
        this.currentDate = null;
    }

    public void start() {
        this.timer = new Thread(this);
        this.timer.start();
    }

    public void stop() {
        this.timer = null;
    }

    public void run() {
        Thread me = Thread.currentThread();
        while (this.timer == me) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.repaint();
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public static void main(String[] args) throws Exception {
        final Window window = new Window(new Frame()){

            public void setVisible(boolean b) {
                System.out.println(b);
                super.setVisible(b);
            }

            public void pack() {
            }
        };
        window.setLayout(new BorderLayout());
        Image back = args[0].startsWith("http://") ? Toolkit.getDefaultToolkit().getImage(new URL(args[0])) : Toolkit.getDefaultToolkit().getImage(args[0]);
        try {
            MediaTracker tracker = new MediaTracker(window);
            tracker.addImage(back, 0);
            tracker.waitForAll();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        final Clock clock = new Clock(back);
        clock.start();
        window.add("Center", clock);
        window.setSize(clock.getSize());
        ImageRegion region = new ImageRegion(back);
        NativeSkin.getInstance().setWindowRegion(window, (Region)region, true);
        NativeSkin.getInstance().setAlwaysOnTop(window, true);
        NativeSkin.getInstance().setWindowTransparency(window, 127);
        final PopupMenu popup = new PopupMenu();
        for (int i = 0; i < 100; i += 10) {
            final int t = i;
            MenuItem item = new MenuItem(i + "%");
            popup.add(item);
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    int transparency = (int)(255.0 * ((double)(100 - t) / 100.0));
                    NativeSkin.getInstance().setWindowTransparency(window, transparency);
                    NativeSkin.getInstance().setAlwaysOnTop(window, true);
                }
            };
            item.addActionListener(listener);
        }
        popup.addSeparator();
        popup.add(new MenuItem("Exit")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        clock.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    popup.show(clock, event.getX(), event.getY());
                }
            }
        });
        clock.add(popup);
        WindowMover mover = new WindowMover(window);
        clock.addMouseListener(mover);
        clock.addMouseMotionListener(mover);
        window.show();
    }

    static class WindowMover
    extends MouseAdapter
    implements MouseMotionListener {
        int clickX;
        int clickY;
        Window window;

        public WindowMover(Window w) {
            this.window = w;
        }

        public void mousePressed(MouseEvent event) {
            this.clickX = event.getX();
            this.clickY = event.getY();
        }

        public void mouseDragged(MouseEvent event) {
            int dX = event.getX() - this.clickX;
            int dY = event.getY() - this.clickY;
            this.window.setLocation(this.window.getX() + dX, this.window.getY() + dY);
        }

        public void mouseMoved(MouseEvent event) {
        }
    }
}

