#ifndef __MINIOS_PUBLIC_PRIVCMD_H__
#define __MINIOS_PUBLIC_PRIVCMD_H__

/*
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this source file (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy, modify,
 * merge, publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <sys/types.h>
#include <errno.h>

typedef struct privcmd_hypercall
{
	uint64_t op;
	uint64_t arg[5];
} privcmd_hypercall_t;

typedef struct privcmd_mmap_entry {
	uint64_t mfn;
} privcmd_mmap_entry_t; 

#define ARCH_IOCTL(d, r, a) (errno=EINVAL, -1)

#endif /* __MINIOS_PUBLIC_PRIVCMD_H__ */
