#include <stdio.h>
#include <errno.h>

void clearerr(FILE *stream) {
    errno = 0;
}

void rewind(FILE *stream) {
    (void)fseek(stream, 0L, SEEK_SET);
    clearerr(stream);
}

int feof(FILE *stream) {
    return (errno == EOF);
}

int ferror(FILE *stream) {
    return (errno != 0 && errno != EOF);
}

int fflush(FILE *stream) {
    return 0;
}

int ungetc(int c, FILE *stream) {
    if (fseek(stream, -1, SEEK_CUR) < 0)
	return EOF;
    else
	return c;
}
