﻿// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System.Collections.Generic;
using System.ComponentModel.Composition;
using EnvDTE;
using Microsoft.VisualStudio.Shell;
using Microsoft.VisualStudio.Threading;

namespace NuGet.PackageManagement.VisualStudio
{
    [Export(typeof(Configuration.IMachineWideSettings))]
    public class VsMachineWideSettings : Configuration.IMachineWideSettings
    {
        private readonly AsyncLazy<IEnumerable<Configuration.Settings>> _settings;

        [ImportingConstructor]
        public VsMachineWideSettings()
            : this(ServiceLocator.GetInstance<DTE>())
        {
        }

        internal VsMachineWideSettings(DTE dte)
        {
            var baseDirectory = Common.NuGetEnvironment.GetFolderPath(Common.NuGetFolderPath.MachineWideConfigDirectory);
            _settings = new AsyncLazy<IEnumerable<Configuration.Settings>>(async () =>
                {
                    await ThreadHelper.JoinableTaskFactory.SwitchToMainThreadAsync();
                    return Configuration.Settings.LoadMachineWideSettings(
                        baseDirectory,
                        "VisualStudio",
                        dte.Version,
                        VSVersionHelper.GetSKU());
                }, ThreadHelper.JoinableTaskFactory);
        }

        public IEnumerable<Configuration.Settings> Settings => ThreadHelper.JoinableTaskFactory.Run(_settings.GetValueAsync);
    }
}
