/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtCore/QByteArray>
#include <qglobal.h>

namespace QtTapioca {

class AvatarPrivate;

class Q_DECL_EXPORT Avatar: public QObject {
    Q_OBJECT
    Q_DECLARE_PRIVATE(Avatar)

public:
    Avatar(const QString &path, QObject *parent = 0);
    Avatar(const QByteArray &data, QObject *parent = 0);
    Avatar(const QByteArray &data, const QString &mimeType, const QString &token, QObject *parent = 0);
    ~Avatar();

    QByteArray data() const;
    QString mimeType() const;
    QString token() const;

private:
    friend class UserContact;
    friend class ContactBase;

    void setData(const QByteArray &_data);
    void setMimeType(const QString &mime);
    void setToken(const QString &_token);
    AvatarPrivate *d;
};

} // namespace
