%%
%% This is file `uestcthesis.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% uestcthesis.dtx  (with options: `class')
%% 
%% This is a generated file.
%% 
%%  Copyright 2012-2013 Shi Fujun <shifujun@foxmail.com>
%% 
%%  This work may be distributed and/or modified under the
%%  conditions of the LaTeX Project Public License, either version 1.3
%%  of this license or (at your option) any later version.
%%  The latest version of this license is in
%%    http://www.latex-project.org/lppl.txt
%%  and version 1.3 or later is part of all distributions of LaTeX
%%  version 2005/12/01 or later.
%% 
%%  This work has the LPPL maintenance status `maintained'.
%% 
%%  The Current Maintainer of this work is Shi Fujun <shifujun@foxmail.com>.
%% 
%%  This work consists of the files uestcthesis.dtx, uestcthesis.ins
%%  and the derived file uestcthesis.cls, uestcthesis.bst and beamerthemeuestcthesis.sty.
%%  Other files in this work's package are belongs to the respective owners.
%% 

\NeedsTeXFormat{LaTeX2e}[2011/06/27]
\ProvidesClass{uestcthesis}
    [2013/06/07 v0.4.8 UESTC thesis class]
\LoadClass[cs4size,UTF8,fancyhdr,hyperref,fntef,openany]{ctexbook}[2011/03/11]
\RequirePackage{etoolbox}[2011/01/03]
\RequirePackage{ifthen}
\newcommand{\bachelor@uestcthesis}{
\newcommand{\degree@uestcthesis}{bachelor}
\newcommand{\bachelortitlepage@uestcthesis}{}%先声明宏，稍后定义。
\newcommand{\titlepage@degree}{\bachelortitlepage@uestcthesis}

\newcommand{\multibibflag@uestcthesis}{}

\newcommand{\thesisname@degree}{电子科技大学学士学位论文}

\newcommand{\chapternumberformat@uestcthesis}{\arabic{chapter}}
}
\newcommand{\master@uestcthesis}{
\newcommand{\degree@uestcthesis}{master}
\newcommand{\mastertitlepage@uestcthesis}{}%先声明宏，稍后定义。
\newcommand{\titlepage@degree}{\mastertitlepage@uestcthesis}

\newcommand{\multibibflag@uestcthesis}{TRUE}

\newcommand{\thesisname@degree}{电子科技大学硕士学位论文}

\newcommand{\publicationsname@degree}{攻硕期间取得的研究成果}

\newcommand{\@degree}{硕士}

\newcommand{\publicationsname@english}{Research Results Obtained During the Study for Master Degree}
\newcommand{\thesisname@english}{Master Thesis of University of Electronic Science and Technology of China}

\newcommand{\chapternumberformat@uestcthesis}{\chinese{chapter}}
}
\newcommand{\doctor@uestcthesis}{
\newcommand{\degree@uestcthesis}{doctor}
\newcommand{\doctortitlepage@uestcthesis}{}%先声明宏，稍后定义。
\newcommand{\titlepage@degree}{\doctortitlepage@uestcthesis}

\newcommand{\multibibflag@uestcthesis}{TRUE}

\newcommand{\thesisname@degree}{电子科技大学博士学位论文}

\newcommand{\publicationsname@degree}{攻博期间取得的研究成果}

\newcommand{\@degree}{博士}

\newcommand{\publicationsname@english}{Research Results Obtained During the Study for Doctor Degree}
\newcommand{\thesisname@english}{Doctor Thesis of University of Electronic Science and Technology of China}

\newcommand{\chapternumberformat@uestcthesis}{\chinese{chapter}}
}
\newcommand{\tocname@uestcthesis}{\zihao{5}目\enspace 录}
\newcommand{\chaptername@uestcthesis}{
\CTEXsetup[ name={第,章},
            number={\chapternumberformat@uestcthesis}
            ]{chapter}
            }
\newcommand{\chaptermarkfix@uestcthesis}{
\renewcommand{\chaptermark}[1]{\markboth{第\chapternumberformat@uestcthesis章~##1 }{}}
}
\newcommand{\acknowledgementsname@uestcthesis}{致\enspace 谢}
\newcommand{\glossaryname@uestcthesis}{主要符号表}
\newcommand{\entryname@uestcthesis}{符号或术语}
\newcommand{\descriptionname@uestcthesis}{说明}
\newcommand{\glspageheader@uestcthesis}{页码}
\newcommand{\english@uestcthesis}{
\renewcommand{\tocname@uestcthesis}{\zihao{5}Contents}
\renewcommand{\chaptername@uestcthesis}{
\CTEXsetup[ name={Chapter\space,},
            number={\arabic{chapter}}
            ]{chapter}
            }
\renewcommand{\chaptermarkfix@uestcthesis}{}
\renewcommand{\chaptermark}[1]{\markboth{Chapter\space\arabic{chapter}~##1 }{}}

\renewcommand{\acknowledgementsname@uestcthesis}{Acknowledgements}
\renewcommand{\CTEX@bibname}{References}
\renewcommand{\publicationsname@degree}{\publicationsname@english}
\renewcommand{\thesisname@degree}{\thesisname@english}
\renewcommand{\CTEX@figurename}{Figure}
\renewcommand{\CTEX@tablename}{Table}
\renewcommand{\glossaryname@uestcthesis}{Glossary}
\renewcommand{\entryname@uestcthesis}{Notation}
\renewcommand{\descriptionname@uestcthesis}{Description}
\renewcommand{\glspageheader@uestcthesis}{Page}
\renewcommand{\CTEX@appendixname}{Appendix~}
}
\DeclareOption{bachelor}{\bachelor@uestcthesis}
\DeclareOption{master}{\master@uestcthesis}
\DeclareOption{doctor}{\doctor@uestcthesis}
\DeclareOption{english}{\english@uestcthesis}
\ProcessOptions\relax
\RequirePackage[a4paper,headheight=12.65pt,headsep=4mm,includeheadfoot,centering,
                top=2.75cm,left=3cm]{geometry}
\linespread{1.391}
\parskip=0bp plus 10bp minus 1bp
\raggedbottom
\RequirePackage{graphicx,calc,float,texnames}
\RequirePackage[format=hang,labelsep=space]{caption}
\intextsep=6bp
\captionsetup[figure]{aboveskip=0bp,belowskip=-7mm+6bp}
\captionsetup[table]{aboveskip=0bp,belowskip=0bp}
\RequirePackage{booktabs,tabularx,threeparttable,longtable}
\DeclareCaptionFont{capfont}{\zihao{5}}
\captionsetup{font=capfont}
\renewcommand{\thefigure}{\arabic{chapter}\textendash\arabic{figure}}
\renewcommand{\thetable}{\arabic{chapter}\textendash\arabic{table}}
\graphicspath{{pics/}}
\RequirePackage[below]{placeins}
\RequirePackage{flafter}
\newcommand{\newcmds@uestcthesis}{
\newcommand{\pic}[4][htbp]{
\begin{figure}[##1]
\centering
  \includegraphics[##3]{##4}
  \caption{##2}
  \label{##4}
\end{figure}
}
\newcommand{\subpiclabel}{}%定义一个空的多图环境整体的标签变量
\newcommand{\subpiccaption}{}%定义一个空的多图环境整体的标题变量
\newenvironment{pics}[3][htbp]{%定义多图环境
\renewcommand{\subpiclabel}{##3}%设置多图环境整体的标签
\renewcommand{\subpiccaption}{##2}%设置多图环境整体的标题。这里先定义两个空变量，又设置值，是因为在定义一个环境时，环境结尾中不能调用##2，##3等传入的值。所以要在环境结尾中插入标题和标签就只能这么做了。
\begin{figure}[##1]
\centering}
{\caption{\subpiccaption}
\label{\subpiclabel}
\end{figure}
}
\newcommand{\addsubpic}[3]{
 \subfigure[##1]{\label{##3}\includegraphics[##2]{##3}}
}
\newcommand{\threelinetable}[8][htbp]{
\begin{table}[##1]
\zihao{5}%管理规范中要求表格中文字为五号字。
\centering
\begin{threeparttable}
\caption{##5}
\label{##2}
\begin{tabularx}{##3}{##4}
\toprule[0.1em]
##6
\midrule[0.05em]
##7
\bottomrule[0.1em]
\end{tabularx}
\ifblank{##8}{}{
\begin{tablenotes}
##8
\end{tablenotes}
}
\end{threeparttable}
\end{table}
}
\newcommand{\longthreelinetable}[6]{
{
\zihao{5}%管理规范中要求表格中文字为五号字。
\centering
\begin{longtable}{##4}
\caption{##2}\label{##1}\\
\toprule[0.1em]
##5
\midrule[0.05em]
\endfirsthead
\multicolumn{##3}{r}{\footnotesize 接上页}\\
\toprule[0.1em]
##5
\midrule[0.05em]
\endhead
\bottomrule[0.1em]
\multicolumn{##3}{r}{\footnotesize 接下页}\\
\endfoot
\bottomrule[0.1em]
\endlastfoot
##6
\end{longtable}
}
}
\newcommand{\pictable}[4][htbp]{
\begin{table}[##1]
\centering
\caption{##2}
\label{##4}
\includegraphics[##3]{##4}
\end{table}
}
}%\newcmds@uestcthesis定义完毕
\newcommand{\mainmatterfancy}{
\fancyhf{}
\fancyhead[OC]{\zihao{5}\leftmark}%奇数页居中打印章标题
\fancyhead[EC]{\zihao{5}\thesisname@degree}%偶数页居中打印论文全名
\fancyfoot[C]{\zihao{-5}\thepage}%页码位于页面底端，居中打印。
}
\newcommand{\Cabstractfancy}{%
\fancyhf{}%
\fancyhead[C]{\zihao{5}摘要}%页眉居中打印“摘要”
\fancyfoot[C]{\zihao{-5}\thepage}%页码位于页面底端，居中打印。
}
\newcommand{\Eabstractfancy}{
\fancyhf{}%
\fancyhead[C]{\zihao{5}ABSTRACT}%页眉居中打印“ABSTRACT”
\fancyfoot[C]{\zihao{-5}\thepage}%页码位于页面底端，居中打印。
}
\newcommand{\tocmatterfancy}{
\fancyhf{}
\fancyhead[C]{\tocname@uestcthesis}%页眉居中打印“目　录”
\fancyfoot[C]{\zihao{-5}\thepage}%页码位于页面底端，居中打印。
}
\newcommand{\glossarymatterfancy}{%定义主要符号表版式设置
\fancypagestyle{plain}{
\fancyhf{}
\fancyhead[C]{\zihao{5}\glossaryname@uestcthesis}%
\fancyfoot[C]{\zihao{-5}\thepage}%
}
\renewcommand{\glossarypreamble}{%
\fancyhead[C]{\zihao{5}\glossaryname@uestcthesis}%页眉居中打印“主要符号表”
}
}
\newcommand{\Cabstractmatter}{
\setcounter{page}{1}%页码重置为1
\pagenumbering{Roman}%页码使用大写罗马数字
\pagestyle{fancy}
\Cabstractfancy
\fancypagestyle{plain}{\Cabstractfancy}
}
\newcommand{\Eabstractmatter}{
\pagestyle{fancy}
\Eabstractfancy
\fancypagestyle{plain}{\Eabstractfancy}
}
\newcommand{\tocmatter}{
\pagestyle{fancy}
\tocmatterfancy
\fancypagestyle{plain}{\tocmatterfancy}
}
\renewcommand{\mainmatter}{
\newpage
\setcounter{page}{1}
\pagenumbering{arabic}
\pagestyle{fancy}
\chaptermarkfix@uestcthesis %修正页眉章号显示不正确
\mainmatterfancy%设置正文的版式
\fancypagestyle{plain}{\mainmatterfancy}
}
\newcommand{\stuid}[1]{
\newcommand{\@stuid}{#1}
}
\newcommand{\major}[1]{
\newcommand{\@major}{#1}
}
\newcommand{\school}[1]{
\newcommand{\@school}{#1}
}
\newcommand{\adviser}[3]{
\newcommand{\@advisername}{#1}%姓名
\newcommand{\@advisertitle}{#2}%职称
\newcommand{\@adviserinstitution}{#3}%工作单位
}
\newcommand{\adviserB}[3]{
\newcommand{\@adviserBname}{#1}%姓名
\newcommand{\@adviserBtitle}{#2}%职称
\newcommand{\@adviserBinstitution}{#3}%工作单位
}
\newcommand{\adviserC}[3]{
\newcommand{\@adviserCname}{#1}%姓名
\newcommand{\@adviserCtitle}{#2}%职称
\newcommand{\@adviserCinstitution}{#3}%工作单位
}
\newcommand{\adviserD}[3]{
\newcommand{\@adviserDname}{#1}%姓名
\newcommand{\@adviserDtitle}{#2}%职称
\newcommand{\@adviserDinstitution}{#3}%工作单位
}
\newcommand{\university}[1]{
\newcommand{\@university}{#1}
}
\renewcommand{\date}[3]{
\renewcommand{\@date}{#1年#2月#3日}
\newcommand{\@year}{#1}%用于pdf元信息
}
\newcommand{\oraldefensedate}[3]{
\newcommand{\@oraldefensedate}{#1年#2月#3日}
}
\newcommand{\awarddate}[3]{
\newcommand{\@awarddate}{#1年#2月#3日}
}
\newcommand{\classnumber}[1]{
\newcommand{\@classnumber}{#1}
}
\newcommand{\securityclassification}[1]{
\newcommand{\@securityclassification}{#1}
}
\newcommand{\UDC}[1]{
\newcommand{\@UDC}{#1}
}
\newcommand{\chairman}[1]{
\newcommand{\@chairman}{#1}
}
\newcommand{\appraiser}[1]{
\newcommand{\@appraiser}{#1}
}
\newcommand{\englishtitle}[1]{
\newcommand{\@englishtitle}{#1}
}
\newcommand{\englishmajor}[1]{
\newcommand{\@englishmajor}{#1}
}
\newcommand{\englishauthor}[1]{
\newcommand{\@englishauthor}{#1}
}
\newcommand{\englishadvisor}[1]{
\newcommand{\@englishadvisor}{#1}
}
\newcommand{\englishshcool}[1]{
\newcommand{\@englishshcool}{#1}
}
\begin{filecontents*}{logo.tex}
\documentclass[pstricks=true]{standalone}
\usepackage{pstricks}

\begin{document}
%%Creator: 0.48.3.1
%%Please note this file requires PSTricks extensions
\psset{xunit=.5pt,yunit=.5pt,runit=.5pt}
\begin{pspicture}(11072.75488281,3090.08740234)
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(3768.03733251,2453.82478578)
\curveto(3767.42483254,2452.89978582)(3766.79983256,2451.97478586)(3766.18733259,2451.0497859)
\curveto(3769.24983246,2438.56228645)(3777.54983209,2429.44978686)(3782.87483185,2419.5122873)
\curveto(3793.36233138,2399.94978817)(3797.04983122,2363.76228978)(3798.64983115,2340.66229081)
\curveto(3802.049831,2291.412293)(3766.1123326,2226.23729589)(3748.56233338,2192.2622974)
\curveto(3706.07483526,2110.01230106)(3650.26233774,2045.67480392)(3616.84983923,1953.874808)
\curveto(3616.53733924,1945.83730836)(3616.22483926,1937.79980871)(3615.92483927,1929.76230907)
\curveto(3613.37483938,1887.14981097)(3638.78733825,1896.91231053)(3651.1623377,1874.11231154)
\curveto(3675.24983663,1829.76231352)(3675.56233662,1777.94981582)(3647.46233787,1735.89981769)
\curveto(3641.04983815,1726.33731811)(3635.21233841,1713.61231868)(3626.12483882,1707.14981897)
\curveto(3606.82483968,1693.42481958)(3585.42484063,1706.12481901)(3573.24984117,1721.06231835)
\curveto(3562.48734165,1734.27481776)(3547.7623423,1748.92481711)(3540.78734261,1765.58731637)
\curveto(3529.46234311,1792.62481517)(3523.37484338,1819.51231397)(3509.24984401,1842.57481295)
\lineto(3506.47484414,1842.57481295)
\curveto(3506.16234415,1842.26231296)(3505.84984416,1841.94981297)(3505.53734418,1841.64981299)
\curveto(3505.59984417,1820.54981393)(3503.79984425,1803.93731466)(3500.89984438,1785.98731546)
\curveto(3497.42484454,1764.41231642)(3503.26234428,1748.78731712)(3500.89984438,1728.48731802)
\curveto(3497.49984454,1699.16231932)(3498.87484447,1672.26232052)(3499.04984447,1645.01232173)
\curveto(3499.18734446,1623.61232268)(3496.44984458,1591.48732411)(3502.7623443,1570.79982503)
\curveto(3517.56234364,1522.28732718)(3623.91233892,1525.87482702)(3664.14983713,1498.44982824)
\curveto(3693.47483582,1478.47482913)(3692.62483586,1431.52483122)(3704.03733535,1395.49983282)
\curveto(3711.09983504,1373.17483381)(3726.61233435,1329.89983574)(3740.21233375,1312.94983649)
\curveto(3753.58733315,1296.26233723)(3770.68733239,1267.6748385)(3791.22483148,1259.14983888)
\curveto(3821.74983012,1246.48733944)(3858.62482848,1247.5373394)(3900.67482661,1248.01233938)
\curveto(3942.09982477,1247.08733942)(3983.53732293,1246.16233946)(4024.96232109,1245.2373395)
\curveto(4039.83732043,1247.4373394)(4056.01231971,1257.44983896)(4068.56231915,1262.86233871)
\curveto(4090.49981818,1272.31233829)(4141.97481589,1280.67483792)(4152.9748154,1298.09983715)
\curveto(4172.46231453,1328.98733578)(4198.39981338,1380.1623335)(4148.33731561,1400.13733261)
\curveto(4141.7373159,1402.7623325)(4130.27481641,1408.72483223)(4121.4373168,1407.54983228)
\curveto(4089.11231824,1403.28733247)(4041.34982036,1391.54983299)(4006.41232191,1384.36233331)
\curveto(3964.0873238,1375.6623337)(3921.3123257,1373.4998338)(3884.91232731,1368.59983401)
\curveto(3848.49982893,1363.68733423)(3819.24983023,1379.28733354)(3811.63733057,1405.69983237)
\curveto(3798.49983116,1451.19983034)(3863.78732825,1489.19982865)(3899.74982665,1504.94982795)
\curveto(3929.13732535,1517.82482738)(3959.32482401,1518.12482737)(3978.58732315,1540.18732639)
\curveto(4014.68732155,1581.53732455)(3977.5498232,1638.39982202)(3995.28732241,1698.79981934)
\curveto(4010.86232172,1751.87481698)(4029.71232088,1804.27481465)(4059.28731956,1845.36231282)
\curveto(4065.56231928,1854.07481244)(4075.29981885,1858.62481223)(4084.32481845,1864.83731196)
\curveto(4105.14981752,1879.13731132)(4141.03731593,1921.34980944)(4147.39981565,1950.17480816)
\curveto(4155.1623153,1985.2873066)(4091.94981811,2026.08730479)(4073.19981894,2043.849804)
\curveto(4041.69982035,2073.71230267)(4008.74982181,2103.68730134)(3974.87482332,2131.03730012)
\curveto(3958.42482405,2144.33729953)(3931.98732522,2158.43729891)(3922.01232567,2177.41229806)
\curveto(3912.06232611,2196.33729722)(3920.74982572,2230.36229571)(3918.29982583,2250.69979481)
\curveto(3908.81232625,2329.34979131)(3909.62482622,2440.69978636)(3768.03733251,2453.82478578)
\closepath
\moveto(6602.62470651,2471.54978499)
\curveto(6601.69970655,2470.31228504)(6600.76220659,2469.0747851)(6599.83720664,2467.83728515)
\curveto(6597.98720672,2444.3372862)(6596.1247068,2420.83728724)(6594.27470688,2397.33728829)
\curveto(6592.31220697,2382.06228897)(6595.68720682,2364.03728977)(6593.34970692,2352.81229027)
\curveto(6585.62470727,2315.84979191)(6614.84970597,2232.7747956)(6567.37470808,2208.1247967)
\curveto(6527.73720984,2187.53729761)(6463.26221271,2192.2747974)(6421.74971455,2181.22479789)
\curveto(6409.57471509,2177.97479804)(6390.71221593,2174.99979817)(6385.57471616,2164.52479864)
\curveto(6378.27471648,2141.57479966)(6392.31221586,2117.68730072)(6385.57471616,2093.09980181)
\curveto(6375.29971662,2055.59980348)(6342.77471806,1995.14980616)(6361.46221723,1956.74980787)
\curveto(6370.89971681,1937.37480873)(6394.57471576,1934.09980888)(6408.76221513,1919.64980952)
\curveto(6409.21221511,1882.02481119)(6368.57471691,1823.87481378)(6348.47471781,1799.99981484)
\curveto(6330.5997186,1778.77481578)(6302.41221986,1758.1373167)(6314.14971933,1715.58731859)
\curveto(6324.41221888,1678.39982024)(6349.47471776,1665.8873208)(6390.21221595,1659.01232111)
\lineto(6429.17471422,1659.01232111)
\curveto(6464.81221264,1654.6373213)(6504.52471087,1679.4873202)(6522.84971006,1650.66232148)
\curveto(6550.13720884,1607.77482338)(6536.84970943,1547.62482606)(6550.67470882,1485.56232882)
\curveto(6552.33720875,1478.09982915)(6550.23720884,1458.08733004)(6552.53720874,1448.46233046)
\curveto(6569.24970799,1378.47483358)(6565.59970816,1303.09983693)(6593.34970692,1238.83733978)
\curveto(6604.38720643,1213.24984092)(6603.16220649,1181.76234232)(6618.38720581,1160.92484325)
\lineto(6622.09970565,1160.92484325)
\curveto(6636.82470499,1179.26234243)(6632.27470519,1206.9373412)(6636.93720499,1235.12483995)
\curveto(6644.63720464,1281.53733788)(6642.49970474,1323.81233601)(6652.71220428,1370.54983393)
\curveto(6662.93720383,1417.34983185)(6671.42470345,1466.34982967)(6689.81220264,1505.96232791)
\curveto(6699.89970219,1527.69982694)(6720.07470129,1544.73732619)(6726.91220099,1569.96232506)
\curveto(6730.14970084,1581.91232453)(6726.31220101,1592.51232406)(6727.83720095,1602.43732362)
\curveto(6730.11220084,1617.16232297)(6728.11220093,1639.69982196)(6725.98720103,1652.52482139)
\curveto(6719.51220132,1691.48731966)(6721.26220124,1725.22481816)(6729.69970086,1758.26231669)
\curveto(6736.17470057,1783.64981557)(6750.96219992,1813.13731426)(6764.9371993,1833.38731335)
\curveto(6787.09969831,1865.48731193)(6826.72469655,1894.03731066)(6815.96219703,1953.04980804)
\curveto(6805.06219751,2012.73730538)(6772.02469898,2049.86230373)(6751.02469991,2096.81230165)
\curveto(6736.97470054,2128.22480025)(6731.29970079,2160.94979879)(6718.56220136,2194.21229732)
\curveto(6703.81220201,2232.7122956)(6700.44970216,2360.49978992)(6700.01220218,2406.61228787)
\curveto(6696.61220233,2414.16228754)(6613.32470604,2469.91228506)(6602.62470651,2471.54978499)
\closepath
\moveto(6180.58722527,2466.8997852)
\curveto(6120.02472796,2433.36228669)(6050.63723105,2311.5372921)(6033.11223183,2233.16229558)
\curveto(6032.79973184,2223.27479602)(6032.48723185,2213.37479646)(6032.17473187,2203.4872969)
\curveto(6019.33723244,2145.47479948)(6024.12473223,2073.82480267)(5994.14973356,2032.81230449)
\curveto(5985.73723393,2021.312305)(5918.46223692,2001.0748059)(5901.39973768,1992.92480626)
\curveto(5833.79974069,1960.6498077)(5746.04974459,1902.28731029)(5746.49974457,1806.48731455)
\curveto(5749.58724443,1802.78731472)(5752.67474429,1799.07481488)(5755.77474415,1795.36231505)
\curveto(5805.76224193,1794.1373151)(5836.89974055,1830.86231347)(5881.46223857,1836.9373132)
\curveto(5900.67473771,1839.56231308)(5928.59973647,1830.0873135)(5919.0247369,1824.11231377)
\curveto(5918.04973694,1803.43731469)(5900.66223771,1784.38731553)(5893.97473801,1766.61231632)
\curveto(5879.46223866,1727.98731804)(5865.56223927,1692.46231962)(5847.59974007,1656.22482123)
\curveto(5836.22474058,1633.29982225)(5817.27474142,1606.18732345)(5811.42474168,1580.17482461)
\curveto(5801.34974213,1535.3998266)(5812.24974164,1481.07482902)(5829.97474086,1448.46233046)
\curveto(5865.52473928,1441.52483077)(5875.51223883,1466.21232968)(5893.04973805,1479.99982906)
\curveto(5924.37473666,1504.63732797)(5949.56223554,1527.82482694)(5983.02473405,1548.63732601)
\curveto(5991.92473366,1554.17482577)(6023.24973226,1585.93732435)(6034.03723179,1580.17482461)
\curveto(6064.39973044,1569.73732507)(6065.02473041,1447.5998305)(6046.08723125,1422.48733162)
\curveto(6035.27473173,1408.13733226)(6016.78723255,1410.86233214)(6001.57473323,1402.08733253)
\curveto(6001.26223324,1401.46233255)(6000.94973326,1400.84983258)(6000.63723327,1400.22483261)
\curveto(6001.31223324,1372.41233385)(6055.08723085,1320.62483615)(6082.26222964,1319.5248362)
\curveto(6134.36222733,1347.74983494)(6150.88722659,1421.63733166)(6134.21222733,1498.54982824)
\curveto(6132.34972742,1530.07482684)(6130.4997275,1561.62482543)(6128.64972758,1593.16232403)
\lineto(6121.22472791,1686.83731987)
\curveto(6125.76222771,1705.98731902)(6163.87472601,1746.8248172)(6175.94972548,1763.82481645)
\curveto(6200.88722437,1798.92481489)(6223.14972338,1839.74981307)(6243.66222247,1877.91231138)
\curveto(6260.72472171,1909.66230996)(6274.4622211,1944.8623084)(6284.47472065,1982.72480672)
\curveto(6287.54972052,1994.3748062)(6292.71222029,2020.98730502)(6285.39972061,2028.1748047)
\curveto(6263.88722157,2020.09980506)(6250.17472218,1989.14980643)(6238.09972271,1970.66230725)
\curveto(6226.93722321,1953.57480801)(6212.33722386,1934.02480888)(6200.98722436,1916.87480964)
\curveto(6186.82472499,1895.4373106)(6179.24972533,1872.71231161)(6162.96222605,1853.79981245)
\curveto(6152.18722653,1841.274813)(6104.52472865,1819.52481397)(6085.97472948,1839.88731307)
\curveto(6061.42473057,1866.82481187)(6091.23722924,1931.79980898)(6086.89972944,1964.17480754)
\curveto(6081.54972967,2004.17480576)(6069.29973022,2044.31230398)(6065.57473038,2092.17480185)
\curveto(6067.11223031,2101.13730145)(6068.66223025,2110.11230105)(6070.21223018,2119.07480066)
\curveto(6069.6247302,2132.63730005)(6066.41223035,2155.19979905)(6072.06223009,2169.16229843)
\curveto(6077.83722984,2183.4122978)(6094.66222909,2196.93729719)(6104.52472865,2208.1247967)
\curveto(6139.28722711,2247.49979495)(6183.64972513,2295.31229282)(6207.48722408,2343.53729068)
\curveto(6226.18722324,2381.387289)(6247.73722229,2466.8622852)(6180.58722527,2466.8997852)
\closepath
\moveto(10908.32451512,2498.62478378)
\curveto(10889.44951596,2476.76228476)(10889.57451595,2436.01228657)(10873.94951665,2411.43728766)
\curveto(10855.82451746,2382.92478893)(10839.44951818,2352.58729028)(10820.19951904,2324.24979154)
\curveto(10811.82451941,2311.92479208)(10798.32452001,2300.44979259)(10790.44952036,2288.07479314)
\curveto(10781.69952075,2274.13729376)(10754.44952196,2230.5622957)(10764.57452151,2210.16229661)
\curveto(10783.07452069,2209.36229664)(10797.69952004,2206.79979676)(10814.57451929,2212.94979648)
\curveto(10836.32451832,2220.82479613)(10849.94951772,2242.17479518)(10875.82451657,2248.18729492)
\curveto(10935.07451393,2261.9747943)(11019.82451017,2246.287295)(11053.94950865,2294.56229286)
\curveto(11058.57450844,2301.16229256)(11075.1995077,2331.7872912)(11072.44950783,2342.79979071)
\curveto(11070.32450792,2348.67479045)(11068.19950801,2354.54979019)(11065.94950811,2360.42478993)
\curveto(11048.3245089,2427.29978696)(11022.44951005,2444.07478621)(10968.57451244,2475.43728482)
\curveto(10949.69951328,2486.41228433)(10937.57451382,2498.91228377)(10908.32451512,2498.62478378)
\closepath
\moveto(7964.26214599,2382.49978895)
\curveto(7946.96214675,2365.31228971)(7946.37464678,2331.12479123)(7941.99964698,2303.66229245)
\curveto(7936.11214724,2266.77479409)(7932.31214741,2223.19979603)(7926.22464768,2187.71229761)
\curveto(7921.73714788,2161.49979877)(7927.8746476,2124.98730039)(7918.81214801,2098.67480156)
\curveto(7897.46214896,2036.66230432)(7768.63715468,2033.59980446)(7714.74965708,1995.71230614)
\curveto(7674.94965885,1967.72480738)(7656.97465965,1921.31230945)(7628.48716091,1881.62481121)
\curveto(7622.17466119,1872.8248116)(7599.71216219,1870.08731172)(7593.23716248,1880.69981125)
\curveto(7580.99966302,1901.07481035)(7618.61216135,1958.12480781)(7627.56216095,1970.66230725)
\curveto(7629.41216087,1975.92480702)(7631.27466079,1981.17480679)(7633.12466071,1986.43730655)
\curveto(7657.27465963,2038.51230424)(7706.51215744,2095.5623017)(7691.56215811,2170.08729839)
\lineto(7691.56215811,2212.76229649)
\curveto(7688.04965826,2226.28729589)(7678.83715867,2245.24979505)(7669.2996591,2253.57479468)
\curveto(7652.56215984,2268.17479403)(7598.33716225,2277.46229362)(7577.47466318,2260.06229439)
\curveto(7560.59966393,2245.98729501)(7525.07466551,2129.56230019)(7527.38716541,2097.7373016)
\curveto(7528.54966535,2081.72480232)(7517.73716583,2027.57480472)(7508.83716623,2021.68730498)
\curveto(7486.09966724,2006.61230566)(7375.22467217,2019.86230507)(7374.33717221,1985.51230659)
\curveto(7410.38717061,1958.81230778)(7444.3496691,1938.53730868)(7461.52466833,1892.74981072)
\curveto(7471.1996679,1866.96231186)(7474.44966776,1828.48731357)(7468.02466804,1800.9248148)
\curveto(7466.16216813,1792.27481518)(7464.31216821,1783.61231557)(7462.46216829,1774.94981595)
\curveto(7463.22466826,1755.21231683)(7447.63716895,1732.77481783)(7441.12466924,1716.52481855)
\curveto(7412.14967053,1644.23732176)(7346.73717344,1570.92482502)(7263.96217711,1554.19982576)
\curveto(7245.63717793,1497.98732826)(7275.02467662,1436.54983099)(7313.12467493,1411.36233211)
\curveto(7343.73717357,1411.28733212)(7368.86217245,1425.63733148)(7391.03717147,1433.61233113)
\curveto(7403.88717089,1438.24983092)(7416.64967033,1451.87483031)(7431.84966965,1454.94983018)
\curveto(7457.09966853,1460.06232995)(7486.81216721,1411.37483211)(7519.03716578,1416.92483187)
\curveto(7552.3621643,1440.52483082)(7561.83716387,1493.14982848)(7565.41216372,1542.1373263)
\curveto(7567.11216364,1565.43732527)(7559.12466399,1589.07482421)(7566.33716367,1612.63732317)
\curveto(7580.91216303,1660.17482105)(7609.37466176,1690.7373197)(7635.91216058,1725.79981814)
\curveto(7643.32466025,1732.59981783)(7650.74965992,1739.39981753)(7658.17465959,1746.19981723)
\curveto(7666.24965923,1757.89981671)(7690.62465815,1788.77481534)(7702.68715761,1794.43731509)
\lineto(7702.68715761,1792.57481517)
\curveto(7722.79965672,1745.93731724)(7678.3371587,1695.0498195)(7703.62465757,1659.01232111)
\curveto(7709.92465729,1650.0373215)(7718.12465693,1651.33732145)(7728.66215646,1646.02482168)
\curveto(7759.2121551,1630.63732237)(7852.56215095,1578.1623247)(7855.73715081,1543.07482626)
\curveto(7855.42465082,1542.1373263)(7855.11215084,1541.21232634)(7854.81215085,1540.28732638)
\curveto(7838.08715159,1533.66232668)(7813.33715269,1519.09982733)(7789.88715374,1523.58732713)
\curveto(7717.52465695,1537.43732651)(7669.74965908,1592.06232408)(7669.2996591,1679.4123202)
\curveto(7665.58715926,1682.82482005)(7661.87465943,1686.2248199)(7658.17465959,1689.62481975)
\curveto(7655.99965969,1689.92481973)(7653.83715978,1690.23731972)(7651.67465988,1690.5498197)
\curveto(7645.83716014,1683.33732002)(7637.06216053,1678.57482024)(7631.27466079,1671.07482057)
\curveto(7610.57466171,1644.24982176)(7594.16216244,1535.13732661)(7599.73716219,1495.76232836)
\curveto(7602.72466206,1474.6498293)(7591.28716256,1452.1373303)(7598.81216223,1431.76233121)
\curveto(7607.38716185,1411.03733213)(7669.1246591,1408.76233223)(7695.27465794,1401.14983257)
\curveto(7742.89965583,1387.29983318)(7840.06215151,1389.33733309)(7891.9121492,1403.01233249)
\curveto(7927.44964762,1412.38733207)(7981.67464521,1435.81233103)(8016.19964368,1424.33733154)
\curveto(8032.78714294,1376.92483364)(8045.28714238,1344.68733508)(8080.19964083,1316.74983632)
\curveto(8105.82463969,1296.24983723)(8153.03713759,1296.43733722)(8186.87463609,1294.48733731)
\curveto(8287.43713162,1288.69983757)(8424.13712554,1294.14983732)(8504.08712199,1334.37483554)
\lineto(8504.08712199,1339.01233533)
\curveto(8488.57462268,1363.21233425)(8455.81212414,1356.28733456)(8426.17462545,1366.83733409)
\curveto(8413.46212602,1371.36233389)(8399.68712663,1377.54983362)(8385.36212727,1384.46233331)
\curveto(8364.94962818,1394.29983287)(8344.81212907,1413.31233203)(8325.99962991,1425.2748315)
\curveto(8319.19963021,1428.36233136)(8312.39963051,1431.44983122)(8305.59963081,1434.54983108)
\curveto(8284.38713176,1449.8623304)(8264.47463264,1466.41232967)(8241.59963366,1479.99982906)
\curveto(8218.42463469,1493.74982845)(8199.39963553,1519.02482733)(8177.5996365,1534.72482663)
\curveto(8168.13713692,1541.53732633)(8157.14963741,1547.92482604)(8148.83713778,1556.04982568)
\curveto(8115.73713925,1588.42482424)(8140.09963817,1607.11232341)(8150.6996377,1640.46232193)
\curveto(8150.99963769,1646.64982166)(8151.31213767,1652.82482138)(8151.62463766,1659.01232111)
\curveto(8154.41213753,1666.12482079)(8157.18713741,1673.23732047)(8159.97463729,1680.34982016)
\curveto(8160.28713727,1692.71231961)(8160.58713726,1705.08731906)(8160.89963725,1717.44981851)
\curveto(8164.63713708,1746.61231721)(8171.39963678,1783.36231558)(8169.24963687,1811.12481434)
\curveto(8167.08713697,1822.26231385)(8164.92463707,1833.38731335)(8162.74963716,1844.52481286)
\curveto(8159.24963732,1872.36231162)(8163.46213713,1908.71231001)(8145.13713795,1924.28730931)
\curveto(8113.18713937,1951.44980811)(8048.69964223,1903.57481024)(8007.84964405,1911.29980989)
\curveto(8008.27464403,1922.2748094)(8002.41214429,1937.08730875)(8007.84964405,1949.3373082)
\curveto(8026.61214321,1991.53730633)(8117.96213915,2003.06230581)(8158.11213737,2028.1748047)
\curveto(8165.22463705,2034.97480439)(8172.33713674,2041.77480409)(8179.44963642,2048.58730379)
\curveto(8187.99963604,2057.08730341)(8222.39963451,2107.33730118)(8216.54963477,2122.78730049)
\curveto(8227.44963429,2155.87479902)(8244.44963353,2222.96229604)(8216.54963477,2247.07479497)
\curveto(8209.74963507,2247.38729495)(8202.94963538,2247.69979494)(8196.14963568,2247.99979493)
\curveto(8182.34963629,2244.31229509)(8173.33713669,2224.36229598)(8164.61213708,2214.61229641)
\curveto(8143.36213802,2190.88729746)(8124.09963888,2165.77479858)(8096.89964009,2147.82479938)
\curveto(8079.84964085,2136.58729988)(8063.06214159,2118.0248007)(8038.46214269,2132.98730004)
\curveto(8019.89964351,2144.28729954)(8028.21214314,2180.62479792)(8024.54964331,2204.41229686)
\curveto(8015.91214369,2260.47479437)(8033.28714292,2382.86228893)(7964.26214599,2382.49978895)
\closepath
\moveto(10362.94953936,2414.22478754)
\curveto(10356.69953964,2412.98728759)(10350.57453991,2411.74978765)(10344.32454019,2410.5122877)
\curveto(10333.94954065,2406.97478786)(10319.69954129,2391.17478856)(10313.69954155,2382.68728894)
\curveto(10305.9495419,2371.71228943)(10304.19954198,2357.83729004)(10300.69954213,2342.79979071)
\curveto(10297.94954225,2332.91229115)(10295.19954238,2323.01229159)(10292.4495425,2313.12479203)
\curveto(10287.07454274,2295.94979279)(10299.44954219,2275.97479368)(10303.574542,2265.81229413)
\curveto(10320.82454124,2223.29979602)(10325.19954104,2209.23729665)(10361.94953941,2186.04979768)
\curveto(10368.8245391,2181.0997979)(10375.5745388,2176.14979812)(10382.3245385,2171.19979834)
\curveto(10387.19953829,2166.12479856)(10388.32453824,2158.37479891)(10394.44953796,2154.51229908)
\curveto(10410.69953724,2144.26229954)(10457.44953516,2155.18729905)(10470.44953459,2164.71229863)
\curveto(10471.69953453,2233.87479555)(10448.44953556,2382.44978895)(10404.69953751,2404.94978795)
\curveto(10392.19953806,2411.29978767)(10377.57453871,2412.52478761)(10362.94953936,2414.22478754)
\closepath
\moveto(5097.04977343,1357.81233449)
\curveto(5168.19977027,1382.02483342)(5189.84976931,1442.97483071)(5211.29976836,1533.69982668)
\curveto(5220.61226794,1572.76232494)(5204.01226868,1617.79982294)(5226.1372677,1647.7873216)
\curveto(5243.57476692,1671.41232055)(5281.51226524,1676.68732032)(5313.33726382,1684.88731996)
\curveto(5328.68726314,1688.84981978)(5345.3747624,1683.71232001)(5355.99976192,1690.44981971)
\curveto(5368.68726136,1698.51231935)(5379.26226089,1719.57481841)(5368.04976139,1737.76231761)
\curveto(5360.9622617,1749.27481709)(5345.3872624,1752.37481696)(5332.81226295,1759.09981666)
\curveto(5318.99976357,1766.47481633)(5304.02476423,1781.51231566)(5290.13726485,1787.84981538)
\lineto(5252.11226654,1795.27481505)
\curveto(5226.31226769,1803.86231467)(5192.12476921,1811.21231434)(5165.84977038,1816.5998141)
\curveto(5155.02477086,1816.28731412)(5144.21227134,1815.98731413)(5133.38727182,1815.67481414)
\curveto(5100.0997733,1816.5998141)(5059.81227509,1820.39981393)(5049.91227553,1849.06231266)
\curveto(5038.39977604,1882.37481118)(5064.67477487,1940.07480861)(5074.94977442,1964.08730755)
\curveto(5109.51227288,2044.81230396)(5187.7122694,2189.77479751)(5115.7622726,2282.2247934)
\curveto(5099.64977332,2302.92479248)(5066.3872748,2321.22479167)(5038.77477602,2329.5372913)
\curveto(5022.46227675,2334.44979108)(5006.46227746,2332.62479116)(4991.47477813,2339.73729085)
\curveto(4982.04977855,2335.19979105)(4979.42477866,2326.96229142)(4971.99977899,2321.18729167)
\curveto(4944.96228019,2300.18729261)(4923.72478114,2273.76229378)(4900.57478217,2248.83729489)
\curveto(4900.88728215,2247.28729496)(4901.18728214,2245.74979503)(4901.49978213,2244.19979509)
\curveto(4918.31228138,2213.11229648)(4977.39977875,2205.7747968)(4990.54977817,2168.13729848)
\curveto(4996.42477791,2151.29979922)(4986.34977836,2115.69980081)(4983.1247785,2095.78730169)
\curveto(4970.79977905,2019.78730507)(4947.1872801,1950.46230815)(4933.96228068,1880.59981126)
\curveto(4926.68728101,1842.17481296)(4938.61228048,1784.63731552)(4909.84978176,1765.58731637)
\curveto(4893.48728248,1754.74981685)(4867.16228365,1758.29981669)(4846.77478456,1760.94981657)
\curveto(4835.02478508,1760.3248166)(4823.2747856,1759.71231663)(4811.52478613,1759.09981666)
\curveto(4772.61228786,1763.52481646)(4705.01229086,1761.91231653)(4689.08729157,1731.26231789)
\curveto(4678.58729204,1711.04981879)(4702.07479099,1681.81232009)(4703.93729091,1664.48732086)
\curveto(4704.27479089,1661.349821)(4738.46228937,1618.7498229)(4743.81228914,1610.68732325)
\curveto(4763.28728827,1581.37482456)(4770.77478794,1542.53732628)(4776.27478769,1503.08732804)
\lineto(4776.27478769,1406.62483232)
\curveto(4777.54978764,1398.54983268)(4771.6247879,1384.6498333)(4778.13728761,1379.72483352)
\curveto(4802.61228652,1365.13733417)(4836.73728501,1372.63733384)(4867.17478365,1363.96233422)
\curveto(4957.43727964,1343.96233511)(5034.04977623,1336.36233545)(5097.04977343,1357.81233449)
\closepath
\moveto(10574.32452997,2388.24978869)
\curveto(10543.44953134,2368.68728956)(10531.69953186,2278.46229357)(10560.44953058,2250.04979483)
\curveto(10570.94953012,2239.74979529)(10584.8245295,2242.78729516)(10600.32452881,2243.54979512)
\lineto(10634.69952728,2243.54979512)
\curveto(10647.19952673,2248.74979489)(10658.57452622,2262.49979428)(10665.32452592,2274.16229376)
\curveto(10669.57452573,2281.69979343)(10680.07452527,2294.36229286)(10679.19952531,2305.69979236)
\curveto(10676.82452541,2336.237291)(10605.69952857,2385.42478882)(10574.32452997,2388.24978869)
\closepath
\moveto(9204.44959086,2324.16229154)
\curveto(9162.82459271,2307.73729227)(9137.19959385,2276.81229364)(9123.69959445,2233.26229558)
\curveto(9123.07459448,2207.59979672)(9122.4495945,2181.92479786)(9121.82459453,2156.274799)
\curveto(9118.69959467,2095.79980169)(9121.44959455,2019.82480507)(9108.82459511,1966.12480745)
\curveto(9104.5745953,1947.66230828)(9107.19959518,1927.94980915)(9098.69959556,1912.32480985)
\curveto(9086.69959609,1890.28731083)(9079.32459642,1869.21231176)(9049.44959775,1859.4498122)
\curveto(9033.19959847,1854.11231243)(9016.94959919,1857.2123123)(9000.32459993,1857.59981228)
\curveto(8983.0746007,1856.98731231)(8965.69960147,1856.36231233)(8948.44960224,1855.74981236)
\curveto(8888.5746049,1871.22481167)(8849.69960663,1855.71231236)(8824.07460777,1809.36231442)
\curveto(8819.94960795,1801.78731476)(8806.19960856,1763.87481644)(8810.19960838,1750.93731702)
\curveto(8823.44960779,1707.23731896)(8883.69960512,1692.37481962)(8929.82460307,1682.29982007)
\curveto(8957.32460184,1676.28732034)(9002.82459982,1677.27482029)(9006.82459964,1648.89982156)
\curveto(9010.57459948,1622.19982274)(8981.94960075,1605.82482347)(8967.82460138,1595.09982395)
\curveto(8932.44960295,1568.08732515)(8897.94960448,1539.56232642)(8909.44960397,1481.94982898)
\curveto(8913.07460381,1463.24982981)(8910.94960391,1442.18733074)(8925.19960327,1431.8623312)
\curveto(8942.07460252,1419.64983175)(9035.69959836,1447.6248305)(9054.07459754,1451.33733034)
\curveto(9153.57459312,1471.39982945)(9245.82458902,1553.3498258)(9276.69958765,1645.18732172)
\curveto(9286.44958721,1674.14982043)(9289.94958706,1706.87481898)(9296.19958678,1736.08731768)
\curveto(9300.44958659,1755.76231681)(9291.199587,1784.49981553)(9302.69958649,1801.02481479)
\curveto(9306.57458632,1806.61231455)(9328.57458534,1819.62481397)(9334.19958509,1823.2873138)
\curveto(9385.57458281,1856.27481234)(9456.82457964,1863.949812)(9518.82457689,1884.49981108)
\curveto(9546.07457567,1893.53731068)(9577.69957427,1889.98731084)(9600.44957326,1904.89981018)
\curveto(9617.32457251,1915.96230968)(9634.07457176,1943.84980844)(9628.32457202,1973.54980712)
\curveto(9618.07457247,1979.62480685)(9607.69957293,1989.29980642)(9595.82457346,1993.94980622)
\curveto(9560.69957502,2007.63730561)(9475.44957881,2017.96230515)(9438.07458047,2000.43730593)
\curveto(9406.19958189,1985.47480659)(9385.94958279,1960.41230771)(9357.44958406,1942.93730849)
\curveto(9348.82458444,1937.68730872)(9337.07458496,1925.93730924)(9322.19958563,1932.73730894)
\curveto(9323.32458558,1959.14980776)(9314.44958597,2005.06230572)(9319.44958575,2028.27480469)
\curveto(9322.19958563,2041.38730411)(9347.94958448,2182.41229784)(9338.82458489,2206.36229678)
\curveto(9333.82458511,2215.57479637)(9319.32458575,2222.07479608)(9312.94958604,2231.39979566)
\curveto(9285.07458728,2271.61229388)(9272.94958781,2324.72479151)(9204.44959086,2324.16229154)
\closepath
\moveto(3909.02482624,2103.21230136)
\curveto(3950.09982442,2103.39980135)(4033.93732069,2026.33730478)(4016.62482146,1969.6498073)
\curveto(4006.6623219,1937.06230875)(3986.19982281,1911.56230988)(3973.0248234,1884.31231109)
\curveto(3955.69982417,1848.46231268)(3924.42482556,1814.24981421)(3874.69982777,1830.51231348)
\curveto(3870.99982793,1855.86231236)(3867.2873281,1881.22481123)(3863.57482826,1906.5748101)
\curveto(3856.22482859,1958.14980781)(3864.14982824,2018.49980513)(3877.48732764,2060.54980326)
\curveto(3880.92482749,2071.37480278)(3881.31232747,2084.93730217)(3887.68732719,2093.01230181)
\lineto(3909.02482624,2103.21230136)
\closepath
\moveto(6513.57471047,2072.69980272)
\curveto(6571.99970787,2065.09980306)(6558.07470849,1987.4998065)(6508.93721068,1976.23730701)
\lineto(6484.82471175,1986.43730655)
\curveto(6469.73721242,1996.03730613)(6455.86221303,2030.18730461)(6468.12471249,2050.43730371)
\curveto(6478.02471205,2066.76230298)(6497.1997112,2062.49980317)(6513.57471047,2072.69980272)
\closepath
\moveto(10644.82452683,2106.27480122)
\curveto(10617.69952804,2104.72480129)(10590.44952925,2103.18730136)(10563.19953046,2101.63730143)
\curveto(10474.19953442,2080.06230239)(10382.57453849,2056.87480342)(10299.82454217,2029.28730465)
\curveto(10270.57454347,2019.54980508)(10221.07454567,2009.91230551)(10204.32454641,1989.39980642)
\curveto(10188.9495471,1970.71230725)(10187.69954715,1940.13730861)(10178.32454757,1915.19980972)
\curveto(10168.19954802,1888.16231092)(10137.32454939,1803.56231468)(10156.94954852,1774.21231599)
\curveto(10168.19954802,1757.48731673)(10210.94954612,1730.03731795)(10239.57454485,1741.74981743)
\curveto(10279.94954305,1758.31231669)(10283.19954291,1815.89981413)(10319.3245413,1835.43731326)
\curveto(10341.32454032,1847.33731273)(10370.07453905,1842.99981293)(10395.32453792,1852.12481252)
\curveto(10446.07453567,1870.42481171)(10492.32453361,1901.16231034)(10540.94953145,1923.54980935)
\curveto(10571.07453011,1937.41230873)(10654.32452641,1974.36230709)(10682.94952514,1947.66230828)
\curveto(10673.32452557,1906.99981008)(10616.82452808,1894.47481064)(10581.82452963,1878.09981137)
\curveto(10521.9495323,1850.09981261)(10475.82453435,1830.96231346)(10444.57453574,1773.28731603)
\curveto(10440.44953592,1765.86231636)(10432.69953626,1754.43731686)(10429.6995364,1746.38731722)
\curveto(10422.07453674,1726.34981811)(10427.82453648,1665.76232081)(10439.82453595,1652.69982139)
\curveto(10467.32453472,1622.99982271)(10490.82453368,1658.12482115)(10503.8245331,1674.9623204)
\curveto(10531.19953188,1710.04981884)(10584.8245295,1806.96231453)(10645.82452679,1789.98731528)
\curveto(10659.69952617,1759.36231665)(10658.44952623,1728.59981801)(10643.07452691,1698.14981937)
\curveto(10616.07452811,1644.92482173)(10516.69953253,1548.74982601)(10453.82453532,1536.76232654)
\curveto(10410.69953724,1528.53732691)(10354.07453976,1545.48732615)(10318.32454135,1554.38732576)
\curveto(10296.9495423,1559.72482552)(10279.19954309,1575.23732483)(10259.94954394,1559.02482555)
\curveto(10240.5745448,1542.79982627)(10239.69954484,1500.81232814)(10253.44954423,1477.39982918)
\curveto(10272.69954338,1444.74983063)(10306.94954185,1421.89983165)(10334.19954064,1396.69983277)
\curveto(10354.57453974,1377.78733361)(10371.82453897,1344.02483511)(10382.3245385,1319.71233619)
\curveto(10400.19953771,1278.66233801)(10410.82453724,1226.39984034)(10454.69953529,1211.18734101)
\curveto(10471.82453452,1205.29984127)(10516.32453255,1212.33734096)(10531.69953186,1211.18734101)
\curveto(10555.19953082,1210.57484104)(10578.69952977,1209.96234107)(10602.19952873,1209.33734109)
\curveto(10610.57452836,1207.0498412)(10641.32452699,1201.36234145)(10649.44952663,1203.77484134)
\curveto(10679.69952528,1212.66234095)(10705.57452413,1236.0998399)(10720.94952345,1260.34983883)
\curveto(10722.44952338,1267.14983852)(10724.07452331,1273.96233822)(10725.57452324,1280.76233792)
\curveto(10741.69952253,1325.33733594)(10737.8245227,1402.81233249)(10772.82452114,1429.16233132)
\curveto(10809.94951949,1457.06233008)(10864.19951708,1446.29983056)(10914.82451483,1457.92483004)
\curveto(10947.19951339,1465.34982971)(10985.94951167,1466.88732965)(10974.19951219,1513.57482757)
\curveto(10963.82451265,1554.37482576)(10899.44951552,1606.02482346)(10855.44951747,1609.11232332)
\curveto(10823.44951889,1611.34982322)(10779.82452083,1586.32482434)(10755.19952193,1576.64982477)
\curveto(10738.19952268,1569.93732507)(10723.44952334,1567.57482517)(10719.07452353,1586.84982431)
\curveto(10709.69952395,1628.29982247)(10741.44952254,1692.62481961)(10757.07452184,1719.48731842)
\curveto(10763.07452158,1729.82481796)(10773.44952112,1740.92481746)(10777.44952094,1752.87481693)
\curveto(10781.32452077,1764.11231643)(10776.69952097,1772.26231607)(10778.44952089,1784.41231553)
\curveto(10783.07452069,1815.99981413)(10781.32452077,1844.48731286)(10795.07452016,1867.89981182)
\curveto(10818.8245191,1908.24981003)(10883.82451621,1931.97480897)(10871.19951677,1997.74980605)
\curveto(10868.82451688,2009.97480551)(10872.44951672,2022.83730493)(10866.57451698,2031.14980456)
\curveto(10853.69951755,2049.33730376)(10814.44951929,2069.48730286)(10793.32452023,2080.29980238)
\curveto(10760.57452169,2096.97480164)(10718.69952355,2095.09980172)(10681.07452522,2105.34980127)
\curveto(10668.94952576,2105.66230125)(10656.9495263,2105.96230124)(10644.82452683,2106.27480122)
\closepath
\moveto(7758.34965514,1941.91230853)
\curveto(7766.99965475,1938.51230868)(7775.66215437,1935.11230883)(7784.31215398,1931.71230898)
\curveto(7789.57465375,1925.83730925)(7794.82465352,1919.96230951)(7800.08715328,1914.08730977)
\curveto(7813.04965271,1906.73731009)(7838.86215156,1908.86231)(7843.67465135,1893.68731067)
\curveto(7843.06215137,1890.27481083)(7842.4371514,1886.87481098)(7841.82465143,1883.47481113)
\curveto(7842.73715139,1878.23731136)(7845.34965127,1867.81231182)(7841.82465143,1859.3623122)
\curveto(7832.53715184,1837.11231319)(7813.48715269,1814.89981418)(7782.46215407,1825.03731373)
\curveto(7774.42465442,1829.37481353)(7766.38715478,1833.69981334)(7758.34965514,1838.02481315)
\curveto(7744.53715575,1842.64981294)(7730.43715638,1831.17481345)(7722.17465675,1842.66231294)
\curveto(7718.06215693,1857.41231229)(7749.41215554,1933.13730892)(7758.34965514,1941.91230853)
\closepath
\moveto(6527.48720985,1798.14981492)
\curveto(6511.19971058,1786.91231542)(6472.3997123,1770.12481617)(6451.43721323,1787.01231542)
\curveto(6425.1872144,1808.13731448)(6470.51221238,1872.39981162)(6482.03721187,1887.18731096)
\curveto(6562.3372083,1899.8998104)(6573.12470782,1829.26231354)(6527.48720985,1798.14981492)
\closepath
\moveto(6014.56223265,1772.17481608)
\curveto(6070.19973018,1765.49981637)(6017.19973253,1683.01232004)(5991.36223368,1721.16231834)
\curveto(5974.91223441,1746.31231723)(6003.88723313,1761.53731655)(6014.56223265,1772.17481608)
\closepath
\moveto(8026.41214322,1767.53731628)
\curveto(8033.41214291,1767.67481628)(8037.77464272,1766.28731634)(8040.3246426,1761.97481653)
\curveto(8058.12464181,1726.79981809)(8011.53714388,1646.39982167)(7978.17464537,1652.52482139)
\curveto(7974.88714551,1664.58732086)(7977.24964541,1663.22482092)(7965.18714594,1659.93732106)
\curveto(7942.93714693,1712.92481871)(7989.42464487,1751.19981701)(8026.41214322,1767.53731628)
\closepath
\moveto(3871.89982789,1717.04981853)
\curveto(3862.08732833,1713.39981869)(3852.28732876,1712.77481872)(3843.44982916,1716.37481856)
\curveto(3837.9248294,1718.62481846)(3835.44982951,1721.33731834)(3834.53732955,1724.77481818)
\curveto(3830.79982972,1738.76231756)(3838.64982937,1739.63731752)(3849.53732889,1743.22481736)
\curveto(3868.58732804,1749.51231708)(3878.4498276,1746.32481722)(3871.89982789,1717.04981853)
\closepath
\moveto(5043.41227582,1650.57482148)
\curveto(5076.52477435,1604.49982353)(5035.94977615,1523.62482712)(5014.6622771,1491.03732857)
\curveto(5003.2747776,1473.59982935)(4982.58727852,1458.47483002)(4962.71227941,1449.28733043)
\curveto(4906.81228189,1471.08732946)(4861.02478393,1508.01232782)(4837.49978497,1561.52482544)
\curveto(4825.23728552,1589.4123242)(4824.83728553,1633.97482222)(4848.62478448,1650.57482148)
\curveto(4866.46228368,1663.01232093)(4903.81228202,1662.47482095)(4924.6872811,1668.1998207)
\curveto(4950.27477996,1675.19982039)(5029.34977644,1670.13732061)(5043.41227582,1650.57482148)
\closepath
\moveto(3871.92482789,1641.0998219)
\curveto(3874.56232777,1636.19982212)(3874.78732776,1633.22482225)(3869.412328,1630.34982238)
\curveto(3861.22482837,1625.96232258)(3860.4498284,1628.92482244)(3857.72482852,1635.36232216)
\curveto(3855.41232863,1640.83732191)(3857.03732855,1642.51232184)(3860.5623284,1644.71232174)
\curveto(3867.38732809,1648.97482155)(3868.01232807,1648.38732158)(3871.92482789,1641.0998219)
\closepath
\moveto(9376.94958319,1574.69982485)
\curveto(9364.19958376,1574.38732487)(9351.57458432,1574.07482488)(9338.82458489,1573.77482489)
\curveto(9320.19958571,1570.73732503)(9299.94958661,1565.29982527)(9286.07458723,1557.07482564)
\curveto(9271.19958789,1486.0123288)(9333.82458511,1489.59982864)(9373.19958336,1463.3873298)
\curveto(9389.32458264,1452.64983028)(9400.94958212,1430.43733127)(9414.07458154,1416.0873319)
\curveto(9432.9495807,1395.16233283)(9468.57457912,1378.93733356)(9497.44957784,1368.78733401)
\curveto(9520.44957681,1360.69983437)(9601.32457322,1362.82483427)(9610.6995728,1378.06233359)
\curveto(9619.94957239,1401.08733257)(9604.69957307,1440.61233081)(9599.5745733,1454.11233021)
\curveto(9576.19957433,1514.53732753)(9533.57457623,1546.6623261)(9469.69957907,1566.34982522)
\curveto(9451.44957988,1571.96232498)(9426.199581,1571.06232502)(9411.19958167,1573.77482489)
\curveto(9399.44958219,1575.9123248)(9385.07458283,1572.01232497)(9376.94958319,1574.69982485)
\closepath
\moveto(10549.32453108,1446.78733054)
\curveto(10615.07452816,1448.44983047)(10625.19952771,1387.72483316)(10584.57452951,1357.7498345)
\curveto(10550.32453103,1332.46233562)(10440.07453594,1341.68733521)(10448.19953557,1396.69983277)
\curveto(10474.6995344,1428.07483137)(10508.69953288,1429.6373313)(10549.32453108,1446.78733054)
\closepath
}
}
{
\newrgbcolor{curcolor}{0 0.33725491 0.62352943}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(1545.04993132,2592.06227963)
\curveto(968.37495696,2592.06227963)(498.02497786,2121.72480054)(498.02497786,1545.03732617)
\curveto(498.02497786,968.36235181)(968.37495696,498.01237271)(1545.04993132,498.01237271)
\curveto(2121.72490569,498.01237271)(2592.07488478,968.36235181)(2592.07488478,1545.03732617)
\curveto(2592.07488478,2121.72480054)(2121.72490569,2592.06227963)(1545.04993132,2592.06227963)
\closepath
\moveto(1545.04993132,3090.08725749)
\curveto(2396.0373935,3090.08725749)(3090.09986264,2396.02478835)(3090.09986264,1545.03732617)
\curveto(3090.09986264,694.062364)(2396.0373935,-0.00010515)(1545.04993132,-0.00010515)
\curveto(694.07496915,-0.00010515)(-0,694.062364)(-0,1545.03732617)
\curveto(-0,2396.02478835)(694.07496915,3090.08725749)(1545.04993132,3090.08725749)
\closepath
}
}
{
\newrgbcolor{curcolor}{1 1 1}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(67.77499699,1579.99982462)
\curveto(68.02499698,1579.72482463)(68.26249697,1579.43732464)(68.51249695,1579.14982466)
\curveto(72.82499676,1579.03732466)(76.5124966,1580.91232458)(80.19999644,1581.74982454)
\curveto(87.46249611,1583.39982447)(99.48749558,1581.37482456)(107.09999524,1579.83732463)
\curveto(123.33749452,1576.56232477)(141.22499372,1559.13732555)(150.6499933,1550.43732593)
\curveto(173.47499229,1529.38732687)(189.31249158,1505.61232792)(216.0374904,1486.63732877)
\curveto(218.61249028,1485.8248288)(221.18749017,1485.01232884)(223.74999005,1484.19982888)
\curveto(237.31248945,1479.58732908)(236.41248949,1488.66232868)(244.88748911,1490.64982859)
\curveto(261.37498838,1494.48732842)(278.16248764,1489.98732862)(289.26248714,1477.14982919)
\curveto(291.78748703,1474.23732932)(295.37498687,1471.21232945)(296.66248681,1467.69982961)
\curveto(299.38748669,1460.23732994)(293.37498696,1454.4498302)(287.46248722,1451.83733031)
\curveto(282.22498746,1449.52483042)(276.18748772,1446.07483057)(270.17498799,1445.28733061)
\curveto(260.42498842,1444.03733066)(251.17498884,1444.46233064)(242.46248922,1441.93733075)
\curveto(242.38748923,1441.63733077)(242.29998923,1441.33733078)(242.21248923,1441.03733079)
\lineto(242.43748922,1440.66233081)
\curveto(249.26248892,1438.79983089)(254.47498869,1436.73733099)(260.02498844,1434.2123311)
\curveto(266.69998815,1431.16233123)(272.2624879,1431.66233121)(278.62498762,1429.09983133)
\curveto(287.81248721,1425.38733149)(296.62498681,1423.43733158)(305.46248642,1421.07483168)
\curveto(312.38748611,1419.21233177)(322.53748566,1415.47483193)(329.78748534,1415.67483192)
\curveto(346.79998458,1416.1373319)(355.09998422,1450.86233036)(367.53748366,1461.43732989)
\curveto(376.61248326,1469.14982955)(391.72498259,1464.69982974)(404.38748202,1465.17482972)
\curveto(412.23748168,1465.48732971)(427.61248099,1466.64982966)(434.2999807,1469.53732953)
\curveto(440.8999804,1472.3873294)(451.66247992,1475.37482927)(456.24997972,1481.24982901)
\curveto(463.04997942,1489.99982862)(465.99997929,1502.02482808)(469.57497913,1515.66232748)
\curveto(473.56247895,1528.98732689)(477.54997877,1542.29982629)(481.5374786,1555.6123257)
\curveto(482.13747857,1560.62482548)(480.33747865,1566.74982521)(479.71247868,1571.28732501)
\curveto(478.59997873,1579.22482465)(480.47497864,1596.61232388)(475.81247885,1601.72482365)
\curveto(467.56247922,1610.77482325)(453.31247985,1623.71232268)(442.39998034,1609.29982332)
\curveto(440.9624804,1607.3998234)(438.02498053,1604.22482354)(437.61248055,1601.24982367)
\curveto(436.11248061,1590.42482415)(435.66248063,1573.92482489)(434.88748067,1561.98732542)
\curveto(433.93748071,1547.52482606)(430.82498085,1533.49982669)(429.17498092,1521.28732723)
\curveto(427.524981,1509.07482777)(419.87498134,1500.99982813)(410.66248175,1500.88732813)
\curveto(394.77498245,1500.68732814)(388.28748274,1525.18732705)(386.39998282,1538.21232648)
\curveto(384.84998289,1548.862326)(387.42498278,1558.66232557)(381.99998302,1566.8498252)
\curveto(371.84998347,1582.19982452)(350.14998444,1575.24982483)(332.18748523,1586.36232434)
\curveto(316.41248594,1596.1123239)(301.13748661,1606.87482342)(290.48748709,1620.08732284)
\curveto(288.22498719,1622.89982271)(287.61248722,1626.44982255)(286.41248727,1629.9248224)
\curveto(283.63748739,1637.92482204)(273.17498786,1653.28732136)(264.41248825,1657.91232115)
\curveto(253.74998872,1663.5498209)(234.93748956,1646.72482165)(227.52498989,1642.23732185)
\curveto(215.06249044,1634.71232219)(202.437491,1626.71232254)(190.57499153,1618.19982292)
\curveto(184.81249179,1614.0498231)(177.89999209,1606.76232343)(170.8749924,1605.2248235)
\curveto(163.86249272,1603.68732357)(153.63749317,1609.52482331)(146.83749347,1610.53732326)
\curveto(120.56249464,1614.46232309)(84.62499624,1624.62482263)(67.77499699,1579.99982462)
\closepath
\moveto(193.71249139,1594.42482398)
\curveto(197.31249123,1607.72482339)(229.68748979,1627.98732249)(246.48748904,1617.33732296)
\curveto(256.13748861,1611.22482323)(262.56248833,1602.33732363)(270.21248799,1595.64982392)
\curveto(280.26248754,1586.86232431)(288.54998717,1573.6998249)(278.8624876,1559.07482555)
\curveto(270.33748798,1560.1248255)(261.81248836,1561.17482545)(253.27498874,1562.23732541)
\curveto(235.93748951,1564.44982531)(217.12499035,1572.37482496)(204.7124909,1580.4248246)
\curveto(201.51249104,1582.49982451)(197.16249124,1583.83732445)(195.12499133,1586.61232432)
\curveto(194.64999135,1589.21232421)(194.18749137,1591.81232409)(193.71249139,1594.42482398)
\closepath
\moveto(315.31248598,1548.07482604)
\curveto(315.62498597,1544.57482619)(314.962486,1541.34982634)(312.99998609,1538.81232645)
\curveto(311.78748614,1537.22482652)(310.68748619,1536.66232654)(309.49998624,1536.67482654)
\curveto(304.63748646,1536.71232654)(305.04998644,1539.32482643)(304.86248645,1543.17482625)
\curveto(304.52498646,1549.88732596)(306.42498638,1552.78732583)(315.31248598,1548.07482604)
\closepath
\moveto(339.88748489,1541.32482634)
\curveto(341.69998481,1541.74982632)(342.68748477,1541.54982633)(343.13748475,1539.56232642)
\curveto(343.82498472,1536.52482655)(342.79998476,1536.52482655)(340.47498487,1536.22482656)
\curveto(338.49998495,1535.96232658)(338.09998497,1536.63732655)(337.69998499,1537.97482649)
\curveto(336.93748502,1540.54982637)(337.17498501,1540.71232636)(339.88748489,1541.32482634)
\closepath
\moveto(1119.69995023,2914.94976528)
\curveto(1119.59995023,2914.5247653)(1119.49995024,2914.08726532)(1119.39995024,2913.64976534)
\curveto(1121.67495014,2907.21226562)(1123.94995004,2900.78726591)(1126.21244994,2894.36226619)
\curveto(1127.49994988,2890.08726638)(1130.49994975,2885.71226658)(1131.19994972,2882.47476672)
\curveto(1133.49994962,2871.7997672)(1150.99994884,2853.26226802)(1141.33744927,2841.17476856)
\curveto(1133.27494963,2831.06226901)(1115.67495041,2824.73726929)(1105.99995084,2816.93726964)
\curveto(1103.16245096,2814.64976974)(1098.52495117,2811.64976987)(1098.39995118,2808.27477002)
\curveto(1099.16245114,2801.34977033)(1105.68745085,2796.68727054)(1106.7874508,2789.39977086)
\curveto(1108.48745073,2778.27477135)(1106.98745079,2758.46227224)(1116.43745037,2750.51227259)
\curveto(1121.21245016,2746.48727277)(1127.86244987,2748.41227268)(1133.31244962,2746.26227278)
\curveto(1137.84994942,2736.36227322)(1133.9374496,2716.21227411)(1131.42494971,2707.5372745)
\curveto(1129.19994981,2699.82477484)(1124.17495003,2691.06227523)(1132.27494967,2681.18727567)
\curveto(1139.36244935,2672.56227605)(1147.449949,2672.19977607)(1159.03744848,2675.17477594)
\curveto(1162.46244833,2676.69977587)(1165.89994818,2678.2247758)(1169.33744802,2679.74977573)
\curveto(1179.26244758,2682.7872756)(1186.84994724,2694.0122751)(1195.07494688,2688.54977534)
\curveto(1207.33744633,2680.4122757)(1210.88744618,2662.94977648)(1221.83744569,2648.17477714)
\curveto(1223.14994563,2646.38727722)(1224.94994555,2640.84977746)(1226.68744547,2638.57477756)
\curveto(1239.33744491,2622.0372783)(1247.23744456,2601.6872792)(1262.1124439,2587.94977981)
\curveto(1268.03744364,2582.48728006)(1271.42494348,2574.01228043)(1277.8999432,2570.2997806)
\curveto(1278.22494318,2570.43728059)(1278.54994317,2570.58728059)(1278.87494315,2570.73728058)
\curveto(1280.61244308,2577.31228029)(1276.16244327,2584.09977999)(1274.07494337,2592.09977963)
\curveto(1270.66244352,2605.27477904)(1265.12494376,2616.19977856)(1262.33744389,2629.74977796)
\curveto(1259.53744401,2643.32477735)(1256.02494417,2657.27477673)(1256.22494416,2669.91227617)
\curveto(1256.33744416,2676.84977586)(1259.67494401,2683.72477556)(1258.51244406,2691.19977522)
\curveto(1257.97494408,2694.73727507)(1255.71244418,2697.08727496)(1254.94994422,2699.88727484)
\curveto(1253.81244427,2704.04977465)(1250.63744441,2709.7747744)(1248.5749445,2712.91227426)
\curveto(1242.27494478,2722.44977384)(1238.77494494,2731.58727343)(1237.12494501,2741.299773)
\curveto(1235.84994507,2748.78727267)(1236.29994505,2758.31227224)(1237.61244499,2765.31227193)
\curveto(1239.69994489,2776.39977144)(1246.82494458,2788.61227089)(1237.03744501,2802.93727026)
\curveto(1227.13744545,2817.43726961)(1214.04994604,2823.37476935)(1202.97494653,2833.32476891)
\curveto(1195.57494686,2839.97476861)(1190.22494709,2847.96226826)(1182.94994742,2855.24976793)
\curveto(1174.52494779,2863.69976756)(1158.6124485,2897.09976607)(1153.08744874,2909.23726553)
\curveto(1151.29994882,2910.82476546)(1122.72495009,2915.77476524)(1119.69995023,2914.94976528)
\closepath
\moveto(1008.66245516,2864.12476754)
\curveto(996.5999557,2848.14976825)(992.57495588,2807.78727004)(997.14995568,2784.99977106)
\curveto(998.22495563,2782.34977117)(999.31245558,2779.69977129)(1000.38745553,2777.04977141)
\curveto(1003.81245538,2760.19977216)(1013.49995495,2741.82477297)(1010.38745509,2727.44977361)
\curveto(1009.51245513,2723.42477379)(994.11245581,2710.17477438)(990.54995597,2706.01227457)
\curveto(976.4749566,2689.5372753)(960.13745732,2663.78727644)(971.51245682,2638.51227757)
\curveto(972.76245676,2637.89977759)(974.0124567,2637.27477762)(975.27495665,2636.66227765)
\curveto(988.62495606,2642.2122774)(992.54995588,2655.57477681)(1003.61245539,2662.4247765)
\curveto(1008.38745518,2665.37477637)(1016.8874548,2666.14977634)(1015.04995488,2663.44977646)
\curveto(1017.22495478,2657.86227671)(1014.86245489,2650.78727702)(1015.18745487,2645.29977727)
\curveto(1015.88745484,2633.38727779)(1016.38745482,2622.36227828)(1015.89995484,2610.6622788)
\curveto(1015.58745486,2603.27477913)(1013.76245494,2593.87477955)(1015.27495487,2586.31227989)
\curveto(1017.87495476,2573.28728047)(1027.13745434,2560.19978105)(1035.64995397,2553.66228134)
\curveto(1045.87495351,2556.01228123)(1045.61245352,2563.71228089)(1048.62495339,2569.41228064)
\curveto(1054.01245315,2579.61228018)(1057.94995297,2588.69977978)(1064.34995269,2598.13727936)
\curveto(1066.04995261,2600.64977925)(1070.59995241,2612.72477871)(1074.12495225,2612.47477872)
\curveto(1083.38745184,2613.27477869)(1097.8999512,2581.06228012)(1095.84995129,2572.19978051)
\curveto(1094.67495134,2567.12478074)(1089.46245157,2565.6747808)(1086.47495171,2561.57478099)
\curveto(1086.46245171,2561.362281)(1086.46245171,2561.174781)(1086.44995171,2560.97478101)
\curveto(1089.89995155,2553.69978134)(1110.19995065,2546.32478166)(1117.51245033,2549.22478154)
\curveto(1127.97494986,2562.81228093)(1123.64995005,2584.28727998)(1110.19995065,2602.66227916)
\curveto(1106.01245084,2610.7747788)(1101.81245102,2618.89977844)(1097.61245121,2627.02477808)
\curveto(1093.2999514,2634.98727772)(1088.97495159,2642.94977737)(1084.64995179,2650.91227702)
\curveto(1083.59995183,2656.51227677)(1088.8749516,2671.78727609)(1090.06245155,2677.69977582)
\curveto(1092.53745144,2689.91227528)(1093.62495139,2703.32477469)(1094.56245135,2715.82477413)
\curveto(1095.33745131,2726.22477367)(1094.83745133,2737.13727318)(1093.03745141,2748.32477269)
\curveto(1092.47495144,2751.77477253)(1090.71245152,2759.41227219)(1087.93745164,2760.44977215)
\curveto(1083.19995185,2755.78727235)(1083.21245185,2745.99977279)(1082.1874519,2739.68727307)
\curveto(1081.24995194,2733.86227333)(1079.68745201,2726.97477363)(1078.69995205,2721.1122739)
\curveto(1077.47495211,2713.77477422)(1078.14995208,2706.87477453)(1076.06245217,2699.96227484)
\curveto(1074.68745223,2695.38727504)(1064.63745268,2684.03727554)(1057.337453,2687.2372754)
\curveto(1047.68745343,2691.47477521)(1047.92495342,2712.16227429)(1042.97495364,2720.21227394)
\curveto(1036.86245391,2730.14977349)(1028.91245426,2739.32477309)(1022.29995456,2751.53727254)
\curveto(1021.64995459,2754.09977243)(1021.01245462,2756.64977232)(1020.36245464,2759.1997722)
\curveto(1018.61245472,2762.71227205)(1015.11245488,2768.2997718)(1014.96245488,2772.6622716)
\curveto(1014.82495489,2777.09977141)(1017.67495476,2782.66227116)(1018.97495471,2786.77477098)
\curveto(1023.5374545,2801.27477033)(1029.64995423,2819.12476954)(1030.2749542,2834.67476885)
\curveto(1030.77495418,2846.8872683)(1026.42495438,2872.01226719)(1008.66245516,2864.12476754)
\closepath
\moveto(1143.03744919,2799.03727043)
\curveto(1159.37494847,2803.89977022)(1164.81244822,2781.7372712)(1153.13744874,2772.98727159)
\curveto(1150.61244885,2772.94977159)(1148.08744897,2772.89977159)(1145.56244908,2772.8497716)
\curveto(1140.44994931,2773.62477156)(1132.76244965,2781.02477123)(1133.63744961,2787.81227093)
\curveto(1134.32494958,2793.28727069)(1139.89994933,2794.42477064)(1143.03744919,2799.03727043)
\closepath
\moveto(1178.97494759,2728.08727359)
\curveto(1175.98744773,2723.1997738)(1167.6999481,2714.2122742)(1160.17494843,2716.21227411)
\curveto(1150.76244885,2718.712274)(1155.18744865,2741.02477301)(1156.49994859,2746.28727278)
\curveto(1176.22494772,2759.08727221)(1187.38744722,2741.67477298)(1178.97494759,2728.08727359)
\closepath
\moveto(1046.41245349,2660.93727657)
\curveto(1061.9124528,2665.71227636)(1057.58745299,2637.6747776)(1046.27495349,2644.72477729)
\curveto(1038.97495382,2649.44977708)(1044.84995356,2656.87477675)(1046.41245349,2660.93727657)
\closepath
\moveto(3062.53736387,1505.88732791)
\curveto(3054.52486423,1509.67482774)(3042.46236476,1506.32482789)(3033.91236514,1508.94982778)
\curveto(3023.98736558,1511.98732764)(3013.64986604,1514.38732753)(3003.68736649,1517.77482738)
\curveto(2999.34986668,1519.24982732)(2994.86236688,1522.31232718)(2990.54986707,1523.62482712)
\curveto(2985.69986728,1525.09982706)(2970.57486796,1529.63732686)(2965.34986819,1524.97482706)
\curveto(2966.62486813,1519.39982731)(2967.06236811,1514.87482751)(2970.26236797,1510.34982771)
\curveto(2974.36236779,1504.54982797)(2981.79986746,1502.26232807)(2985.68736729,1495.08732839)
\curveto(2994.59986689,1478.67482912)(2996.86236679,1452.28733029)(3013.94986603,1446.09983057)
\curveto(3016.27486593,1445.26233061)(3026.69986546,1442.84983071)(3029.74986533,1444.53733064)
\curveto(3031.31236526,1445.66233059)(3032.87486519,1446.78733054)(3034.43736512,1447.89983049)
\curveto(3052.8248643,1458.56233002)(3055.67486417,1467.61232961)(3060.57486396,1486.12482879)
\curveto(3062.29986388,1492.6123285)(3065.01236376,1497.2373283)(3062.53736387,1505.88732791)
\closepath
\moveto(2993.07486696,1660.59982104)
\curveto(2992.212367,1662.32482096)(2991.33736703,1664.06232088)(2990.46236707,1665.7873208)
\curveto(2988.57486716,1668.57482068)(2982.73736742,1671.49982055)(2979.72486755,1672.5873205)
\curveto(2975.84986772,1673.99982044)(2971.58736791,1673.38732047)(2966.84986812,1673.18732048)
\curveto(2963.68736826,1673.21232047)(2960.5373684,1673.22482047)(2957.37486854,1673.24982047)
\curveto(2951.84986879,1673.43732046)(2946.94986901,1668.1373207)(2944.27486913,1666.08732079)
\curveto(2933.07486962,1657.51232117)(2929.27486979,1655.06232128)(2925.39986997,1642.27482185)
\curveto(2924.48737001,1639.86232196)(2923.57487005,1637.43732206)(2922.66237009,1635.02482217)
\curveto(2921.56237014,1633.16232225)(2919.34987023,1632.2248223)(2918.69987026,1630.08732239)
\curveto(2916.98737034,1624.43732264)(2924.03737003,1611.46232322)(2927.92486985,1608.38732336)
\curveto(2948.51236894,1613.67482312)(2990.63736707,1632.66232228)(2993.73736693,1647.47482162)
\curveto(2994.61236689,1651.66232143)(2993.76236693,1656.11232123)(2993.07486696,1660.59982104)
\closepath
\moveto(3002.62486653,1595.82482391)
\curveto(2994.2998669,1603.39982358)(2966.61236813,1599.52482375)(2960.5373684,1588.67482423)
\curveto(2958.3373685,1584.74982441)(2960.37486841,1580.87482458)(2961.86236834,1576.33732478)
\curveto(2962.7998683,1572.94982493)(2963.72486826,1569.54982508)(2964.66236822,1566.16232523)
\curveto(2967.22486811,1562.87482538)(2972.22486788,1560.62482548)(2976.22486771,1559.58732553)
\curveto(2978.81236759,1558.92482555)(2983.42486739,1556.84982565)(2986.69986724,1558.03732559)
\curveto(2995.56236685,1561.23732545)(3004.33736646,1586.32482434)(3002.62486653,1595.82482391)
\closepath
\moveto(2924.82486999,1551.94982586)
\lineto(2916.79987035,1575.76232481)
\curveto(2903.14987095,1600.37482371)(2888.79987159,1625.64982259)(2873.88737225,1647.9123216)
\curveto(2868.62487249,1655.76232125)(2861.73737279,1669.67482063)(2854.28737313,1672.96232049)
\curveto(2847.49987343,1675.97482035)(2838.33737383,1673.88732044)(2830.1873742,1674.61232041)
\curveto(2821.34987459,1675.41232038)(2793.76237582,1677.67482028)(2786.67487613,1669.44982064)
\curveto(2782.62487631,1664.74982085)(2777.98737652,1649.84982151)(2783.78737626,1642.33732185)
\curveto(2791.9873759,1631.72482232)(2809.29987513,1635.46232215)(2818.03737474,1626.33732256)
\curveto(2823.3623745,1620.78732281)(2824.41237445,1611.9248232)(2829.18737424,1605.1623235)
\curveto(2838.73737382,1591.6373241)(2851.61237324,1580.4373246)(2862.21237277,1567.83732516)
\curveto(2868.78737248,1560.03732551)(2886.51237169,1538.41232647)(2880.92487194,1527.76232694)
\curveto(2868.09987251,1527.27482696)(2859.77487288,1542.99982626)(2852.07487322,1552.04982586)
\curveto(2838.89987381,1567.51232517)(2829.47487423,1579.61232464)(2809.8373751,1584.17482443)
\curveto(2807.29987521,1584.76232441)(2803.28737539,1586.12482435)(2800.64987551,1586.37482433)
\curveto(2794.0873758,1587.01232431)(2776.61237658,1580.3498246)(2773.72487671,1575.72482481)
\curveto(2767.162377,1565.18732528)(2779.48737645,1561.07482546)(2785.53737618,1558.57482557)
\curveto(2798.14987562,1553.3623258)(2831.24987415,1545.33732616)(2831.18737415,1525.89982702)
\curveto(2823.23737451,1519.29982732)(2814.02487492,1517.14982741)(2803.74987537,1519.24982732)
\curveto(2785.77487617,1522.89982716)(2749.1873778,1544.4998262)(2740.51237818,1562.14982541)
\curveto(2734.56237845,1574.26232487)(2734.96237843,1592.41232407)(2734.68737844,1603.71232356)
\curveto(2734.53737845,1610.48732326)(2737.68737831,1617.01232297)(2731.31237859,1621.39982278)
\curveto(2724.92487888,1625.79982258)(2712.41237943,1622.66232272)(2706.58737969,1616.67482299)
\curveto(2698.48738005,1608.32482336)(2694.51238023,1596.28732389)(2689.26238046,1586.18732434)
\curveto(2685.32488064,1578.61232468)(2676.72488102,1570.73732503)(2670.3873813,1565.62482526)
\curveto(2659.67488178,1556.98732564)(2645.04988243,1549.58732597)(2644.12488247,1535.3373266)
\curveto(2643.76238248,1529.81232685)(2649.48738223,1517.18732741)(2650.39988219,1512.53732762)
\curveto(2652.13738211,1505.52482793)(2653.86238203,1498.51232824)(2655.59988196,1491.49982855)
\curveto(2655.59988196,1488.81232867)(2656.42488192,1479.2623291)(2657.79988186,1477.0248292)
\curveto(2662.89988163,1468.81232956)(2671.94988123,1463.04982982)(2680.38738086,1460.47482993)
\curveto(2682.52488076,1460.57482993)(2684.66238067,1460.67482992)(2686.81238057,1460.76232992)
\curveto(2701.32487993,1459.62482997)(2723.96237892,1467.08732964)(2734.63737844,1458.84983)
\curveto(2745.92487794,1450.12483039)(2747.14987789,1433.19983114)(2754.72487755,1419.13733177)
\curveto(2759.56237734,1410.16233217)(2763.17487718,1398.79983267)(2776.0498766,1406.08733235)
\curveto(2787.2998761,1412.46233207)(2797.34987566,1435.73733103)(2794.67487578,1449.04983044)
\curveto(2792.73737586,1458.69983001)(2781.77487635,1469.57482953)(2776.89987657,1476.08732924)
\curveto(2773.51237672,1480.59982904)(2771.6123768,1484.78732885)(2776.97487656,1487.63732872)
\curveto(2788.48737605,1493.77482845)(2810.13737509,1489.61232864)(2819.37487468,1487.17482874)
\curveto(2822.92487452,1486.23732879)(2827.04987434,1484.07482888)(2830.92487416,1483.84982889)
\curveto(2834.562374,1483.6498289)(2836.59987391,1485.68732881)(2840.34987375,1486.14982879)
\curveto(2850.07487331,1487.34982874)(2858.37487294,1490.17482861)(2866.43737259,1488.01232871)
\curveto(2880.32487197,1484.26232887)(2892.64987142,1466.94982964)(2911.1123706,1476.04982924)
\curveto(2914.53737045,1477.74982916)(2918.64987027,1477.72482916)(2920.62487018,1480.14982906)
\curveto(2924.96236998,1485.44982882)(2927.74986986,1498.69982823)(2929.2248698,1505.86232791)
\curveto(2931.49986969,1516.91232742)(2927.52486987,1529.17482688)(2927.49986987,1541.16232634)
\curveto(2926.59986991,1544.76232618)(2925.71236995,1548.36232602)(2924.82486999,1551.94982586)
\closepath
\moveto(2721.63737902,1526.512327)
\curveto(2727.48737876,1507.18732785)(2710.31237953,1499.22482821)(2698.12488007,1508.81232778)
\curveto(2687.84988052,1516.89982742)(2681.5873808,1550.32482594)(2698.56238005,1552.38732585)
\curveto(2710.01237954,1547.11232608)(2713.2498794,1537.13732652)(2721.63737902,1526.512327)
\closepath
\moveto(2104.82490644,2864.63726752)
\curveto(2097.57490676,2861.39976766)(2093.46240694,2851.06226812)(2088.96240714,2843.21226847)
\curveto(2082.91240741,2832.66226894)(2076.72490769,2819.83726951)(2070.78740795,2809.73726996)
\curveto(2066.39990815,2802.27477029)(2064.04990825,2790.46227081)(2058.26240851,2783.49977112)
\curveto(2044.61240912,2767.08727185)(2005.04991087,2781.01227123)(1984.2749118,2775.69977147)
\curveto(1968.93741248,2771.77477164)(1958.11241296,2759.72477218)(1944.86241355,2750.92477257)
\curveto(1941.93741368,2748.97477266)(1934.774914,2750.72477258)(1934.03741403,2754.6997724)
\curveto(1932.66241409,2762.31227206)(1950.68741329,2775.33727148)(1954.84991311,2778.12477136)
\curveto(1956.02491305,2779.5122713)(1957.199913,2780.89977124)(1958.36241295,2782.28727118)
\curveto(1971.72491236,2795.3497706)(1993.2874114,2807.03727008)(1997.33741122,2831.43726899)
\curveto(1998.97491114,2835.7747688)(2000.61241107,2840.09976861)(2002.249911,2844.42476841)
\curveto(2002.74991098,2848.94976821)(2002.124911,2855.77476791)(2000.18741109,2859.41226775)
\curveto(1996.77491124,2865.78726746)(1981.33741193,2874.87476706)(1972.9874123,2871.97476719)
\curveto(1966.2249126,2869.64976729)(1941.98741368,2838.31226869)(1939.02491381,2828.36226913)
\curveto(1937.52491388,2823.34976935)(1927.9874143,2808.11227003)(1924.59991445,2807.34977006)
\curveto(1915.94991484,2805.38727015)(1883.73741627,2822.1997694)(1879.49991646,2811.84976986)
\curveto(1887.38741611,2799.56227041)(1895.38741575,2789.47477086)(1895.33741575,2773.56227156)
\curveto(1895.31241575,2764.59977196)(1891.86241591,2752.5122725)(1886.72491613,2744.87477284)
\curveto(1885.1624162,2742.44977295)(1883.59991627,2740.02477305)(1882.03741634,2737.61227316)
\curveto(1879.98741643,2731.51227343)(1872.66241676,2726.47477366)(1868.79991693,2722.28727384)
\curveto(1851.64991769,2703.62477467)(1823.28741895,2688.86227533)(1796.16242016,2693.31227513)
\curveto(1784.1124207,2678.3247758)(1785.96242061,2656.23727678)(1794.64992023,2644.17477732)
\curveto(1803.96241981,2640.62477747)(1813.2624194,2642.08727741)(1820.93741906,2641.96227741)
\curveto(1825.37491886,2641.88727742)(1830.82491862,2644.5622773)(1835.8124184,2643.74977733)
\curveto(1844.08741803,2642.38727739)(1847.51241788,2624.14977821)(1857.96241741,2622.1122783)
\curveto(1870.82491684,2625.46227815)(1879.77491644,2640.37477748)(1886.51241614,2654.87477684)
\curveto(1889.724916,2661.77477653)(1890.01241599,2669.88727617)(1894.93741577,2676.22477589)
\curveto(1904.84991533,2689.01227532)(1917.03741479,2695.03727505)(1929.14991425,2702.63727472)
\curveto(1932.19991411,2703.86227466)(1935.23741398,2705.07477461)(1938.28741384,2706.28727455)
\curveto(1942.08741367,2708.91227444)(1953.07491319,2715.49977414)(1957.39991299,2715.82477413)
\curveto(1957.324913,2715.63727414)(1957.249913,2715.44977415)(1957.187413,2715.26227416)
\curveto(1957.92491297,2698.74977489)(1938.52491383,2688.38727535)(1942.06241367,2674.51227597)
\curveto(1942.93741364,2671.04977612)(1945.58741352,2670.49977614)(1948.1874134,2667.66227627)
\curveto(1955.69991307,2659.46227664)(1978.06241207,2632.72477782)(1974.98741221,2621.67477832)
\curveto(1974.78741222,2621.42477833)(1974.57491223,2621.18727834)(1974.37491224,2620.93727835)
\curveto(1968.5249125,2620.84977835)(1959.31241291,2619.27477842)(1952.6999132,2623.33727824)
\curveto(1932.26241411,2635.89977768)(1924.03741448,2658.0372767)(1933.97491403,2684.67477551)
\lineto(1931.76241413,2689.06227532)
\curveto(1931.13741416,2689.4122753)(1930.51241419,2689.74977529)(1929.88741422,2690.09977527)
\curveto(1927.27491433,2688.57477534)(1924.06241447,2688.13727536)(1921.43741459,2686.52477543)
\curveto(1912.03741501,2680.74977569)(1894.46241579,2649.42477708)(1891.61241592,2636.79977764)
\curveto(1890.08741599,2630.03727794)(1884.01241626,2624.49977819)(1883.94991626,2617.4372785)
\curveto(1884.17491625,2610.13727883)(1902.69991542,2602.32477918)(1909.78741511,2596.98727941)
\curveto(1922.67491454,2587.28727984)(1952.48741321,2576.69978031)(1969.83741244,2574.8747804)
\curveto(1981.73741191,2573.63728045)(2000.93741106,2574.51228041)(2010.12491065,2567.03728074)
\curveto(2009.69991067,2550.68728147)(2009.78741066,2539.43728197)(2017.19991033,2526.91228253)
\curveto(2022.62491009,2517.71228294)(2037.02490945,2512.32478318)(2047.08740901,2507.83728338)
\curveto(2077.02490768,2494.47478397)(2119.2624058,2480.3622846)(2148.23740451,2483.38728446)
\curveto(2148.4124045,2483.84978444)(2148.58740449,2484.32478442)(2148.77490449,2484.7997844)
\curveto(2146.83740457,2493.94978399)(2136.07490505,2495.62478392)(2128.2624054,2502.24978362)
\curveto(2124.92490555,2505.0997835)(2121.4374057,2508.56228334)(2117.87490586,2512.32478318)
\curveto(2112.79990609,2517.67478294)(2108.86240626,2525.78728258)(2104.52490645,2531.58728232)
\curveto(2102.81240653,2533.31228224)(2101.08740661,2535.03728217)(2099.37490668,2536.76228209)
\curveto(2094.68740689,2543.87478177)(2090.53740707,2551.21228145)(2085.13740731,2557.97478115)
\curveto(2079.67490756,2564.83728084)(2076.79990769,2574.7247804)(2071.9749079,2582.01228008)
\curveto(2069.88740799,2585.17477994)(2067.27490811,2588.39977979)(2065.68740818,2591.82477964)
\curveto(2059.34990846,2605.49977903)(2068.91240804,2608.37477891)(2075.98740772,2617.29977851)
\curveto(2076.78740769,2619.14977843)(2077.59990765,2620.98727835)(2078.39990761,2622.83727826)
\curveto(2080.07490754,2624.68727818)(2081.73740747,2626.5247781)(2083.41240739,2628.36227802)
\curveto(2084.92490732,2632.09977785)(2086.44990726,2635.82477769)(2087.96240719,2639.54977752)
\curveto(2092.46240699,2647.99977715)(2098.77490671,2658.39977668)(2101.3124066,2667.0997763)
\lineto(2103.18740651,2678.01227581)
\curveto(2105.33740642,2686.88727542)(2110.81240617,2697.46227495)(2107.02490634,2704.32477464)
\curveto(2100.43740663,2716.27477411)(2075.28740775,2709.13727443)(2063.74990827,2716.19977411)
\curveto(2065.1374082,2719.49977397)(2065.06240821,2724.67477374)(2068.13740807,2727.7747736)
\curveto(2078.7124076,2738.46227312)(2107.83740631,2731.42477344)(2122.96240563,2734.4372733)
\curveto(2125.9124055,2735.68727325)(2128.84990537,2736.93727319)(2131.79990524,2738.18727314)
\curveto(2135.38740508,2739.78727307)(2151.64990436,2751.12477256)(2151.64990436,2756.49977232)
\curveto(2158.78740404,2765.31227193)(2171.69990347,2783.76227111)(2165.98740372,2794.32477064)
\curveto(2163.94990381,2795.1997706)(2161.9249039,2796.07477056)(2159.88740399,2796.96227052)
\curveto(2155.2624042,2797.4247705)(2150.21240442,2792.39977073)(2146.43740459,2790.43727081)
\curveto(2137.237405,2785.66227103)(2128.47490539,2780.23727127)(2118.12490585,2777.92477137)
\curveto(2111.63740614,2776.46227143)(2104.38740646,2772.7497716)(2098.62490672,2780.13727127)
\curveto(2094.28740691,2785.71227102)(2100.99990661,2795.82477057)(2102.63740654,2803.48727023)
\curveto(2106.47490637,2821.53726943)(2125.8749055,2856.78726786)(2104.82490644,2864.63726752)
\closepath
\moveto(1991.34991148,2754.29977242)
\curveto(1993.58741138,2752.26227251)(1995.82491128,2750.2247726)(1998.07491118,2748.19977269)
\curveto(1998.98741114,2745.7997728)(1999.9124111,2743.4122729)(2000.83741106,2741.01227301)
\curveto(2003.93741092,2737.27477318)(2012.03741056,2734.94977328)(2011.74991058,2729.77477351)
\curveto(2011.1749106,2728.81227355)(2010.58741063,2727.8497736)(2010.01241065,2726.87477364)
\curveto(2009.68741067,2725.18727371)(2009.27491069,2721.71227387)(2007.22491078,2719.54977396)
\curveto(2001.83741102,2713.84977422)(1993.47491139,2709.27477442)(1985.19991176,2715.94977412)
\curveto(1983.24991184,2718.18727403)(1981.31241193,2720.43727393)(1979.36241202,2722.67477383)
\curveto(1975.68741218,2725.67477369)(1970.07491243,2723.81227378)(1968.88741248,2728.26227358)
\curveto(1969.33741246,2733.22477336)(1987.61241165,2752.64977249)(1991.34991148,2754.29977242)
\closepath
\moveto(2052.81240875,2670.31227615)
\curveto(2054.96240866,2669.53727619)(2056.1249086,2668.61227623)(2056.39990859,2667.0122763)
\curveto(2057.77490853,2654.24977687)(2034.31240957,2635.16227772)(2024.87490999,2640.86227746)
\curveto(2025.26240998,2644.92477728)(2025.82490995,2644.23727731)(2021.77491013,2644.6247773)
\curveto(2021.11241016,2663.31227646)(2039.67490934,2669.59977618)(2052.81240875,2670.31227615)
\closepath
\moveto(694.36246914,2197.79979716)
\curveto(698.67496894,2224.49979597)(682.94996964,2241.67479521)(657.73747076,2263.82479422)
\curveto(646.88747125,2273.3747938)(629.76247201,2275.71229369)(623.96247226,2287.79979316)
\curveto(619.39997247,2297.33729273)(624.12497226,2310.28729216)(626.89997213,2321.78729165)
\curveto(628.22497208,2327.3372914)(632.67497188,2331.7747912)(632.32497189,2336.287291)
\curveto(631.91247191,2341.68729076)(626.99997213,2348.59979045)(619.32497247,2348.11229048)
\curveto(614.46247269,2347.79979049)(610.84997285,2343.37479069)(606.58747304,2340.51229081)
\curveto(601.91247324,2337.36229095)(594.59997357,2335.13729105)(590.24997376,2331.7997912)
\curveto(587.31247389,2328.18729136)(584.38747402,2324.57479152)(581.46247415,2320.96229168)
\curveto(574.37497447,2314.21229198)(566.26247483,2304.58729241)(560.1124751,2297.13729274)
\curveto(558.38747518,2293.6497929)(556.66247526,2290.16229305)(554.92497533,2286.66229321)
\curveto(549.0124756,2276.23729367)(540.99997595,2264.07479421)(530.21247643,2265.76229414)
\curveto(517.68747699,2267.72479405)(503.77497761,2285.82479324)(497.88747787,2293.14979292)
\curveto(478.04997875,2317.76229182)(445.17498021,2367.09978963)(403.62498206,2359.83728995)
\curveto(394.32498247,2358.21229003)(382.88748298,2350.72479036)(375.58748331,2343.34979069)
\curveto(371.2749835,2338.98729088)(369.14998359,2333.59979112)(364.3499838,2330.03729128)
\curveto(364.21248381,2326.27479145)(366.38748371,2324.04979154)(366.96248369,2320.71229169)
\curveto(369.07498359,2308.57479223)(373.88748338,2297.36229273)(377.8999832,2285.78729325)
\curveto(378.44998318,2285.62479325)(378.98748315,2285.46229326)(379.53748313,2285.29979327)
\curveto(392.26248256,2285.39979326)(404.57498202,2302.93729248)(418.74998139,2300.76229258)
\curveto(425.0999811,2299.78729262)(434.71248068,2290.57479303)(440.49998042,2286.18729323)
\curveto(462.58747944,2269.43729397)(480.63747864,2250.22479483)(500.61247775,2234.22479554)
\curveto(511.59997726,2225.42479593)(531.91247636,2219.49979619)(533.1124763,2207.13729674)
\curveto(533.78747627,2200.09979705)(528.21247652,2192.3372974)(523.92497671,2186.29979767)
\curveto(522.14997679,2182.46229784)(520.36247687,2178.62479801)(518.57497695,2174.78729818)
\curveto(510.5874773,2163.1622987)(499.68747779,2141.39979966)(506.73747748,2131.16230012)
\curveto(511.39997727,2124.41230042)(524.64997668,2126.93730031)(530.47497642,2124.59980041)
\curveto(531.52497637,2124.17480043)(550.84997551,2127.84980027)(554.31247536,2128.19980025)
\curveto(566.9249748,2129.4373002)(580.53747419,2125.26230038)(594.0124736,2120.3498006)
\curveto(604.22497314,2114.92480084)(614.44997269,2109.48730108)(624.67497223,2104.06230132)
\curveto(627.46247211,2103.09980137)(630.87497196,2098.86230155)(633.53747184,2100.1123015)
\curveto(642.31247145,2105.42480126)(645.6874713,2117.54980072)(653.58747095,2125.74980036)
\curveto(675.18746999,2151.07479923)(690.53746931,2174.14979821)(694.36246914,2197.79979716)
\closepath
\moveto(592.22497368,2230.17479572)
\curveto(612.46247278,2232.9247956)(631.32497194,2206.37479678)(638.08747164,2194.09979732)
\curveto(641.71247148,2187.53729761)(643.02497142,2178.39979802)(642.58747144,2170.53729837)
\curveto(626.22497216,2156.44979899)(606.74997303,2148.12479936)(585.76247396,2149.6747993)
\curveto(574.82497445,2150.48729926)(560.59997508,2157.88729893)(559.33747514,2168.24979847)
\curveto(558.39997518,2176.02479812)(564.86247489,2187.8122976)(566.57497482,2195.41229726)
\curveto(568.67497472,2204.72479685)(583.62497406,2229.01229577)(592.22497368,2230.17479572)
\closepath
\moveto(2589.78738488,2112.33730096)
\curveto(2586.62488502,2115.64980081)(2583.47488516,2118.97480066)(2580.3248853,2122.29980051)
\curveto(2574.97488554,2126.56230032)(2568.62488582,2130.64980014)(2563.03738607,2132.39980006)
\curveto(2540.42488708,2119.14980065)(2556.54988636,2103.26230136)(2559.08738625,2086.34980211)
\curveto(2560.1248862,2079.41230242)(2556.99988634,2070.9248028)(2556.31238637,2063.96230311)
\curveto(2555.29988642,2053.81230356)(2559.58738623,2040.34980416)(2563.87488603,2030.14980461)
\curveto(2567.28738588,2022.02480497)(2587.43738499,2000.91230591)(2593.78738471,2002.09980586)
\curveto(2602.21238433,2005.17480572)(2609.09988402,2018.84980511)(2611.44988392,2023.5123049)
\curveto(2621.98738345,2044.38730398)(2620.23738353,2063.59980312)(2610.02488398,2085.48730215)
\curveto(2607.11238411,2091.72480187)(2600.7498844,2098.26230158)(2597.84988452,2102.92480137)
\curveto(2595.56238463,2106.61230121)(2591.03738483,2109.51230108)(2589.78738488,2112.33730096)
\closepath
\moveto(2748.63737782,2340.16229083)
\curveto(2734.14987847,2347.32479051)(2719.66237911,2346.68729054)(2704.73737977,2339.73729085)
\curveto(2697.72488009,2333.68729112)(2690.6998804,2327.63729139)(2683.67488071,2321.57479165)
\curveto(2666.73738146,2307.74979227)(2647.06238234,2288.61229312)(2629.62488311,2278.97479355)
\curveto(2623.62488338,2275.6622937)(2618.98738359,2270.17479394)(2612.74988386,2268.66229401)
\curveto(2603.93738425,2266.5372941)(2596.52488458,2263.38729424)(2586.67488502,2269.01229399)
\curveto(2581.27488526,2272.09979385)(2578.1873854,2277.18729363)(2574.26238557,2281.72479343)
\lineto(2561.17488615,2295.18729283)
\curveto(2550.82488662,2314.94979195)(2537.23738722,2321.61229165)(2518.63738805,2317.22479185)
\curveto(2515.59988818,2316.51229188)(2502.13738878,2310.97479213)(2499.61238889,2306.78729231)
\curveto(2491.13738927,2292.64979294)(2501.7623888,2272.91229382)(2510.23738842,2258.11229448)
\curveto(2515.29988819,2249.28729487)(2526.57488769,2237.3622954)(2519.96238799,2229.41229575)
\curveto(2513.72488826,2221.92479608)(2502.38738877,2225.64979592)(2496.11238905,2226.79979587)
\curveto(2480.31238975,2229.72479574)(2464.31239046,2232.04979563)(2451.64989102,2215.02479639)
\curveto(2447.54989121,2209.49979664)(2441.37489148,2204.98729684)(2442.06239145,2198.66229712)
\curveto(2442.88739141,2191.18729745)(2473.08739007,2172.88729826)(2478.52488983,2168.86229844)
\curveto(2507.99988852,2147.09979941)(2552.28738655,2142.26229963)(2584.37488512,2156.237299)
\curveto(2594.49988467,2160.64979881)(2604.08738425,2167.6622985)(2613.43738383,2173.04979826)
\curveto(2619.72488355,2176.69979809)(2625.18738331,2186.11229768)(2632.39988299,2187.06229763)
\curveto(2634.83738288,2187.37479762)(2643.63738249,2184.64979774)(2645.99988238,2184.01229777)
\curveto(2667.27488144,2178.26229803)(2686.58738058,2161.04979879)(2707.12487967,2149.42479931)
\curveto(2716.16237927,2144.31229953)(2722.84987897,2134.99979995)(2732.37487855,2132.51230006)
\curveto(2739.42487823,2130.67480014)(2750.94987772,2132.94980004)(2757.49987743,2141.69979965)
\curveto(2756.64987747,2145.89979946)(2756.73737746,2151.01229924)(2755.08737754,2155.33729904)
\curveto(2750.23737775,2168.06229848)(2732.34987855,2193.38729735)(2718.61237916,2199.1247971)
\curveto(2706.87487968,2204.03729688)(2695.2373802,2203.41229691)(2683.64988071,2206.79979676)
\curveto(2680.17488087,2207.81229671)(2674.17488113,2208.1247967)(2672.37488121,2213.76229645)
\curveto(2679.72488089,2219.86229618)(2689.86238043,2233.37479558)(2697.2873801,2237.66229538)
\curveto(2701.48737992,2240.08729528)(2745.46237796,2267.38729406)(2749.68737778,2275.6122937)
\curveto(2750.91237772,2279.21229354)(2749.1748778,2284.6372933)(2750.09987776,2288.62479312)
\curveto(2754.11237758,2305.83729235)(2765.38737708,2321.96229164)(2748.63737782,2340.16229083)
\closepath
}
}
{
\newrgbcolor{curcolor}{0 0.33725491 0.62352943}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(907.74995965,1676.54982033)
\lineto(989.67495601,1676.54982033)
\lineto(989.67495601,1503.974828)
\curveto(989.67495601,1440.54983082)(940.19995821,1419.04983177)(851.57496215,1419.04983177)
\curveto(760.58746619,1419.04983177)(711.69996836,1439.17483088)(711.69996836,1502.54982806)
\lineto(711.69996836,1676.54982033)
\lineto(793.62496472,1676.54982033)
\lineto(793.62496472,1517.5248274)
\curveto(793.62496472,1479.04982911)(818.69996361,1473.37482936)(845.34996242,1472.11232941)
\curveto(875.53746108,1470.67482948)(907.74995965,1478.57482913)(907.74995965,1517.5248274)
\lineto(907.74995965,1676.54982033)
\closepath
}
}
{
\newrgbcolor{curcolor}{0 0.33725491 0.62352943}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(1756.09992194,1597.87482382)
\lineto(1691.21242483,1597.87482382)
\curveto(1653.91242648,1663.6123209)(1560.43743064,1605.71232348)(1623.86242782,1584.9623244)
\curveto(1632.48742744,1582.13732452)(1646.18742683,1581.24982456)(1659.54992623,1578.1498247)
\curveto(1728.83742315,1562.13732541)(1763.51242161,1534.93732662)(1763.51242161,1496.47482833)
\curveto(1761.5499217,1439.19983088)(1718.97492359,1408.37483225)(1635.79992729,1409.14983221)
\curveto(1540.12493154,1410.04983217)(1521.51243237,1450.33733038)(1512.64993276,1503.887328)
\lineto(1589.96242933,1503.887328)
\curveto(1592.93742919,1494.51232842)(1607.87492853,1476.8623292)(1615.02492821,1472.4998294)
\curveto(1621.76242791,1468.37482958)(1630.34992753,1466.91232964)(1640.29992709,1466.91232964)
\curveto(1666.01242595,1466.91232964)(1678.87492537,1472.97482938)(1678.87492537,1485.17482883)
\curveto(1678.87492537,1495.51232837)(1661.58742614,1504.47482798)(1626.92492768,1511.98732764)
\curveto(1556.61243081,1527.91232693)(1521.52493237,1556.09982568)(1521.52493237,1596.48732389)
\curveto(1523.48743228,1650.0373215)(1562.57493054,1677.68732028)(1638.77492716,1679.61232019)
\curveto(1708.07492408,1678.64982023)(1747.16242234,1651.42482144)(1756.09992194,1597.87482382)
\closepath
}
}
{
\newrgbcolor{curcolor}{0 0.33725491 0.62352943}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(1796.26242016,1610.23732327)
\lineto(1796.26242016,1676.54982033)
\lineto(2068.38740806,1676.54982033)
\lineto(2068.38740806,1610.23732327)
\lineto(1968.62491249,1610.23732327)
\lineto(1968.62491249,1403.22483248)
\lineto(1896.03741572,1403.22483248)
\lineto(1896.03741572,1610.23732327)
\lineto(1796.26242016,1610.23732327)
\closepath
}
}
{
\newrgbcolor{curcolor}{0 0.33725491 0.62352943}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(2227.78740097,1675.98732035)
\curveto(2292.01239812,1675.98732035)(2346.81239568,1635.24982216)(2366.56239481,1578.87482467)
\lineto(2287.47489832,1578.87482467)
\curveto(2273.49989894,1596.0873239)(2251.9248999,1607.14982341)(2227.78740097,1607.14982341)
\curveto(2185.81240284,1607.14982341)(2151.57490436,1573.6998249)(2151.57490436,1532.67482672)
\curveto(2151.57490436,1491.63732855)(2185.81240284,1458.18733003)(2227.78740097,1458.18733003)
\curveto(2253.63739983,1458.18733003)(2276.56239881,1470.88732947)(2290.34989819,1490.23732861)
\lineto(2367.82489475,1490.23732861)
\curveto(2349.24989558,1431.9123312)(2293.43739806,1389.34983309)(2227.78740097,1389.34983309)
\curveto(2147.02490456,1389.34983309)(2081.16240749,1453.73733023)(2081.16240749,1532.67482672)
\curveto(2081.16240749,1611.59982321)(2147.02490456,1675.98732035)(2227.78740097,1675.98732035)
\closepath
}
}
{
\newrgbcolor{curcolor}{1 1 1}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(1649.76242667,365.78737859)
\lineto(1590.37492931,278.87488245)
\curveto(1590.37492931,278.87488245)(1621.52492792,294.81238175)(1643.24992696,286.12488213)
\curveto(1664.97492599,277.42488252)(1678.01242541,256.42488345)(1670.77492573,240.49988416)
\curveto(1663.52492606,224.56238487)(1642.52492699,210.07488551)(1620.79992795,216.58738522)
\curveto(1599.07492892,223.11238493)(1591.09992928,233.24988448)(1599.07492892,234.69988442)
\curveto(1607.03742857,236.14988435)(1605.58742863,230.34988461)(1612.11242834,226.0123848)
\curveto(1618.62492805,221.662385)(1632.38742744,246.2873839)(1625.14992776,253.52488358)
\curveto(1617.89992808,260.77488326)(1600.52492886,278.87488245)(1580.23742976,263.67488313)
\curveto(1559.96243066,248.46238381)(1568.58743028,219.48738509)(1572.27493011,204.99988574)
\curveto(1575.96242995,190.52488638)(1630.17492754,157.92488783)(1673.6749256,189.79988641)
\curveto(1717.16242367,221.662385)(1715.67492374,246.2873839)(1711.32492393,266.562383)
\curveto(1706.98742412,286.8498821)(1683.81242515,308.57488113)(1670.04992577,307.1248812)
\curveto(1656.28742638,305.67488126)(1650.48742664,312.92488094)(1650.48742664,312.92488094)
\lineto(1665.69992596,335.37487994)
\lineto(1720.74992351,333.19988004)
\lineto(1716.39992371,309.2998811)
\lineto(1740.29992264,304.22488133)
\curveto(1740.29992264,304.22488133)(1747.53742232,331.7498801)(1761.29992171,338.98737978)
\curveto(1775.0624211,346.23737946)(1783.74992071,363.61237869)(1783.74992071,363.61237869)
\curveto(1783.74992071,363.61237869)(1648.32492673,365.06237862)(1649.76242667,365.78737859)
\closepath
}
}
{
\newrgbcolor{curcolor}{1 1 1}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(1442.0999359,302.99988138)
\curveto(1440.29993598,301.13738146)(1438.24993607,299.26238155)(1435.96243617,297.83738161)
\curveto(1428.6624365,293.27488181)(1420.92493684,313.51238091)(1425.93743662,328.84988023)
\curveto(1431.76243636,346.69987944)(1479.96243422,361.67487877)(1492.04993368,330.21238017)
\curveto(1497.73743343,315.43738083)(1496.1624335,303.76238135)(1492.04993368,297.38738163)
\curveto(1487.94993386,290.99988191)(1487.93743386,293.73738179)(1478.36243429,304.23738133)
\curveto(1465.44993486,318.3748807)(1451.57493548,312.88738094)(1442.0999359,302.99988138)
\closepath
\moveto(1452.83743542,260.89988325)
\curveto(1453.13743541,260.89988325)(1448.33743562,254.02488356)(1441.27493593,246.07488391)
\curveto(1430.7624364,234.22488444)(1371.84993902,197.01238609)(1359.82493956,210.69988548)
\curveto(1357.77493965,213.03738538)(1360.72493952,222.82488494)(1358.8999396,226.69988477)
\curveto(1349.52494001,246.59988389)(1318.3749414,231.06238458)(1325.1499411,210.73738548)
\curveto(1339.57494046,167.47488741)(1422.53743677,186.18738657)(1450.27493553,203.6998858)
\curveto(1499.21243336,234.61238442)(1547.44993122,292.79988183)(1520.32493242,345.72487948)
\curveto(1512.61243276,360.78737881)(1476.69993436,393.76237735)(1425.47493664,368.98737845)
\curveto(1396.57493792,355.01237907)(1372.52493899,289.38738199)(1417.73743698,266.83738299)
\curveto(1430.51243641,257.73738339)(1452.83743542,260.89988325)(1452.83743542,260.89988325)
\closepath
}
}
{
\newrgbcolor{curcolor}{1 1 1}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(1171.04994795,184.17488666)
\lineto(1226.34994549,184.76238664)
\lineto(1354.4249398,372.79987828)
\curveto(1354.4249398,372.79987828)(1350.34993998,380.37487794)(1335.21244065,378.03737805)
\curveto(1320.08744132,375.71237815)(1305.52494197,367.56237851)(1290.38744264,368.72487846)
\curveto(1275.24994331,369.88737841)(1267.09994368,372.2248783)(1263.61244383,375.13737817)
\curveto(1260.12494399,378.03737805)(1256.62494414,371.63737833)(1260.12494399,361.1623788)
\curveto(1263.61244383,350.67487926)(1269.43744357,343.1123796)(1275.83744329,341.94987965)
\curveto(1282.237443,340.7873797)(1283.39994295,339.03737978)(1283.39994295,339.03737978)
\lineto(1171.04994795,184.17488666)
\closepath
}
}
{
\newrgbcolor{curcolor}{1 1 1}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(1873.23741673,254.44988354)
\curveto(1875.03741665,256.32488346)(1877.08741656,258.18738337)(1879.37491646,259.61238331)
\curveto(1886.66241614,264.17488311)(1894.41241579,243.93738401)(1889.39991602,228.59988469)
\curveto(1883.57491627,210.76238548)(1833.76241849,194.17488622)(1821.67491903,225.63738482)
\curveto(1815.99991928,240.41238416)(1817.57491921,252.07488364)(1821.67491903,258.46238336)
\curveto(1825.77491884,264.84988308)(1825.78741884,262.0998832)(1835.36241842,251.61238367)
\curveto(1848.27491784,237.47488429)(1863.76241716,244.56238398)(1873.23741673,254.44988354)
\closepath
\moveto(1854.46241757,292.79988183)
\curveto(1854.16241758,292.79988183)(1858.96241737,299.68738153)(1866.02491705,307.63738117)
\curveto(1876.53741659,319.48738065)(1935.46241397,356.69987899)(1947.48741343,342.9998796)
\curveto(1948.51241339,341.83737965)(1955.39991308,330.17488017)(1941.78741369,330.66238015)
\curveto(1933.43741406,330.94988014)(1929.18741425,316.67488077)(1929.87491422,314.64988086)
\curveto(1939.62491378,285.86238214)(1986.04991172,298.24988159)(1978.34991206,339.64987975)
\curveto(1970.02491243,384.47487776)(1901.39991548,371.79987832)(1865.58741707,350.94987925)
\curveto(1815.5624193,321.83738054)(1759.84992177,260.91238325)(1786.97492057,207.9873856)
\curveto(1794.69992023,192.92488627)(1828.9124187,163.78738757)(1881.83741635,184.72488664)
\curveto(1917.14991478,198.68738602)(1940.67491374,265.92488303)(1895.46241575,288.47488203)
\curveto(1882.68741631,297.57488162)(1854.46241757,292.79988183)(1854.46241757,292.79988183)
\closepath
}
}
{
\newrgbcolor{curcolor}{0 0.33725491 0.62352943}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(1401.4999377,1746.67481721)
\curveto(1644.18742692,1974.47480708)(1867.02491701,2114.99980084)(2028.62490983,2137.68729983)
\curveto(2198.66240227,2161.57479877)(2229.32490091,2049.83730373)(2179.33740313,1876.16231145)
\curveto(2168.17490362,1837.34981318)(2150.7374044,1795.68731503)(2128.2999054,1752.28731696)
\lineto(2202.69990209,1752.28731696)
\curveto(2220.63740129,1797.29981496)(2233.63740071,1841.21231301)(2241.08740038,1883.42481113)
\curveto(2273.48739894,2067.09980297)(2205.14990198,2185.22479772)(2009.69991067,2178.61229801)
\curveto(1825.97491883,2172.38729829)(1594.28742913,2045.91230391)(1343.44994028,1810.28731438)
\curveto(1334.92494066,1802.27481474)(1326.54994103,1794.1873151)(1318.2999414,1786.04981546)
\curveto(1348.67494005,1778.19981581)(1376.8124388,1764.67481641)(1401.4999377,1746.67481721)
\closepath
\moveto(1049.61245334,1415.73733192)
\curveto(1001.1124555,1316.38733634)(971.9624568,1221.39984056)(962.9124572,1141.19984412)
\curveto(943.79995805,971.61235166)(1016.46245482,880.8373557)(1193.19994696,894.87485507)
\curveto(1359.29993958,908.06235449)(1592.34992922,1017.68734961)(1814.73741933,1225.99984035)
\curveto(1861.21241727,1269.53733842)(1904.99991532,1314.27483643)(1945.56241352,1359.61233441)
\lineto(1834.39991846,1359.61233441)
\curveto(1628.8124276,1144.46234398)(1379.44993868,961.89985209)(1212.94994608,935.76235325)
\curveto(950.94995773,894.61235508)(966.89995702,1078.33734692)(1033.08745408,1232.43734007)
\curveto(1051.83745325,1276.08733813)(1072.47495233,1319.14983621)(1095.97495128,1362.06233431)
\curveto(1078.07495208,1377.61233361)(1062.43745277,1395.68733281)(1049.61245334,1415.73733192)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.9137255 0.32549021 0.15686275}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(1674.68742556,1084.09984666)
\curveto(1794.14992025,998.74985045)(1916.87491479,940.14985306)(2010.58741063,922.39985385)
\curveto(2225.21240109,870.88735614)(2215.57490152,1082.79984672)(2159.774904,1232.43734007)
\curveto(2143.58740472,1275.87483814)(2124.37490557,1317.97483627)(2101.84990657,1359.61233441)
\lineto(2172.01240345,1359.61233441)
\curveto(2202.67490209,1281.0998379)(2221.19990127,1206.56234122)(2228.41240095,1141.19984412)
\curveto(2247.11240012,971.61235166)(2158.22490407,867.47485629)(1985.36241175,881.51235567)
\curveto(1878.76241649,890.16235528)(1744.37492246,942.53735295)(1604.72492867,1038.09984871)
\curveto(1627.93742764,1052.73734806)(1651.2749266,1068.06234737)(1674.68742556,1084.09984666)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.9137255 0.32549021 0.15686275}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(1794.03742025,1752.28731696)
\curveto(1735.46242286,1812.1748143)(1677.13742545,1866.41231189)(1620.09992799,1914.07480977)
\curveto(1642.79992698,1931.72480898)(1665.28742598,1948.66230823)(1687.49992499,1964.87480751)
\curveto(1747.21242234,1918.06230959)(1808.41241962,1864.54981197)(1870.46241686,1804.94981462)
\curveto(1888.46241606,1787.67481539)(1905.72491529,1770.09981617)(1922.28741455,1752.28731696)
\lineto(1794.03742025,1752.28731696)
\closepath
}
}
{
\newrgbcolor{curcolor}{0 0.33725491 0.62352943}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(1349.08744003,1347.13733497)
\lineto(1349.23744003,1347.21233497)
\lineto(1349.08744003,1347.13733497)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.9137255 0.32549021 0.15686275}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(1363.47493939,1354.98733462)
\curveto(1429.74993645,1290.88733747)(1499.89993333,1228.14984026)(1568.23743029,1168.36234292)
\curveto(1573.18743007,1164.02484311)(1578.16242985,1159.7373433)(1583.16242963,1155.49984349)
\curveto(1560.26243065,1138.14984426)(1537.43743166,1121.387345)(1514.71243267,1105.26234572)
\curveto(1471.01243461,1140.62484415)(1427.27493656,1180.13734239)(1384.16243847,1223.77484045)
\curveto(1350.26243998,1258.08733893)(1318.04994141,1292.62483739)(1287.64994276,1327.26233585)
\curveto(1287.67494276,1327.26233585)(1287.69994276,1327.26233585)(1287.72494276,1327.27483585)
\curveto(1276.12494328,1325.34983594)(1264.2374438,1324.34983598)(1252.11244434,1324.34983598)
\curveto(1131.74994969,1324.34983598)(1033.58745406,1422.51233162)(1033.58745406,1542.86232627)
\curveto(1033.58745406,1581.92482453)(1043.9374536,1618.6498229)(1062.01245279,1650.43732149)
\curveto(1022.89995453,1726.5248181)(993.09995586,1797.64981494)(978.31245651,1883.42481113)
\curveto(946.61245792,2067.09980297)(1022.34995456,2194.12479732)(1213.51244606,2187.51229761)
\curveto(1324.06244114,2183.68729778)(1454.38743535,2128.93730022)(1595.44992908,2032.5123045)
\curveto(1573.72493005,2017.31230518)(1551.82493102,2001.43730589)(1529.737432,1984.81230662)
\curveto(1400.56243774,2078.87480244)(1281.52494304,2134.06229999)(1186.09994728,2137.68729983)
\curveto(1073.1874523,2141.99979964)(996.38745571,2016.58730521)(1028.0124543,1838.78731311)
\curveto(1036.82495391,1789.24981532)(1057.58745299,1738.04981759)(1087.23745167,1686.01231991)
\lineto(1087.23745167,1686.02481991)
\curveto(1101.84995102,1660.17482105)(1117.16245034,1636.46232211)(1133.08744963,1614.56232308)
\curveto(1098.17495119,1549.012326)(1113.6249505,1463.18732981)(1175.87494773,1416.2123319)
\curveto(1227.37494544,1377.33733363)(1300.2374422,1390.78733303)(1359.79993956,1453.14983026)
\lineto(1317.79994142,1484.47482886)
\curveto(1248.28744451,1418.88733178)(1168.01244808,1452.49983029)(1170.94994795,1538.32482647)
\lineto(1384.76243845,1538.32482647)
\curveto(1384.87493844,1539.8373264)(1384.97493844,1541.34982634)(1385.03743843,1542.86232627)
\curveto(1388.74993827,1625.2998226)(1348.03744008,1692.54981962)(1265.59994374,1692.54981962)
\curveto(1223.7374456,1692.54981962)(1183.79994738,1676.38732033)(1156.54994859,1647.33732162)
\curveto(1150.91244884,1641.33732189)(1145.86244907,1634.97482217)(1141.38744926,1628.34982247)
\lineto(1100.0249511,1699.51231931)
\curveto(1139.41244935,1737.76231761)(1193.08744697,1761.38731656)(1252.11244434,1761.38731656)
\curveto(1372.46243899,1761.38731656)(1470.62493463,1663.22482092)(1470.62493463,1542.86232627)
\curveto(1470.62493463,1463.13732981)(1427.53743655,1393.14983292)(1363.47493939,1354.98733462)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.9137255 0.32549021 0.15686275}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(1266.01244373,1648.14982159)
\curveto(1301.18744216,1648.14982159)(1329.73744089,1618.31232292)(1331.46244082,1581.73732454)
\curveto(1331.38744082,1581.26232456)(1331.31244082,1580.77482458)(1331.22494083,1580.2998246)
\lineto(1180.43744753,1580.2998246)
\curveto(1180.48744753,1580.77482458)(1180.54994752,1581.26232456)(1180.62494752,1581.73732454)
\curveto(1186.11244728,1618.31232292)(1224.47494557,1648.14982159)(1266.01244373,1648.14982159)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(3504.9646298,879.82905532)
\lineto(3539.62223716,879.82905532)
\lineto(3539.62223716,717.94674983)
\curveto(3539.62218353,699.8535659)(3540.40629151,686.50673037)(3541.97456345,677.90620319)
\curveto(3543.54272343,669.30555809)(3547.1234832,662.48879722)(3552.71685352,657.45590014)
\curveto(3558.31009038,652.42292603)(3565.86366391,649.90645823)(3575.37759679,649.9064892)
\curveto(3584.36861223,649.90645823)(3591.37331018,651.97696971)(3596.39171166,656.11802984)
\curveto(3601.40989232,660.25901563)(3604.96451516,666.12015581)(3607.05559084,673.70146798)
\curveto(3609.14642439,681.28267064)(3610.19190169,696.28591536)(3610.1920259,718.71124714)
\lineto(3610.1920259,879.82905532)
\lineto(3642.0268417,879.82905532)
\lineto(3642.0268417,720.81361474)
\curveto(3642.02668567,695.33029467)(3640.53688051,675.70821666)(3637.55742175,661.94732184)
\curveto(3634.57765986,648.18634101)(3627.67750964,636.78260086)(3616.85695039,627.73606719)
\curveto(3606.0361294,618.68951594)(3591.53013178,614.16624471)(3573.338914,614.16623993)
\curveto(3559.22488302,614.16624471)(3546.9666616,617.00125274)(3536.56421298,622.67127251)
\curveto(3526.16166321,628.34128483)(3518.29444648,637.51524338)(3512.96253919,650.19317569)
\curveto(3507.63057796,662.87104549)(3504.96461083,685.45554762)(3504.9646298,717.94674983)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(3695.13760153,811.97991901)
\lineto(3725.40419981,811.97991901)
\lineto(3725.40419981,782.1645239)
\curveto(3732.72249139,805.09925706)(3745.79095772,816.56670525)(3764.60963799,816.56690288)
\curveto(3775.27341775,816.56670525)(3783.8724686,813.44501102)(3790.40681632,807.20181082)
\curveto(3796.94093492,800.95823411)(3801.07057028,793.47253876)(3802.79573479,784.74470233)
\curveto(3804.52064539,776.01653429)(3805.38316417,762.22374244)(3805.38329371,743.3662854)
\lineto(3805.38329371,618.94434812)
\lineto(3772.76436913,618.94434812)
\lineto(3772.76436913,741.2639178)
\curveto(3772.76427222,758.08271949)(3771.56197332,769.51831365)(3769.15746882,775.5707346)
\curveto(3766.75277771,781.6228423)(3761.62993891,784.64897446)(3753.78893705,784.64914016)
\curveto(3745.63413612,784.64897446)(3739.28286149,780.79463771)(3734.73509409,773.08611834)
\curveto(3730.18720893,765.3772907)(3727.91329578,750.05550575)(3727.91334785,727.12071755)
\lineto(3727.91334785,618.94434812)
\lineto(3695.13760153,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(3891.42664786,837.97282757)
\lineto(3857.23950576,837.97282757)
\lineto(3857.23950576,880.21130397)
\lineto(3891.42664786,880.21130397)
\closepath
\moveto(3858.02361452,811.97991901)
\lineto(3890.64253909,811.97991901)
\lineto(3890.64253909,618.94434812)
\lineto(3858.02361452,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(3923.36646532,811.97991901)
\lineto(3955.51492463,811.97991901)
\lineto(3985.1542359,673.41478149)
\lineto(4014.16626016,811.97991901)
\lineto(4042.55099741,811.97991901)
\lineto(3997.69997612,618.94434812)
\lineto(3968.68795186,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(4189.12753266,709.53727941)
\lineto(4099.58231185,709.53727941)
\curveto(4099.58226699,683.41689017)(4102.48346652,665.99273972)(4108.28591912,657.26477581)
\curveto(4114.08826462,648.53673526)(4121.38046883,644.17273414)(4130.16255363,644.17275937)
\curveto(4144.79916049,644.17273414)(4154.05163465,656.21355474)(4157.92000387,680.29525729)
\lineto(4187.71613689,675.5171491)
\curveto(4179.87492411,634.61652731)(4160.32449848,614.16624471)(4129.06480136,614.16623993)
\curveto(4109.93249233,614.16624471)(4094.66852366,622.51199867)(4083.27284956,639.20352685)
\curveto(4071.87711838,655.89501451)(4066.17926706,680.35890398)(4066.17927851,712.59526865)
\curveto(4066.17926706,745.72335866)(4071.92939225,771.33399295)(4083.42967131,789.42724835)
\curveto(4094.92989298,807.52016279)(4110.29840938,816.56670525)(4129.53526662,816.56690288)
\curveto(4143.02184907,816.56670525)(4154.36527784,812.04343402)(4163.56558697,802.99707561)
\curveto(4172.76567843,793.9503491)(4179.24763772,782.06879862)(4183.01148431,767.35238851)
\curveto(4186.77507433,752.6356816)(4188.81375508,733.36399783)(4189.12753266,709.53727941)
\closepath
\moveto(4155.72449933,736.48580961)
\curveto(4155.72439834,770.50578836)(4146.62874577,787.51583651)(4128.43751435,787.51600508)
\curveto(4111.39616055,787.51583651)(4102.03913866,770.50578836)(4100.36642061,736.48580961)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(4231.2607706,811.97991901)
\lineto(4260.11597311,811.97991901)
\lineto(4260.11597311,768.78582097)
\curveto(4268.89793433,800.25744561)(4282.07094839,815.99333284)(4299.6350548,815.99352989)
\curveto(4301.30773083,815.99333284)(4303.29413771,815.80220871)(4305.5942814,815.42015691)
\lineto(4305.5942814,773.94617782)
\curveto(4302.87594679,774.32827109)(4300.68044444,774.51939522)(4299.00776779,774.5195508)
\curveto(4275.69353682,774.51939522)(4264.03646486,755.40698158)(4264.03651693,717.18225252)
\lineto(4264.03651693,618.94434812)
\lineto(4231.2607706,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(4429.27486701,766.8745777)
\lineto(4403.71292131,758.46510728)
\curveto(4399.00818436,777.83221359)(4390.06935339,787.51583651)(4376.89640159,787.51600508)
\curveto(4370.83257096,787.51583651)(4365.94496455,785.22234687)(4362.23356771,780.63552928)
\curveto(4358.52207568,776.04838832)(4356.66635346,770.37837227)(4356.66639549,763.62546413)
\curveto(4356.66635346,755.98035399)(4358.54821261,750.37404598)(4362.31197859,746.8065233)
\curveto(4366.07564922,743.23874489)(4374.70083699,738.7791817)(4388.18756779,733.42782036)
\curveto(4404.81058341,726.67465306)(4416.78129857,719.06154162)(4424.09974917,710.58846321)
\curveto(4431.41798085,702.11520152)(4435.07715142,690.29735908)(4435.07727186,675.13490044)
\curveto(4435.07715142,658.06108806)(4429.84976489,643.63121575)(4419.39509659,631.84524024)
\curveto(4408.94021877,620.05923892)(4394.82627514,614.16624471)(4377.05322335,614.16623993)
\curveto(4343.4933394,614.16624471)(4324.46565243,632.89641009)(4319.97010535,670.35679225)
\lineto(4347.72755558,676.66389506)
\curveto(4351.28214534,654.49343751)(4361.37100134,643.40823759)(4377.99415386,643.40826206)
\curveto(4386.46245669,643.40823759)(4392.76145746,645.95655941)(4396.89117507,651.05323516)
\curveto(4401.02072818,656.14984669)(4403.08554586,662.20211101)(4403.0856343,669.21004629)
\curveto(4403.08554586,674.05180748)(4401.67415149,678.86176491)(4398.85144698,683.63993302)
\curveto(4396.02857404,688.41797174)(4388.13522038,693.35534526)(4375.17136231,698.45206841)
\curveto(4362.73012184,703.29380036)(4353.34696302,707.81707159)(4347.0218577,712.02189567)
\curveto(4340.69668761,716.2265336)(4335.49543801,722.31065194)(4331.4180933,730.27426896)
\curveto(4327.34071502,738.23766331)(4325.30203428,747.25235175)(4325.30204494,757.31836131)
\curveto(4325.30203428,773.75489868)(4330.21577762,787.73881467)(4340.0432897,799.27015123)
\curveto(4349.87075097,810.80112714)(4362.57330024,816.56670525)(4378.15097562,816.56690288)
\curveto(4404.60148795,816.56670525)(4421.64276804,800.00261342)(4429.27486701,766.8745777)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(4508.26120861,837.97282757)
\lineto(4474.07406651,837.97282757)
\lineto(4474.07406651,880.21130397)
\lineto(4508.26120861,880.21130397)
\closepath
\moveto(4474.85817528,811.97991901)
\lineto(4507.47709985,811.97991901)
\lineto(4507.47709985,618.94434812)
\lineto(4474.85817528,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(4567.01758035,862.24561717)
\lineto(4596.50006987,865.68585507)
\lineto(4596.50006987,811.97991901)
\lineto(4626.76666815,811.97991901)
\lineto(4626.76666815,779.87103197)
\lineto(4596.50006987,779.87103197)
\lineto(4596.50006987,694.62958186)
\curveto(4596.50001529,679.59440744)(4596.81365848,669.62409832)(4597.44100038,664.71862459)
\curveto(4598.06823125,659.81305931)(4599.9500904,655.79945244)(4603.08658348,652.67779195)
\curveto(4606.22295424,649.55606398)(4611.45034077,647.99521687)(4618.76875876,647.99524592)
\curveto(4622.63694795,647.99521687)(4627.02795263,648.44117319)(4631.94178599,649.33311621)
\lineto(4631.94178599,617.60647783)
\curveto(4623.1596866,615.31298953)(4615.00496361,614.16624471)(4607.47759256,614.16623993)
\curveto(4595.24544252,614.16624471)(4585.88842063,617.06496078)(4579.40649882,622.86239684)
\curveto(4572.92450204,628.65982506)(4568.79486668,636.52776868)(4567.01758035,646.4662513)
\curveto(4565.24024384,656.40467887)(4564.35158813,671.5671937)(4564.35161055,691.95384127)
\lineto(4564.35161055,779.87103197)
\lineto(4543.80796094,779.87103197)
\lineto(4543.80796094,811.97991901)
\lineto(4565.29254107,811.97991901)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(4644.43567979,811.97991901)
\lineto(4677.21142611,811.97991901)
\lineto(4704.8120546,679.33963565)
\lineto(4733.19679184,811.97991901)
\lineto(4762.67928136,811.97991901)
\lineto(4711.24174646,606.71239116)
\curveto(4707.47796151,591.80472074)(4704.0278864,580.78322887)(4700.89151078,573.64788248)
\curveto(4697.75502256,566.51262668)(4693.31174401,560.74704856)(4687.56166179,556.35113083)
\curveto(4681.81149364,551.95533828)(4674.38860477,549.75741071)(4665.2929729,549.75734153)
\curveto(4659.85647021,549.75741071)(4654.26316662,550.64932335)(4648.51304536,552.43308211)
\lineto(4648.51304536,584.1597205)
\curveto(4652.69495066,583.26784264)(4656.51094283,582.82188633)(4659.96103331,582.8218502)
\curveto(4668.42938412,582.82188633)(4674.44087863,585.33835412)(4677.99553488,590.37126114)
\curveto(4681.55012431,595.40422531)(4685.36611648,607.09465166)(4689.44352283,625.44257526)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(4985.41942113,717.37337684)
\curveto(4985.41928501,648.56858928)(4964.50973889,614.16624471)(4922.69072003,614.16623993)
\curveto(4903.45386421,614.16624471)(4888.3205802,622.48014465)(4877.29082261,639.10796469)
\curveto(4866.26100904,655.7357444)(4860.74611625,681.18710857)(4860.7461277,715.46213357)
\curveto(4860.74611625,782.86514919)(4881.65566237,816.56670525)(4923.4748288,816.56690288)
\curveto(4942.50244159,816.56670525)(4957.58345173,808.34836738)(4968.71790446,791.91186461)
\curveto(4979.85211835,775.47501591)(4985.41928501,750.62887816)(4985.41942113,717.37337684)
\closepath
\moveto(4950.76181377,715.46213357)
\curveto(4950.76171231,742.60166443)(4948.27870371,761.23626774)(4943.31278052,771.36599939)
\curveto(4938.3466693,781.49542621)(4931.62947761,786.56021582)(4923.16118529,786.56038344)
\curveto(4904.76071084,786.56021582)(4895.56051054,762.8608229)(4895.56055681,715.46213357)
\curveto(4895.56051054,691.25297976)(4897.70373902,673.35101898)(4901.99024867,661.75619751)
\curveto(4906.27665293,650.16129042)(4913.33362475,644.36385828)(4923.16118529,644.3638837)
\curveto(4932.88405037,644.36385828)(4939.91488526,650.25685248)(4944.25371103,662.042884)
\curveto(4948.5923469,673.82882932)(4950.76171231,691.63522803)(4950.76181377,715.46213357)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(5068.01267944,811.97991901)
\lineto(5096.39741669,811.97991901)
\lineto(5096.39741669,779.87103197)
\lineto(5068.01267944,779.87103197)
\lineto(5068.01267944,618.94434812)
\lineto(5036.02104188,618.94434812)
\lineto(5036.02104188,779.87103197)
\lineto(5015.32057052,779.87103197)
\lineto(5015.32057052,811.97991901)
\lineto(5036.02104188,811.97991901)
\curveto(5036.33466124,834.91462236)(5037.95515106,850.74607166)(5040.88251622,859.47431442)
\curveto(5043.80982398,868.20207613)(5048.59288265,875.05069102)(5055.23170659,880.02017964)
\curveto(5061.87044444,884.98914612)(5070.88768621,887.47375989)(5082.28345894,887.47402842)
\curveto(5088.86989587,887.47375989)(5095.29958131,886.70926334)(5101.57253453,885.18053649)
\lineto(5101.57253453,853.4538981)
\curveto(5097.07689273,854.34557623)(5092.94725737,854.79153255)(5089.18361606,854.7917684)
\curveto(5082.70157977,854.79153255)(5077.91852109,853.3262475)(5074.83442569,850.39590886)
\curveto(5071.75020498,847.46510732)(5069.8422089,843.73818666)(5069.11043171,839.2151357)
\curveto(5068.37854067,834.6916442)(5068.01262361,825.61324771)(5068.01267944,811.97991901)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(5204.81441313,879.82905532)
\lineto(5327.44902378,879.82905532)
\lineto(5327.44902378,845.23555202)
\lineto(5240.25612925,845.23555202)
\lineto(5240.25612925,770.69706425)
\lineto(5308.63041345,770.69706425)
\lineto(5308.63041345,735.91243662)
\lineto(5240.25612925,735.91243662)
\lineto(5240.25612925,654.30234873)
\lineto(5328.86041955,654.30234873)
\lineto(5328.86041955,618.94434812)
\lineto(5204.81441313,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(5366.44583483,879.82905532)
\lineto(5399.22158115,879.82905532)
\lineto(5399.22158115,618.94434812)
\lineto(5366.44583483,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(5567.90993246,709.53727941)
\lineto(5478.36471164,709.53727941)
\curveto(5478.36466679,683.41689017)(5481.26586631,665.99273972)(5487.06831892,657.26477581)
\curveto(5492.87066441,648.53673526)(5500.16286862,644.17273414)(5508.94495342,644.17275937)
\curveto(5523.58156028,644.17273414)(5532.83403444,656.21355474)(5536.70240366,680.29525729)
\lineto(5566.49853668,675.5171491)
\curveto(5558.6573239,634.61652731)(5539.10689828,614.16624471)(5507.84720116,614.16623993)
\curveto(5488.71489212,614.16624471)(5473.45092345,622.51199867)(5462.05524935,639.20352685)
\curveto(5450.65951817,655.89501451)(5444.96166686,680.35890398)(5444.9616783,712.59526865)
\curveto(5444.96166686,745.72335866)(5450.71179204,771.33399295)(5462.21207111,789.42724835)
\curveto(5473.71229278,807.52016279)(5489.08080918,816.56670525)(5508.31766641,816.56690288)
\curveto(5521.80424886,816.56670525)(5533.14767763,812.04343402)(5542.34798676,802.99707561)
\curveto(5551.54807822,793.9503491)(5558.03003752,782.06879862)(5561.7938841,767.35238851)
\curveto(5565.55747412,752.6356816)(5567.59615487,733.36399783)(5567.90993246,709.53727941)
\closepath
\moveto(5534.50689912,736.48580961)
\curveto(5534.50679813,770.50578836)(5525.41114557,787.51583651)(5507.21991414,787.51600508)
\curveto(5490.17856035,787.51583651)(5480.82153846,770.50578836)(5479.1488204,736.48580961)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(5719.81846643,746.99764762)
\lineto(5688.29729413,742.79291242)
\curveto(5686.72898062,759.61171258)(5684.06301349,770.85618261)(5680.29938474,776.52635624)
\curveto(5676.53557689,782.19621471)(5671.20364263,785.03122273)(5664.30356596,785.03138882)
\curveto(5654.58055346,785.03122273)(5647.52358164,779.58418484)(5643.13262933,768.69025881)
\curveto(5638.74157227,757.79603328)(5636.54606993,738.65176561)(5636.54611572,711.25739836)
\curveto(5636.54606993,668.44549947)(5645.79854409,647.03959619)(5664.30356596,647.03962428)
\curveto(5678.52198377,647.03959619)(5686.51988516,660.99165815)(5688.29729413,688.89585203)
\lineto(5719.81846643,685.45561413)
\curveto(5715.53188041,637.92934568)(5696.24282411,614.16624471)(5661.95123966,614.16623993)
\curveto(5641.66890873,614.16624471)(5626.64017245,623.08537108)(5616.86498575,640.9236458)
\curveto(5607.08974683,658.76187656)(5602.20214042,683.41689017)(5602.20215187,714.88876058)
\curveto(5602.20214042,748.0168483)(5607.48180082,773.24523432)(5618.04114889,790.57399432)
\curveto(5628.6004424,807.90241107)(5643.9689588,816.56670525)(5664.1467442,816.56690288)
\curveto(5696.66101503,816.56670525)(5715.21823722,793.37697669)(5719.81846643,746.99764762)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(5761.79493539,862.24561717)
\lineto(5791.27742491,865.68585507)
\lineto(5791.27742491,811.97991901)
\lineto(5821.54402319,811.97991901)
\lineto(5821.54402319,779.87103197)
\lineto(5791.27742491,779.87103197)
\lineto(5791.27742491,694.62958186)
\curveto(5791.27737033,679.59440744)(5791.59101352,669.62409832)(5792.21835542,664.71862459)
\curveto(5792.84558629,659.81305931)(5794.72744544,655.79945244)(5797.86393852,652.67779195)
\curveto(5801.00030928,649.55606398)(5806.22769581,647.99521687)(5813.5461138,647.99524592)
\curveto(5817.41430299,647.99521687)(5821.80530767,648.44117319)(5826.71914103,649.33311621)
\lineto(5826.71914103,617.60647783)
\curveto(5817.93704164,615.31298953)(5809.78231865,614.16624471)(5802.2549476,614.16623993)
\curveto(5790.02279756,614.16624471)(5780.66577567,617.06496078)(5774.18385386,622.86239684)
\curveto(5767.70185708,628.65982506)(5763.57222172,636.52776868)(5761.79493539,646.4662513)
\curveto(5760.01759888,656.40467887)(5759.12894317,671.5671937)(5759.12896559,691.95384127)
\lineto(5759.12896559,779.87103197)
\lineto(5738.58531598,779.87103197)
\lineto(5738.58531598,811.97991901)
\lineto(5760.06989611,811.97991901)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(5858.65893217,811.97991901)
\lineto(5887.51413467,811.97991901)
\lineto(5887.51413467,768.78582097)
\curveto(5896.2960959,800.25744561)(5909.46910996,815.99333284)(5927.03321637,815.99352989)
\curveto(5928.70589239,815.99333284)(5930.69229927,815.80220871)(5932.99244297,815.42015691)
\lineto(5932.99244297,773.94617782)
\curveto(5930.27410835,774.32827109)(5928.07860601,774.51939522)(5926.40592936,774.5195508)
\curveto(5903.09169839,774.51939522)(5891.43462643,755.40698158)(5891.43467849,717.18225252)
\lineto(5891.43467849,618.94434812)
\lineto(5858.65893217,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(6078.15767781,717.37337684)
\curveto(6078.15754169,648.56858928)(6057.24799557,614.16624471)(6015.42897672,614.16623993)
\curveto(5996.19212089,614.16624471)(5981.05883688,622.48014465)(5970.0290793,639.10796469)
\curveto(5958.99926572,655.7357444)(5953.48437293,681.18710857)(5953.48438438,715.46213357)
\curveto(5953.48437293,782.86514919)(5974.39391906,816.56670525)(6016.21308548,816.56690288)
\curveto(6035.24069828,816.56670525)(6050.32170842,808.34836738)(6061.45616115,791.91186461)
\curveto(6072.59037504,775.47501591)(6078.15754169,750.62887816)(6078.15767781,717.37337684)
\closepath
\moveto(6043.50007046,715.46213357)
\curveto(6043.49996899,742.60166443)(6041.01696039,761.23626774)(6036.0510372,771.36599939)
\curveto(6031.08492598,781.49542621)(6024.36773429,786.56021582)(6015.89944197,786.56038344)
\curveto(5997.49896752,786.56021582)(5988.29876723,762.8608229)(5988.29881349,715.46213357)
\curveto(5988.29876723,691.25297976)(5990.44199571,673.35101898)(5994.72850535,661.75619751)
\curveto(5999.01490962,650.16129042)(6006.07188143,644.36385828)(6015.89944197,644.3638837)
\curveto(6025.62230706,644.36385828)(6032.65314194,650.25685248)(6036.99196772,662.042884)
\curveto(6041.33060358,673.82882932)(6043.49996899,691.63522803)(6043.50007046,715.46213357)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(6124.21146774,811.97991901)
\lineto(6154.47806602,811.97991901)
\lineto(6154.47806602,782.1645239)
\curveto(6161.79635761,805.09925706)(6174.86482393,816.56670525)(6193.6835042,816.56690288)
\curveto(6204.34728397,816.56670525)(6212.94633481,813.44501102)(6219.48068253,807.20181082)
\curveto(6226.01480114,800.95823411)(6230.1444365,793.47253876)(6231.869601,784.74470233)
\curveto(6233.59451161,776.01653429)(6234.45703038,762.22374244)(6234.45715992,743.3662854)
\lineto(6234.45715992,618.94434812)
\lineto(6201.83823535,618.94434812)
\lineto(6201.83823535,741.2639178)
\curveto(6201.83813843,758.08271949)(6200.63583953,769.51831365)(6198.23133503,775.5707346)
\curveto(6195.82664392,781.6228423)(6190.70380512,784.64897446)(6182.86280326,784.64914016)
\curveto(6174.70800234,784.64897446)(6168.3567277,780.79463771)(6163.80896031,773.08611834)
\curveto(6159.26107514,765.3772907)(6156.987162,750.05550575)(6156.98721406,727.12071755)
\lineto(6156.98721406,618.94434812)
\lineto(6124.21146774,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(6320.50049679,837.97282757)
\lineto(6286.31335469,837.97282757)
\lineto(6286.31335469,880.21130397)
\lineto(6320.50049679,880.21130397)
\closepath
\moveto(6287.09746346,811.97991901)
\lineto(6319.71638803,811.97991901)
\lineto(6319.71638803,618.94434812)
\lineto(6287.09746346,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(6484.31919552,746.99764762)
\lineto(6452.79802322,742.79291242)
\curveto(6451.22970971,759.61171258)(6448.56374258,770.85618261)(6444.80011383,776.52635624)
\curveto(6441.03630598,782.19621471)(6435.70437172,785.03122273)(6428.80429505,785.03138882)
\curveto(6419.08128255,785.03122273)(6412.02431073,779.58418484)(6407.63335843,768.69025881)
\curveto(6403.24230136,757.79603328)(6401.04679902,738.65176561)(6401.04684481,711.25739836)
\curveto(6401.04679902,668.44549947)(6410.29927318,647.03959619)(6428.80429505,647.03962428)
\curveto(6443.02271286,647.03959619)(6451.02061425,660.99165815)(6452.79802322,688.89585203)
\lineto(6484.31919552,685.45561413)
\curveto(6480.0326095,637.92934568)(6460.7435532,614.16624471)(6426.45196876,614.16623993)
\curveto(6406.16963782,614.16624471)(6391.14090154,623.08537108)(6381.36571484,640.9236458)
\curveto(6371.59047592,658.76187656)(6366.70286951,683.41689017)(6366.70288096,714.88876058)
\curveto(6366.70286951,748.0168483)(6371.98252991,773.24523432)(6382.54187799,790.57399432)
\curveto(6393.10117149,807.90241107)(6408.46968789,816.56670525)(6428.64747329,816.56690288)
\curveto(6461.16174412,816.56670525)(6479.71896631,793.37697669)(6484.31919552,746.99764762)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(6724.30966722,821.53613539)
\lineto(6694.04306894,808.73080544)
\curveto(6690.48832832,822.49155348)(6685.80981738,832.65298674)(6680.00752207,839.2151357)
\curveto(6674.20501928,845.77684411)(6666.28552868,849.05780846)(6656.24902652,849.05803857)
\curveto(6646.94419852,849.05780846)(6639.75654204,845.71313607)(6634.68603552,839.02401137)
\curveto(6629.61541217,832.33444651)(6627.0801297,824.65762703)(6627.08018051,815.99352989)
\curveto(6627.0801297,806.43712602)(6629.92905536,798.82401458)(6635.62696604,793.15417274)
\curveto(6641.324758,787.48398248)(6652.6943237,780.69907564)(6669.73569726,772.79943185)
\curveto(6684.26773835,766.04622517)(6695.45434553,759.61171258)(6703.29555235,753.49587476)
\curveto(6711.13650512,747.37976784)(6717.48777975,739.193284)(6722.34939531,728.93639866)
\curveto(6727.2107187,718.67929335)(6729.64145344,706.79774286)(6729.64160681,693.29171156)
\curveto(6729.64145344,671.37606957)(6723.2901788,652.70961224)(6710.58776385,637.29228357)
\curveto(6697.88508026,621.87491822)(6680.08582913,614.16624471)(6657.18995704,614.16623993)
\curveto(6617.67083395,614.16624471)(6593.20666498,638.50271809)(6583.79737676,687.17573308)
\lineto(6615.47537081,698.06981975)
\curveto(6621.01636133,665.9608857)(6635.44394815,649.90645823)(6658.75817457,649.9064892)
\curveto(6670.15379472,649.90645823)(6678.80511943,653.5059628)(6684.71217465,660.70501371)
\curveto(6690.61901299,667.90398109)(6693.57248638,676.79125343)(6693.57260368,687.36685741)
\curveto(6693.57248638,695.13917054)(6691.53380563,702.33817968)(6687.45655532,708.96390643)
\curveto(6683.37908264,715.58945314)(6673.23795277,722.66104619)(6657.03313529,730.17870679)
\curveto(6639.8872267,738.0783932)(6627.52445756,744.76773798)(6619.94479076,750.24676119)
\curveto(6612.36503662,755.7255218)(6605.90921425,763.81644358)(6600.5773043,774.5195508)
\curveto(6595.24534573,785.22234687)(6592.5793786,797.39058356)(6592.57939491,811.02429737)
\curveto(6592.5793786,831.79292813)(6598.51246231,849.24893259)(6610.37866385,863.39236314)
\curveto(6622.24479716,877.53530479)(6638.00536755,884.60689784)(6657.6604223,884.60716351)
\curveto(6692.4747352,884.60689784)(6714.69112796,863.58324283)(6724.30966722,821.53613539)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(6884.52970137,746.99764762)
\lineto(6853.00852907,742.79291242)
\curveto(6851.44021557,759.61171258)(6848.77424844,770.85618261)(6845.01061968,776.52635624)
\curveto(6841.24681183,782.19621471)(6835.91487757,785.03122273)(6829.0148009,785.03138882)
\curveto(6819.2917884,785.03122273)(6812.23481659,779.58418484)(6807.84386428,768.69025881)
\curveto(6803.45280722,757.79603328)(6801.25730487,738.65176561)(6801.25735066,711.25739836)
\curveto(6801.25730487,668.44549947)(6810.50977903,647.03959619)(6829.0148009,647.03962428)
\curveto(6843.23321871,647.03959619)(6851.23112011,660.99165815)(6853.00852907,688.89585203)
\lineto(6884.52970137,685.45561413)
\curveto(6880.24311535,637.92934568)(6860.95405905,614.16624471)(6826.66247461,614.16623993)
\curveto(6806.38014367,614.16624471)(6791.3514074,623.08537108)(6781.57622069,640.9236458)
\curveto(6771.80098177,658.76187656)(6766.91337536,683.41689017)(6766.91338681,714.88876058)
\curveto(6766.91337536,748.0168483)(6772.19303576,773.24523432)(6782.75238384,790.57399432)
\curveto(6793.31167735,807.90241107)(6808.68019375,816.56670525)(6828.85797915,816.56690288)
\curveto(6861.37224998,816.56670525)(6879.92947216,793.37697669)(6884.52970137,746.99764762)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(6954.10652238,837.97282757)
\lineto(6919.91938028,837.97282757)
\lineto(6919.91938028,880.21130397)
\lineto(6954.10652238,880.21130397)
\closepath
\moveto(6920.70348905,811.97991901)
\lineto(6953.32241362,811.97991901)
\lineto(6953.32241362,618.94434812)
\lineto(6920.70348905,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(7122.16772489,709.53727941)
\lineto(7032.62250407,709.53727941)
\curveto(7032.62245922,683.41689017)(7035.52365875,665.99273972)(7041.32611135,657.26477581)
\curveto(7047.12845685,648.53673526)(7054.42066106,644.17273414)(7063.20274586,644.17275937)
\curveto(7077.83935272,644.17273414)(7087.09182687,656.21355474)(7090.9601961,680.29525729)
\lineto(7120.75632912,675.5171491)
\curveto(7112.91511634,634.61652731)(7093.36469071,614.16624471)(7062.10499359,614.16623993)
\curveto(7042.97268455,614.16624471)(7027.70871588,622.51199867)(7016.31304179,639.20352685)
\curveto(7004.91731061,655.89501451)(6999.21945929,680.35890398)(6999.21947074,712.59526865)
\curveto(6999.21945929,745.72335866)(7004.96958448,771.33399295)(7016.46986354,789.42724835)
\curveto(7027.97008521,807.52016279)(7043.33860161,816.56670525)(7062.57545885,816.56690288)
\curveto(7076.06204129,816.56670525)(7087.40547007,812.04343402)(7096.60577919,802.99707561)
\curveto(7105.80587065,793.9503491)(7112.28782995,782.06879862)(7116.05167654,767.35238851)
\curveto(7119.81526656,752.6356816)(7121.8539473,733.36399783)(7122.16772489,709.53727941)
\closepath
\moveto(7088.76469156,736.48580961)
\curveto(7088.76459056,770.50578836)(7079.668938,787.51583651)(7061.47770658,787.51600508)
\curveto(7044.43635278,787.51583651)(7035.07933089,770.50578836)(7033.40661284,736.48580961)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(7164.30089372,811.97991901)
\lineto(7194.567492,811.97991901)
\lineto(7194.567492,782.1645239)
\curveto(7201.88578359,805.09925706)(7214.95424992,816.56670525)(7233.77293019,816.56690288)
\curveto(7244.43670995,816.56670525)(7253.03576079,813.44501102)(7259.57010852,807.20181082)
\curveto(7266.10422712,800.95823411)(7270.23386248,793.47253876)(7271.95902698,784.74470233)
\curveto(7273.68393759,776.01653429)(7274.54645637,762.22374244)(7274.5465859,743.3662854)
\lineto(7274.5465859,618.94434812)
\lineto(7241.92766133,618.94434812)
\lineto(7241.92766133,741.2639178)
\curveto(7241.92756442,758.08271949)(7240.72526551,769.51831365)(7238.32076102,775.5707346)
\curveto(7235.91606991,781.6228423)(7230.7932311,784.64897446)(7222.95222925,784.64914016)
\curveto(7214.79742832,784.64897446)(7208.44615369,780.79463771)(7203.89838629,773.08611834)
\curveto(7199.35050112,765.3772907)(7197.07658798,750.05550575)(7197.07664005,727.12071755)
\lineto(7197.07664005,618.94434812)
\lineto(7164.30089372,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(7436.96211636,746.99764762)
\lineto(7405.44094406,742.79291242)
\curveto(7403.87263056,759.61171258)(7401.20666343,770.85618261)(7397.44303467,776.52635624)
\curveto(7393.67922682,782.19621471)(7388.34729256,785.03122273)(7381.44721589,785.03138882)
\curveto(7371.72420339,785.03122273)(7364.66723158,779.58418484)(7360.27627927,768.69025881)
\curveto(7355.88522221,757.79603328)(7353.68971986,738.65176561)(7353.68976566,711.25739836)
\curveto(7353.68971986,668.44549947)(7362.94219402,647.03959619)(7381.44721589,647.03962428)
\curveto(7395.66563371,647.03959619)(7403.6635351,660.99165815)(7405.44094406,688.89585203)
\lineto(7436.96211636,685.45561413)
\curveto(7432.67553034,637.92934568)(7413.38647405,614.16624471)(7379.0948896,614.16623993)
\curveto(7358.81255866,614.16624471)(7343.78382239,623.08537108)(7334.00863569,640.9236458)
\curveto(7324.23339676,658.76187656)(7319.34579036,683.41689017)(7319.3458018,714.88876058)
\curveto(7319.34579036,748.0168483)(7324.62545075,773.24523432)(7335.18479883,790.57399432)
\curveto(7345.74409234,807.90241107)(7361.11260874,816.56670525)(7381.29039414,816.56690288)
\curveto(7413.80466497,816.56670525)(7432.36188715,793.37697669)(7436.96211636,746.99764762)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(7588.24334699,709.53727941)
\lineto(7498.69812617,709.53727941)
\curveto(7498.69808132,683.41689017)(7501.59928085,665.99273972)(7507.40173345,657.26477581)
\curveto(7513.20407894,648.53673526)(7520.49628315,644.17273414)(7529.27836796,644.17275937)
\curveto(7543.91497481,644.17273414)(7553.16744897,656.21355474)(7557.03581819,680.29525729)
\lineto(7586.83195122,675.5171491)
\curveto(7578.99073843,634.61652731)(7559.44031281,614.16624471)(7528.18061569,614.16623993)
\curveto(7509.04830665,614.16624471)(7493.78433798,622.51199867)(7482.38866389,639.20352685)
\curveto(7470.99293271,655.89501451)(7465.29508139,680.35890398)(7465.29509284,712.59526865)
\curveto(7465.29508139,745.72335866)(7471.04520657,771.33399295)(7482.54548564,789.42724835)
\curveto(7494.04570731,807.52016279)(7509.41422371,816.56670525)(7528.65108095,816.56690288)
\curveto(7542.13766339,816.56670525)(7553.48109216,812.04343402)(7562.68140129,802.99707561)
\curveto(7571.88149275,793.9503491)(7578.36345205,782.06879862)(7582.12729863,767.35238851)
\curveto(7585.89088865,752.6356816)(7587.9295694,733.36399783)(7588.24334699,709.53727941)
\closepath
\moveto(7554.84031366,736.48580961)
\curveto(7554.84021266,770.50578836)(7545.7445601,787.51583651)(7527.55332868,787.51600508)
\curveto(7510.51197488,787.51583651)(7501.15495299,770.50578836)(7499.48223494,736.48580961)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(7734.7682086,757.31836131)
\lineto(7703.2470363,762.09646951)
\curveto(7705.33797382,779.29749864)(7711.84607005,792.67618819)(7722.77134452,802.2325783)
\curveto(7733.69654575,811.78860184)(7747.1047922,816.56670525)(7762.9961241,816.56690288)
\curveto(7777.21453862,816.56670525)(7788.58410432,813.09461677)(7797.10485532,806.15062702)
\curveto(7805.62538441,799.20626285)(7810.98345561,790.95607096)(7813.17908497,781.40002659)
\curveto(7815.37446029,771.84365731)(7816.47221146,757.38193099)(7816.47234178,738.01480423)
\lineto(7816.47234178,672.26803553)
\curveto(7816.47221146,645.63801919)(7817.41314104,627.86347449)(7819.29513333,618.94434812)
\lineto(7788.40124804,618.94434812)
\curveto(7787.04202529,625.95223313)(7786.36246505,636.65518477)(7786.36256525,651.05323516)
\curveto(7776.43043064,626.46189749)(7761.58465289,614.16624471)(7741.82518747,614.16623993)
\curveto(7728.44302228,614.16624471)(7717.70074296,619.16732628)(7709.59831729,629.16949965)
\curveto(7701.49584472,639.17165257)(7697.44462016,652.77332028)(7697.44463145,669.9745436)
\curveto(7697.44462016,690.99814758)(7703.37770387,707.62594745)(7715.24390038,719.8579931)
\curveto(7727.11003872,732.08983692)(7747.67980472,738.20580929)(7776.95326009,738.20592855)
\curveto(7778.41683752,738.20580929)(7780.71688759,738.14210125)(7783.85341721,738.01480423)
\lineto(7783.85341721,745.85090166)
\curveto(7783.85331951,759.61171258)(7782.15441889,769.99612399)(7778.75671025,777.00416706)
\curveto(7775.3588164,784.011894)(7769.26891109,787.51583651)(7760.48697605,787.51600508)
\curveto(7746.16386262,787.51583651)(7737.59094871,777.44996532)(7734.7682086,757.31836131)
\closepath
\moveto(7783.85341721,712.97751731)
\curveto(7779.67141029,713.48708764)(7776.4827045,713.74191982)(7774.28729029,713.74201462)
\curveto(7745.85021943,713.74191982)(7731.63172807,700.17210613)(7731.63177355,673.03253284)
\curveto(7731.63172807,653.28298465)(7738.68869988,643.40823759)(7752.80271017,643.40826206)
\curveto(7761.06191424,643.40823759)(7768.30184458,648.75971342)(7774.52252292,659.46270558)
\curveto(7780.74302452,670.1656167)(7783.85331951,684.88217521)(7783.85341721,703.61242526)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(7868.32853656,811.97991901)
\lineto(7898.59513484,811.97991901)
\lineto(7898.59513484,782.1645239)
\curveto(7905.91342642,805.09925706)(7918.98189275,816.56670525)(7937.80057302,816.56690288)
\curveto(7948.46435279,816.56670525)(7957.06340363,813.44501102)(7963.59775135,807.20181082)
\curveto(7970.13186996,800.95823411)(7974.26150531,793.47253876)(7975.98666982,784.74470233)
\curveto(7977.71158043,776.01653429)(7978.5740992,762.22374244)(7978.57422874,743.3662854)
\lineto(7978.57422874,618.94434812)
\lineto(7945.95530417,618.94434812)
\lineto(7945.95530417,741.2639178)
\curveto(7945.95520725,758.08271949)(7944.75290835,769.51831365)(7942.34840385,775.5707346)
\curveto(7939.94371274,781.6228423)(7934.82087394,784.64897446)(7926.97987208,784.64914016)
\curveto(7918.82507116,784.64897446)(7912.47379652,780.79463771)(7907.92602913,773.08611834)
\curveto(7903.37814396,765.3772907)(7901.10423082,750.05550575)(7901.10428288,727.12071755)
\lineto(7901.10428288,618.94434812)
\lineto(7868.32853656,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(8113.70277422,879.82905532)
\lineto(8146.16487704,879.82905532)
\lineto(8146.16487704,618.94434812)
\lineto(8116.21192226,618.94434812)
\lineto(8116.21192226,648.18637025)
\curveto(8108.57983364,626.39818945)(8095.45909345,615.50411367)(8076.84966233,615.50411023)
\curveto(8058.97193547,615.50411367)(8045.56368901,624.61436417)(8036.62488275,642.83488907)
\curveto(8027.68602708,661.0553662)(8023.21661159,684.94588326)(8023.21662289,714.50651193)
\curveto(8023.21661159,746.23302302)(8028.15649187,770.95174468)(8038.03627852,788.66275104)
\curveto(8047.91601295,806.37341797)(8061.06289008,815.2288363)(8077.47694934,815.22903258)
\curveto(8094.72725934,815.2288363)(8106.80252222,806.6919582)(8113.70277422,789.61837268)
\closepath
\moveto(8113.70277422,732.47219873)
\curveto(8113.70267244,752.34899539)(8110.61851439,766.26920333)(8104.45029081,774.23286431)
\curveto(8098.28188218,782.19621471)(8091.90447061,786.17796755)(8085.31803697,786.17813478)
\curveto(8067.12665845,786.17796755)(8058.03100589,763.49790335)(8058.031052,718.13787415)
\curveto(8058.03100589,669.71966038)(8067.23120618,645.51060309)(8085.63168048,645.51062966)
\curveto(8092.74085245,645.51060309)(8099.19667482,649.52420996)(8104.99916694,657.5514623)
\curveto(8110.80147292,665.57863743)(8113.70267244,679.53069939)(8113.70277422,699.40769005)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(8249.87733111,879.82905532)
\lineto(8380.50985115,879.82905532)
\lineto(8380.50985115,843.13318441)
\lineto(8332.67921656,843.13318441)
\lineto(8332.67921656,618.94434812)
\lineto(8297.23750044,618.94434812)
\lineto(8297.23750044,843.13318441)
\lineto(8249.87733111,843.13318441)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(8524.57707375,709.53727941)
\lineto(8435.03185293,709.53727941)
\curveto(8435.03180808,683.41689017)(8437.93300761,665.99273972)(8443.73546021,657.26477581)
\curveto(8449.53780571,648.53673526)(8456.83000992,644.17273414)(8465.61209472,644.17275937)
\curveto(8480.24870157,644.17273414)(8489.50117573,656.21355474)(8493.36954496,680.29525729)
\lineto(8523.16567798,675.5171491)
\curveto(8515.3244652,634.61652731)(8495.77403957,614.16624471)(8464.51434245,614.16623993)
\curveto(8445.38203341,614.16624471)(8430.11806474,622.51199867)(8418.72239065,639.20352685)
\curveto(8407.32665947,655.89501451)(8401.62880815,680.35890398)(8401.6288196,712.59526865)
\curveto(8401.62880815,745.72335866)(8407.37893333,771.33399295)(8418.8792124,789.42724835)
\curveto(8430.37943407,807.52016279)(8445.74795047,816.56670525)(8464.98480771,816.56690288)
\curveto(8478.47139015,816.56670525)(8489.81481893,812.04343402)(8499.01512805,802.99707561)
\curveto(8508.21521951,793.9503491)(8514.69717881,782.06879862)(8518.46102539,767.35238851)
\curveto(8522.22461542,752.6356816)(8524.26329616,733.36399783)(8524.57707375,709.53727941)
\closepath
\moveto(8491.17404042,736.48580961)
\curveto(8491.17393942,770.50578836)(8482.07828686,787.51583651)(8463.88705544,787.51600508)
\curveto(8446.84570164,787.51583651)(8437.48867975,770.50578836)(8435.8159617,736.48580961)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(8676.4854695,746.99764762)
\lineto(8644.9642972,742.79291242)
\curveto(8643.3959837,759.61171258)(8640.73001657,770.85618261)(8636.96638781,776.52635624)
\curveto(8633.20257996,782.19621471)(8627.8706457,785.03122273)(8620.97056903,785.03138882)
\curveto(8611.24755653,785.03122273)(8604.19058472,779.58418484)(8599.79963241,768.69025881)
\curveto(8595.40857535,757.79603328)(8593.213073,738.65176561)(8593.2131188,711.25739836)
\curveto(8593.213073,668.44549947)(8602.46554716,647.03959619)(8620.97056903,647.03962428)
\curveto(8635.18898685,647.03959619)(8643.18688824,660.99165815)(8644.9642972,688.89585203)
\lineto(8676.4854695,685.45561413)
\curveto(8672.19888348,637.92934568)(8652.90982719,614.16624471)(8618.61824274,614.16623993)
\curveto(8598.3359118,614.16624471)(8583.30717553,623.08537108)(8573.53198883,640.9236458)
\curveto(8563.7567499,658.76187656)(8558.8691435,683.41689017)(8558.86915494,714.88876058)
\curveto(8558.8691435,748.0168483)(8564.14880389,773.24523432)(8574.70815197,790.57399432)
\curveto(8585.26744548,807.90241107)(8600.63596188,816.56670525)(8620.81374728,816.56690288)
\curveto(8653.32801811,816.56670525)(8671.88524029,793.37697669)(8676.4854695,746.99764762)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(8712.5029883,879.82905532)
\lineto(8745.27873462,879.82905532)
\lineto(8745.27873462,786.36925911)
\curveto(8752.70157159,806.50083406)(8765.29957313,816.56670525)(8783.07277703,816.56690288)
\curveto(8792.1683399,816.56670525)(8799.82646116,814.01838343)(8806.04716381,808.92192977)
\curveto(8812.26764111,803.82509615)(8816.60637193,797.04018931)(8819.06336929,788.56718888)
\curveto(8821.52011527,780.09384921)(8822.7485511,764.07127576)(8822.74868048,740.49942048)
\lineto(8822.74868048,618.94434812)
\lineto(8790.12975591,618.94434812)
\lineto(8790.12975591,740.49942048)
\curveto(8790.12965915,760.63104131)(8788.2478,773.02225616)(8784.48417281,777.67310221)
\curveto(8780.72036339,782.3236308)(8776.06798938,784.64897446)(8770.52703681,784.64914016)
\curveto(8753.69477503,784.64897446)(8745.27868271,766.23734931)(8745.27873462,729.41420948)
\lineto(8745.27873462,618.94434812)
\lineto(8712.5029883,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(8875.54552933,811.97991901)
\lineto(8905.81212761,811.97991901)
\lineto(8905.81212761,782.1645239)
\curveto(8913.1304192,805.09925706)(8926.19888553,816.56670525)(8945.0175658,816.56690288)
\curveto(8955.68134556,816.56670525)(8964.28039641,813.44501102)(8970.81474413,807.20181082)
\curveto(8977.34886273,800.95823411)(8981.47849809,793.47253876)(8983.20366259,784.74470233)
\curveto(8984.9285732,776.01653429)(8985.79109198,762.22374244)(8985.79122151,743.3662854)
\lineto(8985.79122151,618.94434812)
\lineto(8953.17229694,618.94434812)
\lineto(8953.17229694,741.2639178)
\curveto(8953.17220003,758.08271949)(8951.96990113,769.51831365)(8949.56539663,775.5707346)
\curveto(8947.16070552,781.6228423)(8942.03786672,784.64897446)(8934.19686486,784.64914016)
\curveto(8926.04206393,784.64897446)(8919.6907893,780.79463771)(8915.1430219,773.08611834)
\curveto(8910.59513673,765.3772907)(8908.32122359,750.05550575)(8908.32127566,727.12071755)
\lineto(8908.32127566,618.94434812)
\lineto(8875.54552933,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(9155.26400729,717.37337684)
\curveto(9155.26387116,648.56858928)(9134.35432504,614.16624471)(9092.53530619,614.16623993)
\curveto(9073.29845036,614.16624471)(9058.16516635,622.48014465)(9047.13540877,639.10796469)
\curveto(9036.10559519,655.7357444)(9030.5907024,681.18710857)(9030.59071385,715.46213357)
\curveto(9030.5907024,782.86514919)(9051.50024853,816.56670525)(9093.31941495,816.56690288)
\curveto(9112.34702775,816.56670525)(9127.42803789,808.34836738)(9138.56249062,791.91186461)
\curveto(9149.69670451,775.47501591)(9155.26387116,750.62887816)(9155.26400729,717.37337684)
\closepath
\moveto(9120.60639993,715.46213357)
\curveto(9120.60629846,742.60166443)(9118.12328986,761.23626774)(9113.15736667,771.36599939)
\curveto(9108.19125545,781.49542621)(9101.47406376,786.56021582)(9093.00577144,786.56038344)
\curveto(9074.60529699,786.56021582)(9065.4050967,762.8608229)(9065.40514296,715.46213357)
\curveto(9065.4050967,691.25297976)(9067.54832518,673.35101898)(9071.83483482,661.75619751)
\curveto(9076.12123909,650.16129042)(9083.1782109,644.36385828)(9093.00577144,644.3638837)
\curveto(9102.72863653,644.36385828)(9109.75947141,650.25685248)(9114.09829719,662.042884)
\curveto(9118.43693305,673.82882932)(9120.60629846,691.63522803)(9120.60639993,715.46213357)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(9201.31752077,879.82905532)
\lineto(9234.0932671,879.82905532)
\lineto(9234.0932671,618.94434812)
\lineto(9201.31752077,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(9404.5067959,717.37337684)
\curveto(9404.50665978,648.56858928)(9383.59711365,614.16624471)(9341.7780948,614.16623993)
\curveto(9322.54123897,614.16624471)(9307.40795497,622.48014465)(9296.37819738,639.10796469)
\curveto(9285.34838381,655.7357444)(9279.83349102,681.18710857)(9279.83350246,715.46213357)
\curveto(9279.83349102,782.86514919)(9300.74303714,816.56670525)(9342.56220356,816.56690288)
\curveto(9361.58981636,816.56670525)(9376.6708265,808.34836738)(9387.80527923,791.91186461)
\curveto(9398.93949312,775.47501591)(9404.50665978,750.62887816)(9404.5067959,717.37337684)
\closepath
\moveto(9369.84918854,715.46213357)
\curveto(9369.84908708,742.60166443)(9367.36607848,761.23626774)(9362.40015529,771.36599939)
\curveto(9357.43404407,781.49542621)(9350.71685237,786.56021582)(9342.24856006,786.56038344)
\curveto(9323.84808561,786.56021582)(9314.64788531,762.8608229)(9314.64793157,715.46213357)
\curveto(9314.64788531,691.25297976)(9316.79111379,673.35101898)(9321.07762344,661.75619751)
\curveto(9325.3640277,650.16129042)(9332.42099952,644.36385828)(9342.24856006,644.3638837)
\curveto(9351.97142514,644.36385828)(9359.00226003,650.25685248)(9363.3410858,662.042884)
\curveto(9367.67972167,673.82882932)(9369.84908708,691.63522803)(9369.84918854,715.46213357)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(9573.66538529,842.75093576)
\lineto(9573.66538529,813.50891363)
\curveto(9570.63335871,814.27321561)(9568.12421317,814.65546389)(9566.13794116,814.6556596)
\curveto(9556.51941508,814.65546389)(9550.82156376,807.58387084)(9549.04437011,793.44085923)
\curveto(9556.98987986,781.20874)(9560.96269363,767.38409413)(9560.96282332,751.96688014)
\curveto(9560.96269363,734.51074265)(9555.99667642,719.79418414)(9546.06475681,707.81716046)
\curveto(9536.13260761,695.83995904)(9522.75049809,689.85140276)(9505.9183881,689.85147367)
\curveto(9499.54090189,689.85140276)(9492.84984713,690.99814758)(9485.84520375,693.29171156)
\curveto(9477.89952165,689.59657058)(9473.92670789,683.99026257)(9473.92675054,676.47277073)
\curveto(9473.92670789,669.97449257)(9476.04379943,665.76976156)(9480.27803153,663.85856511)
\curveto(9484.51216561,661.94727883)(9495.72490972,660.41828574)(9513.91629749,659.27158125)
\curveto(9529.59837444,658.25221219)(9541.412268,656.46838692)(9549.35801362,653.92010008)
\curveto(9557.30352306,651.37174328)(9563.65479769,646.17953757)(9568.41185657,638.34346738)
\curveto(9573.16864118,630.50735838)(9575.54710205,620.21850903)(9575.54724632,607.47688847)
\curveto(9575.54710205,587.85482192)(9569.32651208,572.9789933)(9556.88545775,562.84935797)
\curveto(9544.44415219,552.71983483)(9526.72331185,547.65504521)(9503.72288357,547.65497392)
\curveto(9481.55869222,547.65504521)(9465.37993091,552.08275437)(9455.18655109,560.93811469)
\curveto(9444.99312344,569.79359102)(9439.89642157,581.54772542)(9439.8964302,596.20055314)
\curveto(9439.89642157,614.80332517)(9447.58067977,627.22639404)(9462.94922785,633.46979702)
\curveto(9451.44894581,641.24216405)(9445.69882062,651.75399155)(9445.69883505,665.00531108)
\curveto(9445.69882062,681.82418903)(9453.48762655,694.75692226)(9469.06527621,703.80354958)
\curveto(9455.47403344,714.76124855)(9448.67843094,731.26163233)(9448.67844835,753.30475044)
\curveto(9448.67843094,772.16219754)(9453.85354361,787.42027444)(9464.20380187,799.0790269)
\curveto(9474.55399427,810.73741909)(9487.88382993,816.56670525)(9504.19334882,816.56690288)
\curveto(9514.85714443,816.56670525)(9524.8414527,813.76355125)(9534.1463036,808.15743246)
\curveto(9535.81896441,821.5359328)(9538.98153326,830.80545342)(9543.63401964,835.96602213)
\curveto(9548.28628129,841.12615679)(9555.05574685,843.70633263)(9563.94243662,843.7065574)
\curveto(9566.55599721,843.70633263)(9569.79697686,843.38779241)(9573.66538529,842.75093576)
\closepath
\moveto(9527.24614648,752.54025312)
\curveto(9527.2460505,777.76850555)(9520.08453096,790.38269855)(9505.76156635,790.38286999)
\curveto(9490.18388,790.38269855)(9482.39507407,777.64108945)(9482.39512519,752.15800447)
\curveto(9482.39507407,727.4391496)(9489.92251067,715.07978878)(9504.97745759,715.07988491)
\curveto(9519.82316163,715.07978878)(9527.2460505,727.56656569)(9527.24614648,752.54025312)
\closepath
\moveto(9483.17923396,626.97156988)
\curveto(9474.08352948,621.49266994)(9469.5357032,613.27433207)(9469.53574147,602.31653162)
\curveto(9469.5357032,593.1425897)(9472.46303966,586.38953687)(9478.31775962,582.05735289)
\curveto(9484.17238549,577.72524269)(9493.89532444,575.55916914)(9507.48660563,575.55912575)
\curveto(9532.57798476,575.55916914)(9545.12371244,584.41458746)(9545.12382629,602.12540729)
\curveto(9545.12371244,610.7897183)(9542.74525157,616.74642055)(9537.98843654,619.99553192)
\curveto(9533.23140808,623.24464119)(9523.84824926,625.12402854)(9509.83893192,625.63369959)
\curveto(9498.0249598,626.14335726)(9489.13840269,626.58931358)(9483.17923396,626.97156988)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(9588.35530026,811.97991901)
\lineto(9621.13104659,811.97991901)
\lineto(9648.73167507,679.33963565)
\lineto(9677.11641232,811.97991901)
\lineto(9706.59890183,811.97991901)
\lineto(9655.16136693,606.71239116)
\curveto(9651.39758198,591.80472074)(9647.94750687,580.78322887)(9644.81113125,573.64788248)
\curveto(9641.67464303,566.51262668)(9637.23136448,560.74704856)(9631.48128227,556.35113083)
\curveto(9625.73111411,551.95533828)(9618.30822524,549.75741071)(9609.21259338,549.75734153)
\curveto(9603.77609069,549.75741071)(9598.1827871,550.64932335)(9592.43266583,552.43308211)
\lineto(9592.43266583,584.1597205)
\curveto(9596.61457114,583.26784264)(9600.43056331,582.82188633)(9603.88065378,582.8218502)
\curveto(9612.3490046,582.82188633)(9618.36049911,585.33835412)(9621.91515535,590.37126114)
\curveto(9625.46974479,595.40422531)(9629.28573696,607.09465166)(9633.3631433,625.44257526)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(9929.33897249,717.37337684)
\curveto(9929.33883637,648.56858928)(9908.42929025,614.16624471)(9866.6102714,614.16623993)
\curveto(9847.37341557,614.16624471)(9832.24013156,622.48014465)(9821.21037398,639.10796469)
\curveto(9810.1805604,655.7357444)(9804.66566761,681.18710857)(9804.66567906,715.46213357)
\curveto(9804.66566761,782.86514919)(9825.57521374,816.56670525)(9867.39438016,816.56690288)
\curveto(9886.42199296,816.56670525)(9901.5030031,808.34836738)(9912.63745583,791.91186461)
\curveto(9923.77166972,775.47501591)(9929.33883637,750.62887816)(9929.33897249,717.37337684)
\closepath
\moveto(9894.68136514,715.46213357)
\curveto(9894.68126367,742.60166443)(9892.19825507,761.23626774)(9887.23233188,771.36599939)
\curveto(9882.26622066,781.49542621)(9875.54902897,786.56021582)(9867.08073665,786.56038344)
\curveto(9848.6802622,786.56021582)(9839.48006191,762.8608229)(9839.48010817,715.46213357)
\curveto(9839.48006191,691.25297976)(9841.62329039,673.35101898)(9845.90980003,661.75619751)
\curveto(9850.1962043,650.16129042)(9857.25317611,644.36385828)(9867.08073665,644.3638837)
\curveto(9876.80360174,644.36385828)(9883.83443662,650.25685248)(9888.1732624,662.042884)
\curveto(9892.51189826,673.82882932)(9894.68126367,691.63522803)(9894.68136514,715.46213357)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(10011.93195437,811.97991901)
\lineto(10040.31669162,811.97991901)
\lineto(10040.31669162,779.87103197)
\lineto(10011.93195437,779.87103197)
\lineto(10011.93195437,618.94434812)
\lineto(9979.94031681,618.94434812)
\lineto(9979.94031681,779.87103197)
\lineto(9959.23984545,779.87103197)
\lineto(9959.23984545,811.97991901)
\lineto(9979.94031681,811.97991901)
\curveto(9980.25393617,834.91462236)(9981.87442599,850.74607166)(9984.80179115,859.47431442)
\curveto(9987.72909891,868.20207613)(9992.51215758,875.05069102)(9999.15098152,880.02017964)
\curveto(10005.78971937,884.98914612)(10014.80696113,887.47375989)(10026.20273387,887.47402842)
\curveto(10032.7891708,887.47375989)(10039.21885623,886.70926334)(10045.49180946,885.18053649)
\lineto(10045.49180946,853.4538981)
\curveto(10040.99616765,854.34557623)(10036.86653229,854.79153255)(10033.10289099,854.7917684)
\curveto(10026.62085469,854.79153255)(10021.83779602,853.3262475)(10018.75370062,850.39590886)
\curveto(10015.66947991,847.46510732)(10013.76148383,843.73818666)(10013.02970664,839.2151357)
\curveto(10012.2978156,834.6916442)(10011.93189854,825.61324771)(10011.93195437,811.97991901)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(10256.31341044,706.6704145)
\lineto(10288.93233502,701.127809)
\curveto(10282.24111951,643.15340541)(10258.87470172,614.16624471)(10218.83301154,614.16623993)
\curveto(10192.80053597,614.16624471)(10173.40693194,626.3344814)(10160.65214127,650.67098651)
\curveto(10147.89728567,675.00742816)(10141.5198741,707.56223941)(10141.51988743,748.33551792)
\curveto(10141.5198741,792.29393992)(10148.26320273,825.99549599)(10161.74989354,849.44028722)
\curveto(10175.23651723,872.88461747)(10194.68239512,884.60689784)(10220.08758556,884.60716351)
\curveto(10259.39744037,884.60689784)(10282.45021497,854.91894864)(10289.24597852,795.54322684)
\lineto(10256.31341044,789.61837268)
\curveto(10252.75865948,829.11719022)(10240.73567046,848.86668432)(10220.24440731,848.86691424)
\curveto(10192.85280984,848.86668432)(10179.15705713,814.5280478)(10179.15710809,745.85090166)
\curveto(10179.15705713,681.88789707)(10192.85280984,649.90645823)(10220.24440731,649.9064892)
\curveto(10231.22182697,649.90645823)(10239.40268689,654.78012371)(10244.78701162,664.52750026)
\curveto(10250.17110315,674.27478564)(10254.01323225,688.32240967)(10256.31341044,706.6704145)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(10331.53618473,879.82905532)
\lineto(10364.31193106,879.82905532)
\lineto(10364.31193106,786.36925911)
\curveto(10371.73476802,806.50083406)(10384.33276956,816.56670525)(10402.10597347,816.56690288)
\curveto(10411.20153633,816.56670525)(10418.8596576,814.01838343)(10425.08036024,808.92192977)
\curveto(10431.30083754,803.82509615)(10435.63956836,797.04018931)(10438.09656572,788.56718888)
\curveto(10440.5533117,780.09384921)(10441.78174753,764.07127576)(10441.78187691,740.49942048)
\lineto(10441.78187691,618.94434812)
\lineto(10409.16295234,618.94434812)
\lineto(10409.16295234,740.49942048)
\curveto(10409.16285558,760.63104131)(10407.28099643,773.02225616)(10403.51736924,777.67310221)
\curveto(10399.75355983,782.3236308)(10395.10118581,784.64897446)(10389.56023325,784.64914016)
\curveto(10372.72797146,784.64897446)(10364.31187915,766.23734931)(10364.31193106,729.41420948)
\lineto(10364.31193106,618.94434812)
\lineto(10331.53618473,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(10527.9817591,837.97282757)
\lineto(10493.794617,837.97282757)
\lineto(10493.794617,880.21130397)
\lineto(10527.9817591,880.21130397)
\closepath
\moveto(10494.57872577,811.97991901)
\lineto(10527.19765034,811.97991901)
\lineto(10527.19765034,618.94434812)
\lineto(10494.57872577,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(10580.9357951,811.97991901)
\lineto(10611.20239338,811.97991901)
\lineto(10611.20239338,782.1645239)
\curveto(10618.52068496,805.09925706)(10631.58915129,816.56670525)(10650.40783156,816.56690288)
\curveto(10661.07161133,816.56670525)(10669.67066217,813.44501102)(10676.20500989,807.20181082)
\curveto(10682.7391285,800.95823411)(10686.86876386,793.47253876)(10688.59392836,784.74470233)
\curveto(10690.31883897,776.01653429)(10691.18135774,762.22374244)(10691.18148728,743.3662854)
\lineto(10691.18148728,618.94434812)
\lineto(10658.56256271,618.94434812)
\lineto(10658.56256271,741.2639178)
\curveto(10658.56246579,758.08271949)(10657.36016689,769.51831365)(10654.95566239,775.5707346)
\curveto(10652.55097128,781.6228423)(10647.42813248,784.64897446)(10639.58713062,784.64914016)
\curveto(10631.4323297,784.64897446)(10625.08105506,780.79463771)(10620.53328767,773.08611834)
\curveto(10615.9854025,765.3772907)(10613.71148936,750.05550575)(10613.71154142,727.12071755)
\lineto(10613.71154142,618.94434812)
\lineto(10580.9357951,618.94434812)
\closepath
}
}
{
\newrgbcolor{curcolor}{0.17254902 0.17254902 0.16862746}
\pscustom[linestyle=none,fillstyle=solid,fillcolor=curcolor]
{
\newpath
\moveto(10773.14773502,757.31836131)
\lineto(10741.62656271,762.09646951)
\curveto(10743.71750023,779.29749864)(10750.22559646,792.67618819)(10761.15087093,802.2325783)
\curveto(10772.07607216,811.78860184)(10785.48431861,816.56670525)(10801.37565051,816.56690288)
\curveto(10815.59406503,816.56670525)(10826.96363074,813.09461677)(10835.48438173,806.15062702)
\curveto(10844.00491083,799.20626285)(10849.36298202,790.95607096)(10851.55861139,781.40002659)
\curveto(10853.75398671,771.84365731)(10854.85173788,757.38193099)(10854.8518682,738.01480423)
\lineto(10854.8518682,672.26803553)
\curveto(10854.85173788,645.63801919)(10855.79266745,627.86347449)(10857.67465975,618.94434812)
\lineto(10826.78077446,618.94434812)
\curveto(10825.42155171,625.95223313)(10824.74199146,636.65518477)(10824.74209167,651.05323516)
\curveto(10814.80995705,626.46189749)(10799.9641793,614.16624471)(10780.20471389,614.16623993)
\curveto(10766.8225487,614.16624471)(10756.08026938,619.16732628)(10747.9778437,629.16949965)
\curveto(10739.87537113,639.17165257)(10735.82414657,652.77332028)(10735.82415786,669.9745436)
\curveto(10735.82414657,690.99814758)(10741.75723028,707.62594745)(10753.6234268,719.8579931)
\curveto(10765.48956513,732.08983692)(10786.05933113,738.20580929)(10815.33278651,738.20592855)
\curveto(10816.79636393,738.20580929)(10819.09641401,738.14210125)(10822.23294363,738.01480423)
\lineto(10822.23294363,745.85090166)
\curveto(10822.23284593,759.61171258)(10820.5339453,769.99612399)(10817.13623666,777.00416706)
\curveto(10813.73834281,784.011894)(10807.64843751,787.51583651)(10798.86650247,787.51600508)
\curveto(10784.54338904,787.51583651)(10775.97047513,777.44996532)(10773.14773502,757.31836131)
\closepath
\moveto(10822.23294363,712.97751731)
\curveto(10818.0509367,713.48708764)(10814.86223092,713.74191982)(10812.66681671,713.74201462)
\curveto(10784.22974585,713.74191982)(10770.01125448,700.17210613)(10770.01129996,673.03253284)
\curveto(10770.01125448,653.28298465)(10777.0682263,643.40823759)(10791.18223658,643.40826206)
\curveto(10799.44144065,643.40823759)(10806.681371,648.75971342)(10812.90204934,659.46270558)
\curveto(10819.12255094,670.1656167)(10822.23284593,684.88217521)(10822.23294363,703.61242526)
\closepath
}
}
\end{pspicture}

\end{document}
\end{filecontents*}

    \immediate\write18{latex logo}%
    \immediate\write18{dvips logo}%
    \IfFileExists{logo.dvi}{
    \immediate\write18{ps2pdf logo.ps}%
    }{}
\newcommand{\uestclogo}{
\IfFileExists{logo.pdf}{\includegraphics[width=13cm]{logo.pdf}}{
{\zihao{6}此文档不是用正确编译脚本生成的。请用compile.bat或compile.sh生成才能保证编译结果完全正确，包括此处的LOGO。
如果您是从MikTeX或CTAN.org处得到的此模板，请访问\url{https://github.com/shifujun/UESTCthesis}获取最新版本和相应的编译脚本。}
}
}
\newcommand{\uestclogobadge}{
\IfFileExists{logo.pdf}{\includegraphics*[height=5cm,trim=0 0 140cm 0]{logo.pdf}}{
{\zihao{6}此文档不是用正确编译脚本生成的。请用compile.bat或compile.sh生成才能保证编译结果完全正确，包括此处的LOGO。
如果您是从MikTeX或CTAN.org处得到的此模板，请访问\url{https://github.com/shifujun/UESTCthesis}获取最新版本和相应的编译脚本。}
}
}
\ifdefstring{\degree@uestcthesis}{bachelor}{
\renewcommand{\bachelortitlepage@uestcthesis}{
\renewcommand{\maketitle}{
\begin{titlepage}
\begin{center}
\zihao{3}
\uestclogo\\
\vspace{1cm}
\resizebox{!}{1cm}{\zihao{0} 学\hspace{0.75em}士\hspace{0.75em}学\hspace{0.75em}位\hspace{0.75em}论\hspace{0.75em}文}\\[3mm]
{\bf BACHELOR DISSERTATION}\\[1cm]
\renewcommand{\ULthickness}{0.8pt}
\renewcommand{\CJKunderlinecolor}{\color{black}}
\linespread{1.25}
\noindent
\parbox[t][14ex][t]{\linewidth}{\centering
{\heiti\zihao{3} 论文题目}\zihao{3}{\uline{\@title}}
}\\[3mm]
\linespread{1.391}
\renewcommand{\ULthickness}{0.4pt}
{\zihao{3}学生姓名~}\makebox[20em][c]{\uline{\hfill\@author\hfill}}\\[5mm]
{\zihao{3}学\qquad 号~}\makebox[20em][c]{\uline{\hfill\@stuid\hfill}}\\[5mm]
{\zihao{3}专\qquad 业~}\makebox[20em][c]{\uline{\hfill\@major\hfill}}\\[5mm]
{\zihao{3}学\qquad 院~}\makebox[20em][c]{\uline{\hfill\@school\hfill}}\\[5mm]
{\zihao{3}指导教师~}\makebox[20em][c]{\uline{\hfill\@advisername\hfill}}\\[5mm]
{\zihao{3}指导单位~}\makebox[20em][c]{\uline{\hfill\@university\hfill}}\\[5mm]
{\zihao{3}\@date}
\end{center}
\end{titlepage}}}}{}
\ifdefstring{\degree@uestcthesis}{master}{
\renewcommand{\mastertitlepage@uestcthesis}{
\renewcommand{\maketitle}{%定义封面的格式
\begin{titlepage}
\begin{center}
{\zihao{2}电\enspace{}子\enspace{}科\enspace{}技\enspace{}大\enspace{}学}\\
{\zihao{-4}UNIVERSITY OF ELECTRONIC SCIENCE AND TECHNOLOGY OF CHINA}\\
~\\
~\\
{\zihao{0}硕士学位论文}\\[12bp]
{\bf\zihao{3}MASTER THESIS}\\[2cm]
\uestclogobadge\\[2cm]
\renewcommand{\ULthickness}{0.8pt}
\renewcommand{\CJKunderlinecolor}{\color{black}}
\linespread{1.25}
\noindent
\parbox[t][14ex][t]{\linewidth}{\centering
{\zihao{-2} 论文题目~~}{\zihao{3}\uline{\@title}}
}\\[3mm]
\linespread{1.391}
\renewcommand{\ULthickness}{0.4pt}
{\zihao{3}~}\\
{\zihao{3}学科专业~}\makebox[20em][c]{\zihao{3}\uline{\hfill\@major\hfill}}\\[5mm]
{\zihao{3}学\qquad 号~}\makebox[20em][c]{\zihao{3}\uline{\hfill\@stuid\hfill}}\\[5mm]
{\zihao{3}作者姓名~}\makebox[20em][c]{\zihao{3}\uline{\hfill\@author\hfill}}\\[5mm]
{\zihao{3}指导教师~}\makebox[20em][c]{\zihao{3}\uline{\hfill\@advisername\hfill}}\\[5mm]
\end{center}
\newpage
\thispagestyle{empty}
\noindent
{\zihao{-4}分类号}\makebox[15em][l]{\zihao{-4}\uline{~~~\@classnumber\hfill}}
{\zihao{-4}密级}\makebox[15em][l]{\zihao{-4}\uline{~~~\@securityclassification\hfill}}\\
{\zihao{-4}UDC\textsuperscript{注1}\!}\makebox[15em][l]{\zihao{-4}\uline{~~~\@UDC\hfill}}\\
\begin{center}
{\zihao{-0}学\quad{}位\quad{}论\quad{}文}\\
{\zihao{3}~}\\
\makebox[\linewidth][c]{\zihao{3}\uline{\hfill\@title\hfill}}\\
{\zihao{-4}（题名和副题名）}\\
{\zihao{5}~}\\
{\zihao{5}~}\\
\makebox[10em][c]{\zihao{3}\uline{\hfill\@author\hfill}}\\
{\zihao{-4}（作者姓名）}\\
{\zihao{-4}~}\\
{\zihao{5}~}\\
{\zihao{-4}指导教师}\makebox[29em][c]{\zihao{-4}\uline{\hfill\@advisername 、\@advisertitle 、\@adviserinstitution \hfill}}\\[5bp]
{\zihao{-4}\qquad\qquad}\makebox[29em][c]{\zihao{-4}\uline{\hfill\ifthenelse{\isundefined{\@adviserBname}}{}{\@adviserBname 、\@adviserBtitle 、\@adviserBinstitution }\hfill}}\\[5bp]
{\zihao{-4}\qquad\qquad}\makebox[29em][c]{\zihao{-4}\uline{\hfill\ifthenelse{\isundefined{\@adviserCname}}{}{\@adviserBname 、\@adviserCtitle 、\@adviserCinstitution }\hfill}}\\[5bp]
{\zihao{-4}\qquad\qquad}\makebox[29em][c]{\zihao{-4}\uline{\hfill\ifthenelse{\isundefined{\@adviserDname}}{}{\@adviserBname 、\@adviserDtitle 、\@adviserDinstitution }\hfill}}\\[5bp]
{\zihao{-4}（姓名、职称、单位名称）}\\[8bp]
\end{center}
{\zihao{-4}申请学位级别}\makebox[10em][l]{\zihao{-4}\uline{\hfill\@degree\hfill}}
{\zihao{-4}学科专业}\makebox[15em][l]{\zihao{-4}\uline{\hfill\@major\hfill}}\\[13bp]
{\zihao{-4}提交论文日期}\makebox[10em][l]{\zihao{-4}\uline{\hfill\@date\hfill}}
{\zihao{-4}论文答辩日期}\makebox[13em][l]{\zihao{-4}\uline{\hfill\@oraldefensedate\hfill}}\\[13bp]
{\zihao{-4}学位授予单位和日期}\makebox[26em][l]{\zihao{3}\uline{\hfill 电子科技大学\hfill\@awarddate}}\\[13bp]
{\zihao{-4}答辩委员会主席}\makebox[16em][l]{\zihao{-4}\uline{\hfill\@chairman\hfill}}\\[13bp]
{\zihao{-4}评阅人}\makebox[32em][l]{\zihao{-4}\uline{\hfill\@appraiser\hfill}}\\
\vfill
{\zihao{5}注1：注明《国际十进分类法UDC》的类号。}
\newpage
\thispagestyle{empty}
\begin{center}
{\zihao{-4}~}\\
{\zihao{-4}~}\\
{\zihao{-4}~}\\
{\bf\zihao{-2}\@englishtitle}\\
\vfill
{\zihao{-3}A Thesis Submitted to}\\[1ex]
{\zihao{-3}University of Electronic Science and Technology of China}\\
\vspace{3cm}
\makebox[6em][r]{\zihao{4}Major:}\makebox[25em][l]{\zihao{4}\uline{\hfill\@englishmajor\hfill}}\\[1ex]
\makebox[6em][r]{\zihao{4}Author:}\makebox[25em][l]{\zihao{4}\uline{\hfill\@englishauthor\hfill}}\\[1ex]
\makebox[6em][r]{\zihao{4}Advisor:}\makebox[25em][l]{\zihao{4}\uline{\hfill\@englishadvisor\hfill}}\\[1ex]
\makebox[6em][r]{\zihao{4}School:}\makebox[25em][l]{\zihao{4}\uline{\hfill\@englishshcool\hfill}}\\[1ex]
\end{center}
\newpage
\thispagestyle{empty}
\linespread{1.5}
\begin{center}
{\bf\zihao{-2}独创性声明}\par
\end{center}
{\zihao{4}\qquad 本人声明所呈交的学位论文是本人在导师指导下进行的研究工作及取得的研究成果。据我所知，除了文中特别加以标注和致谢的地方外，论文中不包含其他人已经发表或撰写过的研究成果，也不包含为获得电子科技大学或其它教育机构的学位或证书而使用过的材料。与我一同工作的同志对本研究所做的任何贡献均已在论文中作了明确的说明并表示谢意。\par
~\par
作者签名：\makebox[5em][l]{\uline{\hfill}}\hfill
日期：\qquad{}年\qquad{}月\qquad{}日 \par
~\par
\begin{center}
{\bf\zihao{-2}论文使用授权}\par
\end{center}
{\zihao{4}\qquad 本学位论文作者完全了解电子科技大学有关保留、使用学位论文的规定，有权保留并向国家有关部门或机构送交论文的复印件和磁盘，允许论文被查阅和借阅。本人授权电子科技大学可以将学位论文的全部或部分内容编入有关数据库进行检索，可以采用影印、缩印或扫描等复制手段保存、汇编学位论文。\par
（保密的学位论文在解密后应遵守此规定） \par
~\par
}
\qquad 作者签名：\makebox[5em][l]{\uline{\hfill}}\hfill
导师签名：\makebox[7em][l]{\uline{\hfill}}\par
\hfill 日期：\qquad{}年\qquad{}月\qquad{}日 \par
}
\linespread{1.391}
\end{titlepage}}}}{}
\ifdefstring{\degree@uestcthesis}{doctor}{
\renewcommand{\doctortitlepage@uestcthesis}{
\renewcommand{\maketitle}{%定义封面的格式
\begin{titlepage}
\begin{center}
{\zihao{2}电\enspace{}子\enspace{}科\enspace{}技\enspace{}大\enspace{}学}\\
{\zihao{-4}UNIVERSITY OF ELECTRONIC SCIENCE AND TECHNOLOGY OF CHINA}\\
~\\
~\\
{\zihao{0}博士学位论文}\\[12bp]
{\bf\zihao{3}DOCTORAL DISSERTATION}\\[2cm]
\uestclogobadge\\[2cm]
\renewcommand{\ULthickness}{0.8pt}
\renewcommand{\CJKunderlinecolor}{\color{black}}
\linespread{1.25}
\noindent
\parbox[t][14ex][t]{\linewidth}{\centering
{\zihao{-2} 论文题目~~}{\zihao{3}\uline{\@title}}
}\\[3mm]
\linespread{1.391}
\renewcommand{\ULthickness}{0.4pt}
{\zihao{3}~}\\
{\zihao{3}学科专业~}\makebox[20em][c]{\zihao{3}\uline{\hfill\@major\hfill}}\\[5mm]
{\zihao{3}学\qquad 号~}\makebox[20em][c]{\zihao{3}\uline{\hfill\@stuid\hfill}}\\[5mm]
{\zihao{3}作者姓名~}\makebox[20em][c]{\zihao{3}\uline{\hfill\@author\hfill}}\\[5mm]
{\zihao{3}指导教师~}\makebox[20em][c]{\zihao{3}\uline{\hfill\@advisername\hfill}}\\[5mm]
\end{center}
\newpage
\thispagestyle{empty}
\noindent
{\zihao{-4}分类号}\makebox[15em][l]{\zihao{-4}\uline{~~~\@classnumber\hfill}}
{\zihao{-4}密级}\makebox[15em][l]{\zihao{-4}\uline{~~~\@securityclassification\hfill}}\\
{\zihao{-4}UDC\textsuperscript{注1}\!}\makebox[15em][l]{\zihao{-4}\uline{~~~\@UDC\hfill}}\\
\begin{center}
{\zihao{-0}学\quad{}位\quad{}论\quad{}文}\\
{\zihao{3}~}\\
\makebox[\linewidth][c]{\zihao{3}\uline{\hfill\@title\hfill}}\\
{\zihao{-4}（题名和副题名）}\\
{\zihao{5}~}\\
{\zihao{5}~}\\
\makebox[10em][c]{\zihao{3}\uline{\hfill\@author\hfill}}\\
{\zihao{-4}（作者姓名）}\\
{\zihao{-4}~}\\
{\zihao{5}~}\\
{\zihao{-4}指导教师}\makebox[29em][c]{\zihao{-4}\uline{\hfill\@advisername 、\@advisertitle 、\@adviserinstitution \hfill}}\\[5bp]
{\zihao{-4}\qquad\qquad}\makebox[29em][c]{\zihao{-4}\uline{\hfill\ifthenelse{\isundefined{\@adviserBname}}{}{\@adviserBname 、\@adviserBtitle 、\@adviserBinstitution }\hfill}}\\[5bp]
{\zihao{-4}\qquad\qquad}\makebox[29em][c]{\zihao{-4}\uline{\hfill\ifthenelse{\isundefined{\@adviserCname}}{}{\@adviserBname 、\@adviserCtitle 、\@adviserCinstitution }\hfill}}\\[5bp]
{\zihao{-4}\qquad\qquad}\makebox[29em][c]{\zihao{-4}\uline{\hfill\ifthenelse{\isundefined{\@adviserDname}}{}{\@adviserBname 、\@adviserDtitle 、\@adviserDinstitution }\hfill}}\\[5bp]
{\zihao{-4}（姓名、职称、单位名称）}\\[8bp]
\end{center}
{\zihao{-4}申请学位级别}\makebox[10em][l]{\zihao{-4}\uline{\hfill\@degree\hfill}}
{\zihao{-4}学科专业}\makebox[15em][l]{\zihao{-4}\uline{\hfill\@major\hfill}}\\[13bp]
{\zihao{-4}提交论文日期}\makebox[10em][l]{\zihao{-4}\uline{\hfill\@date\hfill}}
{\zihao{-4}论文答辩日期}\makebox[13em][l]{\zihao{-4}\uline{\hfill\@oraldefensedate\hfill}}\\[13bp]
{\zihao{-4}学位授予单位和日期}\makebox[26em][l]{\zihao{3}\uline{\hfill 电子科技大学\hfill\@awarddate}}\\[13bp]
{\zihao{-4}答辩委员会主席}\makebox[16em][l]{\zihao{-4}\uline{\hfill\@chairman\hfill}}\\[13bp]
{\zihao{-4}评阅人}\makebox[32em][l]{\zihao{-4}\uline{\hfill\@appraiser\hfill}}\\
\vfill
{\zihao{5}注1：注明《国际十进分类法UDC》的类号。}
\newpage
\thispagestyle{empty}
\begin{center}
{\zihao{-4}~}\\
{\zihao{-4}~}\\
{\zihao{-4}~}\\
{\bf\zihao{-2}\@englishtitle}\\
\vfill
{\zihao{-3}A Doctor Dissertation Submitted to}\\[1ex]
{\zihao{-3}University of Electronic Science and Technology of China}\\
\vspace{3cm}
\makebox[6em][r]{\zihao{4}Major:}\makebox[25em][l]{\zihao{4}\uline{\hfill\@englishmajor\hfill}}\\[1ex]
\makebox[6em][r]{\zihao{4}Author:}\makebox[25em][l]{\zihao{4}\uline{\hfill\@englishauthor\hfill}}\\[1ex]
\makebox[6em][r]{\zihao{4}Advisor:}\makebox[25em][l]{\zihao{4}\uline{\hfill\@englishadvisor\hfill}}\\[1ex]
\makebox[6em][r]{\zihao{4}School:}\makebox[25em][l]{\zihao{4}\uline{\hfill\@englishshcool\hfill}}\\[1ex]
\end{center}
\newpage
\thispagestyle{empty}
\linespread{1.5}
\begin{center}
{\bf\zihao{-2}独创性声明}\par
\end{center}
{\zihao{4}\qquad 本人声明所呈交的学位论文是本人在导师指导下进行的研究工作及取得的研究成果。据我所知，除了文中特别加以标注和致谢的地方外，论文中不包含其他人已经发表或撰写过的研究成果，也不包含为获得电子科技大学或其它教育机构的学位或证书而使用过的材料。与我一同工作的同志对本研究所做的任何贡献均已在论文中作了明确的说明并表示谢意。\par
~\par
作者签名：\makebox[5em][l]{\uline{\hfill}}\hfill
日期：\qquad{}年\qquad{}月\qquad{}日 \par
~\par
\begin{center}
{\bf\zihao{-2}论文使用授权}\par
\end{center}
{\zihao{4}\qquad 本学位论文作者完全了解电子科技大学有关保留、使用学位论文的规定，有权保留并向国家有关部门或机构送交论文的复印件和磁盘，允许论文被查阅和借阅。本人授权电子科技大学可以将学位论文的全部或部分内容编入有关数据库进行检索，可以采用影印、缩印或扫描等复制手段保存、汇编学位论文。\par
（保密的学位论文在解密后应遵守此规定） \par
~\par
}
\qquad 作者签名：\makebox[5em][l]{\uline{\hfill}}\hfill
导师签名：\makebox[7em][l]{\uline{\hfill}}\par
\hfill 日期：\qquad{}年\qquad{}月\qquad{}日 \par
}
\linespread{1.391}
\end{titlepage}}}}{}
\titlepage@degree
\setcounter{secnumdepth}{3}
\chaptername@uestcthesis
\CTEXsetup[ nameformat={},
            numberformat={},
            titleformat={},
            aftername={~},
            beforeskip={2mm},%章标题段前30磅，这里2mm是由于实际效果与MS WORD有差异而微调出的。具体测量的是页眉线到章标题文字上边的距离。
            afterskip={30bp plus 6bp minus 6bp},%章标题段后30磅。
            format={\heiti\zihao{-3}\centering},
            ]{chapter}
\CTEXsetup[ aftername={~},
            beforeskip={18bp},
            afterskip={18bp plus 3.6bp minus 3.6bp},
            format={\heiti\zihao{4}\flushleft}]{section}
\CTEXsetup[ aftername={~},
            beforeskip={12bp},
            afterskip={12bp plus 2.4bp minus 2.4bp},
            format={\heiti\zihao{4}\flushleft}]{subsection}
\CTEXsetup[ aftername={~},
            beforeskip={6bp},
            afterskip={6bp plus 1.2bp minus 1.2bp},
            format={\heiti\zihao{-4}\flushleft}]{subsubsection}
\newenvironment{Cabstract}[5]{
\newcommand{\@ckeywords}{
\ifthenelse{\equal{#1}{}}{必选关键词}{#1}%
\ifthenelse{\equal{#2}{}}{必选关键词}{，#2}%
\ifthenelse{\equal{#3}{}}{必选关键词}{，#3}%
\ifthenelse{\equal{#4}{}}{}{，#4}%
\ifthenelse{\equal{#5}{}}{}{，#5}%
}
\ifthenelse{\equal{#5}{}}{
\ifthenelse{\equal{#4}{}}{
\ifthenelse{\equal{#3}{}}{
\def\@pdfckeywords{#1, #2, 关键字应3-5个}
}{\def\@pdfckeywords{#1, #2, #3}}
}{\def\@pdfckeywords{#1, #2, #3, #4}}
}{\def\@pdfckeywords{#1, #2, #3, #4, #5}}
\hypersetup{%
pdfkeywords={\@pdfckeywords}%在pdf元信息中加入关键字
}
\chapter*{摘要}%插入不带章号的摘要
}
{\\[3mm]%摘要后换行空出3mm
{\heiti 关键词：}\@ckeywords%插入关键词
}
\newenvironment{Eabstract}[5]{
\newcommand{\@ekeywords}{
\ifthenelse{\equal{#1}{}}{必选关键词}{#1}%
\ifthenelse{\equal{#2}{}}{必选关键词}{, #2}%
\ifthenelse{\equal{#3}{}}{必选关键词}{, #3}%
\ifthenelse{\equal{#4}{}}{}{, #4}%
\ifthenelse{\equal{#5}{}}{}{, #5}%
}
\Eabstractmatter%设置英文摘要版式
\chapter*{ABSTRACT}%插入不带章号的ABSTRACT
}
{\\[3mm]%摘要后换行空出3mm
{\heiti Keywords:}\@ekeywords%插入关键词
}
\CTEXoptions[contentsname={\protect\heiti\protect\zihao{-3}目\enspace 录}]
\setcounter{tocdepth}{3}
\def\@dotsep{2}
\def\l@chapter#1#2{\ifnum 0>\c@tocdepth \else \vskip \z@ \@plus .2\p@ {\leftskip
0em\relax \rightskip \@tocrmarg \parfillskip -\rightskip \parindent 0em\relax
\@afterindenttrue \interlinepenalty \@M \leavevmode \@tempdima 1em\relax \advance
\leftskip \@tempdima \null \nobreak \hskip -\leftskip {\heiti #1}\nobreak \leaders
\hbox {$\m@th \mkern \@dotsep mu\hbox {.}\mkern \@dotsep mu$}\hfill \nobreak
\hb@xt@ \@pnumwidth {\hfil \normalfont \normalcolor #2}\par }\fi}
\ifdefstring{\degree@uestcthesis}{bachelor}{
\renewcommand*\l@section{\@dottedtocline{1}{1em}{1em}}
\renewcommand*\l@subsection{\@dottedtocline{2}{2em}{1em}}
\renewcommand*\l@subsubsection{\@dottedtocline{3}{3em}{1em}}
}{
\renewcommand*\l@section{\@dottedtocline{1}{2em}{1em}}
\renewcommand*\l@subsection{\@dottedtocline{2}{4em}{1em}}
\renewcommand*\l@subsubsection{\@dottedtocline{3}{6em}{1em}}
}
\RequirePackage{amsmath,kmath}
\renewcommand{\theequation}{\arabic{chapter}\textendash\arabic{equation}}
\RequirePackage[amsmath,thmmarks]{ntheorem}
\theorembodyfont{\normalfont}%字体
\theoremheaderfont{\normalfont \bfseries \hspace*{2em}}%设置缩进
\theoremseparator{\enskip}%分隔符是一个空格
\theoremsymbol{}%定义环境结束符，下同
\newtheorem{dingyi}{定义}[section]
\def\enddingyi{\quad\@endtheorem}%修正环境中最后一个字符不是英文字符时，不显示结束符的BUG。下同。
\theoremsymbol{}
\newtheorem{gongli}{公理}[section]
\def\endgongli{\quad\@endtheorem}
\theoremsymbol{}
\newtheorem{dingli}{定理}[section]
\def\enddingli{\quad\@endtheorem}
\theoremsymbol{}
\newtheorem{yinli}{引理}[section]
\def\endyinli{\quad\@endtheorem}
\theoremstyle{nonumberplain}
\theoremsymbol{}
\newtheorem{zhengming}{证明}
\def\endzhengming{\quad\@endtheorem}
\RequirePackage[numbers,sort&compress]{natbib}

\newcommand{\citeup}[1]{\textsuperscript{\cite{#1}}}
\ifblank{\multibibflag@uestcthesis}{}{
\RequirePackage[resetlabels]{multibib}
\newcites{publications}{NULL}
\bibliographystylepublications{uestcthesis}
\nocitepublications{*}
\def\bibliographypublications#1{\let \temp@auxout \@auxout \let \addtocontents
\mb@addtocontents \let \@auxout \@auxoutpublications \let \jobname
\@auxoutpublicationsname \bibliography {#1}}
}
\RequirePackage{cmap}%pdflatex编译时，可以生成可复制、粘贴的中文PDF文档
\RequirePackage{hyperxmp}%在pdf中加入XMP高级元信息
\RequirePackage[pdftex,unicode,
            bookmarksnumbered=true,
            bookmarksopen=true,
            colorlinks=false,
            pdfborder={0 0 1},
            citecolor=blue,
            linkcolor=red,
            anchorcolor=green,
            urlcolor=blue,
            breaklinks=true,
pdfdisplaydoctitle=true
]{hyperref}
\input{contents/titlepage.tex}%pdf元信息中需要封面的部分内容，所以在此处导入封面信息
\hypersetup{%
pdftitle={\@title},
pdfauthor={\@author},
pdfcopyright={Copyright (C) \@year, \@author},
pdfsubject={\thesisname@degree},
pdflicenseurl={http://121.49.98.197/tasi/doc/fj_dcx.doc},
pdfcreator={PDFLaTeX with uestcthesis class},
pdflang={zh-CN},
pdfpagelayout={TwoPageRight}
}
\RequirePackage[small]{subfigure}
\RequirePackage{enumerate}
\newskip\@topsepadd@uestcthesis
\def\@trivlist@uestcthesis{\if@noskipsec \leavevmode \fi \@topsepadd@uestcthesis \topsep \ifvmode \advance \@topsepadd \partopsep \else \unskip \par \fi \if@inlabel \@noparitemtrue \@noparlisttrue \else \if@newlist \@noitemerr \fi \@noparlistfalse \@topsep \@topsepadd \fi \advance \@topsep \parskip \leftskip \z@skip \rightskip \@rightskip \parfillskip \@flushglue \par@deathcycles \z@ \@setpar {\if@newlist \advance \par@deathcycles \@ne \ifnum \par@deathcycles >\@m \@noitemerr {\@@par }\fi \else {\@@par }\fi }\global \@newlisttrue \@outerparskip \parskip }

\def\list@uestcthesis#1#2{\ifnum \@listdepth >5\relax \@toodeep \else \global \advance \@listdepth \@ne \fi \rightmargin \z@ \listparindent \z@ \itemindent \z@ \csname @list\romannumeral \the \@listdepth \endcsname \def \@itemlabel {#1}\let \makelabel \@mklab \@nmbrlistfalse #2\relax \@trivlist@uestcthesis \parskip \parsep \parindent \listparindent \advance \linewidth -\rightmargin \advance \linewidth -\leftmargin \advance \@totalleftmargin \leftmargin \parshape \@ne \@totalleftmargin \linewidth \ignorespaces }

\def\@enum@{\list@uestcthesis {\csname label\@enumctr \endcsname }{\usecounter {\@enumctr }\def \makelabel ##1{\hss \llap {##1}}}}

\def\enumerate{%
 \ifnum \@enumdepth >3 \@toodeep\else
 \advance\@enumdepth \@ne
 \edef\@enumctr{enum\romannumeral\the\@enumdepth}\fi
 \@ifnextchar[{\@@enum@}{\@enum@}
 \parsep=0pt
 \itemsep=0pt
 \parskip=0pt
 \partopsep=0pt
 \topsep=0pt
 }
\RequirePackage{color,marvosym}
\DeclareOldFontCommand{\txttbf}{\ttfamily\bfseries}{\mathbf}
\providecommand{\hlstd}[1]{\textcolor[rgb]{0,0,0}{#1}}
\providecommand{\hlnum}[1]{\textcolor[rgb]{0,0,0}{#1}}
\providecommand{\hlesc}[1]{\textcolor[rgb]{0,0,0}{#1}}
\providecommand{\hlstr}[1]{\textcolor[rgb]{0,0,0}{#1}}
\providecommand{\hlpps}[1]{\textcolor[rgb]{0,0,0}{#1}}
\providecommand{\hlslc}[1]{\textcolor[rgb]{0.4,0.4,0.4}{{#1}}}
\providecommand{\hlcom}[1]{\textcolor[rgb]{0.4,0.4,0.4}{{#1}}}
\providecommand{\hlppc}[1]{\textcolor[rgb]{0,0,0}{\txttbf{#1}}}
\providecommand{\hlopt}[1]{\textcolor[rgb]{0,0,0}{\txttbf{#1}}}
\providecommand{\hlipl}[1]{\textcolor[rgb]{0,0,0}{#1}}
\providecommand{\hllin}[1]{\textcolor[rgb]{0.53,0.53,0.53}{#1}}
\providecommand{\hlkwa}[1]{\textcolor[rgb]{0,0,0}{\txttbf{#1}}}
\providecommand{\hlkwb}[1]{\textcolor[rgb]{0,0,0}{\txttbf{#1}}}
\providecommand{\hlkwc}[1]{\textcolor[rgb]{0,0,0}{\txttbf{#1}}}
\providecommand{\hlkwd}[1]{\textcolor[rgb]{0,0,0}{\txttbf{#1}}}
\definecolor{bgcolor}{rgb}{1,1,1}
\RequirePackage[header,cols=3,hyper=true]{glossary}
\makeglossary
\renewcommand{\glossaryname}{\glossaryname@uestcthesis}
\renewcommand{\entryname}{\entryname@uestcthesis}
\renewcommand{\descriptionname}{\descriptionname@uestcthesis}
\renewcommand{\glspageheader}{\glspageheader@uestcthesis}
\newcommand{\ifusingglossary}{}
\newcommand{\fuhao}[3]{
\glossary{name={#1},description={#2},sort=#3}
\renewcommand{\ifusingglossary}{true}%设置使用主要符号表
}

\AtBeginDocument{%插入到论文内容的最前面。
\begin{CJK}{UTF8}{rm}%中文支持环境，此处内容不受ctexbook文类影响，所以必须手动加这个环境。
\maketitle%生成并插入封面
\clearpage{\pagestyle{empty}\cleardoublepage}
\Cabstractmatter%设置中文摘要版式
\include{contents/Cabstract}%插入中文摘要
\clearpage{\pagestyle{empty}\cleardoublepage}
\Eabstractmatter%设置英文摘要版式
\include{contents/Eabstract}%插入英文摘要
\clearpage{\pagestyle{empty}\cleardoublepage}
\tocmatter%目录版式
\tableofcontents%插入目录
\clearpage{\pagestyle{empty}\cleardoublepage}%目录之后另起一页，这样无论目录后有没有主要符号表，主要符号表的页眉设置命令都会应用到下一页。
\glossarymatterfancy%设置主要符号表版式。
\printglossary%插入主要符号表
\clearpage{\pagestyle{empty}\cleardoublepage}
\mainmatter%修正主要符号表版式，这里是受目录版式的影响，必须在此加入\mainmatter。
\end{CJK}
\mainmatter%正文区版式
\makeatletter
\newcmds@uestcthesis%自定义图表命令，这些命令必须在document环境里声明才能在正文中使用，所以只能放在这里了。
\makeatother
}
\newcommand{\insertacknowledgement}{
\chapter*{\acknowledgementsname@uestcthesis}%用带星号的章命令插入不带章号的致谢。
\markboth{\acknowledgementsname@uestcthesis}{}%页眉设置
\phantomsection%手动添加目录项之前需要这个命令，用以更新目录超链接的跳转页码。
\addcontentsline{toc}{chapter}{\acknowledgementsname@uestcthesis}%将致谢编入目录
\input{contents/acknowledgements.tex}%插入致谢内容
}
\newcommand{\insertreference}{
\bibliographystyle{uestcthesis}
\phantomsection%手动添加目录项之前需要这个命令，用以更新目录超链接的跳转页码。
\addcontentsline{toc}{chapter}{\CTEX@bibname}%将参考文献编入目录
\nocite{*}%若将此命令屏蔽掉，则未引用的文献不会出现在文后的参考文献列表中。
{\zihao{5}
\bibliography{contents/reference}%插入参考文献
}
}
\AtEndDocument{%插入到论文内容最后面。
\begin{CJK}{UTF8}{rm}
\ifdefstring{\degree@uestcthesis}{bachelor}{%检测是否为本科论文，调换参考文献与致谢的顺序
\insertreference
\newpage
\insertacknowledgement
}{
\insertacknowledgement
\newpage
\insertreference
}

\appendix%附录版式
\renewcommand{\chaptermark}[1]{\markboth{\CTEX@appendixname\Alph{chapter}~  #1 }{}}%附录页眉设置
\input{contents/appendix.tex}%插入附录内容
\clearpage
\ifdefstring{\degree@uestcthesis}{bachelor}{

\gdef\thechapter{\@arabic \c@chapter}

\CTEXsetup[ name={,},
  number={}
  ]{chapter}

\setcounter{chapter}{0}

\def\Hy@org@chapter[#1]#2{%
\ifnum \c@secnumdepth >\m@ne \if@mainmatter \refstepcounter {chapter}
\typeout {\CTEXthechapter }\else \fi \else \fi \chaptermark {#1}\addtocontents{lof}
{\protect \addvspace {10\p@ }}\addtocontents {lot}{\protect \addvspace {10\p@ }}
\if@twocolumn \@topnewpage [\@makechapterhead {#2}]
\else
\@makechapterhead {#2}
\@afterheading \fi
}

\def\H@old@sect #1#2#3#4#5#6[#7]#8{\ifnum #2>\c@secnumdepth \let \@svsec \@empty
\else \refstepcounter {#1}\protected@edef \@svsec {\@seccntformat {#1}\relax }\fi
\@tempskipa #5\relax \ifdim \@tempskipa >\z@ \begingroup #6{\@hangfrom {\hskip #3
\relax \@svsec }\interlinepenalty \@M \csname CTEX@#1@titleformat\endcsname #8
\@@par }\endgroup \csname #1mark\endcsname {#7}\else \def \@svsechd
 {#6{\hskip #3\relax \@svsec \csname CTEX@#1@titleformat\endcsname #8}\csname #1mark
 \endcsname {#7}}\fi \@xsect {#5}}

\renewcommand{\chaptermark}[1]{\markboth{外文资料原文}{}}
\def\leftmark{外文资料原文}
\newpage
\phantomsection
\addcontentsline{toc}{chapter}{外文资料原文}

\renewcommand{\CTEX@figurename}{Figure}
\renewcommand{\CTEX@tablename}{Table}

\include{contents/original}
\newpage
\phantomsection
\addcontentsline{toc}{chapter}{外文资料译文}
\renewcommand{\chaptermark}[1]{\markboth{外文资料译文}{}}
\def\leftmark{外文资料译文}

\renewcommand{\CTEX@figurename}{图}
\renewcommand{\CTEX@tablename}{表}

\setcounter{chapter}{0}

\include{contents/translation}
}
{
\IfFileExists{contents/publications.bib}{%如果删除了publications.bib，则不显示这一章
\CTEXoptions[ bibname={\publicationsname@degree}]%设置攻博/硕期间发表的论文章题目
\phantomsection%手动添加目录项之前需要这个命令，用以更新目录超链接的跳转页码。
\addcontentsline{toc}{chapter}{\publicationsname@degree}%将攻博/硕期间发表的论文编入目录
{\zihao{5}
\bibliographypublications{contents/publications}%插入攻博/硕期间发表的论文
}}{}}
\clearpage\end{CJK}}
\endinput
%%
%% End of file `uestcthesis.cls'.
