/*
  libreiserfs - a library for manipulating reiserfs partitions
  Copyright (C) 2001-2004 Yury Umanets <torque@ukrpost.net>.

  This program is free software; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free Software
  Foundation; either version 2 of the License, or (at your option) any later
  version.
                                                                                                 
  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
  details.
                                                                                                 
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 Temple
  Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef DEBUG_H
#define DEBUG_H

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#ifdef DEBUG

#ifdef __GNUC__

#define ASSERT(cond, action)					\
	do {							\
		if (!libreiserfs_assert(cond,			\
					#cond,			\
					__FILE__,		\
					__LINE__,		\
					__PRETTY_FUNCTION__))	\
		{						\
			action;					\
		}						\
	} while (0);

#else

#define ASSERT(cond, action)				\
	do {						\
		if (!libreiserfs_assert(cond,		\
					#cond,		\
					"unknown",	\
					0,		\
					"unknown"))	\
		{					\
			action;				\
		}					\
	} while (0);

#endif

#else

#define ASSERT(cond, action) while (0) {}

#endif

extern int libreiserfs_assert(int cond, char *cond_text, char *file, int line, 
			      char *function);

#endif

