/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2007 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#ifndef QTTAPIOCA_STREAM_CHANNEL_H
#define QTTAPIOCA_STREAM_CHANNEL_H

#include <QtCore/QList>
#include <QtCore/QObject>
#include <QtCore/QString>
#include <qglobal.h>
#include <QtTapioca/Channel>
#include <QtTapioca/Stream>

namespace QtTapioca {

class Contact;
class Connection;
class ChannelTarget;
class StreamChannelPrivate;

class Q_DECL_EXPORT StreamChannel : public Channel {
    Q_OBJECT
    Q_DECLARE_PRIVATE(StreamChannel)
    Q_PROPERTY(Type type READ type)
    Q_ENUMS(Type)

public:
    ~StreamChannel();

    QList<QtTapioca::Stream *> streams() const;
    void requestStreams(const Contact *contact, QList<QtTapioca::Stream::Type> types);
    void removeStream (QtTapioca::Stream *stream);
    void join();

Q_SIGNALS:
    void newStream(QtTapioca::Stream *stream);
    void streamRemoved(QtTapioca::Stream *stream);

private Q_SLOTS:
    void onStreamAdded(uint id, uint contactHandle, uint type);
    void onStreamRemoved(uint id);

private:
    friend class Connection;

    StreamChannel(Connection *conn, const QString &serviceName, const QString &objPath, ChannelTarget *target, QObject *parent = 0);
    void updateStreamList();
    StreamChannelPrivate *d;
};

} // namespace

#endif

