//This file is part of AcetoneISO. Copyright 2006,2007,2008,2009 Marco Di Antonio and Fabrizio Di Marco (acetoneiso@gmail.com)
//
//    AcetoneISO is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    AcetoneISO is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with AcetoneISO.  If not, see <http://www.gnu.org/licenses/>.
void acetoneiso::mount()
{

  if (QMainWindow::isMinimized()) {
    QMainWindow::showNormal();
  }
  if (QMainWindow::isHidden()) {
    QMainWindow::showNormal();
  } 

QDir Home = QDir::home();// entro nella home dell'utente
QString isodamontare;
isodamontare = QFileDialog::getOpenFileName(this,tr("Open Image"), Home.path() , tr("Image Files (*.iso *.bin *.mdf *.nrg *.img)"));
  if ( isodamontare.isNull() )  {
    return;   
  }

immagine_con_percorso = isodamontare;
global_functions_mount(immagine_con_percorso);

}


//funzione che effitivamente monta l'immagine con processo fuse
void acetoneiso::Monta( QString &image, QString &destination )
{
QString alog( QDir::home().path() + "/.acetoneiso/acetoneiso.log" );
//file di log
QFile log( alog );
FUse.setReadChannel(QProcess::StandardOutput);//imposto il canale di lettura del processo
FUse.setStandardOutputFile( alog,   QIODevice::Truncate );//l'output di va nel file alog
FUse.start("fuseiso",QStringList()  << image << destination << "-o" << "nonempty"  );
}


//questa funzione si occupa di mettere l'immagine nei display e poi chiamare il file manager
void acetoneiso::openBrowser( QString &destination, QString onlyfile, float divide, QString &temporary, QString image_with_path )
{

QDir Home = QDir::home();
QFile file(Home.path() + "/.acetoneiso/acetoneiso.conf");
   file.open(QIODevice::ReadOnly);//lo apro in sola lettura
   QString strc = (leggiRigo( 3, &file ));

QDir destDir( destination );

if( destDir.count() > 2 ) { //se il contenuto della cartella montata non è nullo
QIcon icona( ":/images/Aiso2.png");
	QDir Dest( destination ); 
	QString name = Dest.dirName(); // voglio il nome della periferica virtuale per sapere quale item inserire 
	listWidget_2->insertItem(name.toInt(), " VD-" + name + " " + onlyfile + "  " + QString::number(divide) + "MB");
	
	//cronologia
	QFile history_conf(Home.path() + "/.acetoneiso/history.conf");
	history_conf.open(QIODevice::ReadWrite);
	QTextStream history_out(&history_conf);
	QString history_line = history_out.readAll();  
	//evita occorrenze nel display cronologia
	 if(!history_line.contains(image_with_path, Qt::CaseSensitive)) {
	  history_out << (image_with_path + "\n");
	  history_conf.close();
	  history->insertItem(name.toInt(), image_with_path );	 
	 }
	history_conf.close();

	QFile f1(temporary + "/" + name);
	f1.open(QIODevice::WriteOnly | QIODevice::Text);
	QTextStream out(&f1);
	out << (" VD-" + name + " " + onlyfile + "  " + QString::number(divide) + "MB");
	
	status_mounted_no_boot(); 
	
	immagine_con_percorso = name;
	openFileManager(immagine_con_percorso);
	
	
	f1.close();
	
   }
   file.close();
}




void acetoneiso::cmlMount()
{
int argNumber = qApp->arguments().size();

if( argNumber > 1  ) { //se gli argomenti presenti sono maggiori di 2 incluso il nome del programma che è argv[0]!
//tabWidget->setCurrentIndex(1);
QString isodamontare = qApp->arguments().at(1) ; //prendo l'argomento 1 da linea di comando 
//qDebug() << "STO ESEGUENDO IL MOUNT DA COMMAND LINE";

immagine_con_percorso = isodamontare; 
global_functions_mount(immagine_con_percorso);

}
  
}


//gestisce context menu del display mount
void acetoneiso::mountdisplaycontextmenu(const QPoint & posm) {
  
QIcon mount_icon( ":/images/file_manager.png" );
QIcon delete_icon( ":/images/document-revert.png" );

QMenu *userListMenum;
userListMenum = new QMenu();
QAction *mountActionm = userListMenum->addAction( mount_icon,   tr("open image in file manager") );
QAction *deleteActionm = userListMenum->addAction( delete_icon,  tr("unmount") );

    QPoint globalPos = listWidget_2->mapToGlobal(posm);    // Map the global position to the userlist
    QModelIndex t = listWidget_2->indexAt(posm);
    //immagine_con_percorso variabile globale che contiene percorso immagine
    connect( mountActionm,    SIGNAL( triggered() ), this, SLOT( openfilemanager_contextmenu() ) ); 
    connect( deleteActionm,   SIGNAL( triggered() ), this, SLOT( unmount_contextmenu() ) );

    if( t.row() >= 0 ) { //previene un segfault se clicco col destro sullo spazio vuoto
       listWidget_2->item(t.row())->setSelected(true);         // even a right click will select the item    
       immagine_con_percorso.clear();
       int row = listWidget_2->currentRow() + 1;
       immagine_con_percorso = QString::number( row ) ;
       
       QStringList smonta = listWidget_2->item(t.row())->text().split(QRegExp("\\s+"));
       
       //gestisce lo spazio nel nome altrimenti lo taglia
       int strl = smonta.size();
       smonta.removeAt(strl - 1);
       smonta.removeAt(0);
       smonta.removeAt(0);
       strl = smonta.size();
       QString h = "";
       int ss = 0;
       while (ss < strl) {
	 h = h.append(smonta[ss]);
	 ss = ss + 1;
       }
       //qDebug() << h;
       
       mountActionm->setText(tr("open ") + h + tr(" in file manager"));
       deleteActionm->setText(tr("unmount ") + h);
       userListMenum->exec(globalPos);
       
       }
}

//apri il file manager dal context menu del display monta
void acetoneiso::openfilemanager_contextmenu() {

  openFileManager(immagine_con_percorso);

}

//chiamo funzione smontaggio per display del montaggio
void acetoneiso::unmount_contextmenu() {
  umount();
}




//gestisce doppio click nel display monta
void acetoneiso::open_mounted(QListWidgetItem *item)
{
  QString vd_number(item->text());
  
  int row = listWidget_2->currentRow() + 1;
  
  immagine_con_percorso = QString::number( row ) ;
  openFileManager(immagine_con_percorso);



}



