/* Application.c generated by valac 0.10.4, the Vala compiler
 * generated from Application.vala, do not modify */

/* -*- mode: vala; c-basic-offset: 2; tab-width: 8; -*-
 * Application.vala - Application-based window management for AllTray
 * Copyright (c) 2009 Michael B. Trausch <mike@trausch.us>
 * License: GNU GPL v3.0 as published by the Free Software Foundation
 */

#include <glib.h>
#include <glib-object.h>
#include <libwnck/libwnck.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtop_glue.h>
#include <unistd.h>
#include <sys/types.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <config.h>


#define ALL_TRAY_TYPE_APPLICATION (all_tray_application_get_type ())
#define ALL_TRAY_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALL_TRAY_TYPE_APPLICATION, AllTrayApplication))
#define ALL_TRAY_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALL_TRAY_TYPE_APPLICATION, AllTrayApplicationClass))
#define ALL_TRAY_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALL_TRAY_TYPE_APPLICATION))
#define ALL_TRAY_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALL_TRAY_TYPE_APPLICATION))
#define ALL_TRAY_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALL_TRAY_TYPE_APPLICATION, AllTrayApplicationClass))

typedef struct _AllTrayApplication AllTrayApplication;
typedef struct _AllTrayApplicationClass AllTrayApplicationClass;
typedef struct _AllTrayApplicationPrivate AllTrayApplicationPrivate;

#define ALL_TRAY_TYPE_PROCESS (all_tray_process_get_type ())
#define ALL_TRAY_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALL_TRAY_TYPE_PROCESS, AllTrayProcess))
#define ALL_TRAY_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALL_TRAY_TYPE_PROCESS, AllTrayProcessClass))
#define ALL_TRAY_IS_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALL_TRAY_TYPE_PROCESS))
#define ALL_TRAY_IS_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALL_TRAY_TYPE_PROCESS))
#define ALL_TRAY_PROCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALL_TRAY_TYPE_PROCESS, AllTrayProcessClass))

typedef struct _AllTrayProcess AllTrayProcess;
typedef struct _AllTrayProcessClass AllTrayProcessClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))

#define ALL_TRAY_DEBUG_TYPE_SUBSYSTEM (all_tray_debug_subsystem_get_type ())

#define ALL_TRAY_DEBUG_TYPE_LEVEL (all_tray_debug_level_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ALL_TRAY_TYPE_CTT (all_tray_ctt_get_type ())
#define ALL_TRAY_CTT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALL_TRAY_TYPE_CTT, AllTrayCtt))
#define ALL_TRAY_CTT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALL_TRAY_TYPE_CTT, AllTrayCttClass))
#define ALL_TRAY_IS_CTT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALL_TRAY_TYPE_CTT))
#define ALL_TRAY_IS_CTT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALL_TRAY_TYPE_CTT))
#define ALL_TRAY_CTT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALL_TRAY_TYPE_CTT, AllTrayCttClass))

typedef struct _AllTrayCtt AllTrayCtt;
typedef struct _AllTrayCttClass AllTrayCttClass;

typedef enum  {
	ALL_TRAY_APPLICATION_ERROR_FAILED
} AllTrayApplicationError;
#define ALL_TRAY_APPLICATION_ERROR all_tray_application_error_quark ()
struct _AllTrayApplication {
	GObject parent_instance;
	AllTrayApplicationPrivate * priv;
};

struct _AllTrayApplicationClass {
	GObjectClass parent_class;
};

struct _AllTrayApplicationPrivate {
	GList* _windows;
	WnckApplication* _wnckApp;
	GtkStatusIcon* _appIcon;
	AllTrayProcess* _process;
	gboolean _appVisible;
	gboolean _caughtWindow;
	gboolean _usingWindowIcon;
	GList* _attached_xids;
	GQueue* _window_enforce_minimize_queue;
};

typedef enum  {
	ALL_TRAY_DEBUG_SUBSYSTEM_None = 0x00,
	ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine = 0x01,
	ALL_TRAY_DEBUG_SUBSYSTEM_Display = 0x02,
	ALL_TRAY_DEBUG_SUBSYSTEM_TrayIcon = 0x04,
	ALL_TRAY_DEBUG_SUBSYSTEM_WindowManager = 0x08,
	ALL_TRAY_DEBUG_SUBSYSTEM_Process = 0x10,
	ALL_TRAY_DEBUG_SUBSYSTEM_Misc = 0x20,
	ALL_TRAY_DEBUG_SUBSYSTEM_Bug = 0x40,
	ALL_TRAY_DEBUG_SUBSYSTEM_Application = 0x80,
	ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper = 0x100,
	ALL_TRAY_DEBUG_SUBSYSTEM_Signal = 0x200,
	ALL_TRAY_DEBUG_SUBSYSTEM_Main = 0x400,
	ALL_TRAY_DEBUG_SUBSYSTEM_Ctt = 0x800,
	ALL_TRAY_DEBUG_SUBSYSTEM_All = ((((((((((ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine | ALL_TRAY_DEBUG_SUBSYSTEM_Display) | ALL_TRAY_DEBUG_SUBSYSTEM_TrayIcon) | ALL_TRAY_DEBUG_SUBSYSTEM_WindowManager) | ALL_TRAY_DEBUG_SUBSYSTEM_Process) | ALL_TRAY_DEBUG_SUBSYSTEM_Misc) | ALL_TRAY_DEBUG_SUBSYSTEM_Bug) | ALL_TRAY_DEBUG_SUBSYSTEM_Application) | ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper) | ALL_TRAY_DEBUG_SUBSYSTEM_Signal) | ALL_TRAY_DEBUG_SUBSYSTEM_Main) | ALL_TRAY_DEBUG_SUBSYSTEM_Ctt
} AllTrayDebugSubsystem;

typedef enum  {
	ALL_TRAY_DEBUG_LEVEL_Information,
	ALL_TRAY_DEBUG_LEVEL_Warning,
	ALL_TRAY_DEBUG_LEVEL_Error,
	ALL_TRAY_DEBUG_LEVEL_Fatal
} AllTrayDebugLevel;

typedef enum  {
	ALL_TRAY_PROCESS_ERROR_SPAWN_FAILED,
	ALL_TRAY_PROCESS_ERROR_PROCESS_DOES_NOT_EXIST,
	ALL_TRAY_PROCESS_ERROR_FAILED
} AllTrayProcessError;
#define ALL_TRAY_PROCESS_ERROR all_tray_process_error_quark ()

extern WnckScreen* all_tray_program_WnckScreen;
extern GList* all_tray_program_WnckEarlyApps;
extern GPid all_tray_program_pgid;
extern gboolean all_tray_program__ctt_enabled;
extern AllTrayCtt* all_tray_program__ctt_obj;
extern gboolean all_tray_program__initially_hide;
static gpointer all_tray_application_parent_class = NULL;

GQuark all_tray_application_error_quark (void);
GType all_tray_application_get_type (void) G_GNUC_CONST;
GType all_tray_process_get_type (void) G_GNUC_CONST;
#define ALL_TRAY_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ALL_TRAY_TYPE_APPLICATION, AllTrayApplicationPrivate))
enum  {
	ALL_TRAY_APPLICATION_DUMMY_PROPERTY,
	ALL_TRAY_APPLICATION_WNCK_APP,
	ALL_TRAY_APPLICATION_VISIBLE,
	ALL_TRAY_APPLICATION_CAUGHT_WINDOW
};
AllTrayApplication* all_tray_application_new (AllTrayProcess* p);
AllTrayApplication* all_tray_application_construct (GType object_type, AllTrayProcess* p);
GType all_tray_debug_subsystem_get_type (void) G_GNUC_CONST;
GType all_tray_debug_level_get_type (void) G_GNUC_CONST;
void all_tray_debug_notification_emit (AllTrayDebugSubsystem subsys, AllTrayDebugLevel lvl, const char* msg);
static void all_tray_application_maybe_setup (AllTrayApplication* self, WnckScreen* scr, WnckApplication* app);
static void _all_tray_application_maybe_setup_wnck_screen_application_opened (WnckScreen* _sender, WnckApplication* app, gpointer self);
static void all_tray_application_bye_wnck_app (AllTrayApplication* self, WnckScreen* scr, WnckApplication* app);
static void _all_tray_application_bye_wnck_app_wnck_screen_application_closed (WnckScreen* _sender, WnckApplication* app, gpointer self);
static void all_tray_application_maybe_update_window_count (AllTrayApplication* self, WnckScreen* scr, WnckWindow* win);
static void _all_tray_application_maybe_update_window_count_wnck_screen_window_opened (WnckScreen* _sender, WnckWindow* window, gpointer self);
static void _all_tray_application_maybe_update_window_count_wnck_screen_window_closed (WnckScreen* _sender, WnckWindow* window, gpointer self);
static gboolean all_tray_application_are_we_interested (AllTrayApplication* self, gint pid);
GPid all_tray_process_get_pid (AllTrayProcess* self);
GQuark all_tray_process_error_quark (void);
void all_tray_process_run_kinda_fake (AllTrayProcess* self, gint pid, GError** error);
void all_tray_application_maybe_setup_for_pid (AllTrayApplication* self, WnckApplication* app, gint pid);
static void all_tray_application_do_setup (AllTrayApplication* self, WnckScreen* scr, WnckApplication* app, gint pid);
gboolean all_tray_process_get_timer_running (AllTrayProcess* self);
guint all_tray_process_get_timer_event_source (AllTrayProcess* self);
static void all_tray_application_on_ctt (AllTrayApplication* self, gulong XID);
static void all_tray_application_set_visibility_for_window (AllTrayApplication* self, WnckWindow* w, gboolean set_visible);
gpointer all_tray_ctt_ref (gpointer instance);
void all_tray_ctt_unref (gpointer instance);
GParamSpec* all_tray_param_spec_ctt (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void all_tray_value_set_ctt (GValue* value, gpointer v_object);
void all_tray_value_take_ctt (GValue* value, gpointer v_object);
gpointer all_tray_value_get_ctt (const GValue* value);
GType all_tray_ctt_get_type (void) G_GNUC_CONST;
static void _all_tray_application_on_ctt_all_tray_ctt_activate (AllTrayCtt* _sender, gulong XID, gpointer self);
void all_tray_ctt_attach (AllTrayCtt* self, gulong window_id);
static void all_tray_application_create_icon (AllTrayApplication* self);
static void all_tray_application_display_menu (AllTrayApplication* self, guint button, guint activate_time);
static void _all_tray_application_display_menu_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self);
static void all_tray_application_update_icon_win_image (AllTrayApplication* self, WnckWindow* win);
static void all_tray_application_update_icon_app_image (AllTrayApplication* self, WnckApplication* app);
static void all_tray_application_hide_all_windows (AllTrayApplication* self);
static GtkMenu* all_tray_application_create_window_list_menu (AllTrayApplication* self);
static void all_tray_application_on_menu_undock (AllTrayApplication* self);
static void _all_tray_application_on_menu_undock_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void all_tray_application_on_menu_about (AllTrayApplication* self);
static void _all_tray_application_on_menu_about_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void all_tray_application_on_menu_toggle_app (AllTrayApplication* self, GtkMenuItem* item);
static void _all_tray_application_on_menu_toggle_app_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda0_ (GtkMenuItem* item, AllTrayApplication* self);
static void all_tray_application_toggle_window_visibility (AllTrayApplication* self, WnckWindow* w);
static void __lambda0__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _all_tray_application_update_ctt_state (AllTrayApplication* self);
static void _all_tray_application_update_icon_win_image_wnck_window_icon_changed (WnckWindow* _sender, gpointer self);
static void _all_tray_application_update_icon_app_image_wnck_application_icon_changed (WnckApplication* _sender, gpointer self);
static void all_tray_application_on_icon_click (AllTrayApplication* self, GtkStatusIcon* icon);
static void _all_tray_application_on_icon_click_gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self);
static void all_tray_application_update_icon_name (AllTrayApplication* self, WnckApplication* app);
static void _all_tray_application_update_icon_name_wnck_application_name_changed (WnckApplication* _sender, gpointer self);
static void all_tray_application_toggle_visibility (AllTrayApplication* self);
static void all_tray_application_maintain_hiddenness (AllTrayApplication* self, WnckWindow* win, WnckWindowState changed_bits, WnckWindowState new_state);
static char* all_tray_application_get_win_state (AllTrayApplication* self, WnckWindowState state);
static void all_tray_application_debug_msg (AllTrayApplication* self, const char* str);
static void all_tray_application_show_all_windows (AllTrayApplication* self);
static void _all_tray_application_maintain_hiddenness_wnck_window_state_changed (WnckWindow* _sender, WnckWindowState changed_mask, WnckWindowState new_state, gpointer self);
static gboolean all_tray_application_set_maintain_hiddenness (AllTrayApplication* self);
static gboolean _all_tray_application_set_maintain_hiddenness_gsource_func (gpointer self);
static void all_tray_application_dialog_destroy (AllTrayApplication* self, GtkAboutDialog* which, gint resp_id);
static void _all_tray_application_dialog_destroy_gtk_dialog_response (GtkAboutDialog* _sender, gint response_id, gpointer self);
WnckApplication* all_tray_application_get_wnck_app (AllTrayApplication* self);
gboolean all_tray_application_get_visible (AllTrayApplication* self);
void all_tray_application_set_visible (AllTrayApplication* self, gboolean value);
gboolean all_tray_application_get_caught_window (AllTrayApplication* self);
void all_tray_application_set_caught_window (AllTrayApplication* self, gboolean value);
static void all_tray_application_finalize (GObject* obj);
static void all_tray_application_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void all_tray_application_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark all_tray_application_error_quark (void) {
	return g_quark_from_static_string ("all_tray_application_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _all_tray_application_maybe_setup_wnck_screen_application_opened (WnckScreen* _sender, WnckApplication* app, gpointer self) {
	all_tray_application_maybe_setup (self, _sender, app);
}


static void _all_tray_application_bye_wnck_app_wnck_screen_application_closed (WnckScreen* _sender, WnckApplication* app, gpointer self) {
	all_tray_application_bye_wnck_app (self, _sender, app);
}


AllTrayApplication* all_tray_application_construct (GType object_type, AllTrayProcess* p) {
	AllTrayApplication * self = NULL;
	AllTrayProcess* _tmp0_;
	GQueue* _tmp1_;
	g_return_val_if_fail (p != NULL, NULL);
	self = (AllTrayApplication*) g_object_new (object_type, NULL);
	self->priv->_process = (_tmp0_ = _g_object_ref0 (p), _g_object_unref0 (self->priv->_process), _tmp0_);
	self->priv->_window_enforce_minimize_queue = (_tmp1_ = g_queue_new (), _g_queue_free0 (self->priv->_window_enforce_minimize_queue), _tmp1_);
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Application, ALL_TRAY_DEBUG_LEVEL_Information, _ ("Creating a new Application"));
	g_signal_connect_object (all_tray_program_WnckScreen, "application-opened", (GCallback) _all_tray_application_maybe_setup_wnck_screen_application_opened, self, 0);
	g_signal_connect_object (all_tray_program_WnckScreen, "application-closed", (GCallback) _all_tray_application_bye_wnck_app_wnck_screen_application_closed, self, 0);
	if (all_tray_program_WnckEarlyApps != NULL) {
		{
			GList* app_collection;
			GList* app_it;
			app_collection = all_tray_program_WnckEarlyApps;
			for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
				WnckApplication* app;
				app = _g_object_ref0 ((WnckApplication*) app_it->data);
				{
					all_tray_application_maybe_setup (self, all_tray_program_WnckScreen, app);
					_g_object_unref0 (app);
				}
			}
		}
	}
	return self;
}


AllTrayApplication* all_tray_application_new (AllTrayProcess* p) {
	return all_tray_application_construct (ALL_TRAY_TYPE_APPLICATION, p);
}


static void _all_tray_application_maybe_update_window_count_wnck_screen_window_opened (WnckScreen* _sender, WnckWindow* window, gpointer self) {
	all_tray_application_maybe_update_window_count (self, _sender, window);
}


static void _all_tray_application_maybe_update_window_count_wnck_screen_window_closed (WnckScreen* _sender, WnckWindow* window, gpointer self) {
	all_tray_application_maybe_update_window_count (self, _sender, window);
}


static void all_tray_application_bye_wnck_app (AllTrayApplication* self, WnckScreen* scr, WnckApplication* app) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (scr != NULL);
	g_return_if_fail (app != NULL);
	if (app == self->priv->_wnckApp) {
		guint _tmp0_;
		guint _tmp1_;
		all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Application, ALL_TRAY_DEBUG_LEVEL_Information, _ ("WHOA - The app went away?! Looking for it to come back..."));
		g_signal_parse_name ("window-opened", WNCK_TYPE_SCREEN, &_tmp0_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (scr, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _all_tray_application_maybe_update_window_count_wnck_screen_window_opened, self);
		g_signal_parse_name ("window-closed", WNCK_TYPE_SCREEN, &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (scr, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _all_tray_application_maybe_update_window_count_wnck_screen_window_closed, self);
		g_signal_connect_object (all_tray_program_WnckScreen, "application-opened", (GCallback) _all_tray_application_maybe_setup_wnck_screen_application_opened, self, 0);
	}
}


static gboolean all_tray_application_are_we_interested (AllTrayApplication* self, gint pid) {
	gboolean result = FALSE;
	gboolean retval;
	gint app_pid;
	gint app_ppid;
	gint app_pgid;
	gint desired_pid;
	gint desired_pgid;
	char* proc_name;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pid != 0, FALSE);
	retval = FALSE;
	app_pid = pid;
	app_ppid = alltray_get_ppid_for (app_pid);
	app_pgid = (gint) getpgid ((pid_t) app_pid);
	desired_pid = (gint) all_tray_process_get_pid (self->priv->_process);
	desired_pgid = (gint) all_tray_program_pgid;
	proc_name = alltray_get_process_name (pid);
	if (app_pgid == desired_pgid) {
		_tmp0_ = app_pgid != app_pid;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		retval = TRUE;
	} else {
		if (app_pid == desired_pid) {
			retval = TRUE;
		} else {
			if (app_ppid == desired_pid) {
				retval = TRUE;
			}
		}
	}
	if (!retval) {
		GString* msg;
		msg = g_string_new ("");
		g_string_append_printf (msg, _ ("pid %d (%s) is not ours."), app_pid, proc_name);
		all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Application, ALL_TRAY_DEBUG_LEVEL_Information, msg->str);
		_g_string_free0 (msg);
	} else {
		if (app_pid != desired_pid) {
			{
				all_tray_process_run_kinda_fake (self->priv->_process, app_pid, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ALL_TRAY_PROCESS_ERROR) {
						goto __catch5_all_tray_process_error;
					}
					_g_free0 (proc_name);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			goto __finally5;
			__catch5_all_tray_process_error:
			{
				GError * pe;
				pe = _inner_error_;
				_inner_error_ = NULL;
				{
					g_critical ("Application.vala:119: error: %s", pe->message);
					_g_error_free0 (pe);
				}
			}
			__finally5:
			if (_inner_error_ != NULL) {
				_g_free0 (proc_name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = retval;
	_g_free0 (proc_name);
	return result;
}


void all_tray_application_maybe_setup_for_pid (AllTrayApplication* self, WnckApplication* app, gint pid) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	if (pid == 0) {
		g_warning (_ ("Application %s needs fixed, reports PID 0."), wnck_application_get_name (app));
	} else {
		gboolean interested;
		interested = self->priv->_caughtWindow = all_tray_application_are_we_interested (self, pid);
		if (!interested) {
			return;
		}
		all_tray_application_do_setup (self, all_tray_program_WnckScreen, app, pid);
	}
}


static void all_tray_application_maybe_setup (AllTrayApplication* self, WnckScreen* scr, WnckApplication* app) {
	gboolean interested;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scr != NULL);
	g_return_if_fail (app != NULL);
	interested = self->priv->_caughtWindow = all_tray_application_are_we_interested (self, wnck_application_get_pid (app));
	if (!interested) {
		return;
	} else {
		gboolean _tmp0_ = FALSE;
		if (interested) {
			_tmp0_ = all_tray_process_get_timer_running (self->priv->_process);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			g_source_remove (all_tray_process_get_timer_event_source (self->priv->_process));
		}
	}
	all_tray_application_do_setup (self, scr, app, wnck_application_get_pid (app));
}


static void all_tray_application_on_ctt (AllTrayApplication* self, gulong XID) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Application, ALL_TRAY_DEBUG_LEVEL_Information, _tmp0_ = g_strdup_printf ("got a CTT event, XID %lu", XID));
	_g_free0 (_tmp0_);
	{
		GList* w_collection;
		GList* w_it;
		w_collection = self->priv->_windows;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			WnckWindow* w;
			w = _g_object_ref0 ((WnckWindow*) w_it->data);
			{
				if (wnck_window_get_xid (w) == XID) {
					all_tray_application_set_visibility_for_window (self, w, FALSE);
					_g_object_unref0 (w);
					return;
				}
				_g_object_unref0 (w);
			}
		}
	}
}


static void _all_tray_application_on_ctt_all_tray_ctt_activate (AllTrayCtt* _sender, gulong XID, gpointer self) {
	all_tray_application_on_ctt (self, XID);
}


static void _all_tray_application_display_menu_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self) {
	all_tray_application_display_menu (self, button, activate_time);
}


static void all_tray_application_do_setup (AllTrayApplication* self, WnckScreen* scr, WnckApplication* app, gint pid) {
	guint _tmp0_;
	WnckApplication* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scr != NULL);
	g_return_if_fail (app != NULL);
	g_signal_parse_name ("application-opened", WNCK_TYPE_SCREEN, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (scr, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _all_tray_application_maybe_setup_wnck_screen_application_opened, self);
	self->priv->_wnckApp = (_tmp1_ = _g_object_ref0 (app), _g_object_unref0 (self->priv->_wnckApp), _tmp1_);
	self->priv->_appVisible = TRUE;
	self->priv->_windows = wnck_application_get_windows (self->priv->_wnckApp);
	if (all_tray_program__ctt_enabled == TRUE) {
		g_signal_connect_object (all_tray_program__ctt_obj, "activate", (GCallback) _all_tray_application_on_ctt_all_tray_ctt_activate, self, 0);
		{
			GList* w_collection;
			GList* w_it;
			w_collection = self->priv->_windows;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				WnckWindow* w;
				w = _g_object_ref0 ((WnckWindow*) w_it->data);
				{
					all_tray_ctt_attach (all_tray_program__ctt_obj, wnck_window_get_xid (w));
					self->priv->_attached_xids = g_list_append (self->priv->_attached_xids, GUINT_TO_POINTER (wnck_window_get_xid (w)));
					_g_object_unref0 (w);
				}
			}
		}
	}
	g_signal_connect_object (scr, "window-opened", (GCallback) _all_tray_application_maybe_update_window_count_wnck_screen_window_opened, self, 0);
	g_signal_connect_object (scr, "window-closed", (GCallback) _all_tray_application_maybe_update_window_count_wnck_screen_window_closed, self, 0);
	if (self->priv->_appIcon == NULL) {
		all_tray_application_create_icon (self);
	}
	gtk_status_icon_set_visible (self->priv->_appIcon, TRUE);
	g_signal_connect_object (self->priv->_appIcon, "popup-menu", (GCallback) _all_tray_application_display_menu_gtk_status_icon_popup_menu, self, 0);
	if (self->priv->_usingWindowIcon) {
		all_tray_application_update_icon_win_image (self, (WnckWindow*) g_list_first (self->priv->_windows)->data);
	} else {
		all_tray_application_update_icon_app_image (self, self->priv->_wnckApp);
	}
	if (all_tray_program__initially_hide == TRUE) {
		all_tray_application_hide_all_windows (self);
	}
}


static void _all_tray_application_on_menu_undock_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	all_tray_application_on_menu_undock (self);
}


static void _all_tray_application_on_menu_about_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	all_tray_application_on_menu_about (self);
}


static void all_tray_application_display_menu (AllTrayApplication* self, guint button, guint activate_time) {
	GtkMenu* appMenu;
	GtkMenuItem* mnuToggle;
	GtkMenuItem* mnuUndock;
	GtkMenuItem* mnuSeparator0;
	GtkMenuItem* mnuAbout;
	GtkMenu* windowList;
	g_return_if_fail (self != NULL);
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Application, ALL_TRAY_DEBUG_LEVEL_Information, _ ("Requesting menu!"));
	appMenu = g_object_ref_sink ((GtkMenu*) gtk_menu_new ());
	mnuToggle = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Toggle Visibility")));
	mnuUndock = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Undock")));
	mnuSeparator0 = (GtkMenuItem*) g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ());
	mnuAbout = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_label (_ ("About AllTray...")));
	windowList = all_tray_application_create_window_list_menu (self);
	gtk_menu_item_set_submenu (mnuToggle, (GtkWidget*) windowList);
	gtk_menu_shell_append ((GtkMenuShell*) appMenu, (GtkWidget*) mnuToggle);
	gtk_widget_show ((GtkWidget*) mnuToggle);
	gtk_menu_shell_append ((GtkMenuShell*) appMenu, (GtkWidget*) mnuUndock);
	g_signal_connect_object (mnuUndock, "activate", (GCallback) _all_tray_application_on_menu_undock_gtk_menu_item_activate, self, 0);
	gtk_widget_show ((GtkWidget*) mnuUndock);
	gtk_menu_shell_append ((GtkMenuShell*) appMenu, (GtkWidget*) mnuSeparator0);
	gtk_widget_show ((GtkWidget*) mnuSeparator0);
	gtk_menu_shell_append ((GtkMenuShell*) appMenu, (GtkWidget*) mnuAbout);
	g_signal_connect_object (mnuAbout, "activate", (GCallback) _all_tray_application_on_menu_about_gtk_menu_item_activate, self, 0);
	gtk_widget_show ((GtkWidget*) mnuAbout);
	gtk_menu_popup (appMenu, NULL, NULL, NULL, NULL, button, (guint32) activate_time);
	_g_object_unref0 (windowList);
	_g_object_unref0 (mnuAbout);
	_g_object_unref0 (mnuSeparator0);
	_g_object_unref0 (mnuUndock);
	_g_object_unref0 (mnuToggle);
	_g_object_unref0 (appMenu);
}


static void _all_tray_application_on_menu_toggle_app_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	all_tray_application_on_menu_toggle_app (self, _sender);
}


static void _lambda0_ (GtkMenuItem* item, AllTrayApplication* self) {
	WnckWindow* win;
	g_return_if_fail (item != NULL);
	win = _g_object_ref0 (WNCK_WINDOW ((WnckWindow*) g_object_get_data ((GObject*) item, "target_window")));
	all_tray_application_toggle_window_visibility (self, win);
	_g_object_unref0 (win);
}


static void __lambda0__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda0_ (_sender, self);
}


static GtkMenu* all_tray_application_create_window_list_menu (AllTrayApplication* self) {
	GtkMenu* result = NULL;
	GtkMenu* retval;
	GtkMenuItem* mnuAllWindows;
	GtkMenuItem* mnuSep0;
	g_return_val_if_fail (self != NULL, NULL);
	retval = g_object_ref_sink ((GtkMenu*) gtk_menu_new ());
	mnuAllWindows = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_label (_ ("All")));
	mnuSep0 = (GtkMenuItem*) g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ());
	gtk_menu_shell_append ((GtkMenuShell*) retval, (GtkWidget*) mnuAllWindows);
	g_signal_connect_object (mnuAllWindows, "activate", (GCallback) _all_tray_application_on_menu_toggle_app_gtk_menu_item_activate, self, 0);
	gtk_widget_show ((GtkWidget*) mnuAllWindows);
	gtk_menu_shell_append ((GtkMenuShell*) retval, (GtkWidget*) mnuSep0);
	gtk_widget_show ((GtkWidget*) mnuSep0);
	{
		GList* w_collection;
		GList* w_it;
		w_collection = self->priv->_windows;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			WnckWindow* w;
			w = _g_object_ref0 ((WnckWindow*) w_it->data);
			{
				GtkMenuItem* item;
				item = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_label (wnck_window_get_name (w)));
				g_object_set_data_full ((GObject*) item, "target_window", _g_object_ref0 (w), g_object_unref);
				g_signal_connect_object (item, "activate", (GCallback) __lambda0__gtk_menu_item_activate, self, 0);
				gtk_menu_shell_append ((GtkMenuShell*) retval, (GtkWidget*) item);
				gtk_widget_show ((GtkWidget*) item);
				_g_object_unref0 (item);
				_g_object_unref0 (w);
			}
		}
	}
	result = retval;
	_g_object_unref0 (mnuSep0);
	_g_object_unref0 (mnuAllWindows);
	return result;
}


static void _all_tray_application_update_ctt_state (AllTrayApplication* self) {
	GList* attached;
	gulong xid;
	g_return_if_fail (self != NULL);
	attached = g_list_copy (self->priv->_attached_xids);
	xid = (gulong) 0;
	{
		GList* w_collection;
		GList* w_it;
		w_collection = self->priv->_windows;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			WnckWindow* w;
			w = _g_object_ref0 ((WnckWindow*) w_it->data);
			{
				xid = wnck_window_get_xid (w);
				if (g_list_index (attached, GUINT_TO_POINTER (xid)) == (-1)) {
					char* _tmp0_;
					GString* wlist;
					char* _tmp1_;
					all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Application, ALL_TRAY_DEBUG_LEVEL_Information, _tmp0_ = g_strdup_printf ("window 0x%lx is new", xid));
					_g_free0 (_tmp0_);
					all_tray_ctt_attach (all_tray_program__ctt_obj, xid);
					self->priv->_attached_xids = g_list_append (self->priv->_attached_xids, GUINT_TO_POINTER (xid));
					wlist = g_string_new ("");
					{
						GList* wlist_id_collection;
						GList* wlist_id_it;
						wlist_id_collection = self->priv->_attached_xids;
						for (wlist_id_it = wlist_id_collection; wlist_id_it != NULL; wlist_id_it = wlist_id_it->next) {
							gulong wlist_id;
							wlist_id = GPOINTER_TO_UINT (wlist_id_it->data);
							{
								g_string_append_printf (wlist, "0x%lx ", wlist_id);
							}
						}
					}
					all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Application, ALL_TRAY_DEBUG_LEVEL_Information, _tmp1_ = g_strdup_printf ("Window List: %s", wlist->str));
					_g_free0 (_tmp1_);
					_g_string_free0 (wlist);
				} else {
					char* _tmp2_;
					all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Application, ALL_TRAY_DEBUG_LEVEL_Information, _tmp2_ = g_strdup_printf ("window 0x%lx is unchanged", xid));
					_g_free0 (_tmp2_);
					attached = g_list_remove (attached, GUINT_TO_POINTER (xid));
				}
				_g_object_unref0 (w);
			}
		}
	}
	_g_list_free0 (attached);
}


static void all_tray_application_maybe_update_window_count (AllTrayApplication* self, WnckScreen* scr, WnckWindow* win) {
	char* new_tooltip;
	gint wincount;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scr != NULL);
	g_return_if_fail (win != NULL);
	new_tooltip = NULL;
	self->priv->_windows = wnck_application_get_windows (self->priv->_wnckApp);
	wincount = wnck_application_get_n_windows (self->priv->_wnckApp);
	if (wincount == 1) {
		WnckWindow* first_window;
		char* _tmp0_;
		first_window = _g_object_ref0 ((WnckWindow*) g_list_first (self->priv->_windows)->data);
		new_tooltip = (_tmp0_ = g_strdup_printf (_ ("%s - \"%s\""), wnck_application_get_name (self->priv->_wnckApp), wnck_window_get_name (first_window)), _g_free0 (new_tooltip), _tmp0_);
		_g_object_unref0 (first_window);
	} else {
		char* app_name;
		char* _tmp1_;
		app_name = g_strdup (wnck_application_get_name (self->priv->_wnckApp));
		new_tooltip = (_tmp1_ = g_strdup_printf (ngettext ("%s - %d window", "%s - %d windows", (gulong) wincount), app_name, wincount), _g_free0 (new_tooltip), _tmp1_);
		_g_free0 (app_name);
	}
	gtk_status_icon_set_tooltip (self->priv->_appIcon, new_tooltip);
	_all_tray_application_update_ctt_state (self);
	_g_free0 (new_tooltip);
}


static void _all_tray_application_update_icon_win_image_wnck_window_icon_changed (WnckWindow* _sender, gpointer self) {
	all_tray_application_update_icon_win_image (self, _sender);
}


static void _all_tray_application_update_icon_app_image_wnck_application_icon_changed (WnckApplication* _sender, gpointer self) {
	all_tray_application_update_icon_app_image (self, _sender);
}


static void _all_tray_application_on_icon_click_gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self) {
	all_tray_application_on_icon_click (self, _sender);
}


static void _all_tray_application_update_icon_name_wnck_application_name_changed (WnckApplication* _sender, gpointer self) {
	all_tray_application_update_icon_name (self, _sender);
}


static char* bool_to_string (gboolean self) {
	char* result = NULL;
	if (self) {
		result = g_strdup ("true");
		return result;
	} else {
		result = g_strdup ("false");
		return result;
	}
}


static void all_tray_application_create_icon (AllTrayApplication* self) {
	WnckWindow* firstWindow;
	gboolean fallback;
	char* msg;
	g_return_if_fail (self != NULL);
	self->priv->_windows = wnck_application_get_windows (self->priv->_wnckApp);
	firstWindow = _g_object_ref0 ((WnckWindow*) g_list_first (self->priv->_windows)->data);
	self->priv->_usingWindowIcon = FALSE;
	fallback = wnck_application_get_icon_is_fallback (self->priv->_wnckApp);
	if (fallback) {
		GtkStatusIcon* _tmp0_;
		self->priv->_appIcon = (_tmp0_ = gtk_status_icon_new_from_pixbuf (wnck_window_get_mini_icon (firstWindow)), _g_object_unref0 (self->priv->_appIcon), _tmp0_);
		g_signal_connect_object (firstWindow, "icon-changed", (GCallback) _all_tray_application_update_icon_win_image_wnck_window_icon_changed, self, 0);
		self->priv->_usingWindowIcon = TRUE;
	} else {
		GtkStatusIcon* _tmp1_;
		self->priv->_appIcon = (_tmp1_ = gtk_status_icon_new_from_pixbuf (wnck_application_get_mini_icon (self->priv->_wnckApp)), _g_object_unref0 (self->priv->_appIcon), _tmp1_);
		g_signal_connect_object (self->priv->_wnckApp, "icon-changed", (GCallback) _all_tray_application_update_icon_app_image_wnck_application_icon_changed, self, 0);
	}
	gtk_status_icon_set_tooltip (self->priv->_appIcon, wnck_application_get_name (self->priv->_wnckApp));
	g_signal_connect_object (self->priv->_appIcon, "activate", (GCallback) _all_tray_application_on_icon_click_gtk_status_icon_activate, self, 0);
	g_signal_connect_object (self->priv->_wnckApp, "name-changed", (GCallback) _all_tray_application_update_icon_name_wnck_application_name_changed, self, 0);
	msg = g_strdup ("");
	if (self->priv->_usingWindowIcon) {
		char* _tmp2_;
		char* _tmp3_;
		msg = (_tmp3_ = g_strdup_printf (_ ("Using Window Icon (fallback was %s)"), _tmp2_ = bool_to_string (fallback)), _g_free0 (msg), _tmp3_);
		_g_free0 (_tmp2_);
	} else {
		char* _tmp4_;
		char* _tmp5_;
		msg = (_tmp5_ = g_strdup_printf (_ ("Using App Icon (fallback was %s)"), _tmp4_ = bool_to_string (fallback)), _g_free0 (msg), _tmp5_);
		_g_free0 (_tmp4_);
	}
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Application, ALL_TRAY_DEBUG_LEVEL_Information, msg);
	_g_free0 (msg);
	_g_object_unref0 (firstWindow);
}


static void all_tray_application_update_icon_app_image (AllTrayApplication* self, WnckApplication* app) {
	GdkPixbuf* new_icon;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	new_icon = wnck_application_get_icon (app);
	gtk_status_icon_set_from_pixbuf (self->priv->_appIcon, new_icon);
	if (new_icon == NULL) {
		gtk_status_icon_set_visible (self->priv->_appIcon, FALSE);
		return;
	}
}


static void all_tray_application_update_icon_win_image (AllTrayApplication* self, WnckWindow* win) {
	GdkPixbuf* new_icon;
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	new_icon = wnck_window_get_mini_icon (win);
	gtk_status_icon_set_from_pixbuf (self->priv->_appIcon, new_icon);
	if (new_icon == NULL) {
		gtk_status_icon_set_visible (self->priv->_appIcon, FALSE);
		return;
	}
}


static void all_tray_application_update_icon_name (AllTrayApplication* self, WnckApplication* app) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	gtk_status_icon_set_tooltip (self->priv->_appIcon, wnck_application_get_name (app));
}


static void all_tray_application_on_icon_click (AllTrayApplication* self, GtkStatusIcon* icon) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon != NULL);
	if (gtk_status_icon_get_blinking (icon) == TRUE) {
		gtk_status_icon_set_blinking (icon, FALSE);
	}
	all_tray_application_toggle_visibility (self);
}


static void all_tray_application_maintain_hiddenness (AllTrayApplication* self, WnckWindow* win, WnckWindowState changed_bits, WnckWindowState new_state) {
	char* _tmp0_;
	char* _tmp1_;
	char* ch_bitmask;
	char* _tmp2_;
	char* _tmp3_;
	char* ch_new_state;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	if (self->priv->_appVisible) {
		return;
	}
	ch_bitmask = (_tmp1_ = g_strdup_printf (_ ("New Bitmask: %s"), _tmp0_ = all_tray_application_get_win_state (self, changed_bits)), _g_free0 (_tmp0_), _tmp1_);
	ch_new_state = (_tmp3_ = g_strdup_printf (_ ("New State: %s"), _tmp2_ = all_tray_application_get_win_state (self, new_state)), _g_free0 (_tmp2_), _tmp3_);
	all_tray_application_debug_msg (self, ch_bitmask);
	all_tray_application_debug_msg (self, ch_new_state);
	if ((new_state & WNCK_WINDOW_STATE_MINIMIZED) == 0) {
		_tmp4_ = (changed_bits & WNCK_WINDOW_STATE_MINIMIZED) == WNCK_WINDOW_STATE_MINIMIZED;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		char* _tmp5_;
		char* _tmp6_;
		all_tray_application_debug_msg (self, _tmp6_ = g_strdup_printf (_ ("Blinking, window state is: %s"), _tmp5_ = all_tray_application_get_win_state (self, new_state)));
		_g_free0 (_tmp6_);
		_g_free0 (_tmp5_);
		wnck_window_minimize (win);
		gtk_status_icon_set_blinking (self->priv->_appIcon, TRUE);
	}
	_g_free0 (ch_new_state);
	_g_free0 (ch_bitmask);
}


static void all_tray_application_debug_msg (AllTrayApplication* self, const char* str) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Application, ALL_TRAY_DEBUG_LEVEL_Information, str);
}


static char* all_tray_application_get_win_state (AllTrayApplication* self, WnckWindowState state) {
	char* result = NULL;
	GString* sb;
	g_return_val_if_fail (self != NULL, NULL);
	sb = g_string_new ("");
	if ((state & WNCK_WINDOW_STATE_MINIMIZED) != 0) {
		g_string_append (sb, _ ("MINIMIZED | "));
	}
	if ((state & WNCK_WINDOW_STATE_MAXIMIZED_HORIZONTALLY) != 0) {
		g_string_append (sb, _ ("MAXIMIZED_HORIZONTALLY | "));
	}
	if ((state & WNCK_WINDOW_STATE_MAXIMIZED_VERTICALLY) != 0) {
		g_string_append (sb, _ ("MAXIMIZED_VERTICALLY | "));
	}
	if ((state & WNCK_WINDOW_STATE_SHADED) != 0) {
		g_string_append (sb, _ ("SHADED | "));
	}
	if ((state & WNCK_WINDOW_STATE_SKIP_PAGER) != 0) {
		g_string_append (sb, _ ("SKIP_PAGER | "));
	}
	if ((state & WNCK_WINDOW_STATE_SKIP_TASKLIST) != 0) {
		g_string_append (sb, _ ("SKIP_TASKLIST | "));
	}
	if ((state & WNCK_WINDOW_STATE_STICKY) != 0) {
		g_string_append (sb, _ ("STICKY | "));
	}
	if ((state & WNCK_WINDOW_STATE_HIDDEN) != 0) {
		g_string_append (sb, _ ("HIDDEN | "));
	}
	if ((state & WNCK_WINDOW_STATE_FULLSCREEN) != 0) {
		g_string_append (sb, _ ("FULLSCREEN | "));
	}
	if ((state & WNCK_WINDOW_STATE_DEMANDS_ATTENTION) != 0) {
		g_string_append (sb, _ ("DEMANDS_ATTENTION | "));
	}
	if ((state & WNCK_WINDOW_STATE_URGENT) != 0) {
		g_string_append (sb, _ ("URGENT | "));
	}
	if ((state & WNCK_WINDOW_STATE_ABOVE) != 0) {
		g_string_append (sb, _ ("ABOVE | "));
	}
	if ((state & WNCK_WINDOW_STATE_BELOW) != 0) {
		g_string_append (sb, _ ("BELOW | "));
	}
	g_string_truncate (sb, (gsize) (sb->len - 3));
	result = g_strdup (sb->str);
	_g_string_free0 (sb);
	return result;
}


static void all_tray_application_toggle_visibility (AllTrayApplication* self) {
	g_return_if_fail (self != NULL);
	self->priv->_appVisible = !self->priv->_appVisible;
	{
		GList* w_collection;
		GList* w_it;
		w_collection = self->priv->_windows;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			WnckWindow* w;
			w = _g_object_ref0 ((WnckWindow*) w_it->data);
			{
				all_tray_application_set_visibility_for_window (self, w, self->priv->_appVisible);
				_g_object_unref0 (w);
			}
		}
	}
}


static void all_tray_application_show_all_windows (AllTrayApplication* self) {
	g_return_if_fail (self != NULL);
	self->priv->_appVisible = FALSE;
	all_tray_application_toggle_visibility (self);
}


static void all_tray_application_hide_all_windows (AllTrayApplication* self) {
	g_return_if_fail (self != NULL);
	self->priv->_appVisible = TRUE;
	all_tray_application_toggle_visibility (self);
}


static void all_tray_application_toggle_window_visibility (AllTrayApplication* self, WnckWindow* w) {
	WnckWindowState ws;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	ws = wnck_window_get_state (w);
	if ((ws & WNCK_WINDOW_STATE_MINIMIZED) != 0) {
		_tmp0_ = (ws & WNCK_WINDOW_STATE_SKIP_TASKLIST) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		all_tray_application_set_visibility_for_window (self, w, TRUE);
	} else {
		all_tray_application_set_visibility_for_window (self, w, FALSE);
	}
}


static void _all_tray_application_maintain_hiddenness_wnck_window_state_changed (WnckWindow* _sender, WnckWindowState changed_mask, WnckWindowState new_state, gpointer self) {
	all_tray_application_maintain_hiddenness (self, _sender, changed_mask, new_state);
}


static gboolean _all_tray_application_set_maintain_hiddenness_gsource_func (gpointer self) {
	gboolean result;
	result = all_tray_application_set_maintain_hiddenness (self);
	return result;
}


static void all_tray_application_set_visibility_for_window (AllTrayApplication* self, WnckWindow* w, gboolean set_visible) {
	GTimeVal tv = {0};
	GString* msg;
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	g_get_current_time (&tv);
	g_get_current_time (&tv);
	msg = g_string_new ("");
	g_string_append_printf (msg, _ ("Setting window 0x%08lx visibility to %s"), wnck_window_get_xid (w), _tmp0_ = bool_to_string (set_visible));
	_g_free0 (_tmp0_);
	if (set_visible) {
		guint _tmp1_;
		WnckWorkspace* ws;
		g_queue_clear (self->priv->_window_enforce_minimize_queue);
		g_signal_parse_name ("state-changed", WNCK_TYPE_WINDOW, &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (w, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _all_tray_application_maintain_hiddenness_wnck_window_state_changed, self);
		wnck_window_set_skip_tasklist (w, FALSE);
		wnck_window_set_skip_pager (w, FALSE);
		wnck_window_unminimize (w, (guint32) tv.tv_sec);
		ws = _g_object_ref0 (wnck_window_get_workspace (w));
		wnck_workspace_activate (ws, (guint32) tv.tv_sec);
		wnck_window_activate (w, (guint32) tv.tv_sec);
		_g_object_unref0 (ws);
	} else {
		wnck_window_set_skip_tasklist (w, TRUE);
		wnck_window_set_skip_pager (w, TRUE);
		wnck_window_minimize (w);
		g_queue_push_head (self->priv->_window_enforce_minimize_queue, _g_object_ref0 (w));
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 150, _all_tray_application_set_maintain_hiddenness_gsource_func, g_object_ref (self), g_object_unref);
	}
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Application, ALL_TRAY_DEBUG_LEVEL_Information, msg->str);
	_g_string_free0 (msg);
}


static gboolean all_tray_application_set_maintain_hiddenness (AllTrayApplication* self) {
	gboolean result = FALSE;
	WnckWindow* w;
	g_return_val_if_fail (self != NULL, FALSE);
	w = NULL;
	while (TRUE) {
		WnckWindow* _tmp0_;
		if (!((w = (_tmp0_ = (WnckWindow*) g_queue_pop_tail (self->priv->_window_enforce_minimize_queue), _g_object_unref0 (w), _tmp0_)) != NULL)) {
			break;
		}
		g_signal_connect_object (w, "state-changed", (GCallback) _all_tray_application_maintain_hiddenness_wnck_window_state_changed, self, 0);
	}
	result = self->priv->_window_enforce_minimize_queue->length == 0;
	_g_object_unref0 (w);
	return result;
}


static void all_tray_application_dialog_destroy (AllTrayApplication* self, GtkAboutDialog* which, gint resp_id) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (which != NULL);
	gtk_object_destroy ((GtkObject*) which);
}


/**********************************************************
     * Context menu handlers.
     **********************************************************/
static void all_tray_application_on_menu_toggle_app (AllTrayApplication* self, GtkMenuItem* item) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	if (gtk_status_icon_get_blinking (self->priv->_appIcon) == TRUE) {
		gtk_status_icon_set_blinking (self->priv->_appIcon, FALSE);
	}
	all_tray_application_toggle_visibility (self);
}


static void _all_tray_application_dialog_destroy_gtk_dialog_response (GtkAboutDialog* _sender, gint response_id, gpointer self) {
	all_tray_application_dialog_destroy (self, _sender, response_id);
}


static void all_tray_application_on_menu_about (AllTrayApplication* self) {
	GtkAboutDialog* about;
	gboolean _tmp0_ = FALSE;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
	about = g_object_ref_sink ((GtkAboutDialog*) gtk_about_dialog_new ());
	gtk_about_dialog_set_program_name (about, "AllTray");
	if (g_utf8_strchr (PACKAGE_VERSION, (gssize) (-1), (gunichar) '+') != NULL) {
		_tmp0_ = _vala_strcmp0 (ALLTRAY_BZR_BUILD, "TRUE") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp1_;
		gtk_about_dialog_set_version (about, _tmp1_ = g_strdup_printf (_ ("%s\nBranch: %s, r%s\n%s"), PACKAGE_VERSION, ALLTRAY_BZR_BRANCH, ALLTRAY_BZR_REVISION, ALLTRAY_BZR_REVID));
		_g_free0 (_tmp1_);
	} else {
		gtk_about_dialog_set_version (about, PACKAGE_VERSION);
	}
	gtk_about_dialog_set_website (about, "http://alltray.trausch.us/");
	gtk_about_dialog_set_copyright (about, _tmp2_ = g_strdup_printf (_ ("Copyright (c) %s"), ALLTRAY_COPYRIGHT_YEARS));
	_g_free0 (_tmp2_);
	gtk_about_dialog_set_comments (about, _ ("Dock applications in the system tray."));
	gtk_about_dialog_set_license (about, ALLTRAY_LICENSE);
	g_signal_connect_object ((GtkDialog*) about, "response", (GCallback) _all_tray_application_dialog_destroy_gtk_dialog_response, self, 0);
	gtk_widget_show_all ((GtkWidget*) about);
	_g_object_unref0 (about);
}


static void all_tray_application_on_menu_undock (AllTrayApplication* self) {
	g_return_if_fail (self != NULL);
	all_tray_application_show_all_windows (self);
	exit (0);
}


WnckApplication* all_tray_application_get_wnck_app (AllTrayApplication* self) {
	WnckApplication* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_wnckApp;
	return result;
}


gboolean all_tray_application_get_visible (AllTrayApplication* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_appVisible;
	return result;
}


void all_tray_application_set_visible (AllTrayApplication* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_appVisible != value) {
		all_tray_application_toggle_visibility (self);
	}
	g_object_notify ((GObject *) self, "visible");
}


gboolean all_tray_application_get_caught_window (AllTrayApplication* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_caughtWindow;
	return result;
}


void all_tray_application_set_caught_window (AllTrayApplication* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_caughtWindow) {
		return;
	}
	if (value == FALSE) {
		return;
	}
	self->priv->_caughtWindow = value;
	g_object_notify ((GObject *) self, "caught-window");
}


static void all_tray_application_class_init (AllTrayApplicationClass * klass) {
	all_tray_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AllTrayApplicationPrivate));
	G_OBJECT_CLASS (klass)->get_property = all_tray_application_get_property;
	G_OBJECT_CLASS (klass)->set_property = all_tray_application_set_property;
	G_OBJECT_CLASS (klass)->finalize = all_tray_application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALL_TRAY_APPLICATION_WNCK_APP, g_param_spec_object ("wnck-app", "wnck-app", "wnck-app", WNCK_TYPE_APPLICATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALL_TRAY_APPLICATION_VISIBLE, g_param_spec_boolean ("visible", "visible", "visible", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALL_TRAY_APPLICATION_CAUGHT_WINDOW, g_param_spec_boolean ("caught-window", "caught-window", "caught-window", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void all_tray_application_instance_init (AllTrayApplication * self) {
	self->priv = ALL_TRAY_APPLICATION_GET_PRIVATE (self);
}


static void all_tray_application_finalize (GObject* obj) {
	AllTrayApplication * self;
	self = ALL_TRAY_APPLICATION (obj);
	_g_object_unref0 (self->priv->_wnckApp);
	_g_object_unref0 (self->priv->_appIcon);
	_g_object_unref0 (self->priv->_process);
	_g_list_free0 (self->priv->_attached_xids);
	_g_queue_free0 (self->priv->_window_enforce_minimize_queue);
	G_OBJECT_CLASS (all_tray_application_parent_class)->finalize (obj);
}


GType all_tray_application_get_type (void) {
	static volatile gsize all_tray_application_type_id__volatile = 0;
	if (g_once_init_enter (&all_tray_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AllTrayApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) all_tray_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AllTrayApplication), 0, (GInstanceInitFunc) all_tray_application_instance_init, NULL };
		GType all_tray_application_type_id;
		all_tray_application_type_id = g_type_register_static (G_TYPE_OBJECT, "AllTrayApplication", &g_define_type_info, 0);
		g_once_init_leave (&all_tray_application_type_id__volatile, all_tray_application_type_id);
	}
	return all_tray_application_type_id__volatile;
}


static void all_tray_application_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AllTrayApplication * self;
	self = ALL_TRAY_APPLICATION (object);
	switch (property_id) {
		case ALL_TRAY_APPLICATION_WNCK_APP:
		g_value_set_object (value, all_tray_application_get_wnck_app (self));
		break;
		case ALL_TRAY_APPLICATION_VISIBLE:
		g_value_set_boolean (value, all_tray_application_get_visible (self));
		break;
		case ALL_TRAY_APPLICATION_CAUGHT_WINDOW:
		g_value_set_boolean (value, all_tray_application_get_caught_window (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void all_tray_application_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AllTrayApplication * self;
	self = ALL_TRAY_APPLICATION (object);
	switch (property_id) {
		case ALL_TRAY_APPLICATION_VISIBLE:
		all_tray_application_set_visible (self, g_value_get_boolean (value));
		break;
		case ALL_TRAY_APPLICATION_CAUGHT_WINDOW:
		all_tray_application_set_caught_window (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




