/* AttachHelper.c generated by valac 0.10.4, the Vala compiler
 * generated from AttachHelper.vala, do not modify */

/* -*- mode: vala; c-basic-offset: 2; tab-width: 8; -*-
 * AttachHelper.vala - Helper class to attach to a running process
 * Copyright (c) 2009 Michael B. Trausch <mike@trausch.us>
 * License: GNU GPL v3.0 as published by the Free Software Foundation
 */

#include <glib.h>
#include <glib-object.h>
#include <libwnck/libwnck.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <x11_glue.h>


#define ALL_TRAY_TYPE_ATTACH_HELPER (all_tray_attach_helper_get_type ())
#define ALL_TRAY_ATTACH_HELPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALL_TRAY_TYPE_ATTACH_HELPER, AllTrayAttachHelper))
#define ALL_TRAY_ATTACH_HELPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALL_TRAY_TYPE_ATTACH_HELPER, AllTrayAttachHelperClass))
#define ALL_TRAY_IS_ATTACH_HELPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALL_TRAY_TYPE_ATTACH_HELPER))
#define ALL_TRAY_IS_ATTACH_HELPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALL_TRAY_TYPE_ATTACH_HELPER))
#define ALL_TRAY_ATTACH_HELPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALL_TRAY_TYPE_ATTACH_HELPER, AllTrayAttachHelperClass))

typedef struct _AllTrayAttachHelper AllTrayAttachHelper;
typedef struct _AllTrayAttachHelperClass AllTrayAttachHelperClass;
typedef struct _AllTrayAttachHelperPrivate AllTrayAttachHelperPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gdk_cursor_unref0(var) ((var == NULL) ? NULL : (var = (gdk_cursor_unref (var), NULL)))

#define ALL_TRAY_DEBUG_TYPE_SUBSYSTEM (all_tray_debug_subsystem_get_type ())

#define ALL_TRAY_DEBUG_TYPE_LEVEL (all_tray_debug_level_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _AllTrayAttachHelper {
	GObject parent_instance;
	AllTrayAttachHelperPrivate * priv;
};

struct _AllTrayAttachHelperClass {
	GObjectClass parent_class;
};

typedef enum  {
	ALL_TRAY_DEBUG_SUBSYSTEM_None = 0x00,
	ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine = 0x01,
	ALL_TRAY_DEBUG_SUBSYSTEM_Display = 0x02,
	ALL_TRAY_DEBUG_SUBSYSTEM_TrayIcon = 0x04,
	ALL_TRAY_DEBUG_SUBSYSTEM_WindowManager = 0x08,
	ALL_TRAY_DEBUG_SUBSYSTEM_Process = 0x10,
	ALL_TRAY_DEBUG_SUBSYSTEM_Misc = 0x20,
	ALL_TRAY_DEBUG_SUBSYSTEM_Bug = 0x40,
	ALL_TRAY_DEBUG_SUBSYSTEM_Application = 0x80,
	ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper = 0x100,
	ALL_TRAY_DEBUG_SUBSYSTEM_Signal = 0x200,
	ALL_TRAY_DEBUG_SUBSYSTEM_Main = 0x400,
	ALL_TRAY_DEBUG_SUBSYSTEM_Ctt = 0x800,
	ALL_TRAY_DEBUG_SUBSYSTEM_All = ((((((((((ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine | ALL_TRAY_DEBUG_SUBSYSTEM_Display) | ALL_TRAY_DEBUG_SUBSYSTEM_TrayIcon) | ALL_TRAY_DEBUG_SUBSYSTEM_WindowManager) | ALL_TRAY_DEBUG_SUBSYSTEM_Process) | ALL_TRAY_DEBUG_SUBSYSTEM_Misc) | ALL_TRAY_DEBUG_SUBSYSTEM_Bug) | ALL_TRAY_DEBUG_SUBSYSTEM_Application) | ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper) | ALL_TRAY_DEBUG_SUBSYSTEM_Signal) | ALL_TRAY_DEBUG_SUBSYSTEM_Main) | ALL_TRAY_DEBUG_SUBSYSTEM_Ctt
} AllTrayDebugSubsystem;

typedef enum  {
	ALL_TRAY_DEBUG_LEVEL_Information,
	ALL_TRAY_DEBUG_LEVEL_Warning,
	ALL_TRAY_DEBUG_LEVEL_Error,
	ALL_TRAY_DEBUG_LEVEL_Fatal
} AllTrayDebugLevel;


static AllTrayAttachHelper* all_tray_attach_helper__sInstance;
static AllTrayAttachHelper* all_tray_attach_helper__sInstance = NULL;
static WnckWindow* all_tray_attach_helper__chosen_window;
static WnckWindow* all_tray_attach_helper__chosen_window = NULL;
extern gint all_tray_attach_helper_target_process;
gint all_tray_attach_helper_target_process = 0;
extern gboolean all_tray_attach_helper_success;
gboolean all_tray_attach_helper_success = FALSE;
extern WnckScreen* all_tray_program_WnckScreen;
static gpointer all_tray_attach_helper_parent_class = NULL;

GType all_tray_attach_helper_get_type (void) G_GNUC_CONST;
enum  {
	ALL_TRAY_ATTACH_HELPER_DUMMY_PROPERTY
};
gboolean all_tray_attach_helper_get_target_window (void);
AllTrayAttachHelper* all_tray_attach_helper_new (void);
AllTrayAttachHelper* all_tray_attach_helper_construct (GType object_type);
void all_tray_attach_helper_run (AllTrayAttachHelper* self);
static GdkFilterReturn all_tray_attach_helper_target_filter (AllTrayAttachHelper* self, GdkXEvent* xev, GdkEvent* ev);
static GdkFilterReturn _all_tray_attach_helper_target_filter_gdk_filter_func (GdkXEvent* xevent, GdkEvent* event, gpointer self);
static void all_tray_attach_helper_clean_up (AllTrayAttachHelper* self);
static void all_tray_attach_helper_handle_button_press_event (AllTrayAttachHelper* self, XKeyEvent* ev);
static WnckWindow* all_tray_attach_helper_get_managed (AllTrayAttachHelper* self, gulong xwin);
GType all_tray_debug_subsystem_get_type (void) G_GNUC_CONST;
GType all_tray_debug_level_get_type (void) G_GNUC_CONST;
void all_tray_debug_notification_emit (AllTrayDebugSubsystem subsys, AllTrayDebugLevel lvl, const char* msg);
static void all_tray_attach_helper_finalize (GObject* obj);



gboolean all_tray_attach_helper_get_target_window (void) {
	gboolean result = FALSE;
	AllTrayAttachHelper* _tmp0_;
	all_tray_attach_helper__sInstance = (_tmp0_ = all_tray_attach_helper_new (), _g_object_unref0 (all_tray_attach_helper__sInstance), _tmp0_);
	all_tray_attach_helper__chosen_window = NULL;
	all_tray_attach_helper_target_process = 0;
	all_tray_attach_helper_success = FALSE;
	all_tray_attach_helper_run (all_tray_attach_helper__sInstance);
	result = FALSE;
	return result;
}


AllTrayAttachHelper* all_tray_attach_helper_construct (GType object_type) {
	AllTrayAttachHelper * self = NULL;
	self = (AllTrayAttachHelper*) g_object_new (object_type, NULL);
	return self;
}


AllTrayAttachHelper* all_tray_attach_helper_new (void) {
	return all_tray_attach_helper_construct (ALL_TRAY_TYPE_ATTACH_HELPER);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GdkFilterReturn _all_tray_attach_helper_target_filter_gdk_filter_func (GdkXEvent* xevent, GdkEvent* event, gpointer self) {
	GdkFilterReturn result;
	result = all_tray_attach_helper_target_filter (self, xevent, event);
	return result;
}


void all_tray_attach_helper_run (AllTrayAttachHelper* self) {
	GdkGrabStatus status = 0;
	GdkCursor* curCross;
	GdkWindow* rootWindow;
	GdkWindow* _tmp0_;
	GdkCursor* _tmp1_;
	g_return_if_fail (self != NULL);
	curCross = NULL;
	rootWindow = NULL;
	rootWindow = (_tmp0_ = _g_object_ref0 (gdk_get_default_root_window ()), _g_object_unref0 (rootWindow), _tmp0_);
	gdk_window_add_filter (rootWindow, _all_tray_attach_helper_target_filter_gdk_filter_func, self);
	curCross = (_tmp1_ = gdk_cursor_new (GDK_CROSS), _gdk_cursor_unref0 (curCross), _tmp1_);
	status = gdk_pointer_grab (rootWindow, FALSE, GDK_BUTTON_PRESS_MASK, NULL, curCross, (guint32) GDK_CURRENT_TIME);
	if (status != GDK_GRAB_SUCCESS) {
		g_warning ("AttachHelper.vala:47: %s", _ ("Pointer grab failed"));
		all_tray_attach_helper_clean_up (self);
		_g_object_unref0 (rootWindow);
		_gdk_cursor_unref0 (curCross);
		return;
	}
	status = gdk_keyboard_grab (rootWindow, FALSE, (guint32) GDK_CURRENT_TIME);
	if (status != GDK_GRAB_SUCCESS) {
		g_warning ("AttachHelper.vala:54: %s", _ ("Pointer grab failed"));
		all_tray_attach_helper_clean_up (self);
		_g_object_unref0 (rootWindow);
		_gdk_cursor_unref0 (curCross);
		return;
	}
	gdk_flush ();
	_g_object_unref0 (rootWindow);
	_gdk_cursor_unref0 (curCross);
}


static GdkFilterReturn all_tray_attach_helper_target_filter (AllTrayAttachHelper* self, GdkXEvent* xev, GdkEvent* ev) {
	GdkFilterReturn result = 0;
	XEvent* real_xev;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (ev != NULL, 0);
	real_xev = (XEvent*) (xev);
	switch ((*real_xev).type) {
		case ButtonPress:
		{
			all_tray_attach_helper_handle_button_press_event (self, &(*real_xev).xkey);
			all_tray_attach_helper_clean_up (self);
			result = GDK_FILTER_REMOVE;
			return result;
		}
		case KeyPress:
		{
			all_tray_attach_helper_clean_up (self);
			result = GDK_FILTER_REMOVE;
			return result;
		}
		default:
		{
			break;
		}
	}
	result = GDK_FILTER_CONTINUE;
	return result;
}


static void all_tray_attach_helper_handle_button_press_event (AllTrayAttachHelper* self, XKeyEvent* ev) {
	gulong xwin;
	GString* sb;
	g_return_if_fail (self != NULL);
	if ((*ev).subwindow == 0) {
		return;
	}
	xwin = (gulong) (*ev).subwindow;
	all_tray_attach_helper_success = TRUE;
	wnck_screen_force_update (all_tray_program_WnckScreen);
	all_tray_attach_helper__chosen_window = all_tray_attach_helper_get_managed (self, xwin);
	sb = g_string_new ("");
	g_string_append_printf (sb, _ ("Got window 0x%08lx"), xwin);
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper, ALL_TRAY_DEBUG_LEVEL_Information, sb->str);
	all_tray_attach_helper_target_process = wnck_window_get_pid (all_tray_attach_helper__chosen_window);
	g_string_truncate (sb, (gsize) 0);
	g_string_append_printf (sb, _ ("Window 0x%08lx pid = %d"), xwin, all_tray_attach_helper_target_process);
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper, ALL_TRAY_DEBUG_LEVEL_Information, sb->str);
	gtk_main_quit ();
	_g_string_free0 (sb);
}


static WnckWindow* all_tray_attach_helper_get_managed (AllTrayAttachHelper* self, gulong xwin) {
	WnckWindow* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = alltray_find_managed_window (xwin, gdk_display_get_default ());
	return result;
}


static void all_tray_attach_helper_clean_up (AllTrayAttachHelper* self) {
	g_return_if_fail (self != NULL);
	gdk_pointer_ungrab ((guint32) GDK_CURRENT_TIME);
	gdk_keyboard_ungrab ((guint32) GDK_CURRENT_TIME);
}


static void all_tray_attach_helper_class_init (AllTrayAttachHelperClass * klass) {
	all_tray_attach_helper_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = all_tray_attach_helper_finalize;
}


static void all_tray_attach_helper_instance_init (AllTrayAttachHelper * self) {
}


static void all_tray_attach_helper_finalize (GObject* obj) {
	AllTrayAttachHelper * self;
	self = ALL_TRAY_ATTACH_HELPER (obj);
	G_OBJECT_CLASS (all_tray_attach_helper_parent_class)->finalize (obj);
}


GType all_tray_attach_helper_get_type (void) {
	static volatile gsize all_tray_attach_helper_type_id__volatile = 0;
	if (g_once_init_enter (&all_tray_attach_helper_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AllTrayAttachHelperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) all_tray_attach_helper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AllTrayAttachHelper), 0, (GInstanceInitFunc) all_tray_attach_helper_instance_init, NULL };
		GType all_tray_attach_helper_type_id;
		all_tray_attach_helper_type_id = g_type_register_static (G_TYPE_OBJECT, "AllTrayAttachHelper", &g_define_type_info, 0);
		g_once_init_leave (&all_tray_attach_helper_type_id__volatile, all_tray_attach_helper_type_id);
	}
	return all_tray_attach_helper_type_id__volatile;
}




