/* Debug.c generated by valac 0.10.4, the Vala compiler
 * generated from Debug.vala, do not modify */

/* -*- mode: vala; c-basic-offset: 2; tab-width: 8; -*-
 * Debug.vala - Debugging system for AllTray.
 * Copyright (C) 2009 Michael B. Trausch <mike@trausch.us>
 * License: GNU GPL v3 as published by the Free Software Foundation.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <time.h>
#include <gobject/gvaluecollector.h>


#define ALL_TRAY_DEBUG_TYPE_SUBSYSTEM (all_tray_debug_subsystem_get_type ())

#define ALL_TRAY_DEBUG_TYPE_LEVEL (all_tray_debug_level_get_type ())

#define ALL_TRAY_DEBUG_TYPE_DEBUG_DESCRIPTION (all_tray_debug_debug_description_get_type ())
typedef struct _AllTrayDebugDebugDescription AllTrayDebugDebugDescription;
#define _g_free0(var) (var = (g_free (var), NULL))

#define ALL_TRAY_DEBUG_TYPE_NOTIFICATION (all_tray_debug_notification_get_type ())
#define ALL_TRAY_DEBUG_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALL_TRAY_DEBUG_TYPE_NOTIFICATION, AllTrayDebugNotification))
#define ALL_TRAY_DEBUG_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALL_TRAY_DEBUG_TYPE_NOTIFICATION, AllTrayDebugNotificationClass))
#define ALL_TRAY_DEBUG_IS_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALL_TRAY_DEBUG_TYPE_NOTIFICATION))
#define ALL_TRAY_DEBUG_IS_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALL_TRAY_DEBUG_TYPE_NOTIFICATION))
#define ALL_TRAY_DEBUG_NOTIFICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALL_TRAY_DEBUG_TYPE_NOTIFICATION, AllTrayDebugNotificationClass))

typedef struct _AllTrayDebugNotification AllTrayDebugNotification;
typedef struct _AllTrayDebugNotificationClass AllTrayDebugNotificationClass;
typedef struct _AllTrayDebugNotificationPrivate AllTrayDebugNotificationPrivate;
typedef struct _AllTrayDebugParamSpecNotification AllTrayDebugParamSpecNotification;

typedef enum  {
	ALL_TRAY_DEBUG_SUBSYSTEM_None = 0x00,
	ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine = 0x01,
	ALL_TRAY_DEBUG_SUBSYSTEM_Display = 0x02,
	ALL_TRAY_DEBUG_SUBSYSTEM_TrayIcon = 0x04,
	ALL_TRAY_DEBUG_SUBSYSTEM_WindowManager = 0x08,
	ALL_TRAY_DEBUG_SUBSYSTEM_Process = 0x10,
	ALL_TRAY_DEBUG_SUBSYSTEM_Misc = 0x20,
	ALL_TRAY_DEBUG_SUBSYSTEM_Bug = 0x40,
	ALL_TRAY_DEBUG_SUBSYSTEM_Application = 0x80,
	ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper = 0x100,
	ALL_TRAY_DEBUG_SUBSYSTEM_Signal = 0x200,
	ALL_TRAY_DEBUG_SUBSYSTEM_Main = 0x400,
	ALL_TRAY_DEBUG_SUBSYSTEM_Ctt = 0x800,
	ALL_TRAY_DEBUG_SUBSYSTEM_All = ((((((((((ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine | ALL_TRAY_DEBUG_SUBSYSTEM_Display) | ALL_TRAY_DEBUG_SUBSYSTEM_TrayIcon) | ALL_TRAY_DEBUG_SUBSYSTEM_WindowManager) | ALL_TRAY_DEBUG_SUBSYSTEM_Process) | ALL_TRAY_DEBUG_SUBSYSTEM_Misc) | ALL_TRAY_DEBUG_SUBSYSTEM_Bug) | ALL_TRAY_DEBUG_SUBSYSTEM_Application) | ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper) | ALL_TRAY_DEBUG_SUBSYSTEM_Signal) | ALL_TRAY_DEBUG_SUBSYSTEM_Main) | ALL_TRAY_DEBUG_SUBSYSTEM_Ctt
} AllTrayDebugSubsystem;

typedef enum  {
	ALL_TRAY_DEBUG_LEVEL_Information,
	ALL_TRAY_DEBUG_LEVEL_Warning,
	ALL_TRAY_DEBUG_LEVEL_Error,
	ALL_TRAY_DEBUG_LEVEL_Fatal
} AllTrayDebugLevel;

struct _AllTrayDebugDebugDescription {
	char* name;
	char* description;
};

struct _AllTrayDebugNotification {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AllTrayDebugNotificationPrivate * priv;
};

struct _AllTrayDebugNotificationClass {
	GTypeClass parent_class;
	void (*finalize) (AllTrayDebugNotification *self);
};

struct _AllTrayDebugParamSpecNotification {
	GParamSpec parent_instance;
};


static AllTrayDebugSubsystem all_tray_debug_notification__subsys;
static AllTrayDebugSubsystem all_tray_debug_notification__subsys = ALL_TRAY_DEBUG_SUBSYSTEM_None;
static gboolean all_tray_debug_notification__enabled;
static gboolean all_tray_debug_notification__enabled = FALSE;
static gpointer all_tray_debug_notification_parent_class = NULL;

GType all_tray_debug_subsystem_get_type (void) G_GNUC_CONST;
GType all_tray_debug_level_get_type (void) G_GNUC_CONST;
GType all_tray_debug_debug_description_get_type (void) G_GNUC_CONST;
AllTrayDebugDebugDescription* all_tray_debug_debug_description_dup (const AllTrayDebugDebugDescription* self);
void all_tray_debug_debug_description_free (AllTrayDebugDebugDescription* self);
void all_tray_debug_debug_description_copy (const AllTrayDebugDebugDescription* self, AllTrayDebugDebugDescription* dest);
void all_tray_debug_debug_description_destroy (AllTrayDebugDebugDescription* self);
gpointer all_tray_debug_notification_ref (gpointer instance);
void all_tray_debug_notification_unref (gpointer instance);
GParamSpec* all_tray_debug_param_spec_notification (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void all_tray_debug_value_set_notification (GValue* value, gpointer v_object);
void all_tray_debug_value_take_notification (GValue* value, gpointer v_object);
gpointer all_tray_debug_value_get_notification (const GValue* value);
GType all_tray_debug_notification_get_type (void) G_GNUC_CONST;
enum  {
	ALL_TRAY_DEBUG_NOTIFICATION_DUMMY_PROPERTY
};
void all_tray_debug_notification_display_debug_list (void);
void all_tray_debug_notification_init (void);
void all_tray_debug_notification_emit (AllTrayDebugSubsystem subsys, AllTrayDebugLevel lvl, const char* msg);
static char* all_tray_debug_notification_lvl_to_string (AllTrayDebugLevel lvl);
static char* all_tray_debug_notification_subsys_to_string (AllTrayDebugSubsystem subsys);
AllTrayDebugNotification* all_tray_debug_notification_new (void);
AllTrayDebugNotification* all_tray_debug_notification_construct (GType object_type);
static void all_tray_debug_notification_finalize (AllTrayDebugNotification* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const AllTrayDebugDebugDescription ALL_TRAY_DEBUG_NOTIFICATION__debugOptions[13] = {{"CL", N_ ("command line parsing")}, {"DISPLAY", N_ ("X11 display")}, {"TRAY", N_ ("System Tray Icon")}, {"WM", N_ ("Window Manager")}, {"PROCESS", N_ ("Process information")}, {"MISC", N_ ("Misc messages")}, {"BUG", N_ ("Internal error detail")}, {"APP", N_ ("Applications")}, {"AH", N_ ("AttachHelper class messages")}, {"SIG", N_ ("Signal debugging messages")}, {"MAIN", N_ ("Entrypoint, preinit, etc.")}, {"CTT", N_ ("Close-To-Tray")}, {"ALL", N_ ("All debug messages")}};


GType all_tray_debug_subsystem_get_type (void) {
	static volatile gsize all_tray_debug_subsystem_type_id__volatile = 0;
	if (g_once_init_enter (&all_tray_debug_subsystem_type_id__volatile)) {
		static const GEnumValue values[] = {{ALL_TRAY_DEBUG_SUBSYSTEM_None, "ALL_TRAY_DEBUG_SUBSYSTEM_None", "none"}, {ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine, "ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine", "commandline"}, {ALL_TRAY_DEBUG_SUBSYSTEM_Display, "ALL_TRAY_DEBUG_SUBSYSTEM_Display", "display"}, {ALL_TRAY_DEBUG_SUBSYSTEM_TrayIcon, "ALL_TRAY_DEBUG_SUBSYSTEM_TrayIcon", "trayicon"}, {ALL_TRAY_DEBUG_SUBSYSTEM_WindowManager, "ALL_TRAY_DEBUG_SUBSYSTEM_WindowManager", "windowmanager"}, {ALL_TRAY_DEBUG_SUBSYSTEM_Process, "ALL_TRAY_DEBUG_SUBSYSTEM_Process", "process"}, {ALL_TRAY_DEBUG_SUBSYSTEM_Misc, "ALL_TRAY_DEBUG_SUBSYSTEM_Misc", "misc"}, {ALL_TRAY_DEBUG_SUBSYSTEM_Bug, "ALL_TRAY_DEBUG_SUBSYSTEM_Bug", "bug"}, {ALL_TRAY_DEBUG_SUBSYSTEM_Application, "ALL_TRAY_DEBUG_SUBSYSTEM_Application", "application"}, {ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper, "ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper", "attachhelper"}, {ALL_TRAY_DEBUG_SUBSYSTEM_Signal, "ALL_TRAY_DEBUG_SUBSYSTEM_Signal", "signal"}, {ALL_TRAY_DEBUG_SUBSYSTEM_Main, "ALL_TRAY_DEBUG_SUBSYSTEM_Main", "main"}, {ALL_TRAY_DEBUG_SUBSYSTEM_Ctt, "ALL_TRAY_DEBUG_SUBSYSTEM_Ctt", "ctt"}, {ALL_TRAY_DEBUG_SUBSYSTEM_All, "ALL_TRAY_DEBUG_SUBSYSTEM_All", "all"}, {0, NULL, NULL}};
		GType all_tray_debug_subsystem_type_id;
		all_tray_debug_subsystem_type_id = g_enum_register_static ("AllTrayDebugSubsystem", values);
		g_once_init_leave (&all_tray_debug_subsystem_type_id__volatile, all_tray_debug_subsystem_type_id);
	}
	return all_tray_debug_subsystem_type_id__volatile;
}


GType all_tray_debug_level_get_type (void) {
	static volatile gsize all_tray_debug_level_type_id__volatile = 0;
	if (g_once_init_enter (&all_tray_debug_level_type_id__volatile)) {
		static const GEnumValue values[] = {{ALL_TRAY_DEBUG_LEVEL_Information, "ALL_TRAY_DEBUG_LEVEL_Information", "information"}, {ALL_TRAY_DEBUG_LEVEL_Warning, "ALL_TRAY_DEBUG_LEVEL_Warning", "warning"}, {ALL_TRAY_DEBUG_LEVEL_Error, "ALL_TRAY_DEBUG_LEVEL_Error", "error"}, {ALL_TRAY_DEBUG_LEVEL_Fatal, "ALL_TRAY_DEBUG_LEVEL_Fatal", "fatal"}, {0, NULL, NULL}};
		GType all_tray_debug_level_type_id;
		all_tray_debug_level_type_id = g_enum_register_static ("AllTrayDebugLevel", values);
		g_once_init_leave (&all_tray_debug_level_type_id__volatile, all_tray_debug_level_type_id);
	}
	return all_tray_debug_level_type_id__volatile;
}


void all_tray_debug_debug_description_copy (const AllTrayDebugDebugDescription* self, AllTrayDebugDebugDescription* dest) {
	dest->name = g_strdup (self->name);
	dest->description = g_strdup (self->description);
}


void all_tray_debug_debug_description_destroy (AllTrayDebugDebugDescription* self) {
	_g_free0 (self->name);
	_g_free0 (self->description);
}


AllTrayDebugDebugDescription* all_tray_debug_debug_description_dup (const AllTrayDebugDebugDescription* self) {
	AllTrayDebugDebugDescription* dup;
	dup = g_new0 (AllTrayDebugDebugDescription, 1);
	all_tray_debug_debug_description_copy (self, dup);
	return dup;
}


void all_tray_debug_debug_description_free (AllTrayDebugDebugDescription* self) {
	all_tray_debug_debug_description_destroy (self);
	g_free (self);
}


GType all_tray_debug_debug_description_get_type (void) {
	static volatile gsize all_tray_debug_debug_description_type_id__volatile = 0;
	if (g_once_init_enter (&all_tray_debug_debug_description_type_id__volatile)) {
		GType all_tray_debug_debug_description_type_id;
		all_tray_debug_debug_description_type_id = g_boxed_type_register_static ("AllTrayDebugDebugDescription", (GBoxedCopyFunc) all_tray_debug_debug_description_dup, (GBoxedFreeFunc) all_tray_debug_debug_description_free);
		g_once_init_leave (&all_tray_debug_debug_description_type_id__volatile, all_tray_debug_debug_description_type_id);
	}
	return all_tray_debug_debug_description_type_id__volatile;
}


void all_tray_debug_notification_display_debug_list (void) {
	fprintf (stdout, "%-16s%s\n", _ ("String"), _ ("Messages are for"));
	fprintf (stdout, "%s", "======================================" "======================================\n");
	{
		AllTrayDebugDebugDescription* dd_collection;
		int dd_collection_length1;
		int dd_it;
		dd_collection = ALL_TRAY_DEBUG_NOTIFICATION__debugOptions;
		dd_collection_length1 = G_N_ELEMENTS (ALL_TRAY_DEBUG_NOTIFICATION__debugOptions);
		for (dd_it = 0; dd_it < G_N_ELEMENTS (ALL_TRAY_DEBUG_NOTIFICATION__debugOptions); dd_it = dd_it + 1) {
			AllTrayDebugDebugDescription _tmp0_ = {0};
			AllTrayDebugDebugDescription dd;
			dd = (all_tray_debug_debug_description_copy (&dd_collection[dd_it], &_tmp0_), _tmp0_);
			{
				fprintf (stdout, "%-16s%s\n", dd.name, _ (dd.description));
				all_tray_debug_debug_description_destroy (&dd);
			}
		}
	}
}


void all_tray_debug_notification_init (void) {
	char* enabled_subsystems;
	all_tray_debug_notification__enabled = TRUE;
	enabled_subsystems = g_strdup (g_getenv ("ALLTRAY_DEBUG"));
	if (enabled_subsystems != NULL) {
		gint values_length1;
		gint _values_size_;
		char** _tmp1_;
		char** _tmp0_;
		char** values;
		values = (_tmp1_ = _tmp0_ = g_strsplit (enabled_subsystems, " ", 0), values_length1 = _vala_array_length (_tmp0_), _values_size_ = values_length1, _tmp1_);
		{
			char** tmpSubsys_collection;
			int tmpSubsys_collection_length1;
			int tmpSubsys_it;
			tmpSubsys_collection = values;
			tmpSubsys_collection_length1 = values_length1;
			for (tmpSubsys_it = 0; tmpSubsys_it < values_length1; tmpSubsys_it = tmpSubsys_it + 1) {
				char* tmpSubsys;
				tmpSubsys = g_strdup (tmpSubsys_collection[tmpSubsys_it]);
				{
					const char* _tmp2_;
					GQuark _tmp3_;
					static GQuark _tmp3__label0 = 0;
					static GQuark _tmp3__label1 = 0;
					static GQuark _tmp3__label2 = 0;
					static GQuark _tmp3__label3 = 0;
					static GQuark _tmp3__label4 = 0;
					static GQuark _tmp3__label5 = 0;
					static GQuark _tmp3__label6 = 0;
					static GQuark _tmp3__label7 = 0;
					static GQuark _tmp3__label8 = 0;
					static GQuark _tmp3__label9 = 0;
					static GQuark _tmp3__label10 = 0;
					static GQuark _tmp3__label11 = 0;
					static GQuark _tmp3__label12 = 0;
					_tmp2_ = tmpSubsys;
					_tmp3_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
					if (_tmp3_ == ((0 != _tmp3__label0) ? _tmp3__label0 : (_tmp3__label0 = g_quark_from_static_string ("AH"))))
					switch (0) {
						default:
						{
							all_tray_debug_notification__subsys = all_tray_debug_notification__subsys | ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper;
							break;
						}
					} else if (_tmp3_ == ((0 != _tmp3__label1) ? _tmp3__label1 : (_tmp3__label1 = g_quark_from_static_string ("CL"))))
					switch (0) {
						default:
						{
							all_tray_debug_notification__subsys = all_tray_debug_notification__subsys | ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine;
							break;
						}
					} else if (_tmp3_ == ((0 != _tmp3__label2) ? _tmp3__label2 : (_tmp3__label2 = g_quark_from_static_string ("DISPLAY"))))
					switch (0) {
						default:
						{
							all_tray_debug_notification__subsys = all_tray_debug_notification__subsys | ALL_TRAY_DEBUG_SUBSYSTEM_Display;
							break;
						}
					} else if (_tmp3_ == ((0 != _tmp3__label3) ? _tmp3__label3 : (_tmp3__label3 = g_quark_from_static_string ("SYSTRAY"))))
					switch (0) {
						default:
						{
							all_tray_debug_notification__subsys = all_tray_debug_notification__subsys | ALL_TRAY_DEBUG_SUBSYSTEM_TrayIcon;
							break;
						}
					} else if (_tmp3_ == ((0 != _tmp3__label4) ? _tmp3__label4 : (_tmp3__label4 = g_quark_from_static_string ("WM"))))
					switch (0) {
						default:
						{
							all_tray_debug_notification__subsys = all_tray_debug_notification__subsys | ALL_TRAY_DEBUG_SUBSYSTEM_WindowManager;
							break;
						}
					} else if (_tmp3_ == ((0 != _tmp3__label5) ? _tmp3__label5 : (_tmp3__label5 = g_quark_from_static_string ("PROCESS"))))
					switch (0) {
						default:
						{
							all_tray_debug_notification__subsys = all_tray_debug_notification__subsys | ALL_TRAY_DEBUG_SUBSYSTEM_Process;
							break;
						}
					} else if (_tmp3_ == ((0 != _tmp3__label6) ? _tmp3__label6 : (_tmp3__label6 = g_quark_from_static_string ("MISC"))))
					switch (0) {
						default:
						{
							all_tray_debug_notification__subsys = all_tray_debug_notification__subsys | ALL_TRAY_DEBUG_SUBSYSTEM_Misc;
							break;
						}
					} else if (_tmp3_ == ((0 != _tmp3__label7) ? _tmp3__label7 : (_tmp3__label7 = g_quark_from_static_string ("BUG"))))
					switch (0) {
						default:
						{
							all_tray_debug_notification__subsys = all_tray_debug_notification__subsys | ALL_TRAY_DEBUG_SUBSYSTEM_Bug;
							break;
						}
					} else if (_tmp3_ == ((0 != _tmp3__label8) ? _tmp3__label8 : (_tmp3__label8 = g_quark_from_static_string ("APP"))))
					switch (0) {
						default:
						{
							all_tray_debug_notification__subsys = all_tray_debug_notification__subsys | ALL_TRAY_DEBUG_SUBSYSTEM_Application;
							break;
						}
					} else if (_tmp3_ == ((0 != _tmp3__label9) ? _tmp3__label9 : (_tmp3__label9 = g_quark_from_static_string ("SIG"))))
					switch (0) {
						default:
						{
							all_tray_debug_notification__subsys = all_tray_debug_notification__subsys | ALL_TRAY_DEBUG_SUBSYSTEM_Signal;
							break;
						}
					} else if (_tmp3_ == ((0 != _tmp3__label10) ? _tmp3__label10 : (_tmp3__label10 = g_quark_from_static_string ("MAIN"))))
					switch (0) {
						default:
						{
							all_tray_debug_notification__subsys = all_tray_debug_notification__subsys | ALL_TRAY_DEBUG_SUBSYSTEM_Main;
							break;
						}
					} else if (_tmp3_ == ((0 != _tmp3__label11) ? _tmp3__label11 : (_tmp3__label11 = g_quark_from_static_string ("CTT"))))
					switch (0) {
						default:
						{
							all_tray_debug_notification__subsys = all_tray_debug_notification__subsys | ALL_TRAY_DEBUG_SUBSYSTEM_Ctt;
							break;
						}
					} else if (_tmp3_ == ((0 != _tmp3__label12) ? _tmp3__label12 : (_tmp3__label12 = g_quark_from_static_string ("ALL"))))
					switch (0) {
						default:
						{
							all_tray_debug_notification__subsys = all_tray_debug_notification__subsys | (((((((((((ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine | ALL_TRAY_DEBUG_SUBSYSTEM_Display) | ALL_TRAY_DEBUG_SUBSYSTEM_TrayIcon) | ALL_TRAY_DEBUG_SUBSYSTEM_WindowManager) | ALL_TRAY_DEBUG_SUBSYSTEM_Process) | ALL_TRAY_DEBUG_SUBSYSTEM_Misc) | ALL_TRAY_DEBUG_SUBSYSTEM_Bug) | ALL_TRAY_DEBUG_SUBSYSTEM_Application) | ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper) | ALL_TRAY_DEBUG_SUBSYSTEM_Signal) | ALL_TRAY_DEBUG_SUBSYSTEM_Main) | ALL_TRAY_DEBUG_SUBSYSTEM_Ctt);
							break;
						}
					} else
					switch (0) {
						default:
						{
							g_warning (_ ("Unrecognized value '%s' in ALLTRAY_DEBUG"), tmpSubsys);
							break;
						}
					}
					_g_free0 (tmpSubsys);
				}
			}
		}
		all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Misc, ALL_TRAY_DEBUG_LEVEL_Information, _ ("Debugging subsystem setup complete."));
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
	} else {
		gboolean _tmp4_ = FALSE;
		if (enabled_subsystems == NULL) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = _vala_strcmp0 (enabled_subsystems, "") == 0;
		}
		if (_tmp4_) {
			g_warning ("Debug.vala:146: %s", _ ("ALLTRAY_DEBUG not set!"));
		}
	}
	_g_free0 (enabled_subsystems);
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	localtime_r (&time, &_result_);
	*result = _result_;
	return;
}


static char* g_time_format (struct tm *self, const char* format) {
	char* result = NULL;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp0_;
	gchar* buffer;
	g_return_val_if_fail (format != NULL, NULL);
	buffer = (_tmp0_ = g_new0 (gchar, 64), buffer_length1 = 64, _buffer_size_ = buffer_length1, _tmp0_);
	strftime (buffer, buffer_length1, format, &(*self));
	result = g_strdup ((const char*) buffer);
	buffer = (g_free (buffer), NULL);
	return result;
}


void all_tray_debug_notification_emit (AllTrayDebugSubsystem subsys, AllTrayDebugLevel lvl, const char* msg) {
	char* cur_time;
	struct tm _tmp0_ = {0};
	struct tm _tmp1_;
	char* _tmp2_;
	char* lvl_str;
	char* subsys_str;
	g_return_if_fail (msg != NULL);
	if (!all_tray_debug_notification__enabled) {
		return;
	}
	if ((all_tray_debug_notification__subsys & subsys) != subsys) {
		return;
	}
	cur_time = NULL;
	cur_time = (_tmp2_ = g_time_format ((_tmp1_ = (g_time_local (time (NULL), &_tmp0_), _tmp0_), &_tmp1_), "%F %T %Z"), _g_free0 (cur_time), _tmp2_);
	lvl_str = all_tray_debug_notification_lvl_to_string (lvl);
	subsys_str = all_tray_debug_notification_subsys_to_string (subsys);
	fprintf (stdout, "[%s] %s/%s: %s\n", cur_time, lvl_str, subsys_str, msg);
	if (lvl == ALL_TRAY_DEBUG_LEVEL_Fatal) {
		all_tray_debug_notification_emit (subsys, ALL_TRAY_DEBUG_LEVEL_Information, _ ("Exiting: encountered fatal error."));
		abort ();
	}
	_g_free0 (subsys_str);
	_g_free0 (lvl_str);
	_g_free0 (cur_time);
}


static char* all_tray_debug_notification_subsys_to_string (AllTrayDebugSubsystem subsys) {
	char* result = NULL;
	char* retval;
	retval = g_strdup ("");
	switch (subsys) {
		case ALL_TRAY_DEBUG_SUBSYSTEM_None:
		{
			char* _tmp0_;
			retval = (_tmp0_ = g_strdup ("None"), _g_free0 (retval), _tmp0_);
			break;
		}
		case ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper:
		{
			char* _tmp1_;
			retval = (_tmp1_ = g_strdup ("AH"), _g_free0 (retval), _tmp1_);
			break;
		}
		case ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine:
		{
			char* _tmp2_;
			retval = (_tmp2_ = g_strdup ("CL"), _g_free0 (retval), _tmp2_);
			break;
		}
		case ALL_TRAY_DEBUG_SUBSYSTEM_Display:
		{
			char* _tmp3_;
			retval = (_tmp3_ = g_strdup ("DISPLAY"), _g_free0 (retval), _tmp3_);
			break;
		}
		case ALL_TRAY_DEBUG_SUBSYSTEM_TrayIcon:
		{
			char* _tmp4_;
			retval = (_tmp4_ = g_strdup ("TRAY"), _g_free0 (retval), _tmp4_);
			break;
		}
		case ALL_TRAY_DEBUG_SUBSYSTEM_WindowManager:
		{
			char* _tmp5_;
			retval = (_tmp5_ = g_strdup ("WM"), _g_free0 (retval), _tmp5_);
			break;
		}
		case ALL_TRAY_DEBUG_SUBSYSTEM_Process:
		{
			char* _tmp6_;
			retval = (_tmp6_ = g_strdup ("PROCESS"), _g_free0 (retval), _tmp6_);
			break;
		}
		case ALL_TRAY_DEBUG_SUBSYSTEM_Misc:
		{
			char* _tmp7_;
			retval = (_tmp7_ = g_strdup ("MISC"), _g_free0 (retval), _tmp7_);
			break;
		}
		case ALL_TRAY_DEBUG_SUBSYSTEM_Application:
		{
			char* _tmp8_;
			retval = (_tmp8_ = g_strdup ("APP"), _g_free0 (retval), _tmp8_);
			break;
		}
		case ALL_TRAY_DEBUG_SUBSYSTEM_Bug:
		{
			char* _tmp9_;
			retval = (_tmp9_ = g_strdup ("BUG"), _g_free0 (retval), _tmp9_);
			break;
		}
		case ALL_TRAY_DEBUG_SUBSYSTEM_Signal:
		{
			char* _tmp10_;
			retval = (_tmp10_ = g_strdup ("SIG"), _g_free0 (retval), _tmp10_);
			break;
		}
		case ALL_TRAY_DEBUG_SUBSYSTEM_Main:
		{
			char* _tmp11_;
			retval = (_tmp11_ = g_strdup ("MAIN"), _g_free0 (retval), _tmp11_);
			break;
		}
		case ALL_TRAY_DEBUG_SUBSYSTEM_Ctt:
		{
			char* _tmp12_;
			retval = (_tmp12_ = g_strdup ("CTT"), _g_free0 (retval), _tmp12_);
			break;
		}
		default:
		{
			g_error ("Debug.vala:228: %s", _ ("BUG: Reached default, should not be possible."));
			break;
		}
	}
	result = retval;
	return result;
}


static char* all_tray_debug_notification_lvl_to_string (AllTrayDebugLevel lvl) {
	char* result = NULL;
	char* retval;
	retval = g_strdup ("");
	switch (lvl) {
		case ALL_TRAY_DEBUG_LEVEL_Information:
		{
			char* _tmp0_;
			retval = (_tmp0_ = g_strdup ("INFO"), _g_free0 (retval), _tmp0_);
			break;
		}
		case ALL_TRAY_DEBUG_LEVEL_Warning:
		{
			char* _tmp1_;
			retval = (_tmp1_ = g_strdup ("WARN"), _g_free0 (retval), _tmp1_);
			break;
		}
		case ALL_TRAY_DEBUG_LEVEL_Error:
		{
			char* _tmp2_;
			retval = (_tmp2_ = g_strdup ("ERR"), _g_free0 (retval), _tmp2_);
			break;
		}
		case ALL_TRAY_DEBUG_LEVEL_Fatal:
		{
			char* _tmp3_;
			retval = (_tmp3_ = g_strdup ("FATAL"), _g_free0 (retval), _tmp3_);
			break;
		}
		default:
		{
			g_error ("Debug.vala:256: %s", _ ("BUG: Reached default, should not be possible."));
			break;
		}
	}
	result = retval;
	return result;
}


AllTrayDebugNotification* all_tray_debug_notification_construct (GType object_type) {
	AllTrayDebugNotification* self = (AllTrayDebugNotification*) g_type_create_instance (object_type);
	return self;
}


AllTrayDebugNotification* all_tray_debug_notification_new (void) {
	return all_tray_debug_notification_construct (ALL_TRAY_DEBUG_TYPE_NOTIFICATION);
}


static void all_tray_debug_value_notification_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void all_tray_debug_value_notification_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		all_tray_debug_notification_unref (value->data[0].v_pointer);
	}
}


static void all_tray_debug_value_notification_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = all_tray_debug_notification_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer all_tray_debug_value_notification_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* all_tray_debug_value_notification_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AllTrayDebugNotification* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = all_tray_debug_notification_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* all_tray_debug_value_notification_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AllTrayDebugNotification** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = all_tray_debug_notification_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* all_tray_debug_param_spec_notification (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	AllTrayDebugParamSpecNotification* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ALL_TRAY_DEBUG_TYPE_NOTIFICATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer all_tray_debug_value_get_notification (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALL_TRAY_DEBUG_TYPE_NOTIFICATION), NULL);
	return value->data[0].v_pointer;
}


void all_tray_debug_value_set_notification (GValue* value, gpointer v_object) {
	AllTrayDebugNotification* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALL_TRAY_DEBUG_TYPE_NOTIFICATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ALL_TRAY_DEBUG_TYPE_NOTIFICATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		all_tray_debug_notification_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		all_tray_debug_notification_unref (old);
	}
}


void all_tray_debug_value_take_notification (GValue* value, gpointer v_object) {
	AllTrayDebugNotification* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALL_TRAY_DEBUG_TYPE_NOTIFICATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ALL_TRAY_DEBUG_TYPE_NOTIFICATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		all_tray_debug_notification_unref (old);
	}
}


static void all_tray_debug_notification_class_init (AllTrayDebugNotificationClass * klass) {
	all_tray_debug_notification_parent_class = g_type_class_peek_parent (klass);
	ALL_TRAY_DEBUG_NOTIFICATION_CLASS (klass)->finalize = all_tray_debug_notification_finalize;
}


static void all_tray_debug_notification_instance_init (AllTrayDebugNotification * self) {
	self->ref_count = 1;
}


static void all_tray_debug_notification_finalize (AllTrayDebugNotification* obj) {
	AllTrayDebugNotification * self;
	self = ALL_TRAY_DEBUG_NOTIFICATION (obj);
}


GType all_tray_debug_notification_get_type (void) {
	static volatile gsize all_tray_debug_notification_type_id__volatile = 0;
	if (g_once_init_enter (&all_tray_debug_notification_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { all_tray_debug_value_notification_init, all_tray_debug_value_notification_free_value, all_tray_debug_value_notification_copy_value, all_tray_debug_value_notification_peek_pointer, "p", all_tray_debug_value_notification_collect_value, "p", all_tray_debug_value_notification_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AllTrayDebugNotificationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) all_tray_debug_notification_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AllTrayDebugNotification), 0, (GInstanceInitFunc) all_tray_debug_notification_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType all_tray_debug_notification_type_id;
		all_tray_debug_notification_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AllTrayDebugNotification", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&all_tray_debug_notification_type_id__volatile, all_tray_debug_notification_type_id);
	}
	return all_tray_debug_notification_type_id__volatile;
}


gpointer all_tray_debug_notification_ref (gpointer instance) {
	AllTrayDebugNotification* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void all_tray_debug_notification_unref (gpointer instance) {
	AllTrayDebugNotification* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ALL_TRAY_DEBUG_NOTIFICATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




