/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "account.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "./account_p.h"

#include <gwenhywfar/misc.h>
#include <gwenhywfar/debug.h>

/* code headers */

/* macro functions */
GWEN_LIST_FUNCTIONS(AB_ACCOUNT, AB_Account)
GWEN_LIST2_FUNCTIONS(AB_ACCOUNT, AB_Account)
GWEN_INHERIT_FUNCTIONS(AB_ACCOUNT)


AB_ACCOUNT *AB_Account_new(void) {
  AB_ACCOUNT *p_struct;

  GWEN_NEW_OBJECT(AB_ACCOUNT, p_struct)
  p_struct->_refCount=1;
  GWEN_INHERIT_INIT(AB_ACCOUNT, p_struct)
  GWEN_LIST_INIT(AB_ACCOUNT, p_struct)
  /* members */
  p_struct->accountType=AB_AccountType_Unknown;
  p_struct->uniqueId=0;
  p_struct->backendName=NULL;
  p_struct->ownerName=NULL;
  p_struct->bankName=NULL;
  p_struct->accountName=NULL;
  p_struct->currency=NULL;
  p_struct->memo=NULL;
  p_struct->iban=NULL;
  p_struct->bic=NULL;
  p_struct->country=NULL;
  p_struct->bankCode=NULL;
  p_struct->branchId=NULL;
  p_struct->accountNumber=NULL;
  p_struct->subAccountId=NULL;
  p_struct->userId=0;
  p_struct->provider=NULL;
  /* virtual functions */
  p_struct->readFromDbFn=AB_Account__ReadFromDb;
  p_struct->writeToDbFn=AB_Account__WriteToDb;

  return p_struct;
}

void AB_Account_free(AB_ACCOUNT *p_struct) {
  if (p_struct) {
  assert(p_struct->_refCount);
  if (p_struct->_refCount==1) {
    GWEN_INHERIT_FINI(AB_ACCOUNT, p_struct)
    GWEN_LIST_FINI(AB_ACCOUNT, p_struct)
  /* members */
    free(p_struct->backendName); p_struct->backendName=NULL;
    free(p_struct->ownerName); p_struct->ownerName=NULL;
    free(p_struct->bankName); p_struct->bankName=NULL;
    free(p_struct->accountName); p_struct->accountName=NULL;
    free(p_struct->currency); p_struct->currency=NULL;
    free(p_struct->memo); p_struct->memo=NULL;
    free(p_struct->iban); p_struct->iban=NULL;
    free(p_struct->bic); p_struct->bic=NULL;
    free(p_struct->country); p_struct->country=NULL;
    free(p_struct->bankCode); p_struct->bankCode=NULL;
    free(p_struct->branchId); p_struct->branchId=NULL;
    free(p_struct->accountNumber); p_struct->accountNumber=NULL;
    free(p_struct->subAccountId); p_struct->subAccountId=NULL;
    p_struct->_refCount=0;
    GWEN_FREE_OBJECT(p_struct);
  }
  else
    p_struct->_refCount--;
  }
}

void AB_Account_Attach(AB_ACCOUNT *p_struct) {
  assert(p_struct);
  assert(p_struct->_refCount);
  p_struct->_refCount++;
}

int AB_Account_GetAccountType(const AB_ACCOUNT *p_struct) {
  assert(p_struct);
  return p_struct->accountType;
}

uint32_t AB_Account_GetUniqueId(const AB_ACCOUNT *p_struct) {
  assert(p_struct);
  return p_struct->uniqueId;
}

const char *AB_Account_GetBackendName(const AB_ACCOUNT *p_struct) {
  assert(p_struct);
  return p_struct->backendName;
}

const char *AB_Account_GetOwnerName(const AB_ACCOUNT *p_struct) {
  assert(p_struct);
  return p_struct->ownerName;
}

const char *AB_Account_GetBankName(const AB_ACCOUNT *p_struct) {
  assert(p_struct);
  return p_struct->bankName;
}

const char *AB_Account_GetAccountName(const AB_ACCOUNT *p_struct) {
  assert(p_struct);
  return p_struct->accountName;
}

const char *AB_Account_GetCurrency(const AB_ACCOUNT *p_struct) {
  assert(p_struct);
  return p_struct->currency;
}

const char *AB_Account_GetMemo(const AB_ACCOUNT *p_struct) {
  assert(p_struct);
  return p_struct->memo;
}

const char *AB_Account_GetIban(const AB_ACCOUNT *p_struct) {
  assert(p_struct);
  return p_struct->iban;
}

const char *AB_Account_GetBic(const AB_ACCOUNT *p_struct) {
  assert(p_struct);
  return p_struct->bic;
}

const char *AB_Account_GetCountry(const AB_ACCOUNT *p_struct) {
  assert(p_struct);
  return p_struct->country;
}

const char *AB_Account_GetBankCode(const AB_ACCOUNT *p_struct) {
  assert(p_struct);
  return p_struct->bankCode;
}

const char *AB_Account_GetBranchId(const AB_ACCOUNT *p_struct) {
  assert(p_struct);
  return p_struct->branchId;
}

const char *AB_Account_GetAccountNumber(const AB_ACCOUNT *p_struct) {
  assert(p_struct);
  return p_struct->accountNumber;
}

const char *AB_Account_GetSubAccountId(const AB_ACCOUNT *p_struct) {
  assert(p_struct);
  return p_struct->subAccountId;
}

uint32_t AB_Account_GetUserId(const AB_ACCOUNT *p_struct) {
  assert(p_struct);
  return p_struct->userId;
}

AB_PROVIDER *AB_Account_GetProvider(const AB_ACCOUNT *p_struct) {
  assert(p_struct);
  return p_struct->provider;
}

void AB_Account_SetAccountType(AB_ACCOUNT *p_struct, int p_src) {
  assert(p_struct);
  p_struct->accountType=p_src;
}

void AB_Account_SetUniqueId(AB_ACCOUNT *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->uniqueId=p_src;
}

void AB_Account_SetBackendName(AB_ACCOUNT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->backendName) {
    free(p_struct->backendName); p_struct->backendName=NULL;
  }
  if (p_src) {
    p_struct->backendName=strdup(p_src);
  }
  else {
    p_struct->backendName=NULL;
  }
}

void AB_Account_SetOwnerName(AB_ACCOUNT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->ownerName) {
    free(p_struct->ownerName); p_struct->ownerName=NULL;
  }
  if (p_src) {
    p_struct->ownerName=strdup(p_src);
  }
  else {
    p_struct->ownerName=NULL;
  }
}

void AB_Account_SetBankName(AB_ACCOUNT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->bankName) {
    free(p_struct->bankName); p_struct->bankName=NULL;
  }
  if (p_src) {
    p_struct->bankName=strdup(p_src);
  }
  else {
    p_struct->bankName=NULL;
  }
}

void AB_Account_SetAccountName(AB_ACCOUNT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->accountName) {
    free(p_struct->accountName); p_struct->accountName=NULL;
  }
  if (p_src) {
    p_struct->accountName=strdup(p_src);
  }
  else {
    p_struct->accountName=NULL;
  }
}

void AB_Account_SetCurrency(AB_ACCOUNT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->currency) {
    free(p_struct->currency); p_struct->currency=NULL;
  }
  if (p_src) {
    p_struct->currency=strdup(p_src);
  }
  else {
    p_struct->currency=NULL;
  }
}

void AB_Account_SetMemo(AB_ACCOUNT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->memo) {
    free(p_struct->memo); p_struct->memo=NULL;
  }
  if (p_src) {
    p_struct->memo=strdup(p_src);
  }
  else {
    p_struct->memo=NULL;
  }
}

void AB_Account_SetIban(AB_ACCOUNT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->iban) {
    free(p_struct->iban); p_struct->iban=NULL;
  }
  if (p_src) {
    p_struct->iban=strdup(p_src);
  }
  else {
    p_struct->iban=NULL;
  }
}

void AB_Account_SetBic(AB_ACCOUNT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->bic) {
    free(p_struct->bic); p_struct->bic=NULL;
  }
  if (p_src) {
    p_struct->bic=strdup(p_src);
  }
  else {
    p_struct->bic=NULL;
  }
}

void AB_Account_SetCountry(AB_ACCOUNT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->country) {
    free(p_struct->country); p_struct->country=NULL;
  }
  if (p_src) {
    p_struct->country=strdup(p_src);
  }
  else {
    p_struct->country=NULL;
  }
}

void AB_Account_SetBankCode(AB_ACCOUNT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->bankCode) {
    free(p_struct->bankCode); p_struct->bankCode=NULL;
  }
  if (p_src) {
    p_struct->bankCode=strdup(p_src);
  }
  else {
    p_struct->bankCode=NULL;
  }
}

void AB_Account_SetBranchId(AB_ACCOUNT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->branchId) {
    free(p_struct->branchId); p_struct->branchId=NULL;
  }
  if (p_src) {
    p_struct->branchId=strdup(p_src);
  }
  else {
    p_struct->branchId=NULL;
  }
}

void AB_Account_SetAccountNumber(AB_ACCOUNT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->accountNumber) {
    free(p_struct->accountNumber); p_struct->accountNumber=NULL;
  }
  if (p_src) {
    p_struct->accountNumber=strdup(p_src);
  }
  else {
    p_struct->accountNumber=NULL;
  }
}

void AB_Account_SetSubAccountId(AB_ACCOUNT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->subAccountId) {
    free(p_struct->subAccountId); p_struct->subAccountId=NULL;
  }
  if (p_src) {
    p_struct->subAccountId=strdup(p_src);
  }
  else {
    p_struct->subAccountId=NULL;
  }
}

void AB_Account_SetUserId(AB_ACCOUNT *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->userId=p_src;
}

void AB_Account_SetProvider(AB_ACCOUNT *p_struct, AB_PROVIDER *p_src) {
  assert(p_struct);
  p_struct->provider=p_src;
}

/* code for virtual functions */
int AB_Account_ReadFromDb(AB_ACCOUNT *p_struct, GWEN_DB_NODE* dbData) {
  assert(p_struct);
  if (p_struct->readFromDbFn)
    return p_struct->readFromDbFn(p_struct, dbData);
  else
    return GWEN_ERROR_NOT_IMPLEMENTED;
}

int AB_Account_WriteToDb(const AB_ACCOUNT *p_struct, GWEN_DB_NODE* dbData) {
  assert(p_struct);
  if (p_struct->writeToDbFn)
    return p_struct->writeToDbFn(p_struct, dbData);
  else
    return GWEN_ERROR_NOT_IMPLEMENTED;
}

/* setters for virtual functions */
AB_ACCOUNT_READFROMDB_FN AB_Account_SetReadFromDbFn(AB_ACCOUNT *p_struct, AB_ACCOUNT_READFROMDB_FN fn){
  AB_ACCOUNT_READFROMDB_FN oldFn;

  assert(p_struct);
  oldFn=p_struct->readFromDbFn;
  p_struct->readFromDbFn=fn;
  return oldFn;
}

AB_ACCOUNT_WRITETODB_FN AB_Account_SetWriteToDbFn(AB_ACCOUNT *p_struct, AB_ACCOUNT_WRITETODB_FN fn){
  AB_ACCOUNT_WRITETODB_FN oldFn;

  assert(p_struct);
  oldFn=p_struct->writeToDbFn;
  p_struct->writeToDbFn=fn;
  return oldFn;
}

/* getters for virtual functions */
AB_ACCOUNT_READFROMDB_FN AB_Account_GetReadFromDbFn(const AB_ACCOUNT *p_struct){
  assert(p_struct);
  return p_struct->readFromDbFn;
}

AB_ACCOUNT_WRITETODB_FN AB_Account_GetWriteToDbFn(const AB_ACCOUNT *p_struct){
  assert(p_struct);
  return p_struct->writeToDbFn;
}

void AB_Account_ReadDb(AB_ACCOUNT *p_struct, GWEN_DB_NODE *p_db) {
  assert(p_struct);
  /* member "accountType" */
  p_struct->accountType=GWEN_DB_GetIntValue(p_db, "accountType", 0, AB_AccountType_Unknown);

  /* member "uniqueId" */
  p_struct->uniqueId=GWEN_DB_GetIntValue(p_db, "uniqueId", 0, 0);

  /* member "backendName" */
  if (p_struct->backendName) {
    free(p_struct->backendName); p_struct->backendName=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "backendName", 0, NULL); if (s) p_struct->backendName=strdup(s); }
  if (p_struct->backendName==NULL) {  p_struct->backendName=NULL;
  }

  /* member "ownerName" */
  if (p_struct->ownerName) {
    free(p_struct->ownerName); p_struct->ownerName=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "ownerName", 0, NULL); if (s) p_struct->ownerName=strdup(s); }
  if (p_struct->ownerName==NULL) {  p_struct->ownerName=NULL;
  }

  /* member "bankName" */
  if (p_struct->bankName) {
    free(p_struct->bankName); p_struct->bankName=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "bankName", 0, NULL); if (s) p_struct->bankName=strdup(s); }
  if (p_struct->bankName==NULL) {  p_struct->bankName=NULL;
  }

  /* member "accountName" */
  if (p_struct->accountName) {
    free(p_struct->accountName); p_struct->accountName=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "accountName", 0, NULL); if (s) p_struct->accountName=strdup(s); }
  if (p_struct->accountName==NULL) {  p_struct->accountName=NULL;
  }

  /* member "currency" */
  if (p_struct->currency) {
    free(p_struct->currency); p_struct->currency=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "currency", 0, NULL); if (s) p_struct->currency=strdup(s); }
  if (p_struct->currency==NULL) {  p_struct->currency=NULL;
  }

  /* member "memo" */
  if (p_struct->memo) {
    free(p_struct->memo); p_struct->memo=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "memo", 0, NULL); if (s) p_struct->memo=strdup(s); }
  if (p_struct->memo==NULL) {  p_struct->memo=NULL;
  }

  /* member "iban" */
  if (p_struct->iban) {
    free(p_struct->iban); p_struct->iban=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "iban", 0, NULL); if (s) p_struct->iban=strdup(s); }
  if (p_struct->iban==NULL) {  p_struct->iban=NULL;
  }

  /* member "bic" */
  if (p_struct->bic) {
    free(p_struct->bic); p_struct->bic=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "bic", 0, NULL); if (s) p_struct->bic=strdup(s); }
  if (p_struct->bic==NULL) {  p_struct->bic=NULL;
  }

  /* member "country" */
  if (p_struct->country) {
    free(p_struct->country); p_struct->country=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "country", 0, NULL); if (s) p_struct->country=strdup(s); }
  if (p_struct->country==NULL) {  p_struct->country=NULL;
  }

  /* member "bankCode" */
  if (p_struct->bankCode) {
    free(p_struct->bankCode); p_struct->bankCode=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "bankCode", 0, NULL); if (s) p_struct->bankCode=strdup(s); }
  if (p_struct->bankCode==NULL) {  p_struct->bankCode=NULL;
  }

  /* member "branchId" */
  if (p_struct->branchId) {
    free(p_struct->branchId); p_struct->branchId=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "branchId", 0, NULL); if (s) p_struct->branchId=strdup(s); }
  if (p_struct->branchId==NULL) {  p_struct->branchId=NULL;
  }

  /* member "accountNumber" */
  if (p_struct->accountNumber) {
    free(p_struct->accountNumber); p_struct->accountNumber=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "accountNumber", 0, NULL); if (s) p_struct->accountNumber=strdup(s); }
  if (p_struct->accountNumber==NULL) {  p_struct->accountNumber=NULL;
  }

  /* member "subAccountId" */
  if (p_struct->subAccountId) {
    free(p_struct->subAccountId); p_struct->subAccountId=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "subAccountId", 0, NULL); if (s) p_struct->subAccountId=strdup(s); }
  if (p_struct->subAccountId==NULL) {  p_struct->subAccountId=NULL;
  }

  /* member "userId" */
  p_struct->userId=GWEN_DB_GetIntValue(p_db, "userId", 0, 0);

  /* member "provider" */
  /* member "provider" is volatile, just presetting */
  p_struct->provider=NULL;

}

int AB_Account_WriteDb(const AB_ACCOUNT *p_struct, GWEN_DB_NODE *p_db) {
  int p_rv;

  assert(p_struct);
  /* member "accountType" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "accountType", p_struct->accountType);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "uniqueId" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "uniqueId", p_struct->uniqueId);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "backendName" */
  if (p_struct->backendName) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "backendName", p_struct->backendName); else { GWEN_DB_DeleteVar(p_db, "backendName"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "ownerName" */
  if (p_struct->ownerName) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "ownerName", p_struct->ownerName); else { GWEN_DB_DeleteVar(p_db, "ownerName"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "bankName" */
  if (p_struct->bankName) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "bankName", p_struct->bankName); else { GWEN_DB_DeleteVar(p_db, "bankName"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "accountName" */
  if (p_struct->accountName) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "accountName", p_struct->accountName); else { GWEN_DB_DeleteVar(p_db, "accountName"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "currency" */
  if (p_struct->currency) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "currency", p_struct->currency); else { GWEN_DB_DeleteVar(p_db, "currency"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "memo" */
  if (p_struct->memo) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "memo", p_struct->memo); else { GWEN_DB_DeleteVar(p_db, "memo"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "iban" */
  if (p_struct->iban) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "iban", p_struct->iban); else { GWEN_DB_DeleteVar(p_db, "iban"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "bic" */
  if (p_struct->bic) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "bic", p_struct->bic); else { GWEN_DB_DeleteVar(p_db, "bic"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "country" */
  if (p_struct->country) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "country", p_struct->country); else { GWEN_DB_DeleteVar(p_db, "country"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "bankCode" */
  if (p_struct->bankCode) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "bankCode", p_struct->bankCode); else { GWEN_DB_DeleteVar(p_db, "bankCode"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "branchId" */
  if (p_struct->branchId) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "branchId", p_struct->branchId); else { GWEN_DB_DeleteVar(p_db, "branchId"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "accountNumber" */
  if (p_struct->accountNumber) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "accountNumber", p_struct->accountNumber); else { GWEN_DB_DeleteVar(p_db, "accountNumber"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "subAccountId" */
  if (p_struct->subAccountId) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "subAccountId", p_struct->subAccountId); else { GWEN_DB_DeleteVar(p_db, "subAccountId"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "userId" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "userId", p_struct->userId);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "provider" is volatile, not writing to db */

  return 0;
}

AB_ACCOUNT *AB_Account_fromDb(GWEN_DB_NODE *p_db) {
  AB_ACCOUNT *p_struct;
  p_struct=AB_Account_new();
  AB_Account_ReadDb(p_struct, p_db);
  return p_struct;
}

int AB_Account_toDb(const AB_ACCOUNT *p_struct, GWEN_DB_NODE *p_db) {
  return AB_Account_WriteDb(p_struct, p_db);
}

void AB_Account_ReadXml(AB_ACCOUNT *p_struct, GWEN_XMLNODE *p_db) {
  assert(p_struct);
  /* member "accountType" */
  p_struct->accountType=GWEN_XMLNode_GetIntValue(p_db, "accountType", AB_AccountType_Unknown);

  /* member "uniqueId" */
  p_struct->uniqueId=GWEN_XMLNode_GetIntValue(p_db, "uniqueId", 0);

  /* member "backendName" */
  if (p_struct->backendName) {
    free(p_struct->backendName); p_struct->backendName=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "backendName", NULL); if (s) p_struct->backendName=strdup(s); }
  if (p_struct->backendName==NULL) {  /* preset member "backendName" if empty */
  p_struct->backendName=NULL;
  }

  /* member "ownerName" */
  if (p_struct->ownerName) {
    free(p_struct->ownerName); p_struct->ownerName=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "ownerName", NULL); if (s) p_struct->ownerName=strdup(s); }
  if (p_struct->ownerName==NULL) {  /* preset member "ownerName" if empty */
  p_struct->ownerName=NULL;
  }

  /* member "bankName" */
  if (p_struct->bankName) {
    free(p_struct->bankName); p_struct->bankName=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "bankName", NULL); if (s) p_struct->bankName=strdup(s); }
  if (p_struct->bankName==NULL) {  /* preset member "bankName" if empty */
  p_struct->bankName=NULL;
  }

  /* member "accountName" */
  if (p_struct->accountName) {
    free(p_struct->accountName); p_struct->accountName=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "accountName", NULL); if (s) p_struct->accountName=strdup(s); }
  if (p_struct->accountName==NULL) {  /* preset member "accountName" if empty */
  p_struct->accountName=NULL;
  }

  /* member "currency" */
  if (p_struct->currency) {
    free(p_struct->currency); p_struct->currency=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "currency", NULL); if (s) p_struct->currency=strdup(s); }
  if (p_struct->currency==NULL) {  /* preset member "currency" if empty */
  p_struct->currency=NULL;
  }

  /* member "memo" */
  if (p_struct->memo) {
    free(p_struct->memo); p_struct->memo=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "memo", NULL); if (s) p_struct->memo=strdup(s); }
  if (p_struct->memo==NULL) {  /* preset member "memo" if empty */
  p_struct->memo=NULL;
  }

  /* member "iban" */
  if (p_struct->iban) {
    free(p_struct->iban); p_struct->iban=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "iban", NULL); if (s) p_struct->iban=strdup(s); }
  if (p_struct->iban==NULL) {  /* preset member "iban" if empty */
  p_struct->iban=NULL;
  }

  /* member "bic" */
  if (p_struct->bic) {
    free(p_struct->bic); p_struct->bic=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "bic", NULL); if (s) p_struct->bic=strdup(s); }
  if (p_struct->bic==NULL) {  /* preset member "bic" if empty */
  p_struct->bic=NULL;
  }

  /* member "country" */
  if (p_struct->country) {
    free(p_struct->country); p_struct->country=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "country", NULL); if (s) p_struct->country=strdup(s); }
  if (p_struct->country==NULL) {  /* preset member "country" if empty */
  p_struct->country=NULL;
  }

  /* member "bankCode" */
  if (p_struct->bankCode) {
    free(p_struct->bankCode); p_struct->bankCode=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "bankCode", NULL); if (s) p_struct->bankCode=strdup(s); }
  if (p_struct->bankCode==NULL) {  /* preset member "bankCode" if empty */
  p_struct->bankCode=NULL;
  }

  /* member "branchId" */
  if (p_struct->branchId) {
    free(p_struct->branchId); p_struct->branchId=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "branchId", NULL); if (s) p_struct->branchId=strdup(s); }
  if (p_struct->branchId==NULL) {  /* preset member "branchId" if empty */
  p_struct->branchId=NULL;
  }

  /* member "accountNumber" */
  if (p_struct->accountNumber) {
    free(p_struct->accountNumber); p_struct->accountNumber=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "accountNumber", NULL); if (s) p_struct->accountNumber=strdup(s); }
  if (p_struct->accountNumber==NULL) {  /* preset member "accountNumber" if empty */
  p_struct->accountNumber=NULL;
  }

  /* member "subAccountId" */
  if (p_struct->subAccountId) {
    free(p_struct->subAccountId); p_struct->subAccountId=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "subAccountId", NULL); if (s) p_struct->subAccountId=strdup(s); }
  if (p_struct->subAccountId==NULL) {  /* preset member "subAccountId" if empty */
  p_struct->subAccountId=NULL;
  }

  /* member "userId" */
  p_struct->userId=GWEN_XMLNode_GetIntValue(p_db, "userId", 0);

  /* member "provider" */
  /* member "provider" is volatile, just presetting */
  p_struct->provider=NULL;

}

void AB_Account_WriteXml(const AB_ACCOUNT *p_struct, GWEN_XMLNODE *p_db) {
  assert(p_struct);
  /* member "accountType" */
  GWEN_XMLNode_SetIntValue(p_db, "accountType", p_struct->accountType);

  /* member "uniqueId" */
  GWEN_XMLNode_SetIntValue(p_db, "uniqueId", p_struct->uniqueId);

  /* member "backendName" */
  GWEN_XMLNode_SetCharValue(p_db, "backendName", p_struct->backendName);

  /* member "ownerName" */
  GWEN_XMLNode_SetCharValue(p_db, "ownerName", p_struct->ownerName);

  /* member "bankName" */
  GWEN_XMLNode_SetCharValue(p_db, "bankName", p_struct->bankName);

  /* member "accountName" */
  GWEN_XMLNode_SetCharValue(p_db, "accountName", p_struct->accountName);

  /* member "currency" */
  GWEN_XMLNode_SetCharValue(p_db, "currency", p_struct->currency);

  /* member "memo" */
  GWEN_XMLNode_SetCharValue(p_db, "memo", p_struct->memo);

  /* member "iban" */
  GWEN_XMLNode_SetCharValue(p_db, "iban", p_struct->iban);

  /* member "bic" */
  GWEN_XMLNode_SetCharValue(p_db, "bic", p_struct->bic);

  /* member "country" */
  GWEN_XMLNode_SetCharValue(p_db, "country", p_struct->country);

  /* member "bankCode" */
  GWEN_XMLNode_SetCharValue(p_db, "bankCode", p_struct->bankCode);

  /* member "branchId" */
  GWEN_XMLNode_SetCharValue(p_db, "branchId", p_struct->branchId);

  /* member "accountNumber" */
  GWEN_XMLNode_SetCharValue(p_db, "accountNumber", p_struct->accountNumber);

  /* member "subAccountId" */
  GWEN_XMLNode_SetCharValue(p_db, "subAccountId", p_struct->subAccountId);

  /* member "userId" */
  GWEN_XMLNode_SetIntValue(p_db, "userId", p_struct->userId);

  /* member "provider" is volatile, not writing to xml */

}

void AB_Account_toXml(const AB_ACCOUNT *p_struct, GWEN_XMLNODE *p_db) {
  AB_Account_WriteXml(p_struct, p_db);
}

AB_ACCOUNT *AB_Account_fromXml(GWEN_XMLNODE *p_db) {
  AB_ACCOUNT *p_struct;
  p_struct=AB_Account_new();
  AB_Account_ReadXml(p_struct, p_db);
  return p_struct;
}

AB_ACCOUNT *AB_Account_List_GetByUniqueId(const AB_ACCOUNT_LIST *p_list, uint32_t p_cmp) {
  AB_ACCOUNT *p_struct;

  assert(p_list);
  p_struct = AB_Account_List_First(p_list);
  while(p_struct) {
    int p_rv;

    if (p_struct->uniqueId==p_cmp) p_rv=0; else if (p_cmp<p_struct->uniqueId) p_rv=-1; else p_rv=1;
    if (p_rv == 0)
      return p_struct;
    p_struct = AB_Account_List_Next(p_struct);
  }
  return NULL;
}

int AB_Account_Matches(const AB_ACCOUNT *a, const char *backendName, const char *country, const char *bankId, const char *accountNumber, const char *subAccountId, const char *iban, const char *currency, int ty) { const char *lbackendName; const char *lcountry; const char *lbankId; const char *laccountNumber; const char *lsubAccountId; const char *liban; const char *lcurrency; int lty; if (!backendName) backendName="*"; if (!country) country="*"; if (!bankId) bankId="*"; if (!accountNumber) accountNumber="*"; if (!subAccountId) subAccountId="*"; if (!iban) iban="*"; if (!currency) currency="*"; if (ty>=AB_AccountType_Last) ty=AB_AccountType_Unknown; lbackendName=AB_Account_GetBackendName(a); lcountry=AB_Account_GetCountry(a); lbankId=AB_Account_GetBankCode(a); laccountNumber=AB_Account_GetAccountNumber(a); lsubAccountId=AB_Account_GetSubAccountId(a); liban=AB_Account_GetIban(a); lcurrency=AB_Account_GetCurrency(a); lty=AB_Account_GetAccountType(a); if (!lcountry) lcountry=""; if (!lbankId) lbankId=""; if (!laccountNumber) laccountNumber=""; if (!lsubAccountId) lsubAccountId=""; if (!liban) liban=""; if (!lcurrency) lcurrency=""; if (lty>=AB_AccountType_Last || lty <=AB_AccountType_Unknown) lty=AB_AccountType_Unknown; if ((-1!=GWEN_Text_ComparePattern(lbackendName, backendName, 0)) && (-1!=GWEN_Text_ComparePattern(lcountry, country, 0)) && (-1!=GWEN_Text_ComparePattern(lbankId, bankId, 0)) && (-1!=GWEN_Text_ComparePattern(laccountNumber, accountNumber, 0)) && (-1!=GWEN_Text_ComparePattern(lsubAccountId, subAccountId, 0)) && (-1!=GWEN_Text_ComparePattern(liban, iban, 0)) && (-1!=GWEN_Text_ComparePattern(lcurrency, currency, 0)) && ((ty==AB_AccountType_Unknown) || (ty==lty))) return 1; return 0; }
AB_ACCOUNT *AB_Account_List__FindInternal(AB_ACCOUNT *a, const char *backendName, const char *country, const char *bankId, const char *accountNumber, const char *subAccountId, const char *iban, const char *currency, int ty) { if (!backendName) backendName="*"; if (!country) country="*"; if (!bankId) bankId="*"; if (!accountNumber) accountNumber="*"; if (!subAccountId) subAccountId="*"; if (!iban) iban="*"; if (!currency) currency="*"; if (ty>=AB_AccountType_Last) ty=AB_AccountType_Unknown; while(a) { const char *lbackendName; lbackendName=AB_Account_GetBackendName(a); if (! (lbackendName && *lbackendName) ) { DBG_ERROR(AQBANKING_LOGDOMAIN, "Account: %s/%s/%s: No backend, ignoring", AB_Account_GetCountry(a), AB_Account_GetBankCode(a), AB_Account_GetAccountNumber(a)); } else { int rv; rv=AB_Account_Matches(a, backendName, country, bankId, accountNumber, subAccountId, iban, currency, ty); if (rv==1) break; } a=AB_Account_List_Next(a); } /* while */ return a; }
AB_ACCOUNT *AB_Account_List_FindFirst(AB_ACCOUNT_LIST *al, const char *backendName, const char *country, const char *bankId, const char *accountNumber, const char *subAccountId, const char *iban, const char *currency, int ty) { AB_ACCOUNT *a; if (AB_Account_List_GetCount(al)==0) { DBG_INFO(AQBANKING_LOGDOMAIN, "No accounts"); return NULL; } a=AB_Account_List_First(al); assert(a); return AB_Account_List__FindInternal(a, backendName, country, bankId, accountNumber, subAccountId, iban, currency, ty); }
AB_ACCOUNT *AB_Account_List_FindNext(AB_ACCOUNT *a, const char *backendName, const char *country, const char *bankId, const char *accountNumber, const char *subAccountId, const char *iban, const char *currency, int ty) { assert(a); a=AB_Account_List_Next(a); if (a==NULL) { DBG_INFO(AQBANKING_LOGDOMAIN, "No more account specs"); return NULL; } return AB_Account_List__FindInternal(a, backendName, country, bankId, accountNumber, subAccountId, iban, currency, ty); }
int AB_Account__ReadFromDb(AB_ACCOUNT *a, GWEN_DB_NODE *db) { assert(a); AB_Account_ReadDb(a, db); return 0; }
int AB_Account__WriteToDb(const AB_ACCOUNT *a, GWEN_DB_NODE *db) { assert(a); AB_Account_WriteDb(a, db); return 0; }

/* code headers */

