/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "element.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "./element_p.h"

#include <gwenhywfar/misc.h>
#include <gwenhywfar/debug.h>

/* code headers */
#include <string.h>

/* macro functions */
GWEN_TREE2_FUNCTIONS(AQFINTS_ELEMENT, AQFINTS_Element)


AQFINTS_ELEMENT_TYPE AQFINTS_ElementType_fromString(const char *p_s) {
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "root")==0)
      return AQFINTS_ElementType_Root;
    else if (strcasecmp(p_s, "group")==0)
      return AQFINTS_ElementType_Group;
    else if (strcasecmp(p_s, "de")==0)
      return AQFINTS_ElementType_De;
    else if (strcasecmp(p_s, "deg")==0)
      return AQFINTS_ElementType_Deg;
  }
  return AQFINTS_ElementType_Unknown;
}

AQFINTS_ELEMENT_DATATYPE AQFINTS_ElementDataType_fromString(const char *p_s) {
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "int")==0)
      return AQFINTS_ElementDataType_Int;
    else if (strcasecmp(p_s, "char")==0)
      return AQFINTS_ElementDataType_Char;
    else if (strcasecmp(p_s, "bin")==0)
      return AQFINTS_ElementDataType_Bin;
  }
  return AQFINTS_ElementDataType_Unknown;
}

const char *AQFINTS_ElementType_toString(AQFINTS_ELEMENT_TYPE p_i) {
  switch(p_i) {
    case AQFINTS_ElementType_Root: return "root";
    case AQFINTS_ElementType_Group: return "group";
    case AQFINTS_ElementType_De: return "de";
    case AQFINTS_ElementType_Deg: return "deg";
    case AQFINTS_ElementType_Unknown:
    default: return "unknown";
  }
}

const char *AQFINTS_ElementDataType_toString(AQFINTS_ELEMENT_DATATYPE p_i) {
  switch(p_i) {
    case AQFINTS_ElementDataType_Int: return "int";
    case AQFINTS_ElementDataType_Char: return "char";
    case AQFINTS_ElementDataType_Bin: return "bin";
    case AQFINTS_ElementDataType_Unknown:
    default: return "unknown";
  }
}

AQFINTS_ELEMENT *AQFINTS_Element_new(void) {
  AQFINTS_ELEMENT *p_struct;

  GWEN_NEW_OBJECT(AQFINTS_ELEMENT, p_struct)
  p_struct->_refCount=1;
  GWEN_TREE2_INIT(AQFINTS_ELEMENT, p_struct,AQFINTS_Element)
  /* members */
  p_struct->flags=0;
  p_struct->elementType=AQFINTS_ElementType_De;
  p_struct->id=NULL;
  p_struct->name=NULL;
  p_struct->version=0;
  p_struct->type=NULL;
  p_struct->minNum=1;
  p_struct->maxNum=1;
  p_struct->minSize=0;
  p_struct->maxSize=-1;
  p_struct->trustLevel=0;
  p_struct->data.pointer=NULL; p_struct->data.length=0;
  p_struct->runtimeFlags=0;
  /* virtual functions */

  return p_struct;
}

void AQFINTS_Element_free(AQFINTS_ELEMENT *p_struct) {
  if (p_struct) {
  assert(p_struct->_refCount);
  if (p_struct->_refCount==1) {
    GWEN_TREE2_FINI(AQFINTS_ELEMENT, p_struct, AQFINTS_Element)
  /* members */
    free(p_struct->id); p_struct->id=NULL;
    free(p_struct->name); p_struct->name=NULL;
    free(p_struct->type); p_struct->type=NULL;
    if (p_struct->data.length && p_struct->data.pointer) { free(p_struct->data.pointer); } p_struct->data.pointer=NULL; p_struct->data.length=0;
    p_struct->_refCount=0;
    GWEN_FREE_OBJECT(p_struct);
  }
  else
    p_struct->_refCount--;
  }
}

void AQFINTS_Element_Attach(AQFINTS_ELEMENT *p_struct) {
  assert(p_struct);
  assert(p_struct->_refCount);
  p_struct->_refCount++;
}

AQFINTS_ELEMENT *AQFINTS_Element_dup(const AQFINTS_ELEMENT *p_src) {
  AQFINTS_ELEMENT *p_struct;

  assert(p_src);
  p_struct=AQFINTS_Element_new();
  /* member "flags" */
  p_struct->flags=p_src->flags;

  /* member "elementType" */
  p_struct->elementType=p_src->elementType;

  /* member "id" */
  if (p_struct->id) {
    free(p_struct->id); p_struct->id=NULL;
    p_struct->id=NULL;
  }
  if (p_src->id) {
    p_struct->id=strdup(p_src->id);
  }

  /* member "name" */
  if (p_struct->name) {
    free(p_struct->name); p_struct->name=NULL;
    p_struct->name=NULL;
  }
  if (p_src->name) {
    p_struct->name=strdup(p_src->name);
  }

  /* member "version" */
  p_struct->version=p_src->version;

  /* member "type" */
  if (p_struct->type) {
    free(p_struct->type); p_struct->type=NULL;
    p_struct->type=NULL;
  }
  if (p_src->type) {
    p_struct->type=strdup(p_src->type);
  }

  /* member "minNum" */
  p_struct->minNum=p_src->minNum;

  /* member "maxNum" */
  p_struct->maxNum=p_src->maxNum;

  /* member "minSize" */
  p_struct->minSize=p_src->minSize;

  /* member "maxSize" */
  p_struct->maxSize=p_src->maxSize;

  /* member "trustLevel" */
  p_struct->trustLevel=p_src->trustLevel;

  /* member "data" */
  if (p_src->data.length && p_src->data.pointer) { p_struct->data.pointer=(uint8_t*) malloc(p_src->data.length); if (p_struct->data.pointer) { p_struct->data.length=p_src->data.length; memmove(p_struct->data.pointer, p_src->data.pointer, p_src->data.length); } else { p_struct->data.pointer=NULL; p_struct->data.length=0; } } else { p_struct->data.pointer=NULL; p_struct->data.length=0; }

  /* member "runtimeFlags" */
  p_struct->runtimeFlags=p_src->runtimeFlags;

  return p_struct;
}

AQFINTS_ELEMENT *AQFINTS_Element_copy(AQFINTS_ELEMENT *p_struct, const AQFINTS_ELEMENT *p_src) {
    assert(p_struct);
  assert(p_src);
  /* member "flags" */
  p_struct->flags=p_src->flags;

  /* member "elementType" */
  p_struct->elementType=p_src->elementType;

  /* member "id" */
  if (p_struct->id) {
    free(p_struct->id); p_struct->id=NULL;
    p_struct->id=NULL;
  }
  if (p_src->id) {
    p_struct->id=strdup(p_src->id);
  }

  /* member "name" */
  if (p_struct->name) {
    free(p_struct->name); p_struct->name=NULL;
    p_struct->name=NULL;
  }
  if (p_src->name) {
    p_struct->name=strdup(p_src->name);
  }

  /* member "version" */
  p_struct->version=p_src->version;

  /* member "type" */
  if (p_struct->type) {
    free(p_struct->type); p_struct->type=NULL;
    p_struct->type=NULL;
  }
  if (p_src->type) {
    p_struct->type=strdup(p_src->type);
  }

  /* member "minNum" */
  p_struct->minNum=p_src->minNum;

  /* member "maxNum" */
  p_struct->maxNum=p_src->maxNum;

  /* member "minSize" */
  p_struct->minSize=p_src->minSize;

  /* member "maxSize" */
  p_struct->maxSize=p_src->maxSize;

  /* member "trustLevel" */
  p_struct->trustLevel=p_src->trustLevel;

  /* member "data" */
  if (p_src->data.length && p_src->data.pointer) { p_struct->data.pointer=(uint8_t*) malloc(p_src->data.length); if (p_struct->data.pointer) { p_struct->data.length=p_src->data.length; memmove(p_struct->data.pointer, p_src->data.pointer, p_src->data.length); } else { p_struct->data.pointer=NULL; p_struct->data.length=0; } } else { p_struct->data.pointer=NULL; p_struct->data.length=0; }

  /* member "runtimeFlags" */
  p_struct->runtimeFlags=p_src->runtimeFlags;

  return p_struct;
}

uint32_t AQFINTS_Element_GetFlags(const AQFINTS_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->flags;
}

AQFINTS_ELEMENT_TYPE AQFINTS_Element_GetElementType(const AQFINTS_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->elementType;
}

const char *AQFINTS_Element_GetId(const AQFINTS_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->id;
}

const char *AQFINTS_Element_GetName(const AQFINTS_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->name;
}

int AQFINTS_Element_GetVersion(const AQFINTS_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->version;
}

const char *AQFINTS_Element_GetType(const AQFINTS_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->type;
}

int AQFINTS_Element_GetMinNum(const AQFINTS_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->minNum;
}

int AQFINTS_Element_GetMaxNum(const AQFINTS_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->maxNum;
}

int AQFINTS_Element_GetMinSize(const AQFINTS_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->minSize;
}

int AQFINTS_Element_GetMaxSize(const AQFINTS_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->maxSize;
}

int AQFINTS_Element_GetTrustLevel(const AQFINTS_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->trustLevel;
}

uint32_t AQFINTS_Element_GetRuntimeFlags(const AQFINTS_ELEMENT *p_struct) {
  assert(p_struct);
  return p_struct->runtimeFlags;
}

void AQFINTS_Element_SetFlags(AQFINTS_ELEMENT *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->flags=p_src;
}

void AQFINTS_Element_AddFlags(AQFINTS_ELEMENT *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->flags|=p_src;
}

void AQFINTS_Element_SubFlags(AQFINTS_ELEMENT *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->flags&=~p_src;
}

void AQFINTS_Element_SetElementType(AQFINTS_ELEMENT *p_struct, AQFINTS_ELEMENT_TYPE  p_src) {
  assert(p_struct);
  p_struct->elementType=p_src;
}

void AQFINTS_Element_SetId(AQFINTS_ELEMENT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->id) {
    free(p_struct->id); p_struct->id=NULL;
  }
  if (p_src) {
    p_struct->id=strdup(p_src);
  }
  else {
    p_struct->id=NULL;
  }
}

void AQFINTS_Element_SetName(AQFINTS_ELEMENT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->name) {
    free(p_struct->name); p_struct->name=NULL;
  }
  if (p_src) {
    p_struct->name=strdup(p_src);
  }
  else {
    p_struct->name=NULL;
  }
}

void AQFINTS_Element_SetVersion(AQFINTS_ELEMENT *p_struct, int p_src) {
  assert(p_struct);
  p_struct->version=p_src;
}

void AQFINTS_Element_SetType(AQFINTS_ELEMENT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->type) {
    free(p_struct->type); p_struct->type=NULL;
  }
  if (p_src) {
    p_struct->type=strdup(p_src);
  }
  else {
    p_struct->type=NULL;
  }
}

void AQFINTS_Element_SetMinNum(AQFINTS_ELEMENT *p_struct, int p_src) {
  assert(p_struct);
  p_struct->minNum=p_src;
}

void AQFINTS_Element_SetMaxNum(AQFINTS_ELEMENT *p_struct, int p_src) {
  assert(p_struct);
  p_struct->maxNum=p_src;
}

void AQFINTS_Element_SetMinSize(AQFINTS_ELEMENT *p_struct, int p_src) {
  assert(p_struct);
  p_struct->minSize=p_src;
}

void AQFINTS_Element_SetMaxSize(AQFINTS_ELEMENT *p_struct, int p_src) {
  assert(p_struct);
  p_struct->maxSize=p_src;
}

void AQFINTS_Element_SetTrustLevel(AQFINTS_ELEMENT *p_struct, int p_src) {
  assert(p_struct);
  p_struct->trustLevel=p_src;
}

void AQFINTS_Element_SetRuntimeFlags(AQFINTS_ELEMENT *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->runtimeFlags=p_src;
}

void AQFINTS_Element_AddRuntimeFlags(AQFINTS_ELEMENT *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->runtimeFlags|=p_src;
}

void AQFINTS_Element_SubRuntimeFlags(AQFINTS_ELEMENT *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->runtimeFlags&=~p_src;
}

void AQFINTS_Element_ReadDb(AQFINTS_ELEMENT *p_struct, GWEN_DB_NODE *p_db) {
  assert(p_struct);
  /* member "flags" */
  p_struct->flags=GWEN_DB_GetIntValue(p_db, "flags", 0, 0);

  /* member "elementType" */
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "elementType", 0, NULL); if (s) p_struct->elementType=AQFINTS_ElementType_fromString(s); else p_struct->elementType=AQFINTS_ElementType_De; }

  /* member "id" */
  if (p_struct->id) {
    free(p_struct->id); p_struct->id=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "id", 0, NULL); if (s) p_struct->id=strdup(s); }
  if (p_struct->id==NULL) {  p_struct->id=NULL;
  }

  /* member "name" */
  if (p_struct->name) {
    free(p_struct->name); p_struct->name=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "name", 0, NULL); if (s) p_struct->name=strdup(s); }
  if (p_struct->name==NULL) {  p_struct->name=NULL;
  }

  /* member "version" */
  p_struct->version=GWEN_DB_GetIntValue(p_db, "version", 0, 0);

  /* member "type" */
  if (p_struct->type) {
    free(p_struct->type); p_struct->type=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "type", 0, NULL); if (s) p_struct->type=strdup(s); }
  if (p_struct->type==NULL) {  p_struct->type=NULL;
  }

  /* member "minNum" */
  p_struct->minNum=GWEN_DB_GetIntValue(p_db, "minNum", 0, 1);

  /* member "maxNum" */
  p_struct->maxNum=GWEN_DB_GetIntValue(p_db, "maxNum", 0, 1);

  /* member "minSize" */
  p_struct->minSize=GWEN_DB_GetIntValue(p_db, "minSize", 0, 0);

  /* member "maxSize" */
  p_struct->maxSize=GWEN_DB_GetIntValue(p_db, "maxSize", 0, -1);

  /* member "trustLevel" */
  p_struct->trustLevel=GWEN_DB_GetIntValue(p_db, "trustLevel", 0, 0);

  /* member "data" */
  { const void *v; unsigned int vlen; v=GWEN_DB_GetBinValue(p_db, "data", 0, NULL, 0, &vlen); if (v && vlen) { uint8_t *dest; dest=(uint8_t*) malloc(vlen); memmove(dest, v, vlen); p_struct->data.pointer=dest; p_struct->data.length=vlen; } }

  /* member "runtimeFlags" */
  /* member "runtimeFlags" is volatile, just presetting */
  p_struct->runtimeFlags=0;

}

int AQFINTS_Element_WriteDb(const AQFINTS_ELEMENT *p_struct, GWEN_DB_NODE *p_db) {
  int p_rv;

  assert(p_struct);
  /* member "flags" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "flags", p_struct->flags);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "elementType" */
  p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "elementType", AQFINTS_ElementType_toString(p_struct->elementType));
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "id" */
  if (p_struct->id) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "id", p_struct->id); else { GWEN_DB_DeleteVar(p_db, "id"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "name" */
  if (p_struct->name) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "name", p_struct->name); else { GWEN_DB_DeleteVar(p_db, "name"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "version" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "version", p_struct->version);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "type" */
  if (p_struct->type) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "type", p_struct->type); else { GWEN_DB_DeleteVar(p_db, "type"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "minNum" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "minNum", p_struct->minNum);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "maxNum" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "maxNum", p_struct->maxNum);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "minSize" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "minSize", p_struct->minSize);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "maxSize" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "maxSize", p_struct->maxSize);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "trustLevel" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "trustLevel", p_struct->trustLevel);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "data" */
  { if (p_struct->data.length && p_struct->data.pointer) { GWEN_DB_SetBinValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "data", p_struct->data.pointer, p_struct->data.length); } else { GWEN_DB_DeleteVar(p_db, "data"); p_rv=0; } }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "runtimeFlags" is volatile, not writing to db */

  return 0;
}

AQFINTS_ELEMENT *AQFINTS_Element_fromDb(GWEN_DB_NODE *p_db) {
  AQFINTS_ELEMENT *p_struct;
  p_struct=AQFINTS_Element_new();
  AQFINTS_Element_ReadDb(p_struct, p_db);
  return p_struct;
}

int AQFINTS_Element_toDb(const AQFINTS_ELEMENT *p_struct, GWEN_DB_NODE *p_db) {
  return AQFINTS_Element_WriteDb(p_struct, p_db);
}

void AQFINTS_Element_SetData(AQFINTS_ELEMENT *st, uint8_t *ptr, uint32_t len) { if (st->data.pointer && st->data.length) { free(st->data.pointer); } st->data.pointer=ptr; st->data.length=len; }
void AQFINTS_Element_SetDataCopy(AQFINTS_ELEMENT *st, const uint8_t *ptr, uint32_t len) { 
 /* free previous data */ 
 if (st->data.pointer && st->data.length) { free(st->data.pointer); } 
 /* create copy if there is data to copy */ 
 if (ptr && len) { uint8_t *ptrCopy; ptrCopy=(uint8_t*) malloc(len); assert(ptrCopy); memmove(ptrCopy, ptr, len); st->data.pointer=ptrCopy; st->data.length=len; } else { st->data.pointer=NULL; st->data.length=0; } }
void AQFINTS_Element_SetTextDataCopy(AQFINTS_ELEMENT *st, const char *ptr) { 
 /* free previous data */ 
 if (st->data.pointer && st->data.length) { free(st->data.pointer); } 
 /* create copy if there is data to copy */ 
 if (ptr) { char *ptrCopy; ptrCopy=strdup(ptr); assert(ptrCopy); st->data.pointer=(uint8_t*) ptrCopy; st->data.length=strlen(ptrCopy)+1; /* count trailing zero */ 
 } else { st->data.pointer=NULL; st->data.length=0; } }
const uint8_t* AQFINTS_Element_GetDataPointer(const AQFINTS_ELEMENT *st) { return st->data.pointer; }
uint32_t AQFINTS_Element_GetDataLength(const AQFINTS_ELEMENT *st) { return st->data.length; }
const char* AQFINTS_Element_GetDataAsChar(const AQFINTS_ELEMENT *st, const char *defaultValue) { if (st->data.length && st->data.pointer && !(st->flags & AQFINTS_ELEMENT_FLAGS_ISBIN)) return (const char*) (st->data.pointer); return defaultValue; }
int AQFINTS_Element_GetDataAsInt(const AQFINTS_ELEMENT *st, int defaultValue) { const char *s; s=AQFINTS_Element_GetDataAsChar(st, NULL); if (s && *s) { long int retVal=0; if (1==sscanf(s, "%li", &retVal)) return retVal; } return defaultValue; }
void AQFINTS_Element_SetDataAsInt(AQFINTS_ELEMENT *st, int value) { 
 char numbuf[32]; int i; i=snprintf(numbuf, sizeof(numbuf)-1, "%i", value); assert(i<=(sizeof(numbuf)-1)); numbuf[sizeof(numbuf)-1]=0; AQFINTS_Element_SetTextDataCopy(st, numbuf); }

/* code headers */

