# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['arch_release_promotion']

package_data = \
{'': ['*']}

install_requires = \
['email-validator>=1.1.3,<2.0.0',
 'orjson>=3.6.1,<4.0.0',
 'prometheus-client>=0.11.0,<0.12.0',
 'pydantic>=1.8.2,<2.0.0',
 'python-dotenv>=0.19.0,<0.20.0',
 'python-gitlab>=2.10.0,<3.0.0',
 'pyxdg>=0.27,<0.28',
 'toml>=0.10.2,<0.11.0',
 'torrentool>=1.1.1,<2.0.0']

entry_points = \
{'console_scripts': ['arch-release-promotion = arch_release_promotion.cli:main',
                     'arch-release-sync = '
                     'arch_release_promotion.cli:arch_release_sync']}

setup_kwargs = {
    'name': 'arch-release-promotion',
    'version': '0.2.1',
    'description': 'Promote official Arch Linux releases and synchronize them',
    'long_description': '======================\narch-release-promotion\n======================\n\nThis project allows for promotion and synchronization of existing releases of a\nproject in Arch Linux\'s Gitlab instance.\n\nReleases of a project (e.g. ``project``) may consist of several release types\n(e.g. ``image_a`` and ``image_b``), which are addressed separately.\n\nA promotion encompasses - per release type - PGP signatures for relevant\nartifacts (optional), a torrent file (optional) and a JSON payload which can be\nused by `archweb <https://github.com/archlinux/archweb>`_ to display\ninformation about each release type.\n\nSynchronization with a local directory can be achieved for a configurable\nmaximum amount of release versions (each consisting of their respective\nconfigured release types) of a project.\n\nRequirements\n============\n\nArch-release-promotion is Python based. All language specific requirements are\nspecified in its `pyproject.toml <pyproject.toml>`_.\n\nAdditionally, ``arch-release-promotion`` requires `gnupg <https://gnupg.org/>`_\nto handle detached PGP signatures.\n\nUse\n===\n\nAfter installation, refer to the output of ``arch-release-promotion -h`` and\n``arch-release-sync -h``.\n\nConfiguration\n=============\n\nThe command-line tools ``arch-release-promotion`` and ``arch-release-sync``\nmake use of two sources of configuration:\n\n* `makepkg.conf <https://man.archlinux.org/man/makepkg.conf.5>`_ is read from\n  any of its locations in the same priority as `makepkg\n  <https://man.archlinux.org/man/makepkg.8>`_ does.\n  All of the below can also be passed to the tool via environment variables:\n\n  * ``GPGKEY`` is recognized for establishing which PGP key to use for signing\n  * ``PACKAGER`` is recognized for establishing who is doing the signature and\n    is important for `WKD\n    <https://wiki.archlinux.org/title/GnuPG#Web_Key_Directory>`_ lookup\n  * ``MIRRORLIST_URL`` (not used by makepkg) is used during the generation of\n    torrent files to add webseeds (defaults to\n    ``"https://archlinux.org/mirrorlist/?country=all&protocol=http&protocol=https"``)\n  * ``GITLAB_URL`` (not used by makepkg) is used to connect to a GitLab\n    instance to select, download and promote releases of a project (defaults to\n    ``"https://gitlab.archlinux.org"``)\n  * ``PRIVATE_TOKEN`` (not used by makepkg) is used to authenticate against the\n    GitLab instance. The `personal access token\n    <https://docs.gitlab.com/ee/user/profile/personal_access_tokens.html>`_\n    needs to provide write access for the target project.\n\n* ``projects.toml`` is a configuration file that provides the configuration for a\n  project and its releases. Configuration files are read and merged with\n  descending priority from ``/etc/arch-release-promotion/projects.toml`` and\n  ``$XDG_CONFIG_HOME/arch-release-promotion/projects.toml`` (which defaults to\n  ``$HOME/.config/arch-release-promotion/projects.toml`` if\n  ``$XDG_CONFIG_HOME`` is unset).\n  Please refer to `examples/example.toml <examples/example.toml>`_ for further\n  reference in regards to the available options\n\nOpenmetrics\n-----------\n\nIf the upstream project offers an `openmetrics <https://openmetrics.io/>`_\nbased metrics file, the data from it can be used as additional information in\nthe JSON payload.\n\nThe following metrics are considered.\n\nVersion metrics\n^^^^^^^^^^^^^^^\n\nDescription and version information about e.g. packages can be derived from\n``version_info`` metrics of type ``info``, that define a ``name``,\n``description`` and ``version`` label.\n\nFor the metrics to be considered, they have to be configured by adding a\n``version_metrics`` list (a list of names to look for) to a release of a\nproject.\n\n.. code::\n\n   # TYPE version_info info\n   # HELP version_info Package description and version information\n   version_info{name="my-package",description="Version of my-package used for build",version="1.0.0-1"} 1\n\nThe above metrics entry would result in the following JSON representation:\n\n.. code:: json\n\n   "version_metrics": [\n     {\n       "name": "my-package",\n       "description": "Version of my-package used for build",\n       "version": "1.0.0-1"\n     }\n   ]\n\nSize metrics\n^^^^^^^^^^^^\n\nArtifact size information in MebiBytes (MiB) and description can be derived\nfrom ``artifact_bytes`` metrics of type ``gauge``, that define a ``name`` and a\n``description`` label.\n\nFor the metrics to be considered, they have to be configured by adding a\n``size_metrics`` list (a list of names to look for) to a release of a\nproject.\n\n.. code::\n\n   # TYPE artifact_bytes gauge\n   # HELP artifact_bytes Artifact sizes in Bytes\n   artifact_bytes{name="foo",description="Size of foo in MiB"} 832\n\nThe above metrics entry would result in the following JSON representation:\n\n.. code:: json\n\n   "size_metrics": [\n     {\n       "name": "foo",\n       "description": "Size of foo in MiB",\n       "size": 832\n     }\n   ]\n\nAmount metrics\n^^^^^^^^^^^^^^\n\nInformation on the amount of something (e.g. packages) and description can be\nderived from ``data_count`` metrics of type ``summary``, that define a ``name``\nand a ``description`` label.\n\nFor the metrics to be considered, they have to be configured by adding a\n``amount_metrics`` list (a list of names to look for) to a release of a\nproject.\n\n.. code::\n\n   # TYPE data_count summary\n   # HELP data_count The amount of something used in some context\n   data_count{name="foo",description="The amount of packages in foo"} 369\n\nThe above metrics entry would result in the following JSON representation:\n\n.. code:: json\n\n   "amount_metrics": [\n     {\n       "name": "foo",\n       "description": "The amount of packages in foo",\n       "amount": 369\n     }\n   ]\n\nPromotion artifact\n==================\n\nThe promotion artifact is a ZIP compressed file (``promotion.zip``), that is\nuploaded to the project before its link is added to the release that it is\npromoting.\n\nThe file contains one directory for each release type that the project offers.\nIn each release type directory there are is a **JSON payload**\n(``<release_type>-<version>.json``), a directory\n(``<release_type>-<version>/``) containing signatures for any files that have\nbeen setup for detached signatures and optionally a torrent file\n(``<release_type>-<version>.json``) that is created for the release type\'s\nbuild artifacts *and* the detached signatures contained in the promotion\nartifact.\n\n.. code::\n\n   example\n   ├── example-0.1.0\n   │\xa0\xa0 └── artifact.tar.gz.sig\n   ├── example-0.1.0.json\n   └── example-0.1.0.torrent\n\nJSON payload\n------------\n\nThe promotion of a release encompasses one or more JSON payloads, that describe\neach release type in the release.\n\n.. code:: json\n\n   {\n     "amount_metrics": [\n       {\n         "name": "foo",\n         "description": "The amount of packages in foo",\n         "size": 369\n       }\n     ],\n     "developer": "Foobar McFooface <foobar@mcfooface.com>",\n     "files": ["something.txt", "something.txt.sig"],\n     "name": "foo",\n     "pgp_public_key": "SOMEONESPGPKEYID",\n     "size_metrics": [\n       {\n         "name": "foo",\n         "description": "Size of foo in MiB",\n         "size": 832\n       }\n     ],\n     "torrent_file": "foo-0.1.0.torrent",\n     "version_metrics": [\n       {\n         "name": "my-package",\n         "description": "Version of my-package used for build",\n         "version": "1.0.0-1"\n       }\n     ],\n     "version": "0.1.0"\n   }\n\n* ``amount_metrics``: A list of objects that describe the amount of something\n  (optional). The list depends on whether the project\'s configuration defines\n  ``amount_metrics`` and whether those metrics are available in the specific\n  release.\n* ``developer``: The full uid of the person promoting (and optionally signing\n  artifacts in) the release type.\n* ``files``: A list of files in the release type.\n* ``name``: The name of the release type.\n* ``pgp_public_key``: The PGP key ID of the key signing files in the release\n  type.\n* ``size_metrics``: A list of objects that describe the size of something\n  (optional). The list depends on whether the project\'s configuration defines\n  ``size_metrics`` and whether those metrics are available in the specific\n  release.\n* ``torrent_file`` (optional): The name of a torrent file created for the\n  release type. The value depends on whether the configuration for the release\n  type sets ``create_torrent`` to ``True``.\n* ``version_metrics``: A list of objects that describe the version of something\n  (optional). The list depends on whether the project\'s configuration defines\n  ``version_metrics`` and whether those metrics are available in the specific\n  release.\n* ``version``: The version of the release type.\n\nSynchronization\n===============\n\nThe synchronization of releases works by retrieving the list of promoted\nreleases of the project from the remote. For each promoted release version, the\npromotion artifact is downloaded and used to establish whether all of the\nconfigured release types are fully synchronized.\n\nLocation and cleanup\n--------------------\n\nAll release types for each release version are synchronized to a local\ndirectory. The directory and and the maximum amount of synchronized release\nversions are configurable globally or per project.\n\n.. code::\n\n   sync_dir\n   ├── example_a\n   │\xa0\xa0 ├── example_a-0.1.0\n   │\xa0\xa0 │\xa0\xa0 ├── foo.txt\n   │\xa0\xa0 │\xa0\xa0 └── foo.txt.sig\n   │\xa0\xa0 ├── example_a-0.1.0.json\n   │\xa0\xa0 ├── example_a-0.1.0.torrent\n   │\xa0\xa0 └── latest -> example_a-0.1.0\n   └── example_b\n       ├── example_b-0.1.0\n       │\xa0\xa0 ├── bar.txt\n       │\xa0\xa0 └── bar.txt.sig\n       ├── example_b-0.1.0.json\n       ├── example_b-0.1.0.torrent\n       └── latest -> example_b-0.1.0\n\nA ``latest`` symlink is created to point at the currently latest version of\neach release type.\n\nAny files and directories that are not owned by versions of release types of\nthe currently synchronized release versions are removed from the\nsynchronization directory.\n\nIf changes are introduced to files in the target directory (due to a\nsynchronization action), it is possible to write a Unix timestamp to a file\nthat is configurable globally or per project (the directory in which the file\nresides in has to exist).\n\nSystem integration\n------------------\n\nFor systemd based systems there are example systemd system service and timer\nfiles that are provided in `examples/systemd/ <examples/systemd/>`_.\nThe provided service file relies on the user ``arch-release-sync`` which may be\ncreated using the `sysusers.d\n<https://man.archlinux.org/man/core/systemd/sysusers.d.5.en>`_ integration\nprovided in `examples/sysusers.d/ <examples/sysusers.d/>`_.\n\nLicense\n=======\n\nArch-release-promotion is licensed under the terms of the **GPL-3.0-or-later**\n(see `LICENSE <LICENSE>`_).\n\n',
    'author': 'David Runge',
    'author_email': 'dvzrv@archlinux.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.archlinux.org/archlinux/arch-release-promotion',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
