Bitwarden believes that working with security researchers across the globe is crucial to keeping our
users safe. If you believe you've found a security issue in our product or service, we encourage you to
notify us. We welcome working with you to resolve the issue promptly. Thanks in advance!

# Disclosure Policy

- Let us know as soon as possible upon discovery of a potential security issue, and we'll make every
  effort to quickly resolve the issue.
- Provide us a reasonable amount of time to resolve the issue before any disclosure to the public or a
  third-party. We may publicly disclose the issue before resolving it, if appropriate. 
- Make a good faith effort to avoid privacy violations, destruction of data, and interruption or
  degradation of our service. Only interact with accounts you own or with explicit permission of the
  account holder.
- If you would like to encrypt your report, please use the PGP key with long ID
  `0xDE6887086F892325FEC04CC0D847525B6931381F` (available in the public keyserver pool).

# In-scope

- Security issues in any current release of Bitwarden. This includes the web vault, browser extension,
  and mobile apps (iOS and Android). Product downloads are available at https://bitwarden.com. Source
  code is available at https://github.com/bitwarden.

# Exclusions

The following bug classes are out-of scope:

- Bugs that are already reported on any of Bitwarden's issue trackers (https://github.com/bitwarden),
  or that we already know of. Note that some of our issue tracking is private.
- Issues in an upstream software dependency (ex: Xamarin, ASP.NET) which are already reported to the
  upstream maintainer.
- Attacks requiring physical access to a user's device.
- Self-XSS
- Issues related to software or protocols not under Bitwarden's control
- Vulnerabilities in outdated versions of Bitwarden
- Missing security best practices that do not directly lead to a vulnerability
- Issues that do not have any impact on the general public

While researching, we'd like to ask you to refrain from:

- Denial of service
- Spamming
- Social engineering (including phishing) of Bitwarden staff or contractors
- Any physical attempts against Bitwarden property or data centers

Thank you for helping keep Bitwarden and our users safe!
