import { KeePass2XmlImporter as Importer } from 'jslib-common/importers/keepass2XmlImporter';

const TestData: string = `<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<KeePassFile>
	<Meta>
		<Generator>KeePass</Generator>
		<DatabaseName />
		<DatabaseNameChanged>2016-12-31T21:33:52Z</DatabaseNameChanged>
		<DatabaseDescription />
		<DatabaseDescriptionChanged>2016-12-31T21:33:52Z</DatabaseDescriptionChanged>
		<DefaultUserName />
		<DefaultUserNameChanged>2016-12-31T21:33:52Z</DefaultUserNameChanged>
		<MaintenanceHistoryDays>365</MaintenanceHistoryDays>
		<Color />
		<MasterKeyChanged>2016-12-31T21:33:59Z</MasterKeyChanged>
		<MasterKeyChangeRec>-1</MasterKeyChangeRec>
		<MasterKeyChangeForce>-1</MasterKeyChangeForce>
		<MemoryProtection>
			<ProtectTitle>False</ProtectTitle>
			<ProtectUserName>False</ProtectUserName>
			<ProtectPassword>True</ProtectPassword>
			<ProtectURL>False</ProtectURL>
			<ProtectNotes>False</ProtectNotes>
		</MemoryProtection>
		<RecycleBinEnabled>True</RecycleBinEnabled>
		<RecycleBinUUID>AAAAAAAAAAAAAAAAAAAAAA==</RecycleBinUUID>
		<RecycleBinChanged>2016-12-31T21:33:52Z</RecycleBinChanged>
		<EntryTemplatesGroup>AAAAAAAAAAAAAAAAAAAAAA==</EntryTemplatesGroup>
		<EntryTemplatesGroupChanged>2016-12-31T21:33:52Z</EntryTemplatesGroupChanged>
		<HistoryMaxItems>10</HistoryMaxItems>
		<HistoryMaxSize>6291456</HistoryMaxSize>
		<LastSelectedGroup>AAAAAAAAAAAAAAAAAAAAAA==</LastSelectedGroup>
		<LastTopVisibleGroup>AAAAAAAAAAAAAAAAAAAAAA==</LastTopVisibleGroup>
		<Binaries />
		<CustomData />
	</Meta>
	<Root>
		<Group>
			<UUID>KvS57lVwl13AfGFLwkvq4Q==</UUID>
			<Name>Root</Name>
			<Notes />
			<IconID>48</IconID>
			<Times>
				<CreationTime>2016-12-31T21:33:52Z</CreationTime>
				<LastModificationTime>2016-12-31T21:33:52Z</LastModificationTime>
				<LastAccessTime>2017-01-01T22:58:00Z</LastAccessTime>
				<ExpiryTime>2016-12-31T21:33:52Z</ExpiryTime>
				<Expires>False</Expires>
				<UsageCount>1</UsageCount>
				<LocationChanged>2016-12-31T21:33:52Z</LocationChanged>
			</Times>
			<IsExpanded>True</IsExpanded>
			<DefaultAutoTypeSequence />
			<EnableAutoType>null</EnableAutoType>
			<EnableSearching>null</EnableSearching>
			<LastTopVisibleEntry>AAAAAAAAAAAAAAAAAAAAAA==</LastTopVisibleEntry>
			<Group>
				<UUID>P0ParXgGMBW6caOL2YrhqQ==</UUID>
				<Name>Folder2</Name>
				<Notes>a note about the folder</Notes>
				<IconID>48</IconID>
				<Times>
					<CreationTime>2016-12-31T21:43:30Z</CreationTime>
					<LastModificationTime>2016-12-31T21:43:43Z</LastModificationTime>
					<LastAccessTime>2017-01-01T22:58:00Z</LastAccessTime>
					<ExpiryTime>2016-12-31T21:43:30Z</ExpiryTime>
					<Expires>False</Expires>
					<UsageCount>1</UsageCount>
					<LocationChanged>2016-12-31T21:43:43Z</LocationChanged>
				</Times>
				<IsExpanded>True</IsExpanded>
				<DefaultAutoTypeSequence />
				<EnableAutoType>null</EnableAutoType>
				<EnableSearching>null</EnableSearching>
				<LastTopVisibleEntry>AAAAAAAAAAAAAAAAAAAAAA==</LastTopVisibleEntry>
				<Entry>
					<UUID>fAa543oYlgnJKkhKag5HLw==</UUID>
					<IconID>1</IconID>
					<ForegroundColor />
					<BackgroundColor />
					<OverrideURL />
					<Tags />
					<Times>
						<CreationTime>2016-12-31T21:34:13Z</CreationTime>
						<LastModificationTime>2016-12-31T21:40:23Z</LastModificationTime>
						<LastAccessTime>2016-12-31T21:40:23Z</LastAccessTime>
						<ExpiryTime>2016-12-31T21:34:13Z</ExpiryTime>
						<Expires>False</Expires>
						<UsageCount>0</UsageCount>
						<LocationChanged>2016-12-31T21:43:48Z</LocationChanged>
					</Times>
					<String>
						<Key>att2</Key>
						<Value>att2value</Value>
					</String>
					<String>
						<Key>attr1</Key>
						<Value>att1value

line1
line2</Value>
					</String>
					<String>
						<Key>Notes</Key>
						<Value>This is a note!!!

line1
line2</Value>
					</String>
					<String>
						<Key>Password</Key>
						<Value ProtectInMemory="True">googpass</Value>
					</String>
					<String>
						<Key>Title</Key>
						<Value>Google</Value>
					</String>
					<String>
						<Key>URL</Key>
						<Value>google.com</Value>
					</String>
					<String>
						<Key>UserName</Key>
						<Value>googleuser</Value>
					</String>
					<AutoType>
						<Enabled>True</Enabled>
						<DataTransferObfuscation>0</DataTransferObfuscation>
					</AutoType>
					<History>
						<Entry>
							<UUID>fAa543oYlgnJKkhKag5HLw==</UUID>
							<IconID>0</IconID>
							<ForegroundColor />
							<BackgroundColor />
							<OverrideURL />
							<Tags />
							<Times>
								<CreationTime>2016-12-31T21:34:13Z</CreationTime>
								<LastModificationTime>2016-12-31T21:34:40Z</LastModificationTime>
								<LastAccessTime>2016-12-31T21:34:40Z</LastAccessTime>
								<ExpiryTime>2016-12-31T21:34:13Z</ExpiryTime>
								<Expires>False</Expires>
								<UsageCount>0</UsageCount>
								<LocationChanged>2016-12-31T21:34:40Z</LocationChanged>
							</Times>
							<String>
								<Key>Notes</Key>
								<Value>This is a note!!!

line1
line2</Value>
							</String>
							<String>
								<Key>Password</Key>
								<Value ProtectInMemory="True">googpass</Value>
							</String>
							<String>
								<Key>Title</Key>
								<Value>Google</Value>
							</String>
							<String>
								<Key>URL</Key>
								<Value>google.com</Value>
							</String>
							<String>
								<Key>UserName</Key>
								<Value>googleuser</Value>
							</String>
							<AutoType>
								<Enabled>True</Enabled>
								<DataTransferObfuscation>0</DataTransferObfuscation>
							</AutoType>
						</Entry>
					</History>
				</Entry>
			</Group>
		</Group>
		<DeletedObjects />
	</Root>
</KeePassFile>`;

describe('KeePass2 Xml Importer', () => {
    it('should parse XML data', async () => {
        const importer = new Importer();
        const result = await importer.parse(TestData);
        expect(result != null).toBe(true);
    });
});
