/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ExternalConversionDialog.java
 *
 * Created on 24 oct. 2009, 17:20:15
 */

package bt747.j2se_view;

import javax.swing.DefaultComboBoxModel;

import bt747.model.Model;

/**
 *
 * @author Mario
 */
public class ExternalConversionDialog extends javax.swing.JDialog {
    /**
     * 
     */
    private static final long serialVersionUID = 5659887530905870305L;
    /** A return status code - returned if Cancel button has been pressed */
    public static final int RET_CANCEL = 0;
    /** A return status code - returned if OK button has been pressed */
    public static final int RET_OK = 1;

    
    /** Creates new form ExternalConversionDialog */
    public ExternalConversionDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        setLocationRelativeTo(parent);
        cbIntermediateFormat.setModel(new DefaultComboBoxModel(intermediateFormatStrings));
    }

    private final static String getString(final String s) {
        return J2SEAppController.getString(s);

    }

    /** @return the return status of this dialog - one of RET_OK or RET_CANCEL */
    public int getReturnStatus() {
        return returnStatus;
    }

    /**
     * Allowed values for combobox selection.
     */
    private int[] intermediateFormats = { Model.GPX_LOGTYPE,
            Model.NMEA_LOGTYPE, Model.KML_LOGTYPE, Model.KMZ_LOGTYPE,
            Model.CSV_LOGTYPE };
    /**
     * Allowed values for combobox selection.
     */
    private String[] intermediateFormatStrings = {
            getString("GPX_Description"), getString("NMEA_Description"),
            getString("KML_Description"), getString("KMZ_Description"),
            getString("CSV_Description") };

    /**
     * 
     */
    public final void setExternalProgram(final String extProgramCall) {
        txtExtProgramCall.setText(extProgramCall);
    }

    public final String getExternalProgram() {
        return txtExtProgramCall.getText();
    }
    
    
    /**
     * The format can be {@link Model#GPX_LOGTYPE}, {@link Model#NMEA_LOGTYPE}
     * , {@link Model#KML_LOGTYPE}, {@link Model#KMZ_LOGTYPE},
     * {@link Model#CSV_LOGTYPE}.
     */
    public final void setIntermediateFormatType(final int fmt) {
        for(int i=0; i<intermediateFormats.length;i++) {
            if(fmt==intermediateFormats[i]) {
                cbIntermediateFormat.setSelectedIndex(i);
            }
        }
    }
    
    public final int getIntermediateFormatType() {
        return intermediateFormats[cbIntermediateFormat.getSelectedIndex()];
    }
       
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    private void initComponents() {//GEN-BEGIN:initComponents

        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        pnExternalToolSettings = new javax.swing.JPanel();
        lbExtProgram = new javax.swing.JLabel();
        lbIntermediateLogFormat = new javax.swing.JLabel();
        cbIntermediateFormat = new javax.swing.JComboBox();
        txtExtProgramCall = new javax.swing.JTextField();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("bt747/j2se_view/Bundle"); // NOI18N
        okButton.setText(bundle.getString("ExternalConversionDialog.okButton.text")); // NOI18N
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        cancelButton.setText(bundle.getString("ExternalConversionDialog.cancelButton.text")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        pnExternalToolSettings.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("ExternalConversionDialog.pnExternalToolSettings.border.title"))); // NOI18N

        lbExtProgram.setText(bundle.getString("ExternalConversionDialog.lbExtProgram.text")); // NOI18N

        lbIntermediateLogFormat.setText(bundle.getString("ExternalConversionDialog.lbIntermediateLogFormat.text")); // NOI18N

        org.jdesktop.layout.GroupLayout pnExternalToolSettingsLayout = new org.jdesktop.layout.GroupLayout(pnExternalToolSettings);
        pnExternalToolSettings.setLayout(pnExternalToolSettingsLayout);
        pnExternalToolSettingsLayout.setHorizontalGroup(
            pnExternalToolSettingsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnExternalToolSettingsLayout.createSequentialGroup()
                .add(pnExternalToolSettingsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(pnExternalToolSettingsLayout.createSequentialGroup()
                        .add(lbExtProgram)
                        .add(18, 18, 18)
                        .add(txtExtProgramCall, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 255, Short.MAX_VALUE))
                    .add(pnExternalToolSettingsLayout.createSequentialGroup()
                        .add(lbIntermediateLogFormat)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(cbIntermediateFormat, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        pnExternalToolSettingsLayout.setVerticalGroup(
            pnExternalToolSettingsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnExternalToolSettingsLayout.createSequentialGroup()
                .add(pnExternalToolSettingsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lbExtProgram)
                    .add(txtExtProgramCall, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnExternalToolSettingsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lbIntermediateLogFormat)
                    .add(cbIntermediateFormat, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap(250, Short.MAX_VALUE)
                .add(okButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 67, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(cancelButton)
                .addContainerGap())
            .add(pnExternalToolSettings, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        layout.linkSize(new java.awt.Component[] {cancelButton, okButton}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(pnExternalToolSettings, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(cancelButton)
                    .add(okButton))
                .addContainerGap())
        );

        pack();
    }//GEN-END:initComponents

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        doClose(RET_OK);
    }//GEN-LAST:event_okButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        doClose(RET_CANCEL);
    }//GEN-LAST:event_cancelButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        doClose(RET_CANCEL);
    }//GEN-LAST:event_closeDialog

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        setVisible(false);
        dispose();
    }

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                ExternalConversionDialog dialog = new ExternalConversionDialog(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JComboBox cbIntermediateFormat;
    private javax.swing.JLabel lbExtProgram;
    private javax.swing.JLabel lbIntermediateLogFormat;
    private javax.swing.JButton okButton;
    private javax.swing.JPanel pnExternalToolSettings;
    private javax.swing.JTextField txtExtProgramCall;
    // End of variables declaration//GEN-END:variables

    private int returnStatus = RET_CANCEL;
}
