"""Initial DB setup

Revision ID: dabab11132c1
Revises: None
Create Date: 2018-09-04 09:58:36.678749

"""

# revision identifiers, used by Alembic.
revision = 'dabab11132c1'
down_revision = None

from alembic import op
import sqlalchemy as sa

import sys, os
sys.path.append(os.getcwd())
import coprs


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('action',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('action_type', sa.Integer(), nullable=False),
    sa.Column('object_type', sa.String(length=20), nullable=True),
    sa.Column('object_id', sa.Integer(), nullable=True),
    sa.Column('old_value', sa.String(length=255), nullable=True),
    sa.Column('new_value', sa.String(length=255), nullable=True),
    sa.Column('data', sa.Text(), nullable=True),
    sa.Column('result', sa.Integer(), nullable=True),
    sa.Column('message', sa.Text(), nullable=True),
    sa.Column('created_on', sa.Integer(), nullable=True),
    sa.Column('ended_on', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('counter_stat',
    sa.Column('name', sa.String(length=127), nullable=False),
    sa.Column('counter_type', sa.String(length=30), nullable=True),
    sa.Column('counter', sa.Integer(), server_default='0', nullable=True),
    sa.PrimaryKeyConstraint('name')
    )
    op.create_table('group',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=127), nullable=True),
    sa.Column('fas_name', sa.String(length=127), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('mock_chroot',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('os_release', sa.String(length=50), nullable=False),
    sa.Column('os_version', sa.String(length=50), nullable=False),
    sa.Column('arch', sa.String(length=50), nullable=False),
    sa.Column('is_active', sa.Boolean(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('user',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('username', sa.String(length=100), nullable=False),
    sa.Column('mail', sa.String(length=150), nullable=False),
    sa.Column('timezone', sa.String(length=50), nullable=True),
    sa.Column('proven', sa.Boolean(), nullable=True),
    sa.Column('admin', sa.Boolean(), nullable=True),
    sa.Column('api_login', sa.String(length=40), nullable=False),
    sa.Column('api_token', sa.String(length=40), nullable=False),
    sa.Column('api_token_expiration', sa.Date(), nullable=False),
    sa.Column('openid_groups', coprs.helpers.JSONEncodedDict(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('username')
    )
    op.create_table('copr',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('homepage', sa.Text(), nullable=True),
    sa.Column('contact', sa.Text(), nullable=True),
    sa.Column('repos', sa.Text(), nullable=True),
    sa.Column('created_on', sa.Integer(), nullable=True),
    sa.Column('description', sa.Text(), nullable=True),
    sa.Column('instructions', sa.Text(), nullable=True),
    sa.Column('deleted', sa.Boolean(), nullable=True),
    sa.Column('playground', sa.Boolean(), nullable=True),
    sa.Column('auto_createrepo', sa.Boolean(), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.Column('group_id', sa.Integer(), nullable=True),
    sa.Column('forked_from_id', sa.Integer(), nullable=True),
    sa.Column('webhook_secret', sa.String(length=100), nullable=True),
    sa.Column('build_enable_net', sa.Boolean(), server_default='1', nullable=False),
    sa.Column('unlisted_on_hp', sa.Boolean(), nullable=False),
    sa.Column('latest_indexed_data_update', sa.Integer(), nullable=True),
    sa.Column('persistent', sa.Boolean(), server_default='0', nullable=False),
    sa.Column('auto_prune', sa.Boolean(), server_default='1', nullable=False),
    sa.ForeignKeyConstraint(['forked_from_id'], ['copr.id'], ),
    sa.ForeignKeyConstraint(['group_id'], ['group.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('krb5_login',
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('config_name', sa.String(length=30), nullable=False),
    sa.Column('primary', sa.String(length=80), nullable=False),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('config_name', 'primary')
    )
    op.create_table('copr_chroot',
    sa.Column('buildroot_pkgs', sa.Text(), nullable=True),
    sa.Column('mock_chroot_id', sa.Integer(), nullable=False),
    sa.Column('copr_id', sa.Integer(), nullable=False),
    sa.Column('comps_zlib', sa.LargeBinary(), nullable=True),
    sa.Column('comps_name', sa.String(length=127), nullable=True),
    sa.Column('module_md_zlib', sa.LargeBinary(), nullable=True),
    sa.Column('module_md_name', sa.String(length=127), nullable=True),
    sa.ForeignKeyConstraint(['copr_id'], ['copr.id'], ),
    sa.ForeignKeyConstraint(['mock_chroot_id'], ['mock_chroot.id'], ),
    sa.PrimaryKeyConstraint('mock_chroot_id', 'copr_id')
    )
    op.create_table('copr_permission',
    sa.Column('copr_builder', sa.SmallInteger(), nullable=True),
    sa.Column('copr_admin', sa.SmallInteger(), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('copr_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['copr_id'], ['copr.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('user_id', 'copr_id')
    )
    op.create_table('legal_flag',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('raise_message', sa.Text(), nullable=True),
    sa.Column('raised_on', sa.Integer(), nullable=True),
    sa.Column('resolved_on', sa.Integer(), nullable=True),
    sa.Column('copr_id', sa.Integer(), nullable=True),
    sa.Column('reporter_id', sa.Integer(), nullable=True),
    sa.Column('resolver_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['copr_id'], ['copr.id'], ),
    sa.ForeignKeyConstraint(['reporter_id'], ['user.id'], ),
    sa.ForeignKeyConstraint(['resolver_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('module',
    sa.Column('id', sa.Integer, primary_key=True),
    sa.Column('name', sa.String(100), nullable=False),
    sa.Column('stream', sa.String(100), nullable=False),
    sa.Column('version', sa.BigInteger, nullable=False),
    sa.Column('summary', sa.String(100), nullable=False),
    sa.Column('description', sa.Text),
    sa.Column('created_on', sa.Integer, nullable=True),
    sa.Column('yaml_b64', sa.Text),
    sa.Column('copr_id', sa.Integer, sa.ForeignKey('copr.id')),
    )
    op.create_table('package',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('source_type', sa.Integer(), nullable=True),
    sa.Column('source_json', sa.Text(), nullable=True),
    sa.Column('webhook_rebuild', sa.Boolean(), nullable=True),
    sa.Column('enable_net', sa.Boolean(), server_default='0', nullable=False),
    sa.Column('old_status', sa.Integer(), nullable=True),
    sa.Column('copr_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['copr_id'], ['copr.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('copr_id', 'name', name='packages_copr_pkgname')
    )
    op.create_table('build',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('pkgs', sa.Text(), nullable=True),
    sa.Column('built_packages', sa.Text(), nullable=True),
    sa.Column('pkg_version', sa.Text(), nullable=True),
    sa.Column('canceled', sa.Boolean(), nullable=True),
    sa.Column('repos', sa.Text(), nullable=True),
    sa.Column('submitted_on', sa.Integer(), nullable=False),
    sa.Column('results', sa.Text(), nullable=True),
    sa.Column('memory_reqs', sa.Integer(), nullable=True),
    sa.Column('timeout', sa.Integer(), nullable=True),
    sa.Column('enable_net', sa.Boolean(), server_default='0', nullable=False),
    sa.Column('source_type', sa.Integer(), nullable=True),
    sa.Column('source_json', sa.Text(), nullable=True),
    sa.Column('fail_type', sa.Integer(), nullable=True),
    sa.Column('is_background', sa.Boolean(), server_default='0', nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.Column('copr_id', sa.Integer(), nullable=True),
    sa.Column('package_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['copr_id'], ['copr.id'], ),
    sa.ForeignKeyConstraint(['package_id'], ['package.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index('build_canceled', 'build', ['canceled'], unique=False)
    op.create_table('build_chroot',
    sa.Column('mock_chroot_id', sa.Integer(), nullable=False),
    sa.Column('build_id', sa.Integer(), nullable=False),
    sa.Column('git_hash', sa.String(length=40), nullable=True),
    sa.Column('status', sa.Integer(), nullable=True),
    sa.Column('started_on', sa.Integer(), nullable=True),
    sa.Column('ended_on', sa.Integer(), nullable=True),
    sa.Column('last_deferred', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['build_id'], ['build.id'], ),
    sa.ForeignKeyConstraint(['mock_chroot_id'], ['mock_chroot.id'], ),
    sa.PrimaryKeyConstraint('mock_chroot_id', 'build_id')
    )
    op.create_index(op.f('ix_build_chroot_ended_on'), 'build_chroot', ['ended_on'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    pass
