/*
 *   Copyright © 2021 Reven Martin <revenmartin@gmail.com>
 *   Copyright © 2015 Robert Metsäranta <therealestrob@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; see the file COPYING.  if not, write to
 *   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *   Boston, MA 02110-1301, USA.
 */

#ifndef ROUNDEDWINDOW_H
#define ROUNDEDWINDOW_H

#include <kwineffects.h>

namespace KWin { class GLTexture; }

class RoundedWindow : public KWin::Effect
{
    Q_OBJECT

public:
    enum { TopLeft = 0,
           TopRight,
           BottomRight,
           BottomLeft,
           NTex };

    RoundedWindow();
    ~RoundedWindow();

    static bool supported();
    static bool enabledByDefault();
    bool hasShadow(KWin::WindowQuadList &qds);

    void paintWindow(KWin::EffectWindow *w, int mask, QRegion region, KWin::WindowPaintData &data);

private:
    void genMasks();
    void genRect();

private:
    KWin::GLShader *m_shader;
    KWin::GLTexture *m_tex[NTex];
    KWin::GLTexture *m_rect[NTex];
    int m_frameRadius;
    QSize m_corner;
};

#endif
