/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     chenhaifeng  <chenhaifeng@uniontech.com>
*
* Maintainer: chenhaifeng  <chenhaifeng@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "pinyindict.h"

QMap<int, QString> PinyinDict_1{
    { 0x3007, "líng,yuán,xīng"},
    { 0x3400, "qiū"},
    { 0x3401, "tiàn"},
    { 0x3404, "kuà"},
    { 0x3405, "wǔ"},
    { 0x3406, "yǐn"},
    { 0x340C, "yí"},
    { 0x3416, "xié"},
    { 0x341C, "chóu"},
    { 0x3421, "nuò"},
    { 0x3424, "dān,qiú"},
    { 0x3428, "xù"},
    { 0x3429, "xíng"},
    { 0x342B, "xiōng"},
    { 0x342C, "liú"},
    { 0x342D, "lǐn"},
    { 0x342E, "xiāng"},
    { 0x342F, "yōng"},
    { 0x3430, "xìn"},
    { 0x3431, "zhěn"},
    { 0x3432, "dài"},
    { 0x3433, "wù"},
    { 0x3434, "pān"},
    { 0x3435, "rú"},
    { 0x3437, "mǎ"},
    { 0x3438, "qiàn,cì"},
    { 0x3439, "yì"},
    { 0x343A, "yín,zhòng"},
    { 0x343B, "nèi"},
    { 0x343C, "chèng"},
    { 0x343D, "fēng"},
    { 0x3441, "zhuō"},
    { 0x3442, "fǎng"},
    { 0x3443, "ǎo"},
    { 0x3444, "wǔ"},
    { 0x3445, "zuò"},
    { 0x3447, "zhòu"},
    { 0x3448, "dòng"},
    { 0x3449, "sù"},
    { 0x344A, "yì"},
    { 0x344B, "qióng"},
    { 0x344C, "kuāng,wāng"},
    { 0x344D, "lèi"},
    { 0x344E, "nǎo"},
    { 0x344F, "zhù"},
    { 0x3450, "shū"},
    { 0x3454, "xǔ"},
    { 0x3457, "shēn"},
    { 0x3458, "jiè"},
    { 0x3459, "dié"},
    { 0x345A, "nuó"},
    { 0x345B, "sù"},
    { 0x345C, "yì,chì"},
    { 0x345D, "lòng"},
    { 0x345E, "yìng"},
    { 0x345F, "běng"},
    { 0x3463, "lán"},
    { 0x3464, "miáo"},
    { 0x3465, "yì"},
    { 0x3466, "lì"},
    { 0x3467, "jì"},
    { 0x3468, "yǔ"},
    { 0x3469, "luó"},
    { 0x346A, "chái"},
    { 0x346E, "hún"},
    { 0x346F, "xǔ"},
    { 0x3470, "huì"},
    { 0x3471, "rǎo"},
    { 0x3473, "zhòu,zhū"},
    { 0x3475, "hàn"},
    { 0x3476, "xì"},
    { 0x3477, "tài"},
    { 0x3478, "yáo"},
    { 0x3479, "huì"},
    { 0x347A, "jùn"},
    { 0x347B, "mà"},
    { 0x347C, "lüè"},
    { 0x347D, "táng"},
    { 0x347E, "yáo"},
    { 0x347F, "zhào"},
    { 0x3480, "zhāi,zhǎ"},
    { 0x3481, "yǔ"},
    { 0x3482, "zhuó"},
    { 0x3483, "èr"},
    { 0x3484, "rǎn"},
    { 0x3485, "qǐ"},
    { 0x3486, "chì"},
    { 0x3487, "wǔ"},
    { 0x3488, "hàn"},
    { 0x3489, "tǎng"},
    { 0x348A, "sè"},
    { 0x348C, "qióng"},
    { 0x348D, "léi"},
    { 0x348E, "sà"},
    { 0x3491, "kuǐ,huì"},
    { 0x3492, "pú"},
    { 0x3493, "tà"},
    { 0x3494, "shú,dú,tù"},
    { 0x3495, "yāng"},
    { 0x3496, "ǒu"},
    { 0x3497, "tái"},
    { 0x3499, "mián"},
    { 0x349A, "yìn,wěn"},
    { 0x349B, "diào"},
    { 0x349C, "yǔ"},
    { 0x349D, "miè,wà"},
    { 0x349E, "jùn"},
    { 0x349F, "niǎo"},
    { 0x34A0, "xiè"},
    { 0x34A1, "yóu"},
    { 0x34A4, "chè"},
    { 0x34A5, "fēng"},
    { 0x34A6, "lěi,lèi"},
    { 0x34A7, "lì"},
    { 0x34A9, "luǒ"},
    { 0x34AB, "jì"},
    { 0x34B0, "quán"},
    { 0x34B2, "cái"},
    { 0x34B3, "liǎng"},
    { 0x34B4, "gǔ"},
    { 0x34B5, "mào"},
    { 0x34B7, "guǎ"},
    { 0x34B8, "suì"},
    { 0x34BB, "mào"},
    { 0x34BC, "mán"},
    { 0x34BD, "quān"},
    { 0x34BE, "shì"},
    { 0x34BF, "lí"},
    { 0x34C1, "wǎng"},
    { 0x34C2, "kòu"},
    { 0x34C3, "dù"},
    { 0x34C4, "zhèn"},
    { 0x34C5, "tīng"},
    { 0x34C8, "bìng"},
    { 0x34C9, "huò"},
    { 0x34CA, "dòng"},
    { 0x34CB, "gòng"},
    { 0x34CC, "chēng"},
    { 0x34CE, "qīn,qìn,qǐn"},
    { 0x34CF, "jiǒng"},
    { 0x34D0, "lù"},
    { 0x34D1, "xìng"},
    { 0x34D3, "nán"},
    { 0x34D4, "xiè"},
    { 0x34D6, "bì"},
    { 0x34D7, "jié"},
    { 0x34D8, "sù"},
    { 0x34DA, "gōng"},
    { 0x34DC, "yòu"},
    { 0x34DD, "xíng"},
    { 0x34DE, "qià"},
    { 0x34DF, "pí"},
    { 0x34E0, "diàn,diǎn"},
    { 0x34E1, "fǔ,guā"},
    { 0x34E2, "luò"},
    { 0x34E3, "qià,gē"},
    { 0x34E4, "qià"},
    { 0x34E5, "tāng"},
    { 0x34E6, "bāi"},
    { 0x34E7, "gān"},
    { 0x34E8, "cí"},
    { 0x34E9, "xuān,jiē"},
    { 0x34EA, "lǎng"},
    { 0x34ED, "shé"},
    { 0x34EF, "lí"},
    { 0x34F0, "huà"},
    { 0x34F1, "tóu,shū"},
    { 0x34F2, "piān"},
    { 0x34F3, "dī"},
    { 0x34F4, "ruǎn"},
    { 0x34F5, "è"},
    { 0x34F6, "qiè"},
    { 0x34F7, "yì"},
    { 0x34F8, "zhuō,dōu"},
    { 0x34F9, "ruì,cuì,jì"},
    { 0x34FA, "jiān,qián"},
    { 0x34FC, "chì"},
    { 0x34FD, "chóng"},
    { 0x34FE, "xī,chí"},
    { 0x3500, "lüè"},
    { 0x3501, "dēng"},
    { 0x3502, "lín"},
    { 0x3503, "jué,xuē"},
    { 0x3504, "sù"},
    { 0x3505, "xiào"},
    { 0x3506, "zàn"},
    { 0x3509, "zhǔ"},
    { 0x350A, "zhǎn,dǎn"},
    { 0x350B, "jiān,lán"},
    { 0x350C, "zòu,cǒu"},
    { 0x350D, "chuā,zhá"},
    { 0x350E, "xiè"},
    { 0x350F, "lì,luǒ"},
    { 0x3511, "chì"},
    { 0x3512, "xí"},
    { 0x3513, "jiǎn"},
    { 0x3515, "jí"},
    { 0x3517, "fèi,bèi,fú"},
    { 0x3518, "chù"},
    { 0x3519, "bēng"},
    { 0x351A, "jié"},
    { 0x351C, "bá"},
    { 0x351D, "liǎng,liáng"},
    { 0x351E, "kuài"},
    { 0x3520, "xiā,hé"},
    { 0x3521, "biē"},
    { 0x3522, "jué,xuē"},
    { 0x3523, "léi"},
    { 0x3524, "xìn"},
    { 0x3525, "bài,pí"},
    { 0x3526, "yǎng"},
    { 0x3527, "lǜ"},
    { 0x3528, "bèi"},
    { 0x3529, "è"},
    { 0x352A, "lǔ"},
    { 0x352D, "chè"},
    { 0x352E, "nuó"},
    { 0x352F, "xuán,suǎn"},
    { 0x3530, "héng"},
    { 0x3531, "yǔ"},
    { 0x3533, "guǐ"},
    { 0x3534, "yì"},
    { 0x3535, "xuǎn"},
    { 0x3536, "gòng,gǎn"},
    { 0x3537, "lòu"},
    { 0x3538, "tī"},
    { 0x3539, "lè"},
    { 0x353A, "shì"},
    { 0x353C, "sǔn"},
    { 0x353D, "yào"},
    { 0x353E, "xiān,jié"},
    { 0x353F, "zòu"},
    { 0x3541, "què"},
    { 0x3542, "yín,qín"},
    { 0x3543, "xī"},
    { 0x3544, "zhǐ"},
    { 0x3545, "jiá"},
    { 0x3546, "hù"},
    { 0x3547, "lā"},
    { 0x3548, "yǐ"},
    { 0x3549, "kè"},
    { 0x354A, "fū"},
    { 0x354B, "qín"},
    { 0x354C, "ài"},
    { 0x354E, "kè"},
    { 0x354F, "chú"},
    { 0x3550, "xiě,xiè"},
    { 0x3551, "chú"},
    { 0x3552, "wēi"},
    { 0x3555, "huàn"},
    { 0x3556, "sù"},
    { 0x3557, "yòu"},
    { 0x3559, "jùn"},
    { 0x355A, "zhǎo"},
    { 0x355B, "xù"},
    { 0x355C, "shǐ"},
    { 0x355E, "shuā"},
    { 0x355F, "kuì,kuài"},
    { 0x3560, "shuāng"},
    { 0x3561, "hé"},
    { 0x3562, "gài,hài"},
    { 0x3563, "yǎn"},
    { 0x3564, "qiú"},
    { 0x3565, "shēn"},
    { 0x3566, "huà"},
    { 0x3567, "xī"},
    { 0x3568, "fàn"},
    { 0x3569, "pàng"},
    { 0x356A, "dǎn"},
    { 0x356B, "fǎng,fēng"},
    { 0x356C, "gōng,sòng"},
    { 0x356D, "āo,ào"},
    { 0x356E, "fǔ"},
    { 0x356F, "nè"},
    { 0x3570, "xuè,ma"},
    { 0x3571, "yóu"},
    { 0x3572, "huá,yíng"},
    { 0x3574, "chén"},
    { 0x3575, "guó"},
    { 0x3576, "ň,ňg"},
    { 0x3577, "huà,pā"},
    { 0x3578, "lì"},
    { 0x3579, "fá"},
    { 0x357A, "xiāo"},
    { 0x357B, "pǒu"},
    { 0x357D, "sì"},
    { 0x3580, "lè"},
    { 0x3581, "lìn"},
    { 0x3582, "yì"},
    { 0x3583, "hǒu,hòu"},
    { 0x3585, "xù"},
    { 0x3586, "qú"},
    { 0x3587, "ér"},
    { 0x358A, "xún"},
    { 0x358F, "niè"},
    { 0x3590, "wěi"},
    { 0x3591, "xiè"},
    { 0x3592, "tí"},
    { 0x3593, "hóng"},
    { 0x3594, "tǔn"},
    { 0x3595, "niè,xīn"},
    { 0x3596, "niè"},
    { 0x3597, "yín"},
    { 0x3598, "zhēn"},
    { 0x359E, "wāi"},
    { 0x359F, "shòu"},
    { 0x35A0, "nuò"},
    { 0x35A1, "yè"},
    { 0x35A2, "qí"},
    { 0x35A3, "tòu"},
    { 0x35A4, "hán"},
    { 0x35A5, "jùn"},
    { 0x35A6, "dǒng"},
    { 0x35A7, "hūn,wěn"},
    { 0x35A8, "lù"},
    { 0x35A9, "jū,sǒu"},
    { 0x35AA, "huò,guó,xù"},
    { 0x35AB, "líng"},
    { 0x35AD, "tiǎn"},
    { 0x35AE, "lún"},
    { 0x35B5, "gé"},
    { 0x35B6, "yān,yè,yīn"},
    { 0x35B7, "shí,tí"},
    { 0x35B8, "xué,niā"},
    { 0x35B9, "pēn,fèn"},
    { 0x35BA, "chǔn"},
    { 0x35BB, "niú,ròu"},
    { 0x35BC, "duǒ"},
    { 0x35BD, "zé"},
    { 0x35BE, "è"},
    { 0x35BF, "xié,yé"},
    { 0x35C0, "yōu"},
    { 0x35C1, "è"},
    { 0x35C2, "shěng"},
    { 0x35C3, "wěn,hūn"},
    { 0x35C4, "kū"},
    { 0x35C5, "hú"},
    { 0x35C6, "gé"},
    { 0x35C7, "xiá,ya"},
    { 0x35C8, "màn"},
    { 0x35C9, "lüè,è"},
    { 0x35CA, "jí,léi"},
    { 0x35CB, "hóu"},
    { 0x35CC, "zhì"},
    { 0x35CF, "wāi"},
    { 0x35D1, "bai"},
    { 0x35D2, "ài"},
    { 0x35D3, "zhuī"},
    { 0x35D4, "qiān"},
    { 0x35D5, "gòu,gōu"},
    { 0x35D6, "dàn"},
    { 0x35D7, "bēi"},
    { 0x35D8, "bó"},
    { 0x35D9, "chū,nà,zhōu"},
    { 0x35DA, "lì"},
    { 0x35DB, "xiào"},
    { 0x35DC, "xiù"},
    { 0x35E2, "hóng,dòng,hòng"},
    { 0x35E3, "tì"},
    { 0x35E4, "cù"},
    { 0x35E5, "kuò,guō"},
    { 0x35E6, "láo"},
    { 0x35E7, "zhì,dié"},
    { 0x35E8, "xiē,ǎi"},
    { 0x35E9, "xī"},
    { 0x35EB, "qiè"},
    { 0x35EC, "zhā"},
    { 0x35ED, "xī"},
    { 0x35F0, "cóng"},
    { 0x35F1, "jí"},
    { 0x35F2, "huò"},
    { 0x35F3, "tǎ,dā"},
    { 0x35F4, "yán"},
    { 0x35F5, "xù"},
    { 0x35F6, "pō"},
    { 0x35F7, "sǎi"},
    { 0x35FB, "guō"},
    { 0x35FC, "yè"},
    { 0x35FD, "xiǎng"},
    { 0x35FE, "xuē"},
    { 0x35FF, "hé,xià,xiā"},
    { 0x3600, "zuò"},
    { 0x3601, "yì"},
    { 0x3602, "cí"},
    { 0x3604, "lēng"},
    { 0x3605, "xián"},
    { 0x3606, "tǎi"},
    { 0x3607, "róng"},
    { 0x3608, "yì,nǐ"},
    { 0x3609, "zhì"},
    { 0x360A, "xī,yì"},
    { 0x360B, "xián"},
    { 0x360C, "jù"},
    { 0x360D, "jí"},
    { 0x360E, "hǎn"},
    { 0x3610, "pào"},
    { 0x3611, "lì"},
    { 0x3613, "lán"},
    { 0x3614, "sǎi"},
    { 0x3615, "hǎn,lán"},
    { 0x3616, "yán"},
    { 0x3617, "qū"},
    { 0x3619, "yán"},
    { 0x361A, "hǎn"},
    { 0x361B, "kān"},
    { 0x361C, "chǐ"},
    { 0x361D, "niè"},
    { 0x361E, "huò"},
    { 0x3620, "bì"},
    { 0x3621, "xiá"},
    { 0x3622, "wěng"},
    { 0x3623, "xuán,yuán"},
    { 0x3624, "wān"},
    { 0x3625, "yóu"},
    { 0x3626, "qín"},
    { 0x3627, "xù"},
    { 0x3628, "niè"},
    { 0x3629, "bì"},
    { 0x362A, "hào"},
    { 0x362B, "jǐng"},
    { 0x362C, "ào,wù"},
    { 0x362D, "ào"},
    { 0x3630, "zhēn"},
    { 0x3631, "tān"},
    { 0x3632, "jú"},
    { 0x3634, "zuò"},
    { 0x3635, "bù"},
    { 0x3636, "jié"},
    { 0x3637, "ài"},
    { 0x3638, "zàng,zuò"},
    { 0x3639, "cí"},
    { 0x363A, "fá"},
    { 0x363F, "niè"},
    { 0x3640, "liù,jiù"},
    { 0x3641, "méi,mù"},
    { 0x3642, "duì,wèng"},
    { 0x3643, "bāng"},
    { 0x3644, "bì"},
    { 0x3645, "bǎo"},
    { 0x3647, "chù"},
    { 0x3648, "xià"},
    { 0x3649, "tiǎn"},
    { 0x364A, "cháng,zhàng"},
    { 0x364D, "duō"},
    { 0x364E, "wēi"},
    { 0x364F, "fù"},
    { 0x3650, "duǒ"},
    { 0x3651, "yǔ"},
    { 0x3652, "yě"},
    { 0x3653, "kuí"},
    { 0x3654, "wěi,hán"},
    { 0x3655, "kuài"},
    { 0x3657, "wēi"},
    { 0x3658, "yāo"},
    { 0x3659, "lǒng"},
    { 0x365A, "xīng"},
    { 0x365B, "bǔ"},
    { 0x365C, "chí"},
    { 0x365D, "xié"},
    { 0x365E, "niè"},
    { 0x365F, "lǎng"},
    { 0x3660, "yī,yì"},
    { 0x3661, "zōng"},
    { 0x3662, "mán"},
    { 0x3663, "zhàng"},
    { 0x3664, "xià"},
    { 0x3665, "gùn"},
    { 0x3666, "xié"},
    { 0x3668, "jì"},
    { 0x3669, "liáo"},
    { 0x366A, "yì"},
    { 0x366B, "jí"},
    { 0x366C, "yín"},
    { 0x366E, "dā,da"},
    { 0x366F, "yì"},
    { 0x3670, "xiè"},
    { 0x3671, "hào"},
    { 0x3672, "yǒng"},
    { 0x3673, "kǎn,hǎn"},
    { 0x3674, "chàn"},
    { 0x3675, "tái"},
    { 0x3676, "táng"},
    { 0x3677, "zhí,zhé"},
    { 0x3678, "bào"},
    { 0x3679, "méng"},
    { 0x367A, "kuí,guì"},
    { 0x367B, "chán"},
    { 0x367C, "lěi"},
    { 0x367E, "xì"},
    { 0x3680, "xī"},
    { 0x3681, "qiào"},
    { 0x3682, "nàng"},
    { 0x3683, "yūn"},
    { 0x3685, "lóng"},
    { 0x3686, "fù"},
    { 0x3687, "zōng"},
    { 0x3689, "gǔ"},
    { 0x368A, "kāi"},
    { 0x368B, "diāo"},
    { 0x368C, "huà"},
    { 0x368D, "kuǐ,kuì"},
    { 0x368F, "gǎo"},
    { 0x3690, "tào"},
    { 0x3692, "shǎn"},
    { 0x3693, "lǎi"},
    { 0x3694, "niè,xìng"},
    { 0x3695, "fú"},
    { 0x3696, "gǎo,zé"},
    { 0x3697, "qié"},
    { 0x3698, "bàn,hè,fú"},
    { 0x3699, "jiā"},
    { 0x369A, "kōng,kuāng"},
    { 0x369B, "xì"},
    { 0x369C, "yù,xù"},
    { 0x369D, "zhuī"},
    { 0x369E, "shěn"},
    { 0x369F, "chuò"},
    { 0x36A0, "xiāo"},
    { 0x36A1, "jǐ"},
    { 0x36A2, "nú,wǔ"},
    { 0x36A3, "xiáo"},
    { 0x36A4, "yì"},
    { 0x36A5, "yú"},
    { 0x36A6, "yí"},
    { 0x36A7, "yǎn"},
    { 0x36A8, "shěn"},
    { 0x36A9, "rǎn"},
    { 0x36AA, "hào"},
    { 0x36AB, "sà"},
    { 0x36AC, "jūn"},
    { 0x36AD, "yóu"},
    { 0x36AF, "xín"},
    { 0x36B0, "pēi,bǐ"},
    { 0x36B1, "qiū"},
    { 0x36B2, "chān,diǎn,diàn"},
    { 0x36B4, "bù"},
    { 0x36B5, "dōng"},
    { 0x36B6, "sì,yí"},
    { 0x36B7, "ěr"},
    { 0x36B9, "mǎo,liǔ"},
    { 0x36BA, "yùn"},
    { 0x36BB, "jī"},
    { 0x36BD, "qiǎo"},
    { 0x36BE, "xiōng"},
    { 0x36BF, "páo"},
    { 0x36C0, "chú"},
    { 0x36C1, "pēng"},
    { 0x36C2, "nuǒ"},
    { 0x36C3, "jié"},
    { 0x36C4, "yī"},
    { 0x36C5, "èr"},
    { 0x36C6, "duò,duǒ"},
    { 0x36CA, "duǒ"},
    { 0x36CD, "qiè,xiǎn,xiá"},
    { 0x36CE, "lǚ"},
    { 0x36CF, "qiú"},
    { 0x36D0, "sǒu"},
    { 0x36D1, "càn"},
    { 0x36D2, "dòu"},
    { 0x36D3, "xī"},
    { 0x36D4, "fēng,péng"},
    { 0x36D5, "yì,è"},
    { 0x36D6, "suō"},
    { 0x36D7, "qiē,zuō,suō"},
    { 0x36D8, "pò"},
    { 0x36D9, "xīn,qiè"},
    { 0x36DA, "tǒng,yǒng"},
    { 0x36DB, "xìn"},
    { 0x36DC, "yóu"},
    { 0x36DD, "bèi"},
    { 0x36DE, "lòng"},
    { 0x36E3, "yún"},
    { 0x36E4, "lí"},
    { 0x36E5, "tà"},
    { 0x36E6, "lǎn"},
    { 0x36E7, "mǎn"},
    { 0x36E8, "qiǎng"},
    { 0x36E9, "zhóu"},
    { 0x36EA, "yàn,yān"},
    { 0x36EB, "xī"},
    { 0x36EC, "lù"},
    { 0x36ED, "xī"},
    { 0x36EE, "sǎo"},
    { 0x36EF, "fàn,miǎn,zhuàn"},
    { 0x36F1, "wěi,wēi"},
    { 0x36F2, "fà"},
    { 0x36F3, "yì"},
    { 0x36F4, "nǎo"},
    { 0x36F5, "chēng"},
    { 0x36F6, "tàn"},
    { 0x36F7, "jī"},
    { 0x36F8, "shù"},
    { 0x36F9, "pián"},
    { 0x36FA, "ān"},
    { 0x36FB, "kuā"},
    { 0x36FC, "chā,shà"},
    { 0x36FE, "xián"},
    { 0x36FF, "zhì"},
    { 0x3702, "fēng"},
    { 0x3703, "liàn"},
    { 0x3704, "xún"},
    { 0x3705, "xù"},
    { 0x3706, "mì"},
    { 0x3707, "huì,yè"},
    { 0x3708, "mù"},
    { 0x3709, "yōng"},
    { 0x370A, "zhǎn"},
    { 0x370B, "yì"},
    { 0x370C, "nǒu,gòu,kòu"},
    { 0x370D, "táng"},
    { 0x370E, "xī,xì"},
    { 0x370F, "yún"},
    { 0x3710, "shù"},
    { 0x3711, "fú"},
    { 0x3712, "yì"},
    { 0x3713, "dá"},
    { 0x3715, "lián"},
    { 0x3716, "cáo"},
    { 0x3717, "cān,sēn"},
    { 0x3718, "jù,qù,chá"},
    { 0x3719, "lù"},
    { 0x371A, "sù"},
    { 0x371B, "nèn"},
    { 0x371C, "ào"},
    { 0x371D, "ǎn,yǎn"},
    { 0x371E, "qiàn,cán"},
    { 0x3720, "cuī"},
    { 0x3721, "cōng"},
    { 0x3723, "rán,rǎn"},
    { 0x3724, "niǎn,tiǎn,tán"},
    { 0x3725, "mái"},
    { 0x3726, "xín"},
    { 0x3727, "yuè"},
    { 0x3728, "nái"},
    { 0x3729, "ào"},
    { 0x372A, "shēn"},
    { 0x372B, "mà"},
    { 0x372E, "làn,lán"},
    { 0x372F, "xī"},
    { 0x3730, "yuè"},
    { 0x3731, "zhì"},
    { 0x3732, "wěng"},
    { 0x3733, "huái"},
    { 0x3734, "mèng"},
    { 0x3735, "niǎo"},
    { 0x3736, "wǎn"},
    { 0x3737, "mí,xiǎn"},
    { 0x3738, "niè"},
    { 0x3739, "qú"},
    { 0x373A, "zàn"},
    { 0x373B, "liàn"},
    { 0x373C, "zhí"},
    { 0x373D, "zǐ"},
    { 0x373E, "hái"},
    { 0x373F, "xù"},
    { 0x3740, "hào"},
    { 0x3741, "xuān,qióng"},
    { 0x3742, "zhì,zhè"},
    { 0x3743, "miǎn"},
    { 0x3744, "chún"},
    { 0x3745, "gòu"},
    { 0x3747, "chún"},
    { 0x3748, "luán"},
    { 0x3749, "zhù"},
    { 0x374A, "shǒu"},
    { 0x374B, "liǎo"},
    { 0x374C, "jiù"},
    { 0x374D, "xiě"},
    { 0x374E, "dìng"},
    { 0x374F, "jiè"},
    { 0x3750, "róng"},
    { 0x3751, "máng"},
    { 0x3753, "kè"},
    { 0x3754, "yǎo"},
    { 0x3755, "níng"},
    { 0x3756, "yí"},
    { 0x3757, "láng,lǎng"},
    { 0x3758, "yóng"},
    { 0x3759, "yín"},
    { 0x375A, "yán"},
    { 0x375B, "sù"},
    { 0x375D, "lín"},
    { 0x375E, "yā,yà"},
    { 0x375F, "máo"},
    { 0x3760, "míng"},
    { 0x3761, "zuì"},
    { 0x3762, "yǔ"},
    { 0x3763, "yì"},
    { 0x3764, "gòu"},
    { 0x3765, "mǐ"},
    { 0x3766, "jùn"},
    { 0x3767, "wěn"},
    { 0x3769, "kāng"},
    { 0x376A, "diàn"},
    { 0x376B, "lóng"},
    { 0x376D, "xǐng"},
    { 0x376E, "cuì"},
    { 0x376F, "qiáo"},
    { 0x3770, "mián"},
    { 0x3771, "mèng"},
    { 0x3772, "qǐn"},
    { 0x3774, "wán"},
    { 0x3775, "dé,ài"},
    { 0x3776, "ài"},
    { 0x3778, "biàn"},
    { 0x3779, "nóu"},
    { 0x377A, "lián"},
    { 0x377B, "jǐn"},
    { 0x377C, "yū"},
    { 0x377D, "chuí"},
    { 0x377E, "zuǒ"},
    { 0x377F, "bǒ"},
    { 0x3780, "huī"},
    { 0x3781, "yào"},
    { 0x3782, "tuǐ,tuì"},
    { 0x3783, "jì"},
    { 0x3784, "ān"},
    { 0x3785, "luò"},
    { 0x3786, "jǐ"},
    { 0x3787, "wěi"},
    { 0x3788, "bō"},
    { 0x3789, "zā"},
    { 0x378A, "xù"},
    { 0x378B, "niǎn,jí"},
    { 0x378C, "yùn"},
    { 0x378E, "bǎ,pā"},
    { 0x378F, "zhé,jié"},
    { 0x3790, "jū"},
    { 0x3791, "wěi"},
    { 0x3792, "xiè,xì"},
    { 0x3793, "qì,jī"},
    { 0x3794, "yí"},
    { 0x3795, "xiè"},
    { 0x3796, "cí,cì"},
    { 0x3797, "qiú"},
    { 0x3798, "dū"},
    { 0x3799, "niào"},
    { 0x379A, "qì,zhǎ"},
    { 0x379B, "jǐ"},
    { 0x379C, "tuī"},
    { 0x379E, "sóng"},
    { 0x379F, "diàn,dǐng"},
    { 0x37A0, "láo"},
    { 0x37A1, "zhǎn"},
    { 0x37A4, "yín,cén"},
    { 0x37A5, "cén"},
    { 0x37A6, "jǐ"},
    { 0x37A7, "huì"},
    { 0x37A8, "zǐ"},
    { 0x37A9, "lán"},
    { 0x37AA, "náo"},
    { 0x37AB, "jù"},
    { 0x37AC, "qìn"},
    { 0x37AD, "dài"},
    { 0x37AF, "jié"},
    { 0x37B0, "xǔ"},
    { 0x37B1, "cōng"},
    { 0x37B2, "yòng"},
    { 0x37B3, "dǒu"},
    { 0x37B4, "chí,mín"},
    { 0x37B6, "mǐn"},
    { 0x37B7, "huáng"},
    { 0x37B8, "suì"},
    { 0x37B9, "kě"},
    { 0x37BA, "zú"},
    { 0x37BB, "hào"},
    { 0x37BC, "chéng"},
    { 0x37BD, "xuè"},
    { 0x37BE, "ní"},
    { 0x37BF, "chì"},
    { 0x37C0, "lián"},
    { 0x37C1, "àn"},
    { 0x37C2, "mǔ"},
    { 0x37C3, "sī"},
    { 0x37C4, "xiáng"},
    { 0x37C5, "yáng"},
    { 0x37C6, "huá"},
    { 0x37C7, "cuò,cuó"},
    { 0x37C8, "qiú"},
    { 0x37C9, "láo"},
    { 0x37CA, "fú"},
    { 0x37CB, "duì"},
    { 0x37CC, "máng"},
    { 0x37CD, "láng,lǎng"},
    { 0x37CE, "tuǒ,tuǐ"},
    { 0x37CF, "hán"},
    { 0x37D0, "mǎng"},
    { 0x37D1, "bó"},
    { 0x37D2, "qūn"},
    { 0x37D3, "qí"},
    { 0x37D4, "hán"},
    { 0x37D6, "lòng,lóng"},
    { 0x37D8, "tiáo"},
    { 0x37D9, "zé"},
    { 0x37DA, "qí"},
    { 0x37DB, "zàn"},
    { 0x37DC, "mí"},
    { 0x37DD, "péi"},
    { 0x37DE, "zhàn"},
    { 0x37DF, "xiàng"},
    { 0x37E0, "gǎng"},
    { 0x37E2, "qí"},
    { 0x37E4, "lù"},
    { 0x37E6, "yùn"},
    { 0x37E7, "è"},
    { 0x37E8, "duān"},
    { 0x37E9, "mín"},
    { 0x37EA, "wēi,wěi"},
    { 0x37EB, "quán"},
    { 0x37EC, "sǒu"},
    { 0x37ED, "mín"},
    { 0x37EE, "tū"},
    { 0x37F0, "mǐng"},
    { 0x37F1, "yǎo"},
    { 0x37F2, "jué"},
    { 0x37F3, "lì"},
    { 0x37F4, "kuài"},
    { 0x37F5, "gǎng"},
    { 0x37F6, "yuán"},
    { 0x37F7, "da"},
    { 0x37F9, "láo"},
    { 0x37FA, "lóu"},
    { 0x37FB, "qiàn,zhǎn"},
    { 0x37FC, "áo"},
    { 0x37FD, "biǎo,biāo"},
    { 0x37FE, "yōng"},
    { 0x37FF, "mǎng,máng"},
    { 0x3800, "dǎo"},
    { 0x3802, "áo"},
    { 0x3804, "xí"},
    { 0x3805, "fú,fù"},
    { 0x3806, "dān"},
    { 0x3807, "jiù"},
    { 0x3808, "rùn"},
    { 0x3809, "tóng"},
    { 0x380A, "qū"},
    { 0x380B, "è"},
    { 0x380C, "qī"},
    { 0x380D, "jí"},
    { 0x380E, "jí,jié"},
    { 0x380F, "huá"},
    { 0x3810, "jiào"},
    { 0x3811, "zuì"},
    { 0x3812, "biǎo"},
    { 0x3813, "méng"},
    { 0x3814, "bài"},
    { 0x3815, "wěi"},
    { 0x3816, "yǐ"},
    { 0x3817, "ào"},
    { 0x3818, "yǔ"},
    { 0x3819, "háo"},
    { 0x381A, "duì"},
    { 0x381B, "wò"},
    { 0x381C, "nì"},
    { 0x381D, "cuán"},
    { 0x381F, "lí"},
    { 0x3820, "lú"},
    { 0x3821, "niǎo"},
    { 0x3822, "huái"},
    { 0x3823, "lì"},
    { 0x3825, "lǜ,léi,lěi"},
    { 0x3826, "fēng"},
    { 0x3827, "mǐ"},
    { 0x3828, "yù"},
    { 0x382A, "jù"},
    { 0x382D, "zhǎn"},
    { 0x382E, "pēng,gāng"},
    { 0x382F, "yǐ"},
    { 0x3831, "jì,qǐ"},
    { 0x3832, "bǐ"},
    { 0x3834, "rèn"},
    { 0x3835, "huāng"},
    { 0x3836, "fán"},
    { 0x3837, "gé"},
    { 0x3838, "kù"},
    { 0x3839, "jiè"},
    { 0x383A, "shā,miáo"},
    { 0x383C, "sī"},
    { 0x383D, "tóng"},
    { 0x383E, "yuān"},
    { 0x383F, "zī,cǐ"},
    { 0x3840, "bì"},
    { 0x3841, "kuǎ"},
    { 0x3842, "lì"},
    { 0x3843, "huāng"},
    { 0x3844, "xún"},
    { 0x3845, "nuǒ"},
    { 0x3847, "zhé,jiē"},
    { 0x3848, "wèn,mén,miǎn"},
    { 0x3849, "xián"},
    { 0x384A, "qià"},
    { 0x384B, "yé,ān"},
    { 0x384C, "mào"},
    { 0x384F, "shù,xū,tóu,shū"},
    { 0x3851, "qiāo,jiǎo"},
    { 0x3852, "zhūn"},
    { 0x3853, "kūn"},
    { 0x3854, "wù"},
    { 0x3855, "yīng"},
    { 0x3856, "chuáng"},
    { 0x3857, "tí"},
    { 0x3858, "lián,lín"},
    { 0x3859, "bī"},
    { 0x385A, "gōu"},
    { 0x385B, "máng"},
    { 0x385C, "xiè,xuě"},
    { 0x385D, "fèng"},
    { 0x385E, "lóu,lǚ"},
    { 0x385F, "zāo"},
    { 0x3860, "zhèng"},
    { 0x3861, "chú"},
    { 0x3862, "màn"},
    { 0x3863, "lóng"},
    { 0x3865, "yìn"},
    { 0x3866, "pīn"},
    { 0x3867, "zhèng"},
    { 0x3868, "jiān,qiān"},
    { 0x3869, "luán"},
    { 0x386A, "nié"},
    { 0x386B, "yì"},
    { 0x386D, "jì"},
    { 0x386E, "jí"},
    { 0x386F, "zhái,dù,duó"},
    { 0x3870, "yǔ"},
    { 0x3871, "jiǔ"},
    { 0x3872, "huán"},
    { 0x3873, "zhǐ"},
    { 0x3874, "lā"},
    { 0x3875, "líng"},
    { 0x3876, "zhǐ"},
    { 0x3877, "běn"},
    { 0x3878, "zhà,zhǎ,chá"},
    { 0x3879, "jū"},
    { 0x387A, "dàn"},
    { 0x387B, "liào"},
    { 0x387C, "yì"},
    { 0x387D, "zhào"},
    { 0x387E, "xiàn"},
    { 0x387F, "chì"},
    { 0x3880, "cì"},
    { 0x3881, "chǐ,shǐ"},
    { 0x3882, "yǎn,tuí,duī"},
    { 0x3883, "láng"},
    { 0x3884, "dòu"},
    { 0x3885, "lòng"},
    { 0x3886, "chán"},
    { 0x3888, "tuí,duī"},
    { 0x3889, "chá"},
    { 0x388A, "ǎi,yǐ"},
    { 0x388B, "chǐ"},
    { 0x388D, "yǐng"},
    { 0x388E, "zhé"},
    { 0x388F, "tóu,yǔ,yú"},
    { 0x3891, "tuí"},
    { 0x3892, "chá"},
    { 0x3893, "yǎo"},
    { 0x3894, "zǒng"},
    { 0x3896, "pān,bān"},
    { 0x3897, "qiào"},
    { 0x3898, "lián"},
    { 0x3899, "qín"},
    { 0x389A, "lǔ"},
    { 0x389B, "yàn,qiān"},
    { 0x389C, "kāng,kàng"},
    { 0x389D, "sū"},
    { 0x389E, "yì"},
    { 0x389F, "chān"},
    { 0x38A0, "jiǒng"},
    { 0x38A1, "jiǎng"},
    { 0x38A3, "jìng"},
    { 0x38A5, "dòng"},
    { 0x38A7, "juàn"},
    { 0x38A8, "hàn"},
    { 0x38A9, "dì"},
    { 0x38AC, "hóng"},
    { 0x38AE, "chí"},
    { 0x38AF, "diāo,mín"},
    { 0x38B0, "bì"},
    { 0x38B2, "xùn"},
    { 0x38B3, "lú"},
    { 0x38B5, "xié,shè"},
    { 0x38B6, "bì"},
    { 0x38B8, "bì"},
    { 0x38BA, "xián"},
    { 0x38BB, "ruì"},
    { 0x38BC, "biè"},
    { 0x38BD, "ěr"},
    { 0x38BE, "juàn"},
    { 0x38C0, "zhèn"},
    { 0x38C1, "bèi"},
    { 0x38C2, "è"},
    { 0x38C3, "yǔ"},
    { 0x38C4, "qú"},
    { 0x38C5, "zàn"},
    { 0x38C6, "mí"},
    { 0x38C7, "yì"},
    { 0x38C8, "sì"},
    { 0x38CC, "shàn"},
    { 0x38CD, "tái"},
    { 0x38CE, "mù"},
    { 0x38CF, "jìng"},
    { 0x38D0, "biàn"},
    { 0x38D1, "róng"},
    { 0x38D2, "cèng"},
    { 0x38D3, "càn"},
    { 0x38D4, "dīng"},
    { 0x38D9, "dí,zhòu"},
    { 0x38DA, "tǒng,tóng,dòng"},
    { 0x38DB, "tà,huì"},
    { 0x38DC, "xíng"},
    { 0x38DD, "sōng"},
    { 0x38DE, "duó"},
    { 0x38DF, "xì"},
    { 0x38E0, "tāo,tóng"},
    { 0x38E2, "tí"},
    { 0x38E3, "shàn"},
    { 0x38E4, "jiàn"},
    { 0x38E5, "zhì"},
    { 0x38E6, "wēi"},
    { 0x38E7, "yìn"},
    { 0x38EA, "huǎn"},
    { 0x38EB, "zhǒng,dòng"},
    { 0x38EC, "qì"},
    { 0x38ED, "zōng"},
    { 0x38EF, "xiè"},
    { 0x38F0, "xiè"},
    { 0x38F1, "zé"},
    { 0x38F2, "wéi"},
    { 0x38F5, "tà"},
    { 0x38F6, "zhān"},
    { 0x38F7, "nìng"},
    { 0x38FB, "yì"},
    { 0x38FC, "rěn"},
    { 0x38FD, "shù,nù"},
    { 0x38FE, "chà"},
    { 0x38FF, "zhuó,diǎo"},
    { 0x3901, "miǎn"},
    { 0x3902, "jí"},
    { 0x3903, "fáng"},
    { 0x3904, "pèi"},
    { 0x3905, "ài,xì,jì"},
    { 0x3906, "fàn"},
    { 0x3907, "ǎo"},
    { 0x3908, "qìn"},
    { 0x3909, "qiā,yà"},
    { 0x390A, "xiào"},
    { 0x390B, "fēn"},
    { 0x390C, "gān"},
    { 0x390D, "qiāo,qiǎo"},
    { 0x390E, "gē"},
    { 0x390F, "tóng"},
    { 0x3910, "chān"},
    { 0x3911, "yòu"},
    { 0x3912, "gāo"},
    { 0x3913, "bèn"},
    { 0x3914, "fù"},
    { 0x3915, "chù,pò"},
    { 0x3916, "zhù"},
    { 0x3918, "zhòu"},
    { 0x391A, "háng"},
    { 0x391B, "nín"},
    { 0x391C, "jué"},
    { 0x391D, "chōng"},
    { 0x391E, "chà,duó,zé"},
    { 0x391F, "kǒng"},
    { 0x3920, "liè"},
    { 0x3921, "lì,liè"},
    { 0x3922, "yù"},
    { 0x3924, "yú"},
    { 0x3925, "hài"},
    { 0x3926, "lì"},
    { 0x3927, "hóu"},
    { 0x3928, "gǒng"},
    { 0x3929, "kè"},
    { 0x392A, "yuàn"},
    { 0x392B, "dé"},
    { 0x392C, "huì"},
    { 0x392E, "guàng"},
    { 0x392F, "jiǒng"},
    { 0x3930, "zuò"},
    { 0x3931, "fù,dòu"},
    { 0x3932, "qiè"},
    { 0x3933, "běi"},
    { 0x3934, "chè,shè,dié"},
    { 0x3935, "cí"},
    { 0x3936, "máng,màng"},
    { 0x3937, "hān"},
    { 0x3938, "xì"},
    { 0x3939, "qiú,jiù"},
    { 0x393A, "huǎng"},
    { 0x393D, "chóu"},
    { 0x393E, "sàn,tàn"},
    { 0x393F, "yān"},
    { 0x3940, "zhí,dé"},
    { 0x3941, "dé"},
    { 0x3942, "tè"},
    { 0x3943, "mèn"},
    { 0x3944, "líng"},
    { 0x3945, "shòu"},
    { 0x3946, "tuì"},
    { 0x3947, "cán"},
    { 0x3948, "dié"},
    { 0x3949, "chè"},
    { 0x394A, "péng,pēng"},
    { 0x394B, "yī"},
    { 0x394C, "jú"},
    { 0x394D, "jì"},
    { 0x394E, "lái"},
    { 0x394F, "tiǎn"},
    { 0x3950, "yuàn"},
    { 0x3952, "cǎi,cāi"},
    { 0x3953, "qī"},
    { 0x3954, "yù"},
    { 0x3955, "lián"},
    { 0x3956, "cōng"},
    { 0x395A, "yú,yǔ"},
    { 0x395B, "jí,kè"},
    { 0x395C, "wèi"},
    { 0x395D, "mǐ"},
    { 0x395E, "suì"},
    { 0x395F, "xié"},
    { 0x3960, "xū"},
    { 0x3961, "chì"},
    { 0x3962, "qiú,jiū"},
    { 0x3963, "huì"},
    { 0x3965, "yú"},
    { 0x3966, "qiè"},
    { 0x3967, "shùn"},
    { 0x3968, "shuì,wěi"},
    { 0x3969, "duǒ"},
    { 0x396A, "lóu"},
    { 0x396C, "páng"},
    { 0x396D, "tài"},
    { 0x396E, "zhòu,chǎo"},
    { 0x396F, "yǐn"},
    { 0x3970, "sāo"},
    { 0x3971, "fěi"},
    { 0x3972, "chēn,shèn"},
    { 0x3973, "yuán"},
    { 0x3974, "yí,tí"},
    { 0x3975, "hùn"},
    { 0x3976, "sè,qiān"},
    { 0x3977, "yè"},
    { 0x3978, "mǐn"},
    { 0x3979, "fěn"},
    { 0x397A, "hé"},
    { 0x397C, "yìn,yān"},
    { 0x397D, "cè,zé"},
    { 0x397E, "nì"},
    { 0x397F, "ào"},
    { 0x3980, "féng"},
    { 0x3981, "lián,liǎn"},
    { 0x3982, "cháng"},
    { 0x3983, "chǎn"},
    { 0x3984, "má"},
    { 0x3985, "diē,dì,chài"},
    { 0x3986, "hū,xiā"},
    { 0x3987, "lù"},
    { 0x3989, "yì"},
    { 0x398A, "huá"},
    { 0x398B, "zhā"},
    { 0x398C, "hū,xù"},
    { 0x398D, "è"},
    { 0x398E, "huò"},
    { 0x398F, "sǔn,xuàn"},
    { 0x3990, "nì"},
    { 0x3991, "xiàn,hān"},
    { 0x3992, "lí"},
    { 0x3993, "xiàn,rǎn"},
    { 0x3994, "yàn"},
    { 0x3995, "lóng"},
    { 0x3996, "mèn"},
    { 0x3997, "jīn,jìn"},
    { 0x3998, "jī"},
    { 0x399A, "biǎn"},
    { 0x399B, "yǔ,yú"},
    { 0x399C, "huò,xuè"},
    { 0x399D, "miǎo"},
    { 0x399E, "chóu"},
    { 0x399F, "mái"},
    { 0x39A1, "lè"},
    { 0x39A2, "jié"},
    { 0x39A3, "wèi"},
    { 0x39A4, "yì"},
    { 0x39A5, "xuān,xiǎn"},
    { 0x39A6, "xì"},
    { 0x39A7, "cǎn"},
    { 0x39A8, "lán"},
    { 0x39A9, "yǐn"},
    { 0x39AA, "xiè"},
    { 0x39AB, "zā"},
    { 0x39AC, "luǒ"},
    { 0x39AD, "líng"},
    { 0x39AE, "qián"},
    { 0x39AF, "huò"},
    { 0x39B0, "jiān"},
    { 0x39B1, "wǒ"},
    { 0x39B4, "gé"},
    { 0x39B5, "zhū"},
    { 0x39B6, "dié,yǒng"},
    { 0x39B7, "yǒng"},
    { 0x39B8, "jǐ"},
    { 0x39B9, "yáng"},
    { 0x39BA, "rù"},
    { 0x39BB, "xí"},
    { 0x39BC, "shuàng"},
    { 0x39BD, "yù"},
    { 0x39BE, "yí"},
    { 0x39BF, "qiǎn,hù"},
    { 0x39C0, "jí"},
    { 0x39C1, "qù,hé"},
    { 0x39C2, "tián"},
    { 0x39C3, "shōu,jiū"},
    { 0x39C4, "qiǎn"},
    { 0x39C5, "mù,dāo"},
    { 0x39C6, "jīn"},
    { 0x39C7, "mǎo"},
    { 0x39C8, "yǐn"},
    { 0x39C9, "gài,hài,yè"},
    { 0x39CA, "pō,bá"},
    { 0x39CB, "xuǎn"},
    { 0x39CC, "mào"},
    { 0x39CD, "fǎng,bēng"},
    { 0x39CE, "yá,yà,qiā"},
    { 0x39CF, "gāng"},
    { 0x39D0, "sǒng"},
    { 0x39D1, "huī"},
    { 0x39D2, "yù"},
    { 0x39D3, "guā"},
    { 0x39D4, "guài"},
    { 0x39D5, "liǔ"},
    { 0x39D6, "è"},
    { 0x39D7, "zǐ,jǐ,zhǐ"},
    { 0x39D8, "zì"},
    { 0x39D9, "bì,bié"},
    { 0x39DA, "wǎ"},
    { 0x39DC, "liè"},
    { 0x39DF, "kuǎi"},
    { 0x39E1, "hài,wèi"},
    { 0x39E2, "yīn"},
    { 0x39E3, "zhū"},
    { 0x39E4, "chòng"},
    { 0x39E5, "xiǎn"},
    { 0x39E6, "xuàn,hōng"},
    { 0x39E8, "qiú"},
    { 0x39E9, "pèi"},
    { 0x39EA, "guǐ,wěi"},
    { 0x39EB, "ér,ruán,ruí"},
    { 0x39EC, "gǒng"},
    { 0x39ED, "qióng"},
    { 0x39EE, "hū"},
    { 0x39EF, "lǎo"},
    { 0x39F0, "lì"},
    { 0x39F1, "chèn"},
    { 0x39F2, "sǎn"},
    { 0x39F3, "zhuò,bāi"},
    { 0x39F4, "wǒ,é"},
    { 0x39F5, "póu"},
    { 0x39F6, "kēng"},
    { 0x39F7, "tùn"},
    { 0x39F8, "pēng"},
    { 0x39F9, "tè"},
    { 0x39FA, "tà"},
    { 0x39FB, "zhuó,zú,dū"},
    { 0x39FC, "biào"},
    { 0x39FD, "gù"},
    { 0x39FE, "hū"},
    { 0x3A00, "bǐng"},
    { 0x3A01, "zhì,zhí"},
    { 0x3A02, "dǒng"},
    { 0x3A03, "duǐ,chéng"},
    { 0x3A04, "zhōu,zhào,tiáo"},
    { 0x3A05, "nèi,ruì"},
    { 0x3A06, "lǐn"},
    { 0x3A07, "pó"},
    { 0x3A08, "jǐ"},
    { 0x3A09, "mín,wěn"},
    { 0x3A0A, "wěi,tuǒ,duò"},
    { 0x3A0B, "chě"},
    { 0x3A0C, "gòu"},
    { 0x3A0D, "bāng"},
    { 0x3A0E, "rú"},
    { 0x3A0F, "tān"},
    { 0x3A10, "bǔ"},
    { 0x3A11, "zōng"},
    { 0x3A12, "kuī"},
    { 0x3A13, "láo"},
    { 0x3A14, "hàn"},
    { 0x3A15, "yíng"},
    { 0x3A16, "zhì"},
    { 0x3A17, "jié"},
    { 0x3A18, "xǐng"},
    { 0x3A19, "xié,xì"},
    { 0x3A1A, "xún,sǔn"},
    { 0x3A1B, "shǎn,shàn"},
    { 0x3A1C, "qián"},
    { 0x3A1D, "xiē"},
    { 0x3A1E, "sù"},
    { 0x3A1F, "hāi"},
    { 0x3A20, "mì"},
    { 0x3A21, "hún"},
    { 0x3A22, "pī"},
    { 0x3A24, "huì"},
    { 0x3A25, "nà"},
    { 0x3A26, "sǒng"},
    { 0x3A27, "bèn"},
    { 0x3A28, "chōu,liù"},
    { 0x3A29, "jié"},
    { 0x3A2A, "huàng,huǎng"},
    { 0x3A2B, "lǎn"},
    { 0x3A2D, "hù"},
    { 0x3A2E, "dōu"},
    { 0x3A2F, "huò"},
    { 0x3A30, "gǔn"},
    { 0x3A31, "yáo"},
    { 0x3A32, "cè"},
    { 0x3A33, "guǐ,jì"},
    { 0x3A34, "jiàn"},
    { 0x3A35, "jiǎn"},
    { 0x3A36, "dǎo"},
    { 0x3A37, "jìn"},
    { 0x3A38, "mà"},
    { 0x3A39, "huì,xuě"},
    { 0x3A3A, "miǎn,mén"},
    { 0x3A3B, "cán,shǎn,zàn,chàn"},
    { 0x3A3C, "lüè"},
    { 0x3A3D, "pì"},
    { 0x3A3E, "yàng"},
    { 0x3A3F, "jù"},
    { 0x3A40, "jù"},
    { 0x3A41, "què"},
    { 0x3A43, "qiān"},
    { 0x3A44, "shāi"},
    { 0x3A46, "jiù,zú"},
    { 0x3A47, "huò,zuó,huá"},
    { 0x3A48, "yǔn"},
    { 0x3A49, "dá,lā,xī,xié"},
    { 0x3A4A, "xuān"},
    { 0x3A4B, "xiāo,sù"},
    { 0x3A4C, "fèi"},
    { 0x3A4D, "cè"},
    { 0x3A4E, "yè"},
    { 0x3A50, "dèn"},
    { 0x3A52, "qín"},
    { 0x3A53, "huǐ"},
    { 0x3A54, "tún"},
    { 0x3A56, "qiáng"},
    { 0x3A57, "xí"},
    { 0x3A58, "nǐ"},
    { 0x3A59, "sāi"},
    { 0x3A5A, "méng"},
    { 0x3A5B, "tuán"},
    { 0x3A5C, "lǎn"},
    { 0x3A5D, "háo"},
    { 0x3A5E, "cì"},
    { 0x3A5F, "zhài"},
    { 0x3A60, "āo,piǎo,póu"},
    { 0x3A61, "luǒ"},
    { 0x3A62, "miè,mì"},
    { 0x3A64, "fū"},
    { 0x3A66, "xié,xī"},
    { 0x3A67, "bó"},
    { 0x3A68, "huì"},
    { 0x3A69, "qǐng"},
    { 0x3A6A, "xié"},
    { 0x3A6D, "bó"},
    { 0x3A6E, "qián"},
    { 0x3A6F, "pó"},
    { 0x3A70, "jiǎo"},
    { 0x3A71, "jué"},
    { 0x3A72, "kǔn"},
    { 0x3A73, "sǒng"},
    { 0x3A74, "jú,qú"},
    { 0x3A75, "è"},
    { 0x3A76, "niè"},
    { 0x3A77, "qiān"},
    { 0x3A78, "dié"},
    { 0x3A79, "dié"},
    { 0x3A7B, "qī,guì,guǐ"},
    { 0x3A7C, "zhī"},
    { 0x3A7D, "qí,chì,è"},
    { 0x3A7E, "zhuì,qí"},
    { 0x3A7F, "kū"},
    { 0x3A80, "yú"},
    { 0x3A81, "qín,kān,qiàn,qián"},
    { 0x3A82, "kū"},
    { 0x3A83, "hé"},
    { 0x3A84, "fú"},
    { 0x3A86, "dǐ"},
    { 0x3A87, "xiàn"},
    { 0x3A88, "guì"},
    { 0x3A89, "hé"},
    { 0x3A8A, "qún"},
    { 0x3A8B, "hàn,hě"},
    { 0x3A8C, "tǒng"},
    { 0x3A8D, "bó,bèi"},
    { 0x3A8E, "shǎn,nà"},
    { 0x3A8F, "bǐ"},
    { 0x3A90, "lù"},
    { 0x3A91, "yè"},
    { 0x3A92, "ní"},
    { 0x3A93, "chuái"},
    { 0x3A94, "sàn"},
    { 0x3A95, "diào,chuò"},
    { 0x3A96, "lù"},
    { 0x3A97, "tǒu"},
    { 0x3A98, "liǎn"},
    { 0x3A99, "kě"},
    { 0x3A9A, "sàn"},
    { 0x3A9B, "zhěn"},
    { 0x3A9C, "chuǎi,duǒ"},
    { 0x3A9D, "liàn"},
    { 0x3A9E, "mào"},
    { 0x3AA0, "qiān,qiàn,jiān"},
    { 0x3AA1, "kài,kě"},
    { 0x3AA2, "shǎo"},
    { 0x3AA3, "xiāo,qiāo"},
    { 0x3AA4, "bì"},
    { 0x3AA5, "zhā"},
    { 0x3AA6, "yìn"},
    { 0x3AA7, "xī"},
    { 0x3AA8, "shàn"},
    { 0x3AA9, "sù"},
    { 0x3AAA, "sà"},
    { 0x3AAB, "ruì"},
    { 0x3AAC, "chuō,zhuó"},
    { 0x3AAD, "lú"},
    { 0x3AAE, "líng"},
    { 0x3AAF, "chá"},
    { 0x3AB1, "huàn"},
    { 0x3AB4, "jiá"},
    { 0x3AB5, "bàn"},
    { 0x3AB6, "hú"},
    { 0x3AB7, "dǒu"},
    { 0x3AB9, "lǒu"},
    { 0x3ABA, "jū"},
    { 0x3ABB, "juàn"},
    { 0x3ABC, "kě"},
    { 0x3ABD, "suǒ"},
    { 0x3ABE, "luò,gé"},
    { 0x3ABF, "zhé"},
    { 0x3AC0, "dǐng"},
    { 0x3AC1, "duàn"},
    { 0x3AC2, "zhù"},
    { 0x3AC3, "yǎn"},
    { 0x3AC4, "páng"},
    { 0x3AC5, "chá"},
    { 0x3ACA, "yǐ,ě"},
    { 0x3ACD, "yóu,yǎo"},
    { 0x3ACE, "huī,gǔn"},
    { 0x3ACF, "yǎo"},
    { 0x3AD0, "yǎo"},
    { 0x3AD1, "zhǐ,shí"},
    { 0x3AD2, "gǒng"},
    { 0x3AD3, "qǐ"},
    { 0x3AD4, "gèn"},
    { 0x3AD7, "hòu"},
    { 0x3AD8, "mì"},
    { 0x3AD9, "fú"},
    { 0x3ADA, "hū"},
    { 0x3ADB, "guàng"},
    { 0x3ADC, "tǎn"},
    { 0x3ADD, "dī"},
    { 0x3ADF, "yán"},
    { 0x3AE2, "qù"},
    { 0x3AE4, "chǎng"},
    { 0x3AE5, "mǐng"},
    { 0x3AE6, "tāo"},
    { 0x3AE7, "bào"},
    { 0x3AE8, "ān"},
    { 0x3AEB, "xiǎn"},
    { 0x3AEF, "mào"},
    { 0x3AF0, "làng,lǎng"},
    { 0x3AF1, "nǎn,nàn"},
    { 0x3AF2, "bèi"},
    { 0x3AF3, "chén"},
    { 0x3AF5, "fēi"},
    { 0x3AF6, "zhǒu"},
    { 0x3AF7, "jī"},
    { 0x3AF8, "jiē"},
    { 0x3AF9, "shù"},
    { 0x3AFB, "kùn"},
    { 0x3AFC, "dié"},
    { 0x3AFD, "lù"},
    { 0x3B02, "yú"},
    { 0x3B03, "tái"},
    { 0x3B04, "chàn"},
    { 0x3B05, "màn"},
    { 0x3B06, "mǐn"},
    { 0x3B07, "huàn"},
    { 0x3B08, "wēn"},
    { 0x3B09, "nuǎn"},
    { 0x3B0A, "huàn,huǎn"},
    { 0x3B0B, "hóu"},
    { 0x3B0C, "jìng"},
    { 0x3B0D, "bó"},
    { 0x3B0E, "xiǎn"},
    { 0x3B0F, "lì"},
    { 0x3B10, "jìn,zī"},
    { 0x3B12, "mǎng"},
    { 0x3B13, "piào"},
    { 0x3B14, "háo"},
    { 0x3B15, "yáng"},
    { 0x3B17, "xiàn"},
    { 0x3B18, "sù"},
    { 0x3B19, "wěi"},
    { 0x3B1A, "chè"},
    { 0x3B1B, "xī"},
    { 0x3B1C, "jìn"},
    { 0x3B1D, "céng,sōng"},
    { 0x3B1E, "hè"},
    { 0x3B1F, "fēn"},
    { 0x3B20, "shài,shà"},
    { 0x3B21, "líng"},
    { 0x3B23, "duì"},
    { 0x3B24, "qī"},
    { 0x3B25, "pù,bó"},
    { 0x3B26, "yuè"},
    { 0x3B27, "bó"},
    { 0x3B29, "huì"},
    { 0x3B2A, "dié"},
    { 0x3B2B, "yàn"},
    { 0x3B2C, "jù"},
    { 0x3B2D, "jiào"},
    { 0x3B2E, "nàn"},
    { 0x3B2F, "liè"},
    { 0x3B30, "yú"},
    { 0x3B31, "tì"},
    { 0x3B32, "tiān"},
    { 0x3B33, "wǔ"},
    { 0x3B34, "hǒng"},
    { 0x3B35, "xiáo"},
    { 0x3B36, "hào"},
    { 0x3B38, "tiāo"},
    { 0x3B39, "zhēng"},
    { 0x3B3B, "huāng,hāng,huǎng"},
    { 0x3B3C, "fù"},
    { 0x3B3F, "tūn"},
    { 0x3B41, "réng"},
    { 0x3B42, "jiǎo"},
    { 0x3B44, "xìn"},
    { 0x3B47, "yuàn"},
    { 0x3B48, "jué"},
    { 0x3B49, "huá"},
    { 0x3B4B, "bàng"},
    { 0x3B4C, "móu"},
    { 0x3B4E, "gāng"},
    { 0x3B4F, "wěi"},
    { 0x3B51, "mèi"},
    { 0x3B52, "sì"},
    { 0x3B53, "biàn"},
    { 0x3B54, "lú"},
    { 0x3B55, "qū"},
    { 0x3B58, "gé,hé"},
    { 0x3B59, "zhé"},
    { 0x3B5A, "lǚ"},
    { 0x3B5B, "pài,bà"},
    { 0x3B5C, "róng"},
    { 0x3B5D, "qiú,òu"},
    { 0x3B5E, "liè"},
    { 0x3B5F, "gǒng"},
    { 0x3B60, "xiǎn"},
    { 0x3B61, "xì,xìn"},
    { 0x3B62, "xīn"},
    { 0x3B64, "niǎo"},
    { 0x3B68, "xié"},
    { 0x3B69, "liè"},
    { 0x3B6A, "fū"},
    { 0x3B6B, "cuó,cuán"},
    { 0x3B6C, "zhuó"},
    { 0x3B6D, "bā,bèi,biē"},
    { 0x3B6E, "zuò,zǎn"},
    { 0x3B6F, "zhé,dié"},
    { 0x3B70, "zuī,zuǐ"},
    { 0x3B71, "hé"},
    { 0x3B72, "jí"},
    { 0x3B74, "jiān"},
    { 0x3B78, "tú"},
    { 0x3B79, "xián"},
    { 0x3B7A, "yǎn,yàn,ān"},
    { 0x3B7B, "táng"},
    { 0x3B7C, "tà"},
    { 0x3B7D, "dǐ"},
    { 0x3B7E, "jué"},
    { 0x3B7F, "áng"},
    { 0x3B80, "hán"},
    { 0x3B81, "xiáo"},
    { 0x3B82, "jú"},
    { 0x3B83, "wēi,ruí"},
    { 0x3B84, "bǎng"},
    { 0x3B85, "zhuī"},
    { 0x3B86, "niè"},
    { 0x3B87, "tiàn"},
    { 0x3B88, "nài"},
    { 0x3B8B, "yǒu"},
    { 0x3B8C, "mián"},
    { 0x3B8F, "nài,nì,nà"},
    { 0x3B90, "shěng,sì"},
    { 0x3B91, "chā,qì"},
    { 0x3B92, "yān,yīn"},
    { 0x3B93, "gèn"},
    { 0x3B94, "chòng,tóng"},
    { 0x3B95, "ruǎn"},
    { 0x3B96, "jiá"},
    { 0x3B97, "qín"},
    { 0x3B98, "máo"},
    { 0x3B99, "è"},
    { 0x3B9A, "lì"},
    { 0x3B9B, "chí,yí"},
    { 0x3B9C, "zāng"},
    { 0x3B9D, "hé"},
    { 0x3B9E, "jié"},
    { 0x3B9F, "niǎn,kā"},
    { 0x3BA1, "guàn"},
    { 0x3BA2, "hóu"},
    { 0x3BA3, "gài"},
    { 0x3BA5, "bèn,fàn"},
    { 0x3BA6, "suǒ,sè"},
    { 0x3BA7, "wū,wēn"},
    { 0x3BA8, "jì"},
    { 0x3BA9, "xī"},
    { 0x3BAA, "qióng"},
    { 0x3BAB, "hé,xiá,qià"},
    { 0x3BAC, "wēng"},
    { 0x3BAD, "xián"},
    { 0x3BAE, "jié"},
    { 0x3BAF, "hún,huá"},
    { 0x3BB0, "pí"},
    { 0x3BB1, "shēn"},
    { 0x3BB2, "chōu"},
    { 0x3BB3, "zhèn"},
    { 0x3BB5, "zhān"},
    { 0x3BB6, "shuò"},
    { 0x3BB7, "jī"},
    { 0x3BB8, "sòng"},
    { 0x3BB9, "zhǐ"},
    { 0x3BBA, "běn"},
    { 0x3BBE, "lǎng"},
    { 0x3BBF, "bì"},
    { 0x3BC0, "xuàn"},
    { 0x3BC1, "péi"},
    { 0x3BC2, "dài"},
    { 0x3BC4, "zhī"},
    { 0x3BC5, "pí,bī"},
    { 0x3BC6, "chǎn,shàn"},
    { 0x3BC7, "bì"},
    { 0x3BC8, "sù"},
    { 0x3BC9, "huò"},
    { 0x3BCA, "hén"},
    { 0x3BCB, "jiǒng,yǐng"},
    { 0x3BCC, "chuán"},
    { 0x3BCD, "jiǎng"},
    { 0x3BCE, "nèn"},
    { 0x3BCF, "gǔ"},
    { 0x3BD0, "fǎng"},
    { 0x3BD3, "tà,dá"},
    { 0x3BD4, "cuì"},
    { 0x3BD5, "xī"},
    { 0x3BD6, "dé"},
    { 0x3BD7, "xián"},
    { 0x3BD8, "kuǎn"},
    { 0x3BD9, "zhé"},
    { 0x3BDA, "tā"},
    { 0x3BDB, "hú"},
    { 0x3BDC, "cuì"},
    { 0x3BDD, "lù"},
    { 0x3BDE, "juàn"},
    { 0x3BDF, "lù"},
    { 0x3BE0, "qiàn"},
    { 0x3BE1, "pào,páo"},
    { 0x3BE2, "zhèn"},
    { 0x3BE4, "lì"},
    { 0x3BE5, "cáo,zāo"},
    { 0x3BE6, "qí"},
    { 0x3BE9, "tì"},
    { 0x3BEA, "líng"},
    { 0x3BEB, "qú"},
    { 0x3BEC, "liǎn"},
    { 0x3BED, "lǔ"},
    { 0x3BEE, "shú"},
    { 0x3BEF, "gòng,dǎn,jù"},
    { 0x3BF0, "zhé"},
    { 0x3BF1, "pāo"},
    { 0x3BF2, "jìn"},
    { 0x3BF3, "qíng"},
    { 0x3BF6, "zōng"},
    { 0x3BF7, "pú"},
    { 0x3BF8, "jǐn"},
    { 0x3BF9, "biǎo"},
    { 0x3BFA, "jiàn"},
    { 0x3BFB, "gǔn"},
    { 0x3BFE, "zāo"},
    { 0x3BFF, "liè,là"},
    { 0x3C00, "lí"},
    { 0x3C01, "luǒ"},
    { 0x3C02, "shěn"},
    { 0x3C03, "mián,miàn"},
    { 0x3C04, "jiàn"},
    { 0x3C05, "dí,zhé"},
    { 0x3C06, "bèi"},
    { 0x3C08, "liǎn"},
    { 0x3C0A, "xián"},
    { 0x3C0B, "pín"},
    { 0x3C0C, "què"},
    { 0x3C0D, "lóng"},
    { 0x3C0E, "zuì"},
    { 0x3C10, "jué"},
    { 0x3C11, "shān"},
    { 0x3C12, "xué"},
    { 0x3C14, "xiè"},
    { 0x3C16, "lǎn"},
    { 0x3C17, "qí"},
    { 0x3C18, "yí"},
    { 0x3C19, "nuó"},
    { 0x3C1A, "lí"},
    { 0x3C1B, "yuè"},
    { 0x3C1D, "yǐ"},
    { 0x3C1E, "chī"},
    { 0x3C1F, "jì,qì"},
    { 0x3C20, "hāng"},
    { 0x3C21, "xiè"},
    { 0x3C22, "kēng"},
    { 0x3C23, "zī"},
    { 0x3C24, "hē,qiè"},
    { 0x3C25, "xì,huì"},
    { 0x3C26, "qù"},
    { 0x3C27, "hāi"},
    { 0x3C28, "xiā"},
    { 0x3C29, "hāi"},
    { 0x3C2A, "guī"},
    { 0x3C2B, "chān"},
    { 0x3C2C, "xún"},
    { 0x3C2D, "xū"},
    { 0x3C2E, "shèn"},
    { 0x3C2F, "kòu,tòu,tǒu,hòu"},
    { 0x3C30, "xiā,qiè,hē"},
    { 0x3C31, "shà"},
    { 0x3C32, "yū,xù"},
    { 0x3C33, "yà,yā"},
    { 0x3C34, "pǒu"},
    { 0x3C35, "zú"},
    { 0x3C36, "yǒu,ǒu"},
    { 0x3C37, "zì"},
    { 0x3C38, "liǎn"},
    { 0x3C39, "xiān,xiàn,hǎn"},
    { 0x3C3A, "xià,xiá"},
    { 0x3C3B, "yǐ,xī,hòu"},
    { 0x3C3C, "shà,qiè"},
    { 0x3C3D, "yàn"},
    { 0x3C3E, "jiào"},
    { 0x3C3F, "xī"},
    { 0x3C40, "chǐ"},
    { 0x3C41, "shì,kuǎn"},
    { 0x3C42, "kāng"},
    { 0x3C43, "yǐn"},
    { 0x3C44, "hēi,mò"},
    { 0x3C45, "yì"},
    { 0x3C46, "xī"},
    { 0x3C47, "sè,xì"},
    { 0x3C48, "jìn"},
    { 0x3C49, "yè"},
    { 0x3C4A, "yōu"},
    { 0x3C4B, "què"},
    { 0x3C4C, "yé,chè"},
    { 0x3C4D, "luán"},
    { 0x3C4E, "kūn"},
    { 0x3C4F, "zhèng"},
    { 0x3C54, "xiē"},
    { 0x3C56, "cuì"},
    { 0x3C57, "xiū"},
    { 0x3C58, "àn"},
    { 0x3C59, "xiǔ,guǎ"},
    { 0x3C5A, "cán"},
    { 0x3C5B, "chuǎn,bù"},
    { 0x3C5C, "zhá"},
    { 0x3C5E, "yì,lā"},
    { 0x3C5F, "pī,pǐ"},
    { 0x3C60, "kū,gū"},
    { 0x3C61, "shēng"},
    { 0x3C62, "láng"},
    { 0x3C63, "tuǐ"},
    { 0x3C64, "xī"},
    { 0x3C65, "líng,lèng"},
    { 0x3C66, "qī"},
    { 0x3C67, "wò,yuǎn"},
    { 0x3C68, "liàn"},
    { 0x3C69, "dú"},
    { 0x3C6A, "mèn"},
    { 0x3C6B, "làn"},
    { 0x3C6C, "wěi"},
    { 0x3C6D, "duàn"},
    { 0x3C6E, "kuài"},
    { 0x3C6F, "ái"},
    { 0x3C70, "zǎi"},
    { 0x3C71, "huì"},
    { 0x3C72, "yì"},
    { 0x3C73, "mò"},
    { 0x3C74, "zì"},
    { 0x3C75, "fèn"},
    { 0x3C76, "péng,bēng"},
    { 0x3C78, "bì"},
    { 0x3C79, "lì"},
    { 0x3C7A, "lú"},
    { 0x3C7B, "luò"},
    { 0x3C7C, "hāi"},
    { 0x3C7D, "zhěn,qín"},
    { 0x3C7E, "gāi,kāi"},
    { 0x3C7F, "què,hù,qiǎng"},
    { 0x3C80, "zhēn,chēn"},
    { 0x3C81, "kōng,zhōng"},
    { 0x3C82, "chéng"},
    { 0x3C83, "jiù"},
    { 0x3C84, "jué,kū"},
    { 0x3C85, "jì"},
    { 0x3C86, "líng"},
    { 0x3C88, "sháo,táo"},
    { 0x3C89, "què"},
    { 0x3C8A, "ruì"},
    { 0x3C8B, "chuò"},
    { 0x3C8C, "nèng"},
    { 0x3C8D, "zhī"},
    { 0x3C8E, "lóu"},
    { 0x3C8F, "pāo"},
    { 0x3C92, "bào,qú"},
    { 0x3C93, "róng,shù"},
    { 0x3C94, "xiān"},
    { 0x3C95, "lèi"},
    { 0x3C96, "xiāo"},
    { 0x3C97, "fū"},
    { 0x3C98, "qú"},
    { 0x3C9A, "shā"},
    { 0x3C9B, "zhǐ"},
    { 0x3C9C, "tán"},
    { 0x3C9D, "rǒng"},
    { 0x3C9E, "sū,zú"},
    { 0x3C9F, "yǐng"},
    { 0x3CA0, "máo"},
    { 0x3CA1, "nài"},
    { 0x3CA2, "biàn"},
    { 0x3CA4, "shuāi"},
    { 0x3CA5, "táng"},
    { 0x3CA6, "hàn"},
    { 0x3CA7, "sào"},
    { 0x3CA8, "róng"},
    { 0x3CAA, "dēng"},
    { 0x3CAB, "pú"},
    { 0x3CAC, "jiāo"},
    { 0x3CAD, "tǎn"},
    { 0x3CAF, "rán"},
    { 0x3CB0, "níng"},
    { 0x3CB1, "liè"},
    { 0x3CB2, "dié"},
    { 0x3CB3, "dié,zhì"},
    { 0x3CB4, "zhòng"},
    { 0x3CB6, "lǜ"},
    { 0x3CB7, "dàn"},
    { 0x3CB8, "xī"},
    { 0x3CB9, "guǐ"},
    { 0x3CBA, "jí"},
    { 0x3CBB, "nì"},
    { 0x3CBC, "yì,chà"},
    { 0x3CBD, "niàn,rěn"},
    { 0x3CBE, "yǔ"},
    { 0x3CBF, "wǎng"},
    { 0x3CC0, "guò"},
    { 0x3CC1, "zè"},
    { 0x3CC2, "yán,yàn"},
    { 0x3CC3, "cuì"},
    { 0x3CC4, "xián"},
    { 0x3CC5, "jiǎo"},
    { 0x3CC6, "tǒu"},
    { 0x3CC7, "fù"},
    { 0x3CC8, "pèi"},
    { 0x3CCA, "yōu,zhōng"},
    { 0x3CCB, "qiū"},
    { 0x3CCC, "yā"},
    { 0x3CCD, "bù"},
    { 0x3CCE, "biàn"},
    { 0x3CCF, "shì"},
    { 0x3CD0, "zhá"},
    { 0x3CD1, "yì"},
    { 0x3CD2, "biàn"},
    { 0x3CD4, "duì"},
    { 0x3CD5, "lán"},
    { 0x3CD6, "yī"},
    { 0x3CD7, "chài,chà"},
    { 0x3CD8, "chōng"},
    { 0x3CD9, "xuàn"},
    { 0x3CDA, "xù"},
    { 0x3CDB, "yú,yóu"},
    { 0x3CDC, "xiū"},
    { 0x3CE0, "tà"},
    { 0x3CE1, "guō"},
    { 0x3CE5, "lòng"},
    { 0x3CE6, "xiè"},
    { 0x3CE7, "chè,rè"},
    { 0x3CE8, "jiǎn"},
    { 0x3CE9, "tān"},
    { 0x3CEA, "pì"},
    { 0x3CEB, "zǎn"},
    { 0x3CEC, "xuán"},
    { 0x3CED, "xián"},
    { 0x3CEE, "niào"},
    { 0x3CF4, "mì"},
    { 0x3CF5, "jì"},
    { 0x3CF6, "nǒu,rǔ"},
    { 0x3CF7, "hū,mǐn,wěn,tuì"},
    { 0x3CF8, "huā"},
    { 0x3CF9, "wǎng,wāng"},
    { 0x3CFA, "yóu"},
    { 0x3CFB, "zé"},
    { 0x3CFC, "bì,yù"},
    { 0x3CFD, "mǐ"},
    { 0x3CFE, "qiāng"},
    { 0x3CFF, "xiè"},
    { 0x3D00, "fàn,fān"},
    { 0x3D01, "yì"},
    { 0x3D02, "tān"},
    { 0x3D03, "lèi"},
    { 0x3D04, "yǒng"},
    { 0x3D06, "jìn"},
    { 0x3D07, "shè,máng"},
    { 0x3D08, "yìn"},
    { 0x3D09, "jǐ"},
    { 0x3D0B, "sù"},
    { 0x3D0E, "nài"},
    { 0x3D0F, "wǎng"},
    { 0x3D10, "miàn,miǎn"},
    { 0x3D11, "sù"},
    { 0x3D12, "yì"},
    { 0x3D13, "shāi"},
    { 0x3D14, "xī,yì,sè"},
    { 0x3D15, "jí"},
    { 0x3D16, "luò"},
    { 0x3D17, "yōu"},
    { 0x3D18, "mào"},
    { 0x3D19, "zhǎ,zhá"},
    { 0x3D1A, "suì"},
    { 0x3D1B, "zhì"},
    { 0x3D1C, "biàn"},
    { 0x3D1D, "lí"},
    { 0x3D25, "qiào"},
    { 0x3D26, "guàn"},
    { 0x3D27, "xī"},
    { 0x3D28, "zhèn"},
    { 0x3D29, "yōng"},
    { 0x3D2A, "niè"},
    { 0x3D2B, "jùn,yá"},
    { 0x3D2C, "xiè"},
    { 0x3D2D, "yǎo"},
    { 0x3D2E, "xiè"},
    { 0x3D2F, "zhī"},
    { 0x3D30, "néng"},
    { 0x3D32, "sī"},
    { 0x3D33, "lǒng"},
    { 0x3D34, "chén"},
    { 0x3D35, "mì"},
    { 0x3D36, "què,hú"},
    { 0x3D37, "dān"},
    { 0x3D38, "shǎn"},
    { 0x3D3C, "sù"},
    { 0x3D3D, "xiè"},
    { 0x3D3E, "bó"},
    { 0x3D3F, "dǐng"},
    { 0x3D40, "zú"},
    { 0x3D42, "shù"},
    { 0x3D43, "shé"},
    { 0x3D44, "hàn,yù"},
    { 0x3D45, "tān,tàn"},
    { 0x3D46, "gǎo"},
    { 0x3D4A, "nà"},
    { 0x3D4B, "mì"},
    { 0x3D4C, "xún"},
    { 0x3D4D, "mèn"},
    { 0x3D4E, "jiàn"},
    { 0x3D4F, "cuǐ"},
    { 0x3D50, "jué"},
    { 0x3D51, "hè"},
    { 0x3D52, "fèi,pài,bì"},
    { 0x3D53, "shí"},
    { 0x3D54, "chě"},
    { 0x3D55, "shèn"},
    { 0x3D56, "nǜ"},
    { 0x3D57, "píng"},
    { 0x3D58, "màn"},
    { 0x3D5D, "yì"},
    { 0x3D5E, "chóu"},
    { 0x3D60, "kū"},
    { 0x3D61, "báo"},
    { 0x3D62, "léi"},
    { 0x3D63, "kě"},
    { 0x3D64, "shà"},
    { 0x3D65, "bì"},
    { 0x3D66, "suí"},
    { 0x3D67, "gé,yì"},
    { 0x3D68, "pì,bó"},
    { 0x3D69, "yì"},
    { 0x3D6A, "xián,yàn,yán"},
    { 0x3D6B, "nì"},
    { 0x3D6C, "yíng"}
};
