/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     chenhaifeng  <chenhaifeng@uniontech.com>
*
* Maintainer: chenhaifeng  <chenhaifeng@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "pinyindict.h"

QMap<int, QString> PinyinDict_4{
    { 0x4EEB, "mù"},
    { 0x4EEC, "men"},
    { 0x4EED, "rèn"},
    { 0x4EEE, "fǎn"},
    { 0x4EEF, "chào,miǎo"},
    { 0x4EF0, "yǎng,áng"},
    { 0x4EF1, "qián,jīng"},
    { 0x4EF2, "zhòng"},
    { 0x4EF3, "pǐ,pí,bì"},
    { 0x4EF4, "wò"},
    { 0x4EF5, "wǔ"},
    { 0x4EF6, "jiàn,móu"},
    { 0x4EF7, "jià,jiè,jie"},
    { 0x4EF8, "yǎo,fó"},
    { 0x4EF9, "fēng"},
    { 0x4EFA, "cāng"},
    { 0x4EFB, "rèn,rén,lìn"},
    { 0x4EFC, "wáng"},
    { 0x4EFD, "fèn,bīn"},
    { 0x4EFE, "dī"},
    { 0x4EFF, "fǎng,páng"},
    { 0x4F00, "zhōng"},
    { 0x4F01, "qǐ"},
    { 0x4F02, "pèi"},
    { 0x4F03, "yú,yǔ,xù"},
    { 0x4F04, "diào"},
    { 0x4F05, "dùn"},
    { 0x4F06, "wù"},
    { 0x4F07, "yì"},
    { 0x4F08, "xǐn,lǐn"},
    { 0x4F09, "kàng,gāng,kǎng"},
    { 0x4F0A, "yī"},
    { 0x4F0B, "jí,fán"},
    { 0x4F0C, "ài"},
    { 0x4F0D, "wǔ"},
    { 0x4F0E, "jì,zhì,qí,qì"},
    { 0x4F0F, "fú,fù"},
    { 0x4F10, "fá"},
    { 0x4F11, "xiū,xù"},
    { 0x4F12, "jìn,yín"},
    { 0x4F13, "pī"},
    { 0x4F14, "dǎn"},
    { 0x4F15, "fū"},
    { 0x4F16, "tǎng"},
    { 0x4F17, "zhòng,yín"},
    { 0x4F18, "yōu,yóu"},
    { 0x4F19, "huǒ,huo"},
    { 0x4F1A, "huì,kuài"},
    { 0x4F1B, "yǔ"},
    { 0x4F1C, "cuì"},
    { 0x4F1D, "yún"},
    { 0x4F1E, "sǎn"},
    { 0x4F1F, "wěi"},
    { 0x4F20, "chuán,zhuàn"},
    { 0x4F21, "chē"},
    { 0x4F22, "yá"},
    { 0x4F23, "qiàn,xiàn"},
    { 0x4F24, "shāng"},
    { 0x4F25, "chāng"},
    { 0x4F26, "lún"},
    { 0x4F27, "cāng,chen"},
    { 0x4F28, "xùn"},
    { 0x4F29, "xìn"},
    { 0x4F2A, "wěi"},
    { 0x4F2B, "zhù"},
    { 0x4F2C, "ze"},
    { 0x4F2D, "xián"},
    { 0x4F2E, "nǔ"},
    { 0x4F2F, "bó,mò,bà,bǎi"},
    { 0x4F30, "gū,gù"},
    { 0x4F31, "nǐ"},
    { 0x4F32, "nì,nǐ"},
    { 0x4F33, "xiè"},
    { 0x4F34, "bàn,pàn"},
    { 0x4F35, "xù"},
    { 0x4F36, "líng"},
    { 0x4F37, "zhòu"},
    { 0x4F38, "shēn"},
    { 0x4F39, "qū,zù"},
    { 0x4F3A, "cì,sì"},
    { 0x4F3B, "bēng"},
    { 0x4F3C, "shì,sì"},
    { 0x4F3D, "gā,jiā,qié"},
    { 0x4F3E, "pī"},
    { 0x4F3F, "yì"},
    { 0x4F40, "sì"},
    { 0x4F41, "yǐ,ǎi,sì,chì"},
    { 0x4F42, "zhēng"},
    { 0x4F43, "diàn,tián"},
    { 0x4F44, "hān,gàn"},
    { 0x4F45, "mài"},
    { 0x4F46, "dàn,tǎn,yàn"},
    { 0x4F47, "zhù"},
    { 0x4F48, "bù"},
    { 0x4F49, "qū,qiā"},
    { 0x4F4A, "bǐ"},
    { 0x4F4B, "zhāo,sháo,shào"},
    { 0x4F4C, "cǐ"},
    { 0x4F4D, "wèi,lì"},
    { 0x4F4E, "dī"},
    { 0x4F4F, "zhù"},
    { 0x4F50, "zuǒ"},
    { 0x4F51, "yòu"},
    { 0x4F52, "yǎng,yāng"},
    { 0x4F53, "tǐ,bèn,cuì,tī"},
    { 0x4F54, "zhàn,chān,diān"},
    { 0x4F55, "hé,hè"},
    { 0x4F56, "bì"},
    { 0x4F57, "tuó,tuō,tuò,yí"},
    { 0x4F58, "shé"},
    { 0x4F59, "yú,tú,xú,yù"},
    { 0x4F5A, "yì,dié"},
    { 0x4F5B, "fú,bó,bì,fó"},
    { 0x4F5C, "zuò,zuō,zuó"},
    { 0x4F5D, "gōu,kòu,jū"},
    { 0x4F5E, "nìng"},
    { 0x4F5F, "tóng"},
    { 0x4F60, "nǐ"},
    { 0x4F61, "xiān"},
    { 0x4F62, "qú"},
    { 0x4F63, "yōng,yòng"},
    { 0x4F64, "wǎ"},
    { 0x4F65, "qiān"},
    { 0x4F66, "shi"},
    { 0x4F67, "kǎ"},
    { 0x4F68, "bāo"},
    { 0x4F69, "pèi"},
    { 0x4F6A, "huí,huái"},
    { 0x4F6B, "hè,gé"},
    { 0x4F6C, "lǎo,liáo"},
    { 0x4F6D, "xiáng"},
    { 0x4F6E, "gé,é"},
    { 0x4F6F, "yáng"},
    { 0x4F70, "bǎi,mò"},
    { 0x4F71, "fǎ"},
    { 0x4F72, "mǐng"},
    { 0x4F73, "jiā"},
    { 0x4F74, "èr,nài"},
    { 0x4F75, "bìng"},
    { 0x4F76, "jí"},
    { 0x4F77, "hěn,héng"},
    { 0x4F78, "huó"},
    { 0x4F79, "guǐ,guī"},
    { 0x4F7A, "quán"},
    { 0x4F7B, "tiāo,tiáo,tiào,diǎo,yáo,dào,zhào"},
    { 0x4F7C, "jiǎo,jiāo,xiáo"},
    { 0x4F7D, "cì"},
    { 0x4F7E, "yì"},
    { 0x4F7F, "shǐ"},
    { 0x4F80, "xíng"},
    { 0x4F81, "shēn"},
    { 0x4F82, "tuō"},
    { 0x4F83, "kǎn"},
    { 0x4F84, "zhí"},
    { 0x4F85, "gāi,hài"},
    { 0x4F86, "lái,lài"},
    { 0x4F87, "yí"},
    { 0x4F88, "chǐ"},
    { 0x4F89, "kuǎ,huá,è,wú"},
    { 0x4F8A, "guāng"},
    { 0x4F8B, "lì,liè"},
    { 0x4F8C, "yīn"},
    { 0x4F8D, "shì"},
    { 0x4F8E, "mǐ"},
    { 0x4F8F, "zhū,zhōu"},
    { 0x4F90, "xù"},
    { 0x4F91, "yòu"},
    { 0x4F92, "ān,ǎn"},
    { 0x4F93, "lù"},
    { 0x4F94, "móu,máo"},
    { 0x4F95, "ér"},
    { 0x4F96, "lún,lùn"},
    { 0x4F97, "dòng,tōng,tóng,tǒng"},
    { 0x4F98, "chà"},
    { 0x4F99, "chī"},
    { 0x4F9A, "xùn,xún"},
    { 0x4F9B, "gōng,gòng"},
    { 0x4F9C, "zhōu"},
    { 0x4F9D, "yī,yǐ"},
    { 0x4F9E, "rú"},
    { 0x4F9F, "cún,jiàn"},
    { 0x4FA0, "xiá"},
    { 0x4FA1, "sì"},
    { 0x4FA2, "dài"},
    { 0x4FA3, "lǚ"},
    { 0x4FA4, "ta"},
    { 0x4FA5, "jiǎo,yáo"},
    { 0x4FA6, "zhēn"},
    { 0x4FA7, "cè,zè,zhāi"},
    { 0x4FA8, "qiáo"},
    { 0x4FA9, "kuài"},
    { 0x4FAA, "chái"},
    { 0x4FAB, "nìng"},
    { 0x4FAC, "nóng"},
    { 0x4FAD, "jǐn"},
    { 0x4FAE, "wǔ"},
    { 0x4FAF, "hóu,hòu"},
    { 0x4FB0, "jiǒng"},
    { 0x4FB1, "chěng,tǐng"},
    { 0x4FB2, "zhèn,zhēn,chēn"},
    { 0x4FB3, "zuò"},
    { 0x4FB4, "chǒu"},
    { 0x4FB5, "qīn,qǐn"},
    { 0x4FB6, "lǚ"},
    { 0x4FB7, "jú"},
    { 0x4FB8, "shù,dōu"},
    { 0x4FB9, "tǐng"},
    { 0x4FBA, "shèn"},
    { 0x4FBB, "tuì,tuō"},
    { 0x4FBC, "bó"},
    { 0x4FBD, "nán"},
    { 0x4FBE, "xiāo"},
    { 0x4FBF, "biàn,pián,biān"},
    { 0x4FC0, "tuǐ"},
    { 0x4FC1, "yǔ"},
    { 0x4FC2, "xì"},
    { 0x4FC3, "cù,chuò"},
    { 0x4FC4, "é"},
    { 0x4FC5, "qiú"},
    { 0x4FC6, "xú,shū"},
    { 0x4FC7, "guàng"},
    { 0x4FC8, "kù"},
    { 0x4FC9, "wǔ,wú"},
    { 0x4FCA, "jùn,shùn,dūn"},
    { 0x4FCB, "yì"},
    { 0x4FCC, "fǔ"},
    { 0x4FCD, "liáng,lǎng"},
    { 0x4FCE, "zǔ"},
    { 0x4FCF, "qiào,xiào,xiāo"},
    { 0x4FD0, "lì"},
    { 0x4FD1, "yǒng"},
    { 0x4FD2, "hùn"},
    { 0x4FD3, "jìng,yíng"},
    { 0x4FD4, "qiàn,xiàn"},
    { 0x4FD5, "sàn"},
    { 0x4FD6, "pěi"},
    { 0x4FD7, "sú"},
    { 0x4FD8, "fú"},
    { 0x4FD9, "xī"},
    { 0x4FDA, "lǐ,lì"},
    { 0x4FDB, "fǔ,miǎn"},
    { 0x4FDC, "pīng"},
    { 0x4FDD, "bǎo"},
    { 0x4FDE, "yú,shù"},
    { 0x4FDF, "qí,sì"},
    { 0x4FE0, "xiá"},
    { 0x4FE1, "xìn,shēn"},
    { 0x4FE2, "xiū"},
    { 0x4FE3, "yǔ"},
    { 0x4FE4, "dì"},
    { 0x4FE5, "chē,jū"},
    { 0x4FE6, "chóu"},
    { 0x4FE7, "zhì"},
    { 0x4FE8, "yǎn"},
    { 0x4FE9, "liǎ,liǎng"},
    { 0x4FEA, "lì"},
    { 0x4FEB, "lái"},
    { 0x4FEC, "sī"},
    { 0x4FED, "jiǎn"},
    { 0x4FEE, "xiū"},
    { 0x4FEF, "fǔ"},
    { 0x4FF0, "huò"},
    { 0x4FF1, "jù,jū"},
    { 0x4FF2, "xiào"},
    { 0x4FF3, "pái"},
    { 0x4FF4, "jiàn"},
    { 0x4FF5, "biào"},
    { 0x4FF6, "chù,shū,tì"},
    { 0x4FF7, "fèi"},
    { 0x4FF8, "fèng,běng"},
    { 0x4FF9, "yà,yā"},
    { 0x4FFA, "ǎn,yàn"},
    { 0x4FFB, "bèi"},
    { 0x4FFC, "yù"},
    { 0x4FFD, "xīn"},
    { 0x4FFE, "bǐ,bì,bēi,pì"},
    { 0x4FFF, "hǔ,chí"},
    { 0x5000, "chāng,chéng,zhèng"},
    { 0x5001, "zhī"},
    { 0x5002, "bìng"},
    { 0x5003, "jiù"},
    { 0x5004, "yáo"},
    { 0x5005, "cuì,zú"},
    { 0x5006, "liǎ,liǎng"},
    { 0x5007, "wǎn"},
    { 0x5008, "lái,lài,liē"},
    { 0x5009, "cāng,chuàng"},
    { 0x500A, "zòng"},
    { 0x500B, "gè,gě"},
    { 0x500C, "guān"},
    { 0x500D, "bèi,péi"},
    { 0x500E, "tiǎn"},
    { 0x500F, "shū"},
    { 0x5010, "shū"},
    { 0x5011, "men,mèn,mén"},
    { 0x5012, "dào,dǎo"},
    { 0x5013, "tán,dàn,tàn"},
    { 0x5014, "jué,juè"},
    { 0x5015, "chuí,zhuì"},
    { 0x5016, "xìng"},
    { 0x5017, "péng,pěng,píng"},
    { 0x5018, "tǎng,cháng"},
    { 0x5019, "hòu"},
    { 0x501A, "yǐ,jī,yī"},
    { 0x501B, "qī,qí,qì"},
    { 0x501C, "tì,diào,zhōu"},
    { 0x501D, "gàn"},
    { 0x501E, "jìng,liàng"},
    { 0x501F, "jiè"},
    { 0x5020, "suī"},
    { 0x5021, "chàng,chāng"},
    { 0x5022, "jié,qiè"},
    { 0x5023, "fǎng"},
    { 0x5024, "zhí"},
    { 0x5025, "kōng,kǒng"},
    { 0x5026, "juàn"},
    { 0x5027, "zōng"},
    { 0x5028, "jù"},
    { 0x5029, "qiàn,qìng"},
    { 0x502A, "ní,nì,niè"},
    { 0x502B, "lún"},
    { 0x502C, "zhuō"},
    { 0x502D, "wō,wēi,wǒ"},
    { 0x502E, "luǒ"},
    { 0x502F, "sōng"},
    { 0x5030, "lèng,líng"},
    { 0x5031, "hùn"},
    { 0x5032, "dōng,dòng"},
    { 0x5033, "zì"},
    { 0x5034, "bèn,bēn"},
    { 0x5035, "wǔ"},
    { 0x5036, "jù"},
    { 0x5037, "nǎi"},
    { 0x5038, "cǎi"},
    { 0x5039, "jiǎn"},
    { 0x503A, "zhài"},
    { 0x503B, "yē"},
    { 0x503C, "zhí"},
    { 0x503D, "shà"},
    { 0x503E, "qīng"},
    { 0x503F, "nìng"},
    { 0x5040, "yīng"},
    { 0x5041, "chēng"},
    { 0x5042, "qián"},
    { 0x5043, "yǎn"},
    { 0x5044, "ruǎn,rú"},
    { 0x5045, "zhòng,chōng,tóng"},
    { 0x5046, "chǔn"},
    { 0x5047, "jiǎ,jià,jie,xià,xiá,gé"},
    { 0x5048, "jì,jié,qì"},
    { 0x5049, "wěi"},
    { 0x504A, "yǔ"},
    { 0x504B, "bìng,bǐng"},
    { 0x504C, "ruò,rè"},
    { 0x504D, "tí"},
    { 0x504E, "wēi"},
    { 0x504F, "piān"},
    { 0x5050, "yàn"},
    { 0x5051, "fēng"},
    { 0x5052, "tǎng,dàng"},
    { 0x5053, "wò"},
    { 0x5054, "è"},
    { 0x5055, "xié,jiē"},
    { 0x5056, "chě"},
    { 0x5057, "shěng"},
    { 0x5058, "kǎn"},
    { 0x5059, "dì"},
    { 0x505A, "zuò"},
    { 0x505B, "chā"},
    { 0x505C, "tíng"},
    { 0x505D, "bèi"},
    { 0x505E, "xiè,yè,zhá"},
    { 0x505F, "huáng"},
    { 0x5060, "yǎo"},
    { 0x5061, "zhàn"},
    { 0x5062, "chǒu,qiào,zōu"},
    { 0x5063, "yān"},
    { 0x5064, "yóu"},
    { 0x5065, "jiàn"},
    { 0x5066, "xǔ,xū"},
    { 0x5067, "zhā"},
    { 0x5068, "cī"},
    { 0x5069, "fù"},
    { 0x506A, "bī,fù"},
    { 0x506B, "zhì"},
    { 0x506C, "zǒng,cōng"},
    { 0x506D, "miǎn"},
    { 0x506E, "jí"},
    { 0x506F, "yǐ"},
    { 0x5070, "xiè"},
    { 0x5071, "xún"},
    { 0x5072, "cāi,sī,sǐ"},
    { 0x5073, "duān"},
    { 0x5074, "cè,zè,zhāi"},
    { 0x5075, "zhēn,zhēng"},
    { 0x5076, "ǒu"},
    { 0x5077, "tōu"},
    { 0x5078, "tōu"},
    { 0x5079, "bèi"},
    { 0x507A, "zá,zán,zan"},
    { 0x507B, "lóu,lǚ"},
    { 0x507C, "jié"},
    { 0x507D, "wěi,wéi,é,guì"},
    { 0x507E, "fèn"},
    { 0x507F, "cháng"},
    { 0x5080, "guī,kuài,kuǐ"},
    { 0x5081, "sǒu"},
    { 0x5082, "zhì,sī"},
    { 0x5083, "sù"},
    { 0x5084, "xiā"},
    { 0x5085, "fù,fū"},
    { 0x5086, "yuàn,yuán"},
    { 0x5087, "rǒng"},
    { 0x5088, "lì"},
    { 0x5089, "nù"},
    { 0x508A, "yùn"},
    { 0x508B, "jiǎng,gòu"},
    { 0x508C, "mà,mǎ"},
    { 0x508D, "bàng,páng,bēng,péng"},
    { 0x508E, "diān"},
    { 0x508F, "táng"},
    { 0x5090, "hào"},
    { 0x5091, "jié"},
    { 0x5092, "xī,xì"},
    { 0x5093, "shàn"},
    { 0x5094, "qiàn,jiān"},
    { 0x5095, "jué,què"},
    { 0x5096, "cāng,chéng,chen"},
    { 0x5097, "chù"},
    { 0x5098, "sǎn"},
    { 0x5099, "bèi"},
    { 0x509A, "xiào"},
    { 0x509B, "yǒng,róng"},
    { 0x509C, "yáo"},
    { 0x509D, "tàn,tà"},
    { 0x509E, "suō"},
    { 0x509F, "yǎng"},
    { 0x50A0, "fá"},
    { 0x50A1, "bìng"},
    { 0x50A2, "jiā,xiàng"},
    { 0x50A3, "dǎi"},
    { 0x50A4, "zài"},
    { 0x50A5, "tǎng"},
    { 0x50A6, "gǔ"},
    { 0x50A7, "bīn"},
    { 0x50A8, "chǔ"},
    { 0x50A9, "nuó"},
    { 0x50AA, "cān,sǎn,càn,cā,sēn"},
    { 0x50AB, "lěi"},
    { 0x50AC, "cuī"},
    { 0x50AD, "yōng,chōng,yòng"},
    { 0x50AE, "zāo,cáo"},
    { 0x50AF, "zǒng"},
    { 0x50B0, "bēng,péng"},
    { 0x50B1, "sǒng,shuǎng"},
    { 0x50B2, "ào,áo"},
    { 0x50B3, "chuán,zhuàn"},
    { 0x50B4, "yǔ"},
    { 0x50B5, "zhài"},
    { 0x50B6, "zú,qī"},
    { 0x50B7, "shāng"},
    { 0x50B8, "chuǎng"},
    { 0x50B9, "jìng"},
    { 0x50BA, "chì"},
    { 0x50BB, "shǎ"},
    { 0x50BC, "hàn"},
    { 0x50BD, "zhāng"},
    { 0x50BE, "qīng,qǐng"},
    { 0x50BF, "yàn,yān,yìn"},
    { 0x50C0, "dì"},
    { 0x50C1, "xiè,sù"},
    { 0x50C2, "lóu,liǔ,lǚ"},
    { 0x50C3, "bèi"},
    { 0x50C4, "piào,biāo"},
    { 0x50C5, "jǐn,jìn"},
    { 0x50C6, "liàn,lián"},
    { 0x50C7, "lù,liáo"},
    { 0x50C8, "mán,màn"},
    { 0x50C9, "qiān"},
    { 0x50CA, "xiān"},
    { 0x50CB, "tàn,làn,tǎn"},
    { 0x50CC, "yíng"},
    { 0x50CD, "dòng"},
    { 0x50CE, "zhuàn,zūn"},
    { 0x50CF, "xiàng"},
    { 0x50D0, "shàn"},
    { 0x50D1, "qiáo,jiǎo"},
    { 0x50D2, "jiǒng"},
    { 0x50D3, "tuǐ,tuí"},
    { 0x50D4, "zǔn,cuán"},
    { 0x50D5, "pú,pū,bú"},
    { 0x50D6, "xī"},
    { 0x50D7, "láo,lào"},
    { 0x50D8, "chǎng"},
    { 0x50D9, "guāng"},
    { 0x50DA, "liáo,liǎo,lǎo"},
    { 0x50DB, "qī"},
    { 0x50DC, "chēng,dèng,dēng,téng"},
    { 0x50DD, "chán,zhuàn"},
    { 0x50DE, "wěi"},
    { 0x50DF, "jī"},
    { 0x50E0, "bō"},
    { 0x50E1, "huì"},
    { 0x50E2, "chuǎn,chǔn"},
    { 0x50E3, "tiě,jiàn"},
    { 0x50E4, "dàn,chán,chǎn,shàn,dá"},
    { 0x50E5, "jiǎo,yáo,jiāo"},
    { 0x50E6, "jiù"},
    { 0x50E7, "sēng,céng"},
    { 0x50E8, "fèn"},
    { 0x50E9, "xiàn"},
    { 0x50EA, "jú,yù"},
    { 0x50EB, "è"},
    { 0x50EC, "jiāo,jiào,jiǎo"},
    { 0x50ED, "jiàn,zèn"},
    { 0x50EE, "tóng,zhuàng,chòng"},
    { 0x50EF, "lìn,lǐn"},
    { 0x50F0, "bó"},
    { 0x50F1, "gù"},
    { 0x50F2, "xiān"},
    { 0x50F3, "sù"},
    { 0x50F4, "xiàn"},
    { 0x50F5, "jiāng"},
    { 0x50F6, "mǐn"},
    { 0x50F7, "yè"},
    { 0x50F8, "jìn"},
    { 0x50F9, "jià,qiǎ,jie"},
    { 0x50FA, "qiào"},
    { 0x50FB, "pì"},
    { 0x50FC, "fēng"},
    { 0x50FD, "zhòu,zhōu"},
    { 0x50FE, "ài"},
    { 0x50FF, "sài"},
    { 0x5100, "yí"},
    { 0x5101, "jùn"},
    { 0x5102, "nóng"},
    { 0x5103, "chán,shàn,tǎn,dàn,zhǎn"},
    { 0x5104, "yì,yī"},
    { 0x5105, "dàng,dāng"},
    { 0x5106, "jǐng"},
    { 0x5107, "xuān,xuán"},
    { 0x5108, "kuài"},
    { 0x5109, "jiǎn"},
    { 0x510A, "chù"},
    { 0x510B, "dān,dàn,shàn"},
    { 0x510C, "jiǎo,jiāo"},
    { 0x510D, "shǎ"},
    { 0x510E, "zài"},
    { 0x510F, "càn"},
    { 0x5110, "bīn,bìn"},
    { 0x5111, "án,àn"},
    { 0x5112, "rú"},
    { 0x5113, "tái,tài"},
    { 0x5114, "chóu,dào"},
    { 0x5115, "chái"},
    { 0x5116, "lán"},
    { 0x5117, "nǐ,yí,yì,ài"},
    { 0x5118, "jǐn,jìn"},
    { 0x5119, "qiàn"},
    { 0x511A, "méng"},
    { 0x511B, "wǔ"},
    { 0x511C, "níng"},
    { 0x511D, "qióng"},
    { 0x511E, "nǐ"},
    { 0x511F, "cháng"},
    { 0x5120, "liè,là"},
    { 0x5121, "lěi,léi,lèi"},
    { 0x5122, "lǚ"},
    { 0x5123, "kuǎng"},
    { 0x5124, "bào"},
    { 0x5125, "yù,dí,dú"},
    { 0x5126, "biāo"},
    { 0x5127, "zǎn"},
    { 0x5128, "zhì"},
    { 0x5129, "sì"},
    { 0x512A, "yōu"},
    { 0x512B, "háo"},
    { 0x512C, "qìng"},
    { 0x512D, "chèn,qìn,qīn"},
    { 0x512E, "lì"},
    { 0x512F, "téng"},
    { 0x5130, "wěi"},
    { 0x5131, "lǒng,lòng,lóng"},
    { 0x5132, "chǔ,chú"},
    { 0x5133, "chán,chàn"},
    { 0x5134, "ráng,xiāng"},
    { 0x5135, "shū,tiáo"},
    { 0x5136, "huì,xié"},
    { 0x5137, "lì,lí"},
    { 0x5138, "luó"},
    { 0x5139, "zǎn"},
    { 0x513A, "nuó"},
    { 0x513B, "tǎng,tàng,chǎng"},
    { 0x513C, "yǎn"},
    { 0x513D, "léi,lěi,luǒ"},
    { 0x513E, "nàng"},
    { 0x513F, "ér,rén"},
    { 0x5140, "wù,wū"},
    { 0x5141, "yǔn,yuán"},
    { 0x5142, "zān"},
    { 0x5143, "yuán"},
    { 0x5144, "xiōng,kuàng"},
    { 0x5145, "chōng"},
    { 0x5146, "zhào"},
    { 0x5147, "xiōng"},
    { 0x5148, "xiān"},
    { 0x5149, "guāng,guàng"},
    { 0x514A, "duì"},
    { 0x514B, "kè"},
    { 0x514C, "duì"},
    { 0x514D, "miǎn,wèn,wǎn"},
    { 0x514E, "tù"},
    { 0x514F, "cháng"},
    { 0x5150, "ér"},
    { 0x5151, "duì,ruì,duó"},
    { 0x5152, "ér,ní"},
    { 0x5153, "jīn,zàn"},
    { 0x5154, "tù,tú,chān"},
    { 0x5155, "sì"},
    { 0x5156, "yǎn"},
    { 0x5157, "yǎn"},
    { 0x5158, "shǐ"},
    { 0x515A, "dǎng"},
    { 0x515B, "qiān"},
    { 0x515C, "dōu"},
    { 0x515D, "fēn"},
    { 0x515E, "máo"},
    { 0x515F, "shēn"},
    { 0x5160, "dōu"},
    { 0x5162, "jīng"},
    { 0x5163, "lǐ"},
    { 0x5164, "huǎng"},
    { 0x5165, "rù"},
    { 0x5166, "wáng"},
    { 0x5167, "nèi"},
    { 0x5168, "quán"},
    { 0x5169, "liǎng,liàng"},
    { 0x516A, "yú,yù,shù,shū,zhū"},
    { 0x516B, "bā,bá"},
    { 0x516C, "gōng"},
    { 0x516D, "liù,lù"},
    { 0x516E, "xī"},
    { 0x516F, "han"},
    { 0x5170, "lán"},
    { 0x5171, "gòng,gōng,gǒng,hóng"},
    { 0x5172, "tiān"},
    { 0x5173, "guān"},
    { 0x5174, "xìng,xīng"},
    { 0x5175, "bīng"},
    { 0x5176, "qí,jī,jì"},
    { 0x5177, "jù"},
    { 0x5178, "diǎn,tiǎn"},
    { 0x5179, "zī,cí"},
    { 0x517A, "fēn"},
    { 0x517B, "yǎng"},
    { 0x517C, "jiān"},
    { 0x517D, "shòu"},
    { 0x517E, "jì"},
    { 0x517F, "yì"},
    { 0x5180, "jì"},
    { 0x5181, "chǎn"},
    { 0x5182, "jiōng,jiǒng"},
    { 0x5183, "mào"},
    { 0x5184, "rǎn"},
    { 0x5185, "nèi,nà,ruì"},
    { 0x5186, "yuán"},
    { 0x5187, "mǎo"},
    { 0x5188, "gāng"},
    { 0x5189, "rǎn,nán,dān"},
    { 0x518A, "cè"},
    { 0x518B, "jiōng,jiǒng"},
    { 0x518C, "cè,zhà"},
    { 0x518D, "zài"},
    { 0x518E, "guǎ"},
    { 0x518F, "jiǒng,jiōng"},
    { 0x5190, "mào"},
    { 0x5191, "zhòu"},
    { 0x5192, "mào,mò"},
    { 0x5193, "gòu,gōu"},
    { 0x5194, "xǔ"},
    { 0x5195, "miǎn"},
    { 0x5196, "mì"},
    { 0x5197, "rǒng"},
    { 0x5198, "yín,yóu"},
    { 0x5199, "xiě,xiè"},
    { 0x519A, "kǎn"},
    { 0x519B, "jūn"},
    { 0x519C, "nóng"},
    { 0x519D, "yí"},
    { 0x519E, "mí"},
    { 0x519F, "shì"},
    { 0x51A0, "guān,guàn"},
    { 0x51A1, "méng"},
    { 0x51A2, "zhǒng"},
    { 0x51A3, "jù"},
    { 0x51A4, "yuān"},
    { 0x51A5, "míng,mián,miàn"},
    { 0x51A6, "kòu"},
    { 0x51A7, "lín"},
    { 0x51A8, "fù"},
    { 0x51A9, "xiě"},
    { 0x51AA, "mì"},
    { 0x51AB, "bīng"},
    { 0x51AC, "dōng"},
    { 0x51AD, "tài"},
    { 0x51AE, "gāng"},
    { 0x51AF, "féng,píng"},
    { 0x51B0, "bīng,níng"},
    { 0x51B1, "hù"},
    { 0x51B2, "chōng,chòng"},
    { 0x51B3, "jué"},
    { 0x51B4, "hù"},
    { 0x51B5, "kuàng"},
    { 0x51B6, "yě"},
    { 0x51B7, "lěng,líng,lǐng"},
    { 0x51B8, "pàn"},
    { 0x51B9, "fú"},
    { 0x51BA, "mǐn"},
    { 0x51BB, "dòng"},
    { 0x51BC, "xiǎn,shěng"},
    { 0x51BD, "liè"},
    { 0x51BE, "qià"},
    { 0x51BF, "jiān"},
    { 0x51C0, "jìng,chēng"},
    { 0x51C1, "sōu"},
    { 0x51C2, "měi"},
    { 0x51C3, "tú"},
    { 0x51C4, "qī"},
    { 0x51C5, "gù"},
    { 0x51C6, "zhǔn"},
    { 0x51C7, "sōng"},
    { 0x51C8, "jìng"},
    { 0x51C9, "liáng,liàng"},
    { 0x51CA, "qìng"},
    { 0x51CB, "diāo"},
    { 0x51CC, "líng,lìng"},
    { 0x51CD, "dòng"},
    { 0x51CE, "gàn"},
    { 0x51CF, "jiǎn"},
    { 0x51D0, "yīn"},
    { 0x51D1, "còu"},
    { 0x51D2, "ái"},
    { 0x51D3, "lì"},
    { 0x51D4, "chuàng,cāng"},
    { 0x51D5, "mǐng"},
    { 0x51D6, "zhǔn"},
    { 0x51D7, "cuī"},
    { 0x51D8, "sī"},
    { 0x51D9, "duó"},
    { 0x51DA, "jìn"},
    { 0x51DB, "lǐn"},
    { 0x51DC, "lǐn"},
    { 0x51DD, "níng"},
    { 0x51DE, "xī"},
    { 0x51DF, "dú"},
    { 0x51E0, "jǐ,jī"},
    { 0x51E1, "fán"},
    { 0x51E2, "fán"},
    { 0x51E3, "fán"},
    { 0x51E4, "fèng"},
    { 0x51E5, "jū"},
    { 0x51E6, "chǔ,chù"},
    { 0x51E7, "zhēng"},
    { 0x51E8, "fēng"},
    { 0x51E9, "mù"},
    { 0x51EA, "zhǐ"},
    { 0x51EB, "fú"},
    { 0x51EC, "fēng"},
    { 0x51ED, "píng"},
    { 0x51EE, "fēng"},
    { 0x51EF, "kǎi"},
    { 0x51F0, "huáng"},
    { 0x51F1, "kǎi"},
    { 0x51F2, "gān"},
    { 0x51F3, "dèng"},
    { 0x51F4, "píng"},
    { 0x51F5, "qiǎn,kǎn"},
    { 0x51F6, "xiōng"},
    { 0x51F7, "kuài"},
    { 0x51F8, "tū"},
    { 0x51F9, "āo,wā"},
    { 0x51FA, "chū"},
    { 0x51FB, "jī"},
    { 0x51FC, "dàng"},
    { 0x51FD, "hán"},
    { 0x51FE, "hán"},
    { 0x51FF, "záo,zuò"},
    { 0x5200, "dāo,diāo"},
    { 0x5201, "diāo"},
    { 0x5202, "dāo"},
    { 0x5203, "rèn"},
    { 0x5204, "rèn"},
    { 0x5205, "chuāng"},
    { 0x5206, "fēn,fèn,fén"},
    { 0x5207, "qiè,qiē,qì"},
    { 0x5208, "yì"},
    { 0x5209, "jī"},
    { 0x520A, "kān"},
    { 0x520B, "qiàn"},
    { 0x520C, "cǔn"},
    { 0x520D, "chú"},
    { 0x520E, "wěn"},
    { 0x520F, "jī"},
    { 0x5210, "dǎn"},
    { 0x5211, "xíng"},
    { 0x5212, "huà,guò,guǒ,huá,huai"},
    { 0x5213, "wán"},
    { 0x5214, "jué"},
    { 0x5215, "lí"},
    { 0x5216, "yuè"},
    { 0x5217, "liè,lì"},
    { 0x5218, "liú"},
    { 0x5219, "zé"},
    { 0x521A, "gāng"},
    { 0x521B, "chuàng,chuāng"},
    { 0x521C, "fú"},
    { 0x521D, "chū"},
    { 0x521E, "qù"},
    { 0x521F, "diāo"},
    { 0x5220, "shān"},
    { 0x5221, "mǐn"},
    { 0x5222, "líng"},
    { 0x5223, "zhōng"},
    { 0x5224, "pàn"},
    { 0x5225, "bié"},
    { 0x5226, "jié"},
    { 0x5227, "jié"},
    { 0x5228, "páo,bào"},
    { 0x5229, "lì"},
    { 0x522A, "shān"},
    { 0x522B, "bié,biè"},
    { 0x522C, "chǎn,chàn"},
    { 0x522D, "jǐng"},
    { 0x522E, "guā"},
    { 0x522F, "gēng"},
    { 0x5230, "dào"},
    { 0x5231, "chuàng"},
    { 0x5232, "kuī"},
    { 0x5233, "kū,kōu"},
    { 0x5234, "duò"},
    { 0x5235, "èr"},
    { 0x5236, "zhì"},
    { 0x5237, "shuā,shuà"},
    { 0x5238, "quàn,xuàn"},
    { 0x5239, "shā,chà"},
    { 0x523A, "cì,qì,cī"},
    { 0x523B, "kè,kēi"},
    { 0x523C, "jié"},
    { 0x523D, "guì"},
    { 0x523E, "cì"},
    { 0x523F, "guì"},
    { 0x5240, "kǎi"},
    { 0x5241, "duò"},
    { 0x5242, "jì"},
    { 0x5243, "tì"},
    { 0x5244, "jǐng"},
    { 0x5245, "lóu,dōu"},
    { 0x5246, "luǒ"},
    { 0x5247, "zé"},
    { 0x5248, "yuān"},
    { 0x5249, "cuò"},
    { 0x524A, "xuē,qiào,xiāo,shào"},
    { 0x524B, "kè,kēi"},
    { 0x524C, "lá,là"},
    { 0x524D, "qián,jiǎn"},
    { 0x524E, "shā"},
    { 0x524F, "chuàng"},
    { 0x5250, "guǎ"},
    { 0x5251, "jiàn"},
    { 0x5252, "cuò"},
    { 0x5253, "lí"},
    { 0x5254, "tī,tì"},
    { 0x5255, "fèi"},
    { 0x5256, "pōu,pǒ"},
    { 0x5257, "chǎn,chàn"},
    { 0x5258, "qí"},
    { 0x5259, "chuàng"},
    { 0x525A, "zì"},
    { 0x525B, "gāng"},
    { 0x525C, "wān"},
    { 0x525D, "bō"},
    { 0x525E, "jī"},
    { 0x525F, "duō,chì"},
    { 0x5260, "qíng,lüè"},
    { 0x5261, "shàn,yǎn"},
    { 0x5262, "dū,zhuó"},
    { 0x5263, "jiàn"},
    { 0x5264, "jì"},
    { 0x5265, "bō,bāo,pū"},
    { 0x5266, "yān"},
    { 0x5267, "jù"},
    { 0x5268, "huō,huò"},
    { 0x5269, "shèng"},
    { 0x526A, "jiǎn"},
    { 0x526B, "duó,dù"},
    { 0x526C, "duān,tuán,zhì"},
    { 0x526D, "wū"},
    { 0x526E, "guǎ"},
    { 0x526F, "fù,pì"},
    { 0x5270, "shèng"},
    { 0x5271, "jiàn"},
    { 0x5272, "gē"},
    { 0x5273, "dá,zhá"},
    { 0x5274, "kǎi,āi"},
    { 0x5275, "chuàng,chuāng,qiāng"},
    { 0x5276, "chuān"},
    { 0x5277, "chǎn"},
    { 0x5278, "tuán,zhuān,zhuàn"},
    { 0x5279, "lù,jiū"},
    { 0x527A, "lí"},
    { 0x527B, "pěng"},
    { 0x527C, "shān"},
    { 0x527D, "piāo,piào,piáo,biǎo,biāo"},
    { 0x527E, "kōu"},
    { 0x527F, "jiǎo,chāo"},
    { 0x5280, "guā"},
    { 0x5281, "qiāo,qiáo"},
    { 0x5282, "jué"},
    { 0x5283, "huà,huá,huai"},
    { 0x5284, "zhā,zhá"},
    { 0x5285, "zhuó"},
    { 0x5286, "lián"},
    { 0x5287, "jù"},
    { 0x5288, "pī,pǐ"},
    { 0x5289, "liú"},
    { 0x528A, "guì"},
    { 0x528B, "jiǎo,chāo"},
    { 0x528C, "guì"},
    { 0x528D, "jiàn"},
    { 0x528E, "jiàn"},
    { 0x528F, "tāng"},
    { 0x5290, "huō,huò,huá"},
    { 0x5291, "jì"},
    { 0x5292, "jiàn"},
    { 0x5293, "yì"},
    { 0x5294, "jiàn"},
    { 0x5295, "zhì"},
    { 0x5296, "chán"},
    { 0x5297, "jiǎn,zuān"},
    { 0x5298, "mó,mí"},
    { 0x5299, "lí"},
    { 0x529A, "zhǔ"},
    { 0x529B, "lì"},
    { 0x529C, "yà"},
    { 0x529D, "quàn"},
    { 0x529E, "bàn"},
    { 0x529F, "gōng"},
    { 0x52A0, "jiā"},
    { 0x52A1, "wù"},
    { 0x52A2, "mài"},
    { 0x52A3, "liè"},
    { 0x52A4, "jìn"},
    { 0x52A5, "kēng"},
    { 0x52A6, "xié,liè"},
    { 0x52A7, "zhǐ"},
    { 0x52A8, "dòng"},
    { 0x52A9, "zhù,chú"},
    { 0x52AA, "nǔ"},
    { 0x52AB, "jié"},
    { 0x52AC, "qú"},
    { 0x52AD, "shào"},
    { 0x52AE, "yì"},
    { 0x52AF, "zhū"},
    { 0x52B0, "mò"},
    { 0x52B1, "lì"},
    { 0x52B2, "jìn,jìng"},
    { 0x52B3, "láo"},
    { 0x52B4, "láo"},
    { 0x52B5, "juàn"},
    { 0x52B6, "kǒu"},
    { 0x52B7, "yáng"},
    { 0x52B8, "wā"},
    { 0x52B9, "xiào"},
    { 0x52BA, "móu"},
    { 0x52BB, "kuāng"},
    { 0x52BC, "jié"},
    { 0x52BD, "liè"},
    { 0x52BE, "hé,kài"},
    { 0x52BF, "shì"},
    { 0x52C0, "kè"},
    { 0x52C1, "jìn,jìng"},
    { 0x52C2, "gào"},
    { 0x52C3, "bó"},
    { 0x52C4, "mǐn"},
    { 0x52C5, "chì"},
    { 0x52C6, "láng"},
    { 0x52C7, "yǒng"},
    { 0x52C8, "yǒng"},
    { 0x52C9, "miǎn"},
    { 0x52CA, "kè"},
    { 0x52CB, "xūn"},
    { 0x52CC, "juàn,juān"},
    { 0x52CD, "qíng"},
    { 0x52CE, "lù"},
    { 0x52CF, "bù"},
    { 0x52D0, "měng"},
    { 0x52D1, "chì,lài"},
    { 0x52D2, "lēi,lè,lei"},
    { 0x52D3, "kài"},
    { 0x52D4, "miǎn"},
    { 0x52D5, "dòng"},
    { 0x52D6, "xù,mào"},
    { 0x52D7, "xù"},
    { 0x52D8, "kān"},
    { 0x52D9, "wù,wǔ,wú,máo,mào"},
    { 0x52DA, "yì"},
    { 0x52DB, "xūn"},
    { 0x52DC, "wěng,yǎng"},
    { 0x52DD, "shèng"},
    { 0x52DE, "láo,lào,liáo"},
    { 0x52DF, "mù,bó"},
    { 0x52E0, "lù"},
    { 0x52E1, "piào"},
    { 0x52E2, "shì"},
    { 0x52E3, "jī"},
    { 0x52E4, "qín,qí"},
    { 0x52E5, "jiàng,qiǎng,jiǎng"},
    { 0x52E6, "chāo,jiǎo,cháo"},
    { 0x52E7, "quàn"},
    { 0x52E8, "xiàng"},
    { 0x52E9, "yì"},
    { 0x52EA, "jué"},
    { 0x52EB, "fān"},
    { 0x52EC, "juān"},
    { 0x52ED, "tóng,dòng"},
    { 0x52EE, "jù"},
    { 0x52EF, "dān"},
    { 0x52F0, "xié"},
    { 0x52F1, "mài"},
    { 0x52F2, "xūn"},
    { 0x52F3, "xūn"},
    { 0x52F4, "lǜ"},
    { 0x52F5, "lì"},
    { 0x52F6, "chè"},
    { 0x52F7, "ráng,xiāng"},
    { 0x52F8, "quàn"},
    { 0x52F9, "bāo"},
    { 0x52FA, "sháo,shuò,zhuó,dì"},
    { 0x52FB, "yún"},
    { 0x52FC, "jiū"},
    { 0x52FD, "bào"},
    { 0x52FE, "gōu,gòu"},
    { 0x52FF, "wù,mò"},
    { 0x5300, "yún,jūn,yùn"},
    { 0x5301, "wén"},
    { 0x5302, "xiōng"},
    { 0x5303, "gài"},
    { 0x5304, "gài"},
    { 0x5305, "bāo,páo,fú"},
    { 0x5306, "cōng"},
    { 0x5307, "yì"},
    { 0x5308, "xiōng"},
    { 0x5309, "pēng"},
    { 0x530A, "jū"},
    { 0x530B, "táo,yáo"},
    { 0x530C, "gé"},
    { 0x530D, "pú"},
    { 0x530E, "è"},
    { 0x530F, "páo"},
    { 0x5310, "fú"},
    { 0x5311, "gōng"},
    { 0x5312, "dá"},
    { 0x5313, "jiù"},
    { 0x5314, "gōng"},
    { 0x5315, "bǐ,pìn"},
    { 0x5316, "huà,huā,huò"},
    { 0x5317, "běi,bèi"},
    { 0x5318, "nǎo"},
    { 0x5319, "shi,chí"},
    { 0x531A, "fāng,fàng"},
    { 0x531B, "jiù"},
    { 0x531C, "yí"},
    { 0x531D, "zā"},
    { 0x531E, "jiàng"},
    { 0x531F, "kàng"},
    { 0x5320, "jiàng"},
    { 0x5321, "kuāng,wāng"},
    { 0x5322, "hū"},
    { 0x5323, "xiá"},
    { 0x5324, "qū"},
    { 0x5325, "fán"},
    { 0x5326, "guǐ"},
    { 0x5327, "qiè"},
    { 0x5328, "zāng,cáng"},
    { 0x5329, "kuāng"},
    { 0x532A, "fěi,fēi,fēn"},
    { 0x532B, "hū"},
    { 0x532C, "yǔ"},
    { 0x532D, "guǐ"},
    { 0x532E, "kuì"},
    { 0x532F, "huì"},
    { 0x5330, "dān"},
    { 0x5331, "guì,kuì"},
    { 0x5332, "lián"},
    { 0x5333, "lián"},
    { 0x5334, "suǎn"},
    { 0x5335, "dú"},
    { 0x5336, "jiù"},
    { 0x5337, "jué"},
    { 0x5338, "xì"},
    { 0x5339, "pǐ"},
    { 0x533A, "qū,ōu"},
    { 0x533B, "yī,yì"},
    { 0x533C, "kē,ē,ǎn"},
    { 0x533D, "yǎn,yàn"},
    { 0x533E, "biǎn"},
    { 0x533F, "nì,tè"},
    { 0x5340, "qū,ōu,gōu,qiū,kòu"},
    { 0x5341, "shí"},
    { 0x5342, "xùn"},
    { 0x5343, "qiān"},
    { 0x5344, "niàn"},
    { 0x5345, "sà"},
    { 0x5346, "zú"},
    { 0x5347, "shēng"},
    { 0x5348, "wǔ"},
    { 0x5349, "huì"},
    { 0x534A, "bàn,pàn"},
    { 0x534B, "shì"},
    { 0x534C, "xì"},
    { 0x534D, "wàn"},
    { 0x534E, "huá,huà"},
    { 0x534F, "xié"},
    { 0x5350, "wàn"},
    { 0x5351, "bēi,bǐ,bì,pí,bān"},
    { 0x5352, "zú,cù,cuì"},
    { 0x5353, "zhuó,zhuō"},
    { 0x5354, "xié"},
    { 0x5355, "dān,chán,shàn"},
    { 0x5356, "mài"},
    { 0x5357, "nán,nā"},
    { 0x5358, "dān"},
    { 0x5359, "jí,chì"},
    { 0x535A, "bó"},
    { 0x535B, "shuài"},
    { 0x535C, "bo,bǔ,pū"},
    { 0x535D, "kuàng,guàn"},
    { 0x535E, "biàn,pán"},
    { 0x535F, "bǔ,jī"},
    { 0x5360, "zhàn,zhān,tiē"},
    { 0x5361, "kǎ,qiǎ"},
    { 0x5362, "lú"},
    { 0x5363, "yǒu"},
    { 0x5364, "lǔ,xī"},
    { 0x5365, "xī"},
    { 0x5366, "guà"},
    { 0x5367, "wò"},
    { 0x5368, "xiè"},
    { 0x5369, "jié"},
    { 0x536A, "jié"},
    { 0x536B, "wèi"},
    { 0x536C, "áng,yǎng"},
    { 0x536D, "qióng"},
    { 0x536E, "zhī"},
    { 0x536F, "mǎo"},
    { 0x5370, "yìn,yì"},
    { 0x5371, "wēi"},
    { 0x5372, "shào"},
    { 0x5373, "jí"},
    { 0x5374, "què"},
    { 0x5375, "luǎn,kūn"},
    { 0x5376, "chǐ"},
    { 0x5377, "juǎn,juàn,quán,quān,gǔn,jùn"},
    { 0x5378, "xiè"},
    { 0x5379, "xù,sū"},
    { 0x537A, "jǐn"},
    { 0x537B, "què,jiǎo,xì"},
    { 0x537C, "wù"},
    { 0x537D, "jí"},
    { 0x537E, "è"},
    { 0x537F, "qīng"},
    { 0x5380, "xī"},
    { 0x5381, "sān"},
    { 0x5382, "chǎng,hǎn,yán,ān"},
    { 0x5383, "wěi,yán"},
    { 0x5384, "è,ě"},
    { 0x5385, "tīng"},
    { 0x5386, "lì"},
    { 0x5387, "zhé,zhái"},
    { 0x5388, "hǎn,àn"},
    { 0x5389, "lì"},
    { 0x538A, "yǎ"},
    { 0x538B, "yā,yà"},
    { 0x538C, "yàn"},
    { 0x538D, "shè"},
    { 0x538E, "dǐ,zhǐ"},
    { 0x538F, "zhǎ,zhǎi"},
    { 0x5390, "páng"},
    { 0x5391, "yá"},
    { 0x5392, "qiè"},
    { 0x5393, "yá,ái"},
    { 0x5394, "zhì,shī"},
    { 0x5395, "cè,si"},
    { 0x5396, "páng,máng"},
    { 0x5397, "tí"},
    { 0x5398, "lí,chán"},
    { 0x5399, "shè"},
    { 0x539A, "hòu"},
    { 0x539B, "tīng"},
    { 0x539C, "zuī"},
    { 0x539D, "cuò,jí"},
    { 0x539E, "fèi"},
    { 0x539F, "yuán"},
    { 0x53A0, "cè"},
    { 0x53A1, "yuán"},
    { 0x53A2, "xiāng"},
    { 0x53A3, "yǎn"},
    { 0x53A4, "lì"},
    { 0x53A5, "jué"},
    { 0x53A6, "shà,xià"},
    { 0x53A7, "diān"},
    { 0x53A8, "chú"},
    { 0x53A9, "jiù"},
    { 0x53AA, "jǐn"},
    { 0x53AB, "áo"},
    { 0x53AC, "guǐ"},
    { 0x53AD, "yàn,yā,yǎn,yān,yì"},
    { 0x53AE, "sī"},
    { 0x53AF, "lì"},
    { 0x53B0, "chǎng"},
    { 0x53B1, "lán,qiān"},
    { 0x53B2, "lì,lài"},
    { 0x53B3, "yán"},
    { 0x53B4, "yǎn"},
    { 0x53B5, "yuán"},
    { 0x53B6, "sī,mǒu"},
    { 0x53B7, "gōng,hóng"},
    { 0x53B8, "lín,min"},
    { 0x53B9, "róu,qiú"},
    { 0x53BA, "qù"},
    { 0x53BB, "qù,qū"},
    { 0x53BC, "ěr"},
    { 0x53BD, "lěi"},
    { 0x53BE, "dū,dǔ"},
    { 0x53BF, "xiàn"},
    { 0x53C0, "zhuān,huì"},
    { 0x53C1, "sān"},
    { 0x53C2, "cān,cēn,shēn"},
    { 0x53C3, "cān,shēn,sān,cēn,càn,sǎn"},
    { 0x53C4, "cān"},
    { 0x53C5, "cān"},
    { 0x53C6, "ài"},
    { 0x53C7, "dài"},
    { 0x53C8, "yòu"},
    { 0x53C9, "chā,chá,chǎ,chà"},
    { 0x53CA, "jí"},
    { 0x53CB, "yǒu"},
    { 0x53CC, "shuāng"},
    { 0x53CD, "fǎn,fàn"},
    { 0x53CE, "shōu"},
    { 0x53CF, "guài"},
    { 0x53D0, "bá"},
    { 0x53D1, "fā,fà"},
    { 0x53D2, "ruò"},
    { 0x53D3, "shì,lì"},
    { 0x53D4, "shū"},
    { 0x53D5, "zhuó,yǐ,lì,jué"},
    { 0x53D6, "qǔ,qū"},
    { 0x53D7, "shòu,dào"},
    { 0x53D8, "biàn"},
    { 0x53D9, "xù"},
    { 0x53DA, "jiǎ,xiá"},
    { 0x53DB, "pàn"},
    { 0x53DC, "sǒu"},
    { 0x53DD, "jí"},
    { 0x53DE, "wèi"},
    { 0x53DF, "sǒu,sōu,xiāo"},
    { 0x53E0, "dié"},
    { 0x53E1, "ruì"},
    { 0x53E2, "cóng"},
    { 0x53E3, "kǒu"},
    { 0x53E4, "gǔ,gù,kū"},
    { 0x53E5, "jù,gōu,gòu,qú"},
    { 0x53E6, "lìng"},
    { 0x53E7, "guǎ"},
    { 0x53E8, "dāo,tāo,dáo"},
    { 0x53E9, "kòu"},
    { 0x53EA, "zhǐ,zhī"},
    { 0x53EB, "jiào"},
    { 0x53EC, "zhào,shào"},
    { 0x53ED, "bā,pā,ba"},
    { 0x53EE, "dīng"},
    { 0x53EF, "kě,gē,kè"},
    { 0x53F0, "tái,yí,sì,tāi"},
    { 0x53F1, "chì,huà,é"},
    { 0x53F2, "shǐ"},
    { 0x53F3, "yòu"},
    { 0x53F4, "qiú"},
    { 0x53F5, "pǒ"},
    { 0x53F6, "yè,xié"},
    { 0x53F7, "hào,háo,xiāo"},
    { 0x53F8, "sī,cí,sì"},
    { 0x53F9, "tàn,yǐ,yòu"},
    { 0x53FA, "chǐ"},
    { 0x53FB, "lè,lì"},
    { 0x53FC, "diāo"},
    { 0x53FD, "jī,jiào"},
    { 0x53FE, "liǎo"},
    { 0x53FF, "hōng,hóng"},
    { 0x5400, "miē"},
    { 0x5401, "xū,yù,yū"},
    { 0x5402, "máng,màng"},
    { 0x5403, "chī,qī"},
    { 0x5404, "gè,gě"},
    { 0x5405, "xuān,sòng"},
    { 0x5406, "yāo"},
    { 0x5407, "zǐ,jí"},
    { 0x5408, "hé,gě"},
    { 0x5409, "jí"},
    { 0x540A, "diào"},
    { 0x540B, "cùn,dòu,yīng"},
    { 0x540C, "tóng,tòng"},
    { 0x540D, "míng,mìng"},
    { 0x540E, "hòu"},
    { 0x540F, "lì"},
    { 0x5410, "tǔ,tù"},
    { 0x5411, "xiàng"},
    { 0x5412, "zhā,zhà"},
    { 0x5413, "xià,hà,hè"},
    { 0x5414, "yě,yē"},
    { 0x5415, "lǚ"},
    { 0x5416, "yā,ā"},
    { 0x5417, "ma,má,mǎ"},
    { 0x5418, "ǒu"},
    { 0x5419, "huō"},
    { 0x541A, "yī,xī"},
    { 0x541B, "jūn"},
    { 0x541C, "chǒu"},
    { 0x541D, "lìn"},
    { 0x541E, "tūn,tiān"},
    { 0x541F, "yín,yǐn,jìn"},
    { 0x5420, "fèi"},
    { 0x5421, "bǐ,bì,pǐ"},
    { 0x5422, "qìn"},
    { 0x5423, "qìn"},
    { 0x5424, "jiè,gè,xiè"},
    { 0x5425, "bù,pōu"},
    { 0x5426, "fǒu,pǐ"},
    { 0x5427, "ba,bā,pā"},
    { 0x5428, "dūn,tún,tǔn"},
    { 0x5429, "fēn,pèn"},
    { 0x542A, "é,huā"},
    { 0x542B, "hán,hàn"},
    { 0x542C, "tīng,yǐn,yí"},
    { 0x542D, "kēng,háng,hàng"},
    { 0x542E, "shǔn"},
    { 0x542F, "qǐ"},
    { 0x5430, "hóng"},
    { 0x5431, "zhī,zī,qì"},
    { 0x5432, "yǐn,shěn"},
    { 0x5433, "wú,yú"},
    { 0x5434, "wú,tūn"},
    { 0x5435, "chǎo,miǎo,chāo,chào"},
    { 0x5436, "nà"},
    { 0x5437, "xuè,chuò,jué"},
    { 0x5438, "xī"},
    { 0x5439, "chuī,chuì"},
    { 0x543A, "dōu,rú"},
    { 0x543B, "wěn"},
    { 0x543C, "hǒu"},
    { 0x543D, "hōng,ōu,hǒu"},
    { 0x543E, "wú,yú,yá"},
    { 0x543F, "gào"},
    { 0x5440, "ya,xiā,yā"},
    { 0x5441, "jùn"},
    { 0x5442, "lǚ"},
    { 0x5443, "è,ài,e"},
    { 0x5444, "gé"},
    { 0x5445, "méi,wěn"},
    { 0x5446, "dāi,bǎo,ái"},
    { 0x5447, "qǐ"},
    { 0x5448, "chéng,kuáng,chěng"},
    { 0x5449, "wú"},
    { 0x544A, "gào,jū,gù"},
    { 0x544B, "fū"},
    { 0x544C, "jiào"},
    { 0x544D, "hōng"},
    { 0x544E, "chǐ,yīng"},
    { 0x544F, "shēng"},
    { 0x5450, "nà,nè,na,nuò,ne"},
    { 0x5451, "tūn"},
    { 0x5452, "wǔ,ḿ"},
    { 0x5453, "yì"},
    { 0x5454, "dāi,tǎi"},
    { 0x5455, "ǒu,òu"},
    { 0x5456, "lì"},
    { 0x5457, "bei,bài"},
    { 0x5458, "yuán,yún,yùn"},
    { 0x5459, "guō"},
    { 0x545A, "wen"},
    { 0x545B, "qiāng,qiàng"},
    { 0x545C, "wū"},
    { 0x545D, "è"},
    { 0x545E, "shī"},
    { 0x545F, "juǎn"},
    { 0x5460, "pěn"},
    { 0x5461, "wěn,mǐn"},
    { 0x5462, "ne,ní,nǐ,nī"},
    { 0x5463, "ḿ,móu,m̀"},
    { 0x5464, "lìng,líng"},
    { 0x5465, "rán"},
    { 0x5466, "yōu"},
    { 0x5467, "dǐ"},
    { 0x5468, "zhōu"},
    { 0x5469, "shì"},
    { 0x546A, "zhòu"},
    { 0x546B, "tiè,chè"},
    { 0x546C, "xì,chì"},
    { 0x546D, "yì"},
    { 0x546E, "qì,zhī"},
    { 0x546F, "píng"},
    { 0x5470, "zǐ,cī,jī,xì"},
    { 0x5471, "gū,guā,guǎ"},
    { 0x5472, "cī,cí,zī"},
    { 0x5473, "wèi,mèi"},
    { 0x5474, "xǔ,hǒu,hōu,gòu,gōu,gū"},
    { 0x5475, "hē,hā,ā,a,kē,huō,á,à"},
    { 0x5476, "náo,ná,nǔ"},
    { 0x5477, "gā,xiā,jiǎ"},
    { 0x5478, "pēi"},
    { 0x5479, "yì,chì"},
    { 0x547A, "xiāo,háo"},
    { 0x547B, "shēn"},
    { 0x547C, "hū,xiāo,xū,hè,xià"},
    { 0x547D, "mìng"},
    { 0x547E, "dá,yà,tǎ,dàn"},
    { 0x547F, "qù,kā"},
    { 0x5480, "jǔ,zuǐ"},
    { 0x5481, "hán,xián,gàn"},
    { 0x5482, "zā"},
    { 0x5483, "tuō"},
    { 0x5484, "duō"},
    { 0x5485, "pǒu"},
    { 0x5486, "páo"},
    { 0x5487, "bié,bì"},
    { 0x5488, "fú"},
    { 0x5489, "yāng,yǎng"},
    { 0x548A, "hé"},
    { 0x548B, "zǎ,zé,zhà,zhā"},
    { 0x548C, "hé,hè,huò,huó,hú"},
    { 0x548D, "hāi,tāi"},
    { 0x548E, "jiù,gāo"},
    { 0x548F, "yǒng"},
    { 0x5490, "fù,fú"},
    { 0x5491, "dā"},
    { 0x5492, "zhòu"},
    { 0x5493, "wǎ"},
    { 0x5494, "kā,nòng,kǎ"},
    { 0x5495, "gū,gu"},
    { 0x5496, "kā,jiā,gā"},
    { 0x5497, "zuo"},
    { 0x5498, "bù"},
    { 0x5499, "lóng"},
    { 0x549A, "dōng"},
    { 0x549B, "níng"},
    { 0x549C, "ta"},
    { 0x549D, "sī"},
    { 0x549E, "xiàn,xián"},
    { 0x549F, "huò"},
    { 0x54A0, "qì"},
    { 0x54A1, "èr,ér"},
    { 0x54A2, "è"},
    { 0x54A3, "guāng,gōng"},
    { 0x54A4, "zhà"},
    { 0x54A5, "xì,xī,dié,zhì"},
    { 0x54A6, "yí,xī"},
    { 0x54A7, "liě,liè,liē,lié,lie"},
    { 0x54A8, "zī"},
    { 0x54A9, "miē,mie"},
    { 0x54AA, "mī,miē,mǎi,mǐ"},
    { 0x54AB, "zhǐ"},
    { 0x54AC, "yǎo,jiāo,yāo,jiǎo"},
    { 0x54AD, "jī,xī,qià"},
    { 0x54AE, "zhòu,zhù,zhū,rú"},
    { 0x54AF, "gē,luò,kǎ,kā,lo"},
    { 0x54B0, "shù,xún"},
    { 0x54B1, "zán,zá,zǎ,zan"},
    { 0x54B2, "xiào"},
    { 0x54B3, "hāi,hái,ké,gāi"},
    { 0x54B4, "huī,hái"},
    { 0x54B5, "kuǎ"},
    { 0x54B6, "huài,shì,guō,guā,huà"},
    { 0x54B7, "táo,tiào"},
    { 0x54B8, "xián,jiǎn,jiān"},
    { 0x54B9, "è,àn,ń"},
    { 0x54BA, "xuǎn,xuān"},
    { 0x54BB, "xiū,xǔ,xiāo,xù"},
    { 0x54BC, "guō,wāi,hé,wǒ,wō,guǎ"},
    { 0x54BD, "yàn,yān,yè,yuān"},
    { 0x54BE, "lǎo"},
    { 0x54BF, "yī"},
    { 0x54C0, "āi"},
    { 0x54C1, "pǐn"},
    { 0x54C2, "shěn"},
    { 0x54C3, "tóng"},
    { 0x54C4, "hōng,hòng,hǒng"},
    { 0x54C5, "xiōng,hōng"},
    { 0x54C6, "duō,chǐ,zhà,chì,duò,diě"},
    { 0x54C7, "wa,wā,guī,huá,wá"},
    { 0x54C8, "hā,hà,hē,hé,hǎ,tà,shà"},
    { 0x54C9, "zāi"},
    { 0x54CA, "yòu"},
    { 0x54CB, "diè,dì"},
    { 0x54CC, "pài,gū"},
    { 0x54CD, "xiǎng"},
    { 0x54CE, "āi"},
    { 0x54CF, "gén,hěn,ǹ"},
    { 0x54D0, "kuāng,qiāng"},
    { 0x54D1, "yǎ,yā"},
    { 0x54D2, "dá"},
    { 0x54D3, "xiāo"},
    { 0x54D4, "bì"},
    { 0x54D5, "huì,yuě"},
    { 0x54D6, "nián"},
    { 0x54D7, "huā,huá"},
    { 0x54D8, "xing"},
    { 0x54D9, "kuài"},
    { 0x54DA, "duǒ"},
    { 0x54DB, "fēn"},
    { 0x54DC, "jì"},
    { 0x54DD, "nóng"},
    { 0x54DE, "mōu"},
    { 0x54DF, "yō,yo"},
    { 0x54E0, "hào"},
    { 0x54E1, "yuán,yún,yùn"},
    { 0x54E2, "lòng"},
    { 0x54E3, "pǒu"},
    { 0x54E4, "máng"},
    { 0x54E5, "gē"},
    { 0x54E6, "ó,é,ò"},
    { 0x54E7, "chī,xià,hè"},
    { 0x54E8, "shào,sāo,xiāo,xiào,sào"},
    { 0x54E9, "lī,lì,li,lǐ,mái,yīng"},
    { 0x54EA, "nǎ,nuó,na,nǎi,nà,niè,né,něi"},
    { 0x54EB, "zú"},
    { 0x54EC, "hé"},
    { 0x54ED, "kū"},
    { 0x54EE, "xiāo,xiào,xuē"},
    { 0x54EF, "xiàn"},
    { 0x54F0, "láo"},
    { 0x54F1, "bō,pò,bèi,bā,bó"},
    { 0x54F2, "zhé"},
    { 0x54F3, "zhā"},
    { 0x54F4, "liàng,láng"},
    { 0x54F5, "bā"},
    { 0x54F6, "miē"},
    { 0x54F7, "liè,lǜ"},
    { 0x54F8, "suī"},
    { 0x54F9, "fú"},
    { 0x54FA, "bǔ,bū,fǔ"},
    { 0x54FB, "hān"},
    { 0x54FC, "hēng,hng"},
    { 0x54FD, "gěng,yǐng,yìng,ńg,ń"},
    { 0x54FE, "shuō,yuè"},
    { 0x54FF, "gě"},
    { 0x5500, "yòu"},
    { 0x5501, "yàn"},
    { 0x5502, "gū"},
    { 0x5503, "gǔ"},
    { 0x5504, "bei,bài"},
    { 0x5505, "hán"},
    { 0x5506, "suō,shuà"},
    { 0x5507, "chún,zhēn,zhèn"},
    { 0x5508, "yì"},
    { 0x5509, "āi,ǎi,ài"},
    { 0x550A, "jiá,qiǎn"},
    { 0x550B, "tū"},
    { 0x550C, "xián,yán,dàn"},
    { 0x550D, "wǎn"},
    { 0x550E, "lì"},
    { 0x550F, "xī,xiè"},
    { 0x5510, "táng"},
    { 0x5511, "zuò,shì"},
    { 0x5512, "qiú"},
    { 0x5513, "chē"},
    { 0x5514, "wú,wù,ńg,ḿ,ń"},
    { 0x5515, "zào"},
    { 0x5516, "yǎ"},
    { 0x5517, "dōu"},
    { 0x5518, "qǐ"},
    { 0x5519, "dí"},
    { 0x551A, "qìn,qīn"},
    { 0x551B, "mà"},
    { 0x551C, "mò"},
    { 0x551D, "gòng,hǒng"},
    { 0x551E, "dǒu"},
    { 0x551F, "qù"},
    { 0x5520, "láo,lào"},
    { 0x5521, "liǎng,yīng"},
    { 0x5522, "suǒ"},
    { 0x5523, "zào"},
    { 0x5524, "huàn"},
    { 0x5525, "lang"},
    { 0x5526, "shā"},
    { 0x5527, "jī,jié"},
    { 0x5528, "zǔ"},
    { 0x5529, "wō,wěi"},
    { 0x552A, "fěng,běng"},
    { 0x552B, "jìn,yín"},
    { 0x552C, "hǔ,xiāo,guó,xià,háo"},
    { 0x552D, "qì"},
    { 0x552E, "shòu,shú"},
    { 0x552F, "wéi,wěi"},
    { 0x5530, "shuā"},
    { 0x5531, "chàng"},
    { 0x5532, "ér,wā"},
    { 0x5533, "lì"},
    { 0x5534, "qiàng"},
    { 0x5535, "ǎn,ng,n"},
    { 0x5536, "zé,jiè"},
    { 0x5537, "yō,yù"},
    { 0x5538, "niàn,diàn"},
    { 0x5539, "yū"},
    { 0x553A, "tiǎn"},
    { 0x553B, "lài,lái"},
    { 0x553C, "shà,qiè"},
    { 0x553D, "xī"},
    { 0x553E, "tuò"},
    { 0x553F, "hū"},
    { 0x5540, "ái"},
    { 0x5541, "zhāo,dāo,zhōu,tiáo,diào"},
    { 0x5542, "nǒu"},
    { 0x5543, "kěn"},
    { 0x5544, "zhuó,zhòu"},
    { 0x5545, "zhuó,zhào"},
    { 0x5546, "shāng"},
    { 0x5547, "dì,shì,zhāi"},
    { 0x5548, "hēng,hèng,è,zá"},
    { 0x5549, "lín,lán,lèn"},
    { 0x554A, "a,è,ā,á,ǎ,à"},
    { 0x554B, "cǎi,cāi,xiāo"},
    { 0x554C, "xiāng,qiāng"},
    { 0x554D, "tūn,zhūn,xiāng,tuī,duǐ"},
    { 0x554E, "wǔ"},
    { 0x554F, "wèn"},
    { 0x5550, "cuì,zú,zá,è,chuài"},
    { 0x5551, "shà,zā,jié,dié,tì"},
    { 0x5552, "gǔ"},
    { 0x5553, "qǐ"},
    { 0x5554, "qǐ"},
    { 0x5555, "táo"},
    { 0x5556, "dàn"},
    { 0x5557, "dàn"},
    { 0x5558, "yè,wā"},
    { 0x5559, "zǐ,cī"},
    { 0x555A, "bǐ,tú"},
    { 0x555B, "cuì"},
    { 0x555C, "chuài,chuò,zhuó"},
    { 0x555D, "hé"},
    { 0x555E, "yǎ,è,yā"},
    { 0x555F, "qǐ"},
    { 0x5560, "zhé"},
    { 0x5561, "fēi,pèi,pái,pēi,bài"},
    { 0x5562, "liǎng,yīng"},
    { 0x5563, "xián"},
    { 0x5564, "pí"},
    { 0x5565, "shá,shà"},
    { 0x5566, "la,lā"},
    { 0x5567, "zé"},
    { 0x5568, "yīng,qíng"},
    { 0x5569, "guà"},
    { 0x556A, "pā"},
    { 0x556B, "zhě"},
    { 0x556C, "sè"},
    { 0x556D, "zhuàn"},
    { 0x556E, "niè"},
    { 0x556F, "guō"},
    { 0x5570, "luō"},
    { 0x5571, "yán"},
    { 0x5572, "dī"},
    { 0x5573, "quán,jué"},
    { 0x5574, "chǎn,tān"},
    { 0x5575, "bō,bo"},
    { 0x5576, "dìng"},
    { 0x5577, "lāng"},
    { 0x5578, "xiào"},
    { 0x5579, "jú"},
    { 0x557A, "táng"},
    { 0x557B, "chì,dì"},
    { 0x557C, "tí"},
    { 0x557D, "án,ān"},
    { 0x557E, "jiū"},
    { 0x557F, "dàn"},
    { 0x5580, "kā,kè,ke"},
    { 0x5581, "yóng,yú"},
    { 0x5582, "wèi"},
    { 0x5583, "nán,nǎn"},
    { 0x5584, "shàn"},
    { 0x5585, "yù"},
    { 0x5586, "zhé"},
    { 0x5587, "lǎ,lá,lā,la"},
    { 0x5588, "jiē,xiè"},
    { 0x5589, "hóu"},
    { 0x558A, "hǎn,kàn,jiān"},
    { 0x558B, "dié,zhá,qiè"},
    { 0x558C, "zhōu"},
    { 0x558D, "chái"},
    { 0x558E, "wāi"},
    { 0x558F, "nuò,rě"},
    { 0x5590, "yù"},
    { 0x5591, "yīn,yǐn,yìn"},
    { 0x5592, "zá,zǎn,zán,zà,zan"},
    { 0x5593, "yāo"},
    { 0x5594, "ō,wō,wū,o,ò"},
    { 0x5595, "miǎn"},
    { 0x5596, "hú"},
    { 0x5597, "yǔn"},
    { 0x5598, "chuǎn"},
    { 0x5599, "huì,zhòu"},
    { 0x559A, "huàn"},
    { 0x559B, "huàn,yuán,xuǎn,hé"},
    { 0x559C, "xǐ,xī,chì"},
    { 0x559D, "hē,yè,hè,kài"},
    { 0x559E, "jī"},
    { 0x559F, "kuì,huài"},
    { 0x55A0, "zhǒng,chǒng"},
    { 0x55A1, "wéi,wèi"},
    { 0x55A2, "shà,chè"},
    { 0x55A3, "xù"},
    { 0x55A4, "huáng"},
    { 0x55A5, "duó,zhà"},
    { 0x55A6, "niè,yì"},
    { 0x55A7, "xuān,xuǎn"},
    { 0x55A8, "liàng"},
    { 0x55A9, "yù"},
    { 0x55AA, "sàng,sāng"},
    { 0x55AB, "chī,kài"},
    { 0x55AC, "qiáo,jiǎo"},
    { 0x55AD, "yàn,yǎn"},
    { 0x55AE, "dān,dǎn,chán,shàn,chǎn,dàn,zhàn,tán"},
    { 0x55AF, "pèn,bēn"},
    { 0x55B0, "cān,sūn,qī"},
    { 0x55B1, "lí"},
    { 0x55B2, "yō,yo"},
    { 0x55B3, "zhā,zha,chā"},
    { 0x55B4, "wēi"},
    { 0x55B5, "miāo"},
    { 0x55B6, "yíng"},
    { 0x55B7, "pēn,pèn"},
    { 0x55B8, "bǔ"},
    { 0x55B9, "kuí"},
    { 0x55BA, "xí"},
    { 0x55BB, "yù,yú"},
    { 0x55BC, "jiē"},
    { 0x55BD, "lóu,lou"},
    { 0x55BE, "kù"},
    { 0x55BF, "zào,qiāo"},
    { 0x55C0, "hù"},
    { 0x55C1, "tí"},
    { 0x55C2, "yáo"},
    { 0x55C3, "hè,xiāo,xiào,hù"},
    { 0x55C4, "á,shà,a,xià"},
    { 0x55C5, "xiù"},
    { 0x55C6, "qiāng,qiàng,chéng"},
    { 0x55C7, "sè"},
    { 0x55C8, "yōng"},
    { 0x55C9, "sù"},
    { 0x55CA, "hǒng,gǒng,gòng"},
    { 0x55CB, "xié"},
    { 0x55CC, "ài,yì,wò"},
    { 0x55CD, "suō,shuò"},
    { 0x55CE, "ma,mà,má,mǎ"},
    { 0x55CF, "chā"},
    { 0x55D0, "hài"},
    { 0x55D1, "kē,kè,hé,xiá"},
    { 0x55D2, "dā,tà,da"},
    { 0x55D3, "sǎng"},
    { 0x55D4, "chēn,tián"},
    { 0x55D5, "rù"},
    { 0x55D6, "sōu,sù,sòu"},
    { 0x55D7, "wā,gū"},
    { 0x55D8, "jī"},
    { 0x55D9, "pǎng,bēng,bàng"},
    { 0x55DA, "wū,wù"},
    { 0x55DB, "qiǎn,xián,qiàn,qiān,qiè"},
    { 0x55DC, "shì"},
    { 0x55DD, "gé"},
    { 0x55DE, "zī"},
    { 0x55DF, "jiē,jiè,juē"},
    { 0x55E0, "lào"},
    { 0x55E1, "wēng,wěng"},
    { 0x55E2, "wà"},
    { 0x55E3, "sì"},
    { 0x55E4, "chī"},
    { 0x55E5, "háo"},
    { 0x55E6, "suo,suō"},
    { 0x55E8, "hāi,hēi"},
    { 0x55E9, "suǒ"},
    { 0x55EA, "qín"},
    { 0x55EB, "niè"},
    { 0x55EC, "hē"},
    { 0x55ED, "zhí"},
    { 0x55EE, "sài"},
    { 0x55EF, "ń,ńg,ňg,ň,ǹg,ǹ"},
    { 0x55F0, "gě"},
    { 0x55F1, "ná"},
    { 0x55F2, "diē,diǎ"},
    { 0x55F3, "āi,ǎi,ài"},
    { 0x55F4, "qiāng"},
    { 0x55F5, "tōng"},
    { 0x55F6, "bì"},
    { 0x55F7, "áo"},
    { 0x55F8, "áo"},
    { 0x55F9, "lián"},
    { 0x55FA, "zuī,suī,zuǐ"},
    { 0x55FB, "zhē,zhè,zhù,zhe"},
    { 0x55FC, "mò"},
    { 0x55FD, "sòu,shuò,shù"},
    { 0x55FE, "sǒu"},
    { 0x55FF, "tǎn"},
    { 0x5600, "dí,zhé,dī"},
    { 0x5601, "qī,zú,zā"},
    { 0x5602, "jiào"},
    { 0x5603, "chōng"},
    { 0x5604, "jiāo,jiào,dǎo"},
    { 0x5605, "kǎi,kài,gé"},
    { 0x5606, "tàn"},
    { 0x5607, "shān,càn,shěn"},
    { 0x5608, "cáo"},
    { 0x5609, "jiā"},
    { 0x560A, "ái"},
    { 0x560B, "xiào"},
    { 0x560C, "piào,piāo"},
    { 0x560D, "lóu,lǒu,lou"},
    { 0x560E, "gā,gá,gǎ"},
    { 0x560F, "gǔ,jiǎ"},
    { 0x5610, "xiāo,jiāo,láo,bào,miù"},
    { 0x5611, "hū,hù"},
    { 0x5612, "huì"},
    { 0x5613, "guō"},
    { 0x5614, "ǒu,ōu,òu,xū,chū,ou"},
    { 0x5615, "xiān"},
    { 0x5616, "zé"},
    { 0x5617, "cháng"},
    { 0x5618, "xū,shī"},
    { 0x5619, "pó"},
    { 0x561A, "dē,dé,dāi,dēi"},
    { 0x561B, "ma,má"},
    { 0x561C, "mà"},
    { 0x561D, "hú"},
    { 0x561E, "lei,lē"},
    { 0x561F, "dū"},
    { 0x5620, "gā"},
    { 0x5621, "tāng"},
    { 0x5622, "yě"},
    { 0x5623, "bēng"},
    { 0x5624, "yīng"},
    { 0x5625, "sāi"},
    { 0x5626, "jiào"},
    { 0x5627, "mì"},
    { 0x5628, "xiào"},
    { 0x5629, "huā,huá"},
    { 0x562A, "mǎi"},
    { 0x562B, "rán"},
    { 0x562C, "chuài,zuō"},
    { 0x562D, "pēng"},
    { 0x562E, "láo,chāo,lào,xiāo"},
    { 0x562F, "xiào,chì"},
    { 0x5630, "jī"},
    { 0x5631, "zhǔ"},
    { 0x5632, "cháo,zhāo"},
    { 0x5633, "kuì"},
    { 0x5634, "zuǐ"},
    { 0x5635, "xiāo"},
    { 0x5636, "sī"},
    { 0x5637, "háo"},
    { 0x5638, "fǔ,wǔ,m̄,ḿ"},
    { 0x5639, "liáo,liào"},
    { 0x563A, "qiáo,qiào"},
    { 0x563B, "xī"},
    { 0x563C, "chù,xù,shòu"},
    { 0x563D, "chǎn,tān,chān,tuō,dǎn"},
    { 0x563E, "dàn,tán"},
    { 0x563F, "hēi,mò,mù"},
    { 0x5640, "xùn"},
    { 0x5641, "ě,wù,wò"},
    { 0x5642, "zǔn"},
    { 0x5643, "fān,bo"},
    { 0x5644, "chī"},
    { 0x5645, "huī"},
    { 0x5646, "zǎn,cǎn"},
    { 0x5647, "chuáng"},
    { 0x5648, "cù,zā,hé"},
    { 0x5649, "dàn"},
    { 0x564A, "yù"},
    { 0x564B, "tūn,kuò"},
    { 0x564C, "cēng,chēng"},
    { 0x564D, "jiào,jiāo,jiū"},
    { 0x564E, "yē,yì,shà"},
    { 0x564F, "xī"},
    { 0x5650, "qì"},
    { 0x5651, "háo"},
    { 0x5652, "lián"},
    { 0x5653, "xū"},
    { 0x5654, "dēng"},
    { 0x5655, "huī"},
    { 0x5656, "yín"},
    { 0x5657, "pū"},
    { 0x5658, "juē"},
    { 0x5659, "qín"},
    { 0x565A, "xún"},
    { 0x565B, "niè"},
    { 0x565C, "lū"},
    { 0x565D, "sī"},
    { 0x565E, "yǎn"},
    { 0x565F, "yìng"},
    { 0x5660, "dā,dá"},
    { 0x5661, "zhān,dān"},
    { 0x5662, "ō,yǔ,yù,ào"},
    { 0x5663, "zhòu,zhuó,zhú,dú"},
    { 0x5664, "jìn"},
    { 0x5665, "nóng,náng"},
    { 0x5666, "yuě,huì"},
    { 0x5667, "xiè"},
    { 0x5668, "qì"},
    { 0x5669, "è"},
    { 0x566A, "zào"},
    { 0x566B, "yī,ǎi,yì"},
    { 0x566C, "shì"},
    { 0x566D, "jiào,qiào,chī"},
    { 0x566E, "yuàn"},
    { 0x566F, "āi,ǎi,ài"},
    { 0x5670, "yōng,yǒng"},
    { 0x5671, "jué,xué"},
    { 0x5672, "kuài,guài,kuò,wèi"},
    { 0x5673, "yǔ"},
    { 0x5674, "pēn,pèn,fèn"},
    { 0x5675, "dào"},
    { 0x5676, "gá,gé"},
    { 0x5677, "hm,xīn,hēn"},
    { 0x5678, "dūn"},
    { 0x5679, "dāng"},
    { 0x567A, "xīn"},
    { 0x567B, "sāi"},
    { 0x567C, "pī"},
    { 0x567D, "pǐ"},
    { 0x567E, "yīn"},
    { 0x567F, "zuǐ"},
    { 0x5680, "níng"},
    { 0x5681, "dí"},
    { 0x5682, "làn,hǎn"},
    { 0x5683, "tā,tà"},
    { 0x5684, "huō,huò,wò,ǒ"},
    { 0x5685, "rú"},
    { 0x5686, "hāo"},
    { 0x5687, "xià,hè"},
    { 0x5688, "yè"},
    { 0x5689, "duō"},
    { 0x568A, "pì,xì,xiù"},
    { 0x568B, "chóu,zhōu"},
    { 0x568C, "jì,jiē,zhāi"},
    { 0x568D, "jìn"},
    { 0x568E, "háo"},
    { 0x568F, "tì"},
    { 0x5690, "cháng"},
    { 0x5691, "xūn"},
    { 0x5692, "mē"},
    { 0x5693, "cā,chā"},
    { 0x5694, "tì,zhì"},
    { 0x5695, "lǔ,lū"},
    { 0x5696, "huì"},
    { 0x5697, "bó,pào,bào"},
    { 0x5698, "yōu"},
    { 0x5699, "niè,yǎo"},
    { 0x569A, "yín"},
    { 0x569B, "hù,yo"},
    { 0x569C, "me,mèi,ma"},
    { 0x569D, "hōng"},
    { 0x569E, "zhé"},
    { 0x569F, "lí"},
    { 0x56A0, "liú"},
    { 0x56A1, "hai"},
    { 0x56A2, "náng"},
    { 0x56A3, "xiāo,áo"},
    { 0x56A4, "mó"},
    { 0x56A5, "yàn"},
    { 0x56A6, "lì"},
    { 0x56A7, "lú"},
    { 0x56A8, "lóng"},
    { 0x56A9, "mó"},
    { 0x56AA, "dàn"},
    { 0x56AB, "chèn"},
    { 0x56AC, "pín"},
    { 0x56AD, "pǐ"},
    { 0x56AE, "xiàng,xiǎng"},
    { 0x56AF, "huò,xuè"},
    { 0x56B0, "mó"},
    { 0x56B1, "xì"},
    { 0x56B2, "duǒ"},
    { 0x56B3, "kù"},
    { 0x56B4, "yán,yǎn"},
    { 0x56B5, "chán,chān"},
    { 0x56B6, "yīng"},
    { 0x56B7, "rǎng,rāng"},
    { 0x56B8, "diǎn"},
    { 0x56B9, "lá,la"},
    { 0x56BA, "tà"},
    { 0x56BB, "xiāo"},
    { 0x56BC, "jué,jiáo,jiào"},
    { 0x56BD, "chuò"}
};
