/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     chenhaifeng  <chenhaifeng@uniontech.com>
*
* Maintainer: chenhaifeng  <chenhaifeng@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "pinyindict.h"

QMap<int, QString> PinyinDict_5{
    { 0x56BE, "huān,huàn"},
    { 0x56BF, "huò"},
    { 0x56C0, "zhuàn"},
    { 0x56C1, "niè,zhé"},
    { 0x56C2, "xiāo,áo"},
    { 0x56C3, "cà,zhā,zǎ"},
    { 0x56C4, "lí"},
    { 0x56C5, "chǎn"},
    { 0x56C6, "chài"},
    { 0x56C7, "lì"},
    { 0x56C8, "yì"},
    { 0x56C9, "luō,luó,luo"},
    { 0x56CA, "náng,nāng"},
    { 0x56CB, "zá,zàn,cān"},
    { 0x56CC, "sū"},
    { 0x56CD, "xǐ"},
    { 0x56CE, "zen"},
    { 0x56CF, "jiān"},
    { 0x56D0, "zá,niè,yàn,è"},
    { 0x56D1, "zhǔ"},
    { 0x56D2, "lán"},
    { 0x56D3, "niè"},
    { 0x56D4, "nāng,nang"},
    { 0x56D5, "lǎn"},
    { 0x56D6, "lo"},
    { 0x56D7, "wéi,guó"},
    { 0x56D8, "huí"},
    { 0x56D9, "yīn"},
    { 0x56DA, "qiú"},
    { 0x56DB, "sì"},
    { 0x56DC, "nín"},
    { 0x56DD, "jiǎn,nān,yuè"},
    { 0x56DE, "huí"},
    { 0x56DF, "xìn"},
    { 0x56E0, "yīn"},
    { 0x56E1, "nān,niè"},
    { 0x56E2, "tuán,qiú"},
    { 0x56E3, "tuán"},
    { 0x56E4, "dùn,tún"},
    { 0x56E5, "kàng"},
    { 0x56E6, "yuān"},
    { 0x56E7, "jiǒng"},
    { 0x56E8, "piān"},
    { 0x56E9, "yún"},
    { 0x56EA, "cōng"},
    { 0x56EB, "hú"},
    { 0x56EC, "huí"},
    { 0x56ED, "yuán,wán"},
    { 0x56EE, "é"},
    { 0x56EF, "guó"},
    { 0x56F0, "kùn"},
    { 0x56F1, "cōng,chuāng"},
    { 0x56F2, "tōng"},
    { 0x56F3, "tú"},
    { 0x56F4, "wéi"},
    { 0x56F5, "lún"},
    { 0x56F6, "guó"},
    { 0x56F7, "qūn"},
    { 0x56F8, "rì"},
    { 0x56F9, "líng"},
    { 0x56FA, "gù"},
    { 0x56FB, "guó"},
    { 0x56FC, "tāi"},
    { 0x56FD, "guó"},
    { 0x56FE, "tú"},
    { 0x56FF, "yòu"},
    { 0x5700, "guó"},
    { 0x5701, "yín"},
    { 0x5702, "hùn,huàn"},
    { 0x5703, "pǔ"},
    { 0x5704, "yǔ"},
    { 0x5705, "hán"},
    { 0x5706, "yuán"},
    { 0x5707, "lún"},
    { 0x5708, "quān,juàn,juān,quán,juǎn"},
    { 0x5709, "yǔ"},
    { 0x570A, "qīng"},
    { 0x570B, "guó"},
    { 0x570C, "chuán,chuí"},
    { 0x570D, "wéi"},
    { 0x570E, "yuán"},
    { 0x570F, "quān"},
    { 0x5710, "kū"},
    { 0x5711, "pǔ"},
    { 0x5712, "yuán"},
    { 0x5713, "yuán"},
    { 0x5714, "yà"},
    { 0x5715, "tú"},
    { 0x5716, "tú"},
    { 0x5717, "tú"},
    { 0x5718, "tuán,chuán"},
    { 0x5719, "lüè"},
    { 0x571A, "huì"},
    { 0x571B, "yì"},
    { 0x571C, "huán,yuán"},
    { 0x571D, "luán"},
    { 0x571E, "luán"},
    { 0x571F, "tǔ,dù,chǎ,tú"},
    { 0x5720, "yà"},
    { 0x5721, "tǔ"},
    { 0x5722, "tǐng"},
    { 0x5723, "shèng,kū"},
    { 0x5724, "pú"},
    { 0x5725, "lù"},
    { 0x5726, "kuài"},
    { 0x5727, "yā"},
    { 0x5728, "zài"},
    { 0x5729, "wéi,yú,xū"},
    { 0x572A, "gē,yì"},
    { 0x572B, "yù,zhūn"},
    { 0x572C, "wū"},
    { 0x572D, "guī"},
    { 0x572E, "pǐ"},
    { 0x572F, "yí"},
    { 0x5730, "de,dì"},
    { 0x5731, "qiān,sú"},
    { 0x5732, "qiān"},
    { 0x5733, "zhèn,quǎn,chóu,huái"},
    { 0x5734, "zhuó"},
    { 0x5735, "dàng"},
    { 0x5736, "qià"},
    { 0x5737, "xià"},
    { 0x5738, "shān"},
    { 0x5739, "kuàng"},
    { 0x573A, "chǎng,cháng"},
    { 0x573B, "qí,yín"},
    { 0x573C, "niè"},
    { 0x573D, "mò"},
    { 0x573E, "jī,jí,jié"},
    { 0x573F, "jiá"},
    { 0x5740, "zhǐ"},
    { 0x5741, "zhǐ,zhì"},
    { 0x5742, "bǎn"},
    { 0x5743, "xūn"},
    { 0x5744, "yì"},
    { 0x5745, "qǐn"},
    { 0x5746, "méi,fén"},
    { 0x5747, "jūn,yùn"},
    { 0x5748, "rǒng,kēng"},
    { 0x5749, "tún,dùn"},
    { 0x574A, "fāng,fáng"},
    { 0x574B, "bèn,fèn"},
    { 0x574C, "bèn"},
    { 0x574D, "tān"},
    { 0x574E, "kǎn,kàn"},
    { 0x574F, "huài,pī,péi"},
    { 0x5750, "zuò"},
    { 0x5751, "kēng,kàng"},
    { 0x5752, "bì"},
    { 0x5753, "jǐng,xíng"},
    { 0x5754, "dì,làn"},
    { 0x5755, "jīng"},
    { 0x5756, "jì"},
    { 0x5757, "kuài,yué"},
    { 0x5758, "dǐ"},
    { 0x5759, "jīng"},
    { 0x575A, "jiān"},
    { 0x575B, "tán"},
    { 0x575C, "lì"},
    { 0x575D, "bà"},
    { 0x575E, "wù"},
    { 0x575F, "fén"},
    { 0x5760, "zhuì"},
    { 0x5761, "pō"},
    { 0x5762, "bàn,pǎn,pàn"},
    { 0x5763, "táng"},
    { 0x5764, "kūn"},
    { 0x5765, "qū,jù"},
    { 0x5766, "tǎn"},
    { 0x5767, "zhī"},
    { 0x5768, "tuó,yí"},
    { 0x5769, "gān"},
    { 0x576A, "píng"},
    { 0x576B, "diàn,zhēn"},
    { 0x576C, "guà"},
    { 0x576D, "ní"},
    { 0x576E, "tái"},
    { 0x576F, "pī,huài"},
    { 0x5770, "jiōng"},
    { 0x5771, "yǎng"},
    { 0x5772, "fó"},
    { 0x5773, "ào,āo,yǒu"},
    { 0x5774, "lù"},
    { 0x5775, "qiū"},
    { 0x5776, "mǔ,mù,méi"},
    { 0x5777, "kě,kē,jiōng"},
    { 0x5778, "gòu"},
    { 0x5779, "xuè"},
    { 0x577A, "bá"},
    { 0x577B, "chí,dǐ"},
    { 0x577C, "chè"},
    { 0x577D, "líng"},
    { 0x577E, "zhù"},
    { 0x577F, "fù,fú"},
    { 0x5780, "hū"},
    { 0x5781, "zhì"},
    { 0x5782, "chuí,zhuì"},
    { 0x5783, "lā,la"},
    { 0x5784, "lǒng"},
    { 0x5785, "lǒng"},
    { 0x5786, "lú"},
    { 0x5787, "ào"},
    { 0x5788, "dài"},
    { 0x5789, "páo"},
    { 0x578A, "min"},
    { 0x578B, "xíng"},
    { 0x578C, "dòng,tǒng,tóng"},
    { 0x578D, "jì,jī"},
    { 0x578E, "hè"},
    { 0x578F, "lǜ"},
    { 0x5790, "cí"},
    { 0x5791, "chǐ"},
    { 0x5792, "lěi"},
    { 0x5793, "gāi"},
    { 0x5794, "yīn"},
    { 0x5795, "hòu"},
    { 0x5796, "duī"},
    { 0x5797, "zhào"},
    { 0x5798, "fú"},
    { 0x5799, "guāng"},
    { 0x579A, "yáo"},
    { 0x579B, "duǒ,duò"},
    { 0x579C, "duǒ,duò"},
    { 0x579D, "guǐ"},
    { 0x579E, "chá"},
    { 0x579F, "yáng"},
    { 0x57A0, "yín,kèn"},
    { 0x57A1, "fá"},
    { 0x57A2, "gòu"},
    { 0x57A3, "yuán"},
    { 0x57A4, "dié"},
    { 0x57A5, "xié"},
    { 0x57A6, "kěn,yín"},
    { 0x57A7, "shǎng,jiōng"},
    { 0x57A8, "shǒu"},
    { 0x57A9, "è,shèng"},
    { 0x57AA, "bìng"},
    { 0x57AB, "diàn"},
    { 0x57AC, "hóng"},
    { 0x57AD, "yā"},
    { 0x57AE, "kuǎ"},
    { 0x57AF, "da"},
    { 0x57B0, "kǎ"},
    { 0x57B1, "dàng"},
    { 0x57B2, "kǎi"},
    { 0x57B3, "háng"},
    { 0x57B4, "nǎo"},
    { 0x57B5, "ǎn"},
    { 0x57B6, "xīng"},
    { 0x57B7, "xiàn"},
    { 0x57B8, "yuàn,huán"},
    { 0x57B9, "bāng"},
    { 0x57BA, "fū,fóu,pēi,póu"},
    { 0x57BB, "bà,bèi"},
    { 0x57BC, "yì"},
    { 0x57BD, "yìn"},
    { 0x57BE, "hàn,àn"},
    { 0x57BF, "xù"},
    { 0x57C0, "chuí"},
    { 0x57C1, "qín"},
    { 0x57C2, "gěng"},
    { 0x57C3, "āi,zhì"},
    { 0x57C4, "běng,fēng"},
    { 0x57C5, "fáng,fāng,dì"},
    { 0x57C6, "què,jué"},
    { 0x57C7, "yǒng"},
    { 0x57C8, "jùn"},
    { 0x57C9, "jiā,xiá"},
    { 0x57CA, "dì"},
    { 0x57CB, "mái,mán"},
    { 0x57CC, "làng"},
    { 0x57CD, "juǎn"},
    { 0x57CE, "chéng"},
    { 0x57CF, "shān,yán"},
    { 0x57D0, "jīn,qín"},
    { 0x57D1, "zhé"},
    { 0x57D2, "liè"},
    { 0x57D3, "liè"},
    { 0x57D4, "pǔ,bù"},
    { 0x57D5, "chéng"},
    { 0x57D6, "huā"},
    { 0x57D7, "bù"},
    { 0x57D8, "shí"},
    { 0x57D9, "xūn"},
    { 0x57DA, "guō"},
    { 0x57DB, "jiōng"},
    { 0x57DC, "yě"},
    { 0x57DD, "niàn,diàn,niè"},
    { 0x57DE, "dī"},
    { 0x57DF, "yù"},
    { 0x57E0, "bù"},
    { 0x57E1, "yā,è,wǔ,yà"},
    { 0x57E2, "quán,juǎn"},
    { 0x57E3, "suì,sù"},
    { 0x57E4, "pí,bì,pì,bēi"},
    { 0x57E5, "qīng,zhēng"},
    { 0x57E6, "wǎn,wān"},
    { 0x57E7, "jù"},
    { 0x57E8, "lǔn,lùn"},
    { 0x57E9, "zhēng,chéng"},
    { 0x57EA, "kōng"},
    { 0x57EB, "chǒng,shǎng"},
    { 0x57EC, "dōng"},
    { 0x57ED, "dài"},
    { 0x57EE, "tàn,tán"},
    { 0x57EF, "ǎn,yǎn"},
    { 0x57F0, "cài,cǎi"},
    { 0x57F1, "chù,tòu"},
    { 0x57F2, "běng,bàng"},
    { 0x57F3, "kǎn,xiàn"},
    { 0x57F4, "zhí"},
    { 0x57F5, "duǒ"},
    { 0x57F6, "yì,shì"},
    { 0x57F7, "zhí"},
    { 0x57F8, "yì"},
    { 0x57F9, "péi,pǒu,pī"},
    { 0x57FA, "jī"},
    { 0x57FB, "zhǔn,duī,guó"},
    { 0x57FC, "qí"},
    { 0x57FD, "sào,sǎo"},
    { 0x57FE, "jù"},
    { 0x57FF, "ní,nì,bàn"},
    { 0x5800, "kū"},
    { 0x5801, "kè"},
    { 0x5802, "táng"},
    { 0x5803, "kūn"},
    { 0x5804, "nì"},
    { 0x5805, "jiān"},
    { 0x5806, "duī,zuī"},
    { 0x5807, "jǐn,qín,jìn"},
    { 0x5808, "gāng"},
    { 0x5809, "yù"},
    { 0x580A, "è,yà"},
    { 0x580B, "péng,bèng,pēng,pīng"},
    { 0x580C, "gù"},
    { 0x580D, "tù"},
    { 0x580E, "lèng"},
    { 0x580F, "fang"},
    { 0x5810, "yá"},
    { 0x5811, "qiàn"},
    { 0x5812, "kūn"},
    { 0x5813, "àn"},
    { 0x5814, "shēn"},
    { 0x5815, "duò,huī"},
    { 0x5816, "nǎo"},
    { 0x5817, "tū"},
    { 0x5818, "chéng"},
    { 0x5819, "yīn"},
    { 0x581A, "hún"},
    { 0x581B, "bì"},
    { 0x581C, "liàn"},
    { 0x581D, "guō,wō"},
    { 0x581E, "dié"},
    { 0x581F, "zhuàn"},
    { 0x5820, "hòu"},
    { 0x5821, "bǎo,bǔ,pù"},
    { 0x5822, "bǎo"},
    { 0x5823, "yú"},
    { 0x5824, "dī,tí,dǐ,shí,wéi"},
    { 0x5825, "máo,móu,wǔ"},
    { 0x5826, "jiē"},
    { 0x5827, "ruán,nuò"},
    { 0x5828, "yè,ài,è"},
    { 0x5829, "gèng"},
    { 0x582A, "kān,chěn"},
    { 0x582B, "zōng"},
    { 0x582C, "yú"},
    { 0x582D, "huáng"},
    { 0x582E, "è"},
    { 0x582F, "yáo"},
    { 0x5830, "yàn"},
    { 0x5831, "bào,fù"},
    { 0x5832, "cí,jí"},
    { 0x5833, "méi"},
    { 0x5834, "chǎng,cháng,shāng,dàng"},
    { 0x5835, "dǔ,zhě,dū"},
    { 0x5836, "tuó"},
    { 0x5837, "yìn,pǒu"},
    { 0x5838, "féng"},
    { 0x5839, "zhòng"},
    { 0x583A, "jiè"},
    { 0x583B, "jīn"},
    { 0x583C, "hèng"},
    { 0x583D, "gāng"},
    { 0x583E, "chūn"},
    { 0x583F, "jiǎn,kǎn,xián"},
    { 0x5840, "píng"},
    { 0x5841, "lěi"},
    { 0x5842, "xiàng,jiǎng"},
    { 0x5843, "huāng"},
    { 0x5844, "léng"},
    { 0x5845, "duàn"},
    { 0x5846, "wān"},
    { 0x5847, "xuān"},
    { 0x5848, "jì,xì"},
    { 0x5849, "jí"},
    { 0x584A, "kuài"},
    { 0x584B, "yíng"},
    { 0x584C, "tā,dā"},
    { 0x584D, "chéng"},
    { 0x584E, "yǒng"},
    { 0x584F, "kǎi"},
    { 0x5850, "sù"},
    { 0x5851, "sù"},
    { 0x5852, "shí"},
    { 0x5853, "mì"},
    { 0x5854, "tǎ,dā,da"},
    { 0x5855, "wěng"},
    { 0x5856, "chéng"},
    { 0x5857, "tú,dù"},
    { 0x5858, "táng"},
    { 0x5859, "què,qiāo"},
    { 0x585A, "zhǒng"},
    { 0x585B, "lì"},
    { 0x585C, "zhǒng,péng"},
    { 0x585D, "bàng"},
    { 0x585E, "sāi,sè,sài"},
    { 0x585F, "zàng"},
    { 0x5860, "duī"},
    { 0x5861, "tián"},
    { 0x5862, "wù,wǔ"},
    { 0x5863, "zhèng"},
    { 0x5864, "xūn"},
    { 0x5865, "gé"},
    { 0x5866, "zhèn"},
    { 0x5867, "ài"},
    { 0x5868, "gōng"},
    { 0x5869, "yán"},
    { 0x586A, "kǎn"},
    { 0x586B, "tián,tiǎn,chén,zhèn"},
    { 0x586C, "yuán"},
    { 0x586D, "wēn"},
    { 0x586E, "xiè"},
    { 0x586F, "liù"},
    { 0x5870, "hǎi"},
    { 0x5871, "lǎng"},
    { 0x5872, "cháng,shāng,chǎng"},
    { 0x5873, "péng"},
    { 0x5874, "bèng"},
    { 0x5875, "chén"},
    { 0x5876, "lù"},
    { 0x5877, "lǔ"},
    { 0x5878, "ōu"},
    { 0x5879, "qiàn,jiàn"},
    { 0x587A, "méi"},
    { 0x587B, "mò"},
    { 0x587C, "zhuān,tuán"},
    { 0x587D, "shuǎng"},
    { 0x587E, "shú"},
    { 0x587F, "lǒu"},
    { 0x5880, "chí"},
    { 0x5881, "màn"},
    { 0x5882, "biāo"},
    { 0x5883, "jìng"},
    { 0x5884, "cè"},
    { 0x5885, "shù,yě"},
    { 0x5886, "zhì,dì"},
    { 0x5887, "zhàng"},
    { 0x5888, "kàn"},
    { 0x5889, "yōng"},
    { 0x588A, "diàn"},
    { 0x588B, "chěn"},
    { 0x588C, "zhí,zhuó"},
    { 0x588D, "xì"},
    { 0x588E, "guō"},
    { 0x588F, "qiǎng"},
    { 0x5890, "jìn,qín"},
    { 0x5891, "dì"},
    { 0x5892, "shāng"},
    { 0x5893, "mù"},
    { 0x5894, "cuī"},
    { 0x5895, "yàn"},
    { 0x5896, "tǎ"},
    { 0x5897, "zēng"},
    { 0x5898, "qián"},
    { 0x5899, "qiáng"},
    { 0x589A, "liáng"},
    { 0x589B, "wèi"},
    { 0x589C, "zhuì"},
    { 0x589D, "qiāo,qiào"},
    { 0x589E, "zēng,zèng,céng"},
    { 0x589F, "xū"},
    { 0x58A0, "shàn,chǎn"},
    { 0x58A1, "shàn"},
    { 0x58A2, "bá,fèi"},
    { 0x58A3, "pú"},
    { 0x58A4, "kuài,tuí"},
    { 0x58A5, "dǒng,tuǎn"},
    { 0x58A6, "fán,fān"},
    { 0x58A7, "què,qiáo"},
    { 0x58A8, "mò,mèi"},
    { 0x58A9, "dūn"},
    { 0x58AA, "dūn"},
    { 0x58AB, "zūn,cūn"},
    { 0x58AC, "dì"},
    { 0x58AD, "shèng"},
    { 0x58AE, "duò,huī,huì"},
    { 0x58AF, "duò"},
    { 0x58B0, "tán"},
    { 0x58B1, "dèng,dēng"},
    { 0x58B2, "mú,wú"},
    { 0x58B3, "fén,fèn"},
    { 0x58B4, "huáng"},
    { 0x58B5, "tán"},
    { 0x58B6, "da"},
    { 0x58B7, "yè"},
    { 0x58B8, "zhù"},
    { 0x58B9, "jiàn"},
    { 0x58BA, "ào"},
    { 0x58BB, "qiáng"},
    { 0x58BC, "jī"},
    { 0x58BD, "qiāo,qiào,áo"},
    { 0x58BE, "kěn"},
    { 0x58BF, "yì,tú"},
    { 0x58C0, "pí"},
    { 0x58C1, "bì"},
    { 0x58C2, "diàn"},
    { 0x58C3, "jiāng"},
    { 0x58C4, "yě"},
    { 0x58C5, "yōng,wèng"},
    { 0x58C6, "xué,jué,bó"},
    { 0x58C7, "tán,shàn,dàn,tǎn"},
    { 0x58C8, "lǎn"},
    { 0x58C9, "jù"},
    { 0x58CA, "huài"},
    { 0x58CB, "dàng"},
    { 0x58CC, "rǎng"},
    { 0x58CD, "qiàn"},
    { 0x58CE, "xūn,xùn"},
    { 0x58CF, "xiàn,làn"},
    { 0x58D0, "xǐ"},
    { 0x58D1, "hè,huò"},
    { 0x58D2, "ài"},
    { 0x58D3, "yā,yà"},
    { 0x58D4, "dǎo"},
    { 0x58D5, "háo"},
    { 0x58D6, "ruán"},
    { 0x58D7, "jìn"},
    { 0x58D8, "lěi,léi,lǜ"},
    { 0x58D9, "kuàng,kuǎng"},
    { 0x58DA, "lú"},
    { 0x58DB, "yán"},
    { 0x58DC, "tán"},
    { 0x58DD, "wěi"},
    { 0x58DE, "huài,huì,huái"},
    { 0x58DF, "lǒng"},
    { 0x58E0, "lǒng"},
    { 0x58E1, "ruì"},
    { 0x58E2, "lì"},
    { 0x58E3, "lín"},
    { 0x58E4, "rǎng"},
    { 0x58E5, "chán"},
    { 0x58E6, "xūn"},
    { 0x58E7, "yán"},
    { 0x58E8, "léi"},
    { 0x58E9, "bà"},
    { 0x58EA, "wān"},
    { 0x58EB, "shì"},
    { 0x58EC, "rén"},
    { 0x58ED, "san"},
    { 0x58EE, "zhuàng"},
    { 0x58EF, "zhuàng,zhuāng"},
    { 0x58F0, "shēng,qìng"},
    { 0x58F1, "yī"},
    { 0x58F2, "mài"},
    { 0x58F3, "ké,qiào"},
    { 0x58F4, "zhù"},
    { 0x58F5, "zhuàng"},
    { 0x58F6, "hú"},
    { 0x58F7, "hú"},
    { 0x58F8, "kǔn"},
    { 0x58F9, "yī,yīn"},
    { 0x58FA, "hú"},
    { 0x58FB, "xù"},
    { 0x58FC, "kǔn"},
    { 0x58FD, "shòu"},
    { 0x58FE, "mǎng"},
    { 0x58FF, "zūn"},
    { 0x5900, "shòu"},
    { 0x5901, "yī"},
    { 0x5902, "zhǐ,zhōng"},
    { 0x5903, "gǔ,yíng"},
    { 0x5904, "chù,chǔ"},
    { 0x5905, "jiàng"},
    { 0x5906, "féng,páng"},
    { 0x5907, "bèi"},
    { 0x5908, "zhāi"},
    { 0x5909, "biàn"},
    { 0x590A, "suī"},
    { 0x590B, "qūn"},
    { 0x590C, "líng"},
    { 0x590D, "fù"},
    { 0x590E, "cuò"},
    { 0x590F, "xià,jiǎ"},
    { 0x5910, "xiòng,xuàn"},
    { 0x5911, "xiè"},
    { 0x5912, "náo"},
    { 0x5913, "xià"},
    { 0x5914, "kuí"},
    { 0x5915, "xī,yì"},
    { 0x5916, "wài"},
    { 0x5917, "yuàn,wǎn,wān,yuān"},
    { 0x5918, "mǎo,wān"},
    { 0x5919, "sù"},
    { 0x591A, "duō"},
    { 0x591B, "duō"},
    { 0x591C, "yè"},
    { 0x591D, "qíng"},
    { 0x591E, "wài"},
    { 0x591F, "gòu"},
    { 0x5920, "gòu"},
    { 0x5921, "qì"},
    { 0x5922, "mèng,méng"},
    { 0x5923, "mèng"},
    { 0x5924, "yín"},
    { 0x5925, "huǒ"},
    { 0x5926, "chěn"},
    { 0x5927, "dà,dài,tài"},
    { 0x5928, "zè"},
    { 0x5929, "tiān"},
    { 0x592A, "tài,tā"},
    { 0x592B, "fū,fú"},
    { 0x592C, "guài,jué"},
    { 0x592D, "yāo,wò,wāi"},
    { 0x592E, "yāng,yīng"},
    { 0x592F, "hāng,bèn"},
    { 0x5930, "gǎo"},
    { 0x5931, "shī,yì"},
    { 0x5932, "tāo,běn"},
    { 0x5933, "tài"},
    { 0x5934, "tóu,tou"},
    { 0x5935, "yǎn,tāo"},
    { 0x5936, "bǐ"},
    { 0x5937, "yí"},
    { 0x5938, "kuā,kuà,kuǎ"},
    { 0x5939, "jiā,gā,jiá"},
    { 0x593A, "duó"},
    { 0x593B, "huà"},
    { 0x593C, "kuǎng"},
    { 0x593D, "yǔn"},
    { 0x593E, "jiā,jiá,xié,xiá,gā"},
    { 0x593F, "bā"},
    { 0x5940, "ēn"},
    { 0x5941, "lián"},
    { 0x5942, "huàn"},
    { 0x5943, "dī,tì"},
    { 0x5944, "yǎn,yān"},
    { 0x5945, "pào"},
    { 0x5946, "juàn"},
    { 0x5947, "qí,jī,ǎi,yǐ"},
    { 0x5948, "nài"},
    { 0x5949, "fèng"},
    { 0x594A, "xié,liè,xǐ,pí"},
    { 0x594B, "fèn,kǎng"},
    { 0x594C, "diǎn"},
    { 0x594D, "quān"},
    { 0x594E, "kuí,kuǐ"},
    { 0x594F, "zòu,còu"},
    { 0x5950, "huàn"},
    { 0x5951, "qì,xiè,qiè,jié"},
    { 0x5952, "kāi"},
    { 0x5953, "zhā,shē,chǐ,zhà"},
    { 0x5954, "bēn,bèn,fèn"},
    { 0x5955, "yì"},
    { 0x5956, "jiǎng"},
    { 0x5957, "tào,tǎo"},
    { 0x5958, "zàng,zhuǎng"},
    { 0x5959, "běn"},
    { 0x595A, "xī"},
    { 0x595B, "huǎng"},
    { 0x595C, "fěi,fēi"},
    { 0x595D, "diāo"},
    { 0x595E, "xùn"},
    { 0x595F, "bēng,kēng"},
    { 0x5960, "diàn,tíng,dìng,zhèng,zūn"},
    { 0x5961, "ào,xiào"},
    { 0x5962, "shē"},
    { 0x5963, "wěng"},
    { 0x5964, "hǎ,pò,tǎi"},
    { 0x5965, "ào,yù,yōu"},
    { 0x5966, "wù"},
    { 0x5967, "ào"},
    { 0x5968, "jiǎng"},
    { 0x5969, "lián"},
    { 0x596A, "duó,duì"},
    { 0x596B, "yūn"},
    { 0x596C, "jiǎng"},
    { 0x596D, "shì"},
    { 0x596E, "fèn"},
    { 0x596F, "huò"},
    { 0x5970, "bì"},
    { 0x5971, "luán"},
    { 0x5972, "duǒ,chě"},
    { 0x5973, "nǚ,nǜ,rǔ"},
    { 0x5974, "nú"},
    { 0x5975, "dǐng,dīng,tiǎn"},
    { 0x5976, "nǎi"},
    { 0x5977, "qiān"},
    { 0x5978, "jiān,gān"},
    { 0x5979, "tā,jiě,chí"},
    { 0x597A, "jiǔ"},
    { 0x597B, "nuán"},
    { 0x597C, "chà"},
    { 0x597D, "hǎo,hào"},
    { 0x597E, "xiān"},
    { 0x597F, "fàn"},
    { 0x5980, "jǐ"},
    { 0x5981, "shuò,yuē"},
    { 0x5982, "rú"},
    { 0x5983, "fēi,pèi"},
    { 0x5984, "wàng,wáng"},
    { 0x5985, "hóng"},
    { 0x5986, "zhuāng"},
    { 0x5987, "fù"},
    { 0x5988, "mā"},
    { 0x5989, "dān"},
    { 0x598A, "rèn,rén"},
    { 0x598B, "fū,yōu"},
    { 0x598C, "jìng"},
    { 0x598D, "yán"},
    { 0x598E, "hài,jiè"},
    { 0x598F, "wèn"},
    { 0x5990, "zhōng"},
    { 0x5991, "pā"},
    { 0x5992, "dù"},
    { 0x5993, "jì,jī"},
    { 0x5994, "kēng,háng"},
    { 0x5995, "zhòng"},
    { 0x5996, "yāo,jiǎo"},
    { 0x5997, "jìn,xiān"},
    { 0x5998, "yún"},
    { 0x5999, "miào,miǎo"},
    { 0x599A, "fǒu,pēi,pī"},
    { 0x599B, "chī"},
    { 0x599C, "yuè,jué"},
    { 0x599D, "zhuāng"},
    { 0x599E, "niū,hào"},
    { 0x599F, "yàn"},
    { 0x59A0, "nà,nàn"},
    { 0x59A1, "xīn"},
    { 0x59A2, "fén"},
    { 0x59A3, "bǐ"},
    { 0x59A4, "yú"},
    { 0x59A5, "tuǒ"},
    { 0x59A6, "fēng"},
    { 0x59A7, "wàn,yuán"},
    { 0x59A8, "fáng,fāng"},
    { 0x59A9, "wǔ"},
    { 0x59AA, "yù"},
    { 0x59AB, "guī"},
    { 0x59AC, "dù"},
    { 0x59AD, "bá,bō"},
    { 0x59AE, "nī,ní"},
    { 0x59AF, "zhóu,chōu"},
    { 0x59B0, "zhuó"},
    { 0x59B1, "zhāo"},
    { 0x59B2, "dá"},
    { 0x59B3, "nǐ,nǎi"},
    { 0x59B4, "yuàn"},
    { 0x59B5, "tǒu"},
    { 0x59B6, "xián,xuán,xù"},
    { 0x59B7, "zhí,yì"},
    { 0x59B8, "ē,ě"},
    { 0x59B9, "mèi"},
    { 0x59BA, "mò"},
    { 0x59BB, "qī,qì"},
    { 0x59BC, "bì"},
    { 0x59BD, "shēn"},
    { 0x59BE, "qiè"},
    { 0x59BF, "ē"},
    { 0x59C0, "hé"},
    { 0x59C1, "xǔ,xū"},
    { 0x59C2, "fá"},
    { 0x59C3, "zhēng"},
    { 0x59C4, "mín"},
    { 0x59C5, "bàn"},
    { 0x59C6, "mǔ"},
    { 0x59C7, "fū,fú"},
    { 0x59C8, "líng"},
    { 0x59C9, "zǐ"},
    { 0x59CA, "zǐ"},
    { 0x59CB, "shǐ"},
    { 0x59CC, "rǎn"},
    { 0x59CD, "shān,xiān,pān"},
    { 0x59CE, "yāng"},
    { 0x59CF, "mán"},
    { 0x59D0, "jiě,jù,xù,zū"},
    { 0x59D1, "gū"},
    { 0x59D2, "sì"},
    { 0x59D3, "xìng,shēng"},
    { 0x59D4, "wěi,wēi,wèi"},
    { 0x59D5, "zī,cǐ,cī"},
    { 0x59D6, "jù"},
    { 0x59D7, "shān"},
    { 0x59D8, "pīn,pín"},
    { 0x59D9, "rèn"},
    { 0x59DA, "yáo,tiào,táo,yào"},
    { 0x59DB, "dòng"},
    { 0x59DC, "jiāng"},
    { 0x59DD, "shū"},
    { 0x59DE, "jí"},
    { 0x59DF, "gāi"},
    { 0x59E0, "xiàng"},
    { 0x59E1, "huá,huó"},
    { 0x59E2, "juān"},
    { 0x59E3, "jiāo,jiǎo,xiáo"},
    { 0x59E4, "gòu"},
    { 0x59E5, "lǎo,mǔ"},
    { 0x59E6, "jiān"},
    { 0x59E7, "jiān"},
    { 0x59E8, "yí"},
    { 0x59E9, "niàn,nián"},
    { 0x59EA, "zhí"},
    { 0x59EB, "jī,zhěn"},
    { 0x59EC, "jī,yí"},
    { 0x59ED, "xiàn"},
    { 0x59EE, "héng"},
    { 0x59EF, "guāng"},
    { 0x59F0, "jūn,xūn,xuàn,xīn"},
    { 0x59F1, "kuā,hù"},
    { 0x59F2, "yàn"},
    { 0x59F3, "mǐng"},
    { 0x59F4, "liè"},
    { 0x59F5, "pèi"},
    { 0x59F6, "è,yà"},
    { 0x59F7, "yòu"},
    { 0x59F8, "yán"},
    { 0x59F9, "chà"},
    { 0x59FA, "shēn,xiān"},
    { 0x59FB, "yīn"},
    { 0x59FC, "shí,tí,jì"},
    { 0x59FD, "guǐ,wá"},
    { 0x59FE, "quán"},
    { 0x59FF, "zī,zì"},
    { 0x5A00, "sōng"},
    { 0x5A01, "wēi"},
    { 0x5A02, "hóng"},
    { 0x5A03, "wá,wā,guì"},
    { 0x5A04, "lóu"},
    { 0x5A05, "yà"},
    { 0x5A06, "ráo,rǎo"},
    { 0x5A07, "jiāo"},
    { 0x5A08, "luán"},
    { 0x5A09, "pīng,pìn"},
    { 0x5A0A, "xiàn,dān"},
    { 0x5A0B, "shào,shāo"},
    { 0x5A0C, "lǐ"},
    { 0x5A0D, "chéng,shèng"},
    { 0x5A0E, "xiè"},
    { 0x5A0F, "máng"},
    { 0x5A10, "fū"},
    { 0x5A11, "suō,suǒ,suò"},
    { 0x5A12, "méi,mǔ,wǔ"},
    { 0x5A13, "wěi"},
    { 0x5A14, "kè"},
    { 0x5A15, "chuò,cù,lài"},
    { 0x5A16, "chuò,cù"},
    { 0x5A17, "tǐng,tiǎn"},
    { 0x5A18, "niáng"},
    { 0x5A19, "xíng"},
    { 0x5A1A, "nán"},
    { 0x5A1B, "yú"},
    { 0x5A1C, "nà,nuó"},
    { 0x5A1D, "pōu,bǐ"},
    { 0x5A1E, "něi,suī"},
    { 0x5A1F, "juān"},
    { 0x5A20, "shēn"},
    { 0x5A21, "zhì"},
    { 0x5A22, "hán"},
    { 0x5A23, "dì"},
    { 0x5A24, "zhuāng"},
    { 0x5A25, "é"},
    { 0x5A26, "pín"},
    { 0x5A27, "tuì"},
    { 0x5A28, "xiàn"},
    { 0x5A29, "miǎn,wǎn,wèn"},
    { 0x5A2A, "wú,wù,yú"},
    { 0x5A2B, "yán"},
    { 0x5A2C, "wǔ"},
    { 0x5A2D, "āi,xī"},
    { 0x5A2E, "yán"},
    { 0x5A2F, "yú"},
    { 0x5A30, "sì"},
    { 0x5A31, "yú"},
    { 0x5A32, "wā"},
    { 0x5A33, "lì"},
    { 0x5A34, "xián"},
    { 0x5A35, "jū"},
    { 0x5A36, "qǔ,jū,shū"},
    { 0x5A37, "zhuì,shuì"},
    { 0x5A38, "qī"},
    { 0x5A39, "xián"},
    { 0x5A3A, "zhuó"},
    { 0x5A3B, "dōng,dòng"},
    { 0x5A3C, "chāng"},
    { 0x5A3D, "lù"},
    { 0x5A3E, "ǎi,ái,è"},
    { 0x5A3F, "ē,ě"},
    { 0x5A40, "ē,ě"},
    { 0x5A41, "lóu,lǚ,lǘ,léi"},
    { 0x5A42, "mián"},
    { 0x5A43, "cóng"},
    { 0x5A44, "pǒu,péi,bù"},
    { 0x5A45, "jú"},
    { 0x5A46, "pó"},
    { 0x5A47, "cǎi"},
    { 0x5A48, "líng"},
    { 0x5A49, "wǎn"},
    { 0x5A4A, "biǎo"},
    { 0x5A4B, "xiāo"},
    { 0x5A4C, "shú"},
    { 0x5A4D, "qǐ"},
    { 0x5A4E, "huī"},
    { 0x5A4F, "fàn,fù"},
    { 0x5A50, "wǒ"},
    { 0x5A51, "ruí,wǒ,něi"},
    { 0x5A52, "tán"},
    { 0x5A53, "fēi"},
    { 0x5A54, "fēi"},
    { 0x5A55, "jié,qiè"},
    { 0x5A56, "tiān"},
    { 0x5A57, "ní,nǐ"},
    { 0x5A58, "quán,juàn"},
    { 0x5A59, "jìng"},
    { 0x5A5A, "hūn"},
    { 0x5A5B, "jīng"},
    { 0x5A5C, "qiān,jǐn"},
    { 0x5A5D, "diàn"},
    { 0x5A5E, "xìng"},
    { 0x5A5F, "hù"},
    { 0x5A60, "wān,guàn"},
    { 0x5A61, "lái,lài"},
    { 0x5A62, "bì"},
    { 0x5A63, "yīn"},
    { 0x5A64, "chōu,zhōu"},
    { 0x5A65, "nào,chuò"},
    { 0x5A66, "fù"},
    { 0x5A67, "jìng"},
    { 0x5A68, "lún"},
    { 0x5A69, "àn,nüè"},
    { 0x5A6A, "lán,lǎn"},
    { 0x5A6B, "kūn,hùn"},
    { 0x5A6C, "yín"},
    { 0x5A6D, "yà,yā,yǎ"},
    { 0x5A6E, "jū"},
    { 0x5A6F, "lì"},
    { 0x5A70, "diǎn"},
    { 0x5A71, "xián"},
    { 0x5A72, "huā"},
    { 0x5A73, "huà"},
    { 0x5A74, "yīng"},
    { 0x5A75, "chán"},
    { 0x5A76, "shěn"},
    { 0x5A77, "tíng"},
    { 0x5A78, "dàng,yáng"},
    { 0x5A79, "yǎo"},
    { 0x5A7A, "wù,móu,mù"},
    { 0x5A7B, "nàn"},
    { 0x5A7C, "chuò,ruò"},
    { 0x5A7D, "jiǎ"},
    { 0x5A7E, "tōu"},
    { 0x5A7F, "xù"},
    { 0x5A80, "yù,yú"},
    { 0x5A81, "wéi,wěi"},
    { 0x5A82, "dì,tí"},
    { 0x5A83, "róu"},
    { 0x5A84, "měi"},
    { 0x5A85, "dān"},
    { 0x5A86, "ruǎn,nèn,nùn"},
    { 0x5A87, "qīn"},
    { 0x5A88, "huī"},
    { 0x5A89, "wò"},
    { 0x5A8A, "qián"},
    { 0x5A8B, "chūn"},
    { 0x5A8C, "miáo"},
    { 0x5A8D, "fù"},
    { 0x5A8E, "jiě"},
    { 0x5A8F, "duān"},
    { 0x5A90, "yí,xī"},
    { 0x5A91, "zhòng"},
    { 0x5A92, "méi,mèi"},
    { 0x5A93, "huáng"},
    { 0x5A94, "mián,miǎn"},
    { 0x5A95, "ān,yǎn,è"},
    { 0x5A96, "yīng"},
    { 0x5A97, "xuān"},
    { 0x5A98, "jiē"},
    { 0x5A99, "wēi"},
    { 0x5A9A, "mèi"},
    { 0x5A9B, "yuàn,yuán"},
    { 0x5A9C, "zhēng"},
    { 0x5A9D, "qiū"},
    { 0x5A9E, "shì,tí,zhī,dài"},
    { 0x5A9F, "xiè"},
    { 0x5AA0, "tuǒ,duò,nuǒ"},
    { 0x5AA1, "liàn"},
    { 0x5AA2, "mào"},
    { 0x5AA3, "rǎn"},
    { 0x5AA4, "sī"},
    { 0x5AA5, "piān"},
    { 0x5AA6, "wèi"},
    { 0x5AA7, "wā"},
    { 0x5AA8, "cù"},
    { 0x5AA9, "hú"},
    { 0x5AAA, "ǎo,yǔn,wò"},
    { 0x5AAB, "jié"},
    { 0x5AAC, "bǎo"},
    { 0x5AAD, "xū"},
    { 0x5AAE, "tōu,yú"},
    { 0x5AAF, "guī,guì"},
    { 0x5AB0, "chú,zòu"},
    { 0x5AB1, "yáo"},
    { 0x5AB2, "pì,bī,pí"},
    { 0x5AB3, "xí"},
    { 0x5AB4, "yuán"},
    { 0x5AB5, "yìng,shèng"},
    { 0x5AB6, "róng"},
    { 0x5AB7, "rù"},
    { 0x5AB8, "chī"},
    { 0x5AB9, "liú"},
    { 0x5ABA, "měi"},
    { 0x5ABB, "pán"},
    { 0x5ABC, "ǎo"},
    { 0x5ABD, "mā"},
    { 0x5ABE, "gòu"},
    { 0x5ABF, "kuì,chǒu"},
    { 0x5AC0, "qín,shēn"},
    { 0x5AC1, "jià"},
    { 0x5AC2, "sǎo"},
    { 0x5AC3, "zhēn,zhěn"},
    { 0x5AC4, "yuán"},
    { 0x5AC5, "jiē,suǒ"},
    { 0x5AC6, "róng"},
    { 0x5AC7, "míng,mǐng,méng"},
    { 0x5AC8, "yīng,xīng,yíng"},
    { 0x5AC9, "jí"},
    { 0x5ACA, "sù"},
    { 0x5ACB, "niǎo"},
    { 0x5ACC, "xián"},
    { 0x5ACD, "tāo"},
    { 0x5ACE, "páng,bàng"},
    { 0x5ACF, "láng"},
    { 0x5AD0, "nǎo"},
    { 0x5AD1, "báo"},
    { 0x5AD2, "ài"},
    { 0x5AD3, "pì"},
    { 0x5AD4, "pín"},
    { 0x5AD5, "yì"},
    { 0x5AD6, "piáo,piào,biāo"},
    { 0x5AD7, "yù,yǔ,kōu"},
    { 0x5AD8, "léi"},
    { 0x5AD9, "xuán"},
    { 0x5ADA, "mān,màn,yuān"},
    { 0x5ADB, "yī"},
    { 0x5ADC, "zhāng"},
    { 0x5ADD, "kāng"},
    { 0x5ADE, "yōng"},
    { 0x5ADF, "nì"},
    { 0x5AE0, "lí"},
    { 0x5AE1, "dí"},
    { 0x5AE2, "guī,zuī"},
    { 0x5AE3, "yān"},
    { 0x5AE4, "jǐn,jìn"},
    { 0x5AE5, "zhuān,tuán"},
    { 0x5AE6, "cháng"},
    { 0x5AE7, "zé,cè"},
    { 0x5AE8, "hān,nǎn"},
    { 0x5AE9, "nèn"},
    { 0x5AEA, "lào,láo"},
    { 0x5AEB, "mó"},
    { 0x5AEC, "zhē"},
    { 0x5AED, "hù"},
    { 0x5AEE, "hù"},
    { 0x5AEF, "ào"},
    { 0x5AF0, "nèn"},
    { 0x5AF1, "qiáng"},
    { 0x5AF2, "ma"},
    { 0x5AF3, "piè"},
    { 0x5AF4, "gū"},
    { 0x5AF5, "wǔ"},
    { 0x5AF6, "qiáo,jiāo"},
    { 0x5AF7, "tuǒ"},
    { 0x5AF8, "zhǎn"},
    { 0x5AF9, "miáo"},
    { 0x5AFA, "xián"},
    { 0x5AFB, "xián"},
    { 0x5AFC, "mò"},
    { 0x5AFD, "liáo,liǎo,liào,lǎo"},
    { 0x5AFE, "lián"},
    { 0x5AFF, "huà"},
    { 0x5B00, "guī"},
    { 0x5B01, "dēng"},
    { 0x5B02, "zhí"},
    { 0x5B03, "xū"},
    { 0x5B04, "yī"},
    { 0x5B05, "huà"},
    { 0x5B06, "xī"},
    { 0x5B07, "kuì"},
    { 0x5B08, "ráo,rǎo,yǎo"},
    { 0x5B09, "xī,xǐ"},
    { 0x5B0A, "yàn"},
    { 0x5B0B, "chán"},
    { 0x5B0C, "jiāo"},
    { 0x5B0D, "měi"},
    { 0x5B0E, "fàn,fù"},
    { 0x5B0F, "fān"},
    { 0x5B10, "xiān,yǎn,jìn"},
    { 0x5B11, "yì"},
    { 0x5B12, "huì"},
    { 0x5B13, "jiào"},
    { 0x5B14, "fù"},
    { 0x5B15, "shì"},
    { 0x5B16, "bì"},
    { 0x5B17, "shàn,chán"},
    { 0x5B18, "suì"},
    { 0x5B19, "qiáng"},
    { 0x5B1A, "liǎn"},
    { 0x5B1B, "huán,xuān,qióng,xuán"},
    { 0x5B1C, "xīn"},
    { 0x5B1D, "niǎo"},
    { 0x5B1E, "dǒng"},
    { 0x5B1F, "yì,yǐ"},
    { 0x5B20, "cān"},
    { 0x5B21, "ài"},
    { 0x5B22, "niáng"},
    { 0x5B23, "níng"},
    { 0x5B24, "mā"},
    { 0x5B25, "tiǎo,diào"},
    { 0x5B26, "chóu"},
    { 0x5B27, "jìn"},
    { 0x5B28, "cí"},
    { 0x5B29, "yú"},
    { 0x5B2A, "pín"},
    { 0x5B2B, "róng"},
    { 0x5B2C, "rú,nòu"},
    { 0x5B2D, "nǎi,ěr,nì"},
    { 0x5B2E, "yān,yàn"},
    { 0x5B2F, "tái"},
    { 0x5B30, "yīng,yìng"},
    { 0x5B31, "qiàn"},
    { 0x5B32, "niǎo"},
    { 0x5B33, "yuè"},
    { 0x5B34, "yíng"},
    { 0x5B35, "mián"},
    { 0x5B36, "bí"},
    { 0x5B37, "mā"},
    { 0x5B38, "shěn"},
    { 0x5B39, "xìng,xīng"},
    { 0x5B3A, "nì"},
    { 0x5B3B, "dú"},
    { 0x5B3C, "liǔ"},
    { 0x5B3D, "yuān"},
    { 0x5B3E, "lǎn"},
    { 0x5B3F, "yàn"},
    { 0x5B40, "shuāng"},
    { 0x5B41, "líng"},
    { 0x5B42, "jiǎo"},
    { 0x5B43, "niáng,ráng"},
    { 0x5B44, "lǎn"},
    { 0x5B45, "qiān,xiān"},
    { 0x5B46, "yīng"},
    { 0x5B47, "shuāng"},
    { 0x5B48, "huì,xié"},
    { 0x5B49, "quán,huān"},
    { 0x5B4A, "mǐ"},
    { 0x5B4B, "lí,lì"},
    { 0x5B4C, "luán,liàn,luǎn"},
    { 0x5B4D, "yán,yǎn"},
    { 0x5B4E, "zhú,shú,chuò"},
    { 0x5B4F, "lǎn"},
    { 0x5B50, "zi,zǐ"},
    { 0x5B51, "jié"},
    { 0x5B52, "jué"},
    { 0x5B53, "jué"},
    { 0x5B54, "kǒng"},
    { 0x5B55, "yùn"},
    { 0x5B56, "mā,zī"},
    { 0x5B57, "zì"},
    { 0x5B58, "cún"},
    { 0x5B59, "sūn"},
    { 0x5B5A, "fú"},
    { 0x5B5B, "bèi,bó"},
    { 0x5B5C, "zī"},
    { 0x5B5D, "xiào"},
    { 0x5B5E, "xìn"},
    { 0x5B5F, "mèng"},
    { 0x5B60, "sì"},
    { 0x5B61, "tāi"},
    { 0x5B62, "bāo"},
    { 0x5B63, "jì"},
    { 0x5B64, "gū"},
    { 0x5B65, "nú"},
    { 0x5B66, "xué"},
    { 0x5B67, "yòu"},
    { 0x5B68, "zhuǎn,nì"},
    { 0x5B69, "hái"},
    { 0x5B6A, "luán"},
    { 0x5B6B, "sūn,xùn"},
    { 0x5B6C, "nāo"},
    { 0x5B6D, "miē"},
    { 0x5B6E, "cóng"},
    { 0x5B6F, "qiān"},
    { 0x5B70, "shú"},
    { 0x5B71, "càn,chán,jiān,zhàn"},
    { 0x5B72, "yā"},
    { 0x5B73, "zī"},
    { 0x5B74, "nǐ,nì,yì"},
    { 0x5B75, "fū"},
    { 0x5B76, "zī"},
    { 0x5B77, "lí"},
    { 0x5B78, "xué,huá,jiào"},
    { 0x5B79, "bò"},
    { 0x5B7A, "rú"},
    { 0x5B7B, "nái"},
    { 0x5B7C, "niè"},
    { 0x5B7D, "niè"},
    { 0x5B7E, "yīng"},
    { 0x5B7F, "luán"},
    { 0x5B80, "mián"},
    { 0x5B81, "níng,zhù,nìng"},
    { 0x5B82, "rǒng"},
    { 0x5B83, "tā,tuó,yí"},
    { 0x5B84, "guǐ"},
    { 0x5B85, "zhái,chè,dù"},
    { 0x5B86, "qióng"},
    { 0x5B87, "yǔ"},
    { 0x5B88, "shǒu,shòu"},
    { 0x5B89, "ān"},
    { 0x5B8A, "tū,jiā"},
    { 0x5B8B, "sòng"},
    { 0x5B8C, "wán,kuān"},
    { 0x5B8D, "ròu"},
    { 0x5B8E, "yǎo,yāo"},
    { 0x5B8F, "hóng"},
    { 0x5B90, "yí"},
    { 0x5B91, "jǐng"},
    { 0x5B92, "zhūn"},
    { 0x5B93, "mì,fú"},
    { 0x5B94, "zhǔ"},
    { 0x5B95, "dàng"},
    { 0x5B96, "hóng"},
    { 0x5B97, "zōng"},
    { 0x5B98, "guān"},
    { 0x5B99, "zhòu"},
    { 0x5B9A, "dìng"},
    { 0x5B9B, "wǎn,yuān,yǔn,yù"},
    { 0x5B9C, "yí"},
    { 0x5B9D, "bǎo"},
    { 0x5B9E, "shí"},
    { 0x5B9F, "shí"},
    { 0x5BA0, "chǒng"},
    { 0x5BA1, "shěn"},
    { 0x5BA2, "kè,qià"},
    { 0x5BA3, "xuān"},
    { 0x5BA4, "shì"},
    { 0x5BA5, "yòu"},
    { 0x5BA6, "huàn"},
    { 0x5BA7, "yí"},
    { 0x5BA8, "tiǎo"},
    { 0x5BA9, "shǐ"},
    { 0x5BAA, "xiàn,xiòng"},
    { 0x5BAB, "gōng"},
    { 0x5BAC, "chéng"},
    { 0x5BAD, "qún"},
    { 0x5BAE, "gōng"},
    { 0x5BAF, "xiāo"},
    { 0x5BB0, "zǎi"},
    { 0x5BB1, "zhà"},
    { 0x5BB2, "bǎo,shí"},
    { 0x5BB3, "hài,hé"},
    { 0x5BB4, "yàn"},
    { 0x5BB5, "xiāo"},
    { 0x5BB6, "jiā,jià,jia,jie,gū"},
    { 0x5BB7, "shěn"},
    { 0x5BB8, "chén"},
    { 0x5BB9, "róng,yǒng"},
    { 0x5BBA, "huǎng"},
    { 0x5BBB, "mì"},
    { 0x5BBC, "kòu"},
    { 0x5BBD, "kuān"},
    { 0x5BBE, "bīn"},
    { 0x5BBF, "sù,xiù,xiǔ,qī"},
    { 0x5BC0, "cǎi,cài"},
    { 0x5BC1, "zǎn"},
    { 0x5BC2, "jì"},
    { 0x5BC3, "yuān"},
    { 0x5BC4, "jì"},
    { 0x5BC5, "yín"},
    { 0x5BC6, "mì"},
    { 0x5BC7, "kòu"},
    { 0x5BC8, "qīng"},
    { 0x5BC9, "hè"},
    { 0x5BCA, "zhēn"},
    { 0x5BCB, "jiàn"},
    { 0x5BCC, "fù"},
    { 0x5BCD, "níng"},
    { 0x5BCE, "bìng,bǐng"},
    { 0x5BCF, "huán"},
    { 0x5BD0, "mèi"},
    { 0x5BD1, "qǐn"},
    { 0x5BD2, "hán"},
    { 0x5BD3, "yù"},
    { 0x5BD4, "shí"},
    { 0x5BD5, "níng"},
    { 0x5BD6, "jìn"},
    { 0x5BD7, "níng"},
    { 0x5BD8, "zhì,tián"},
    { 0x5BD9, "yǔ"},
    { 0x5BDA, "bǎo"},
    { 0x5BDB, "kuān"},
    { 0x5BDC, "níng"},
    { 0x5BDD, "qǐn"},
    { 0x5BDE, "mò"},
    { 0x5BDF, "chá,cuì"},
    { 0x5BE0, "jù,lǜ,lóu"},
    { 0x5BE1, "guǎ"},
    { 0x5BE2, "qǐn"},
    { 0x5BE3, "hū"},
    { 0x5BE4, "wù"},
    { 0x5BE5, "liáo"},
    { 0x5BE6, "shí,zhì"},
    { 0x5BE7, "níng,nìng"},
    { 0x5BE8, "zhài,sè,qiān"},
    { 0x5BE9, "shěn,pán"},
    { 0x5BEA, "wěi,wéi"},
    { 0x5BEB, "xiě,xiè"},
    { 0x5BEC, "kuān"},
    { 0x5BED, "huì"},
    { 0x5BEE, "liáo"},
    { 0x5BEF, "jùn"},
    { 0x5BF0, "huán,xiàn"},
    { 0x5BF1, "yì"},
    { 0x5BF2, "yí"},
    { 0x5BF3, "bǎo"},
    { 0x5BF4, "qīn,qìn"},
    { 0x5BF5, "chǒng,lóng"},
    { 0x5BF6, "bǎo"},
    { 0x5BF7, "fēng"},
    { 0x5BF8, "cùn,cǔn"},
    { 0x5BF9, "duì"},
    { 0x5BFA, "sì,shì"},
    { 0x5BFB, "xún,xín"},
    { 0x5BFC, "dǎo"},
    { 0x5BFD, "lǜ,lüè"},
    { 0x5BFE, "duì"},
    { 0x5BFF, "shòu"},
    { 0x5C00, "pǒ"},
    { 0x5C01, "fēng,biǎn"},
    { 0x5C02, "zhuān"},
    { 0x5C03, "fū,bù,fǔ,pò"},
    { 0x5C04, "shè,yè,yì"},
    { 0x5C05, "kè,kēi"},
    { 0x5C06, "jiāng,jiàng,qiāng"},
    { 0x5C07, "jiāng,jiàng,qiāng,yáng,jiǎng"},
    { 0x5C08, "zhuān,tuán,shuàn"},
    { 0x5C09, "wèi,yù,yùn"},
    { 0x5C0A, "zūn"},
    { 0x5C0B, "xún,xín"},
    { 0x5C0C, "shù,zhù"},
    { 0x5C0D, "duì"},
    { 0x5C0E, "dǎo,dào"},
    { 0x5C0F, "xiǎo"},
    { 0x5C10, "jié,jí"},
    { 0x5C11, "shǎo,shào"},
    { 0x5C12, "ěr"},
    { 0x5C13, "ěr"},
    { 0x5C14, "ěr"},
    { 0x5C15, "gǎ"},
    { 0x5C16, "jiān"},
    { 0x5C17, "shū,shú"},
    { 0x5C18, "chén"},
    { 0x5C19, "shàng"},
    { 0x5C1A, "shàng,cháng"},
    { 0x5C1B, "mó"},
    { 0x5C1C, "gá"},
    { 0x5C1D, "cháng"},
    { 0x5C1E, "liào,liáo"},
    { 0x5C1F, "xiǎn"},
    { 0x5C20, "xiǎn"},
    { 0x5C21, "kun"},
    { 0x5C22, "yóu,wāng"},
    { 0x5C23, "wāng"},
    { 0x5C24, "yóu"},
    { 0x5C25, "liào,niǎo"},
    { 0x5C26, "liào"},
    { 0x5C27, "yáo"},
    { 0x5C28, "máng,méng,páng"},
    { 0x5C29, "wāng"},
    { 0x5C2A, "wāng"},
    { 0x5C2B, "wāng"},
    { 0x5C2C, "gà"},
    { 0x5C2D, "yáo"},
    { 0x5C2E, "duò"},
    { 0x5C2F, "kuì,kuǐ"},
    { 0x5C30, "zhǒng"},
    { 0x5C31, "jiù"},
    { 0x5C32, "gān"},
    { 0x5C33, "gǔ"},
    { 0x5C34, "gān"},
    { 0x5C35, "tuí,zhuài"},
    { 0x5C36, "gān"},
    { 0x5C37, "gān"},
    { 0x5C38, "shī"},
    { 0x5C39, "yǐn,yún"},
    { 0x5C3A, "chǐ,chě"},
    { 0x5C3B, "kāo"},
    { 0x5C3C, "ní,nǐ"},
    { 0x5C3D, "jǐn,jìn"},
    { 0x5C3E, "wěi,yǐ"},
    { 0x5C3F, "niào,suī"},
    { 0x5C40, "jú"},
    { 0x5C41, "pì"},
    { 0x5C42, "céng"},
    { 0x5C43, "xì"},
    { 0x5C44, "bī"},
    { 0x5C45, "jū,jī"},
    { 0x5C46, "jiè"},
    { 0x5C47, "tián"},
    { 0x5C48, "qū,jué,què,jú"},
    { 0x5C49, "tì"},
    { 0x5C4A, "jiè"},
    { 0x5C4B, "wū"},
    { 0x5C4C, "diǎo"},
    { 0x5C4D, "shī,shì"},
    { 0x5C4E, "shǐ,xī"},
    { 0x5C4F, "píng,bǐng,bìng,bīng"},
    { 0x5C50, "jī"},
    { 0x5C51, "xiè"},
    { 0x5C52, "zhěn"},
    { 0x5C53, "xiè"},
    { 0x5C54, "ní"},
    { 0x5C55, "zhǎn"},
    { 0x5C56, "xī"},
    { 0x5C57, "wěi"},
    { 0x5C58, "mǎn"},
    { 0x5C59, "ē"},
    { 0x5C5A, "lòu"},
    { 0x5C5B, "píng"},
    { 0x5C5C, "tì"},
    { 0x5C5D, "fèi"},
    { 0x5C5E, "shǔ,zhǔ"},
    { 0x5C5F, "xiè,tì"},
    { 0x5C60, "tú"},
    { 0x5C61, "lǚ"},
    { 0x5C62, "lǚ"},
    { 0x5C63, "xǐ"},
    { 0x5C64, "céng"},
    { 0x5C65, "lǚ"},
    { 0x5C66, "jù"},
    { 0x5C67, "xiè"},
    { 0x5C68, "jù"},
    { 0x5C69, "juē"},
    { 0x5C6A, "liáo"},
    { 0x5C6B, "jué"},
    { 0x5C6C, "shǔ,zhǔ"},
    { 0x5C6D, "xì"},
    { 0x5C6E, "chè,cǎo"},
    { 0x5C6F, "tún,zhūn"},
    { 0x5C70, "nì,pò,jí"},
    { 0x5C71, "shān"},
    { 0x5C72, "wā"},
    { 0x5C73, "xiān"},
    { 0x5C74, "lì"},
    { 0x5C75, "è,yǎn"},
    { 0x5C76, "huì"},
    { 0x5C77, "huì"},
    { 0x5C78, "lóng,hóng"},
    { 0x5C79, "yì,gē"},
    { 0x5C7A, "qǐ"},
    { 0x5C7B, "rèn"},
    { 0x5C7C, "wù"},
    { 0x5C7D, "hàn,àn"},
    { 0x5C7E, "shēn"},
    { 0x5C7F, "yǔ"},
    { 0x5C80, "chū"},
    { 0x5C81, "suì"},
    { 0x5C82, "qǐ"},
    { 0x5C83, "rèn"},
    { 0x5C84, "yuè"},
    { 0x5C85, "bǎn"},
    { 0x5C86, "yǎo"},
    { 0x5C87, "áng"},
    { 0x5C88, "yá,xiā"},
    { 0x5C89, "wù"},
    { 0x5C8A, "jié"},
    { 0x5C8B, "è,jí"},
    { 0x5C8C, "jí"},
    { 0x5C8D, "qiān"},
    { 0x5C8E, "fén,chà"},
    { 0x5C8F, "wán"},
    { 0x5C90, "qí"},
    { 0x5C91, "cén"},
    { 0x5C92, "qián"},
    { 0x5C93, "qí"},
    { 0x5C94, "chà"},
    { 0x5C95, "jiè"},
    { 0x5C96, "qū"},
    { 0x5C97, "gǎng,gāng"},
    { 0x5C98, "xiàn"},
    { 0x5C99, "ào"},
    { 0x5C9A, "lán"},
    { 0x5C9B, "dǎo"},
    { 0x5C9C, "bā"},
    { 0x5C9D, "zuò"},
    { 0x5C9E, "zuò"},
    { 0x5C9F, "yǎng"},
    { 0x5CA0, "jù"},
    { 0x5CA1, "gāng"},
    { 0x5CA2, "kě"},
    { 0x5CA3, "gǒu"},
    { 0x5CA4, "xué"},
    { 0x5CA5, "pō"},
    { 0x5CA6, "lì"},
    { 0x5CA7, "tiáo"},
    { 0x5CA8, "qū,zǔ,jǔ"},
    { 0x5CA9, "yán"},
    { 0x5CAA, "fú"},
    { 0x5CAB, "xiù"},
    { 0x5CAC, "jiǎ,jiá"},
    { 0x5CAD, "lǐng,líng"},
    { 0x5CAE, "tuó"},
    { 0x5CAF, "pí"},
    { 0x5CB0, "ào"},
    { 0x5CB1, "dài"},
    { 0x5CB2, "kuàng"},
    { 0x5CB3, "yuè"},
    { 0x5CB4, "qū"},
    { 0x5CB5, "hù"},
    { 0x5CB6, "pò"},
    { 0x5CB7, "mín"},
    { 0x5CB8, "àn"},
    { 0x5CB9, "tiáo"},
    { 0x5CBA, "líng"},
    { 0x5CBB, "chí"},
    { 0x5CBC, "píng"},
    { 0x5CBD, "dōng"},
    { 0x5CBE, "hàn"},
    { 0x5CBF, "kuī"},
    { 0x5CC0, "xiù"},
    { 0x5CC1, "mǎo"},
    { 0x5CC2, "tóng"},
    { 0x5CC3, "xué"},
    { 0x5CC4, "yì"},
    { 0x5CC5, "biàn"},
    { 0x5CC6, "hé"},
    { 0x5CC7, "bā,kè"},
    { 0x5CC8, "luò"},
    { 0x5CC9, "è"},
    { 0x5CCA, "fù,niè"},
    { 0x5CCB, "xún"},
    { 0x5CCC, "dié"},
    { 0x5CCD, "lù"},
    { 0x5CCE, "ěn"},
    { 0x5CCF, "ér"},
    { 0x5CD0, "gāi"},
    { 0x5CD1, "quān"},
    { 0x5CD2, "dòng,tóng"},
    { 0x5CD3, "yí"},
    { 0x5CD4, "mǔ"},
    { 0x5CD5, "shí"},
    { 0x5CD6, "ān"},
    { 0x5CD7, "wéi,wěi"},
    { 0x5CD8, "huán"},
    { 0x5CD9, "zhì,shì"},
    { 0x5CDA, "mì"},
    { 0x5CDB, "lǐ"},
    { 0x5CDC, "jì"},
    { 0x5CDD, "tóng"},
    { 0x5CDE, "wéi,wěi"},
    { 0x5CDF, "yòu"},
    { 0x5CE0, "qiǎ"},
    { 0x5CE1, "xiá"},
    { 0x5CE2, "lǐ"},
    { 0x5CE3, "yáo"},
    { 0x5CE4, "jiào,qiáo"},
    { 0x5CE5, "zhēng"},
    { 0x5CE6, "luán"},
    { 0x5CE7, "jiāo"},
    { 0x5CE8, "é"},
    { 0x5CE9, "é"},
    { 0x5CEA, "yù"},
    { 0x5CEB, "xié,yé"},
    { 0x5CEC, "bū"},
    { 0x5CED, "qiào"},
    { 0x5CEE, "qūn"},
    { 0x5CEF, "fēng"},
    { 0x5CF0, "fēng"},
    { 0x5CF1, "náo"},
    { 0x5CF2, "lǐ"},
    { 0x5CF3, "yóu"},
    { 0x5CF4, "xiàn"},
    { 0x5CF5, "róng"},
    { 0x5CF6, "dǎo"},
    { 0x5CF7, "shēn"},
    { 0x5CF8, "chéng"},
    { 0x5CF9, "tú"},
    { 0x5CFA, "gěng"},
    { 0x5CFB, "jùn"},
    { 0x5CFC, "gào"},
    { 0x5CFD, "xiá"},
    { 0x5CFE, "yín"},
    { 0x5CFF, "yǔ,wú"},
    { 0x5D00, "làng,lǎng"},
    { 0x5D01, "kàn"},
    { 0x5D02, "láo"},
    { 0x5D03, "lái"},
    { 0x5D04, "xiǎn"},
    { 0x5D05, "què"},
    { 0x5D06, "kōng"},
    { 0x5D07, "chóng"},
    { 0x5D08, "chóng"},
    { 0x5D09, "tà"},
    { 0x5D0A, "lín"},
    { 0x5D0B, "huà"},
    { 0x5D0C, "jū"},
    { 0x5D0D, "lái"},
    { 0x5D0E, "qí,qǐ,yī"},
    { 0x5D0F, "mín"},
    { 0x5D10, "kūn"},
    { 0x5D11, "kūn"},
    { 0x5D12, "zú,cuì"},
    { 0x5D13, "gù"},
    { 0x5D14, "cuī"},
    { 0x5D15, "yá"},
    { 0x5D16, "yá"},
    { 0x5D17, "gǎng,gāng"},
    { 0x5D18, "lún"},
    { 0x5D19, "lún"},
    { 0x5D1A, "léng,líng"},
    { 0x5D1B, "jué,yù"},
    { 0x5D1C, "duō,duǒ"},
    { 0x5D1D, "zhēng"},
    { 0x5D1E, "guō"},
    { 0x5D1F, "yín"},
    { 0x5D20, "dōng,dòng"},
    { 0x5D21, "hán"},
    { 0x5D22, "zhēng"},
    { 0x5D23, "wěi"},
    { 0x5D24, "xiáo,yáo"},
    { 0x5D25, "pí,bǐ"},
    { 0x5D26, "yān"},
    { 0x5D27, "sōng"},
    { 0x5D28, "jié"},
    { 0x5D29, "bēng"},
    { 0x5D2A, "zú"},
    { 0x5D2B, "kū,jué"},
    { 0x5D2C, "dōng"},
    { 0x5D2D, "zhǎn"},
    { 0x5D2E, "gù"},
    { 0x5D2F, "yín"},
    { 0x5D30, "zī"},
    { 0x5D31, "zè"},
    { 0x5D32, "huáng"},
    { 0x5D33, "yú"},
    { 0x5D34, "wǎi,wēi,wěi"},
    { 0x5D35, "yáng,dàng"},
    { 0x5D36, "fēng"},
    { 0x5D37, "qiú"},
    { 0x5D38, "yáng"},
    { 0x5D39, "tí"},
    { 0x5D3A, "yǐ"},
    { 0x5D3B, "zhì"},
    { 0x5D3C, "shì,dié"},
    { 0x5D3D, "zǎi"},
    { 0x5D3E, "yǎo"},
    { 0x5D3F, "è"},
    { 0x5D40, "zhù"},
    { 0x5D41, "kān,zhàn"},
    { 0x5D42, "lǜ"},
    { 0x5D43, "yǎn,yàn"},
    { 0x5D44, "měi"},
    { 0x5D45, "hán"},
    { 0x5D46, "jī"},
    { 0x5D47, "jī,xí"},
    { 0x5D48, "huàn"},
    { 0x5D49, "tíng"},
    { 0x5D4A, "shèng,chéng"},
    { 0x5D4B, "méi"},
    { 0x5D4C, "qiàn,hǎn,kàn"},
    { 0x5D4D, "wù,máo"},
    { 0x5D4E, "yú"},
    { 0x5D4F, "zōng"},
    { 0x5D50, "lán"},
    { 0x5D51, "kě,jié"},
    { 0x5D52, "yán,niè"},
    { 0x5D53, "yán"},
    { 0x5D54, "wěi"},
    { 0x5D55, "zōng"},
    { 0x5D56, "chá"},
    { 0x5D57, "suì"},
    { 0x5D58, "róng"},
    { 0x5D59, "kē"},
    { 0x5D5A, "qīn"},
    { 0x5D5B, "yú"},
    { 0x5D5C, "qí"},
    { 0x5D5D, "lǒu"},
    { 0x5D5E, "tú"},
    { 0x5D5F, "duī"},
    { 0x5D60, "xī"},
    { 0x5D61, "wěng"},
    { 0x5D62, "cāng"},
    { 0x5D63, "dàng,táng"},
    { 0x5D64, "róng,yíng"},
    { 0x5D65, "jié"},
    { 0x5D66, "kǎi,ái"},
    { 0x5D67, "liú"},
    { 0x5D68, "wù"},
    { 0x5D69, "sōng"},
    { 0x5D6A, "qiāo,kāo"},
    { 0x5D6B, "zī"},
    { 0x5D6C, "wéi,wěi"},
    { 0x5D6D, "bēng"},
    { 0x5D6E, "diān"},
    { 0x5D6F, "cuó,cī"},
    { 0x5D70, "qiǎn"},
    { 0x5D71, "yǒng,yóng"},
    { 0x5D72, "niè"},
    { 0x5D73, "cuó"},
    { 0x5D74, "jǐ"},
    { 0x5D75, "shí"},
    { 0x5D76, "ruò"},
    { 0x5D77, "sǒng"},
    { 0x5D78, "zōng"},
    { 0x5D79, "jiàng"},
    { 0x5D7A, "liáo,jiāo"},
    { 0x5D7B, "kāng"},
    { 0x5D7C, "chǎn"},
    { 0x5D7D, "dié,dì"},
    { 0x5D7E, "cēn,cān"},
    { 0x5D7F, "dǐng"},
    { 0x5D80, "tū"},
    { 0x5D81, "lǒu"},
    { 0x5D82, "zhàng"},
    { 0x5D83, "zhǎn"},
    { 0x5D84, "zhǎn,chán"},
    { 0x5D85, "áo,ào"},
    { 0x5D86, "cáo"},
    { 0x5D87, "qū"},
    { 0x5D88, "qiāng"},
    { 0x5D89, "cuī,zuǐ"},
    { 0x5D8A, "zuǐ"},
    { 0x5D8B, "dǎo"},
    { 0x5D8C, "dǎo"},
    { 0x5D8D, "xí"},
    { 0x5D8E, "yù"},
    { 0x5D8F, "pèi,pǐ"},
    { 0x5D90, "lóng"},
    { 0x5D91, "xiàng"},
    { 0x5D92, "céng,zhēng"},
    { 0x5D93, "bō"},
    { 0x5D94, "qīn"},
    { 0x5D95, "jiāo"},
    { 0x5D96, "yān"},
    { 0x5D97, "láo"},
    { 0x5D98, "zhàn"},
    { 0x5D99, "lín,lǐn"},
    { 0x5D9A, "liáo"},
    { 0x5D9B, "liáo"},
    { 0x5D9C, "jīn,qín"},
    { 0x5D9D, "dèng"},
    { 0x5D9E, "duò"},
    { 0x5D9F, "zūn"},
    { 0x5DA0, "jiào,qiáo"},
    { 0x5DA1, "guì,jué"},
    { 0x5DA2, "yáo"},
    { 0x5DA3, "jiāo"},
    { 0x5DA4, "yáo"},
    { 0x5DA5, "jué"},
    { 0x5DA6, "zhān,shàn"},
    { 0x5DA7, "yì"},
    { 0x5DA8, "xué"},
    { 0x5DA9, "náo"},
    { 0x5DAA, "yè"},
    { 0x5DAB, "yè"},
    { 0x5DAC, "yí,yǐ"},
    { 0x5DAD, "niè"},
    { 0x5DAE, "xiǎn,yǎn"},
    { 0x5DAF, "jí"},
    { 0x5DB0, "xiè,jiè"},
    { 0x5DB1, "kě"},
    { 0x5DB2, "xī"},
    { 0x5DB3, "dì"},
    { 0x5DB4, "ào"},
    { 0x5DB5, "zuǐ"},
    { 0x5DB6, "wēi"},
    { 0x5DB7, "yí,nì"},
    { 0x5DB8, "róng"},
    { 0x5DB9, "dǎo"},
    { 0x5DBA, "lǐng"},
    { 0x5DBB, "jié"},
    { 0x5DBC, "yǔ,xù"},
    { 0x5DBD, "yuè"},
    { 0x5DBE, "yǐn"},
    { 0x5DBF, "ru"},
    { 0x5DC0, "jié"},
    { 0x5DC1, "lì,liè"},
    { 0x5DC2, "guī,xī,juàn"},
    { 0x5DC3, "lóng"},
    { 0x5DC4, "lóng"},
    { 0x5DC5, "diān"},
    { 0x5DC6, "róng,hōng,yíng"},
    { 0x5DC7, "xī"},
    { 0x5DC8, "jú"},
    { 0x5DC9, "chán"},
    { 0x5DCA, "yǐng"},
    { 0x5DCB, "kuī,kuì,wěi"},
    { 0x5DCC, "yán"},
    { 0x5DCD, "wēi"},
    { 0x5DCE, "náo"},
    { 0x5DCF, "quán"},
    { 0x5DD0, "chǎo"},
    { 0x5DD1, "cuán"},
    { 0x5DD2, "luán"},
    { 0x5DD3, "diān"},
    { 0x5DD4, "diān"},
    { 0x5DD5, "niè"},
    { 0x5DD6, "yán"},
    { 0x5DD7, "yán"},
    { 0x5DD8, "yǎn"},
    { 0x5DD9, "kuí,náo"},
    { 0x5DDA, "yǎn"},
    { 0x5DDB, "chuān,shùn"},
    { 0x5DDC, "kuài,huān"},
    { 0x5DDD, "chuān"},
    { 0x5DDE, "zhōu"},
    { 0x5DDF, "huāng"},
    { 0x5DE0, "jīng,xíng"},
    { 0x5DE1, "xún,yán,shùn"},
    { 0x5DE2, "cháo,chào"},
    { 0x5DE3, "cháo"},
    { 0x5DE4, "liè"},
    { 0x5DE5, "gōng"},
    { 0x5DE6, "zuǒ"},
    { 0x5DE7, "qiǎo"},
    { 0x5DE8, "jù,qú"},
    { 0x5DE9, "gǒng"},
    { 0x5DEA, "jù"},
    { 0x5DEB, "wū"},
    { 0x5DEC, "pu"},
    { 0x5DED, "pu"},
    { 0x5DEE, "chà,chā,chāi,chài,cī,cuō,jiē"},
    { 0x5DEF, "qiú"},
    { 0x5DF0, "qiú"},
    { 0x5DF1, "jǐ,qǐ"},
    { 0x5DF2, "yǐ,sì"},
    { 0x5DF3, "sì,yǐ"},
    { 0x5DF4, "bā"},
    { 0x5DF5, "zhī"},
    { 0x5DF6, "zhāo"},
    { 0x5DF7, "xiàng,hàng"},
    { 0x5DF8, "yí"},
    { 0x5DF9, "jǐn"},
    { 0x5DFA, "xùn"},
    { 0x5DFB, "juàn"},
    { 0x5DFC, "bā"},
    { 0x5DFD, "xùn,zhuàn"},
    { 0x5DFE, "jīn"},
    { 0x5DFF, "fú,pó"},
    { 0x5E00, "zā"},
    { 0x5E01, "bì,yìn"},
    { 0x5E02, "shì,fú"},
    { 0x5E03, "bù"},
    { 0x5E04, "dīng"},
    { 0x5E05, "shuài"},
    { 0x5E06, "fān,fán,fàn"},
    { 0x5E07, "niè"},
    { 0x5E08, "shī"},
    { 0x5E09, "fēn"},
    { 0x5E0A, "pà,pā"},
    { 0x5E0B, "zhǐ"},
    { 0x5E0C, "xī"},
    { 0x5E0D, "hù"},
    { 0x5E0E, "dàn"},
    { 0x5E0F, "wéi"},
    { 0x5E10, "zhàng"},
    { 0x5E11, "tǎng,nú"},
    { 0x5E12, "dài"},
    { 0x5E13, "mò,wà"},
    { 0x5E14, "pèi,pī"},
    { 0x5E15, "pà,mò"},
    { 0x5E16, "tiē,tiè,tiě"},
    { 0x5E17, "bō,fú"},
    { 0x5E18, "lián,chén"},
    { 0x5E19, "zhì"},
    { 0x5E1A, "zhǒu"},
    { 0x5E1B, "bó"},
    { 0x5E1C, "zhì"},
    { 0x5E1D, "dì"},
    { 0x5E1E, "mò"},
    { 0x5E1F, "yì"},
    { 0x5E20, "yì"},
    { 0x5E21, "píng"},
    { 0x5E22, "qià"},
    { 0x5E23, "juǎn,juàn"},
    { 0x5E24, "rú"},
    { 0x5E25, "shuài"},
    { 0x5E26, "dài"},
    { 0x5E27, "zhèng"},
    { 0x5E28, "shuì"},
    { 0x5E29, "qiào"},
    { 0x5E2A, "zhēn"},
    { 0x5E2B, "shī"},
    { 0x5E2C, "qún"},
    { 0x5E2D, "xí"},
    { 0x5E2E, "bāng"},
    { 0x5E2F, "dài"},
    { 0x5E30, "guī"},
    { 0x5E31, "chóu,dào"},
    { 0x5E32, "píng"},
    { 0x5E33, "zhàng"},
    { 0x5E34, "sàn,jiǎn,jiān"},
    { 0x5E35, "wān"},
    { 0x5E36, "dài"},
    { 0x5E37, "wéi"},
    { 0x5E38, "cháng"},
    { 0x5E39, "shà,qiè"},
    { 0x5E3A, "qí,jì"},
    { 0x5E3B, "zé"},
    { 0x5E3C, "guó"},
    { 0x5E3D, "mào"},
    { 0x5E3E, "dǔ"},
    { 0x5E3F, "hóu"},
    { 0x5E40, "zhèng"},
    { 0x5E41, "xū"},
    { 0x5E42, "mì"},
    { 0x5E43, "wéi"},
    { 0x5E44, "wò"},
    { 0x5E45, "fú,bī"},
    { 0x5E46, "yì,kài"},
    { 0x5E47, "bāng"},
    { 0x5E48, "píng"},
    { 0x5E49, "dié"},
    { 0x5E4A, "gōng"},
    { 0x5E4B, "pán"},
    { 0x5E4C, "huǎng"},
    { 0x5E4D, "tāo"},
    { 0x5E4E, "mì"},
    { 0x5E4F, "jià"},
    { 0x5E50, "téng"},
    { 0x5E51, "huī"},
    { 0x5E52, "zhōng"},
    { 0x5E53, "shān,shēn,qiāo"},
    { 0x5E54, "màn"},
    { 0x5E55, "mù,màn"},
    { 0x5E56, "biāo"},
    { 0x5E57, "guó"},
    { 0x5E58, "zé,cè"},
    { 0x5E59, "mù"},
    { 0x5E5A, "bāng"},
    { 0x5E5B, "zhàng"},
    { 0x5E5C, "jǐng"},
    { 0x5E5D, "chǎn,chàn"},
    { 0x5E5E, "fú"},
    { 0x5E5F, "zhì"},
    { 0x5E60, "hū,wú"},
    { 0x5E61, "fān"},
    { 0x5E62, "chuáng,zhuàng"},
    { 0x5E63, "bì"},
    { 0x5E64, "bì"},
    { 0x5E65, "zhǎng"},
    { 0x5E66, "mì"},
    { 0x5E67, "qiāo"},
    { 0x5E68, "chān,chàn"},
    { 0x5E69, "fén,fèn"},
    { 0x5E6A, "méng,měng"},
    { 0x5E6B, "bāng"},
    { 0x5E6C, "chóu,dào"},
    { 0x5E6D, "miè"},
    { 0x5E6E, "chú"},
    { 0x5E6F, "jié"},
    { 0x5E70, "xiǎn"},
    { 0x5E71, "lán"},
    { 0x5E72, "gàn,gān,àn"},
    { 0x5E73, "píng,pián,bìng,bēng"},
    { 0x5E74, "nián,nìng"},
    { 0x5E75, "jiān,qiān"},
    { 0x5E76, "bìng,bīng"},
    { 0x5E77, "bìng,bīng"},
    { 0x5E78, "xìng,niè"},
    { 0x5E79, "gàn,gān,hán,guǎn"},
    { 0x5E7A, "yāo,mì"},
    { 0x5E7B, "huàn"},
    { 0x5E7C, "yòu,yào"},
    { 0x5E7D, "yōu"},
    { 0x5E7E, "jǐ,jī,jì,qí"},
    { 0x5E7F, "guǎng,yǎn,ān"},
    { 0x5E80, "pǐ"},
    { 0x5E81, "tīng"},
    { 0x5E82, "zè"},
    { 0x5E83, "guǎng"},
    { 0x5E84, "zhuāng,péng"},
    { 0x5E85, "mó"},
    { 0x5E86, "qìng"},
    { 0x5E87, "bì,pí,pǐ"},
    { 0x5E88, "qín"},
    { 0x5E89, "dùn,tún"},
    { 0x5E8A, "chuáng"},
    { 0x5E8B, "guǐ,guì"},
    { 0x5E8C, "yǎ,yá"},
    { 0x5E8D, "bài,xìn,tīng"}
};
