/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     chenhaifeng  <chenhaifeng@uniontech.com>
*
* Maintainer: chenhaifeng  <chenhaifeng@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "pinyindict.h"

QMap<int, QString> PinyinDict_7{
    { 0x665E, "xī"},
    { 0x665F, "chéng,shèng,jīng"},
    { 0x6660, "shèng"},
    { 0x6661, "bū"},
    { 0x6662, "zhé,zhì"},
    { 0x6663, "zhé"},
    { 0x6664, "wù"},
    { 0x6665, "wǎn"},
    { 0x6666, "huì"},
    { 0x6667, "hào"},
    { 0x6668, "chén"},
    { 0x6669, "wǎn"},
    { 0x666A, "tiǎn"},
    { 0x666B, "zhuó"},
    { 0x666C, "zuì"},
    { 0x666D, "zhǒu"},
    { 0x666E, "pǔ"},
    { 0x666F, "jǐng,yǐng"},
    { 0x6670, "xī"},
    { 0x6671, "shǎn"},
    { 0x6672, "nǐ"},
    { 0x6673, "xī"},
    { 0x6674, "qíng"},
    { 0x6675, "qǐ,dù"},
    { 0x6676, "jīng"},
    { 0x6677, "guǐ"},
    { 0x6678, "zhěng"},
    { 0x6679, "yì"},
    { 0x667A, "zhì,zhī"},
    { 0x667B, "àn,ǎn,yǎn"},
    { 0x667C, "wǎn"},
    { 0x667D, "lín"},
    { 0x667E, "liàng"},
    { 0x667F, "chāng"},
    { 0x6680, "wǎng,wàng"},
    { 0x6681, "xiǎo"},
    { 0x6682, "zàn"},
    { 0x6683, "fēi"},
    { 0x6684, "xuān"},
    { 0x6685, "gèng,xuǎn"},
    { 0x6686, "yí"},
    { 0x6687, "xiá,xià,jiǎ"},
    { 0x6688, "yūn,yùn"},
    { 0x6689, "huī"},
    { 0x668A, "xǔ"},
    { 0x668B, "mǐn,mín"},
    { 0x668C, "kuí"},
    { 0x668D, "yē"},
    { 0x668E, "yìng"},
    { 0x668F, "shǔ,dǔ"},
    { 0x6690, "wěi"},
    { 0x6691, "shǔ"},
    { 0x6692, "qíng"},
    { 0x6693, "mào"},
    { 0x6694, "nán"},
    { 0x6695, "jiǎn,lán"},
    { 0x6696, "nuǎn,xuān"},
    { 0x6697, "àn"},
    { 0x6698, "yáng"},
    { 0x6699, "chūn"},
    { 0x669A, "yáo"},
    { 0x669B, "suǒ"},
    { 0x669C, "pǔ"},
    { 0x669D, "míng"},
    { 0x669E, "jiǎo"},
    { 0x669F, "kǎi"},
    { 0x66A0, "gǎo,hào"},
    { 0x66A1, "wěng"},
    { 0x66A2, "chàng"},
    { 0x66A3, "qì"},
    { 0x66A4, "hào"},
    { 0x66A5, "yàn"},
    { 0x66A6, "lì"},
    { 0x66A7, "ài,nuǎn"},
    { 0x66A8, "jì,jiè"},
    { 0x66A9, "jì"},
    { 0x66AA, "mèn"},
    { 0x66AB, "zàn"},
    { 0x66AC, "xiè"},
    { 0x66AD, "hào"},
    { 0x66AE, "mù"},
    { 0x66AF, "mò"},
    { 0x66B0, "cōng"},
    { 0x66B1, "nì"},
    { 0x66B2, "zhāng"},
    { 0x66B3, "huì"},
    { 0x66B4, "bào,pù,bó"},
    { 0x66B5, "hàn"},
    { 0x66B6, "xuán"},
    { 0x66B7, "chuán"},
    { 0x66B8, "liáo"},
    { 0x66B9, "xiān"},
    { 0x66BA, "tǎn"},
    { 0x66BB, "jǐng"},
    { 0x66BC, "piē"},
    { 0x66BD, "lín"},
    { 0x66BE, "tūn"},
    { 0x66BF, "xǐ,xī"},
    { 0x66C0, "yì"},
    { 0x66C1, "jì"},
    { 0x66C2, "huàng"},
    { 0x66C3, "dài"},
    { 0x66C4, "yè"},
    { 0x66C5, "yè"},
    { 0x66C6, "lì"},
    { 0x66C7, "tán"},
    { 0x66C8, "tóng"},
    { 0x66C9, "xiǎo"},
    { 0x66CA, "fèi"},
    { 0x66CB, "shěn"},
    { 0x66CC, "zhào"},
    { 0x66CD, "hào"},
    { 0x66CE, "yì"},
    { 0x66CF, "xiǎng,xiàng,shǎng"},
    { 0x66D0, "xīng"},
    { 0x66D1, "shēn"},
    { 0x66D2, "jiǎo"},
    { 0x66D3, "bào"},
    { 0x66D4, "jìng"},
    { 0x66D5, "yàn"},
    { 0x66D6, "ài"},
    { 0x66D7, "yè"},
    { 0x66D8, "rú"},
    { 0x66D9, "shǔ"},
    { 0x66DA, "méng"},
    { 0x66DB, "xūn"},
    { 0x66DC, "yào"},
    { 0x66DD, "pù"},
    { 0x66DE, "lì"},
    { 0x66DF, "chén"},
    { 0x66E0, "kuàng"},
    { 0x66E1, "dié"},
    { 0x66E2, "liǎo"},
    { 0x66E3, "yàn"},
    { 0x66E4, "huò"},
    { 0x66E5, "lú"},
    { 0x66E6, "xī"},
    { 0x66E7, "róng"},
    { 0x66E8, "lóng"},
    { 0x66E9, "nǎng"},
    { 0x66EA, "luǒ"},
    { 0x66EB, "luán"},
    { 0x66EC, "shài"},
    { 0x66ED, "tǎng"},
    { 0x66EE, "yǎn"},
    { 0x66EF, "zhú"},
    { 0x66F0, "yuē"},
    { 0x66F1, "yuē"},
    { 0x66F2, "qū,qǔ"},
    { 0x66F3, "yè"},
    { 0x66F4, "gèng,gēng"},
    { 0x66F5, "yè"},
    { 0x66F6, "hū"},
    { 0x66F7, "hé,è,hè"},
    { 0x66F8, "shū"},
    { 0x66F9, "cáo"},
    { 0x66FA, "cáo"},
    { 0x66FB, "shēng"},
    { 0x66FC, "màn"},
    { 0x66FD, "cēng"},
    { 0x66FE, "céng,zēng"},
    { 0x66FF, "tì"},
    { 0x6700, "zuì,cuō"},
    { 0x6701, "cǎn,qián,jiàn"},
    { 0x6702, "xù"},
    { 0x6703, "huì,kuài,kuò"},
    { 0x6704, "yǐn"},
    { 0x6705, "qiè"},
    { 0x6706, "fēn"},
    { 0x6707, "pí"},
    { 0x6708, "yuè,rù"},
    { 0x6709, "yǒu,yòu,wěi"},
    { 0x670A, "ruǎn,wǎn"},
    { 0x670B, "péng"},
    { 0x670C, "fén,bān"},
    { 0x670D, "fú,fù,bì,bó"},
    { 0x670E, "líng"},
    { 0x670F, "fěi,kū"},
    { 0x6710, "qú,xū,xù,chǔn"},
    { 0x6711, "tì"},
    { 0x6712, "nǜ"},
    { 0x6713, "tiǎo,tiào,yóu"},
    { 0x6714, "shuò"},
    { 0x6715, "zhèn"},
    { 0x6716, "lǎng"},
    { 0x6717, "lǎng"},
    { 0x6718, "zuī,juān"},
    { 0x6719, "míng"},
    { 0x671A, "huāng,máng,wáng,mèng"},
    { 0x671B, "wàng"},
    { 0x671C, "tūn"},
    { 0x671D, "cháo,zhāo,zhū"},
    { 0x671E, "jī,qī"},
    { 0x671F, "qī,jī"},
    { 0x6720, "yīng"},
    { 0x6721, "zōng"},
    { 0x6722, "wàng"},
    { 0x6723, "tóng,chuáng"},
    { 0x6724, "lǎng"},
    { 0x6725, "láo"},
    { 0x6726, "méng,mǎng"},
    { 0x6727, "lóng,lǒng"},
    { 0x6728, "mù"},
    { 0x6729, "děng"},
    { 0x672A, "wèi"},
    { 0x672B, "mò,me"},
    { 0x672C, "běn,bēn"},
    { 0x672D, "zhá,yà"},
    { 0x672E, "shù,zhú"},
    { 0x672F, "shù,shú,zhú"},
    { 0x6730, "mù"},
    { 0x6731, "zhū,shū"},
    { 0x6732, "rén"},
    { 0x6733, "bā"},
    { 0x6734, "pǔ,pò,pū,pō,piáo"},
    { 0x6735, "duǒ"},
    { 0x6736, "duǒ"},
    { 0x6737, "dāo,mù,tiáo"},
    { 0x6738, "lì"},
    { 0x6739, "guǐ,qiú"},
    { 0x673A, "jī,wèi"},
    { 0x673B, "jiū"},
    { 0x673C, "bǐ"},
    { 0x673D, "xiǔ"},
    { 0x673E, "chéng,zhēng,chēng,tīng"},
    { 0x673F, "cì"},
    { 0x6740, "shā"},
    { 0x6741, "rù"},
    { 0x6742, "zá,duǒ"},
    { 0x6743, "quán"},
    { 0x6744, "qiān"},
    { 0x6745, "yú,wū"},
    { 0x6746, "gān,gàn,gǎn"},
    { 0x6747, "wū"},
    { 0x6748, "chā,chà"},
    { 0x6749, "shān,shā"},
    { 0x674A, "xún"},
    { 0x674B, "fán"},
    { 0x674C, "wù,wò"},
    { 0x674D, "zǐ"},
    { 0x674E, "lǐ"},
    { 0x674F, "xìng"},
    { 0x6750, "cái"},
    { 0x6751, "cūn"},
    { 0x6752, "rèn,ér"},
    { 0x6753, "biāo,sháo,shuó,dí,zhuó"},
    { 0x6754, "tuō,zhé"},
    { 0x6755, "dì,duò"},
    { 0x6756, "zhàng"},
    { 0x6757, "máng"},
    { 0x6758, "chì"},
    { 0x6759, "yì"},
    { 0x675A, "gài,gé"},
    { 0x675B, "gōng"},
    { 0x675C, "dù,dǔ,tú"},
    { 0x675D, "lí,zhì,yí,tuò,duò"},
    { 0x675E, "qǐ"},
    { 0x675F, "shù"},
    { 0x6760, "gāng,gōng,gàng"},
    { 0x6761, "tiáo"},
    { 0x6762, "jiang"},
    { 0x6763, "mián"},
    { 0x6764, "wàn"},
    { 0x6765, "lái"},
    { 0x6766, "jiǔ"},
    { 0x6767, "máng"},
    { 0x6768, "yáng"},
    { 0x6769, "mà"},
    { 0x676A, "miǎo"},
    { 0x676B, "sì,zhǐ,xǐ"},
    { 0x676C, "yuán,yuàn"},
    { 0x676D, "háng,kàng,kāng"},
    { 0x676E, "fèi,bèi"},
    { 0x676F, "bēi"},
    { 0x6770, "jié"},
    { 0x6771, "dōng"},
    { 0x6772, "gǎo"},
    { 0x6773, "yǎo"},
    { 0x6774, "xiān,qiān"},
    { 0x6775, "chǔ"},
    { 0x6776, "chūn"},
    { 0x6777, "pá,bà"},
    { 0x6778, "shū,duì"},
    { 0x6779, "huà"},
    { 0x677A, "xīn"},
    { 0x677B, "chǒu,niǔ"},
    { 0x677C, "zhù,shù"},
    { 0x677D, "chǒu"},
    { 0x677E, "sōng"},
    { 0x677F, "bǎn"},
    { 0x6780, "sōng"},
    { 0x6781, "jí"},
    { 0x6782, "wò,yuè"},
    { 0x6783, "jìn"},
    { 0x6784, "gòu"},
    { 0x6785, "jī"},
    { 0x6786, "máo"},
    { 0x6787, "pí,bǐ,bì,pī"},
    { 0x6788, "bì,pī"},
    { 0x6789, "wǎng,kuáng"},
    { 0x678A, "àng"},
    { 0x678B, "fāng,fǎng,bǐng"},
    { 0x678C, "fén"},
    { 0x678D, "yì"},
    { 0x678E, "fú,fū"},
    { 0x678F, "nán"},
    { 0x6790, "xī,sī"},
    { 0x6791, "hù"},
    { 0x6792, "yā,yē,yá,yà"},
    { 0x6793, "dǒu,zhǔ"},
    { 0x6794, "xín"},
    { 0x6795, "zhěn,chén"},
    { 0x6796, "yāo,yǎo"},
    { 0x6797, "lín"},
    { 0x6798, "ruì,nèn"},
    { 0x6799, "ě,è"},
    { 0x679A, "méi"},
    { 0x679B, "zhào"},
    { 0x679C, "guǒ,luǒ,guàn"},
    { 0x679D, "zhī,qí"},
    { 0x679E, "cōng,zōng"},
    { 0x679F, "yùn"},
    { 0x67A0, "zui"},
    { 0x67A1, "shēng"},
    { 0x67A2, "shū"},
    { 0x67A3, "zǎo"},
    { 0x67A4, "dì"},
    { 0x67A5, "lì"},
    { 0x67A6, "lú"},
    { 0x67A7, "jiǎn"},
    { 0x67A8, "chéng"},
    { 0x67A9, "sōng"},
    { 0x67AA, "qiāng"},
    { 0x67AB, "fēng"},
    { 0x67AC, "zhān"},
    { 0x67AD, "xiāo"},
    { 0x67AE, "xiān,zhēn"},
    { 0x67AF, "kū,gū"},
    { 0x67B0, "píng"},
    { 0x67B1, "tái,sì,cí"},
    { 0x67B2, "xǐ"},
    { 0x67B3, "zhǐ,zhī"},
    { 0x67B4, "guǎi"},
    { 0x67B5, "xiāo"},
    { 0x67B6, "jià"},
    { 0x67B7, "jiā,jià"},
    { 0x67B8, "gǒu,jǔ,gōu,qú"},
    { 0x67B9, "bāo,fú"},
    { 0x67BA, "mò"},
    { 0x67BB, "yì,xiè"},
    { 0x67BC, "yè"},
    { 0x67BD, "yè"},
    { 0x67BE, "shì"},
    { 0x67BF, "niè"},
    { 0x67C0, "bǐ"},
    { 0x67C1, "duò,tuó,tuǒ"},
    { 0x67C2, "yí,duò,lí"},
    { 0x67C3, "líng"},
    { 0x67C4, "bǐng"},
    { 0x67C5, "nǐ,chì"},
    { 0x67C6, "lā"},
    { 0x67C7, "hé"},
    { 0x67C8, "bàn,pán,pàn"},
    { 0x67C9, "fán"},
    { 0x67CA, "zhōng"},
    { 0x67CB, "dài"},
    { 0x67CC, "cí"},
    { 0x67CD, "yǎng,yàng,yīng"},
    { 0x67CE, "fū,fǔ,fù"},
    { 0x67CF, "bǎi,bó,bò"},
    { 0x67D0, "mǒu,méi"},
    { 0x67D1, "gān,qián"},
    { 0x67D2, "qī"},
    { 0x67D3, "rǎn"},
    { 0x67D4, "róu"},
    { 0x67D5, "mào"},
    { 0x67D6, "sháo,shào"},
    { 0x67D7, "sōng"},
    { 0x67D8, "zhè"},
    { 0x67D9, "xiá,jiǎ"},
    { 0x67DA, "yòu,yóu,zhóu"},
    { 0x67DB, "shēn"},
    { 0x67DC, "guì,jǔ"},
    { 0x67DD, "tuò"},
    { 0x67DE, "zhà,zuò,zé"},
    { 0x67DF, "nán,rán"},
    { 0x67E0, "níng,chǔ,zhù"},
    { 0x67E1, "yǒng"},
    { 0x67E2, "dǐ,dì,chí"},
    { 0x67E3, "zhì,dié"},
    { 0x67E4, "zhā,zǔ,zū"},
    { 0x67E5, "chá,zhā,chái"},
    { 0x67E6, "dàn"},
    { 0x67E7, "gū"},
    { 0x67E8, "bù,pū"},
    { 0x67E9, "jiù"},
    { 0x67EA, "āo,ào"},
    { 0x67EB, "fú"},
    { 0x67EC, "jiǎn"},
    { 0x67ED, "bā,fú,bó,biē,pèi"},
    { 0x67EE, "duò,zuó,wù"},
    { 0x67EF, "kē"},
    { 0x67F0, "nài"},
    { 0x67F1, "zhù,zhǔ"},
    { 0x67F2, "bì,bié"},
    { 0x67F3, "liǔ"},
    { 0x67F4, "chái,cī,zhài,zì"},
    { 0x67F5, "shān,zhà"},
    { 0x67F6, "sì"},
    { 0x67F7, "chù,zhù"},
    { 0x67F8, "pēi,bēi"},
    { 0x67F9, "shì,fèi"},
    { 0x67FA, "guǎi"},
    { 0x67FB, "zhā"},
    { 0x67FC, "yǎo"},
    { 0x67FD, "chēng,jué"},
    { 0x67FE, "jiù"},
    { 0x67FF, "shì"},
    { 0x6800, "zhī"},
    { 0x6801, "liǔ"},
    { 0x6802, "méi"},
    { 0x6803, "lì"},
    { 0x6804, "róng"},
    { 0x6805, "zhà,shān,cè"},
    { 0x6806, "zǎo"},
    { 0x6807, "biāo"},
    { 0x6808, "zhàn"},
    { 0x6809, "zhì"},
    { 0x680A, "lóng"},
    { 0x680B, "dòng"},
    { 0x680C, "lú"},
    { 0x680D, "shēng"},
    { 0x680E, "lì,yuè"},
    { 0x680F, "lán"},
    { 0x6810, "yǒng"},
    { 0x6811, "shù"},
    { 0x6812, "xún,sǔn"},
    { 0x6813, "shuān,shuàn,quán"},
    { 0x6814, "qì"},
    { 0x6815, "zhēn"},
    { 0x6816, "qī,xī"},
    { 0x6817, "lì,liè"},
    { 0x6818, "yí"},
    { 0x6819, "xiáng"},
    { 0x681A, "zhèn"},
    { 0x681B, "lì"},
    { 0x681C, "sè,cì"},
    { 0x681D, "guā,tiǎn,kuò"},
    { 0x681E, "kān"},
    { 0x681F, "bēn,bīng"},
    { 0x6820, "rěn"},
    { 0x6821, "xiào,jiào,jiǎo,qiāo"},
    { 0x6822, "bǎi"},
    { 0x6823, "rěn"},
    { 0x6824, "bìng"},
    { 0x6825, "zī"},
    { 0x6826, "chóu"},
    { 0x6827, "yì"},
    { 0x6828, "cì"},
    { 0x6829, "xǔ,yǔ"},
    { 0x682A, "zhū"},
    { 0x682B, "jiàn,zùn"},
    { 0x682C, "zuì"},
    { 0x682D, "ér"},
    { 0x682E, "ěr"},
    { 0x682F, "yǒu,yù"},
    { 0x6830, "fá"},
    { 0x6831, "gǒng"},
    { 0x6832, "kǎo"},
    { 0x6833, "lǎo"},
    { 0x6834, "zhān"},
    { 0x6835, "liè"},
    { 0x6836, "yīn"},
    { 0x6837, "yàng,yáng"},
    { 0x6838, "hé,gāi,kài,hú"},
    { 0x6839, "gēn"},
    { 0x683A, "yì,zhī,zhǐ"},
    { 0x683B, "shì"},
    { 0x683C, "gé,luò,hè,gē"},
    { 0x683D, "zāi,zài"},
    { 0x683E, "luán"},
    { 0x683F, "fú"},
    { 0x6840, "jié"},
    { 0x6841, "héng,háng,hàng"},
    { 0x6842, "guì"},
    { 0x6843, "táo,tiāo,zhào"},
    { 0x6844, "guāng,guàng"},
    { 0x6845, "wéi,guǐ"},
    { 0x6846, "kuāng,kuàng,kuáng"},
    { 0x6847, "rú"},
    { 0x6848, "àn"},
    { 0x6849, "ān,àn"},
    { 0x684A, "juàn,quān"},
    { 0x684B, "yí,tí"},
    { 0x684C, "zhuō"},
    { 0x684D, "kū"},
    { 0x684E, "zhì"},
    { 0x684F, "qióng"},
    { 0x6850, "tóng,tōng,dòng"},
    { 0x6851, "sāng"},
    { 0x6852, "sāng"},
    { 0x6853, "huán"},
    { 0x6854, "jú,jié,xié"},
    { 0x6855, "jiù"},
    { 0x6856, "xuè"},
    { 0x6857, "duò"},
    { 0x6858, "zhuì"},
    { 0x6859, "yú,móu"},
    { 0x685A, "zǎn"},
    { 0x685C, "yīng"},
    { 0x685D, "jié"},
    { 0x685E, "liǔ"},
    { 0x685F, "zhàn"},
    { 0x6860, "yā"},
    { 0x6861, "ráo"},
    { 0x6862, "zhēn"},
    { 0x6863, "dàng"},
    { 0x6864, "qī"},
    { 0x6865, "qiáo"},
    { 0x6866, "huà"},
    { 0x6867, "guì,huì"},
    { 0x6868, "jiǎng"},
    { 0x6869, "zhuāng"},
    { 0x686A, "xún"},
    { 0x686B, "suō"},
    { 0x686C, "shā"},
    { 0x686D, "zhēn,chén,zhèn"},
    { 0x686E, "bēi"},
    { 0x686F, "tīng,yíng"},
    { 0x6870, "kuò"},
    { 0x6871, "jìng"},
    { 0x6872, "po,bó"},
    { 0x6873, "bèn"},
    { 0x6874, "fú"},
    { 0x6875, "ruí"},
    { 0x6876, "tǒng"},
    { 0x6877, "jué"},
    { 0x6878, "xī"},
    { 0x6879, "láng"},
    { 0x687A, "liǔ"},
    { 0x687B, "fēng,fèng"},
    { 0x687C, "qī"},
    { 0x687D, "wěn"},
    { 0x687E, "jūn"},
    { 0x687F, "gǎn,hàn"},
    { 0x6880, "sù,yìn"},
    { 0x6881, "liáng"},
    { 0x6882, "qiú"},
    { 0x6883, "tǐng,tìng"},
    { 0x6884, "yǒu"},
    { 0x6885, "méi"},
    { 0x6886, "bāng"},
    { 0x6887, "lòng"},
    { 0x6888, "pēng"},
    { 0x6889, "zhuāng"},
    { 0x688A, "dì"},
    { 0x688B, "xuān,juān,xié"},
    { 0x688C, "tú,chá,tū"},
    { 0x688D, "zào"},
    { 0x688E, "āo,yòu"},
    { 0x688F, "gù,jué"},
    { 0x6890, "bì"},
    { 0x6891, "dí"},
    { 0x6892, "hán"},
    { 0x6893, "zǐ"},
    { 0x6894, "zhī"},
    { 0x6895, "rèn"},
    { 0x6896, "bèi"},
    { 0x6897, "gěng"},
    { 0x6898, "jiǎn,xiàn,jiàn"},
    { 0x6899, "huàn"},
    { 0x689A, "wǎn"},
    { 0x689B, "nuó"},
    { 0x689C, "jiā"},
    { 0x689D, "tiáo,tiāo"},
    { 0x689E, "jì"},
    { 0x689F, "xiāo"},
    { 0x68A0, "lǚ"},
    { 0x68A1, "hún,kuǎn"},
    { 0x68A2, "shāo,shào,xiāo,sào"},
    { 0x68A3, "cén"},
    { 0x68A4, "fén"},
    { 0x68A5, "sōng"},
    { 0x68A6, "mèng"},
    { 0x68A7, "wú,wù,yǔ"},
    { 0x68A8, "lí"},
    { 0x68A9, "lí,sì,qǐ"},
    { 0x68AA, "dòu"},
    { 0x68AB, "qǐn,qīn"},
    { 0x68AC, "yǐng"},
    { 0x68AD, "suō,xùn"},
    { 0x68AE, "jū"},
    { 0x68AF, "tī,tí"},
    { 0x68B0, "xiè"},
    { 0x68B1, "kǔn,hún"},
    { 0x68B2, "zhuó"},
    { 0x68B3, "shū"},
    { 0x68B4, "chān"},
    { 0x68B5, "fàn"},
    { 0x68B6, "wěi"},
    { 0x68B7, "jìng"},
    { 0x68B8, "lí"},
    { 0x68B9, "bīn,bīng"},
    { 0x68BA, "xià"},
    { 0x68BB, "fó"},
    { 0x68BC, "táo"},
    { 0x68BD, "zhì"},
    { 0x68BE, "lái"},
    { 0x68BF, "lián"},
    { 0x68C0, "jiǎn"},
    { 0x68C1, "zhuō,tuō,ruì"},
    { 0x68C2, "líng"},
    { 0x68C3, "lí"},
    { 0x68C4, "qì"},
    { 0x68C5, "bǐng"},
    { 0x68C6, "lún"},
    { 0x68C7, "cōng,sōng"},
    { 0x68C8, "qiàn"},
    { 0x68C9, "mián"},
    { 0x68CA, "qí"},
    { 0x68CB, "qí,jī"},
    { 0x68CC, "cài"},
    { 0x68CD, "gùn,hùn,āo,gǔn"},
    { 0x68CE, "chán"},
    { 0x68CF, "dé,zhé"},
    { 0x68D0, "fěi,féi"},
    { 0x68D1, "pái,bèi,pèi"},
    { 0x68D2, "bàng"},
    { 0x68D3, "bàng,pǒu,bèi,péi,bēi"},
    { 0x68D4, "hūn"},
    { 0x68D5, "zōng"},
    { 0x68D6, "chéng,cháng"},
    { 0x68D7, "zǎo"},
    { 0x68D8, "jí"},
    { 0x68D9, "lì,liè"},
    { 0x68DA, "péng"},
    { 0x68DB, "yù"},
    { 0x68DC, "yù"},
    { 0x68DD, "gù"},
    { 0x68DE, "jùn"},
    { 0x68DF, "dòng"},
    { 0x68E0, "táng"},
    { 0x68E1, "gāng"},
    { 0x68E2, "wǎng"},
    { 0x68E3, "dì,tì,dài"},
    { 0x68E4, "cuò"},
    { 0x68E5, "fán"},
    { 0x68E6, "chēng"},
    { 0x68E7, "zhàn,zhǎn,chén"},
    { 0x68E8, "qǐ"},
    { 0x68E9, "yuān"},
    { 0x68EA, "yǎn,yàn"},
    { 0x68EB, "yù"},
    { 0x68EC, "quān,juàn,quán"},
    { 0x68ED, "yì"},
    { 0x68EE, "sēn"},
    { 0x68EF, "rěn,shěn"},
    { 0x68F0, "chuí,duǒ"},
    { 0x68F1, "léng,lèng,lēng,líng,chēng"},
    { 0x68F2, "qī,xī"},
    { 0x68F3, "zhuō"},
    { 0x68F4, "fú,sù"},
    { 0x68F5, "kē,kuǎn,kě"},
    { 0x68F6, "lái"},
    { 0x68F7, "zōu,sǒu"},
    { 0x68F8, "zōu"},
    { 0x68F9, "zhào,zhuō"},
    { 0x68FA, "guān,guàn"},
    { 0x68FB, "fēn"},
    { 0x68FC, "fén,fèn,fēn"},
    { 0x68FD, "shēn,chēn"},
    { 0x68FE, "qíng"},
    { 0x68FF, "ní,niè"},
    { 0x6900, "wǎn"},
    { 0x6901, "guǒ"},
    { 0x6902, "lù"},
    { 0x6903, "háo"},
    { 0x6904, "jiē,jié,qiè"},
    { 0x6905, "yǐ,yī"},
    { 0x6906, "chóu,zhòu,diāo"},
    { 0x6907, "jǔ"},
    { 0x6908, "jú"},
    { 0x6909, "chéng,shèng"},
    { 0x690A, "zuó,cuì"},
    { 0x690B, "liáng"},
    { 0x690C, "qiāng,kōng"},
    { 0x690D, "zhí"},
    { 0x690E, "chuí,zhuī"},
    { 0x690F, "yā,ě"},
    { 0x6910, "jū"},
    { 0x6911, "bēi,pí,bì,pái"},
    { 0x6912, "jiāo"},
    { 0x6913, "zhuó"},
    { 0x6914, "zī"},
    { 0x6915, "bīn"},
    { 0x6916, "péng"},
    { 0x6917, "dìng"},
    { 0x6918, "chǔ"},
    { 0x6919, "chāng"},
    { 0x691A, "mēn"},
    { 0x691B, "huā"},
    { 0x691C, "jiǎn"},
    { 0x691D, "guī"},
    { 0x691E, "xì"},
    { 0x691F, "dú"},
    { 0x6920, "qiàn"},
    { 0x6921, "dào"},
    { 0x6922, "guì"},
    { 0x6923, "diǎn"},
    { 0x6924, "luó"},
    { 0x6925, "zhī"},
    { 0x6926, "quan"},
    { 0x6927, "mìng"},
    { 0x6928, "fǔ"},
    { 0x6929, "gēng"},
    { 0x692A, "pèng"},
    { 0x692B, "shàn"},
    { 0x692C, "yí"},
    { 0x692D, "tuǒ"},
    { 0x692E, "sēn"},
    { 0x692F, "duǒ,chuán"},
    { 0x6930, "yē"},
    { 0x6931, "fù"},
    { 0x6932, "wěi,huī"},
    { 0x6933, "wēi"},
    { 0x6934, "duàn"},
    { 0x6935, "jiǎ,jiā"},
    { 0x6936, "zōng"},
    { 0x6937, "jiān,hán"},
    { 0x6938, "yí"},
    { 0x6939, "shèn,zhēn"},
    { 0x693A, "xí"},
    { 0x693B, "yàn,yà"},
    { 0x693C, "yǎn"},
    { 0x693D, "chuán"},
    { 0x693E, "jiān,zhàn"},
    { 0x693F, "chūn"},
    { 0x6940, "yǔ"},
    { 0x6941, "hé"},
    { 0x6942, "zhā,chá"},
    { 0x6943, "wò"},
    { 0x6944, "pián"},
    { 0x6945, "bī"},
    { 0x6946, "yāo"},
    { 0x6947, "huò,guō,kuǎ"},
    { 0x6948, "xū"},
    { 0x6949, "ruò"},
    { 0x694A, "yáng"},
    { 0x694B, "là"},
    { 0x694C, "yán"},
    { 0x694D, "běn"},
    { 0x694E, "huī"},
    { 0x694F, "kuí"},
    { 0x6950, "jiè"},
    { 0x6951, "kuí"},
    { 0x6952, "sī"},
    { 0x6953, "fēng,fán"},
    { 0x6954, "xiē,xiè"},
    { 0x6955, "tuǒ"},
    { 0x6956, "zhì,jí"},
    { 0x6957, "jiàn,jiǎn"},
    { 0x6958, "mù"},
    { 0x6959, "mào"},
    { 0x695A, "chǔ"},
    { 0x695B, "hù,kǔ"},
    { 0x695C, "hú"},
    { 0x695D, "liàn"},
    { 0x695E, "léng,lèng"},
    { 0x695F, "tíng"},
    { 0x6960, "nán"},
    { 0x6961, "yú"},
    { 0x6962, "yóu,yǒu"},
    { 0x6963, "méi,měi"},
    { 0x6964, "sǒng,cōng"},
    { 0x6965, "xuàn,yuán"},
    { 0x6966, "xuàn"},
    { 0x6967, "yǎng"},
    { 0x6968, "zhēn"},
    { 0x6969, "pián"},
    { 0x696A, "yè,dié"},
    { 0x696B, "jí"},
    { 0x696C, "jié,qià"},
    { 0x696D, "yè"},
    { 0x696E, "chǔ,zhū"},
    { 0x696F, "dùn,shǔn,chūn"},
    { 0x6970, "yú"},
    { 0x6971, "zòu,cōu"},
    { 0x6972, "wēi"},
    { 0x6973, "méi"},
    { 0x6974, "tì,dǐ,shì"},
    { 0x6975, "jí,jǐ"},
    { 0x6976, "jié"},
    { 0x6977, "kǎi,jiè,jiē"},
    { 0x6978, "qiū"},
    { 0x6979, "yíng"},
    { 0x697A, "rǒu,ròu"},
    { 0x697B, "huáng"},
    { 0x697C, "lóu"},
    { 0x697D, "lè"},
    { 0x697E, "quán"},
    { 0x697F, "xiāng"},
    { 0x6980, "pǐn"},
    { 0x6981, "shǐ"},
    { 0x6982, "gài,guì,jié"},
    { 0x6983, "tán"},
    { 0x6984, "lǎn"},
    { 0x6985, "wēn,yùn"},
    { 0x6986, "yú"},
    { 0x6987, "chèn"},
    { 0x6988, "lǘ"},
    { 0x6989, "jǔ"},
    { 0x698A, "shén"},
    { 0x698B, "chu"},
    { 0x698C, "bī"},
    { 0x698D, "xiè"},
    { 0x698E, "jiǎ"},
    { 0x698F, "yì"},
    { 0x6990, "zhǎn,chǎn,niàn,zhèn"},
    { 0x6991, "fú,fù,bó"},
    { 0x6992, "nuò"},
    { 0x6993, "mì"},
    { 0x6994, "láng,lǎng"},
    { 0x6995, "róng"},
    { 0x6996, "gǔ"},
    { 0x6997, "jiàn,jìn"},
    { 0x6998, "jǔ"},
    { 0x6999, "tā"},
    { 0x699A, "yǎo"},
    { 0x699B, "zhēn"},
    { 0x699C, "bǎng,bēng,bàng,páng,péng"},
    { 0x699D, "shā,xiè"},
    { 0x699E, "yuán"},
    { 0x699F, "zǐ"},
    { 0x69A0, "míng"},
    { 0x69A1, "sù"},
    { 0x69A2, "jià"},
    { 0x69A3, "yáo"},
    { 0x69A4, "jié"},
    { 0x69A5, "huàng"},
    { 0x69A6, "gàn,hán"},
    { 0x69A7, "fěi"},
    { 0x69A8, "zhà"},
    { 0x69A9, "qián"},
    { 0x69AA, "mà,mǎ"},
    { 0x69AB, "sǔn"},
    { 0x69AC, "yuán"},
    { 0x69AD, "xiè"},
    { 0x69AE, "róng"},
    { 0x69AF, "shí"},
    { 0x69B0, "zhī"},
    { 0x69B1, "cuī"},
    { 0x69B2, "wēn"},
    { 0x69B3, "tíng"},
    { 0x69B4, "liú"},
    { 0x69B5, "róng"},
    { 0x69B6, "táng"},
    { 0x69B7, "què"},
    { 0x69B8, "zhāi"},
    { 0x69B9, "sī"},
    { 0x69BA, "shèng"},
    { 0x69BB, "tà"},
    { 0x69BC, "kē"},
    { 0x69BD, "xī"},
    { 0x69BE, "gǔ"},
    { 0x69BF, "qī"},
    { 0x69C0, "gǎo,kào"},
    { 0x69C1, "gǎo,kào,gāo"},
    { 0x69C2, "sūn"},
    { 0x69C3, "pán"},
    { 0x69C4, "tāo"},
    { 0x69C5, "gé"},
    { 0x69C6, "chūn"},
    { 0x69C7, "diān,zhěn,zhēn"},
    { 0x69C8, "nòu"},
    { 0x69C9, "jí"},
    { 0x69CA, "shuò"},
    { 0x69CB, "gòu,jué"},
    { 0x69CC, "chuí,zhuì,duī"},
    { 0x69CD, "qiāng,chēng,qiǎng"},
    { 0x69CE, "chá"},
    { 0x69CF, "qiǎn,xiàn,lián"},
    { 0x69D0, "huái"},
    { 0x69D1, "méi"},
    { 0x69D2, "xù"},
    { 0x69D3, "gàng"},
    { 0x69D4, "gāo"},
    { 0x69D5, "zhuō"},
    { 0x69D6, "tuó"},
    { 0x69D7, "qiáo"},
    { 0x69D8, "yàng"},
    { 0x69D9, "diān"},
    { 0x69DA, "jiǎ"},
    { 0x69DB, "kǎn,jiàn"},
    { 0x69DC, "zuì"},
    { 0x69DD, "dǎo"},
    { 0x69DE, "lóng"},
    { 0x69DF, "bīn,bīng"},
    { 0x69E0, "zhū"},
    { 0x69E1, "sāng"},
    { 0x69E2, "xí,dié"},
    { 0x69E3, "jī,guī"},
    { 0x69E4, "lián,liǎn"},
    { 0x69E5, "huì"},
    { 0x69E6, "yōng"},
    { 0x69E7, "qiàn"},
    { 0x69E8, "guǒ"},
    { 0x69E9, "gài"},
    { 0x69EA, "gài"},
    { 0x69EB, "tuán,shuàn,quán"},
    { 0x69EC, "huà"},
    { 0x69ED, "qī,zú,sè"},
    { 0x69EE, "sēn,shěn"},
    { 0x69EF, "cuī,zuǐ"},
    { 0x69F0, "péng"},
    { 0x69F1, "yǒu,chǎo"},
    { 0x69F2, "hú"},
    { 0x69F3, "jiǎng,jiāng"},
    { 0x69F4, "hù"},
    { 0x69F5, "huàn"},
    { 0x69F6, "guì"},
    { 0x69F7, "niè,xiè,yì"},
    { 0x69F8, "yì"},
    { 0x69F9, "gāo"},
    { 0x69FA, "kāng"},
    { 0x69FB, "guī"},
    { 0x69FC, "guī"},
    { 0x69FD, "cáo,zāo"},
    { 0x69FE, "màn,wàn,mán"},
    { 0x69FF, "jǐn,qín"},
    { 0x6A00, "dí,zhí,zhé,dī"},
    { 0x6A01, "zhuāng,chōng"},
    { 0x6A02, "lè,yuè,yào,luò,liáo"},
    { 0x6A03, "lǎng"},
    { 0x6A04, "chén"},
    { 0x6A05, "cōng,zōng"},
    { 0x6A06, "lí,chī"},
    { 0x6A07, "xiū"},
    { 0x6A08, "qíng"},
    { 0x6A09, "shuǎng"},
    { 0x6A0A, "fán,fàn"},
    { 0x6A0B, "tōng"},
    { 0x6A0C, "guàn"},
    { 0x6A0D, "zé"},
    { 0x6A0E, "sù"},
    { 0x6A0F, "lěi,léi"},
    { 0x6A10, "lǔ"},
    { 0x6A11, "liáng"},
    { 0x6A12, "mì"},
    { 0x6A13, "lóu,lǘ"},
    { 0x6A14, "cháo,chāo,jiǎo"},
    { 0x6A15, "sù"},
    { 0x6A16, "kē"},
    { 0x6A17, "chū"},
    { 0x6A18, "táng,chēng"},
    { 0x6A19, "biāo,biào"},
    { 0x6A1A, "lù,dú"},
    { 0x6A1B, "jiū,liáo"},
    { 0x6A1C, "zhè"},
    { 0x6A1D, "zhā"},
    { 0x6A1E, "shū,ōu"},
    { 0x6A1F, "zhāng"},
    { 0x6A20, "mán,lǎng"},
    { 0x6A21, "mó,mú"},
    { 0x6A22, "niǎo,mù"},
    { 0x6A23, "yàng,xiàng"},
    { 0x6A24, "tiáo"},
    { 0x6A25, "péng"},
    { 0x6A26, "zhù"},
    { 0x6A27, "shā"},
    { 0x6A28, "xī"},
    { 0x6A29, "quán"},
    { 0x6A2A, "héng,hèng,guāng,guàng,huáng,huàng"},
    { 0x6A2B, "jiān"},
    { 0x6A2C, "cōng"},
    { 0x6A2D, "jī"},
    { 0x6A2E, "yān"},
    { 0x6A2F, "qiáng"},
    { 0x6A30, "xuě"},
    { 0x6A31, "yīng"},
    { 0x6A32, "èr,zhì"},
    { 0x6A33, "xún"},
    { 0x6A34, "zhí,yì"},
    { 0x6A35, "qiáo"},
    { 0x6A36, "zuī"},
    { 0x6A37, "cóng"},
    { 0x6A38, "pǔ,pú"},
    { 0x6A39, "shù"},
    { 0x6A3A, "huà"},
    { 0x6A3B, "kuì"},
    { 0x6A3C, "zhēn"},
    { 0x6A3D, "zūn"},
    { 0x6A3E, "yuè"},
    { 0x6A3F, "shàn"},
    { 0x6A40, "xī"},
    { 0x6A41, "chūn"},
    { 0x6A42, "diàn"},
    { 0x6A43, "fá,fèi"},
    { 0x6A44, "gǎn"},
    { 0x6A45, "mó"},
    { 0x6A46, "wǔ,wú"},
    { 0x6A47, "qiāo"},
    { 0x6A48, "ráo,náo"},
    { 0x6A49, "lìn"},
    { 0x6A4A, "liú"},
    { 0x6A4B, "qiáo,jiāo,jiào,qiāo,jiǎo"},
    { 0x6A4C, "xiàn"},
    { 0x6A4D, "rùn"},
    { 0x6A4E, "fán"},
    { 0x6A4F, "zhǎn,jiǎn"},
    { 0x6A50, "tuó,dù,luò"},
    { 0x6A51, "lǎo"},
    { 0x6A52, "yún"},
    { 0x6A53, "shùn"},
    { 0x6A54, "dūn,tuí"},
    { 0x6A55, "chēng"},
    { 0x6A56, "táng,chēng"},
    { 0x6A57, "méng"},
    { 0x6A58, "jú"},
    { 0x6A59, "chéng,dèng,chén"},
    { 0x6A5A, "sù,xiāo,qiū"},
    { 0x6A5B, "jué"},
    { 0x6A5C, "jué"},
    { 0x6A5D, "diàn,tán,xín"},
    { 0x6A5E, "huì"},
    { 0x6A5F, "jī"},
    { 0x6A60, "nuǒ,nuó"},
    { 0x6A61, "xiàng"},
    { 0x6A62, "tuǒ,duǒ"},
    { 0x6A63, "nǐng"},
    { 0x6A64, "ruǐ"},
    { 0x6A65, "zhū"},
    { 0x6A66, "tóng,chuáng,zhōng,chōng"},
    { 0x6A67, "zēng,céng"},
    { 0x6A68, "fén,fèn,fèi"},
    { 0x6A69, "qióng"},
    { 0x6A6A, "rǎn,yān"},
    { 0x6A6B, "héng"},
    { 0x6A6C, "qián,qín"},
    { 0x6A6D, "gū"},
    { 0x6A6E, "liǔ"},
    { 0x6A6F, "lào"},
    { 0x6A70, "gāo"},
    { 0x6A71, "chú"},
    { 0x6A72, "xǐ"},
    { 0x6A73, "shèng"},
    { 0x6A74, "zǐ"},
    { 0x6A75, "san"},
    { 0x6A76, "jí"},
    { 0x6A77, "dōu"},
    { 0x6A78, "jīng"},
    { 0x6A79, "lǔ"},
    { 0x6A7A, "jian"},
    { 0x6A7B, "chu"},
    { 0x6A7C, "yuán"},
    { 0x6A7D, "tà"},
    { 0x6A7E, "shū,qiāo,sāo"},
    { 0x6A7F, "jiāng"},
    { 0x6A80, "tán,shàn"},
    { 0x6A81, "lǐn"},
    { 0x6A82, "nóng"},
    { 0x6A83, "yǐn"},
    { 0x6A84, "xí"},
    { 0x6A85, "huì"},
    { 0x6A86, "shān"},
    { 0x6A87, "zuì"},
    { 0x6A88, "xuán"},
    { 0x6A89, "chēng"},
    { 0x6A8A, "gàn"},
    { 0x6A8B, "jú"},
    { 0x6A8C, "zuì"},
    { 0x6A8D, "yì"},
    { 0x6A8E, "qín"},
    { 0x6A8F, "pǔ"},
    { 0x6A90, "yán,dān"},
    { 0x6A91, "léi,lèi"},
    { 0x6A92, "fēng"},
    { 0x6A93, "huǐ"},
    { 0x6A94, "dàng,dāng"},
    { 0x6A95, "jì"},
    { 0x6A96, "suì"},
    { 0x6A97, "bò,bì"},
    { 0x6A98, "píng,bò"},
    { 0x6A99, "chéng"},
    { 0x6A9A, "chǔ"},
    { 0x6A9B, "zhuā"},
    { 0x6A9C, "guì,kuài,huì"},
    { 0x6A9D, "jí"},
    { 0x6A9E, "jiě,xiè"},
    { 0x6A9F, "jiǎ"},
    { 0x6AA0, "qíng,jìng"},
    { 0x6AA1, "zhái,shì,tú"},
    { 0x6AA2, "jiǎn"},
    { 0x6AA3, "qiáng"},
    { 0x6AA4, "dào"},
    { 0x6AA5, "yǐ"},
    { 0x6AA6, "biǎo"},
    { 0x6AA7, "sōng"},
    { 0x6AA8, "shē"},
    { 0x6AA9, "lǐn"},
    { 0x6AAA, "lì"},
    { 0x6AAB, "chá,sà"},
    { 0x6AAC, "méng"},
    { 0x6AAD, "yín"},
    { 0x6AAE, "táo,chóu,dào"},
    { 0x6AAF, "tái"},
    { 0x6AB0, "mián"},
    { 0x6AB1, "qí"},
    { 0x6AB2, "tuán"},
    { 0x6AB3, "bīn,bīng"},
    { 0x6AB4, "huò,huà"},
    { 0x6AB5, "jì"},
    { 0x6AB6, "qiān"},
    { 0x6AB7, "nǐ,mí"},
    { 0x6AB8, "níng"},
    { 0x6AB9, "yī"},
    { 0x6ABA, "gǎo"},
    { 0x6ABB, "kǎn,jiàn"},
    { 0x6ABC, "yìn"},
    { 0x6ABD, "nòu,ruǎn,rú"},
    { 0x6ABE, "qǐng"},
    { 0x6ABF, "yǎn"},
    { 0x6AC0, "qí"},
    { 0x6AC1, "mì"},
    { 0x6AC2, "zhào,dí"},
    { 0x6AC3, "guì"},
    { 0x6AC4, "chūn"},
    { 0x6AC5, "jī,jì"},
    { 0x6AC6, "kuí"},
    { 0x6AC7, "pó"},
    { 0x6AC8, "dèng"},
    { 0x6AC9, "chú"},
    { 0x6ACA, "gé"},
    { 0x6ACB, "mián"},
    { 0x6ACC, "yōu"},
    { 0x6ACD, "zhì"},
    { 0x6ACE, "huǎng,guàng,guǒ,gǔ"},
    { 0x6ACF, "qiān"},
    { 0x6AD0, "lěi"},
    { 0x6AD1, "léi,lěi"},
    { 0x6AD2, "sà"},
    { 0x6AD3, "lǔ"},
    { 0x6AD4, "lì"},
    { 0x6AD5, "cuán"},
    { 0x6AD6, "lǜ,chū"},
    { 0x6AD7, "miè,mèi"},
    { 0x6AD8, "huì"},
    { 0x6AD9, "ōu"},
    { 0x6ADA, "lǘ"},
    { 0x6ADB, "zhì"},
    { 0x6ADC, "gāo"},
    { 0x6ADD, "dú"},
    { 0x6ADE, "yuán"},
    { 0x6ADF, "lì,luò,yuè"},
    { 0x6AE0, "fèi"},
    { 0x6AE1, "zhuó,zhù"},
    { 0x6AE2, "sǒu"},
    { 0x6AE3, "lián"},
    { 0x6AE4, "jiàng"},
    { 0x6AE5, "chú"},
    { 0x6AE6, "qìng"},
    { 0x6AE7, "zhū"},
    { 0x6AE8, "lú,lǘ"},
    { 0x6AE9, "yán,yǎn"},
    { 0x6AEA, "lì"},
    { 0x6AEB, "zhū"},
    { 0x6AEC, "chèn,qìn,guàn"},
    { 0x6AED, "jié,jì"},
    { 0x6AEE, "è"},
    { 0x6AEF, "sū"},
    { 0x6AF0, "huái,guī"},
    { 0x6AF1, "niè"},
    { 0x6AF2, "yù"},
    { 0x6AF3, "lóng"},
    { 0x6AF4, "lài"},
    { 0x6AF5, "jiao"},
    { 0x6AF6, "xiǎn"},
    { 0x6AF7, "guī"},
    { 0x6AF8, "jǔ"},
    { 0x6AF9, "xiāo,qiū,xiū"},
    { 0x6AFA, "líng"},
    { 0x6AFB, "yīng"},
    { 0x6AFC, "jiān,shān"},
    { 0x6AFD, "yǐn"},
    { 0x6AFE, "yóu,yòu"},
    { 0x6AFF, "yíng"},
    { 0x6B00, "xiāng,ràng"},
    { 0x6B01, "nóng"},
    { 0x6B02, "bó"},
    { 0x6B03, "chán,zhàn"},
    { 0x6B04, "lán,liàn"},
    { 0x6B05, "jǔ"},
    { 0x6B06, "shuāng"},
    { 0x6B07, "shè"},
    { 0x6B08, "wéi,zuì"},
    { 0x6B09, "cóng"},
    { 0x6B0A, "quán,guàn"},
    { 0x6B0B, "qú"},
    { 0x6B0C, "cáng"},
    { 0x6B0D, "jiù"},
    { 0x6B0E, "yù"},
    { 0x6B0F, "luó,luǒ"},
    { 0x6B10, "lì,lǐ"},
    { 0x6B11, "cuán,zuàn"},
    { 0x6B12, "luán"},
    { 0x6B13, "dǎng,tǎng"},
    { 0x6B14, "jué"},
    { 0x6B15, "yán"},
    { 0x6B16, "lǎn"},
    { 0x6B17, "lán"},
    { 0x6B18, "zhú"},
    { 0x6B19, "léi,luǒ"},
    { 0x6B1A, "lǐ"},
    { 0x6B1B, "bà"},
    { 0x6B1C, "náng"},
    { 0x6B1D, "yù"},
    { 0x6B1E, "líng"},
    { 0x6B1F, "guang"},
    { 0x6B20, "qiàn"},
    { 0x6B21, "cì,zī,cí"},
    { 0x6B22, "huān"},
    { 0x6B23, "xīn"},
    { 0x6B24, "yú"},
    { 0x6B25, "yì,huān,yù"},
    { 0x6B26, "qiān,hān,xiān,qián"},
    { 0x6B27, "ōu"},
    { 0x6B28, "xū"},
    { 0x6B29, "chāo"},
    { 0x6B2A, "chù,xì,qù"},
    { 0x6B2B, "qì"},
    { 0x6B2C, "kài,ài"},
    { 0x6B2D, "yì,yīn"},
    { 0x6B2E, "jué"},
    { 0x6B2F, "xì,kài"},
    { 0x6B30, "xù"},
    { 0x6B31, "hē,xiá"},
    { 0x6B32, "yù"},
    { 0x6B33, "kuì"},
    { 0x6B34, "láng"},
    { 0x6B35, "kuǎn"},
    { 0x6B36, "shuò,sòu"},
    { 0x6B37, "xī"},
    { 0x6B38, "āi,ǎi,xiè,ế,éi,ê̌,ěi,ề,èi,ê̄,ēi"},
    { 0x6B39, "yī"},
    { 0x6B3A, "qī"},
    { 0x6B3B, "chuā,xū"},
    { 0x6B3C, "chǐ,chuài"},
    { 0x6B3D, "qīn,qìn,yín"},
    { 0x6B3E, "kuǎn,xīn"},
    { 0x6B3F, "kǎn,qiàn,dàn"},
    { 0x6B40, "kuǎn"},
    { 0x6B41, "kǎn,kè,qiǎn"},
    { 0x6B42, "chuǎn,chuán"},
    { 0x6B43, "shà,xiá"},
    { 0x6B44, "guā"},
    { 0x6B45, "yīn"},
    { 0x6B46, "xīn"},
    { 0x6B47, "xiē,yà"},
    { 0x6B48, "yú"},
    { 0x6B49, "qiàn"},
    { 0x6B4A, "xiāo"},
    { 0x6B4B, "yè"},
    { 0x6B4C, "gē"},
    { 0x6B4D, "wū,yāng"},
    { 0x6B4E, "tàn"},
    { 0x6B4F, "jìn,qūn"},
    { 0x6B50, "ōu,ǒu"},
    { 0x6B51, "hū"},
    { 0x6B52, "tì,xiāo"},
    { 0x6B53, "huān"},
    { 0x6B54, "xū"},
    { 0x6B55, "pēn"},
    { 0x6B56, "xǐ,yǐ"},
    { 0x6B57, "xiào"},
    { 0x6B58, "chuā,xū"},
    { 0x6B59, "shè,xī,xié"},
    { 0x6B5A, "shàn"},
    { 0x6B5B, "hān,liǎn"},
    { 0x6B5C, "chù"},
    { 0x6B5D, "yì"},
    { 0x6B5E, "è"},
    { 0x6B5F, "yú"},
    { 0x6B60, "chuò"},
    { 0x6B61, "huān"},
    { 0x6B62, "zhǐ"},
    { 0x6B63, "zhèng,zhēng"},
    { 0x6B64, "cǐ"},
    { 0x6B65, "bù"},
    { 0x6B66, "wǔ"},
    { 0x6B67, "qí"},
    { 0x6B68, "bù"},
    { 0x6B69, "bù"},
    { 0x6B6A, "wāi,wǎi"},
    { 0x6B6B, "jù"},
    { 0x6B6C, "qián"},
    { 0x6B6D, "chí,zhì"},
    { 0x6B6E, "sè"},
    { 0x6B6F, "chǐ"},
    { 0x6B70, "sè,shà"},
    { 0x6B71, "zhǒng"},
    { 0x6B72, "suì,suò"},
    { 0x6B73, "suì"},
    { 0x6B74, "lì"},
    { 0x6B75, "zé"},
    { 0x6B76, "yú"},
    { 0x6B77, "lì"},
    { 0x6B78, "guī,kuì,kuí"},
    { 0x6B79, "dǎi,è,dāi"},
    { 0x6B7A, "è"},
    { 0x6B7B, "sǐ"},
    { 0x6B7C, "jiān"},
    { 0x6B7D, "zhé"},
    { 0x6B7E, "mò,wěn"},
    { 0x6B7F, "mò"},
    { 0x6B80, "yāo"},
    { 0x6B81, "mò,wěn"},
    { 0x6B82, "cú"},
    { 0x6B83, "yāng"},
    { 0x6B84, "tiǎn"},
    { 0x6B85, "shēng"},
    { 0x6B86, "dài"},
    { 0x6B87, "shāng"},
    { 0x6B88, "xù"},
    { 0x6B89, "xùn"},
    { 0x6B8A, "shū"},
    { 0x6B8B, "cán"},
    { 0x6B8C, "jué"},
    { 0x6B8D, "piǎo,bì"},
    { 0x6B8E, "qià"},
    { 0x6B8F, "qiú"},
    { 0x6B90, "sù"},
    { 0x6B91, "qíng,jīng,jìng"},
    { 0x6B92, "yǔn"},
    { 0x6B93, "liàn"},
    { 0x6B94, "yì"},
    { 0x6B95, "fǒu,yè,bó"},
    { 0x6B96, "zhí,shì,shi"},
    { 0x6B97, "yè,yàn,yān"},
    { 0x6B98, "cán"},
    { 0x6B99, "hūn,mèn"},
    { 0x6B9A, "dān"},
    { 0x6B9B, "jí"},
    { 0x6B9C, "dié"},
    { 0x6B9D, "zhēn"},
    { 0x6B9E, "yǔn"},
    { 0x6B9F, "wēn"},
    { 0x6BA0, "chòu"},
    { 0x6BA1, "bìn"},
    { 0x6BA2, "tì"},
    { 0x6BA3, "jìn"},
    { 0x6BA4, "shāng"},
    { 0x6BA5, "yín"},
    { 0x6BA6, "diāo"},
    { 0x6BA7, "jiù"},
    { 0x6BA8, "huì,kuì"},
    { 0x6BA9, "cuàn"},
    { 0x6BAA, "yì"},
    { 0x6BAB, "dān"},
    { 0x6BAC, "dù"},
    { 0x6BAD, "jiāng"},
    { 0x6BAE, "liàn"},
    { 0x6BAF, "bìn"},
    { 0x6BB0, "dú"},
    { 0x6BB1, "jiān"},
    { 0x6BB2, "jiān"},
    { 0x6BB3, "shū"},
    { 0x6BB4, "ōu"},
    { 0x6BB5, "duàn"},
    { 0x6BB6, "zhù"},
    { 0x6BB7, "yīn,yǐn,yān"},
    { 0x6BB8, "qìng,kēng,shēng"},
    { 0x6BB9, "yì"},
    { 0x6BBA, "shā,shài,sà,xiè,shì"},
    { 0x6BBB, "qiào"},
    { 0x6BBC, "ké,qiào"},
    { 0x6BBD, "xiáo,yáo,xiào"},
    { 0x6BBE, "xùn"},
    { 0x6BBF, "diàn"},
    { 0x6BC0, "huǐ"},
    { 0x6BC1, "huǐ,huì"},
    { 0x6BC2, "gǔ,gū"},
    { 0x6BC3, "qiāo"},
    { 0x6BC4, "jī"},
    { 0x6BC5, "yì"},
    { 0x6BC6, "ōu,kōu,qū"},
    { 0x6BC7, "huǐ"},
    { 0x6BC8, "duàn"},
    { 0x6BC9, "yī"},
    { 0x6BCA, "xiāo"},
    { 0x6BCB, "wú,móu"},
    { 0x6BCC, "guàn"},
    { 0x6BCD, "mǔ,mú,wǔ,wú"},
    { 0x6BCE, "měi"},
    { 0x6BCF, "měi"},
    { 0x6BD0, "ǎi"},
    { 0x6BD1, "jiě"},
    { 0x6BD2, "dú,dài"},
    { 0x6BD3, "yù"},
    { 0x6BD4, "bǐ,bì,pí,pǐ"},
    { 0x6BD5, "bì"},
    { 0x6BD6, "bì"},
    { 0x6BD7, "pí"},
    { 0x6BD8, "pí"},
    { 0x6BD9, "bì"},
    { 0x6BDA, "chán"},
    { 0x6BDB, "máo,mào"},
    { 0x6BDC, "háo"},
    { 0x6BDD, "cǎi"},
    { 0x6BDE, "pí"},
    { 0x6BDF, "liě"},
    { 0x6BE0, "jiā"},
    { 0x6BE1, "zhān"},
    { 0x6BE2, "sāi"},
    { 0x6BE3, "mù,mào"},
    { 0x6BE4, "tuò"},
    { 0x6BE5, "xún,xùn"},
    { 0x6BE6, "ěr"},
    { 0x6BE7, "róng"},
    { 0x6BE8, "xiǎn"},
    { 0x6BE9, "jú"},
    { 0x6BEA, "mú"},
    { 0x6BEB, "háo"},
    { 0x6BEC, "qiú"},
    { 0x6BED, "dòu,nuò"},
    { 0x6BEE, "shā"},
    { 0x6BEF, "tǎn"},
    { 0x6BF0, "péi"},
    { 0x6BF1, "jú"},
    { 0x6BF2, "duō"},
    { 0x6BF3, "cuì,qiāo,xiā"},
    { 0x6BF4, "bī"},
    { 0x6BF5, "sān"},
    { 0x6BF6, "sān"},
    { 0x6BF7, "mào"},
    { 0x6BF8, "sāi,suī"},
    { 0x6BF9, "shū,yú"},
    { 0x6BFA, "shū"},
    { 0x6BFB, "tuò"},
    { 0x6BFC, "hé,kě,dā"},
    { 0x6BFD, "jiàn"},
    { 0x6BFE, "tà"},
    { 0x6BFF, "sān"},
    { 0x6C00, "lǘ,shū,yú,dōu"},
    { 0x6C01, "mú"},
    { 0x6C02, "máo,lí"},
    { 0x6C03, "tóng"},
    { 0x6C04, "rǒng,róng"},
    { 0x6C05, "chǎng"},
    { 0x6C06, "pǔ"},
    { 0x6C07, "lu"},
    { 0x6C08, "zhān"},
    { 0x6C09, "sào"},
    { 0x6C0A, "zhān"},
    { 0x6C0B, "méng"},
    { 0x6C0C, "lǔ"},
    { 0x6C0D, "qú"},
    { 0x6C0E, "dié"},
    { 0x6C0F, "shì,zhī,jīng"},
    { 0x6C10, "dī,dǐ,zhī"},
    { 0x6C11, "mín"},
    { 0x6C12, "jué"},
    { 0x6C13, "máng,méng"},
    { 0x6C14, "qì,qǐ"},
    { 0x6C15, "piē"},
    { 0x6C16, "nǎi"},
    { 0x6C17, "qì"},
    { 0x6C18, "dāo"},
    { 0x6C19, "xiān"},
    { 0x6C1A, "chuān"},
    { 0x6C1B, "fēn"},
    { 0x6C1C, "yáng,rì"},
    { 0x6C1D, "nèi"},
    { 0x6C1E, "bin"},
    { 0x6C1F, "fú"},
    { 0x6C20, "shēn"},
    { 0x6C21, "dōng"},
    { 0x6C22, "qīng"},
    { 0x6C23, "qì,xì"},
    { 0x6C24, "yīn,yán"},
    { 0x6C25, "xī"},
    { 0x6C26, "hài"},
    { 0x6C27, "yǎng"},
    { 0x6C28, "ān"},
    { 0x6C29, "yà"},
    { 0x6C2A, "kè"},
    { 0x6C2B, "qīng"},
    { 0x6C2C, "yà"},
    { 0x6C2D, "dōng"},
    { 0x6C2E, "dàn"},
    { 0x6C2F, "lǜ"},
    { 0x6C30, "qíng"},
    { 0x6C31, "yǎng"},
    { 0x6C32, "yūn,yún"},
    { 0x6C33, "yūn"},
    { 0x6C34, "shuǐ"},
    { 0x6C35, "shui"},
    { 0x6C36, "zhěng,chéng,zhèng"},
    { 0x6C37, "bīng"},
    { 0x6C38, "yǒng"},
    { 0x6C39, "dàng"},
    { 0x6C3A, "shuǐ"},
    { 0x6C3B, "lè"},
    { 0x6C3C, "nì,mèi"},
    { 0x6C3D, "tǔn,qiú"},
    { 0x6C3E, "fàn,fán"},
    { 0x6C3F, "guǐ,qiú,jiǔ"},
    { 0x6C40, "tīng,tìng,dìng"},
    { 0x6C41, "zhī,xié,shí"},
    { 0x6C42, "qiú"},
    { 0x6C43, "bīn,pà,pā"},
    { 0x6C44, "zè"},
    { 0x6C45, "miǎn"},
    { 0x6C46, "cuān"},
    { 0x6C47, "huì"},
    { 0x6C48, "diāo"},
    { 0x6C49, "hàn"},
    { 0x6C4A, "chà"},
    { 0x6C4B, "zhuó,yuè,què,shuò"},
    { 0x6C4C, "chuàn"},
    { 0x6C4D, "wán,huán"},
    { 0x6C4E, "fàn,fá"},
    { 0x6C4F, "dà,tài"},
    { 0x6C50, "xī"},
    { 0x6C51, "tuō"},
    { 0x6C52, "máng,mǎng"},
    { 0x6C53, "qiú,yóu"},
    { 0x6C54, "qì"},
    { 0x6C55, "shàn,shuàn"},
    { 0x6C56, "pìn,chí"},
    { 0x6C57, "hàn,hán,gān"},
    { 0x6C58, "qiān"},
    { 0x6C59, "wū,yú,wā,yū"},
    { 0x6C5A, "wū"},
    { 0x6C5B, "xùn"},
    { 0x6C5C, "sì"},
    { 0x6C5D, "rǔ"},
    { 0x6C5E, "gǒng"},
    { 0x6C5F, "jiāng"},
    { 0x6C60, "chí,tuó,chè"},
    { 0x6C61, "wū"},
    { 0x6C62, "tu"},
    { 0x6C63, "jiǔ"},
    { 0x6C64, "tāng,shāng"},
    { 0x6C65, "zhī,jì"},
    { 0x6C66, "zhǐ"},
    { 0x6C67, "qiān,yán"},
    { 0x6C68, "mì"},
    { 0x6C69, "gǔ,yù,hú"},
    { 0x6C6A, "wāng,wǎng,hóng"},
    { 0x6C6B, "jǐng"},
    { 0x6C6C, "jǐng"},
    { 0x6C6D, "ruì,tūn"},
    { 0x6C6E, "jūn"},
    { 0x6C6F, "hóng"},
    { 0x6C70, "tài"},
    { 0x6C71, "quǎn,fú"},
    { 0x6C72, "jí,jī"},
    { 0x6C73, "biàn"},
    { 0x6C74, "biàn"},
    { 0x6C75, "gàn,hán,cén"},
    { 0x6C76, "wèn,wén,mín,mén"},
    { 0x6C77, "zhōng"},
    { 0x6C78, "fāng,pāng"},
    { 0x6C79, "xiōng"},
    { 0x6C7A, "jué,quē,xuè"},
    { 0x6C7B, "hǔ,huǎng"},
    { 0x6C7C, "niú,yóu"},
    { 0x6C7D, "qì,gài,yǐ"},
    { 0x6C7E, "fén,pén,fēn"},
    { 0x6C7F, "xù"},
    { 0x6C80, "xù"},
    { 0x6C81, "qìn"},
    { 0x6C82, "yí,yín"},
    { 0x6C83, "wò"},
    { 0x6C84, "yún"},
    { 0x6C85, "yuán"},
    { 0x6C86, "hàng,háng,kàng"},
    { 0x6C87, "yǎn,wěi"},
    { 0x6C88, "shěn,chén,tán"},
    { 0x6C89, "chén"},
    { 0x6C8A, "dàn"},
    { 0x6C8B, "yóu"},
    { 0x6C8C, "dùn,tún,chún,zhuàn"},
    { 0x6C8D, "hù,hú"},
    { 0x6C8E, "huò"},
    { 0x6C8F, "qī,qiè"},
    { 0x6C90, "mù"},
    { 0x6C91, "nǜ,niǔ"},
    { 0x6C92, "méi"},
    { 0x6C93, "dá,tà"},
    { 0x6C94, "miǎn"},
    { 0x6C95, "mì,wù,fū"},
    { 0x6C96, "chōng"},
    { 0x6C97, "pāng,tiān"},
    { 0x6C98, "bǐ"},
    { 0x6C99, "shā,shà,suō"},
    { 0x6C9A, "zhǐ"},
    { 0x6C9B, "pèi"},
    { 0x6C9C, "pàn"},
    { 0x6C9D, "zhuǐ,zǐ"},
    { 0x6C9E, "zā"},
    { 0x6C9F, "gōu"},
    { 0x6CA0, "liú"},
    { 0x6CA1, "méi,mò,me"},
    { 0x6CA2, "zé"},
    { 0x6CA3, "fēng"},
    { 0x6CA4, "ōu,òu"},
    { 0x6CA5, "lì"},
    { 0x6CA6, "lún"},
    { 0x6CA7, "cāng"},
    { 0x6CA8, "fēng"},
    { 0x6CA9, "wéi"},
    { 0x6CAA, "hù"},
    { 0x6CAB, "mò"},
    { 0x6CAC, "mèi,huì"},
    { 0x6CAD, "shù"},
    { 0x6CAE, "jǔ,jū,jù,jiān,zǔ"},
    { 0x6CAF, "zá"},
    { 0x6CB0, "tuō,duó"},
    { 0x6CB1, "tuó,duò,chí"},
    { 0x6CB2, "tuó"},
    { 0x6CB3, "hé"},
    { 0x6CB4, "lì,zhěn"},
    { 0x6CB5, "mǐ"},
    { 0x6CB6, "yí,chí,shì"},
    { 0x6CB7, "fā"},
    { 0x6CB8, "fèi,fú"},
    { 0x6CB9, "yóu,yòu"},
    { 0x6CBA, "tián"},
    { 0x6CBB, "zhì,chí"},
    { 0x6CBC, "zhǎo"},
    { 0x6CBD, "gū,gǔ"},
    { 0x6CBE, "zhān,tiān,diàn,chān"},
    { 0x6CBF, "yán,yǎn,yàn"},
    { 0x6CC0, "sī"},
    { 0x6CC1, "kuàng"},
    { 0x6CC2, "jiǒng,yíng,yǐng,jiōng"},
    { 0x6CC3, "jū,gōu"},
    { 0x6CC4, "xiè,yì"},
    { 0x6CC5, "qiú,yōu"},
    { 0x6CC6, "yì,dié"},
    { 0x6CC7, "jiā"},
    { 0x6CC8, "zhōng"},
    { 0x6CC9, "quán"},
    { 0x6CCA, "pō,bó,pò"},
    { 0x6CCB, "huì,huǐ"},
    { 0x6CCC, "mì,bì"},
    { 0x6CCD, "bēn,bèn"},
    { 0x6CCE, "zé"},
    { 0x6CCF, "zhú,kū"},
    { 0x6CD0, "lè"},
    { 0x6CD1, "yōu,āo"},
    { 0x6CD2, "gū"},
    { 0x6CD3, "hóng"},
    { 0x6CD4, "gān,hàn"},
    { 0x6CD5, "fǎ"},
    { 0x6CD6, "mǎo,liǔ"},
    { 0x6CD7, "sì"},
    { 0x6CD8, "hū"},
    { 0x6CD9, "píng,pēng"},
    { 0x6CDA, "cǐ,zǐ"},
    { 0x6CDB, "fàn,fěng,fá"},
    { 0x6CDC, "zhī,chí,zhì"},
    { 0x6CDD, "sù"},
    { 0x6CDE, "nìng,zhù"},
    { 0x6CDF, "chēng"},
    { 0x6CE0, "líng,lǐng"},
    { 0x6CE1, "pào,pāo,páo"},
    { 0x6CE2, "bō,bēi,bì"},
    { 0x6CE3, "qì,lì,sè"},
    { 0x6CE4, "sì"},
    { 0x6CE5, "ní,nì,nǐ,niè,nìng"},
    { 0x6CE6, "jú"},
    { 0x6CE7, "sà,xuè"},
    { 0x6CE8, "zhù,zhòu"},
    { 0x6CE9, "shēng"},
    { 0x6CEA, "lèi"},
    { 0x6CEB, "xuàn,xuán,juān"},
    { 0x6CEC, "jué,xuè"},
    { 0x6CED, "fú"},
    { 0x6CEE, "pàn"},
    { 0x6CEF, "mǐn,miàn"},
    { 0x6CF0, "tài"},
    { 0x6CF1, "yāng"},
    { 0x6CF2, "jǐ"},
    { 0x6CF3, "yǒng"},
    { 0x6CF4, "guàn"},
    { 0x6CF5, "bèng,pìn,liú"},
    { 0x6CF6, "xué"},
    { 0x6CF7, "lóng,shuāng"},
    { 0x6CF8, "lú"},
    { 0x6CF9, "dàn"},
    { 0x6CFA, "luò,pō"},
    { 0x6CFB, "xiè"},
    { 0x6CFC, "pō"},
    { 0x6CFD, "zé"},
    { 0x6CFE, "jīng"},
    { 0x6CFF, "yín"},
    { 0x6D00, "pán,zhōu"},
    { 0x6D01, "jié,jí"},
    { 0x6D02, "yè"},
    { 0x6D03, "huī"},
    { 0x6D04, "huí,huì"},
    { 0x6D05, "zài"},
    { 0x6D06, "chéng"},
    { 0x6D07, "yīn,yān,yē"},
    { 0x6D08, "wéi"},
    { 0x6D09, "hòu"},
    { 0x6D0A, "jiàn,cún"},
    { 0x6D0B, "yáng,xiáng,yǎng"},
    { 0x6D0C, "liè"},
    { 0x6D0D, "sì"},
    { 0x6D0E, "jì"},
    { 0x6D0F, "ér"},
    { 0x6D10, "xíng"},
    { 0x6D11, "fú,fù"},
    { 0x6D12, "sǎ,xǐ,xiǎn,sěn,cuǐ,xùn"},
    { 0x6D13, "sè,qì,zì"},
    { 0x6D14, "zhǐ"},
    { 0x6D15, "yìn"},
    { 0x6D16, "wú"},
    { 0x6D17, "xǐ,xiǎn"},
    { 0x6D18, "kǎo,kào"},
    { 0x6D19, "zhū"},
    { 0x6D1A, "jiàng,hóng"},
    { 0x6D1B, "luò"},
    { 0x6D1C, "luò"},
    { 0x6D1D, "àn,yàn,è"},
    { 0x6D1E, "dòng,tóng"},
    { 0x6D1F, "tì"},
    { 0x6D20, "móu"},
    { 0x6D21, "lèi,lěi"},
    { 0x6D22, "yī"},
    { 0x6D23, "mǐ"},
    { 0x6D24, "quán"},
    { 0x6D25, "jīn"},
    { 0x6D26, "pò"},
    { 0x6D27, "wěi"},
    { 0x6D28, "xiáo"},
    { 0x6D29, "xiè,yì"},
    { 0x6D2A, "hóng"},
    { 0x6D2B, "xù,yì"},
    { 0x6D2C, "sù,shuò"},
    { 0x6D2D, "kuāng"},
    { 0x6D2E, "táo,yáo,dào"},
    { 0x6D2F, "qiè,jié"},
    { 0x6D30, "jù"},
    { 0x6D31, "ěr"},
    { 0x6D32, "zhōu"},
    { 0x6D33, "rù,rú"},
    { 0x6D34, "píng,pēng"},
    { 0x6D35, "xún,xuàn"},
    { 0x6D36, "xiōng"},
    { 0x6D37, "zhì"},
    { 0x6D38, "guāng,huàng"},
    { 0x6D39, "huán"},
    { 0x6D3A, "míng"},
    { 0x6D3B, "huó,guō"},
    { 0x6D3C, "wā,guī"},
    { 0x6D3D, "qià,hé"},
    { 0x6D3E, "pài,mài,bài,pā"},
    { 0x6D3F, "wū,hù"},
    { 0x6D40, "qū"},
    { 0x6D41, "liú"},
    { 0x6D42, "yì"},
    { 0x6D43, "jiā"},
    { 0x6D44, "jìng"},
    { 0x6D45, "qiǎn,jiān"},
    { 0x6D46, "jiāng,jiàng"},
    { 0x6D47, "jiāo"},
    { 0x6D48, "zhēn"},
    { 0x6D49, "shī"},
    { 0x6D4A, "zhuó"},
    { 0x6D4B, "cè"},
    { 0x6D4C, "fá"},
    { 0x6D4D, "huì,kuài"},
    { 0x6D4E, "jì,jǐ"},
    { 0x6D4F, "liú"},
    { 0x6D50, "chǎn"},
    { 0x6D51, "hún"},
    { 0x6D52, "hǔ,xǔ"},
    { 0x6D53, "nóng"},
    { 0x6D54, "xún"},
    { 0x6D55, "jìn"},
    { 0x6D56, "liè"},
    { 0x6D57, "qiú"},
    { 0x6D58, "wěi"},
    { 0x6D59, "zhè"},
    { 0x6D5A, "jùn,xùn,cún"},
    { 0x6D5B, "hán,hàn,gān"},
    { 0x6D5C, "bāng,bīn"},
    { 0x6D5D, "máng"},
    { 0x6D5E, "zhuó"},
    { 0x6D5F, "yóu,dí"},
    { 0x6D60, "xī"},
    { 0x6D61, "bó"},
    { 0x6D62, "dòu"},
    { 0x6D63, "huàn"},
    { 0x6D64, "hóng"},
    { 0x6D65, "yì,yà"},
    { 0x6D66, "pǔ"},
    { 0x6D67, "yǐng,chéng,yíng,zhèng,yìng"},
    { 0x6D68, "lǎn"},
    { 0x6D69, "hào,gǎo,gé"},
    { 0x6D6A, "làng,láng"},
    { 0x6D6B, "hǎn"},
    { 0x6D6C, "lǐ,hǎi"},
    { 0x6D6D, "gēng"},
    { 0x6D6E, "fú"},
    { 0x6D6F, "wú"},
    { 0x6D70, "liàn"},
    { 0x6D71, "chún"},
    { 0x6D72, "féng,hóng"},
    { 0x6D73, "yì"},
    { 0x6D74, "yù"},
    { 0x6D75, "tóng"},
    { 0x6D76, "láo"},
    { 0x6D77, "hǎi"},
    { 0x6D78, "jìn,qīn"},
    { 0x6D79, "jiā,xiá"},
    { 0x6D7A, "chōng"},
    { 0x6D7B, "jiǒng,jiōng"},
    { 0x6D7C, "měi"},
    { 0x6D7D, "suī,něi"},
    { 0x6D7E, "chēng"},
    { 0x6D7F, "pèi"},
    { 0x6D80, "xiàn,jiǎn"},
    { 0x6D81, "shèn"},
    { 0x6D82, "tú,chú,yé"},
    { 0x6D83, "kùn"},
    { 0x6D84, "pīng"},
    { 0x6D85, "niè"},
    { 0x6D86, "hàn"},
    { 0x6D87, "jīng,qǐng"},
    { 0x6D88, "xiāo"},
    { 0x6D89, "shè,dié"},
    { 0x6D8A, "niǎn,rěn"},
    { 0x6D8B, "tū"},
    { 0x6D8C, "yǒng,chōng"},
    { 0x6D8D, "xiào"},
    { 0x6D8E, "xián,yàn,diàn"},
    { 0x6D8F, "tǐng"},
    { 0x6D90, "é"},
    { 0x6D91, "sù,sōu,shù"},
    { 0x6D92, "tūn,yūn"},
    { 0x6D93, "juān,yuàn,xuàn"},
    { 0x6D94, "cén,qián,zàn"},
    { 0x6D95, "tì"},
    { 0x6D96, "lì"},
    { 0x6D97, "shuì"},
    { 0x6D98, "sì"},
    { 0x6D99, "lèi"},
    { 0x6D9A, "shuì"},
    { 0x6D9B, "tāo"},
    { 0x6D9C, "dú"},
    { 0x6D9D, "lào"},
    { 0x6D9E, "lái"},
    { 0x6D9F, "lián"},
    { 0x6DA0, "wéi"},
    { 0x6DA1, "wō,guō"},
    { 0x6DA2, "yún"},
    { 0x6DA3, "huàn,huì"},
    { 0x6DA4, "dí"},
    { 0x6DA5, "hēng"},
    { 0x6DA6, "rùn"},
    { 0x6DA7, "jiàn"},
    { 0x6DA8, "zhǎng,zhàng"},
    { 0x6DA9, "sè"},
    { 0x6DAA, "fú,póu"},
    { 0x6DAB, "guàn"},
    { 0x6DAC, "xìng"},
    { 0x6DAD, "shòu,tāo"},
    { 0x6DAE, "shuàn,shuā"},
    { 0x6DAF, "yá"},
    { 0x6DB0, "chuò"},
    { 0x6DB1, "zhàng"},
    { 0x6DB2, "yè,shì"},
    { 0x6DB3, "kōng,náng"},
    { 0x6DB4, "wò,wǎn,yuān"},
    { 0x6DB5, "hán,hàn"},
    { 0x6DB6, "tuō,tuò"},
    { 0x6DB7, "dōng"},
    { 0x6DB8, "hé"},
    { 0x6DB9, "wō"},
    { 0x6DBA, "jū"},
    { 0x6DBB, "shè"},
    { 0x6DBC, "liáng,liàng"},
    { 0x6DBD, "hūn,hùn"},
    { 0x6DBE, "tà"},
    { 0x6DBF, "zhuō,zhuó"},
    { 0x6DC0, "diàn"},
    { 0x6DC1, "qiè,jí"},
    { 0x6DC2, "dé"},
    { 0x6DC3, "juàn"},
    { 0x6DC4, "zī"},
    { 0x6DC5, "xī"},
    { 0x6DC6, "xiáo"},
    { 0x6DC7, "qí"},
    { 0x6DC8, "gǔ,hù"},
    { 0x6DC9, "guǒ,guàn"},
    { 0x6DCA, "yān,hàn,yǎn,hán"},
    { 0x6DCB, "lín,lìn"},
    { 0x6DCC, "tǎng,chàng,chǎng"},
    { 0x6DCD, "zhōu,diāo"},
    { 0x6DCE, "pěng"},
    { 0x6DCF, "hào"},
    { 0x6DD0, "chāng"},
    { 0x6DD1, "shū,chù"},
    { 0x6DD2, "qī,qiàn"},
    { 0x6DD3, "fāng"},
    { 0x6DD4, "zhí"},
    { 0x6DD5, "lù"},
    { 0x6DD6, "nào,zhào,zhuō,chuò"},
    { 0x6DD7, "jú"},
    { 0x6DD8, "táo"},
    { 0x6DD9, "cóng,shuàng"},
    { 0x6DDA, "lèi,lì"},
    { 0x6DDB, "zhè"},
    { 0x6DDC, "píng,péng"},
    { 0x6DDD, "féi"},
    { 0x6DDE, "sōng"},
    { 0x6DDF, "tiǎn"},
    { 0x6DE0, "pì,pèi"},
    { 0x6DE1, "dàn,yàn,tán"},
    { 0x6DE2, "yù,xù"},
    { 0x6DE3, "ní"},
    { 0x6DE4, "yū"},
    { 0x6DE5, "lù"},
    { 0x6DE6, "gàn,hán"},
    { 0x6DE7, "mì"},
    { 0x6DE8, "jìng,chéng"},
    { 0x6DE9, "líng"},
    { 0x6DEA, "lún,lǔn,guān"},
    { 0x6DEB, "yín,yàn,yáo"},
    { 0x6DEC, "cuì,zú"},
    { 0x6DED, "qú"},
    { 0x6DEE, "huái"},
    { 0x6DEF, "yù"},
    { 0x6DF0, "niǎn,shěn,nà"},
    { 0x6DF1, "shēn"},
    { 0x6DF2, "biāo,hū,hǔ"},
    { 0x6DF3, "chún,zhūn,zhǔn"},
    { 0x6DF4, "hū"},
    { 0x6DF5, "yuān"},
    { 0x6DF6, "lái"},
    { 0x6DF7, "hùn,gǔn,hún,kūn"},
    { 0x6DF8, "qīng"},
    { 0x6DF9, "yān,yǎn"},
    { 0x6DFA, "qiǎn,jiān,jiàn,cán,zàn"},
    { 0x6DFB, "tiān,tiàn"},
    { 0x6DFC, "miǎo"},
    { 0x6DFD, "zhǐ"},
    { 0x6DFE, "yǐn"},
    { 0x6DFF, "bó"},
    { 0x6E00, "bèn,bēn"},
    { 0x6E01, "yuān"},
    { 0x6E02, "wèn,mín"},
    { 0x6E03, "ruò,rè"},
    { 0x6E04, "fēi"},
    { 0x6E05, "qīng,qìng"},
    { 0x6E06, "yuān"},
    { 0x6E07, "kě"},
    { 0x6E08, "jì"},
    { 0x6E09, "shè"},
    { 0x6E0A, "yuān"},
    { 0x6E0B, "sè"},
    { 0x6E0C, "lù"},
    { 0x6E0D, "zì"},
    { 0x6E0E, "dú"},
    { 0x6E0F, "yī"},
    { 0x6E10, "jiàn,jiān"},
    { 0x6E11, "miǎn,shéng"},
    { 0x6E12, "pài"},
    { 0x6E13, "xī"},
    { 0x6E14, "yú"},
    { 0x6E15, "yuān"},
    { 0x6E16, "shěn"},
    { 0x6E17, "shèn"},
    { 0x6E18, "róu"},
    { 0x6E19, "huàn"},
    { 0x6E1A, "zhǔ"},
    { 0x6E1B, "jiǎn"},
    { 0x6E1C, "nuǎn,nuán"},
    { 0x6E1D, "yú,yū"},
    { 0x6E1E, "qiú,wù"},
    { 0x6E1F, "tíng,tīng"},
    { 0x6E20, "qú,jù"},
    { 0x6E21, "dù"},
    { 0x6E22, "fán,féng"},
    { 0x6E23, "zhā"},
    { 0x6E24, "bó"},
    { 0x6E25, "wò,òu,wū"},
    { 0x6E26, "wō,guō"},
    { 0x6E27, "dì,tí,dī"},
    { 0x6E28, "wēi"},
    { 0x6E29, "wēn,yùn"},
    { 0x6E2A, "rú"},
    { 0x6E2B, "xiè,dié,zhá,yì,qiè"},
    { 0x6E2C, "cè"},
    { 0x6E2D, "wèi"},
    { 0x6E2E, "hé"}
};
