/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     chenhaifeng  <chenhaifeng@uniontech.com>
*
* Maintainer: chenhaifeng  <chenhaifeng@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "pinyindict.h"

QMap<int, QString> PinyinDict_8{
    { 0x6E2F, "gǎng,hòng"},
    { 0x6E30, "yǎn"},
    { 0x6E31, "hóng,gòng"},
    { 0x6E32, "xuàn"},
    { 0x6E33, "mǐ"},
    { 0x6E34, "kě,jié,kài,hé"},
    { 0x6E35, "máo"},
    { 0x6E36, "yīng"},
    { 0x6E37, "yǎn"},
    { 0x6E38, "yóu,liú"},
    { 0x6E39, "hōng,qìng"},
    { 0x6E3A, "miǎo"},
    { 0x6E3B, "shěng"},
    { 0x6E3C, "měi"},
    { 0x6E3D, "zāi"},
    { 0x6E3E, "hún,hùn,gǔn"},
    { 0x6E3F, "nài"},
    { 0x6E40, "guǐ"},
    { 0x6E41, "chì"},
    { 0x6E42, "è"},
    { 0x6E43, "pài,bá"},
    { 0x6E44, "méi"},
    { 0x6E45, "liàn,làn"},
    { 0x6E46, "qì"},
    { 0x6E47, "qì"},
    { 0x6E48, "méi"},
    { 0x6E49, "tián"},
    { 0x6E4A, "còu"},
    { 0x6E4B, "wéi"},
    { 0x6E4C, "cān"},
    { 0x6E4D, "tuān,zhuān"},
    { 0x6E4E, "miǎn"},
    { 0x6E4F, "huì,mǐn"},
    { 0x6E50, "mò"},
    { 0x6E51, "xū,xǔ,xù"},
    { 0x6E52, "jí"},
    { 0x6E53, "pén,pèn"},
    { 0x6E54, "jiān,zàn,zhǎn,qián,jiàn"},
    { 0x6E55, "jiǎn"},
    { 0x6E56, "hú"},
    { 0x6E57, "fèng"},
    { 0x6E58, "xiāng"},
    { 0x6E59, "yì"},
    { 0x6E5A, "yìn"},
    { 0x6E5B, "zhàn,chén,dān,tán,jìn,yǐn,chěn,yín,shèn"},
    { 0x6E5C, "shí"},
    { 0x6E5D, "jiē,xié"},
    { 0x6E5E, "zhēn,chēng"},
    { 0x6E5F, "huáng,kuàng"},
    { 0x6E60, "tàn"},
    { 0x6E61, "yú"},
    { 0x6E62, "bì"},
    { 0x6E63, "mǐn,hūn,miàn"},
    { 0x6E64, "shī"},
    { 0x6E65, "tū"},
    { 0x6E66, "shēng"},
    { 0x6E67, "yǒng"},
    { 0x6E68, "jú"},
    { 0x6E69, "dòng,dǒng,tóng"},
    { 0x6E6A, "tuàn,nuǎn"},
    { 0x6E6B, "jiǎo,jiù,jiū,qiū,jiāo"},
    { 0x6E6C, "jiǎo"},
    { 0x6E6D, "qiú"},
    { 0x6E6E, "yān,yīn"},
    { 0x6E6F, "tāng,tàng,shāng,yáng"},
    { 0x6E70, "lóng"},
    { 0x6E71, "huò"},
    { 0x6E72, "yuán"},
    { 0x6E73, "nǎn"},
    { 0x6E74, "bàn,pán"},
    { 0x6E75, "yǒu"},
    { 0x6E76, "quán"},
    { 0x6E77, "zhuāng,hún"},
    { 0x6E78, "liàng"},
    { 0x6E79, "chán"},
    { 0x6E7A, "xián"},
    { 0x6E7B, "chún"},
    { 0x6E7C, "niè"},
    { 0x6E7D, "zī"},
    { 0x6E7E, "wān"},
    { 0x6E7F, "shī"},
    { 0x6E80, "mǎn"},
    { 0x6E81, "yíng"},
    { 0x6E82, "là"},
    { 0x6E83, "kuì,huì"},
    { 0x6E84, "féng"},
    { 0x6E85, "jiàn,jiān"},
    { 0x6E86, "xù"},
    { 0x6E87, "lóu"},
    { 0x6E88, "wéi"},
    { 0x6E89, "gài,xiè"},
    { 0x6E8A, "bō"},
    { 0x6E8B, "yíng"},
    { 0x6E8C, "pō"},
    { 0x6E8D, "jìn"},
    { 0x6E8E, "yàn,guì"},
    { 0x6E8F, "táng"},
    { 0x6E90, "yuán"},
    { 0x6E91, "suǒ"},
    { 0x6E92, "yuán"},
    { 0x6E93, "lián,liǎn,xián,xiàn,nián,lín"},
    { 0x6E94, "yǎo"},
    { 0x6E95, "méng"},
    { 0x6E96, "zhǔn,zhuó"},
    { 0x6E97, "chéng"},
    { 0x6E98, "kè,kài"},
    { 0x6E99, "tài"},
    { 0x6E9A, "tǎ,dá"},
    { 0x6E9B, "wā"},
    { 0x6E9C, "liū,liù,liú"},
    { 0x6E9D, "gōu,gǎng,kòu"},
    { 0x6E9E, "sāo"},
    { 0x6E9F, "míng,mǐng,mì"},
    { 0x6EA0, "zhà,zhā"},
    { 0x6EA1, "shí"},
    { 0x6EA2, "yì"},
    { 0x6EA3, "lùn"},
    { 0x6EA4, "mǎ"},
    { 0x6EA5, "pǔ,fū,bù,bó,pò"},
    { 0x6EA6, "wēi,méi"},
    { 0x6EA7, "lì"},
    { 0x6EA8, "zāi"},
    { 0x6EA9, "wù"},
    { 0x6EAA, "xī,qī"},
    { 0x6EAB, "wēn"},
    { 0x6EAC, "qiāng"},
    { 0x6EAD, "zé"},
    { 0x6EAE, "shī"},
    { 0x6EAF, "sù,shuò"},
    { 0x6EB0, "ái"},
    { 0x6EB1, "qín,zhēn"},
    { 0x6EB2, "sōu,sǒu,shāo"},
    { 0x6EB3, "yún,yǔn"},
    { 0x6EB4, "xiù,chòu"},
    { 0x6EB5, "yīn"},
    { 0x6EB6, "róng"},
    { 0x6EB7, "hùn,hún"},
    { 0x6EB8, "sù"},
    { 0x6EB9, "suò,sè"},
    { 0x6EBA, "nì,ruò,niào"},
    { 0x6EBB, "tā"},
    { 0x6EBC, "shī"},
    { 0x6EBD, "rù,rú"},
    { 0x6EBE, "āi"},
    { 0x6EBF, "pàn"},
    { 0x6EC0, "chù,xù"},
    { 0x6EC1, "chú"},
    { 0x6EC2, "pāng,pēng"},
    { 0x6EC3, "wēng,wěng"},
    { 0x6EC4, "cāng"},
    { 0x6EC5, "miè"},
    { 0x6EC6, "gé"},
    { 0x6EC7, "diān,tián,zhēn"},
    { 0x6EC8, "hào,xuè"},
    { 0x6EC9, "huàng"},
    { 0x6ECA, "xì,xiē,qì"},
    { 0x6ECB, "zī,cí,xuán"},
    { 0x6ECC, "dí"},
    { 0x6ECD, "zhì"},
    { 0x6ECE, "xíng,yīng,yíng"},
    { 0x6ECF, "fǔ"},
    { 0x6ED0, "jié"},
    { 0x6ED1, "huá,gǔ"},
    { 0x6ED2, "gē"},
    { 0x6ED3, "zǐ"},
    { 0x6ED4, "tāo"},
    { 0x6ED5, "téng"},
    { 0x6ED6, "suī"},
    { 0x6ED7, "bì"},
    { 0x6ED8, "jiào"},
    { 0x6ED9, "huì"},
    { 0x6EDA, "gǔn"},
    { 0x6EDB, "yín"},
    { 0x6EDC, "gāo"},
    { 0x6EDD, "lóng"},
    { 0x6EDE, "zhì"},
    { 0x6EDF, "yàn"},
    { 0x6EE0, "shè"},
    { 0x6EE1, "mǎn"},
    { 0x6EE2, "yíng"},
    { 0x6EE3, "chún"},
    { 0x6EE4, "lǜ"},
    { 0x6EE5, "làn"},
    { 0x6EE6, "luán"},
    { 0x6EE7, "yáo"},
    { 0x6EE8, "bīn"},
    { 0x6EE9, "tān"},
    { 0x6EEA, "yù"},
    { 0x6EEB, "xiǔ"},
    { 0x6EEC, "hù"},
    { 0x6EED, "bì"},
    { 0x6EEE, "biāo"},
    { 0x6EEF, "zhì,chì"},
    { 0x6EF0, "jiàng"},
    { 0x6EF1, "kòu"},
    { 0x6EF2, "shèn,sēn,qīn,lín"},
    { 0x6EF3, "shāng"},
    { 0x6EF4, "dī"},
    { 0x6EF5, "mì"},
    { 0x6EF6, "áo"},
    { 0x6EF7, "lǔ"},
    { 0x6EF8, "hǔ,xǔ"},
    { 0x6EF9, "hū,hǔ"},
    { 0x6EFA, "yōu"},
    { 0x6EFB, "chǎn"},
    { 0x6EFC, "fàn"},
    { 0x6EFD, "yōng"},
    { 0x6EFE, "gǔn"},
    { 0x6EFF, "mǎn,mèn"},
    { 0x6F00, "qǐng,qīng"},
    { 0x6F01, "yú"},
    { 0x6F02, "piào,piāo,piǎo,biāo"},
    { 0x6F03, "jì"},
    { 0x6F04, "yá"},
    { 0x6F05, "cháo"},
    { 0x6F06, "qī,qiè"},
    { 0x6F07, "xǐ"},
    { 0x6F08, "jì"},
    { 0x6F09, "lù"},
    { 0x6F0A, "lóu,lǚ,lǒu"},
    { 0x6F0B, "lóng"},
    { 0x6F0C, "jǐn"},
    { 0x6F0D, "guó"},
    { 0x6F0E, "cóng,sǒng"},
    { 0x6F0F, "lòu,lóu"},
    { 0x6F10, "zhí"},
    { 0x6F11, "gài"},
    { 0x6F12, "qiáng"},
    { 0x6F13, "lí"},
    { 0x6F14, "yǎn,yàn"},
    { 0x6F15, "cáo,cào"},
    { 0x6F16, "jiào"},
    { 0x6F17, "cōng"},
    { 0x6F18, "chún"},
    { 0x6F19, "tuán,zhuān"},
    { 0x6F1A, "ōu,òu"},
    { 0x6F1B, "téng"},
    { 0x6F1C, "yě"},
    { 0x6F1D, "xí"},
    { 0x6F1E, "mì"},
    { 0x6F1F, "táng"},
    { 0x6F20, "mò"},
    { 0x6F21, "shāng,tàng"},
    { 0x6F22, "hàn,tān"},
    { 0x6F23, "lián,lán"},
    { 0x6F24, "lǎn"},
    { 0x6F25, "wā"},
    { 0x6F26, "chí,tāi"},
    { 0x6F27, "gān"},
    { 0x6F28, "féng,péng,běng"},
    { 0x6F29, "xuán"},
    { 0x6F2A, "yī"},
    { 0x6F2B, "màn"},
    { 0x6F2C, "zì,sè,qì"},
    { 0x6F2D, "mǎng"},
    { 0x6F2E, "kāng"},
    { 0x6F2F, "luò,tà,lěi"},
    { 0x6F30, "pēng"},
    { 0x6F31, "shù"},
    { 0x6F32, "zhǎng,zhàng,zhāng"},
    { 0x6F33, "zhāng"},
    { 0x6F34, "zhuàng,chuáng,chóng"},
    { 0x6F35, "xù"},
    { 0x6F36, "huàn"},
    { 0x6F37, "huǒ,kuò,huò"},
    { 0x6F38, "jiàn,jiān,qián,chán"},
    { 0x6F39, "yān"},
    { 0x6F3A, "shuǎng,chuǎng"},
    { 0x6F3B, "liáo,xiào,liú"},
    { 0x6F3C, "cuǐ,cuī"},
    { 0x6F3D, "tí"},
    { 0x6F3E, "yàng"},
    { 0x6F3F, "jiāng,jiàng"},
    { 0x6F40, "cóng"},
    { 0x6F41, "yǐng"},
    { 0x6F42, "hóng"},
    { 0x6F43, "xiǔ"},
    { 0x6F44, "shù"},
    { 0x6F45, "guàn"},
    { 0x6F46, "yíng"},
    { 0x6F47, "xiāo"},
    { 0x6F48, "zong"},
    { 0x6F49, "kūn"},
    { 0x6F4A, "xù"},
    { 0x6F4B, "liàn"},
    { 0x6F4C, "zhì"},
    { 0x6F4D, "wéi"},
    { 0x6F4E, "pì,piē,piào"},
    { 0x6F4F, "yù,jué,shù"},
    { 0x6F50, "jiào,jiǎo,qiáo"},
    { 0x6F51, "pō,bō"},
    { 0x6F52, "dàng,xiàng,yǎng"},
    { 0x6F53, "huì"},
    { 0x6F54, "jié"},
    { 0x6F55, "wǔ"},
    { 0x6F56, "pá"},
    { 0x6F57, "jí"},
    { 0x6F58, "pān,pàn,bō,pán,fān"},
    { 0x6F59, "wéi,guī"},
    { 0x6F5A, "sù,xiāo,sōu"},
    { 0x6F5B, "qián"},
    { 0x6F5C, "qián"},
    { 0x6F5D, "xī,yà"},
    { 0x6F5E, "lù"},
    { 0x6F5F, "xì"},
    { 0x6F60, "xùn,sùn"},
    { 0x6F61, "dùn"},
    { 0x6F62, "huáng,huàng,guāng"},
    { 0x6F63, "mǐn"},
    { 0x6F64, "rùn"},
    { 0x6F65, "sù"},
    { 0x6F66, "lǎo,lào,láo,liáo,liǎo"},
    { 0x6F67, "zhēn"},
    { 0x6F68, "cóng,zōng"},
    { 0x6F69, "yì"},
    { 0x6F6A, "zhè,zhì"},
    { 0x6F6B, "wān"},
    { 0x6F6C, "shàn,tān"},
    { 0x6F6D, "tán,xún,yǐn,dàn"},
    { 0x6F6E, "cháo"},
    { 0x6F6F, "xún,yín"},
    { 0x6F70, "kuì,xiè"},
    { 0x6F71, "yē"},
    { 0x6F72, "shào"},
    { 0x6F73, "tú,zhā"},
    { 0x6F74, "zhū"},
    { 0x6F75, "sǎ,sàn"},
    { 0x6F76, "hēi"},
    { 0x6F77, "bì"},
    { 0x6F78, "shān"},
    { 0x6F79, "chán"},
    { 0x6F7A, "chán"},
    { 0x6F7B, "shǔ"},
    { 0x6F7C, "tóng,chōng,zhōng"},
    { 0x6F7D, "pū,pǔ"},
    { 0x6F7E, "lín"},
    { 0x6F7F, "wéi"},
    { 0x6F80, "sè"},
    { 0x6F81, "sè"},
    { 0x6F82, "chéng"},
    { 0x6F83, "jiǒng"},
    { 0x6F84, "chéng,dèng"},
    { 0x6F85, "huà"},
    { 0x6F86, "jiāo,ào,nào"},
    { 0x6F87, "lào,láo"},
    { 0x6F88, "chè"},
    { 0x6F89, "gǎn,hàn"},
    { 0x6F8A, "cūn,cún"},
    { 0x6F8B, "hòng"},
    { 0x6F8C, "sī"},
    { 0x6F8D, "shù,zhù"},
    { 0x6F8E, "pēng,péng"},
    { 0x6F8F, "hán"},
    { 0x6F90, "yún"},
    { 0x6F91, "liù"},
    { 0x6F92, "hòng"},
    { 0x6F93, "fú"},
    { 0x6F94, "hào"},
    { 0x6F95, "hé"},
    { 0x6F96, "xián"},
    { 0x6F97, "jiàn"},
    { 0x6F98, "shān"},
    { 0x6F99, "xì"},
    { 0x6F9A, "yu"},
    { 0x6F9B, "lǔ"},
    { 0x6F9C, "lán"},
    { 0x6F9D, "nìng"},
    { 0x6F9E, "yú"},
    { 0x6F9F, "lǐn"},
    { 0x6FA0, "miǎn,shéng"},
    { 0x6FA1, "zǎo,cāo"},
    { 0x6FA2, "dāng"},
    { 0x6FA3, "huàn,hàn"},
    { 0x6FA4, "zé,shì,yì,duó"},
    { 0x6FA5, "xiè"},
    { 0x6FA6, "yù"},
    { 0x6FA7, "lǐ"},
    { 0x6FA8, "shì,cuó"},
    { 0x6FA9, "xué,xiào"},
    { 0x6FAA, "líng"},
    { 0x6FAB, "wàn,màn,ǒu"},
    { 0x6FAC, "zī,cí"},
    { 0x6FAD, "yōng,yǒng"},
    { 0x6FAE, "huì,kuài,huá"},
    { 0x6FAF, "càn"},
    { 0x6FB0, "liàn"},
    { 0x6FB1, "diàn"},
    { 0x6FB2, "yè"},
    { 0x6FB3, "ào,yù"},
    { 0x6FB4, "huán,xuàn"},
    { 0x6FB5, "zhēn"},
    { 0x6FB6, "chán,dàn,zhān"},
    { 0x6FB7, "màn"},
    { 0x6FB8, "dǎn"},
    { 0x6FB9, "dàn,dān,shàn,tán"},
    { 0x6FBA, "yì"},
    { 0x6FBB, "suì"},
    { 0x6FBC, "pì"},
    { 0x6FBD, "jù"},
    { 0x6FBE, "tà"},
    { 0x6FBF, "qín"},
    { 0x6FC0, "jī,jiào,jiāo"},
    { 0x6FC1, "zhuó"},
    { 0x6FC2, "lián,xiǎn"},
    { 0x6FC3, "nóng"},
    { 0x6FC4, "guō,wō"},
    { 0x6FC5, "jìn"},
    { 0x6FC6, "fén,pēn"},
    { 0x6FC7, "sè"},
    { 0x6FC8, "jí,shà"},
    { 0x6FC9, "suī"},
    { 0x6FCA, "huì,wèi,huò"},
    { 0x6FCB, "chǔ"},
    { 0x6FCC, "tà"},
    { 0x6FCD, "sōng"},
    { 0x6FCE, "dǐng,tìng"},
    { 0x6FCF, "sè"},
    { 0x6FD0, "zhǔ"},
    { 0x6FD1, "lài"},
    { 0x6FD2, "bīn"},
    { 0x6FD3, "lián"},
    { 0x6FD4, "mǐ,mí,nǐ"},
    { 0x6FD5, "shī,tà,xí"},
    { 0x6FD6, "shù"},
    { 0x6FD7, "mì"},
    { 0x6FD8, "nìng,níng,nì"},
    { 0x6FD9, "yíng"},
    { 0x6FDA, "yíng"},
    { 0x6FDB, "méng"},
    { 0x6FDC, "jìn,jīn"},
    { 0x6FDD, "qí"},
    { 0x6FDE, "bì,pì"},
    { 0x6FDF, "jì,jǐ,qí"},
    { 0x6FE0, "háo"},
    { 0x6FE1, "rú,ruǎn,ér,nuán,nuò"},
    { 0x6FE2, "cuì,zuǐ"},
    { 0x6FE3, "wò"},
    { 0x6FE4, "tāo,cháo,shòu,dào"},
    { 0x6FE5, "yǐn"},
    { 0x6FE6, "yǐn"},
    { 0x6FE7, "duì"},
    { 0x6FE8, "cí"},
    { 0x6FE9, "huò,hù"},
    { 0x6FEA, "qìng"},
    { 0x6FEB, "làn,jiàn,lǎn,lán"},
    { 0x6FEC, "jùn,xùn"},
    { 0x6FED, "ǎi,kài,kè"},
    { 0x6FEE, "pú"},
    { 0x6FEF, "zhuó,shuò,zhào"},
    { 0x6FF0, "wéi"},
    { 0x6FF1, "bīn"},
    { 0x6FF2, "gǔ"},
    { 0x6FF3, "qián"},
    { 0x6FF4, "yíng"},
    { 0x6FF5, "bīn"},
    { 0x6FF6, "kuò"},
    { 0x6FF7, "fèi"},
    { 0x6FF8, "cāng"},
    { 0x6FF9, "me"},
    { 0x6FFA, "jiàn,jiān,zàn"},
    { 0x6FFB, "wěi"},
    { 0x6FFC, "luò,pō,lì"},
    { 0x6FFD, "zàn"},
    { 0x6FFE, "lǜ"},
    { 0x6FFF, "lì"},
    { 0x7000, "yōu"},
    { 0x7001, "yàng,yǎng"},
    { 0x7002, "lǔ"},
    { 0x7003, "sì"},
    { 0x7004, "zhì"},
    { 0x7005, "yíng,yìng,jiōng"},
    { 0x7006, "dú,dòu"},
    { 0x7007, "wǎng,wāng"},
    { 0x7008, "huī"},
    { 0x7009, "xiè"},
    { 0x700A, "pán"},
    { 0x700B, "shěn,chèn,pán"},
    { 0x700C, "biāo"},
    { 0x700D, "chán"},
    { 0x700E, "mò,miè"},
    { 0x700F, "liú,liū"},
    { 0x7010, "jiān"},
    { 0x7011, "pù,bào,bó"},
    { 0x7012, "sè"},
    { 0x7013, "chéng"},
    { 0x7014, "gǔ"},
    { 0x7015, "bīn"},
    { 0x7016, "huò"},
    { 0x7017, "xiàn"},
    { 0x7018, "lú"},
    { 0x7019, "qìn"},
    { 0x701A, "hàn"},
    { 0x701B, "yíng"},
    { 0x701C, "róng"},
    { 0x701D, "lì"},
    { 0x701E, "jìng"},
    { 0x701F, "xiāo"},
    { 0x7020, "yíng"},
    { 0x7021, "suǐ"},
    { 0x7022, "wěi,duì"},
    { 0x7023, "xiè"},
    { 0x7024, "huái,wāi"},
    { 0x7025, "xuè"},
    { 0x7026, "zhū"},
    { 0x7027, "lóng,shuāng"},
    { 0x7028, "lài"},
    { 0x7029, "duì"},
    { 0x702A, "fán"},
    { 0x702B, "hú"},
    { 0x702C, "lài"},
    { 0x702D, "shū"},
    { 0x702E, "ling"},
    { 0x702F, "yíng"},
    { 0x7030, "mí,mǐ,nǐ"},
    { 0x7031, "jì"},
    { 0x7032, "liàn"},
    { 0x7033, "jiàn,zùn"},
    { 0x7034, "yíng,yǐng,yìng"},
    { 0x7035, "fèn"},
    { 0x7036, "lín"},
    { 0x7037, "yì"},
    { 0x7038, "jiān"},
    { 0x7039, "yuè,yào"},
    { 0x703A, "chán"},
    { 0x703B, "dài"},
    { 0x703C, "ráng,nǎng,ràng"},
    { 0x703D, "jiǎn"},
    { 0x703E, "lán"},
    { 0x703F, "fán"},
    { 0x7040, "shuàng"},
    { 0x7041, "yuān"},
    { 0x7042, "zhuó,zé,jiào"},
    { 0x7043, "fēng"},
    { 0x7044, "shè,nì"},
    { 0x7045, "lěi"},
    { 0x7046, "lán"},
    { 0x7047, "cóng"},
    { 0x7048, "qú"},
    { 0x7049, "yōng"},
    { 0x704A, "qián"},
    { 0x704B, "fǎ"},
    { 0x704C, "guàn,huàn"},
    { 0x704D, "jué"},
    { 0x704E, "yàn"},
    { 0x704F, "hào"},
    { 0x7050, "yíng"},
    { 0x7051, "sǎ,xiǎn,xǐ,lí,shī"},
    { 0x7052, "zàn,cuán,qián,zā"},
    { 0x7053, "luán,luàn"},
    { 0x7054, "yàn"},
    { 0x7055, "lí"},
    { 0x7056, "mǐ"},
    { 0x7057, "shàn"},
    { 0x7058, "tān,hàn,nàn"},
    { 0x7059, "dǎng"},
    { 0x705A, "jiǎo"},
    { 0x705B, "chǎn"},
    { 0x705C, "yíng"},
    { 0x705D, "hào"},
    { 0x705E, "bà"},
    { 0x705F, "zhú"},
    { 0x7060, "lǎn,làn"},
    { 0x7061, "lán"},
    { 0x7062, "nǎng"},
    { 0x7063, "wān"},
    { 0x7064, "luán"},
    { 0x7065, "xún,quán,quàn"},
    { 0x7066, "xiǎn"},
    { 0x7067, "yàn"},
    { 0x7068, "gàn"},
    { 0x7069, "yàn"},
    { 0x706A, "yù"},
    { 0x706B, "huǒ,huō"},
    { 0x706C, "biāo,huǒ"},
    { 0x706D, "miè"},
    { 0x706E, "guāng"},
    { 0x706F, "dēng,dīng"},
    { 0x7070, "huī"},
    { 0x7071, "xiāo"},
    { 0x7072, "xiāo"},
    { 0x7073, "huī"},
    { 0x7074, "hōng"},
    { 0x7075, "líng"},
    { 0x7076, "zào"},
    { 0x7077, "zhuàn"},
    { 0x7078, "jiǔ"},
    { 0x7079, "zhà,yù"},
    { 0x707A, "xiè"},
    { 0x707B, "chì"},
    { 0x707C, "zhuó"},
    { 0x707D, "zāi"},
    { 0x707E, "zāi"},
    { 0x707F, "càn"},
    { 0x7080, "yáng"},
    { 0x7081, "qì"},
    { 0x7082, "zhōng"},
    { 0x7083, "fén,bèn"},
    { 0x7084, "niǔ"},
    { 0x7085, "jiǒng,guì"},
    { 0x7086, "wén"},
    { 0x7087, "pū"},
    { 0x7088, "yì"},
    { 0x7089, "lú"},
    { 0x708A, "chuī"},
    { 0x708B, "pī"},
    { 0x708C, "kài"},
    { 0x708D, "pàn"},
    { 0x708E, "yán,yàn,tán"},
    { 0x708F, "kài,yán"},
    { 0x7090, "pàng,fēng"},
    { 0x7091, "mù"},
    { 0x7092, "chǎo"},
    { 0x7093, "liào"},
    { 0x7094, "guì,xuè,quē"},
    { 0x7095, "kàng,hāng"},
    { 0x7096, "dùn,tún"},
    { 0x7097, "guāng"},
    { 0x7098, "xīn"},
    { 0x7099, "zhì"},
    { 0x709A, "guāng"},
    { 0x709B, "guāng"},
    { 0x709C, "wěi"},
    { 0x709D, "qiàng"},
    { 0x709E, "bian"},
    { 0x709F, "dá"},
    { 0x70A0, "xiá"},
    { 0x70A1, "zhēng"},
    { 0x70A2, "zhú"},
    { 0x70A3, "kě"},
    { 0x70A4, "zhào,zhāo,zhǎo"},
    { 0x70A5, "fú"},
    { 0x70A6, "bá"},
    { 0x70A7, "xiè"},
    { 0x70A8, "xiè"},
    { 0x70A9, "lìng"},
    { 0x70AA, "zhuō,chù"},
    { 0x70AB, "xuàn"},
    { 0x70AC, "jù"},
    { 0x70AD, "tàn"},
    { 0x70AE, "pào,páo,bāo"},
    { 0x70AF, "jiǒng"},
    { 0x70B0, "páo,fǒu"},
    { 0x70B1, "tái"},
    { 0x70B2, "tái"},
    { 0x70B3, "bǐng"},
    { 0x70B4, "yǎng"},
    { 0x70B5, "tōng"},
    { 0x70B6, "shǎn"},
    { 0x70B7, "zhù"},
    { 0x70B8, "zhà,zhá"},
    { 0x70B9, "diǎn"},
    { 0x70BA, "wèi,wéi"},
    { 0x70BB, "shí"},
    { 0x70BC, "liàn"},
    { 0x70BD, "chì"},
    { 0x70BE, "huǎng"},
    { 0x70BF, "zhōu"},
    { 0x70C0, "hū"},
    { 0x70C1, "shuò"},
    { 0x70C2, "làn"},
    { 0x70C3, "tīng"},
    { 0x70C4, "jiǎo,yào"},
    { 0x70C5, "xù"},
    { 0x70C6, "héng"},
    { 0x70C7, "quǎn"},
    { 0x70C8, "liè"},
    { 0x70C9, "huàn"},
    { 0x70CA, "yáng,yàng"},
    { 0x70CB, "xiū,xiāo"},
    { 0x70CC, "xiū"},
    { 0x70CD, "xiǎn"},
    { 0x70CE, "yín"},
    { 0x70CF, "wū,yā,wù"},
    { 0x70D0, "zhōu"},
    { 0x70D1, "yáo"},
    { 0x70D2, "shì"},
    { 0x70D3, "wēi"},
    { 0x70D4, "tóng,dòng"},
    { 0x70D5, "miè"},
    { 0x70D6, "zāi"},
    { 0x70D7, "kài"},
    { 0x70D8, "hōng"},
    { 0x70D9, "lào,luò"},
    { 0x70DA, "xiá"},
    { 0x70DB, "zhú,chóng"},
    { 0x70DC, "xuǎn,xuān,huǐ"},
    { 0x70DD, "zhēng"},
    { 0x70DE, "pò"},
    { 0x70DF, "yān,yīn"},
    { 0x70E0, "huí,huǐ,ǎi"},
    { 0x70E1, "guāng"},
    { 0x70E2, "chè"},
    { 0x70E3, "huī"},
    { 0x70E4, "kǎo"},
    { 0x70E5, "jù"},
    { 0x70E6, "fán"},
    { 0x70E7, "shāo"},
    { 0x70E8, "yè"},
    { 0x70E9, "huì"},
    { 0x70EB, "tàng"},
    { 0x70EC, "jìn"},
    { 0x70ED, "rè"},
    { 0x70EE, "liè"},
    { 0x70EF, "xī"},
    { 0x70F0, "fú,fū"},
    { 0x70F1, "jiǒng"},
    { 0x70F2, "xiè,chè"},
    { 0x70F3, "pǔ"},
    { 0x70F4, "tīng,jǐng"},
    { 0x70F5, "zhuó"},
    { 0x70F6, "tǐng"},
    { 0x70F7, "wán"},
    { 0x70F8, "hǎi"},
    { 0x70F9, "pēng"},
    { 0x70FA, "lǎng"},
    { 0x70FB, "yàn,shān"},
    { 0x70FC, "xù"},
    { 0x70FD, "fēng"},
    { 0x70FE, "chì"},
    { 0x70FF, "róng"},
    { 0x7100, "hú"},
    { 0x7101, "xī"},
    { 0x7102, "shū"},
    { 0x7103, "hè,huò"},
    { 0x7104, "xūn,hūn"},
    { 0x7105, "kù,kào"},
    { 0x7106, "juān,yè,yuè,yuān"},
    { 0x7107, "xiāo"},
    { 0x7108, "xī"},
    { 0x7109, "yān,yí"},
    { 0x710A, "hàn"},
    { 0x710B, "zhuàng"},
    { 0x710C, "jùn,qū"},
    { 0x710D, "dì"},
    { 0x710E, "xiè"},
    { 0x710F, "jí,qì"},
    { 0x7110, "wù"},
    { 0x7111, "yān"},
    { 0x7112, "lǚ"},
    { 0x7113, "hán"},
    { 0x7114, "yàn"},
    { 0x7115, "huàn"},
    { 0x7116, "mèn"},
    { 0x7117, "jú"},
    { 0x7118, "dào,tāo"},
    { 0x7119, "bèi"},
    { 0x711A, "fén,fèn"},
    { 0x711B, "lìn"},
    { 0x711C, "kūn"},
    { 0x711D, "hùn"},
    { 0x711E, "tūn,tuī,jùn"},
    { 0x711F, "xī"},
    { 0x7120, "cuì"},
    { 0x7121, "wú,mó"},
    { 0x7122, "hōng"},
    { 0x7123, "chǎo,jù"},
    { 0x7124, "fǔ"},
    { 0x7125, "wò,ài"},
    { 0x7126, "jiāo,qiáo"},
    { 0x7127, "cōng"},
    { 0x7128, "fèng"},
    { 0x7129, "píng"},
    { 0x712A, "qióng"},
    { 0x712B, "ruò,rè"},
    { 0x712C, "xī,yì"},
    { 0x712D, "qióng"},
    { 0x712E, "xìn"},
    { 0x712F, "chāo,zhuō,zhuó,chuò"},
    { 0x7130, "yàn"},
    { 0x7131, "yàn,yì"},
    { 0x7132, "yì"},
    { 0x7133, "jué"},
    { 0x7134, "yù"},
    { 0x7135, "gàng"},
    { 0x7136, "rán"},
    { 0x7137, "pí"},
    { 0x7138, "xiòng,yīng,gǔ"},
    { 0x7139, "gàng"},
    { 0x713A, "shēng"},
    { 0x713B, "chàng,guā"},
    { 0x713C, "shāo"},
    { 0x713D, "xiǒng"},
    { 0x713E, "niǎn"},
    { 0x713F, "gēng"},
    { 0x7140, "wei"},
    { 0x7141, "chén"},
    { 0x7142, "hè"},
    { 0x7143, "kuǐ"},
    { 0x7144, "zhǒng"},
    { 0x7145, "duàn"},
    { 0x7146, "xiā,xià"},
    { 0x7147, "huī,hún,yùn,xūn,xuàn"},
    { 0x7148, "fèng"},
    { 0x7149, "liàn,làn"},
    { 0x714A, "xuān"},
    { 0x714B, "xīng"},
    { 0x714C, "huáng"},
    { 0x714D, "jiǎo"},
    { 0x714E, "jiān,jiàn,jiǎn"},
    { 0x714F, "bì"},
    { 0x7150, "yīng"},
    { 0x7151, "zhǔ"},
    { 0x7152, "wěi,huī"},
    { 0x7153, "tuān"},
    { 0x7154, "shǎn,qián,shān"},
    { 0x7155, "xī"},
    { 0x7156, "nuǎn,xuān"},
    { 0x7157, "nuǎn"},
    { 0x7158, "chán"},
    { 0x7159, "yān"},
    { 0x715A, "jiǒng"},
    { 0x715B, "jiǒng"},
    { 0x715C, "yù"},
    { 0x715D, "mèi"},
    { 0x715E, "shā,shà"},
    { 0x715F, "wèi"},
    { 0x7160, "zhá,yè"},
    { 0x7161, "jìn"},
    { 0x7162, "qióng"},
    { 0x7163, "róu,rǒu"},
    { 0x7164, "méi"},
    { 0x7165, "huàn"},
    { 0x7166, "xù,xiū"},
    { 0x7167, "zhào"},
    { 0x7168, "wēi,yù"},
    { 0x7169, "fán"},
    { 0x716A, "qiú"},
    { 0x716B, "suì"},
    { 0x716C, "yáng,yàng"},
    { 0x716D, "liè"},
    { 0x716E, "zhǔ"},
    { 0x716F, "jiē"},
    { 0x7170, "zào"},
    { 0x7171, "guā"},
    { 0x7172, "bāo"},
    { 0x7173, "hú"},
    { 0x7174, "yūn,yùn,wěn"},
    { 0x7175, "nǎn"},
    { 0x7176, "shì"},
    { 0x7177, "liang"},
    { 0x7178, "biān"},
    { 0x7179, "gòu"},
    { 0x717A, "tuì"},
    { 0x717B, "táng"},
    { 0x717C, "chǎo"},
    { 0x717D, "shān"},
    { 0x717E, "ēn,yūn"},
    { 0x717F, "bó"},
    { 0x7180, "huǎng,yè"},
    { 0x7181, "xié"},
    { 0x7182, "xì"},
    { 0x7183, "wù"},
    { 0x7184, "xī"},
    { 0x7185, "yùn"},
    { 0x7186, "hé"},
    { 0x7187, "hè,xiāo,kǎo,kào"},
    { 0x7188, "xī"},
    { 0x7189, "yún"},
    { 0x718A, "xióng"},
    { 0x718B, "nái"},
    { 0x718C, "shǎn"},
    { 0x718D, "qióng"},
    { 0x718E, "yào"},
    { 0x718F, "xūn,xùn"},
    { 0x7190, "mì"},
    { 0x7191, "lián,qiān"},
    { 0x7192, "yíng,xíng,jiǒng"},
    { 0x7193, "wǔ"},
    { 0x7194, "róng"},
    { 0x7195, "gōng"},
    { 0x7196, "yàn"},
    { 0x7197, "qiàng"},
    { 0x7198, "liū"},
    { 0x7199, "xī,yí"},
    { 0x719A, "bì"},
    { 0x719B, "biāo"},
    { 0x719C, "cōng,zǒng"},
    { 0x719D, "lù,āo"},
    { 0x719E, "jiān"},
    { 0x719F, "shú,shóu"},
    { 0x71A0, "yì"},
    { 0x71A1, "lóu"},
    { 0x71A2, "péng,bèng,fēng"},
    { 0x71A3, "suī,cuǐ"},
    { 0x71A4, "yì"},
    { 0x71A5, "tēng,tōng"},
    { 0x71A6, "jué"},
    { 0x71A7, "zōng"},
    { 0x71A8, "yùn,yù,wèi"},
    { 0x71A9, "hù"},
    { 0x71AA, "yí"},
    { 0x71AB, "zhì"},
    { 0x71AC, "áo,āo"},
    { 0x71AD, "wèi"},
    { 0x71AE, "liǔ"},
    { 0x71AF, "hàn,rǎn"},
    { 0x71B0, "ōu,òu"},
    { 0x71B1, "rè"},
    { 0x71B2, "jiǒng"},
    { 0x71B3, "màn"},
    { 0x71B4, "kūn"},
    { 0x71B5, "shāng"},
    { 0x71B6, "cuàn"},
    { 0x71B7, "zēng"},
    { 0x71B8, "jiān"},
    { 0x71B9, "xī"},
    { 0x71BA, "xī"},
    { 0x71BB, "xī"},
    { 0x71BC, "yì"},
    { 0x71BD, "xiào"},
    { 0x71BE, "chì"},
    { 0x71BF, "huáng,huǎng"},
    { 0x71C0, "chǎn,dǎn,chàn"},
    { 0x71C1, "yè"},
    { 0x71C2, "tán,xún,qián"},
    { 0x71C3, "rán"},
    { 0x71C4, "yàn"},
    { 0x71C5, "xún"},
    { 0x71C6, "qiāo,xiāo"},
    { 0x71C7, "jùn"},
    { 0x71C8, "dēng"},
    { 0x71C9, "dùn,tún,dūn"},
    { 0x71CA, "shēn"},
    { 0x71CB, "jiāo,qiáo,jué,zhuó"},
    { 0x71CC, "fén,bèn"},
    { 0x71CD, "sī,xī"},
    { 0x71CE, "liáo,liǎo,liào"},
    { 0x71CF, "yù"},
    { 0x71D0, "lín"},
    { 0x71D1, "tóng"},
    { 0x71D2, "shāo,shào"},
    { 0x71D3, "fén"},
    { 0x71D4, "fán,fén"},
    { 0x71D5, "yàn,yān"},
    { 0x71D6, "xún,qián"},
    { 0x71D7, "làn"},
    { 0x71D8, "měi"},
    { 0x71D9, "tàng,dàng"},
    { 0x71DA, "yì"},
    { 0x71DB, "jiǒng"},
    { 0x71DC, "mèn"},
    { 0x71DD, "jing"},
    { 0x71DE, "jiǎo"},
    { 0x71DF, "yíng,cuō"},
    { 0x71E0, "yù,ào"},
    { 0x71E1, "yì"},
    { 0x71E2, "xué"},
    { 0x71E3, "lán"},
    { 0x71E4, "tài,liè"},
    { 0x71E5, "zào,sào"},
    { 0x71E6, "càn"},
    { 0x71E7, "suì"},
    { 0x71E8, "xī"},
    { 0x71E9, "què"},
    { 0x71EA, "zǒng"},
    { 0x71EB, "lián"},
    { 0x71EC, "huǐ"},
    { 0x71ED, "zhú,kuò"},
    { 0x71EE, "xiè"},
    { 0x71EF, "líng"},
    { 0x71F0, "wēi"},
    { 0x71F1, "yì"},
    { 0x71F2, "xié"},
    { 0x71F3, "zhào"},
    { 0x71F4, "huì"},
    { 0x71F5, "dá"},
    { 0x71F6, "nóng"},
    { 0x71F7, "lán"},
    { 0x71F8, "rú,ruǎn"},
    { 0x71F9, "xiǎn,bìng"},
    { 0x71FA, "hè"},
    { 0x71FB, "xūn"},
    { 0x71FC, "jìn"},
    { 0x71FD, "chóu"},
    { 0x71FE, "dào,tāo"},
    { 0x71FF, "yào,shuò,shào"},
    { 0x7200, "hè"},
    { 0x7201, "làn"},
    { 0x7202, "biāo"},
    { 0x7203, "róng"},
    { 0x7204, "lì,liè"},
    { 0x7205, "mò"},
    { 0x7206, "bào,bó"},
    { 0x7207, "ruò"},
    { 0x7208, "lǜ"},
    { 0x7209, "là,liè"},
    { 0x720A, "āo"},
    { 0x720B, "xūn"},
    { 0x720C, "kuàng,huǎng,kuǎng"},
    { 0x720D, "shuò,luò,yuè"},
    { 0x720E, "liáo"},
    { 0x720F, "lì"},
    { 0x7210, "lú"},
    { 0x7211, "jué"},
    { 0x7212, "liǎo"},
    { 0x7213, "yàn,xún"},
    { 0x7214, "xī"},
    { 0x7215, "xiè"},
    { 0x7216, "lóng"},
    { 0x7217, "yè"},
    { 0x7218, "cān"},
    { 0x7219, "rǎng"},
    { 0x721A, "yuè"},
    { 0x721B, "làn"},
    { 0x721C, "cóng"},
    { 0x721D, "jué,jiào"},
    { 0x721E, "chóng,tóng"},
    { 0x721F, "guàn"},
    { 0x7220, "ju"},
    { 0x7221, "chè"},
    { 0x7222, "mí"},
    { 0x7223, "tǎng"},
    { 0x7224, "làn"},
    { 0x7225, "zhú"},
    { 0x7226, "lǎn"},
    { 0x7227, "líng"},
    { 0x7228, "cuàn"},
    { 0x7229, "yù"},
    { 0x722A, "zhǎo,zhuǎ"},
    { 0x722B, "zhǎo"},
    { 0x722C, "pá"},
    { 0x722D, "zhēng,zhèng"},
    { 0x722E, "páo"},
    { 0x722F, "chēng,chèng"},
    { 0x7230, "yuán"},
    { 0x7231, "ài"},
    { 0x7232, "wèi,wéi"},
    { 0x7233, "han"},
    { 0x7234, "jué"},
    { 0x7235, "jué"},
    { 0x7236, "fù,fǔ"},
    { 0x7237, "yé"},
    { 0x7238, "bà"},
    { 0x7239, "diē"},
    { 0x723A, "yé"},
    { 0x723B, "yáo,xiào"},
    { 0x723C, "zǔ"},
    { 0x723D, "shuǎng,shuāng"},
    { 0x723E, "ěr,mǐ,nǐ"},
    { 0x723F, "pán,qiáng"},
    { 0x7240, "chuáng"},
    { 0x7241, "kē"},
    { 0x7242, "zāng"},
    { 0x7243, "dié"},
    { 0x7244, "qiāng"},
    { 0x7245, "yōng"},
    { 0x7246, "qiáng"},
    { 0x7247, "piàn,piān,pàn"},
    { 0x7248, "bǎn"},
    { 0x7249, "pàn"},
    { 0x724A, "cháo"},
    { 0x724B, "jiān"},
    { 0x724C, "pái"},
    { 0x724D, "dú"},
    { 0x724E, "chuāng"},
    { 0x724F, "yú"},
    { 0x7250, "zhá"},
    { 0x7251, "biān,miàn"},
    { 0x7252, "dié"},
    { 0x7253, "bǎng,pāng"},
    { 0x7254, "bó"},
    { 0x7255, "chuāng"},
    { 0x7256, "yǒu"},
    { 0x7257, "yǒu"},
    { 0x7258, "dú"},
    { 0x7259, "yá,yà"},
    { 0x725A, "chēng,chèng"},
    { 0x725B, "niú"},
    { 0x725C, "niú"},
    { 0x725D, "pìn"},
    { 0x725E, "jiū,lè"},
    { 0x725F, "móu,mào,mù"},
    { 0x7260, "tā,tuó"},
    { 0x7261, "mǔ"},
    { 0x7262, "láo,lào,lóu"},
    { 0x7263, "rèn"},
    { 0x7264, "māng"},
    { 0x7265, "fāng"},
    { 0x7266, "máo"},
    { 0x7267, "mù"},
    { 0x7268, "gāng"},
    { 0x7269, "wù"},
    { 0x726A, "yàn"},
    { 0x726B, "gē,qiú,zāng"},
    { 0x726C, "bèi"},
    { 0x726D, "sì"},
    { 0x726E, "jiàn"},
    { 0x726F, "gǔ"},
    { 0x7270, "yòu,chōu"},
    { 0x7271, "gē"},
    { 0x7272, "shēng"},
    { 0x7273, "mǔ"},
    { 0x7274, "dǐ,dī,zhāi"},
    { 0x7275, "qiān"},
    { 0x7276, "quàn"},
    { 0x7277, "quán"},
    { 0x7278, "zì"},
    { 0x7279, "tè"},
    { 0x727A, "xī"},
    { 0x727B, "máng"},
    { 0x727C, "kēng"},
    { 0x727D, "qiān,qiàn"},
    { 0x727E, "wǔ,wú"},
    { 0x727F, "gù"},
    { 0x7280, "xī"},
    { 0x7281, "lí"},
    { 0x7282, "lí"},
    { 0x7283, "pǒu"},
    { 0x7284, "jī,yī"},
    { 0x7285, "gāng"},
    { 0x7286, "zhí,tè"},
    { 0x7287, "bēn"},
    { 0x7288, "quán"},
    { 0x7289, "chún"},
    { 0x728A, "dú"},
    { 0x728B, "jù"},
    { 0x728C, "jiā"},
    { 0x728D, "jiān,qián,jiǎn"},
    { 0x728E, "fēng"},
    { 0x728F, "piān"},
    { 0x7290, "kē"},
    { 0x7291, "jú"},
    { 0x7292, "kào"},
    { 0x7293, "chú"},
    { 0x7294, "xì"},
    { 0x7295, "bèi"},
    { 0x7296, "luò"},
    { 0x7297, "jiè"},
    { 0x7298, "má"},
    { 0x7299, "sān"},
    { 0x729A, "wèi"},
    { 0x729B, "máo,lí"},
    { 0x729C, "dūn"},
    { 0x729D, "tóng"},
    { 0x729E, "qiáo"},
    { 0x729F, "jiàng"},
    { 0x72A0, "xī"},
    { 0x72A1, "lì"},
    { 0x72A2, "dú"},
    { 0x72A3, "liè"},
    { 0x72A4, "pái"},
    { 0x72A5, "piāo,pào"},
    { 0x72A6, "bó"},
    { 0x72A7, "xī,suō"},
    { 0x72A8, "chōu"},
    { 0x72A9, "wéi"},
    { 0x72AA, "kuí,ráo"},
    { 0x72AB, "chōu"},
    { 0x72AC, "quǎn"},
    { 0x72AD, "quǎn"},
    { 0x72AE, "bá"},
    { 0x72AF, "fàn"},
    { 0x72B0, "qiú"},
    { 0x72B1, "jǐ"},
    { 0x72B2, "chái"},
    { 0x72B3, "zhuó"},
    { 0x72B4, "àn,án,jiàn,hān"},
    { 0x72B5, "gē,hé"},
    { 0x72B6, "zhuàng"},
    { 0x72B7, "guǎng"},
    { 0x72B8, "mà"},
    { 0x72B9, "yóu,yòu"},
    { 0x72BA, "kàng,gǎng"},
    { 0x72BB, "bó,pèi,fèi"},
    { 0x72BC, "hǒu"},
    { 0x72BD, "yà"},
    { 0x72BE, "yín"},
    { 0x72BF, "huān,fān"},
    { 0x72C0, "zhuàng"},
    { 0x72C1, "yǔn"},
    { 0x72C2, "kuáng,jué"},
    { 0x72C3, "niǔ,nǜ"},
    { 0x72C4, "dí,tì"},
    { 0x72C5, "kuáng"},
    { 0x72C6, "zhòng"},
    { 0x72C7, "mù"},
    { 0x72C8, "bèi"},
    { 0x72C9, "pī"},
    { 0x72CA, "jú"},
    { 0x72CB, "yí,quán,chí"},
    { 0x72CC, "shēng,xīng"},
    { 0x72CD, "páo"},
    { 0x72CE, "xiá"},
    { 0x72CF, "tuó,yí"},
    { 0x72D0, "hú"},
    { 0x72D1, "líng"},
    { 0x72D2, "fèi"},
    { 0x72D3, "pí,pī"},
    { 0x72D4, "nǐ"},
    { 0x72D5, "yǎo"},
    { 0x72D6, "yòu"},
    { 0x72D7, "gǒu"},
    { 0x72D8, "xuè"},
    { 0x72D9, "jū"},
    { 0x72DA, "dàn"},
    { 0x72DB, "bó"},
    { 0x72DC, "kǔ"},
    { 0x72DD, "xiǎn"},
    { 0x72DE, "níng"},
    { 0x72DF, "huán,xuān,héng"},
    { 0x72E0, "hěn,yán,kěn,hǎng"},
    { 0x72E1, "jiǎo,xiào"},
    { 0x72E2, "hé,mò"},
    { 0x72E3, "zhào"},
    { 0x72E4, "jí,jié,kuài"},
    { 0x72E5, "xùn"},
    { 0x72E6, "shān"},
    { 0x72E7, "tà,shì"},
    { 0x72E8, "róng"},
    { 0x72E9, "shòu"},
    { 0x72EA, "tóng,dòng"},
    { 0x72EB, "lǎo"},
    { 0x72EC, "dú"},
    { 0x72ED, "xiá"},
    { 0x72EE, "shī"},
    { 0x72EF, "kuài"},
    { 0x72F0, "zhēng"},
    { 0x72F1, "yù"},
    { 0x72F2, "sūn"},
    { 0x72F3, "yú"},
    { 0x72F4, "bì"},
    { 0x72F5, "máng,zhuó"},
    { 0x72F6, "xī,shǐ"},
    { 0x72F7, "juàn"},
    { 0x72F8, "lí"},
    { 0x72F9, "xiá"},
    { 0x72FA, "yín"},
    { 0x72FB, "suān,xùn,jùn"},
    { 0x72FC, "láng,lǎng,làng,hǎng"},
    { 0x72FD, "bèi"},
    { 0x72FE, "zhì"},
    { 0x72FF, "yán"},
    { 0x7300, "shā"},
    { 0x7301, "lì"},
    { 0x7302, "hàn"},
    { 0x7303, "xiǎn"},
    { 0x7304, "jīng"},
    { 0x7305, "pái"},
    { 0x7306, "fēi"},
    { 0x7307, "xiāo"},
    { 0x7308, "bài,pí"},
    { 0x7309, "qí"},
    { 0x730A, "ní"},
    { 0x730B, "biāo"},
    { 0x730C, "yìn"},
    { 0x730D, "lái"},
    { 0x730E, "liè,xī,què"},
    { 0x730F, "jiān"},
    { 0x7310, "qiāng"},
    { 0x7311, "kūn"},
    { 0x7312, "yàn"},
    { 0x7313, "guǒ,luǒ"},
    { 0x7314, "zòng"},
    { 0x7315, "mí"},
    { 0x7316, "chāng"},
    { 0x7317, "yī,yǐ,jì,ē,wēi"},
    { 0x7318, "zhì"},
    { 0x7319, "zhēng"},
    { 0x731A, "yá,wèi"},
    { 0x731B, "měng"},
    { 0x731C, "cāi"},
    { 0x731D, "cù"},
    { 0x731E, "shē"},
    { 0x731F, "liè"},
    { 0x7320, "diǎn"},
    { 0x7321, "luó"},
    { 0x7322, "hú"},
    { 0x7323, "zōng"},
    { 0x7324, "guì"},
    { 0x7325, "wěi,wèi"},
    { 0x7326, "fēng"},
    { 0x7327, "wō"},
    { 0x7328, "yuán"},
    { 0x7329, "xīng"},
    { 0x732A, "zhū"},
    { 0x732B, "māo,miáo,máo"},
    { 0x732C, "wèi"},
    { 0x732D, "chuān,chuàn,shān"},
    { 0x732E, "xiàn"},
    { 0x732F, "tuān"},
    { 0x7330, "yà,jiá,qiè"},
    { 0x7331, "náo"},
    { 0x7332, "xiē,hè,gé,hài"},
    { 0x7333, "jiā"},
    { 0x7334, "hóu"},
    { 0x7335, "biān,piàn"},
    { 0x7336, "yóu,yáo"},
    { 0x7337, "yóu"},
    { 0x7338, "méi"},
    { 0x7339, "chá"},
    { 0x733A, "yáo"},
    { 0x733B, "sūn"},
    { 0x733C, "bó,pò"},
    { 0x733D, "míng"},
    { 0x733E, "huá"},
    { 0x733F, "yuán"},
    { 0x7340, "sōu"},
    { 0x7341, "mà,mǎ"},
    { 0x7342, "yuán"},
    { 0x7343, "dāi,ái"},
    { 0x7344, "yù"},
    { 0x7345, "shī"},
    { 0x7346, "háo"},
    { 0x7347, "qiāng"},
    { 0x7348, "yì"},
    { 0x7349, "zhēn"},
    { 0x734A, "cāng"},
    { 0x734B, "háo,gāo"},
    { 0x734C, "màn"},
    { 0x734D, "jìng"},
    { 0x734E, "jiǎng"},
    { 0x734F, "mò,mú"},
    { 0x7350, "zhāng"},
    { 0x7351, "chán"},
    { 0x7352, "áo"},
    { 0x7353, "áo"},
    { 0x7354, "háo"},
    { 0x7355, "cuī"},
    { 0x7356, "bèn,fèn,fén"},
    { 0x7357, "jué"},
    { 0x7358, "bì"},
    { 0x7359, "bì"},
    { 0x735A, "huáng"},
    { 0x735B, "pú"},
    { 0x735C, "lín,lìn"},
    { 0x735D, "xù,yù"},
    { 0x735E, "tóng,zhuàng"},
    { 0x735F, "yào,xiāo"},
    { 0x7360, "liáo,lǎo"},
    { 0x7361, "shuò"},
    { 0x7362, "xiāo"},
    { 0x7363, "shòu"},
    { 0x7364, "dūn"},
    { 0x7365, "jiào"},
    { 0x7366, "gé,xiē,liè"},
    { 0x7367, "juàn"},
    { 0x7368, "dú"},
    { 0x7369, "huì"},
    { 0x736A, "kuài,huá"},
    { 0x736B, "xiǎn"},
    { 0x736C, "xiè,hǎ,jiě"},
    { 0x736D, "tǎ"},
    { 0x736E, "xiǎn,mí"},
    { 0x736F, "xūn"},
    { 0x7370, "níng"},
    { 0x7371, "biān"},
    { 0x7372, "huò"},
    { 0x7373, "nòu,rú"},
    { 0x7374, "měng,méng"},
    { 0x7375, "liè"},
    { 0x7376, "nǎo,yōu,náo"},
    { 0x7377, "guǎng,jǐng"},
    { 0x7378, "shòu"},
    { 0x7379, "lú"},
    { 0x737A, "tǎ"},
    { 0x737B, "xiàn,suō,xī"},
    { 0x737C, "mí"},
    { 0x737D, "ráng"},
    { 0x737E, "huān,quán"},
    { 0x737F, "nǎo,náo"},
    { 0x7380, "luó,ě"},
    { 0x7381, "xiǎn"},
    { 0x7382, "qí"},
    { 0x7383, "jué"},
    { 0x7384, "xuán,xuàn"},
    { 0x7385, "miào,yāo"},
    { 0x7386, "zī,xuán"},
    { 0x7387, "lǜ,shuài,lüè"},
    { 0x7388, "lú"},
    { 0x7389, "yù"},
    { 0x738A, "sù"},
    { 0x738B, "wáng,wàng,yù"},
    { 0x738C, "qiú"},
    { 0x738D, "gǎ"},
    { 0x738E, "dīng"},
    { 0x738F, "lè"},
    { 0x7390, "bā"},
    { 0x7391, "jī"},
    { 0x7392, "hóng"},
    { 0x7393, "dì"},
    { 0x7394, "chuàn"},
    { 0x7395, "gān"},
    { 0x7396, "jiǔ"},
    { 0x7397, "yú"},
    { 0x7398, "qǐ"},
    { 0x7399, "yú"},
    { 0x739A, "chàng,yáng"},
    { 0x739B, "mǎ"},
    { 0x739C, "hóng"},
    { 0x739D, "wǔ"},
    { 0x739E, "fū"},
    { 0x739F, "wén,mín"},
    { 0x73A0, "jiè"},
    { 0x73A1, "yá,yà"},
    { 0x73A2, "bīn,fēn"},
    { 0x73A3, "biàn"},
    { 0x73A4, "bàng"},
    { 0x73A5, "yuè"},
    { 0x73A6, "jué"},
    { 0x73A7, "mén,yǔn"},
    { 0x73A8, "jué"},
    { 0x73A9, "wán"},
    { 0x73AA, "jiān,yín,qián,lín"},
    { 0x73AB, "méi"},
    { 0x73AC, "dǎn"},
    { 0x73AD, "pín"},
    { 0x73AE, "wěi"},
    { 0x73AF, "huán"},
    { 0x73B0, "xiàn"},
    { 0x73B1, "qiāng"},
    { 0x73B2, "líng"},
    { 0x73B3, "dài"},
    { 0x73B4, "yì"},
    { 0x73B5, "án,gān"},
    { 0x73B6, "píng"},
    { 0x73B7, "diàn,diān"},
    { 0x73B8, "fú"},
    { 0x73B9, "xuán,xuàn,xián"},
    { 0x73BA, "xǐ"},
    { 0x73BB, "bō"},
    { 0x73BC, "cǐ,cī,cuō"},
    { 0x73BD, "gǒu"},
    { 0x73BE, "jiǎ"},
    { 0x73BF, "sháo"},
    { 0x73C0, "pò"},
    { 0x73C1, "cí"},
    { 0x73C2, "kē"},
    { 0x73C3, "rǎn"},
    { 0x73C4, "shēng"},
    { 0x73C5, "shēn"},
    { 0x73C6, "yí,tāi"},
    { 0x73C7, "zǔ,jù"},
    { 0x73C8, "jiā"},
    { 0x73C9, "mín"},
    { 0x73CA, "shān"},
    { 0x73CB, "liǔ"},
    { 0x73CC, "bì"},
    { 0x73CD, "zhēn"},
    { 0x73CE, "zhēn"},
    { 0x73CF, "jué"},
    { 0x73D0, "fà"},
    { 0x73D1, "lóng"},
    { 0x73D2, "jīn"},
    { 0x73D3, "jiào"},
    { 0x73D4, "jiàn"},
    { 0x73D5, "lì"},
    { 0x73D6, "guāng"},
    { 0x73D7, "xiān"},
    { 0x73D8, "zhōu"},
    { 0x73D9, "gǒng"},
    { 0x73DA, "yān"},
    { 0x73DB, "xiù"},
    { 0x73DC, "yáng"},
    { 0x73DD, "xǔ"},
    { 0x73DE, "luò,lì"},
    { 0x73DF, "sù"},
    { 0x73E0, "zhū"},
    { 0x73E1, "qín"},
    { 0x73E2, "yín,kèn"},
    { 0x73E3, "xún"},
    { 0x73E4, "bǎo"},
    { 0x73E5, "ěr"},
    { 0x73E6, "xiàng"},
    { 0x73E7, "yáo"},
    { 0x73E8, "xiá"},
    { 0x73E9, "háng,héng"},
    { 0x73EA, "guī"},
    { 0x73EB, "chōng"},
    { 0x73EC, "xù"},
    { 0x73ED, "bān"},
    { 0x73EE, "pèi"},
    { 0x73EF, "lǎo"},
    { 0x73F0, "dāng"},
    { 0x73F1, "yīng"},
    { 0x73F2, "huī,hún"},
    { 0x73F3, "wén"},
    { 0x73F4, "é"},
    { 0x73F5, "chéng,tǐng"},
    { 0x73F6, "dì,tí"},
    { 0x73F7, "wǔ,wù"},
    { 0x73F8, "wú"},
    { 0x73F9, "chéng"},
    { 0x73FA, "jùn"},
    { 0x73FB, "méi"},
    { 0x73FC, "bèi"},
    { 0x73FD, "tǐng"},
    { 0x73FE, "xiàn"},
    { 0x73FF, "chù"},
    { 0x7400, "hán"},
    { 0x7401, "xuán,qióng"},
    { 0x7402, "yán"},
    { 0x7403, "qiú"},
    { 0x7404, "xuàn"},
    { 0x7405, "láng,làng"},
    { 0x7406, "lǐ"},
    { 0x7407, "xiù"},
    { 0x7408, "fú,fū"},
    { 0x7409, "liú"},
    { 0x740A, "yá"},
    { 0x740B, "xī"},
    { 0x740C, "líng"},
    { 0x740D, "lí"},
    { 0x740E, "jìn"},
    { 0x740F, "liǎn"},
    { 0x7410, "suǒ"},
    { 0x7411, "suǒ"},
    { 0x7412, "fēng"},
    { 0x7413, "wán"},
    { 0x7414, "diàn"},
    { 0x7415, "pín,bǐng"},
    { 0x7416, "zhǎn"},
    { 0x7417, "sè,cuì"},
    { 0x7418, "mín"},
    { 0x7419, "yù"},
    { 0x741A, "jū"},
    { 0x741B, "chēn"},
    { 0x741C, "lái"},
    { 0x741D, "mín"},
    { 0x741E, "shèng,wàng"},
    { 0x741F, "wéi,yù"},
    { 0x7420, "tiǎn,tiàn"},
    { 0x7421, "chù"},
    { 0x7422, "zuó,zhuó"},
    { 0x7423, "běng,pěi"},
    { 0x7424, "chēng"},
    { 0x7425, "hǔ"},
    { 0x7426, "qí"},
    { 0x7427, "è"},
    { 0x7428, "kūn"},
    { 0x7429, "chāng"},
    { 0x742A, "qí"},
    { 0x742B, "běng"},
    { 0x742C, "wǎn"},
    { 0x742D, "lù"},
    { 0x742E, "cóng"},
    { 0x742F, "guǎn,gùn,guān,guàn"},
    { 0x7430, "yǎn"},
    { 0x7431, "diāo"},
    { 0x7432, "bèi"},
    { 0x7433, "lín"},
    { 0x7434, "qín"},
    { 0x7435, "pí"},
    { 0x7436, "pá"},
    { 0x7437, "què"},
    { 0x7438, "zhuó"},
    { 0x7439, "qín"},
    { 0x743A, "fà"},
    { 0x743B, "jīn"},
    { 0x743C, "qióng"},
    { 0x743D, "dǔ"},
    { 0x743E, "jiè"},
    { 0x743F, "hún,huī"},
    { 0x7440, "yǔ"},
    { 0x7441, "mào"},
    { 0x7442, "méi"},
    { 0x7443, "chūn"},
    { 0x7444, "xuān"},
    { 0x7445, "tí"},
    { 0x7446, "xīng"},
    { 0x7447, "dài"},
    { 0x7448, "róu"},
    { 0x7449, "mín"},
    { 0x744A, "jiān"},
    { 0x744B, "wěi"},
    { 0x744C, "ruǎn"},
    { 0x744D, "huàn"},
    { 0x744E, "xié"},
    { 0x744F, "chuān"},
    { 0x7450, "jiǎn"},
    { 0x7451, "zhuàn"},
    { 0x7452, "chàng,yáng,dàng"},
    { 0x7453, "liàn"},
    { 0x7454, "quán"},
    { 0x7455, "xiá"},
    { 0x7456, "duàn"},
    { 0x7457, "yuàn,huán"},
    { 0x7458, "yá"},
    { 0x7459, "nǎo"},
    { 0x745A, "hú"},
    { 0x745B, "yīng"},
    { 0x745C, "yú"},
    { 0x745D, "huáng"},
    { 0x745E, "ruì"},
    { 0x745F, "sè"},
    { 0x7460, "liú"},
    { 0x7461, "shī"},
    { 0x7462, "róng"},
    { 0x7463, "suǒ"},
    { 0x7464, "yáo"},
    { 0x7465, "wēn"},
    { 0x7466, "wǔ"},
    { 0x7467, "zhēn"},
    { 0x7468, "jìn"},
    { 0x7469, "yíng,yǐng"},
    { 0x746A, "mǎ"},
    { 0x746B, "tāo"},
    { 0x746C, "liú"},
    { 0x746D, "táng"},
    { 0x746E, "lì"},
    { 0x746F, "láng"},
    { 0x7470, "guī"},
    { 0x7471, "zhèn,tiàn"},
    { 0x7472, "qiāng,chēng,cāng"},
    { 0x7473, "cuō"},
    { 0x7474, "jué"},
    { 0x7475, "zhǎo"},
    { 0x7476, "yáo"},
    { 0x7477, "ài"},
    { 0x7478, "bīn"},
    { 0x7479, "shū,tū"},
    { 0x747A, "cháng"},
    { 0x747B, "kūn"},
    { 0x747C, "zhuān"},
    { 0x747D, "cōng"},
    { 0x747E, "jǐn,jìn"},
    { 0x747F, "yī"},
    { 0x7480, "cuǐ"},
    { 0x7481, "cōng"},
    { 0x7482, "qí"},
    { 0x7483, "lí"},
    { 0x7484, "jǐng"},
    { 0x7485, "suǒ,zǎo"},
    { 0x7486, "qiú"},
    { 0x7487, "xuán"},
    { 0x7488, "áo"},
    { 0x7489, "liǎn,lián"},
    { 0x748A, "mén"},
    { 0x748B, "zhāng"},
    { 0x748C, "yín"},
    { 0x748D, "yè"},
    { 0x748E, "yīng"},
    { 0x748F, "wèi,zhì"},
    { 0x7490, "lù"},
    { 0x7491, "wú"},
    { 0x7492, "dēng"},
    { 0x7493, "xiù"},
    { 0x7494, "zēng"},
    { 0x7495, "xún"},
    { 0x7496, "qú"},
    { 0x7497, "dàng"},
    { 0x7498, "lín"},
    { 0x7499, "liáo"},
    { 0x749A, "qióng,jué"},
    { 0x749B, "sù"},
    { 0x749C, "huáng"},
    { 0x749D, "guī"},
    { 0x749E, "pú"},
    { 0x749F, "jǐng"},
    { 0x74A0, "fán"},
    { 0x74A1, "jìn,jīn"},
    { 0x74A2, "liú"},
    { 0x74A3, "jī"},
    { 0x74A4, "huì"},
    { 0x74A5, "jǐng"},
    { 0x74A6, "ài"},
    { 0x74A7, "bì"},
    { 0x74A8, "càn"},
    { 0x74A9, "qú"},
    { 0x74AA, "zǎo"},
    { 0x74AB, "dāng"},
    { 0x74AC, "jiǎo"},
    { 0x74AD, "gùn"},
    { 0x74AE, "tǎn"},
    { 0x74AF, "huì,kuài"},
    { 0x74B0, "huán,huàn"},
    { 0x74B1, "sè"},
    { 0x74B2, "suì"},
    { 0x74B3, "tián"},
    { 0x74B4, "chǔ"},
    { 0x74B5, "yú"},
    { 0x74B6, "jìn"},
    { 0x74B7, "lú,fū"},
    { 0x74B8, "bīn,pián"},
    { 0x74B9, "shú"},
    { 0x74BA, "wèn"},
    { 0x74BB, "zuǐ"},
    { 0x74BC, "lán"},
    { 0x74BD, "xǐ"},
    { 0x74BE, "zī,jì"},
    { 0x74BF, "xuán"},
    { 0x74C0, "ruǎn"},
    { 0x74C1, "wò"},
    { 0x74C2, "gài"},
    { 0x74C3, "léi"},
    { 0x74C4, "dú"},
    { 0x74C5, "lì"},
    { 0x74C6, "zhì"},
    { 0x74C7, "róu"},
    { 0x74C8, "lí,li"},
    { 0x74C9, "zàn"},
    { 0x74CA, "qióng,xuán"},
    { 0x74CB, "tì"},
    { 0x74CC, "guī"},
    { 0x74CD, "suí"},
    { 0x74CE, "là"},
    { 0x74CF, "lóng"},
    { 0x74D0, "lú"},
    { 0x74D1, "lì"},
    { 0x74D2, "zàn"},
    { 0x74D3, "làn"},
    { 0x74D4, "yīng"},
    { 0x74D5, "mí,xǐ"},
    { 0x74D6, "xiāng"},
    { 0x74D7, "qióng,wěi,wèi"},
    { 0x74D8, "guàn"},
    { 0x74D9, "dào"},
    { 0x74DA, "zàn"},
    { 0x74DB, "huán,yè,yǎn"},
    { 0x74DC, "guā"},
    { 0x74DD, "bó"},
    { 0x74DE, "dié"},
    { 0x74DF, "bó,páo"},
    { 0x74E0, "hù,hú,huò,gū"},
    { 0x74E1, "zhí,hú"},
    { 0x74E2, "piáo"},
    { 0x74E3, "bàn"},
    { 0x74E4, "ráng"},
    { 0x74E5, "lì"},
    { 0x74E6, "wǎ,wà"},
    { 0x74E8, "xiáng,hóng"},
    { 0x74E9, "qiān,wǎ"},
    { 0x74EA, "bǎn"},
    { 0x74EB, "pén"},
    { 0x74EC, "fǎng"},
    { 0x74ED, "dǎn,dān"},
    { 0x74EE, "wèng"},
    { 0x74EF, "ōu"},
    { 0x74F2, "wa"},
    { 0x74F3, "hú"},
    { 0x74F4, "líng"},
    { 0x74F5, "yí"},
    { 0x74F6, "píng"},
    { 0x74F7, "cí"},
    { 0x74F8, "bǎi"},
    { 0x74F9, "juān,juàn"},
    { 0x74FA, "cháng"},
    { 0x74FB, "chī"},
    { 0x74FD, "dàng"},
    { 0x74FE, "měng"},
    { 0x74FF, "bù,pǒu"},
    { 0x7500, "zhuì"},
    { 0x7501, "píng"},
    { 0x7502, "biān"},
    { 0x7503, "zhòu"},
    { 0x7504, "zhēn,zhèn,juàn"},
    { 0x7506, "cí"},
    { 0x7507, "yīng"},
    { 0x7508, "qì"},
    { 0x7509, "xián"},
    { 0x750A, "lǒu"},
    { 0x750B, "dì"},
    { 0x750C, "ōu,ǒu"},
    { 0x750D, "méng"},
    { 0x750E, "zhuān,chuán"},
    { 0x750F, "bèng"},
    { 0x7510, "lìn"},
    { 0x7511, "zèng"},
    { 0x7512, "wǔ"},
    { 0x7513, "pì"},
    { 0x7514, "dān,dàn"},
    { 0x7515, "wèng"},
    { 0x7516, "yīng"},
    { 0x7517, "yǎn"},
    { 0x7518, "gān,hān"},
    { 0x7519, "dài"},
    { 0x751A, "shén,shèn"},
    { 0x751B, "tián"},
    { 0x751C, "tián"},
    { 0x751D, "hán"},
    { 0x751E, "cháng"},
    { 0x751F, "shēng"},
    { 0x7520, "qíng"},
    { 0x7521, "shēn"},
    { 0x7522, "chǎn"},
    { 0x7523, "chǎn"},
    { 0x7524, "ruí"},
    { 0x7525, "shēng"},
    { 0x7526, "sū"},
    { 0x7527, "shēn"},
    { 0x7528, "yòng"},
    { 0x7529, "shuǎi"},
    { 0x752A, "lù"},
    { 0x752B, "fǔ,fū,pǔ"},
    { 0x752C, "yǒng,dòng"},
    { 0x752D, "béng,qì"},
    { 0x752E, "fèng"},
    { 0x752F, "níng,nìng"},
    { 0x7530, "tián"},
    { 0x7531, "yóu,yāo"},
    { 0x7532, "jiǎ"},
    { 0x7533, "shēn"},
    { 0x7534, "zhá,yóu"},
    { 0x7535, "diàn"},
    { 0x7536, "fú"},
    { 0x7537, "nán"},
    { 0x7538, "diān,diàn,tián,shèng,yìng"},
    { 0x7539, "pīng"},
    { 0x753A, "tīng,tǐng,zhèng,tiǎn,dīng"},
    { 0x753B, "huà"},
    { 0x753C, "tǐng"},
    { 0x753D, "zhèn,quǎn,zhùn"},
    { 0x753E, "zāi,zī"},
    { 0x753F, "méng,máng"},
    { 0x7540, "bì"},
    { 0x7541, "bì"},
    { 0x7542, "liù"},
    { 0x7543, "xún"},
    { 0x7544, "liú"},
    { 0x7545, "chàng"},
    { 0x7546, "mǔ"},
    { 0x7547, "yún,tián"},
    { 0x7548, "fàn"},
    { 0x7549, "fú"},
    { 0x754A, "gēng"},
    { 0x754B, "tián"},
    { 0x754C, "jiè"},
    { 0x754D, "jiè"},
    { 0x754E, "quǎn"},
    { 0x754F, "wèi,wēi,wěi"},
    { 0x7550, "fú,bì"},
    { 0x7551, "tián"},
    { 0x7552, "mǔ"},
    { 0x7553, "duō"},
    { 0x7554, "pàn"},
    { 0x7555, "jiāng"},
    { 0x7556, "wā"},
    { 0x7557, "dá,fú"},
    { 0x7558, "nán"},
    { 0x7559, "liú,liù,liǔ"},
    { 0x755A, "běn"},
    { 0x755B, "zhěn"},
    { 0x755C, "chù,xù"},
    { 0x755D, "mǔ,mǒu"},
    { 0x755E, "mǔ"},
    { 0x755F, "cè,jì"},
    { 0x7560, "tián"},
    { 0x7561, "gāi"},
    { 0x7562, "bì"},
    { 0x7563, "dá"},
    { 0x7564, "zhì,chóu,shì"},
    { 0x7565, "lüè"},
    { 0x7566, "qí"},
    { 0x7567, "lüè"},
    { 0x7568, "pān,fān"},
    { 0x7569, "yī"},
    { 0x756A, "fān,fán,bō,pó,pān,pán,pàn,pí"},
    { 0x756B, "huà"},
    { 0x756C, "shē,yú"},
    { 0x756D, "yú"},
    { 0x756E, "mǔ"},
    { 0x756F, "jùn"},
    { 0x7570, "yì"},
    { 0x7571, "liú"},
    { 0x7572, "shē"},
    { 0x7573, "dié"},
    { 0x7574, "chóu"},
    { 0x7575, "huà"},
    { 0x7576, "dāng,dàng,dang"},
    { 0x7577, "zhuì"},
    { 0x7578, "jī,qí"},
    { 0x7579, "wǎn,yuǎn"},
    { 0x757A, "jiāng,jiàng"},
    { 0x757B, "chéng"},
    { 0x757C, "chàng"},
    { 0x757D, "tǔn,tuǎn"},
    { 0x757E, "léi"},
    { 0x757F, "jī"},
    { 0x7580, "chā"},
    { 0x7581, "liú"},
    { 0x7582, "dié"},
    { 0x7583, "tuǎn"},
    { 0x7584, "lìn,lín"},
    { 0x7585, "jiāng"},
    { 0x7586, "jiāng,jiàng"},
    { 0x7587, "chóu"},
    { 0x7588, "pì"},
    { 0x7589, "dié"},
    { 0x758A, "dié"},
    { 0x758B, "pǐ,shū,yǎ"},
    { 0x758C, "jié,qiè"},
    { 0x758D, "dàn"},
    { 0x758E, "shū"},
    { 0x758F, "shū"},
    { 0x7590, "zhì,dì"},
    { 0x7591, "yí,níng"},
    { 0x7592, "nè"},
    { 0x7593, "nǎi"},
    { 0x7594, "dīng,nè"},
    { 0x7595, "bǐ"},
    { 0x7596, "jiē"},
    { 0x7597, "liáo"},
    { 0x7598, "gāng,gōng"},
    { 0x7599, "gē,yì"},
    { 0x759A, "jiù"},
    { 0x759B, "zhǒu"},
    { 0x759C, "xià"},
    { 0x759D, "shàn"},
    { 0x759E, "xū"},
    { 0x759F, "nüè,yào"},
    { 0x75A0, "lì"},
    { 0x75A1, "yáng"},
    { 0x75A2, "chèn"},
    { 0x75A3, "yóu,yòu"},
    { 0x75A4, "bā"},
    { 0x75A5, "jiè"},
    { 0x75A6, "jué,xuè"},
    { 0x75A7, "qí"},
    { 0x75A8, "xiā,yá"},
    { 0x75A9, "cuì"},
    { 0x75AA, "bì"},
    { 0x75AB, "yì"},
    { 0x75AC, "lì"},
    { 0x75AD, "zòng"},
    { 0x75AE, "chuāng"},
    { 0x75AF, "fēng"},
    { 0x75B0, "zhù"},
    { 0x75B1, "pào"},
    { 0x75B2, "pí"},
    { 0x75B3, "gān"},
    { 0x75B4, "kē,ē,qià"},
    { 0x75B5, "cī,zī,zhài,jì"},
    { 0x75B6, "xuē"},
    { 0x75B7, "zhī"},
    { 0x75B8, "dǎn,da"},
    { 0x75B9, "zhěn,chèn"},
    { 0x75BA, "fá,biǎn"},
    { 0x75BB, "zhǐ"},
    { 0x75BC, "téng"},
    { 0x75BD, "jū,jǔ"},
    { 0x75BE, "jí"},
    { 0x75BF, "fèi"},
    { 0x75C0, "jū,gōu"},
    { 0x75C1, "shān"},
    { 0x75C2, "jiā"},
    { 0x75C3, "xuán"},
    { 0x75C4, "zhà"},
    { 0x75C5, "bìng"},
    { 0x75C6, "niè,nì,niǎn"},
    { 0x75C7, "zhèng,zhēng"},
    { 0x75C8, "yōng"},
    { 0x75C9, "jìng"},
    { 0x75CA, "quán"},
    { 0x75CB, "téng,chóng"},
    { 0x75CC, "tōng,tóng"},
    { 0x75CD, "yí"},
    { 0x75CE, "jiē"},
    { 0x75CF, "wěi,yòu,yù"},
    { 0x75D0, "huí"},
    { 0x75D1, "tān,shǐ"},
    { 0x75D2, "yǎng,yáng"},
    { 0x75D3, "chì"},
    { 0x75D4, "zhì"},
    { 0x75D5, "hén,gèn"},
    { 0x75D6, "yǎ"},
    { 0x75D7, "mèi"},
    { 0x75D8, "dòu"},
    { 0x75D9, "jìng"},
    { 0x75DA, "xiāo"},
    { 0x75DB, "tòng"},
    { 0x75DC, "tū"},
    { 0x75DD, "máng"},
    { 0x75DE, "pǐ"},
    { 0x75DF, "xiāo"},
    { 0x75E0, "suān"},
    { 0x75E1, "fū,pū,pù"},
    { 0x75E2, "lì"},
    { 0x75E3, "zhì"},
    { 0x75E4, "cuó"},
    { 0x75E5, "duó"},
    { 0x75E6, "wù,pī"},
    { 0x75E7, "shā"},
    { 0x75E8, "láo"},
    { 0x75E9, "shòu"},
    { 0x75EA, "huàn,tuǎn"},
    { 0x75EB, "xián"},
    { 0x75EC, "yì"},
    { 0x75ED, "bēng,péng,bìng"},
    { 0x75EE, "zhàng"},
    { 0x75EF, "guǎn"},
    { 0x75F0, "tán"},
    { 0x75F1, "fèi,féi,fěi"},
    { 0x75F2, "má"},
    { 0x75F3, "lín,lìn"},
    { 0x75F4, "chī"},
    { 0x75F5, "jì"},
    { 0x75F6, "tiǎn,diǎn"},
    { 0x75F7, "ān,yè,è"},
    { 0x75F8, "chì"},
    { 0x75F9, "bì"},
    { 0x75FA, "bì"},
    { 0x75FB, "mín"},
    { 0x75FC, "gù"},
    { 0x75FD, "duī"},
    { 0x75FE, "ē,kē"},
    { 0x75FF, "wěi"},
    { 0x7600, "yū"},
    { 0x7601, "cuì"},
    { 0x7602, "yǎ"},
    { 0x7603, "zhú"},
    { 0x7604, "cù"}
};
