/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     chenhaifeng  <chenhaifeng@uniontech.com>
*
* Maintainer: chenhaifeng  <chenhaifeng@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "pinyindict.h"

QMap<int, QString> PinyinDict_9{
    { 0x7605, "dān,dàn"},
    { 0x7606, "shèn"},
    { 0x7607, "zhǒng"},
    { 0x7608, "chì,zhì"},
    { 0x7609, "yù"},
    { 0x760A, "hóu"},
    { 0x760B, "fēng"},
    { 0x760C, "là"},
    { 0x760D, "yáng,dàng"},
    { 0x760E, "chén"},
    { 0x760F, "tú"},
    { 0x7610, "yǔ,yù"},
    { 0x7611, "guō"},
    { 0x7612, "wén"},
    { 0x7613, "huàn"},
    { 0x7614, "kù"},
    { 0x7615, "jiǎ,xiā"},
    { 0x7616, "yīn,yìn"},
    { 0x7617, "yì"},
    { 0x7618, "lòu"},
    { 0x7619, "sào"},
    { 0x761A, "jué"},
    { 0x761B, "chì"},
    { 0x761C, "xī"},
    { 0x761D, "guān"},
    { 0x761E, "yì"},
    { 0x761F, "wēn,wò,yūn"},
    { 0x7620, "jí"},
    { 0x7621, "chuāng"},
    { 0x7622, "bān"},
    { 0x7623, "huì,lěi"},
    { 0x7624, "liú"},
    { 0x7625, "chài,cuó"},
    { 0x7626, "shòu"},
    { 0x7627, "nüè,yào"},
    { 0x7628, "diān,chēn"},
    { 0x7629, "da,dá"},
    { 0x762A, "biě,biē"},
    { 0x762B, "tān"},
    { 0x762C, "zhàng"},
    { 0x762D, "biāo"},
    { 0x762E, "shèn"},
    { 0x762F, "cù"},
    { 0x7630, "luǒ"},
    { 0x7631, "yì"},
    { 0x7632, "zòng"},
    { 0x7633, "chōu,lù"},
    { 0x7634, "zhàng"},
    { 0x7635, "zhài,jì"},
    { 0x7636, "sòu"},
    { 0x7637, "sè"},
    { 0x7638, "qué"},
    { 0x7639, "diào"},
    { 0x763A, "lòu"},
    { 0x763B, "lòu,lǘ"},
    { 0x763C, "mò"},
    { 0x763D, "qín"},
    { 0x763E, "yǐn"},
    { 0x763F, "yǐng"},
    { 0x7640, "huáng"},
    { 0x7641, "fú"},
    { 0x7642, "liáo,liào,shuò"},
    { 0x7643, "lóng"},
    { 0x7644, "qiáo"},
    { 0x7645, "liú"},
    { 0x7646, "láo,lào"},
    { 0x7647, "xián"},
    { 0x7648, "fèi"},
    { 0x7649, "dān,dàn,dǎn,tán"},
    { 0x764A, "yìn"},
    { 0x764B, "hè"},
    { 0x764C, "ái,yán"},
    { 0x764D, "bān"},
    { 0x764E, "xián"},
    { 0x764F, "guān"},
    { 0x7650, "guì,wēi"},
    { 0x7651, "nòng,nóng"},
    { 0x7652, "yù"},
    { 0x7653, "wéi"},
    { 0x7654, "yì"},
    { 0x7655, "yōng"},
    { 0x7656, "pǐ"},
    { 0x7657, "lěi"},
    { 0x7658, "lì,lài"},
    { 0x7659, "shǔ"},
    { 0x765A, "dàn"},
    { 0x765B, "lǐn,bǐng"},
    { 0x765C, "diàn"},
    { 0x765D, "lǐn"},
    { 0x765E, "lài"},
    { 0x765F, "biě,bié,biē"},
    { 0x7660, "jì"},
    { 0x7661, "chī"},
    { 0x7662, "yǎng"},
    { 0x7663, "xuǎn"},
    { 0x7664, "jiē"},
    { 0x7665, "zhēng"},
    { 0x7666, "me"},
    { 0x7667, "lì"},
    { 0x7668, "huò"},
    { 0x7669, "lài,là"},
    { 0x766A, "jī"},
    { 0x766B, "diān"},
    { 0x766C, "xuǎn"},
    { 0x766D, "yǐng"},
    { 0x766E, "yǐn"},
    { 0x766F, "qú"},
    { 0x7670, "yōng"},
    { 0x7671, "tān"},
    { 0x7672, "diān"},
    { 0x7673, "luǒ"},
    { 0x7674, "luán"},
    { 0x7675, "luán"},
    { 0x7676, "bō"},
    { 0x7677, "bō"},
    { 0x7678, "guǐ"},
    { 0x7679, "bá"},
    { 0x767A, "fā"},
    { 0x767B, "dēng,dé"},
    { 0x767C, "fā,bō"},
    { 0x767D, "bái,bó"},
    { 0x767E, "bǎi,bó,mò"},
    { 0x767F, "qié"},
    { 0x7680, "jí,xiāng,bī"},
    { 0x7681, "zào"},
    { 0x7682, "zào"},
    { 0x7683, "mào"},
    { 0x7684, "de,dì,dí"},
    { 0x7685, "pā,bà"},
    { 0x7686, "jiē"},
    { 0x7687, "huáng,wǎng"},
    { 0x7688, "guī"},
    { 0x7689, "cǐ"},
    { 0x768A, "líng"},
    { 0x768B, "gāo,háo,gū"},
    { 0x768C, "mò"},
    { 0x768D, "jí"},
    { 0x768E, "jiǎo"},
    { 0x768F, "pěng"},
    { 0x7690, "gāo"},
    { 0x7691, "ái"},
    { 0x7692, "é"},
    { 0x7693, "hào,huī"},
    { 0x7694, "hàn"},
    { 0x7695, "bì"},
    { 0x7696, "wǎn,huàn"},
    { 0x7697, "chóu"},
    { 0x7698, "qiàn"},
    { 0x7699, "xī"},
    { 0x769A, "ái"},
    { 0x769B, "xiǎo,jiǎo,pò"},
    { 0x769C, "hào"},
    { 0x769D, "huàng"},
    { 0x769E, "hào"},
    { 0x769F, "zé"},
    { 0x76A0, "cuǐ"},
    { 0x76A1, "hào"},
    { 0x76A2, "xiǎo"},
    { 0x76A3, "yè"},
    { 0x76A4, "pó,pán"},
    { 0x76A5, "hào"},
    { 0x76A6, "jiǎo"},
    { 0x76A7, "ài"},
    { 0x76A8, "xīng"},
    { 0x76A9, "huàng"},
    { 0x76AA, "lì,luò,bō"},
    { 0x76AB, "piǎo"},
    { 0x76AC, "hé"},
    { 0x76AD, "jiào"},
    { 0x76AE, "pí"},
    { 0x76AF, "gǎn"},
    { 0x76B0, "pào"},
    { 0x76B1, "zhòu"},
    { 0x76B2, "jūn"},
    { 0x76B3, "qiú"},
    { 0x76B4, "cūn"},
    { 0x76B5, "què"},
    { 0x76B6, "zhā"},
    { 0x76B7, "gǔ"},
    { 0x76B8, "jūn"},
    { 0x76B9, "jūn"},
    { 0x76BA, "zhòu,zhōu"},
    { 0x76BB, "zhā,cǔ"},
    { 0x76BC, "gǔ"},
    { 0x76BD, "zhāo,zhǎn,dǎn"},
    { 0x76BE, "dú"},
    { 0x76BF, "mǐn,mǐng"},
    { 0x76C0, "qǐ"},
    { 0x76C1, "yíng"},
    { 0x76C2, "yú"},
    { 0x76C3, "bēi"},
    { 0x76C4, "zhāo"},
    { 0x76C5, "zhōng,chōng"},
    { 0x76C6, "pén"},
    { 0x76C7, "hé"},
    { 0x76C8, "yíng"},
    { 0x76C9, "hé"},
    { 0x76CA, "yì"},
    { 0x76CB, "bō"},
    { 0x76CC, "wǎn"},
    { 0x76CD, "hé,kě"},
    { 0x76CE, "àng"},
    { 0x76CF, "zhǎn"},
    { 0x76D0, "yán"},
    { 0x76D1, "jiān,jiàn"},
    { 0x76D2, "hé,ān"},
    { 0x76D3, "yū,wū"},
    { 0x76D4, "kuī"},
    { 0x76D5, "fàn"},
    { 0x76D6, "gài,gě"},
    { 0x76D7, "dào"},
    { 0x76D8, "pán"},
    { 0x76D9, "fǔ"},
    { 0x76DA, "qiú"},
    { 0x76DB, "shèng,chéng"},
    { 0x76DC, "dào"},
    { 0x76DD, "lù"},
    { 0x76DE, "zhǎn"},
    { 0x76DF, "méng,mèng,míng"},
    { 0x76E0, "lí"},
    { 0x76E1, "jǐn,jìn"},
    { 0x76E2, "xù"},
    { 0x76E3, "jiān,jiàn,kàn"},
    { 0x76E4, "pán,xuán"},
    { 0x76E5, "guàn"},
    { 0x76E6, "ān"},
    { 0x76E7, "lú,lǘ,léi"},
    { 0x76E8, "xǔ"},
    { 0x76E9, "zhōu,chóu"},
    { 0x76EA, "dàng"},
    { 0x76EB, "ān"},
    { 0x76EC, "gǔ,gù,gū"},
    { 0x76ED, "lì"},
    { 0x76EE, "mù"},
    { 0x76EF, "dīng,chéng"},
    { 0x76F0, "gàn"},
    { 0x76F1, "xū"},
    { 0x76F2, "máng"},
    { 0x76F3, "wàng,máng"},
    { 0x76F4, "zhí"},
    { 0x76F5, "qì"},
    { 0x76F6, "yuǎn"},
    { 0x76F7, "tián,xián,mín"},
    { 0x76F8, "xiāng,xiàng"},
    { 0x76F9, "dǔn,zhūn"},
    { 0x76FA, "xīn"},
    { 0x76FB, "xì,pǎn"},
    { 0x76FC, "pàn,fén"},
    { 0x76FD, "fēng"},
    { 0x76FE, "dùn,shǔn,yǔn"},
    { 0x76FF, "mín"},
    { 0x7700, "míng"},
    { 0x7701, "shěng,xǐng,xiǎn"},
    { 0x7702, "shì"},
    { 0x7703, "yún,hùn"},
    { 0x7704, "miǎn,miàn"},
    { 0x7705, "pān"},
    { 0x7706, "fǎng"},
    { 0x7707, "miǎo,miào"},
    { 0x7708, "dān,chěn"},
    { 0x7709, "méi"},
    { 0x770A, "mào,mèi"},
    { 0x770B, "kàn,kān"},
    { 0x770C, "xiàn"},
    { 0x770D, "kōu"},
    { 0x770E, "shì"},
    { 0x770F, "yāng,yǎng,yìng"},
    { 0x7710, "zhēng"},
    { 0x7711, "yǎo,āo,ǎo"},
    { 0x7712, "shēn"},
    { 0x7713, "huò"},
    { 0x7714, "dà"},
    { 0x7715, "zhěn"},
    { 0x7716, "kuàng"},
    { 0x7717, "jū,xū,kōu"},
    { 0x7718, "shèn"},
    { 0x7719, "yí,chì"},
    { 0x771A, "shěng"},
    { 0x771B, "mèi"},
    { 0x771C, "mò,miè"},
    { 0x771D, "zhù"},
    { 0x771E, "zhēn"},
    { 0x771F, "zhēn"},
    { 0x7720, "mián,miǎn,mǐn"},
    { 0x7721, "shì"},
    { 0x7722, "yuān"},
    { 0x7723, "dié,chōu"},
    { 0x7724, "nì"},
    { 0x7725, "zì"},
    { 0x7726, "zì"},
    { 0x7727, "chǎo"},
    { 0x7728, "zhǎ"},
    { 0x7729, "xuàn,huàn,juàn"},
    { 0x772A, "bǐng,fǎng"},
    { 0x772B, "mǐ,pàn"},
    { 0x772C, "lóng"},
    { 0x772D, "suī,huī,xié,wèi"},
    { 0x772E, "tóng"},
    { 0x772F, "mī,mǐ,mì,mí"},
    { 0x7730, "diè,zhì"},
    { 0x7731, "dì"},
    { 0x7732, "nè"},
    { 0x7733, "míng"},
    { 0x7734, "xuàn,shùn,xún"},
    { 0x7735, "chī"},
    { 0x7736, "kuàng"},
    { 0x7737, "juàn"},
    { 0x7738, "móu"},
    { 0x7739, "zhèn"},
    { 0x773A, "tiào"},
    { 0x773B, "yáng"},
    { 0x773C, "yǎn,wěn"},
    { 0x773D, "mò,mì"},
    { 0x773E, "zhòng"},
    { 0x773F, "mò"},
    { 0x7740, "zhe,zhuó,zhāo,zháo"},
    { 0x7741, "zhēng"},
    { 0x7742, "méi"},
    { 0x7743, "suō,jùn,juān"},
    { 0x7744, "shào,qiáo,xiāo"},
    { 0x7745, "hàn"},
    { 0x7746, "huàn,huǎn"},
    { 0x7747, "dì,tī,tí"},
    { 0x7748, "chěng"},
    { 0x7749, "cuó,zhuài"},
    { 0x774A, "juàn"},
    { 0x774B, "é"},
    { 0x774C, "mǎn"},
    { 0x774D, "xiàn"},
    { 0x774E, "xī"},
    { 0x774F, "kùn"},
    { 0x7750, "lài"},
    { 0x7751, "jiǎn"},
    { 0x7752, "shǎn"},
    { 0x7753, "tiǎn"},
    { 0x7754, "gùn,huán,lǔn"},
    { 0x7755, "wǎn,wàn,wān"},
    { 0x7756, "lèng,chēng"},
    { 0x7757, "shì"},
    { 0x7758, "qióng"},
    { 0x7759, "liè"},
    { 0x775A, "yá"},
    { 0x775B, "jīng,jǐng"},
    { 0x775C, "zhēng"},
    { 0x775D, "lí"},
    { 0x775E, "lài"},
    { 0x775F, "suì,zuì"},
    { 0x7760, "juàn"},
    { 0x7761, "shuì"},
    { 0x7762, "suī,huī,wěi"},
    { 0x7763, "dū"},
    { 0x7764, "bì"},
    { 0x7765, "pì"},
    { 0x7766, "mù"},
    { 0x7767, "hūn"},
    { 0x7768, "nì"},
    { 0x7769, "lù"},
    { 0x776A, "yì,zé,dù,gāo"},
    { 0x776B, "jié,shè"},
    { 0x776C, "cǎi"},
    { 0x776D, "zhǒu"},
    { 0x776E, "yú"},
    { 0x776F, "hūn"},
    { 0x7770, "mà"},
    { 0x7771, "xià,xiá"},
    { 0x7772, "xǐng,xìng"},
    { 0x7773, "huī"},
    { 0x7774, "gùn"},
    { 0x7775, "zāi"},
    { 0x7776, "chǔn"},
    { 0x7777, "jiān"},
    { 0x7778, "mèi"},
    { 0x7779, "dǔ"},
    { 0x777A, "hóu"},
    { 0x777B, "xuān"},
    { 0x777C, "tiàn"},
    { 0x777D, "kuí,kuì,jì"},
    { 0x777E, "gāo,hào"},
    { 0x777F, "ruì"},
    { 0x7780, "mào,wú"},
    { 0x7781, "xù"},
    { 0x7782, "fá"},
    { 0x7783, "wò"},
    { 0x7784, "miáo"},
    { 0x7785, "chǒu"},
    { 0x7786, "kuì"},
    { 0x7787, "mī,mǐ,mì"},
    { 0x7788, "wěng"},
    { 0x7789, "kòu,jì"},
    { 0x778A, "dàng"},
    { 0x778B, "chēn,tián,tiàn,shèn"},
    { 0x778C, "kē"},
    { 0x778D, "sǒu"},
    { 0x778E, "xiā"},
    { 0x778F, "qióng,huán"},
    { 0x7790, "mò"},
    { 0x7791, "míng,méng,mián"},
    { 0x7792, "mán"},
    { 0x7793, "shuì"},
    { 0x7794, "zé"},
    { 0x7795, "zhàng"},
    { 0x7796, "yì"},
    { 0x7797, "diāo,dōu"},
    { 0x7798, "kōu"},
    { 0x7799, "mò"},
    { 0x779A, "shùn"},
    { 0x779B, "cōng"},
    { 0x779C, "lōu,lóu,lǘ"},
    { 0x779D, "chī"},
    { 0x779E, "mán,mén,mèn"},
    { 0x779F, "piǎo,piào,piāo"},
    { 0x77A0, "chēng,zhèng"},
    { 0x77A1, "guī"},
    { 0x77A2, "méng,máng,mèng"},
    { 0x77A3, "wàn"},
    { 0x77A4, "rún,shùn"},
    { 0x77A5, "piē,bì"},
    { 0x77A6, "xī"},
    { 0x77A7, "qiáo"},
    { 0x77A8, "pú"},
    { 0x77A9, "zhǔ"},
    { 0x77AA, "dèng"},
    { 0x77AB, "shěn"},
    { 0x77AC, "shùn"},
    { 0x77AD, "liǎo,liào"},
    { 0x77AE, "chè"},
    { 0x77AF, "xián,jiàn"},
    { 0x77B0, "kàn"},
    { 0x77B1, "yè"},
    { 0x77B2, "xù,xuè"},
    { 0x77B3, "tóng"},
    { 0x77B4, "móu,wǔ,mí"},
    { 0x77B5, "lín,lìn,lián"},
    { 0x77B6, "guì,wèi,kuì"},
    { 0x77B7, "jiàn,xián"},
    { 0x77B8, "yè"},
    { 0x77B9, "ài"},
    { 0x77BA, "huì"},
    { 0x77BB, "zhān"},
    { 0x77BC, "jiǎn"},
    { 0x77BD, "gǔ"},
    { 0x77BE, "zhào"},
    { 0x77BF, "qú,jù,jí"},
    { 0x77C0, "méi"},
    { 0x77C1, "chǒu"},
    { 0x77C2, "sào"},
    { 0x77C3, "nǐng,chēng"},
    { 0x77C4, "xūn"},
    { 0x77C5, "yào"},
    { 0x77C6, "huò,xuē,yuè,wò"},
    { 0x77C7, "méng,měng,mēng"},
    { 0x77C8, "mián"},
    { 0x77C9, "pín"},
    { 0x77CA, "mián"},
    { 0x77CB, "lěi"},
    { 0x77CC, "kuàng,guō"},
    { 0x77CD, "jué"},
    { 0x77CE, "xuān,xuàn"},
    { 0x77CF, "mián"},
    { 0x77D0, "huò"},
    { 0x77D1, "lú"},
    { 0x77D2, "méng"},
    { 0x77D3, "lóng"},
    { 0x77D4, "guàn,quán"},
    { 0x77D5, "mǎn,mán"},
    { 0x77D6, "xǐ,lí"},
    { 0x77D7, "chù"},
    { 0x77D8, "tǎng"},
    { 0x77D9, "kàn"},
    { 0x77DA, "zhǔ"},
    { 0x77DB, "máo"},
    { 0x77DC, "jīn,qín,guān"},
    { 0x77DD, "jīn"},
    { 0x77DE, "yù,jué,xù"},
    { 0x77DF, "shuò"},
    { 0x77E0, "zé,zhuó"},
    { 0x77E1, "jué"},
    { 0x77E2, "shǐ"},
    { 0x77E3, "yǐ,xián"},
    { 0x77E4, "shěn"},
    { 0x77E5, "zhī,zhì"},
    { 0x77E6, "hóu"},
    { 0x77E7, "shěn"},
    { 0x77E8, "yǐng"},
    { 0x77E9, "jǔ"},
    { 0x77EA, "zhōu"},
    { 0x77EB, "jiǎo,jiáo"},
    { 0x77EC, "cuó"},
    { 0x77ED, "duǎn"},
    { 0x77EE, "ǎi"},
    { 0x77EF, "jiǎo,jiāo,jiáo"},
    { 0x77F0, "zēng"},
    { 0x77F1, "yuē"},
    { 0x77F2, "bà"},
    { 0x77F3, "shí,dàn"},
    { 0x77F4, "dìng"},
    { 0x77F5, "qì,diāo"},
    { 0x77F6, "jī"},
    { 0x77F7, "zǐ"},
    { 0x77F8, "gān,gàn,gǎn,hàn"},
    { 0x77F9, "wù"},
    { 0x77FA, "zhé,dā"},
    { 0x77FB, "kū,qià"},
    { 0x77FC, "gāng,kòng,qiāng"},
    { 0x77FD, "xì,xī"},
    { 0x77FE, "fán"},
    { 0x77FF, "kuàng"},
    { 0x7800, "dàng"},
    { 0x7801, "mǎ"},
    { 0x7802, "shā"},
    { 0x7803, "dān"},
    { 0x7804, "jué"},
    { 0x7805, "lì"},
    { 0x7806, "fū"},
    { 0x7807, "mín"},
    { 0x7808, "ě"},
    { 0x7809, "huò,xū,huā"},
    { 0x780A, "kāng,kàng"},
    { 0x780B, "zhǐ"},
    { 0x780C, "qì,qiè"},
    { 0x780D, "kǎn"},
    { 0x780E, "jiè"},
    { 0x780F, "bīn,fēn,pīn"},
    { 0x7810, "è"},
    { 0x7811, "yà"},
    { 0x7812, "pī"},
    { 0x7813, "zhé"},
    { 0x7814, "yán,yàn,xíng"},
    { 0x7815, "suì"},
    { 0x7816, "zhuān"},
    { 0x7817, "chē"},
    { 0x7818, "dùn"},
    { 0x7819, "wǎ"},
    { 0x781A, "yàn"},
    { 0x781B, "jīn"},
    { 0x781C, "fēng"},
    { 0x781D, "fá,jié,gé,fǎ"},
    { 0x781E, "mò"},
    { 0x781F, "zhǎ,zhà,zuó"},
    { 0x7820, "jū,zū"},
    { 0x7821, "yù"},
    { 0x7822, "kē,luǒ"},
    { 0x7823, "tuó"},
    { 0x7824, "tuó"},
    { 0x7825, "dǐ,zhǐ"},
    { 0x7826, "zhài"},
    { 0x7827, "zhēn"},
    { 0x7828, "è"},
    { 0x7829, "fú,fèi"},
    { 0x782A, "mǔ"},
    { 0x782B, "zhù,zhǔ"},
    { 0x782C, "lá,lì,lā"},
    { 0x782D, "biān"},
    { 0x782E, "nǔ,nú"},
    { 0x782F, "pīng"},
    { 0x7830, "pēng,pīng,pèng"},
    { 0x7831, "líng"},
    { 0x7832, "pào,báo,pū"},
    { 0x7833, "lè"},
    { 0x7834, "pò"},
    { 0x7835, "bō,è"},
    { 0x7836, "pò"},
    { 0x7837, "shēn"},
    { 0x7838, "zá"},
    { 0x7839, "ài"},
    { 0x783A, "lì"},
    { 0x783B, "lóng"},
    { 0x783C, "tóng"},
    { 0x783D, "yòng"},
    { 0x783E, "lì"},
    { 0x783F, "kuàng"},
    { 0x7840, "chǔ"},
    { 0x7841, "kēng"},
    { 0x7842, "quán"},
    { 0x7843, "zhū"},
    { 0x7844, "kuāng,guāng"},
    { 0x7845, "guī,hè"},
    { 0x7846, "è"},
    { 0x7847, "náo"},
    { 0x7848, "qià"},
    { 0x7849, "lù"},
    { 0x784A, "wěi,guì"},
    { 0x784B, "ài"},
    { 0x784C, "gè,luò,lì"},
    { 0x784D, "xiàn,kèn,kēng,yǐn"},
    { 0x784E, "xíng,kēng"},
    { 0x784F, "yán,yàn"},
    { 0x7850, "dòng,tóng,liú"},
    { 0x7851, "pēng,píng"},
    { 0x7852, "xī"},
    { 0x7853, "lǎo"},
    { 0x7854, "hóng"},
    { 0x7855, "shuò"},
    { 0x7856, "xiá"},
    { 0x7857, "qiāo"},
    { 0x7858, "qing"},
    { 0x7859, "wéi,wèi"},
    { 0x785A, "qiáo"},
    { 0x785B, "yì"},
    { 0x785C, "kēng,qìng"},
    { 0x785D, "xiāo,qiào"},
    { 0x785E, "què,kè,kù"},
    { 0x785F, "chàn"},
    { 0x7860, "láng"},
    { 0x7861, "hōng"},
    { 0x7862, "yú"},
    { 0x7863, "xiāo"},
    { 0x7864, "xiá"},
    { 0x7865, "mǎng,bàng"},
    { 0x7866, "luò,lòng"},
    { 0x7867, "yǒng,tóng"},
    { 0x7868, "chē"},
    { 0x7869, "chè"},
    { 0x786A, "wò,é,yǐ"},
    { 0x786B, "liú,chù"},
    { 0x786C, "yìng,gěng"},
    { 0x786D, "máng"},
    { 0x786E, "què"},
    { 0x786F, "yàn"},
    { 0x7870, "shā"},
    { 0x7871, "kǔn"},
    { 0x7872, "yù"},
    { 0x7873, "chì"},
    { 0x7874, "huā"},
    { 0x7875, "lǔ"},
    { 0x7876, "chěn,cén"},
    { 0x7877, "jiǎn"},
    { 0x7878, "nüè"},
    { 0x7879, "sōng"},
    { 0x787A, "zhuó"},
    { 0x787B, "kēng,kěng"},
    { 0x787C, "péng,pēng"},
    { 0x787D, "yān,yǎn"},
    { 0x787E, "zhuì,duǒ"},
    { 0x787F, "kōng"},
    { 0x7880, "chéng"},
    { 0x7881, "qí"},
    { 0x7882, "zòng,cóng"},
    { 0x7883, "qìng"},
    { 0x7884, "lín"},
    { 0x7885, "jūn"},
    { 0x7886, "bō"},
    { 0x7887, "dìng"},
    { 0x7888, "mín"},
    { 0x7889, "diāo"},
    { 0x788A, "jiān,zhàn"},
    { 0x788B, "hè"},
    { 0x788C, "lù,luò,liù"},
    { 0x788D, "ài"},
    { 0x788E, "suì"},
    { 0x788F, "què,xī"},
    { 0x7890, "léng"},
    { 0x7891, "bēi"},
    { 0x7892, "yín"},
    { 0x7893, "duì,duī"},
    { 0x7894, "wǔ"},
    { 0x7895, "qí,qī,qǐ"},
    { 0x7896, "lǔn,lùn,lún"},
    { 0x7897, "wǎn"},
    { 0x7898, "diǎn"},
    { 0x7899, "náo,gāng"},
    { 0x789A, "bèi"},
    { 0x789B, "qì"},
    { 0x789C, "chěn"},
    { 0x789D, "ruǎn"},
    { 0x789E, "yán"},
    { 0x789F, "dié,shé"},
    { 0x78A0, "dìng"},
    { 0x78A1, "dú,zhóu"},
    { 0x78A2, "tuó"},
    { 0x78A3, "jié,kě,yà"},
    { 0x78A4, "yīng"},
    { 0x78A5, "biǎn"},
    { 0x78A6, "kè"},
    { 0x78A7, "bì"},
    { 0x78A8, "wèi,wěi"},
    { 0x78A9, "shuò"},
    { 0x78AA, "zhēn,ǎn,kàn"},
    { 0x78AB, "duàn"},
    { 0x78AC, "xiá"},
    { 0x78AD, "dàng"},
    { 0x78AE, "tí,dī"},
    { 0x78AF, "nǎo"},
    { 0x78B0, "pèng"},
    { 0x78B1, "jiǎn,xián"},
    { 0x78B2, "dì"},
    { 0x78B3, "tàn"},
    { 0x78B4, "chá,chā"},
    { 0x78B5, "tián"},
    { 0x78B6, "qì"},
    { 0x78B7, "dùn"},
    { 0x78B8, "fēng"},
    { 0x78B9, "xuàn"},
    { 0x78BA, "què"},
    { 0x78BB, "què,qiāo"},
    { 0x78BC, "mǎ"},
    { 0x78BD, "gōng"},
    { 0x78BE, "niǎn"},
    { 0x78BF, "sù,xiè"},
    { 0x78C0, "é"},
    { 0x78C1, "cí"},
    { 0x78C2, "liú,liù"},
    { 0x78C3, "sī,tí"},
    { 0x78C4, "táng"},
    { 0x78C5, "bàng,pāng,páng"},
    { 0x78C6, "huá,kě,gū"},
    { 0x78C7, "pī"},
    { 0x78C8, "wěi,kuǐ"},
    { 0x78C9, "sǎng"},
    { 0x78CA, "lěi"},
    { 0x78CB, "cuō"},
    { 0x78CC, "tián"},
    { 0x78CD, "xiá,qià,yà"},
    { 0x78CE, "xī,qī"},
    { 0x78CF, "lián,qiān"},
    { 0x78D0, "pán"},
    { 0x78D1, "wéi,wèi,ái,gài"},
    { 0x78D2, "yǔn"},
    { 0x78D3, "duī,zhuì"},
    { 0x78D4, "zhé"},
    { 0x78D5, "kē,kě"},
    { 0x78D6, "lá,lā"},
    { 0x78D7, "zhuān"},
    { 0x78D8, "yáo"},
    { 0x78D9, "gǔn"},
    { 0x78DA, "zhuān,tuán,tuó"},
    { 0x78DB, "chán"},
    { 0x78DC, "qì,qī"},
    { 0x78DD, "áo,qiāo"},
    { 0x78DE, "pēng"},
    { 0x78DF, "liù,lù"},
    { 0x78E0, "lǔ"},
    { 0x78E1, "kàn"},
    { 0x78E2, "chuǎng"},
    { 0x78E3, "chěn,cà"},
    { 0x78E4, "yǐn,yīn"},
    { 0x78E5, "lěi,léi"},
    { 0x78E6, "biāo"},
    { 0x78E7, "qì"},
    { 0x78E8, "mó,mò"},
    { 0x78E9, "qì,zhú"},
    { 0x78EA, "cuī"},
    { 0x78EB, "zōng"},
    { 0x78EC, "qìng,qǐng"},
    { 0x78ED, "chuò"},
    { 0x78EE, "lún"},
    { 0x78EF, "jī"},
    { 0x78F0, "shàn"},
    { 0x78F1, "láo"},
    { 0x78F2, "qú"},
    { 0x78F3, "zēng"},
    { 0x78F4, "dèng,dēng"},
    { 0x78F5, "jiàn"},
    { 0x78F6, "xì"},
    { 0x78F7, "lín,lìn,lǐn,líng"},
    { 0x78F8, "dìng"},
    { 0x78F9, "tán,diàn"},
    { 0x78FA, "huáng,kuàng,gǒng"},
    { 0x78FB, "pán,bō"},
    { 0x78FC, "zá,shé"},
    { 0x78FD, "qiāo,qiǎo,qiào,áo"},
    { 0x78FE, "dī"},
    { 0x78FF, "lì"},
    { 0x7900, "jiàn"},
    { 0x7901, "jiāo"},
    { 0x7902, "xī"},
    { 0x7903, "zhǎng"},
    { 0x7904, "qiáo"},
    { 0x7905, "dūn"},
    { 0x7906, "jiǎn,xiǎn"},
    { 0x7907, "yù"},
    { 0x7908, "zhuì"},
    { 0x7909, "hé,qiāo,qiào,áo"},
    { 0x790A, "kè,huò"},
    { 0x790B, "zé"},
    { 0x790C, "léi,lèi,lěi"},
    { 0x790D, "jié"},
    { 0x790E, "chǔ"},
    { 0x790F, "yè"},
    { 0x7910, "què,hú"},
    { 0x7911, "dàng"},
    { 0x7912, "yǐ"},
    { 0x7913, "jiāng"},
    { 0x7914, "pī"},
    { 0x7915, "pī"},
    { 0x7916, "yù"},
    { 0x7917, "pīn"},
    { 0x7918, "è,qì"},
    { 0x7919, "ài,yí"},
    { 0x791A, "kē"},
    { 0x791B, "jiān"},
    { 0x791C, "yù"},
    { 0x791D, "ruǎn"},
    { 0x791E, "méng"},
    { 0x791F, "pào"},
    { 0x7920, "cí"},
    { 0x7921, "bó"},
    { 0x7922, "yǎng"},
    { 0x7923, "mà"},
    { 0x7924, "cǎ"},
    { 0x7925, "xián,xín"},
    { 0x7926, "kuàng,gǒng"},
    { 0x7927, "léi,lèi,lěi"},
    { 0x7928, "lěi"},
    { 0x7929, "zhì"},
    { 0x792A, "lì"},
    { 0x792B, "lì,luò"},
    { 0x792C, "fán"},
    { 0x792D, "què"},
    { 0x792E, "pào"},
    { 0x792F, "yīng"},
    { 0x7930, "lì"},
    { 0x7931, "lóng"},
    { 0x7932, "lóng"},
    { 0x7933, "mò"},
    { 0x7934, "bó"},
    { 0x7935, "shuāng"},
    { 0x7936, "guàn"},
    { 0x7937, "lán"},
    { 0x7938, "cǎ"},
    { 0x7939, "yán,yǎn"},
    { 0x793A, "shì,qí,zhì,shí"},
    { 0x793B, "shì"},
    { 0x793C, "lǐ"},
    { 0x793D, "réng"},
    { 0x793E, "shè"},
    { 0x793F, "yuè"},
    { 0x7940, "sì"},
    { 0x7941, "qí,zhǐ"},
    { 0x7942, "tā"},
    { 0x7943, "mà"},
    { 0x7944, "xiè"},
    { 0x7945, "yāo"},
    { 0x7946, "xiān"},
    { 0x7947, "qí,chí,zhī,zhǐ"},
    { 0x7948, "qí,guǐ"},
    { 0x7949, "zhǐ"},
    { 0x794A, "bēng,fāng"},
    { 0x794B, "duì"},
    { 0x794C, "zhòng,chōng"},
    { 0x794D, "rèn"},
    { 0x794E, "yī"},
    { 0x794F, "shí"},
    { 0x7950, "yòu"},
    { 0x7951, "zhì"},
    { 0x7952, "tiáo"},
    { 0x7953, "fú,fèi"},
    { 0x7954, "fù"},
    { 0x7955, "mì,bì"},
    { 0x7956, "zǔ,jiē"},
    { 0x7957, "zhī"},
    { 0x7958, "suàn"},
    { 0x7959, "mèi"},
    { 0x795A, "zuò"},
    { 0x795B, "qū"},
    { 0x795C, "hù"},
    { 0x795D, "zhù,zhòu,chù"},
    { 0x795E, "shén,shēn"},
    { 0x795F, "suì"},
    { 0x7960, "cí,sì"},
    { 0x7961, "chái"},
    { 0x7962, "mí,nǐ"},
    { 0x7963, "lǚ"},
    { 0x7964, "yǔ"},
    { 0x7965, "xiáng"},
    { 0x7966, "wú"},
    { 0x7967, "tiāo"},
    { 0x7968, "piào,piāo"},
    { 0x7969, "zhù"},
    { 0x796A, "guǐ"},
    { 0x796B, "xiá"},
    { 0x796C, "zhī"},
    { 0x796D, "jì,zhài"},
    { 0x796E, "gào"},
    { 0x796F, "zhēn"},
    { 0x7970, "gào"},
    { 0x7971, "shuì,lèi"},
    { 0x7972, "jìn"},
    { 0x7973, "shèn"},
    { 0x7974, "gāi"},
    { 0x7975, "kǔn"},
    { 0x7976, "dì"},
    { 0x7977, "dǎo"},
    { 0x7978, "huò"},
    { 0x7979, "táo"},
    { 0x797A, "qí"},
    { 0x797B, "gù"},
    { 0x797C, "guàn"},
    { 0x797D, "zuì"},
    { 0x797E, "líng"},
    { 0x797F, "lù"},
    { 0x7980, "bǐng"},
    { 0x7981, "jìn,jīn"},
    { 0x7982, "dǎo"},
    { 0x7983, "zhí"},
    { 0x7984, "lù"},
    { 0x7985, "chán,shàn"},
    { 0x7986, "bì"},
    { 0x7987, "zhě"},
    { 0x7988, "huī"},
    { 0x7989, "yǒu"},
    { 0x798A, "xì"},
    { 0x798B, "yīn"},
    { 0x798C, "zī"},
    { 0x798D, "huò"},
    { 0x798E, "zhēn,zhēng"},
    { 0x798F, "fú,fù"},
    { 0x7990, "yuàn"},
    { 0x7991, "wú"},
    { 0x7992, "xiǎn"},
    { 0x7993, "yáng,shāng"},
    { 0x7994, "zhī"},
    { 0x7995, "yī"},
    { 0x7996, "méi"},
    { 0x7997, "sī"},
    { 0x7998, "dì"},
    { 0x7999, "bèi"},
    { 0x799A, "zhuó"},
    { 0x799B, "zhēn"},
    { 0x799C, "yǒng,yíng"},
    { 0x799D, "jì"},
    { 0x799E, "gào"},
    { 0x799F, "táng"},
    { 0x79A0, "sī"},
    { 0x79A1, "mà"},
    { 0x79A2, "tà"},
    { 0x79A3, "fù"},
    { 0x79A4, "xuān"},
    { 0x79A5, "qí"},
    { 0x79A6, "yù"},
    { 0x79A7, "xǐ,xī"},
    { 0x79A8, "jī,jì,qí"},
    { 0x79A9, "sì"},
    { 0x79AA, "chán,shàn,tán"},
    { 0x79AB, "dàn"},
    { 0x79AC, "guì"},
    { 0x79AD, "suì"},
    { 0x79AE, "lǐ"},
    { 0x79AF, "nóng"},
    { 0x79B0, "mí,nǐ,xiǎn"},
    { 0x79B1, "dǎo"},
    { 0x79B2, "lì"},
    { 0x79B3, "ráng"},
    { 0x79B4, "yuè"},
    { 0x79B5, "tí"},
    { 0x79B6, "zàn"},
    { 0x79B7, "lèi"},
    { 0x79B8, "róu"},
    { 0x79B9, "yǔ"},
    { 0x79BA, "yú,yù"},
    { 0x79BB, "lí,chī"},
    { 0x79BC, "xiè"},
    { 0x79BD, "qín"},
    { 0x79BE, "hé"},
    { 0x79BF, "tū"},
    { 0x79C0, "xiù"},
    { 0x79C1, "sī"},
    { 0x79C2, "rén"},
    { 0x79C3, "tū"},
    { 0x79C4, "zǐ,zì"},
    { 0x79C5, "chá,ná"},
    { 0x79C6, "gǎn"},
    { 0x79C7, "yì,zhí"},
    { 0x79C8, "xiān"},
    { 0x79C9, "bǐng"},
    { 0x79CA, "nián"},
    { 0x79CB, "qiū"},
    { 0x79CC, "qiū"},
    { 0x79CD, "zhǒng,chóng,zhòng"},
    { 0x79CE, "fèn"},
    { 0x79CF, "hào,mào"},
    { 0x79D0, "yún"},
    { 0x79D1, "kē,kè"},
    { 0x79D2, "miǎo"},
    { 0x79D3, "zhī"},
    { 0x79D4, "jīng"},
    { 0x79D5, "bǐ"},
    { 0x79D6, "zhī"},
    { 0x79D7, "yù"},
    { 0x79D8, "mì,bì,bié"},
    { 0x79D9, "kù"},
    { 0x79DA, "bàn"},
    { 0x79DB, "pī"},
    { 0x79DC, "ní,nì"},
    { 0x79DD, "lì"},
    { 0x79DE, "yóu"},
    { 0x79DF, "zū,jū"},
    { 0x79E0, "pī"},
    { 0x79E1, "bó"},
    { 0x79E2, "líng"},
    { 0x79E3, "mò"},
    { 0x79E4, "chèng,chēng,píng"},
    { 0x79E5, "nián"},
    { 0x79E6, "qín"},
    { 0x79E7, "yāng"},
    { 0x79E8, "zuó"},
    { 0x79E9, "zhì"},
    { 0x79EA, "zhī"},
    { 0x79EB, "shú"},
    { 0x79EC, "jù"},
    { 0x79ED, "zǐ"},
    { 0x79EE, "huó"},
    { 0x79EF, "jī,zhǐ"},
    { 0x79F0, "chēng,chèn,chèng"},
    { 0x79F1, "tóng"},
    { 0x79F2, "zhì,shì"},
    { 0x79F3, "huó,kuò"},
    { 0x79F4, "hé,gé"},
    { 0x79F5, "yīn"},
    { 0x79F6, "zī"},
    { 0x79F7, "zhì"},
    { 0x79F8, "jiē,jí"},
    { 0x79F9, "rěn"},
    { 0x79FA, "dù"},
    { 0x79FB, "yí,chǐ,yì"},
    { 0x79FC, "zhū"},
    { 0x79FD, "huì"},
    { 0x79FE, "nóng"},
    { 0x79FF, "fù,bū,pū"},
    { 0x7A00, "xī"},
    { 0x7A01, "gǎo"},
    { 0x7A02, "láng"},
    { 0x7A03, "fū"},
    { 0x7A04, "xùn,zè"},
    { 0x7A05, "shuì"},
    { 0x7A06, "lǚ"},
    { 0x7A07, "kǔn"},
    { 0x7A08, "gǎn"},
    { 0x7A09, "jīng"},
    { 0x7A0A, "tí"},
    { 0x7A0B, "chéng"},
    { 0x7A0C, "tú,shǔ"},
    { 0x7A0D, "shāo,shào"},
    { 0x7A0E, "shuì,tuō,tuì,tuàn"},
    { 0x7A0F, "yà"},
    { 0x7A10, "lǔn"},
    { 0x7A11, "lù"},
    { 0x7A12, "gù"},
    { 0x7A13, "zuó"},
    { 0x7A14, "rěn"},
    { 0x7A15, "zhùn,zhǔn"},
    { 0x7A16, "bàng"},
    { 0x7A17, "bài"},
    { 0x7A18, "jī,qí"},
    { 0x7A19, "zhī,zhì"},
    { 0x7A1A, "zhì"},
    { 0x7A1B, "kǔn"},
    { 0x7A1C, "léng,lèng,líng"},
    { 0x7A1D, "péng"},
    { 0x7A1E, "kē,huà"},
    { 0x7A1F, "bǐng,lǐn"},
    { 0x7A20, "chóu,tiáo,diào"},
    { 0x7A21, "zuì,zú,sū"},
    { 0x7A22, "yù"},
    { 0x7A23, "sū"},
    { 0x7A24, "lüè"},
    { 0x7A25, "xiāng"},
    { 0x7A26, "yī"},
    { 0x7A27, "xì,qiè"},
    { 0x7A28, "biǎn"},
    { 0x7A29, "jì"},
    { 0x7A2A, "fú"},
    { 0x7A2B, "pì,bì"},
    { 0x7A2C, "nuò"},
    { 0x7A2D, "jiē"},
    { 0x7A2E, "zhǒng,chóng,zhòng"},
    { 0x7A2F, "zōng,zǒng"},
    { 0x7A30, "xǔ,xū"},
    { 0x7A31, "chēng,chèn,chèng"},
    { 0x7A32, "dào"},
    { 0x7A33, "wěn"},
    { 0x7A34, "xián,jiān,liàn,liǎn"},
    { 0x7A35, "zī,jiū"},
    { 0x7A36, "yù"},
    { 0x7A37, "jì,zè"},
    { 0x7A38, "xù"},
    { 0x7A39, "zhěn,zhēn,biān"},
    { 0x7A3A, "zhì"},
    { 0x7A3B, "dào"},
    { 0x7A3C, "jià"},
    { 0x7A3D, "jī,qǐ"},
    { 0x7A3E, "gǎo,kào,gào,jiào"},
    { 0x7A3F, "gǎo"},
    { 0x7A40, "gǔ"},
    { 0x7A41, "róng"},
    { 0x7A42, "suì"},
    { 0x7A43, "rong"},
    { 0x7A44, "jì"},
    { 0x7A45, "kāng"},
    { 0x7A46, "mù"},
    { 0x7A47, "cǎn,shān,cēn"},
    { 0x7A48, "méi,mén,mí"},
    { 0x7A49, "zhì,chí,tí"},
    { 0x7A4A, "jì"},
    { 0x7A4B, "lù,jiū"},
    { 0x7A4C, "sū"},
    { 0x7A4D, "jī"},
    { 0x7A4E, "yǐng"},
    { 0x7A4F, "wěn"},
    { 0x7A50, "qiū"},
    { 0x7A51, "sè"},
    { 0x7A52, "hè"},
    { 0x7A53, "yì"},
    { 0x7A54, "huáng"},
    { 0x7A55, "qiè"},
    { 0x7A56, "jǐ,jì"},
    { 0x7A57, "suì"},
    { 0x7A58, "xiāo,rào"},
    { 0x7A59, "pú"},
    { 0x7A5A, "jiāo"},
    { 0x7A5B, "zhuō,bó"},
    { 0x7A5C, "zhǒng,tóng,zhòng"},
    { 0x7A5D, "zui"},
    { 0x7A5E, "lǚ"},
    { 0x7A5F, "suì"},
    { 0x7A60, "nóng"},
    { 0x7A61, "sè"},
    { 0x7A62, "huì"},
    { 0x7A63, "ráng"},
    { 0x7A64, "nuò"},
    { 0x7A65, "yù,yǔ"},
    { 0x7A66, "pīn"},
    { 0x7A67, "jì,zì"},
    { 0x7A68, "tuí"},
    { 0x7A69, "wěn"},
    { 0x7A6A, "chēng,bié"},
    { 0x7A6B, "huò,hù"},
    { 0x7A6C, "kuàng"},
    { 0x7A6D, "lǚ"},
    { 0x7A6E, "biāo,pāo"},
    { 0x7A6F, "sè"},
    { 0x7A70, "ráng,rǎng,réng"},
    { 0x7A71, "zhuō,jué"},
    { 0x7A72, "lí"},
    { 0x7A73, "cuán,zàn"},
    { 0x7A74, "xué,jué"},
    { 0x7A75, "wā,yà"},
    { 0x7A76, "jiū,jiù"},
    { 0x7A77, "qióng"},
    { 0x7A78, "xī"},
    { 0x7A79, "qióng,qiōng,kōng"},
    { 0x7A7A, "kōng,kǒng,kòng"},
    { 0x7A7B, "yū,yǔ"},
    { 0x7A7C, "shēn"},
    { 0x7A7D, "jǐng"},
    { 0x7A7E, "yào,yǎo"},
    { 0x7A7F, "chuān,chuàn,yuān"},
    { 0x7A80, "zhūn,tún"},
    { 0x7A81, "tū"},
    { 0x7A82, "láo"},
    { 0x7A83, "qiè"},
    { 0x7A84, "zhǎi"},
    { 0x7A85, "yǎo"},
    { 0x7A86, "biǎn"},
    { 0x7A87, "báo"},
    { 0x7A88, "yǎo,yào"},
    { 0x7A89, "bǐng"},
    { 0x7A8A, "wā"},
    { 0x7A8B, "zhú,kū"},
    { 0x7A8C, "jiào,pào,liáo,liù"},
    { 0x7A8D, "qiào"},
    { 0x7A8E, "diào"},
    { 0x7A8F, "wū"},
    { 0x7A90, "guī,wā"},
    { 0x7A91, "yáo"},
    { 0x7A92, "zhì,dié"},
    { 0x7A93, "chuāng"},
    { 0x7A94, "yào,yǎo"},
    { 0x7A95, "tiǎo,tiāo"},
    { 0x7A96, "jiào,zào"},
    { 0x7A97, "chuāng,cōng"},
    { 0x7A98, "jiǒng"},
    { 0x7A99, "xiāo"},
    { 0x7A9A, "chéng"},
    { 0x7A9B, "kòu"},
    { 0x7A9C, "cuàn"},
    { 0x7A9D, "wō"},
    { 0x7A9E, "dàn"},
    { 0x7A9F, "kū"},
    { 0x7AA0, "kē"},
    { 0x7AA1, "zhuó"},
    { 0x7AA2, "xū"},
    { 0x7AA3, "sū"},
    { 0x7AA4, "guān"},
    { 0x7AA5, "kuī"},
    { 0x7AA6, "dòu"},
    { 0x7AA7, "zhuo"},
    { 0x7AA8, "xūn,yìn,yīn"},
    { 0x7AA9, "wō"},
    { 0x7AAA, "wā"},
    { 0x7AAB, "yà,yē"},
    { 0x7AAC, "yú,dōu"},
    { 0x7AAD, "jù"},
    { 0x7AAE, "qióng"},
    { 0x7AAF, "yáo,yào,qiāo"},
    { 0x7AB0, "yáo"},
    { 0x7AB1, "tiǎo"},
    { 0x7AB2, "cháo"},
    { 0x7AB3, "yǔ,yú"},
    { 0x7AB4, "tián"},
    { 0x7AB5, "diào"},
    { 0x7AB6, "jù,lóu"},
    { 0x7AB7, "liào"},
    { 0x7AB8, "xī"},
    { 0x7AB9, "wù"},
    { 0x7ABA, "kuī,kuǐ"},
    { 0x7ABB, "chuāng"},
    { 0x7ABC, "zhāo,kē"},
    { 0x7ABD, "kuǎn"},
    { 0x7ABE, "kuǎn,cuàn"},
    { 0x7ABF, "lóng"},
    { 0x7AC0, "chēng,chèng"},
    { 0x7AC1, "cuì"},
    { 0x7AC2, "liáo"},
    { 0x7AC3, "zào"},
    { 0x7AC4, "cuàn,cuān"},
    { 0x7AC5, "qiào"},
    { 0x7AC6, "qióng"},
    { 0x7AC7, "dòu,dú"},
    { 0x7AC8, "zào"},
    { 0x7AC9, "lǒng"},
    { 0x7ACA, "qiè"},
    { 0x7ACB, "lì,wèi"},
    { 0x7ACC, "chù"},
    { 0x7ACD, "shí"},
    { 0x7ACE, "fù"},
    { 0x7ACF, "qiān"},
    { 0x7AD0, "chù"},
    { 0x7AD1, "hóng"},
    { 0x7AD2, "qí"},
    { 0x7AD3, "háo"},
    { 0x7AD4, "shēng"},
    { 0x7AD5, "fēn"},
    { 0x7AD6, "shù"},
    { 0x7AD7, "miào"},
    { 0x7AD8, "qǔ,kǒu"},
    { 0x7AD9, "zhàn,zhān"},
    { 0x7ADA, "zhù"},
    { 0x7ADB, "líng"},
    { 0x7ADC, "lóng,néng"},
    { 0x7ADD, "bìng"},
    { 0x7ADE, "jìng"},
    { 0x7ADF, "jìng"},
    { 0x7AE0, "zhāng,zhàng"},
    { 0x7AE1, "bǎi"},
    { 0x7AE2, "sì"},
    { 0x7AE3, "jùn"},
    { 0x7AE4, "hóng"},
    { 0x7AE5, "tóng,zhōng"},
    { 0x7AE6, "sǒng"},
    { 0x7AE7, "jìng,zhěn"},
    { 0x7AE8, "diào"},
    { 0x7AE9, "yì"},
    { 0x7AEA, "shù"},
    { 0x7AEB, "jìng"},
    { 0x7AEC, "qǔ"},
    { 0x7AED, "jié"},
    { 0x7AEE, "pīng"},
    { 0x7AEF, "duān"},
    { 0x7AF0, "lí"},
    { 0x7AF1, "zhuǎn"},
    { 0x7AF2, "céng"},
    { 0x7AF3, "dēng"},
    { 0x7AF4, "cūn"},
    { 0x7AF5, "wāi,huā"},
    { 0x7AF6, "jìng"},
    { 0x7AF7, "kǎn,kàn"},
    { 0x7AF8, "jìng"},
    { 0x7AF9, "zhú"},
    { 0x7AFA, "zhú,dǔ"},
    { 0x7AFB, "lè,jīn"},
    { 0x7AFC, "péng"},
    { 0x7AFD, "yú"},
    { 0x7AFE, "chí"},
    { 0x7AFF, "gān,gàn,gǎn"},
    { 0x7B00, "máng"},
    { 0x7B01, "zhú"},
    { 0x7B02, "wán"},
    { 0x7B03, "dǔ"},
    { 0x7B04, "jī"},
    { 0x7B05, "jiǎo"},
    { 0x7B06, "bā"},
    { 0x7B07, "suàn"},
    { 0x7B08, "jí"},
    { 0x7B09, "qǐn"},
    { 0x7B0A, "zhào"},
    { 0x7B0B, "sǔn"},
    { 0x7B0C, "yá"},
    { 0x7B0D, "zhuì,ruì"},
    { 0x7B0E, "yuán"},
    { 0x7B0F, "hù,wěn,wù"},
    { 0x7B10, "háng,hàng"},
    { 0x7B11, "xiào"},
    { 0x7B12, "cén,jìn,hán"},
    { 0x7B13, "bì,pí,bī"},
    { 0x7B14, "bǐ"},
    { 0x7B15, "jiǎn"},
    { 0x7B16, "yǐ"},
    { 0x7B17, "dōng"},
    { 0x7B18, "shān"},
    { 0x7B19, "shēng"},
    { 0x7B1A, "dā,xiá,nà"},
    { 0x7B1B, "dí"},
    { 0x7B1C, "zhú"},
    { 0x7B1D, "nà"},
    { 0x7B1E, "chī"},
    { 0x7B1F, "gū"},
    { 0x7B20, "lì"},
    { 0x7B21, "qiè"},
    { 0x7B22, "mǐn"},
    { 0x7B23, "bāo"},
    { 0x7B24, "tiáo,shào"},
    { 0x7B25, "sì"},
    { 0x7B26, "fú"},
    { 0x7B27, "cè,shàn"},
    { 0x7B28, "bèn"},
    { 0x7B29, "fá"},
    { 0x7B2A, "dá"},
    { 0x7B2B, "zǐ"},
    { 0x7B2C, "dì"},
    { 0x7B2D, "líng"},
    { 0x7B2E, "zé,zhà,zuó"},
    { 0x7B2F, "nú"},
    { 0x7B30, "fú,fèi"},
    { 0x7B31, "gǒu"},
    { 0x7B32, "fán"},
    { 0x7B33, "jiā"},
    { 0x7B34, "gǎn"},
    { 0x7B35, "fàn"},
    { 0x7B36, "shǐ"},
    { 0x7B37, "mǎo"},
    { 0x7B38, "pǒ"},
    { 0x7B39, "ti"},
    { 0x7B3A, "jiān"},
    { 0x7B3B, "qióng"},
    { 0x7B3C, "lóng,lǒng"},
    { 0x7B3D, "mǐn"},
    { 0x7B3E, "biān"},
    { 0x7B3F, "luò"},
    { 0x7B40, "guì"},
    { 0x7B41, "qū"},
    { 0x7B42, "chí"},
    { 0x7B43, "yīn"},
    { 0x7B44, "yào"},
    { 0x7B45, "xiǎn"},
    { 0x7B46, "bǐ"},
    { 0x7B47, "qióng"},
    { 0x7B48, "kuò"},
    { 0x7B49, "děng"},
    { 0x7B4A, "xiáo,jiǎo,jiào"},
    { 0x7B4B, "jīn,qián"},
    { 0x7B4C, "quán"},
    { 0x7B4D, "sǔn,yún,xùn"},
    { 0x7B4E, "rú"},
    { 0x7B4F, "fá"},
    { 0x7B50, "kuāng"},
    { 0x7B51, "zhù,zhú"},
    { 0x7B52, "tǒng,dòng,tóng"},
    { 0x7B53, "jī"},
    { 0x7B54, "dá,dā"},
    { 0x7B55, "háng"},
    { 0x7B56, "cè"},
    { 0x7B57, "zhòng"},
    { 0x7B58, "kòu"},
    { 0x7B59, "lái"},
    { 0x7B5A, "bì"},
    { 0x7B5B, "shāi"},
    { 0x7B5C, "dāng"},
    { 0x7B5D, "zhēng"},
    { 0x7B5E, "cè"},
    { 0x7B5F, "fū"},
    { 0x7B60, "yún,jūn"},
    { 0x7B61, "tú"},
    { 0x7B62, "pá"},
    { 0x7B63, "lí"},
    { 0x7B64, "láng,làng"},
    { 0x7B65, "jǔ"},
    { 0x7B66, "guǎn"},
    { 0x7B67, "jiǎn,xiàn"},
    { 0x7B68, "hán"},
    { 0x7B69, "tóng,tǒng,yǒng,dòng"},
    { 0x7B6A, "xiá"},
    { 0x7B6B, "zhì,zhǐ"},
    { 0x7B6C, "chéng"},
    { 0x7B6D, "suàn"},
    { 0x7B6E, "shì"},
    { 0x7B6F, "zhù"},
    { 0x7B70, "zuó"},
    { 0x7B71, "xiǎo"},
    { 0x7B72, "shāo"},
    { 0x7B73, "tíng"},
    { 0x7B74, "cè,jiā,jiá"},
    { 0x7B75, "yán"},
    { 0x7B76, "gào,gǎo"},
    { 0x7B77, "kuài"},
    { 0x7B78, "gān"},
    { 0x7B79, "chóu"},
    { 0x7B7A, "kuāng"},
    { 0x7B7B, "gàng"},
    { 0x7B7C, "yún"},
    { 0x7B7D, "o"},
    { 0x7B7E, "qiān"},
    { 0x7B7F, "xiǎo"},
    { 0x7B80, "jiǎn"},
    { 0x7B81, "póu,bù,fú,pú"},
    { 0x7B82, "lái"},
    { 0x7B83, "zōu"},
    { 0x7B84, "bǐ,bēi,bī,bì,pái"},
    { 0x7B85, "bì"},
    { 0x7B86, "bì"},
    { 0x7B87, "gè"},
    { 0x7B88, "tái,chí"},
    { 0x7B89, "guǎi,dài"},
    { 0x7B8A, "yū"},
    { 0x7B8B, "jiān"},
    { 0x7B8C, "dào,zhào"},
    { 0x7B8D, "gū"},
    { 0x7B8E, "chí,hǔ"},
    { 0x7B8F, "zhēng"},
    { 0x7B90, "qìng,jīng,qiāng"},
    { 0x7B91, "shà,zhá"},
    { 0x7B92, "zhǒu"},
    { 0x7B93, "lù"},
    { 0x7B94, "bó"},
    { 0x7B95, "jī"},
    { 0x7B96, "lín,lǐn"},
    { 0x7B97, "suàn"},
    { 0x7B98, "jùn,qūn"},
    { 0x7B99, "fú"},
    { 0x7B9A, "zhá"},
    { 0x7B9B, "gū"},
    { 0x7B9C, "kōng"},
    { 0x7B9D, "qián"},
    { 0x7B9E, "qiān"},
    { 0x7B9F, "jùn"},
    { 0x7BA0, "chuí,zhuī"},
    { 0x7BA1, "guǎn"},
    { 0x7BA2, "yuān,wǎn"},
    { 0x7BA3, "cè"},
    { 0x7BA4, "zú"},
    { 0x7BA5, "bǒ"},
    { 0x7BA6, "zé"},
    { 0x7BA7, "qiè"},
    { 0x7BA8, "tuò"},
    { 0x7BA9, "luó"},
    { 0x7BAA, "dān"},
    { 0x7BAB, "xiāo"},
    { 0x7BAC, "ruò,nà"},
    { 0x7BAD, "jiàn"},
    { 0x7BAE, "xuān"},
    { 0x7BAF, "biān"},
    { 0x7BB0, "sǔn"},
    { 0x7BB1, "xiāng"},
    { 0x7BB2, "xiǎn"},
    { 0x7BB3, "píng"},
    { 0x7BB4, "zhēn,jiǎn"},
    { 0x7BB5, "xīng,xǐng,shěng"},
    { 0x7BB6, "hú"},
    { 0x7BB7, "yí,shī"},
    { 0x7BB8, "zhù,zhuó"},
    { 0x7BB9, "yuē,yào,chuò"},
    { 0x7BBA, "chūn"},
    { 0x7BBB, "lǜ"},
    { 0x7BBC, "wū"},
    { 0x7BBD, "dǒng"},
    { 0x7BBE, "shuò,xiāo,qiào"},
    { 0x7BBF, "jí"},
    { 0x7BC0, "jié,jiē"},
    { 0x7BC1, "huáng"},
    { 0x7BC2, "xīng"},
    { 0x7BC3, "mèi"},
    { 0x7BC4, "fàn"},
    { 0x7BC5, "chuán,duān"},
    { 0x7BC6, "zhuàn"},
    { 0x7BC7, "piān"},
    { 0x7BC8, "fēng"},
    { 0x7BC9, "zhù,zhú"},
    { 0x7BCA, "huáng,hóng"},
    { 0x7BCB, "qiè"},
    { 0x7BCC, "hóu"},
    { 0x7BCD, "qiū"},
    { 0x7BCE, "miǎo"},
    { 0x7BCF, "qiàn"},
    { 0x7BD0, "gū"},
    { 0x7BD1, "kuì"},
    { 0x7BD2, "shi"},
    { 0x7BD3, "lǒu"},
    { 0x7BD4, "yún,xūn"},
    { 0x7BD5, "hé"},
    { 0x7BD6, "táng"},
    { 0x7BD7, "yuè"},
    { 0x7BD8, "chōu"},
    { 0x7BD9, "gāo"},
    { 0x7BDA, "fěi"},
    { 0x7BDB, "ruò"},
    { 0x7BDC, "zhēng"},
    { 0x7BDD, "gōu"},
    { 0x7BDE, "niè"},
    { 0x7BDF, "qiàn"},
    { 0x7BE0, "xiǎo"},
    { 0x7BE1, "cuàn"},
    { 0x7BE2, "lǒng,gōng,gǎn"},
    { 0x7BE3, "péng,páng"},
    { 0x7BE4, "dǔ"},
    { 0x7BE5, "lì"},
    { 0x7BE6, "bì,pí"},
    { 0x7BE7, "zhuó,huò"},
    { 0x7BE8, "chú"},
    { 0x7BE9, "shāi,shī"},
    { 0x7BEA, "chí"},
    { 0x7BEB, "zhù"},
    { 0x7BEC, "qiāng,cāng"},
    { 0x7BED, "lóng"},
    { 0x7BEE, "lán"},
    { 0x7BEF, "jiān"},
    { 0x7BF0, "bù"},
    { 0x7BF1, "lí"},
    { 0x7BF2, "huì,suì"},
    { 0x7BF3, "bì"},
    { 0x7BF4, "dí,zhú"},
    { 0x7BF5, "cōng"},
    { 0x7BF6, "yān"},
    { 0x7BF7, "péng"},
    { 0x7BF8, "cǎn,cēn,zān"},
    { 0x7BF9, "zhuàn,suǎn,zuǎn"},
    { 0x7BFA, "pí"},
    { 0x7BFB, "piǎo,biāo"},
    { 0x7BFC, "dōu"},
    { 0x7BFD, "yù"},
    { 0x7BFE, "miè"},
    { 0x7BFF, "tuán,zhuān"},
    { 0x7C00, "zé,zhài"},
    { 0x7C01, "shāi"},
    { 0x7C02, "guì,guó"},
    { 0x7C03, "yí"},
    { 0x7C04, "hù"},
    { 0x7C05, "chǎn"},
    { 0x7C06, "kòu"},
    { 0x7C07, "cù,chuò,còu"},
    { 0x7C08, "píng"},
    { 0x7C09, "zào,chòu"},
    { 0x7C0A, "jī"},
    { 0x7C0B, "guǐ"},
    { 0x7C0C, "sù"},
    { 0x7C0D, "lǒu,lǚ,jù"},
    { 0x7C0E, "cè,jí"},
    { 0x7C0F, "lù"},
    { 0x7C10, "niǎn"},
    { 0x7C11, "suō"},
    { 0x7C12, "cuàn"},
    { 0x7C13, "diāo"},
    { 0x7C14, "suō"},
    { 0x7C15, "lè"},
    { 0x7C16, "duàn"},
    { 0x7C17, "zhù"},
    { 0x7C18, "xiāo"},
    { 0x7C19, "bó"},
    { 0x7C1A, "mì"},
    { 0x7C1B, "shāi,sī"},
    { 0x7C1C, "dàng,tāng"},
    { 0x7C1D, "liáo"},
    { 0x7C1E, "dān"},
    { 0x7C1F, "diàn"},
    { 0x7C20, "fǔ"},
    { 0x7C21, "jiǎn"},
    { 0x7C22, "mǐn"},
    { 0x7C23, "kuì"},
    { 0x7C24, "dài"},
    { 0x7C25, "jiāo"},
    { 0x7C26, "dēng"},
    { 0x7C27, "huáng"},
    { 0x7C28, "sǔn,zhuàn"},
    { 0x7C29, "láo"},
    { 0x7C2A, "zān,zǎn"},
    { 0x7C2B, "xiāo,xiǎo"},
    { 0x7C2C, "lù"},
    { 0x7C2D, "shì"},
    { 0x7C2E, "zān"},
    { 0x7C2F, "qi"},
    { 0x7C30, "pái"},
    { 0x7C31, "qí"},
    { 0x7C32, "pái"},
    { 0x7C33, "gǎn,gàn"},
    { 0x7C34, "jù"},
    { 0x7C35, "lù"},
    { 0x7C36, "lù"},
    { 0x7C37, "yán"},
    { 0x7C38, "bǒ,bò"},
    { 0x7C39, "dāng"},
    { 0x7C3A, "sài"},
    { 0x7C3B, "zhuā,kē"},
    { 0x7C3C, "gōu"},
    { 0x7C3D, "qiān"},
    { 0x7C3E, "lián"},
    { 0x7C3F, "bù,bó"},
    { 0x7C40, "zhòu"},
    { 0x7C41, "lài"},
    { 0x7C42, "shi"},
    { 0x7C43, "lán"},
    { 0x7C44, "kuì"},
    { 0x7C45, "yú"},
    { 0x7C46, "yuè"},
    { 0x7C47, "háo"},
    { 0x7C48, "zhēn,jiān"},
    { 0x7C49, "tái"},
    { 0x7C4A, "tì"},
    { 0x7C4B, "niè,mí"},
    { 0x7C4C, "chóu,táo"},
    { 0x7C4D, "jí,jiè"},
    { 0x7C4E, "yí"},
    { 0x7C4F, "qí"},
    { 0x7C50, "téng"},
    { 0x7C51, "zhuàn,zuǎn"},
    { 0x7C52, "zhòu"},
    { 0x7C53, "fān,bān,pān"},
    { 0x7C54, "sǒu,shǔ"},
    { 0x7C55, "zhòu"},
    { 0x7C56, "qian"},
    { 0x7C57, "zhuó"},
    { 0x7C58, "téng"},
    { 0x7C59, "lù"},
    { 0x7C5A, "lú"},
    { 0x7C5B, "jiǎn,jiān"},
    { 0x7C5C, "tuò"},
    { 0x7C5D, "yíng"},
    { 0x7C5E, "yù"},
    { 0x7C5F, "lài"},
    { 0x7C60, "lóng,lǒng"},
    { 0x7C61, "qiè"},
    { 0x7C62, "lián"},
    { 0x7C63, "lán"},
    { 0x7C64, "qiān"},
    { 0x7C65, "yuè"},
    { 0x7C66, "zhōng"},
    { 0x7C67, "qú,jǔ"},
    { 0x7C68, "lián"},
    { 0x7C69, "biān"},
    { 0x7C6A, "duàn"},
    { 0x7C6B, "zuǎn"},
    { 0x7C6C, "lí"},
    { 0x7C6D, "sī"},
    { 0x7C6E, "luó"},
    { 0x7C6F, "yíng"},
    { 0x7C70, "yuè"},
    { 0x7C71, "zhuó"},
    { 0x7C72, "yù"},
    { 0x7C73, "mǐ"},
    { 0x7C74, "dí,zá"},
    { 0x7C75, "fán"},
    { 0x7C76, "shēn"},
    { 0x7C77, "zhé"},
    { 0x7C78, "shēn"},
    { 0x7C79, "nǚ"},
    { 0x7C7A, "hé"},
    { 0x7C7B, "lèi"},
    { 0x7C7C, "xiān"},
    { 0x7C7D, "zǐ"},
    { 0x7C7E, "ní"},
    { 0x7C7F, "cùn"},
    { 0x7C80, "zhàng"},
    { 0x7C81, "qiān"},
    { 0x7C82, "zhāi"},
    { 0x7C83, "bǐ,pī"},
    { 0x7C84, "bǎn"},
    { 0x7C85, "wù"},
    { 0x7C86, "shā,chǎo"},
    { 0x7C87, "kāng,jīng"},
    { 0x7C88, "róu"},
    { 0x7C89, "fěn"},
    { 0x7C8A, "bì"},
    { 0x7C8B, "cuì"},
    { 0x7C8C, "yin"},
    { 0x7C8D, "zhé"},
    { 0x7C8E, "mǐ"},
    { 0x7C8F, "tai"},
    { 0x7C90, "hù"},
    { 0x7C91, "bā"},
    { 0x7C92, "lì"},
    { 0x7C93, "gān"},
    { 0x7C94, "jù"},
    { 0x7C95, "pò"},
    { 0x7C96, "mò"},
    { 0x7C97, "cū"},
    { 0x7C98, "zhān,nián"},
    { 0x7C99, "zhòu"},
    { 0x7C9A, "chī"},
    { 0x7C9B, "sù"},
    { 0x7C9C, "tiào"},
    { 0x7C9D, "lì"},
    { 0x7C9E, "xī"},
    { 0x7C9F, "sù"},
    { 0x7CA0, "hóng"},
    { 0x7CA1, "tóng"},
    { 0x7CA2, "zī,cí,jì"},
    { 0x7CA3, "cè,sè"},
    { 0x7CA4, "yuè"},
    { 0x7CA5, "zhōu,yù"},
    { 0x7CA6, "lín"},
    { 0x7CA7, "zhuāng"},
    { 0x7CA8, "bǎi"},
    { 0x7CA9, "lāo"},
    { 0x7CAA, "fèn"},
    { 0x7CAB, "ér"},
    { 0x7CAC, "qū"},
    { 0x7CAD, "hé"},
    { 0x7CAE, "liáng"},
    { 0x7CAF, "xiàn"},
    { 0x7CB0, "fú,fū"},
    { 0x7CB1, "liáng"},
    { 0x7CB2, "càn"},
    { 0x7CB3, "jīng"},
    { 0x7CB4, "lǐ"},
    { 0x7CB5, "yuè"},
    { 0x7CB6, "lù"},
    { 0x7CB7, "jú"},
    { 0x7CB8, "qí"},
    { 0x7CB9, "cuì,suì"},
    { 0x7CBA, "bài"},
    { 0x7CBB, "zhāng"},
    { 0x7CBC, "lín,lǐn"},
    { 0x7CBD, "zòng"},
    { 0x7CBE, "jīng,qíng,jìng"},
    { 0x7CBF, "guǒ,huà"},
    { 0x7CC0, "huā"},
    { 0x7CC1, "sǎn,shēn"},
    { 0x7CC2, "sǎn"},
    { 0x7CC3, "táng"},
    { 0x7CC4, "biǎn,biān"},
    { 0x7CC5, "róu"},
    { 0x7CC6, "miàn"},
    { 0x7CC7, "hóu"},
    { 0x7CC8, "xǔ"},
    { 0x7CC9, "zòng"},
    { 0x7CCA, "hú,hū,hù"},
    { 0x7CCB, "jiàn"},
    { 0x7CCC, "zān"},
    { 0x7CCD, "cí"},
    { 0x7CCE, "lí"},
    { 0x7CCF, "xiè"},
    { 0x7CD0, "fū"},
    { 0x7CD1, "nuò"},
    { 0x7CD2, "bèi"},
    { 0x7CD3, "gǔ"},
    { 0x7CD4, "xiǔ"},
    { 0x7CD5, "gāo"},
    { 0x7CD6, "táng"},
    { 0x7CD7, "qiǔ"},
    { 0x7CD8, "jiā"},
    { 0x7CD9, "cāo"},
    { 0x7CDA, "zhuāng"},
    { 0x7CDB, "táng"},
    { 0x7CDC, "mí,méi"},
    { 0x7CDD, "sǎn,sān,shēn"},
    { 0x7CDE, "fèn"},
    { 0x7CDF, "zāo"},
    { 0x7CE0, "kāng"},
    { 0x7CE1, "jiàng"},
    { 0x7CE2, "mó"},
    { 0x7CE3, "sǎn"},
    { 0x7CE4, "sǎn"},
    { 0x7CE5, "nuò"},
    { 0x7CE6, "xī"},
    { 0x7CE7, "liáng"},
    { 0x7CE8, "jiàng,jiāng"},
    { 0x7CE9, "kuài"},
    { 0x7CEA, "bò"},
    { 0x7CEB, "huán"},
    { 0x7CEC, "shǔ"},
    { 0x7CED, "zòng"},
    { 0x7CEE, "xiàn"},
    { 0x7CEF, "nuò"},
    { 0x7CF0, "tuán"},
    { 0x7CF1, "niè"},
    { 0x7CF2, "lì"},
    { 0x7CF3, "zuò"},
    { 0x7CF4, "dí"},
    { 0x7CF5, "niè"},
    { 0x7CF6, "tiào,diào"},
    { 0x7CF7, "làn"},
    { 0x7CF8, "mì,sī"},
    { 0x7CF9, "sī"},
    { 0x7CFA, "jiū,jiǔ"},
    { 0x7CFB, "xì,jì"},
    { 0x7CFC, "gōng"},
    { 0x7CFD, "zhěng,zhēng"},
    { 0x7CFE, "jiū,jiǎo"},
    { 0x7CFF, "yòu"},
    { 0x7D00, "jì,jǐ"},
    { 0x7D01, "chà"},
    { 0x7D02, "zhòu"},
    { 0x7D03, "xún"},
    { 0x7D04, "yuē,yāo,yào,dì"},
    { 0x7D05, "hóng,gōng,jiàng"},
    { 0x7D06, "yū,ōu"},
    { 0x7D07, "hé,gē,jié"},
    { 0x7D08, "wán"},
    { 0x7D09, "rèn"},
    { 0x7D0A, "wěn,wèn"},
    { 0x7D0B, "wén,wèn"},
    { 0x7D0C, "qiú"},
    { 0x7D0D, "nà"},
    { 0x7D0E, "zī"},
    { 0x7D0F, "tǒu"},
    { 0x7D10, "niǔ"},
    { 0x7D11, "fóu"},
    { 0x7D12, "jì,jié,jiè"},
    { 0x7D13, "shū"},
    { 0x7D14, "chún,zhǔn,tún,quán,zī,zhūn"},
    { 0x7D15, "pī,pí,bǐ,bī,bì,chǐ"},
    { 0x7D16, "zhèn"},
    { 0x7D17, "shā,miǎo"},
    { 0x7D18, "hóng"},
    { 0x7D19, "zhǐ"},
    { 0x7D1A, "jí"},
    { 0x7D1B, "fēn"},
    { 0x7D1C, "yún"},
    { 0x7D1D, "rèn"},
    { 0x7D1E, "dǎn"},
    { 0x7D1F, "jīn,jìn"},
    { 0x7D20, "sù"},
    { 0x7D21, "fǎng,bǎng,fàng"},
    { 0x7D22, "suǒ"},
    { 0x7D23, "cuì"},
    { 0x7D24, "jiǔ"},
    { 0x7D25, "zā,zhā"},
    { 0x7D26, "ba"},
    { 0x7D27, "jǐn"},
    { 0x7D28, "fū,fù"},
    { 0x7D29, "zhì"},
    { 0x7D2A, "qī"},
    { 0x7D2B, "zǐ"},
    { 0x7D2C, "chóu,chōu,zhòu"},
    { 0x7D2D, "hóng"},
    { 0x7D2E, "zā,zhā"},
    { 0x7D2F, "lèi,lěi,léi,lǜ,liè"},
    { 0x7D30, "xì"},
    { 0x7D31, "fú"},
    { 0x7D32, "xiè,yì"},
    { 0x7D33, "shēn"},
    { 0x7D34, "bō,bì"},
    { 0x7D35, "zhù,shū"},
    { 0x7D36, "qū,qǔ"},
    { 0x7D37, "líng"},
    { 0x7D38, "zhù"},
    { 0x7D39, "shào,chāo"},
    { 0x7D3A, "gàn"},
    { 0x7D3B, "yǎng"},
    { 0x7D3C, "fú,fèi"},
    { 0x7D3D, "tuó"},
    { 0x7D3E, "zhěn,tiǎn,jǐn"},
    { 0x7D3F, "dài"},
    { 0x7D40, "chù"},
    { 0x7D41, "shī"},
    { 0x7D42, "zhōng"},
    { 0x7D43, "xián,xuàn"},
    { 0x7D44, "zǔ,qū"},
    { 0x7D45, "jiōng,jiǒng"},
    { 0x7D46, "bàn"},
    { 0x7D47, "qú"},
    { 0x7D48, "mò"},
    { 0x7D49, "shù"},
    { 0x7D4A, "zuì"},
    { 0x7D4B, "kuàng"},
    { 0x7D4C, "jīng"},
    { 0x7D4D, "rèn"},
    { 0x7D4E, "háng"},
    { 0x7D4F, "xiè,yì"},
    { 0x7D50, "jié,jì,jiē"},
    { 0x7D51, "zhū"},
    { 0x7D52, "chóu"},
    { 0x7D53, "guà,kuā"},
    { 0x7D54, "bǎi,mò"},
    { 0x7D55, "jué"},
    { 0x7D56, "kuàng"},
    { 0x7D57, "hú"},
    { 0x7D58, "cì"},
    { 0x7D59, "huán,gēng"},
    { 0x7D5A, "gēng"},
    { 0x7D5B, "tāo"},
    { 0x7D5C, "jié,xié,qià,jiá,qì"},
    { 0x7D5D, "kù"},
    { 0x7D5E, "jiǎo,xiáo,jiào"},
    { 0x7D5F, "quán"},
    { 0x7D60, "gǎi,ǎi"},
    { 0x7D61, "luò,lào"},
    { 0x7D62, "xuàn,xún"},
    { 0x7D63, "bēng,bīng,pēng"},
    { 0x7D64, "xiàn"},
    { 0x7D65, "fú"},
    { 0x7D66, "gěi,jǐ,xiá"},
    { 0x7D67, "dòng,tóng,tōng"},
    { 0x7D68, "róng"},
    { 0x7D69, "tiào,diào,dào"},
    { 0x7D6A, "yīn"},
    { 0x7D6B, "lěi"},
    { 0x7D6C, "xiè"},
    { 0x7D6D, "juàn"},
    { 0x7D6E, "xù,chù,nǜ,nà"},
    { 0x7D6F, "gāi,hài"},
    { 0x7D70, "dié"},
    { 0x7D71, "tǒng"},
    { 0x7D72, "sī"},
    { 0x7D73, "jiàng"},
    { 0x7D74, "xiáng"},
    { 0x7D75, "huì"},
    { 0x7D76, "jué"},
    { 0x7D77, "zhí"},
    { 0x7D78, "jiǎn"},
    { 0x7D79, "juàn,xuàn"},
    { 0x7D7A, "chī,zhǐ"},
    { 0x7D7B, "miǎn,wèn,mán,wàn"},
    { 0x7D7C, "zhèn"},
    { 0x7D7D, "lǚ"},
    { 0x7D7E, "chéng"},
    { 0x7D7F, "qiú"},
    { 0x7D80, "shū"},
    { 0x7D81, "bǎng"},
    { 0x7D82, "tǒng"},
    { 0x7D83, "xiāo,shāo"},
    { 0x7D84, "huán,huàn,wàn"},
    { 0x7D85, "qīn,xiān"},
    { 0x7D86, "gěng,bǐng"},
    { 0x7D87, "xiǔ"},
    { 0x7D88, "tí,tì"},
    { 0x7D89, "tòu,xiù"},
    { 0x7D8A, "xié"},
    { 0x7D8B, "hóng"},
    { 0x7D8C, "xì"},
    { 0x7D8D, "fú"},
    { 0x7D8E, "tīng"},
    { 0x7D8F, "suī,suí,shuāi,ruí,tuǒ"},
    { 0x7D90, "duì"},
    { 0x7D91, "kǔn"},
    { 0x7D92, "fū"},
    { 0x7D93, "jīng,jìng"},
    { 0x7D94, "hù"},
    { 0x7D95, "zhī"},
    { 0x7D96, "yán,xiàn"},
    { 0x7D97, "jiǒng"},
    { 0x7D98, "féng"},
    { 0x7D99, "jì"},
    { 0x7D9A, "xù"},
    { 0x7D9B, "rěn"},
    { 0x7D9C, "zōng,zèng,zòng"},
    { 0x7D9D, "chēn,shēn,lín"},
    { 0x7D9E, "duǒ"},
    { 0x7D9F, "lì,liè"},
    { 0x7DA0, "lǜ"},
    { 0x7DA1, "liáng"},
    { 0x7DA2, "chóu,tāo,diào"},
    { 0x7DA3, "quǎn"},
    { 0x7DA4, "shào"},
    { 0x7DA5, "qí"},
    { 0x7DA6, "qí,qì"},
    { 0x7DA7, "zhǔn,zhùn"},
    { 0x7DA8, "qí"},
    { 0x7DA9, "wǎn"},
    { 0x7DAA, "qiàn,qīng,zhēng"},
    { 0x7DAB, "xiàn"},
    { 0x7DAC, "shòu"},
    { 0x7DAD, "wéi,yí"},
    { 0x7DAE, "qǐ,qìng,qǐng"},
    { 0x7DAF, "táo"},
    { 0x7DB0, "wǎn"},
    { 0x7DB1, "gāng"},
    { 0x7DB2, "wǎng"},
    { 0x7DB3, "bēng"},
    { 0x7DB4, "zhuì,chuò"},
    { 0x7DB5, "cǎi"},
    { 0x7DB6, "guǒ"},
    { 0x7DB7, "cuì,zú"},
    { 0x7DB8, "lún,guān"},
    { 0x7DB9, "liǔ"},
    { 0x7DBA, "qǐ,yǐ"},
    { 0x7DBB, "zhàn"},
    { 0x7DBC, "bì"},
    { 0x7DBD, "chuò,chāo"},
    { 0x7DBE, "líng"},
    { 0x7DBF, "mián"},
    { 0x7DC0, "qī"},
    { 0x7DC1, "qiè"},
    { 0x7DC2, "tián,tǎn,chān"},
    { 0x7DC3, "zōng"},
    { 0x7DC4, "gǔn,hùn,hún"},
    { 0x7DC5, "zōu"},
    { 0x7DC6, "xī"},
    { 0x7DC7, "zī"},
    { 0x7DC8, "xìng"},
    { 0x7DC9, "liǎng"},
    { 0x7DCA, "jǐn"},
    { 0x7DCB, "fēi"},
    { 0x7DCC, "ruí"},
    { 0x7DCD, "mín"},
    { 0x7DCE, "yù"},
    { 0x7DCF, "zǒng,cōng"},
    { 0x7DD0, "fán"},
    { 0x7DD1, "lǜ,lù"},
    { 0x7DD2, "xù"},
    { 0x7DD3, "yīng"},
    { 0x7DD4, "shàng"}
};
