/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     chenhaifeng  <chenhaifeng@uniontech.com>
*
* Maintainer: chenhaifeng  <chenhaifeng@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "pinyindict.h"

QMap<int, QString> PinyinDict_10{
    { 0x7DD5, "qi"},
    { 0x7DD6, "xù"},
    { 0x7DD7, "xiāng"},
    { 0x7DD8, "jiān"},
    { 0x7DD9, "kè"},
    { 0x7DDA, "xiàn"},
    { 0x7DDB, "ruǎn,ruàn"},
    { 0x7DDC, "mián"},
    { 0x7DDD, "jī,qì,qī,jí"},
    { 0x7DDE, "duàn"},
    { 0x7DDF, "chóng,zhòng"},
    { 0x7DE0, "dì"},
    { 0x7DE1, "mín,mǐn,mián,hún"},
    { 0x7DE2, "miáo,máo"},
    { 0x7DE3, "yuán,yuàn"},
    { 0x7DE4, "xiè,yè"},
    { 0x7DE5, "bǎo"},
    { 0x7DE6, "sī"},
    { 0x7DE7, "qiū"},
    { 0x7DE8, "biān,biǎn,biàn"},
    { 0x7DE9, "huǎn"},
    { 0x7DEA, "gēng,gèng"},
    { 0x7DEB, "cōng"},
    { 0x7DEC, "miǎn"},
    { 0x7DED, "wèi"},
    { 0x7DEE, "fù"},
    { 0x7DEF, "wěi"},
    { 0x7DF0, "tóu,xū,yú"},
    { 0x7DF1, "gōu"},
    { 0x7DF2, "miǎo"},
    { 0x7DF3, "xié"},
    { 0x7DF4, "liàn"},
    { 0x7DF5, "zōng,zòng"},
    { 0x7DF6, "biàn,pián,biǎn"},
    { 0x7DF7, "yùn,gǔn"},
    { 0x7DF8, "yīn"},
    { 0x7DF9, "tí"},
    { 0x7DFA, "guā"},
    { 0x7DFB, "zhì"},
    { 0x7DFC, "yùn,wēn"},
    { 0x7DFD, "chēng"},
    { 0x7DFE, "chán"},
    { 0x7DFF, "dài"},
    { 0x7E00, "xiá"},
    { 0x7E01, "yuán"},
    { 0x7E02, "zǒng"},
    { 0x7E03, "xū"},
    { 0x7E04, "shéng"},
    { 0x7E05, "wēi"},
    { 0x7E06, "gēng"},
    { 0x7E07, "xuān"},
    { 0x7E08, "yíng"},
    { 0x7E09, "jìn"},
    { 0x7E0A, "yì"},
    { 0x7E0B, "zhuì"},
    { 0x7E0C, "nì"},
    { 0x7E0D, "bāng,bàng"},
    { 0x7E0E, "gǔ,hú"},
    { 0x7E0F, "pán"},
    { 0x7E10, "zhòu,chào,cù,zhōu"},
    { 0x7E11, "jiān"},
    { 0x7E12, "cī,cuò,suǒ"},
    { 0x7E13, "quán"},
    { 0x7E14, "shuǎng"},
    { 0x7E15, "yùn"},
    { 0x7E16, "xiá"},
    { 0x7E17, "cuī,suī,shuāi"},
    { 0x7E18, "xī"},
    { 0x7E19, "róng,rǒng,ròng"},
    { 0x7E1A, "tāo"},
    { 0x7E1B, "fù"},
    { 0x7E1C, "yún"},
    { 0x7E1D, "chēn,zhěn"},
    { 0x7E1E, "gǎo"},
    { 0x7E1F, "rù,rǒng"},
    { 0x7E20, "hú"},
    { 0x7E21, "zài,zēng"},
    { 0x7E22, "téng"},
    { 0x7E23, "xiàn,xuán"},
    { 0x7E24, "sù"},
    { 0x7E25, "zhěn"},
    { 0x7E26, "zòng"},
    { 0x7E27, "tāo"},
    { 0x7E28, "huǎng"},
    { 0x7E29, "cài"},
    { 0x7E2A, "bì"},
    { 0x7E2B, "fèng,féng"},
    { 0x7E2C, "cù"},
    { 0x7E2D, "lí"},
    { 0x7E2E, "suō,sù"},
    { 0x7E2F, "yǎn,yǐn"},
    { 0x7E30, "xǐ"},
    { 0x7E31, "zòng,cóng,zǒng"},
    { 0x7E32, "léi"},
    { 0x7E33, "juàn,zhuàn"},
    { 0x7E34, "qiàn,qiān"},
    { 0x7E35, "màn"},
    { 0x7E36, "zhí"},
    { 0x7E37, "lǚ"},
    { 0x7E38, "mù,mò"},
    { 0x7E39, "piǎo,piāo"},
    { 0x7E3A, "lián"},
    { 0x7E3B, "mí"},
    { 0x7E3C, "xuàn"},
    { 0x7E3D, "zǒng,zōng,cōng"},
    { 0x7E3E, "jī"},
    { 0x7E3F, "shān,xiān,xiāo,sāo,cǎn"},
    { 0x7E40, "suì,cuǐ"},
    { 0x7E41, "fán,pán,pó"},
    { 0x7E42, "lǜ"},
    { 0x7E43, "běng,bēng,bèng"},
    { 0x7E44, "yī,yì"},
    { 0x7E45, "sāo,zǎo"},
    { 0x7E46, "móu,jiū,miù,mù,miào,liáo,liǎo,liào,lù"},
    { 0x7E47, "yáo,yóu,zhòu"},
    { 0x7E48, "qiǎng"},
    { 0x7E49, "hún"},
    { 0x7E4A, "xiān"},
    { 0x7E4B, "jì"},
    { 0x7E4C, "sha"},
    { 0x7E4D, "xiù"},
    { 0x7E4E, "rán"},
    { 0x7E4F, "xuàn"},
    { 0x7E50, "suì"},
    { 0x7E51, "qiāo,juē"},
    { 0x7E52, "zēng,zèng,céng"},
    { 0x7E53, "zuǒ"},
    { 0x7E54, "zhī,zhì"},
    { 0x7E55, "shàn"},
    { 0x7E56, "sǎn"},
    { 0x7E57, "lín"},
    { 0x7E58, "yù,jué"},
    { 0x7E59, "fān,fán"},
    { 0x7E5A, "liáo,rǎo"},
    { 0x7E5B, "chuò"},
    { 0x7E5C, "zūn"},
    { 0x7E5D, "jiàn"},
    { 0x7E5E, "rào,rǎo"},
    { 0x7E5F, "chǎn,chán"},
    { 0x7E60, "ruǐ"},
    { 0x7E61, "xiù"},
    { 0x7E62, "huì,huí"},
    { 0x7E63, "huà"},
    { 0x7E64, "zuǎn"},
    { 0x7E65, "xī"},
    { 0x7E66, "qiǎng"},
    { 0x7E67, "yun"},
    { 0x7E68, "da"},
    { 0x7E69, "shéng,yìng,mǐn,shèng"},
    { 0x7E6A, "huì,guì"},
    { 0x7E6B, "xì,jì"},
    { 0x7E6C, "sè"},
    { 0x7E6D, "jiǎn"},
    { 0x7E6E, "jiāng"},
    { 0x7E6F, "huán"},
    { 0x7E70, "zǎo,sāo,qiāo"},
    { 0x7E71, "cōng"},
    { 0x7E72, "xiè"},
    { 0x7E73, "jiǎo,zhuó,jiào,hé"},
    { 0x7E74, "bì"},
    { 0x7E75, "dàn,tán,chán"},
    { 0x7E76, "yì"},
    { 0x7E77, "nǒng"},
    { 0x7E78, "suì"},
    { 0x7E79, "yì,shì"},
    { 0x7E7A, "shǎi"},
    { 0x7E7B, "xū,rú"},
    { 0x7E7C, "jì"},
    { 0x7E7D, "bīn"},
    { 0x7E7E, "qiǎn"},
    { 0x7E7F, "lán"},
    { 0x7E80, "pú,fú"},
    { 0x7E81, "xūn"},
    { 0x7E82, "zuǎn"},
    { 0x7E83, "qí"},
    { 0x7E84, "péng"},
    { 0x7E85, "yào,lì"},
    { 0x7E86, "mò"},
    { 0x7E87, "lèi"},
    { 0x7E88, "xié"},
    { 0x7E89, "zuǎn"},
    { 0x7E8A, "kuàng"},
    { 0x7E8B, "yōu"},
    { 0x7E8C, "xù"},
    { 0x7E8D, "léi,lěi,lèi"},
    { 0x7E8E, "xiān"},
    { 0x7E8F, "chán"},
    { 0x7E90, "jiǎo"},
    { 0x7E91, "lú"},
    { 0x7E92, "chán"},
    { 0x7E93, "yīng"},
    { 0x7E94, "cái,shān"},
    { 0x7E95, "rǎng,xiāng,sāng"},
    { 0x7E96, "xiān,jiān"},
    { 0x7E97, "zuī"},
    { 0x7E98, "zuǎn"},
    { 0x7E99, "luò"},
    { 0x7E9A, "lí,xǐ,lǐ,sǎ"},
    { 0x7E9B, "dào,dú"},
    { 0x7E9C, "lǎn"},
    { 0x7E9D, "léi"},
    { 0x7E9E, "liàn"},
    { 0x7E9F, "sī"},
    { 0x7EA0, "jiū"},
    { 0x7EA1, "yū"},
    { 0x7EA2, "hóng,gōng"},
    { 0x7EA3, "zhòu"},
    { 0x7EA4, "xiān,qiàn"},
    { 0x7EA5, "gē,hé"},
    { 0x7EA6, "yuē,yāo"},
    { 0x7EA7, "jí"},
    { 0x7EA8, "wán"},
    { 0x7EA9, "kuàng"},
    { 0x7EAA, "jì,jǐ"},
    { 0x7EAB, "rèn"},
    { 0x7EAC, "wěi"},
    { 0x7EAD, "yún"},
    { 0x7EAE, "hóng"},
    { 0x7EAF, "chún"},
    { 0x7EB0, "pī"},
    { 0x7EB1, "shā"},
    { 0x7EB2, "gāng"},
    { 0x7EB3, "nà"},
    { 0x7EB4, "rèn"},
    { 0x7EB5, "zòng"},
    { 0x7EB6, "lún,guān"},
    { 0x7EB7, "fēn"},
    { 0x7EB8, "zhǐ"},
    { 0x7EB9, "wén,wèn"},
    { 0x7EBA, "fǎng"},
    { 0x7EBB, "zhù"},
    { 0x7EBC, "zhèn"},
    { 0x7EBD, "niǔ"},
    { 0x7EBE, "shū"},
    { 0x7EBF, "xiàn"},
    { 0x7EC0, "gàn"},
    { 0x7EC1, "xiè"},
    { 0x7EC2, "fú"},
    { 0x7EC3, "liàn"},
    { 0x7EC4, "zǔ"},
    { 0x7EC5, "shēn"},
    { 0x7EC6, "xì"},
    { 0x7EC7, "zhī"},
    { 0x7EC8, "zhōng"},
    { 0x7EC9, "zhòu"},
    { 0x7ECA, "bàn"},
    { 0x7ECB, "fú"},
    { 0x7ECC, "chù"},
    { 0x7ECD, "shào"},
    { 0x7ECE, "yì"},
    { 0x7ECF, "jīng,jìng"},
    { 0x7ED0, "dài"},
    { 0x7ED1, "bǎng"},
    { 0x7ED2, "róng"},
    { 0x7ED3, "jié,jiē"},
    { 0x7ED4, "kù"},
    { 0x7ED5, "rào,rǎo"},
    { 0x7ED6, "dié"},
    { 0x7ED7, "háng"},
    { 0x7ED8, "huì"},
    { 0x7ED9, "gěi,jǐ"},
    { 0x7EDA, "xuàn"},
    { 0x7EDB, "jiàng"},
    { 0x7EDC, "luò,lào"},
    { 0x7EDD, "jué"},
    { 0x7EDE, "jiǎo"},
    { 0x7EDF, "tǒng"},
    { 0x7EE0, "gěng"},
    { 0x7EE1, "xiāo"},
    { 0x7EE2, "juàn"},
    { 0x7EE3, "xiù"},
    { 0x7EE4, "xì"},
    { 0x7EE5, "suí"},
    { 0x7EE6, "tāo"},
    { 0x7EE7, "jì"},
    { 0x7EE8, "tí,tì"},
    { 0x7EE9, "jī"},
    { 0x7EEA, "xù"},
    { 0x7EEB, "líng"},
    { 0x7EEC, "yīng"},
    { 0x7EED, "xù"},
    { 0x7EEE, "qǐ"},
    { 0x7EEF, "fēi"},
    { 0x7EF0, "chuò,chāo"},
    { 0x7EF1, "shàng"},
    { 0x7EF2, "gǔn"},
    { 0x7EF3, "shéng"},
    { 0x7EF4, "wéi"},
    { 0x7EF5, "mián"},
    { 0x7EF6, "shòu"},
    { 0x7EF7, "bēng,běng,bèng"},
    { 0x7EF8, "chóu"},
    { 0x7EF9, "táo"},
    { 0x7EFA, "liǔ"},
    { 0x7EFB, "quǎn"},
    { 0x7EFC, "zōng,zèng"},
    { 0x7EFD, "zhàn"},
    { 0x7EFE, "wǎn"},
    { 0x7EFF, "lǜ,lù"},
    { 0x7F00, "zhuì"},
    { 0x7F01, "zī"},
    { 0x7F02, "kè"},
    { 0x7F03, "xiāng"},
    { 0x7F04, "jiān"},
    { 0x7F05, "miǎn"},
    { 0x7F06, "lǎn"},
    { 0x7F07, "tí"},
    { 0x7F08, "miǎo"},
    { 0x7F09, "jī,qī"},
    { 0x7F0A, "yūn,yùn"},
    { 0x7F0B, "huì"},
    { 0x7F0C, "sī"},
    { 0x7F0D, "duǒ"},
    { 0x7F0E, "duàn"},
    { 0x7F0F, "biàn,pián"},
    { 0x7F10, "xiàn"},
    { 0x7F11, "gōu"},
    { 0x7F12, "zhuì"},
    { 0x7F13, "huǎn"},
    { 0x7F14, "dì"},
    { 0x7F15, "lǚ"},
    { 0x7F16, "biān"},
    { 0x7F17, "mín"},
    { 0x7F18, "yuán"},
    { 0x7F19, "jìn"},
    { 0x7F1A, "fù"},
    { 0x7F1B, "rù"},
    { 0x7F1C, "zhěn"},
    { 0x7F1D, "fèng,féng"},
    { 0x7F1E, "cuī"},
    { 0x7F1F, "gǎo"},
    { 0x7F20, "chán"},
    { 0x7F21, "lí"},
    { 0x7F22, "yì"},
    { 0x7F23, "jiān"},
    { 0x7F24, "bīn"},
    { 0x7F25, "piāo,piǎo"},
    { 0x7F26, "màn"},
    { 0x7F27, "léi"},
    { 0x7F28, "yīng"},
    { 0x7F29, "suō,sù"},
    { 0x7F2A, "móu,miào,miù"},
    { 0x7F2B, "sāo"},
    { 0x7F2C, "xié"},
    { 0x7F2D, "liáo"},
    { 0x7F2E, "shàn"},
    { 0x7F2F, "zēng,zèng"},
    { 0x7F30, "jiāng"},
    { 0x7F31, "qiǎn"},
    { 0x7F32, "qiāo,sāo"},
    { 0x7F33, "huán"},
    { 0x7F34, "jiǎo,zhuó"},
    { 0x7F35, "zuǎn"},
    { 0x7F36, "fǒu"},
    { 0x7F37, "xiè"},
    { 0x7F38, "gāng"},
    { 0x7F39, "fǒu"},
    { 0x7F3A, "quē,kuǐ"},
    { 0x7F3B, "fǒu"},
    { 0x7F3C, "qi"},
    { 0x7F3D, "bō"},
    { 0x7F3E, "píng"},
    { 0x7F3F, "xiàng"},
    { 0x7F40, "zhao"},
    { 0x7F41, "gāng"},
    { 0x7F42, "yīng"},
    { 0x7F43, "yīng"},
    { 0x7F44, "qìng"},
    { 0x7F45, "xià"},
    { 0x7F46, "guàn"},
    { 0x7F47, "zūn"},
    { 0x7F48, "tán"},
    { 0x7F49, "chēng"},
    { 0x7F4A, "qì"},
    { 0x7F4B, "wèng"},
    { 0x7F4C, "yīng"},
    { 0x7F4D, "léi"},
    { 0x7F4E, "tán"},
    { 0x7F4F, "lú"},
    { 0x7F50, "guàn"},
    { 0x7F51, "wǎng"},
    { 0x7F52, "wǎng"},
    { 0x7F53, "gāng"},
    { 0x7F54, "wǎng,wáng"},
    { 0x7F55, "hǎn,hàn"},
    { 0x7F56, "luó"},
    { 0x7F57, "luó"},
    { 0x7F58, "fú"},
    { 0x7F59, "shēn"},
    { 0x7F5A, "fá"},
    { 0x7F5B, "gū"},
    { 0x7F5C, "zhǔ,dú"},
    { 0x7F5D, "jū,jiē"},
    { 0x7F5E, "máo"},
    { 0x7F5F, "gǔ"},
    { 0x7F60, "mín"},
    { 0x7F61, "gāng"},
    { 0x7F62, "bà,ba"},
    { 0x7F63, "guà"},
    { 0x7F64, "tí,kūn"},
    { 0x7F65, "juàn"},
    { 0x7F66, "fú"},
    { 0x7F67, "shèn"},
    { 0x7F68, "yǎn"},
    { 0x7F69, "zhào"},
    { 0x7F6A, "zuì"},
    { 0x7F6B, "guà,huà,guǎi"},
    { 0x7F6C, "zhuó"},
    { 0x7F6D, "yù"},
    { 0x7F6E, "zhì"},
    { 0x7F6F, "ǎn"},
    { 0x7F70, "fá"},
    { 0x7F71, "lǎn,nǎn"},
    { 0x7F72, "shǔ"},
    { 0x7F73, "sī"},
    { 0x7F74, "pí"},
    { 0x7F75, "mà"},
    { 0x7F76, "liǔ"},
    { 0x7F77, "bà,pí,pì,bǐ,ba,bǎi"},
    { 0x7F78, "fá"},
    { 0x7F79, "lí"},
    { 0x7F7A, "cháo"},
    { 0x7F7B, "wèi"},
    { 0x7F7C, "bì"},
    { 0x7F7D, "jì"},
    { 0x7F7E, "zēng"},
    { 0x7F7F, "chōng"},
    { 0x7F80, "liǔ"},
    { 0x7F81, "jī"},
    { 0x7F82, "juàn"},
    { 0x7F83, "mì"},
    { 0x7F84, "zhào"},
    { 0x7F85, "luó,luō,luo"},
    { 0x7F86, "pí"},
    { 0x7F87, "jī"},
    { 0x7F88, "jī"},
    { 0x7F89, "luán"},
    { 0x7F8A, "yáng"},
    { 0x7F8B, "mǐ,miē"},
    { 0x7F8C, "qiāng"},
    { 0x7F8D, "dá"},
    { 0x7F8E, "měi"},
    { 0x7F8F, "yáng,xiáng"},
    { 0x7F90, "yǒu"},
    { 0x7F91, "yǒu"},
    { 0x7F92, "fén"},
    { 0x7F93, "bā"},
    { 0x7F94, "gāo"},
    { 0x7F95, "yàng"},
    { 0x7F96, "gǔ"},
    { 0x7F97, "qiāng,yǒu"},
    { 0x7F98, "zāng"},
    { 0x7F99, "gāo,měi"},
    { 0x7F9A, "líng"},
    { 0x7F9B, "yì,xī"},
    { 0x7F9C, "zhù"},
    { 0x7F9D, "dī"},
    { 0x7F9E, "xiū"},
    { 0x7F9F, "qiǎng"},
    { 0x7FA0, "yí"},
    { 0x7FA1, "xiàn,yán,yí"},
    { 0x7FA2, "róng"},
    { 0x7FA3, "qún"},
    { 0x7FA4, "qún"},
    { 0x7FA5, "qiǎng,qiān"},
    { 0x7FA6, "huán"},
    { 0x7FA7, "suō,zuī"},
    { 0x7FA8, "xiàn"},
    { 0x7FA9, "yì,yí,xī"},
    { 0x7FAA, "yang"},
    { 0x7FAB, "qiāng,kàng"},
    { 0x7FAC, "qián,xián,yán"},
    { 0x7FAD, "yú"},
    { 0x7FAE, "gēng"},
    { 0x7FAF, "jié"},
    { 0x7FB0, "tāng"},
    { 0x7FB1, "yuán"},
    { 0x7FB2, "xī"},
    { 0x7FB3, "fán"},
    { 0x7FB4, "shān"},
    { 0x7FB5, "fén"},
    { 0x7FB6, "shān"},
    { 0x7FB7, "liǎn"},
    { 0x7FB8, "léi,lián"},
    { 0x7FB9, "gēng,láng"},
    { 0x7FBA, "nóu"},
    { 0x7FBB, "qiàng"},
    { 0x7FBC, "chàn"},
    { 0x7FBD, "yǔ,hù"},
    { 0x7FBE, "gòng"},
    { 0x7FBF, "yì"},
    { 0x7FC0, "chōng"},
    { 0x7FC1, "wēng,wěng"},
    { 0x7FC2, "fēn"},
    { 0x7FC3, "hóng"},
    { 0x7FC4, "chì"},
    { 0x7FC5, "chì"},
    { 0x7FC6, "cuì"},
    { 0x7FC7, "fú"},
    { 0x7FC8, "xiá"},
    { 0x7FC9, "běn"},
    { 0x7FCA, "yì"},
    { 0x7FCB, "lā"},
    { 0x7FCC, "yì"},
    { 0x7FCD, "pī,bì,pō"},
    { 0x7FCE, "líng"},
    { 0x7FCF, "liù,lù"},
    { 0x7FD0, "zhì"},
    { 0x7FD1, "qú"},
    { 0x7FD2, "xí"},
    { 0x7FD3, "xié"},
    { 0x7FD4, "xiáng"},
    { 0x7FD5, "xī"},
    { 0x7FD6, "xī"},
    { 0x7FD7, "ké"},
    { 0x7FD8, "qiào,qiáo"},
    { 0x7FD9, "huì"},
    { 0x7FDA, "huī"},
    { 0x7FDB, "xiāo,shū"},
    { 0x7FDC, "shà"},
    { 0x7FDD, "hóng"},
    { 0x7FDE, "jiāng"},
    { 0x7FDF, "dí,zhái"},
    { 0x7FE0, "cuì"},
    { 0x7FE1, "fěi"},
    { 0x7FE2, "dào,zhōu"},
    { 0x7FE3, "shà"},
    { 0x7FE4, "chì"},
    { 0x7FE5, "zhù"},
    { 0x7FE6, "jiǎn"},
    { 0x7FE7, "xuān"},
    { 0x7FE8, "chì"},
    { 0x7FE9, "piān"},
    { 0x7FEA, "zōng"},
    { 0x7FEB, "wán,wàn"},
    { 0x7FEC, "huī"},
    { 0x7FED, "hóu"},
    { 0x7FEE, "hé,lì"},
    { 0x7FEF, "hè,hào"},
    { 0x7FF0, "hàn"},
    { 0x7FF1, "áo"},
    { 0x7FF2, "piāo"},
    { 0x7FF3, "yì"},
    { 0x7FF4, "lián"},
    { 0x7FF5, "hóu,qú"},
    { 0x7FF6, "áo"},
    { 0x7FF7, "lín"},
    { 0x7FF8, "pěn"},
    { 0x7FF9, "qiào,qiáo"},
    { 0x7FFA, "áo"},
    { 0x7FFB, "fān"},
    { 0x7FFC, "yì"},
    { 0x7FFD, "huì"},
    { 0x7FFE, "xuān"},
    { 0x7FFF, "dào"},
    { 0x8000, "yào"},
    { 0x8001, "lǎo"},
    { 0x8002, "lǎo"},
    { 0x8003, "kǎo"},
    { 0x8004, "mào"},
    { 0x8005, "zhě"},
    { 0x8006, "qí,zhǐ,shì"},
    { 0x8007, "gǒu"},
    { 0x8008, "gǒu"},
    { 0x8009, "gǒu"},
    { 0x800A, "dié"},
    { 0x800B, "dié"},
    { 0x800C, "ér,néng"},
    { 0x800D, "shuǎ"},
    { 0x800E, "ruǎn,nuò"},
    { 0x800F, "nài,ér"},
    { 0x8010, "nài,néng"},
    { 0x8011, "duān,zhuān"},
    { 0x8012, "lěi"},
    { 0x8013, "tīng"},
    { 0x8014, "zǐ"},
    { 0x8015, "gēng"},
    { 0x8016, "chào"},
    { 0x8017, "hào,máo,mào"},
    { 0x8018, "yún"},
    { 0x8019, "bà,pá"},
    { 0x801A, "pī"},
    { 0x801B, "yí,chí"},
    { 0x801C, "sì"},
    { 0x801D, "qù,chú"},
    { 0x801E, "jiā"},
    { 0x801F, "jù"},
    { 0x8020, "huō"},
    { 0x8021, "chú"},
    { 0x8022, "lào"},
    { 0x8023, "lǔn,lún"},
    { 0x8024, "jí,jiè"},
    { 0x8025, "tāng,tǎng"},
    { 0x8026, "ǒu"},
    { 0x8027, "lóu"},
    { 0x8028, "nòu"},
    { 0x8029, "jiǎng"},
    { 0x802A, "pǎng"},
    { 0x802B, "zhá,zé"},
    { 0x802C, "lóu,lǒu"},
    { 0x802D, "jī"},
    { 0x802E, "lào"},
    { 0x802F, "huò"},
    { 0x8030, "yōu"},
    { 0x8031, "mò"},
    { 0x8032, "huái"},
    { 0x8033, "ěr,réng"},
    { 0x8034, "yì"},
    { 0x8035, "dīng"},
    { 0x8036, "yé,xié,yē"},
    { 0x8037, "dā,zhé"},
    { 0x8038, "sǒng"},
    { 0x8039, "qín"},
    { 0x803A, "yún,yíng"},
    { 0x803B, "chǐ"},
    { 0x803C, "dān"},
    { 0x803D, "dān"},
    { 0x803E, "hóng"},
    { 0x803F, "gěng"},
    { 0x8040, "zhí"},
    { 0x8041, "pàn"},
    { 0x8042, "niè"},
    { 0x8043, "dān"},
    { 0x8044, "zhěn"},
    { 0x8045, "chè"},
    { 0x8046, "líng"},
    { 0x8047, "zhēng"},
    { 0x8048, "yǒu"},
    { 0x8049, "wà,tuǐ,zhuó"},
    { 0x804A, "liáo,liú"},
    { 0x804B, "lóng"},
    { 0x804C, "zhí"},
    { 0x804D, "níng"},
    { 0x804E, "tiāo"},
    { 0x804F, "ér,nǜ"},
    { 0x8050, "yà"},
    { 0x8051, "tiē,zhé"},
    { 0x8052, "guā,guō"},
    { 0x8053, "xù"},
    { 0x8054, "lián"},
    { 0x8055, "hào"},
    { 0x8056, "shèng"},
    { 0x8057, "liè"},
    { 0x8058, "pìn,pìng"},
    { 0x8059, "jīng"},
    { 0x805A, "jù"},
    { 0x805B, "bǐ"},
    { 0x805C, "dǐ"},
    { 0x805D, "guó"},
    { 0x805E, "wén,wèn"},
    { 0x805F, "xù"},
    { 0x8060, "pīng"},
    { 0x8061, "cōng"},
    { 0x8062, "dìng"},
    { 0x8063, "ní"},
    { 0x8064, "tíng"},
    { 0x8065, "jǔ"},
    { 0x8066, "cōng"},
    { 0x8067, "kuī"},
    { 0x8068, "lián"},
    { 0x8069, "kuì"},
    { 0x806A, "cōng"},
    { 0x806B, "lián"},
    { 0x806C, "wěng"},
    { 0x806D, "kuì"},
    { 0x806E, "lián"},
    { 0x806F, "lián"},
    { 0x8070, "cōng"},
    { 0x8071, "áo,yóu"},
    { 0x8072, "shēng"},
    { 0x8073, "sǒng"},
    { 0x8074, "tīng"},
    { 0x8075, "kuì"},
    { 0x8076, "niè,zhé,shè,yè"},
    { 0x8077, "zhí,tè"},
    { 0x8078, "dān"},
    { 0x8079, "níng"},
    { 0x807A, "qié"},
    { 0x807B, "nǐ,jiàn"},
    { 0x807C, "tīng"},
    { 0x807D, "tīng,tìng"},
    { 0x807E, "lóng"},
    { 0x807F, "yù"},
    { 0x8080, "yù"},
    { 0x8081, "zhào"},
    { 0x8082, "sì"},
    { 0x8083, "sù"},
    { 0x8084, "yì,sì"},
    { 0x8085, "sù"},
    { 0x8086, "sì,tì"},
    { 0x8087, "zhào"},
    { 0x8088, "zhào"},
    { 0x8089, "ròu,rù"},
    { 0x808A, "yì"},
    { 0x808B, "lē,lèi,jīn"},
    { 0x808C, "jī,jì"},
    { 0x808D, "qiú"},
    { 0x808E, "kěn"},
    { 0x808F, "cào"},
    { 0x8090, "gē,qì"},
    { 0x8091, "bó,dí"},
    { 0x8092, "huàn"},
    { 0x8093, "huāng"},
    { 0x8094, "chǐ"},
    { 0x8095, "rèn"},
    { 0x8096, "xiào,xiāo"},
    { 0x8097, "rǔ"},
    { 0x8098, "zhǒu"},
    { 0x8099, "yuàn"},
    { 0x809A, "dù,dǔ"},
    { 0x809B, "gāng"},
    { 0x809C, "róng,chēn"},
    { 0x809D, "gān"},
    { 0x809E, "chā"},
    { 0x809F, "wò"},
    { 0x80A0, "cháng"},
    { 0x80A1, "gǔ"},
    { 0x80A2, "zhī,shì"},
    { 0x80A3, "hán,hàn,qín"},
    { 0x80A4, "fū"},
    { 0x80A5, "féi,bǐ"},
    { 0x80A6, "fén"},
    { 0x80A7, "pēi"},
    { 0x80A8, "pàng,pāng,fēng"},
    { 0x80A9, "jiān,xián"},
    { 0x80AA, "fáng"},
    { 0x80AB, "zhūn,chún,tún,zhuō"},
    { 0x80AC, "yóu"},
    { 0x80AD, "nà,nù"},
    { 0x80AE, "āng,háng,gāng"},
    { 0x80AF, "kěn"},
    { 0x80B0, "rán"},
    { 0x80B1, "gōng"},
    { 0x80B2, "yù,zhòu,yō"},
    { 0x80B3, "wěn"},
    { 0x80B4, "yáo"},
    { 0x80B5, "qí"},
    { 0x80B6, "pí,bì"},
    { 0x80B7, "qiǎn,xù"},
    { 0x80B8, "xī,bì"},
    { 0x80B9, "xī"},
    { 0x80BA, "fèi,pèi"},
    { 0x80BB, "kěn"},
    { 0x80BC, "jǐng"},
    { 0x80BD, "tài"},
    { 0x80BE, "shèn"},
    { 0x80BF, "zhǒng"},
    { 0x80C0, "zhàng"},
    { 0x80C1, "xié"},
    { 0x80C2, "shèn,shēn,chēn"},
    { 0x80C3, "wèi"},
    { 0x80C4, "zhòu"},
    { 0x80C5, "dié"},
    { 0x80C6, "dǎn,tán,tǎn,dá"},
    { 0x80C7, "fèi,bì,fěi"},
    { 0x80C8, "bá"},
    { 0x80C9, "bó"},
    { 0x80CA, "qú"},
    { 0x80CB, "tián"},
    { 0x80CC, "bèi,bēi"},
    { 0x80CD, "guā,gū,hù"},
    { 0x80CE, "tāi"},
    { 0x80CF, "zǐ,fèi"},
    { 0x80D0, "fěi"},
    { 0x80D1, "zhī"},
    { 0x80D2, "nì"},
    { 0x80D3, "píng,pēng"},
    { 0x80D4, "zì,cí,jí"},
    { 0x80D5, "fǔ,fū,fú,zhǒu"},
    { 0x80D6, "pàng,pàn,pán"},
    { 0x80D7, "zhēn,zhěn,zhūn"},
    { 0x80D8, "xián"},
    { 0x80D9, "zuò"},
    { 0x80DA, "pēi"},
    { 0x80DB, "jiǎ"},
    { 0x80DC, "shèng,xīng,qìng,shēng"},
    { 0x80DD, "zhī,chī,dì"},
    { 0x80DE, "bāo,páo,pào"},
    { 0x80DF, "mǔ"},
    { 0x80E0, "qū"},
    { 0x80E1, "hú"},
    { 0x80E2, "kē"},
    { 0x80E3, "chǐ"},
    { 0x80E4, "yìn"},
    { 0x80E5, "xū,xǔ"},
    { 0x80E6, "yāng"},
    { 0x80E7, "lóng"},
    { 0x80E8, "dòng"},
    { 0x80E9, "kǎ"},
    { 0x80EA, "lú"},
    { 0x80EB, "jìng"},
    { 0x80EC, "nǔ,nǚ"},
    { 0x80ED, "yān"},
    { 0x80EE, "pāng"},
    { 0x80EF, "kuà,kuǎ"},
    { 0x80F0, "yí"},
    { 0x80F1, "guāng"},
    { 0x80F2, "hǎi,gāi,gǎi"},
    { 0x80F3, "gē,gé,gā"},
    { 0x80F4, "dòng"},
    { 0x80F5, "chī,zhì"},
    { 0x80F6, "jiāo,xiáo"},
    { 0x80F7, "xiōng"},
    { 0x80F8, "xiōng"},
    { 0x80F9, "ér"},
    { 0x80FA, "àn,è"},
    { 0x80FB, "héng"},
    { 0x80FC, "pián"},
    { 0x80FD, "néng,tái,nái,nài,xióng"},
    { 0x80FE, "zì"},
    { 0x80FF, "guī,kuì"},
    { 0x8100, "chéng,zhēng,zhèng"},
    { 0x8101, "tiǎo"},
    { 0x8102, "zhī,zhǐ"},
    { 0x8103, "cuì"},
    { 0x8104, "méi"},
    { 0x8105, "xié,xiàn,xī"},
    { 0x8106, "cuì"},
    { 0x8107, "xié"},
    { 0x8108, "mài,mò"},
    { 0x8109, "mài,mò"},
    { 0x810A, "jí,jǐ"},
    { 0x810B, "xié"},
    { 0x810C, "nin"},
    { 0x810D, "kuài"},
    { 0x810E, "sà"},
    { 0x810F, "zàng,zāng"},
    { 0x8110, "qí"},
    { 0x8111, "nǎo"},
    { 0x8112, "mǐ"},
    { 0x8113, "nóng"},
    { 0x8114, "luán,jī"},
    { 0x8115, "wàn,wèn"},
    { 0x8116, "bó,bō"},
    { 0x8117, "wěn"},
    { 0x8118, "wǎn,huàn"},
    { 0x8119, "xiū"},
    { 0x811A, "jiǎo,jué"},
    { 0x811B, "jìng,kēng"},
    { 0x811C, "yǒu"},
    { 0x811D, "hēng"},
    { 0x811E, "cuǒ,qiē"},
    { 0x811F, "liè,luán,pāo"},
    { 0x8120, "shān,chān"},
    { 0x8121, "tǐng"},
    { 0x8122, "méi"},
    { 0x8123, "chún"},
    { 0x8124, "shèn"},
    { 0x8125, "qiǎn,qū,jié"},
    { 0x8126, "de,tè,te"},
    { 0x8127, "juān,zuī"},
    { 0x8128, "cù,jí"},
    { 0x8129, "xiū,yǒu,tiáo,xiāo"},
    { 0x812A, "xìn,chī"},
    { 0x812B, "tuō"},
    { 0x812C, "pāo"},
    { 0x812D, "chéng"},
    { 0x812E, "něi,tuǐ"},
    { 0x812F, "pú,fǔ"},
    { 0x8130, "dòu"},
    { 0x8131, "tuō,tuì"},
    { 0x8132, "niào"},
    { 0x8133, "nǎo"},
    { 0x8134, "pǐ"},
    { 0x8135, "gǔ"},
    { 0x8136, "luó"},
    { 0x8137, "lì"},
    { 0x8138, "liǎn"},
    { 0x8139, "zhàng,cháng"},
    { 0x813A, "cuì,suì"},
    { 0x813B, "jiē"},
    { 0x813C, "liǎng,lǎng"},
    { 0x813D, "shuí"},
    { 0x813E, "pí,pái,bì,pì"},
    { 0x813F, "biāo,biào,biǎo"},
    { 0x8140, "lún"},
    { 0x8141, "pián"},
    { 0x8142, "lěi,guò,huà"},
    { 0x8143, "kuì,quān,quán,juàn"},
    { 0x8144, "chuí,hóu,chuái"},
    { 0x8145, "dàn"},
    { 0x8146, "tiǎn"},
    { 0x8147, "něi"},
    { 0x8148, "jīng"},
    { 0x8149, "nái"},
    { 0x814A, "là,xī"},
    { 0x814B, "yè"},
    { 0x814C, "yān,ā,āng"},
    { 0x814D, "rèn,diàn"},
    { 0x814E, "shèn"},
    { 0x814F, "chuò,zhuì"},
    { 0x8150, "fǔ"},
    { 0x8151, "fǔ"},
    { 0x8152, "jū"},
    { 0x8153, "féi"},
    { 0x8154, "qiāng,kòng"},
    { 0x8155, "wàn"},
    { 0x8156, "dòng"},
    { 0x8157, "pí"},
    { 0x8158, "guó"},
    { 0x8159, "zōng"},
    { 0x815A, "dìng"},
    { 0x815B, "wò"},
    { 0x815C, "méi"},
    { 0x815D, "ní,ruǎn,nào,nèn,ér"},
    { 0x815E, "zhuàn,dùn,tú"},
    { 0x815F, "chì"},
    { 0x8160, "còu"},
    { 0x8161, "luó"},
    { 0x8162, "ǒu"},
    { 0x8163, "dì"},
    { 0x8164, "ān"},
    { 0x8165, "xīng"},
    { 0x8166, "nǎo,nào"},
    { 0x8167, "shù,yú"},
    { 0x8168, "shuàn"},
    { 0x8169, "nǎn"},
    { 0x816A, "yùn"},
    { 0x816B, "zhǒng"},
    { 0x816C, "róu"},
    { 0x816D, "è"},
    { 0x816E, "sāi"},
    { 0x816F, "tú,dùn"},
    { 0x8170, "yāo"},
    { 0x8171, "jiàn,qián"},
    { 0x8172, "wěi"},
    { 0x8173, "jiǎo,jué"},
    { 0x8174, "yú"},
    { 0x8175, "jiā"},
    { 0x8176, "duàn"},
    { 0x8177, "bì"},
    { 0x8178, "cháng"},
    { 0x8179, "fù"},
    { 0x817A, "xiàn"},
    { 0x817B, "nì"},
    { 0x817C, "miǎn"},
    { 0x817D, "wà"},
    { 0x817E, "téng"},
    { 0x817F, "tuǐ"},
    { 0x8180, "bǎng,páng,pāng,bàng,pǎng"},
    { 0x8181, "qiǎn,xiàn,yán"},
    { 0x8182, "lǚ"},
    { 0x8183, "wà"},
    { 0x8184, "shòu"},
    { 0x8185, "táng"},
    { 0x8186, "sù"},
    { 0x8187, "zhuì"},
    { 0x8188, "gé"},
    { 0x8189, "yì"},
    { 0x818A, "bó,pò,liè"},
    { 0x818B, "liáo"},
    { 0x818C, "jí"},
    { 0x818D, "pí"},
    { 0x818E, "xié"},
    { 0x818F, "gāo,gào"},
    { 0x8190, "lǚ"},
    { 0x8191, "bìn"},
    { 0x8192, "ōu"},
    { 0x8193, "cháng"},
    { 0x8194, "lù,biāo"},
    { 0x8195, "guó,huò"},
    { 0x8196, "pāng"},
    { 0x8197, "chuái"},
    { 0x8198, "biāo,piǎo"},
    { 0x8199, "jiǎng"},
    { 0x819A, "fū,lú"},
    { 0x819B, "táng,tāng"},
    { 0x819C, "mó"},
    { 0x819D, "xī"},
    { 0x819E, "zhuān,zhuǎn,chuǎn,chún"},
    { 0x819F, "lǜ"},
    { 0x81A0, "jiāo,jiǎo,háo,nǎo"},
    { 0x81A1, "yìng"},
    { 0x81A2, "lǘ"},
    { 0x81A3, "zhì"},
    { 0x81A4, "xuě"},
    { 0x81A5, "cūn"},
    { 0x81A6, "lìn,liǎn"},
    { 0x81A7, "tóng"},
    { 0x81A8, "péng,pèng"},
    { 0x81A9, "nì"},
    { 0x81AA, "chuài,zhà,zhài"},
    { 0x81AB, "liáo,liǎo"},
    { 0x81AC, "cuì"},
    { 0x81AD, "guī,kuì,duì"},
    { 0x81AE, "xiāo"},
    { 0x81AF, "tēng,tún"},
    { 0x81B0, "fán,pán"},
    { 0x81B1, "zhí"},
    { 0x81B2, "jiāo"},
    { 0x81B3, "shàn"},
    { 0x81B4, "hū,wǔ,méi"},
    { 0x81B5, "cuì"},
    { 0x81B6, "rùn"},
    { 0x81B7, "xiāng"},
    { 0x81B8, "suǐ,wěi"},
    { 0x81B9, "fèn"},
    { 0x81BA, "yīng"},
    { 0x81BB, "shān,dàn"},
    { 0x81BC, "zhuā"},
    { 0x81BD, "dǎn"},
    { 0x81BE, "kuài"},
    { 0x81BF, "nóng"},
    { 0x81C0, "tún"},
    { 0x81C1, "lián"},
    { 0x81C2, "bì,bei"},
    { 0x81C3, "yōng"},
    { 0x81C4, "jué,jū"},
    { 0x81C5, "chù"},
    { 0x81C6, "yì,yǐ"},
    { 0x81C7, "juǎn"},
    { 0x81C8, "là,gé"},
    { 0x81C9, "liǎn"},
    { 0x81CA, "sāo,sào"},
    { 0x81CB, "tún"},
    { 0x81CC, "gǔ"},
    { 0x81CD, "qí"},
    { 0x81CE, "cuì"},
    { 0x81CF, "bìn"},
    { 0x81D0, "xūn"},
    { 0x81D1, "nào,rú,ér,nèn,nuǎn"},
    { 0x81D2, "wò,yuè"},
    { 0x81D3, "zàng"},
    { 0x81D4, "xiàn"},
    { 0x81D5, "biāo"},
    { 0x81D6, "xìng"},
    { 0x81D7, "kuān"},
    { 0x81D8, "là,liè"},
    { 0x81D9, "yān"},
    { 0x81DA, "lú,lǚ"},
    { 0x81DB, "huò"},
    { 0x81DC, "zā"},
    { 0x81DD, "luǒ"},
    { 0x81DE, "qú"},
    { 0x81DF, "zàng"},
    { 0x81E0, "luán"},
    { 0x81E1, "ní,luán"},
    { 0x81E2, "zā,zān"},
    { 0x81E3, "chén"},
    { 0x81E4, "qiān,xián,qìn"},
    { 0x81E5, "wò"},
    { 0x81E6, "guàng,jiǒng"},
    { 0x81E7, "zāng,cáng,zàng"},
    { 0x81E8, "lín,lìn"},
    { 0x81E9, "guǎng,jiǒng"},
    { 0x81EA, "zì"},
    { 0x81EB, "jiǎo"},
    { 0x81EC, "niè"},
    { 0x81ED, "chòu,xiù"},
    { 0x81EE, "jì"},
    { 0x81EF, "gāo"},
    { 0x81F0, "chòu"},
    { 0x81F1, "mián,biān"},
    { 0x81F2, "niè"},
    { 0x81F3, "zhì,dié"},
    { 0x81F4, "zhì,zhuì"},
    { 0x81F5, "gé"},
    { 0x81F6, "jiàn"},
    { 0x81F7, "dié,zhí"},
    { 0x81F8, "zhī,jìn"},
    { 0x81F9, "xiū"},
    { 0x81FA, "tái"},
    { 0x81FB, "zhēn"},
    { 0x81FC, "jiù"},
    { 0x81FD, "xiàn"},
    { 0x81FE, "yú,yǔ,yǒng,kuì"},
    { 0x81FF, "chā"},
    { 0x8200, "yǎo"},
    { 0x8201, "yú"},
    { 0x8202, "chōng,chuāng,zhōng"},
    { 0x8203, "xì"},
    { 0x8204, "xì,què,tuō"},
    { 0x8205, "jiù"},
    { 0x8206, "yú"},
    { 0x8207, "yǔ,yú,yù"},
    { 0x8208, "xìng,xīng,xìn"},
    { 0x8209, "jǔ"},
    { 0x820A, "jiù"},
    { 0x820B, "xìn"},
    { 0x820C, "shé,guā"},
    { 0x820D, "shě,shè,shì"},
    { 0x820E, "shè"},
    { 0x820F, "jiǔ"},
    { 0x8210, "shì"},
    { 0x8211, "tān"},
    { 0x8212, "shū,yù"},
    { 0x8213, "shì"},
    { 0x8214, "tiǎn,tān"},
    { 0x8215, "tàn"},
    { 0x8216, "pù"},
    { 0x8217, "pù"},
    { 0x8218, "guǎn"},
    { 0x8219, "huà,qì"},
    { 0x821A, "tiàn"},
    { 0x821B, "chuǎn"},
    { 0x821C, "shùn"},
    { 0x821D, "xiá"},
    { 0x821E, "wǔ"},
    { 0x821F, "zhōu"},
    { 0x8220, "dāo"},
    { 0x8221, "chuán,xiāng"},
    { 0x8222, "shān"},
    { 0x8223, "yǐ"},
    { 0x8224, "fán"},
    { 0x8225, "pā"},
    { 0x8226, "tài"},
    { 0x8227, "fán"},
    { 0x8228, "bǎn"},
    { 0x8229, "chuán,fán"},
    { 0x822A, "háng"},
    { 0x822B, "fǎng"},
    { 0x822C, "bān,pán,bǎn,bō"},
    { 0x822D, "bǐ"},
    { 0x822E, "lú"},
    { 0x822F, "zhōng"},
    { 0x8230, "jiàn"},
    { 0x8231, "cāng"},
    { 0x8232, "líng"},
    { 0x8233, "zhú,zhǒu"},
    { 0x8234, "zé"},
    { 0x8235, "duò"},
    { 0x8236, "bó"},
    { 0x8237, "xián"},
    { 0x8238, "gě"},
    { 0x8239, "chuán"},
    { 0x823A, "xiá"},
    { 0x823B, "lú"},
    { 0x823C, "qióng,hóng"},
    { 0x823D, "páng,féng"},
    { 0x823E, "xī"},
    { 0x823F, "kuā"},
    { 0x8240, "fú"},
    { 0x8241, "zào"},
    { 0x8242, "féng"},
    { 0x8243, "lí"},
    { 0x8244, "shāo,shào"},
    { 0x8245, "yú"},
    { 0x8246, "láng"},
    { 0x8247, "tǐng"},
    { 0x8248, "yù"},
    { 0x8249, "wěi"},
    { 0x824A, "bó"},
    { 0x824B, "měng"},
    { 0x824C, "niàn,qiàn"},
    { 0x824D, "jū"},
    { 0x824E, "huáng"},
    { 0x824F, "shǒu"},
    { 0x8250, "kè,jiè,zōng"},
    { 0x8251, "biàn"},
    { 0x8252, "mù,mò"},
    { 0x8253, "dié"},
    { 0x8254, "dào"},
    { 0x8255, "bàng"},
    { 0x8256, "chā"},
    { 0x8257, "yì"},
    { 0x8258, "sōu"},
    { 0x8259, "cāng"},
    { 0x825A, "cáo"},
    { 0x825B, "lóu"},
    { 0x825C, "dài"},
    { 0x825D, "xuě"},
    { 0x825E, "yào,tiào"},
    { 0x825F, "chōng,zhuàng,tóng"},
    { 0x8260, "dēng"},
    { 0x8261, "dāng"},
    { 0x8262, "qiáng"},
    { 0x8263, "lǔ"},
    { 0x8264, "yǐ"},
    { 0x8265, "jí"},
    { 0x8266, "jiàn"},
    { 0x8267, "huò,wò"},
    { 0x8268, "méng"},
    { 0x8269, "qí"},
    { 0x826A, "lǔ"},
    { 0x826B, "lú"},
    { 0x826C, "chán"},
    { 0x826D, "shuāng"},
    { 0x826E, "gěn,gèn,hén"},
    { 0x826F, "liáng,liǎng"},
    { 0x8270, "jiān"},
    { 0x8271, "jiān"},
    { 0x8272, "sè,shǎi"},
    { 0x8273, "yàn"},
    { 0x8274, "fú,bó,pèi"},
    { 0x8275, "pīng"},
    { 0x8276, "yàn"},
    { 0x8277, "yàn"},
    { 0x8278, "cǎo"},
    { 0x8279, "cǎo"},
    { 0x827A, "yì"},
    { 0x827B, "lè,jí"},
    { 0x827C, "tīng,dǐng"},
    { 0x827D, "jiāo,qiú"},
    { 0x827E, "ài,yì"},
    { 0x827F, "nǎi,réng,rèng"},
    { 0x8280, "tiáo"},
    { 0x8281, "jiāo"},
    { 0x8282, "jié,jiē"},
    { 0x8283, "péng"},
    { 0x8284, "wán"},
    { 0x8285, "yì"},
    { 0x8286, "chāi,chā"},
    { 0x8287, "mián"},
    { 0x8288, "mǐ"},
    { 0x8289, "gān,gǎn"},
    { 0x828A, "qiān,qiàn"},
    { 0x828B, "yù,yú,xū,yǔ"},
    { 0x828C, "yù"},
    { 0x828D, "sháo,xiào,què,dì"},
    { 0x828E, "qiōng,xiōng"},
    { 0x828F, "dù"},
    { 0x8290, "hù,xià"},
    { 0x8291, "qǐ"},
    { 0x8292, "máng,huāng,huǎng,wáng"},
    { 0x8293, "zì,zǐ,zī"},
    { 0x8294, "huì,hū"},
    { 0x8295, "suī"},
    { 0x8296, "zhì"},
    { 0x8297, "xiāng"},
    { 0x8298, "pí,bì"},
    { 0x8299, "fú"},
    { 0x829A, "tún,chūn"},
    { 0x829B, "wěi"},
    { 0x829C, "wú"},
    { 0x829D, "zhī"},
    { 0x829E, "qì"},
    { 0x829F, "shān,wěi"},
    { 0x82A0, "wén"},
    { 0x82A1, "qiàn"},
    { 0x82A2, "rén"},
    { 0x82A3, "fú,fǒu,fū"},
    { 0x82A4, "kōu"},
    { 0x82A5, "jiè,gài"},
    { 0x82A6, "lú,hù,lǔ"},
    { 0x82A7, "xù,zhù"},
    { 0x82A8, "jī"},
    { 0x82A9, "qín,yín"},
    { 0x82AA, "qí,chí"},
    { 0x82AB, "yán,yuán"},
    { 0x82AC, "fēn"},
    { 0x82AD, "bā,pā"},
    { 0x82AE, "ruì,ruò"},
    { 0x82AF, "xīn,xìn"},
    { 0x82B0, "jì"},
    { 0x82B1, "huā"},
    { 0x82B2, "huā"},
    { 0x82B3, "fāng"},
    { 0x82B4, "wù,hū"},
    { 0x82B5, "jué"},
    { 0x82B6, "gǒu"},
    { 0x82B7, "zhǐ"},
    { 0x82B8, "yún,yùn"},
    { 0x82B9, "qín"},
    { 0x82BA, "ǎo"},
    { 0x82BB, "chú,zōu"},
    { 0x82BC, "mào"},
    { 0x82BD, "yá"},
    { 0x82BE, "fèi,fú"},
    { 0x82BF, "rèng"},
    { 0x82C0, "háng"},
    { 0x82C1, "cōng"},
    { 0x82C2, "yín"},
    { 0x82C3, "yǒu"},
    { 0x82C4, "biàn"},
    { 0x82C5, "yì"},
    { 0x82C6, "qiē"},
    { 0x82C7, "wěi"},
    { 0x82C8, "lì"},
    { 0x82C9, "pǐ"},
    { 0x82CA, "è"},
    { 0x82CB, "xiàn"},
    { 0x82CC, "cháng"},
    { 0x82CD, "cāng"},
    { 0x82CE, "zhù"},
    { 0x82CF, "sū"},
    { 0x82D0, "tí,dì"},
    { 0x82D1, "yuàn,yuān,yù,yùn"},
    { 0x82D2, "rǎn"},
    { 0x82D3, "líng,lián"},
    { 0x82D4, "tái,tāi"},
    { 0x82D5, "sháo,tiáo"},
    { 0x82D6, "dí"},
    { 0x82D7, "miáo"},
    { 0x82D8, "qǐng"},
    { 0x82D9, "lì,jī"},
    { 0x82DA, "yòng"},
    { 0x82DB, "kē,hē"},
    { 0x82DC, "mù"},
    { 0x82DD, "bèi"},
    { 0x82DE, "bāo,páo,biāo"},
    { 0x82DF, "gǒu,gōu"},
    { 0x82E0, "mín"},
    { 0x82E1, "yǐ"},
    { 0x82E2, "yǐ"},
    { 0x82E3, "jù,qǔ"},
    { 0x82E4, "piě,pī"},
    { 0x82E5, "ruò,ré,rè,rě"},
    { 0x82E6, "kǔ,gǔ,hù"},
    { 0x82E7, "níng,zhù"},
    { 0x82E8, "nǐ"},
    { 0x82E9, "bó,pā"},
    { 0x82EA, "bǐng"},
    { 0x82EB, "shān,shàn,tiān,chān"},
    { 0x82EC, "xiú"},
    { 0x82ED, "yǎo"},
    { 0x82EE, "xiān"},
    { 0x82EF, "běn"},
    { 0x82F0, "hóng"},
    { 0x82F1, "yīng,yāng"},
    { 0x82F2, "zhǎ,zhà,zuó"},
    { 0x82F3, "dōng"},
    { 0x82F4, "jū,chá,zhǎ,zū,jiē,bāo,xié"},
    { 0x82F5, "dié"},
    { 0x82F6, "nié,niè"},
    { 0x82F7, "gān"},
    { 0x82F8, "hū"},
    { 0x82F9, "píng,pēng"},
    { 0x82FA, "méi"},
    { 0x82FB, "fú,pú"},
    { 0x82FC, "shēng,ruí"},
    { 0x82FD, "gū,guā"},
    { 0x82FE, "bì,bié,mì"},
    { 0x82FF, "wèi"},
    { 0x8300, "fú,bó,fèi,bèi,bì"},
    { 0x8301, "zhuó,zhú"},
    { 0x8302, "mào"},
    { 0x8303, "fàn"},
    { 0x8304, "jiā,qié"},
    { 0x8305, "máo"},
    { 0x8306, "máo,mǎo"},
    { 0x8307, "bá,pèi,fèi"},
    { 0x8308, "cí,zǐ,cǐ,chái"},
    { 0x8309, "mò"},
    { 0x830A, "zī"},
    { 0x830B, "zhǐ"},
    { 0x830C, "chí"},
    { 0x830D, "jì"},
    { 0x830E, "jīng"},
    { 0x830F, "lóng"},
    { 0x8310, "cōng"},
    { 0x8311, "niǎo"},
    { 0x8312, "yuán"},
    { 0x8313, "xué"},
    { 0x8314, "yíng"},
    { 0x8315, "qióng"},
    { 0x8316, "gé,luò"},
    { 0x8317, "míng"},
    { 0x8318, "lì"},
    { 0x8319, "róng"},
    { 0x831A, "yìn"},
    { 0x831B, "gèn,jiàn"},
    { 0x831C, "qiàn,xī"},
    { 0x831D, "chǎi,zhǐ"},
    { 0x831E, "chén"},
    { 0x831F, "yù,wěi"},
    { 0x8320, "hāo,xiū,kòu"},
    { 0x8321, "zì"},
    { 0x8322, "liè"},
    { 0x8323, "wú"},
    { 0x8324, "jì,duō"},
    { 0x8325, "guī,guì"},
    { 0x8326, "cì"},
    { 0x8327, "jiǎn,chóng"},
    { 0x8328, "cí"},
    { 0x8329, "gòu"},
    { 0x832A, "guāng"},
    { 0x832B, "máng,huǎng"},
    { 0x832C, "chá,chí"},
    { 0x832D, "jiāo,xiào,qiào"},
    { 0x832E, "jiāo,niǎo"},
    { 0x832F, "fú"},
    { 0x8330, "yú"},
    { 0x8331, "zhū"},
    { 0x8332, "zī,cí"},
    { 0x8333, "jiāng"},
    { 0x8334, "huí"},
    { 0x8335, "yīn"},
    { 0x8336, "chá"},
    { 0x8337, "fá,pèi,bó,bá"},
    { 0x8338, "rōng,róng,rǒng"},
    { 0x8339, "rú"},
    { 0x833A, "chōng"},
    { 0x833B, "mǎng,mǔ"},
    { 0x833C, "tóng"},
    { 0x833D, "zhòng"},
    { 0x833E, "qiān"},
    { 0x833F, "zhú"},
    { 0x8340, "xún"},
    { 0x8341, "huán"},
    { 0x8342, "fū"},
    { 0x8343, "quán,chuò"},
    { 0x8344, "gāi"},
    { 0x8345, "dā,dá,tà"},
    { 0x8346, "jīng"},
    { 0x8347, "xìng"},
    { 0x8348, "chuǎn"},
    { 0x8349, "cǎo,zào"},
    { 0x834A, "jīng"},
    { 0x834B, "ér"},
    { 0x834C, "àn"},
    { 0x834D, "qiáo"},
    { 0x834E, "chí"},
    { 0x834F, "rěn"},
    { 0x8350, "jiàn"},
    { 0x8351, "tí,yí"},
    { 0x8352, "huāng,huǎng,kāng,huáng"},
    { 0x8353, "píng,pēng"},
    { 0x8354, "lì"},
    { 0x8355, "jīn"},
    { 0x8356, "lǎo,chā"},
    { 0x8357, "shù"},
    { 0x8358, "zhuāng"},
    { 0x8359, "dá"},
    { 0x835A, "jiá"},
    { 0x835B, "ráo"},
    { 0x835C, "bì"},
    { 0x835D, "cè"},
    { 0x835E, "qiáo"},
    { 0x835F, "huì"},
    { 0x8360, "jì,qí"},
    { 0x8361, "dàng"},
    { 0x8362, "zì"},
    { 0x8363, "róng"},
    { 0x8364, "hūn,xūn"},
    { 0x8365, "xíng,yíng"},
    { 0x8366, "luò"},
    { 0x8367, "yíng"},
    { 0x8368, "xún,qián"},
    { 0x8369, "jìn"},
    { 0x836A, "sūn"},
    { 0x836B, "yīn,yìn"},
    { 0x836C, "mǎi"},
    { 0x836D, "hóng"},
    { 0x836E, "zhòu"},
    { 0x836F, "yào"},
    { 0x8370, "dù"},
    { 0x8371, "wěi,wèi"},
    { 0x8372, "lí"},
    { 0x8373, "dòu"},
    { 0x8374, "fū"},
    { 0x8375, "rěn"},
    { 0x8376, "yín"},
    { 0x8377, "hé,hè,hē"},
    { 0x8378, "bí"},
    { 0x8379, "bù,pú"},
    { 0x837A, "yǔn,yún"},
    { 0x837B, "dí"},
    { 0x837C, "tú,chá,yé,shū"},
    { 0x837D, "suī,wěi"},
    { 0x837E, "suī"},
    { 0x837F, "chéng"},
    { 0x8380, "chén,nóng"},
    { 0x8381, "wú"},
    { 0x8382, "bié"},
    { 0x8383, "xī"},
    { 0x8384, "gěng"},
    { 0x8385, "lì"},
    { 0x8386, "pú,fǔ"},
    { 0x8387, "zhù"},
    { 0x8388, "mò"},
    { 0x8389, "lì,lí,chí"},
    { 0x838A, "zhuāng"},
    { 0x838B, "zuó,jí"},
    { 0x838C, "tuō"},
    { 0x838D, "qiú"},
    { 0x838E, "shā,suō,suī"},
    { 0x838F, "suō"},
    { 0x8390, "chén"},
    { 0x8391, "péng,fēng"},
    { 0x8392, "jǔ"},
    { 0x8393, "méi"},
    { 0x8394, "méng,xí,qǐng"},
    { 0x8395, "xìng"},
    { 0x8396, "jīng,yīng"},
    { 0x8397, "chē"},
    { 0x8398, "shēn,xīn"},
    { 0x8399, "jūn"},
    { 0x839A, "yán"},
    { 0x839B, "tíng,tǐng"},
    { 0x839C, "yóu,diào,dí"},
    { 0x839D, "cuò"},
    { 0x839E, "guǎn,guān,wǎn"},
    { 0x839F, "hàn"},
    { 0x83A0, "yǒu,xiù"},
    { 0x83A1, "cuò"},
    { 0x83A2, "jiá"},
    { 0x83A3, "wáng"},
    { 0x83A4, "sù,yóu"},
    { 0x83A5, "niǔ,ròu"},
    { 0x83A6, "shāo,xiāo"},
    { 0x83A7, "xiàn,wàn"},
    { 0x83A8, "làng,láng,liáng"},
    { 0x83A9, "fú,piǎo"},
    { 0x83AA, "é"},
    { 0x83AB, "mò,mù"},
    { 0x83AC, "wèn,wǎn,miǎn"},
    { 0x83AD, "jié"},
    { 0x83AE, "nán"},
    { 0x83AF, "mù"},
    { 0x83B0, "kǎn"},
    { 0x83B1, "lái"},
    { 0x83B2, "lián"},
    { 0x83B3, "shí,shì"},
    { 0x83B4, "wō"},
    { 0x83B5, "tù"},
    { 0x83B6, "xiān"},
    { 0x83B7, "huò"},
    { 0x83B8, "yóu"},
    { 0x83B9, "yíng"},
    { 0x83BA, "yīng"},
    { 0x83BB, "gòng"},
    { 0x83BC, "chún"},
    { 0x83BD, "mǎng,máng"},
    { 0x83BE, "mǎng"},
    { 0x83BF, "cì"},
    { 0x83C0, "wǎn,yù,yùn"},
    { 0x83C1, "jīng"},
    { 0x83C2, "dì"},
    { 0x83C3, "qú"},
    { 0x83C4, "dōng"},
    { 0x83C5, "jiān,guān"},
    { 0x83C6, "zōu,cuán,chù,cóng"},
    { 0x83C7, "gū"},
    { 0x83C8, "lā"},
    { 0x83C9, "lù,lǜ"},
    { 0x83CA, "jú"},
    { 0x83CB, "wèi"},
    { 0x83CC, "jūn,jùn"},
    { 0x83CD, "niè,rěn"},
    { 0x83CE, "kūn"},
    { 0x83CF, "hé,gē"},
    { 0x83D0, "pú"},
    { 0x83D1, "zāi,zī,zì"},
    { 0x83D2, "gǎo"},
    { 0x83D3, "guǒ"},
    { 0x83D4, "fú"},
    { 0x83D5, "lún"},
    { 0x83D6, "chāng"},
    { 0x83D7, "chóu"},
    { 0x83D8, "sōng"},
    { 0x83D9, "chuí"},
    { 0x83DA, "zhàn"},
    { 0x83DB, "mén"},
    { 0x83DC, "cài"},
    { 0x83DD, "bá"},
    { 0x83DE, "lí"},
    { 0x83DF, "tú,tù"},
    { 0x83E0, "bō"},
    { 0x83E1, "hàn"},
    { 0x83E2, "bào"},
    { 0x83E3, "qìn"},
    { 0x83E4, "juǎn"},
    { 0x83E5, "xī,sī"},
    { 0x83E6, "qín"},
    { 0x83E7, "dǐ"},
    { 0x83E8, "jiē,shà"},
    { 0x83E9, "pú,bèi,bó"},
    { 0x83EA, "dàng"},
    { 0x83EB, "jǐn"},
    { 0x83EC, "qiáo,zhǎo"},
    { 0x83ED, "tái,zhī,chí"},
    { 0x83EE, "gēng"},
    { 0x83EF, "huá,huā,huà,kuā"},
    { 0x83F0, "gū"},
    { 0x83F1, "líng"},
    { 0x83F2, "fēi,fěi,fèi"},
    { 0x83F3, "qín,qīn,jīn"},
    { 0x83F4, "ān,yǎn"},
    { 0x83F5, "wǎng"},
    { 0x83F6, "běng"},
    { 0x83F7, "zhǒu"},
    { 0x83F8, "yān,yū,yù"},
    { 0x83F9, "jū,zū,jù"},
    { 0x83FA, "jiān"},
    { 0x83FB, "lǐn"},
    { 0x83FC, "tǎn"},
    { 0x83FD, "shū,jiāo"},
    { 0x83FE, "tián,tiàn"},
    { 0x83FF, "dào,dǎo"},
    { 0x8400, "hǔ"},
    { 0x8401, "qí,jī"},
    { 0x8402, "hé"},
    { 0x8403, "cuì"},
    { 0x8404, "táo"},
    { 0x8405, "chūn"},
    { 0x8406, "bì,pì,bēi,bá"},
    { 0x8407, "cháng"},
    { 0x8408, "huán"},
    { 0x8409, "fèi,féi,fú"},
    { 0x840A, "lái"},
    { 0x840B, "qī"},
    { 0x840C, "méng,míng"},
    { 0x840D, "píng"},
    { 0x840E, "wēi,wèi,wěi"},
    { 0x840F, "dàn"},
    { 0x8410, "shà"},
    { 0x8411, "huán,zhuī"},
    { 0x8412, "yǎn,juàn"},
    { 0x8413, "yí"},
    { 0x8414, "tiáo"},
    { 0x8415, "qí"},
    { 0x8416, "wǎn"},
    { 0x8417, "cè"},
    { 0x8418, "nài"},
    { 0x8419, "zhěn"},
    { 0x841A, "tuò"},
    { 0x841B, "jiū"},
    { 0x841C, "tiē"},
    { 0x841D, "luó"},
    { 0x841E, "bì"},
    { 0x841F, "yì"},
    { 0x8420, "pān"},
    { 0x8421, "bo"},
    { 0x8422, "pāo"},
    { 0x8423, "dìng"},
    { 0x8424, "yíng"},
    { 0x8425, "yíng"},
    { 0x8426, "yíng"},
    { 0x8427, "xiāo"},
    { 0x8428, "sà"},
    { 0x8429, "qiū,jiāo"},
    { 0x842A, "kē"},
    { 0x842B, "xiàng"},
    { 0x842C, "wàn"},
    { 0x842D, "yǔ,jǔ"},
    { 0x842E, "yú,yǔ,yù"},
    { 0x842F, "fù,bèi"},
    { 0x8430, "liàn"},
    { 0x8431, "xuān"},
    { 0x8432, "xuān"},
    { 0x8433, "nǎn,nán"},
    { 0x8434, "cè"},
    { 0x8435, "wō"},
    { 0x8436, "chǔn"},
    { 0x8437, "xiāo,shāo,shuò"},
    { 0x8438, "yú"},
    { 0x8439, "biǎn,biān,pián"},
    { 0x843A, "mào,mù"},
    { 0x843B, "ān"},
    { 0x843C, "è"},
    { 0x843D, "luò,là,lào,luō"},
    { 0x843E, "yíng"},
    { 0x843F, "kuò,huó"},
    { 0x8440, "kuò"},
    { 0x8441, "jiāng"},
    { 0x8442, "miǎn"},
    { 0x8443, "zuò,zé"},
    { 0x8444, "zuò"},
    { 0x8445, "zū"},
    { 0x8446, "bǎo,bāo"},
    { 0x8447, "róu,rǒu"},
    { 0x8448, "xǐ"},
    { 0x8449, "yè,shè"},
    { 0x844A, "ān"},
    { 0x844B, "qú"},
    { 0x844C, "jiān"},
    { 0x844D, "fú"},
    { 0x844E, "lǜ"},
    { 0x844F, "jīng"},
    { 0x8450, "pén,fén"},
    { 0x8451, "fēng,fèng"},
    { 0x8452, "hóng"},
    { 0x8453, "hóng"},
    { 0x8454, "hóu"},
    { 0x8455, "yàn"},
    { 0x8456, "tū"},
    { 0x8457, "zhù,zhe,chú,zhuó,zhāo,zháo"},
    { 0x8458, "zī"},
    { 0x8459, "xiāng"},
    { 0x845A, "rèn,shèn"},
    { 0x845B, "gé,gě"},
    { 0x845C, "qiā"},
    { 0x845D, "qíng,jìng"},
    { 0x845E, "mǐ"},
    { 0x845F, "huáng"},
    { 0x8460, "shēn,shān"},
    { 0x8461, "pú,bèi"},
    { 0x8462, "gài"},
    { 0x8463, "dǒng,zhǒng"},
    { 0x8464, "zhòu"},
    { 0x8465, "jiàn,qián"},
    { 0x8466, "wěi"},
    { 0x8467, "bó"},
    { 0x8468, "wēi"},
    { 0x8469, "pā"},
    { 0x846A, "jì"},
    { 0x846B, "hú"},
    { 0x846C, "zàng"},
    { 0x846D, "jiā,xiá"},
    { 0x846E, "duàn"},
    { 0x846F, "yào"},
    { 0x8470, "suī,jùn,suǒ"},
    { 0x8471, "cōng,chuāng"},
    { 0x8472, "quán"},
    { 0x8473, "wēi"},
    { 0x8474, "zhēn,qián"},
    { 0x8475, "kuí"},
    { 0x8476, "tíng,dǐng"},
    { 0x8477, "hūn,xūn"},
    { 0x8478, "xǐ"},
    { 0x8479, "shī"},
    { 0x847A, "qì"},
    { 0x847B, "lán"},
    { 0x847C, "zōng"},
    { 0x847D, "yāo,yǎo"},
    { 0x847E, "yuān"},
    { 0x847F, "méi"},
    { 0x8480, "yūn"},
    { 0x8481, "shù"},
    { 0x8482, "dì"},
    { 0x8483, "zhuàn"},
    { 0x8484, "guān"},
    { 0x8485, "rǎn"},
    { 0x8486, "xuē"},
    { 0x8487, "chǎn"},
    { 0x8488, "kǎi"},
    { 0x8489, "kuì"},
    { 0x848A, "huā"},
    { 0x848B, "jiǎng"},
    { 0x848C, "lóu"},
    { 0x848D, "wěi,huā,kuī,é"},
    { 0x848E, "pài"},
    { 0x848F, "you"},
    { 0x8490, "sōu,huì"},
    { 0x8491, "yīn"},
    { 0x8492, "shī"},
    { 0x8493, "chún"},
    { 0x8494, "shí,shì"},
    { 0x8495, "yūn"},
    { 0x8496, "zhēn"},
    { 0x8497, "làng"},
    { 0x8498, "rú,ná"},
    { 0x8499, "méng,měng,mēng"},
    { 0x849A, "lì"},
    { 0x849B, "quē"},
    { 0x849C, "suàn"},
    { 0x849D, "yuán,huán"},
    { 0x849E, "lì"},
    { 0x849F, "jǔ"},
    { 0x84A0, "xī"},
    { 0x84A1, "bàng,páng"},
    { 0x84A2, "chú"},
    { 0x84A3, "xú,shú"},
    { 0x84A4, "tú"},
    { 0x84A5, "liú"},
    { 0x84A6, "huò,wò"},
    { 0x84A7, "diǎn"},
    { 0x84A8, "qiàn"},
    { 0x84A9, "zū,jù,jí"},
    { 0x84AA, "pò"},
    { 0x84AB, "cuó"},
    { 0x84AC, "yuān"},
    { 0x84AD, "chú"},
    { 0x84AE, "yù"},
    { 0x84AF, "kuǎi,kuài"},
    { 0x84B0, "pán"},
    { 0x84B1, "pú"},
    { 0x84B2, "pú,bó"},
    { 0x84B3, "nà"},
    { 0x84B4, "shuò"},
    { 0x84B5, "xí,xì"},
    { 0x84B6, "fén"},
    { 0x84B7, "yún"},
    { 0x84B8, "zhēng"},
    { 0x84B9, "jiān"},
    { 0x84BA, "jí"},
    { 0x84BB, "ruò"},
    { 0x84BC, "cāng,cǎng"},
    { 0x84BD, "ēn"},
    { 0x84BE, "mí"},
    { 0x84BF, "hāo,gǎo"},
    { 0x84C0, "sūn"},
    { 0x84C1, "zhēn,qín"},
    { 0x84C2, "míng,mì"},
    { 0x84C3, "sōu,sǒu"},
    { 0x84C4, "xù"},
    { 0x84C5, "liú"},
    { 0x84C6, "xí"},
    { 0x84C7, "gǔ,gū"},
    { 0x84C8, "láng"},
    { 0x84C9, "róng"},
    { 0x84CA, "wěng"},
    { 0x84CB, "gài,gě"},
    { 0x84CC, "cuò"},
    { 0x84CD, "shī"},
    { 0x84CE, "táng"},
    { 0x84CF, "luǒ"},
    { 0x84D0, "rù"},
    { 0x84D1, "suō,suī"},
    { 0x84D2, "xuān"},
    { 0x84D3, "bèi"},
    { 0x84D4, "yǎo,zhuó"},
    { 0x84D5, "guì"},
    { 0x84D6, "bì"},
    { 0x84D7, "zǒng"},
    { 0x84D8, "gǔn"},
    { 0x84D9, "zuò"},
    { 0x84DA, "tiáo"},
    { 0x84DB, "cè"},
    { 0x84DC, "pèi"},
    { 0x84DD, "lán,la"},
    { 0x84DE, "dàn"},
    { 0x84DF, "jì"},
    { 0x84E0, "lí"},
    { 0x84E1, "shēn"},
    { 0x84E2, "lǎng"},
    { 0x84E3, "yù"},
    { 0x84E4, "líng"},
    { 0x84E5, "yíng"},
    { 0x84E6, "mò"},
    { 0x84E7, "diào,tiáo,dí"},
    { 0x84E8, "tiáo,xiū"},
    { 0x84E9, "mǎo"},
    { 0x84EA, "tōng"},
    { 0x84EB, "chù,zhú"},
    { 0x84EC, "péng,pèng"},
    { 0x84ED, "ān"},
    { 0x84EE, "lián,liǎn"},
    { 0x84EF, "cōng,zǒng,sǒng"},
    { 0x84F0, "xǐ"},
    { 0x84F1, "píng"},
    { 0x84F2, "qiū,ōu,xū,fū"},
    { 0x84F3, "jǐn"},
    { 0x84F4, "chún,tuán"},
    { 0x84F5, "jié"},
    { 0x84F6, "wéi"},
    { 0x84F7, "tuī"},
    { 0x84F8, "cáo"},
    { 0x84F9, "yù"},
    { 0x84FA, "yì"},
    { 0x84FB, "zí,jú"},
    { 0x84FC, "liǎo,lù,lǎo,liǔ"},
    { 0x84FD, "bì"},
    { 0x84FE, "lǔ"},
    { 0x84FF, "xu,sù"},
    { 0x8500, "bù"},
    { 0x8501, "zhāng"},
    { 0x8502, "léi"},
    { 0x8503, "qiáng,jiàng"},
    { 0x8504, "màn"},
    { 0x8505, "yán"},
    { 0x8506, "líng"},
    { 0x8507, "jì,xì"},
    { 0x8508, "biāo,piǎo,biào"},
    { 0x8509, "gǔn"},
    { 0x850A, "hǎn"},
    { 0x850B, "dí"},
    { 0x850C, "sù"},
    { 0x850D, "lù,cū"},
    { 0x850E, "shè"},
    { 0x850F, "shāng"},
    { 0x8510, "dí"},
    { 0x8511, "miè"},
    { 0x8512, "xūn"},
    { 0x8513, "màn,wàn,mán"},
    { 0x8514, "bó,bo"},
    { 0x8515, "dì,dài,chài"},
    { 0x8516, "cuó,cǔ,zhā"},
    { 0x8517, "zhè"},
    { 0x8518, "shēn,sān,sǎn"},
    { 0x8519, "xuàn"},
    { 0x851A, "wèi,yù"},
    { 0x851B, "hú"},
    { 0x851C, "áo"},
    { 0x851D, "mǐ"},
    { 0x851E, "lóu,lǚ,jù,liǔ"},
    { 0x851F, "cù,còu,chuò"},
    { 0x8520, "zhōng"},
    { 0x8521, "cài,sà,cā"},
    { 0x8522, "pó,bò"},
    { 0x8523, "jiǎng,jiāng"},
    { 0x8524, "mì"},
    { 0x8525, "cōng"},
    { 0x8526, "niǎo"},
    { 0x8527, "huì"},
    { 0x8528, "juàn,jùn"},
    { 0x8529, "yín"},
    { 0x852A, "jiàn,jiān,shān"},
    { 0x852B, "niān,yān,yàn"},
    { 0x852C, "shū,shǔ"},
    { 0x852D, "yīn,yìn"},
    { 0x852E, "guó"},
    { 0x852F, "chén"},
    { 0x8530, "hù"},
    { 0x8531, "shā"},
    { 0x8532, "kòu"},
    { 0x8533, "qiàn"},
    { 0x8534, "má"},
    { 0x8535, "zāng,cáng"},
    { 0x8536, "zé"},
    { 0x8537, "qiáng"},
    { 0x8538, "dōu"},
    { 0x8539, "liǎn"},
    { 0x853A, "lìn"},
    { 0x853B, "kòu"},
    { 0x853C, "ǎi"},
    { 0x853D, "bì,biē,piē"},
    { 0x853E, "lí"},
    { 0x853F, "wěi"},
    { 0x8540, "jí"},
    { 0x8541, "qián,tán,xún"},
    { 0x8542, "shèng"},
    { 0x8543, "fān,fán,pí,bō"},
    { 0x8544, "méng"},
    { 0x8545, "ǒu"},
    { 0x8546, "chǎn"},
    { 0x8547, "diǎn"},
    { 0x8548, "xùn,tán"},
    { 0x8549, "jiāo,qiáo,qiāo"},
    { 0x854A, "ruǐ,juǎn"},
    { 0x854B, "ruǐ"},
    { 0x854C, "lěi"},
    { 0x854D, "yú"},
    { 0x854E, "qiáo,jiāo"},
    { 0x854F, "chú"},
    { 0x8550, "huá"},
    { 0x8551, "jiān"},
    { 0x8552, "mǎi"},
    { 0x8553, "yún"},
    { 0x8554, "bāo"},
    { 0x8555, "yóu"},
    { 0x8556, "qú"},
    { 0x8557, "lù"},
    { 0x8558, "ráo,yáo"},
    { 0x8559, "huì"},
    { 0x855A, "è"},
    { 0x855B, "tí"},
    { 0x855C, "fěi"},
    { 0x855D, "jué,zuì"},
    { 0x855E, "zuì,jué,zhuó"},
    { 0x855F, "fà,fèi"},
    { 0x8560, "rú"},
    { 0x8561, "fén,fèi"},
    { 0x8562, "kuì,kuài"},
    { 0x8563, "shùn"},
    { 0x8564, "ruí"},
    { 0x8565, "yǎ"},
    { 0x8566, "xū"},
    { 0x8567, "fù"},
    { 0x8568, "jué"},
    { 0x8569, "dàng,tāng,tàng"},
    { 0x856A, "wú,wǔ"},
    { 0x856B, "dǒng"},
    { 0x856C, "sī"},
    { 0x856D, "xiāo"},
    { 0x856E, "xì"},
    { 0x856F, "lóng"},
    { 0x8570, "wēn,yùn"},
    { 0x8571, "shāo"},
    { 0x8572, "qí"},
    { 0x8573, "jiān"},
    { 0x8574, "yùn"},
    { 0x8575, "sūn"},
    { 0x8576, "líng"},
    { 0x8577, "yù"},
    { 0x8578, "xiá"},
    { 0x8579, "wèng,yōng"},
    { 0x857A, "jí,qiè"},
    { 0x857B, "hóng,hòng"},
    { 0x857C, "sì"},
    { 0x857D, "nóng"},
    { 0x857E, "lěi"},
    { 0x857F, "xuān"},
    { 0x8580, "yùn"},
    { 0x8581, "yù"},
    { 0x8582, "xí,xiào"},
    { 0x8583, "hào"},
    { 0x8584, "báo,bó,bù,bò"},
    { 0x8585, "hāo"},
    { 0x8586, "ài"},
    { 0x8587, "wēi"},
    { 0x8588, "huì"},
    { 0x8589, "huì"},
    { 0x858A, "jì"},
    { 0x858B, "cí,zī"},
    { 0x858C, "xiāng,xiǎng"},
    { 0x858D, "wàn,luàn"},
    { 0x858E, "miè"},
    { 0x858F, "yì"},
    { 0x8590, "léng"},
    { 0x8591, "jiāng"},
    { 0x8592, "càn"},
    { 0x8593, "shēn"},
    { 0x8594, "qiáng,sè"},
    { 0x8595, "lián"},
    { 0x8596, "kē"},
    { 0x8597, "yuán"},
    { 0x8598, "dá"},
    { 0x8599, "tì,zhì"},
    { 0x859A, "tāng"},
    { 0x859B, "xuē"},
    { 0x859C, "bì,bò,bó,bài,pì"},
    { 0x859D, "zhān"},
    { 0x859E, "sūn"},
    { 0x859F, "xiān,liǎn,yán,kàn"},
    { 0x85A0, "fán"},
    { 0x85A1, "dǐng"},
    { 0x85A2, "xiè"},
    { 0x85A3, "gǔ"},
    { 0x85A4, "xiè"}
};
