/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     chenhaifeng  <chenhaifeng@uniontech.com>
*
* Maintainer: chenhaifeng  <chenhaifeng@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "pinyindict.h"

QMap<int, QString> PinyinDict_12{
    { 0x8D75, "zhào"},
    { 0x8D76, "gǎn,qián"},
    { 0x8D77, "qǐ"},
    { 0x8D78, "shàn"},
    { 0x8D79, "qióng"},
    { 0x8D7A, "yǐn,qǐn"},
    { 0x8D7B, "xiǎn"},
    { 0x8D7C, "zī"},
    { 0x8D7D, "jué,guì"},
    { 0x8D7E, "qǐn"},
    { 0x8D7F, "chí,dì"},
    { 0x8D80, "cī"},
    { 0x8D81, "chèn,zhēn,chén,niǎn,zhěn"},
    { 0x8D82, "chèn"},
    { 0x8D83, "dié,tú"},
    { 0x8D84, "jū,qiè"},
    { 0x8D85, "chāo,chǎo,chào,tiào"},
    { 0x8D86, "dī"},
    { 0x8D87, "xì"},
    { 0x8D88, "zhān"},
    { 0x8D89, "jué,jú"},
    { 0x8D8A, "yuè,huó"},
    { 0x8D8B, "qū"},
    { 0x8D8C, "jí,jié"},
    { 0x8D8D, "chí,qū"},
    { 0x8D8E, "chú"},
    { 0x8D8F, "guā,huó"},
    { 0x8D90, "xuè,chì"},
    { 0x8D91, "zī,cì"},
    { 0x8D92, "tiáo,tiào,tiǎo"},
    { 0x8D93, "duǒ"},
    { 0x8D94, "liè"},
    { 0x8D95, "gǎn"},
    { 0x8D96, "suō"},
    { 0x8D97, "cù"},
    { 0x8D98, "xí"},
    { 0x8D99, "zhào,diào"},
    { 0x8D9A, "sù"},
    { 0x8D9B, "yǐn"},
    { 0x8D9C, "jú,qū,qiú"},
    { 0x8D9D, "jiàn"},
    { 0x8D9E, "què,qì,jí"},
    { 0x8D9F, "tàng,zhēng,zhèng,chéng,tāng"},
    { 0x8DA0, "chuò,chào,tiào,zhuó"},
    { 0x8DA1, "cuǐ,wěi,jù"},
    { 0x8DA2, "lù"},
    { 0x8DA3, "qù,cù,qū,cǒu,zōu"},
    { 0x8DA4, "dàng"},
    { 0x8DA5, "qiū,cù"},
    { 0x8DA6, "zī"},
    { 0x8DA7, "tí"},
    { 0x8DA8, "qū,cù,qù,cǒu"},
    { 0x8DA9, "chì"},
    { 0x8DAA, "huáng,guāng"},
    { 0x8DAB, "qiáo,jiào,chǎo"},
    { 0x8DAC, "qiāo"},
    { 0x8DAD, "jiào"},
    { 0x8DAE, "zào"},
    { 0x8DAF, "tì,yuè,yào"},
    { 0x8DB0, "ěr"},
    { 0x8DB1, "zǎn"},
    { 0x8DB2, "zǎn,zū"},
    { 0x8DB3, "zú,jù"},
    { 0x8DB4, "pā"},
    { 0x8DB5, "bào,bō,zhuó,chuò,páo"},
    { 0x8DB6, "kù,wū"},
    { 0x8DB7, "kē"},
    { 0x8DB8, "dǔn"},
    { 0x8DB9, "jué,guì"},
    { 0x8DBA, "fū"},
    { 0x8DBB, "chěn"},
    { 0x8DBC, "jiǎn,yàn,yán,jiān"},
    { 0x8DBD, "fàng,páng,fāng"},
    { 0x8DBE, "zhǐ"},
    { 0x8DBF, "tā,sà,qì"},
    { 0x8DC0, "yuè"},
    { 0x8DC1, "bà,pá"},
    { 0x8DC2, "qí,qǐ,qì,jī,zhī"},
    { 0x8DC3, "yuè"},
    { 0x8DC4, "qiāng,qiàng"},
    { 0x8DC5, "tuò,chì"},
    { 0x8DC6, "tái"},
    { 0x8DC7, "yì"},
    { 0x8DC8, "niǎn,jiàn,chén,tiàn"},
    { 0x8DC9, "líng"},
    { 0x8DCA, "mèi"},
    { 0x8DCB, "bá,bèi"},
    { 0x8DCC, "diē,dié,tú"},
    { 0x8DCD, "kū"},
    { 0x8DCE, "tuó"},
    { 0x8DCF, "jiā"},
    { 0x8DD0, "cī,cǐ,zǐ"},
    { 0x8DD1, "pǎo,páo,bó"},
    { 0x8DD2, "qiǎ"},
    { 0x8DD3, "zhù"},
    { 0x8DD4, "jū,qǔ"},
    { 0x8DD5, "diǎn,tiē,dié,zhàn,diē"},
    { 0x8DD6, "zhí"},
    { 0x8DD7, "fū,fù"},
    { 0x8DD8, "pán,bàn"},
    { 0x8DD9, "jù,qū,qiě,zhù,qiè"},
    { 0x8DDA, "shān"},
    { 0x8DDB, "bǒ,bì,pō"},
    { 0x8DDC, "ní"},
    { 0x8DDD, "jù"},
    { 0x8DDE, "lì,luò"},
    { 0x8DDF, "gēn"},
    { 0x8DE0, "yí"},
    { 0x8DE1, "jī"},
    { 0x8DE2, "duò,dài,duō,chí"},
    { 0x8DE3, "xiǎn,xiān,sǔn"},
    { 0x8DE4, "jiāo,qiāo"},
    { 0x8DE5, "duò"},
    { 0x8DE6, "zhū,chú"},
    { 0x8DE7, "quán,zūn"},
    { 0x8DE8, "kuà,kù,kuā,kuǎ"},
    { 0x8DE9, "zhuǎi,shì"},
    { 0x8DEA, "guì"},
    { 0x8DEB, "qióng,qiāng,qiōng"},
    { 0x8DEC, "kuǐ,xiè"},
    { 0x8DED, "xiáng"},
    { 0x8DEE, "chì,dié"},
    { 0x8DEF, "lù,luò"},
    { 0x8DF0, "pián,bèng,bǐng"},
    { 0x8DF1, "zhì"},
    { 0x8DF2, "jiá,jié"},
    { 0x8DF3, "tiào,diào,táo"},
    { 0x8DF4, "cǎi"},
    { 0x8DF5, "jiàn"},
    { 0x8DF6, "dá"},
    { 0x8DF7, "qiāo"},
    { 0x8DF8, "bì"},
    { 0x8DF9, "xiān"},
    { 0x8DFA, "duò"},
    { 0x8DFB, "jī"},
    { 0x8DFC, "jú,qù"},
    { 0x8DFD, "jì"},
    { 0x8DFE, "shū,chōu"},
    { 0x8DFF, "tú,duó,chuō"},
    { 0x8E00, "chù,cù"},
    { 0x8E01, "jìng,kēng"},
    { 0x8E02, "niè"},
    { 0x8E03, "xiāo,qiào"},
    { 0x8E04, "bù"},
    { 0x8E05, "xué,chì"},
    { 0x8E06, "cūn,qūn,cún,zūn,qiù,zhūn"},
    { 0x8E07, "mǔ"},
    { 0x8E08, "shū"},
    { 0x8E09, "liáng,láng,liàng,làng"},
    { 0x8E0A, "yǒng"},
    { 0x8E0B, "jiǎo"},
    { 0x8E0C, "chóu"},
    { 0x8E0D, "qiāo"},
    { 0x8E0E, "móu"},
    { 0x8E0F, "tà,tā"},
    { 0x8E10, "jiàn"},
    { 0x8E11, "qí,jī,jì"},
    { 0x8E12, "wō,wēi,ruí"},
    { 0x8E13, "wěi,cù"},
    { 0x8E14, "chuō,diào,zhuō,tiào,chuò"},
    { 0x8E15, "jié"},
    { 0x8E16, "jí,qì,què"},
    { 0x8E17, "niè"},
    { 0x8E18, "jū"},
    { 0x8E19, "niè"},
    { 0x8E1A, "lún"},
    { 0x8E1B, "lù"},
    { 0x8E1C, "lèng,léng,chěng"},
    { 0x8E1D, "huái"},
    { 0x8E1E, "jù"},
    { 0x8E1F, "chí"},
    { 0x8E20, "wǎn,wò"},
    { 0x8E21, "quán,juǎn"},
    { 0x8E22, "tī,dié"},
    { 0x8E23, "bó,pòu"},
    { 0x8E24, "zú,cù,cuì"},
    { 0x8E25, "qiè"},
    { 0x8E26, "yǐ,qī,jī,jǐ,yì"},
    { 0x8E27, "cù,dí"},
    { 0x8E28, "zōng"},
    { 0x8E29, "cǎi,kuí"},
    { 0x8E2A, "zōng"},
    { 0x8E2B, "pèng,pán"},
    { 0x8E2C, "zhì"},
    { 0x8E2D, "zhēng"},
    { 0x8E2E, "diǎn"},
    { 0x8E2F, "zhí"},
    { 0x8E30, "yú,yáo,chū"},
    { 0x8E31, "duó,chuò,duò"},
    { 0x8E32, "dùn"},
    { 0x8E33, "chuǎn,chǔn,chūn"},
    { 0x8E34, "yǒng"},
    { 0x8E35, "zhǒng,zhòng"},
    { 0x8E36, "dì,zhì,tí,chí,shì"},
    { 0x8E37, "zhǎ"},
    { 0x8E38, "chěn"},
    { 0x8E39, "chuài,shuàn,duàn,chuǎn"},
    { 0x8E3A, "jiàn"},
    { 0x8E3B, "guā,guǎ,tuó"},
    { 0x8E3C, "táng,tǎng,shāng"},
    { 0x8E3D, "jǔ"},
    { 0x8E3E, "fú,bì"},
    { 0x8E3F, "zú"},
    { 0x8E40, "dié"},
    { 0x8E41, "pián"},
    { 0x8E42, "róu,rǒu"},
    { 0x8E43, "nuò,rè,nà"},
    { 0x8E44, "tí,dì"},
    { 0x8E45, "chǎ,zhā"},
    { 0x8E46, "tuǐ"},
    { 0x8E47, "jiǎn"},
    { 0x8E48, "dǎo"},
    { 0x8E49, "cuō"},
    { 0x8E4A, "qī,xī"},
    { 0x8E4B, "tà"},
    { 0x8E4C, "qiāng,qiàng"},
    { 0x8E4D, "niǎn,zhǎn,chán"},
    { 0x8E4E, "diān"},
    { 0x8E4F, "tí"},
    { 0x8E50, "jí"},
    { 0x8E51, "niè"},
    { 0x8E52, "pán,mán"},
    { 0x8E53, "liū,liù"},
    { 0x8E54, "zàn,cán"},
    { 0x8E55, "bì"},
    { 0x8E56, "chōng"},
    { 0x8E57, "lù"},
    { 0x8E58, "liáo"},
    { 0x8E59, "cù"},
    { 0x8E5A, "tāng,tàng,chēng"},
    { 0x8E5B, "dài,diē,dān,zhì"},
    { 0x8E5C, "sù"},
    { 0x8E5D, "xǐ"},
    { 0x8E5E, "kuǐ"},
    { 0x8E5F, "jī"},
    { 0x8E60, "zhí,zhuó"},
    { 0x8E61, "qiāng,qiàng"},
    { 0x8E62, "dí,zhí"},
    { 0x8E63, "pán,mán,liǎng"},
    { 0x8E64, "zōng"},
    { 0x8E65, "lián"},
    { 0x8E66, "bèng"},
    { 0x8E67, "zāo"},
    { 0x8E68, "niǎn,rǎn"},
    { 0x8E69, "bié"},
    { 0x8E6A, "tuí"},
    { 0x8E6B, "jú"},
    { 0x8E6C, "dēng,dèng"},
    { 0x8E6D, "cèng,céng"},
    { 0x8E6E, "xiān"},
    { 0x8E6F, "fán"},
    { 0x8E70, "chú"},
    { 0x8E71, "zhōng,chòng"},
    { 0x8E72, "dūn,zún,cún,zūn,cǔn,cuán,qǔn"},
    { 0x8E73, "bō"},
    { 0x8E74, "cù,zú,jiu"},
    { 0x8E75, "cù"},
    { 0x8E76, "jué,guì,juě"},
    { 0x8E77, "jué"},
    { 0x8E78, "lìn,lín"},
    { 0x8E79, "tá"},
    { 0x8E7A, "qiāo,qiào"},
    { 0x8E7B, "juē,qiāo,jiǎo,jué,jú,xuè"},
    { 0x8E7C, "pǔ"},
    { 0x8E7D, "liāo"},
    { 0x8E7E, "dūn"},
    { 0x8E7F, "cuān"},
    { 0x8E80, "guàn"},
    { 0x8E81, "zào"},
    { 0x8E82, "dá"},
    { 0x8E83, "bì"},
    { 0x8E84, "bì"},
    { 0x8E85, "zhú,zhuó"},
    { 0x8E86, "jù"},
    { 0x8E87, "chú,chuò"},
    { 0x8E88, "qiào"},
    { 0x8E89, "dǔn"},
    { 0x8E8A, "chóu"},
    { 0x8E8B, "jī"},
    { 0x8E8C, "wǔ"},
    { 0x8E8D, "yuè,tì"},
    { 0x8E8E, "niǎn"},
    { 0x8E8F, "lìn"},
    { 0x8E90, "liè"},
    { 0x8E91, "zhí"},
    { 0x8E92, "lì,yuè,luò"},
    { 0x8E93, "zhì,zhī"},
    { 0x8E94, "chán,zhàn"},
    { 0x8E95, "chú"},
    { 0x8E96, "duàn"},
    { 0x8E97, "wèi"},
    { 0x8E98, "lóng,lǒng"},
    { 0x8E99, "lìn"},
    { 0x8E9A, "xiān"},
    { 0x8E9B, "wèi"},
    { 0x8E9C, "zuān"},
    { 0x8E9D, "lán"},
    { 0x8E9E, "xiè"},
    { 0x8E9F, "ráng"},
    { 0x8EA0, "sǎ,xiè"},
    { 0x8EA1, "niè"},
    { 0x8EA2, "tà"},
    { 0x8EA3, "qú"},
    { 0x8EA4, "jí"},
    { 0x8EA5, "cuān"},
    { 0x8EA6, "cuó,zuān"},
    { 0x8EA7, "xǐ"},
    { 0x8EA8, "kuí"},
    { 0x8EA9, "jué,qì"},
    { 0x8EAA, "lìn"},
    { 0x8EAB, "shēn,juān"},
    { 0x8EAC, "gōng"},
    { 0x8EAD, "dān"},
    { 0x8EAE, "fēn"},
    { 0x8EAF, "qū"},
    { 0x8EB0, "tǐ"},
    { 0x8EB1, "duǒ"},
    { 0x8EB2, "duǒ"},
    { 0x8EB3, "gōng"},
    { 0x8EB4, "láng"},
    { 0x8EB5, "rěn"},
    { 0x8EB6, "luǒ"},
    { 0x8EB7, "ǎi"},
    { 0x8EB8, "jī"},
    { 0x8EB9, "jú"},
    { 0x8EBA, "tǎng,tàng"},
    { 0x8EBB, "kōng"},
    { 0x8EBC, "lào"},
    { 0x8EBD, "yǎn,yàn"},
    { 0x8EBE, "měi"},
    { 0x8EBF, "kāng"},
    { 0x8EC0, "qū"},
    { 0x8EC1, "lóu,lǚ"},
    { 0x8EC2, "lào"},
    { 0x8EC3, "duǒ,tuǒ"},
    { 0x8EC4, "zhí"},
    { 0x8EC5, "yàn"},
    { 0x8EC6, "tǐ"},
    { 0x8EC7, "dào"},
    { 0x8EC8, "yīng"},
    { 0x8EC9, "yù"},
    { 0x8ECA, "chē,jū"},
    { 0x8ECB, "yà,zhá,gá"},
    { 0x8ECC, "guǐ"},
    { 0x8ECD, "jūn"},
    { 0x8ECE, "wèi"},
    { 0x8ECF, "yuè"},
    { 0x8ED0, "xìn,xiàn"},
    { 0x8ED1, "dài"},
    { 0x8ED2, "xuān,xiǎn,xiàn,hǎn,jiān"},
    { 0x8ED3, "fàn"},
    { 0x8ED4, "rèn"},
    { 0x8ED5, "shān"},
    { 0x8ED6, "kuáng"},
    { 0x8ED7, "shū"},
    { 0x8ED8, "tún"},
    { 0x8ED9, "chén,qí"},
    { 0x8EDA, "dài"},
    { 0x8EDB, "è"},
    { 0x8EDC, "nà"},
    { 0x8EDD, "qí"},
    { 0x8EDE, "máo"},
    { 0x8EDF, "ruǎn"},
    { 0x8EE0, "kuáng"},
    { 0x8EE1, "qián"},
    { 0x8EE2, "zhuǎn"},
    { 0x8EE3, "hōng"},
    { 0x8EE4, "hū"},
    { 0x8EE5, "qú,gōu,gòu,jū"},
    { 0x8EE6, "kuàng"},
    { 0x8EE7, "dǐ,chí"},
    { 0x8EE8, "líng,lǐng"},
    { 0x8EE9, "dài"},
    { 0x8EEA, "āo,ào"},
    { 0x8EEB, "zhěn"},
    { 0x8EEC, "fàn,bèn"},
    { 0x8EED, "kuāng"},
    { 0x8EEE, "yǎng"},
    { 0x8EEF, "pēng"},
    { 0x8EF0, "bèi"},
    { 0x8EF1, "gū"},
    { 0x8EF2, "gū"},
    { 0x8EF3, "páo"},
    { 0x8EF4, "zhù"},
    { 0x8EF5, "rǒng,fǔ,fù,róng"},
    { 0x8EF6, "è"},
    { 0x8EF7, "bá"},
    { 0x8EF8, "zhóu,zhú,zhòu"},
    { 0x8EF9, "zhǐ"},
    { 0x8EFA, "yáo,diāo"},
    { 0x8EFB, "kē"},
    { 0x8EFC, "yì,dié,zhé"},
    { 0x8EFD, "zhì,qīng"},
    { 0x8EFE, "shì"},
    { 0x8EFF, "píng"},
    { 0x8F00, "ér"},
    { 0x8F01, "gǒng"},
    { 0x8F02, "jú"},
    { 0x8F03, "jiào,jué,xiào"},
    { 0x8F04, "guāng"},
    { 0x8F05, "hé,lù,yà"},
    { 0x8F06, "kǎi,kài"},
    { 0x8F07, "quán,chūn"},
    { 0x8F08, "zhōu"},
    { 0x8F09, "zài,zǎi,dài,zāi,zī"},
    { 0x8F0A, "zhì"},
    { 0x8F0B, "shē"},
    { 0x8F0C, "liàng"},
    { 0x8F0D, "yù"},
    { 0x8F0E, "shāo"},
    { 0x8F0F, "yóu"},
    { 0x8F10, "wàn,yuǎn"},
    { 0x8F11, "yǐn,qūn"},
    { 0x8F12, "zhé"},
    { 0x8F13, "wǎn"},
    { 0x8F14, "fǔ"},
    { 0x8F15, "qīng,qìng"},
    { 0x8F16, "zhōu"},
    { 0x8F17, "ní,yì"},
    { 0x8F18, "léng,líng,lèng"},
    { 0x8F19, "zhé"},
    { 0x8F1A, "zhàn"},
    { 0x8F1B, "liàng"},
    { 0x8F1C, "zī,zì"},
    { 0x8F1D, "huī"},
    { 0x8F1E, "wǎng"},
    { 0x8F1F, "chuò"},
    { 0x8F20, "guǒ,huà,huì"},
    { 0x8F21, "kǎn"},
    { 0x8F22, "yǐ"},
    { 0x8F23, "péng"},
    { 0x8F24, "qiàn"},
    { 0x8F25, "gǔn"},
    { 0x8F26, "niǎn,liǎn"},
    { 0x8F27, "píng,pēng"},
    { 0x8F28, "guǎn"},
    { 0x8F29, "bèi"},
    { 0x8F2A, "lún"},
    { 0x8F2B, "pái"},
    { 0x8F2C, "liáng"},
    { 0x8F2D, "ruǎn,ér"},
    { 0x8F2E, "róu,rǒu"},
    { 0x8F2F, "jí"},
    { 0x8F30, "yáng"},
    { 0x8F31, "xián,kàn"},
    { 0x8F32, "chuán"},
    { 0x8F33, "còu"},
    { 0x8F34, "chūn,shǔn"},
    { 0x8F35, "gé,yà,è,qiè"},
    { 0x8F36, "yóu"},
    { 0x8F37, "hōng"},
    { 0x8F38, "shū,shù"},
    { 0x8F39, "fù,bú"},
    { 0x8F3A, "zī"},
    { 0x8F3B, "fú"},
    { 0x8F3C, "wēn,yūn"},
    { 0x8F3D, "bèn"},
    { 0x8F3E, "zhǎn,niǎn"},
    { 0x8F3F, "yú,yù"},
    { 0x8F40, "wēn"},
    { 0x8F41, "tāo,kǎn"},
    { 0x8F42, "gǔ,gū"},
    { 0x8F43, "zhēn"},
    { 0x8F44, "xiá,hé"},
    { 0x8F45, "yuán"},
    { 0x8F46, "lù"},
    { 0x8F47, "jiāo,xiǎo"},
    { 0x8F48, "cháo"},
    { 0x8F49, "zhuǎn,zhuàn,zhuǎi"},
    { 0x8F4A, "wèi"},
    { 0x8F4B, "hún"},
    { 0x8F4C, "xuě"},
    { 0x8F4D, "zhé"},
    { 0x8F4E, "jiào"},
    { 0x8F4F, "zhàn"},
    { 0x8F50, "bú"},
    { 0x8F51, "lǎo,láo,liáo,liǎo,liào"},
    { 0x8F52, "fén"},
    { 0x8F53, "fān"},
    { 0x8F54, "lín,lìn"},
    { 0x8F55, "gé"},
    { 0x8F56, "sè"},
    { 0x8F57, "kǎn"},
    { 0x8F58, "huán,huàn"},
    { 0x8F59, "yǐ"},
    { 0x8F5A, "jí"},
    { 0x8F5B, "zhuì"},
    { 0x8F5C, "ér"},
    { 0x8F5D, "yù"},
    { 0x8F5E, "jiàn"},
    { 0x8F5F, "hōng"},
    { 0x8F60, "léi"},
    { 0x8F61, "pèi"},
    { 0x8F62, "lì"},
    { 0x8F63, "lì"},
    { 0x8F64, "lú"},
    { 0x8F65, "lìn"},
    { 0x8F66, "chē,jū"},
    { 0x8F67, "yà,gá,zhá"},
    { 0x8F68, "guǐ"},
    { 0x8F69, "xuān"},
    { 0x8F6A, "dài"},
    { 0x8F6B, "rèn"},
    { 0x8F6C, "zhuǎn,zhuǎi,zhuàn"},
    { 0x8F6D, "è"},
    { 0x8F6E, "lún"},
    { 0x8F6F, "ruǎn"},
    { 0x8F70, "hōng"},
    { 0x8F71, "gū"},
    { 0x8F72, "kē,kě"},
    { 0x8F73, "lú"},
    { 0x8F74, "zhóu,zhòu"},
    { 0x8F75, "zhǐ"},
    { 0x8F76, "yì"},
    { 0x8F77, "hū"},
    { 0x8F78, "zhěn"},
    { 0x8F79, "lì"},
    { 0x8F7A, "yáo"},
    { 0x8F7B, "qīng"},
    { 0x8F7C, "shì"},
    { 0x8F7D, "zài,zǎi"},
    { 0x8F7E, "zhì"},
    { 0x8F7F, "jiào"},
    { 0x8F80, "zhōu"},
    { 0x8F81, "quán"},
    { 0x8F82, "lù"},
    { 0x8F83, "jiào"},
    { 0x8F84, "zhé"},
    { 0x8F85, "fǔ"},
    { 0x8F86, "liàng"},
    { 0x8F87, "niǎn"},
    { 0x8F88, "bèi"},
    { 0x8F89, "huī"},
    { 0x8F8A, "gǔn"},
    { 0x8F8B, "wǎng"},
    { 0x8F8C, "liáng"},
    { 0x8F8D, "chuò"},
    { 0x8F8E, "zī"},
    { 0x8F8F, "còu"},
    { 0x8F90, "fú"},
    { 0x8F91, "jí"},
    { 0x8F92, "wēn"},
    { 0x8F93, "shū"},
    { 0x8F94, "pèi"},
    { 0x8F95, "yuán"},
    { 0x8F96, "xiá"},
    { 0x8F97, "niǎn,zhǎn"},
    { 0x8F98, "lù"},
    { 0x8F99, "zhé"},
    { 0x8F9A, "lín"},
    { 0x8F9B, "xīn"},
    { 0x8F9C, "gū"},
    { 0x8F9D, "cí"},
    { 0x8F9E, "cí"},
    { 0x8F9F, "pì,bì,mǐ,pī"},
    { 0x8FA0, "zuì,zuī"},
    { 0x8FA1, "biàn"},
    { 0x8FA2, "là"},
    { 0x8FA3, "là"},
    { 0x8FA4, "cí"},
    { 0x8FA5, "xuē,yì"},
    { 0x8FA6, "bàn"},
    { 0x8FA7, "biàn"},
    { 0x8FA8, "biàn,biǎn,bàn,piàn"},
    { 0x8FA9, "biàn"},
    { 0x8FAA, "xuē"},
    { 0x8FAB, "biàn"},
    { 0x8FAC, "bān"},
    { 0x8FAD, "cí"},
    { 0x8FAE, "biàn"},
    { 0x8FAF, "biàn,pián,biǎn,bàn"},
    { 0x8FB0, "chén"},
    { 0x8FB1, "rǔ"},
    { 0x8FB2, "nóng"},
    { 0x8FB3, "nóng"},
    { 0x8FB4, "chǎn,zhěn"},
    { 0x8FB5, "chuò"},
    { 0x8FB6, "chuò"},
    { 0x8FB7, "yī"},
    { 0x8FB8, "réng"},
    { 0x8FB9, "biān,bian"},
    { 0x8FBA, "biān"},
    { 0x8FBB, "shí"},
    { 0x8FBC, "yū"},
    { 0x8FBD, "liáo"},
    { 0x8FBE, "dá,tì,tà"},
    { 0x8FBF, "chān,chán"},
    { 0x8FC0, "gān"},
    { 0x8FC1, "qiān"},
    { 0x8FC2, "yū"},
    { 0x8FC3, "yū"},
    { 0x8FC4, "qì"},
    { 0x8FC5, "xùn"},
    { 0x8FC6, "yí,yǐ,tuó"},
    { 0x8FC7, "guò,guō"},
    { 0x8FC8, "mài"},
    { 0x8FC9, "qī"},
    { 0x8FCA, "zā"},
    { 0x8FCB, "wàng,guàng,kuáng"},
    { 0x8FCC, "tù"},
    { 0x8FCD, "zhūn"},
    { 0x8FCE, "yíng,yìng"},
    { 0x8FCF, "dá"},
    { 0x8FD0, "yùn,yǔn"},
    { 0x8FD1, "jìn"},
    { 0x8FD2, "háng,xiáng"},
    { 0x8FD3, "yà"},
    { 0x8FD4, "fǎn"},
    { 0x8FD5, "wù,wǔ"},
    { 0x8FD6, "dá"},
    { 0x8FD7, "é"},
    { 0x8FD8, "hái,fú,huán"},
    { 0x8FD9, "zhè,zhèi"},
    { 0x8FDA, "dá"},
    { 0x8FDB, "jìn"},
    { 0x8FDC, "yuǎn"},
    { 0x8FDD, "wéi"},
    { 0x8FDE, "lián"},
    { 0x8FDF, "chí"},
    { 0x8FE0, "chè"},
    { 0x8FE1, "nì,chí"},
    { 0x8FE2, "tiáo"},
    { 0x8FE3, "zhì,chì"},
    { 0x8FE4, "yí,yǐ,tuó"},
    { 0x8FE5, "jiǒng"},
    { 0x8FE6, "jiā,xiè"},
    { 0x8FE7, "chén"},
    { 0x8FE8, "dài"},
    { 0x8FE9, "ěr"},
    { 0x8FEA, "dí"},
    { 0x8FEB, "pò,pǎi"},
    { 0x8FEC, "zhù,wǎng"},
    { 0x8FED, "dié,yì,dá"},
    { 0x8FEE, "zé,zuò"},
    { 0x8FEF, "táo"},
    { 0x8FF0, "shù"},
    { 0x8FF1, "tuó,yí"},
    { 0x8FF2, "qu"},
    { 0x8FF3, "jìng"},
    { 0x8FF4, "huí"},
    { 0x8FF5, "dòng"},
    { 0x8FF6, "yòu"},
    { 0x8FF7, "mí,mì"},
    { 0x8FF8, "bèng"},
    { 0x8FF9, "jì,jī"},
    { 0x8FFA, "nǎi"},
    { 0x8FFB, "yí"},
    { 0x8FFC, "jié"},
    { 0x8FFD, "zhuī,duī,tuī"},
    { 0x8FFE, "liè"},
    { 0x8FFF, "xùn"},
    { 0x9000, "tuì"},
    { 0x9001, "sòng"},
    { 0x9002, "shì,kuò"},
    { 0x9003, "táo"},
    { 0x9004, "páng,féng"},
    { 0x9005, "hòu"},
    { 0x9006, "nì"},
    { 0x9007, "dùn"},
    { 0x9008, "jiǒng"},
    { 0x9009, "xuǎn"},
    { 0x900A, "xùn"},
    { 0x900B, "bū"},
    { 0x900C, "yōu,yóu"},
    { 0x900D, "xiāo"},
    { 0x900E, "qiú"},
    { 0x900F, "tòu,shū"},
    { 0x9010, "zhú,dí,zhòu,tún"},
    { 0x9011, "qiú"},
    { 0x9012, "dì"},
    { 0x9013, "dì"},
    { 0x9014, "tú"},
    { 0x9015, "jìng"},
    { 0x9016, "tì"},
    { 0x9017, "dòu,zhù,tóu,qí"},
    { 0x9018, "yǐ,sì"},
    { 0x9019, "zhè,yàn,zhèi"},
    { 0x901A, "tōng,tòng"},
    { 0x901B, "guàng,kuáng"},
    { 0x901C, "wù,wǔ"},
    { 0x901D, "shì"},
    { 0x901E, "chěng,yíng"},
    { 0x901F, "sù"},
    { 0x9020, "zào,cào,cāo"},
    { 0x9021, "qūn,xùn,suō"},
    { 0x9022, "féng,péng,páng"},
    { 0x9023, "lián,liǎn,liàn,làn"},
    { 0x9024, "suò"},
    { 0x9025, "huí"},
    { 0x9026, "lǐ"},
    { 0x9027, "gǔ"},
    { 0x9028, "lái,lài"},
    { 0x9029, "bèn,bēn"},
    { 0x902A, "cuò"},
    { 0x902B, "jué,zhú"},
    { 0x902C, "bèng,pēng"},
    { 0x902D, "huàn"},
    { 0x902E, "dǎi,dài,dì"},
    { 0x902F, "lù,dài"},
    { 0x9030, "yóu"},
    { 0x9031, "zhōu"},
    { 0x9032, "jìn"},
    { 0x9033, "yù"},
    { 0x9034, "chuō,chuò"},
    { 0x9035, "kuí,kuǐ"},
    { 0x9036, "wēi"},
    { 0x9037, "tì"},
    { 0x9038, "yì"},
    { 0x9039, "dá"},
    { 0x903A, "yuǎn"},
    { 0x903B, "luó"},
    { 0x903C, "bī"},
    { 0x903D, "nuò"},
    { 0x903E, "yú,dòu"},
    { 0x903F, "dàng,táng"},
    { 0x9040, "suí"},
    { 0x9041, "dùn,qūn,xún"},
    { 0x9042, "suì,suí"},
    { 0x9043, "yǎn,àn"},
    { 0x9044, "chuán"},
    { 0x9045, "chí"},
    { 0x9046, "tí"},
    { 0x9047, "yù,yóng,ǒu"},
    { 0x9048, "shí"},
    { 0x9049, "zhēn"},
    { 0x904A, "yóu"},
    { 0x904B, "yùn"},
    { 0x904C, "è"},
    { 0x904D, "biàn"},
    { 0x904E, "guò,guō,guo,huò"},
    { 0x904F, "è"},
    { 0x9050, "xiá"},
    { 0x9051, "huáng"},
    { 0x9052, "qiú,qiū"},
    { 0x9053, "dào,dǎo"},
    { 0x9054, "dá,tà"},
    { 0x9055, "wéi,huí"},
    { 0x9056, "nán"},
    { 0x9057, "yí,wèi"},
    { 0x9058, "gòu"},
    { 0x9059, "yáo"},
    { 0x905A, "chòu"},
    { 0x905B, "liú,liù"},
    { 0x905C, "xùn"},
    { 0x905D, "tà"},
    { 0x905E, "dì,shì,dài"},
    { 0x905F, "chí,zhì,xī"},
    { 0x9060, "yuǎn,yuàn"},
    { 0x9061, "sù"},
    { 0x9062, "tà"},
    { 0x9063, "qiǎn,qiàn"},
    { 0x9064, "mǎ"},
    { 0x9065, "yáo"},
    { 0x9066, "guàn"},
    { 0x9067, "zhāng"},
    { 0x9068, "áo"},
    { 0x9069, "shì,dí,tì,zhé"},
    { 0x906A, "cà"},
    { 0x906B, "chì"},
    { 0x906C, "sù"},
    { 0x906D, "zāo"},
    { 0x906E, "zhē"},
    { 0x906F, "dùn"},
    { 0x9070, "dì,shì,dài"},
    { 0x9071, "lóu"},
    { 0x9072, "chí,zhì"},
    { 0x9073, "cuō"},
    { 0x9074, "lín,lìn"},
    { 0x9075, "zūn"},
    { 0x9076, "rào"},
    { 0x9077, "qiān"},
    { 0x9078, "xuǎn,xuàn,suàn,shuā"},
    { 0x9079, "yù"},
    { 0x907A, "yí,wèi,suí"},
    { 0x907B, "è"},
    { 0x907C, "liáo"},
    { 0x907D, "jù,qú"},
    { 0x907E, "shì"},
    { 0x907F, "bì"},
    { 0x9080, "yāo"},
    { 0x9081, "mài"},
    { 0x9082, "xiè"},
    { 0x9083, "suì"},
    { 0x9084, "hái,huán,xuán"},
    { 0x9085, "zhān,zhàn"},
    { 0x9086, "téng"},
    { 0x9087, "ěr"},
    { 0x9088, "miǎo,miáo"},
    { 0x9089, "biān"},
    { 0x908A, "biān"},
    { 0x908B, "lā,liè"},
    { 0x908C, "lí,chí"},
    { 0x908D, "yuán"},
    { 0x908E, "yáo"},
    { 0x908F, "luó,luò"},
    { 0x9090, "lǐ"},
    { 0x9091, "yì,è"},
    { 0x9092, "tíng"},
    { 0x9093, "dèng,shān"},
    { 0x9094, "qǐ"},
    { 0x9095, "yōng,yǒng"},
    { 0x9096, "shān"},
    { 0x9097, "hán"},
    { 0x9098, "yú"},
    { 0x9099, "máng"},
    { 0x909A, "rú,fù"},
    { 0x909B, "qióng"},
    { 0x909C, "xī"},
    { 0x909D, "kuàng"},
    { 0x909E, "fū"},
    { 0x909F, "kàng,háng,kāng"},
    { 0x90A0, "bīn"},
    { 0x90A1, "fāng,fàng"},
    { 0x90A2, "xíng,gěng"},
    { 0x90A3, "nà,nuó,nuò,nèi,nǎ,něi,né,nā,nǎi,nè"},
    { 0x90A4, "xīn"},
    { 0x90A5, "shěn"},
    { 0x90A6, "bāng"},
    { 0x90A7, "yuán"},
    { 0x90A8, "cūn"},
    { 0x90A9, "huǒ"},
    { 0x90AA, "xié,yá,yé,xú,shé"},
    { 0x90AB, "bāng"},
    { 0x90AC, "wū"},
    { 0x90AD, "jù"},
    { 0x90AE, "yóu"},
    { 0x90AF, "hán,hàn"},
    { 0x90B0, "tái"},
    { 0x90B1, "qiū"},
    { 0x90B2, "bì,biàn"},
    { 0x90B3, "pī"},
    { 0x90B4, "bǐng"},
    { 0x90B5, "shào"},
    { 0x90B6, "bèi"},
    { 0x90B7, "wǎ"},
    { 0x90B8, "dǐ"},
    { 0x90B9, "zōu"},
    { 0x90BA, "yè,qiū"},
    { 0x90BB, "lín"},
    { 0x90BC, "kuāng"},
    { 0x90BD, "guī"},
    { 0x90BE, "zhū"},
    { 0x90BF, "shī"},
    { 0x90C0, "kū"},
    { 0x90C1, "yù"},
    { 0x90C2, "gāi,hái"},
    { 0x90C3, "hé,xiá"},
    { 0x90C4, "qiè,xì"},
    { 0x90C5, "zhì,jí"},
    { 0x90C6, "jí"},
    { 0x90C7, "huán,xún"},
    { 0x90C8, "hòu"},
    { 0x90C9, "xíng"},
    { 0x90CA, "jiāo"},
    { 0x90CB, "xí"},
    { 0x90CC, "guī"},
    { 0x90CD, "nuó,nǎ,fú"},
    { 0x90CE, "láng,làng"},
    { 0x90CF, "jiá"},
    { 0x90D0, "kuài"},
    { 0x90D1, "zhèng"},
    { 0x90D2, "láng"},
    { 0x90D3, "yùn"},
    { 0x90D4, "yán"},
    { 0x90D5, "chéng"},
    { 0x90D6, "dòu"},
    { 0x90D7, "xī,chī"},
    { 0x90D8, "lǚ"},
    { 0x90D9, "fǔ"},
    { 0x90DA, "wú,yú"},
    { 0x90DB, "fú"},
    { 0x90DC, "gào"},
    { 0x90DD, "hǎo,shì"},
    { 0x90DE, "láng"},
    { 0x90DF, "jiá"},
    { 0x90E0, "gěng"},
    { 0x90E1, "jùn"},
    { 0x90E2, "yǐng,chéng"},
    { 0x90E3, "bó"},
    { 0x90E4, "xì"},
    { 0x90E5, "bèi"},
    { 0x90E6, "lì"},
    { 0x90E7, "yún"},
    { 0x90E8, "bù,pǒu"},
    { 0x90E9, "xiáo,ǎo"},
    { 0x90EA, "qī"},
    { 0x90EB, "pí"},
    { 0x90EC, "qīng"},
    { 0x90ED, "guō,guó"},
    { 0x90EE, "zhōu"},
    { 0x90EF, "tán"},
    { 0x90F0, "zōu,jǔ"},
    { 0x90F1, "píng"},
    { 0x90F2, "lái,lěi"},
    { 0x90F3, "ní"},
    { 0x90F4, "chēn,lán"},
    { 0x90F5, "yóu,chuí"},
    { 0x90F6, "bù"},
    { 0x90F7, "xiāng"},
    { 0x90F8, "dān"},
    { 0x90F9, "jú"},
    { 0x90FA, "yōng"},
    { 0x90FB, "qiāo"},
    { 0x90FC, "yī"},
    { 0x90FD, "dōu,dū"},
    { 0x90FE, "yǎn,yān"},
    { 0x90FF, "méi"},
    { 0x9100, "ruò"},
    { 0x9101, "bèi"},
    { 0x9102, "è"},
    { 0x9103, "shū"},
    { 0x9104, "juàn"},
    { 0x9105, "yǔ"},
    { 0x9106, "yùn"},
    { 0x9107, "hóu"},
    { 0x9108, "kuí"},
    { 0x9109, "xiāng,xiǎng,xiàng"},
    { 0x910A, "xiāng"},
    { 0x910B, "sōu"},
    { 0x910C, "táng"},
    { 0x910D, "míng"},
    { 0x910E, "xī"},
    { 0x910F, "rǔ"},
    { 0x9110, "chù"},
    { 0x9111, "zī"},
    { 0x9112, "zōu,jù"},
    { 0x9113, "yè"},
    { 0x9114, "wū"},
    { 0x9115, "xiāng"},
    { 0x9116, "yún"},
    { 0x9117, "hào,qiāo,jiāo"},
    { 0x9118, "yōng"},
    { 0x9119, "bǐ"},
    { 0x911A, "mào,mò"},
    { 0x911B, "cháo"},
    { 0x911C, "fū,lù"},
    { 0x911D, "liǎo"},
    { 0x911E, "yín"},
    { 0x911F, "zhuān"},
    { 0x9120, "hù"},
    { 0x9121, "qiāo"},
    { 0x9122, "yān"},
    { 0x9123, "zhāng,zhàng"},
    { 0x9124, "màn,wàn"},
    { 0x9125, "qiāo"},
    { 0x9126, "xǔ"},
    { 0x9127, "dèng"},
    { 0x9128, "bì"},
    { 0x9129, "xún"},
    { 0x912A, "bì"},
    { 0x912B, "zēng,céng"},
    { 0x912C, "wéi"},
    { 0x912D, "zhèng"},
    { 0x912E, "mào"},
    { 0x912F, "shàn"},
    { 0x9130, "lín,lìn"},
    { 0x9131, "pó,pí,pán"},
    { 0x9132, "dān,duō"},
    { 0x9133, "méng"},
    { 0x9134, "yè"},
    { 0x9135, "cào,sāo"},
    { 0x9136, "kuài"},
    { 0x9137, "fēng"},
    { 0x9138, "méng"},
    { 0x9139, "zōu,jù"},
    { 0x913A, "kuàng,kuò"},
    { 0x913B, "liǎn"},
    { 0x913C, "zàn"},
    { 0x913D, "chán"},
    { 0x913E, "yōu"},
    { 0x913F, "jī,qí"},
    { 0x9140, "yàn,yǎn"},
    { 0x9141, "chán"},
    { 0x9142, "cuó,zàn"},
    { 0x9143, "líng"},
    { 0x9144, "huān,quān"},
    { 0x9145, "xī"},
    { 0x9146, "fēng"},
    { 0x9147, "zàn,cuó"},
    { 0x9148, "lì,lí,zhí"},
    { 0x9149, "yǒu"},
    { 0x914A, "dīng,dǐng"},
    { 0x914B, "qiú"},
    { 0x914C, "zhuó"},
    { 0x914D, "pèi"},
    { 0x914E, "zhòu"},
    { 0x914F, "yǐ,yí"},
    { 0x9150, "gān,hàng"},
    { 0x9151, "yú"},
    { 0x9152, "jiǔ"},
    { 0x9153, "yǎn,yàn,yǐn"},
    { 0x9154, "zuì"},
    { 0x9155, "máo"},
    { 0x9156, "zhèn,dān"},
    { 0x9157, "xù"},
    { 0x9158, "dòu"},
    { 0x9159, "zhēn"},
    { 0x915A, "fēn"},
    { 0x915B, "yuán"},
    { 0x915C, "fu"},
    { 0x915D, "yùn"},
    { 0x915E, "tài"},
    { 0x915F, "tiān"},
    { 0x9160, "qiǎ"},
    { 0x9161, "tuó,duò"},
    { 0x9162, "cù,zuò"},
    { 0x9163, "hān,hàn"},
    { 0x9164, "gū"},
    { 0x9165, "sū"},
    { 0x9166, "pò,fā,pō"},
    { 0x9167, "chóu"},
    { 0x9168, "zài,zuì"},
    { 0x9169, "mǐng"},
    { 0x916A, "lào,luò,lù"},
    { 0x916B, "chuò"},
    { 0x916C, "chóu"},
    { 0x916D, "yòu"},
    { 0x916E, "tóng,dòng,chóng"},
    { 0x916F, "zhǐ"},
    { 0x9170, "xiān"},
    { 0x9171, "jiàng"},
    { 0x9172, "chéng"},
    { 0x9173, "yìn"},
    { 0x9174, "tú"},
    { 0x9175, "jiào"},
    { 0x9176, "méi"},
    { 0x9177, "kù"},
    { 0x9178, "suān"},
    { 0x9179, "lèi"},
    { 0x917A, "pú"},
    { 0x917B, "zuì,fú"},
    { 0x917C, "hǎi"},
    { 0x917D, "yàn"},
    { 0x917E, "shāi,shī"},
    { 0x917F, "niàng,niáng"},
    { 0x9180, "wéi,zhuì"},
    { 0x9181, "lù"},
    { 0x9182, "lǎn"},
    { 0x9183, "yān,āng"},
    { 0x9184, "táo"},
    { 0x9185, "pēi"},
    { 0x9186, "zhǎn"},
    { 0x9187, "chún"},
    { 0x9188, "tán,dàn"},
    { 0x9189, "zuì"},
    { 0x918A, "zhuì"},
    { 0x918B, "cù,zuò"},
    { 0x918C, "kūn"},
    { 0x918D, "tí,tǐ"},
    { 0x918E, "xián,jiǎn"},
    { 0x918F, "dū"},
    { 0x9190, "hú"},
    { 0x9191, "xǔ"},
    { 0x9192, "xǐng,chéng,jīng"},
    { 0x9193, "tǎn"},
    { 0x9194, "qiú,chōu"},
    { 0x9195, "chún"},
    { 0x9196, "yùn"},
    { 0x9197, "pò"},
    { 0x9198, "kē"},
    { 0x9199, "sōu"},
    { 0x919A, "mí"},
    { 0x919B, "quán,chuò"},
    { 0x919C, "chǒu"},
    { 0x919D, "cuō,cuǒ"},
    { 0x919E, "yùn"},
    { 0x919F, "yòng"},
    { 0x91A0, "àng"},
    { 0x91A1, "zhà"},
    { 0x91A2, "hǎi"},
    { 0x91A3, "táng"},
    { 0x91A4, "jiàng"},
    { 0x91A5, "piǎo"},
    { 0x91A6, "chěn,chǎn"},
    { 0x91A7, "yù,ōu"},
    { 0x91A8, "lí"},
    { 0x91A9, "zāo"},
    { 0x91AA, "láo"},
    { 0x91AB, "yī,yǐ"},
    { 0x91AC, "jiàng"},
    { 0x91AD, "bú"},
    { 0x91AE, "jiào,qiáo,zhàn"},
    { 0x91AF, "xī"},
    { 0x91B0, "tán"},
    { 0x91B1, "fā,pò,pō"},
    { 0x91B2, "nóng"},
    { 0x91B3, "yì,shì"},
    { 0x91B4, "lǐ"},
    { 0x91B5, "jù"},
    { 0x91B6, "yàn,liǎn,xiān,jiǎn"},
    { 0x91B7, "yì,yǐ,ài"},
    { 0x91B8, "niàng"},
    { 0x91B9, "rú"},
    { 0x91BA, "xūn"},
    { 0x91BB, "chóu,shòu,dào"},
    { 0x91BC, "yàn"},
    { 0x91BD, "líng"},
    { 0x91BE, "mí"},
    { 0x91BF, "mí"},
    { 0x91C0, "niàng,niáng"},
    { 0x91C1, "xìn"},
    { 0x91C2, "jiào"},
    { 0x91C3, "shāi,shī,lí"},
    { 0x91C4, "mí"},
    { 0x91C5, "yàn"},
    { 0x91C6, "biàn,biǎn"},
    { 0x91C7, "cǎi,cài"},
    { 0x91C8, "shì"},
    { 0x91C9, "yòu"},
    { 0x91CA, "shì"},
    { 0x91CB, "shì,yì"},
    { 0x91CC, "lǐ,li"},
    { 0x91CD, "zhòng,chóng,tóng"},
    { 0x91CE, "yě,shù"},
    { 0x91CF, "liàng,liáng"},
    { 0x91D0, "lí,xī,lái,tāi,lài,xǐ"},
    { 0x91D1, "jīn,jìn"},
    { 0x91D2, "jīn"},
    { 0x91D3, "qiú,gá"},
    { 0x91D4, "yǐ"},
    { 0x91D5, "liǎo,liào"},
    { 0x91D6, "dāo"},
    { 0x91D7, "zhāo"},
    { 0x91D8, "dīng,dìng,líng"},
    { 0x91D9, "pò,pō"},
    { 0x91DA, "qiú"},
    { 0x91DB, "bā"},
    { 0x91DC, "fǔ"},
    { 0x91DD, "zhēn"},
    { 0x91DE, "zhí"},
    { 0x91DF, "bā"},
    { 0x91E0, "luàn"},
    { 0x91E1, "fǔ"},
    { 0x91E2, "nǎi"},
    { 0x91E3, "diào"},
    { 0x91E4, "shàn,shān,xiān"},
    { 0x91E5, "qiǎo,jiǎo"},
    { 0x91E6, "kòu"},
    { 0x91E7, "chuàn,chuān"},
    { 0x91E8, "zǐ"},
    { 0x91E9, "fǎn,fàn,fán"},
    { 0x91EA, "huá,yú"},
    { 0x91EB, "huá,wū"},
    { 0x91EC, "hàn,gān"},
    { 0x91ED, "gāng,gōng"},
    { 0x91EE, "qí"},
    { 0x91EF, "máng"},
    { 0x91F0, "rì,rèn,jiàn"},
    { 0x91F1, "dì"},
    { 0x91F2, "sì"},
    { 0x91F3, "xì"},
    { 0x91F4, "yì"},
    { 0x91F5, "chāi,chā"},
    { 0x91F6, "shī,yí,yě"},
    { 0x91F7, "tǔ"},
    { 0x91F8, "xī"},
    { 0x91F9, "nǚ"},
    { 0x91FA, "qiān"},
    { 0x91FB, "qiú"},
    { 0x91FC, "jiàn"},
    { 0x91FD, "pì,pī,zhāo"},
    { 0x91FE, "yé,yá"},
    { 0x91FF, "jīn,yǐn,yín"},
    { 0x9200, "bǎ,bā,pá"},
    { 0x9201, "fāng"},
    { 0x9202, "chén,qín,zhèn"},
    { 0x9203, "xíng"},
    { 0x9204, "dǒu"},
    { 0x9205, "yuè"},
    { 0x9206, "qiān,zhōng"},
    { 0x9207, "fū,fǔ"},
    { 0x9208, "pī,bù"},
    { 0x9209, "nà,ruì"},
    { 0x920A, "xīn,qìn"},
    { 0x920B, "é"},
    { 0x920C, "jué"},
    { 0x920D, "dùn"},
    { 0x920E, "gōu"},
    { 0x920F, "yǐn"},
    { 0x9210, "qián,hán"},
    { 0x9211, "bǎn"},
    { 0x9212, "sà,xì"},
    { 0x9213, "rén"},
    { 0x9214, "chāo,chǎo"},
    { 0x9215, "niǔ,chǒu"},
    { 0x9216, "fēn"},
    { 0x9217, "yǔn,duì"},
    { 0x9218, "yǐ"},
    { 0x9219, "qín"},
    { 0x921A, "pī,bī,bǐ"},
    { 0x921B, "guō"},
    { 0x921C, "hóng"},
    { 0x921D, "yín"},
    { 0x921E, "jūn"},
    { 0x921F, "diào"},
    { 0x9220, "yì"},
    { 0x9221, "zhōng"},
    { 0x9222, "xǐ"},
    { 0x9223, "gài"},
    { 0x9224, "rì"},
    { 0x9225, "huǒ"},
    { 0x9226, "tài"},
    { 0x9227, "kàng"},
    { 0x9228, "yuán"},
    { 0x9229, "lú"},
    { 0x922A, "è"},
    { 0x922B, "qín"},
    { 0x922C, "duó"},
    { 0x922D, "zī"},
    { 0x922E, "nǐ,ní"},
    { 0x922F, "tú"},
    { 0x9230, "shì"},
    { 0x9231, "mín,mǐn"},
    { 0x9232, "gū,pì"},
    { 0x9233, "kē"},
    { 0x9234, "líng"},
    { 0x9235, "bǐng"},
    { 0x9236, "sì,cí,tái"},
    { 0x9237, "gǔ,hú,gù"},
    { 0x9238, "bó"},
    { 0x9239, "pī,pí"},
    { 0x923A, "yù"},
    { 0x923B, "sì"},
    { 0x923C, "zuó"},
    { 0x923D, "bū"},
    { 0x923E, "yóu,zhòu"},
    { 0x923F, "tián,diàn"},
    { 0x9240, "jiǎ,gé"},
    { 0x9241, "zhēn,zhèn"},
    { 0x9242, "shǐ"},
    { 0x9243, "shì,zú"},
    { 0x9244, "zhí,tiě"},
    { 0x9245, "jù"},
    { 0x9246, "chān,qián,tiē"},
    { 0x9247, "shī,yí"},
    { 0x9248, "shī,shé,yí,tuó,tā"},
    { 0x9249, "xuàn"},
    { 0x924A, "zhāo"},
    { 0x924B, "bào,páo,báo"},
    { 0x924C, "hé"},
    { 0x924D, "bì,sè"},
    { 0x924E, "shēng"},
    { 0x924F, "chú,zū,zhù,jǔ,chá,xú"},
    { 0x9250, "shí,zú"},
    { 0x9251, "bó"},
    { 0x9252, "zhù"},
    { 0x9253, "chì"},
    { 0x9254, "zā"},
    { 0x9255, "pō,pǒ"},
    { 0x9256, "tóng"},
    { 0x9257, "qián,ān"},
    { 0x9258, "fú"},
    { 0x9259, "zhǎi"},
    { 0x925A, "liǔ,mǎo"},
    { 0x925B, "qiān,yán"},
    { 0x925C, "fú"},
    { 0x925D, "lì"},
    { 0x925E, "yuè"},
    { 0x925F, "pī"},
    { 0x9260, "yāng"},
    { 0x9261, "bàn"},
    { 0x9262, "bō"},
    { 0x9263, "jié"},
    { 0x9264, "gōu,gòu,qú"},
    { 0x9265, "shù,xù"},
    { 0x9266, "zhēng"},
    { 0x9267, "mǔ"},
    { 0x9268, "xǐ,nǐ,niě"},
    { 0x9269, "xǐ,niè"},
    { 0x926A, "dì"},
    { 0x926B, "jiā"},
    { 0x926C, "mù"},
    { 0x926D, "tǎn"},
    { 0x926E, "huán,shén,shēn"},
    { 0x926F, "yǐ"},
    { 0x9270, "sī"},
    { 0x9271, "kuàng"},
    { 0x9272, "kǎ"},
    { 0x9273, "běi"},
    { 0x9274, "jiàn"},
    { 0x9275, "tóng,zhuó"},
    { 0x9276, "xíng"},
    { 0x9277, "hóng"},
    { 0x9278, "jiǎo"},
    { 0x9279, "chǐ"},
    { 0x927A, "èr,kēng,ěr"},
    { 0x927B, "luò,gē,gè"},
    { 0x927C, "bǐng,píng"},
    { 0x927D, "shì"},
    { 0x927E, "móu,máo"},
    { 0x927F, "jiā,gē,kē,hā"},
    { 0x9280, "yín"},
    { 0x9281, "jūn"},
    { 0x9282, "zhōu"},
    { 0x9283, "chòng"},
    { 0x9284, "xiǎng,jiōng"},
    { 0x9285, "tóng"},
    { 0x9286, "mò"},
    { 0x9287, "lèi"},
    { 0x9288, "jī"},
    { 0x9289, "yù,sì"},
    { 0x928A, "xù,huì"},
    { 0x928B, "rén,rěn"},
    { 0x928C, "zùn"},
    { 0x928D, "zhì"},
    { 0x928E, "qióng,qiōng"},
    { 0x928F, "shàn,shuò"},
    { 0x9290, "chì,lì"},
    { 0x9291, "xiǎn,xiān,xǐ"},
    { 0x9292, "xíng,jiān"},
    { 0x9293, "quán"},
    { 0x9294, "pī"},
    { 0x9295, "tiě,yí"},
    { 0x9296, "zhū"},
    { 0x9297, "xiàng,hóu"},
    { 0x9298, "míng"},
    { 0x9299, "kuǎ"},
    { 0x929A, "yáo,diào,tiáo,qiāo,yào"},
    { 0x929B, "xiān,tiǎn,guā"},
    { 0x929C, "xián"},
    { 0x929D, "xiū"},
    { 0x929E, "jūn"},
    { 0x929F, "chā"},
    { 0x92A0, "lǎo"},
    { 0x92A1, "jí"},
    { 0x92A2, "pǐ"},
    { 0x92A3, "rú"},
    { 0x92A4, "mǐ"},
    { 0x92A5, "yī"},
    { 0x92A6, "yīn"},
    { 0x92A7, "guāng"},
    { 0x92A8, "ǎn"},
    { 0x92A9, "diū"},
    { 0x92AA, "yǒu"},
    { 0x92AB, "sè"},
    { 0x92AC, "kào"},
    { 0x92AD, "qián"},
    { 0x92AE, "luán"},
    { 0x92AF, "sī"},
    { 0x92B0, "āi"},
    { 0x92B1, "diào"},
    { 0x92B2, "hàn"},
    { 0x92B3, "ruì"},
    { 0x92B4, "shì,zhì"},
    { 0x92B5, "kēng"},
    { 0x92B6, "qiú"},
    { 0x92B7, "xiāo"},
    { 0x92B8, "zhé,niè"},
    { 0x92B9, "xiù,yòu"},
    { 0x92BA, "zàng"},
    { 0x92BB, "tí,tī"},
    { 0x92BC, "cuò"},
    { 0x92BD, "guā"},
    { 0x92BE, "hòng,gǒng"},
    { 0x92BF, "zhōng,yōng"},
    { 0x92C0, "tōu,dòu,tù"},
    { 0x92C1, "lǚ,lǜ"},
    { 0x92C2, "méi,méng"},
    { 0x92C3, "láng"},
    { 0x92C4, "wàn"},
    { 0x92C5, "xīn,zǐ"},
    { 0x92C6, "yún,jūn"},
    { 0x92C7, "bèi"},
    { 0x92C8, "wù"},
    { 0x92C9, "sù"},
    { 0x92CA, "yù"},
    { 0x92CB, "chán,yán"},
    { 0x92CC, "dìng,tǐng"},
    { 0x92CD, "bó"},
    { 0x92CE, "hàn"},
    { 0x92CF, "jiá"},
    { 0x92D0, "hóng"},
    { 0x92D1, "cuān,jiān,juān"},
    { 0x92D2, "fēng"},
    { 0x92D3, "chān"},
    { 0x92D4, "wǎn"},
    { 0x92D5, "zhì"},
    { 0x92D6, "sī,tuó"},
    { 0x92D7, "xuān,juān,juàn"},
    { 0x92D8, "huá,wú,hú"},
    { 0x92D9, "yǔ,yú,wú"},
    { 0x92DA, "tiáo"},
    { 0x92DB, "kuàng"},
    { 0x92DC, "zhuó,chuò"},
    { 0x92DD, "lüè"},
    { 0x92DE, "xíng,xìng,jīng"},
    { 0x92DF, "qǐn,qiān,qīn,jìn"},
    { 0x92E0, "shèn"},
    { 0x92E1, "hán"},
    { 0x92E2, "lüè"},
    { 0x92E3, "yé"},
    { 0x92E4, "chú,jǔ"},
    { 0x92E5, "zèng"},
    { 0x92E6, "jū,jú"},
    { 0x92E7, "xiàn"},
    { 0x92E8, "tiě,é"},
    { 0x92E9, "máng"},
    { 0x92EA, "pù,pū"},
    { 0x92EB, "lí"},
    { 0x92EC, "pàn"},
    { 0x92ED, "ruì,duì,yuè"},
    { 0x92EE, "chéng"},
    { 0x92EF, "gào"},
    { 0x92F0, "lǐ"},
    { 0x92F1, "tè"},
    { 0x92F2, "bīng"},
    { 0x92F3, "zhù"},
    { 0x92F4, "zhèn"},
    { 0x92F5, "tū"},
    { 0x92F6, "liǔ"},
    { 0x92F7, "zuì,niè"},
    { 0x92F8, "jù,jū"},
    { 0x92F9, "chǎng"},
    { 0x92FA, "yuǎn,yuān,wǎn,wān"},
    { 0x92FB, "jiàn,jiān"},
    { 0x92FC, "gāng,gàng"},
    { 0x92FD, "diào"},
    { 0x92FE, "táo"},
    { 0x92FF, "cháng"},
    { 0x9300, "lún,fēn"},
    { 0x9301, "guǒ,kuǎ,kè"},
    { 0x9302, "líng"},
    { 0x9303, "pī"},
    { 0x9304, "lù"},
    { 0x9305, "lí"},
    { 0x9306, "qiāng"},
    { 0x9307, "póu,fú,péi"},
    { 0x9308, "juǎn"},
    { 0x9309, "mín"},
    { 0x930A, "zuì,zū"},
    { 0x930B, "péng,bèng"},
    { 0x930C, "àn"},
    { 0x930D, "pī,bēi,bī,pí"},
    { 0x930E, "xiàn,gàn,qiàn"},
    { 0x930F, "yā,yà"},
    { 0x9310, "zhuī"},
    { 0x9311, "lèi,lì"},
    { 0x9312, "kē,ā"},
    { 0x9313, "kōng"},
    { 0x9314, "tà"},
    { 0x9315, "kūn,gǔn"},
    { 0x9316, "dú"},
    { 0x9317, "nèi,zhuì,wèi"},
    { 0x9318, "chuí"},
    { 0x9319, "zī"},
    { 0x931A, "zhēng"},
    { 0x931B, "bēn"},
    { 0x931C, "niè"},
    { 0x931D, "zòng"},
    { 0x931E, "chún,duì,duò"},
    { 0x931F, "tán,xiān,yǎn"},
    { 0x9320, "dìng"},
    { 0x9321, "qí,yǐ"},
    { 0x9322, "qián,jiǎn"},
    { 0x9323, "zhuì,chuò"},
    { 0x9324, "jī"},
    { 0x9325, "yù"},
    { 0x9326, "jǐn"},
    { 0x9327, "guǎn"},
    { 0x9328, "máo"},
    { 0x9329, "chāng"},
    { 0x932A, "tiǎn,tǔn"},
    { 0x932B, "xī,tì"},
    { 0x932C, "liàn"},
    { 0x932D, "táo,diāo"},
    { 0x932E, "gù"},
    { 0x932F, "cuò,cù,xī"},
    { 0x9330, "shù"},
    { 0x9331, "zhēn"},
    { 0x9332, "lù,lǜ"},
    { 0x9333, "měng"},
    { 0x9334, "lù"},
    { 0x9335, "huā"},
    { 0x9336, "biǎo"},
    { 0x9337, "gá"},
    { 0x9338, "lái"},
    { 0x9339, "kěn"},
    { 0x933A, "fāng"},
    { 0x933B, "wu"},
    { 0x933C, "nài"},
    { 0x933D, "wàn,jiǎn"},
    { 0x933E, "zàn"},
    { 0x933F, "hǔ"},
    { 0x9340, "dé"},
    { 0x9341, "xiān"},
    { 0x9342, "piān"},
    { 0x9343, "huō"},
    { 0x9344, "liàng"},
    { 0x9345, "fǎ"},
    { 0x9346, "mén"},
    { 0x9347, "kǎi,jiē,jiě"},
    { 0x9348, "yīng"},
    { 0x9349, "dī,chí,dí,shì"},
    { 0x934A, "liàn,jiàn"},
    { 0x934B, "guō,guǒ"},
    { 0x934C, "xiǎn"},
    { 0x934D, "dù"},
    { 0x934E, "tú"},
    { 0x934F, "wéi"},
    { 0x9350, "zōng"},
    { 0x9351, "fù"},
    { 0x9352, "róu"},
    { 0x9353, "jí"},
    { 0x9354, "è"},
    { 0x9355, "jūn"},
    { 0x9356, "chěn,zhēn"},
    { 0x9357, "tí"},
    { 0x9358, "zhá"},
    { 0x9359, "hù"},
    { 0x935A, "yáng"},
    { 0x935B, "duàn"},
    { 0x935C, "xiá"},
    { 0x935D, "yú"},
    { 0x935E, "kēng"},
    { 0x935F, "shēng"},
    { 0x9360, "huáng"},
    { 0x9361, "wěi"},
    { 0x9362, "fù"},
    { 0x9363, "zhāo"},
    { 0x9364, "chā"},
    { 0x9365, "qiè"},
    { 0x9366, "shī,shé"},
    { 0x9367, "hōng"},
    { 0x9368, "kuí"},
    { 0x9369, "tiǎn,nuò"},
    { 0x936A, "móu"},
    { 0x936B, "qiāo"},
    { 0x936C, "qiāo"},
    { 0x936D, "hóu"},
    { 0x936E, "tōu"},
    { 0x936F, "cōng"},
    { 0x9370, "huán"},
    { 0x9371, "yè,xié"},
    { 0x9372, "mín"},
    { 0x9373, "jiàn"},
    { 0x9374, "duān"},
    { 0x9375, "jiàn"},
    { 0x9376, "sōng,sī"},
    { 0x9377, "kuí"},
    { 0x9378, "hú"},
    { 0x9379, "xuān"},
    { 0x937A, "duǒ,dǔ,zhě"},
    { 0x937B, "jié"},
    { 0x937C, "zhēn,qián"},
    { 0x937D, "biān"},
    { 0x937E, "zhōng"},
    { 0x937F, "zī"},
    { 0x9380, "xiū"},
    { 0x9381, "yé"},
    { 0x9382, "měi"},
    { 0x9383, "pài"},
    { 0x9384, "āi"},
    { 0x9385, "jiè"},
    { 0x9386, "qian"},
    { 0x9387, "méi"},
    { 0x9388, "suǒ,chā"},
    { 0x9389, "dá,tà"},
    { 0x938A, "bàng,pāng"},
    { 0x938B, "xiá"},
    { 0x938C, "lián"},
    { 0x938D, "suǒ,sè"},
    { 0x938E, "kài"},
    { 0x938F, "liú"},
    { 0x9390, "yáo,zú"},
    { 0x9391, "yè,tà,gé"},
    { 0x9392, "nòu,hāo"},
    { 0x9393, "wēng"},
    { 0x9394, "róng"},
    { 0x9395, "táng"},
    { 0x9396, "suǒ"},
    { 0x9397, "qiāng,chēng,qiàng"},
    { 0x9398, "lì,gé"},
    { 0x9399, "shuò"},
    { 0x939A, "chuí,duī,zhuì"},
    { 0x939B, "bó"},
    { 0x939C, "pán"},
    { 0x939D, "dā,sà"},
    { 0x939E, "bī,pī"},
    { 0x939F, "sǎng"},
    { 0x93A0, "gāng"},
    { 0x93A1, "zī"},
    { 0x93A2, "wū"},
    { 0x93A3, "yíng,yīng,jiǒng"},
    { 0x93A4, "huàng"},
    { 0x93A5, "tiáo"},
    { 0x93A6, "liú,liù"},
    { 0x93A7, "kǎi"},
    { 0x93A8, "sǔn"},
    { 0x93A9, "shā,shì,sè"},
    { 0x93AA, "sōu"},
    { 0x93AB, "wàn"},
    { 0x93AC, "hào,gǎo"},
    { 0x93AD, "zhèn"},
    { 0x93AE, "zhèn,zhēn,tián"},
    { 0x93AF, "láng,luǒ"},
    { 0x93B0, "yì"},
    { 0x93B1, "yuán"},
    { 0x93B2, "tǎng"},
    { 0x93B3, "niè"},
    { 0x93B4, "xí"},
    { 0x93B5, "jiā"},
    { 0x93B6, "gē"},
    { 0x93B7, "mǎ"},
    { 0x93B8, "juān"},
    { 0x93B9, "sòng"},
    { 0x93BA, "zǔ"},
    { 0x93BB, "suǒ"},
    { 0x93BC, "xià"},
    { 0x93BD, "fēng"},
    { 0x93BE, "wēn"},
    { 0x93BF, "ná"},
    { 0x93C0, "lǔ"},
    { 0x93C1, "suǒ"},
    { 0x93C2, "ōu,kōu"},
    { 0x93C3, "zú,chuò"},
    { 0x93C4, "tuán"},
    { 0x93C5, "xiū,xiù"},
    { 0x93C6, "guàn"},
    { 0x93C7, "xuàn,xuán"},
    { 0x93C8, "liàn,lián"},
    { 0x93C9, "shòu,sōu"},
    { 0x93CA, "ào"},
    { 0x93CB, "mǎn"},
    { 0x93CC, "mò"},
    { 0x93CD, "luó"},
    { 0x93CE, "bì"},
    { 0x93CF, "wèi"},
    { 0x93D0, "liú,liù,liáo"},
    { 0x93D1, "dí,dī"},
    { 0x93D2, "sǎn,qiāo,càn"},
    { 0x93D3, "zǒng,cōng"},
    { 0x93D4, "yí"},
    { 0x93D5, "lù,áo"},
    { 0x93D6, "áo,biāo"},
    { 0x93D7, "kēng"},
    { 0x93D8, "qiāng"},
    { 0x93D9, "cuī"},
    { 0x93DA, "qī"},
    { 0x93DB, "cháng"},
    { 0x93DC, "tāng,táng"},
    { 0x93DD, "màn"},
    { 0x93DE, "yōng"},
    { 0x93DF, "chǎn"},
    { 0x93E0, "fēng"},
    { 0x93E1, "jìng"},
    { 0x93E2, "biāo"},
    { 0x93E3, "shù"},
    { 0x93E4, "lòu,lǘ"},
    { 0x93E5, "xiù"},
    { 0x93E6, "cōng"},
    { 0x93E7, "lóng"},
    { 0x93E8, "zàn"},
    { 0x93E9, "jiàn,zàn"},
    { 0x93EA, "cáo"},
    { 0x93EB, "lí"},
    { 0x93EC, "xià"},
    { 0x93ED, "xī"},
    { 0x93EE, "kāng"},
    { 0x93EF, "shuǎng"},
    { 0x93F0, "bèng"},
    { 0x93F1, "zhang"},
    { 0x93F2, "qian"},
    { 0x93F3, "chēng"},
    { 0x93F4, "lù"},
    { 0x93F5, "huá"},
    { 0x93F6, "jí"},
    { 0x93F7, "pú"},
    { 0x93F8, "huì,suì,ruì"},
    { 0x93F9, "qiǎng,qiāng"},
    { 0x93FA, "pō"},
    { 0x93FB, "lín"},
    { 0x93FC, "sè"},
    { 0x93FD, "xiù"},
    { 0x93FE, "sǎn,xiàn,sà"},
    { 0x93FF, "chēng"},
    { 0x9400, "kuì"},
    { 0x9401, "sī"},
    { 0x9402, "liú"},
    { 0x9403, "náo,nào"},
    { 0x9404, "huáng"},
    { 0x9405, "piě"},
    { 0x9406, "suì"},
    { 0x9407, "fán"},
    { 0x9408, "qiáo"},
    { 0x9409, "quān"},
    { 0x940A, "yáng"},
    { 0x940B, "tāng,tàng"},
    { 0x940C, "xiàng"},
    { 0x940D, "jué,yù"},
    { 0x940E, "jiāo"},
    { 0x940F, "zūn"},
    { 0x9410, "liáo"},
    { 0x9411, "qiè"},
    { 0x9412, "láo"},
    { 0x9413, "duì,duī,dūn"},
    { 0x9414, "xín"},
    { 0x9415, "zān"},
    { 0x9416, "jī,qí"},
    { 0x9417, "jiǎn"},
    { 0x9418, "zhōng"},
    { 0x9419, "dèng,dēng"},
    { 0x941A, "yā"},
    { 0x941B, "yǐng"},
    { 0x941C, "duī,dūn"},
    { 0x941D, "jué"},
    { 0x941E, "nòu"},
    { 0x941F, "zān,tì"},
    { 0x9420, "pǔ"},
    { 0x9421, "tiě"},
    { 0x9422, "fán"},
    { 0x9423, "chēng"},
    { 0x9424, "dǐng"},
    { 0x9425, "shàn"},
    { 0x9426, "kāi"},
    { 0x9427, "jiān,jiǎn"},
    { 0x9428, "fèi"},
    { 0x9429, "suì"},
    { 0x942A, "lǔ"},
    { 0x942B, "juān"},
    { 0x942C, "huì"},
    { 0x942D, "yù"},
    { 0x942E, "lián"},
    { 0x942F, "zhuó"},
    { 0x9430, "qiāo,sào,cáo"},
    { 0x9431, "jiàn,qiān"},
    { 0x9432, "zhuó,shǔ"},
    { 0x9433, "léi"},
    { 0x9434, "bì,bèi"},
    { 0x9435, "tiě,dié"},
    { 0x9436, "huán,xuàn"},
    { 0x9437, "yè"},
    { 0x9438, "duó"},
    { 0x9439, "guǒ,guō"},
    { 0x943A, "dāng,chēng,tāng"},
    { 0x943B, "jù,qú"},
    { 0x943C, "fén,bēn"},
    { 0x943D, "dá"},
    { 0x943E, "bèi"},
    { 0x943F, "yì"},
    { 0x9440, "ài"},
    { 0x9441, "zōng"},
    { 0x9442, "xùn"},
    { 0x9443, "diào"},
    { 0x9444, "zhù"},
    { 0x9445, "héng"},
    { 0x9446, "zhuì"},
    { 0x9447, "jī"},
    { 0x9448, "niè,nǐ"},
    { 0x9449, "hé"},
    { 0x944A, "huò"},
    { 0x944B, "qīng"},
    { 0x944C, "bīn"},
    { 0x944D, "yīng"},
    { 0x944E, "kuì"},
    { 0x944F, "níng,nǐng"},
    { 0x9450, "xū,rú,róu"},
    { 0x9451, "jiàn"},
    { 0x9452, "jiàn"},
    { 0x9453, "qiǎn"},
    { 0x9454, "chǎ"},
    { 0x9455, "zhì"},
    { 0x9456, "miè,mì"},
    { 0x9457, "lí"},
    { 0x9458, "léi,lěi"},
    { 0x9459, "jī"},
    { 0x945A, "zuàn"},
    { 0x945B, "kuàng,gǒng"},
    { 0x945C, "shǎng"},
    { 0x945D, "péng"},
    { 0x945E, "là"},
    { 0x945F, "dú"},
    { 0x9460, "shuò,yuè,lì"},
    { 0x9461, "chuò"},
    { 0x9462, "lǜ"},
    { 0x9463, "biāo"},
    { 0x9464, "bào"},
    { 0x9465, "lǔ"},
    { 0x9466, "xian"},
    { 0x9467, "kuān"},
    { 0x9468, "lóng"},
    { 0x9469, "è"},
    { 0x946A, "lú"},
    { 0x946B, "xīn,xùn"},
    { 0x946C, "jiàn"},
    { 0x946D, "làn,lán"},
    { 0x946E, "bó"},
    { 0x946F, "jiān,qiān"},
    { 0x9470, "yào,yuè"},
    { 0x9471, "chán"},
    { 0x9472, "xiāng,ráng"},
    { 0x9473, "jiàn"},
    { 0x9474, "xī,huī"},
    { 0x9475, "guàn"},
    { 0x9476, "cáng"},
    { 0x9477, "niè"},
    { 0x9478, "lěi"},
    { 0x9479, "cuān,cuàn"},
    { 0x947A, "qú"},
    { 0x947B, "pàn"},
    { 0x947C, "luó"},
    { 0x947D, "zuān,zuàn"},
    { 0x947E, "luán"},
    { 0x947F, "záo,zuò,zú,zào"},
    { 0x9480, "niè,yǐ"},
    { 0x9481, "jué"},
    { 0x9482, "tǎng"},
    { 0x9483, "zhú"},
    { 0x9484, "lán"},
    { 0x9485, "jīn"},
    { 0x9486, "gá"},
    { 0x9487, "yǐ"},
    { 0x9488, "zhēn"},
    { 0x9489, "dīng,dìng"},
    { 0x948A, "zhāo"},
    { 0x948B, "pō"},
    { 0x948C, "liǎo,liào"},
    { 0x948D, "tǔ"},
    { 0x948E, "qiān"},
    { 0x948F, "chuàn"},
    { 0x9490, "shān,shàn"},
    { 0x9491, "sà"},
    { 0x9492, "fán"},
    { 0x9493, "diào"},
    { 0x9494, "mén"},
    { 0x9495, "nǚ"},
    { 0x9496, "yáng"},
    { 0x9497, "chāi"},
    { 0x9498, "xíng"},
    { 0x9499, "gài"},
    { 0x949A, "bù"},
    { 0x949B, "tài"},
    { 0x949C, "jù"},
    { 0x949D, "dùn"},
    { 0x949E, "chāo"},
    { 0x949F, "zhōng"},
    { 0x94A0, "nà"},
    { 0x94A1, "bèi"},
    { 0x94A2, "gāng,gàng"},
    { 0x94A3, "bǎn"},
    { 0x94A4, "qián"},
    { 0x94A5, "yào,yuè"},
    { 0x94A6, "qīn"},
    { 0x94A7, "jūn"},
    { 0x94A8, "wū"},
    { 0x94A9, "gōu"},
    { 0x94AA, "kàng"},
    { 0x94AB, "fāng"},
    { 0x94AC, "huǒ"},
    { 0x94AD, "tǒu,dǒu"},
    { 0x94AE, "niǔ"},
    { 0x94AF, "bǎ,pá"},
    { 0x94B0, "yù"},
    { 0x94B1, "qián"},
    { 0x94B2, "zhēng"},
    { 0x94B3, "qián"},
    { 0x94B4, "gǔ"},
    { 0x94B5, "bō"},
    { 0x94B6, "kē"},
    { 0x94B7, "pǒ"},
    { 0x94B8, "bū"},
    { 0x94B9, "bó"},
    { 0x94BA, "yuè"},
    { 0x94BB, "zuān,zuàn"},
    { 0x94BC, "mù"},
    { 0x94BD, "tǎn"},
    { 0x94BE, "jiǎ"},
    { 0x94BF, "diàn,tián"},
    { 0x94C0, "yóu"},
    { 0x94C1, "tiě"},
    { 0x94C2, "bó"},
    { 0x94C3, "líng"},
    { 0x94C4, "shuò"},
    { 0x94C5, "qiān,yán"},
    { 0x94C6, "mǎo"},
    { 0x94C7, "bào"},
    { 0x94C8, "shì"},
    { 0x94C9, "xuàn"},
    { 0x94CA, "tā,tuó"},
    { 0x94CB, "bì"},
    { 0x94CC, "ní"},
    { 0x94CD, "pī,pí"},
    { 0x94CE, "duó"},
    { 0x94CF, "xíng"},
    { 0x94D0, "kào"},
    { 0x94D1, "lǎo"},
    { 0x94D2, "ěr"},
    { 0x94D3, "máng"},
    { 0x94D4, "yā"},
    { 0x94D5, "yǒu"},
    { 0x94D6, "chéng"},
    { 0x94D7, "jiá"},
    { 0x94D8, "yé"},
    { 0x94D9, "náo"},
    { 0x94DA, "zhì"},
    { 0x94DB, "dāng,chēng"},
    { 0x94DC, "tóng"},
    { 0x94DD, "lǚ"},
    { 0x94DE, "diào"},
    { 0x94DF, "yīn"},
    { 0x94E0, "kǎi"},
    { 0x94E1, "zhá"},
    { 0x94E2, "zhū"},
    { 0x94E3, "xǐ,xiǎn"},
    { 0x94E4, "dìng,tǐng"},
    { 0x94E5, "diū"},
    { 0x94E6, "xiān"},
    { 0x94E7, "huá"},
    { 0x94E8, "quán"},
    { 0x94E9, "shā"},
    { 0x94EA, "hā"},
    { 0x94EB, "diào,yáo"},
    { 0x94EC, "gè"},
    { 0x94ED, "míng"},
    { 0x94EE, "zhēng,zhèng"},
    { 0x94EF, "sè"},
    { 0x94F0, "jiǎo"},
    { 0x94F1, "yī"},
    { 0x94F2, "chǎn"},
    { 0x94F3, "chòng"},
    { 0x94F4, "tāng"},
    { 0x94F5, "ǎn"},
    { 0x94F6, "yín"},
    { 0x94F7, "rú"},
    { 0x94F8, "zhù"},
    { 0x94F9, "láo"},
    { 0x94FA, "pù,pū"},
    { 0x94FB, "wú,yǔ"},
    { 0x94FC, "lái"},
    { 0x94FD, "tè"},
    { 0x94FE, "liàn"},
    { 0x94FF, "kēng"},
    { 0x9500, "xiāo"},
    { 0x9501, "suǒ"},
    { 0x9502, "lǐ"},
    { 0x9503, "zèng"},
    { 0x9504, "chú"},
    { 0x9505, "guō"},
    { 0x9506, "gào"},
    { 0x9507, "é"},
    { 0x9508, "xiù"},
    { 0x9509, "cuò"},
    { 0x950A, "lüè"},
    { 0x950B, "fēng"},
    { 0x950C, "xīn"},
    { 0x950D, "liǔ"},
    { 0x950E, "kāi"},
    { 0x950F, "jiǎn,jiàn"},
    { 0x9510, "ruì"},
    { 0x9511, "tī"},
    { 0x9512, "láng"},
    { 0x9513, "qǐn"},
    { 0x9514, "jū,jú"},
    { 0x9515, "ā"},
    { 0x9516, "qiāng"},
    { 0x9517, "zhě"},
    { 0x9518, "nuò"},
    { 0x9519, "cuò"},
    { 0x951A, "máo"},
    { 0x951B, "bēn"},
    { 0x951C, "qí"},
    { 0x951D, "dé"},
    { 0x951E, "kè"},
    { 0x951F, "kūn"},
    { 0x9520, "chāng"},
    { 0x9521, "xī"},
    { 0x9522, "gù"},
    { 0x9523, "luó"},
    { 0x9524, "chuí"},
    { 0x9525, "zhuī"},
    { 0x9526, "jǐn"},
    { 0x9527, "zhì"},
    { 0x9528, "xiān"},
    { 0x9529, "juǎn"},
    { 0x952A, "huō"},
    { 0x952B, "péi"},
    { 0x952C, "tán,xiān"},
    { 0x952D, "dìng"},
    { 0x952E, "jiàn"},
    { 0x952F, "jù,jū"},
    { 0x9530, "měng"},
    { 0x9531, "zī"},
    { 0x9532, "qiè"},
    { 0x9533, "yīng"},
    { 0x9534, "kǎi"},
    { 0x9535, "qiāng"},
    { 0x9536, "sī"},
    { 0x9537, "è"},
    { 0x9538, "chā"},
    { 0x9539, "qiāo"},
    { 0x953A, "zhōng"},
    { 0x953B, "duàn"},
    { 0x953C, "sōu"},
    { 0x953D, "huáng"},
    { 0x953E, "huán"},
    { 0x953F, "āi"},
    { 0x9540, "dù"},
    { 0x9541, "měi"},
    { 0x9542, "lòu"},
    { 0x9543, "zī"},
    { 0x9544, "fèi"}
};
