/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     chenhaifeng  <chenhaifeng@uniontech.com>
*
* Maintainer: chenhaifeng  <chenhaifeng@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "pinyindict.h"

QMap<int, QString> PinyinDict_15{
    { 0x21186, "luǒ"},
    { 0x2118F, "dòu"},
    { 0x21195, "liàn"},
    { 0x211A3, "niè,dí"},
    { 0x211A4, "nǎn"},
    { 0x211A5, "jiù"},
    { 0x211A6, "yuè"},
    { 0x211A9, "yāo,jiǒng"},
    { 0x211AA, "chuāng"},
    { 0x211AE, "cǎn"},
    { 0x211AF, "lǐ"},
    { 0x211B0, "dùn"},
    { 0x211B1, "nǎn"},
    { 0x211B2, "nǎn"},
    { 0x211B8, "rì,guó"},
    { 0x211BD, "yuè"},
    { 0x211C0, "yóu"},
    { 0x211C2, "yīn"},
    { 0x211C4, "guó,niè"},
    { 0x211C8, "dàng,tuó"},
    { 0x211D1, "zhēn"},
    { 0x211D2, "mí"},
    { 0x211D3, "dié"},
    { 0x211D6, "zhēn"},
    { 0x211DA, "kuā"},
    { 0x211DC, "hán"},
    { 0x211DD, "sòng"},
    { 0x211DE, "hé"},
    { 0x211DF, "jī"},
    { 0x211E0, "zhé"},
    { 0x211E4, "bǐng"},
    { 0x211E6, "wéi"},
    { 0x211E7, "tōu"},
    { 0x211E9, "tú"},
    { 0x211EC, "gāng"},
    { 0x211ED, "lóu"},
    { 0x211EE, "quán"},
    { 0x211EF, "hùn"},
    { 0x211F0, "zhuǎn"},
    { 0x211F1, "què"},
    { 0x211F3, "hóng"},
    { 0x211F5, "dàng"},
    { 0x211F6, "hé"},
    { 0x211F7, "tài"},
    { 0x211F8, "guāi"},
    { 0x211FA, "yù"},
    { 0x211FC, "yà"},
    { 0x211FF, "wān"},
    { 0x21200, "qūn"},
    { 0x21205, "jué"},
    { 0x21206, "ōu"},
    { 0x21209, "quān"},
    { 0x2120A, "zhí"},
    { 0x2120D, "líng"},
    { 0x2120E, "wū,rì"},
    { 0x2120F, "xìn"},
    { 0x21210, "dá"},
    { 0x21212, "yuān"},
    { 0x21213, "yuàn"},
    { 0x21217, "mò"},
    { 0x21219, "yóu"},
    { 0x2121E, "wǔ"},
    { 0x21220, "zhāng"},
    { 0x21223, "xuān"},
    { 0x21226, "rǎo"},
    { 0x21227, "gǔn"},
    { 0x21228, "yù"},
    { 0x2122E, "xiá"},
    { 0x2122F, "biǎn"},
    { 0x21230, "yóu"},
    { 0x21232, "yīn"},
    { 0x21234, "xuán,rǔ"},
    { 0x21235, "yóu"},
    { 0x21236, "léi"},
    { 0x2123C, "tǐng,tíng,zhēng,zhǐ"},
    { 0x2123F, "zhēn"},
    { 0x21244, "zài,kū"},
    { 0x21245, "gā"},
    { 0x21246, "lá"},
    { 0x21249, "què"},
    { 0x2124E, "jú"},
    { 0x21250, "chūn"},
    { 0x21251, "dā"},
    { 0x21252, "tún"},
    { 0x21253, "āi"},
    { 0x21257, "zǐ"},
    { 0x2125A, "huáng,fēng"},
    { 0x2125B, "yì"},
    { 0x21269, "bào"},
    { 0x2126A, "chí"},
    { 0x2126D, "rì"},
    { 0x21274, "lú,hù"},
    { 0x21277, "jié"},
    { 0x21278, "shì"},
    { 0x2127A, "zuān"},
    { 0x21281, "yì"},
    { 0x21284, "fèn"},
    { 0x21285, "fèn,biàn"},
    { 0x21289, "mò"},
    { 0x2128D, "shù"},
    { 0x2129B, "áo"},
    { 0x2129D, "pǐ"},
    { 0x2129E, "píng,pìng"},
    { 0x2129F, "pō"},
    { 0x212A0, "jiá"},
    { 0x212A1, "zhóu"},
    { 0x212A3, "qiū"},
    { 0x212A7, "yǒu"},
    { 0x212A8, "tán"},
    { 0x212AB, "rǒng"},
    { 0x212AD, "mì"},
    { 0x212B6, "yì"},
    { 0x212B8, "rǒng"},
    { 0x212BB, "liè"},
    { 0x212BC, "qióng"},
    { 0x212D9, "huí"},
    { 0x212DA, "jì"},
    { 0x212DF, "gào"},
    { 0x212E7, "yóu"},
    { 0x212E8, "chā"},
    { 0x212E9, "dé"},
    { 0x212EA, "yīn"},
    { 0x212EC, "yù"},
    { 0x212ED, "bèi"},
    { 0x212EF, "bó"},
    { 0x21314, "qiāo"},
    { 0x2131A, "chǎ"},
    { 0x2131C, "xīn"},
    { 0x2131E, "chí"},
    { 0x21323, "zào"},
    { 0x21324, "kuí"},
    { 0x21326, "fèi"},
    { 0x21329, "tā,dá"},
    { 0x2132A, "guài"},
    { 0x2132D, "duō"},
    { 0x21332, "guī"},
    { 0x21334, "zhí"},
    { 0x2134C, "chǎn"},
    { 0x2134D, "nǎo"},
    { 0x21350, "hú"},
    { 0x21352, "táo"},
    { 0x21361, "yì"},
    { 0x21364, "niè"},
    { 0x21365, "zhài"},
    { 0x21366, "huán"},
    { 0x21368, "dù"},
    { 0x2136A, "qì"},
    { 0x2136B, "cè"},
    { 0x2136E, "chuí"},
    { 0x21372, "dā"},
    { 0x21376, "zhì"},
    { 0x21377, "gèng"},
    { 0x2137B, "wèng"},
    { 0x21389, "dù"},
    { 0x2138D, "chí"},
    { 0x21391, "àn"},
    { 0x21392, "kuò"},
    { 0x21394, "wò"},
    { 0x21398, "yīng"},
    { 0x2139A, "piǎn"},
    { 0x213AB, "zhá,qì"},
    { 0x213AC, "zhuǎ"},
    { 0x213AE, "sù"},
    { 0x213B3, "nì"},
    { 0x213BA, "zhú"},
    { 0x213BB, "chán"},
    { 0x213BE, "bèng"},
    { 0x213BF, "ní"},
    { 0x213C0, "zhí"},
    { 0x213C1, "huì"},
    { 0x213D8, "xià"},
    { 0x213DA, "zhì"},
    { 0x213DB, "xī"},
    { 0x213DE, "jiǎng"},
    { 0x213E9, "duī"},
    { 0x213EA, "fū"},
    { 0x213ED, "jiāo"},
    { 0x213EE, "cháo"},
    { 0x213EF, "bài"},
    { 0x213F5, "liè"},
    { 0x213FC, "áo"},
    { 0x2140B, "zāo"},
    { 0x2140C, "chù"},
    { 0x2140F, "tuǒ"},
    { 0x21412, "háo,hào"},
    { 0x21413, "kāng"},
    { 0x21414, "yín"},
    { 0x21416, "xiàn"},
    { 0x2141D, "fú,fù"},
    { 0x2141E, "biē"},
    { 0x21420, "kuī"},
    { 0x21424, "qiè"},
    { 0x21425, "sà"},
    { 0x2143F, "dā,da"},
    { 0x21440, "yě,shù"},
    { 0x21444, "zhǎng"},
    { 0x21446, "liáng"},
    { 0x21448, "duǐ"},
    { 0x2144D, "láo"},
    { 0x2144E, "xūn"},
    { 0x21458, "zhì"},
    { 0x2145A, "kū"},
    { 0x2145E, "suì"},
    { 0x2145F, "wō"},
    { 0x21463, "kū"},
    { 0x2146F, "jiǎn"},
    { 0x21476, "jiǎng"},
    { 0x2147B, "zhuì"},
    { 0x2147D, "shuǎng"},
    { 0x2147E, "yú"},
    { 0x21481, "sà"},
    { 0x21483, "yù,ào"},
    { 0x21484, "lǎn"},
    { 0x2148A, "yù"},
    { 0x2148C, "qiǎn"},
    { 0x2148D, "jù"},
    { 0x2148F, "liè"},
    { 0x21492, "shú"},
    { 0x21493, "xiàn"},
    { 0x21496, "gài"},
    { 0x214A2, "tái"},
    { 0x214A7, "tiǎn"},
    { 0x214AF, "mèng"},
    { 0x214B1, "dí"},
    { 0x214B3, "mián"},
    { 0x214BE, "huī,kuì"},
    { 0x214C9, "duò"},
    { 0x214CD, "liè"},
    { 0x214D2, "lài"},
    { 0x214D3, "yín,yīn"},
    { 0x214D4, "lǎn"},
    { 0x214D6, "jiāo"},
    { 0x214D8, "huò"},
    { 0x214E3, "guō"},
    { 0x214E6, "zhàn"},
    { 0x214ED, "mǐ"},
    { 0x214F0, "kuī"},
    { 0x214F7, "duò"},
    { 0x214FF, "yín"},
    { 0x21507, "lèi"},
    { 0x21515, "gòng"},
    { 0x2151B, "tǐng"},
    { 0x2151C, "yáo"},
    { 0x2151E, "wǎng"},
    { 0x21523, "jié,qiè"},
    { 0x21528, "xiū"},
    { 0x2152A, "shù"},
    { 0x21531, "wèi"},
    { 0x21534, "yù"},
    { 0x21541, "zhān"},
    { 0x21549, "āng"},
    { 0x2154F, "sǎng"},
    { 0x21550, "chóu"},
    { 0x21552, "kuà"},
    { 0x21556, "jǔ,féng"},
    { 0x21557, "hài"},
    { 0x21562, "miǎn,mǎn"},
    { 0x21567, "hàng"},
    { 0x2156A, "chóu"},
    { 0x2156E, "líng"},
    { 0x21570, "zōng"},
    { 0x21589, "kūn"},
    { 0x2158C, "zhōng"},
    { 0x2158E, "zhāo"},
    { 0x21590, "diě"},
    { 0x21591, "gǒu"},
    { 0x21592, "yún"},
    { 0x21593, "dān"},
    { 0x21594, "nuó,nuǒ"},
    { 0x2159B, "bǐng"},
    { 0x2159D, "rán"},
    { 0x2159E, "chān"},
    { 0x215A2, "rǒng"},
    { 0x215A3, "yīn"},
    { 0x215A4, "chān"},
    { 0x215A7, "zhì"},
    { 0x215AA, "guài"},
    { 0x215AB, "nuó"},
    { 0x215AC, "shēn"},
    { 0x215AF, "sù"},
    { 0x215B2, "wǒ"},
    { 0x215B3, "chǐ"},
    { 0x215BA, "miè"},
    { 0x215BB, "zhí"},
    { 0x215BE, "qī"},
    { 0x215C1, "gōu"},
    { 0x215C6, "lǒu"},
    { 0x215C8, "zī"},
    { 0x215CD, "dǎng"},
    { 0x215CF, "xiǎn"},
    { 0x215D1, "rǒu"},
    { 0x215D7, "pěng"},
    { 0x215DE, "xī"},
    { 0x215E2, "kuā,běn"},
    { 0x215E4, "guì"},
    { 0x215E5, "chún"},
    { 0x215E6, "jiè"},
    { 0x215F2, "jiè,bēn"},
    { 0x215F3, "xī"},
    { 0x215F5, "kū"},
    { 0x215F7, "gū"},
    { 0x215F8, "zhà,kuā"},
    { 0x215F9, "fàn"},
    { 0x215FC, "xiè"},
    { 0x2160D, "huán,qié"},
    { 0x2160F, "niǎo"},
    { 0x21610, "xì"},
    { 0x2161B, "cū"},
    { 0x2161D, "gǔn"},
    { 0x21621, "xī"},
    { 0x21627, "qiá"},
    { 0x2162A, "māng"},
    { 0x2162D, "zhé"},
    { 0x21630, "juàn"},
    { 0x21634, "biē"},
    { 0x21640, "biē"},
    { 0x21645, "quán"},
    { 0x2164B, "xì"},
    { 0x2164E, "jiǎo,miǎo"},
    { 0x21650, "quán"},
    { 0x21651, "zhǐ"},
    { 0x21652, "tiān"},
    { 0x21653, "kāi"},
    { 0x21658, "sǎn,yì"},
    { 0x2165B, "zī"},
    { 0x21663, "jié"},
    { 0x2166A, "bié"},
    { 0x2166C, "dòu"},
    { 0x2166D, "zuī"},
    { 0x21676, "yǎn"},
    { 0x21681, "bì"},
    { 0x21685, "kuǎi"},
    { 0x21687, "yàn"},
    { 0x21688, "wéi"},
    { 0x2168A, "huān"},
    { 0x2168C, "hào"},
    { 0x21691, "gōng"},
    { 0x21694, "méng"},
    { 0x21697, "lěi"},
    { 0x21699, "dì"},
    { 0x2169B, "bǐng"},
    { 0x2169C, "huān,kàn"},
    { 0x2169F, "wā"},
    { 0x216A0, "jué"},
    { 0x216A8, "chì"},
    { 0x216AD, "bā"},
    { 0x216AE, "jiǔ"},
    { 0x216B7, "dì"},
    { 0x216B9, "zhàng"},
    { 0x216BB, "dà"},
    { 0x216BC, "shí"},
    { 0x216BD, "hào"},
    { 0x216CC, "yè"},
    { 0x216D7, "bì"},
    { 0x216D8, "pǐ"},
    { 0x216D9, "yǎo,yāo"},
    { 0x216DC, "dī"},
    { 0x216DD, "càn"},
    { 0x216DE, "pín"},
    { 0x216DF, "yuè"},
    { 0x216E0, "qiē"},
    { 0x216E1, "pī"},
    { 0x216F5, "tuǒ"},
    { 0x216F6, "xiè"},
    { 0x216FD, "yè"},
    { 0x21700, "fàn"},
    { 0x21701, "guā"},
    { 0x21702, "hù"},
    { 0x21703, "rǔ"},
    { 0x21709, "rǎn,ràn"},
    { 0x2170A, "fǒu"},
    { 0x2170B, "huāng"},
    { 0x2171A, "rú"},
    { 0x21722, "mǎo"},
    { 0x21725, "duī"},
    { 0x21726, "huì"},
    { 0x21727, "xì"},
    { 0x21728, "xiū"},
    { 0x2172B, "rǎn"},
    { 0x2172C, "yī"},
    { 0x2172F, "zhé"},
    { 0x21731, "jì"},
    { 0x21732, "gào"},
    { 0x21733, "yòu"},
    { 0x21735, "pū"},
    { 0x21748, "chù"},
    { 0x21749, "cū"},
    { 0x2174A, "zhé"},
    { 0x2174B, "niǎo"},
    { 0x2174D, "qiè"},
    { 0x21750, "chá"},
    { 0x21752, "niǎo"},
    { 0x21753, "suī"},
    { 0x21759, "chá"},
    { 0x2175A, "chéng"},
    { 0x2175B, "yáo"},
    { 0x2175C, "dù"},
    { 0x2175D, "wāng"},
    { 0x2175F, "niàn"},
    { 0x21760, "mí"},
    { 0x21766, "nǒu"},
    { 0x21767, "xì"},
    { 0x21769, "yāo"},
    { 0x2176B, "chān"},
    { 0x21798, "xiè"},
    { 0x21799, "miè"},
    { 0x2179A, "kěng"},
    { 0x2179C, "cù"},
    { 0x2179E, "shěng"},
    { 0x2179F, "pàn"},
    { 0x217A0, "hù"},
    { 0x217A2, "kè"},
    { 0x217A3, "xiàn"},
    { 0x217A5, "hóu"},
    { 0x217A6, "qióng"},
    { 0x217A7, "zōng"},
    { 0x217AA, "fú"},
    { 0x217AB, "nài"},
    { 0x217AD, "nì"},
    { 0x217AF, "kǔ"},
    { 0x217BE, "nèn"},
    { 0x217CD, "gē"},
    { 0x217D1, "hóu"},
    { 0x217D3, "āi"},
    { 0x217D5, "shī"},
    { 0x217DE, "xiū"},
    { 0x217DF, "cōng"},
    { 0x217E0, "jiāo"},
    { 0x217E2, "zhá"},
    { 0x217E3, "xiāo"},
    { 0x217E4, "liàn"},
    { 0x217E5, "qǔ"},
    { 0x217E8, "shǎn"},
    { 0x217E9, "xiè"},
    { 0x217EB, "gòng"},
    { 0x217EC, "miè"},
    { 0x217ED, "chái"},
    { 0x217EF, "ēn"},
    { 0x217F3, "dòu"},
    { 0x21806, "kòu"},
    { 0x2180A, "tiáo"},
    { 0x2180B, "shī"},
    { 0x2180F, "sāng"},
    { 0x21812, "guān"},
    { 0x21816, "hào"},
    { 0x21817, "zhì"},
    { 0x21818, "yàng"},
    { 0x21819, "tōng"},
    { 0x2181A, "bì"},
    { 0x2181C, "mó,mò"},
    { 0x2181E, "fú"},
    { 0x21825, "qiáng"},
    { 0x21839, "zhì"},
    { 0x2183C, "sōu"},
    { 0x2183F, "niǎo"},
    { 0x21840, "juàn"},
    { 0x21842, "yàng"},
    { 0x21844, "huāng"},
    { 0x21848, "bēng"},
    { 0x21849, "mó"},
    { 0x2184A, "cháo"},
    { 0x2184E, "lǚ,lóu"},
    { 0x2184F, "shāo"},
    { 0x21850, "bǔ"},
    { 0x21851, "zēng"},
    { 0x21852, "sī,xī"},
    { 0x21854, "zuì"},
    { 0x21855, "yuē"},
    { 0x21856, "zān,cān"},
    { 0x21857, "luǎn,luàn"},
    { 0x21865, "qú"},
    { 0x2187A, "miǎo"},
    { 0x21880, "zhuàn"},
    { 0x21888, "dàng"},
    { 0x2188A, "yuān"},
    { 0x21892, "jǔ"},
    { 0x21895, "huǐ"},
    { 0x21896, "qì"},
    { 0x21898, "yùn,yíng"},
    { 0x2189A, "màn"},
    { 0x2189C, "mǒ"},
    { 0x218B1, "piāo"},
    { 0x218B3, "jìn"},
    { 0x218B9, "yāo"},
    { 0x218C0, "chì"},
    { 0x218C1, "nì"},
    { 0x218C2, "sōu"},
    { 0x218C8, "shù"},
    { 0x218CB, "piāo"},
    { 0x218D4, "hàn"},
    { 0x218E0, "yāo"},
    { 0x218E2, "néi"},
    { 0x218EA, "shì"},
    { 0x218EC, "yuān"},
    { 0x218EE, "cài"},
    { 0x218EF, "jié"},
    { 0x218F9, "xiè"},
    { 0x218FD, "yán"},
    { 0x218FE, "xiāo"},
    { 0x2190B, "xiè"},
    { 0x2190C, "lì"},
    { 0x2190E, "fàn"},
    { 0x21917, "zhù"},
    { 0x21919, "nà"},
    { 0x2191B, "zhuǎn"},
    { 0x2191E, "kuī"},
    { 0x21922, "luó"},
    { 0x2192B, "qiā"},
    { 0x21936, "wān"},
    { 0x2193D, "shǔ"},
    { 0x2193F, "chèng,kǒng"},
    { 0x21941, "yì"},
    { 0x21946, "hǎo,hào"},
    { 0x21948, "jiào"},
    { 0x2194B, "huì"},
    { 0x2194D, "xiào"},
    { 0x2194E, "cí,zǐ"},
    { 0x2195E, "jì,bèi"},
    { 0x21966, "nǐ,jìn"},
    { 0x21968, "nǐ,jìn"},
    { 0x21969, "tǐ"},
    { 0x21976, "jù,rú"},
    { 0x21978, "mìng"},
    { 0x2197D, "lí"},
    { 0x2197F, "zhòng"},
    { 0x21981, "xù"},
    { 0x21983, "qióng"},
    { 0x21984, "fú"},
    { 0x21986, "bìn"},
    { 0x2198A, "jì"},
    { 0x2198D, "qí"},
    { 0x2198E, "xì"},
    { 0x21994, "dèng"},
    { 0x21995, "ér"},
    { 0x2199B, "shú"},
    { 0x2199C, "tóng"},
    { 0x2199D, "xiāo,xiáo"},
    { 0x2199F, "pí"},
    { 0x219A8, "dǎn"},
    { 0x219AA, "jí"},
    { 0x219B3, "xiào"},
    { 0x219B7, "cóng"},
    { 0x219BB, "bīn"},
    { 0x219BC, "rǒng"},
    { 0x219CD, "miàn,bīn"},
    { 0x219D2, "miàn"},
    { 0x219D4, "shū"},
    { 0x219D5, "xiáo,shǒu"},
    { 0x219D6, "bǎo"},
    { 0x219D7, "wà"},
    { 0x219D9, "pào"},
    { 0x219E3, "gǎi"},
    { 0x219E5, "hū"},
    { 0x219E6, "héng"},
    { 0x219E8, "zhú"},
    { 0x219E9, "guāi"},
    { 0x219ED, "guì,guǐ"},
    { 0x219F9, "dài"},
    { 0x219FC, "bīn"},
    { 0x219FD, "huǎng,huāng"},
    { 0x21A00, "chá"},
    { 0x21A04, "xià,sāi"},
    { 0x21A05, "jú"},
    { 0x21A07, "yǎo,xiǎng"},
    { 0x21A16, "fěn"},
    { 0x21A17, "zào"},
    { 0x21A1B, "fēng"},
    { 0x21A22, "jū"},
    { 0x21A23, "yù"},
    { 0x21A29, "hūn"},
    { 0x21A32, "jié"},
    { 0x21A33, "xiòng,hùn"},
    { 0x21A35, "nài"},
    { 0x21A3B, "nǒu"},
    { 0x21A3D, "shěng"},
    { 0x21A3F, "yù"},
    { 0x21A42, "huán"},
    { 0x21A43, "gěng"},
    { 0x21A44, "wǎn"},
    { 0x21A46, "tuó"},
    { 0x21A47, "qiāo"},
    { 0x21A58, "yìn"},
    { 0x21A5A, "jiā,zhuàn"},
    { 0x21A61, "suǒ"},
    { 0x21A63, "jié"},
    { 0x21A64, "xī"},
    { 0x21A65, "wěng"},
    { 0x21A69, "máng"},
    { 0x21A76, "yáng"},
    { 0x21A78, "yáo"},
    { 0x21A7D, "máng"},
    { 0x21A7E, "ōu"},
    { 0x21A81, "án"},
    { 0x21A85, "lòu"},
    { 0x21A91, "è"},
    { 0x21A92, "zǐ"},
    { 0x21A97, "è"},
    { 0x21A99, "àn"},
    { 0x21A9E, "huò"},
    { 0x21AA0, "céng"},
    { 0x21AB0, "xiòng"},
    { 0x21AB1, "jì"},
    { 0x21AB3, "zuó"},
    { 0x21AB5, "qí"},
    { 0x21ABA, "zhēng"},
    { 0x21AC0, "jī"},
    { 0x21AC1, "qī,chèn"},
    { 0x21AC2, "juǎn"},
    { 0x21AC3, "níng"},
    { 0x21ADF, "sè"},
    { 0x21AE5, "hè"},
    { 0x21AE6, "rǒng"},
    { 0x21AE7, "qǐn"},
    { 0x21AEC, "jū"},
    { 0x21AEF, "lì"},
    { 0x21AF5, "shí"},
    { 0x21AF8, "nì"},
    { 0x21AF9, "xián"},
    { 0x21AFA, "fū"},
    { 0x21AFD, "rǔ,yù"},
    { 0x21B01, "xiòng"},
    { 0x21B02, "guì"},
    { 0x21B04, "jì"},
    { 0x21B06, "měng,mèng"},
    { 0x21B07, "fū"},
    { 0x21B09, "sài"},
    { 0x21B0A, "yù"},
    { 0x21B0B, "jiào"},
    { 0x21B0C, "mèng"},
    { 0x21B0D, "mí,lóng,mǐ"},
    { 0x21B0E, "qiāng"},
    { 0x21B10, "yí,mí"},
    { 0x21B13, "yí"},
    { 0x21B15, "lóng"},
    { 0x21B16, "hān"},
    { 0x21B17, "nì"},
    { 0x21B18, "lào"},
    { 0x21B19, "sèng"},
    { 0x21B1C, "lǐn"},
    { 0x21B1E, "yù"},
    { 0x21B25, "nuó"},
    { 0x21B2B, "wù"},
    { 0x21B2F, "biǎn"},
    { 0x21B32, "biǎn"},
    { 0x21B33, "xuān,shòu"},
    { 0x21B35, "jiān"},
    { 0x21B38, "biǎn"},
    { 0x21B42, "dé"},
    { 0x21B47, "zhuān"},
    { 0x21B4B, "rǒng"},
    { 0x21B50, "shuàn"},
    { 0x21B58, "jiā"},
    { 0x21B5B, "huǐ"},
    { 0x21B5E, "zhān"},
    { 0x21B62, "bài"},
    { 0x21B63, "liè"},
    { 0x21B65, "xiē"},
    { 0x21B6D, "jiǎn"},
    { 0x21B6E, "shǒu"},
    { 0x21B73, "kào"},
    { 0x21B77, "guān"},
    { 0x21B78, "luàn"},
    { 0x21B7E, "nǒu"},
    { 0x21B7F, "chǎng"},
    { 0x21B8E, "liáng"},
    { 0x21B99, "nài"},
    { 0x21B9A, "rǔ"},
    { 0x21B9E, "zhì"},
    { 0x21BA6, "cáo"},
    { 0x21BB0, "lì"},
    { 0x21BBB, "lán"},
    { 0x21BBF, "chān"},
    { 0x21BC1, "wāng"},
    { 0x21BC4, "lì"},
    { 0x21BC7, "wù"},
    { 0x21BC8, "páo"},
    { 0x21BC9, "yòu"},
    { 0x21BCB, "gān"},
    { 0x21BCF, "ān"},
    { 0x21BD0, "xiū"},
    { 0x21BD1, "shuǐ,zhuǐ"},
    { 0x21BD2, "ruǐ"},
    { 0x21BD8, "bǎn"},
    { 0x21BD9, "yóu"},
    { 0x21BE2, "huó"},
    { 0x21BE5, "huī"},
    { 0x21BE8, "zuò"},
    { 0x21BE9, "xiāo"},
    { 0x21BEB, "mián"},
    { 0x21BF0, "gà"},
    { 0x21BF1, "yuǎn"},
    { 0x21BF3, "bò"},
    { 0x21BF4, "chào"},
    { 0x21BF5, "tuǐ,kuì"},
    { 0x21BF7, "bò,kòu"},
    { 0x21BFD, "gà"},
    { 0x21BFF, "tiāo"},
    { 0x21C00, "ná"},
    { 0x21C05, "hú"},
    { 0x21C06, "niè"},
    { 0x21C0B, "huí"},
    { 0x21C0C, "lǒu"},
    { 0x21C0E, "tí"},
    { 0x21C10, "qiào"},
    { 0x21C11, "qiáo"},
    { 0x21C12, "zhǒng"},
    { 0x21C16, "dī"},
    { 0x21C1A, "lín"},
    { 0x21C1D, "quán"},
    { 0x21C1E, "zhuān"},
    { 0x21C20, "léi,luán"},
    { 0x21C22, "xié"},
    { 0x21C25, "rén,yí"},
    { 0x21C28, "dāng"},
    { 0x21C2A, "dū"},
    { 0x21C2B, "niǎn"},
    { 0x21C2F, "shǐ,diǎo,běi"},
    { 0x21C32, "xián"},
    { 0x21C39, "zhí"},
    { 0x21C3D, "ài"},
    { 0x21C3E, "cī"},
    { 0x21C3F, "pú"},
    { 0x21C41, "shǐ"},
    { 0x21C45, "qū"},
    { 0x21C46, "shǔ"},
    { 0x21C47, "diān"},
    { 0x21C49, "xiǎo"},
    { 0x21C4A, "shuǐ"},
    { 0x21C4C, "huán"},
    { 0x21C50, "yí"},
    { 0x21C51, "juān"},
    { 0x21C54, "zhǐ,qì"},
    { 0x21C5C, "zhào"},
    { 0x21C63, "xù"},
    { 0x21C6F, "lòng"},
    { 0x21C71, "zhù"},
    { 0x21C73, "suǒ"},
    { 0x21C77, "dié"},
    { 0x21C7A, "qú"},
    { 0x21C7C, "kè,kuà"},
    { 0x21C7D, "hū"},
    { 0x21C7E, "jū"},
    { 0x21C80, "qǐng"},
    { 0x21C8D, "bīng"},
    { 0x21C95, "tì"},
    { 0x21C97, "jué"},
    { 0x21C9A, "qiú"},
    { 0x21CA3, "jiàng"},
    { 0x21CAA, "yùn"},
    { 0x21CAD, "mèi"},
    { 0x21CAE, "pī"},
    { 0x21CB0, "qú"},
    { 0x21CBC, "mì"},
    { 0x21CBF, "tì"},
    { 0x21CC2, "kài"},
    { 0x21CC4, "bǐ"},
    { 0x21CC6, "qū,qù"},
    { 0x21CCF, "tiāo"},
    { 0x21CD1, "chù"},
    { 0x21CD8, "jú"},
    { 0x21CDA, "xī"},
    { 0x21CDE, "lìn"},
    { 0x21CED, "chǐ"},
    { 0x21CEE, "jī"},
    { 0x21CF4, "lú"},
    { 0x21CF8, "lì"},
    { 0x21CFE, "jué"},
    { 0x21D05, "zhū"},
    { 0x21D06, "lù"},
    { 0x21D0E, "niè"},
    { 0x21D14, "quán"},
    { 0x21D2D, "yà"},
    { 0x21D2F, "è"},
    { 0x21D31, "hù,jié"},
    { 0x21D40, "máng"},
    { 0x21D49, "wù"},
    { 0x21D4C, "chā"},
    { 0x21D51, "qīn"},
    { 0x21D52, "jié,qǐ"},
    { 0x21D53, "hóng"},
    { 0x21D55, "dān"},
    { 0x21D56, "ěn"},
    { 0x21D57, "zè"},
    { 0x21D58, "hù"},
    { 0x21D59, "àng"},
    { 0x21D5A, "jiè"},
    { 0x21D5B, "fù"},
    { 0x21D5C, "yòng"},
    { 0x21D5E, "fēng"},
    { 0x21D6C, "mù"},
    { 0x21D76, "sè"},
    { 0x21D77, "cóng"},
    { 0x21D7B, "kāng"},
    { 0x21D82, "yào"},
    { 0x21D83, "ài"},
    { 0x21D84, "bāo"},
    { 0x21D86, "pǒ"},
    { 0x21D88, "shǐ"},
    { 0x21D89, "fàn"},
    { 0x21D8B, "jú"},
    { 0x21D8C, "pí"},
    { 0x21D8E, "wèi"},
    { 0x21D8F, "kū"},
    { 0x21D90, "qié"},
    { 0x21D91, "gān"},
    { 0x21DA2, "kuàng"},
    { 0x21DA3, "suì"},
    { 0x21DA4, "bēng,yòng"},
    { 0x21DA5, "jiā"},
    { 0x21DA6, "yà"},
    { 0x21DAA, "kàn"},
    { 0x21DAB, "niè"},
    { 0x21DAD, "xíng"},
    { 0x21DAF, "xì"},
    { 0x21DB1, "lìn"},
    { 0x21DB2, "duǒ"},
    { 0x21DB4, "chǎn"},
    { 0x21DC8, "shì"},
    { 0x21DCB, "duì"},
    { 0x21DCD, "jiāng"},
    { 0x21DCE, "yǔ"},
    { 0x21DCF, "lù"},
    { 0x21DD0, "ěn"},
    { 0x21DD3, "gǔ"},
    { 0x21DD5, "wěi"},
    { 0x21DD6, "chē"},
    { 0x21DD7, "huàn,huán"},
    { 0x21DD8, "bié"},
    { 0x21DDB, "hàn"},
    { 0x21DDC, "tuí"},
    { 0x21DDD, "nà"},
    { 0x21DDE, "qǐ"},
    { 0x21DE0, "tóu"},
    { 0x21DE1, "yuān"},
    { 0x21DE2, "wáng"},
    { 0x21DE4, "wú"},
    { 0x21DE5, "gào"},
    { 0x21DE8, "kēng,xíng"},
    { 0x21DEA, "yí,níng"},
    { 0x21DF8, "xiāo"},
    { 0x21DFA, "guǐ"},
    { 0x21DFB, "yà"},
    { 0x21DFC, "suì"},
    { 0x21DFD, "sǒng"},
    { 0x21DFF, "zhuó"},
    { 0x21E02, "tū,tú"},
    { 0x21E03, "xiǎn,jiǎn"},
    { 0x21E08, "zè"},
    { 0x21E09, "lì"},
    { 0x21E0C, "zhù"},
    { 0x21E0E, "jié"},
    { 0x21E11, "tì"},
    { 0x21E14, "xié"},
    { 0x21E15, "qióng"},
    { 0x21E17, "yà"},
    { 0x21E18, "jū"},
    { 0x21E1B, "yín"},
    { 0x21E1C, "zhí"},
    { 0x21E1E, "kǎn"},
    { 0x21E1F, "zī"},
    { 0x21E21, "kē"},
    { 0x21E23, "niè"},
    { 0x21E24, "qiáng"},
    { 0x21E25, "wǎn"},
    { 0x21E26, "zé"},
    { 0x21E28, "jū"},
    { 0x21E2A, "zì"},
    { 0x21E44, "yà"},
    { 0x21E47, "lín"},
    { 0x21E49, "qí"},
    { 0x21E4E, "huí"},
    { 0x21E53, "qì"},
    { 0x21E55, "yáng"},
    { 0x21E56, "suì"},
    { 0x21E58, "qǐ"},
    { 0x21E59, "guī"},
    { 0x21E62, "qìn"},
    { 0x21E63, "ē"},
    { 0x21E65, "zuò"},
    { 0x21E68, "zè"},
    { 0x21E69, "qì"},
    { 0x21E6A, "jí"},
    { 0x21E6C, "tuó"},
    { 0x21E6D, "dié"},
    { 0x21E6F, "huì"},
    { 0x21E70, "máo"},
    { 0x21E72, "xǔ"},
    { 0x21E75, "hóu"},
    { 0x21E76, "yǎn"},
    { 0x21E77, "xiáng"},
    { 0x21E78, "cōng"},
    { 0x21E79, "hú"},
    { 0x21E7C, "àn,yǎn"},
    { 0x21E7E, "bǐng"},
    { 0x21E87, "duǒ"},
    { 0x21E90, "zhǔ"},
    { 0x21E91, "dié"},
    { 0x21E92, "yōu"},
    { 0x21E93, "qǐ"},
    { 0x21E94, "shí"},
    { 0x21E95, "xūn"},
    { 0x21E96, "yōu"},
    { 0x21E97, "kān"},
    { 0x21E98, "qiǎo"},
    { 0x21E9B, "qiāng,huà"},
    { 0x21E9C, "pén"},
    { 0x21E9F, "quán"},
    { 0x21EA1, "yíng"},
    { 0x21EA7, "shā"},
    { 0x21EAB, "tāo"},
    { 0x21EAD, "hòng"},
    { 0x21EAE, "pǐ"},
    { 0x21EAF, "yáo"},
    { 0x21EB4, "tú"},
    { 0x21EB5, "chái"},
    { 0x21EB7, "xià"},
    { 0x21EB8, "qí"},
    { 0x21EBA, "qióng"},
    { 0x21EBD, "jìn"},
    { 0x21EC8, "zhēn"},
    { 0x21ECC, "zhū"},
    { 0x21ECE, "xī"},
    { 0x21ED0, "wēng"},
    { 0x21ED1, "zhǒng"},
    { 0x21ED5, "suì"},
    { 0x21ED8, "kē"},
    { 0x21ED9, "kuò"},
    { 0x21EDA, "kǎng"},
    { 0x21EDD, "cháo"},
    { 0x21EDE, "bì"},
    { 0x21EDF, "mò"},
    { 0x21EE0, "zhù"},
    { 0x21EE1, "hàn,yán"},
    { 0x21EE2, "yǔ"},
    { 0x21EE3, "yí"},
    { 0x21EE4, "má"},
    { 0x21EE7, "qì"},
    { 0x21EE8, "gùn"},
    { 0x21EE9, "màn"},
    { 0x21EEA, "liáo,liù"},
    { 0x21EEB, "lín"},
    { 0x21EEC, "zú"},
    { 0x21EED, "lěi"},
    { 0x21EEE, "hù"},
    { 0x21EEF, "chuǎng"},
    { 0x21EF0, "qì"},
    { 0x21EF1, "léi"},
    { 0x21F01, "chī"},
    { 0x21F03, "pó"},
    { 0x21F04, "dié"},
    { 0x21F0A, "lěi"},
    { 0x21F0E, "yǐ"},
    { 0x21F13, "diàn"},
    { 0x21F16, "dūn"},
    { 0x21F17, "gāo"},
    { 0x21F18, "hū"},
    { 0x21F1A, "xiāo"},
    { 0x21F1B, "gá"},
    { 0x21F1C, "pēng"},
    { 0x21F2C, "shěn"},
    { 0x21F31, "wéi"},
    { 0x21F3B, "duì"},
    { 0x21F3C, "cháo"},
    { 0x21F3D, "yǐn"},
    { 0x21F3E, "kuài"},
    { 0x21F3F, "kū"},
    { 0x21F41, "zuì"},
    { 0x21F42, "gǔ"},
    { 0x21F45, "yùn"},
    { 0x21F46, "zhì"},
    { 0x21F49, "jì"},
    { 0x21F4A, "chēng"},
    { 0x21F56, "xiè"},
    { 0x21F5B, "zuǐ"},
    { 0x21F5C, "án"},
    { 0x21F5D, "hāo"},
    { 0x21F60, "pǒ"},
    { 0x21F62, "dí"},
    { 0x21F63, "yè"},
    { 0x21F67, "náo"},
    { 0x21F71, "jié"},
    { 0x21F72, "bàng"},
    { 0x21F73, "lǎn"},
    { 0x21F74, "cáng"},
    { 0x21F76, "bì"},
    { 0x21F7B, "zhǎn"},
    { 0x21F7C, "qì"},
    { 0x21F82, "náo"},
    { 0x21F85, "lǜ"},
    { 0x21F87, "kuàng"},
    { 0x21F89, "mó"},
    { 0x21F8B, "lěi,léi"},
    { 0x21F8C, "páo"},
    { 0x21F92, "lì"},
    { 0x21F93, "céng"},
    { 0x21F95, "dàng"},
    { 0x21F96, "lěi"},
    { 0x21F99, "è"},
    { 0x21F9B, "bèng"},
    { 0x21F9C, "jué,huò"},
    { 0x21FA5, "xuán"},
    { 0x21FA6, "niè"},
    { 0x21FA8, "hài"},
    { 0x21FAE, "xiǎn"},
    { 0x21FB0, "jiǎn"},
    { 0x21FB1, "mí"},
    { 0x21FB2, "niè"},
    { 0x21FBB, "cáng"},
    { 0x21FBC, "sǒng"},
    { 0x21FBD, "zēng"},
    { 0x21FBE, "yì"},
    { 0x21FC2, "chóng"},
    { 0x21FC4, "cáng"},
    { 0x21FC9, "lěi"},
    { 0x21FCA, "nuó"},
    { 0x21FCB, "lì"},
    { 0x21FCE, "lí"},
    { 0x21FCF, "luó"},
    { 0x21FD3, "tǎng"},
    { 0x21FD6, "niè,yà"},
    { 0x21FD7, "niè"},
    { 0x21FD9, "jī"},
    { 0x21FDB, "lěi"},
    { 0x21FDD, "nàng"},
    { 0x21FE0, "lín"},
    { 0x21FE1, "líng"},
    { 0x21FE4, "xián"},
    { 0x21FE5, "yù"},
    { 0x21FE7, "zāi"},
    { 0x21FE8, "quǎn"},
    { 0x21FE9, "liè"},
    { 0x21FEF, "yù"},
    { 0x21FF0, "huāng"},
    { 0x21FFA, "nǎo"},
    { 0x21FFC, "xùn"},
    { 0x21FFE, "jú"},
    { 0x21FFF, "huò"},
    { 0x22001, "yì"},
    { 0x2200A, "xī"},
    { 0x2200B, "sè"},
    { 0x2200C, "jiǎo"},
    { 0x2200D, "yōng"},
    { 0x22015, "shī"},
    { 0x22016, "jīng"},
    { 0x22017, "wàn"},
    { 0x22018, "yě"},
    { 0x22019, "jiū"},
    { 0x2201C, "gǒng"},
    { 0x22021, "huī,zuǒ"},
    { 0x2202A, "ěr"},
    { 0x22035, "hàn"},
    { 0x2203C, "fú"},
    { 0x22040, "fú"},
    { 0x22041, "zhuó"},
    { 0x22042, "jī,jì"},
    { 0x2204F, "bāng"},
    { 0x22052, "qí"},
    { 0x22053, "shǐ,hài"},
    { 0x22055, "diǎo"},
    { 0x22056, "pèi"},
    { 0x22057, "xiǎn,gàn"},
    { 0x22058, "sān"},
    { 0x2205D, "cháng"},
    { 0x2205E, "yuē"},
    { 0x22060, "gōng"},
    { 0x22062, "wū"},
    { 0x22064, "fēn"},
    { 0x22067, "chǎn"},
    { 0x22069, "nèi"},
    { 0x2206A, "jué"},
    { 0x2206C, "zhǎo"},
    { 0x2206E, "qián"},
    { 0x22071, "ǎo"},
    { 0x22076, "wǎng"},
    { 0x22077, "zhōng"},
    { 0x22079, "huāng"},
    { 0x2207B, "bù"},
    { 0x2207C, "zhǔ"},
    { 0x2207D, "bì"},
    { 0x2207E, "chāo"},
    { 0x2207F, "zhēng"},
    { 0x22080, "fú"},
    { 0x22081, "kōu,qú"},
    { 0x22083, "zuó"},
    { 0x22084, "xuàn"},
    { 0x22086, "fù"},
    { 0x2208A, "yǎo"},
    { 0x2208D, "bō"},
    { 0x2208F, "bèi"},
    { 0x22090, "xié"},
    { 0x22091, "shì"},
    { 0x22092, "yí"},
    { 0x22094, "hóng"},
    { 0x22095, "cuì"},
    { 0x22097, "yì"},
    { 0x22098, "zhuān"},
    { 0x2209D, "chì"},
    { 0x220A4, "pō,lù"},
    { 0x220A8, "yín"},
    { 0x220B1, "yuàn"},
    { 0x220B6, "jiōng"},
    { 0x220B9, "mào"},
    { 0x220BA, "qiàn"},
    { 0x220BC, "yì"},
    { 0x220C0, "wú"},
    { 0x220CD, "bēi"},
    { 0x220CE, "huò"},
    { 0x220CF, "cóng"},
    { 0x220D0, "kōng"},
    { 0x220D5, "tà"},
    { 0x220D7, "hàn"},
    { 0x220D8, "qiàn"},
    { 0x220DC, "zhí"},
    { 0x220E2, "sè"},
    { 0x220E5, "qiān"},
    { 0x220E6, "guǒ"},
    { 0x220E9, "gǔn,juǎn"},
    { 0x220EC, "jiān"},
    { 0x220ED, "zhōng"},
    { 0x220EE, "miǎn"},
    { 0x220EF, "guǐ"},
    { 0x220F0, "shì"},
    { 0x220F1, "móu"},
    { 0x220F2, "è"},
    { 0x220F3, "bǎ"},
    { 0x220F4, "là"},
    { 0x220F8, "zhòu"},
    { 0x220FA, "jí"},
    { 0x22100, "zǎo"},
    { 0x22104, "zhā"},
    { 0x22105, "yì"},
    { 0x22107, "gǒu"},
    { 0x2210A, "guī"},
    { 0x2210B, "yīng"},
    { 0x2210C, "shǎi"},
    { 0x2210D, "hé,gé"},
    { 0x2210E, "bàng"},
    { 0x2210F, "mò"},
    { 0x22110, "méng"},
    { 0x22113, "wù"},
    { 0x22114, "dài"},
    { 0x22117, "jiǒng"},
    { 0x2211C, "hàn"},
    { 0x2211F, "tōng"},
    { 0x22120, "kōu"},
    { 0x22121, "lí"},
    { 0x22122, "zhì"},
    { 0x22123, "huì"},
    { 0x22124, "zǎn"},
    { 0x22126, "diǎo"},
    { 0x22127, "cù"},
    { 0x22131, "zhì"},
    { 0x22133, "kuǎ"},
    { 0x22135, "xiàng"},
    { 0x22136, "huà"},
    { 0x22137, "liáo"},
    { 0x22138, "cuì"},
    { 0x22139, "qiāo"},
    { 0x2213A, "jiǎo"},
    { 0x2213C, "xū"},
    { 0x2213D, "èr"},
    { 0x2213F, "tuō"},
    { 0x22140, "tán"},
    { 0x22141, "zhì"},
    { 0x22148, "nǎo"},
    { 0x22149, "mào"},
    { 0x2214A, "dì"},
    { 0x2214B, "céng"},
    { 0x2214E, "jiǎo"},
    { 0x2214F, "lián"},
    { 0x22151, "shā"},
    { 0x22152, "dàn"},
    { 0x22155, "suì"},
    { 0x22156, "lián"},
    { 0x22157, "guò"},
    { 0x2215A, "biǎo,biāo"},
    { 0x2215C, "cì"},
    { 0x2215D, "diàn"},
    { 0x2215E, "lǜ"},
    { 0x2215F, "nǐ"},
    { 0x22160, "yǎn"},
    { 0x22161, "lán"},
    { 0x22164, "gài"},
    { 0x22165, "chú"},
    { 0x22169, "bì"},
    { 0x2216A, "zú"},
    { 0x2216B, "huì"},
    { 0x2216D, "lǎi"},
    { 0x2216E, "xián"},
    { 0x2216F, "fèn"},
    { 0x22170, "hè"},
    { 0x22179, "yào"},
    { 0x2217A, "zhǎn"},
    { 0x2217C, "néi"},
    { 0x2217E, "luǒ"},
    { 0x22180, "yuán"},
    { 0x22182, "néng"},
    { 0x22189, "rěn"},
    { 0x2219C, "gé"},
    { 0x2219E, "jiǎn"},
    { 0x2219F, "píng"},
    { 0x221A3, "biè"},
    { 0x221A6, "jiàn"},
    { 0x221A9, "bìng"},
    { 0x221AF, "mì,xuán"},
    { 0x221B0, "hù"},
    { 0x221B4, "diǎo"},
    { 0x221B6, "yōu,zī"},
    { 0x221B7, "yāo,miào"},
    { 0x221B8, "bēng"},
    { 0x221BA, "chén"},
    { 0x221BB, "jī,duì"},
    { 0x221BD, "yāo"},
    { 0x221C7, "guān"},
    { 0x221C8, "yàn"},
    { 0x221D5, "chǐ"},
    { 0x221D7, "shà"},
    { 0x221D8, "yǎn"},
    { 0x221D9, "yì"},
    { 0x221DA, "yì"},
    { 0x221DB, "chè,chǐ"},
    { 0x221DE, "hàn"},
    { 0x221DF, "huāng"},
    { 0x221E4, "shuì"},
    { 0x221E5, "suì"},
    { 0x221E6, "rén"},
    { 0x221E7, "tán"},
    { 0x221E8, "zhǐ"},
    { 0x221EA, "fàn"},
    { 0x221EB, "fěng"},
    { 0x221F0, "tán"},
    { 0x221F2, "mí"},
    { 0x221F3, "pí"},
    { 0x221F4, "bù"},
    { 0x221F5, "nà"},
    { 0x221F6, "tián"},
    { 0x221F7, "bá"},
    { 0x221F8, "yì"},
    { 0x22202, "yǎn"},
    { 0x22204, "tiāo"},
    { 0x22206, "yáo"},
    { 0x22207, "shěn"},
    { 0x22208, "kē,wā"},
    { 0x22209, "tóng"},
    { 0x2220B, "xuǎn"},
    { 0x22213, "yòu"},
    { 0x22215, "bài"},
    { 0x22219, "xiá"},
    { 0x2221A, "lǚ"},
    { 0x2221B, "kùn"},
    { 0x2221C, "zāng"},
    { 0x2221D, "qiú"},
    { 0x22220, "cù,là"},
    { 0x22221, "zuī"},
    { 0x22222, "lǒu"},
    { 0x22224, "xiá"},
    { 0x2222F, "shēn"},
    { 0x22232, "pú"},
    { 0x22234, "jīng"},
    { 0x22235, "qiāng"},
    { 0x22236, "yì,sī"},
    { 0x22238, "niè"},
    { 0x22239, "duī,tuí"},
    { 0x2223B, "jié"},
    { 0x2223C, "suì"},
    { 0x2223D, "zhàn"},
    { 0x2223E, "cōu"},
    { 0x22241, "bēng"},
    { 0x22242, "guān"},
    { 0x22243, "shě"},
    { 0x22245, "jìn"},
    { 0x22246, "dì"},
    { 0x22251, "dān"},
    { 0x22253, "nǎi"},
    { 0x22255, "nóu"},
    { 0x22257, "jí"},
    { 0x22258, "yán"},
    { 0x2225A, "nòu"},
    { 0x2225C, "dù,tú"},
    { 0x2225D, "wèi"},
    { 0x2225E, "piān"},
    { 0x22262, "hú"},
    { 0x22264, "jià"},
    { 0x22265, "yè"},
    { 0x22266, "jǔn"},
    { 0x22267, "lán,lián"},
    { 0x22268, "là"},
    { 0x22269, "yīn"},
    { 0x2226D, "tuí"},
    { 0x22275, "nǎo"},
    { 0x2227A, "zǔ"},
    { 0x2227F, "mà"},
    { 0x22280, "sī,mà"},
    { 0x22281, "zhì"},
    { 0x22284, "huī"},
    { 0x22285, "zhuì"},
    { 0x22287, "huì"},
    { 0x2228D, "chú"},
    { 0x2228F, "chè"},
    { 0x22292, "xiū"},
    { 0x22293, "lán"},
    { 0x22295, "cōng"},
    { 0x22296, "shèn"},
    { 0x22297, "mò"},
    { 0x22298, "yī"},
    { 0x22299, "yáo"},
    { 0x2229A, "xǐ"},
    { 0x2229B, "zuǐ"},
    { 0x2229C, "bìng"},
    { 0x222A7, "yú"},
    { 0x222A9, "lù"},
    { 0x222AE, "tuí"},
    { 0x222AF, "wěi"},
    { 0x222B1, "fén"},
    { 0x222B2, "shěn"},
    { 0x222BB, "liáo"},
    { 0x222C2, "shǔ"},
    { 0x222C3, "dǎn"},
    { 0x222C4, "juǎn"},
    { 0x222C5, "yú"},
    { 0x222C6, "xìn"},
    { 0x222C7, "yáo"},
    { 0x222C8, "sū"},
    { 0x222D2, "huó"},
    { 0x222D4, "qiān"},
    { 0x222DA, "má"},
    { 0x222DD, "kǎi"},
    { 0x222E1, "lǔ"},
    { 0x222E3, "yōu"},
    { 0x222EE, "xiàn"},
    { 0x222F9, "wú"},
    { 0x222FB, "yǐn"},
    { 0x222FC, "xī"},
    { 0x222FF, "zhāi"},
    { 0x22300, "xiè"},
    { 0x22304, "qú"},
    { 0x22308, "lí"},
    { 0x2230D, "qiān"},
    { 0x22314, "líng"},
    { 0x22315, "luán"},
    { 0x2231A, "chān"},
    { 0x22326, "zhèng"},
    { 0x22328, "yán"},
    { 0x22332, "yìn"},
    { 0x22333, "kuí"},
    { 0x22337, "qū"},
    { 0x22339, "fú"},
    { 0x2233B, "yù"},
    { 0x22341, "qí,bì"},
    { 0x22346, "qì,qiè"},
    { 0x22347, "jì"},
    { 0x22348, "yuān,zàng"},
    { 0x2234E, "gào"},
    { 0x2234F, "juàn"},
    { 0x22351, "qí"},
    { 0x22353, "gǎi"},
    { 0x22355, "quàn"},
    { 0x2235A, "wèi"},
    { 0x22367, "zhì"},
    { 0x2236B, "jiǎn"},
    { 0x2236D, "sì"},
    { 0x22370, "yì,zé"},
    { 0x22371, "qiān"},
    { 0x2237C, "lì"},
    { 0x2237F, "zāng"},
    { 0x22380, "yì"},
    { 0x22382, "cái"},
    { 0x22383, "yì"},
    { 0x22384, "gē"},
    { 0x22386, "dié"},
    { 0x22388, "zhī"},
    { 0x22389, "yì"},
    { 0x2238B, "zāi"},
    { 0x2238C, "dài"},
    { 0x2238E, "sù"},
    { 0x22394, "jié"},
    { 0x22395, "chèn"},
    { 0x22396, "qú"},
    { 0x22398, "hàn"},
    { 0x22399, "xián"},
    { 0x223A0, "quán,juàn"},
    { 0x223A1, "jié"},
    { 0x223A5, "juàn"},
    { 0x223AA, "dàn"},
    { 0x223AD, "jīn"},
    { 0x223B4, "bīng"},
    { 0x223B5, "hú"},
    { 0x223B9, "jué"},
    { 0x223BB, "yú"},
    { 0x223C3, "lǐ"},
    { 0x223C4, "qiáng"},
    { 0x223C5, "shuǐ"},
    { 0x223C6, "kū"},
    { 0x223C8, "zhěn"},
    { 0x223CD, "fú"},
    { 0x223CE, "shēn"},
    { 0x223D2, "chuí"},
    { 0x223D5, "tóng"},
    { 0x223D7, "yì"},
    { 0x223D9, "yáng"},
    { 0x223DC, "tuó"},
    { 0x223DD, "zhōu"},
    { 0x223DE, "jí"},
    { 0x223E4, "xùn"},
    { 0x223E6, "shěn"},
    { 0x223E7, "xuān"},
    { 0x223ED, "liú"},
    { 0x223EE, "yuān"},
    { 0x223EF, "hú,shǐ"},
    { 0x223F0, "zhèng"},
    { 0x223F3, "pēng,bēng"},
    { 0x223F7, "jué"},
    { 0x22402, "zhì"},
    { 0x22403, "piān"},
    { 0x22404, "yuàn"},
    { 0x22406, "jiān"},
    { 0x2240A, "páng"},
    { 0x2240E, "zhuàn"},
    { 0x22410, "xián"},
    { 0x22412, "bēng"},
    { 0x22414, "cōng"},
    { 0x22416, "mò"},
    { 0x2241A, "guó"},
    { 0x2241E, "chéng"},
    { 0x2241F, "qiāo"},
    { 0x22426, "bì"},
    { 0x22429, "qiǎng"},
    { 0x2242B, "zhōu"},
    { 0x22432, "fán"},
    { 0x22433, "biē"},
    { 0x2243E, "bó"},
    { 0x2243F, "rǎng,rǒng"},
    { 0x22445, "dǐng"},
    { 0x22446, "quán"},
    { 0x22447, "jiù"},
    { 0x22448, "yáo"},
    { 0x22453, "xiá"},
    { 0x22456, "zǎo"},
    { 0x2245D, "dān"},
    { 0x2245F, "wǔ"},
    { 0x22460, "tuó"},
    { 0x22462, "hū"},
    { 0x22467, "xī"},
    { 0x2246C, "lái"},
    { 0x2246E, "fēi"},
    { 0x22479, "hú"},
    { 0x22486, "xiān"},
    { 0x22489, "shǎn"},
    { 0x2248D, "fèi"},
    { 0x22490, "cuò"},
    { 0x22492, "fú"},
    { 0x22494, "chù"},
    { 0x2249D, "diū"},
    { 0x2249E, "làn"},
    { 0x224A9, "xǐ"},
    { 0x224AF, "biāo"},
    { 0x224B0, "yù"},
    { 0x224B1, "suì"},
    { 0x224B2, "xǐ"},
    { 0x224B7, "póu"},
    { 0x224B9, "shǎn"},
    { 0x224BE, "jiào"},
    { 0x224C0, "yì"},
    { 0x224C3, "wán"},
    { 0x224C4, "jǐ"},
    { 0x224C6, "wán"},
    { 0x224C7, "tuì,nà"},
    { 0x224CB, "àng"},
    { 0x224CD, "tiān"},
    { 0x224CE, "chí"},
    { 0x224D2, "rán"},
    { 0x224D4, "sà"},
    { 0x224D5, "yín"},
    { 0x224D6, "pī"},
    { 0x224D7, "cǐ"},
    { 0x224D8, "tóng,tāo"},
    { 0x224D9, "yǐn"},
    { 0x224DC, "gé"},
    { 0x224DD, "tiāo"},
    { 0x224DE, "zhēng"},
    { 0x224DF, "zhòu"},
    { 0x224E1, "yí,tí"},
    { 0x224E2, "kuà"},
    { 0x224E3, "sōng"},
    { 0x224E7, "dì"},
    { 0x224EC, "xié"},
    { 0x224EE, "xiāo"},
    { 0x224EF, "guàng,wǎng"},
    { 0x224F0, "tuǒ"},
    { 0x224F1, "fēng,fèng"},
    { 0x224F2, "wú,hú"},
    { 0x224F5, "xiù"},
    { 0x224FF, "yóu"},
    { 0x22501, "líng"},
    { 0x22502, "yàn"},
    { 0x22505, "dōng"},
    { 0x22506, "qì"},
    { 0x22507, "táo"},
    { 0x22508, "hán"},
    { 0x2250A, "chí"},
    { 0x2250B, "sōng"},
    { 0x22511, "quǎn"},
    { 0x22514, "hàn,jí"},
    { 0x2251F, "rǒu,niǔ"},
    { 0x22520, "qì"},
    { 0x22521, "kāi"},
    { 0x22522, "yú"},
    { 0x22523, "chā,shà"},
    { 0x22524, "chèng"},
    { 0x22525, "yù"},
    { 0x22527, "bìng"},
    { 0x22529, "cōng,sǒng"},
    { 0x2252A, "zhū"},
    { 0x2252C, "yù"},
    { 0x22531, "jué,què"},
    { 0x22532, "liù"},
    { 0x22533, "sāo"},
    { 0x22534, "yù"},
    { 0x22545, "shuài"},
    { 0x2254B, "yuàn"},
    { 0x2254E, "zhāng"},
    { 0x22551, "shuài"},
    { 0x22553, "chǔ"},
    { 0x22554, "zhāng,zhàng"},
    { 0x22555, "sǎn,sàn"},
    { 0x22556, "xiān"},
    { 0x22558, "cuī"},
    { 0x22559, "měng"},
    { 0x2255A, "dí"},
    { 0x2255E, "zhì"},
    { 0x2255F, "ào"},
    { 0x22566, "xiū"},
    { 0x22568, "pián"},
    { 0x2256A, "jiào"},
    { 0x2256B, "kuǎn"},
    { 0x2256C, "sà"},
    { 0x2256D, "xiàn"},
    { 0x2256E, "zhà"},
    { 0x2256F, "diàn"},
    { 0x22577, "yí"},
    { 0x2257A, "huì"},
    { 0x2257B, "shàn"},
    { 0x22584, "chóng"},
    { 0x22585, "yí"},
    { 0x22586, "xiè"},
    { 0x22587, "zhì"},
    { 0x22588, "tiào"},
    { 0x2258A, "pīng"},
    { 0x2258B, "xián"},
    { 0x2258E, "xiān"},
    { 0x2258F, "sù"},
    { 0x22591, "cuán"},
    { 0x22597, "sǒng"},
    { 0x2259B, "hēi"},
    { 0x2259D, "xiàn"},
    { 0x2259F, "yóu"},
    { 0x225A1, "yù"},
    { 0x225A4, "tái"},
    { 0x225A6, "jué"},
    { 0x225A7, "nàng"},
    { 0x225A9, "diān"},
    { 0x225AB, "yì"},
    { 0x225AC, "bì"},
    { 0x225B3, "xū"},
    { 0x225B4, "yì"},
    { 0x225B5, "rù"},
    { 0x225B7, "gōng"},
    { 0x225BA, "yì"},
    { 0x225BF, "zhì"},
    { 0x225C0, "xīn"},
    { 0x225C2, "jì"},
    { 0x225C4, "xià"},
    { 0x225C8, "zhāo"},
    { 0x225C9, "nè"},
    { 0x225CA, "xiè,jiá"},
    { 0x225CE, "yì"},
    { 0x225EB, "fǔ"},
    { 0x225ED, "shè"},
    { 0x225EF, "yuán"},
    { 0x225F0, "fǎn"},
    { 0x225F2, "fū"},
    { 0x225F3, "wù"},
    { 0x225F4, "xī"},
    { 0x225F5, "hǒng"},
    { 0x225F9, "jì"},
    { 0x225FA, "chàng"},
    { 0x225FF, "mò"},
    { 0x22600, "pèi"},
    { 0x22603, "mú,wǔ"},
    { 0x22604, "qiú"},
    { 0x22605, "mào,róu"},
    { 0x22607, "dá,dàn"},
    { 0x22609, "xiá"},
    { 0x2260A, "shēn"},
    { 0x2260B, "tè"},
    { 0x2260C, "hóng"},
    { 0x2260D, "bì,fú"},
    { 0x2261D, "nǐ"},
    { 0x2261F, "qiáo"},
    { 0x22627, "ruǎn"},
    { 0x22638, "jiàng"},
    { 0x22639, "chā"},
    { 0x2263A, "mǐ,mí"},
    { 0x2263D, "yì"},
    { 0x2263F, "suō"},
    { 0x22641, "wù"},
    { 0x22642, "xuān"},
    { 0x22645, "xí"},
    { 0x22647, "yǐ"},
    { 0x22650, "náo"},
    { 0x22653, "wèi"},
    { 0x2266E, "kàn"},
    { 0x22671, "lòng"},
    { 0x22672, "lǚ"},
    { 0x22673, "zhuǎng"},
    { 0x2267A, "zhì"},
    { 0x2267C, "xìng"},
    { 0x2267E, "gěng"},
    { 0x2267F, "jìn"},
    { 0x22680, "xiàn"},
    { 0x22681, "jì"},
    { 0x22682, "cuò"},
    { 0x22684, "láo"},
    { 0x22685, "fěn"},
    { 0x22686, "jù"},
    { 0x2268B, "miào"},
    { 0x2268C, "xiá"},
    { 0x22691, "sù"},
    { 0x226A8, "zhì"},
    { 0x226AA, "hù"},
    { 0x226AB, "kòu"},
    { 0x226AD, "suǒ"},
    { 0x226AE, "nì"},
    { 0x226BA, "tēng"},
    { 0x226BB, "zhù"},
    { 0x226C1, "dá,chè"},
    { 0x226C3, "qiú"},
    { 0x226C4, "yà"},
    { 0x226C6, "xián"},
    { 0x226C9, "nèi"},
    { 0x226CD, "zhǐ"},
    { 0x226CE, "bié"},
    { 0x226D2, "chǒng"},
    { 0x226D3, "lán"},
    { 0x226D4, "dōng"},
    { 0x226D5, "qūn"},
    { 0x226D6, "xiàng"},
    { 0x226D8, "xiáo"},
    { 0x226D9, "wǎn"},
    { 0x226DA, "rù"},
    { 0x226DB, "wàng"},
    { 0x226DC, "nì"},
    { 0x226DE, "bāi"},
    { 0x226DF, "yà"},
    { 0x226E5, "sī"},
    { 0x226E6, "yǐn"},
    { 0x226E8, "yù"},
    { 0x226EE, "lí"},
    { 0x226EF, "huò"},
    { 0x22717, "bàng"},
    { 0x22723, "xī"},
    { 0x22725, "jiū"},
    { 0x22728, "xiè,dié"},
    { 0x22729, "qiān"},
    { 0x2272A, "nuò,ruò"},
    { 0x2272B, "xǐng"},
    { 0x2272C, "duó"},
    { 0x2272D, "jǐ"},
    { 0x2272E, "wǔ"},
    { 0x2272F, "mú,móu,mǔ"},
    { 0x22730, "yàn,yǎn"},
    { 0x22731, "qì"},
    { 0x22732, "ná"},
    { 0x22733, "chì"},
    { 0x22734, "hóu"},
    { 0x22736, "sào"},
    { 0x22738, "náo"},
    { 0x2273B, "chěng"},
    { 0x2273C, "chěng"},
    { 0x2273D, "kuí,kuǐ"},
    { 0x2273F, "jià"},
    { 0x22740, "tú"},
    { 0x22741, "hōng"},
    { 0x22742, "dú"},
    { 0x22745, "xiá"},
    { 0x22746, "zhòng"},
    { 0x22747, "huò"},
    { 0x22748, "chóng"},
    { 0x22749, "dá"},
    { 0x2274C, "mào"},
    { 0x2274D, "yào"},
    { 0x22753, "juān"},
    { 0x2276C, "shì"},
    { 0x2276F, "yín"},
    { 0x22773, "gǔ"},
    { 0x22774, "wù"},
    { 0x22778, "guò"},
    { 0x22779, "tì"},
    { 0x2277B, "hōng"},
    { 0x22787, "rě"},
    { 0x22789, "yí"},
    { 0x2278B, "tǔn"},
    { 0x2278F, "qióng"},
    { 0x22790, "hài"},
    { 0x22792, "qì"},
    { 0x22795, "huò"},
    { 0x22796, "tì"},
    { 0x22797, "pī,bī"},
    { 0x2279A, "gěng"},
    { 0x2279C, "xiè"},
    { 0x2279E, "mì,mí"},
    { 0x2279F, "gào"},
    { 0x227A0, "tā"},
    { 0x227A1, "xiǎng"},
    { 0x227A3, "shū"},
    { 0x227A6, "fú"},
    { 0x227AC, "zhuān"},
    { 0x227AD, "liù"},
    { 0x227C5, "yóu"},
    { 0x227CA, "chěng"},
    { 0x227CB, "duī"},
    { 0x227E2, "lí"},
    { 0x227E3, "yàng"},
    { 0x227E4, "lí"},
    { 0x227E7, "lǔ"},
    { 0x227E8, "mǔ"},
    { 0x227E9, "suì"},
    { 0x227EA, "ài,xì"},
    { 0x227ED, "kòu"},
    { 0x227EF, "zhé,shì"},
    { 0x227F0, "ài"},
    { 0x227F1, "téng"},
    { 0x227F3, "lǜ"},
    { 0x227F4, "tuí"},
    { 0x227F5, "bī"},
    { 0x227FE, "huì"},
    { 0x227FF, "huán"},
    { 0x2281B, "kuò"},
    { 0x2281D, "xīn"},
    { 0x22821, "sào"},
    { 0x2282B, "shù"},
    { 0x2282C, "què"},
    { 0x2282D, "bā"},
    { 0x2282E, "tuì"},
    { 0x22832, "fù"},
    { 0x22833, "biē"},
    { 0x22835, "tǎng"},
    { 0x22837, "xiàng"},
    { 0x22839, "sī,xī"},
    { 0x2283A, "bó"},
    { 0x2283C, "mái"},
    { 0x2283D, "dàng"},
    { 0x2283F, "guì"},
    { 0x22840, "hēi"},
    { 0x22841, "xī"},
    { 0x22842, "dàng"},
    { 0x22843, "yì"},
    { 0x22845, "bī"},
    { 0x22847, "gū"},
    { 0x22848, "cuì"},
    { 0x22849, "sè"},
    { 0x2284D, "gé"},
    { 0x2284E, "yù"},
    { 0x2284F, "nǎ"},
    { 0x22851, "lì"},
    { 0x22852, "zhì"},
    { 0x22870, "zhào"},
    { 0x22874, "jī"},
    { 0x22875, "ruǎn"},
    { 0x22879, "chòng"},
    { 0x22882, "jié"},
    { 0x2288C, "chàng"},
    { 0x2288D, "zhé"},
    { 0x22892, "sū,sù"},
    { 0x22893, "yōng"},
    { 0x22896, "qì"},
    { 0x22897, "zhuó"},
    { 0x2289A, "kài"},
    { 0x2289C, "yè"},
    { 0x2289E, "qì,jì,kuài"},
    { 0x228B9, "xiòng"},
    { 0x228C9, "yī"},
    { 0x228CA, "chǒu"},
    { 0x228CE, "tuǎn"},
    { 0x228CF, "ài"},
    { 0x228D0, "pīn"},
    { 0x228D3, "liè"},
    { 0x228D4, "mián"},
    { 0x228D5, "ài,chī"},
    { 0x228D7, "mǒ"},
    { 0x228D8, "wèi"},
    { 0x228D9, "yìng"},
    { 0x228DA, "nǐ"},
    { 0x228DE, "bó"},
    { 0x228E0, "liù"},
    { 0x228F3, "ruì"},
    { 0x228F5, "chú"},
    { 0x228FB, "lǘ"},
    { 0x228FC, "chá"},
    { 0x228FF, "chù"},
    { 0x22901, "sào"},
    { 0x22902, "lí"},
    { 0x22904, "sōng"},
    { 0x22906, "lì,là"},
    { 0x2290B, "xì"},
    { 0x2290D, "yān"},
    { 0x2290E, "cuō,zuǒ"},
    { 0x22910, "liú"},
    { 0x22918, "méng"},
    { 0x2291A, "zhàn"},
    { 0x22924, "zhuàng"},
    { 0x22927, "miǎo"},
    { 0x22929, "lì"},
    { 0x2292B, "jǔ"},
    { 0x2292F, "xiè"},
    { 0x22930, "xiè"},
    { 0x22931, "lǒng"},
    { 0x22932, "lóng"},
    { 0x22942, "téng"},
    { 0x22943, "zhù"},
    { 0x2294B, "chán"},
    { 0x2294C, "xiǎn"},
    { 0x2294F, "yíng"},
    { 0x22950, "pèi"},
    { 0x22958, "xié"},
    { 0x2295A, "jiào"},
    { 0x2295E, "chōng"},
    { 0x22973, "hē"},
    { 0x2297D, "tǔn"},
    { 0x22985, "hǒng,zhuàng"},
    { 0x22988, "mán"},
    { 0x2298A, "jīn"},
    { 0x2298C, "qú"},
    { 0x2298D, "dǒu"},
    { 0x2298E, "qiú"},
    { 0x2298F, "zāi"},
    { 0x22991, "shēng"},
    { 0x22992, "zāi"},
    { 0x22995, "yǐ,zhí"},
    { 0x2299A, "huà"},
    { 0x2299F, "kān"},
    { 0x229B0, "yuè"},
    { 0x229B1, "nì"},
    { 0x229B2, "sī"},
    { 0x229B4, "wǒ"},
    { 0x229B8, "cán"},
    { 0x229BA, "jiān"},
    { 0x229BC, "miè"},
    { 0x229BD, "sháo,qī"},
    { 0x229BF, "rǒng"},
    { 0x229C0, "gān"},
    { 0x229C5, "qiáng"},
    { 0x229C7, "shú"},
    { 0x229C8, "zhuó"},
    { 0x229CF, "shī"},
    { 0x229D1, "tì"},
    { 0x229D6, "zhá"},
    { 0x229D7, "zhān"},
    { 0x229DD, "fèn"},
    { 0x229DE, "miè"},
    { 0x229E0, "zè"},
    { 0x229E4, "zhì"},
    { 0x229E5, "qiān"},
    { 0x229E6, "hàn"},
    { 0x229E7, "gé"},
    { 0x229EE, "cán"},
    { 0x229F0, "guó"},
    { 0x229F1, "jiāo"},
    { 0x229F3, "yōng"},
    { 0x229F4, "áo"},
    { 0x229FB, "zhá"},
    { 0x229FD, "xì"},
    { 0x22A01, "xū"},
    { 0x22A02, "wǔ"},
    { 0x22A0F, "jué"},
    { 0x22A10, "jí,jī"},
    { 0x22A12, "chì"},
    { 0x22A14, "wǎn"},
    { 0x22A16, "miè"},
    { 0x22A17, "zéi"},
    { 0x22A1C, "jié"},
    { 0x22A1D, "shí"},
    { 0x22A1F, "xī,xì"},
    { 0x22A21, "è"},
    { 0x22A25, "hù"},
    { 0x22A26, "hù"},
    { 0x22A28, "lì"},
    { 0x22A2B, "chù"},
    { 0x22A2E, "yī"},
    { 0x22A2F, "mǎo"},
    { 0x22A30, "xū"},
    { 0x22A31, "zhōng"},
    { 0x22A33, "yì"},
    { 0x22A3A, "liáo"},
    { 0x22A3F, "jiān"},
    { 0x22A40, "jiǎn"},
    { 0x22A41, "jú"},
    { 0x22A44, "zhù"},
    { 0x22A48, "wǔ"},
    { 0x22A4F, "kè"},
    { 0x22A50, "kě"},
    { 0x22A51, "lì"},
    { 0x22A52, "bǐ"},
    { 0x22A53, "gé"},
    { 0x22A55, "xū"},
    { 0x22A56, "shā"},
    { 0x22A57, "líng"},
    { 0x22A58, "kē"},
    { 0x22A5E, "bó"},
    { 0x22A5F, "biān"},
    { 0x22A60, "shuān"},
    { 0x22A61, "qí"},
    { 0x22A62, "shàn"},
    { 0x22A66, "jī"},
    { 0x22A68, "qiǎo,xiǔ"},
    { 0x22A6E, "yì"},
    { 0x22A6F, "jué"},
    { 0x22A70, "zhǎng"},
    { 0x22A72, "xìn"},
    { 0x22A77, "tuō"},
    { 0x22A78, "hài"},
    { 0x22A79, "xià"},
    { 0x22A7B, "tuó"},
    { 0x22A7C, "yí"},
    { 0x22A83, "cù"},
    { 0x22A87, "jiāng"},
    { 0x22A88, "nán"},
    { 0x22A8B, "pěng,féng,bàng"},
    { 0x22A8D, "jié,jiā"},
    { 0x22A8E, "xuē"},
    { 0x22A8F, "hú,gǔ"},
    { 0x22AA5, "yǒu"},
    { 0x22AA6, "nǔ"},
    { 0x22AA7, "yè"},
    { 0x22AAA, "yìn"},
    { 0x22AAC, "kǒng"},
    { 0x22AB6, "xiāo"},
    { 0x22AB7, "xiāng"},
    { 0x22ABC, "náo"},
    { 0x22ABE, "zhàng"},
    { 0x22AD0, "jié"},
    { 0x22AD3, "nǔ"},
    { 0x22AD4, "shàn,quán"},
    { 0x22AE2, "jiá"},
    { 0x22AE7, "zhǒu"},
    { 0x22AE8, "rǒng,rēng"},
    { 0x22AEB, "lù"},
    { 0x22AEC, "sà,cuō,shā"},
    { 0x22AED, "nù"},
    { 0x22AEF, "bó"},
    { 0x22AF0, "zhé"},
    { 0x22AF2, "qǐn"},
    { 0x22AF4, "cī"},
    { 0x22AF5, "zú"},
    { 0x22AF7, "wǒ"},
    { 0x22AF8, "wǔ,wū"},
    { 0x22AFB, "nié"},
    { 0x22AFF, "xiān"},
    { 0x22B00, "hóng"},
    { 0x22B2B, "tìng"},
    { 0x22B2C, "jǐn"},
    { 0x22B31, "jié"},
    { 0x22B32, "hè"},
    { 0x22B33, "tū"},
    { 0x22B34, "zhé,niè,dié"},
    { 0x22B35, "pīn,pān,biàn,fān"},
    { 0x22B36, "jìn"},
    { 0x22B37, "nàn"},
    { 0x22B3C, "dùn"},
    { 0x22B3E, "xī"},
    { 0x22B3F, "xiè"},
    { 0x22B41, "xì"},
    { 0x22B42, "láo"},
    { 0x22B43, "duǎn,dòu"},
    { 0x22B44, "jì"},
    { 0x22B45, "chā"},
    { 0x22B46, "chōu"},
    { 0x22B48, "gāng"},
    { 0x22B4E, "xiáng"},
    { 0x22B4F, "dǎo"},
    { 0x22B65, "biàn"},
    { 0x22B66, "xiāo"},
    { 0x22B67, "xīn"},
    { 0x22B81, "yǔ"},
    { 0x22B82, "xián"},
    { 0x22B83, "lí"},
    { 0x22B84, "qiǎn"},
    { 0x22B87, "měi"},
    { 0x22B89, "qiāo"},
    { 0x22B8A, "yà"},
    { 0x22B8C, "qiā,jié"},
    { 0x22B8D, "qiòng"},
    { 0x22B8F, "bàng"},
    { 0x22B90, "zhēng"},
    { 0x22B9A, "zè"},
    { 0x22B9B, "shuàn,tuán"},
    { 0x22B9E, "sào"},
    { 0x22BC5, "lù,jué"},
    { 0x22BC9, "xié"},
    { 0x22BCB, "fǔ"}
};
