/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     chenhaifeng  <chenhaifeng@uniontech.com>
*
* Maintainer: chenhaifeng  <chenhaifeng@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "pinyindict.h"

QMap<int, QString> PinyinDict_16{
    { 0x22BCC, "zhài"},
    { 0x22BE9, "zè"},
    { 0x22BEB, "duàn,wǎn"},
    { 0x22BED, "dèng"},
    { 0x22BEE, "yù"},
    { 0x22BF0, "lǜ"},
    { 0x22BF2, "wàn"},
    { 0x22BF3, "xué"},
    { 0x22BF4, "jiǎo"},
    { 0x22BF5, "yuě"},
    { 0x22BF6, "zhì"},
    { 0x22BF7, "wěi,huī"},
    { 0x22BF9, "gé"},
    { 0x22BFA, "jǔ"},
    { 0x22BFC, "yǎn"},
    { 0x22BFD, "cuò"},
    { 0x22BFE, "mào"},
    { 0x22C06, "fú"},
    { 0x22C07, "āi"},
    { 0x22C0A, "xuān"},
    { 0x22C0C, "gāng"},
    { 0x22C0D, "ān"},
    { 0x22C12, "jí"},
    { 0x22C18, "pí"},
    { 0x22C19, "zhǐ"},
    { 0x22C1C, "nuó"},
    { 0x22C3F, "pàn"},
    { 0x22C41, "yí"},
    { 0x22C44, "jié"},
    { 0x22C46, "zī"},
    { 0x22C48, "jià"},
    { 0x22C49, "wǎi"},
    { 0x22C4C, "jià"},
    { 0x22C5F, "chǎn,chī"},
    { 0x22C61, "suǒ"},
    { 0x22C62, "suǒ,sè"},
    { 0x22C63, "jí"},
    { 0x22C64, "sǒng"},
    { 0x22C66, "tī"},
    { 0x22C67, "pī"},
    { 0x22C68, "pó"},
    { 0x22C6E, "mì"},
    { 0x22C74, "yè"},
    { 0x22C76, "qìn"},
    { 0x22C77, "jìn"},
    { 0x22C7A, "juē"},
    { 0x22C7D, "yuān"},
    { 0x22C7E, "ruán"},
    { 0x22C94, "bàn,bān,pān"},
    { 0x22CB0, "bīn"},
    { 0x22CB4, "wèi"},
    { 0x22CB5, "zào"},
    { 0x22CB6, "qiè"},
    { 0x22CB7, "sōu"},
    { 0x22CB8, "lǔ"},
    { 0x22CBC, "dié"},
    { 0x22CBD, "chuāi"},
    { 0x22CBE, "bì"},
    { 0x22CBF, "zhú"},
    { 0x22CC0, "mā,mó"},
    { 0x22CC1, "fèi"},
    { 0x22CC2, "piē"},
    { 0x22CC3, "yìn"},
    { 0x22CC4, "xuàn,xuán"},
    { 0x22CC6, "ào,áo"},
    { 0x22CC7, "zhuó,zú"},
    { 0x22CC8, "zú"},
    { 0x22CCB, "bǐ"},
    { 0x22CD1, "làng"},
    { 0x22CD3, "tì"},
    { 0x22CD9, "tiǎo"},
    { 0x22CDA, "jiān"},
    { 0x22CDF, "tǒng"},
    { 0x22CFD, "duō"},
    { 0x22CFE, "dòng"},
    { 0x22D02, "biǎn"},
    { 0x22D20, "zhì"},
    { 0x22D22, "fén"},
    { 0x22D26, "káng"},
    { 0x22D27, "zhì"},
    { 0x22D28, "zhāi,zhì,chì"},
    { 0x22D29, "bì"},
    { 0x22D2A, "kuǎn"},
    { 0x22D2C, "bàn"},
    { 0x22D2D, "juē"},
    { 0x22D2E, "qū"},
    { 0x22D30, "qī"},
    { 0x22D31, "léi"},
    { 0x22D32, "xié,jié"},
    { 0x22D33, "tāng"},
    { 0x22D3C, "sōu"},
    { 0x22D3E, "bèi"},
    { 0x22D47, "yàng"},
    { 0x22D48, "jiǎn,zhǎn"},
    { 0x22D65, "zào"},
    { 0x22D80, "zhuài,chuái"},
    { 0x22D83, "fán"},
    { 0x22D85, "shé"},
    { 0x22D87, "qióng"},
    { 0x22D89, "pò"},
    { 0x22D8B, "tiě"},
    { 0x22D8C, "shā"},
    { 0x22D8D, "zá,sà"},
    { 0x22D91, "niǎo"},
    { 0x22D92, "guài"},
    { 0x22D93, "cuǐ"},
    { 0x22DA1, "qiào,jiǎo"},
    { 0x22DA3, "dié"},
    { 0x22DB3, "pīn"},
    { 0x22DB4, "cí"},
    { 0x22DB6, "bàng"},
    { 0x22DCD, "yìn"},
    { 0x22DD1, "xiǎn"},
    { 0x22DD4, "yǐ"},
    { 0x22DD5, "miǎo"},
    { 0x22DD6, "duǎn"},
    { 0x22DD7, "zhòu"},
    { 0x22DD9, "kōng"},
    { 0x22DE2, "zhāng"},
    { 0x22DF6, "liú"},
    { 0x22DF8, "zhǐ"},
    { 0x22DF9, "chǎn"},
    { 0x22DFA, "dú"},
    { 0x22DFB, "yuán"},
    { 0x22DFE, "suò,cè"},
    { 0x22DFF, "jié"},
    { 0x22E00, "lì"},
    { 0x22E01, "gǒng"},
    { 0x22E0C, "bāng"},
    { 0x22E17, "guó"},
    { 0x22E18, "liáo"},
    { 0x22E19, "shěn"},
    { 0x22E23, "niǎo"},
    { 0x22E25, "cuàn"},
    { 0x22E26, "wěi"},
    { 0x22E28, "tuō"},
    { 0x22E2B, "sū"},
    { 0x22E2D, "lóng"},
    { 0x22E33, "xiāo"},
    { 0x22E34, "yǎn,yán"},
    { 0x22E43, "qǐng"},
    { 0x22E4D, "xī"},
    { 0x22E4F, "yú"},
    { 0x22E51, "zhèng,zhēng"},
    { 0x22E52, "xiè"},
    { 0x22E53, "chāi"},
    { 0x22E54, "fèn"},
    { 0x22E56, "guó"},
    { 0x22E58, "jǐng"},
    { 0x22E59, "làn"},
    { 0x22E5A, "xiān"},
    { 0x22E5D, "líng"},
    { 0x22E6E, "lěi"},
    { 0x22E72, "jùn"},
    { 0x22E73, "xiào"},
    { 0x22E7C, "zá"},
    { 0x22E84, "guān"},
    { 0x22E85, "qiè"},
    { 0x22E86, "luò"},
    { 0x22E87, "yào"},
    { 0x22E88, "luán"},
    { 0x22E89, "tà"},
    { 0x22E91, "luò"},
    { 0x22E9E, "bǎ"},
    { 0x22E9F, "chàn"},
    { 0x22EA1, "zhuó"},
    { 0x22EAB, "tiǎo"},
    { 0x22EAF, "wān"},
    { 0x22EB0, "líng,lìng"},
    { 0x22EB4, "yù"},
    { 0x22EB5, "qì,qǐ"},
    { 0x22EB7, "qí"},
    { 0x22EBC, "jì"},
    { 0x22EBD, "bó,jiào"},
    { 0x22EBF, "shī"},
    { 0x22EC0, "fǔ"},
    { 0x22EC2, "guī"},
    { 0x22EC5, "diǎn"},
    { 0x22EC7, "hāo"},
    { 0x22EC9, "gǎi"},
    { 0x22ECB, "qí"},
    { 0x22ED3, "chéng"},
    { 0x22ED4, "huì"},
    { 0x22ED7, "xiá,guī"},
    { 0x22ED8, "shí"},
    { 0x22ED9, "zhì"},
    { 0x22EDA, "qí"},
    { 0x22EDC, "hài"},
    { 0x22EDF, "jiǎo"},
    { 0x22EE0, "lì"},
    { 0x22EE2, "liǎo"},
    { 0x22EE4, "qiāo,qiáo"},
    { 0x22EE8, "sà"},
    { 0x22EEA, "qī"},
    { 0x22EEB, "shī"},
    { 0x22EEE, "jié,fú"},
    { 0x22EF5, "bèi,lù"},
    { 0x22EF6, "biān"},
    { 0x22EF7, "bā"},
    { 0x22EF8, "jūn"},
    { 0x22EF9, "pī"},
    { 0x22EFC, "dǎn"},
    { 0x22EFF, "táng"},
    { 0x22F00, "kuǐ"},
    { 0x22F01, "kū"},
    { 0x22F03, "kǒu"},
    { 0x22F09, "shī"},
    { 0x22F0A, "shī,tuó"},
    { 0x22F0B, "jī"},
    { 0x22F0C, "bào"},
    { 0x22F10, "kě"},
    { 0x22F11, "kuāng"},
    { 0x22F16, "mǐn"},
    { 0x22F19, "liáo"},
    { 0x22F1A, "è"},
    { 0x22F1B, "gé,guó,è"},
    { 0x22F1F, "wǎng"},
    { 0x22F20, "duó"},
    { 0x22F23, "qià"},
    { 0x22F24, "huá"},
    { 0x22F26, "hǒng"},
    { 0x22F29, "pēng"},
    { 0x22F2B, "jiào"},
    { 0x22F30, "qū"},
    { 0x22F31, "zì"},
    { 0x22F32, "zhòu"},
    { 0x22F33, "kuāng"},
    { 0x22F35, "shā"},
    { 0x22F37, "jì"},
    { 0x22F38, "wēi,wéi"},
    { 0x22F39, "pū,bǔ"},
    { 0x22F3A, "xué"},
    { 0x22F3C, "shāo"},
    { 0x22F42, "láng"},
    { 0x22F43, "zhǐ"},
    { 0x22F44, "tǐng"},
    { 0x22F47, "dà"},
    { 0x22F55, "yáng"},
    { 0x22F56, "jìn"},
    { 0x22F57, "zhǐ"},
    { 0x22F5A, "zhuó,dū"},
    { 0x22F5C, "zá"},
    { 0x22F5D, "chán"},
    { 0x22F62, "mào"},
    { 0x22F66, "kōng"},
    { 0x22F67, "zhōu"},
    { 0x22F68, "hū"},
    { 0x22F69, "pēng"},
    { 0x22F6D, "jiù"},
    { 0x22F78, "chuò"},
    { 0x22F79, "mǐn"},
    { 0x22F7E, "xiào"},
    { 0x22F80, "dǔ"},
    { 0x22F81, "wéi"},
    { 0x22F83, "cán"},
    { 0x22F84, "yú"},
    { 0x22F85, "dù"},
    { 0x22F86, "kāi"},
    { 0x22F87, "pì"},
    { 0x22F8A, "chéng"},
    { 0x22F8E, "chǔn"},
    { 0x22F90, "shǎo"},
    { 0x22F91, "yǎn"},
    { 0x22F92, "kuài"},
    { 0x22F94, "yuē"},
    { 0x22FA6, "qí"},
    { 0x22FA7, "zhēng"},
    { 0x22FA9, "kè"},
    { 0x22FAA, "qí"},
    { 0x22FAB, "zhǐ"},
    { 0x22FAC, "lù"},
    { 0x22FB1, "pī"},
    { 0x22FB2, "nuò"},
    { 0x22FB3, "pǎo"},
    { 0x22FBA, "fěi"},
    { 0x22FBF, "wén"},
    { 0x22FC2, "méng"},
    { 0x22FC8, "shǎn"},
    { 0x22FCC, "xiòng,xuàn"},
    { 0x22FCE, "duò"},
    { 0x22FCF, "biào,pāo"},
    { 0x22FDA, "yōu"},
    { 0x22FDC, "màn"},
    { 0x22FDE, "liǎo"},
    { 0x22FE1, "xié"},
    { 0x22FE2, "luàn"},
    { 0x22FE3, "qiāo"},
    { 0x22FE4, "dèng"},
    { 0x22FE6, "chéng"},
    { 0x22FE7, "chéng"},
    { 0x22FED, "chuò"},
    { 0x22FF8, "cè"},
    { 0x23000, "léi"},
    { 0x23001, "zhǎn"},
    { 0x23002, "lǐ"},
    { 0x23003, "lián"},
    { 0x23004, "qún"},
    { 0x2300D, "chén"},
    { 0x2300F, "chéng"},
    { 0x23010, "gū"},
    { 0x23012, "zòng"},
    { 0x23013, "chóu,dǎo"},
    { 0x23014, "chuàn,chuò"},
    { 0x2301C, "lèi"},
    { 0x2301D, "shuò"},
    { 0x2301E, "lǜ"},
    { 0x23023, "fú"},
    { 0x23025, "lì"},
    { 0x23027, "sàn"},
    { 0x2302B, "sān"},
    { 0x2302F, "sà"},
    { 0x23033, "niè"},
    { 0x23036, "zuān"},
    { 0x23037, "lǐ,lí"},
    { 0x2303B, "shǔ,zhǔ"},
    { 0x2303E, "fú"},
    { 0x23049, "bì"},
    { 0x2304D, "dào"},
    { 0x23052, "shī"},
    { 0x23056, "gàn"},
    { 0x23057, "tàn"},
    { 0x2305C, "màn"},
    { 0x2305F, "lí"},
    { 0x23062, "bì"},
    { 0x23066, "pán"},
    { 0x23068, "yōu"},
    { 0x2306D, "jiū"},
    { 0x2306F, "guō"},
    { 0x23070, "liáo"},
    { 0x23073, "wò"},
    { 0x23074, "qià"},
    { 0x23075, "dǒu"},
    { 0x23077, "liè"},
    { 0x23079, "jiǎo"},
    { 0x2307B, "liè,luō"},
    { 0x23081, "tiāo,qiāo"},
    { 0x23084, "guō"},
    { 0x23086, "pāng"},
    { 0x23087, "qiāo"},
    { 0x23089, "dí"},
    { 0x2308A, "yùn"},
    { 0x23092, "lè"},
    { 0x23096, "sī"},
    { 0x23097, "xīn"},
    { 0x2309C, "xīn"},
    { 0x2309D, "xiàng"},
    { 0x2309E, "luǒ"},
    { 0x230A4, "bēng"},
    { 0x230A5, "tiāo,qiāo"},
    { 0x230AC, "xiào"},
    { 0x230AE, "dōu,tóu"},
    { 0x230B3, "dàng"},
    { 0x230B4, "tíng"},
    { 0x230B5, "zhuàn"},
    { 0x230BB, "ōu,kōu"},
    { 0x230BD, "wò"},
    { 0x230C4, "xīn"},
    { 0x230C5, "ruǎn"},
    { 0x230C8, "zhuó"},
    { 0x230C9, "dàng"},
    { 0x230CD, "cuì,chà"},
    { 0x230D1, "zhuó"},
    { 0x230D7, "cóng"},
    { 0x230D8, "chǎn,chuáng"},
    { 0x230DD, "yǎng"},
    { 0x230E7, "yǎn"},
    { 0x230F3, "yǎn,yè"},
    { 0x230F5, "zhèn,shēn"},
    { 0x230FD, "nuǒ"},
    { 0x230FE, "yàn"},
    { 0x23105, "fǎng"},
    { 0x23109, "yǎn"},
    { 0x2310A, "yú"},
    { 0x2310D, "tí"},
    { 0x2310E, "fù"},
    { 0x2310F, "běn"},
    { 0x23111, "yǎn"},
    { 0x23113, "huī"},
    { 0x23119, "huǎng"},
    { 0x2311C, "guì"},
    { 0x2311D, "yàn"},
    { 0x2311F, "hú"},
    { 0x23120, "biāo"},
    { 0x23127, "suì,wéi"},
    { 0x2312E, "zì"},
    { 0x2312F, "jì"},
    { 0x23130, "ě"},
    { 0x23131, "jì"},
    { 0x23132, "kuǐ"},
    { 0x23134, "liàng"},
    { 0x23138, "huò"},
    { 0x2313A, "wéi"},
    { 0x2313B, "zhuō"},
    { 0x2313F, "tǐng"},
    { 0x23143, "zǎi"},
    { 0x23144, "yòu"},
    { 0x23149, "rèn"},
    { 0x2314D, "miàn,bīng"},
    { 0x2315A, "nà,niǔ"},
    { 0x2315D, "tū"},
    { 0x2315F, "dān"},
    { 0x23161, "jué"},
    { 0x23164, "xū"},
    { 0x23165, "dī"},
    { 0x23170, "xiàng"},
    { 0x23177, "xiòng"},
    { 0x2317A, "yǒu"},
    { 0x2317B, "guǎ,jiōng"},
    { 0x2317E, "xī"},
    { 0x23188, "hè"},
    { 0x2318D, "dǐng"},
    { 0x23190, "lú"},
    { 0x23192, "xú"},
    { 0x23194, "zhòu"},
    { 0x23195, "xiàn"},
    { 0x23196, "huāng"},
    { 0x23197, "chā"},
    { 0x23198, "shǐ"},
    { 0x23199, "gàn"},
    { 0x2319A, "nuǒ,chǐ"},
    { 0x2319B, "àn,wǎn"},
    { 0x2319F, "xiē,jiē"},
    { 0x231A7, "hào"},
    { 0x231B2, "qīn"},
    { 0x231B3, "gěng"},
    { 0x231B4, "shān"},
    { 0x231B5, "fú"},
    { 0x231BD, "zè"},
    { 0x231C7, "dàn"},
    { 0x231D6, "diǎn"},
    { 0x231D7, "shēn"},
    { 0x231D9, "zǔ"},
    { 0x231E2, "biē"},
    { 0x231E6, "chuí"},
    { 0x231E7, "zhè"},
    { 0x231E8, "dài"},
    { 0x231EB, "wǒ"},
    { 0x231EC, "qióng"},
    { 0x231F0, "lín"},
    { 0x231F2, "hūn"},
    { 0x231F3, "jī"},
    { 0x23205, "cáo"},
    { 0x2320A, "mù"},
    { 0x2320D, "dié"},
    { 0x2320E, "wèi"},
    { 0x23220, "biàn"},
    { 0x23221, "tǐ"},
    { 0x23225, "tú"},
    { 0x23236, "gèng"},
    { 0x23244, "chí"},
    { 0x23245, "còu"},
    { 0x23246, "tǐ"},
    { 0x23252, "huò"},
    { 0x23253, "qī"},
    { 0x23254, "sāo"},
    { 0x23255, "sàng"},
    { 0x23256, "xuǎn"},
    { 0x23257, "àng"},
    { 0x23258, "nài"},
    { 0x2325A, "yáng"},
    { 0x2325B, "shū"},
    { 0x2325C, "shā"},
    { 0x23261, "tǐng"},
    { 0x23269, "yà"},
    { 0x2326A, "huǎng"},
    { 0x2326E, "bīn"},
    { 0x2327E, "òu"},
    { 0x2327F, "cáo"},
    { 0x23281, "áo"},
    { 0x23283, "mào"},
    { 0x23294, "méng"},
    { 0x23296, "tiān"},
    { 0x2329D, "sàng"},
    { 0x2329E, "xù"},
    { 0x2329F, "kàn"},
    { 0x232A7, "lǎng,zhào"},
    { 0x232B6, "biē"},
    { 0x232B7, "cóng"},
    { 0x232BA, "xián"},
    { 0x232C4, "tūn"},
    { 0x232C9, "yù"},
    { 0x232CA, "dàn"},
    { 0x232CB, "yìng"},
    { 0x232CD, "zhāo"},
    { 0x232CF, "pù"},
    { 0x232D8, "huì"},
    { 0x232DE, "ài"},
    { 0x232DF, "mǒ"},
    { 0x232E2, "jīng"},
    { 0x232E3, "lán"},
    { 0x232F2, "liè"},
    { 0x232F3, "piǎo,bào"},
    { 0x232F5, "bó"},
    { 0x232F6, "qióng"},
    { 0x232F9, "bì"},
    { 0x232FF, "yōng"},
    { 0x23305, "lì"},
    { 0x2330D, "niè"},
    { 0x2330F, "dé"},
    { 0x23313, "huān"},
    { 0x23317, "yuè"},
    { 0x2331A, "chūn"},
    { 0x2331C, "lì"},
    { 0x2331E, "zhāng"},
    { 0x2331F, "líng"},
    { 0x23320, "chún"},
    { 0x23327, "cè"},
    { 0x23328, "xún"},
    { 0x2332C, "jǔ"},
    { 0x2332D, "hui,dá"},
    { 0x2333E, "tōng"},
    { 0x23346, "níng"},
    { 0x23347, "jù"},
    { 0x2334F, "chà"},
    { 0x23356, "zāo"},
    { 0x2335B, "yù"},
    { 0x2335F, "kěn,wěi"},
    { 0x23366, "kuàng"},
    { 0x23367, "fěi"},
    { 0x2336F, "yùn"},
    { 0x23370, "qiǎn"},
    { 0x23374, "quán"},
    { 0x23378, "pò"},
    { 0x2337A, "pěi"},
    { 0x23384, "gèng"},
    { 0x23385, "yì,huān"},
    { 0x23386, "luò"},
    { 0x23391, "kuān"},
    { 0x23393, "xuǎn"},
    { 0x23394, "niàn"},
    { 0x2339A, "hú"},
    { 0x2339B, "jú,xuè"},
    { 0x233A9, "yè"},
    { 0x233AE, "xī"},
    { 0x233B1, "yuè"},
    { 0x233B2, "tǎng"},
    { 0x233B3, "pìn"},
    { 0x233B4, "dǔn,è,ài"},
    { 0x233B5, "bèi,pō"},
    { 0x233B8, "liǎo"},
    { 0x233C0, "yǒng"},
    { 0x233CE, "yā"},
    { 0x233D1, "jiǎo"},
    { 0x233D4, "kùn,kǔn"},
    { 0x233D6, "zhèn"},
    { 0x233D7, "shù"},
    { 0x233DA, "shí"},
    { 0x233DE, "yóu"},
    { 0x233DF, "pài"},
    { 0x233E0, "xiáo"},
    { 0x233E1, "jí"},
    { 0x233F6, "qī"},
    { 0x233F7, "hé"},
    { 0x233FA, "kǒng"},
    { 0x23402, "yè"},
    { 0x23403, "chì"},
    { 0x2340A, "kǎo,jú"},
    { 0x2340B, "yuè"},
    { 0x2340E, "wǎ"},
    { 0x2340F, "niǎn"},
    { 0x23411, "cí"},
    { 0x23413, "yí"},
    { 0x23424, "jiu"},
    { 0x2342B, "yāng"},
    { 0x2342C, "lí"},
    { 0x2342E, "dāi"},
    { 0x2342F, "chóng"},
    { 0x23435, "yí"},
    { 0x2343A, "hàn"},
    { 0x2343F, "yī"},
    { 0x23441, "chòng"},
    { 0x23442, "hù"},
    { 0x23443, "zhuǎ"},
    { 0x23466, "qióng"},
    { 0x23467, "duò"},
    { 0x23478, "tóng"},
    { 0x23479, "xiān"},
    { 0x2347F, "fú"},
    { 0x23482, "diàn"},
    { 0x23483, "xí"},
    { 0x23484, "xiē"},
    { 0x23485, "zhèn"},
    { 0x23486, "qiào"},
    { 0x23487, "tū"},
    { 0x234B7, "hàn"},
    { 0x234B8, "kuàng"},
    { 0x234B9, "suō"},
    { 0x234BB, "shòu"},
    { 0x234BC, "tiáo"},
    { 0x234C0, "zhēn,zhěn"},
    { 0x234C3, "nèi"},
    { 0x234C5, "qiǎn"},
    { 0x234C6, "yín"},
    { 0x234C8, "liǎng"},
    { 0x234C9, "shà,jié"},
    { 0x234CA, "zì"},
    { 0x234CB, "pí"},
    { 0x234CC, "gāo,jú"},
    { 0x234CF, "jìn"},
    { 0x234D0, "yóu"},
    { 0x234D2, "shàn"},
    { 0x234D4, "mì"},
    { 0x234D5, "òu"},
    { 0x234D7, "hū"},
    { 0x234DB, "yòu"},
    { 0x234DD, "měng"},
    { 0x23510, "zhǐ"},
    { 0x23513, "bǐ"},
    { 0x23517, "shēn"},
    { 0x23518, "qì"},
    { 0x23519, "xiān"},
    { 0x2351A, "pán"},
    { 0x2351B, "kǎng"},
    { 0x2352B, "shuān"},
    { 0x2352C, "pí"},
    { 0x2352E, "zāi"},
    { 0x2352F, "zhǔ"},
    { 0x23531, "sōu,sāo"},
    { 0x23532, "jiǒng"},
    { 0x23535, "chán"},
    { 0x23536, "fán,fàn"},
    { 0x23537, "xiáo"},
    { 0x23538, "yǐn"},
    { 0x23539, "hóu"},
    { 0x2353A, "mào"},
    { 0x2353B, "tú,chán"},
    { 0x2353D, "jì"},
    { 0x23541, "yí"},
    { 0x23543, "yù"},
    { 0x23544, "jiōng"},
    { 0x23545, "pào"},
    { 0x23547, "xiāo"},
    { 0x23549, "gǒu"},
    { 0x2354C, "gōu"},
    { 0x2354D, "sǔn"},
    { 0x2354E, "xiǎn"},
    { 0x2354F, "zhuǎn"},
    { 0x2357E, "chóu,bì"},
    { 0x23584, "qiāo"},
    { 0x23585, "tí"},
    { 0x23586, "yún"},
    { 0x23589, "shān"},
    { 0x2358A, "liè,lì"},
    { 0x2358C, "zhǐ"},
    { 0x23590, "pāi"},
    { 0x235A3, "jú"},
    { 0x235A4, "lái"},
    { 0x235A8, "zǐ"},
    { 0x235AA, "qú"},
    { 0x235AB, "gǔ,què"},
    { 0x235AC, "jué"},
    { 0x235AD, "zhí"},
    { 0x235AE, "àng"},
    { 0x235AF, "qìn"},
    { 0x235B0, "pí"},
    { 0x235B1, "zuī"},
    { 0x235B3, "qián"},
    { 0x235B5, "cuó"},
    { 0x235B7, "jí"},
    { 0x235B8, "tí"},
    { 0x235B9, "rú"},
    { 0x235BB, "hǎi"},
    { 0x235BC, "xún"},
    { 0x235BE, "bèi"},
    { 0x235BF, "zhí"},
    { 0x235C1, "dùn,zā"},
    { 0x235CB, "dǎng"},
    { 0x235D0, "réng"},
    { 0x235F2, "gān"},
    { 0x235F5, "gàng,gāng"},
    { 0x235F6, "tà"},
    { 0x235F8, "tuò"},
    { 0x235F9, "yàng"},
    { 0x235FA, "kū"},
    { 0x235FB, "zhì"},
    { 0x23616, "jiān"},
    { 0x23617, "nì"},
    { 0x23618, "shēn,zhēn"},
    { 0x23619, "bàng"},
    { 0x2361A, "shuài"},
    { 0x2361B, "dōu"},
    { 0x2361D, "qiān"},
    { 0x2361E, "hán"},
    { 0x2361F, "qiā"},
    { 0x23620, "gǎn"},
    { 0x23623, "chún"},
    { 0x23624, "chá,sà"},
    { 0x23625, "bì"},
    { 0x23626, "yī"},
    { 0x23627, "fū"},
    { 0x23628, "ě,ē"},
    { 0x2362A, "láo"},
    { 0x2362B, "háo"},
    { 0x2362C, "lí"},
    { 0x23631, "tè"},
    { 0x23632, "shēn"},
    { 0x23634, "yín"},
    { 0x23637, "jiān"},
    { 0x2363B, "chá,tú"},
    { 0x23657, "niè"},
    { 0x23658, "còu"},
    { 0x2365B, "yí"},
    { 0x2365F, "táng"},
    { 0x23662, "juàn"},
    { 0x23670, "chì"},
    { 0x23671, "gǒu"},
    { 0x23674, "jié"},
    { 0x23675, "zhé"},
    { 0x23676, "hú"},
    { 0x23677, "máng"},
    { 0x2367B, "zōu"},
    { 0x2367C, "sì,cí"},
    { 0x2367F, "fèi"},
    { 0x23680, "zī"},
    { 0x23681, "zī"},
    { 0x23683, "jié"},
    { 0x23684, "sī"},
    { 0x23686, "chūn"},
    { 0x23687, "pào"},
    { 0x2368B, "yé"},
    { 0x2368C, "dī,shì"},
    { 0x2368E, "léi"},
    { 0x2368F, "xū"},
    { 0x23690, "rú"},
    { 0x23692, "pá"},
    { 0x23693, "juàn"},
    { 0x23694, "xì"},
    { 0x23695, "yè,yǎn"},
    { 0x23696, "ān"},
    { 0x23698, "yì"},
    { 0x23699, "jiān,jiàn"},
    { 0x2369C, "sōng"},
    { 0x2369D, "wǒ"},
    { 0x2369F, "sè"},
    { 0x236A0, "zhǐ"},
    { 0x236A1, "bī"},
    { 0x236A2, "zhuàn"},
    { 0x236A6, "jiàng"},
    { 0x236A7, "hào"},
    { 0x236A9, "chì"},
    { 0x236AA, "dùn"},
    { 0x236D3, "bó"},
    { 0x236D4, "jí"},
    { 0x236D5, "chuǎ"},
    { 0x236D7, "luò"},
    { 0x236DA, "ruǐ"},
    { 0x236EB, "hú"},
    { 0x236F1, "dàn,lǎn"},
    { 0x236F4, "hǎn"},
    { 0x236F5, "què"},
    { 0x236F6, "shā"},
    { 0x236F7, "zhǎn"},
    { 0x236F8, "zé"},
    { 0x236F9, "chuán,chuǎi"},
    { 0x236FA, "qī"},
    { 0x236FB, "dié"},
    { 0x236FD, "zhà"},
    { 0x236FE, "tòu"},
    { 0x23701, "cī"},
    { 0x23702, "sà"},
    { 0x23704, "luó"},
    { 0x23707, "jí"},
    { 0x23722, "luǒ"},
    { 0x23723, "qín"},
    { 0x23727, "qióng"},
    { 0x23728, "juàn"},
    { 0x2372C, "ài"},
    { 0x2372D, "jiǎn"},
    { 0x23739, "tì"},
    { 0x2373A, "wén"},
    { 0x2373D, "qiāo"},
    { 0x23741, "pái,bēi"},
    { 0x23742, "hún"},
    { 0x23745, "ài"},
    { 0x23747, "shuò"},
    { 0x23748, "lián"},
    { 0x23749, "duì"},
    { 0x2374B, "tà"},
    { 0x2374C, "jǐn"},
    { 0x2374D, "bì"},
    { 0x2374E, "yǎn"},
    { 0x2374F, "gào"},
    { 0x23750, "piáo"},
    { 0x23751, "yù,yú"},
    { 0x23752, "shè"},
    { 0x23755, "jiān"},
    { 0x23757, "hú"},
    { 0x2375A, "liè"},
    { 0x2375C, "biàn"},
    { 0x2375D, "sù"},
    { 0x2375E, "jiāo"},
    { 0x23778, "zhuì"},
    { 0x2377D, "hān"},
    { 0x23787, "dùn"},
    { 0x23790, "xiě"},
    { 0x23791, "méng"},
    { 0x23792, "fū"},
    { 0x23793, "lù"},
    { 0x23794, "tàn"},
    { 0x23797, "liú"},
    { 0x23798, "xiān"},
    { 0x23799, "sǎng"},
    { 0x2379C, "còu"},
    { 0x2379D, "zhuāng"},
    { 0x2379F, "chēn"},
    { 0x237B0, "liàn"},
    { 0x237B4, "lí"},
    { 0x237C0, "pèng"},
    { 0x237C1, "tuǒ"},
    { 0x237C4, "tuò"},
    { 0x237C6, "liáo"},
    { 0x237C7, "xiào"},
    { 0x237C8, "chuì"},
    { 0x237C9, "huài"},
    { 0x237CA, "niǎo"},
    { 0x237CB, "qiān"},
    { 0x237CC, "lì"},
    { 0x237CF, "pāo"},
    { 0x237D0, "tiáo"},
    { 0x237D1, "liú"},
    { 0x237D2, "wú"},
    { 0x237E4, "yǐng"},
    { 0x237E6, "zhá"},
    { 0x237F0, "yú"},
    { 0x237F2, "xiǎn"},
    { 0x237F3, "xuán"},
    { 0x237F4, "shuān"},
    { 0x237F5, "xī"},
    { 0x237F8, "méi"},
    { 0x237F9, "sēn"},
    { 0x237FA, "liàn"},
    { 0x237FC, "jiū,qiāo"},
    { 0x237FD, "lào"},
    { 0x2380E, "xiāo"},
    { 0x2380F, "zōu"},
    { 0x2381A, "liú"},
    { 0x2381C, "zhào"},
    { 0x2381E, "zhé,shè"},
    { 0x23820, "lěi"},
    { 0x2382D, "duǎn"},
    { 0x23837, "jiǎn"},
    { 0x23838, "shuān"},
    { 0x23839, "zuó"},
    { 0x2383A, "qiè"},
    { 0x2383C, "lǎo"},
    { 0x23849, "yù"},
    { 0x2384A, "yì"},
    { 0x2384B, "nǐ"},
    { 0x2384E, "cén"},
    { 0x23855, "yàn"},
    { 0x23857, "ruǎn"},
    { 0x2385E, "yán"},
    { 0x2385F, "dié"},
    { 0x23860, "mián"},
    { 0x23867, "léi"},
    { 0x23869, "wān"},
    { 0x23870, "nǎ"},
    { 0x23876, "yán"},
    { 0x2387A, "lěi"},
    { 0x2387D, "shā"},
    { 0x2387E, "hū"},
    { 0x23881, "xī"},
    { 0x23882, "xī"},
    { 0x23884, "yǒu,yōu"},
    { 0x23885, "hān"},
    { 0x23887, "hāi,xī"},
    { 0x23889, "wā"},
    { 0x2388A, "xù"},
    { 0x2388B, "pī"},
    { 0x2388C, "tān"},
    { 0x2388D, "xī"},
    { 0x2388E, "xī"},
    { 0x2388F, "bīn"},
    { 0x23890, "qīn,kēng"},
    { 0x23891, "xī"},
    { 0x23892, "yú"},
    { 0x23893, "xì"},
    { 0x23895, "cì"},
    { 0x23896, "qiàn"},
    { 0x23897, "xiā"},
    { 0x2389A, "wá"},
    { 0x2389B, "è"},
    { 0x2389C, "yǒu,yōu"},
    { 0x2389D, "xìng"},
    { 0x2389E, "ní"},
    { 0x2389F, "hán,xián"},
    { 0x238A0, "bì"},
    { 0x238A1, "shēng"},
    { 0x238A4, "zhān"},
    { 0x238A5, "diàn"},
    { 0x238A6, "yǔ"},
    { 0x238A8, "ǒu"},
    { 0x238AA, "guǐ"},
    { 0x238AB, "wǎng,wāng"},
    { 0x238AC, "qiān"},
    { 0x238AD, "yí"},
    { 0x238B0, "zú"},
    { 0x238B2, "qiān"},
    { 0x238B3, "dìng"},
    { 0x238B4, "kēng"},
    { 0x238B6, "chù"},
    { 0x238B7, "yī"},
    { 0x238BA, "hān"},
    { 0x238BB, "kuǎn"},
    { 0x238C8, "diàn"},
    { 0x238C9, "xì"},
    { 0x238CA, "zī"},
    { 0x238CB, "líng"},
    { 0x238CC, "zì,sì"},
    { 0x238CE, "yù"},
    { 0x238CF, "hūn"},
    { 0x238D1, "sǐ"},
    { 0x238D2, "kǎn"},
    { 0x238DA, "àn"},
    { 0x238DC, "yǒu"},
    { 0x238DD, "jí"},
    { 0x238DE, "hùn"},
    { 0x238DF, "qiā"},
    { 0x238E0, "hóu"},
    { 0x238E1, "hóu"},
    { 0x238E3, "diàn"},
    { 0x238E9, "xiē"},
    { 0x238ED, "shè"},
    { 0x238EE, "shà"},
    { 0x238F2, "xié"},
    { 0x238F3, "yáo,yǎo"},
    { 0x238F4, "dà"},
    { 0x238F6, "xiè"},
    { 0x238F7, "chī"},
    { 0x238F8, "yǒu"},
    { 0x238F9, "hē"},
    { 0x238FA, "shà"},
    { 0x238FF, "tái"},
    { 0x23901, "zhú"},
    { 0x23903, "ǎi"},
    { 0x23907, "què"},
    { 0x23908, "zé"},
    { 0x2390A, "lā"},
    { 0x2390B, "lòu"},
    { 0x2390C, "chuài,chǐ,chuò"},
    { 0x2390E, "yǒu"},
    { 0x23916, "tì"},
    { 0x23918, "shī"},
    { 0x23921, "xiào,yǒu"},
    { 0x23922, "xì"},
    { 0x23928, "huò"},
    { 0x23929, "chì"},
    { 0x2392A, "yì"},
    { 0x2392F, "shú"},
    { 0x23930, "yuè"},
    { 0x23931, "chán"},
    { 0x23932, "è"},
    { 0x23933, "xī"},
    { 0x23934, "xī"},
    { 0x23935, "yǐng"},
    { 0x23936, "zú,zā,zǎn"},
    { 0x23937, "zā"},
    { 0x2393A, "zā"},
    { 0x23942, "tà"},
    { 0x23943, "wàn"},
    { 0x23947, "xìn"},
    { 0x2394A, "wàng"},
    { 0x2394B, "fǔ"},
    { 0x23950, "lǔ,lǚ"},
    { 0x2395E, "jiǎn"},
    { 0x23961, "yán"},
    { 0x23963, "bì"},
    { 0x23964, "kěn"},
    { 0x23965, "guàn"},
    { 0x23968, "zī"},
    { 0x2396E, "kuǐ"},
    { 0x2396F, "zhǒu"},
    { 0x23970, "zhì"},
    { 0x23973, "tú"},
    { 0x23977, "tà"},
    { 0x23979, "chù"},
    { 0x2397A, "chēng"},
    { 0x2397B, "chěng"},
    { 0x2397C, "zhù"},
    { 0x2397E, "dà"},
    { 0x23987, "bì"},
    { 0x23989, "jiǎ"},
    { 0x2398C, "yì"},
    { 0x2398F, "yuè"},
    { 0x23990, "gāng"},
    { 0x23996, "gān"},
    { 0x2399C, "qiāo"},
    { 0x239A0, "chú"},
    { 0x239A1, "chú"},
    { 0x239A2, "bì"},
    { 0x239A6, "guì"},
    { 0x239A9, "gǔ"},
    { 0x239AA, "bǐng"},
    { 0x239AB, "yìn"},
    { 0x239AC, "zhuì"},
    { 0x239AD, "gǔ"},
    { 0x239AF, "lì"},
    { 0x239B5, "è,zhēn"},
    { 0x239B6, "dǎi"},
    { 0x239BC, "cán"},
    { 0x239C2, "tì"},
    { 0x239C3, "dù"},
    { 0x239C4, "yì"},
    { 0x239C8, "dié"},
    { 0x239CA, "niǔ"},
    { 0x239CC, "xuè"},
    { 0x239CD, "nè"},
    { 0x239CE, "guì"},
    { 0x239CF, "kǎo"},
    { 0x239D2, "chuǎn,mò"},
    { 0x239D6, "zhá"},
    { 0x239D7, "yóu"},
    { 0x239D9, "bài"},
    { 0x239DA, "shí"},
    { 0x239DB, "diàn"},
    { 0x239DC, "pā"},
    { 0x239DD, "qiú"},
    { 0x239E1, "xuè"},
    { 0x239E3, "mò"},
    { 0x239E4, "kē"},
    { 0x239E5, "yǒu"},
    { 0x239E6, "jiǎo"},
    { 0x239E7, "bó"},
    { 0x239EC, "xiǔ"},
    { 0x239F2, "mǐ"},
    { 0x239F3, "luò"},
    { 0x239F5, "xuè,xù"},
    { 0x239F7, "duò"},
    { 0x239F9, "èr"},
    { 0x239FA, "shān"},
    { 0x239FC, "kuì"},
    { 0x239FD, "nào"},
    { 0x239FE, "miǎn"},
    { 0x239FF, "lì"},
    { 0x23A00, "luàn"},
    { 0x23A02, "dié"},
    { 0x23A04, "qià"},
    { 0x23A05, "lèi"},
    { 0x23A07, "mào"},
    { 0x23A09, "hēng"},
    { 0x23A0A, "chè"},
    { 0x23A0B, "zhì"},
    { 0x23A0D, "gǔ"},
    { 0x23A0E, "cuō"},
    { 0x23A13, "wù"},
    { 0x23A14, "tào"},
    { 0x23A17, "xī"},
    { 0x23A18, "yāo"},
    { 0x23A19, "wěi,wèi"},
    { 0x23A1B, "zú"},
    { 0x23A1C, "mà"},
    { 0x23A1D, "yǔ"},
    { 0x23A1E, "pěng"},
    { 0x23A1F, "yì"},
    { 0x23A20, "qìn,qīn"},
    { 0x23A21, "yuè"},
    { 0x23A22, "juè"},
    { 0x23A23, "jiàng"},
    { 0x23A24, "xù"},
    { 0x23A25, "bēng"},
    { 0x23A2A, "luǒ"},
    { 0x23A2B, "zhuī"},
    { 0x23A32, "dù"},
    { 0x23A33, "xiàng"},
    { 0x23A36, "huì"},
    { 0x23A3A, "gǔ"},
    { 0x23A3B, "kǎo"},
    { 0x23A3E, "xīng"},
    { 0x23A3F, "hún"},
    { 0x23A40, "biān"},
    { 0x23A44, "kè,ài"},
    { 0x23A45, "kǎo"},
    { 0x23A48, "cuó,zuō"},
    { 0x23A4F, "lù"},
    { 0x23A51, "zuì"},
    { 0x23A52, "zāo"},
    { 0x23A53, "jiǎo"},
    { 0x23A54, "guàn"},
    { 0x23A59, "yān"},
    { 0x23A5A, "ér"},
    { 0x23A5C, "qíng"},
    { 0x23A5F, "dèng"},
    { 0x23A60, "sì"},
    { 0x23A61, "suì"},
    { 0x23A62, "liào"},
    { 0x23A67, "shàn"},
    { 0x23A69, "bì"},
    { 0x23A6A, "wèi"},
    { 0x23A6B, "yè"},
    { 0x23A6D, "zhài"},
    { 0x23A6F, "yé"},
    { 0x23A70, "diào"},
    { 0x23A71, "ài,kē"},
    { 0x23A74, "jiàng"},
    { 0x23A77, "sū"},
    { 0x23A79, "huài"},
    { 0x23A7A, "yù"},
    { 0x23A7D, "rǎng"},
    { 0x23A80, "diān"},
    { 0x23A81, "zuān"},
    { 0x23A82, "bān"},
    { 0x23A84, "qín"},
    { 0x23A87, "jiā"},
    { 0x23A89, "pí"},
    { 0x23A8C, "tóu,duì"},
    { 0x23A90, "chóu"},
    { 0x23A95, "guǐ"},
    { 0x23AA0, "jī,jì,qì"},
    { 0x23AA8, "xuè"},
    { 0x23AAA, "diàn"},
    { 0x23AAD, "biàn"},
    { 0x23AAE, "zǎi"},
    { 0x23AAF, "tóng"},
    { 0x23AB6, "shǎn"},
    { 0x23AB8, "gù"},
    { 0x23AB9, "què"},
    { 0x23AC0, "gǔ"},
    { 0x23AC8, "hú"},
    { 0x23AC9, "kuǎi"},
    { 0x23ACC, "gòu"},
    { 0x23ACE, "sù"},
    { 0x23AD0, "chóu"},
    { 0x23AD2, "kēng"},
    { 0x23AD4, "dū"},
    { 0x23AD9, "yì"},
    { 0x23ADC, "dào"},
    { 0x23ADD, "qiāng"},
    { 0x23AE3, "lóng"},
    { 0x23AE5, "lí"},
    { 0x23AE7, "lì"},
    { 0x23AE8, "qīng"},
    { 0x23AEA, "wēi"},
    { 0x23AEC, "móu"},
    { 0x23AF1, "qì"},
    { 0x23AF3, "jiǎng"},
    { 0x23AF4, "xié"},
    { 0x23AF9, "dài"},
    { 0x23AFB, "lóu"},
    { 0x23B02, "guàn"},
    { 0x23B06, "péi"},
    { 0x23B09, "pí"},
    { 0x23B0B, "juàn,chuò"},
    { 0x23B0D, "bēi"},
    { 0x23B0E, "jué"},
    { 0x23B0F, "juàn"},
    { 0x23B10, "shì"},
    { 0x23B15, "xiě"},
    { 0x23B18, "ruí"},
    { 0x23B19, "jìng"},
    { 0x23B1A, "pò"},
    { 0x23B1B, "sān,shān"},
    { 0x23B20, "jī"},
    { 0x23B29, "fēn"},
    { 0x23B2A, "bèi"},
    { 0x23B2B, "jiè,gà"},
    { 0x23B2C, "sā"},
    { 0x23B2E, "pī"},
    { 0x23B34, "dì"},
    { 0x23B35, "máo,mào"},
    { 0x23B36, "ba"},
    { 0x23B37, "ba"},
    { 0x23B38, "tiáo"},
    { 0x23B39, "líng"},
    { 0x23B3A, "shēng"},
    { 0x23B3B, "zhěn"},
    { 0x23B3C, "pī"},
    { 0x23B3D, "wù"},
    { 0x23B3F, "zè"},
    { 0x23B40, "bào"},
    { 0x23B47, "lǚ"},
    { 0x23B56, "hāo"},
    { 0x23B57, "dǒu"},
    { 0x23B58, "fú"},
    { 0x23B59, "ní"},
    { 0x23B5D, "gé"},
    { 0x23B60, "rú"},
    { 0x23B61, "xiǎn"},
    { 0x23B64, "bì"},
    { 0x23B6E, "máo"},
    { 0x23B72, "rǒng"},
    { 0x23B73, "qiú,qú"},
    { 0x23B77, "bó"},
    { 0x23B79, "hāo"},
    { 0x23B7A, "nǎo"},
    { 0x23B7B, "yán"},
    { 0x23B83, "páo"},
    { 0x23B84, "suī"},
    { 0x23B86, "tuò"},
    { 0x23B88, "qū"},
    { 0x23B89, "lí"},
    { 0x23B8A, "dé"},
    { 0x23B8C, "jié"},
    { 0x23B8D, "jié"},
    { 0x23B8E, "gǔn"},
    { 0x23B8F, "jiān"},
    { 0x23B90, "bì"},
    { 0x23BA0, "sàn"},
    { 0x23BA1, "bāng"},
    { 0x23BA2, "chún"},
    { 0x23BA6, "nài"},
    { 0x23BA7, "bǎng"},
    { 0x23BAA, "róng"},
    { 0x23BAB, "jiā"},
    { 0x23BAC, "sōu"},
    { 0x23BB0, "dé"},
    { 0x23BBE, "xiān"},
    { 0x23BBF, "zhān"},
    { 0x23BC0, "mào"},
    { 0x23BC3, "zī"},
    { 0x23BC5, "jì"},
    { 0x23BC6, "qí"},
    { 0x23BCB, "rù"},
    { 0x23BCC, "suō"},
    { 0x23BCD, "rǒng"},
    { 0x23BCE, "wù"},
    { 0x23BCF, "róng,rǒng"},
    { 0x23BD0, "róng"},
    { 0x23BDA, "tà"},
    { 0x23BDC, "sōu"},
    { 0x23BE4, "lí"},
    { 0x23BE7, "cuǐ,suī"},
    { 0x23BE8, "zōng"},
    { 0x23BE9, "mén"},
    { 0x23BEA, "xǐ"},
    { 0x23BEC, "mǎng"},
    { 0x23BED, "niè"},
    { 0x23BEF, "suī"},
    { 0x23BF1, "péi"},
    { 0x23BF4, "bì"},
    { 0x23BF5, "dì"},
    { 0x23BF8, "qú"},
    { 0x23BF9, "qiáo"},
    { 0x23BFB, "fēn"},
    { 0x23BFC, "sù"},
    { 0x23C03, "xū"},
    { 0x23C07, "rǒng"},
    { 0x23C08, "jī"},
    { 0x23C0B, "qú"},
    { 0x23C0C, "liè,hé"},
    { 0x23C15, "sào"},
    { 0x23C18, "kùn"},
    { 0x23C1A, "cuì"},
    { 0x23C1B, "yè"},
    { 0x23C1C, "bìng"},
    { 0x23C1E, "jié"},
    { 0x23C20, "qú"},
    { 0x23C21, "qú"},
    { 0x23C25, "méng"},
    { 0x23C26, "rán,gān"},
    { 0x23C28, "bīn"},
    { 0x23C29, "cháo"},
    { 0x23C2C, "dú"},
    { 0x23C36, "ráng,nǎng"},
    { 0x23C37, "xiān"},
    { 0x23C3A, "táo"},
    { 0x23C3B, "qú"},
    { 0x23C3C, "niè"},
    { 0x23C3F, "shū"},
    { 0x23C40, "lǔ"},
    { 0x23C42, "kùn"},
    { 0x23C48, "mín"},
    { 0x23C49, "mǐn"},
    { 0x23C4D, "dàn"},
    { 0x23C50, "yìn,zhì"},
    { 0x23C53, "xiào,hào"},
    { 0x23C57, "jì"},
    { 0x23C5C, "yīn"},
    { 0x23C66, "fēn"},
    { 0x23C67, "zhòng"},
    { 0x23C6B, "gǔ"},
    { 0x23C71, "chá"},
    { 0x23C73, "liú"},
    { 0x23C76, "bǔ"},
    { 0x23C7A, "pā"},
    { 0x23C7B, "sì"},
    { 0x23C7C, "dāo"},
    { 0x23C7D, "zhěn"},
    { 0x23C80, "shān"},
    { 0x23C82, "chuǎi"},
    { 0x23C84, "jiǔ"},
    { 0x23C8A, "kè"},
    { 0x23C8B, "chí"},
    { 0x23C91, "hù,chí,hé,hú"},
    { 0x23C92, "lì,lè"},
    { 0x23C93, "shā"},
    { 0x23C96, "pài,liú,gū"},
    { 0x23C97, "wéi"},
    { 0x23C98, "wǔ"},
    { 0x23C9C, "yíng"},
    { 0x23CA1, "shā,jí,jié"},
    { 0x23CA2, "dī"},
    { 0x23CA5, "dān"},
    { 0x23CB1, "tū"},
    { 0x23CB2, "hé"},
    { 0x23CB3, "pǒ"},
    { 0x23CB5, "zhǐ"},
    { 0x23CB6, "niǔ"},
    { 0x23CB7, "nì"},
    { 0x23CBD, "rǒng"},
    { 0x23CBE, "guài"},
    { 0x23CC0, "zhí"},
    { 0x23CC3, "jí"},
    { 0x23CDC, "fàn"},
    { 0x23CDF, "jié"},
    { 0x23CE0, "hǎi,mǔ"},
    { 0x23CE4, "zhàn"},
    { 0x23CE6, "xì,náo"},
    { 0x23CE9, "zī"},
    { 0x23CEC, "xí"},
    { 0x23CED, "piào"},
    { 0x23CF0, "bēn"},
    { 0x23CF2, "jiǎn"},
    { 0x23D13, "jiàn"},
    { 0x23D16, "zá"},
    { 0x23D1E, "bèn"},
    { 0x23D1F, "mào,huǎn"},
    { 0x23D22, "zào"},
    { 0x23D23, "zhuàng"},
    { 0x23D25, "kuáng"},
    { 0x23D28, "bí"},
    { 0x23D2A, "pài,pì"},
    { 0x23D3C, "mào"},
    { 0x23D3D, "tàn"},
    { 0x23D5E, "tǔn"},
    { 0x23D5F, "luǒ"},
    { 0x23D62, "tān"},
    { 0x23D71, "án"},
    { 0x23D77, "hán,gàn"},
    { 0x23D78, "zhú"},
    { 0x23D7A, "duò,tuó"},
    { 0x23D7B, "duò,tuó"},
    { 0x23D7C, "gàn"},
    { 0x23D86, "qiòng"},
    { 0x23D88, "wǎng,mǎng"},
    { 0x23D8A, "mò"},
    { 0x23D8B, "zhè"},
    { 0x23D8C, "wěn"},
    { 0x23D8D, "zhuàng"},
    { 0x23D8F, "jiē,diē"},
    { 0x23D90, "pào"},
    { 0x23D98, "sù"},
    { 0x23D9D, "jù"},
    { 0x23DA0, "qī"},
    { 0x23DA1, "càn"},
    { 0x23DA3, "tuán"},
    { 0x23DA4, "shā"},
    { 0x23DA6, "tuó"},
    { 0x23DA9, "huà"},
    { 0x23DAB, "yì"},
    { 0x23DE0, "mín"},
    { 0x23DE1, "zhōng"},
    { 0x23DE5, "shuò"},
    { 0x23DE9, "yì"},
    { 0x23DEA, "wǎng"},
    { 0x23DEB, "áo"},
    { 0x23DF6, "sǔ"},
    { 0x23DFE, "guǐ"},
    { 0x23DFF, "tuǒ"},
    { 0x23E00, "huǐ"},
    { 0x23E03, "xù"},
    { 0x23E04, "zǎn"},
    { 0x23E06, "zǐ"},
    { 0x23E07, "biàn"},
    { 0x23E09, "dá"},
    { 0x23E0A, "yīn"},
    { 0x23E0B, "quǎn"},
    { 0x23E0E, "huài"},
    { 0x23E0F, "ná"},
    { 0x23E10, "zá"},
    { 0x23E12, "tí"},
    { 0x23E18, "yí"},
    { 0x23E19, "tān"},
    { 0x23E1A, "shé"},
    { 0x23E1B, "shuò"},
    { 0x23E1D, "xíng"},
    { 0x23E20, "yǒu"},
    { 0x23E23, "fén"},
    { 0x23E47, "kè"},
    { 0x23E4B, "fú"},
    { 0x23E52, "mǐn"},
    { 0x23E5A, "pì"},
    { 0x23E5C, "jí"},
    { 0x23E5D, "qiào,xiào"},
    { 0x23E5E, "zhǒng"},
    { 0x23E5F, "gàn"},
    { 0x23E60, "yuān"},
    { 0x23E61, "chí"},
    { 0x23E65, "qiàn"},
    { 0x23E67, "zuó,zhà"},
    { 0x23E69, "xié"},
    { 0x23E6A, "máo"},
    { 0x23E6C, "hú"},
    { 0x23E6E, "pì"},
    { 0x23E6F, "xùn"},
    { 0x23E71, "xiá"},
    { 0x23E72, "tí"},
    { 0x23E75, "nà"},
    { 0x23E76, "chuǎ"},
    { 0x23E80, "wǔ"},
    { 0x23EAC, "huāng"},
    { 0x23EAD, "xuè"},
    { 0x23EAE, "tào"},
    { 0x23EB0, "qiào"},
    { 0x23EB3, "jiāo"},
    { 0x23EBC, "dǎng"},
    { 0x23EBD, "bài"},
    { 0x23ECD, "dàng,xiàng"},
    { 0x23ECE, "kòu"},
    { 0x23ED0, "jū"},
    { 0x23ED1, "shā,shài"},
    { 0x23ED2, "jīng"},
    { 0x23ED5, "mó"},
    { 0x23ED6, "nóu"},
    { 0x23ED8, "shuò"},
    { 0x23EDA, "shù"},
    { 0x23EDB, "zhuāng"},
    { 0x23EDC, "fú"},
    { 0x23EDF, "zāng"},
    { 0x23EE0, "xié"},
    { 0x23EE1, "làng"},
    { 0x23EE2, "tōng"},
    { 0x23EE9, "zhé"},
    { 0x23EEC, "càn"},
    { 0x23EEE, "yuè"},
    { 0x23EF1, "zhòu"},
    { 0x23F1A, "tān"},
    { 0x23F1E, "yán"},
    { 0x23F1F, "lù"},
    { 0x23F20, "yǎn"},
    { 0x23F26, "zé"},
    { 0x23F27, "shuài"},
    { 0x23F45, "guō"},
    { 0x23F46, "zhú"},
    { 0x23F48, "rú,ruán"},
    { 0x23F49, "rú"},
    { 0x23F4C, "kǎn"},
    { 0x23F4D, "jì"},
    { 0x23F4E, "gāo,zé,háo"},
    { 0x23F52, "xiè"},
    { 0x23F55, "òu"},
    { 0x23F56, "jiān"},
    { 0x23F5A, "zhí"},
    { 0x23F5B, "zhá"},
    { 0x23F5D, "hǒng"},
    { 0x23F5F, "kuǎn"},
    { 0x23F61, "bó"},
    { 0x23F64, "sè"},
    { 0x23F65, "àn"},
    { 0x23F66, "jiàn"},
    { 0x23F68, "téng"},
    { 0x23F6B, "sōng"},
    { 0x23F6D, "mèng"},
    { 0x23F6E, "yín"},
    { 0x23F6F, "tān"},
    { 0x23F70, "guō"},
    { 0x23F73, "ruán"},
    { 0x23F74, "wèi"},
    { 0x23F77, "sì"},
    { 0x23FA4, "qì"},
    { 0x23FA6, "zhǎng"},
    { 0x23FC5, "dǒng"},
    { 0x23FC6, "fú"},
    { 0x23FC7, "shěn"},
    { 0x23FC8, "sù"},
    { 0x23FC9, "yì"},
    { 0x23FCA, "liàn"},
    { 0x23FCC, "hé"},
    { 0x23FCE, "zhēn"},
    { 0x23FD0, "zé"},
    { 0x23FD2, "cuǐ"},
    { 0x23FD3, "cuǐ"},
    { 0x23FDD, "fèng"},
    { 0x23FDE, "lǐ"},
    { 0x23FDF, "kòu"},
    { 0x23FE3, "xiào"},
    { 0x23FE4, "yǒu"},
    { 0x24003, "háo"},
    { 0x24009, "hàn"},
    { 0x2400A, "kěn"},
    { 0x2401D, "yù"},
    { 0x24023, "huǎn"},
    { 0x24024, "suō,shàn,shuài"},
    { 0x24026, "là"},
    { 0x24028, "dòu"},
    { 0x24029, "jiàn"},
    { 0x2402A, "pō"},
    { 0x2402B, "biǎn"},
    { 0x24030, "xuè"},
    { 0x24032, "biàn"},
    { 0x24037, "wèi"},
    { 0x24061, "dàn"},
    { 0x24062, "jié"},
    { 0x24063, "bài"},
    { 0x24065, "niǎn"},
    { 0x24066, "xiàn"},
    { 0x24067, "sè"},
    { 0x2406A, "huá"},
    { 0x2406B, "chuā"},
    { 0x2406E, "òu"},
    { 0x2406F, "liè"},
    { 0x24070, "dí"},
    { 0x24071, "cài"},
    { 0x24073, "zhá"},
    { 0x24075, "lǘ"},
    { 0x24079, "huò"},
    { 0x2407C, "lì"},
    { 0x2407D, "yǐng"},
    { 0x2407F, "wěi"},
    { 0x24080, "bì"},
    { 0x24081, "guó"},
    { 0x24083, "pì"},
    { 0x24086, "biāo"},
    { 0x240A0, "yǎn"},
    { 0x240A4, "zhuàn"},
    { 0x240B2, "hóng"},
    { 0x240B6, "lìn"},
    { 0x240B7, "è"},
    { 0x240B9, "yǐn"},
    { 0x240BA, "làn"},
    { 0x240BC, "yào"},
    { 0x240BF, "xuàn"},
    { 0x240C0, "lì"},
    { 0x240E8, "làn"},
    { 0x240E9, "líng"},
    { 0x240EA, "xī"},
    { 0x240EB, "hōng"},
    { 0x240ED, "jiǎo"},
    { 0x240EE, "zhuó"},
    { 0x240F2, "zhí"},
    { 0x240F5, "bó"},
    { 0x240F6, "tēng"},
    { 0x240F7, "ǎn"},
    { 0x240FA, "xún"},
    { 0x240FB, "lěi"},
    { 0x240FC, "zāng"},
    { 0x240FD, "huǐ"},
    { 0x2410E, "xì"},
    { 0x2410F, "hóng"},
    { 0x24111, "fàn"},
    { 0x24112, "jiǎn"},
    { 0x24113, "cóng"},
    { 0x24114, "zá"},
    { 0x24116, "cā,zá"},
    { 0x24118, "yōu"},
    { 0x2411B, "duì"},
    { 0x2411C, "pān"},
    { 0x24125, "tà"},
    { 0x24127, "pàn"},
    { 0x2412B, "fān"},
    { 0x2412C, "xī"},
    { 0x24136, "yào,shuò"},
    { 0x24137, "luó"},
    { 0x2413A, "biān"},
    { 0x2413C, "jìn"},
    { 0x2413D, "lì"},
    { 0x2414A, "yàn"},
    { 0x2414B, "dòu"},
    { 0x2414E, "màn"},
    { 0x24150, "gōng"},
    { 0x24151, "rǎng"},
    { 0x24152, "càn"},
    { 0x24163, "mén"},
    { 0x24171, "gǔ"},
    { 0x24172, "shuàn"},
    { 0x24178, "yán,yàn"},
    { 0x24179, "bì"},
    { 0x24180, "biāo"},
    { 0x24181, "chéng"},
    { 0x24182, "kuì"},
    { 0x24184, "huǒ,zāi"},
    { 0x2418D, "chì"},
    { 0x2418F, "wò"},
    { 0x24191, "còu"},
    { 0x24192, "zhì"},
    { 0x24199, "shuǐ"},
    { 0x2419C, "guà"},
    { 0x2419D, "pū"},
    { 0x2419E, "xù"},
    { 0x2419F, "sī"},
    { 0x241A1, "wǔ"},
    { 0x241AE, "fū"},
    { 0x241B0, "shì"},
    { 0x241B3, "huì"},
    { 0x241B4, "huāng"},
    { 0x241B5, "pā"},
    { 0x241BC, "zhǔ"},
    { 0x241BE, "yí"},
    { 0x241C3, "lì"},
    { 0x241C4, "shǎn"},
    { 0x241DC, "mín"},
    { 0x241DE, "gē"},
    { 0x241E0, "hū"},
    { 0x241EF, "ēn,āo"},
    { 0x241F0, "fá"},
    { 0x241F3, "xù,xuè"},
    { 0x241F4, "yí,xī"},
    { 0x241FE, "yíng"},
    { 0x24214, "chí"},
    { 0x24219, "yí"},
    { 0x24225, "dí"},
    { 0x24226, "huǐ,méi"},
    { 0x24227, "hé"},
    { 0x24229, "zhǎ"},
    { 0x24236, "yún"},
    { 0x24237, "xiān"},
    { 0x2424C, "xián"},
    { 0x2424D, "lào"},
    { 0x2424E, "shào"},
    { 0x2424F, "shì"},
    { 0x24250, "zhuó"},
    { 0x24264, "biē"},
    { 0x24265, "jiǔ"},
    { 0x24266, "wō"},
    { 0x24267, "jiǎo"},
    { 0x24268, "fú"},
    { 0x2426A, "xiāng"},
    { 0x2426B, "kài"},
    { 0x242B2, "nǎo"},
    { 0x242B4, "huò"},
    { 0x242B5, "jí"},
    { 0x242B6, "là"},
    { 0x242BB, "fōu"},
    { 0x242BC, "shǎn"},
    { 0x242BD, "liào,liǎo"},
    { 0x242BE, "miè"},
    { 0x242BF, "chè"},
    { 0x242C2, "mó"},
    { 0x242CF, "lóu"},
    { 0x242E8, "duò"},
    { 0x242EB, "nǎo"},
    { 0x242ED, "jī"},
    { 0x242F0, "zhù"},
    { 0x24302, "sù"},
    { 0x24303, "duò"},
    { 0x24307, "jiǒng"},
    { 0x2430A, "zǎi"},
    { 0x2430B, "huǐ"},
    { 0x2430C, "yǐng"},
    { 0x2430D, "hú"},
    { 0x2430E, "lìn,lǐn"},
    { 0x2430F, "wěng"},
    { 0x24310, "hàn"},
    { 0x24314, "nán"},
    { 0x24337, "xì"},
    { 0x24339, "gàn"},
    { 0x2433E, "hè"},
    { 0x2433F, "jī"},
    { 0x24340, "xiǎng"},
    { 0x24341, "shā"},
    { 0x24350, "tuì"},
    { 0x24352, "zhāo"},
    { 0x24353, "shù"},
    { 0x24355, "yǒu"},
    { 0x24356, "jiān"},
    { 0x2435C, "zào"},
    { 0x24364, "zhāng"},
    { 0x2437D, "ruò"},
    { 0x24384, "yān"},
    { 0x2438B, "cuì"},
    { 0x24397, "jí"},
    { 0x24398, "shāng"},
    { 0x243A3, "è"},
    { 0x243A4, "láo"},
    { 0x243A5, "tǎn,chān"},
    { 0x243A7, "zhù"},
    { 0x243AD, "lǐn,yǐn"},
    { 0x243AF, "zēng"},
    { 0x243B1, "juǎn"},
    { 0x243B2, "hū"},
    { 0x243D7, "shěn"},
    { 0x243D8, "huò"},
    { 0x243DC, "kuì"},
    { 0x243F1, "chù"},
    { 0x243F2, "zhòu"},
    { 0x243F6, "āo"},
    { 0x243F8, "zhuó"},
    { 0x243FD, "xīng"},
    { 0x243FF, "miè"},
    { 0x24400, "hū"},
    { 0x24414, "tán"},
    { 0x24419, "bì"},
    { 0x24423, "dǐng"},
    { 0x24429, "kài"},
    { 0x2442B, "biāo"},
    { 0x24430, "huò"},
    { 0x24431, "liè"},
    { 0x24432, "cuàn"},
    { 0x24443, "xiàn"},
    { 0x24444, "rè"},
    { 0x24453, "yuè"},
    { 0x24455, "xūn"},
    { 0x24457, "liǎo,zhāo"},
    { 0x24463, "shā"},
    { 0x24466, "shì"},
    { 0x2446A, "xiè"},
    { 0x24473, "xiāo"},
    { 0x24477, "yé"},
    { 0x24478, "lǎn"},
    { 0x24479, "yì"},
    { 0x2447F, "liǎn"},
    { 0x24494, "bó"},
    { 0x24495, "cāo"},
    { 0x2449D, "yào"},
    { 0x244A6, "liàn,yàn"},
    { 0x244BB, "tà"},
    { 0x244D1, "jì"},
    { 0x244D4, "xī"},
    { 0x244D5, "zhì"},
    { 0x244DA, "xī"},
    { 0x244DD, "yuè"},
    { 0x244E4, "xiǎn"},
    { 0x244E6, "zhuò"},
    { 0x244EF, "zhǎng,jú"},
    { 0x244F5, "zǔ"},
    { 0x244F7, "ná"},
    { 0x244FE, "dào"},
    { 0x244FF, "liè"},
    { 0x24500, "ná"},
    { 0x24509, "páo"},
    { 0x2450B, "jù"},
    { 0x24516, "luǒ"},
    { 0x24519, "shuǎ"},
    { 0x2451A, "shàng"},
    { 0x2451D, "luǒ"},
    { 0x2451F, "fēn"},
    { 0x24523, "bào"},
    { 0x24528, "lì"},
    { 0x2452B, "xiòng"},
    { 0x24536, "dāng"},
    { 0x24540, "chèng"},
    { 0x24544, "zhǎng"},
    { 0x24547, "sǒu"},
    { 0x2454A, "shén"},
    { 0x24552, "gě"},
    { 0x24558, "yū,wù"},
    { 0x2455A, "huī"},
    { 0x2455B, "chè"},
    { 0x2455D, "jiào,bó"},
    { 0x2455E, "zhù"},
    { 0x2455F, "shū"},
    { 0x24562, "xiáo"},
    { 0x24566, "níng"},
    { 0x2456D, "jiāng"},
    { 0x2456F, "jiāng,zhuàng"},
    { 0x24577, "diào"},
    { 0x2457D, "qiáng"},
    { 0x2457E, "qiú,fǔ"},
    { 0x24580, "fēng"},
    { 0x24586, "zhàn"},
    { 0x24587, "kē"},
    { 0x24592, "dié"},
    { 0x24593, "zé"},
    { 0x24596, "guāng"},
    { 0x24597, "sè"},
    { 0x24598, "fèn,fén"},
    { 0x2459B, "jiǎng"},
    { 0x2459D, "yán"},
    { 0x2459E, "zhì"},
    { 0x245A2, "lì"},
    { 0x245A6, "líng"},
    { 0x245AA, "yí"},
    { 0x245AC, "qǔ"},
    { 0x245AD, "pán"},
    { 0x245AE, "gōu"},
    { 0x245B0, "jiǎ"},
    { 0x245B1, "hé"},
    { 0x245B3, "pèng"},
    { 0x245B5, "jù"},
    { 0x245B7, "chè"},
    { 0x245BA, "liè"},
    { 0x245BB, "shì"},
    { 0x245BC, "pò"},
    { 0x245BD, "xiàng"},
    { 0x245BF, "pì"},
    { 0x245C0, "luǒ"},
    { 0x245C1, "cù"},
    { 0x245C3, "yǔ"},
    { 0x245C7, "kòng"},
    { 0x245C8, "xiè"},
    { 0x245CD, "wǎn"},
    { 0x245CE, "yǎn"},
    { 0x245CF, "péi"},
    { 0x245D3, "chéng"},
    { 0x245D8, "tí"},
    { 0x245D9, "chè,tuò"},
    { 0x245DA, "bì"},
    { 0x245DB, "liàn"},
    { 0x245DC, "jiǎ"},
    { 0x245DE, "tíng"},
    { 0x245E2, "tī"},
    { 0x245E8, "dié"},
    { 0x245EA, "shù"},
    { 0x245EB, "lí"},
    { 0x245EC, "lǘ"},
    { 0x245ED, "xià,xiā"},
    { 0x245EF, "cuī"},
    { 0x245F3, "bō"},
    { 0x245F4, "tuí"},
    { 0x245F5, "pú"},
    { 0x245F7, "lìn"},
    { 0x245F8, "fèn,fén"},
    { 0x245FA, "bó"},
    { 0x245FB, "chàn"},
    { 0x245FE, "dāng"},
    { 0x245FF, "tǎi"},
    { 0x24600, "dào"},
    { 0x24603, "lì"},
    { 0x24605, "yá"},
    { 0x24606, "yá"},
    { 0x24607, "zhān"},
    { 0x2460A, "yí"},
    { 0x2460C, "qī"},
    { 0x24614, "hù"},
    { 0x24616, "tīng"},
    { 0x24618, "kǒu"},
    { 0x2461B, "chún"},
    { 0x2461C, "yóu"},
    { 0x2461D, "fèn"},
    { 0x2461F, "nuó"},
    { 0x24620, "tiàn"},
    { 0x24621, "jìn"},
    { 0x24622, "pí"},
    { 0x24623, "chén"},
    { 0x24624, "pì"},
    { 0x24626, "jiè"},
    { 0x24627, "guǐ"},
    { 0x24632, "zhuàng"},
    { 0x24635, "hú"},
    { 0x24636, "chǒu"},
    { 0x24637, "shù"},
    { 0x24638, "tāo"},
    { 0x24639, "pí"},
    { 0x2463A, "rǒng"},
    { 0x2463B, "rǒng"},
    { 0x2463D, "hǒu"},
    { 0x2463E, "pēng"},
    { 0x24645, "bài"},
    { 0x24647, "xiá"},
    { 0x2464B, "qǐn"},
    { 0x2464C, "nǐ"},
    { 0x2464E, "tāo"},
    { 0x2464F, "qù"},
    { 0x24652, "xié"},
    { 0x24654, "zhào"},
    { 0x24655, "huā"},
    { 0x24656, "xīn"},
    { 0x24658, "shōu"},
    { 0x2465B, "tú"},
    { 0x2465D, "liáng"},
    { 0x2465E, "bì"},
    { 0x2465F, "chū"},
    { 0x24661, "xīng"},
    { 0x24663, "xīn"},
    { 0x24664, "fū"},
    { 0x24669, "jiè"},
    { 0x2466D, "fǔ"},
    { 0x24670, "tè"},
    { 0x24671, "shè"},
    { 0x24674, "chāo"},
    { 0x24675, "chuī"},
    { 0x2467C, "rán"},
    { 0x2467D, "hǒu"},
    { 0x2467E, "bēng"},
    { 0x24680, "cǎi"},
    { 0x24685, "mú"},
    { 0x24689, "xū"},
    { 0x2468A, "dié"},
    { 0x2468D, "chǎn"},
    { 0x2468E, "yú"},
    { 0x2468F, "zhòng"},
    { 0x24693, "lí"},
    { 0x24694, "shōu"},
    { 0x2469A, "dú"},
    { 0x2469C, "māo"},
    { 0x2469D, "huáng"},
    { 0x2469F, "táo"},
    { 0x246A1, "dù"},
    { 0x246A2, "tí"},
    { 0x246A3, "shēng"},
    { 0x246A4, "méi"},
    { 0x246A8, "zhēn"},
    { 0x246A9, "qín"},
    { 0x246AA, "pì"},
    { 0x246AB, "táng"},
    { 0x246AC, "cāng"},
    { 0x246AD, "yáo"},
    { 0x246AF, "xiù"},
    { 0x246B0, "bāng"},
    { 0x246B1, "gǔ"},
    { 0x246B5, "bù"},
    { 0x246BC, "gòu"},
    { 0x246BD, "bó"},
    { 0x246C1, "wèn"},
    { 0x246C4, "jì"},
    { 0x246CA, "lā"},
    { 0x246CD, "cuī"},
    { 0x246CE, "mǐn"},
    { 0x246CF, "cǔ"},
    { 0x246D0, "ōu"},
    { 0x246D1, "yōng"},
    { 0x246D6, "máo"},
    { 0x246D7, "kè"},
    { 0x246D8, "māng"},
    { 0x246D9, "dǐng"},
    { 0x246DA, "huān"},
    { 0x246DB, "duǒ"},
    { 0x246DC, "jiāng"},
    { 0x246DD, "sù"},
    { 0x246E2, "céng"},
    { 0x246E3, "tà"},
    { 0x246E5, "huáng"},
    { 0x246E6, "jué"},
    { 0x246E7, "xún"},
    { 0x246EA, "xiòng"},
    { 0x246EC, "mì"},
    { 0x246ED, "qún"},
    { 0x246EE, "láo"},
    { 0x246F1, "zhì"},
    { 0x246F2, "wěi,wéi"},
    { 0x246F7, "sè"},
    { 0x246FB, "zāng"},
    { 0x24701, "ǎn"},
    { 0x24702, "wèi,guì"},
    { 0x24704, "huái,huài"},
    { 0x24707, "zhàn"},
    { 0x24709, "yīng"},
    { 0x2470A, "gē"},
    { 0x2470B, "huì"},
    { 0x2470D, "quán"},
    { 0x24713, "liè"},
    { 0x24714, "jú"},
    { 0x24715, "bà"},
    { 0x24716, "léi"},
    { 0x24718, "mán"},
    { 0x24719, "líng"},
    { 0x2471C, "lì"},
    { 0x2471D, "jǐ"},
    { 0x24721, "huí"},
    { 0x24722, "xìn"},
    { 0x24723, "shì,shé"},
    { 0x24724, "zhé"},
    { 0x24727, "bō"},
    { 0x2472B, "chā"},
    { 0x2472F, "chā"},
    { 0x24730, "jīng"},
    { 0x24731, "bā"},
    { 0x24732, "bèi,pèi"},
    { 0x24735, "yàn"},
    { 0x24737, "hù"},
    { 0x24739, "yú"},
    { 0x2473B, "bì,pí"},
    { 0x2473C, "chuán"},
    { 0x2473E, "jǐ"},
    { 0x24742, "mù"},
    { 0x24744, "máo"},
    { 0x24745, "zhōng"},
    { 0x24747, "yè"},
    { 0x24748, "dōu"},
    { 0x24749, "yě"},
    { 0x2474D, "rì"},
    { 0x2474E, "yīn"},
    { 0x24750, "hào"},
    { 0x24752, "nà"},
    { 0x24753, "tiè"},
    { 0x24754, "fù,chái"},
    { 0x24755, "mǔ"},
    { 0x24756, "zǎi"},
    { 0x24758, "hú"},
    { 0x2475A, "chēn"},
    { 0x2475B, "tuó"},
    { 0x2475E, "chù"},
    { 0x2475F, "fú,fèi"},
    { 0x24767, "bào"},
    { 0x2476C, "dǐ"},
    { 0x2476D, "cǎi"},
    { 0x2476E, "lù"},
    { 0x2476F, "pǒ"},
    { 0x24770, "dá"},
    { 0x24771, "yè"},
    { 0x24773, "yǐ"},
    { 0x24777, "xiáng"},
    { 0x24778, "bī"},
    { 0x24779, "zhū"},
    { 0x2477B, "yí"},
    { 0x2477D, "lǜ"},
    { 0x2477F, "kuāng"},
    { 0x24782, "zhì"},
    { 0x24787, "wá,kuáng"},
    { 0x24788, "dī"},
    { 0x24789, "shù"},
    { 0x2478A, "liè"},
    { 0x2478B, "zǎo"},
    { 0x2478C, "zhì"},
    { 0x2478D, "náo"},
    { 0x24797, "chái"},
    { 0x2479A, "xiāo"},
    { 0x2479B, "zàng"},
    { 0x2479E, "yù"},
    { 0x2479F, "dòu"},
    { 0x247A0, "chà"}
};
