/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     chenhaifeng  <chenhaifeng@uniontech.com>
*
* Maintainer: chenhaifeng  <chenhaifeng@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "pinyindict.h"

QMap<int, QString> PinyinDict_17{
    { 0x247A1, "xié"},
    { 0x247A2, "yáng"},
    { 0x247A4, "xiǎn"},
    { 0x247A5, "bǎo"},
    { 0x247AE, "zhài,zhāi"},
    { 0x247B0, "qiú"},
    { 0x247B2, "hú"},
    { 0x247B3, "zài"},
    { 0x247B4, "jué"},
    { 0x247B6, "hān,hàn"},
    { 0x247BF, "àn"},
    { 0x247C0, "zào"},
    { 0x247C3, "shà"},
    { 0x247C5, "xiàn"},
    { 0x247C6, "chǐ"},
    { 0x247C7, "yǎn"},
    { 0x247C9, "àn"},
    { 0x247CD, "zhé"},
    { 0x247CE, "jué"},
    { 0x247D1, "lì"},
    { 0x247D3, "lè"},
    { 0x247D6, "cǎi"},
    { 0x247D8, "lù"},
    { 0x247DA, "jiā"},
    { 0x247DD, "xià"},
    { 0x247DE, "xiào"},
    { 0x247DF, "yān"},
    { 0x247E0, "xū"},
    { 0x247E2, "dùn"},
    { 0x247E3, "yíng"},
    { 0x247E4, "huī,xūn"},
    { 0x247E5, "tí"},
    { 0x247E6, "nóu"},
    { 0x247E7, "xǐ"},
    { 0x247EA, "tú"},
    { 0x247F7, "wāi"},
    { 0x247F8, "chēn"},
    { 0x247FC, "hōng"},
    { 0x247FE, "tí"},
    { 0x247FF, "xuān"},
    { 0x24800, "zá"},
    { 0x24807, "gé"},
    { 0x2480B, "lóu"},
    { 0x2480C, "chái"},
    { 0x2480D, "pán"},
    { 0x2480E, "jí"},
    { 0x24810, "tà"},
    { 0x24813, "xī"},
    { 0x24816, "xiāo"},
    { 0x24818, "sāo"},
    { 0x24819, "jiā"},
    { 0x2481A, "sù"},
    { 0x2481B, "huāng"},
    { 0x2481D, "cuō"},
    { 0x2481F, "tà"},
    { 0x24820, "shuāi"},
    { 0x2482A, "fú"},
    { 0x2482B, "lì"},
    { 0x2482D, "shè"},
    { 0x2482F, "táng"},
    { 0x24836, "diān"},
    { 0x2483A, "bì"},
    { 0x2483C, "gòu"},
    { 0x2483D, "cù"},
    { 0x2483F, "qiān"},
    { 0x24842, "léi,lěi"},
    { 0x24843, "sù"},
    { 0x24846, "zòng,zōng"},
    { 0x24847, "hāo"},
    { 0x2484F, "chì"},
    { 0x24850, "cáo"},
    { 0x24853, "wò"},
    { 0x24854, "xiāo"},
    { 0x24855, "liè,wěn"},
    { 0x24856, "yán,yān"},
    { 0x2485D, "bì"},
    { 0x2485F, "huàn"},
    { 0x24861, "xī"},
    { 0x24862, "chī"},
    { 0x24863, "xū"},
    { 0x24864, "náo,nà,rú"},
    { 0x24865, "yán,xiàn"},
    { 0x24867, "xiè"},
    { 0x24868, "zhá"},
    { 0x2486A, "suì,wěi"},
    { 0x2486C, "xì"},
    { 0x2486D, "bēng,péng"},
    { 0x2486E, "rán"},
    { 0x2486F, "shuò,xī,què"},
    { 0x24870, "bān"},
    { 0x24871, "guì"},
    { 0x24872, "kāi"},
    { 0x24873, "chēn"},
    { 0x24876, "xù"},
    { 0x2487E, "è"},
    { 0x2487F, "lì"},
    { 0x24880, "xī"},
    { 0x24881, "huàn"},
    { 0x24882, "sù"},
    { 0x24884, "chǎng"},
    { 0x2488A, "lù"},
    { 0x2488B, "yán"},
    { 0x2488E, "dāng"},
    { 0x2488F, "dǎn"},
    { 0x24890, "yāng"},
    { 0x24892, "zhǎi"},
    { 0x24893, "jù,qú"},
    { 0x24895, "duó"},
    { 0x24896, "sāo,shān"},
    { 0x24897, "lái"},
    { 0x24898, "sù"},
    { 0x2489F, "zé"},
    { 0x248A3, "bì"},
    { 0x248A6, "yìn"},
    { 0x248A8, "hāo"},
    { 0x248AA, "liè"},
    { 0x248AD, "háo"},
    { 0x248AE, "yáng"},
    { 0x248B4, "shuò,lì"},
    { 0x248B5, "lài,ài"},
    { 0x248B6, "qióng"},
    { 0x248B9, "lěi"},
    { 0x248BA, "xié"},
    { 0x248BC, "shì"},
    { 0x248C3, "lǔ"},
    { 0x248C5, "què"},
    { 0x248C6, "lián"},
    { 0x248CC, "xiào"},
    { 0x248CE, "yīng"},
    { 0x248D1, "xié"},
    { 0x248D8, "líng"},
    { 0x248D9, "yōu"},
    { 0x248DE, "dǎng"},
    { 0x248DF, "lǎn"},
    { 0x248E0, "xiāo"},
    { 0x248E8, "yì"},
    { 0x248EC, "wū"},
    { 0x248EE, "yì"},
    { 0x248EF, "tuō"},
    { 0x248F0, "bǔ"},
    { 0x248F2, "xìn"},
    { 0x248F5, "sī"},
    { 0x248F6, "jīn"},
    { 0x248F8, "bā"},
    { 0x248F9, "fǎ"},
    { 0x248FB, "mò"},
    { 0x248FC, "ruò"},
    { 0x2490A, "dà"},
    { 0x2490B, "jì"},
    { 0x24910, "sù"},
    { 0x24911, "qióng"},
    { 0x24912, "bā"},
    { 0x24926, "tián"},
    { 0x24927, "yóu"},
    { 0x24929, "tuó"},
    { 0x2492B, "wài"},
    { 0x2492C, "yòu"},
    { 0x2492E, "dōng"},
    { 0x24931, "xǐ"},
    { 0x24932, "kǒng"},
    { 0x24936, "qióng"},
    { 0x24937, "duī"},
    { 0x24938, "duò"},
    { 0x2493A, "yì"},
    { 0x24952, "xī"},
    { 0x24953, "qīn"},
    { 0x24954, "sù"},
    { 0x24957, "liú"},
    { 0x24959, "wán"},
    { 0x2496D, "chē"},
    { 0x2496E, "zhū"},
    { 0x24970, "mào"},
    { 0x24977, "quán"},
    { 0x2497D, "yū"},
    { 0x2497F, "yì"},
    { 0x24980, "mí"},
    { 0x24983, "lái"},
    { 0x24984, "zhì"},
    { 0x249A4, "ní"},
    { 0x249A6, "bān"},
    { 0x249AA, "dōng"},
    { 0x249AE, "zhì"},
    { 0x249D5, "yì"},
    { 0x249D8, "líng"},
    { 0x249D9, "yú"},
    { 0x249DA, "cōng"},
    { 0x249DB, "dì"},
    { 0x249DC, "zhì"},
    { 0x249E0, "ruǎn"},
    { 0x249E3, "jiàn"},
    { 0x249E9, "wàn"},
    { 0x249EB, "jīn,jìn,duī"},
    { 0x249ED, "páng"},
    { 0x24A0D, "lù"},
    { 0x24A0E, "qú"},
    { 0x24A10, "xǐ,tāo"},
    { 0x24A11, "dá"},
    { 0x24A16, "hù"},
    { 0x24A17, "luǒ"},
    { 0x24A19, "lè"},
    { 0x24A36, "gǒng"},
    { 0x24A3B, "lìng"},
    { 0x24A42, "láo"},
    { 0x24A44, "zhuàn"},
    { 0x24A68, "zǎo"},
    { 0x24A69, "hào"},
    { 0x24A6A, "xiàng"},
    { 0x24A6D, "hào"},
    { 0x24A6E, "lì"},
    { 0x24A71, "diàn,tiàn"},
    { 0x24A72, "gé"},
    { 0x24A7D, "huán"},
    { 0x24A84, "è"},
    { 0x24A86, "xiá"},
    { 0x24A8B, "jiān"},
    { 0x24A8C, "qí"},
    { 0x24A8D, "xiá"},
    { 0x24A8E, "yǒu"},
    { 0x24AA1, "zhēng"},
    { 0x24AAA, "zhuàn,chūn"},
    { 0x24AAE, "chàn"},
    { 0x24AC9, "xiè"},
    { 0x24AD5, "náo"},
    { 0x24ADD, "jì"},
    { 0x24ADE, "tián"},
    { 0x24AE3, "yǎn"},
    { 0x24AE7, "hǎo"},
    { 0x24AE8, "xín"},
    { 0x24AE9, "líng"},
    { 0x24AEB, "bān"},
    { 0x24AEC, "běng"},
    { 0x24AF1, "gōu"},
    { 0x24AF2, "líng"},
    { 0x24AF5, "kuò,guó"},
    { 0x24AF6, "qià"},
    { 0x24AF7, "jiào"},
    { 0x24AF9, "ēn"},
    { 0x24AFA, "yáo"},
    { 0x24AFB, "dū"},
    { 0x24B01, "huǒ,guǒ,luǒ"},
    { 0x24B02, "dǔ"},
    { 0x24B03, "pēi"},
    { 0x24B0C, "yuán"},
    { 0x24B0F, "lóu"},
    { 0x24B10, "xíng"},
    { 0x24B13, "lián,liǎn"},
    { 0x24B14, "yáo"},
    { 0x24B15, "xī"},
    { 0x24B16, "yáo"},
    { 0x24B18, "xī"},
    { 0x24B1B, "lú"},
    { 0x24B1D, "yàn"},
    { 0x24B20, "quán"},
    { 0x24B25, "ráng"},
    { 0x24B26, "wà"},
    { 0x24B27, "zú"},
    { 0x24B28, "fàn"},
    { 0x24B29, "yì"},
    { 0x24B2A, "dù,kān"},
    { 0x24B2B, "suì"},
    { 0x24B2D, "pī"},
    { 0x24B2F, "hán,qiàn"},
    { 0x24B31, "xù"},
    { 0x24B33, "gǒng"},
    { 0x24B35, "dì"},
    { 0x24B37, "nà"},
    { 0x24B3E, "duò,tuó"},
    { 0x24B3F, "wā"},
    { 0x24B42, "niè"},
    { 0x24B48, "diào"},
    { 0x24B49, "huāng"},
    { 0x24B4C, "tí"},
    { 0x24B4D, "fàn"},
    { 0x24B51, "wú"},
    { 0x24B52, "áng"},
    { 0x24B54, "píng"},
    { 0x24B59, "hán,gān"},
    { 0x24B5B, "gāng"},
    { 0x24B5C, "lí"},
    { 0x24B5E, "dūn"},
    { 0x24B5F, "fù"},
    { 0x24B60, "nà"},
    { 0x24B62, "cèi,suì"},
    { 0x24B67, "jiē"},
    { 0x24B69, "qìng"},
    { 0x24B6B, "yīng"},
    { 0x24B6C, "xiáng"},
    { 0x24B71, "hú"},
    { 0x24B74, "sù"},
    { 0x24B7B, "gē"},
    { 0x24B7C, "è"},
    { 0x24B7D, "xù"},
    { 0x24B86, "xī"},
    { 0x24B8A, "kāng"},
    { 0x24B8B, "guó"},
    { 0x24B8C, "jiē"},
    { 0x24B8D, "chuán"},
    { 0x24B8E, "léi"},
    { 0x24B8F, "héng"},
    { 0x24B90, "zūn"},
    { 0x24B95, "piè"},
    { 0x24B98, "dēng"},
    { 0x24B99, "xī"},
    { 0x24B9A, "léi"},
    { 0x24B9C, "shàn"},
    { 0x24BA7, "lú"},
    { 0x24BA9, "duì"},
    { 0x24BAA, "jùn"},
    { 0x24BAD, "chàn"},
    { 0x24BAF, "xié"},
    { 0x24BB0, "wā"},
    { 0x24BB1, "zhé"},
    { 0x24BB3, "zhuān,guàn"},
    { 0x24BB7, "liù"},
    { 0x24BB8, "léi"},
    { 0x24BBC, "dài"},
    { 0x24BBD, "gān"},
    { 0x24BC4, "shì"},
    { 0x24BC7, "yǎn"},
    { 0x24BCC, "gān"},
    { 0x24BD0, "yán"},
    { 0x24BD6, "suī"},
    { 0x24BDA, "zhōng"},
    { 0x24BDC, "shì"},
    { 0x24BE1, "shèng"},
    { 0x24BE5, "chǎn"},
    { 0x24BF7, "huáng"},
    { 0x24BF8, "yìn"},
    { 0x24BFB, "měng"},
    { 0x24C02, "ráng"},
    { 0x24C05, "xiáng"},
    { 0x24C08, "bèi,fú"},
    { 0x24C0C, "chuán"},
    { 0x24C11, "pú"},
    { 0x24C19, "kē,gé"},
    { 0x24C1A, "lā,lá"},
    { 0x24C1D, "quǎn"},
    { 0x24C1F, "hàng"},
    { 0x24C20, "chì"},
    { 0x24C21, "máng"},
    { 0x24C26, "zhà"},
    { 0x24C2A, "fèn"},
    { 0x24C2C, "chào"},
    { 0x24C33, "jǐng"},
    { 0x24C43, "liè"},
    { 0x24C45, "nà"},
    { 0x24C46, "nà"},
    { 0x24C47, "tóng"},
    { 0x24C4B, "rán"},
    { 0x24C4C, "zǔ"},
    { 0x24C4D, "pī,pǒ"},
    { 0x24C4E, "yǒu"},
    { 0x24C50, "shū"},
    { 0x24C5B, "liè"},
    { 0x24C5C, "shōu"},
    { 0x24C5D, "tuǎn"},
    { 0x24C5F, "gǎo"},
    { 0x24C60, "sháo"},
    { 0x24C61, "tuó"},
    { 0x24C63, "nán"},
    { 0x24C67, "tuǒ"},
    { 0x24C68, "gōng"},
    { 0x24C69, "diào"},
    { 0x24C74, "měng"},
    { 0x24C75, "bāng"},
    { 0x24C77, "xié"},
    { 0x24C78, "sì"},
    { 0x24C79, "tǐng"},
    { 0x24C7A, "guì"},
    { 0x24C7D, "fú"},
    { 0x24C7E, "guì"},
    { 0x24C89, "guì"},
    { 0x24C91, "zhǔ"},
    { 0x24C93, "lái"},
    { 0x24C95, "lǔn"},
    { 0x24C96, "tiǎn"},
    { 0x24C97, "rǎn"},
    { 0x24C9A, "dōng"},
    { 0x24CA8, "juàn"},
    { 0x24CA9, "yán"},
    { 0x24CAC, "ruán"},
    { 0x24CAD, "dǎn"},
    { 0x24CB0, "mào"},
    { 0x24CB6, "luán,niǎo"},
    { 0x24CB8, "xù,zī"},
    { 0x24CBA, "xī"},
    { 0x24CC2, "má"},
    { 0x24CC3, "qī"},
    { 0x24CC5, "chà"},
    { 0x24CC8, "shāng"},
    { 0x24CC9, "hàn"},
    { 0x24CCA, "píng"},
    { 0x24CCE, "jī"},
    { 0x24CD3, "lì"},
    { 0x24CD5, "yù"},
    { 0x24CD6, "bān,fān"},
    { 0x24CD8, "tēng"},
    { 0x24CDD, "chóu"},
    { 0x24CE0, "chóu"},
    { 0x24CE4, "qī"},
    { 0x24CE5, "xī"},
    { 0x24CE6, "bèi"},
    { 0x24CEA, "yè"},
    { 0x24CED, "guǎng"},
    { 0x24CEF, "zhù"},
    { 0x24CF3, "léi,huǐ"},
    { 0x24CF4, "léi"},
    { 0x24CF5, "chā"},
    { 0x24D00, "guǎng,qiāo"},
    { 0x24D0D, "dié"},
    { 0x24D13, "yǎ"},
    { 0x24D18, "niè"},
    { 0x24D19, "shū,xū"},
    { 0x24D1B, "zhì"},
    { 0x24D1F, "zhì"},
    { 0x24D22, "zhì"},
    { 0x24D23, "pǐ"},
    { 0x24D25, "jiū"},
    { 0x24D26, "jiū"},
    { 0x24D27, "yì"},
    { 0x24D28, "yòu,yǒu"},
    { 0x24D2A, "jiū"},
    { 0x24D2F, "huàn"},
    { 0x24D31, "dù"},
    { 0x24D3B, "táo"},
    { 0x24D3C, "qiè,cí"},
    { 0x24D3D, "qín"},
    { 0x24D3E, "xìn"},
    { 0x24D3F, "chān"},
    { 0x24D40, "jì"},
    { 0x24D42, "qìn"},
    { 0x24D4A, "dù"},
    { 0x24D4B, "zhī"},
    { 0x24D4E, "ǒu"},
    { 0x24D50, "wù"},
    { 0x24D52, "wén"},
    { 0x24D58, "bì"},
    { 0x24D5B, "bēi"},
    { 0x24D5D, "mǔ"},
    { 0x24D5E, "jìn"},
    { 0x24D5F, "táo"},
    { 0x24D60, "liáo"},
    { 0x24D65, "cáo,zhǒu"},
    { 0x24D66, "zhá"},
    { 0x24D6C, "chǐ"},
    { 0x24D6D, "yā"},
    { 0x24D6E, "kuí"},
    { 0x24D6F, "yìn"},
    { 0x24D78, "lóng,pāng"},
    { 0x24D79, "qià"},
    { 0x24D7B, "hāng"},
    { 0x24D7C, "shàng,shāng"},
    { 0x24D7D, "hài"},
    { 0x24D7E, "chā"},
    { 0x24D80, "jiǎo"},
    { 0x24D81, "lǎo"},
    { 0x24D88, "xī"},
    { 0x24D8B, "bó"},
    { 0x24D93, "zhǐ"},
    { 0x24D95, "tùn"},
    { 0x24D96, "fú"},
    { 0x24D98, "hū"},
    { 0x24D9A, "niè"},
    { 0x24D9B, "yì"},
    { 0x24D9C, "zhuàng"},
    { 0x24DA0, "chá"},
    { 0x24DA4, "suān"},
    { 0x24DA7, "yùn"},
    { 0x24DAE, "dù"},
    { 0x24DB0, "xī"},
    { 0x24DB1, "chuàn"},
    { 0x24DB2, "xíng"},
    { 0x24DB3, "jiǎo"},
    { 0x24DB4, "shēn"},
    { 0x24DC0, "wāng"},
    { 0x24DC1, "bēi"},
    { 0x24DC2, "féi"},
    { 0x24DC3, "jiàn"},
    { 0x24DC4, "quán"},
    { 0x24DC5, "yì,yá"},
    { 0x24DC6, "dōng"},
    { 0x24DC7, "xù"},
    { 0x24DC8, "nà,niè"},
    { 0x24DC9, "jí"},
    { 0x24DCC, "zhěn"},
    { 0x24DCD, "qí"},
    { 0x24DCE, "duī"},
    { 0x24DCF, "yín"},
    { 0x24DD1, "jiù"},
    { 0x24DD2, "pí,bì,bēi"},
    { 0x24DD3, "xìn"},
    { 0x24DD4, "lún"},
    { 0x24DD5, "cǎi"},
    { 0x24DD6, "lìng"},
    { 0x24DD7, "biē"},
    { 0x24DD8, "dào"},
    { 0x24DD9, "dé"},
    { 0x24DDF, "la"},
    { 0x24DE1, "xī,nüè"},
    { 0x24DE2, "jù"},
    { 0x24DE4, "xiáo"},
    { 0x24DE6, "jīng"},
    { 0x24DF9, "wài"},
    { 0x24DFB, "nǎo"},
    { 0x24DFC, "xiāng"},
    { 0x24DFD, "què"},
    { 0x24DFE, "qiè"},
    { 0x24DFF, "tū"},
    { 0x24E00, "xǔ"},
    { 0x24E01, "huì"},
    { 0x24E05, "mín"},
    { 0x24E06, "wěi"},
    { 0x24E08, "yóu"},
    { 0x24E09, "tuí"},
    { 0x24E0A, "dài"},
    { 0x24E0E, "kě,hài"},
    { 0x24E0F, "nà,niè"},
    { 0x24E11, "fù"},
    { 0x24E12, "yù"},
    { 0x24E13, "zhǐ"},
    { 0x24E15, "hān"},
    { 0x24E16, "āi"},
    { 0x24E17, "fù"},
    { 0x24E21, "yāng"},
    { 0x24E24, "shí"},
    { 0x24E26, "chán"},
    { 0x24E2A, "chì"},
    { 0x24E2B, "yùn"},
    { 0x24E2C, "shuāi"},
    { 0x24E2E, "sù"},
    { 0x24E2F, "sǎng"},
    { 0x24E31, "è,kè,kài,yà"},
    { 0x24E32, "zhěng"},
    { 0x24E33, "ái"},
    { 0x24E34, "suǒ"},
    { 0x24E35, "bù"},
    { 0x24E37, "qún"},
    { 0x24E38, "yì"},
    { 0x24E39, "yǎn"},
    { 0x24E3B, "nà"},
    { 0x24E3C, "wǔ"},
    { 0x24E47, "lì"},
    { 0x24E48, "lì"},
    { 0x24E4A, "xī"},
    { 0x24E4B, "jué"},
    { 0x24E4C, "shī"},
    { 0x24E4E, "yǎ"},
    { 0x24E5B, "chén"},
    { 0x24E5C, "yíng"},
    { 0x24E5D, "bì"},
    { 0x24E5E, "chè"},
    { 0x24E61, "zhā"},
    { 0x24E62, "tuǒ"},
    { 0x24E63, "hù"},
    { 0x24E64, "téng"},
    { 0x24E65, "yìng"},
    { 0x24E66, "bǐ"},
    { 0x24E67, "níng"},
    { 0x24E68, "liàn"},
    { 0x24E69, "xìn"},
    { 0x24E6A, "yǔ"},
    { 0x24E72, "bèi"},
    { 0x24E74, "mó"},
    { 0x24E75, "duī"},
    { 0x24E77, "dǎo"},
    { 0x24E78, "qí"},
    { 0x24E80, "shuāi"},
    { 0x24E83, "xiāo,jiāo,yāo"},
    { 0x24E84, "zhǒng,tóng"},
    { 0x24E85, "zhuì"},
    { 0x24E87, "biàn"},
    { 0x24E89, "wěi"},
    { 0x24E8A, "xī,sī"},
    { 0x24E8C, "dēng"},
    { 0x24E8E, "xiē"},
    { 0x24E8F, "pān"},
    { 0x24E90, "niè"},
    { 0x24E93, "bié"},
    { 0x24E94, "shè"},
    { 0x24E95, "fèi"},
    { 0x24E96, "mǐn"},
    { 0x24E97, "qì,jì"},
    { 0x24EAA, "shàn"},
    { 0x24EAB, "suǒ"},
    { 0x24EB7, "jí"},
    { 0x24EBA, "dǎn,dàn,tán"},
    { 0x24EBB, "juàn"},
    { 0x24EBC, "lù"},
    { 0x24EBE, "ào"},
    { 0x24EC2, "yì"},
    { 0x24EC3, "shǔ"},
    { 0x24EC4, "suì"},
    { 0x24EC5, "wèi"},
    { 0x24EC6, "wán"},
    { 0x24EC7, "chǔ"},
    { 0x24ECC, "wò"},
    { 0x24ED6, "bì"},
    { 0x24ED8, "yǐn"},
    { 0x24ED9, "huó"},
    { 0x24EDC, "kài,è"},
    { 0x24EDD, "níng"},
    { 0x24EE2, "ài"},
    { 0x24EE4, "lì"},
    { 0x24EE6, "zhāi"},
    { 0x24EF1, "lù"},
    { 0x24EF6, "biàn"},
    { 0x24EF7, "pán"},
    { 0x24EFF, "guì"},
    { 0x24F00, "sū"},
    { 0x24F01, "méng"},
    { 0x24F02, "xiǎn"},
    { 0x24F03, "lòng,lóng"},
    { 0x24F05, "qì"},
    { 0x24F0B, "chàn"},
    { 0x24F0C, "yì"},
    { 0x24F0D, "háng"},
    { 0x24F0F, "liǎn"},
    { 0x24F10, "guàn,huàn"},
    { 0x24F12, "wěi,huà"},
    { 0x24F17, "jué"},
    { 0x24F18, "léi"},
    { 0x24F19, "luán"},
    { 0x24F1A, "lì"},
    { 0x24F1C, "pí"},
    { 0x24F22, "huǎn"},
    { 0x24F2E, "guī"},
    { 0x24F33, "jú"},
    { 0x24F36, "dēng"},
    { 0x24F3A, "fèi"},
    { 0x24F41, "zhī"},
    { 0x24F43, "mèi"},
    { 0x24F45, "huàn"},
    { 0x24F49, "pā"},
    { 0x24F4A, "bǐ"},
    { 0x24F4C, "pō"},
    { 0x24F53, "ér"},
    { 0x24F55, "huàn"},
    { 0x24F63, "chàng"},
    { 0x24F65, "luò"},
    { 0x24F66, "fǒu"},
    { 0x24F6F, "chóu"},
    { 0x24F71, "zú"},
    { 0x24F72, "nán"},
    { 0x24F73, "xiǎo"},
    { 0x24F79, "bài"},
    { 0x24F7A, "lù"},
    { 0x24F7C, "luò"},
    { 0x24F7F, "niàn"},
    { 0x24F80, "zé"},
    { 0x24F84, "zhù"},
    { 0x24F85, "hú"},
    { 0x24F88, "huī"},
    { 0x24F89, "tǎng"},
    { 0x24F8A, "chóu"},
    { 0x24F91, "huáng"},
    { 0x24F92, "dōu"},
    { 0x24F9B, "miào"},
    { 0x24F9D, "bó"},
    { 0x24FA0, "dì"},
    { 0x24FA2, "děng"},
    { 0x24FA3, "pū"},
    { 0x24FA5, "sōng"},
    { 0x24FA6, "chóu"},
    { 0x24FAB, "yào"},
    { 0x24FAC, "měng"},
    { 0x24FAD, "lóng"},
    { 0x24FB2, "lián"},
    { 0x24FB5, "bié"},
    { 0x24FBA, "lǚ"},
    { 0x24FBF, "sè"},
    { 0x24FC0, "zuó"},
    { 0x24FC4, "cún"},
    { 0x24FC5, "líng"},
    { 0x24FC6, "zhěng"},
    { 0x24FC7, "pǐ"},
    { 0x24FC8, "báo"},
    { 0x24FCB, "què"},
    { 0x24FCE, "pī"},
    { 0x24FCF, "nàn"},
    { 0x24FD0, "pī"},
    { 0x24FD1, "bǒ"},
    { 0x24FD2, "bèi"},
    { 0x24FD3, "fā"},
    { 0x24FD5, "mǐn"},
    { 0x24FD6, "mò"},
    { 0x24FD7, "wà"},
    { 0x24FD8, "zhāo"},
    { 0x24FD9, "zhì,pí"},
    { 0x24FDA, "cū"},
    { 0x24FDF, "xún"},
    { 0x24FE0, "jí"},
    { 0x24FE1, "guì,qí"},
    { 0x24FE3, "chéng"},
    { 0x24FE7, "hàn"},
    { 0x24FE8, "xiào"},
    { 0x24FE9, "què"},
    { 0x24FEB, "chuò"},
    { 0x24FED, "fǔ"},
    { 0x24FF3, "qǐn"},
    { 0x24FF4, "lù"},
    { 0x24FF5, "què"},
    { 0x24FF6, "diǎn"},
    { 0x24FF7, "qiān"},
    { 0x24FFC, "chǎng"},
    { 0x24FFD, "tà"},
    { 0x24FFE, "bēi"},
    { 0x25001, "dù"},
    { 0x25002, "běng,bāng"},
    { 0x25003, "hòu"},
    { 0x25008, "zhǎ"},
    { 0x25009, "zhǎ"},
    { 0x2500E, "què"},
    { 0x2500F, "má"},
    { 0x25010, "hán"},
    { 0x25013, "liú"},
    { 0x25014, "lù"},
    { 0x25016, "zī"},
    { 0x25018, "pǐ"},
    { 0x25019, "zhòu"},
    { 0x2501B, "zāo"},
    { 0x2501D, "niǔ"},
    { 0x25020, "huì"},
    { 0x25023, "xué,qiào"},
    { 0x25025, "là"},
    { 0x2502B, "nóu,rǎn"},
    { 0x2502C, "yǎn,yè"},
    { 0x2502D, "rǎn"},
    { 0x2502E, "nǎo"},
    { 0x25030, "là"},
    { 0x25031, "guǎng"},
    { 0x25032, "dú"},
    { 0x25035, "lú"},
    { 0x25039, "jiǎn"},
    { 0x2503A, "xiè"},
    { 0x2503B, "qì"},
    { 0x2503E, "xiàng"},
    { 0x25041, "guǒ"},
    { 0x25042, "jié"},
    { 0x25043, "màng"},
    { 0x25046, "xiā"},
    { 0x25047, "kuī"},
    { 0x2504E, "yòng"},
    { 0x25050, "hǎi"},
    { 0x25051, "mì"},
    { 0x25052, "yào"},
    { 0x25055, "wēn"},
    { 0x2505F, "lì"},
    { 0x25060, "juàn,quán,quān"},
    { 0x25061, "wū"},
    { 0x25062, "qiáo"},
    { 0x2506E, "diào"},
    { 0x2506F, "chù,chuò"},
    { 0x25072, "suō"},
    { 0x25075, "chōng"},
    { 0x25078, "quān"},
    { 0x25079, "shè"},
    { 0x25082, "měng"},
    { 0x25083, "jù"},
    { 0x2508B, "tú"},
    { 0x25092, "nóng"},
    { 0x25093, "mó"},
    { 0x25099, "fèn"},
    { 0x250A2, "áo"},
    { 0x250A3, "guō"},
    { 0x250A4, "hú"},
    { 0x250A5, "cán"},
    { 0x250A6, "dūn"},
    { 0x250A7, "hǎi"},
    { 0x250A8, "jiǎo"},
    { 0x250B0, "gū"},
    { 0x250B5, "jīn"},
    { 0x250B8, "yáng"},
    { 0x250C0, "chà"},
    { 0x250CC, "huī"},
    { 0x250D4, "qú"},
    { 0x250D5, "kē"},
    { 0x250DF, "qīng"},
    { 0x250E0, "yì"},
    { 0x250E3, "kǎi"},
    { 0x250E4, "jiǎo"},
    { 0x250E7, "chōu,jiǎo,yǎo"},
    { 0x250E8, "bǔ"},
    { 0x250E9, "gèn,yǎn"},
    { 0x250EA, "jiāo"},
    { 0x250EB, "zhī"},
    { 0x250EE, "wèn"},
    { 0x250F0, "bīn"},
    { 0x250F4, "xiòng"},
    { 0x250F5, "fàn"},
    { 0x250F8, "yí"},
    { 0x250F9, "chuàn"},
    { 0x250FA, "yào"},
    { 0x250FD, "yāng"},
    { 0x250FE, "dù"},
    { 0x250FF, "yǎn"},
    { 0x25101, "méng"},
    { 0x25107, "chī,hūn"},
    { 0x25108, "mù"},
    { 0x25109, "jiāo"},
    { 0x2510B, "nǜ"},
    { 0x2510D, "guó"},
    { 0x2510E, "xuè"},
    { 0x25111, "fú"},
    { 0x25112, "xuē"},
    { 0x25113, "fū"},
    { 0x25114, "pèi,pò"},
    { 0x25115, "mò"},
    { 0x25116, "xī"},
    { 0x25117, "wò,nài"},
    { 0x25118, "shǎn"},
    { 0x2511B, "xī"},
    { 0x2511C, "qì"},
    { 0x2511D, "miàn"},
    { 0x25126, "dǎn"},
    { 0x25128, "chǒu"},
    { 0x25131, "fèi"},
    { 0x25132, "mié"},
    { 0x25134, "xuè,jué"},
    { 0x25135, "xù,yù"},
    { 0x25136, "sī"},
    { 0x25137, "jǔ"},
    { 0x25138, "mǎo"},
    { 0x25139, "bào"},
    { 0x2513B, "yí"},
    { 0x2513C, "guā"},
    { 0x2513D, "nì"},
    { 0x2513F, "yí,dì"},
    { 0x25141, "zuò"},
    { 0x25144, "nǔ"},
    { 0x25151, "diàn"},
    { 0x25152, "fàn"},
    { 0x25153, "yì"},
    { 0x25154, "shì"},
    { 0x25157, "cū"},
    { 0x25158, "zhěn,mí"},
    { 0x2515E, "shì"},
    { 0x2515F, "jiǎo"},
    { 0x25160, "hòu"},
    { 0x25161, "ér"},
    { 0x25166, "lèi"},
    { 0x25167, "xuè"},
    { 0x25168, "gèng"},
    { 0x2516A, "shōu"},
    { 0x2516C, "juān"},
    { 0x25174, "jié"},
    { 0x25175, "wéi"},
    { 0x25177, "shǒu"},
    { 0x25178, "jìng"},
    { 0x2517A, "xú"},
    { 0x2517B, "chòng"},
    { 0x25185, "jiāng"},
    { 0x25186, "mòu"},
    { 0x25189, "yù"},
    { 0x2518C, "jué"},
    { 0x25191, "tìng"},
    { 0x25194, "xiāo"},
    { 0x25196, "dōu"},
    { 0x25198, "guó"},
    { 0x25199, "máng"},
    { 0x2519A, "wāng"},
    { 0x2519B, "xù"},
    { 0x2519C, "wàng"},
    { 0x2519D, "suō"},
    { 0x2519E, "juàn"},
    { 0x2519F, "yuè"},
    { 0x251A1, "hán"},
    { 0x251A3, "shēn"},
    { 0x251A5, "xié"},
    { 0x251A6, "liú"},
    { 0x251A7, "rún"},
    { 0x251AF, "bì"},
    { 0x251B2, "nào"},
    { 0x251B6, "wàn"},
    { 0x251B7, "jiù"},
    { 0x251B8, "quē"},
    { 0x251C4, "nì"},
    { 0x251C6, "mí"},
    { 0x251C7, "suō"},
    { 0x251C9, "qiǎng"},
    { 0x251CC, "hàn,qià"},
    { 0x251CD, "zhuó"},
    { 0x251CE, "mí"},
    { 0x251CF, "xù"},
    { 0x251D1, "lǎng"},
    { 0x251D2, "jié"},
    { 0x251D3, "dìng"},
    { 0x251D4, "chàng,zhāng"},
    { 0x251D5, "zhì"},
    { 0x251D6, "fēi"},
    { 0x251D7, "jiá"},
    { 0x251D8, "jùn"},
    { 0x251D9, "huò"},
    { 0x251DA, "qī"},
    { 0x251DB, "jū,jù,xì"},
    { 0x251DC, "zhūn,guō"},
    { 0x251DE, "diàn"},
    { 0x251DF, "jiǎo"},
    { 0x251E0, "yā"},
    { 0x251E2, "zhǎn"},
    { 0x251ED, "zhī"},
    { 0x251EF, "mài"},
    { 0x251F0, "hū"},
    { 0x251F1, "xiè"},
    { 0x251F2, "shí"},
    { 0x251F3, "guī"},
    { 0x251FF, "xù"},
    { 0x25202, "jí"},
    { 0x25204, "chuàng"},
    { 0x25206, "mào"},
    { 0x25207, "ruán"},
    { 0x25208, "xū"},
    { 0x25209, "huàn"},
    { 0x2520A, "shà"},
    { 0x2520B, "jǔ"},
    { 0x2520F, "kuàng"},
    { 0x25211, "hóu"},
    { 0x25212, "guān"},
    { 0x25213, "guā"},
    { 0x25215, "mí"},
    { 0x25216, "dié"},
    { 0x25217, "bì"},
    { 0x25218, "liǎng"},
    { 0x25219, "là"},
    { 0x2521A, "shǎn"},
    { 0x2521B, "lù"},
    { 0x2521C, "xì"},
    { 0x2521F, "sǒu"},
    { 0x2522C, "ōu"},
    { 0x2522E, "léng"},
    { 0x25237, "kū"},
    { 0x25238, "guī"},
    { 0x2523B, "xī"},
    { 0x2523C, "pán,pān"},
    { 0x2523D, "sè"},
    { 0x2523E, "juè"},
    { 0x2523F, "hòng"},
    { 0x25240, "guàn"},
    { 0x25241, "jù"},
    { 0x25243, "nài"},
    { 0x25244, "huá"},
    { 0x25245, "gé"},
    { 0x25246, "lì"},
    { 0x25247, "gòu"},
    { 0x25248, "tì"},
    { 0x2524A, "mà"},
    { 0x2524B, "téng"},
    { 0x2524C, "dá"},
    { 0x25250, "qī"},
    { 0x25251, "yù,hè"},
    { 0x25252, "jiǎo"},
    { 0x25253, "miè"},
    { 0x25254, "gěng"},
    { 0x25255, "mèng,méng"},
    { 0x25256, "wèi"},
    { 0x25258, "tí"},
    { 0x25259, "qí"},
    { 0x2525C, "chén"},
    { 0x2525D, "dōu"},
    { 0x2525F, "pán"},
    { 0x25270, "hàn,qià"},
    { 0x25274, "mì"},
    { 0x25275, "má"},
    { 0x25276, "lù"},
    { 0x25277, "qī"},
    { 0x25278, "kēng"},
    { 0x2527A, "dié"},
    { 0x2527B, "qì"},
    { 0x2527C, "jiāo"},
    { 0x2527D, "kāng"},
    { 0x2527E, "qiāo"},
    { 0x2527F, "mì"},
    { 0x25280, "shān,sǎn"},
    { 0x25287, "jiān"},
    { 0x25288, "lí"},
    { 0x25289, "kè"},
    { 0x2528A, "xù"},
    { 0x25291, "mán,màn"},
    { 0x25292, "fèng"},
    { 0x25293, "chàn"},
    { 0x25294, "huǐ"},
    { 0x252A7, "kòu"},
    { 0x252AA, "wěi"},
    { 0x252AB, "guàn"},
    { 0x252AC, "jí"},
    { 0x252AD, "zùn"},
    { 0x252AE, "huò"},
    { 0x252AF, "xié"},
    { 0x252B4, "suì"},
    { 0x252B6, "ruǎn"},
    { 0x252B8, "tè"},
    { 0x252BC, "zhèng"},
    { 0x252BD, "kūn"},
    { 0x252BE, "xiǎng"},
    { 0x252BF, "mián"},
    { 0x252C1, "xì"},
    { 0x252CC, "sā"},
    { 0x252D9, "è"},
    { 0x252DA, "miè"},
    { 0x252DB, "zhǔ"},
    { 0x252DC, "zōu"},
    { 0x252DD, "měng"},
    { 0x252DF, "xī"},
    { 0x252E1, "táng"},
    { 0x252E3, "jià"},
    { 0x252E4, "cháng"},
    { 0x252E5, "jí"},
    { 0x252EE, "zhuó"},
    { 0x252FF, "hè"},
    { 0x25300, "chá"},
    { 0x25301, "qì"},
    { 0x25302, "mián"},
    { 0x25303, "zhěn"},
    { 0x25304, "kū"},
    { 0x25305, "yè"},
    { 0x25306, "zhōu"},
    { 0x25308, "jiān"},
    { 0x2530A, "pàn"},
    { 0x2530D, "huī"},
    { 0x2530F, "míng"},
    { 0x25310, "liù"},
    { 0x25318, "shuì"},
    { 0x2531A, "mài,yá,shù"},
    { 0x2531B, "lí"},
    { 0x2531E, "shuò"},
    { 0x2531F, "yí"},
    { 0x25324, "lì"},
    { 0x25328, "xiē,miè"},
    { 0x25329, "tè"},
    { 0x2532A, "xiū"},
    { 0x2532D, "xuàn"},
    { 0x2532E, "lì"},
    { 0x2532F, "méng"},
    { 0x25330, "wéi"},
    { 0x25331, "méng"},
    { 0x2533A, "yào"},
    { 0x2533B, "lán"},
    { 0x2533C, "líng"},
    { 0x2533D, "yīng"},
    { 0x2533E, "yīng"},
    { 0x2533F, "lì"},
    { 0x25340, "jiǎn"},
    { 0x25341, "guī,guì"},
    { 0x25345, "guān"},
    { 0x25346, "xiè"},
    { 0x25349, "shè"},
    { 0x2534B, "zuī,xiē,huǐ"},
    { 0x25353, "kàn,yǎn"},
    { 0x25354, "léi"},
    { 0x2535A, "biàn"},
    { 0x2535D, "shǔ"},
    { 0x2535E, "nǜ"},
    { 0x2535F, "xù,yì"},
    { 0x25363, "hào"},
    { 0x25368, "guǐ"},
    { 0x2536A, "zhài"},
    { 0x2536B, "láng"},
    { 0x2536C, "cuān"},
    { 0x2536D, "zhì"},
    { 0x2536E, "féng,fēng"},
    { 0x2536F, "qīn"},
    { 0x25371, "zé"},
    { 0x25372, "nà"},
    { 0x25373, "niǔ"},
    { 0x25374, "yì"},
    { 0x25377, "cōng"},
    { 0x25378, "shī"},
    { 0x25379, "jiǎn"},
    { 0x2537A, "zōng"},
    { 0x2537B, "yǎn"},
    { 0x2537C, "yīng"},
    { 0x25380, "ruǎn"},
    { 0x25382, "róng"},
    { 0x25383, "xì"},
    { 0x25385, "guān"},
    { 0x25386, "kài"},
    { 0x25388, "wù"},
    { 0x2538A, "qín"},
    { 0x2538B, "cōng"},
    { 0x2538D, "zé"},
    { 0x2538E, "xiè"},
    { 0x25390, "yù"},
    { 0x25391, "zàn"},
    { 0x25392, "chuāng"},
    { 0x25393, "lǐ"},
    { 0x25394, "lǐ"},
    { 0x25395, "xù"},
    { 0x25396, "mí"},
    { 0x25397, "xù"},
    { 0x25398, "ruǎn"},
    { 0x2539B, "guì"},
    { 0x2539C, "rǒng"},
    { 0x2539F, "máo"},
    { 0x253A1, "qín"},
    { 0x253A2, "cuàn"},
    { 0x253A3, "cuàn"},
    { 0x253A4, "cuàn"},
    { 0x253AE, "wū"},
    { 0x253B0, "fǎ"},
    { 0x253B1, "bá"},
    { 0x253B8, "qià"},
    { 0x253B9, "zhì"},
    { 0x253BA, "tiào"},
    { 0x253C4, "zhì"},
    { 0x253C5, "zhí"},
    { 0x253C7, "huàn"},
    { 0x253C8, "chóu"},
    { 0x253CA, "zhì"},
    { 0x253CE, "yǐng"},
    { 0x253D2, "wù"},
    { 0x253D3, "bēi"},
    { 0x253D5, "hóng"},
    { 0x253D6, "shěn"},
    { 0x253D8, "jué"},
    { 0x253D9, "kuì"},
    { 0x253DC, "yǐ"},
    { 0x253DD, "yà"},
    { 0x253E0, "bī"},
    { 0x253E4, "kuà"},
    { 0x253E5, "qiān"},
    { 0x253E8, "zhāo"},
    { 0x253EA, "kǎi"},
    { 0x253EB, "shāng"},
    { 0x253EE, "àn"},
    { 0x253EF, "zhé"},
    { 0x253F0, "zhì"},
    { 0x253F7, "zhì"},
    { 0x253F9, "jiǎo"},
    { 0x25400, "sī"},
    { 0x25401, "pú"},
    { 0x25402, "ǒu"},
    { 0x2540A, "zhuó"},
    { 0x25411, "yīng"},
    { 0x25413, "huān"},
    { 0x25415, "yà"},
    { 0x25418, "shí"},
    { 0x25419, "pā,bā"},
    { 0x2541A, "pǔ"},
    { 0x2541E, "máng"},
    { 0x2541F, "chāi"},
    { 0x25429, "yún"},
    { 0x2542C, "gǔ"},
    { 0x25439, "dǎn"},
    { 0x2543B, "náo"},
    { 0x2543D, "zhé"},
    { 0x2543F, "hú"},
    { 0x25445, "kēng"},
    { 0x25447, "dié"},
    { 0x25448, "tīng"},
    { 0x2544B, "guài"},
    { 0x2544E, "qiōng"},
    { 0x2544F, "shǐ"},
    { 0x25450, "jiǎ"},
    { 0x25451, "ào"},
    { 0x25452, "nǎ,kēng"},
    { 0x25453, "pǐn"},
    { 0x25454, "jiá"},
    { 0x25461, "zhè"},
    { 0x25462, "bù"},
    { 0x25463, "wǒ"},
    { 0x25465, "chǎ"},
    { 0x2546A, "náo"},
    { 0x2546B, "kān,kǎn"},
    { 0x2546F, "dú"},
    { 0x25470, "guài"},
    { 0x25471, "qióng"},
    { 0x25473, "róng"},
    { 0x25474, "yǐ"},
    { 0x25475, "duī"},
    { 0x25476, "lěi"},
    { 0x25478, "zhōu"},
    { 0x25479, "kuā"},
    { 0x2547A, "ē"},
    { 0x2547B, "xiān"},
    { 0x2547C, "diàn"},
    { 0x2547D, "nuò"},
    { 0x2547E, "è"},
    { 0x2547F, "yōng"},
    { 0x25480, "wù"},
    { 0x25481, "kēng"},
    { 0x25493, "zhì"},
    { 0x25497, "zhǐ"},
    { 0x25498, "xún"},
    { 0x2549B, "zhèng"},
    { 0x2549E, "yáng"},
    { 0x254A0, "huò"},
    { 0x254A1, "jí"},
    { 0x254A2, "nǎo,lì"},
    { 0x254A7, "yà"},
    { 0x254A8, "lù"},
    { 0x254AB, "fū"},
    { 0x254AC, "sǎn"},
    { 0x254AD, "chù"},
    { 0x254AE, "wěi"},
    { 0x254B0, "fǔ"},
    { 0x254B1, "kēng"},
    { 0x254B2, "sì"},
    { 0x254B3, "kàng"},
    { 0x254B5, "yì"},
    { 0x254B6, "huà"},
    { 0x254BE, "yǔ"},
    { 0x254C3, "lì"},
    { 0x254C6, "lǐn"},
    { 0x254C7, "dǔ"},
    { 0x254C8, "è"},
    { 0x254CC, "qiǎng"},
    { 0x254CD, "dú"},
    { 0x254D0, "jié"},
    { 0x254D1, "chuò"},
    { 0x254D2, "xiàn,kàn"},
    { 0x254D6, "gǎo"},
    { 0x254EC, "dào"},
    { 0x254F0, "hōng"},
    { 0x254FB, "zōng"},
    { 0x254FE, "qì"},
    { 0x254FF, "tuó"},
    { 0x25500, "hōng"},
    { 0x25501, "pǐ"},
    { 0x25502, "gèng"},
    { 0x25504, "niè"},
    { 0x25507, "kōng"},
    { 0x2550A, "zhǐ"},
    { 0x25511, "xiǎo"},
    { 0x25521, "shè"},
    { 0x25522, "yú"},
    { 0x25523, "jiāng"},
    { 0x25529, "qǐ"},
    { 0x2552A, "chěn"},
    { 0x2552B, "sǎng"},
    { 0x2552D, "suǒ"},
    { 0x2552E, "qián"},
    { 0x2552F, "huì"},
    { 0x25531, "shàn"},
    { 0x25532, "è"},
    { 0x2553B, "qiū"},
    { 0x2553D, "kè"},
    { 0x25540, "wēng"},
    { 0x25541, "zī"},
    { 0x25542, "jí"},
    { 0x25547, "dǎ"},
    { 0x25549, "cuò"},
    { 0x2554D, "lǒu"},
    { 0x2554E, "kāng"},
    { 0x2554F, "kuò"},
    { 0x25550, "dí"},
    { 0x25551, "qiē,jū"},
    { 0x25553, "mò"},
    { 0x25556, "guǒ"},
    { 0x25557, "hōng"},
    { 0x25558, "cháo,suǒ"},
    { 0x25559, "hēi"},
    { 0x25562, "cáo"},
    { 0x25563, "zhé"},
    { 0x25566, "gǔn"},
    { 0x25570, "xū"},
    { 0x25571, "péng,pēng"},
    { 0x25572, "jué"},
    { 0x25575, "gǎn"},
    { 0x25576, "sī"},
    { 0x25578, "suì"},
    { 0x25579, "què"},
    { 0x2557B, "wú,wǔ"},
    { 0x2557C, "yán"},
    { 0x2557D, "pèng"},
    { 0x2557E, "xiǎo"},
    { 0x2557F, "pān"},
    { 0x2558D, "là"},
    { 0x25597, "bèng"},
    { 0x25598, "zhěn"},
    { 0x25599, "jí"},
    { 0x2559C, "jǐn"},
    { 0x2559D, "lián"},
    { 0x2559E, "kěn"},
    { 0x255A0, "zhóu,dú"},
    { 0x255A8, "zào"},
    { 0x255AA, "lè"},
    { 0x255AB, "qī"},
    { 0x255AC, "bìng"},
    { 0x255B5, "yǐn"},
    { 0x255B6, "pīn"},
    { 0x255BB, "sǒu"},
    { 0x255BC, "lǜ"},
    { 0x255BE, "dí"},
    { 0x255BF, "dú"},
    { 0x255C0, "liǎo"},
    { 0x255C1, "zhuó"},
    { 0x255CA, "chǎng"},
    { 0x255D2, "chèn"},
    { 0x255D3, "tà"},
    { 0x255D9, "què"},
    { 0x255DA, "dào"},
    { 0x255DD, "rǎng"},
    { 0x255DF, "pò"},
    { 0x255E6, "zhōng"},
    { 0x255E7, "xiē"},
    { 0x255EA, "jiāng"},
    { 0x255EB, "qú"},
    { 0x255EC, "lěi"},
    { 0x255ED, "cà"},
    { 0x255EE, "quē"},
    { 0x255F5, "xiàng"},
    { 0x255F6, "lèi"},
    { 0x255FA, "làn"},
    { 0x255FF, "lǎ"},
    { 0x25601, "lǎ"},
    { 0x25604, "yù"},
    { 0x2560A, "jiào"},
    { 0x2560B, "qín"},
    { 0x2560C, "jī"},
    { 0x2560F, "gǎn"},
    { 0x25612, "yì"},
    { 0x25620, "yì"},
    { 0x25621, "zhī"},
    { 0x25624, "biǎo"},
    { 0x25625, "shēng"},
    { 0x25626, "jiù,shè"},
    { 0x2562B, "hē"},
    { 0x2562C, "fú"},
    { 0x2562E, "jū"},
    { 0x25640, "zuǒ"},
    { 0x25641, "yí"},
    { 0x25646, "xiàn,zhī"},
    { 0x25647, "yí"},
    { 0x25649, "sì,tái"},
    { 0x2564B, "chuì"},
    { 0x2564E, "mò"},
    { 0x25661, "zhān"},
    { 0x25663, "xún"},
    { 0x25666, "rú"},
    { 0x25668, "huò"},
    { 0x2566C, "shāo"},
    { 0x25670, "shòu"},
    { 0x2567E, "yòu"},
    { 0x2567F, "yù"},
    { 0x25682, "jùn"},
    { 0x25689, "zī"},
    { 0x2568A, "lù"},
    { 0x2569A, "chǐ"},
    { 0x2569B, "kūn"},
    { 0x256A0, "zhùn"},
    { 0x256A6, "hóu"},
    { 0x256A9, "xǔ"},
    { 0x256BE, "zōng"},
    { 0x256BF, "yìng"},
    { 0x256C2, "zhū"},
    { 0x256C5, "liù"},
    { 0x256D1, "nù"},
    { 0x256D8, "bì"},
    { 0x256DA, "chì"},
    { 0x256DC, "zǔ"},
    { 0x256DD, "féng"},
    { 0x256DE, "lù"},
    { 0x256DF, "pǔ"},
    { 0x256E5, "zhuàn"},
    { 0x256E7, "zhé"},
    { 0x256E8, "shī"},
    { 0x256E9, "yǔ"},
    { 0x256EA, "lù"},
    { 0x256EB, "liáng"},
    { 0x256EF, "jué"},
    { 0x256F0, "liào"},
    { 0x256F1, "bēng"},
    { 0x25703, "yì"},
    { 0x25704, "guān"},
    { 0x2570C, "ǎo"},
    { 0x2570F, "guì"},
    { 0x25710, "mǐn"},
    { 0x25712, "yǎn"},
    { 0x25713, "lán"},
    { 0x25716, "bó"},
    { 0x25719, "zàn"},
    { 0x2571A, "yǒu"},
    { 0x25725, "yì"},
    { 0x25726, "nǐ,xiǎn"},
    { 0x2572C, "nǐ,xiǎn"},
    { 0x2572D, "guǒ"},
    { 0x2572E, "jùn"},
    { 0x25730, "shī"},
    { 0x25732, "xiǎn,jiǎn"},
    { 0x25734, "qiān"},
    { 0x25735, "què"},
    { 0x25736, "kuí"},
    { 0x25740, "shé"},
    { 0x25742, "huò"},
    { 0x25744, "wàn"},
    { 0x2574A, "fèi"},
    { 0x2574B, "fèi"},
    { 0x2574C, "jī"},
    { 0x2574D, "yù,wáng"},
    { 0x25751, "zhī"},
    { 0x25752, "guà"},
    { 0x25754, "jié"},
    { 0x25755, "máng"},
    { 0x25756, "hé,xié"},
    { 0x25758, "yǒu"},
    { 0x2575F, "dù"},
    { 0x25760, "sī,xiù"},
    { 0x25762, "lì"},
    { 0x25765, "jié"},
    { 0x25766, "niǔ"},
    { 0x25767, "bà"},
    { 0x25768, "yú"},
    { 0x2576E, "zhī"},
    { 0x25778, "hé"},
    { 0x25779, "kē"},
    { 0x2577E, "dù,zhà"},
    { 0x2577F, "jiā"},
    { 0x25781, "chēn"},
    { 0x25783, "chuì,shù"},
    { 0x25784, "hé"},
    { 0x25785, "zhǎi"},
    { 0x2578A, "mèi"},
    { 0x2578D, "hé"},
    { 0x2578E, "zǐ"},
    { 0x2578F, "zhú"},
    { 0x25792, "tuó"},
    { 0x25798, "zùn"},
    { 0x2579A, "rú"},
    { 0x2579B, "duò"},
    { 0x2579C, "jiàng"},
    { 0x257A7, "héng"},
    { 0x257A9, "bēng,hé"},
    { 0x257AA, "mò,mǐ"},
    { 0x257AF, "zú"},
    { 0x257B2, "biē"},
    { 0x257B4, "kù"},
    { 0x257B5, "jiá"},
    { 0x257BA, "zhuō"},
    { 0x257BC, "xiū"},
    { 0x257C3, "hé"},
    { 0x257C5, "qiāo"},
    { 0x257CD, "fěi"},
    { 0x257CE, "shēng"},
    { 0x257D2, "zhuì"},
    { 0x257D3, "kuǎn"},
    { 0x257D4, "zè"},
    { 0x257D5, "xiān"},
    { 0x257D7, "bì"},
    { 0x257D8, "yì"},
    { 0x257DA, "chàng"},
    { 0x257EA, "mào"},
    { 0x257F6, "wǎn"},
    { 0x257FD, "wū"},
    { 0x257FE, "kū"},
    { 0x257FF, "wǒ"},
    { 0x25800, "xīng"},
    { 0x25801, "kē"},
    { 0x25803, "jiū"},
    { 0x25804, "duān"},
    { 0x25805, "huàn"},
    { 0x25808, "zhì,jì"},
    { 0x25809, "cè"},
    { 0x2580A, "róu"},
    { 0x2580B, "jí"},
    { 0x2580D, "yè"},
    { 0x2581B, "jīng"},
    { 0x2581C, "yàng"},
    { 0x25821, "zǒng"},
    { 0x25829, "cǎn"},
    { 0x25831, "sī"},
    { 0x25832, "lì"},
    { 0x25833, "gǔ"},
    { 0x25834, "chàng"},
    { 0x25836, "fěi"},
    { 0x25837, "liú"},
    { 0x25839, "jié"},
    { 0x2583A, "yūn"},
    { 0x2583D, "zhì"},
    { 0x25840, "chóu"},
    { 0x25841, "biē"},
    { 0x25852, "jī"},
    { 0x2585C, "luó,suì"},
    { 0x2585D, "jiān,qiān"},
    { 0x2585F, "chuāng"},
    { 0x25860, "shuǎng"},
    { 0x25862, "lǜ"},
    { 0x25863, "jùn"},
    { 0x25864, "jiào"},
    { 0x25866, "tì,dì"},
    { 0x25867, "zhā"},
    { 0x2586A, "yì"},
    { 0x2586C, "cōng"},
    { 0x2586D, "něi"},
    { 0x2586E, "jiā"},
    { 0x25874, "jì"},
    { 0x2587D, "ài"},
    { 0x25887, "jiǎn"},
    { 0x2588A, "bèn"},
    { 0x2588C, "fán"},
    { 0x2588D, "hù,suì"},
    { 0x2588E, "zùn"},
    { 0x2588F, "diàn"},
    { 0x25890, "gāo"},
    { 0x25891, "gǎo,hào"},
    { 0x25892, "láo,lào"},
    { 0x25894, "zhuó,zhào"},
    { 0x2589F, "hù"},
    { 0x258A2, "tuí"},
    { 0x258A6, "bì"},
    { 0x258A7, "jú,yì"},
    { 0x258AE, "huá"},
    { 0x258B2, "chéng"},
    { 0x258B6, "kuài"},
    { 0x258B7, "dāng"},
    { 0x258B8, "gé"},
    { 0x258B9, "xié"},
    { 0x258BB, "jié"},
    { 0x258BD, "cān"},
    { 0x258C6, "zú"},
    { 0x258C8, "pú"},
    { 0x258CB, "shǔ"},
    { 0x258CC, "bǔ"},
    { 0x258D7, "níng"},
    { 0x258D8, "yǎn"},
    { 0x258D9, "zhòu,còng"},
    { 0x258DB, "méng"},
    { 0x258DD, "biǎn"},
    { 0x258DF, "xiàng"},
    { 0x258E4, "lù"},
    { 0x258E5, "lí"},
    { 0x258E9, "jì"},
    { 0x258EB, "miè"},
    { 0x258EC, "lèi"},
    { 0x258EE, "zhì"},
    { 0x258EF, "yōu"},
    { 0x258F0, "biǎn"},
    { 0x258F8, "mù"},
    { 0x258F9, "ràn"},
    { 0x258FA, "ràn"},
    { 0x25902, "niǎo"},
    { 0x2590A, "quán"},
    { 0x2590B, "zhé"},
    { 0x25910, "lèi,léi"},
    { 0x25917, "dǎng"},
    { 0x25918, "jué"},
    { 0x2591C, "líng"},
    { 0x2591E, "líng"},
    { 0x2591F, "yán"},
    { 0x25923, "yǎo"},
    { 0x25924, "zhèn"},
    { 0x25925, "qī"},
    { 0x25926, "ài"},
    { 0x25928, "nú"},
    { 0x25929, "mǎng"},
    { 0x25931, "kǎn,hān"},
    { 0x25933, "jiū,cuàn"},
    { 0x25934, "yǎn"},
    { 0x25935, "miàn"},
    { 0x25937, "yín"},
    { 0x25938, "wán"},
    { 0x25939, "yào,yǎo"},
    { 0x2593A, "wā"},
    { 0x2593B, "pí"},
    { 0x2593C, "suì"},
    { 0x25945, "kǒng"},
    { 0x25948, "hóng,wòng"},
    { 0x2594A, "mǐng"},
    { 0x2594B, "líng"},
    { 0x2594C, "yì,dié"},
    { 0x2594D, "shēn,shèn"},
    { 0x2594F, "zuò"},
    { 0x2595B, "tū,bá"},
    { 0x2595D, "yòng"},
    { 0x2595F, "wà"},
    { 0x25960, "guǐ"},
    { 0x25961, "hòng"},
    { 0x25965, "shì"},
    { 0x25967, "xiòng"},
    { 0x25969, "ā,xiàng"},
    { 0x25971, "chéng"},
    { 0x25973, "kēng"},
    { 0x25974, "yì"},
    { 0x25975, "yàng"},
    { 0x25976, "tíng"},
    { 0x25977, "dòu"},
    { 0x25978, "chá"},
    { 0x25979, "liù"},
    { 0x2597D, "qiú"},
    { 0x2597E, "xuǎn"},
    { 0x2597F, "shēn"},
    { 0x25980, "kuān,mì"},
    { 0x25981, "tòng"},
    { 0x25983, "qiǎn"},
    { 0x25985, "chòu"},
    { 0x2598A, "wěn"},
    { 0x2598C, "lòng"},
    { 0x2598D, "ǎn,yǎn"},
    { 0x25994, "kǎn"},
    { 0x25996, "yǎo"},
    { 0x25998, "fú"},
    { 0x2599C, "bèng"},
    { 0x2599D, "lǎn"},
    { 0x2599E, "qià"},
    { 0x2599F, "diàn"},
    { 0x259A2, "jiào"},
    { 0x259A3, "guī"},
    { 0x259A5, "xiòng"},
    { 0x259A8, "kè"},
    { 0x259B6, "xiàn"},
    { 0x259B7, "wòng"},
    { 0x259C2, "gǒng"},
    { 0x259C6, "ǒu"},
    { 0x259C7, "kē,cháo"},
    { 0x259CB, "kū"},
    { 0x259D1, "tián,diān,yǎn,chǎn"},
    { 0x259D2, "gòu"},
    { 0x259D3, "mǎ"},
    { 0x259D5, "liù"},
    { 0x259D9, "wèi"},
    { 0x259DA, "wěn"},
    { 0x259E1, "gòng"},
    { 0x259E3, "tú"},
    { 0x259E4, "níng"},
    { 0x259E7, "mì"},
    { 0x259EB, "láng"},
    { 0x259EC, "qiǎn"},
    { 0x259ED, "mán"},
    { 0x259EE, "zhé"},
    { 0x259F0, "huà"},
    { 0x259F1, "yōng"},
    { 0x259F2, "jìn,jǐn"},
    { 0x259F4, "mèi"},
    { 0x259F7, "fú"},
    { 0x259FB, "qú"},
    { 0x25A0C, "liù"},
    { 0x25A0D, "fù"},
    { 0x25A0E, "dàn"},
    { 0x25A10, "gǒng"},
    { 0x25A12, "cuì,cuàn"},
    { 0x25A15, "xǐng"},
    { 0x25A1C, "tū"},
    { 0x25A1D, "shòu"},
    { 0x25A2A, "qióng"},
    { 0x25A33, "róng"},
    { 0x25A3B, "lì"},
    { 0x25A3F, "jī"},
    { 0x25A40, "tuò"},
    { 0x25A4C, "tóng"},
    { 0x25A52, "tán"},
    { 0x25A54, "líng"},
    { 0x25A56, "yì"},
    { 0x25A57, "ruǎn"},
    { 0x25A59, "pǎ"},
    { 0x25A5D, "cà"},
    { 0x25A61, "yuè"},
    { 0x25A62, "què"},
    { 0x25A63, "zhù"},
    { 0x25A64, "hài"},
    { 0x25A71, "fá"},
    { 0x25A72, "hài"},
    { 0x25A80, "bū"},
    { 0x25A81, "pīng"},
    { 0x25A82, "liè"},
    { 0x25A8A, "kuǐ,jué"},
    { 0x25A8B, "fú"},
    { 0x25A8C, "tiǎn"},
    { 0x25A8D, "wò"},
    { 0x25A8F, "jū"},
    { 0x25A98, "zhēn"},
    { 0x25A9A, "fú"},
    { 0x25AA2, "lóng"},
    { 0x25AA6, "xì"},
    { 0x25AA7, "tián"},
    { 0x25AAB, "jì"},
    { 0x25AAF, "yào,qiáo"},
    { 0x25AB1, "cù"},
    { 0x25AB4, "pàng"},
    { 0x25AB5, "qiè"},
    { 0x25ABB, "lóng"},
    { 0x25ABC, "jǐ"},
    { 0x25AC2, "tóng"},
    { 0x25AC3, "yí"},
    { 0x25AC5, "chāng"},
    { 0x25ACB, "gōng"},
    { 0x25ACE, "dòng"},
    { 0x25AD6, "xiāng"},
    { 0x25AD9, "tǐng"},
    { 0x25ADB, "zhuān"},
    { 0x25ADC, "yǐ"},
    { 0x25ADD, "yì"},
    { 0x25ADE, "zǐ"},
    { 0x25ADF, "qǐ"},
    { 0x25AE2, "chǎ"},
    { 0x25AEC, "dùn"},
    { 0x25AEF, "chōng"},
    { 0x25AF0, "lù"},
    { 0x25AF1, "dùn"},
    { 0x25AF3, "fāng"},
    { 0x25AF4, "shì"},
    { 0x25AF5, "tì"},
    { 0x25AF6, "jī"},
    { 0x25AF7, "qiū"},
    { 0x25AF8, "shuǐ"},
    { 0x25AF9, "chén"},
    { 0x25AFC, "huàng"},
    { 0x25AFD, "shi"},
    { 0x25B00, "yún"},
    { 0x25B06, "lóng"},
    { 0x25B08, "mǎn"},
    { 0x25B09, "gōu"},
    { 0x25B0D, "xiān"},
    { 0x25B0E, "mò"},
    { 0x25B10, "shěn"},
    { 0x25B12, "pō"},
    { 0x25B13, "yào"},
    { 0x25B14, "qū"},
    { 0x25B15, "rǎn"},
    { 0x25B19, "jù"},
    { 0x25B1C, "yǐn"},
    { 0x25B1D, "bái"},
    { 0x25B1E, "niè"},
    { 0x25B20, "chōu"},
    { 0x25B2A, "róng"},
    { 0x25B2B, "chuǎn"},
    { 0x25B2C, "niè"},
    { 0x25B2D, "lì,liè"},
    { 0x25B2E, "jiāng"},
    { 0x25B2F, "kǎo"},
    { 0x25B30, "cè,zhà"},
    { 0x25B31, "chòng"},
    { 0x25B32, "zhuā,duò"},
    { 0x25B33, "zǐ"},
    { 0x25B34, "yáng"},
    { 0x25B3C, "wěn"},
    { 0x25B4B, "jì"},
    { 0x25B4C, "jì"},
    { 0x25B50, "lǜ"},
    { 0x25B51, "qiú"},
    { 0x25B52, "dùn"},
    { 0x25B53, "báo"},
    { 0x25B54, "chān"},
    { 0x25B56, "bó"},
    { 0x25B58, "chī"},
    { 0x25B59, "zhè,niè"},
    { 0x25B5A, "màng"},
    { 0x25B5C, "jì"},
    { 0x25B5D, "miào"},
    { 0x25B5E, "yuàn"},
    { 0x25B60, "wú"},
    { 0x25B61, "zhì"},
    { 0x25B62, "pīng"},
    { 0x25B65, "chōng"},
    { 0x25B6B, "mí"},
    { 0x25B6C, "féi"},
    { 0x25B6D, "cuō"},
    { 0x25B6E, "méng"},
    { 0x25B8D, "yín"},
    { 0x25B8E, "mǎng"},
    { 0x25B8F, "diǎn"},
    { 0x25B90, "diāo"},
    { 0x25B92, "qián,zhān"},
    { 0x25B95, "hàng"},
    { 0x25B96, "zhí"},
    { 0x25B97, "jú"},
    { 0x25B98, "niàn"},
    { 0x25B9C, "mí"},
    { 0x25B9D, "gǔ"},
    { 0x25BA3, "zhuā"},
    { 0x25BA4, "niè"},
    { 0x25BA5, "zhuó"},
    { 0x25BA7, "yè"},
    { 0x25BA8, "còng"},
    { 0x25BAA, "xū,jí"},
    { 0x25BAC, "xì"},
    { 0x25BAF, "bō"},
    { 0x25BBE, "cǎn,zān"},
    { 0x25BC3, "yǎn"},
    { 0x25BD1, "jǐn"},
    { 0x25BD4, "jǔ"},
    { 0x25BD5, "dàng"},
    { 0x25BD6, "dù"},
    { 0x25BD8, "yé"},
    { 0x25BD9, "jìng"},
    { 0x25BDA, "kè"},
    { 0x25BDB, "luò"},
    { 0x25BDC, "wěi"},
    { 0x25BDD, "tū"},
    { 0x25BDE, "yóu"},
    { 0x25BDF, "pài"},
    { 0x25BE1, "pí"},
    { 0x25BE2, "dìng"},
    { 0x25BE4, "wěi"},
    { 0x25BE5, "chè"},
    { 0x25BE6, "jiàn,shà"},
    { 0x25BE8, "sī"},
    { 0x25BE9, "zhuó"},
    { 0x25BEA, "sòu"},
    { 0x25BEC, "ruǎn"},
    { 0x25BEE, "yú"},
    { 0x25BF3, "è"},
    { 0x25BF6, "kǔ"},
    { 0x25BF8, "zhù"},
    { 0x25BFE, "xiá"},
    { 0x25C1B, "fú"},
    { 0x25C1C, "táo"},
    { 0x25C1D, "xī"},
    { 0x25C1E, "chōu,sǒu"},
    { 0x25C1F, "yuán"},
    { 0x25C20, "lǘ"},
    { 0x25C21, "cè"},
    { 0x25C22, "shàn"},
    { 0x25C23, "liú"},
    { 0x25C25, "xì"},
    { 0x25C26, "jī"},
    { 0x25C27, "yǐ"},
    { 0x25C28, "tán"},
    { 0x25C2A, "hú"},
    { 0x25C2D, "cuō,zhǎ,cī"},
    { 0x25C2E, "gě"},
    { 0x25C30, "shì,shé"},
    { 0x25C31, "sāo"},
    { 0x25C32, "hòng"},
    { 0x25C33, "xiàn"},
    { 0x25C36, "xiá"},
    { 0x25C3B, "mù"},
    { 0x25C3C, "suǒ"},
    { 0x25C3E, "zhài"},
    { 0x25C40, "fū"},
    { 0x25C41, "sè"},
    { 0x25C42, "nú"},
    { 0x25C43, "yì"},
    { 0x25C67, "qín"},
    { 0x25C68, "qìng"},
    { 0x25C75, "huì,suì,xí"},
    { 0x25C76, "shuǎng"},
    { 0x25C77, "dǎn"},
    { 0x25C78, "ōu"},
    { 0x25C79, "mò"},
    { 0x25C7A, "qiān"},
    { 0x25C7B, "chì,tú"},
    { 0x25C7C, "pái,pì"},
    { 0x25C7D, "juàn"},
    { 0x25C80, "cháo"},
    { 0x25C81, "liè"},
    { 0x25C82, "bīng"},
    { 0x25C83, "kòu"},
    { 0x25C84, "dàn"},
    { 0x25C85, "chóu"},
    { 0x25C86, "tōng"},
    { 0x25C87, "dàn"},
    { 0x25C88, "mǎn"},
    { 0x25C89, "hù"},
    { 0x25C8A, "liáo"},
    { 0x25C8B, "xián"},
    { 0x25C8D, "cáo"},
    { 0x25C8E, "lù"},
    { 0x25C8F, "chuàn"},
    { 0x25C90, "wú"},
    { 0x25C91, "mán"},
    { 0x25C95, "zǐ"},
    { 0x25C97, "dù"},
    { 0x25C9A, "shuàng"},
    { 0x25C9B, "fù"},
    { 0x25C9C, "jù"},
    { 0x25C9D, "zhòu"},
    { 0x25C9F, "diào"},
    { 0x25CA0, "wàng"},
    { 0x25CA1, "chuāng"},
    { 0x25CA2, "qiān"},
    { 0x25CA3, "tuì"},
    { 0x25CA5, "lián"},
    { 0x25CA6, "biāo"},
    { 0x25CA7, "lí"},
    { 0x25CAA, "lí"},
    { 0x25CC6, "bì"},
    { 0x25CC7, "fù"},
    { 0x25CC8, "cuì"},
    { 0x25CC9, "dū"},
    { 0x25CCB, "zàn,zān"},
    { 0x25CCC, "lóng"},
    { 0x25CCD, "xún"},
    { 0x25CCE, "qióng"},
    { 0x25CCF, "jī"},
    { 0x25CD0, "qiǎn"},
    { 0x25CD2, "jiǎn"},
    { 0x25CD3, "shāo"},
    { 0x25CD4, "duò"},
    { 0x25CD5, "shū"},
    { 0x25CD6, "bù"},
    { 0x25CD7, "xū"},
    { 0x25CD8, "dǒng"},
    { 0x25CDA, "rán"},
    { 0x25CDC, "yáng"},
    { 0x25CDD, "ruǐ"},
    { 0x25CDE, "lìn"},
    { 0x25CDF, "jiǎn"},
    { 0x25CE0, "dì"},
    { 0x25CE1, "fén"},
    { 0x25CE2, "diàn"},
    { 0x25CE3, "zuì"},
    { 0x25CE5, "nǐng"},
    { 0x25CEA, "suàn"},
    { 0x25CEB, "tiǎn"},
    { 0x25CEC, "àn"},
    { 0x25CEF, "cè"},
    { 0x25CF0, "dìng"},
    { 0x25CF1, "shēn"},
    { 0x25CF2, "dù"},
    { 0x25CF3, "tí"},
    { 0x25CF4, "jiǎo"},
    { 0x25CF5, "zuì"},
    { 0x25CF6, "zhǎng"},
    { 0x25CF7, "jiǎn"},
    { 0x25CF8, "dàn"},
    { 0x25CF9, "dǎn"},
    { 0x25CFA, "sǒng"},
    { 0x25D10, "zhǎn"},
    { 0x25D11, "tíng"},
    { 0x25D12, "zhì"},
    { 0x25D15, "yóu"},
    { 0x25D16, "pái"},
    { 0x25D21, "lǐ"},
    { 0x25D24, "qián"},
    { 0x25D26, "suì,dí"},
    { 0x25D27, "jǔ"},
    { 0x25D28, "ài"},
    { 0x25D29, "gé"},
    { 0x25D2A, "jù"},
    { 0x25D2B, "tún,diàn"},
    { 0x25D2C, "bì"},
    { 0x25D2D, "qià"},
    { 0x25D2E, "bó"},
    { 0x25D2F, "huì"},
    { 0x25D31, "jiàn"},
    { 0x25D34, "gōu"},
    { 0x25D35, "suàn"},
    { 0x25D3A, "cí"},
    { 0x25D3B, "qiàng"},
    { 0x25D3F, "yán"},
    { 0x25D4F, "diàn"},
    { 0x25D52, "miè"},
    { 0x25D5C, "pò"},
    { 0x25D5D, "lǐng"},
    { 0x25D5E, "jié"},
    { 0x25D5F, "zhù"},
    { 0x25D60, "gǔ"},
    { 0x25D63, "duān"},
    { 0x25D64, "zhào"},
    { 0x25D66, "shǎo"},
    { 0x25D67, "qǐn"},
    { 0x25D68, "mí"},
    { 0x25D6A, "píng"},
    { 0x25D6B, "cóng"},
    { 0x25D6C, "chōu"},
    { 0x25D6F, "sà"},
    { 0x25D76, "tiǎn"},
    { 0x25D85, "liú"},
    { 0x25D86, "lǘ"},
    { 0x25D87, "lǔ"},
    { 0x25D88, "zōu"},
    { 0x25D8C, "lǜ"},
    { 0x25D8D, "huǎn"},
    { 0x25D8F, "tiáo"},
    { 0x25D90, "tuí"},
    { 0x25D91, "qiǎng"},
    { 0x25D92, "lìn"},
    { 0x25D93, "bēi"},
    { 0x25D94, "páo"},
    { 0x25D95, "zhān"},
    { 0x25D97, "lì"},
    { 0x25D9B, "tí"},
    { 0x25D9C, "hú"},
    { 0x25DA2, "liè"},
    { 0x25DB5, "huǐ"},
    { 0x25DB6, "qū"},
    { 0x25DB7, "xuǎn"},
    { 0x25DB9, "jìng"},
    { 0x25DBA, "dié"},
    { 0x25DBB, "suí"},
    { 0x25DBD, "wèi"},
    { 0x25DBF, "yán"},
    { 0x25DC0, "yān"},
    { 0x25DC1, "bàn"},
    { 0x25DC3, "jiǎng"},
    { 0x25DC4, "nǐ"},
    { 0x25DC5, "lì"},
    { 0x25DC6, "hú"},
    { 0x25DC7, "qì"},
    { 0x25DC8, "zhōng"},
    { 0x25DD1, "bì"},
    { 0x25DD4, "yú"},
    { 0x25DD5, "dié"},
    { 0x25DD6, "lìn"},
    { 0x25DD7, "lì"},
    { 0x25DD8, "zhuó"},
    { 0x25DD9, "jì"},
    { 0x25DDA, "jū"},
    { 0x25DDC, "fēng"},
    { 0x25DDE, "yù"},
    { 0x25DE8, "liè"},
    { 0x25DE9, "zá"},
    { 0x25DEA, "qián"},
    { 0x25DEB, "jiē"},
    { 0x25DEC, "guān"},
    { 0x25DEE, "zhuó,zhāo"},
    { 0x25DF1, "fù"},
    { 0x25DF9, "sè"},
    { 0x25DFC, "cù"},
    { 0x25E03, "huǐ"},
    { 0x25E08, "dàng"},
    { 0x25E09, "lóng"}
};
