/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     chenhaifeng  <chenhaifeng@uniontech.com>
*
* Maintainer: chenhaifeng  <chenhaifeng@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "pinyindict.h"

QMap<int, QString> PinyinDict_20{
    { 0x288C8, "kuì"},
    { 0x288CD, "shē"},
    { 0x288D4, "chěn"},
    { 0x288D5, "tǎn"},
    { 0x288D7, "hú"},
    { 0x288D8, "méng"},
    { 0x288D9, "pào"},
    { 0x288DA, "zhǎn"},
    { 0x288DB, "cháng"},
    { 0x288DD, "gǎn,jiǎn"},
    { 0x288E0, "yì"},
    { 0x288E2, "suì"},
    { 0x288E6, "xù"},
    { 0x288E7, "jì"},
    { 0x288E8, "làn"},
    { 0x288EC, "yí"},
    { 0x288EF, "mì"},
    { 0x288F1, "miè"},
    { 0x288F5, "cuán"},
    { 0x288F8, "lǎn"},
    { 0x288FB, "yān,yǎn"},
    { 0x288FE, "mí"},
    { 0x28902, "yǒng"},
    { 0x28903, "cáng,zā"},
    { 0x28904, "jiǎn"},
    { 0x28907, "sōu,zāo"},
    { 0x2890E, "yán"},
    { 0x28911, "juàn"},
    { 0x28915, "è"},
    { 0x28918, "fèn"},
    { 0x2891A, "fèn"},
    { 0x28921, "guàng"},
    { 0x28922, "mái"},
    { 0x28924, "liě"},
    { 0x28929, "chōng"},
    { 0x2892B, "lí"},
    { 0x28931, "zhí"},
    { 0x28934, "xiè"},
    { 0x28937, "chóu"},
    { 0x28939, "jí"},
    { 0x2893D, "pī"},
    { 0x28942, "jié"},
    { 0x28947, "zhǒu,zhù"},
    { 0x2894D, "xiōng"},
    { 0x28951, "kuàng,gǒng"},
    { 0x28959, "jǐng"},
    { 0x2895B, "hù"},
    { 0x2895E, "qián"},
    { 0x28963, "cén"},
    { 0x28966, "qí"},
    { 0x28967, "wǎn,fàn,biān"},
    { 0x28968, "máo"},
    { 0x2896A, "dǒu"},
    { 0x28974, "kǒu"},
    { 0x28976, "dài"},
    { 0x28978, "náo"},
    { 0x2897A, "hóng"},
    { 0x28982, "lǎi"},
    { 0x28983, "duǒ,duò"},
    { 0x28984, "qiān"},
    { 0x28986, "yín"},
    { 0x28996, "lòu"},
    { 0x28997, "huī"},
    { 0x2899B, "fù"},
    { 0x2899C, "máo"},
    { 0x2899E, "zhōu"},
    { 0x289A1, "yóng,yáng"},
    { 0x289AD, "láo"},
    { 0x289AE, "jí"},
    { 0x289AF, "yì"},
    { 0x289B0, "liú"},
    { 0x289B1, "cōng"},
    { 0x289B3, "nǎn"},
    { 0x289D0, "tūn"},
    { 0x289D1, "xiàng"},
    { 0x289D5, "biàn"},
    { 0x289D6, "chuáng"},
    { 0x289D7, "wù"},
    { 0x289D9, "jū"},
    { 0x289E5, "xiē"},
    { 0x289E6, "pī"},
    { 0x289E7, "zhuó"},
    { 0x289E8, "ruì,zhuì"},
    { 0x289EA, "sào"},
    { 0x289EB, "zì"},
    { 0x289ED, "zhèng"},
    { 0x289F0, "zú"},
    { 0x289F1, "qū"},
    { 0x289F3, "chì"},
    { 0x289F5, "zhì"},
    { 0x28A17, "quàn"},
    { 0x28A18, "qiān"},
    { 0x28A19, "yā"},
    { 0x28A1A, "chào"},
    { 0x28A1B, "hé"},
    { 0x28A1C, "rǔ"},
    { 0x28A20, "jū"},
    { 0x28A21, "wù"},
    { 0x28A2C, "chì"},
    { 0x28A2D, "kuàng,gǒng"},
    { 0x28A2F, "còu,zhòu"},
    { 0x28A30, "ruàn"},
    { 0x28A31, "kuò"},
    { 0x28A32, "chí"},
    { 0x28A33, "zú"},
    { 0x28A34, "jiāo"},
    { 0x28A36, "yú"},
    { 0x28A37, "tú"},
    { 0x28A38, "méng"},
    { 0x28A39, "dā"},
    { 0x28A3A, "shuò,xuē"},
    { 0x28A65, "fēng"},
    { 0x28A66, "gǒu"},
    { 0x28A67, "dōng"},
    { 0x28A68, "chǎ"},
    { 0x28A69, "mào"},
    { 0x28A6A, "chǎn"},
    { 0x28A6B, "biān"},
    { 0x28A6C, "yù"},
    { 0x28A6F, "wán"},
    { 0x28A70, "zú"},
    { 0x28A72, "zī"},
    { 0x28A74, "chuān"},
    { 0x28A75, "wǎn"},
    { 0x28A76, "wā"},
    { 0x28A78, "quān,juān"},
    { 0x28A7B, "wǎn"},
    { 0x28A7D, "xià"},
    { 0x28A84, "yìng"},
    { 0x28A85, "jiàn"},
    { 0x28A88, "wěi"},
    { 0x28A89, "tí"},
    { 0x28A8A, "sāo"},
    { 0x28A8C, "qí"},
    { 0x28A8D, "shā"},
    { 0x28A8E, "yù"},
    { 0x28A8F, "jí"},
    { 0x28A90, "dòu,tōu"},
    { 0x28A91, "chǎn"},
    { 0x28A92, "tuán"},
    { 0x28A95, "liú"},
    { 0x28A97, "zhuì"},
    { 0x28AB3, "ruàn"},
    { 0x28AB6, "yàn"},
    { 0x28AB7, "gǔ"},
    { 0x28AB9, "lì"},
    { 0x28ABA, "chā"},
    { 0x28ABE, "dì"},
    { 0x28ABF, "liú"},
    { 0x28AC0, "zhǎn"},
    { 0x28AC1, "pō"},
    { 0x28AD2, "lòu"},
    { 0x28AD4, "zhì,xiè"},
    { 0x28B01, "lián"},
    { 0x28B05, "luǒ"},
    { 0x28B0D, "duò,duì"},
    { 0x28B10, "jué"},
    { 0x28B11, "lì"},
    { 0x28B12, "lán"},
    { 0x28B14, "ruàn"},
    { 0x28B15, "gū"},
    { 0x28B16, "chán"},
    { 0x28B17, "xū"},
    { 0x28B1A, "zhǐ"},
    { 0x28B41, "xuè"},
    { 0x28B42, "bō"},
    { 0x28B43, "chēng"},
    { 0x28B45, "zhù"},
    { 0x28B46, "hēi"},
    { 0x28B49, "bān"},
    { 0x28B53, "dié"},
    { 0x28B56, "zhǎn"},
    { 0x28B57, "guó"},
    { 0x28B5A, "biāo"},
    { 0x28B5B, "là,gě"},
    { 0x28B7A, "jīn"},
    { 0x28B82, "gǎi"},
    { 0x28B92, "mèng"},
    { 0x28B94, "yù"},
    { 0x28BAA, "xǐ"},
    { 0x28BAC, "piāo"},
    { 0x28BAD, "sī"},
    { 0x28BB4, "dèng"},
    { 0x28BB8, "chuō"},
    { 0x28BB9, "dí"},
    { 0x28BBA, "jī"},
    { 0x28BBB, "chán"},
    { 0x28BBF, "zhuó"},
    { 0x28BD3, "cài"},
    { 0x28BDE, "jiàng"},
    { 0x28BF2, "tóu"},
    { 0x28BFD, "lí"},
    { 0x28C02, "qiàn"},
    { 0x28C06, "chuō"},
    { 0x28C0F, "tà"},
    { 0x28C11, "diào"},
    { 0x28C13, "jiǎn"},
    { 0x28C1B, "zhǐ"},
    { 0x28C1C, "jué"},
    { 0x28C1E, "mó"},
    { 0x28C20, "luó"},
    { 0x28C26, "bǎo"},
    { 0x28C2D, "zuǎn"},
    { 0x28C35, "zhē"},
    { 0x28C38, "yú"},
    { 0x28C3B, "bǎo"},
    { 0x28C3E, "mǎ"},
    { 0x28C3F, "xì"},
    { 0x28C40, "hù"},
    { 0x28C41, "yì"},
    { 0x28C42, "é"},
    { 0x28C43, "gū"},
    { 0x28C44, "tú"},
    { 0x28C45, "zhēn"},
    { 0x28C47, "qiú"},
    { 0x28C48, "sù"},
    { 0x28C49, "liàng"},
    { 0x28C4A, "qū"},
    { 0x28C4B, "líng"},
    { 0x28C4C, "guàn"},
    { 0x28C4D, "láng"},
    { 0x28C4E, "tōu"},
    { 0x28C4F, "dā"},
    { 0x28C50, "lòu"},
    { 0x28C51, "huáng"},
    { 0x28C52, "shòu"},
    { 0x28C53, "jiāo"},
    { 0x28C54, "zūn"},
    { 0x28C55, "gǎi"},
    { 0x28C56, "wéi"},
    { 0x28C59, "kūn"},
    { 0x28C5A, "duàn"},
    { 0x28C5B, "sōng"},
    { 0x28C5C, "qí"},
    { 0x28C5D, "yǎng"},
    { 0x28C61, "shì"},
    { 0x28C63, "gǎi"},
    { 0x28C66, "dào"},
    { 0x28C67, "yǎo,ǎo"},
    { 0x28C6B, "qián"},
    { 0x28C6D, "shāo"},
    { 0x28C6E, "cháng"},
    { 0x28C6F, "miǔ"},
    { 0x28C71, "mó"},
    { 0x28C75, "nǎo"},
    { 0x28C78, "cōng"},
    { 0x28C7A, "niè"},
    { 0x28C7B, "zhāo"},
    { 0x28C7C, "cén"},
    { 0x28C7F, "sōng"},
    { 0x28C80, "niè"},
    { 0x28C81, "cì"},
    { 0x28C84, "jùn"},
    { 0x28C86, "shāo"},
    { 0x28C88, "zhú"},
    { 0x28C89, "duǒ,tuǒ,shèng"},
    { 0x28C8A, "àn"},
    { 0x28C8B, "bī"},
    { 0x28C8E, "tì"},
    { 0x28C90, "pǐ"},
    { 0x28C91, "xiá"},
    { 0x28C92, "qiú"},
    { 0x28C93, "shěng"},
    { 0x28C97, "tāng"},
    { 0x28C9B, "mán,mián"},
    { 0x28C9C, "piān"},
    { 0x28C9E, "tì"},
    { 0x28C9F, "róng"},
    { 0x28CA7, "cōng"},
    { 0x28CAA, "jī"},
    { 0x28CAB, "féng"},
    { 0x28CAC, "wù"},
    { 0x28CAD, "jiào"},
    { 0x28CAE, "láo"},
    { 0x28CAF, "zēng"},
    { 0x28CB0, "péng"},
    { 0x28CB1, "cǎn"},
    { 0x28CB3, "nóng"},
    { 0x28CB5, "chǎn"},
    { 0x28CBE, "mán,mián"},
    { 0x28CBF, "guì"},
    { 0x28CC0, "niào"},
    { 0x28CC1, "chōng"},
    { 0x28CC2, "chàn"},
    { 0x28CC6, "nàng"},
    { 0x28CC9, "xiā"},
    { 0x28CCA, "jiū"},
    { 0x28CCB, "jǐ"},
    { 0x28CCC, "zhèn"},
    { 0x28CD1, "tǐng"},
    { 0x28CD4, "mén"},
    { 0x28CD5, "yuè"},
    { 0x28CD7, "zhōng"},
    { 0x28CD8, "tún"},
    { 0x28CD9, "ruì"},
    { 0x28CDA, "xiè,fēn"},
    { 0x28CDB, "xī"},
    { 0x28CDD, "tǐng,rùn"},
    { 0x28CDE, "niǔ"},
    { 0x28CE0, "wǎng"},
    { 0x28CE1, "jiān,guān"},
    { 0x28CE3, "fēn"},
    { 0x28CF2, "biàn,bì"},
    { 0x28CF7, "yí"},
    { 0x28CFA, "dié"},
    { 0x28CFB, "jī"},
    { 0x28CFC, "gǎn"},
    { 0x28CFF, "jiān,xì,mǎ"},
    { 0x28D00, "jiōng"},
    { 0x28D06, "kāi"},
    { 0x28D0A, "què,guān"},
    { 0x28D0C, "nán"},
    { 0x28D0D, "móu"},
    { 0x28D0E, "xù"},
    { 0x28D0F, "sǒng"},
    { 0x28D10, "shèn"},
    { 0x28D11, "kuāng"},
    { 0x28D12, "què"},
    { 0x28D13, "wéi"},
    { 0x28D17, "dié"},
    { 0x28D18, "nán"},
    { 0x28D1A, "ruò"},
    { 0x28D1B, "gōng"},
    { 0x28D1C, "dòu,yòu"},
    { 0x28D1E, "niǎn"},
    { 0x28D21, "chāo"},
    { 0x28D22, "hé"},
    { 0x28D23, "yàn"},
    { 0x28D29, "tú"},
    { 0x28D2A, "bǔ"},
    { 0x28D2C, "hú"},
    { 0x28D2D, "yǒng"},
    { 0x28D2F, "shǐ"},
    { 0x28D30, "chù"},
    { 0x28D39, "xiāo"},
    { 0x28D3A, "mén"},
    { 0x28D3B, "lǐ"},
    { 0x28D3C, "tí"},
    { 0x28D3E, "jiān"},
    { 0x28D42, "zhǐ"},
    { 0x28D43, "guā,fǔ,yuè"},
    { 0x28D44, "guǎn"},
    { 0x28D46, "qì"},
    { 0x28D48, "fēi"},
    { 0x28D49, "yǔ"},
    { 0x28D4A, "zhé"},
    { 0x28D4B, "wěi"},
    { 0x28D4C, "ě"},
    { 0x28D4D, "chān"},
    { 0x28D4E, "xī,qí"},
    { 0x28D50, "gǔ"},
    { 0x28D57, "què"},
    { 0x28D58, "huì"},
    { 0x28D5A, "xié"},
    { 0x28D5B, "yīng"},
    { 0x28D5D, "tà"},
    { 0x28D5E, "wāi"},
    { 0x28D5F, "fú"},
    { 0x28D60, "jiè"},
    { 0x28D61, "pì"},
    { 0x28D65, "shěng"},
    { 0x28D66, "yú"},
    { 0x28D67, "kuā"},
    { 0x28D69, "pì"},
    { 0x28D6A, "xié"},
    { 0x28D6B, "nüè"},
    { 0x28D6C, "xiàn"},
    { 0x28D6D, "jiàn"},
    { 0x28D6E, "xù"},
    { 0x28D70, "bì"},
    { 0x28D74, "nán"},
    { 0x28D76, "liáng"},
    { 0x28D78, "pián"},
    { 0x28D7C, "jìng"},
    { 0x28D80, "tǎ"},
    { 0x28D81, "yàn"},
    { 0x28D82, "ài"},
    { 0x28D85, "xiāo"},
    { 0x28D86, "qiāng"},
    { 0x28D87, "wǔ"},
    { 0x28D88, "táng"},
    { 0x28D8A, "jùn"},
    { 0x28D90, "kuò"},
    { 0x28D97, "làng"},
    { 0x28D99, "něng"},
    { 0x28D9C, "dòu,dǒu"},
    { 0x28D9D, "shú"},
    { 0x28D9F, "jiǎo"},
    { 0x28DA0, "niè"},
    { 0x28DA2, "yú"},
    { 0x28DA8, "cè"},
    { 0x28DAA, "jiǎo,liú"},
    { 0x28DAC, "huà"},
    { 0x28DAD, "wén"},
    { 0x28DAE, "yē"},
    { 0x28DAF, "é"},
    { 0x28DB0, "guāng"},
    { 0x28DB1, "huā"},
    { 0x28DB2, "jiāo"},
    { 0x28DBA, "lèi"},
    { 0x28DBC, "shāng"},
    { 0x28DBD, "yòng"},
    { 0x28DBF, "dēng"},
    { 0x28DC0, "guān"},
    { 0x28DC1, "niú"},
    { 0x28DC3, "suì"},
    { 0x28DC4, "xiàng"},
    { 0x28DC6, "sà"},
    { 0x28DC7, "chāng"},
    { 0x28DCE, "rùn"},
    { 0x28DD0, "yūn"},
    { 0x28DD2, "fēn"},
    { 0x28DD3, "jiàn"},
    { 0x28DD4, "xù"},
    { 0x28DD8, "xì"},
    { 0x28DD9, "shú"},
    { 0x28DE5, "xié"},
    { 0x28DE6, "lì"},
    { 0x28DE9, "tóu"},
    { 0x28DEC, "mǐ"},
    { 0x28DED, "chán"},
    { 0x28DEE, "huō"},
    { 0x28DF1, "zhuǎn"},
    { 0x28DF2, "yuè"},
    { 0x28DFB, "lán"},
    { 0x28DFD, "yán"},
    { 0x28DFE, "dàng"},
    { 0x28DFF, "xiàng"},
    { 0x28E00, "yuè"},
    { 0x28E01, "tǐng"},
    { 0x28E02, "bēng"},
    { 0x28E03, "sàn"},
    { 0x28E04, "xiàn"},
    { 0x28E05, "dié"},
    { 0x28E06, "pì"},
    { 0x28E07, "pián"},
    { 0x28E09, "tǎ"},
    { 0x28E0B, "jiāo"},
    { 0x28E0C, "yē"},
    { 0x28E0E, "yuè"},
    { 0x28E10, "réng"},
    { 0x28E11, "qiǎo"},
    { 0x28E12, "qí"},
    { 0x28E13, "diāo"},
    { 0x28E14, "qí,wéi"},
    { 0x28E17, "hàn"},
    { 0x28E18, "yuán"},
    { 0x28E19, "yóu"},
    { 0x28E1A, "jí"},
    { 0x28E1B, "gài"},
    { 0x28E1C, "hāi"},
    { 0x28E1D, "shì"},
    { 0x28E1F, "qū"},
    { 0x28E29, "wèn"},
    { 0x28E2C, "zhèn"},
    { 0x28E2D, "pō"},
    { 0x28E2E, "yán,yǔn"},
    { 0x28E2F, "gū"},
    { 0x28E30, "jú"},
    { 0x28E31, "tiàn,niǎn"},
    { 0x28E37, "è"},
    { 0x28E3A, "yā"},
    { 0x28E3B, "lìn"},
    { 0x28E3C, "bì"},
    { 0x28E40, "zǐ"},
    { 0x28E41, "hóng"},
    { 0x28E43, "duǒ,duò"},
    { 0x28E45, "duì"},
    { 0x28E46, "xuàn"},
    { 0x28E48, "shǎn,yáng"},
    { 0x28E4A, "shǎn"},
    { 0x28E4B, "yáo"},
    { 0x28E4C, "rǎn"},
    { 0x28E54, "tuó"},
    { 0x28E57, "bīng"},
    { 0x28E58, "xù"},
    { 0x28E59, "tūn"},
    { 0x28E5A, "chéng"},
    { 0x28E5C, "dòu"},
    { 0x28E5D, "yì,yà"},
    { 0x28E61, "chè"},
    { 0x28E75, "juǎn"},
    { 0x28E76, "jī"},
    { 0x28E78, "zhào"},
    { 0x28E79, "bēng,bèng"},
    { 0x28E7B, "tiǎn"},
    { 0x28E80, "pēng"},
    { 0x28E85, "fù"},
    { 0x28E96, "tuǒ"},
    { 0x28E98, "xián"},
    { 0x28E99, "nì"},
    { 0x28E9A, "lóng"},
    { 0x28E9D, "zhuó"},
    { 0x28E9F, "zhēng"},
    { 0x28EA0, "shǔn"},
    { 0x28EA1, "zōng"},
    { 0x28EA2, "fēng"},
    { 0x28EA3, "duàn"},
    { 0x28EA4, "pì"},
    { 0x28EA5, "yǎn"},
    { 0x28EA6, "sǒu"},
    { 0x28EA7, "qiú"},
    { 0x28EA8, "è"},
    { 0x28EA9, "qián"},
    { 0x28EAB, "qiǎn"},
    { 0x28EAD, "cā"},
    { 0x28EAE, "xùn"},
    { 0x28EB5, "zhuì"},
    { 0x28EB8, "mǎo"},
    { 0x28EB9, "jiǎo"},
    { 0x28EBF, "zhǎn"},
    { 0x28EC0, "pí,bī"},
    { 0x28EC1, "xī"},
    { 0x28EC2, "yàn"},
    { 0x28EC3, "fèi"},
    { 0x28EC4, "niè"},
    { 0x28EC6, "zhì"},
    { 0x28EC8, "suǒ"},
    { 0x28ECA, "yì"},
    { 0x28ECC, "lěi"},
    { 0x28ECD, "xù"},
    { 0x28ECF, "yì"},
    { 0x28ED2, "wēi"},
    { 0x28ED5, "jī"},
    { 0x28ED6, "chēn"},
    { 0x28ED7, "dié"},
    { 0x28EE3, "yuán"},
    { 0x28EE5, "xí"},
    { 0x28EE7, "liú"},
    { 0x28EE8, "suǒ"},
    { 0x28EF1, "bēng"},
    { 0x28EF2, "xià"},
    { 0x28EF3, "yàn,yān"},
    { 0x28EF5, "cuī,zuī,duì"},
    { 0x28EF7, "kāng"},
    { 0x28EFA, "qīng"},
    { 0x28EFB, "lóu"},
    { 0x28EFC, "bī"},
    { 0x28F08, "zhàn"},
    { 0x28F09, "cuàn"},
    { 0x28F0A, "wú"},
    { 0x28F0B, "xū"},
    { 0x28F0C, "chēn"},
    { 0x28F0D, "háo"},
    { 0x28F0E, "jué"},
    { 0x28F10, "chèn"},
    { 0x28F11, "chá"},
    { 0x28F12, "chǎn"},
    { 0x28F13, "zhí"},
    { 0x28F14, "xún"},
    { 0x28F23, "gé"},
    { 0x28F24, "chén"},
    { 0x28F25, "yè,gé"},
    { 0x28F2A, "chǔ"},
    { 0x28F2B, "qú"},
    { 0x28F2C, "xiè"},
    { 0x28F2E, "zhàn"},
    { 0x28F2F, "kěn"},
    { 0x28F31, "jué"},
    { 0x28F3D, "qú"},
    { 0x28F3F, "méng"},
    { 0x28F40, "yè"},
    { 0x28F41, "zōu,cóng"},
    { 0x28F42, "pú"},
    { 0x28F44, "shì"},
    { 0x28F49, "shǔ"},
    { 0x28F4A, "chán"},
    { 0x28F4D, "dú"},
    { 0x28F4F, "guō"},
    { 0x28F50, "lù,yáng"},
    { 0x28F51, "yān"},
    { 0x28F56, "niǎo"},
    { 0x28F57, "bīn,pín"},
    { 0x28F5F, "tuí"},
    { 0x28F66, "nì"},
    { 0x28F67, "huān"},
    { 0x28F68, "qián"},
    { 0x28F6F, "xià"},
    { 0x28F72, "líng"},
    { 0x28F77, "lián"},
    { 0x28F79, "yì,lì"},
    { 0x28F7B, "lì"},
    { 0x28F7C, "sì"},
    { 0x28F7F, "dài"},
    { 0x28F82, "wèi"},
    { 0x28F85, "cì"},
    { 0x28F89, "jiǔ"},
    { 0x28F8A, "hóng"},
    { 0x28F8C, "yú"},
    { 0x28F8E, "kuí"},
    { 0x28F92, "háng"},
    { 0x28F93, "gē,yì"},
    { 0x28F94, "fàng"},
    { 0x28F97, "kuí,xié"},
    { 0x28F9A, "guī,fū"},
    { 0x28F9B, "chǐ,qí"},
    { 0x28F9E, "jiǔ"},
    { 0x28FA1, "suī,huǎng"},
    { 0x28FA4, "dié"},
    { 0x28FAC, "suǐ"},
    { 0x28FB0, "qín"},
    { 0x28FB4, "guī"},
    { 0x28FBB, "zhuī"},
    { 0x28FBE, "tiào"},
    { 0x28FC1, "yuè"},
    { 0x28FC7, "zuǐ"},
    { 0x28FCF, "wú"},
    { 0x28FD0, "cuǐ"},
    { 0x28FDB, "zhì,xī"},
    { 0x28FE0, "shuì"},
    { 0x28FE2, "dōng"},
    { 0x28FED, "wéi"},
    { 0x28FFF, "chǒng"},
    { 0x2900B, "rún"},
    { 0x29016, "jí"},
    { 0x2901C, "diāo"},
    { 0x2901E, "cāng"},
    { 0x29020, "kòu,gǔ"},
    { 0x29023, "wéi"},
    { 0x29027, "cán"},
    { 0x2902A, "má"},
    { 0x2902B, "òu"},
    { 0x29032, "sǎn"},
    { 0x29036, "wéi,huī,mí"},
    { 0x2903C, "sǎn"},
    { 0x2903F, "jīn"},
    { 0x2904C, "wéi"},
    { 0x2905E, "cài"},
    { 0x2905F, "lí"},
    { 0x2906F, "yuè"},
    { 0x29074, "yūn"},
    { 0x29077, "chēng"},
    { 0x2907A, "shān"},
    { 0x29082, "hū"},
    { 0x29083, "shài"},
    { 0x29084, "tún"},
    { 0x29086, "fǒu,fù"},
    { 0x29088, "qìn"},
    { 0x29089, "xū,chēn"},
    { 0x2908D, "chuān"},
    { 0x2908E, "fù"},
    { 0x29092, "yì,ài"},
    { 0x29093, "dōng"},
    { 0x29094, "fú"},
    { 0x29095, "fú"},
    { 0x29096, "zé"},
    { 0x29097, "pù"},
    { 0x29099, "líng"},
    { 0x2909D, "shài,yīng"},
    { 0x2909E, "pào"},
    { 0x290A2, "yín,ái"},
    { 0x290A3, "luò"},
    { 0x290A4, "huà"},
    { 0x290A5, "yìn"},
    { 0x290A6, "bèng"},
    { 0x290A7, "yū"},
    { 0x290A8, "shè"},
    { 0x290AA, "xiè"},
    { 0x290AB, "chǔ"},
    { 0x290B4, "shè"},
    { 0x290B5, "diàn"},
    { 0x290B9, "yì"},
    { 0x290BB, "chè"},
    { 0x290BC, "gěng"},
    { 0x290BD, "lóng"},
    { 0x290BE, "píng"},
    { 0x290BF, "yǔn"},
    { 0x290C0, "yàn"},
    { 0x290C1, "mò"},
    { 0x290C3, "suī"},
    { 0x290CB, "jìng"},
    { 0x290CD, "sòng"},
    { 0x290CE, "páng"},
    { 0x290D0, "yá"},
    { 0x290D1, "sè"},
    { 0x290D2, "duǒ"},
    { 0x290D5, "chuáng"},
    { 0x290D6, "xiè"},
    { 0x290D8, "tuán"},
    { 0x290D9, "gōng"},
    { 0x290DA, "xuàn"},
    { 0x290DC, "lā"},
    { 0x290DE, "líng"},
    { 0x290E0, "dài"},
    { 0x290E1, "zhá"},
    { 0x290EC, "yīn"},
    { 0x290ED, "sōng"},
    { 0x290EF, "yǔ"},
    { 0x290F0, "tuó"},
    { 0x290F1, "tuó"},
    { 0x290F4, "bà"},
    { 0x290F5, "rǎn"},
    { 0x290F6, "bó"},
    { 0x290F7, "dài"},
    { 0x290F9, "zhá,zhǎ"},
    { 0x290FA, "hóu"},
    { 0x290FE, "huǐ"},
    { 0x29105, "lú"},
    { 0x2910A, "lìng"},
    { 0x2910B, "rú"},
    { 0x29115, "dàn"},
    { 0x29116, "méng"},
    { 0x29117, "xià"},
    { 0x29118, "wěng"},
    { 0x29119, "hán"},
    { 0x2911A, "zī"},
    { 0x2911B, "zhèn"},
    { 0x2911C, "sè"},
    { 0x2911D, "cuó"},
    { 0x2911E, "lì"},
    { 0x29120, "diān"},
    { 0x29121, "lián"},
    { 0x29122, "gòu"},
    { 0x29126, "péng"},
    { 0x2912A, "yīng"},
    { 0x2912C, "hòu"},
    { 0x2912E, "duì"},
    { 0x2912F, "wù"},
    { 0x29137, "piào"},
    { 0x29138, "hè"},
    { 0x2913A, "lóng"},
    { 0x2913B, "mò"},
    { 0x2913C, "fěi"},
    { 0x2913D, "lǚ"},
    { 0x2913E, "zé"},
    { 0x2913F, "bó"},
    { 0x29140, "diàn,zhí"},
    { 0x29141, "mǎng"},
    { 0x29143, "zhuàng,chóng"},
    { 0x29144, "lù"},
    { 0x29145, "pāng"},
    { 0x29146, "duì"},
    { 0x29147, "bù"},
    { 0x2914C, "chēn"},
    { 0x2914D, "màn"},
    { 0x29156, "xī"},
    { 0x2915D, "ǎn"},
    { 0x2915E, "zhōng,chòng"},
    { 0x29160, "nàn"},
    { 0x29161, "tuò"},
    { 0x29162, "hé"},
    { 0x29165, "duì"},
    { 0x29166, "wān,dān"},
    { 0x29167, "zhōng"},
    { 0x29168, "cén,shèn"},
    { 0x29169, "lì"},
    { 0x2916A, "shuāng"},
    { 0x2916E, "cén"},
    { 0x29170, "sī"},
    { 0x29172, "duì"},
    { 0x29174, "hūn"},
    { 0x2917C, "jiān,jiàn"},
    { 0x2917D, "nóng"},
    { 0x2917E, "dàn"},
    { 0x2917F, "fù"},
    { 0x29180, "huò"},
    { 0x29181, "huì,wèi"},
    { 0x29182, "cí"},
    { 0x29184, "yǒng"},
    { 0x29185, "sà"},
    { 0x29186, "tíng"},
    { 0x2918E, "liù"},
    { 0x29191, "suān"},
    { 0x29192, "líng"},
    { 0x29193, "mán,màn"},
    { 0x29194, "diàn"},
    { 0x29198, "pāo"},
    { 0x2919A, "líng"},
    { 0x2919D, "lì"},
    { 0x2919F, "nóu"},
    { 0x291A3, "liè"},
    { 0x291A4, "shǎn"},
    { 0x291A6, "fèi"},
    { 0x291AB, "shǎn"},
    { 0x291AE, "líng"},
    { 0x291AF, "zhàn,jiān"},
    { 0x291B1, "bīn"},
    { 0x291B2, "lí"},
    { 0x291B5, "sī,xiàn"},
    { 0x291B6, "ráng"},
    { 0x291B7, "jiān"},
    { 0x291B8, "zhuó"},
    { 0x291BB, "líng"},
    { 0x291BC, "líng"},
    { 0x291BD, "mèng"},
    { 0x291BF, "shuāng"},
    { 0x291C4, "líng"},
    { 0x291C7, "hùn"},
    { 0x291CE, "líng"},
    { 0x291CF, "jiān"},
    { 0x291D0, "qú"},
    { 0x291D4, "nóng"},
    { 0x291D5, "jìng"},
    { 0x291D6, "chēn"},
    { 0x291DC, "zhēn,chèng,chēng"},
    { 0x291DD, "qìng"},
    { 0x291DF, "qìng"},
    { 0x291E0, "è,yǎn"},
    { 0x291E3, "sè"},
    { 0x291E9, "bèi"},
    { 0x291EB, "fēi"},
    { 0x291EE, "fèi"},
    { 0x291EF, "féi"},
    { 0x291F4, "fāng"},
    { 0x291F5, "kǔ"},
    { 0x291FA, "zá"},
    { 0x291FB, "huì"},
    { 0x291FD, "féi"},
    { 0x29201, "duì"},
    { 0x29206, "pā"},
    { 0x29207, "niǔ"},
    { 0x29208, "pàng"},
    { 0x29209, "dàn"},
    { 0x2920A, "dān,dàn"},
    { 0x2920B, "ài"},
    { 0x2920D, "tiǎn"},
    { 0x2920E, "chǎo"},
    { 0x2920F, "ǎo,yǒu"},
    { 0x29210, "mèi"},
    { 0x29211, "nǎn"},
    { 0x29214, "bò"},
    { 0x29215, "yù,chì"},
    { 0x29216, "xiān,hān"},
    { 0x29217, "mài"},
    { 0x2921A, "pīng"},
    { 0x2921C, "duī"},
    { 0x2921E, "dào"},
    { 0x29221, "xìng"},
    { 0x29222, "nì,nǜ"},
    { 0x29223, "hān"},
    { 0x29224, "chù"},
    { 0x29225, "shuǎ"},
    { 0x29226, "mǎn"},
    { 0x2922C, "wàn"},
    { 0x2922D, "yì"},
    { 0x2922E, "diào"},
    { 0x2922F, "yān"},
    { 0x29231, "wò"},
    { 0x29232, "suàn"},
    { 0x29234, "ǎn"},
    { 0x29235, "lán"},
    { 0x29236, "nǎn"},
    { 0x29238, "qiǔ"},
    { 0x29239, "miàn"},
    { 0x2923A, "nuǒ"},
    { 0x2923B, "cán"},
    { 0x2923C, "cǎn"},
    { 0x29240, "làn"},
    { 0x29241, "tiǎn"},
    { 0x29242, "yè"},
    { 0x29244, "niǎn"},
    { 0x29246, "shuǎ"},
    { 0x2924B, "cí"},
    { 0x2924D, "jiǎn"},
    { 0x29250, "gàn"},
    { 0x29254, "jiàn"},
    { 0x29255, "guó"},
    { 0x29257, "zhān"},
    { 0x29259, "luǒ"},
    { 0x2925C, "jī,hàng"},
    { 0x2925D, "guì"},
    { 0x29261, "jiá"},
    { 0x29262, "jǐ"},
    { 0x29265, "xuàn"},
    { 0x29267, "fēng"},
    { 0x2926B, "bì"},
    { 0x2926C, "qí,chí"},
    { 0x2926F, "yuán"},
    { 0x29270, "àng"},
    { 0x29271, "dī"},
    { 0x29274, "è"},
    { 0x29275, "fén"},
    { 0x29278, "jù"},
    { 0x29279, "nǐ"},
    { 0x2927A, "tuó"},
    { 0x2927C, "shēn"},
    { 0x2927D, "fú"},
    { 0x2927E, "xiá"},
    { 0x2927F, "qú"},
    { 0x29280, "pò"},
    { 0x29281, "wǎn"},
    { 0x29282, "líng"},
    { 0x29283, "mà"},
    { 0x29284, "zhòu"},
    { 0x29285, "bào"},
    { 0x29287, "yù"},
    { 0x2928C, "běng"},
    { 0x2928D, "mài"},
    { 0x2928F, "jiā"},
    { 0x29291, "yǎng"},
    { 0x29293, "kuǎ,kù"},
    { 0x29294, "jiào"},
    { 0x29296, "bǐng"},
    { 0x2929A, "luò"},
    { 0x2929B, "guǐ"},
    { 0x2929C, "duò"},
    { 0x2929D, "zhì"},
    { 0x292A1, "zhèn"},
    { 0x292A2, "è"},
    { 0x292A3, "zhū"},
    { 0x292A4, "bá"},
    { 0x292A8, "zhèn"},
    { 0x292A9, "fēng,féng"},
    { 0x292AA, "dòu"},
    { 0x292AB, "niǎn"},
    { 0x292AC, "bù"},
    { 0x292AD, "duì"},
    { 0x292AE, "shā,suō"},
    { 0x292AF, "sè"},
    { 0x292B0, "bì"},
    { 0x292B4, "zhì"},
    { 0x292B5, "zhé"},
    { 0x292B6, "bù"},
    { 0x292BA, "jué"},
    { 0x292BB, "xùn"},
    { 0x292BF, "xì"},
    { 0x292C1, "zhuó"},
    { 0x292C2, "bài"},
    { 0x292C3, "yáo,táo"},
    { 0x292C4, "chǒu"},
    { 0x292C5, "tà"},
    { 0x292C6, "qiān"},
    { 0x292C8, "nào"},
    { 0x292C9, "yù"},
    { 0x292CA, "è"},
    { 0x292CB, "jiān"},
    { 0x292CC, "yì"},
    { 0x292CD, "xiāo"},
    { 0x292CF, "niè"},
    { 0x292D2, "bīng"},
    { 0x292D7, "guǒ"},
    { 0x292D8, "xié"},
    { 0x292D9, "diào"},
    { 0x292DC, "jū"},
    { 0x292DD, "suǒ"},
    { 0x292DE, "dié"},
    { 0x292DF, "fú,fù"},
    { 0x292E0, "miǎn"},
    { 0x292E1, "shì"},
    { 0x292E2, "xuàn,yùn"},
    { 0x292E3, "tí"},
    { 0x292E4, "yù"},
    { 0x292E7, "xié,kài"},
    { 0x292E8, "fú"},
    { 0x292E9, "zhì"},
    { 0x292EA, "nǐ"},
    { 0x292EB, "xuàn"},
    { 0x292EC, "yáng"},
    { 0x292EE, "fěng,bāng"},
    { 0x292EF, "zòng"},
    { 0x292F0, "zhòu"},
    { 0x292F1, "xuān"},
    { 0x292F5, "zhū"},
    { 0x292F7, "la"},
    { 0x292F9, "yìng"},
    { 0x292FA, "gào"},
    { 0x292FB, "kuò"},
    { 0x292FD, "é"},
    { 0x292FE, "wéi,wěi,xuē"},
    { 0x292FF, "méi"},
    { 0x29303, "huái,guì"},
    { 0x29304, "chǒu,zhōu"},
    { 0x29306, "suǒ"},
    { 0x29307, "tà"},
    { 0x29308, "suǒ"},
    { 0x29309, "tà"},
    { 0x2930A, "xuè"},
    { 0x2930C, "gǒng"},
    { 0x2930D, "jiǎ"},
    { 0x2930F, "bó,fú,bù,fù"},
    { 0x29310, "tà"},
    { 0x29311, "yuǎn"},
    { 0x29318, "tà"},
    { 0x2931D, "chuí"},
    { 0x29320, "xiōng"},
    { 0x29321, "hé,juē"},
    { 0x29322, "suō"},
    { 0x29327, "mò"},
    { 0x29328, "chóng"},
    { 0x29329, "suī"},
    { 0x2932A, "zé"},
    { 0x2932B, "lù"},
    { 0x2932C, "zhāng"},
    { 0x2932D, "luò"},
    { 0x2932E, "xù"},
    { 0x2932F, "jiān"},
    { 0x29330, "shān"},
    { 0x29332, "xù"},
    { 0x2933E, "jiǎng"},
    { 0x29342, "bào"},
    { 0x29343, "mái"},
    { 0x29345, "tóng"},
    { 0x29346, "xì"},
    { 0x29349, "róng"},
    { 0x2934B, "shéng"},
    { 0x2934C, "zhòu"},
    { 0x2934E, "jiān"},
    { 0x2934F, "fù"},
    { 0x29350, "dèng"},
    { 0x29353, "yōng"},
    { 0x29354, "jū,qū"},
    { 0x29356, "yì"},
    { 0x29357, "bāng"},
    { 0x29359, "sè"},
    { 0x2935A, "suì"},
    { 0x2935C, "duó"},
    { 0x2935D, "xiè"},
    { 0x29361, "huán"},
    { 0x29365, "rǔ"},
    { 0x29366, "nǐ"},
    { 0x29367, "zhòu"},
    { 0x29368, "guì"},
    { 0x2936A, "luò"},
    { 0x29372, "zhī,chàn"},
    { 0x29373, "xù"},
    { 0x29375, "zhī"},
    { 0x29377, "jué"},
    { 0x29378, "jū"},
    { 0x2937B, "yuán"},
    { 0x2937C, "lú"},
    { 0x2937F, "bó,fù"},
    { 0x29382, "róng"},
    { 0x29383, "xiè"},
    { 0x29389, "xǐ"},
    { 0x2938A, "luó"},
    { 0x2938E, "gé"},
    { 0x29391, "zuān"},
    { 0x29392, "hàn,jiān"},
    { 0x29394, "jiāo"},
    { 0x29395, "sǎ"},
    { 0x29396, "qín,qián"},
    { 0x29397, "qūn"},
    { 0x29398, "páo"},
    { 0x29399, "yuè"},
    { 0x2939A, "chè"},
    { 0x2939B, "fú"},
    { 0x2939C, "pēi"},
    { 0x2939F, "mèi,mò,wà"},
    { 0x293A2, "tāo"},
    { 0x293A4, "kēn"},
    { 0x293A5, "xì"},
    { 0x293AB, "duò"},
    { 0x293AD, "yì"},
    { 0x293B0, "suì"},
    { 0x293B2, "xiá"},
    { 0x293B3, "juān"},
    { 0x293B5, "wéi"},
    { 0x293B7, "yì"},
    { 0x293B9, "yù"},
    { 0x293BB, "bài"},
    { 0x293BC, "tuó"},
    { 0x293BD, "tà"},
    { 0x293BE, "páo"},
    { 0x293C2, "bǐng,bì"},
    { 0x293C5, "yùn"},
    { 0x293C6, "yùn"},
    { 0x293C7, "duàn"},
    { 0x293C8, "ruǎn"},
    { 0x293C9, "wéi"},
    { 0x293CF, "wéi"},
    { 0x293D0, "guì,wěi"},
    { 0x293D2, "dá"},
    { 0x293D3, "xiá"},
    { 0x293D6, "hùn"},
    { 0x293D7, "juǎn"},
    { 0x293D8, "suī"},
    { 0x293DA, "suì"},
    { 0x293DD, "lóu"},
    { 0x293DE, "bài"},
    { 0x293DF, "yù"},
    { 0x293E0, "zhèng"},
    { 0x293E1, "guì"},
    { 0x293E3, "kuī"},
    { 0x293E4, "gāo"},
    { 0x293E5, "dān"},
    { 0x293E9, "xiǎn"},
    { 0x293EA, "zhái"},
    { 0x293EB, "sè"},
    { 0x293ED, "kē"},
    { 0x293EE, "bǔ"},
    { 0x293EF, "bó"},
    { 0x293F2, "suì"},
    { 0x293F4, "yù"},
    { 0x293F5, "bǔ,bù"},
    { 0x293F6, "jiū"},
    { 0x293F7, "jiū,jiào"},
    { 0x293F9, "juàn"},
    { 0x293FA, "jué"},
    { 0x293FC, "nà"},
    { 0x293FD, "zhái"},
    { 0x293FE, "tāo"},
    { 0x293FF, "wěi"},
    { 0x29400, "xiá"},
    { 0x29401, "xiè"},
    { 0x29405, "sà"},
    { 0x29406, "jī"},
    { 0x29409, "xiè"},
    { 0x2940C, "duì"},
    { 0x2940D, "zǐ"},
    { 0x29418, "yuǎn"},
    { 0x29419, "qìn"},
    { 0x2941A, "fú"},
    { 0x2941B, "péng"},
    { 0x2941C, "páo"},
    { 0x2941E, "yìn"},
    { 0x29420, "hōng"},
    { 0x29421, "zú"},
    { 0x29423, "gōng"},
    { 0x29424, "dòng"},
    { 0x29425, "hē"},
    { 0x29426, "wò"},
    { 0x29428, "pāng"},
    { 0x2942B, "sù"},
    { 0x2942C, "kǎn"},
    { 0x2942D, "niè"},
    { 0x2942E, "háo"},
    { 0x2942F, "fèng"},
    { 0x29430, "è"},
    { 0x29431, "yè"},
    { 0x29434, "tíng"},
    { 0x29435, "dòng"},
    { 0x29436, "zhé"},
    { 0x29437, "sāng"},
    { 0x2943B, "mò"},
    { 0x2943C, "sù"},
    { 0x2943E, "lè"},
    { 0x29440, "pǔ"},
    { 0x29441, "é"},
    { 0x29442, "zhuó"},
    { 0x29443, "yè"},
    { 0x29447, "xiāng"},
    { 0x29448, "guàng"},
    { 0x29449, "rěn"},
    { 0x2944A, "líng"},
    { 0x2944D, "ào"},
    { 0x29450, "chāi"},
    { 0x29452, "duó"},
    { 0x29453, "qióng"},
    { 0x29454, "kū,yà"},
    { 0x29455, "xū"},
    { 0x29456, "huán"},
    { 0x29457, "yāo"},
    { 0x29458, "zhèn"},
    { 0x29459, "tǐng"},
    { 0x2945A, "běng,lèi"},
    { 0x2945D, "áng"},
    { 0x2945F, "kān,qiān"},
    { 0x29461, "kū,gěn"},
    { 0x29462, "péi,bāi"},
    { 0x29463, "yòu"},
    { 0x29464, "ǎo"},
    { 0x29465, "mén"},
    { 0x29466, "mò"},
    { 0x2946C, "fǔ,guī"},
    { 0x2946D, "qīng"},
    { 0x2946E, "là"},
    { 0x2946F, "dǒu"},
    { 0x29470, "tǎn"},
    { 0x29473, "qiǎn"},
    { 0x29474, "yào"},
    { 0x29475, "wèi"},
    { 0x29476, "hú,kū"},
    { 0x29477, "mò"},
    { 0x29478, "hē"},
    { 0x29479, "xuàn"},
    { 0x2947B, "bì,pó"},
    { 0x2947C, "pō"},
    { 0x2947E, "dī"},
    { 0x29480, "zhěn"},
    { 0x29482, "shī"},
    { 0x29483, "kǎn"},
    { 0x29484, "cè"},
    { 0x29487, "xū"},
    { 0x29488, "zhěn"},
    { 0x2948A, "zhǔ"},
    { 0x2948F, "huì"},
    { 0x29490, "chǐ"},
    { 0x29493, "hǒng"},
    { 0x29494, "nóu"},
    { 0x29495, "niè,pò,è"},
    { 0x29496, "yàn"},
    { 0x29498, "chǒng"},
    { 0x29499, "fǔ,guì"},
    { 0x2949A, "guāng"},
    { 0x2949B, "qī"},
    { 0x2949D, "gěn"},
    { 0x2949E, "tǐng"},
    { 0x294A2, "tǎn"},
    { 0x294A3, "qiǎn"},
    { 0x294A6, "jiù,xìn"},
    { 0x294A7, "xū"},
    { 0x294A8, "qǐ"},
    { 0x294AA, "zhèn"},
    { 0x294AE, "qiú"},
    { 0x294B0, "ě"},
    { 0x294B3, "huì"},
    { 0x294B4, "hòng"},
    { 0x294B5, "qǐng"},
    { 0x294B7, "chē,rǒng"},
    { 0x294BA, "fù"},
    { 0x294BC, "hōng"},
    { 0x294BD, "xī"},
    { 0x294BE, "wú"},
    { 0x294BF, "máng"},
    { 0x294C2, "tī"},
    { 0x294C5, "hōng"},
    { 0x294D0, "bó"},
    { 0x294D2, "qǐn"},
    { 0x294D3, "gěn"},
    { 0x294D6, "fú"},
    { 0x294D7, "kuǐ"},
    { 0x294DD, "bié"},
    { 0x294DE, "jìng"},
    { 0x294DF, "kǎn"},
    { 0x294E0, "guī"},
    { 0x294E2, "gǎo"},
    { 0x294E3, "xū"},
    { 0x294E4, "àn"},
    { 0x294E5, "yuè"},
    { 0x294E6, "wù"},
    { 0x294E7, "yí"},
    { 0x294E8, "jīng"},
    { 0x294EA, "lù"},
    { 0x294EB, "quán"},
    { 0x294EC, "tuí"},
    { 0x294EE, "jì"},
    { 0x294FA, "jiǒng"},
    { 0x294FB, "jué"},
    { 0x294FC, "piē"},
    { 0x294FD, "kūn"},
    { 0x29500, "wài"},
    { 0x29501, "huì"},
    { 0x29502, "dùn"},
    { 0x29503, "yuǎn"},
    { 0x29504, "jié"},
    { 0x29506, "guì"},
    { 0x29507, "gǎo"},
    { 0x29508, "pò"},
    { 0x29509, "mén,mín,hūn"},
    { 0x2950A, "zhuàn"},
    { 0x2950B, "hàng"},
    { 0x29514, "yóng"},
    { 0x29515, "qiú"},
    { 0x29517, "lèi"},
    { 0x29518, "áng"},
    { 0x29519, "pǐ,xìn"},
    { 0x2951A, "wēng,wěng"},
    { 0x2951D, "qìn"},
    { 0x2951F, "qǐn"},
    { 0x29520, "miè"},
    { 0x29521, "dōu"},
    { 0x29522, "mí"},
    { 0x29523, "zhān"},
    { 0x29525, "qǐng"},
    { 0x29526, "yí"},
    { 0x2952E, "bān"},
    { 0x29531, "juān"},
    { 0x29533, "zé"},
    { 0x29534, "xù"},
    { 0x29535, "lán"},
    { 0x29536, "má"},
    { 0x29537, "má"},
    { 0x29538, "ōu"},
    { 0x29539, "bēi"},
    { 0x2953B, "póu"},
    { 0x2953C, "xù"},
    { 0x29540, "ào"},
    { 0x29546, "hǒng"},
    { 0x29549, "hǒng"},
    { 0x2954A, "zhǎn"},
    { 0x2954C, "sěn"},
    { 0x2954D, "gǎo,háo"},
    { 0x2954F, "pó,fán"},
    { 0x29550, "liào"},
    { 0x29555, "wài"},
    { 0x29556, "xuān"},
    { 0x2955C, "kuí"},
    { 0x2955F, "è"},
    { 0x29560, "hàn"},
    { 0x29561, "sè"},
    { 0x29564, "dàn"},
    { 0x2956A, "xuān"},
    { 0x2956C, "è"},
    { 0x2956D, "gài"},
    { 0x2956F, "dāo"},
    { 0x29571, "měng"},
    { 0x29572, "yī"},
    { 0x29573, "nǐng"},
    { 0x29575, "pín"},
    { 0x29579, "cāng"},
    { 0x2957E, "yuàn"},
    { 0x29580, "è"},
    { 0x29581, "niè,yá"},
    { 0x29584, "yǐn"},
    { 0x29587, "qiāo"},
    { 0x29589, "hōng"},
    { 0x2958A, "líng"},
    { 0x2958C, "chān"},
    { 0x2958D, "yǐng"},
    { 0x29592, "guān"},
    { 0x29594, "niǎo"},
    { 0x29595, "xū"},
    { 0x29596, "tán"},
    { 0x29597, "jìn"},
    { 0x2959B, "péng"},
    { 0x2959D, "liáo"},
    { 0x295A0, "bèi"},
    { 0x295A3, "xín,bá"},
    { 0x295A4, "tún"},
    { 0x295A5, "chāo"},
    { 0x295A6, "gān"},
    { 0x295A8, "hū"},
    { 0x295A9, "wǎng"},
    { 0x295AC, "fú"},
    { 0x295AD, "pèi"},
    { 0x295AF, "náo"},
    { 0x295B0, "xún,xín"},
    { 0x295B1, "xuè"},
    { 0x295B4, "liǔ"},
    { 0x295B5, "líng"},
    { 0x295B6, "xuè"},
    { 0x295B7, "qū"},
    { 0x295B8, "háo"},
    { 0x295B9, "yí"},
    { 0x295BA, "hàn"},
    { 0x295BC, "fú"},
    { 0x295BD, "bá"},
    { 0x295BE, "yí"},
    { 0x295C0, "bó"},
    { 0x295C4, "hōng"},
    { 0x295C5, "lì"},
    { 0x295C9, "sà"},
    { 0x295CA, "xī"},
    { 0x295CE, "shì"},
    { 0x295CF, "piāo"},
    { 0x295D0, "huà"},
    { 0x295D1, "yí"},
    { 0x295D2, "bó"},
    { 0x295D3, "bó"},
    { 0x295D4, "něi"},
    { 0x295D5, "qiú"},
    { 0x295D8, "wěi"},
    { 0x295D9, "chè"},
    { 0x295DA, "yóu"},
    { 0x295DC, "wèi"},
    { 0x295DD, "huǐ"},
    { 0x295DE, "sà"},
    { 0x295E2, "hòng"},
    { 0x295E3, "sōu"},
    { 0x295E4, "hàn"},
    { 0x295E5, "páo"},
    { 0x295E7, "fáng"},
    { 0x295E9, "liú"},
    { 0x295EA, "zhòu"},
    { 0x295EB, "pí"},
    { 0x295ED, "lì"},
    { 0x295F0, "chuí"},
    { 0x295F1, "xī"},
    { 0x295F2, "zhēng"},
    { 0x295F4, "bèng"},
    { 0x295F5, "zhēng"},
    { 0x295F6, "suì"},
    { 0x295F7, "yǎn"},
    { 0x295FC, "qīng"},
    { 0x295FD, "wù"},
    { 0x295FE, "liǎng"},
    { 0x29600, "zhào"},
    { 0x29601, "liáng"},
    { 0x29605, "jiē"},
    { 0x29607, "hōng"},
    { 0x29608, "yōu"},
    { 0x2960A, "là"},
    { 0x2960B, "hòu"},
    { 0x2960D, "yuàn"},
    { 0x2960E, "hóng"},
    { 0x2960F, "yè"},
    { 0x29611, "yǐng,yīng"},
    { 0x29612, "xuǎn,juān"},
    { 0x29613, "yóu"},
    { 0x29618, "quán"},
    { 0x2961C, "táng"},
    { 0x2961D, "suǒ"},
    { 0x2961F, "lì"},
    { 0x29620, "sōu"},
    { 0x29621, "lì"},
    { 0x29624, "yù"},
    { 0x29627, "yì"},
    { 0x2962D, "xiū"},
    { 0x2962E, "áo"},
    { 0x2962F, "tuán"},
    { 0x29630, "sù"},
    { 0x29631, "shuài"},
    { 0x29633, "yù"},
    { 0x29635, "fēng"},
    { 0x29639, "sù"},
    { 0x2963A, "tuí"},
    { 0x2963B, "yù"},
    { 0x2963C, "zhēng"},
    { 0x2963D, "zhēng"},
    { 0x2963F, "táo"},
    { 0x29644, "liú"},
    { 0x29646, "chéng"},
    { 0x29647, "suí"},
    { 0x29648, "sāo"},
    { 0x2964F, "gǔ"},
    { 0x29650, "fēng"},
    { 0x29651, "liè"},
    { 0x29652, "piāo,piào"},
    { 0x29656, "lì"},
    { 0x29658, "lóng"},
    { 0x29659, "chū"},
    { 0x2965A, "xiāo"},
    { 0x2965B, "hōng"},
    { 0x2965C, "xiè"},
    { 0x2965D, "shè"},
    { 0x29660, "lóng"},
    { 0x29661, "hōu"},
    { 0x29662, "xuán,shī"},
    { 0x29663, "fēng"},
    { 0x29665, "bá"},
    { 0x29666, "bó"},
    { 0x29667, "táo"},
    { 0x29668, "sù"},
    { 0x29669, "zhào"},
    { 0x2966A, "biāo"},
    { 0x2966B, "sōu"},
    { 0x2966C, "tuí"},
    { 0x2966D, "suǒ"},
    { 0x2966E, "xiāo"},
    { 0x2966F, "héng"},
    { 0x29670, "sāo"},
    { 0x29672, "fēi"},
    { 0x29677, "niù"},
    { 0x29678, "mǎng"},
    { 0x2967D, "huán,xuān"},
    { 0x2967E, "zhī"},
    { 0x29682, "yì"},
    { 0x29684, "yù"},
    { 0x29687, "yí"},
    { 0x29688, "yuē"},
    { 0x29689, "chí"},
    { 0x29695, "yǐn,qiāng"},
    { 0x29696, "niù"},
    { 0x29697, "rǒng"},
    { 0x2969B, "nà"},
    { 0x296A3, "tián"},
    { 0x296A5, "bā"},
    { 0x296AA, "ěr"},
    { 0x296AB, "zhēng"},
    { 0x296AC, "è"},
    { 0x296AD, "póu"},
    { 0x296AE, "jī,nì"},
    { 0x296AF, "ní"},
    { 0x296B1, "jiǒng"},
    { 0x296B2, "jiá"},
    { 0x296B5, "gān"},
    { 0x296B9, "líng"},
    { 0x296BB, "zuì"},
    { 0x296BE, "bèi"},
    { 0x296C5, "shū"},
    { 0x296C6, "yǐ"},
    { 0x296C7, "pāi"},
    { 0x296CB, "nǎo"},
    { 0x296CC, "shì"},
    { 0x296CE, "mǎn"},
    { 0x296CF, "shì"},
    { 0x296D1, "tí"},
    { 0x296D8, "gōng"},
    { 0x296DD, "lèi"},
    { 0x296DE, "bǎo,něi,piǎo"},
    { 0x296DF, "yuān,mán"},
    { 0x296E0, "zuō"},
    { 0x296E1, "láng,náng"},
    { 0x296E2, "xiū"},
    { 0x296E5, "zài"},
    { 0x296E6, "chèng"},
    { 0x296E7, "jiān"},
    { 0x296E8, "mào"},
    { 0x296E9, "jiá"},
    { 0x296EA, "yù"},
    { 0x296ED, "yù"},
    { 0x296EE, "yí"},
    { 0x296F2, "māng"},
    { 0x296F3, "zài,cān"},
    { 0x296F5, "zhuì"},
    { 0x296F6, "tí"},
    { 0x296F9, "xì"},
    { 0x296FA, "jú"},
    { 0x296FB, "zàn,zuǎn,zhān"},
    { 0x296FC, "lù"},
    { 0x296FD, "táo"},
    { 0x29700, "zhuì,duī"},
    { 0x29701, "líng"},
    { 0x29703, "jù"},
    { 0x29706, "jī"},
    { 0x29707, "juǎn,juàn"},
    { 0x2970A, "zī"},
    { 0x2970C, "yuē"},
    { 0x2970D, "dōng"},
    { 0x29712, "nǎng"},
    { 0x29716, "chóng"},
    { 0x2971F, "àng"},
    { 0x29723, "gēng"},
    { 0x29725, "bō"},
    { 0x29726, "dìng"},
    { 0x29727, "wěi"},
    { 0x2972C, "quán"},
    { 0x2972D, "kē"},
    { 0x29730, "pì"},
    { 0x29731, "kǎn,sǎn"},
    { 0x29732, "fú"},
    { 0x29733, "yǒng"},
    { 0x29735, "tuán"},
    { 0x29736, "tǒu"},
    { 0x29737, "yòu,niù"},
    { 0x29738, "yāo"},
    { 0x2973A, "yē"},
    { 0x2973D, "yàn"},
    { 0x29748, "xián"},
    { 0x2974A, "tí"},
    { 0x2974C, "suì"},
    { 0x29750, "cí"},
    { 0x29754, "xǔ"},
    { 0x29755, "wù"},
    { 0x29756, "cān"},
    { 0x29757, "yù"},
    { 0x2975A, "chǎn"},
    { 0x2975B, "xiá"},
    { 0x2975D, "kào,gāo"},
    { 0x2975E, "cāng"},
    { 0x2975F, "chā"},
    { 0x29760, "qiǔ"},
    { 0x29763, "dā"},
    { 0x29765, "sù"},
    { 0x29768, "huā"},
    { 0x29777, "wū"},
    { 0x29778, "yuān"},
    { 0x2977D, "jiàng"},
    { 0x2977E, "xiǎng"},
    { 0x2977F, "zhāi"},
    { 0x29780, "sǎn,chěn,càn"},
    { 0x29781, "mó,mí"},
    { 0x29783, "shǎng,xiǎng"},
    { 0x29784, "cáo"},
    { 0x29785, "suī"},
    { 0x29786, "chuáng"},
    { 0x29787, "mí"},
    { 0x29788, "zhú"},
    { 0x29789, "chóng"},
    { 0x2978A, "jì"},
    { 0x2978B, "chóng"},
    { 0x29799, "lián"},
    { 0x2979E, "hài"},
    { 0x297A4, "dūn"},
    { 0x297A5, "xiǎng"},
    { 0x297A6, "chēng"},
    { 0x297A7, "shǎng"},
    { 0x297A8, "lì"},
    { 0x297A9, "huáng"},
    { 0x297AC, "dèng"},
    { 0x297AF, "liáng"},
    { 0x297B6, "zā"},
    { 0x297BA, "huò"},
    { 0x297BB, "lín"},
    { 0x297BE, "dú,yì"},
    { 0x297BF, "hàn"},
    { 0x297C0, "yōng,yǒng"},
    { 0x297C1, "yuàn,xuàn"},
    { 0x297C2, "guò"},
    { 0x297C3, "líng"},
    { 0x297C5, "liǎn"},
    { 0x297C7, "ào"},
    { 0x297C8, "dāng"},
    { 0x297C9, "yì"},
    { 0x297CA, "nóng"},
    { 0x297CB, "shàn"},
    { 0x297CD, "xìn"},
    { 0x297D0, "dá"},
    { 0x297D1, "yù"},
    { 0x297D2, "cān"},
    { 0x297D3, "wò"},
    { 0x297D4, "chá"},
    { 0x297D5, "bó"},
    { 0x297D7, "jiǎn"},
    { 0x297DE, "méng"},
    { 0x297DF, "wěi"},
    { 0x297E0, "mó"},
    { 0x297E5, "shuì,juǎn"},
    { 0x297E6, "jié"},
    { 0x297E7, "shuò"},
    { 0x297E8, "huò"},
    { 0x297EB, "chuò"},
    { 0x297ED, "lóng"},
    { 0x297EE, "huài"},
    { 0x297F0, "tuō"},
    { 0x297F3, "yú"},
    { 0x297F6, "chàn,jié"},
    { 0x297F7, "yōng"},
    { 0x297F8, "huò"},
    { 0x297FA, "lǎn"},
    { 0x297FF, "nà"},
    { 0x29800, "bā"},
    { 0x29801, "gān"},
    { 0x29802, "yǐ"},
    { 0x29803, "jiá"},
    { 0x29805, "dá"},
    { 0x29806, "dìng"},
    { 0x29807, "xùn"},
    { 0x29808, "rěn"},
    { 0x29809, "juǎn"},
    { 0x2980A, "tuán"},
    { 0x2980B, "xǔ"},
    { 0x2980C, "sòng"},
    { 0x2980E, "cáo"},
    { 0x2980F, "chēng"},
    { 0x29811, "dǐng"},
    { 0x2981A, "hái"},
    { 0x2981F, "wǔ"},
    { 0x29826, "qǐ,shǒu"},
    { 0x29828, "jī,qǐ"},
    { 0x2982E, "kuí"},
    { 0x2982F, "wéi"},
    { 0x29836, "shǒu"},
    { 0x29837, "fú"},
    { 0x29839, "tuán"},
    { 0x2983B, "bié,hān"},
    { 0x2983D, "tán"},
    { 0x2983E, "hāng"},
    { 0x2983F, "piē"},
    { 0x29843, "yú"},
    { 0x29844, "tán,xiāng"},
    { 0x2984C, "xiāng"},
    { 0x2984E, "xiū"},
    { 0x29853, "wěng"},
    { 0x29854, "hài"},
    { 0x29855, "péng"},
    { 0x2985D, "tán"},
    { 0x2985F, "bié"},
    { 0x29860, "xiāng"},
    { 0x29863, "yǐ"},
    { 0x29866, "piáo"},
    { 0x29867, "huán"},
    { 0x29868, "mǔ"},
    { 0x29869, "bā"},
    { 0x2986B, "fàn"},
    { 0x2986F, "dīng"},
    { 0x29877, "fēn,fèi"},
    { 0x2987A, "jiè"},
    { 0x2987E, "suó"},
    { 0x29884, "wàn"},
    { 0x29885, "gē"},
    { 0x29888, "fēn"},
    { 0x2988A, "tuó"},
    { 0x2988C, "wén"},
    { 0x2988D, "guā"},
    { 0x2988E, "duō"},
    { 0x29890, "zhé"},
    { 0x29891, "cǐ"},
    { 0x29892, "yǎo"},
    { 0x29894, "bàn"},
    { 0x29895, "bù"},
    { 0x29896, "mò"},
    { 0x29898, "pǒ"},
    { 0x2989B, "gé"},
    { 0x2989E, "liú"},
    { 0x298A1, "rǎn"},
    { 0x298A8, "gān"},
    { 0x298AA, "hú"},
    { 0x298AB, "móu"},
    { 0x298AE, "xiū"},
    { 0x298AF, "huāng"},
    { 0x298B0, "fú"},
    { 0x298B1, "huí"},
    { 0x298B3, "qú"},
    { 0x298B4, "jié,jí"},
    { 0x298B5, "tuō"},
    { 0x298B6, "yú"},
    { 0x298B7, "mò"},
    { 0x298B8, "zhōu"},
    { 0x298B9, "jiù"},
    { 0x298BB, "shú"},
    { 0x298BC, "kuāng"},
    { 0x298BD, "qióng"},
    { 0x298BE, "liè"},
    { 0x298BF, "fù"},
    { 0x298CA, "xù"},
    { 0x298D6, "lìn"},
    { 0x298D8, "niè"},
    { 0x298DA, "pī,bǐ"},
    { 0x298DC, "fù"},
    { 0x298DD, "bù"},
    { 0x298DE, "yì,sà"},
    { 0x298E1, "bó"},
    { 0x298E3, "é,ě"},
    { 0x298E9, "zhé"},
    { 0x298EB, "lì"},
    { 0x298EE, "tù"},
    { 0x298EF, "dá"},
    { 0x298F1, "lù"},
    { 0x298F2, "yān"},
    { 0x298F3, "dōng"},
    { 0x298F4, "qiè"},
    { 0x298F5, "wǎn,wò"},
    { 0x298F6, "mǐng"},
    { 0x298F7, "zuī,zhù"},
    { 0x298F8, "fù"},
    { 0x298F9, "qū"},
    { 0x298FA, "bēn"},
    { 0x298FB, "ǎo"},
    { 0x298FC, "qiāng"},
    { 0x29901, "qūn"},
    { 0x29908, "què"},
    { 0x29909, "huá,táo"},
    { 0x2990A, "xiàn,jiàn"},
    { 0x2990B, "kùn"},
    { 0x2990F, "cuì"},
    { 0x29912, "yí"},
    { 0x29916, "chī,ér"},
    { 0x29917, "zòng"},
    { 0x29918, "nǎo"},
    { 0x29919, "chéng"},
    { 0x2991A, "duān"},
    { 0x2991B, "yóng"},
    { 0x2991C, "zhě"},
    { 0x2991E, "tàn"},
    { 0x2991F, "yáng"},
    { 0x29920, "xié"},
    { 0x29921, "xuān"},
    { 0x29923, "duàn"},
    { 0x29924, "shuǎ"},
    { 0x29925, "xián"},
    { 0x29926, "xián"},
    { 0x29929, "é"},
    { 0x29932, "lā"},
    { 0x29938, "wèi"},
    { 0x29939, "yōu"},
    { 0x2993A, "yú"},
    { 0x2993D, "tī"},
    { 0x2993F, "jīn"},
    { 0x29941, "táng"},
    { 0x29942, "qí"},
    { 0x29944, "diān"},
    { 0x29945, "tāo"},
    { 0x29946, "lǜ"},
    { 0x29947, "zhàn"},
    { 0x29948, "wēn"},
    { 0x29949, "jì"},
    { 0x2994A, "āo,jiāo"},
    { 0x2994B, "òu,dú"},
    { 0x2994C, "qià"},
    { 0x29950, "shī"},
    { 0x29951, "tǎ"},
    { 0x29954, "mò"},
    { 0x29958, "yóu"},
    { 0x29960, "zhá"},
    { 0x29963, "yáo"},
    { 0x2996B, "chōng"},
    { 0x2996C, "lí"},
    { 0x2996D, "yú"},
    { 0x2996E, "chǎn"},
    { 0x2996F, "yī"},
    { 0x29972, "chì"},
    { 0x29974, "lí"},
    { 0x2997D, "tú"},
    { 0x2997F, "zú"},
    { 0x29982, "xián"},
    { 0x29987, "xì"},
    { 0x29989, "bié"},
    { 0x2998A, "hán,qiān"},
    { 0x2998B, "qí"},
    { 0x2998C, "sāng,shuāng"},
    { 0x2998E, "fēi,fěi"},
    { 0x29990, "shàn,huō"},
    { 0x29998, "huān"},
    { 0x299A0, "bàng"},
    { 0x299A1, "yú"},
    { 0x299A2, "yú"},
    { 0x299A4, "jí"},
    { 0x299B1, "kuǎi"},
    { 0x299B2, "zōng"},
    { 0x299B9, "xiàn"},
    { 0x299BA, "méng"},
    { 0x299C3, "lì"},
    { 0x299C4, "zhì"},
    { 0x299C5, "fán"},
    { 0x299C6, "liè,là"},
    { 0x299C7, "cài"},
    { 0x299C8, "dú"},
    { 0x299C9, "guāng"},
    { 0x299CA, "xiòng"},
    { 0x299CB, "lí"},
    { 0x299CC, "qì"},
    { 0x299CF, "jué"},
    { 0x299D0, "tuō"},
    { 0x299D2, "jù"},
    { 0x299D3, "xiāo"},
    { 0x299D8, "qú"},
    { 0x299DC, "zhuǎn"},
    { 0x299E1, "jué"},
    { 0x299E6, "jiè"},
    { 0x299E8, "zhòu"},
    { 0x299E9, "xiàn"},
    { 0x299EA, "lóng"},
    { 0x299EB, "yǎng"},
    { 0x299EC, "rǎn"},
    { 0x299ED, "yì"},
    { 0x299EE, "liè"},
    { 0x299EF, "bō"},
    { 0x299F0, "hún"},
    { 0x299F1, "jì"},
    { 0x299F2, "dòng"},
    { 0x299F3, "zhōu"},
    { 0x299F4, "quān"},
    { 0x299F5, "jié"},
    { 0x299FA, "jú"},
    { 0x299FC, "bēn"},
    { 0x299FF, "bī"},
    { 0x29A00, "gé"},
    { 0x29A01, "chǔn"},
    { 0x29A03, "qián"},
    { 0x29A04, "sōu"},
    { 0x29A05, "wèi"},
    { 0x29A06, "chéng"},
    { 0x29A07, "lóu"},
    { 0x29A08, "yú"},
    { 0x29A09, "lā"},
    { 0x29A0A, "qián"},
    { 0x29A0B, "diān"},
    { 0x29A0C, "tǎ"},
    { 0x29A0D, "zhàn"},
    { 0x29A0F, "fán"},
    { 0x29A10, "liè"},
    { 0x29A11, "tīng"},
    { 0x29A12, "jī"},
    { 0x29A13, "qiān"},
    { 0x29A14, "hú,huá"},
    { 0x29A17, "yú"},
    { 0x29A18, "qì,gē"},
    { 0x29A19, "yú"},
    { 0x29A1A, "wā"},
    { 0x29A1C, "bà"},
    { 0x29A1D, "qí"},
    { 0x29A1E, "sǎ"},
    { 0x29A1F, "qiāo"},
    { 0x29A20, "yà"},
    { 0x29A21, "xiǎn,sǎn"},
    { 0x29A28, "cī"},
    { 0x29A29, "fàn"},
    { 0x29A2B, "kǔn"},
    { 0x29A2C, "gǔn"},
    { 0x29A2D, "quē"},
    { 0x29A2E, "è"},
    { 0x29A2F, "qióng"},
    { 0x29A32, "mà"},
    { 0x29A33, "kū,dū"},
    { 0x29A34, "yǎo"},
    { 0x29A37, "quē"},
    { 0x29A38, "chū"},
    { 0x29A39, "jiǎ"},
    { 0x29A3B, "zhǔ"},
    { 0x29A3D, "duī"},
    { 0x29A3E, "wá"},
    { 0x29A40, "nǎo"},
    { 0x29A44, "yán"},
    { 0x29A45, "tóng"},
    { 0x29A4B, "xíng,jìng"},
    { 0x29A4C, "gǔn"},
    { 0x29A4D, "pīng"},
    { 0x29A51, "yǔ"},
    { 0x29A52, "hè"},
    { 0x29A54, "zhuó"},
    { 0x29A57, "shē"},
    { 0x29A58, "yǔ"},
    { 0x29A5B, "jì"},
    { 0x29A5D, "qiāng"},
    { 0x29A5E, "shuì"},
    { 0x29A5F, "chuò"},
    { 0x29A60, "zú"},
    { 0x29A61, "léng"},
    { 0x29A62, "ní"},
    { 0x29A64, "wā"},
    { 0x29A65, "zhá"},
    { 0x29A67, "dàn"},
    { 0x29A6E, "dù"},
    { 0x29A6F, "biàn"},
    { 0x29A70, "jiē,hái"},
    { 0x29A71, "qià"},
    { 0x29A72, "hé"},
    { 0x29A73, "chòng"},
    { 0x29A74, "yán"},
    { 0x29A76, "yàn"},
    { 0x29A7A, "sóng"},
    { 0x29A7B, "téng"},
    { 0x29A7C, "yǎo"},
    { 0x29A7E, "kāo"},
    { 0x29A80, "zhuī"},
    { 0x29A81, "guì"},
    { 0x29A82, "ái"},
    { 0x29A83, "hài"},
    { 0x29A88, "suǒ"},
    { 0x29A89, "xù"},
    { 0x29A8A, "biāo"},
    { 0x29A8C, "fèng"},
    { 0x29A8D, "qū,shū"},
    { 0x29A8E, "mǎng"},
    { 0x29A90, "guó"},
    { 0x29A96, "bì"},
    { 0x29A97, "jué"},
    { 0x29A98, "chuáng"},
    { 0x29A9B, "pú"},
    { 0x29A9F, "yì"},
    { 0x29AA2, "qiān"},
    { 0x29AA3, "yì"},
    { 0x29AA4, "è"},
    { 0x29AA5, "líng"},
    { 0x29AA7, "bì"},
    { 0x29AAD, "huò"},
    { 0x29AAE, "mǒ,mó"},
    { 0x29AB1, "xūn"},
    { 0x29AB4, "yàn"},
    { 0x29AB8, "lì"},
    { 0x29ABA, "tán"},
    { 0x29ABE, "luán"},
    { 0x29AC0, "kài"},
    { 0x29AC1, "mào"},
    { 0x29AC2, "xiāo"},
    { 0x29AC7, "ǎi"},
    { 0x29ACA, "tǎ"},
    { 0x29ACD, "mèi"},
    { 0x29ACF, "guō,yōng"},
    { 0x29AD3, "gǎo"},
    { 0x29AD4, "náo"},
    { 0x29AD5, "háo"},
    { 0x29AE0, "quē"},
    { 0x29AE5, "cáo"},
    { 0x29AE6, "sào"},
    { 0x29AEB, "pí"},
    { 0x29AF2, "xiē"},
    { 0x29AF3, "xiāo"},
    { 0x29AF4, "jú"},
    { 0x29AF9, "chéng"},
    { 0x29AFA, "nǎo"},
    { 0x29B00, "nèi"},
    { 0x29B0D, "mǔ"},
    { 0x29B0F, "shāo"},
    { 0x29B11, "diān,chān"},
    { 0x29B14, "líng"},
    { 0x29B16, "zhěn"},
    { 0x29B17, "yǎo"},
    { 0x29B19, "fù,fū"},
    { 0x29B1A, "qián,gàn"},
    { 0x29B1B, "qióng"},
    { 0x29B1C, "jú"},
    { 0x29B1D, "bìng,fǎng"},
    { 0x29B1E, "máo,mán,mián"},
    { 0x29B1F, "zhà"},
    { 0x29B20, "tāi"},
    { 0x29B24, "chōng"},
    { 0x29B2B, "zhǎi"},
    { 0x29B2D, "shī"},
    { 0x29B2E, "yòng"},
    { 0x29B30, "qióng"},
    { 0x29B31, "dào"},
    { 0x29B32, "tì"},
    { 0x29B33, "zhuǐ"},
    { 0x29B35, "yìn"},
    { 0x29B37, "nǎo"},
    { 0x29B38, "bō"},
    { 0x29B39, "kuāng"},
    { 0x29B3A, "zhǐ"},
    { 0x29B3B, "duǒ"},
    { 0x29B3C, "cōng"},
    { 0x29B3D, "bǎo"},
    { 0x29B47, "lí"},
    { 0x29B4A, "jú"},
    { 0x29B4B, "wén,kūn"},
    { 0x29B4C, "liè"},
    { 0x29B4F, "wǒ"},
    { 0x29B50, "shǐ"},
    { 0x29B51, "niǎo"},
    { 0x29B52, "máng"},
    { 0x29B53, "jiū"},
    { 0x29B58, "xiū"},
    { 0x29B5D, "wǒ"},
    { 0x29B5F, "dào"},
    { 0x29B61, "xī"},
    { 0x29B62, "àn"},
    { 0x29B63, "dá"},
    { 0x29B64, "zǒng,zōng"},
    { 0x29B65, "hàn"},
    { 0x29B66, "chuí"},
    { 0x29B67, "bī,bān"},
    { 0x29B69, "dòng"},
    { 0x29B6B, "zhǎng"},
    { 0x29B6F, "yā"},
    { 0x29B72, "dí"},
    { 0x29B73, "huō"},
    { 0x29B77, "mín"},
    { 0x29B7A, "fù"},
    { 0x29B7C, "bǎo"}
};
