/*
 * Copyright (C) 2015 ~ 2018 Deepin Technology Co., Ltd.
 *
 * Author:     sbw <sbw@sbw.so>
 *             kirigaya <kirigaya@mkacg.com>
 *             Hualet <mr.asianwang@gmail.com>
 *             listenerri <listenerri@gmail.com>
 *
 * Maintainer: sbw <sbw@sbw.so>
 *             kirigaya <kirigaya@mkacg.com>
 *             Hualet <mr.asianwang@gmail.com>
 *             listenerri <listenerri@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * This file was generated by qdbusxml2cpp version 0.8
 * Command line was: qdbusxml2cpp dde-center -a dbuscontrolcenter -c DBusControlCenter -l Frame
 *
 * qdbusxml2cpp is Copyright (C) 2015 Digia Plc and/or its subsidiary(-ies).
 *
 * This is an auto-generated file.
 * Do not edit! All changes made to it will be lost.
 */

#include "dbuscontrolcenterservice.h"
#include "window/mainwindow.h"

#include "modules/display/displaymodel.h"
#include "modules/display/displayworker.h"

#include <QtCore/QMetaObject>
#include <QtCore/QByteArray>
#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtCore/QThread>
#include <QGuiApplication>
#include <qpa/qplatformwindow.h>
#include <QScreen>
#include <QString>

#include <unistd.h>

/*
 * Implementation of adaptor class DBusControlCenter
 */

using namespace DCC_NAMESPACE;

DBusControlCenterService::DBusControlCenterService(MainWindow *parent)
    : QDBusAbstractAdaptor(parent)
    , m_toggleProcessed(true)
{

}

DBusControlCenterService::~DBusControlCenterService()
{

}

MainWindow *DBusControlCenterService::parent() const
{
    return static_cast<MainWindow *>(QObject::parent());
}

bool DBusControlCenterService::showInRight() const
{
    return true;
}

const QRect DBusControlCenterService::rect() const
{
    if (parent()->windowHandle() && parent()->windowHandle()->handle()) {
        return parent()->windowHandle()->handle()->geometry();
    }

    return parent()->geometry();
}

void DBusControlCenterService::exitProc()
{
    pid_t pid = getpid();
    qDebug() << "exit pid:" << pid;
    exit(0);
}

void DBusControlCenterService::Hide()
{
    // handle method call com.deepin.dde.ControlCenter.Hide
    parent()->hide();
}

void DBusControlCenterService::HideImmediately()
{
    // handle method call com.deepin.dde.ControlCenter.HideImmediately
//    parent()->hideImmediately();
}

void DBusControlCenterService::Show()
{
    // handle method call com.deepin.dde.ControlCenter.Show
#ifdef DISABLE_MAIN_PAGE
    parent()->showSettingsPage(QString(), QString());
#else
    parent()->initAllModule();

    parent()->raise();
    if (parent()->isMinimized() || !parent()->isVisible())
        parent()->showNormal();

    parent()->activateWindow();
#endif
}

void DBusControlCenterService::ShowImmediately()
{
    // handle method call com.deepin.dde.ControlCenter.ShowImmediately
#ifdef DISABLE_MAIN_PAGE
    parent()->showSettingsPage(QString(), QString());
#else
    if (parent()->isMinimized())
        parent()->showNormal();

    parent()->activateWindow();
#endif
}

void DBusControlCenterService::ShowHome()
{
    parent()->popWidget();
}

void DBusControlCenterService::ShowModule(const QString &module)
{
    ShowPage(module, "");
}

void DBusControlCenterService::ShowPage(const QString &module, const QString &page)
{
    parent()->initAllModule(module);

    static bool firstEnter = true;
    QStringList delayModule{"bluetooth"};
    if (delayModule.contains(module) && firstEnter) {
        firstEnter = false;
        //此时对应了dbus调用显示控制中心需要dbus同步方式数据
    }

    parent()->showModulePage(module, page, false);
}

void DBusControlCenterService::Toggle()
{
    Show();
}

void DBusControlCenterService::ToggleInLeft()
{
    // handle method call com.deepin.dde.ControlCenter.ToggleInLeft
    Toggle();
}

bool DBusControlCenterService::isNetworkCanShowPassword()
{
    // handle method call com.deepin.dde.ControlCenter.isNetworkCanShowPassword
    //return parent()->isNetworkCanShowPassword();

    return false; // for remove gcc warning.
}

bool DBusControlCenterService::isModuleAvailable(const QString &m)
{
    return parent()->isModuleAvailable(m);
}

