/*
 *  Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd
 *
 * Author:     wangliang <wangliang@uniontech.com>
 *
 * Maintainer: wangliang <wangliang@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "ut_iconbutton_test.h"

#include "iconbutton.h"

//Qt单元测试相关头文件
#include <QTest>
#include <QtGui>
#include <QSignalSpy>
#include <QDebug>
#include <QMainWindow>
#include <DTitlebar>
#include <QKeyEvent>
#include <QFocusEvent>

DWIDGET_USE_NAMESPACE

UT_IconButton_Test::UT_IconButton_Test()
{
}

void UT_IconButton_Test::SetUp()
{
}

void UT_IconButton_Test::TearDown()
{
}

#ifdef UT_ICONBUTTON_TEST
TEST_F(UT_IconButton_Test, IconButton)
{
    IconButton *iconButton = new IconButton(nullptr);
    EXPECT_NE(iconButton, nullptr);

    delete iconButton;
}

/*******************************************************************************
 1. @函数:    keyPressEvent
 2. @作者:    ut000610 戴正文
 3. @日期:    2020-12-08
 4. @说明:    测试函数是否正确执行
*******************************************************************************/
TEST_F(UT_IconButton_Test, keyPressEvent)
{
    // 创建iconbutton
    IconButton *iconButton = new IconButton(nullptr);
    iconButton->show();
    // 发送键盘按键
    // 右键
    QKeyEvent keyRigth(QEvent::KeyPress, Qt::Key_Right, Qt::NoModifier);
    iconButton->keyPressEvent(&keyRigth);
    // 上键
    QKeyEvent keyUp(QEvent::KeyPress, Qt::Key_Up, Qt::NoModifier);
    iconButton->keyPressEvent(&keyUp);
    // 下键
    QKeyEvent keyDown(QEvent::KeyPress, Qt::Key_Down, Qt::NoModifier);
    iconButton->keyPressEvent(&keyDown);
    // 左键
    QKeyEvent keyLeft(QEvent::KeyPress, Qt::Key_Left, Qt::NoModifier);
    iconButton->keyPressEvent(&keyLeft);
    // 其他按键
    QKeyEvent keyOther(QEvent::KeyPress, Qt::Key_W, Qt::NoModifier);
    iconButton->keyPressEvent(&keyOther);

    delete iconButton;
}

/*******************************************************************************
 1. @函数:    focusOutEvent
 2. @作者:    ut000610 戴正文
 3. @日期:    2020-12-08
 4. @说明:    焦点切出
*******************************************************************************/
TEST_F(UT_IconButton_Test, focusOutEvent)
{
    // 创建iconbutton
    IconButton *iconButton = new IconButton(nullptr);
    iconButton->show();

    // 丢失焦点
    QFocusEvent foucsOut(QEvent::FocusOut, Qt::TabFocusReason);
    iconButton->focusOutEvent(&foucsOut);
    EXPECT_EQ(iconButton->hasFocus(), false);

    delete iconButton;
}

#endif
