#! /usr/bin/env python3
# -*- coding: utf-8 -*-

#Do not change these during runtime!

METADATA={
    #The pretty name of this program. Used for NSM display and Jack client name
    #Can contain everything a linux file/path supports. Never change this or it will break the
    #session, making your file unable to load and destroying saved Jack connections.
    "name" : "Fluajho",

    #Set this to the name the user types into a terminal.
    #MUST be the same as the binary name as well as the name in configure.
    #Program reports that as proc title so you can killall it by name.
    #Should not contain spaces or special characters. We use this as save file extension as well
    #to distinguish between compatible program versions. In basic programs this will just be e.g.
    #patroneo. But in complex programs with a bright future it will be "laborejo1" "laborejo2" etc.
    "shortName" : "fluajho",

    #A very short description used in various places: Desktop file, overview on the website,
    #release announcements, entries in software directories etc.
    "tagline" : 'SF2 soundfont sample player for JACK based on Fluidsynth.',

    "version" : "1.6.2",
    "year" : "2021",
    "author" : "Laborejo Software Suite",
    "url" : "https://www.laborejo.org/fluajho",

    "supportedLanguages" : {"German":"de.qm"},

    #Show the About Dialog the first time the program starts up. This is the initial state for a
    #new instance in NSM, not the saved state! Decide on how annoying it would be for every new
    #instance to show about. Fluajho does not show it because you add it many times into a session.
    #Patroneo does because its only added once.
    "showAboutDialogFirstStart" : False,

    #If your program handles very small duration with n-tuplets you should increase D4.
    #This will not be visible to the outside jack world
    "quarterNoteInTicks" : 96,

    #How many audio outputs do you want? must be pairs. These are just unconnected jack outputs
    #that need to be connected internally to instrument outputs like fluidsynth
    "cboxOutputs" : 16 * 2,  #16 stereo channels

    #Does the program uses a metronome? In this case you need at least two cboxOutputs above
    "metronome" : False,

    #Various strings for the README
    #Extra whitespace will be stripped so we don't need to worry about docstring indentation
    "description" : """
"Fluajho" (with jh as in pleasure) means fluid in Esperanto. It is a simple sf2 soundfont
host/player for Linux. Behind the scenes the Fluidsynth library is at work, hence the name.

.sf2 is an old file format for making MIDI signals audible through virtual instruments, although it
is still in moderate use today.

Why does Fluajho exist? There are many soundfont players for Linux,
most of them even based on Fluidsynth. Fluajho was written for a clearly defined use case:
Load an .sf2 in the New Session Manager (Agordejo) and save the soundfont in the session directory.
This makes it possible to archive the session, for example as a backup or to share it.

You can load one soundfont file per Fluajho instance. Each instance holds 16 of the soundfonts
instruments that can be assigned to 16 MIDI channels. Finally connect external sequencers, such as
Laborejo, Patroneo or Vico, through JACK-Midi to play the instruments.
""",

    "dependencies" : "\n".join("* "+dep for dep in ("Fluidsynth", )),

}
