#! /usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Copyright 2021, Nils Hilbricht, Germany ( https://www.hilbricht.net )

This file is part of the Laborejo Software Suite ( https://www.laborejo.org ),

This application is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

import logging; logger = logging.getLogger(__name__); logger.info("import")

#Python Standard Lib
import os.path

#Third Party
from calfbox import cbox

#Template Modules
from template.start import PATHS
import template.engine.sampler_sf2

class Data(template.engine.sampler_sf2.Sampler_sf2):
    """There must always be a Data class in a file main.py.
    Simply inheriting from engine.data.Data is easiest.    
    """         
    DEFAULT_PATCHES = { #Choose a nice set of instruments as program default.            
            # channel: (bank, program, name)
            #the name doesn't matter for the program at all, it is only to get a human readable save file. We set it to "" here because it gets updated automatically.                
            1: (0, 0, ""), #piano                
            2: (0, 49, ""), #slow strings
            3: (127, 95, ""), #Brass Section 1
            4: (0, 52, ""),  #Chor Aahs
            5: (0, 21, ""), #Accordion                
            6: (0, 11, ""),  #Vibraphone
            7: (0, 19, ""), #Church Organ
            8: (0, 59, ""),  #Muted Trumpet
            9: (0, 73, ""),  #Flute
            10: (128, 0, ""),  #drumset
            11: (0, 55, ""), #Orchester Hit
            12: (0, 81, ""), #Saw Wave
            13: (127, 33, ""), #Harmo Pad
            14: (127, 36, ""), #Soundtrack MT
            15: (0, 38, ""), #Synth Bass 1
            16: (8, 125, ""), #Starship
        }
    
    def __init__(self, parentSession, filePath="", activePatches=DEFAULT_PATCHES, ignoreProgramChanges=False): #Program start.
        DEFAULT_GM_SF2 = os.path.join(PATHS["share"], "gm.sf2")
        
        if not os.path.exists(DEFAULT_GM_SF2):  #a workaround if we are starting the compiled version without installing.
            _engineRoot = os.path.dirname(__file__)            
            DEFAULT_GM_SF2 = os.path.join(_engineRoot, "resources/gm.sf2")        
                
        if not filePath: #First start or save file with no filePath -> Default GM soundfont            
            #The default sf2 has a dynamic path. It depends on where the program is run from. We need to prevent an absolute path.
            super().__init__(parentSession, filePath, activePatches, ignoreProgramChanges, mixer=True, defaultSoundfont=DEFAULT_GM_SF2)
        else:
            super().__init__(parentSession, filePath, activePatches, ignoreProgramChanges, mixer=True)

    

        
        
        
