#! /usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Copyright 2021, Nils Hilbricht, Germany ( https://www.hilbricht.net )

This file is part of the Laborejo Software Suite ( https://www.laborejo.org ),

This application is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""


import logging; logger = logging.getLogger(__name__); logger.info("import")


class Data(object):
    """Base class to all Data. Data is the class that gets added to the session. Consider this an
    interface. It can be used as an object or parent class to get a working program, even if it
    doesn't do much.
    """

    def __init__(self, parentSession):
        self.parentSession = parentSession
        super().__init__()

    def updateJackMetadataSorting(self):
        pass

    #Save / Load / Export
    def serialize(self)->dict:
        return {
        }

    @classmethod
    def instanceFromSerializedData(cls, parentSession, serializedData):
        """The entry function to create a score from saved data. It is called by the session.

        This functions triggers a tree of other createInstanceFromSerializedData which finally
        return the score, which gets saved in the session.

        The serializedData is already converted to primitive python types from json,
        but nothing more. Here we create the actual objects."""
        self = cls(parentSession=parentSession,
            )

        return self

    def export(self)->dict:
        return {
            }
