// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gdk_sys;
use glib::error::ErrorDomain;
use glib::translate::*;
use glib::value::FromValue;
use glib::value::FromValueOptional;
use glib::value::SetValue;
use glib::value::Value;
use glib::Quark;
use glib::StaticType;
use glib::Type;
use gobject_sys;
use std::fmt;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum AxisUse {
    Ignore,
    X,
    Y,
    Pressure,
    Xtilt,
    Ytilt,
    Wheel,
    Distance,
    Rotation,
    Slider,
    Last,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for AxisUse {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "AxisUse::{}",
            match *self {
                AxisUse::Ignore => "Ignore",
                AxisUse::X => "X",
                AxisUse::Y => "Y",
                AxisUse::Pressure => "Pressure",
                AxisUse::Xtilt => "Xtilt",
                AxisUse::Ytilt => "Ytilt",
                AxisUse::Wheel => "Wheel",
                AxisUse::Distance => "Distance",
                AxisUse::Rotation => "Rotation",
                AxisUse::Slider => "Slider",
                AxisUse::Last => "Last",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for AxisUse {
    type GlibType = gdk_sys::GdkAxisUse;

    fn to_glib(&self) -> gdk_sys::GdkAxisUse {
        match *self {
            AxisUse::Ignore => gdk_sys::GDK_AXIS_IGNORE,
            AxisUse::X => gdk_sys::GDK_AXIS_X,
            AxisUse::Y => gdk_sys::GDK_AXIS_Y,
            AxisUse::Pressure => gdk_sys::GDK_AXIS_PRESSURE,
            AxisUse::Xtilt => gdk_sys::GDK_AXIS_XTILT,
            AxisUse::Ytilt => gdk_sys::GDK_AXIS_YTILT,
            AxisUse::Wheel => gdk_sys::GDK_AXIS_WHEEL,
            AxisUse::Distance => gdk_sys::GDK_AXIS_DISTANCE,
            AxisUse::Rotation => gdk_sys::GDK_AXIS_ROTATION,
            AxisUse::Slider => gdk_sys::GDK_AXIS_SLIDER,
            AxisUse::Last => gdk_sys::GDK_AXIS_LAST,
            AxisUse::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkAxisUse> for AxisUse {
    fn from_glib(value: gdk_sys::GdkAxisUse) -> Self {
        skip_assert_initialized!();
        match value {
            0 => AxisUse::Ignore,
            1 => AxisUse::X,
            2 => AxisUse::Y,
            3 => AxisUse::Pressure,
            4 => AxisUse::Xtilt,
            5 => AxisUse::Ytilt,
            6 => AxisUse::Wheel,
            7 => AxisUse::Distance,
            8 => AxisUse::Rotation,
            9 => AxisUse::Slider,
            10 => AxisUse::Last,
            value => AxisUse::__Unknown(value),
        }
    }
}

impl StaticType for AxisUse {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_axis_use_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for AxisUse {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for AxisUse {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for AxisUse {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum ByteOrder {
    LsbFirst,
    MsbFirst,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ByteOrder {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ByteOrder::{}",
            match *self {
                ByteOrder::LsbFirst => "LsbFirst",
                ByteOrder::MsbFirst => "MsbFirst",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for ByteOrder {
    type GlibType = gdk_sys::GdkByteOrder;

    fn to_glib(&self) -> gdk_sys::GdkByteOrder {
        match *self {
            ByteOrder::LsbFirst => gdk_sys::GDK_LSB_FIRST,
            ByteOrder::MsbFirst => gdk_sys::GDK_MSB_FIRST,
            ByteOrder::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkByteOrder> for ByteOrder {
    fn from_glib(value: gdk_sys::GdkByteOrder) -> Self {
        skip_assert_initialized!();
        match value {
            0 => ByteOrder::LsbFirst,
            1 => ByteOrder::MsbFirst,
            value => ByteOrder::__Unknown(value),
        }
    }
}

impl StaticType for ByteOrder {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_byte_order_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for ByteOrder {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for ByteOrder {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for ByteOrder {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum CrossingMode {
    Normal,
    Grab,
    Ungrab,
    GtkGrab,
    GtkUngrab,
    StateChanged,
    TouchBegin,
    TouchEnd,
    DeviceSwitch,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for CrossingMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "CrossingMode::{}",
            match *self {
                CrossingMode::Normal => "Normal",
                CrossingMode::Grab => "Grab",
                CrossingMode::Ungrab => "Ungrab",
                CrossingMode::GtkGrab => "GtkGrab",
                CrossingMode::GtkUngrab => "GtkUngrab",
                CrossingMode::StateChanged => "StateChanged",
                CrossingMode::TouchBegin => "TouchBegin",
                CrossingMode::TouchEnd => "TouchEnd",
                CrossingMode::DeviceSwitch => "DeviceSwitch",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for CrossingMode {
    type GlibType = gdk_sys::GdkCrossingMode;

    fn to_glib(&self) -> gdk_sys::GdkCrossingMode {
        match *self {
            CrossingMode::Normal => gdk_sys::GDK_CROSSING_NORMAL,
            CrossingMode::Grab => gdk_sys::GDK_CROSSING_GRAB,
            CrossingMode::Ungrab => gdk_sys::GDK_CROSSING_UNGRAB,
            CrossingMode::GtkGrab => gdk_sys::GDK_CROSSING_GTK_GRAB,
            CrossingMode::GtkUngrab => gdk_sys::GDK_CROSSING_GTK_UNGRAB,
            CrossingMode::StateChanged => gdk_sys::GDK_CROSSING_STATE_CHANGED,
            CrossingMode::TouchBegin => gdk_sys::GDK_CROSSING_TOUCH_BEGIN,
            CrossingMode::TouchEnd => gdk_sys::GDK_CROSSING_TOUCH_END,
            CrossingMode::DeviceSwitch => gdk_sys::GDK_CROSSING_DEVICE_SWITCH,
            CrossingMode::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkCrossingMode> for CrossingMode {
    fn from_glib(value: gdk_sys::GdkCrossingMode) -> Self {
        skip_assert_initialized!();
        match value {
            0 => CrossingMode::Normal,
            1 => CrossingMode::Grab,
            2 => CrossingMode::Ungrab,
            3 => CrossingMode::GtkGrab,
            4 => CrossingMode::GtkUngrab,
            5 => CrossingMode::StateChanged,
            6 => CrossingMode::TouchBegin,
            7 => CrossingMode::TouchEnd,
            8 => CrossingMode::DeviceSwitch,
            value => CrossingMode::__Unknown(value),
        }
    }
}

impl StaticType for CrossingMode {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_crossing_mode_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for CrossingMode {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for CrossingMode {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for CrossingMode {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum CursorType {
    XCursor,
    Arrow,
    BasedArrowDown,
    BasedArrowUp,
    Boat,
    Bogosity,
    BottomLeftCorner,
    BottomRightCorner,
    BottomSide,
    BottomTee,
    BoxSpiral,
    CenterPtr,
    Circle,
    Clock,
    CoffeeMug,
    Cross,
    CrossReverse,
    Crosshair,
    DiamondCross,
    Dot,
    Dotbox,
    DoubleArrow,
    DraftLarge,
    DraftSmall,
    DrapedBox,
    Exchange,
    Fleur,
    Gobbler,
    Gumby,
    Hand1,
    Hand2,
    Heart,
    Icon,
    IronCross,
    LeftPtr,
    LeftSide,
    LeftTee,
    Leftbutton,
    LlAngle,
    LrAngle,
    Man,
    Middlebutton,
    Mouse,
    Pencil,
    Pirate,
    Plus,
    QuestionArrow,
    RightPtr,
    RightSide,
    RightTee,
    Rightbutton,
    RtlLogo,
    Sailboat,
    SbDownArrow,
    SbHDoubleArrow,
    SbLeftArrow,
    SbRightArrow,
    SbUpArrow,
    SbVDoubleArrow,
    Shuttle,
    Sizing,
    Spider,
    Spraycan,
    Star,
    Target,
    Tcross,
    TopLeftArrow,
    TopLeftCorner,
    TopRightCorner,
    TopSide,
    TopTee,
    Trek,
    UlAngle,
    Umbrella,
    UrAngle,
    Watch,
    Xterm,
    LastCursor,
    BlankCursor,
    CursorIsPixmap,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for CursorType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "CursorType::{}",
            match *self {
                CursorType::XCursor => "XCursor",
                CursorType::Arrow => "Arrow",
                CursorType::BasedArrowDown => "BasedArrowDown",
                CursorType::BasedArrowUp => "BasedArrowUp",
                CursorType::Boat => "Boat",
                CursorType::Bogosity => "Bogosity",
                CursorType::BottomLeftCorner => "BottomLeftCorner",
                CursorType::BottomRightCorner => "BottomRightCorner",
                CursorType::BottomSide => "BottomSide",
                CursorType::BottomTee => "BottomTee",
                CursorType::BoxSpiral => "BoxSpiral",
                CursorType::CenterPtr => "CenterPtr",
                CursorType::Circle => "Circle",
                CursorType::Clock => "Clock",
                CursorType::CoffeeMug => "CoffeeMug",
                CursorType::Cross => "Cross",
                CursorType::CrossReverse => "CrossReverse",
                CursorType::Crosshair => "Crosshair",
                CursorType::DiamondCross => "DiamondCross",
                CursorType::Dot => "Dot",
                CursorType::Dotbox => "Dotbox",
                CursorType::DoubleArrow => "DoubleArrow",
                CursorType::DraftLarge => "DraftLarge",
                CursorType::DraftSmall => "DraftSmall",
                CursorType::DrapedBox => "DrapedBox",
                CursorType::Exchange => "Exchange",
                CursorType::Fleur => "Fleur",
                CursorType::Gobbler => "Gobbler",
                CursorType::Gumby => "Gumby",
                CursorType::Hand1 => "Hand1",
                CursorType::Hand2 => "Hand2",
                CursorType::Heart => "Heart",
                CursorType::Icon => "Icon",
                CursorType::IronCross => "IronCross",
                CursorType::LeftPtr => "LeftPtr",
                CursorType::LeftSide => "LeftSide",
                CursorType::LeftTee => "LeftTee",
                CursorType::Leftbutton => "Leftbutton",
                CursorType::LlAngle => "LlAngle",
                CursorType::LrAngle => "LrAngle",
                CursorType::Man => "Man",
                CursorType::Middlebutton => "Middlebutton",
                CursorType::Mouse => "Mouse",
                CursorType::Pencil => "Pencil",
                CursorType::Pirate => "Pirate",
                CursorType::Plus => "Plus",
                CursorType::QuestionArrow => "QuestionArrow",
                CursorType::RightPtr => "RightPtr",
                CursorType::RightSide => "RightSide",
                CursorType::RightTee => "RightTee",
                CursorType::Rightbutton => "Rightbutton",
                CursorType::RtlLogo => "RtlLogo",
                CursorType::Sailboat => "Sailboat",
                CursorType::SbDownArrow => "SbDownArrow",
                CursorType::SbHDoubleArrow => "SbHDoubleArrow",
                CursorType::SbLeftArrow => "SbLeftArrow",
                CursorType::SbRightArrow => "SbRightArrow",
                CursorType::SbUpArrow => "SbUpArrow",
                CursorType::SbVDoubleArrow => "SbVDoubleArrow",
                CursorType::Shuttle => "Shuttle",
                CursorType::Sizing => "Sizing",
                CursorType::Spider => "Spider",
                CursorType::Spraycan => "Spraycan",
                CursorType::Star => "Star",
                CursorType::Target => "Target",
                CursorType::Tcross => "Tcross",
                CursorType::TopLeftArrow => "TopLeftArrow",
                CursorType::TopLeftCorner => "TopLeftCorner",
                CursorType::TopRightCorner => "TopRightCorner",
                CursorType::TopSide => "TopSide",
                CursorType::TopTee => "TopTee",
                CursorType::Trek => "Trek",
                CursorType::UlAngle => "UlAngle",
                CursorType::Umbrella => "Umbrella",
                CursorType::UrAngle => "UrAngle",
                CursorType::Watch => "Watch",
                CursorType::Xterm => "Xterm",
                CursorType::LastCursor => "LastCursor",
                CursorType::BlankCursor => "BlankCursor",
                CursorType::CursorIsPixmap => "CursorIsPixmap",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for CursorType {
    type GlibType = gdk_sys::GdkCursorType;

    fn to_glib(&self) -> gdk_sys::GdkCursorType {
        match *self {
            CursorType::XCursor => gdk_sys::GDK_X_CURSOR,
            CursorType::Arrow => gdk_sys::GDK_ARROW,
            CursorType::BasedArrowDown => gdk_sys::GDK_BASED_ARROW_DOWN,
            CursorType::BasedArrowUp => gdk_sys::GDK_BASED_ARROW_UP,
            CursorType::Boat => gdk_sys::GDK_BOAT,
            CursorType::Bogosity => gdk_sys::GDK_BOGOSITY,
            CursorType::BottomLeftCorner => gdk_sys::GDK_BOTTOM_LEFT_CORNER,
            CursorType::BottomRightCorner => gdk_sys::GDK_BOTTOM_RIGHT_CORNER,
            CursorType::BottomSide => gdk_sys::GDK_BOTTOM_SIDE,
            CursorType::BottomTee => gdk_sys::GDK_BOTTOM_TEE,
            CursorType::BoxSpiral => gdk_sys::GDK_BOX_SPIRAL,
            CursorType::CenterPtr => gdk_sys::GDK_CENTER_PTR,
            CursorType::Circle => gdk_sys::GDK_CIRCLE,
            CursorType::Clock => gdk_sys::GDK_CLOCK,
            CursorType::CoffeeMug => gdk_sys::GDK_COFFEE_MUG,
            CursorType::Cross => gdk_sys::GDK_CROSS,
            CursorType::CrossReverse => gdk_sys::GDK_CROSS_REVERSE,
            CursorType::Crosshair => gdk_sys::GDK_CROSSHAIR,
            CursorType::DiamondCross => gdk_sys::GDK_DIAMOND_CROSS,
            CursorType::Dot => gdk_sys::GDK_DOT,
            CursorType::Dotbox => gdk_sys::GDK_DOTBOX,
            CursorType::DoubleArrow => gdk_sys::GDK_DOUBLE_ARROW,
            CursorType::DraftLarge => gdk_sys::GDK_DRAFT_LARGE,
            CursorType::DraftSmall => gdk_sys::GDK_DRAFT_SMALL,
            CursorType::DrapedBox => gdk_sys::GDK_DRAPED_BOX,
            CursorType::Exchange => gdk_sys::GDK_EXCHANGE,
            CursorType::Fleur => gdk_sys::GDK_FLEUR,
            CursorType::Gobbler => gdk_sys::GDK_GOBBLER,
            CursorType::Gumby => gdk_sys::GDK_GUMBY,
            CursorType::Hand1 => gdk_sys::GDK_HAND1,
            CursorType::Hand2 => gdk_sys::GDK_HAND2,
            CursorType::Heart => gdk_sys::GDK_HEART,
            CursorType::Icon => gdk_sys::GDK_ICON,
            CursorType::IronCross => gdk_sys::GDK_IRON_CROSS,
            CursorType::LeftPtr => gdk_sys::GDK_LEFT_PTR,
            CursorType::LeftSide => gdk_sys::GDK_LEFT_SIDE,
            CursorType::LeftTee => gdk_sys::GDK_LEFT_TEE,
            CursorType::Leftbutton => gdk_sys::GDK_LEFTBUTTON,
            CursorType::LlAngle => gdk_sys::GDK_LL_ANGLE,
            CursorType::LrAngle => gdk_sys::GDK_LR_ANGLE,
            CursorType::Man => gdk_sys::GDK_MAN,
            CursorType::Middlebutton => gdk_sys::GDK_MIDDLEBUTTON,
            CursorType::Mouse => gdk_sys::GDK_MOUSE,
            CursorType::Pencil => gdk_sys::GDK_PENCIL,
            CursorType::Pirate => gdk_sys::GDK_PIRATE,
            CursorType::Plus => gdk_sys::GDK_PLUS,
            CursorType::QuestionArrow => gdk_sys::GDK_QUESTION_ARROW,
            CursorType::RightPtr => gdk_sys::GDK_RIGHT_PTR,
            CursorType::RightSide => gdk_sys::GDK_RIGHT_SIDE,
            CursorType::RightTee => gdk_sys::GDK_RIGHT_TEE,
            CursorType::Rightbutton => gdk_sys::GDK_RIGHTBUTTON,
            CursorType::RtlLogo => gdk_sys::GDK_RTL_LOGO,
            CursorType::Sailboat => gdk_sys::GDK_SAILBOAT,
            CursorType::SbDownArrow => gdk_sys::GDK_SB_DOWN_ARROW,
            CursorType::SbHDoubleArrow => gdk_sys::GDK_SB_H_DOUBLE_ARROW,
            CursorType::SbLeftArrow => gdk_sys::GDK_SB_LEFT_ARROW,
            CursorType::SbRightArrow => gdk_sys::GDK_SB_RIGHT_ARROW,
            CursorType::SbUpArrow => gdk_sys::GDK_SB_UP_ARROW,
            CursorType::SbVDoubleArrow => gdk_sys::GDK_SB_V_DOUBLE_ARROW,
            CursorType::Shuttle => gdk_sys::GDK_SHUTTLE,
            CursorType::Sizing => gdk_sys::GDK_SIZING,
            CursorType::Spider => gdk_sys::GDK_SPIDER,
            CursorType::Spraycan => gdk_sys::GDK_SPRAYCAN,
            CursorType::Star => gdk_sys::GDK_STAR,
            CursorType::Target => gdk_sys::GDK_TARGET,
            CursorType::Tcross => gdk_sys::GDK_TCROSS,
            CursorType::TopLeftArrow => gdk_sys::GDK_TOP_LEFT_ARROW,
            CursorType::TopLeftCorner => gdk_sys::GDK_TOP_LEFT_CORNER,
            CursorType::TopRightCorner => gdk_sys::GDK_TOP_RIGHT_CORNER,
            CursorType::TopSide => gdk_sys::GDK_TOP_SIDE,
            CursorType::TopTee => gdk_sys::GDK_TOP_TEE,
            CursorType::Trek => gdk_sys::GDK_TREK,
            CursorType::UlAngle => gdk_sys::GDK_UL_ANGLE,
            CursorType::Umbrella => gdk_sys::GDK_UMBRELLA,
            CursorType::UrAngle => gdk_sys::GDK_UR_ANGLE,
            CursorType::Watch => gdk_sys::GDK_WATCH,
            CursorType::Xterm => gdk_sys::GDK_XTERM,
            CursorType::LastCursor => gdk_sys::GDK_LAST_CURSOR,
            CursorType::BlankCursor => gdk_sys::GDK_BLANK_CURSOR,
            CursorType::CursorIsPixmap => gdk_sys::GDK_CURSOR_IS_PIXMAP,
            CursorType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkCursorType> for CursorType {
    fn from_glib(value: gdk_sys::GdkCursorType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => CursorType::XCursor,
            2 => CursorType::Arrow,
            4 => CursorType::BasedArrowDown,
            6 => CursorType::BasedArrowUp,
            8 => CursorType::Boat,
            10 => CursorType::Bogosity,
            12 => CursorType::BottomLeftCorner,
            14 => CursorType::BottomRightCorner,
            16 => CursorType::BottomSide,
            18 => CursorType::BottomTee,
            20 => CursorType::BoxSpiral,
            22 => CursorType::CenterPtr,
            24 => CursorType::Circle,
            26 => CursorType::Clock,
            28 => CursorType::CoffeeMug,
            30 => CursorType::Cross,
            32 => CursorType::CrossReverse,
            34 => CursorType::Crosshair,
            36 => CursorType::DiamondCross,
            38 => CursorType::Dot,
            40 => CursorType::Dotbox,
            42 => CursorType::DoubleArrow,
            44 => CursorType::DraftLarge,
            46 => CursorType::DraftSmall,
            48 => CursorType::DrapedBox,
            50 => CursorType::Exchange,
            52 => CursorType::Fleur,
            54 => CursorType::Gobbler,
            56 => CursorType::Gumby,
            58 => CursorType::Hand1,
            60 => CursorType::Hand2,
            62 => CursorType::Heart,
            64 => CursorType::Icon,
            66 => CursorType::IronCross,
            68 => CursorType::LeftPtr,
            70 => CursorType::LeftSide,
            72 => CursorType::LeftTee,
            74 => CursorType::Leftbutton,
            76 => CursorType::LlAngle,
            78 => CursorType::LrAngle,
            80 => CursorType::Man,
            82 => CursorType::Middlebutton,
            84 => CursorType::Mouse,
            86 => CursorType::Pencil,
            88 => CursorType::Pirate,
            90 => CursorType::Plus,
            92 => CursorType::QuestionArrow,
            94 => CursorType::RightPtr,
            96 => CursorType::RightSide,
            98 => CursorType::RightTee,
            100 => CursorType::Rightbutton,
            102 => CursorType::RtlLogo,
            104 => CursorType::Sailboat,
            106 => CursorType::SbDownArrow,
            108 => CursorType::SbHDoubleArrow,
            110 => CursorType::SbLeftArrow,
            112 => CursorType::SbRightArrow,
            114 => CursorType::SbUpArrow,
            116 => CursorType::SbVDoubleArrow,
            118 => CursorType::Shuttle,
            120 => CursorType::Sizing,
            122 => CursorType::Spider,
            124 => CursorType::Spraycan,
            126 => CursorType::Star,
            128 => CursorType::Target,
            130 => CursorType::Tcross,
            132 => CursorType::TopLeftArrow,
            134 => CursorType::TopLeftCorner,
            136 => CursorType::TopRightCorner,
            138 => CursorType::TopSide,
            140 => CursorType::TopTee,
            142 => CursorType::Trek,
            144 => CursorType::UlAngle,
            146 => CursorType::Umbrella,
            148 => CursorType::UrAngle,
            150 => CursorType::Watch,
            152 => CursorType::Xterm,
            153 => CursorType::LastCursor,
            -2 => CursorType::BlankCursor,
            -1 => CursorType::CursorIsPixmap,
            value => CursorType::__Unknown(value),
        }
    }
}

impl StaticType for CursorType {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_cursor_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for CursorType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for CursorType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for CursorType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum DevicePadFeature {
    Button,
    Ring,
    Strip,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl fmt::Display for DevicePadFeature {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "DevicePadFeature::{}",
            match *self {
                DevicePadFeature::Button => "Button",
                DevicePadFeature::Ring => "Ring",
                DevicePadFeature::Strip => "Strip",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[doc(hidden)]
impl ToGlib for DevicePadFeature {
    type GlibType = gdk_sys::GdkDevicePadFeature;

    fn to_glib(&self) -> gdk_sys::GdkDevicePadFeature {
        match *self {
            DevicePadFeature::Button => gdk_sys::GDK_DEVICE_PAD_FEATURE_BUTTON,
            DevicePadFeature::Ring => gdk_sys::GDK_DEVICE_PAD_FEATURE_RING,
            DevicePadFeature::Strip => gdk_sys::GDK_DEVICE_PAD_FEATURE_STRIP,
            DevicePadFeature::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[doc(hidden)]
impl FromGlib<gdk_sys::GdkDevicePadFeature> for DevicePadFeature {
    fn from_glib(value: gdk_sys::GdkDevicePadFeature) -> Self {
        skip_assert_initialized!();
        match value {
            0 => DevicePadFeature::Button,
            1 => DevicePadFeature::Ring,
            2 => DevicePadFeature::Strip,
            value => DevicePadFeature::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl StaticType for DevicePadFeature {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_device_pad_feature_get_type()) }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl<'a> FromValueOptional<'a> for DevicePadFeature {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl<'a> FromValue<'a> for DevicePadFeature {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl SetValue for DevicePadFeature {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum DeviceToolType {
    Unknown,
    Pen,
    Eraser,
    Brush,
    Pencil,
    Airbrush,
    Mouse,
    Lens,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl fmt::Display for DeviceToolType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "DeviceToolType::{}",
            match *self {
                DeviceToolType::Unknown => "Unknown",
                DeviceToolType::Pen => "Pen",
                DeviceToolType::Eraser => "Eraser",
                DeviceToolType::Brush => "Brush",
                DeviceToolType::Pencil => "Pencil",
                DeviceToolType::Airbrush => "Airbrush",
                DeviceToolType::Mouse => "Mouse",
                DeviceToolType::Lens => "Lens",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[doc(hidden)]
impl ToGlib for DeviceToolType {
    type GlibType = gdk_sys::GdkDeviceToolType;

    fn to_glib(&self) -> gdk_sys::GdkDeviceToolType {
        match *self {
            DeviceToolType::Unknown => gdk_sys::GDK_DEVICE_TOOL_TYPE_UNKNOWN,
            DeviceToolType::Pen => gdk_sys::GDK_DEVICE_TOOL_TYPE_PEN,
            DeviceToolType::Eraser => gdk_sys::GDK_DEVICE_TOOL_TYPE_ERASER,
            DeviceToolType::Brush => gdk_sys::GDK_DEVICE_TOOL_TYPE_BRUSH,
            DeviceToolType::Pencil => gdk_sys::GDK_DEVICE_TOOL_TYPE_PENCIL,
            DeviceToolType::Airbrush => gdk_sys::GDK_DEVICE_TOOL_TYPE_AIRBRUSH,
            DeviceToolType::Mouse => gdk_sys::GDK_DEVICE_TOOL_TYPE_MOUSE,
            DeviceToolType::Lens => gdk_sys::GDK_DEVICE_TOOL_TYPE_LENS,
            DeviceToolType::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[doc(hidden)]
impl FromGlib<gdk_sys::GdkDeviceToolType> for DeviceToolType {
    fn from_glib(value: gdk_sys::GdkDeviceToolType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => DeviceToolType::Unknown,
            1 => DeviceToolType::Pen,
            2 => DeviceToolType::Eraser,
            3 => DeviceToolType::Brush,
            4 => DeviceToolType::Pencil,
            5 => DeviceToolType::Airbrush,
            6 => DeviceToolType::Mouse,
            7 => DeviceToolType::Lens,
            value => DeviceToolType::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl StaticType for DeviceToolType {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_device_tool_type_get_type()) }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl<'a> FromValueOptional<'a> for DeviceToolType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl<'a> FromValue<'a> for DeviceToolType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl SetValue for DeviceToolType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum DeviceType {
    Master,
    Slave,
    Floating,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for DeviceType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "DeviceType::{}",
            match *self {
                DeviceType::Master => "Master",
                DeviceType::Slave => "Slave",
                DeviceType::Floating => "Floating",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for DeviceType {
    type GlibType = gdk_sys::GdkDeviceType;

    fn to_glib(&self) -> gdk_sys::GdkDeviceType {
        match *self {
            DeviceType::Master => gdk_sys::GDK_DEVICE_TYPE_MASTER,
            DeviceType::Slave => gdk_sys::GDK_DEVICE_TYPE_SLAVE,
            DeviceType::Floating => gdk_sys::GDK_DEVICE_TYPE_FLOATING,
            DeviceType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkDeviceType> for DeviceType {
    fn from_glib(value: gdk_sys::GdkDeviceType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => DeviceType::Master,
            1 => DeviceType::Slave,
            2 => DeviceType::Floating,
            value => DeviceType::__Unknown(value),
        }
    }
}

impl StaticType for DeviceType {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_device_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for DeviceType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for DeviceType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for DeviceType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum DragCancelReason {
    NoTarget,
    UserCancelled,
    Error,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
impl fmt::Display for DragCancelReason {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "DragCancelReason::{}",
            match *self {
                DragCancelReason::NoTarget => "NoTarget",
                DragCancelReason::UserCancelled => "UserCancelled",
                DragCancelReason::Error => "Error",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[doc(hidden)]
impl ToGlib for DragCancelReason {
    type GlibType = gdk_sys::GdkDragCancelReason;

    fn to_glib(&self) -> gdk_sys::GdkDragCancelReason {
        match *self {
            DragCancelReason::NoTarget => gdk_sys::GDK_DRAG_CANCEL_NO_TARGET,
            DragCancelReason::UserCancelled => gdk_sys::GDK_DRAG_CANCEL_USER_CANCELLED,
            DragCancelReason::Error => gdk_sys::GDK_DRAG_CANCEL_ERROR,
            DragCancelReason::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[doc(hidden)]
impl FromGlib<gdk_sys::GdkDragCancelReason> for DragCancelReason {
    fn from_glib(value: gdk_sys::GdkDragCancelReason) -> Self {
        skip_assert_initialized!();
        match value {
            0 => DragCancelReason::NoTarget,
            1 => DragCancelReason::UserCancelled,
            2 => DragCancelReason::Error,
            value => DragCancelReason::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
impl StaticType for DragCancelReason {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_drag_cancel_reason_get_type()) }
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
impl<'a> FromValueOptional<'a> for DragCancelReason {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
impl<'a> FromValue<'a> for DragCancelReason {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
impl SetValue for DragCancelReason {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum DragProtocol {
    None,
    Motif,
    Xdnd,
    Rootwin,
    Win32Dropfiles,
    Ole2,
    Local,
    Wayland,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for DragProtocol {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "DragProtocol::{}",
            match *self {
                DragProtocol::None => "None",
                DragProtocol::Motif => "Motif",
                DragProtocol::Xdnd => "Xdnd",
                DragProtocol::Rootwin => "Rootwin",
                DragProtocol::Win32Dropfiles => "Win32Dropfiles",
                DragProtocol::Ole2 => "Ole2",
                DragProtocol::Local => "Local",
                DragProtocol::Wayland => "Wayland",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for DragProtocol {
    type GlibType = gdk_sys::GdkDragProtocol;

    fn to_glib(&self) -> gdk_sys::GdkDragProtocol {
        match *self {
            DragProtocol::None => gdk_sys::GDK_DRAG_PROTO_NONE,
            DragProtocol::Motif => gdk_sys::GDK_DRAG_PROTO_MOTIF,
            DragProtocol::Xdnd => gdk_sys::GDK_DRAG_PROTO_XDND,
            DragProtocol::Rootwin => gdk_sys::GDK_DRAG_PROTO_ROOTWIN,
            DragProtocol::Win32Dropfiles => gdk_sys::GDK_DRAG_PROTO_WIN32_DROPFILES,
            DragProtocol::Ole2 => gdk_sys::GDK_DRAG_PROTO_OLE2,
            DragProtocol::Local => gdk_sys::GDK_DRAG_PROTO_LOCAL,
            DragProtocol::Wayland => gdk_sys::GDK_DRAG_PROTO_WAYLAND,
            DragProtocol::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkDragProtocol> for DragProtocol {
    fn from_glib(value: gdk_sys::GdkDragProtocol) -> Self {
        skip_assert_initialized!();
        match value {
            0 => DragProtocol::None,
            1 => DragProtocol::Motif,
            2 => DragProtocol::Xdnd,
            3 => DragProtocol::Rootwin,
            4 => DragProtocol::Win32Dropfiles,
            5 => DragProtocol::Ole2,
            6 => DragProtocol::Local,
            7 => DragProtocol::Wayland,
            value => DragProtocol::__Unknown(value),
        }
    }
}

impl StaticType for DragProtocol {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_drag_protocol_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for DragProtocol {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for DragProtocol {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for DragProtocol {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum EventType {
    Nothing,
    Delete,
    Destroy,
    Expose,
    MotionNotify,
    ButtonPress,
    DoubleButtonPress,
    TripleButtonPress,
    ButtonRelease,
    KeyPress,
    KeyRelease,
    EnterNotify,
    LeaveNotify,
    FocusChange,
    Configure,
    Map,
    Unmap,
    PropertyNotify,
    SelectionClear,
    SelectionRequest,
    SelectionNotify,
    ProximityIn,
    ProximityOut,
    DragEnter,
    DragLeave,
    DragMotion,
    DragStatus,
    DropStart,
    DropFinished,
    ClientEvent,
    VisibilityNotify,
    Scroll,
    WindowState,
    Setting,
    OwnerChange,
    GrabBroken,
    Damage,
    TouchBegin,
    TouchUpdate,
    TouchEnd,
    TouchCancel,
    #[cfg(any(feature = "v3_18", feature = "dox"))]
    TouchpadSwipe,
    #[cfg(any(feature = "v3_18", feature = "dox"))]
    TouchpadPinch,
    PadButtonPress,
    PadButtonRelease,
    PadRing,
    PadStrip,
    PadGroupMode,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for EventType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "EventType::{}",
            match *self {
                EventType::Nothing => "Nothing",
                EventType::Delete => "Delete",
                EventType::Destroy => "Destroy",
                EventType::Expose => "Expose",
                EventType::MotionNotify => "MotionNotify",
                EventType::ButtonPress => "ButtonPress",
                EventType::DoubleButtonPress => "DoubleButtonPress",
                EventType::TripleButtonPress => "TripleButtonPress",
                EventType::ButtonRelease => "ButtonRelease",
                EventType::KeyPress => "KeyPress",
                EventType::KeyRelease => "KeyRelease",
                EventType::EnterNotify => "EnterNotify",
                EventType::LeaveNotify => "LeaveNotify",
                EventType::FocusChange => "FocusChange",
                EventType::Configure => "Configure",
                EventType::Map => "Map",
                EventType::Unmap => "Unmap",
                EventType::PropertyNotify => "PropertyNotify",
                EventType::SelectionClear => "SelectionClear",
                EventType::SelectionRequest => "SelectionRequest",
                EventType::SelectionNotify => "SelectionNotify",
                EventType::ProximityIn => "ProximityIn",
                EventType::ProximityOut => "ProximityOut",
                EventType::DragEnter => "DragEnter",
                EventType::DragLeave => "DragLeave",
                EventType::DragMotion => "DragMotion",
                EventType::DragStatus => "DragStatus",
                EventType::DropStart => "DropStart",
                EventType::DropFinished => "DropFinished",
                EventType::ClientEvent => "ClientEvent",
                EventType::VisibilityNotify => "VisibilityNotify",
                EventType::Scroll => "Scroll",
                EventType::WindowState => "WindowState",
                EventType::Setting => "Setting",
                EventType::OwnerChange => "OwnerChange",
                EventType::GrabBroken => "GrabBroken",
                EventType::Damage => "Damage",
                EventType::TouchBegin => "TouchBegin",
                EventType::TouchUpdate => "TouchUpdate",
                EventType::TouchEnd => "TouchEnd",
                EventType::TouchCancel => "TouchCancel",
                #[cfg(any(feature = "v3_18", feature = "dox"))]
                EventType::TouchpadSwipe => "TouchpadSwipe",
                #[cfg(any(feature = "v3_18", feature = "dox"))]
                EventType::TouchpadPinch => "TouchpadPinch",
                EventType::PadButtonPress => "PadButtonPress",
                EventType::PadButtonRelease => "PadButtonRelease",
                EventType::PadRing => "PadRing",
                EventType::PadStrip => "PadStrip",
                EventType::PadGroupMode => "PadGroupMode",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for EventType {
    type GlibType = gdk_sys::GdkEventType;

    fn to_glib(&self) -> gdk_sys::GdkEventType {
        match *self {
            EventType::Nothing => gdk_sys::GDK_NOTHING,
            EventType::Delete => gdk_sys::GDK_DELETE,
            EventType::Destroy => gdk_sys::GDK_DESTROY,
            EventType::Expose => gdk_sys::GDK_EXPOSE,
            EventType::MotionNotify => gdk_sys::GDK_MOTION_NOTIFY,
            EventType::ButtonPress => gdk_sys::GDK_BUTTON_PRESS,
            EventType::DoubleButtonPress => gdk_sys::GDK_DOUBLE_BUTTON_PRESS,
            EventType::TripleButtonPress => gdk_sys::GDK_TRIPLE_BUTTON_PRESS,
            EventType::ButtonRelease => gdk_sys::GDK_BUTTON_RELEASE,
            EventType::KeyPress => gdk_sys::GDK_KEY_PRESS,
            EventType::KeyRelease => gdk_sys::GDK_KEY_RELEASE,
            EventType::EnterNotify => gdk_sys::GDK_ENTER_NOTIFY,
            EventType::LeaveNotify => gdk_sys::GDK_LEAVE_NOTIFY,
            EventType::FocusChange => gdk_sys::GDK_FOCUS_CHANGE,
            EventType::Configure => gdk_sys::GDK_CONFIGURE,
            EventType::Map => gdk_sys::GDK_MAP,
            EventType::Unmap => gdk_sys::GDK_UNMAP,
            EventType::PropertyNotify => gdk_sys::GDK_PROPERTY_NOTIFY,
            EventType::SelectionClear => gdk_sys::GDK_SELECTION_CLEAR,
            EventType::SelectionRequest => gdk_sys::GDK_SELECTION_REQUEST,
            EventType::SelectionNotify => gdk_sys::GDK_SELECTION_NOTIFY,
            EventType::ProximityIn => gdk_sys::GDK_PROXIMITY_IN,
            EventType::ProximityOut => gdk_sys::GDK_PROXIMITY_OUT,
            EventType::DragEnter => gdk_sys::GDK_DRAG_ENTER,
            EventType::DragLeave => gdk_sys::GDK_DRAG_LEAVE,
            EventType::DragMotion => gdk_sys::GDK_DRAG_MOTION,
            EventType::DragStatus => gdk_sys::GDK_DRAG_STATUS,
            EventType::DropStart => gdk_sys::GDK_DROP_START,
            EventType::DropFinished => gdk_sys::GDK_DROP_FINISHED,
            EventType::ClientEvent => gdk_sys::GDK_CLIENT_EVENT,
            EventType::VisibilityNotify => gdk_sys::GDK_VISIBILITY_NOTIFY,
            EventType::Scroll => gdk_sys::GDK_SCROLL,
            EventType::WindowState => gdk_sys::GDK_WINDOW_STATE,
            EventType::Setting => gdk_sys::GDK_SETTING,
            EventType::OwnerChange => gdk_sys::GDK_OWNER_CHANGE,
            EventType::GrabBroken => gdk_sys::GDK_GRAB_BROKEN,
            EventType::Damage => gdk_sys::GDK_DAMAGE,
            EventType::TouchBegin => gdk_sys::GDK_TOUCH_BEGIN,
            EventType::TouchUpdate => gdk_sys::GDK_TOUCH_UPDATE,
            EventType::TouchEnd => gdk_sys::GDK_TOUCH_END,
            EventType::TouchCancel => gdk_sys::GDK_TOUCH_CANCEL,
            #[cfg(any(feature = "v3_18", feature = "dox"))]
            EventType::TouchpadSwipe => gdk_sys::GDK_TOUCHPAD_SWIPE,
            #[cfg(any(feature = "v3_18", feature = "dox"))]
            EventType::TouchpadPinch => gdk_sys::GDK_TOUCHPAD_PINCH,
            EventType::PadButtonPress => gdk_sys::GDK_PAD_BUTTON_PRESS,
            EventType::PadButtonRelease => gdk_sys::GDK_PAD_BUTTON_RELEASE,
            EventType::PadRing => gdk_sys::GDK_PAD_RING,
            EventType::PadStrip => gdk_sys::GDK_PAD_STRIP,
            EventType::PadGroupMode => gdk_sys::GDK_PAD_GROUP_MODE,
            EventType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkEventType> for EventType {
    fn from_glib(value: gdk_sys::GdkEventType) -> Self {
        skip_assert_initialized!();
        match value {
            -1 => EventType::Nothing,
            0 => EventType::Delete,
            1 => EventType::Destroy,
            2 => EventType::Expose,
            3 => EventType::MotionNotify,
            4 => EventType::ButtonPress,
            5 => EventType::DoubleButtonPress,
            6 => EventType::TripleButtonPress,
            7 => EventType::ButtonRelease,
            8 => EventType::KeyPress,
            9 => EventType::KeyRelease,
            10 => EventType::EnterNotify,
            11 => EventType::LeaveNotify,
            12 => EventType::FocusChange,
            13 => EventType::Configure,
            14 => EventType::Map,
            15 => EventType::Unmap,
            16 => EventType::PropertyNotify,
            17 => EventType::SelectionClear,
            18 => EventType::SelectionRequest,
            19 => EventType::SelectionNotify,
            20 => EventType::ProximityIn,
            21 => EventType::ProximityOut,
            22 => EventType::DragEnter,
            23 => EventType::DragLeave,
            24 => EventType::DragMotion,
            25 => EventType::DragStatus,
            26 => EventType::DropStart,
            27 => EventType::DropFinished,
            28 => EventType::ClientEvent,
            29 => EventType::VisibilityNotify,
            31 => EventType::Scroll,
            32 => EventType::WindowState,
            33 => EventType::Setting,
            34 => EventType::OwnerChange,
            35 => EventType::GrabBroken,
            36 => EventType::Damage,
            37 => EventType::TouchBegin,
            38 => EventType::TouchUpdate,
            39 => EventType::TouchEnd,
            40 => EventType::TouchCancel,
            #[cfg(any(feature = "v3_18", feature = "dox"))]
            41 => EventType::TouchpadSwipe,
            #[cfg(any(feature = "v3_18", feature = "dox"))]
            42 => EventType::TouchpadPinch,
            43 => EventType::PadButtonPress,
            44 => EventType::PadButtonRelease,
            45 => EventType::PadRing,
            46 => EventType::PadStrip,
            47 => EventType::PadGroupMode,
            value => EventType::__Unknown(value),
        }
    }
}

impl StaticType for EventType {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_event_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for EventType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for EventType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for EventType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum FullscreenMode {
    CurrentMonitor,
    AllMonitors,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FullscreenMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FullscreenMode::{}",
            match *self {
                FullscreenMode::CurrentMonitor => "CurrentMonitor",
                FullscreenMode::AllMonitors => "AllMonitors",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for FullscreenMode {
    type GlibType = gdk_sys::GdkFullscreenMode;

    fn to_glib(&self) -> gdk_sys::GdkFullscreenMode {
        match *self {
            FullscreenMode::CurrentMonitor => gdk_sys::GDK_FULLSCREEN_ON_CURRENT_MONITOR,
            FullscreenMode::AllMonitors => gdk_sys::GDK_FULLSCREEN_ON_ALL_MONITORS,
            FullscreenMode::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkFullscreenMode> for FullscreenMode {
    fn from_glib(value: gdk_sys::GdkFullscreenMode) -> Self {
        skip_assert_initialized!();
        match value {
            0 => FullscreenMode::CurrentMonitor,
            1 => FullscreenMode::AllMonitors,
            value => FullscreenMode::__Unknown(value),
        }
    }
}

impl StaticType for FullscreenMode {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_fullscreen_mode_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for FullscreenMode {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for FullscreenMode {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for FullscreenMode {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum GLError {
    NotAvailable,
    UnsupportedFormat,
    UnsupportedProfile,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
impl fmt::Display for GLError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "GLError::{}",
            match *self {
                GLError::NotAvailable => "NotAvailable",
                GLError::UnsupportedFormat => "UnsupportedFormat",
                GLError::UnsupportedProfile => "UnsupportedProfile",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
#[doc(hidden)]
impl ToGlib for GLError {
    type GlibType = gdk_sys::GdkGLError;

    fn to_glib(&self) -> gdk_sys::GdkGLError {
        match *self {
            GLError::NotAvailable => gdk_sys::GDK_GL_ERROR_NOT_AVAILABLE,
            GLError::UnsupportedFormat => gdk_sys::GDK_GL_ERROR_UNSUPPORTED_FORMAT,
            GLError::UnsupportedProfile => gdk_sys::GDK_GL_ERROR_UNSUPPORTED_PROFILE,
            GLError::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
#[doc(hidden)]
impl FromGlib<gdk_sys::GdkGLError> for GLError {
    fn from_glib(value: gdk_sys::GdkGLError) -> Self {
        skip_assert_initialized!();
        match value {
            0 => GLError::NotAvailable,
            1 => GLError::UnsupportedFormat,
            2 => GLError::UnsupportedProfile,
            value => GLError::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
impl ErrorDomain for GLError {
    fn domain() -> Quark {
        skip_assert_initialized!();
        unsafe { from_glib(gdk_sys::gdk_gl_error_quark()) }
    }

    fn code(self) -> i32 {
        self.to_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            0 => Some(GLError::NotAvailable),
            1 => Some(GLError::UnsupportedFormat),
            2 => Some(GLError::UnsupportedProfile),
            value => Some(GLError::__Unknown(value)),
        }
    }
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
impl StaticType for GLError {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_gl_error_get_type()) }
    }
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
impl<'a> FromValueOptional<'a> for GLError {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
impl<'a> FromValue<'a> for GLError {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
impl SetValue for GLError {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum GrabOwnership {
    None,
    Window,
    Application,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for GrabOwnership {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "GrabOwnership::{}",
            match *self {
                GrabOwnership::None => "None",
                GrabOwnership::Window => "Window",
                GrabOwnership::Application => "Application",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for GrabOwnership {
    type GlibType = gdk_sys::GdkGrabOwnership;

    fn to_glib(&self) -> gdk_sys::GdkGrabOwnership {
        match *self {
            GrabOwnership::None => gdk_sys::GDK_OWNERSHIP_NONE,
            GrabOwnership::Window => gdk_sys::GDK_OWNERSHIP_WINDOW,
            GrabOwnership::Application => gdk_sys::GDK_OWNERSHIP_APPLICATION,
            GrabOwnership::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkGrabOwnership> for GrabOwnership {
    fn from_glib(value: gdk_sys::GdkGrabOwnership) -> Self {
        skip_assert_initialized!();
        match value {
            0 => GrabOwnership::None,
            1 => GrabOwnership::Window,
            2 => GrabOwnership::Application,
            value => GrabOwnership::__Unknown(value),
        }
    }
}

impl StaticType for GrabOwnership {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_grab_ownership_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for GrabOwnership {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for GrabOwnership {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for GrabOwnership {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum GrabStatus {
    Success,
    AlreadyGrabbed,
    InvalidTime,
    NotViewable,
    Frozen,
    Failed,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for GrabStatus {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "GrabStatus::{}",
            match *self {
                GrabStatus::Success => "Success",
                GrabStatus::AlreadyGrabbed => "AlreadyGrabbed",
                GrabStatus::InvalidTime => "InvalidTime",
                GrabStatus::NotViewable => "NotViewable",
                GrabStatus::Frozen => "Frozen",
                GrabStatus::Failed => "Failed",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for GrabStatus {
    type GlibType = gdk_sys::GdkGrabStatus;

    fn to_glib(&self) -> gdk_sys::GdkGrabStatus {
        match *self {
            GrabStatus::Success => gdk_sys::GDK_GRAB_SUCCESS,
            GrabStatus::AlreadyGrabbed => gdk_sys::GDK_GRAB_ALREADY_GRABBED,
            GrabStatus::InvalidTime => gdk_sys::GDK_GRAB_INVALID_TIME,
            GrabStatus::NotViewable => gdk_sys::GDK_GRAB_NOT_VIEWABLE,
            GrabStatus::Frozen => gdk_sys::GDK_GRAB_FROZEN,
            GrabStatus::Failed => gdk_sys::GDK_GRAB_FAILED,
            GrabStatus::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkGrabStatus> for GrabStatus {
    fn from_glib(value: gdk_sys::GdkGrabStatus) -> Self {
        skip_assert_initialized!();
        match value {
            0 => GrabStatus::Success,
            1 => GrabStatus::AlreadyGrabbed,
            2 => GrabStatus::InvalidTime,
            3 => GrabStatus::NotViewable,
            4 => GrabStatus::Frozen,
            5 => GrabStatus::Failed,
            value => GrabStatus::__Unknown(value),
        }
    }
}

impl StaticType for GrabStatus {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_grab_status_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for GrabStatus {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for GrabStatus {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for GrabStatus {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum Gravity {
    NorthWest,
    North,
    NorthEast,
    West,
    Center,
    East,
    SouthWest,
    South,
    SouthEast,
    Static,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Gravity {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Gravity::{}",
            match *self {
                Gravity::NorthWest => "NorthWest",
                Gravity::North => "North",
                Gravity::NorthEast => "NorthEast",
                Gravity::West => "West",
                Gravity::Center => "Center",
                Gravity::East => "East",
                Gravity::SouthWest => "SouthWest",
                Gravity::South => "South",
                Gravity::SouthEast => "SouthEast",
                Gravity::Static => "Static",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for Gravity {
    type GlibType = gdk_sys::GdkGravity;

    fn to_glib(&self) -> gdk_sys::GdkGravity {
        match *self {
            Gravity::NorthWest => gdk_sys::GDK_GRAVITY_NORTH_WEST,
            Gravity::North => gdk_sys::GDK_GRAVITY_NORTH,
            Gravity::NorthEast => gdk_sys::GDK_GRAVITY_NORTH_EAST,
            Gravity::West => gdk_sys::GDK_GRAVITY_WEST,
            Gravity::Center => gdk_sys::GDK_GRAVITY_CENTER,
            Gravity::East => gdk_sys::GDK_GRAVITY_EAST,
            Gravity::SouthWest => gdk_sys::GDK_GRAVITY_SOUTH_WEST,
            Gravity::South => gdk_sys::GDK_GRAVITY_SOUTH,
            Gravity::SouthEast => gdk_sys::GDK_GRAVITY_SOUTH_EAST,
            Gravity::Static => gdk_sys::GDK_GRAVITY_STATIC,
            Gravity::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkGravity> for Gravity {
    fn from_glib(value: gdk_sys::GdkGravity) -> Self {
        skip_assert_initialized!();
        match value {
            1 => Gravity::NorthWest,
            2 => Gravity::North,
            3 => Gravity::NorthEast,
            4 => Gravity::West,
            5 => Gravity::Center,
            6 => Gravity::East,
            7 => Gravity::SouthWest,
            8 => Gravity::South,
            9 => Gravity::SouthEast,
            10 => Gravity::Static,
            value => Gravity::__Unknown(value),
        }
    }
}

impl StaticType for Gravity {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_gravity_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for Gravity {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for Gravity {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for Gravity {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum InputMode {
    Disabled,
    Screen,
    Window,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for InputMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "InputMode::{}",
            match *self {
                InputMode::Disabled => "Disabled",
                InputMode::Screen => "Screen",
                InputMode::Window => "Window",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for InputMode {
    type GlibType = gdk_sys::GdkInputMode;

    fn to_glib(&self) -> gdk_sys::GdkInputMode {
        match *self {
            InputMode::Disabled => gdk_sys::GDK_MODE_DISABLED,
            InputMode::Screen => gdk_sys::GDK_MODE_SCREEN,
            InputMode::Window => gdk_sys::GDK_MODE_WINDOW,
            InputMode::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkInputMode> for InputMode {
    fn from_glib(value: gdk_sys::GdkInputMode) -> Self {
        skip_assert_initialized!();
        match value {
            0 => InputMode::Disabled,
            1 => InputMode::Screen,
            2 => InputMode::Window,
            value => InputMode::__Unknown(value),
        }
    }
}

impl StaticType for InputMode {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_input_mode_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for InputMode {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for InputMode {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for InputMode {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum InputSource {
    Mouse,
    Pen,
    Eraser,
    Cursor,
    Keyboard,
    Touchscreen,
    Touchpad,
    Trackpoint,
    TabletPad,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for InputSource {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "InputSource::{}",
            match *self {
                InputSource::Mouse => "Mouse",
                InputSource::Pen => "Pen",
                InputSource::Eraser => "Eraser",
                InputSource::Cursor => "Cursor",
                InputSource::Keyboard => "Keyboard",
                InputSource::Touchscreen => "Touchscreen",
                InputSource::Touchpad => "Touchpad",
                InputSource::Trackpoint => "Trackpoint",
                InputSource::TabletPad => "TabletPad",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for InputSource {
    type GlibType = gdk_sys::GdkInputSource;

    fn to_glib(&self) -> gdk_sys::GdkInputSource {
        match *self {
            InputSource::Mouse => gdk_sys::GDK_SOURCE_MOUSE,
            InputSource::Pen => gdk_sys::GDK_SOURCE_PEN,
            InputSource::Eraser => gdk_sys::GDK_SOURCE_ERASER,
            InputSource::Cursor => gdk_sys::GDK_SOURCE_CURSOR,
            InputSource::Keyboard => gdk_sys::GDK_SOURCE_KEYBOARD,
            InputSource::Touchscreen => gdk_sys::GDK_SOURCE_TOUCHSCREEN,
            InputSource::Touchpad => gdk_sys::GDK_SOURCE_TOUCHPAD,
            InputSource::Trackpoint => gdk_sys::GDK_SOURCE_TRACKPOINT,
            InputSource::TabletPad => gdk_sys::GDK_SOURCE_TABLET_PAD,
            InputSource::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkInputSource> for InputSource {
    fn from_glib(value: gdk_sys::GdkInputSource) -> Self {
        skip_assert_initialized!();
        match value {
            0 => InputSource::Mouse,
            1 => InputSource::Pen,
            2 => InputSource::Eraser,
            3 => InputSource::Cursor,
            4 => InputSource::Keyboard,
            5 => InputSource::Touchscreen,
            6 => InputSource::Touchpad,
            7 => InputSource::Trackpoint,
            8 => InputSource::TabletPad,
            value => InputSource::__Unknown(value),
        }
    }
}

impl StaticType for InputSource {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_input_source_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for InputSource {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for InputSource {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for InputSource {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum ModifierIntent {
    PrimaryAccelerator,
    ContextMenu,
    ExtendSelection,
    ModifySelection,
    NoTextInput,
    ShiftGroup,
    DefaultModMask,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ModifierIntent {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ModifierIntent::{}",
            match *self {
                ModifierIntent::PrimaryAccelerator => "PrimaryAccelerator",
                ModifierIntent::ContextMenu => "ContextMenu",
                ModifierIntent::ExtendSelection => "ExtendSelection",
                ModifierIntent::ModifySelection => "ModifySelection",
                ModifierIntent::NoTextInput => "NoTextInput",
                ModifierIntent::ShiftGroup => "ShiftGroup",
                ModifierIntent::DefaultModMask => "DefaultModMask",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for ModifierIntent {
    type GlibType = gdk_sys::GdkModifierIntent;

    fn to_glib(&self) -> gdk_sys::GdkModifierIntent {
        match *self {
            ModifierIntent::PrimaryAccelerator => gdk_sys::GDK_MODIFIER_INTENT_PRIMARY_ACCELERATOR,
            ModifierIntent::ContextMenu => gdk_sys::GDK_MODIFIER_INTENT_CONTEXT_MENU,
            ModifierIntent::ExtendSelection => gdk_sys::GDK_MODIFIER_INTENT_EXTEND_SELECTION,
            ModifierIntent::ModifySelection => gdk_sys::GDK_MODIFIER_INTENT_MODIFY_SELECTION,
            ModifierIntent::NoTextInput => gdk_sys::GDK_MODIFIER_INTENT_NO_TEXT_INPUT,
            ModifierIntent::ShiftGroup => gdk_sys::GDK_MODIFIER_INTENT_SHIFT_GROUP,
            ModifierIntent::DefaultModMask => gdk_sys::GDK_MODIFIER_INTENT_DEFAULT_MOD_MASK,
            ModifierIntent::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkModifierIntent> for ModifierIntent {
    fn from_glib(value: gdk_sys::GdkModifierIntent) -> Self {
        skip_assert_initialized!();
        match value {
            0 => ModifierIntent::PrimaryAccelerator,
            1 => ModifierIntent::ContextMenu,
            2 => ModifierIntent::ExtendSelection,
            3 => ModifierIntent::ModifySelection,
            4 => ModifierIntent::NoTextInput,
            5 => ModifierIntent::ShiftGroup,
            6 => ModifierIntent::DefaultModMask,
            value => ModifierIntent::__Unknown(value),
        }
    }
}

impl StaticType for ModifierIntent {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_modifier_intent_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for ModifierIntent {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for ModifierIntent {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for ModifierIntent {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum NotifyType {
    Ancestor,
    Virtual,
    Inferior,
    Nonlinear,
    NonlinearVirtual,
    Unknown,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for NotifyType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "NotifyType::{}",
            match *self {
                NotifyType::Ancestor => "Ancestor",
                NotifyType::Virtual => "Virtual",
                NotifyType::Inferior => "Inferior",
                NotifyType::Nonlinear => "Nonlinear",
                NotifyType::NonlinearVirtual => "NonlinearVirtual",
                NotifyType::Unknown => "Unknown",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for NotifyType {
    type GlibType = gdk_sys::GdkNotifyType;

    fn to_glib(&self) -> gdk_sys::GdkNotifyType {
        match *self {
            NotifyType::Ancestor => gdk_sys::GDK_NOTIFY_ANCESTOR,
            NotifyType::Virtual => gdk_sys::GDK_NOTIFY_VIRTUAL,
            NotifyType::Inferior => gdk_sys::GDK_NOTIFY_INFERIOR,
            NotifyType::Nonlinear => gdk_sys::GDK_NOTIFY_NONLINEAR,
            NotifyType::NonlinearVirtual => gdk_sys::GDK_NOTIFY_NONLINEAR_VIRTUAL,
            NotifyType::Unknown => gdk_sys::GDK_NOTIFY_UNKNOWN,
            NotifyType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkNotifyType> for NotifyType {
    fn from_glib(value: gdk_sys::GdkNotifyType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => NotifyType::Ancestor,
            1 => NotifyType::Virtual,
            2 => NotifyType::Inferior,
            3 => NotifyType::Nonlinear,
            4 => NotifyType::NonlinearVirtual,
            5 => NotifyType::Unknown,
            value => NotifyType::__Unknown(value),
        }
    }
}

impl StaticType for NotifyType {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_notify_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for NotifyType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for NotifyType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for NotifyType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum OwnerChange {
    NewOwner,
    Destroy,
    Close,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for OwnerChange {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "OwnerChange::{}",
            match *self {
                OwnerChange::NewOwner => "NewOwner",
                OwnerChange::Destroy => "Destroy",
                OwnerChange::Close => "Close",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for OwnerChange {
    type GlibType = gdk_sys::GdkOwnerChange;

    fn to_glib(&self) -> gdk_sys::GdkOwnerChange {
        match *self {
            OwnerChange::NewOwner => gdk_sys::GDK_OWNER_CHANGE_NEW_OWNER,
            OwnerChange::Destroy => gdk_sys::GDK_OWNER_CHANGE_DESTROY,
            OwnerChange::Close => gdk_sys::GDK_OWNER_CHANGE_CLOSE,
            OwnerChange::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkOwnerChange> for OwnerChange {
    fn from_glib(value: gdk_sys::GdkOwnerChange) -> Self {
        skip_assert_initialized!();
        match value {
            0 => OwnerChange::NewOwner,
            1 => OwnerChange::Destroy,
            2 => OwnerChange::Close,
            value => OwnerChange::__Unknown(value),
        }
    }
}

impl StaticType for OwnerChange {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_owner_change_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for OwnerChange {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for OwnerChange {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for OwnerChange {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum PropMode {
    Replace,
    Prepend,
    Append,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PropMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PropMode::{}",
            match *self {
                PropMode::Replace => "Replace",
                PropMode::Prepend => "Prepend",
                PropMode::Append => "Append",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for PropMode {
    type GlibType = gdk_sys::GdkPropMode;

    fn to_glib(&self) -> gdk_sys::GdkPropMode {
        match *self {
            PropMode::Replace => gdk_sys::GDK_PROP_MODE_REPLACE,
            PropMode::Prepend => gdk_sys::GDK_PROP_MODE_PREPEND,
            PropMode::Append => gdk_sys::GDK_PROP_MODE_APPEND,
            PropMode::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkPropMode> for PropMode {
    fn from_glib(value: gdk_sys::GdkPropMode) -> Self {
        skip_assert_initialized!();
        match value {
            0 => PropMode::Replace,
            1 => PropMode::Prepend,
            2 => PropMode::Append,
            value => PropMode::__Unknown(value),
        }
    }
}

impl StaticType for PropMode {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_prop_mode_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for PropMode {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for PropMode {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for PropMode {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum PropertyState {
    NewValue,
    Delete,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PropertyState {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PropertyState::{}",
            match *self {
                PropertyState::NewValue => "NewValue",
                PropertyState::Delete => "Delete",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for PropertyState {
    type GlibType = gdk_sys::GdkPropertyState;

    fn to_glib(&self) -> gdk_sys::GdkPropertyState {
        match *self {
            PropertyState::NewValue => gdk_sys::GDK_PROPERTY_NEW_VALUE,
            PropertyState::Delete => gdk_sys::GDK_PROPERTY_DELETE,
            PropertyState::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkPropertyState> for PropertyState {
    fn from_glib(value: gdk_sys::GdkPropertyState) -> Self {
        skip_assert_initialized!();
        match value {
            0 => PropertyState::NewValue,
            1 => PropertyState::Delete,
            value => PropertyState::__Unknown(value),
        }
    }
}

impl StaticType for PropertyState {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_property_state_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for PropertyState {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for PropertyState {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for PropertyState {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum ScrollDirection {
    Up,
    Down,
    Left,
    Right,
    Smooth,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ScrollDirection {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ScrollDirection::{}",
            match *self {
                ScrollDirection::Up => "Up",
                ScrollDirection::Down => "Down",
                ScrollDirection::Left => "Left",
                ScrollDirection::Right => "Right",
                ScrollDirection::Smooth => "Smooth",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for ScrollDirection {
    type GlibType = gdk_sys::GdkScrollDirection;

    fn to_glib(&self) -> gdk_sys::GdkScrollDirection {
        match *self {
            ScrollDirection::Up => gdk_sys::GDK_SCROLL_UP,
            ScrollDirection::Down => gdk_sys::GDK_SCROLL_DOWN,
            ScrollDirection::Left => gdk_sys::GDK_SCROLL_LEFT,
            ScrollDirection::Right => gdk_sys::GDK_SCROLL_RIGHT,
            ScrollDirection::Smooth => gdk_sys::GDK_SCROLL_SMOOTH,
            ScrollDirection::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkScrollDirection> for ScrollDirection {
    fn from_glib(value: gdk_sys::GdkScrollDirection) -> Self {
        skip_assert_initialized!();
        match value {
            0 => ScrollDirection::Up,
            1 => ScrollDirection::Down,
            2 => ScrollDirection::Left,
            3 => ScrollDirection::Right,
            4 => ScrollDirection::Smooth,
            value => ScrollDirection::__Unknown(value),
        }
    }
}

impl StaticType for ScrollDirection {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_scroll_direction_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for ScrollDirection {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for ScrollDirection {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for ScrollDirection {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum SettingAction {
    New,
    Changed,
    Deleted,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SettingAction {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SettingAction::{}",
            match *self {
                SettingAction::New => "New",
                SettingAction::Changed => "Changed",
                SettingAction::Deleted => "Deleted",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for SettingAction {
    type GlibType = gdk_sys::GdkSettingAction;

    fn to_glib(&self) -> gdk_sys::GdkSettingAction {
        match *self {
            SettingAction::New => gdk_sys::GDK_SETTING_ACTION_NEW,
            SettingAction::Changed => gdk_sys::GDK_SETTING_ACTION_CHANGED,
            SettingAction::Deleted => gdk_sys::GDK_SETTING_ACTION_DELETED,
            SettingAction::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkSettingAction> for SettingAction {
    fn from_glib(value: gdk_sys::GdkSettingAction) -> Self {
        skip_assert_initialized!();
        match value {
            0 => SettingAction::New,
            1 => SettingAction::Changed,
            2 => SettingAction::Deleted,
            value => SettingAction::__Unknown(value),
        }
    }
}

impl StaticType for SettingAction {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_setting_action_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for SettingAction {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for SettingAction {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for SettingAction {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum SubpixelLayout {
    Unknown,
    None,
    HorizontalRgb,
    HorizontalBgr,
    VerticalRgb,
    VerticalBgr,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl fmt::Display for SubpixelLayout {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SubpixelLayout::{}",
            match *self {
                SubpixelLayout::Unknown => "Unknown",
                SubpixelLayout::None => "None",
                SubpixelLayout::HorizontalRgb => "HorizontalRgb",
                SubpixelLayout::HorizontalBgr => "HorizontalBgr",
                SubpixelLayout::VerticalRgb => "VerticalRgb",
                SubpixelLayout::VerticalBgr => "VerticalBgr",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[doc(hidden)]
impl ToGlib for SubpixelLayout {
    type GlibType = gdk_sys::GdkSubpixelLayout;

    fn to_glib(&self) -> gdk_sys::GdkSubpixelLayout {
        match *self {
            SubpixelLayout::Unknown => gdk_sys::GDK_SUBPIXEL_LAYOUT_UNKNOWN,
            SubpixelLayout::None => gdk_sys::GDK_SUBPIXEL_LAYOUT_NONE,
            SubpixelLayout::HorizontalRgb => gdk_sys::GDK_SUBPIXEL_LAYOUT_HORIZONTAL_RGB,
            SubpixelLayout::HorizontalBgr => gdk_sys::GDK_SUBPIXEL_LAYOUT_HORIZONTAL_BGR,
            SubpixelLayout::VerticalRgb => gdk_sys::GDK_SUBPIXEL_LAYOUT_VERTICAL_RGB,
            SubpixelLayout::VerticalBgr => gdk_sys::GDK_SUBPIXEL_LAYOUT_VERTICAL_BGR,
            SubpixelLayout::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[doc(hidden)]
impl FromGlib<gdk_sys::GdkSubpixelLayout> for SubpixelLayout {
    fn from_glib(value: gdk_sys::GdkSubpixelLayout) -> Self {
        skip_assert_initialized!();
        match value {
            0 => SubpixelLayout::Unknown,
            1 => SubpixelLayout::None,
            2 => SubpixelLayout::HorizontalRgb,
            3 => SubpixelLayout::HorizontalBgr,
            4 => SubpixelLayout::VerticalRgb,
            5 => SubpixelLayout::VerticalBgr,
            value => SubpixelLayout::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl StaticType for SubpixelLayout {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_subpixel_layout_get_type()) }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl<'a> FromValueOptional<'a> for SubpixelLayout {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl<'a> FromValue<'a> for SubpixelLayout {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl SetValue for SubpixelLayout {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum VisibilityState {
    Unobscured,
    Partial,
    FullyObscured,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for VisibilityState {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "VisibilityState::{}",
            match *self {
                VisibilityState::Unobscured => "Unobscured",
                VisibilityState::Partial => "Partial",
                VisibilityState::FullyObscured => "FullyObscured",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for VisibilityState {
    type GlibType = gdk_sys::GdkVisibilityState;

    fn to_glib(&self) -> gdk_sys::GdkVisibilityState {
        match *self {
            VisibilityState::Unobscured => gdk_sys::GDK_VISIBILITY_UNOBSCURED,
            VisibilityState::Partial => gdk_sys::GDK_VISIBILITY_PARTIAL,
            VisibilityState::FullyObscured => gdk_sys::GDK_VISIBILITY_FULLY_OBSCURED,
            VisibilityState::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkVisibilityState> for VisibilityState {
    fn from_glib(value: gdk_sys::GdkVisibilityState) -> Self {
        skip_assert_initialized!();
        match value {
            0 => VisibilityState::Unobscured,
            1 => VisibilityState::Partial,
            2 => VisibilityState::FullyObscured,
            value => VisibilityState::__Unknown(value),
        }
    }
}

impl StaticType for VisibilityState {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_visibility_state_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for VisibilityState {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for VisibilityState {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for VisibilityState {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum VisualType {
    StaticGray,
    Grayscale,
    StaticColor,
    PseudoColor,
    TrueColor,
    DirectColor,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for VisualType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "VisualType::{}",
            match *self {
                VisualType::StaticGray => "StaticGray",
                VisualType::Grayscale => "Grayscale",
                VisualType::StaticColor => "StaticColor",
                VisualType::PseudoColor => "PseudoColor",
                VisualType::TrueColor => "TrueColor",
                VisualType::DirectColor => "DirectColor",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for VisualType {
    type GlibType = gdk_sys::GdkVisualType;

    fn to_glib(&self) -> gdk_sys::GdkVisualType {
        match *self {
            VisualType::StaticGray => gdk_sys::GDK_VISUAL_STATIC_GRAY,
            VisualType::Grayscale => gdk_sys::GDK_VISUAL_GRAYSCALE,
            VisualType::StaticColor => gdk_sys::GDK_VISUAL_STATIC_COLOR,
            VisualType::PseudoColor => gdk_sys::GDK_VISUAL_PSEUDO_COLOR,
            VisualType::TrueColor => gdk_sys::GDK_VISUAL_TRUE_COLOR,
            VisualType::DirectColor => gdk_sys::GDK_VISUAL_DIRECT_COLOR,
            VisualType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkVisualType> for VisualType {
    fn from_glib(value: gdk_sys::GdkVisualType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => VisualType::StaticGray,
            1 => VisualType::Grayscale,
            2 => VisualType::StaticColor,
            3 => VisualType::PseudoColor,
            4 => VisualType::TrueColor,
            5 => VisualType::DirectColor,
            value => VisualType::__Unknown(value),
        }
    }
}

impl StaticType for VisualType {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_visual_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for VisualType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for VisualType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for VisualType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum WindowEdge {
    NorthWest,
    North,
    NorthEast,
    West,
    East,
    SouthWest,
    South,
    SouthEast,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for WindowEdge {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "WindowEdge::{}",
            match *self {
                WindowEdge::NorthWest => "NorthWest",
                WindowEdge::North => "North",
                WindowEdge::NorthEast => "NorthEast",
                WindowEdge::West => "West",
                WindowEdge::East => "East",
                WindowEdge::SouthWest => "SouthWest",
                WindowEdge::South => "South",
                WindowEdge::SouthEast => "SouthEast",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for WindowEdge {
    type GlibType = gdk_sys::GdkWindowEdge;

    fn to_glib(&self) -> gdk_sys::GdkWindowEdge {
        match *self {
            WindowEdge::NorthWest => gdk_sys::GDK_WINDOW_EDGE_NORTH_WEST,
            WindowEdge::North => gdk_sys::GDK_WINDOW_EDGE_NORTH,
            WindowEdge::NorthEast => gdk_sys::GDK_WINDOW_EDGE_NORTH_EAST,
            WindowEdge::West => gdk_sys::GDK_WINDOW_EDGE_WEST,
            WindowEdge::East => gdk_sys::GDK_WINDOW_EDGE_EAST,
            WindowEdge::SouthWest => gdk_sys::GDK_WINDOW_EDGE_SOUTH_WEST,
            WindowEdge::South => gdk_sys::GDK_WINDOW_EDGE_SOUTH,
            WindowEdge::SouthEast => gdk_sys::GDK_WINDOW_EDGE_SOUTH_EAST,
            WindowEdge::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkWindowEdge> for WindowEdge {
    fn from_glib(value: gdk_sys::GdkWindowEdge) -> Self {
        skip_assert_initialized!();
        match value {
            0 => WindowEdge::NorthWest,
            1 => WindowEdge::North,
            2 => WindowEdge::NorthEast,
            3 => WindowEdge::West,
            4 => WindowEdge::East,
            5 => WindowEdge::SouthWest,
            6 => WindowEdge::South,
            7 => WindowEdge::SouthEast,
            value => WindowEdge::__Unknown(value),
        }
    }
}

impl StaticType for WindowEdge {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_window_edge_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for WindowEdge {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for WindowEdge {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for WindowEdge {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum WindowType {
    Root,
    Toplevel,
    Child,
    Temp,
    Foreign,
    Offscreen,
    Subsurface,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for WindowType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "WindowType::{}",
            match *self {
                WindowType::Root => "Root",
                WindowType::Toplevel => "Toplevel",
                WindowType::Child => "Child",
                WindowType::Temp => "Temp",
                WindowType::Foreign => "Foreign",
                WindowType::Offscreen => "Offscreen",
                WindowType::Subsurface => "Subsurface",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for WindowType {
    type GlibType = gdk_sys::GdkWindowType;

    fn to_glib(&self) -> gdk_sys::GdkWindowType {
        match *self {
            WindowType::Root => gdk_sys::GDK_WINDOW_ROOT,
            WindowType::Toplevel => gdk_sys::GDK_WINDOW_TOPLEVEL,
            WindowType::Child => gdk_sys::GDK_WINDOW_CHILD,
            WindowType::Temp => gdk_sys::GDK_WINDOW_TEMP,
            WindowType::Foreign => gdk_sys::GDK_WINDOW_FOREIGN,
            WindowType::Offscreen => gdk_sys::GDK_WINDOW_OFFSCREEN,
            WindowType::Subsurface => gdk_sys::GDK_WINDOW_SUBSURFACE,
            WindowType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkWindowType> for WindowType {
    fn from_glib(value: gdk_sys::GdkWindowType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => WindowType::Root,
            1 => WindowType::Toplevel,
            2 => WindowType::Child,
            3 => WindowType::Temp,
            4 => WindowType::Foreign,
            5 => WindowType::Offscreen,
            6 => WindowType::Subsurface,
            value => WindowType::__Unknown(value),
        }
    }
}

impl StaticType for WindowType {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_window_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for WindowType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for WindowType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for WindowType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum WindowTypeHint {
    Normal,
    Dialog,
    Menu,
    Toolbar,
    Splashscreen,
    Utility,
    Dock,
    Desktop,
    DropdownMenu,
    PopupMenu,
    Tooltip,
    Notification,
    Combo,
    Dnd,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for WindowTypeHint {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "WindowTypeHint::{}",
            match *self {
                WindowTypeHint::Normal => "Normal",
                WindowTypeHint::Dialog => "Dialog",
                WindowTypeHint::Menu => "Menu",
                WindowTypeHint::Toolbar => "Toolbar",
                WindowTypeHint::Splashscreen => "Splashscreen",
                WindowTypeHint::Utility => "Utility",
                WindowTypeHint::Dock => "Dock",
                WindowTypeHint::Desktop => "Desktop",
                WindowTypeHint::DropdownMenu => "DropdownMenu",
                WindowTypeHint::PopupMenu => "PopupMenu",
                WindowTypeHint::Tooltip => "Tooltip",
                WindowTypeHint::Notification => "Notification",
                WindowTypeHint::Combo => "Combo",
                WindowTypeHint::Dnd => "Dnd",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for WindowTypeHint {
    type GlibType = gdk_sys::GdkWindowTypeHint;

    fn to_glib(&self) -> gdk_sys::GdkWindowTypeHint {
        match *self {
            WindowTypeHint::Normal => gdk_sys::GDK_WINDOW_TYPE_HINT_NORMAL,
            WindowTypeHint::Dialog => gdk_sys::GDK_WINDOW_TYPE_HINT_DIALOG,
            WindowTypeHint::Menu => gdk_sys::GDK_WINDOW_TYPE_HINT_MENU,
            WindowTypeHint::Toolbar => gdk_sys::GDK_WINDOW_TYPE_HINT_TOOLBAR,
            WindowTypeHint::Splashscreen => gdk_sys::GDK_WINDOW_TYPE_HINT_SPLASHSCREEN,
            WindowTypeHint::Utility => gdk_sys::GDK_WINDOW_TYPE_HINT_UTILITY,
            WindowTypeHint::Dock => gdk_sys::GDK_WINDOW_TYPE_HINT_DOCK,
            WindowTypeHint::Desktop => gdk_sys::GDK_WINDOW_TYPE_HINT_DESKTOP,
            WindowTypeHint::DropdownMenu => gdk_sys::GDK_WINDOW_TYPE_HINT_DROPDOWN_MENU,
            WindowTypeHint::PopupMenu => gdk_sys::GDK_WINDOW_TYPE_HINT_POPUP_MENU,
            WindowTypeHint::Tooltip => gdk_sys::GDK_WINDOW_TYPE_HINT_TOOLTIP,
            WindowTypeHint::Notification => gdk_sys::GDK_WINDOW_TYPE_HINT_NOTIFICATION,
            WindowTypeHint::Combo => gdk_sys::GDK_WINDOW_TYPE_HINT_COMBO,
            WindowTypeHint::Dnd => gdk_sys::GDK_WINDOW_TYPE_HINT_DND,
            WindowTypeHint::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkWindowTypeHint> for WindowTypeHint {
    fn from_glib(value: gdk_sys::GdkWindowTypeHint) -> Self {
        skip_assert_initialized!();
        match value {
            0 => WindowTypeHint::Normal,
            1 => WindowTypeHint::Dialog,
            2 => WindowTypeHint::Menu,
            3 => WindowTypeHint::Toolbar,
            4 => WindowTypeHint::Splashscreen,
            5 => WindowTypeHint::Utility,
            6 => WindowTypeHint::Dock,
            7 => WindowTypeHint::Desktop,
            8 => WindowTypeHint::DropdownMenu,
            9 => WindowTypeHint::PopupMenu,
            10 => WindowTypeHint::Tooltip,
            11 => WindowTypeHint::Notification,
            12 => WindowTypeHint::Combo,
            13 => WindowTypeHint::Dnd,
            value => WindowTypeHint::__Unknown(value),
        }
    }
}

impl StaticType for WindowTypeHint {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_window_type_hint_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for WindowTypeHint {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for WindowTypeHint {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for WindowTypeHint {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
pub enum WindowWindowClass {
    InputOutput,
    InputOnly,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for WindowWindowClass {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "WindowWindowClass::{}",
            match *self {
                WindowWindowClass::InputOutput => "InputOutput",
                WindowWindowClass::InputOnly => "InputOnly",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for WindowWindowClass {
    type GlibType = gdk_sys::GdkWindowWindowClass;

    fn to_glib(&self) -> gdk_sys::GdkWindowWindowClass {
        match *self {
            WindowWindowClass::InputOutput => gdk_sys::GDK_INPUT_OUTPUT,
            WindowWindowClass::InputOnly => gdk_sys::GDK_INPUT_ONLY,
            WindowWindowClass::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gdk_sys::GdkWindowWindowClass> for WindowWindowClass {
    fn from_glib(value: gdk_sys::GdkWindowWindowClass) -> Self {
        skip_assert_initialized!();
        match value {
            0 => WindowWindowClass::InputOutput,
            1 => WindowWindowClass::InputOnly,
            value => WindowWindowClass::__Unknown(value),
        }
    }
}

impl StaticType for WindowWindowClass {
    fn static_type() -> Type {
        unsafe { from_glib(gdk_sys::gdk_window_window_class_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for WindowWindowClass {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for WindowWindowClass {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for WindowWindowClass {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}
