// This file was generated by gir (https://github.com/gtk-rs/gir @ 894f9e5)
// from gir-files (https://github.com/gtk-rs/gir-files @ 22748fa)
// DO NOT EDIT

extern crate gspell_sys;
extern crate shell_words;
extern crate tempfile;
use std::env;
use std::error::Error;
use std::path::Path;
use std::mem::{align_of, size_of};
use std::process::Command;
use std::str;
use tempfile::Builder;
use gspell_sys::*;

static PACKAGES: &[&str] = &["gspell-1"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Compiler, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Compiler { args })
    }

    pub fn define<'a, V: Into<Option<&'a str>>>(&mut self, var: &str, val: V) {
        let arg = match val.into() {
            None => format!("-D{}", var),
            Some(val) => format!("-D{}={}", var, val),
        };
        self.args.push(arg);
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {:?} failed, {}",
                               &cmd, status).into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{} {}", name, err).into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let mut cmd = Command::new("pkg-config");
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {:?} returned {}",
                           &cmd, out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}


#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
    /// Number of tests that failed to compile.
    failed_to_compile: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn record_failed_to_compile(&mut self) {
        self.failed += 1;
        self.failed_to_compile += 1;
    }
    fn summary(&self) -> String {
        format!(
            "{} passed; {} failed (compilation errors: {})",
            self.passed,
            self.failed,
            self.failed_to_compile)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let tmpdir = Builder::new().prefix("abi").tempdir().expect("temporary directory");
    let cc = Compiler::new().expect("configured compiler");

    assert_eq!("1",
               get_c_value(tmpdir.path(), &cc, "1").expect("C constant"),
               "failed to obtain correct constant value for 1");

    let mut results : Results = Default::default();
    for (i, &(name, rust_value)) in RUST_CONSTANTS.iter().enumerate() {
        match get_c_value(tmpdir.path(), &cc, name) {
            Err(e) => {
                results.record_failed_to_compile();
                eprintln!("{}", e);
            },
            Ok(ref c_value) => {
                if rust_value == c_value {
                    results.record_passed();
                } else {
                    results.record_failed();
                    eprintln!("Constant value mismatch for {}\nRust: {:?}\nC:    {:?}",
                              name, rust_value, c_value);
                }
            }
        };
        if (i + 1) % 25 == 0 {
            println!("constants ... {}", results.summary());
        }
    }
    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let tmpdir = Builder::new().prefix("abi").tempdir().expect("temporary directory");
    let cc = Compiler::new().expect("configured compiler");

    assert_eq!(Layout {size: 1, alignment: 1},
               get_c_layout(tmpdir.path(), &cc, "char").expect("C layout"),
               "failed to obtain correct layout for char type");

    let mut results : Results = Default::default();
    for (i, &(name, rust_layout)) in RUST_LAYOUTS.iter().enumerate() {
        match get_c_layout(tmpdir.path(), &cc, name) {
            Err(e) => {
                results.record_failed_to_compile();
                eprintln!("{}", e);
            },
            Ok(c_layout) => {
                if rust_layout == c_layout {
                    results.record_passed();
                } else {
                    results.record_failed();
                    eprintln!("Layout mismatch for {}\nRust: {:?}\nC:    {:?}",
                              name, rust_layout, &c_layout);
                }
            }
        };
        if (i + 1) % 25 == 0 {
            println!("layout    ... {}", results.summary());
        }
    }
    results.expect_total_success();
}

fn get_c_layout(dir: &Path, cc: &Compiler, name: &str) -> Result<Layout, Box<dyn Error>> {
    let exe = dir.join("layout");
    let mut cc = cc.clone();
    cc.define("ABI_TYPE_NAME", name);
    cc.compile(Path::new("tests/layout.c"), &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}",
                           &abi_cmd, &output).into());
    }

    let stdout = str::from_utf8(&output.stdout)?;
    let mut words = stdout.trim().split_whitespace();
    let size = words.next().unwrap().parse().unwrap();
    let alignment = words.next().unwrap().parse().unwrap();
    Ok(Layout {size, alignment})
}

fn get_c_value(dir: &Path, cc: &Compiler, name: &str) -> Result<String, Box<dyn Error>> {
    let exe = dir.join("constant");
    let mut cc = cc.clone();
    cc.define("ABI_CONSTANT_NAME", name);
    cc.compile(Path::new("tests/constant.c"), &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}",
                           &abi_cmd, &output).into());
    }

    let output = str::from_utf8(&output.stdout)?.trim();
    if !output.starts_with("###gir test###") ||
       !output.ends_with("###gir test###") {
        return Err(format!("command {:?} return invalid output, {:?}",
                           &abi_cmd, &output).into());
    }

    Ok(String::from(&output[14..(output.len() - 14)]))
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    ("GspellChecker", Layout {size: size_of::<GspellChecker>(), alignment: align_of::<GspellChecker>()}),
    ("GspellCheckerClass", Layout {size: size_of::<GspellCheckerClass>(), alignment: align_of::<GspellCheckerClass>()}),
    ("GspellCheckerDialog", Layout {size: size_of::<GspellCheckerDialog>(), alignment: align_of::<GspellCheckerDialog>()}),
    ("GspellCheckerDialogClass", Layout {size: size_of::<GspellCheckerDialogClass>(), alignment: align_of::<GspellCheckerDialogClass>()}),
    ("GspellCheckerError", Layout {size: size_of::<GspellCheckerError>(), alignment: align_of::<GspellCheckerError>()}),
    ("GspellEntryBufferClass", Layout {size: size_of::<GspellEntryBufferClass>(), alignment: align_of::<GspellEntryBufferClass>()}),
    ("GspellEntryClass", Layout {size: size_of::<GspellEntryClass>(), alignment: align_of::<GspellEntryClass>()}),
    ("GspellLanguageChooserButton", Layout {size: size_of::<GspellLanguageChooserButton>(), alignment: align_of::<GspellLanguageChooserButton>()}),
    ("GspellLanguageChooserButtonClass", Layout {size: size_of::<GspellLanguageChooserButtonClass>(), alignment: align_of::<GspellLanguageChooserButtonClass>()}),
    ("GspellLanguageChooserDialog", Layout {size: size_of::<GspellLanguageChooserDialog>(), alignment: align_of::<GspellLanguageChooserDialog>()}),
    ("GspellLanguageChooserDialogClass", Layout {size: size_of::<GspellLanguageChooserDialogClass>(), alignment: align_of::<GspellLanguageChooserDialogClass>()}),
    ("GspellLanguageChooserInterface", Layout {size: size_of::<GspellLanguageChooserInterface>(), alignment: align_of::<GspellLanguageChooserInterface>()}),
    ("GspellNavigatorInterface", Layout {size: size_of::<GspellNavigatorInterface>(), alignment: align_of::<GspellNavigatorInterface>()}),
    ("GspellNavigatorTextView", Layout {size: size_of::<GspellNavigatorTextView>(), alignment: align_of::<GspellNavigatorTextView>()}),
    ("GspellNavigatorTextViewClass", Layout {size: size_of::<GspellNavigatorTextViewClass>(), alignment: align_of::<GspellNavigatorTextViewClass>()}),
    ("GspellTextBufferClass", Layout {size: size_of::<GspellTextBufferClass>(), alignment: align_of::<GspellTextBufferClass>()}),
    ("GspellTextView", Layout {size: size_of::<GspellTextView>(), alignment: align_of::<GspellTextView>()}),
    ("GspellTextViewClass", Layout {size: size_of::<GspellTextViewClass>(), alignment: align_of::<GspellTextViewClass>()}),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) GSPELL_CHECKER_ERROR_DICTIONARY", "0"),
    ("(gint) GSPELL_CHECKER_ERROR_NO_LANGUAGE_SET", "1"),
];


