// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::GString;
use glib_sys;
use gspell_sys;
use libc;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use Language;

glib_wrapper! {
    pub struct Checker(Object<gspell_sys::GspellChecker, gspell_sys::GspellCheckerClass, CheckerClass>);

    match fn {
        get_type => || gspell_sys::gspell_checker_get_type(),
    }
}

impl Checker {
    pub fn new(language: Option<&Language>) -> Checker {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(gspell_sys::gspell_checker_new(language.to_glib_none().0))
        }
    }
}

pub const NONE_CHECKER: Option<&Checker> = None;

pub trait CheckerExt: 'static {
    fn add_word_to_personal(&self, word: &str);

    fn add_word_to_session(&self, word: &str);

    //fn check_word(&self, word: &str, error: /*Ignored*/Option<glib::Error>) -> bool;

    fn clear_session(&self);

    fn get_enchant_dict(&self);

    fn get_language(&self) -> Option<Language>;

    fn get_suggestions(&self, word: &str) -> Vec<GString>;

    fn set_correction(&self, word: &str, replacement: &str);

    fn set_language(&self, language: Option<&Language>);

    fn connect_session_cleared<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_word_added_to_personal<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_word_added_to_session<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_language_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Checker>> CheckerExt for O {
    fn add_word_to_personal(&self, word: &str) {
        let word_length = word.len() as isize;
        unsafe {
            gspell_sys::gspell_checker_add_word_to_personal(self.as_ref().to_glib_none().0, word.to_glib_none().0, word_length);
        }
    }

    fn add_word_to_session(&self, word: &str) {
        let word_length = word.len() as isize;
        unsafe {
            gspell_sys::gspell_checker_add_word_to_session(self.as_ref().to_glib_none().0, word.to_glib_none().0, word_length);
        }
    }

    //fn check_word(&self, word: &str, error: /*Ignored*/Option<glib::Error>) -> bool {
    //    unsafe { TODO: call gspell_sys:gspell_checker_check_word() }
    //}

    fn clear_session(&self) {
        unsafe {
            gspell_sys::gspell_checker_clear_session(self.as_ref().to_glib_none().0);
        }
    }

    fn get_enchant_dict(&self) {
        unsafe {
            gspell_sys::gspell_checker_get_enchant_dict(self.as_ref().to_glib_none().0);
        }
    }

    fn get_language(&self) -> Option<Language> {
        unsafe {
            from_glib_none(gspell_sys::gspell_checker_get_language(self.as_ref().to_glib_none().0))
        }
    }

    fn get_suggestions(&self, word: &str) -> Vec<GString> {
        let word_length = word.len() as isize;
        unsafe {
            FromGlibPtrContainer::from_glib_full(gspell_sys::gspell_checker_get_suggestions(self.as_ref().to_glib_none().0, word.to_glib_none().0, word_length))
        }
    }

    fn set_correction(&self, word: &str, replacement: &str) {
        let word_length = word.len() as isize;
        let replacement_length = replacement.len() as isize;
        unsafe {
            gspell_sys::gspell_checker_set_correction(self.as_ref().to_glib_none().0, word.to_glib_none().0, word_length, replacement.to_glib_none().0, replacement_length);
        }
    }

    fn set_language(&self, language: Option<&Language>) {
        unsafe {
            gspell_sys::gspell_checker_set_language(self.as_ref().to_glib_none().0, language.to_glib_none().0);
        }
    }

    fn connect_session_cleared<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn session_cleared_trampoline<P, F: Fn(&P) + 'static>(this: *mut gspell_sys::GspellChecker, f: glib_sys::gpointer)
            where P: IsA<Checker>
        {
            let f: &F = &*(f as *const F);
            f(&Checker::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"session-cleared\0".as_ptr() as *const _,
                Some(transmute(session_cleared_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }

    fn connect_word_added_to_personal<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn word_added_to_personal_trampoline<P, F: Fn(&P, &str) + 'static>(this: *mut gspell_sys::GspellChecker, word: *mut libc::c_char, f: glib_sys::gpointer)
            where P: IsA<Checker>
        {
            let f: &F = &*(f as *const F);
            f(&Checker::from_glib_borrow(this).unsafe_cast(), &GString::from_glib_borrow(word))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"word-added-to-personal\0".as_ptr() as *const _,
                Some(transmute(word_added_to_personal_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }

    fn connect_word_added_to_session<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn word_added_to_session_trampoline<P, F: Fn(&P, &str) + 'static>(this: *mut gspell_sys::GspellChecker, word: *mut libc::c_char, f: glib_sys::gpointer)
            where P: IsA<Checker>
        {
            let f: &F = &*(f as *const F);
            f(&Checker::from_glib_borrow(this).unsafe_cast(), &GString::from_glib_borrow(word))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"word-added-to-session\0".as_ptr() as *const _,
                Some(transmute(word_added_to_session_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }

    fn connect_property_language_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_language_trampoline<P, F: Fn(&P) + 'static>(this: *mut gspell_sys::GspellChecker, _param_spec: glib_sys::gpointer, f: glib_sys::gpointer)
            where P: IsA<Checker>
        {
            let f: &F = &*(f as *const F);
            f(&Checker::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::language\0".as_ptr() as *const _,
                Some(transmute(notify_language_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for Checker {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Checker")
    }
}
