// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib_sys;
use gspell_sys;
use gtk;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib_wrapper! {
    pub struct Entry(Object<gspell_sys::GspellEntry, gspell_sys::GspellEntryClass, EntryClass>);

    match fn {
        get_type => || gspell_sys::gspell_entry_get_type(),
    }
}

impl Entry {
    pub fn get_from_gtk_entry<P: IsA<gtk::Entry>>(gtk_entry: &P) -> Option<Entry> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(gspell_sys::gspell_entry_get_from_gtk_entry(gtk_entry.as_ref().to_glib_none().0))
        }
    }
}

pub const NONE_ENTRY: Option<&Entry> = None;

pub trait EntryExt: 'static {
    fn basic_setup(&self);

    fn get_entry(&self) -> Option<gtk::Entry>;

    fn get_inline_spell_checking(&self) -> bool;

    fn set_inline_spell_checking(&self, enable: bool);

    fn connect_property_inline_spell_checking_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Entry>> EntryExt for O {
    fn basic_setup(&self) {
        unsafe {
            gspell_sys::gspell_entry_basic_setup(self.as_ref().to_glib_none().0);
        }
    }

    fn get_entry(&self) -> Option<gtk::Entry> {
        unsafe {
            from_glib_none(gspell_sys::gspell_entry_get_entry(self.as_ref().to_glib_none().0))
        }
    }

    fn get_inline_spell_checking(&self) -> bool {
        unsafe {
            from_glib(gspell_sys::gspell_entry_get_inline_spell_checking(self.as_ref().to_glib_none().0))
        }
    }

    fn set_inline_spell_checking(&self, enable: bool) {
        unsafe {
            gspell_sys::gspell_entry_set_inline_spell_checking(self.as_ref().to_glib_none().0, enable.to_glib());
        }
    }

    fn connect_property_inline_spell_checking_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_inline_spell_checking_trampoline<P, F: Fn(&P) + 'static>(this: *mut gspell_sys::GspellEntry, _param_spec: glib_sys::gpointer, f: glib_sys::gpointer)
            where P: IsA<Entry>
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::inline-spell-checking\0".as_ptr() as *const _,
                Some(transmute(notify_inline_spell_checking_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for Entry {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Entry")
    }
}
