// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib_sys;
use gspell_sys;
use gtk;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use Checker;

glib_wrapper! {
    pub struct TextBuffer(Object<gspell_sys::GspellTextBuffer, gspell_sys::GspellTextBufferClass, TextBufferClass>);

    match fn {
        get_type => || gspell_sys::gspell_text_buffer_get_type(),
    }
}

impl TextBuffer {
    pub fn get_from_gtk_text_buffer<P: IsA<gtk::TextBuffer>>(gtk_buffer: &P) -> Option<TextBuffer> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(gspell_sys::gspell_text_buffer_get_from_gtk_text_buffer(gtk_buffer.as_ref().to_glib_none().0))
        }
    }
}

pub const NONE_TEXT_BUFFER: Option<&TextBuffer> = None;

pub trait TextBufferExt: 'static {
    fn get_buffer(&self) -> Option<gtk::TextBuffer>;

    fn get_spell_checker(&self) -> Option<Checker>;

    fn set_spell_checker<P: IsA<Checker>>(&self, spell_checker: Option<&P>);

    fn connect_property_spell_checker_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<TextBuffer>> TextBufferExt for O {
    fn get_buffer(&self) -> Option<gtk::TextBuffer> {
        unsafe {
            from_glib_none(gspell_sys::gspell_text_buffer_get_buffer(self.as_ref().to_glib_none().0))
        }
    }

    fn get_spell_checker(&self) -> Option<Checker> {
        unsafe {
            from_glib_none(gspell_sys::gspell_text_buffer_get_spell_checker(self.as_ref().to_glib_none().0))
        }
    }

    fn set_spell_checker<P: IsA<Checker>>(&self, spell_checker: Option<&P>) {
        unsafe {
            gspell_sys::gspell_text_buffer_set_spell_checker(self.as_ref().to_glib_none().0, spell_checker.map(|p| p.as_ref()).to_glib_none().0);
        }
    }

    fn connect_property_spell_checker_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_spell_checker_trampoline<P, F: Fn(&P) + 'static>(this: *mut gspell_sys::GspellTextBuffer, _param_spec: glib_sys::gpointer, f: glib_sys::gpointer)
            where P: IsA<TextBuffer>
        {
            let f: &F = &*(f as *const F);
            f(&TextBuffer::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::spell-checker\0".as_ptr() as *const _,
                Some(transmute(notify_spell_checker_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for TextBuffer {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "TextBuffer")
    }
}
