// Copyright (C) 2018 Thiago Santos <thiagossantos@gmail.com>
//                    Sebastian Dröge <sebastian@centricular.com>
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

use DiscovererVideoInfo;

use glib::translate::*;
use gst;
use gst_pbutils_sys;

impl DiscovererVideoInfo {
    pub fn get_framerate(&self) -> gst::Fraction {
        unsafe {
            gst::Fraction::new(
                gst_pbutils_sys::gst_discoverer_video_info_get_framerate_num(self.to_glib_none().0)
                    as i32,
                gst_pbutils_sys::gst_discoverer_video_info_get_framerate_denom(
                    self.to_glib_none().0,
                ) as i32,
            )
        }
    }

    pub fn get_par(&self) -> gst::Fraction {
        unsafe {
            gst::Fraction::new(
                gst_pbutils_sys::gst_discoverer_video_info_get_par_num(self.to_glib_none().0)
                    as i32,
                gst_pbutils_sys::gst_discoverer_video_info_get_par_denom(self.to_glib_none().0)
                    as i32,
            )
        }
    }
}
