// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib;
use glib::object::IsA;
use glib::translate::*;
use gst;
use gst_video_sys;
use VideoCodecFrame;

glib_wrapper! {
    pub struct VideoDecoder(Object<gst_video_sys::GstVideoDecoder, gst_video_sys::GstVideoDecoderClass, VideoDecoderClass>) @extends gst::Element, gst::Object;

    match fn {
        get_type => || gst_video_sys::gst_video_decoder_get_type(),
    }
}

unsafe impl Send for VideoDecoder {}
unsafe impl Sync for VideoDecoder {}

pub const NONE_VIDEO_DECODER: Option<&VideoDecoder> = None;

pub trait VideoDecoderExt: 'static {
    fn add_to_frame(&self, n_bytes: i32);

    fn allocate_output_buffer(&self) -> Result<gst::Buffer, glib::BoolError>;

    fn get_buffer_pool(&self) -> Option<gst::BufferPool>;

    fn get_estimate_rate(&self) -> i32;

    fn get_max_decode_time(&self, frame: &VideoCodecFrame) -> gst::ClockTimeDiff;

    fn get_max_errors(&self) -> i32;

    fn get_needs_format(&self) -> bool;

    fn get_packetized(&self) -> bool;

    fn get_pending_frame_size(&self) -> usize;

    fn get_qos_proportion(&self) -> f64;

    fn merge_tags(&self, tags: Option<&gst::TagList>, mode: gst::TagMergeMode);

    fn proxy_getcaps(&self, caps: Option<&gst::Caps>, filter: Option<&gst::Caps>) -> gst::Caps;

    fn set_estimate_rate(&self, enabled: bool);

    fn set_max_errors(&self, num: i32);

    fn set_needs_format(&self, enabled: bool);

    fn set_packetized(&self, packetized: bool);

    fn set_use_default_pad_acceptcaps(&self, use_: bool);
}

impl<O: IsA<VideoDecoder>> VideoDecoderExt for O {
    fn add_to_frame(&self, n_bytes: i32) {
        unsafe {
            gst_video_sys::gst_video_decoder_add_to_frame(self.as_ref().to_glib_none().0, n_bytes);
        }
    }

    fn allocate_output_buffer(&self) -> Result<gst::Buffer, glib::BoolError> {
        unsafe {
            Option::<_>::from_glib_full(gst_video_sys::gst_video_decoder_allocate_output_buffer(
                self.as_ref().to_glib_none().0,
            ))
            .ok_or_else(|| glib_bool_error!("Failed to allocate output buffer"))
        }
    }

    fn get_buffer_pool(&self) -> Option<gst::BufferPool> {
        unsafe {
            from_glib_full(gst_video_sys::gst_video_decoder_get_buffer_pool(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_estimate_rate(&self) -> i32 {
        unsafe {
            gst_video_sys::gst_video_decoder_get_estimate_rate(self.as_ref().to_glib_none().0)
        }
    }

    fn get_max_decode_time(&self, frame: &VideoCodecFrame) -> gst::ClockTimeDiff {
        unsafe {
            gst_video_sys::gst_video_decoder_get_max_decode_time(
                self.as_ref().to_glib_none().0,
                frame.to_glib_none().0,
            )
        }
    }

    fn get_max_errors(&self) -> i32 {
        unsafe { gst_video_sys::gst_video_decoder_get_max_errors(self.as_ref().to_glib_none().0) }
    }

    fn get_needs_format(&self) -> bool {
        unsafe {
            from_glib(gst_video_sys::gst_video_decoder_get_needs_format(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_packetized(&self) -> bool {
        unsafe {
            from_glib(gst_video_sys::gst_video_decoder_get_packetized(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_pending_frame_size(&self) -> usize {
        unsafe {
            gst_video_sys::gst_video_decoder_get_pending_frame_size(self.as_ref().to_glib_none().0)
        }
    }

    fn get_qos_proportion(&self) -> f64 {
        unsafe {
            gst_video_sys::gst_video_decoder_get_qos_proportion(self.as_ref().to_glib_none().0)
        }
    }

    fn merge_tags(&self, tags: Option<&gst::TagList>, mode: gst::TagMergeMode) {
        unsafe {
            gst_video_sys::gst_video_decoder_merge_tags(
                self.as_ref().to_glib_none().0,
                tags.to_glib_none().0,
                mode.to_glib(),
            );
        }
    }

    fn proxy_getcaps(&self, caps: Option<&gst::Caps>, filter: Option<&gst::Caps>) -> gst::Caps {
        unsafe {
            from_glib_full(gst_video_sys::gst_video_decoder_proxy_getcaps(
                self.as_ref().to_glib_none().0,
                caps.to_glib_none().0,
                filter.to_glib_none().0,
            ))
        }
    }

    fn set_estimate_rate(&self, enabled: bool) {
        unsafe {
            gst_video_sys::gst_video_decoder_set_estimate_rate(
                self.as_ref().to_glib_none().0,
                enabled.to_glib(),
            );
        }
    }

    fn set_max_errors(&self, num: i32) {
        unsafe {
            gst_video_sys::gst_video_decoder_set_max_errors(self.as_ref().to_glib_none().0, num);
        }
    }

    fn set_needs_format(&self, enabled: bool) {
        unsafe {
            gst_video_sys::gst_video_decoder_set_needs_format(
                self.as_ref().to_glib_none().0,
                enabled.to_glib(),
            );
        }
    }

    fn set_packetized(&self, packetized: bool) {
        unsafe {
            gst_video_sys::gst_video_decoder_set_packetized(
                self.as_ref().to_glib_none().0,
                packetized.to_glib(),
            );
        }
    }

    fn set_use_default_pad_acceptcaps(&self, use_: bool) {
        unsafe {
            gst_video_sys::gst_video_decoder_set_use_default_pad_acceptcaps(
                self.as_ref().to_glib_none().0,
                use_.to_glib(),
            );
        }
    }
}
