// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib_sys;
use gtk;
use handy_sys;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib_wrapper! {
    pub struct Column(Object<handy_sys::HdyColumn, handy_sys::HdyColumnClass, ColumnClass>) @extends gtk::Bin, gtk::Container, gtk::Widget;

    match fn {
        get_type => || handy_sys::hdy_column_get_type(),
    }
}

impl Column {
    pub fn new() -> Column {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(handy_sys::hdy_column_new())
        }
    }
}

impl Default for Column {
    fn default() -> Self {
        Self::new()
    }
}

pub const NONE_COLUMN: Option<&Column> = None;

pub trait ColumnExt: 'static {
    fn get_linear_growth_width(&self) -> i32;

    fn get_maximum_width(&self) -> i32;

    fn set_linear_growth_width(&self, linear_growth_width: i32);

    fn set_maximum_width(&self, maximum_width: i32);

    fn connect_property_linear_growth_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_maximum_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Column>> ColumnExt for O {
    fn get_linear_growth_width(&self) -> i32 {
        unsafe {
            handy_sys::hdy_column_get_linear_growth_width(self.as_ref().to_glib_none().0)
        }
    }

    fn get_maximum_width(&self) -> i32 {
        unsafe {
            handy_sys::hdy_column_get_maximum_width(self.as_ref().to_glib_none().0)
        }
    }

    fn set_linear_growth_width(&self, linear_growth_width: i32) {
        unsafe {
            handy_sys::hdy_column_set_linear_growth_width(self.as_ref().to_glib_none().0, linear_growth_width);
        }
    }

    fn set_maximum_width(&self, maximum_width: i32) {
        unsafe {
            handy_sys::hdy_column_set_maximum_width(self.as_ref().to_glib_none().0, maximum_width);
        }
    }

    fn connect_property_linear_growth_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_linear_growth_width_trampoline<P, F: Fn(&P) + 'static>(this: *mut handy_sys::HdyColumn, _param_spec: glib_sys::gpointer, f: glib_sys::gpointer)
            where P: IsA<Column>
        {
            let f: &F = &*(f as *const F);
            f(&Column::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::linear-growth-width\0".as_ptr() as *const _,
                Some(transmute(notify_linear_growth_width_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }

    fn connect_property_maximum_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_maximum_width_trampoline<P, F: Fn(&P) + 'static>(this: *mut handy_sys::HdyColumn, _param_spec: glib_sys::gpointer, f: glib_sys::gpointer)
            where P: IsA<Column>
        {
            let f: &F = &*(f as *const F);
            f(&Column::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::maximum-width\0".as_ptr() as *const _,
                Some(transmute(notify_maximum_width_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for Column {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Column")
    }
}
