// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gio;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib_sys;
use gtk_source_sys;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use Buffer;
use CompressionType;
use Encoding;
use File;
use FileSaverFlags;
use NewlineType;

glib_wrapper! {
    pub struct FileSaver(Object<gtk_source_sys::GtkSourceFileSaver, gtk_source_sys::GtkSourceFileSaverClass, FileSaverClass>);

    match fn {
        get_type => || gtk_source_sys::gtk_source_file_saver_get_type(),
    }
}

impl FileSaver {
    pub fn new<P: IsA<Buffer>, Q: IsA<File>>(buffer: &P, file: &Q) -> FileSaver {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(gtk_source_sys::gtk_source_file_saver_new(buffer.as_ref().to_glib_none().0, file.as_ref().to_glib_none().0))
        }
    }

    pub fn new_with_target<P: IsA<Buffer>, Q: IsA<File>, R: IsA<gio::File>>(buffer: &P, file: &Q, target_location: &R) -> FileSaver {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(gtk_source_sys::gtk_source_file_saver_new_with_target(buffer.as_ref().to_glib_none().0, file.as_ref().to_glib_none().0, target_location.as_ref().to_glib_none().0))
        }
    }
}

pub const NONE_FILE_SAVER: Option<&FileSaver> = None;

pub trait FileSaverExt: 'static {
    fn get_buffer(&self) -> Option<Buffer>;

    fn get_compression_type(&self) -> CompressionType;

    fn get_encoding(&self) -> Option<Encoding>;

    fn get_file(&self) -> Option<File>;

    fn get_flags(&self) -> FileSaverFlags;

    fn get_location(&self) -> Option<gio::File>;

    fn get_newline_type(&self) -> NewlineType;

    //fn save_async<P: IsA<gio::Cancellable>, Q: FnOnce(Result<(), glib::Error>) + Send + 'static, R: FnOnce(Result<(), glib::Error>) + Send + 'static>(&self, io_priority: glib::Priority, cancellable: Option<&P>, progress_callback: Q, progress_callback_notify: Fn() + 'static, callback: R);

    //
    //fn save_async_future<Q: FnOnce(Result<(), glib::Error>) + Send + 'static>(&self, io_priority: glib::Priority, progress_callback: Q, progress_callback_notify: Fn() + 'static) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    fn set_compression_type(&self, compression_type: CompressionType);

    fn set_encoding(&self, encoding: Option<&Encoding>);

    fn set_flags(&self, flags: FileSaverFlags);

    fn set_newline_type(&self, newline_type: NewlineType);

    fn connect_property_compression_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_encoding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_flags_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_newline_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<FileSaver>> FileSaverExt for O {
    fn get_buffer(&self) -> Option<Buffer> {
        unsafe {
            from_glib_none(gtk_source_sys::gtk_source_file_saver_get_buffer(self.as_ref().to_glib_none().0))
        }
    }

    fn get_compression_type(&self) -> CompressionType {
        unsafe {
            from_glib(gtk_source_sys::gtk_source_file_saver_get_compression_type(self.as_ref().to_glib_none().0))
        }
    }

    fn get_encoding(&self) -> Option<Encoding> {
        unsafe {
            from_glib_none(gtk_source_sys::gtk_source_file_saver_get_encoding(self.as_ref().to_glib_none().0))
        }
    }

    fn get_file(&self) -> Option<File> {
        unsafe {
            from_glib_none(gtk_source_sys::gtk_source_file_saver_get_file(self.as_ref().to_glib_none().0))
        }
    }

    fn get_flags(&self) -> FileSaverFlags {
        unsafe {
            from_glib(gtk_source_sys::gtk_source_file_saver_get_flags(self.as_ref().to_glib_none().0))
        }
    }

    fn get_location(&self) -> Option<gio::File> {
        unsafe {
            from_glib_none(gtk_source_sys::gtk_source_file_saver_get_location(self.as_ref().to_glib_none().0))
        }
    }

    fn get_newline_type(&self) -> NewlineType {
        unsafe {
            from_glib(gtk_source_sys::gtk_source_file_saver_get_newline_type(self.as_ref().to_glib_none().0))
        }
    }

    //fn save_async<P: IsA<gio::Cancellable>, Q: FnOnce(Result<(), glib::Error>) + Send + 'static, R: FnOnce(Result<(), glib::Error>) + Send + 'static>(&self, io_priority: glib::Priority, cancellable: Option<&P>, progress_callback: Q, progress_callback_notify: Fn() + 'static, callback: R) {
    //    unsafe { TODO: call gtk_source_sys:gtk_source_file_saver_save_async() }
    //}

    //
    //fn save_async_future<Q: FnOnce(Result<(), glib::Error>) + Send + 'static>(&self, io_priority: glib::Priority, progress_callback: Q, progress_callback_notify: Fn() + 'static) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {

        //let progress_callback = progress_callback.map(ToOwned::to_owned);
        //let progress_callback_notify = progress_callback_notify.map(ToOwned::to_owned);
        //Box_::pin(gio::GioFuture::new(self, move |obj, send| {
        //    let cancellable = gio::Cancellable::new();
        //    obj.save_async(
        //        io_priority,
        //        Some(&cancellable),
        //        progress_callback.as_ref().map(::std::borrow::Borrow::borrow),
        //        progress_callback_notify.as_ref().map(::std::borrow::Borrow::borrow),
        //        move |res| {
        //            send.resolve(res);
        //        },
        //    );

        //    cancellable
        //}))
    //}

    fn set_compression_type(&self, compression_type: CompressionType) {
        unsafe {
            gtk_source_sys::gtk_source_file_saver_set_compression_type(self.as_ref().to_glib_none().0, compression_type.to_glib());
        }
    }

    fn set_encoding(&self, encoding: Option<&Encoding>) {
        unsafe {
            gtk_source_sys::gtk_source_file_saver_set_encoding(self.as_ref().to_glib_none().0, encoding.to_glib_none().0);
        }
    }

    fn set_flags(&self, flags: FileSaverFlags) {
        unsafe {
            gtk_source_sys::gtk_source_file_saver_set_flags(self.as_ref().to_glib_none().0, flags.to_glib());
        }
    }

    fn set_newline_type(&self, newline_type: NewlineType) {
        unsafe {
            gtk_source_sys::gtk_source_file_saver_set_newline_type(self.as_ref().to_glib_none().0, newline_type.to_glib());
        }
    }

    fn connect_property_compression_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_compression_type_trampoline<P, F: Fn(&P) + 'static>(this: *mut gtk_source_sys::GtkSourceFileSaver, _param_spec: glib_sys::gpointer, f: glib_sys::gpointer)
            where P: IsA<FileSaver>
        {
            let f: &F = &*(f as *const F);
            f(&FileSaver::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::compression-type\0".as_ptr() as *const _,
                Some(transmute(notify_compression_type_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }

    fn connect_property_encoding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_encoding_trampoline<P, F: Fn(&P) + 'static>(this: *mut gtk_source_sys::GtkSourceFileSaver, _param_spec: glib_sys::gpointer, f: glib_sys::gpointer)
            where P: IsA<FileSaver>
        {
            let f: &F = &*(f as *const F);
            f(&FileSaver::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::encoding\0".as_ptr() as *const _,
                Some(transmute(notify_encoding_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }

    fn connect_property_flags_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_flags_trampoline<P, F: Fn(&P) + 'static>(this: *mut gtk_source_sys::GtkSourceFileSaver, _param_spec: glib_sys::gpointer, f: glib_sys::gpointer)
            where P: IsA<FileSaver>
        {
            let f: &F = &*(f as *const F);
            f(&FileSaver::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::flags\0".as_ptr() as *const _,
                Some(transmute(notify_flags_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }

    fn connect_property_newline_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_newline_type_trampoline<P, F: Fn(&P) + 'static>(this: *mut gtk_source_sys::GtkSourceFileSaver, _param_spec: glib_sys::gpointer, f: glib_sys::gpointer)
            where P: IsA<FileSaver>
        {
            let f: &F = &*(f as *const F);
            f(&FileSaver::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::newline-type\0".as_ptr() as *const _,
                Some(transmute(notify_newline_type_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for FileSaver {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "FileSaver")
    }
}
