// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::GString;
use glib::StaticType;
use glib::Value;
use glib_sys;
use gobject_sys;
use gtk_source_sys;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;
use GutterRenderer;

glib_wrapper! {
    pub struct GutterRendererText(Object<gtk_source_sys::GtkSourceGutterRendererText, gtk_source_sys::GtkSourceGutterRendererTextClass, GutterRendererTextClass>) @extends GutterRenderer;

    match fn {
        get_type => || gtk_source_sys::gtk_source_gutter_renderer_text_get_type(),
    }
}

impl GutterRendererText {
    pub fn new() -> GutterRendererText {
        assert_initialized_main_thread!();
        unsafe {
            GutterRenderer::from_glib_full(gtk_source_sys::gtk_source_gutter_renderer_text_new()).unsafe_cast()
        }
    }
}

impl Default for GutterRendererText {
    fn default() -> Self {
        Self::new()
    }
}

pub const NONE_GUTTER_RENDERER_TEXT: Option<&GutterRendererText> = None;

pub trait GutterRendererTextExt: 'static {
    fn measure(&self, text: &str) -> (i32, i32);

    fn measure_markup(&self, markup: &str) -> (i32, i32);

    fn set_markup(&self, markup: &str);

    fn set_text(&self, text: &str);

    fn get_property_markup(&self) -> Option<GString>;

    fn get_property_text(&self) -> Option<GString>;

    fn connect_property_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<GutterRendererText>> GutterRendererTextExt for O {
    fn measure(&self, text: &str) -> (i32, i32) {
        unsafe {
            let mut width = mem::MaybeUninit::uninit();
            let mut height = mem::MaybeUninit::uninit();
            gtk_source_sys::gtk_source_gutter_renderer_text_measure(self.as_ref().to_glib_none().0, text.to_glib_none().0, width.as_mut_ptr(), height.as_mut_ptr());
            let width = width.assume_init();
            let height = height.assume_init();
            (width, height)
        }
    }

    fn measure_markup(&self, markup: &str) -> (i32, i32) {
        unsafe {
            let mut width = mem::MaybeUninit::uninit();
            let mut height = mem::MaybeUninit::uninit();
            gtk_source_sys::gtk_source_gutter_renderer_text_measure_markup(self.as_ref().to_glib_none().0, markup.to_glib_none().0, width.as_mut_ptr(), height.as_mut_ptr());
            let width = width.assume_init();
            let height = height.assume_init();
            (width, height)
        }
    }

    fn set_markup(&self, markup: &str) {
        let length = markup.len() as i32;
        unsafe {
            gtk_source_sys::gtk_source_gutter_renderer_text_set_markup(self.as_ref().to_glib_none().0, markup.to_glib_none().0, length);
        }
    }

    fn set_text(&self, text: &str) {
        let length = text.len() as i32;
        unsafe {
            gtk_source_sys::gtk_source_gutter_renderer_text_set_text(self.as_ref().to_glib_none().0, text.to_glib_none().0, length);
        }
    }

    fn get_property_markup(&self) -> Option<GString> {
        unsafe {
            let mut value = Value::from_type(<GString as StaticType>::static_type());
            gobject_sys::g_object_get_property(self.to_glib_none().0 as *mut gobject_sys::GObject, b"markup\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `markup` getter")
        }
    }

    fn get_property_text(&self) -> Option<GString> {
        unsafe {
            let mut value = Value::from_type(<GString as StaticType>::static_type());
            gobject_sys::g_object_get_property(self.to_glib_none().0 as *mut gobject_sys::GObject, b"text\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `text` getter")
        }
    }

    fn connect_property_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_markup_trampoline<P, F: Fn(&P) + 'static>(this: *mut gtk_source_sys::GtkSourceGutterRendererText, _param_spec: glib_sys::gpointer, f: glib_sys::gpointer)
            where P: IsA<GutterRendererText>
        {
            let f: &F = &*(f as *const F);
            f(&GutterRendererText::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::markup\0".as_ptr() as *const _,
                Some(transmute(notify_markup_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }

    fn connect_property_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_trampoline<P, F: Fn(&P) + 'static>(this: *mut gtk_source_sys::GtkSourceGutterRendererText, _param_spec: glib_sys::gpointer, f: glib_sys::gpointer)
            where P: IsA<GutterRendererText>
        {
            let f: &F = &*(f as *const F);
            f(&GutterRendererText::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::text\0".as_ptr() as *const _,
                Some(transmute(notify_text_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for GutterRendererText {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "GutterRendererText")
    }
}
