// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::object::IsA;
use glib::translate::*;
use glib::GString;
use gtk;
use gtk_source_sys;
use std::fmt;

glib_wrapper! {
    pub struct Region(Object<gtk_source_sys::GtkSourceRegion, gtk_source_sys::GtkSourceRegionClass, RegionClass>);

    match fn {
        get_type => || gtk_source_sys::gtk_source_region_get_type(),
    }
}

impl Region {
    pub fn new<P: IsA<gtk::TextBuffer>>(buffer: &P) -> Region {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(gtk_source_sys::gtk_source_region_new(buffer.as_ref().to_glib_none().0))
        }
    }
}

pub const NONE_REGION: Option<&Region> = None;

pub trait RegionExt: 'static {
    fn add_region<P: IsA<Region>>(&self, region_to_add: Option<&P>);

    fn add_subregion(&self, _start: &gtk::TextIter, _end: &gtk::TextIter);

    fn get_bounds(&self) -> Option<(gtk::TextIter, gtk::TextIter)>;

    fn get_buffer(&self) -> Option<gtk::TextBuffer>;

    //fn get_start_region_iter(&self, iter: /*Ignored*/RegionIter);

    fn intersect_region<P: IsA<Region>>(&self, region2: Option<&P>) -> Option<Region>;

    fn intersect_subregion(&self, _start: &gtk::TextIter, _end: &gtk::TextIter) -> Option<Region>;

    fn is_empty(&self) -> bool;

    fn subtract_region<P: IsA<Region>>(&self, region_to_subtract: Option<&P>);

    fn subtract_subregion(&self, _start: &gtk::TextIter, _end: &gtk::TextIter);

    fn to_string(&self) -> GString;
}

impl<O: IsA<Region>> RegionExt for O {
    fn add_region<P: IsA<Region>>(&self, region_to_add: Option<&P>) {
        unsafe {
            gtk_source_sys::gtk_source_region_add_region(self.as_ref().to_glib_none().0, region_to_add.map(|p| p.as_ref()).to_glib_none().0);
        }
    }

    fn add_subregion(&self, _start: &gtk::TextIter, _end: &gtk::TextIter) {
        unsafe {
            gtk_source_sys::gtk_source_region_add_subregion(self.as_ref().to_glib_none().0, _start.to_glib_none().0, _end.to_glib_none().0);
        }
    }

    fn get_bounds(&self) -> Option<(gtk::TextIter, gtk::TextIter)> {
        unsafe {
            let mut start = gtk::TextIter::uninitialized();
            let mut end = gtk::TextIter::uninitialized();
            let ret = from_glib(gtk_source_sys::gtk_source_region_get_bounds(self.as_ref().to_glib_none().0, start.to_glib_none_mut().0, end.to_glib_none_mut().0));
            if ret { Some((start, end)) } else { None }
        }
    }

    fn get_buffer(&self) -> Option<gtk::TextBuffer> {
        unsafe {
            from_glib_none(gtk_source_sys::gtk_source_region_get_buffer(self.as_ref().to_glib_none().0))
        }
    }

    //fn get_start_region_iter(&self, iter: /*Ignored*/RegionIter) {
    //    unsafe { TODO: call gtk_source_sys:gtk_source_region_get_start_region_iter() }
    //}

    fn intersect_region<P: IsA<Region>>(&self, region2: Option<&P>) -> Option<Region> {
        unsafe {
            from_glib_full(gtk_source_sys::gtk_source_region_intersect_region(self.as_ref().to_glib_none().0, region2.map(|p| p.as_ref()).to_glib_none().0))
        }
    }

    fn intersect_subregion(&self, _start: &gtk::TextIter, _end: &gtk::TextIter) -> Option<Region> {
        unsafe {
            from_glib_full(gtk_source_sys::gtk_source_region_intersect_subregion(self.as_ref().to_glib_none().0, _start.to_glib_none().0, _end.to_glib_none().0))
        }
    }

    fn is_empty(&self) -> bool {
        unsafe {
            from_glib(gtk_source_sys::gtk_source_region_is_empty(self.as_ref().to_glib_none().0))
        }
    }

    fn subtract_region<P: IsA<Region>>(&self, region_to_subtract: Option<&P>) {
        unsafe {
            gtk_source_sys::gtk_source_region_subtract_region(self.as_ref().to_glib_none().0, region_to_subtract.map(|p| p.as_ref()).to_glib_none().0);
        }
    }

    fn subtract_subregion(&self, _start: &gtk::TextIter, _end: &gtk::TextIter) {
        unsafe {
            gtk_source_sys::gtk_source_region_subtract_subregion(self.as_ref().to_glib_none().0, _start.to_glib_none().0, _end.to_glib_none().0);
        }
    }

    fn to_string(&self) -> GString {
        unsafe {
            from_glib_full(gtk_source_sys::gtk_source_region_to_string(self.as_ref().to_glib_none().0))
        }
    }
}

impl fmt::Display for Region {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Region")
    }
}
