/***************************************************************************
 * mdZ80: Gens Z80 Emulator                                                *
 * mdZ80_opcodes.h: Z80 opcodes.                                           *
 *                                                                         *
 * Copyright (c) 1999-2002 by Stéphane Dallongeville                       *
 * Copyright (c) 2003-2004 by Stéphane Akhoun                              *
 * Copyright (c) 2008-2009 by David Korth                                  *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at your  *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 * GNU General Public License for more details.                            *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.           *
 ***************************************************************************/


#ifndef _MDZ80_OPCODES_H
#define _MDZ80_OPCODES_H


/**
 * Z80 opcodes: 1-byte opcodes.
 */
enum mdZ80_opcode
{
	/* 0x00 - 0x0F */
	Z80_OP_NOP		= 0x00,	Z80_OP_LD_BC_NN		= 0x01,
	Z80_OP_LD_mBC_A		= 0x02,	Z80_OP_INC_BC		= 0x03,
	Z80_OP_INC_B		= 0x04,	Z80_OP_DEC_B		= 0x05,
	Z80_OP_LD_B_N		= 0x06,	Z80_OP_RLCA		= 0x07,
	Z80_OP_EX_AF_AF2	= 0x08,	Z80_OP_ADD_HL_BC	= 0x09,
	Z80_OP_LD_A_mBC		= 0x0A,	Z80_OP_DEC_BC		= 0x0B,
	Z80_OP_INC_C		= 0x0C,	Z80_OP_DEC_C		= 0x0D,
	Z80_OP_LD_C_N		= 0x0E,	Z80_OP_RRCA		= 0x0F,
	
	/* 0x10 - 0x1F */
	Z80_OP_DJNZ		= 0x10,	Z80_OP_LD_DE_NN		= 0x11,
	Z80_OP_LD_mDE_A		= 0x12,	Z80_OP_INC_DE		= 0x13,
	Z80_OP_INC_D		= 0x14,	Z80_OP_DEC_D		= 0x15,
	Z80_OP_LD_D_N		= 0x16,	Z80_OP_RLA		= 0x17,
	Z80_OP_JR_N		= 0x18,	Z80_OP_ADD_HL_DE	= 0x19,
	Z80_OP_LD_A_mDE		= 0x1A,	Z80_OP_DEC_DE		= 0x1B,
	Z80_OP_INC_E		= 0x1C,	Z80_OP_DEC_E		= 0x1D,
	Z80_OP_LD_E_N		= 0x1E,	Z80_OP_RRA		= 0x1F,
	
	/* 0x20 - 0x2F */
	Z80_OP_JRNZ_N		= 0x20,	Z80_OP_LD_HL_NN		= 0x21,
	Z80_OP_LD_mNN_HL	= 0x22,	Z80_OP_INC_HL		= 0x23,
	Z80_OP_INC_H		= 0x24,	Z80_OP_DEC_H		= 0x25,
	Z80_OP_LD_H_N		= 0x26,	Z80_OP_DAA		= 0x27,
	Z80_OP_JRZ_N		= 0x28,	Z80_OP_ADD_HL_HL	= 0x29,
	Z80_OP_LD_HL_mNN	= 0x2A,	Z80_OP_DEC_HL		= 0x2B,
	Z80_OP_INC_L		= 0x2C,	Z80_OP_DEC_L		= 0x2D,
	Z80_OP_LD_L_N		= 0x2E,	Z80_OP_CPL		= 0x2F,
	
	/* 0x30 - 0x3F */
	Z80_OP_JRNC_N		= 0x30,	Z80_OP_LD_SP_NN		= 0x31,
	Z80_OP_LD_mNN_A		= 0x32,	Z80_OP_INC_SP		= 0x33,
	Z80_OP_INC_mHL		= 0x34,	Z80_OP_DEC_mHL		= 0x35,
	Z80_OP_LD_mHL_N		= 0x36,	Z80_OP_SCF		= 0x37,
	Z80_OP_JRC_N		= 0x38,	Z80_OP_ADD_HL_SP	= 0x39,
	Z80_OP_LD_A_mNN		= 0x3A,	Z80_OP_DEC_SP		= 0x3B,
	Z80_OP_INC_A		= 0x3C,	Z80_OP_DEC_A		= 0x3D,
	Z80_OP_LD_A_N		= 0x3E,	Z80_OP_CCF		= 0x3F,
	
	/* 0x40 - 0x4F */
	Z80_OP_LD_B_B		= 0x40,	Z80_OP_LD_B_C		= 0x41,
	Z80_OP_LD_B_D		= 0x42,	Z80_OP_LD_B_E		= 0x43,
	Z80_OP_LD_B_H		= 0x44,	Z80_OP_LD_B_L		= 0x45,
	Z80_OP_LD_B_mHL		= 0x46,	Z80_OP_LD_B_A		= 0x47,
	Z80_OP_LD_C_B		= 0x48,	Z80_OP_LD_C_C		= 0x49,
	Z80_OP_LD_C_D		= 0x4A,	Z80_OP_LD_C_E		= 0x4B,
	Z80_OP_LD_C_H		= 0x4C,	Z80_OP_LD_C_L		= 0x4D,
	Z80_OP_LD_C_mHL		= 0x4E,	Z80_OP_LD_C_A		= 0x4F,
	
	/* 0x50 - 0x5F */
	Z80_OP_LD_D_B		= 0x50,	Z80_OP_LD_D_C		= 0x51,
	Z80_OP_LD_D_D		= 0x52,	Z80_OP_LD_D_E		= 0x53,
	Z80_OP_LD_D_H		= 0x54,	Z80_OP_LD_D_L		= 0x55,
	Z80_OP_LD_D_mHL		= 0x56,	Z80_OP_LD_D_A		= 0x57,
	Z80_OP_LD_E_B		= 0x58,	Z80_OP_LD_E_C		= 0x59,
	Z80_OP_LD_E_D		= 0x5A,	Z80_OP_LD_E_E		= 0x5B,
	Z80_OP_LD_E_H		= 0x5C,	Z80_OP_LD_E_L		= 0x5D,
	Z80_OP_LD_E_mHL		= 0x5E,	Z80_OP_LD_E_A		= 0x5F,
	
	/* 0x60 - 0x6F */
	Z80_OP_LD_H_B		= 0x60,	Z80_OP_LD_H_C		= 0x61,
	Z80_OP_LD_H_D		= 0x62,	Z80_OP_LD_H_E		= 0x63,
	Z80_OP_LD_H_H		= 0x64,	Z80_OP_LD_H_L		= 0x65,
	Z80_OP_LD_H_mHL		= 0x66,	Z80_OP_LD_H_A		= 0x67,
	Z80_OP_LD_L_B		= 0x68,	Z80_OP_LD_L_C		= 0x69,
	Z80_OP_LD_L_D		= 0x6A,	Z80_OP_LD_L_E		= 0x6B,
	Z80_OP_LD_L_H		= 0x6C,	Z80_OP_LD_L_L		= 0x6D,
	Z80_OP_LD_L_mHL		= 0x6E,	Z80_OP_LD_L_A		= 0x6F,
	
	/* 0x70 - 0x7F */
	Z80_OP_LD_mHL_B		= 0x70,	Z80_OP_LD_mHL_C		= 0x71,
	Z80_OP_LD_mHL_D		= 0x72,	Z80_OP_LD_mHL_E		= 0x73,
	Z80_OP_LD_mHL_H		= 0x74,	Z80_OP_LD_mHL_L		= 0x75,
	Z80_OP_LD_mHL_mHL	= 0x76,	Z80_OP_LD_mHL_A		= 0x77,
	Z80_OP_LD_A_B		= 0x78,	Z80_OP_LD_A_C		= 0x79,
	Z80_OP_LD_A_D		= 0x7A,	Z80_OP_LD_A_E		= 0x7B,
	Z80_OP_LD_A_H		= 0x7C,	Z80_OP_LD_A_L		= 0x7D,
	Z80_OP_LD_A_mHL		= 0x7E,	Z80_OP_LD_A_A		= 0x7F,
	
	/* 0x80 - 0x8F */
	Z80_OP_ADD_A_B		= 0x80,	Z80_OP_ADD_A_C		= 0x81,
	Z80_OP_ADD_A_D		= 0x82,	Z80_OP_ADD_A_E		= 0x83,
	Z80_OP_ADD_A_H		= 0x84,	Z80_OP_ADD_A_L		= 0x85,
	Z80_OP_ADD_A_mHL	= 0x86,	Z80_OP_ADD_A_A		= 0x87,
	Z80_OP_ADC_A_B		= 0x88,	Z80_OP_ADC_A_C		= 0x89,
	Z80_OP_ADC_A_D		= 0x8A,	Z80_OP_ADC_A_E		= 0x8B,
	Z80_OP_ADC_A_H		= 0x8C,	Z80_OP_ADC_A_L		= 0x8D,
	Z80_OP_ADC_A_mHL	= 0x8E,	Z80_OP_ADC_A_A		= 0x8F,
	
	/* 0x90 - 0x9F */
	Z80_OP_SUB_B		= 0x90,	Z80_OP_SUB_C		= 0x91,
	Z80_OP_SUB_D		= 0x92,	Z80_OP_SUB_E		= 0x93,
	Z80_OP_SUB_H		= 0x94,	Z80_OP_SUB_L		= 0x95,
	Z80_OP_SUB_mHL		= 0x96,	Z80_OP_SUB_A		= 0x97,
	Z80_OP_SBC_B		= 0x98,	Z80_OP_SBC_C		= 0x99,
	Z80_OP_SBC_D		= 0x9A,	Z80_OP_SBC_E		= 0x9B,
	Z80_OP_SBC_H		= 0x9C,	Z80_OP_SBC_L		= 0x9D,
	Z80_OP_SBC_mHL		= 0x9E,	Z80_OP_SBC_A		= 0x9F,
	
	/* 0xA0 - 0xAF */
	Z80_OP_AND_B		= 0xA0,	Z80_OP_AND_C		= 0xA1,
	Z80_OP_AND_D		= 0xA2,	Z80_OP_AND_E		= 0xA3,
	Z80_OP_AND_H		= 0xA4,	Z80_OP_AND_L		= 0xA5,
	Z80_OP_AND_mHL		= 0xA6,	Z80_OP_AND_A		= 0xA7,
	Z80_OP_XOR_B		= 0xA8,	Z80_OP_XOR_C		= 0xA9,
	Z80_OP_XOR_D		= 0xAA,	Z80_OP_XOR_E		= 0xAB,
	Z80_OP_XOR_H		= 0xAC,	Z80_OP_XOR_L		= 0xAD,
	Z80_OP_XOR_mHL		= 0xAE,	Z80_OP_XOR_A		= 0xAF,
	
	/* 0xB0 - 0xBF */
	Z80_OP_OR_B		= 0xB0,	Z80_OP_OR_C		= 0xB1,
	Z80_OP_OR_D		= 0xB2,	Z80_OP_OR_E		= 0xB3,
	Z80_OP_OR_H		= 0xB4,	Z80_OP_OR_L		= 0xB5,
	Z80_OP_OR_mHL		= 0xB6,	Z80_OP_OR_A		= 0xB7,
	Z80_OP_CP_B		= 0xB8,	Z80_OP_CP_C		= 0xB9,
	Z80_OP_CP_D		= 0xBA,	Z80_OP_CP_E		= 0xBB,
	Z80_OP_CP_H		= 0xBC,	Z80_OP_CP_L		= 0xBD,
	Z80_OP_CP_mHL		= 0xBE,	Z80_OP_CP_A		= 0xBF,
	
	/* 0xC0 - 0xCF */
	Z80_OP_RET_NZ		= 0xC0,	Z80_OP_POP_BC		= 0xC1,
	Z80_OP_JP_NZ_NN		= 0xC2,	Z80_OP_JP_NN		= 0xC3,
	Z80_OP_CALL_NZ_NN	= 0xC4,	Z80_OP_PUSH_BC		= 0xC5,
	Z80_OP_ADD_A_N		= 0xC6,	Z80_OP_RST_00h		= 0xC7,
	Z80_OP_RET_Z		= 0xC8,	Z80_OP_RET		= 0xC9,
	Z80_OP_JP_Z_NN		= 0xCA,	Z80_PREFIX_CB		= 0xCB,
	Z80_OP_CALL_Z_NN	= 0xCC,	Z80_OP_CALL_NN		= 0xCD,
	Z80_OP_ADC_A_N		= 0xCE,	Z80_OP_RST_08h		= 0xCF,
	
	/* 0xD0 - 0xDF */
	Z80_OP_RET_NC		= 0xD0,	Z80_OP_POP_DE		= 0xD1,
	Z80_OP_JP_NC_NN		= 0xD2,	Z80_OP_OUT_mN		= 0xD3,
	Z80_OP_CALL_NC_NN	= 0xD4,	Z80_OP_PUSH_DE		= 0xD5,
	Z80_OP_SUB_N		= 0xD6,	Z80_OP_RST_10h		= 0xD7,
	Z80_OP_RET_C		= 0xD8,	Z80_OP_EXX		= 0xD9,
	Z80_OP_JP_C_NN		= 0xDA,	Z80_IN_mN		= 0xDB,
	Z80_OP_CALL_C_NN	= 0xDC,	Z80_PREFIX_DD		= 0xDD,
	Z80_OP_SBC_N		= 0xDE,	Z80_OP_RST_18h		= 0xDF,
	
	/* 0xE0 - 0xEF */
	Z80_OP_RET_NP		= 0xE0,	Z80_OP_POP_HL		= 0xE1,
	Z80_OP_JP_NP_NN		= 0xE2,	Z80_OP_EX_mSP_HL	= 0xE3,
	Z80_OP_CALL_NP_NN	= 0xE4,	Z80_OP_PUSH_HL		= 0xE5,
	Z80_OP_AND_N		= 0xE6,	Z80_OP_RST_20h		= 0xE7,
	Z80_OP_RET_P		= 0xE8,	Z80_OP_JP_HL		= 0xE9,
	Z80_OP_JP_P_NN		= 0xEA,	Z80_EX_DE_HL		= 0xEB,
	Z80_OP_CALL_P_NN	= 0xEC,	Z80_PREFIX_ED		= 0xED,
	Z80_OP_XOR_N		= 0xEE,	Z80_OP_RST_28h		= 0xEF,
	
	/* 0xF0 - 0xFF */
	Z80_OP_RET_NS		= 0xF0,	Z80_OP_POP_AF		= 0xF1,
	Z80_OP_JP_NS_NN		= 0xF2,	Z80_OP_DI		= 0xF3,
	Z80_OP_CALL_NS_NN	= 0xF4,	Z80_OP_PUSH_AF		= 0xF5,
	Z80_OP_OR_N		= 0xF6,	Z80_OP_RST_30h		= 0xF7,
	Z80_OP_RET_S		= 0xF8,	Z80_OP_LD_SP_HL		= 0xF9,
	Z80_OP_JP_S_NN		= 0xFA,	Z80_EX_EI		= 0xFB,
	Z80_OP_CALL_S_NN	= 0xFC,	Z80_PREFIX_FD		= 0xFD,
	Z80_OP_CP_N		= 0xFE,	Z80_OP_RST_38h		= 0xFF,
};


/**
 * Z80 opcodes: 2-byte opcodes, "CB" prefix.
 */
enum mdZ80_opcode_CB
{
	/* 0x00 - 0x0F */
	Z80_OP_CB_RLC_B		= 0x00,	Z80_OP_CB_RLC_C		= 0x01,
	Z80_OP_CB_RLC_D		= 0x02,	Z80_OP_CB_RLC_E		= 0x03,
	Z80_OP_CB_RLC_H		= 0x04,	Z80_OP_CB_RLC_L		= 0x05,
	Z80_OP_CB_RLC_mHL	= 0x06,	Z80_OP_CB_RLC_A		= 0x07,
	Z80_OP_CB_RRC_B		= 0x08,	Z80_OP_CB_RRC_C		= 0x09,
	Z80_OP_CB_RRC_D		= 0x0A,	Z80_OP_CB_RRC_E		= 0x0B,
	Z80_OP_CB_RRC_H		= 0x0C,	Z80_OP_CB_RRC_L		= 0x0D,
	Z80_OP_CB_RRC_mHL	= 0x0E,	Z80_OP_CB_RRC_A		= 0x0F,
	
	/* 0x10 - 0x1F */
	Z80_OP_CB_RL_B		= 0x10,	Z80_OP_CB_RL_C		= 0x11,
	Z80_OP_CB_RL_D		= 0x12,	Z80_OP_CB_RL_E		= 0x13,
	Z80_OP_CB_RL_H		= 0x14,	Z80_OP_CB_RL_L		= 0x15,
	Z80_OP_CB_RL_mHL	= 0x16,	Z80_OP_CB_RL_A		= 0x17,
	Z80_OP_CB_RR_B		= 0x18,	Z80_OP_CB_RR_C		= 0x19,
	Z80_OP_CB_RR_D		= 0x1A,	Z80_OP_CB_RR_E		= 0x1B,
	Z80_OP_CB_RR_H		= 0x1C,	Z80_OP_CB_RR_L		= 0x1D,
	Z80_OP_CB_RR_mHL	= 0x1E,	Z80_OP_CB_RR_A		= 0x1F,
	
	/* 0x20 - 0x2F */
	Z80_OP_CB_SLA_B		= 0x20,	Z80_OP_CB_SLA_C		= 0x21,
	Z80_OP_CB_SLA_D		= 0x22,	Z80_OP_CB_SLA_E		= 0x23,
	Z80_OP_CB_SLA_H		= 0x24,	Z80_OP_CB_SLA_L		= 0x25,
	Z80_OP_CB_SLA_mHL	= 0x26,	Z80_OP_CB_SLA_A		= 0x27,
	Z80_OP_CB_SRA_B		= 0x28,	Z80_OP_CB_SRA_C		= 0x29,
	Z80_OP_CB_SRA_D		= 0x2A,	Z80_OP_CB_SRA_E		= 0x2B,
	Z80_OP_CB_SRA_H		= 0x2C,	Z80_OP_CB_SRA_L		= 0x2D,
	Z80_OP_CB_SRA_mHL	= 0x2E,	Z80_OP_CB_SRA_A		= 0x2F,
	
	/* 0x30 - 0x3F */
	Z80_OP_CB_SLL_B		= 0x30,	Z80_OP_CB_SLL_C		= 0x31,
	Z80_OP_CB_SLL_D		= 0x32,	Z80_OP_CB_SLL_E		= 0x33,
	Z80_OP_CB_SLL_H		= 0x34,	Z80_OP_CB_SLL_L		= 0x35,
	Z80_OP_CB_SLL_mHL	= 0x36,	Z80_OP_CB_SLL_A		= 0x37,
	Z80_OP_CB_SRL_B		= 0x38,	Z80_OP_CB_SRL_C		= 0x39,
	Z80_OP_CB_SRL_D		= 0x3A,	Z80_OP_CB_SRL_E		= 0x3B,
	Z80_OP_CB_SRL_H		= 0x3C,	Z80_OP_CB_SRL_L		= 0x3D,
	Z80_OP_CB_SRL_mHL	= 0x3E,	Z80_OP_CB_SRL_A		= 0x3F,
	
	/* 0x40 - 0x4F */
	Z80_OP_CB_BIT_0_B	= 0x40,	Z80_OP_CB_BIT_0_C	= 0x41,
	Z80_OP_CB_BIT_0_D	= 0x42,	Z80_OP_CB_BIT_0_E	= 0x43,
	Z80_OP_CB_BIT_0_H	= 0x44,	Z80_OP_CB_BIT_0_L	= 0x45,
	Z80_OP_CB_BIT_0_mHL	= 0x46,	Z80_OP_CB_BIT_0_A	= 0x47,
	Z80_OP_CB_BIT_1_B	= 0x48,	Z80_OP_CB_BIT_1_C	= 0x49,
	Z80_OP_CB_BIT_1_D	= 0x4A,	Z80_OP_CB_BIT_1_E	= 0x4B,
	Z80_OP_CB_BIT_1_H	= 0x4C,	Z80_OP_CB_BIT_1_L	= 0x4D,
	Z80_OP_CB_BIT_1_mHL	= 0x4E,	Z80_OP_CB_BIT_1_A	= 0x4F,
	
	/* 0x50 - 0x5F */
	Z80_OP_CB_BIT_2_B	= 0x50,	Z80_OP_CB_BIT_2_C	= 0x51,
	Z80_OP_CB_BIT_2_D	= 0x52,	Z80_OP_CB_BIT_2_E	= 0x53,
	Z80_OP_CB_BIT_2_H	= 0x54,	Z80_OP_CB_BIT_2_L	= 0x55,
	Z80_OP_CB_BIT_2_mHL	= 0x56,	Z80_OP_CB_BIT_2_A	= 0x57,
	Z80_OP_CB_BIT_3_B	= 0x58,	Z80_OP_CB_BIT_3_C	= 0x59,
	Z80_OP_CB_BIT_3_D	= 0x5A,	Z80_OP_CB_BIT_3_E	= 0x5B,
	Z80_OP_CB_BIT_3_H	= 0x5C,	Z80_OP_CB_BIT_3_L	= 0x5D,
	Z80_OP_CB_BIT_3_mHL	= 0x5E,	Z80_OP_CB_BIT_3_A	= 0x5F,
	
	/* 0x60 - 0x6F */
	Z80_OP_CB_BIT_4_B	= 0x60,	Z80_OP_CB_BIT_4_C	= 0x61,
	Z80_OP_CB_BIT_4_D	= 0x62,	Z80_OP_CB_BIT_4_E	= 0x63,
	Z80_OP_CB_BIT_4_H	= 0x64,	Z80_OP_CB_BIT_4_L	= 0x65,
	Z80_OP_CB_BIT_4_mHL	= 0x66,	Z80_OP_CB_BIT_4_A	= 0x67,
	Z80_OP_CB_BIT_5_B	= 0x68,	Z80_OP_CB_BIT_5_C	= 0x69,
	Z80_OP_CB_BIT_5_D	= 0x6A,	Z80_OP_CB_BIT_5_E	= 0x6B,
	Z80_OP_CB_BIT_5_H	= 0x6C,	Z80_OP_CB_BIT_5_L	= 0x6D,
	Z80_OP_CB_BIT_5_mHL	= 0x6E,	Z80_OP_CB_BIT_5_A	= 0x6F,
	
	/* 0x70 - 0x7F */
	Z80_OP_CB_BIT_6_B	= 0x70,	Z80_OP_CB_BIT_6_C	= 0x71,
	Z80_OP_CB_BIT_6_D	= 0x72,	Z80_OP_CB_BIT_6_E	= 0x73,
	Z80_OP_CB_BIT_6_H	= 0x74,	Z80_OP_CB_BIT_6_L	= 0x75,
	Z80_OP_CB_BIT_6_mHL	= 0x76,	Z80_OP_CB_BIT_6_A	= 0x77,
	Z80_OP_CB_BIT_7_B	= 0x78,	Z80_OP_CB_BIT_7_C	= 0x79,
	Z80_OP_CB_BIT_7_D	= 0x7A,	Z80_OP_CB_BIT_7_E	= 0x7B,
	Z80_OP_CB_BIT_7_H	= 0x7C,	Z80_OP_CB_BIT_7_L	= 0x7D,
	Z80_OP_CB_BIT_7_mHL	= 0x7E,	Z80_OP_CB_BIT_7_A	= 0x7F,
	
	/* 0x80 - 0x8F */
	Z80_OP_CB_RES_0_B	= 0x80,	Z80_OP_CB_RES_0_C	= 0x81,
	Z80_OP_CB_RES_0_D	= 0x82,	Z80_OP_CB_RES_0_E	= 0x83,
	Z80_OP_CB_RES_0_H	= 0x84,	Z80_OP_CB_RES_0_L	= 0x85,
	Z80_OP_CB_RES_0_mHL	= 0x86,	Z80_OP_CB_RES_0_A	= 0x87,
	Z80_OP_CB_RES_1_B	= 0x88,	Z80_OP_CB_RES_1_C	= 0x89,
	Z80_OP_CB_RES_1_D	= 0x8A,	Z80_OP_CB_RES_1_E	= 0x8B,
	Z80_OP_CB_RES_1_H	= 0x8C,	Z80_OP_CB_RES_1_L	= 0x8D,
	Z80_OP_CB_RES_1_mHL	= 0x8E,	Z80_OP_CB_RES_1_A	= 0x8F,
	
	/* 0x90 - 0x9F */
	Z80_OP_CB_RES_2_B	= 0x90,	Z80_OP_CB_RES_2_C	= 0x91,
	Z80_OP_CB_RES_2_D	= 0x92,	Z80_OP_CB_RES_2_E	= 0x93,
	Z80_OP_CB_RES_2_H	= 0x94,	Z80_OP_CB_RES_2_L	= 0x95,
	Z80_OP_CB_RES_2_mHL	= 0x96,	Z80_OP_CB_RES_2_A	= 0x97,
	Z80_OP_CB_RES_3_B	= 0x98,	Z80_OP_CB_RES_3_C	= 0x99,
	Z80_OP_CB_RES_3_D	= 0x9A,	Z80_OP_CB_RES_3_E	= 0x9B,
	Z80_OP_CB_RES_3_H	= 0x9C,	Z80_OP_CB_RES_3_L	= 0x9D,
	Z80_OP_CB_RES_3_mHL	= 0x9E,	Z80_OP_CB_RES_3_A	= 0x9F,
	
	/* 0xA0 - 0xAF */
	Z80_OP_CB_RES_4_B	= 0xA0,	Z80_OP_CB_RES_4_C	= 0xA1,
	Z80_OP_CB_RES_4_D	= 0xA2,	Z80_OP_CB_RES_4_E	= 0xA3,
	Z80_OP_CB_RES_4_H	= 0xA4,	Z80_OP_CB_RES_4_L	= 0xA5,
	Z80_OP_CB_RES_4_mHL	= 0xA6,	Z80_OP_CB_RES_4_A	= 0xA7,
	Z80_OP_CB_RES_5_B	= 0xA8,	Z80_OP_CB_RES_5_C	= 0xA9,
	Z80_OP_CB_RES_5_D	= 0xAA,	Z80_OP_CB_RES_5_E	= 0xAB,
	Z80_OP_CB_RES_5_H	= 0xAC,	Z80_OP_CB_RES_5_L	= 0xAD,
	Z80_OP_CB_RES_5_mHL	= 0xAE,	Z80_OP_CB_RES_5_A	= 0xAF,
	
	/* 0xB0 - 0xBF */
	Z80_OP_CB_RES_6_B	= 0xB0,	Z80_OP_CB_RES_6_C	= 0xB1,
	Z80_OP_CB_RES_6_D	= 0xB2,	Z80_OP_CB_RES_6_E	= 0xB3,
	Z80_OP_CB_RES_6_H	= 0xB4,	Z80_OP_CB_RES_6_L	= 0xB5,
	Z80_OP_CB_RES_6_mHL	= 0xB6,	Z80_OP_CB_RES_6_A	= 0xB7,
	Z80_OP_CB_RES_7_B	= 0xB8,	Z80_OP_CB_RES_7_C	= 0xB9,
	Z80_OP_CB_RES_7_D	= 0xBA,	Z80_OP_CB_RES_7_E	= 0xBB,
	Z80_OP_CB_RES_7_H	= 0xBC,	Z80_OP_CB_RES_7_L	= 0xBD,
	Z80_OP_CB_RES_7_mHL	= 0xBE,	Z80_OP_CB_RES_7_A	= 0xBF,
	
	/* 0xC0 - 0xCF */
	Z80_OP_CB_SET_0_B	= 0xC0,	Z80_OP_CB_SET_0_C	= 0xC1,
	Z80_OP_CB_SET_0_D	= 0xC2,	Z80_OP_CB_SET_0_E	= 0xC3,
	Z80_OP_CB_SET_0_H	= 0xC4,	Z80_OP_CB_SET_0_L	= 0xC5,
	Z80_OP_CB_SET_0_mHL	= 0xC6,	Z80_OP_CB_SET_0_A	= 0xC7,
	Z80_OP_CB_SET_1_B	= 0xC8,	Z80_OP_CB_SET_1_C	= 0xC9,
	Z80_OP_CB_SET_1_D	= 0xCA,	Z80_OP_CB_SET_1_E	= 0xCB,
	Z80_OP_CB_SET_1_H	= 0xCC,	Z80_OP_CB_SET_1_L	= 0xCD,
	Z80_OP_CB_SET_1_mHL	= 0xCE,	Z80_OP_CB_SET_1_A	= 0xCF,
	
	/* 0xD0 - 0xDF */
	Z80_OP_CB_SET_2_B	= 0xD0,	Z80_OP_CB_SET_2_C	= 0xD1,
	Z80_OP_CB_SET_2_D	= 0xD2,	Z80_OP_CB_SET_2_E	= 0xD3,
	Z80_OP_CB_SET_2_H	= 0xD4,	Z80_OP_CB_SET_2_L	= 0xD5,
	Z80_OP_CB_SET_2_mHL	= 0xD6,	Z80_OP_CB_SET_2_A	= 0xD7,
	Z80_OP_CB_SET_3_B	= 0xD8,	Z80_OP_CB_SET_3_C	= 0xD9,
	Z80_OP_CB_SET_3_D	= 0xDA,	Z80_OP_CB_SET_3_E	= 0xDB,
	Z80_OP_CB_SET_3_H	= 0xDC,	Z80_OP_CB_SET_3_L	= 0xDD,
	Z80_OP_CB_SET_3_mHL	= 0xDE,	Z80_OP_CB_SET_3_A	= 0xDF,
	
	/* 0xE0 - 0xEF */
	Z80_OP_CB_SET_4_B	= 0xE0,	Z80_OP_CB_SET_4_C	= 0xE1,
	Z80_OP_CB_SET_4_D	= 0xE2,	Z80_OP_CB_SET_4_E	= 0xE3,
	Z80_OP_CB_SET_4_H	= 0xE4,	Z80_OP_CB_SET_4_L	= 0xE5,
	Z80_OP_CB_SET_4_mHL	= 0xE6,	Z80_OP_CB_SET_4_A	= 0xE7,
	Z80_OP_CB_SET_5_B	= 0xE8,	Z80_OP_CB_SET_5_C	= 0xE9,
	Z80_OP_CB_SET_5_D	= 0xEA,	Z80_OP_CB_SET_5_E	= 0xEB,
	Z80_OP_CB_SET_5_H	= 0xEC,	Z80_OP_CB_SET_5_L	= 0xED,
	Z80_OP_CB_SET_5_mHL	= 0xEE,	Z80_OP_CB_SET_5_A	= 0xEF,
	
	/* 0xF0 - 0xFF */
	Z80_OP_CB_SET_6_B	= 0xF0,	Z80_OP_CB_SET_6_C	= 0xF1,
	Z80_OP_CB_SET_6_D	= 0xF2,	Z80_OP_CB_SET_6_E	= 0xF3,
	Z80_OP_CB_SET_6_H	= 0xF4,	Z80_OP_CB_SET_6_L	= 0xF5,
	Z80_OP_CB_SET_6_mHL	= 0xF6,	Z80_OP_CB_SET_6_A	= 0xF7,
	Z80_OP_CB_SET_7_B	= 0xF8,	Z80_OP_CB_SET_7_C	= 0xF9,
	Z80_OP_CB_SET_7_D	= 0xFA,	Z80_OP_CB_SET_7_E	= 0xFB,
	Z80_OP_CB_SET_7_H	= 0xFC,	Z80_OP_CB_SET_7_L	= 0xFD,
	Z80_OP_CB_SET_7_mHL	= 0xFE,	Z80_OP_CB_SET_7_A	= 0xFF,
};


/**
 * Z80 opcodes: 2-byte opcodes, "DD" prefix.
 */
enum mdZ80_opcode_DD
{
	/* 0x00 - 0x0F */
	Z80_OP_DD_NOP		= 0x00,	Z80_OP_DD_LD_BC_NN	= 0x01,
	Z80_OP_DD_LD_mBC_A	= 0x02,	Z80_OP_DD_INC_BC	= 0x03,
	Z80_OP_DD_INC_B		= 0x04,	Z80_OP_DD_DEC_B		= 0x05,
	Z80_OP_DD_LD_B_N	= 0x06,	Z80_OP_DD_RLCA		= 0x07,
	Z80_OP_DD_EX_AF_AF2	= 0x08,	Z80_OP_DD_ADD_IX_BC	= 0x09,
	Z80_OP_DD_LD_A_mBC	= 0x0A,	Z80_OP_DD_DEC_BC	= 0x0B,
	Z80_OP_DD_INC_C		= 0x0C,	Z80_OP_DD_DEC_C		= 0x0D,
	Z80_OP_DD_LD_C_N	= 0x0E,	Z80_OP_DD_RRCA		= 0x0F,
	
	/* 0x10 - 0x1F */
	Z80_OP_DD_DJNZ		= 0x10,	Z80_OP_DD_LD_DE_NN	= 0x11,
	Z80_OP_DD_LD_mDE_A	= 0x12,	Z80_OP_DD_INC_DE	= 0x13,
	Z80_OP_DD_INC_D		= 0x14,	Z80_OP_DD_DEC_D		= 0x15,
	Z80_OP_DD_LD_D_N	= 0x16,	Z80_OP_DD_RLA		= 0x17,
	Z80_OP_DD_JR_N		= 0x18,	Z80_OP_DD_ADD_IX_DE	= 0x19,
	Z80_OP_DD_LD_A_mDE	= 0x1A,	Z80_OP_DD_DEC_DE	= 0x1B,
	Z80_OP_DD_INC_E		= 0x1C,	Z80_OP_DD_DEC_E		= 0x1D,
	Z80_OP_DD_LD_E_N	= 0x1E,	Z80_OP_DD_RRA		= 0x1F,
	
	/* 0x20 - 0x2F */
	Z80_OP_DD_JRNZ_N	= 0x20,	Z80_OP_DD_LD_IX_NN	= 0x21,
	Z80_OP_DD_LD_mNN_IX	= 0x22,	Z80_OP_DD_INC_IX	= 0x23,
	Z80_OP_DD_INC_hIX	= 0x24,	Z80_OP_DD_DEC_hIX	= 0x25,
	Z80_OP_DD_LD_hIX_N	= 0x26,	Z80_OP_DD_DAA		= 0x27,
	Z80_OP_DD_JRZ_N		= 0x28,	Z80_OP_DD_ADD_IX_IX	= 0x29,
	Z80_OP_DD_LD_IX_mNN	= 0x2A,	Z80_OP_DD_DEC_IX	= 0x2B,
	Z80_OP_DD_INC_lIX	= 0x2C,	Z80_OP_DD_DEC_lIX	= 0x2D,
	Z80_OP_DD_LD_lIX_N	= 0x2E,	Z80_OP_DD_CPL		= 0x2F,
	
	/* 0x30 - 0x3F */
	Z80_OP_DD_JRNC_N	= 0x30,	Z80_OP_DD_LD_SP_NN	= 0x31,
	Z80_OP_DD_LD_mNN_A	= 0x32,	Z80_OP_DD_INC_SP	= 0x33,
	Z80_OP_DD_INC_mIXd	= 0x34,	Z80_OP_DD_DEC_mIXd	= 0x35,
	Z80_OP_DD_LD_mIXd_N	= 0x36,	Z80_OP_DD_SCF		= 0x37,
	Z80_OP_DD_JRC_N		= 0x38,	Z80_OP_DD_ADD_IX_SP	= 0x39,
	Z80_OP_DD_LD_A_mNN	= 0x3A,	Z80_OP_DD_DEC_SP	= 0x3B,
	Z80_OP_DD_INC_A		= 0x3C,	Z80_OP_DD_DEC_A		= 0x3D,
	Z80_OP_DD_LD_A_N	= 0x3E,	Z80_OP_DD_CCF		= 0x3F,
	
	/* 0x40 - 0x4F */
	Z80_OP_DD_LD_B_B	= 0x40,	Z80_OP_DD_LD_B_C	= 0x41,
	Z80_OP_DD_LD_B_D	= 0x42,	Z80_OP_DD_LD_B_E	= 0x43,
	Z80_OP_DD_LD_B_hIX	= 0x44,	Z80_OP_DD_LD_B_lIX	= 0x45,
	Z80_OP_DD_LD_B_mIXd	= 0x46,	Z80_OP_DD_LD_B_A	= 0x47,
	Z80_OP_DD_LD_C_B	= 0x48,	Z80_OP_DD_LD_C_C	= 0x49,
	Z80_OP_DD_LD_C_D	= 0x4A,	Z80_OP_DD_LD_C_E	= 0x4B,
	Z80_OP_DD_LD_C_hIX	= 0x4C,	Z80_OP_DD_LD_C_lIX	= 0x4D,
	Z80_OP_DD_LD_C_mIXd	= 0x4E,	Z80_OP_DD_LD_C_A	= 0x4F,
	
	/* 0x50 - 0x5F */
	Z80_OP_DD_LD_D_B	= 0x50,	Z80_OP_DD_LD_D_C	= 0x51,
	Z80_OP_DD_LD_D_D	= 0x52,	Z80_OP_DD_LD_D_E	= 0x53,
	Z80_OP_DD_LD_D_hIX	= 0x54,	Z80_OP_DD_LD_D_lIX	= 0x55,
	Z80_OP_DD_LD_D_mIXd	= 0x56,	Z80_OP_DD_LD_D_A	= 0x57,
	Z80_OP_DD_LD_E_B	= 0x58,	Z80_OP_DD_LD_E_C	= 0x59,
	Z80_OP_DD_LD_E_D	= 0x5A,	Z80_OP_DD_LD_E_E	= 0x5B,
	Z80_OP_DD_LD_E_hIX	= 0x5C,	Z80_OP_DD_LD_E_lIX	= 0x5D,
	Z80_OP_DD_LD_E_mIXd	= 0x5E,	Z80_OP_DD_LD_E_A	= 0x5F,
	
	/* 0x60 - 0x6F */
	Z80_OP_DD_LD_hIX_B	= 0x60,	Z80_OP_DD_LD_hIX_C	= 0x61,
	Z80_OP_DD_LD_hIX_D	= 0x62,	Z80_OP_DD_LD_hIX_E	= 0x63,
	Z80_OP_DD_LD_hIX_hIX	= 0x64,	Z80_OP_DD_LD_hIX_lIX	= 0x65,
	Z80_OP_DD_LD_hIX_mIXd	= 0x66,	Z80_OP_DD_LD_hIX_A	= 0x67,
	Z80_OP_DD_LD_lIX_B	= 0x68,	Z80_OP_DD_LD_lIX_C	= 0x69,
	Z80_OP_DD_LD_lIX_D	= 0x6A,	Z80_OP_DD_LD_lIX_E	= 0x6B,
	Z80_OP_DD_LD_lIX_hIX	= 0x6C,	Z80_OP_DD_LD_lIX_lIX	= 0x6D,
	Z80_OP_DD_LD_lIX_mIXd	= 0x6E,	Z80_OP_DD_LD_lIX_A	= 0x6F,
	
	/* 0x70 - 0x7F */
	Z80_OP_DD_LD_mIXd_B	= 0x70,	Z80_OP_DD_LD_mIXd_C	= 0x71,
	Z80_OP_DD_LD_mIXd_D	= 0x72,	Z80_OP_DD_LD_mIXd_E	= 0x73,
	Z80_OP_DD_LD_mIXd_hIX	= 0x74,	Z80_OP_DD_LD_mIXd_lIX	= 0x75,
	Z80_OP_DD_LD_mIXd_mIXd	= 0x76,	Z80_OP_DD_LD_mIXd_A	= 0x77,
	Z80_OP_DD_LD_A_B	= 0x78,	Z80_OP_DD_LD_A_C	= 0x79,
	Z80_OP_DD_LD_A_D	= 0x7A,	Z80_OP_DD_LD_A_E	= 0x7B,
	Z80_OP_DD_LD_A_hIX	= 0x7C,	Z80_OP_DD_LD_A_lIX	= 0x7D,
	Z80_OP_DD_LD_A_mIXd	= 0x7E,	Z80_OP_DD_LD_A_A	= 0x7F,
	
	/* 0x80 - 0x8F */
	Z80_OP_DD_ADD_A_B	= 0x80,	Z80_OP_DD_ADD_A_C	= 0x81,
	Z80_OP_DD_ADD_A_D	= 0x82,	Z80_OP_DD_ADD_A_E	= 0x83,
	Z80_OP_DD_ADD_A_hIX	= 0x84,	Z80_OP_DD_ADD_A_lIX	= 0x85,
	Z80_OP_DD_ADD_A_mIXd	= 0x86,	Z80_OP_DD_ADD_A_A	= 0x87,
	Z80_OP_DD_ADC_A_B	= 0x88,	Z80_OP_DD_ADC_A_C	= 0x89,
	Z80_OP_DD_ADC_A_D	= 0x8A,	Z80_OP_DD_ADC_A_E	= 0x8B,
	Z80_OP_DD_ADC_A_hIX	= 0x8C,	Z80_OP_DD_ADC_A_lIX	= 0x8D,
	Z80_OP_DD_ADC_A_mIXd	= 0x8E,	Z80_OP_DD_ADC_A_A	= 0x8F,
	
	/* 0x90 - 0x9F */
	Z80_OP_DD_SUB_B		= 0x90,	Z80_OP_DD_SUB_C		= 0x91,
	Z80_OP_DD_SUB_D		= 0x92,	Z80_OP_DD_SUB_E		= 0x93,
	Z80_OP_DD_SUB_hIX	= 0x94,	Z80_OP_DD_SUB_lIX	= 0x95,
	Z80_OP_DD_SUB_mIXd	= 0x96,	Z80_OP_DD_SUB_A		= 0x97,
	Z80_OP_DD_SBC_B		= 0x98,	Z80_OP_DD_SBC_C		= 0x99,
	Z80_OP_DD_SBC_D		= 0x9A,	Z80_OP_DD_SBC_E		= 0x9B,
	Z80_OP_DD_SBC_hIX	= 0x9C,	Z80_OP_DD_SBC_lIX	= 0x9D,
	Z80_OP_DD_SBC_mIXd	= 0x9E,	Z80_OP_DD_SBC_A		= 0x9F,
	
	/* 0xA0 - 0xAF */
	Z80_OP_DD_AND_B		= 0xA0,	Z80_OP_DD_AND_C		= 0xA1,
	Z80_OP_DD_AND_D		= 0xA2,	Z80_OP_DD_AND_E		= 0xA3,
	Z80_OP_DD_AND_hIX	= 0xA4,	Z80_OP_DD_AND_lIX	= 0xA5,
	Z80_OP_DD_AND_mIXd	= 0xA6,	Z80_OP_DD_AND_A		= 0xA7,
	Z80_OP_DD_XOR_B		= 0xA8,	Z80_OP_DD_XOR_C		= 0xA9,
	Z80_OP_DD_XOR_D		= 0xAA,	Z80_OP_DD_XOR_E		= 0xAB,
	Z80_OP_DD_XOR_hIX	= 0xAC,	Z80_OP_DD_XOR_lIX	= 0xAD,
	Z80_OP_DD_XOR_mIXd	= 0xAE,	Z80_OP_DD_XOR_A		= 0xAF,
	
	/* 0xB0 - 0xBF */
	Z80_OP_DD_OR_B		= 0xB0,	Z80_OP_DD_OR_C		= 0xB1,
	Z80_OP_DD_OR_D		= 0xB2,	Z80_OP_DD_OR_E		= 0xB3,
	Z80_OP_DD_OR_hIX	= 0xB4,	Z80_OP_DD_OR_lIX	= 0xB5,
	Z80_OP_DD_OR_mIXd	= 0xB6,	Z80_OP_DD_OR_A		= 0xB7,
	Z80_OP_DD_CP_B		= 0xB8,	Z80_OP_DD_CP_C		= 0xB9,
	Z80_OP_DD_CP_D		= 0xBA,	Z80_OP_DD_CP_E		= 0xBB,
	Z80_OP_DD_CP_hIX	= 0xBC,	Z80_OP_DD_CP_lIX	= 0xBD,
	Z80_OP_DD_CP_mIXd	= 0xBE,	Z80_OP_DD_CP_A		= 0xBF,
	
	/* 0xC0 - 0xCF */
	Z80_OP_DD_RET_NZ	= 0xC0,	Z80_OP_DD_POP_BC	= 0xC1,
	Z80_OP_DD_JP_NZ_NN	= 0xC2,	Z80_OP_DD_JP_NN		= 0xC3,
	Z80_OP_DD_CALL_NZ_NN	= 0xC4,	Z80_OP_DD_PUSH_BC	= 0xC5,
	Z80_OP_DD_ADD_A_N	= 0xC6,	Z80_OP_DD_RST_00h	= 0xC7,
	Z80_OP_DD_RET_Z		= 0xC8,	Z80_OP_DD_RET		= 0xC9,
	Z80_OP_DD_JP_Z_NN	= 0xCA,	Z80_PREFIX_CB		= 0xCB,
	Z80_OP_DD_CALL_Z_NN	= 0xCC,	Z80_OP_DD_CALL_NN	= 0xCD,
	Z80_OP_DD_ADC_A_N	= 0xCE,	Z80_OP_DD_RST_08h	= 0xCF,
	
	/* 0xD0 - 0xDF */
	Z80_OP_DD_RET_NC	= 0xD0,	Z80_OP_DD_POP_DE	= 0xD1,
	Z80_OP_DD_JP_NC_NN	= 0xD2,	Z80_OP_DD_OUT_mN	= 0xD3,
	Z80_OP_DD_CALL_NC_NN	= 0xD4,	Z80_OP_DD_PUSH_DE	= 0xD5,
	Z80_OP_DD_SUB_N		= 0xD6,	Z80_OP_DD_RST_10h	= 0xD7,
	Z80_OP_DD_RET_C		= 0xD8,	Z80_OP_DD_EXX		= 0xD9,
	Z80_OP_DD_JP_C_NN	= 0xDA,	Z80_IN_mN		= 0xDB,
	Z80_OP_DD_CALL_C_NN	= 0xDC,	Z80_PREFIX_DD		= 0xDD,
	Z80_OP_DD_SBC_N		= 0xDE,	Z80_OP_DD_RST_18h	= 0xDF,
	
	/* 0xE0 - 0xEF */
	Z80_OP_DD_RET_NP	= 0xE0,	Z80_OP_DD_POP_IX	= 0xE1,
	Z80_OP_DD_JP_NP_NN	= 0xE2,	Z80_OP_DD_EX_mSP_IX	= 0xE3,
	Z80_OP_DD_CALL_NP_NN	= 0xE4,	Z80_OP_DD_PUSH_IX	= 0xE5,
	Z80_OP_DD_AND_N		= 0xE6,	Z80_OP_DD_RST_20h	= 0xE7,
	Z80_OP_DD_RET_P		= 0xE8,	Z80_OP_DD_JP_IX		= 0xE9,
	Z80_OP_DD_JP_P_NN	= 0xEA,	Z80_EX_DE_IX		= 0xEB,
	Z80_OP_DD_CALL_P_NN	= 0xEC,	Z80_PREFIX_ED		= 0xED,
	Z80_OP_DD_XOR_N		= 0xEE,	Z80_OP_DD_RST_28h	= 0xEF,
	
	/* 0xF0 - 0xFF */
	Z80_OP_DD_RET_NS	= 0xF0,	Z80_OP_DD_POP_AF	= 0xF1,
	Z80_OP_DD_JP_NS_NN	= 0xF2,	Z80_OP_DD_DI		= 0xF3,
	Z80_OP_DD_CALL_NS_NN	= 0xF4,	Z80_OP_DD_PUSH_AF	= 0xF5,
	Z80_OP_DD_OR_N		= 0xF6,	Z80_OP_DD_RST_30h	= 0xF7,
	Z80_OP_DD_RET_S		= 0xF8,	Z80_OP_DD_LD_SP_IX	= 0xF9,
	Z80_OP_DD_JP_S_NN	= 0xFA,	Z80_EX_EI		= 0xFB,
	Z80_OP_DD_CALL_S_NN	= 0xFC,	Z80_PREFIX_FD		= 0xFD,
	Z80_OP_DD_CP_N		= 0xFE,	Z80_OP_DD_RST_38h	= 0xFF,
};


/**
 * Z80 opcodes: 2-byte opcodes, "FD" prefix.
 */
enum mdZ80_opcode_FD
{
	/* 0x00 - 0x0F */
	Z80_OP_FD_NOP		= 0x00,	Z80_OP_FD_LD_BC_NN	= 0x01,
	Z80_OP_FD_LD_mBC_A	= 0x02,	Z80_OP_FD_INC_BC	= 0x03,
	Z80_OP_FD_INC_B		= 0x04,	Z80_OP_FD_DEC_B		= 0x05,
	Z80_OP_FD_LD_B_N	= 0x06,	Z80_OP_FD_RLCA		= 0x07,
	Z80_OP_FD_EX_AF_AF2	= 0x08,	Z80_OP_FD_ADD_IY_BC	= 0x09,
	Z80_OP_FD_LD_A_mBC	= 0x0A,	Z80_OP_FD_DEC_BC	= 0x0B,
	Z80_OP_FD_INC_C		= 0x0C,	Z80_OP_FD_DEC_C		= 0x0D,
	Z80_OP_FD_LD_C_N	= 0x0E,	Z80_OP_FD_RRCA		= 0x0F,
	
	/* 0x10 - 0x1F */
	Z80_OP_FD_DJNZ		= 0x10,	Z80_OP_FD_LD_DE_NN	= 0x11,
	Z80_OP_FD_LD_mDE_A	= 0x12,	Z80_OP_FD_INC_DE	= 0x13,
	Z80_OP_FD_INC_D		= 0x14,	Z80_OP_FD_DEC_D		= 0x15,
	Z80_OP_FD_LD_D_N	= 0x16,	Z80_OP_FD_RLA		= 0x17,
	Z80_OP_FD_JR_N		= 0x18,	Z80_OP_FD_ADD_IY_DE	= 0x19,
	Z80_OP_FD_LD_A_mDE	= 0x1A,	Z80_OP_FD_DEC_DE	= 0x1B,
	Z80_OP_FD_INC_E		= 0x1C,	Z80_OP_FD_DEC_E		= 0x1D,
	Z80_OP_FD_LD_E_N	= 0x1E,	Z80_OP_FD_RRA		= 0x1F,
	
	/* 0x20 - 0x2F */
	Z80_OP_FD_JRNZ_N	= 0x20,	Z80_OP_FD_LD_IY_NN	= 0x21,
	Z80_OP_FD_LD_mNN_IY	= 0x22,	Z80_OP_FD_INC_IY	= 0x23,
	Z80_OP_FD_INC_hIY	= 0x24,	Z80_OP_FD_DEC_hIY	= 0x25,
	Z80_OP_FD_LD_hIY_N	= 0x26,	Z80_OP_FD_DAA		= 0x27,
	Z80_OP_FD_JRZ_N		= 0x28,	Z80_OP_FD_ADD_IY_IY	= 0x29,
	Z80_OP_FD_LD_IY_mNN	= 0x2A,	Z80_OP_FD_DEC_IY	= 0x2B,
	Z80_OP_FD_INC_lIY	= 0x2C,	Z80_OP_FD_DEC_lIY	= 0x2D,
	Z80_OP_FD_LD_lIY_N	= 0x2E,	Z80_OP_FD_CPL		= 0x2F,
	
	/* 0x30 - 0x3F */
	Z80_OP_FD_JRNC_N	= 0x30,	Z80_OP_FD_LD_SP_NN	= 0x31,
	Z80_OP_FD_LD_mNN_A	= 0x32,	Z80_OP_FD_INC_SP	= 0x33,
	Z80_OP_FD_INC_mIYd	= 0x34,	Z80_OP_FD_DEC_mIYd	= 0x35,
	Z80_OP_FD_LD_mIYd_N	= 0x36,	Z80_OP_FD_SCF		= 0x37,
	Z80_OP_FD_JRC_N		= 0x38,	Z80_OP_FD_ADD_IY_SP	= 0x39,
	Z80_OP_FD_LD_A_mNN	= 0x3A,	Z80_OP_FD_DEC_SP	= 0x3B,
	Z80_OP_FD_INC_A		= 0x3C,	Z80_OP_FD_DEC_A		= 0x3D,
	Z80_OP_FD_LD_A_N	= 0x3E,	Z80_OP_FD_CCF		= 0x3F,
	
	/* 0x40 - 0x4F */
	Z80_OP_FD_LD_B_B	= 0x40,	Z80_OP_FD_LD_B_C	= 0x41,
	Z80_OP_FD_LD_B_D	= 0x42,	Z80_OP_FD_LD_B_E	= 0x43,
	Z80_OP_FD_LD_B_hIY	= 0x44,	Z80_OP_FD_LD_B_lIY	= 0x45,
	Z80_OP_FD_LD_B_mIYd	= 0x46,	Z80_OP_FD_LD_B_A	= 0x47,
	Z80_OP_FD_LD_C_B	= 0x48,	Z80_OP_FD_LD_C_C	= 0x49,
	Z80_OP_FD_LD_C_D	= 0x4A,	Z80_OP_FD_LD_C_E	= 0x4B,
	Z80_OP_FD_LD_C_hIY	= 0x4C,	Z80_OP_FD_LD_C_lIY	= 0x4D,
	Z80_OP_FD_LD_C_mIYd	= 0x4E,	Z80_OP_FD_LD_C_A	= 0x4F,
	
	/* 0x50 - 0x5F */
	Z80_OP_FD_LD_D_B	= 0x50,	Z80_OP_FD_LD_D_C	= 0x51,
	Z80_OP_FD_LD_D_D	= 0x52,	Z80_OP_FD_LD_D_E	= 0x53,
	Z80_OP_FD_LD_D_hIY	= 0x54,	Z80_OP_FD_LD_D_lIY	= 0x55,
	Z80_OP_FD_LD_D_mIYd	= 0x56,	Z80_OP_FD_LD_D_A	= 0x57,
	Z80_OP_FD_LD_E_B	= 0x58,	Z80_OP_FD_LD_E_C	= 0x59,
	Z80_OP_FD_LD_E_D	= 0x5A,	Z80_OP_FD_LD_E_E	= 0x5B,
	Z80_OP_FD_LD_E_hIY	= 0x5C,	Z80_OP_FD_LD_E_lIY	= 0x5D,
	Z80_OP_FD_LD_E_mIYd	= 0x5E,	Z80_OP_FD_LD_E_A	= 0x5F,
	
	/* 0x60 - 0x6F */
	Z80_OP_FD_LD_hIY_B	= 0x60,	Z80_OP_FD_LD_hIY_C	= 0x61,
	Z80_OP_FD_LD_hIY_D	= 0x62,	Z80_OP_FD_LD_hIY_E	= 0x63,
	Z80_OP_FD_LD_hIY_hIY	= 0x64,	Z80_OP_FD_LD_hIY_lIY	= 0x65,
	Z80_OP_FD_LD_hIY_mIYd	= 0x66,	Z80_OP_FD_LD_hIY_A	= 0x67,
	Z80_OP_FD_LD_lIY_B	= 0x68,	Z80_OP_FD_LD_lIY_C	= 0x69,
	Z80_OP_FD_LD_lIY_D	= 0x6A,	Z80_OP_FD_LD_lIY_E	= 0x6B,
	Z80_OP_FD_LD_lIY_hIY	= 0x6C,	Z80_OP_FD_LD_lIY_lIY	= 0x6D,
	Z80_OP_FD_LD_lIY_mIYd	= 0x6E,	Z80_OP_FD_LD_lIY_A	= 0x6F,
	
	/* 0x70 - 0x7F */
	Z80_OP_FD_LD_mIYd_B	= 0x70,	Z80_OP_FD_LD_mIYd_C	= 0x71,
	Z80_OP_FD_LD_mIYd_D	= 0x72,	Z80_OP_FD_LD_mIYd_E	= 0x73,
	Z80_OP_FD_LD_mIYd_hIY	= 0x74,	Z80_OP_FD_LD_mIYd_lIY	= 0x75,
	Z80_OP_FD_LD_mIYd_mIYd	= 0x76,	Z80_OP_FD_LD_mIYd_A	= 0x77,
	Z80_OP_FD_LD_A_B	= 0x78,	Z80_OP_FD_LD_A_C	= 0x79,
	Z80_OP_FD_LD_A_D	= 0x7A,	Z80_OP_FD_LD_A_E	= 0x7B,
	Z80_OP_FD_LD_A_hIY	= 0x7C,	Z80_OP_FD_LD_A_lIY	= 0x7D,
	Z80_OP_FD_LD_A_mIYd	= 0x7E,	Z80_OP_FD_LD_A_A	= 0x7F,
	
	/* 0x80 - 0x8F */
	Z80_OP_FD_ADD_A_B	= 0x80,	Z80_OP_FD_ADD_A_C	= 0x81,
	Z80_OP_FD_ADD_A_D	= 0x82,	Z80_OP_FD_ADD_A_E	= 0x83,
	Z80_OP_FD_ADD_A_hIY	= 0x84,	Z80_OP_FD_ADD_A_lIY	= 0x85,
	Z80_OP_FD_ADD_A_mIYd	= 0x86,	Z80_OP_FD_ADD_A_A	= 0x87,
	Z80_OP_FD_ADC_A_B	= 0x88,	Z80_OP_FD_ADC_A_C	= 0x89,
	Z80_OP_FD_ADC_A_D	= 0x8A,	Z80_OP_FD_ADC_A_E	= 0x8B,
	Z80_OP_FD_ADC_A_hIY	= 0x8C,	Z80_OP_FD_ADC_A_lIY	= 0x8D,
	Z80_OP_FD_ADC_A_mIYd	= 0x8E,	Z80_OP_FD_ADC_A_A	= 0x8F,
	
	/* 0x90 - 0x9F */
	Z80_OP_FD_SUB_B		= 0x90,	Z80_OP_FD_SUB_C		= 0x91,
	Z80_OP_FD_SUB_D		= 0x92,	Z80_OP_FD_SUB_E		= 0x93,
	Z80_OP_FD_SUB_hIY	= 0x94,	Z80_OP_FD_SUB_lIY	= 0x95,
	Z80_OP_FD_SUB_mIYd	= 0x96,	Z80_OP_FD_SUB_A		= 0x97,
	Z80_OP_FD_SBC_B		= 0x98,	Z80_OP_FD_SBC_C		= 0x99,
	Z80_OP_FD_SBC_D		= 0x9A,	Z80_OP_FD_SBC_E		= 0x9B,
	Z80_OP_FD_SBC_hIY	= 0x9C,	Z80_OP_FD_SBC_lIY	= 0x9D,
	Z80_OP_FD_SBC_mIYd	= 0x9E,	Z80_OP_FD_SBC_A		= 0x9F,
	
	/* 0xA0 - 0xAF */
	Z80_OP_FD_AND_B		= 0xA0,	Z80_OP_FD_AND_C		= 0xA1,
	Z80_OP_FD_AND_D		= 0xA2,	Z80_OP_FD_AND_E		= 0xA3,
	Z80_OP_FD_AND_hIY	= 0xA4,	Z80_OP_FD_AND_lIY	= 0xA5,
	Z80_OP_FD_AND_mIYd	= 0xA6,	Z80_OP_FD_AND_A		= 0xA7,
	Z80_OP_FD_XOR_B		= 0xA8,	Z80_OP_FD_XOR_C		= 0xA9,
	Z80_OP_FD_XOR_D		= 0xAA,	Z80_OP_FD_XOR_E		= 0xAB,
	Z80_OP_FD_XOR_hIY	= 0xAC,	Z80_OP_FD_XOR_lIY	= 0xAD,
	Z80_OP_FD_XOR_mIYd	= 0xAE,	Z80_OP_FD_XOR_A		= 0xAF,
	
	/* 0xB0 - 0xBF */
	Z80_OP_FD_OR_B		= 0xB0,	Z80_OP_FD_OR_C		= 0xB1,
	Z80_OP_FD_OR_D		= 0xB2,	Z80_OP_FD_OR_E		= 0xB3,
	Z80_OP_FD_OR_hIY	= 0xB4,	Z80_OP_FD_OR_lIY	= 0xB5,
	Z80_OP_FD_OR_mIYd	= 0xB6,	Z80_OP_FD_OR_A		= 0xB7,
	Z80_OP_FD_CP_B		= 0xB8,	Z80_OP_FD_CP_C		= 0xB9,
	Z80_OP_FD_CP_D		= 0xBA,	Z80_OP_FD_CP_E		= 0xBB,
	Z80_OP_FD_CP_hIY	= 0xBC,	Z80_OP_FD_CP_lIY	= 0xBD,
	Z80_OP_FD_CP_mIYd	= 0xBE,	Z80_OP_FD_CP_A		= 0xBF,
	
	/* 0xC0 - 0xCF */
	Z80_OP_FD_RET_NZ	= 0xC0,	Z80_OP_FD_POP_BC	= 0xC1,
	Z80_OP_FD_JP_NZ_NN	= 0xC2,	Z80_OP_FD_JP_NN		= 0xC3,
	Z80_OP_FD_CALL_NZ_NN	= 0xC4,	Z80_OP_FD_PUSH_BC	= 0xC5,
	Z80_OP_FD_ADD_A_N	= 0xC6,	Z80_OP_FD_RST_00h	= 0xC7,
	Z80_OP_FD_RET_Z		= 0xC8,	Z80_OP_FD_RET		= 0xC9,
	Z80_OP_FD_JP_Z_NN	= 0xCA,	Z80_PREFIY_CB		= 0xCB,
	Z80_OP_FD_CALL_Z_NN	= 0xCC,	Z80_OP_FD_CALL_NN	= 0xCD,
	Z80_OP_FD_ADC_A_N	= 0xCE,	Z80_OP_FD_RST_08h	= 0xCF,
	
	/* 0xD0 - 0xDF */
	Z80_OP_FD_RET_NC	= 0xD0,	Z80_OP_FD_POP_DE	= 0xD1,
	Z80_OP_FD_JP_NC_NN	= 0xD2,	Z80_OP_FD_OUT_mN	= 0xD3,
	Z80_OP_FD_CALL_NC_NN	= 0xD4,	Z80_OP_FD_PUSH_DE	= 0xD5,
	Z80_OP_FD_SUB_N		= 0xD6,	Z80_OP_FD_RST_10h	= 0xD7,
	Z80_OP_FD_RET_C		= 0xD8,	Z80_OP_FD_EXX		= 0xD9,
	Z80_OP_FD_JP_C_NN	= 0xDA,	Z80_IN_mN		= 0xDB,
	Z80_OP_FD_CALL_C_NN	= 0xDC,	Z80_PREFIY_DD		= 0xDD,
	Z80_OP_FD_SBC_N		= 0xDE,	Z80_OP_FD_RST_18h	= 0xDF,
	
	/* 0xE0 - 0xEF */
	Z80_OP_FD_RET_NP	= 0xE0,	Z80_OP_FD_POP_IY	= 0xE1,
	Z80_OP_FD_JP_NP_NN	= 0xE2,	Z80_OP_FD_EX_mSP_IY	= 0xE3,
	Z80_OP_FD_CALL_NP_NN	= 0xE4,	Z80_OP_FD_PUSH_IY	= 0xE5,
	Z80_OP_FD_AND_N		= 0xE6,	Z80_OP_FD_RST_20h	= 0xE7,
	Z80_OP_FD_RET_P		= 0xE8,	Z80_OP_FD_JP_IY		= 0xE9,
	Z80_OP_FD_JP_P_NN	= 0xEA,	Z80_EX_DE_IY		= 0xEB,
	Z80_OP_FD_CALL_P_NN	= 0xEC,	Z80_PREFIY_ED		= 0xED,
	Z80_OP_FD_XOR_N		= 0xEE,	Z80_OP_FD_RST_28h	= 0xEF,
	
	/* 0xF0 - 0xFF */
	Z80_OP_FD_RET_NS	= 0xF0,	Z80_OP_FD_POP_AF	= 0xF1,
	Z80_OP_FD_JP_NS_NN	= 0xF2,	Z80_OP_FD_DI		= 0xF3,
	Z80_OP_FD_CALL_NS_NN	= 0xF4,	Z80_OP_FD_PUSH_AF	= 0xF5,
	Z80_OP_FD_OR_N		= 0xF6,	Z80_OP_FD_RST_30h	= 0xF7,
	Z80_OP_FD_RET_S		= 0xF8,	Z80_OP_FD_LD_SP_IY	= 0xF9,
	Z80_OP_FD_JP_S_NN	= 0xFA,	Z80_EX_EI		= 0xFB,
	Z80_OP_FD_CALL_S_NN	= 0xFC,	Z80_PREFIY_FD		= 0xFD,
	Z80_OP_FD_CP_N		= 0xFE,	Z80_OP_FD_RST_38h	= 0xFF,
};


/**
 * Z80 opcodes: 2-byte opcodes, "ED" prefix.
 */
enum mdZ80_opcode_ED
{
	/* 0x00 - 0x3F are all NOP. */
	
	/* 0x40 - 0x4F */
	Z80_OP_ED_IN_B_mBC	= 0x40,	Z80_OP_ED_OUT_mBC_B	= 0x41,
	Z80_OP_ED_SBC_HL_BC	= 0x42,	Z80_OP_ED_LD_mNN_BC	= 0x43,
	Z80_OP_ED_NEG		= 0x44,	Z80_OP_ED_RETN		= 0x45,
	Z80_OP_ED_IM_0		= 0x46,	Z80_OP_LD_I_A		= 0x47,
	Z80_OP_ED_IN_C_mBC	= 0x48,	Z80_OP_ED_OUT_mBC_C	= 0x49,
	Z80_OP_ED_ADC_HL_BC	= 0x4A,	Z80_OP_ED_LD_BC_mNN	= 0x4B,
	Z80_OP_ED_NEG_4Ch	= 0x4C,	Z80_OP_ED_RETI		= 0x4D,
	Z80_OP_ED_IM_0_4Eh	= 0x4E,	Z80_OP_ED_LD_R_A	= 0x4F,
	
	/* 0x50 - 0x5F */
	Z80_OP_ED_IN_D_mBC	= 0x50,	Z80_OP_ED_OUT_mBC_D	= 0x51,
	Z80_OP_ED_SBC_HL_DE	= 0x52,	Z80_OP_ED_LD_mNN_DE	= 0x53,
	Z80_OP_ED_NEG_54h	= 0x54,	Z80_OP_ED_RETN_55h	= 0x55,
	Z80_OP_ED_IM_1		= 0x56,	Z80_OP_ED_LD_A_I	= 0x57,
	Z80_OP_ED_IN_E_mBC	= 0x58,	Z80_OP_ED_OUT_mBC_E	= 0x59,
	Z80_OP_ED_ADC_HL_DE	= 0x5A,	Z80_OP_ED_LD_DE_mNN	= 0x5B,
	Z80_OP_ED_NEG_5Ch	= 0x5C,	Z80_OP_ED_RETN_5Dh	= 0x5D,
	Z80_OP_ED_IM_2		= 0x5E,	Z80_OP_ED_LD_A_R	= 0x5F,
	
	/* 0x60 - 0x6F */
	Z80_OP_ED_IN_H_mBC	= 0x60,	Z80_OP_ED_OUT_mBC_H	= 0x61,
	Z80_OP_ED_SBC_HL_HL	= 0x62,	Z80_OP_ED_LD_mNN_HL	= 0x63,
	Z80_OP_ED_NEG_64h	= 0x64,	Z80_OP_ED_RETN_65h	= 0x65,
	Z80_OP_ED_IM_0_66h	= 0x66,	Z80_OP_ED_RRD		= 0x67,
	Z80_OP_ED_IN_L_mBC	= 0x68,	Z80_OP_ED_OUT_mBC_L	= 0x69,
	Z80_OP_ED_ADC_HL_HL	= 0x6A,	Z80_OP_ED_LD_HL_mNN	= 0x6B,
	Z80_OP_ED_NEG_6Ch	= 0x6C,	Z80_OP_ED_RETN_6Dh	= 0x6D,
	Z80_OP_ED_IM_0_6Eh	= 0x6E,	Z80_OP_ED_RLF		= 0x6F,
	
	/* 0x70 - 0x7F */
	Z80_OP_ED_IN_F_mBC	= 0x70,	Z80_OP_ED_OUT_mBC_0	= 0x71,
	Z80_OP_ED_SBC_HL_SP	= 0x72,	Z80_OP_ED_LD_mNN_SP	= 0x73,
	Z80_OP_ED_NEG_74h	= 0x74,	Z80_OP_ED_RETN_75h	= 0x75,
	Z80_OP_ED_IM_1_76h	= 0x76,	Z80_OP_ED_NOP_77h	= 0x77,
	Z80_OP_ED_IN_A_mBC	= 0x78,	Z80_OP_ED_OUT_mBC_A	= 0x79,
	Z80_OP_ED_ADC_HL_SP	= 0x7A,	Z80_OP_ED_LD_SP_mNN	= 0x7B,
	Z80_OP_ED_NEG_7Ch	= 0x7C,	Z80_OP_ED_RETN_7Dh	= 0x7D,
	Z80_OP_ED_IM_2_7Eh	= 0x7E,	Z80_OP_ED_NOP_7Fh	= 0x7F,
	
	/* 0x80 - 0x9F are all NOP. */
	
	/* 0xA0 - 0xA3 */
	Z80_OP_ED_LDI		= 0xA0,	Z80_OP_ED_CPI		= 0xA1,
	Z80_OP_ED_INI		= 0xA2,	Z80_OP_ED_OUTI		= 0xA3,
	
	/* 0xA4 - 0xA7 are all NOP. */
	
	/* 0xA8 - 0xAB */
	Z80_OP_ED_LDD		= 0xA8,	Z80_OP_ED_CPD		= 0xA9,
	Z80_OP_ED_IND		= 0xAA,	Z80_OP_ED_OUTD		= 0xAB,
	
	/* 0xAC - 0xAF are all NOP. */
	
	/* 0xB0 - 0xB3 */
	Z80_OP_ED_LDIR		= 0xB0,	Z80_OP_ED_CPIR		= 0xB1,
	Z80_OP_ED_INIR		= 0xB2,	Z80_OP_ED_OTIR		= 0xB3,
	
	/* 0xB4 - 0xB7 are all NOP. */
	
	/* 0xB8 - 0xBB */
	Z80_OP_ED_LDDR		= 0xB8,	Z80_OP_ED_CPDR		= 0xB9,
	Z80_OP_ED_INDR		= 0xBA,	Z80_OP_ED_OTDR		= 0xBB,
	
	/* 0xBC - 0xFF are all NOP. */
};


/**
 * Z80 opcodes: 3-byte opcodes, "DDCB" prefix.
 */
enum mdZ80_opcode_DDCB
{
	/* 0x00 - 0x0F */
	Z80_OP_DDCB_RLC_mIXd_B		= 0x00,	Z80_OP_DDCB_RLC_mIXd_C		= 0x01,
	Z80_OP_DDCB_RLC_mIXd_D		= 0x02,	Z80_OP_DDCB_RLC_mIXd_E		= 0x03,
	Z80_OP_DDCB_RLC_mIXd_H		= 0x04,	Z80_OP_DDCB_RLC_mIXd_L		= 0x05,
	Z80_OP_DDCB_RLC_mIXd		= 0x06,	Z80_OP_DDCB_RLC_mIXd_A		= 0x07,
	Z80_OP_DDCB_RRC_mIXd_B		= 0x08,	Z80_OP_DDCB_RRC_mIXd_C		= 0x09,
	Z80_OP_DDCB_RRC_mIXd_D		= 0x0A,	Z80_OP_DDCB_RRC_mIXd_E		= 0x0B,
	Z80_OP_DDCB_RRC_mIXd_H		= 0x0C,	Z80_OP_DDCB_RRC_mIXd_L		= 0x0D,
	Z80_OP_DDCB_RRC_mIXd		= 0x0E,	Z80_OP_DDCB_RRC_mIXd_A		= 0x0F,
	
	/* 0x10 - 0x1F */
	Z80_OP_DDCB_RL_mIXd_B		= 0x10,	Z80_OP_DDCB_RL_mIXd_C		= 0x11,
	Z80_OP_DDCB_RL_mIXd_D		= 0x12,	Z80_OP_DDCB_RL_mIXd_E		= 0x13,
	Z80_OP_DDCB_RL_mIXd_H		= 0x14,	Z80_OP_DDCB_RL_mIXd_L		= 0x15,
	Z80_OP_DDCB_RL_mIXd		= 0x16,	Z80_OP_DDCB_RL_mIXd_A		= 0x17,
	Z80_OP_DDCB_RR_mIXd_B		= 0x18,	Z80_OP_DDCB_RR_mIXd_C		= 0x19,
	Z80_OP_DDCB_RR_mIXd_D		= 0x1A,	Z80_OP_DDCB_RR_mIXd_E		= 0x1B,
	Z80_OP_DDCB_RR_mIXd_H		= 0x1C,	Z80_OP_DDCB_RR_mIXd_L		= 0x1D,
	Z80_OP_DDCB_RR_mIXd		= 0x1E,	Z80_OP_DDCB_RR_mIXd_A		= 0x1F,
	
	/* 0x20 - 0x2F */
	Z80_OP_DDCB_SLA_mIXd_B		= 0x20,	Z80_OP_DDCB_SLA_mIXd_C		= 0x21,
	Z80_OP_DDCB_SLA_mIXd_D		= 0x22,	Z80_OP_DDCB_SLA_mIXd_E		= 0x23,
	Z80_OP_DDCB_SLA_mIXd_H		= 0x24,	Z80_OP_DDCB_SLA_mIXd_L		= 0x25,
	Z80_OP_DDCB_SLA_mIXd		= 0x26,	Z80_OP_DDCB_SLA_mIXd_A		= 0x27,
	Z80_OP_DDCB_SRA_mIXd_B		= 0x28,	Z80_OP_DDCB_SRA_mIXd_C		= 0x29,
	Z80_OP_DDCB_SRA_mIXd_D		= 0x2A,	Z80_OP_DDCB_SRA_mIXd_E		= 0x2B,
	Z80_OP_DDCB_SRA_mIXd_H		= 0x2C,	Z80_OP_DDCB_SRA_mIXd_L		= 0x2D,
	Z80_OP_DDCB_SRA_mIXd		= 0x2E,	Z80_OP_DDCB_SRA_mIXd_A		= 0x2F,
	
	/* 0x30 - 0x3F */
	Z80_OP_DDCB_SLL_mIXd_B		= 0x30,	Z80_OP_DDCB_SLL_mIXd_C		= 0x31,
	Z80_OP_DDCB_SLL_mIXd_D		= 0x32,	Z80_OP_DDCB_SLL_mIXd_E		= 0x33,
	Z80_OP_DDCB_SLL_mIXd_H		= 0x34,	Z80_OP_DDCB_SLL_mIXd_L		= 0x35,
	Z80_OP_DDCB_SLL_mIXd		= 0x36,	Z80_OP_DDCB_SLL_mIXd_A		= 0x37,
	Z80_OP_DDCB_SRL_mIXd_B		= 0x38,	Z80_OP_DDCB_SRL_mIXd_C		= 0x39,
	Z80_OP_DDCB_SRL_mIXd_D		= 0x3A,	Z80_OP_DDCB_SRL_mIXd_E		= 0x3B,
	Z80_OP_DDCB_SRL_mIXd_H		= 0x3C,	Z80_OP_DDCB_SRL_mIXd_L		= 0x3D,
	Z80_OP_DDCB_SRL_mIXd		= 0x3E,	Z80_OP_DDCB_SRL_mIXd_A		= 0x3F,
	
	/* 0x40 - 0x4F */
	Z80_OP_DDCB_BIT_0_B		= 0x40,	Z80_OP_DDCB_BIT_0_C		= 0x41,
	Z80_OP_DDCB_BIT_0_D		= 0x42,	Z80_OP_DDCB_BIT_0_E		= 0x43,
	Z80_OP_DDCB_BIT_0_H		= 0x44,	Z80_OP_DDCB_BIT_0_L		= 0x45,
	Z80_OP_DDCB_BIT_0_mIXd		= 0x46,	Z80_OP_DDCB_BIT_0_A		= 0x47,
	Z80_OP_DDCB_BIT_1_B		= 0x48,	Z80_OP_DDCB_BIT_1_C		= 0x49,
	Z80_OP_DDCB_BIT_1_D		= 0x4A,	Z80_OP_DDCB_BIT_1_E		= 0x4B,
	Z80_OP_DDCB_BIT_1_H		= 0x4C,	Z80_OP_DDCB_BIT_1_L		= 0x4D,
	Z80_OP_DDCB_BIT_1_mIXd		= 0x4E,	Z80_OP_DDCB_BIT_1_A		= 0x4F,
	
	/* 0x50 - 0x5F */
	Z80_OP_DDCB_BIT_2_B		= 0x50,	Z80_OP_DDCB_BIT_2_C		= 0x51,
	Z80_OP_DDCB_BIT_2_D		= 0x52,	Z80_OP_DDCB_BIT_2_E		= 0x53,
	Z80_OP_DDCB_BIT_2_H		= 0x54,	Z80_OP_DDCB_BIT_2_L		= 0x55,
	Z80_OP_DDCB_BIT_2_mIXd		= 0x56,	Z80_OP_DDCB_BIT_2_A		= 0x57,
	Z80_OP_DDCB_BIT_3_B		= 0x58,	Z80_OP_DDCB_BIT_3_C		= 0x59,
	Z80_OP_DDCB_BIT_3_D		= 0x5A,	Z80_OP_DDCB_BIT_3_E		= 0x5B,
	Z80_OP_DDCB_BIT_3_H		= 0x5C,	Z80_OP_DDCB_BIT_3_L		= 0x5D,
	Z80_OP_DDCB_BIT_3_mIXd		= 0x5E,	Z80_OP_DDCB_BIT_3_A		= 0x5F,
	
	/* 0x60 - 0x6F */
	Z80_OP_DDCB_BIT_4_B		= 0x60,	Z80_OP_DDCB_BIT_4_C		= 0x61,
	Z80_OP_DDCB_BIT_4_D		= 0x62,	Z80_OP_DDCB_BIT_4_E		= 0x63,
	Z80_OP_DDCB_BIT_4_H		= 0x64,	Z80_OP_DDCB_BIT_4_L		= 0x65,
	Z80_OP_DDCB_BIT_4_mIXd		= 0x66,	Z80_OP_DDCB_BIT_4_A		= 0x67,
	Z80_OP_DDCB_BIT_5_B		= 0x68,	Z80_OP_DDCB_BIT_5_C		= 0x69,
	Z80_OP_DDCB_BIT_5_D		= 0x6A,	Z80_OP_DDCB_BIT_5_E		= 0x6B,
	Z80_OP_DDCB_BIT_5_H		= 0x6C,	Z80_OP_DDCB_BIT_5_L		= 0x6D,
	Z80_OP_DDCB_BIT_5_mIXd		= 0x6E,	Z80_OP_DDCB_BIT_5_A		= 0x6F,
	
	/* 0x70 - 0x7F */
	Z80_OP_DDCB_BIT_6_B		= 0x70,	Z80_OP_DDCB_BIT_6_C		= 0x71,
	Z80_OP_DDCB_BIT_6_D		= 0x72,	Z80_OP_DDCB_BIT_6_E		= 0x73,
	Z80_OP_DDCB_BIT_6_H		= 0x74,	Z80_OP_DDCB_BIT_6_L		= 0x75,
	Z80_OP_DDCB_BIT_6_mIXd		= 0x76,	Z80_OP_DDCB_BIT_6_A		= 0x77,
	Z80_OP_DDCB_BIT_7_B		= 0x78,	Z80_OP_DDCB_BIT_7_C		= 0x79,
	Z80_OP_DDCB_BIT_7_D		= 0x7A,	Z80_OP_DDCB_BIT_7_E		= 0x7B,
	Z80_OP_DDCB_BIT_7_H		= 0x7C,	Z80_OP_DDCB_BIT_7_L		= 0x7D,
	Z80_OP_DDCB_BIT_7_mIXd		= 0x7E,	Z80_OP_DDCB_BIT_7_A		= 0x7F,
	
	/* 0x80 - 0x8F */
	Z80_OP_DDCB_RES_0_mIXd_B	= 0x80,	Z80_OP_DDCB_RES_0_mIXd_C	= 0x81,
	Z80_OP_DDCB_RES_0_mIXd_D	= 0x82,	Z80_OP_DDCB_RES_0_mIXd_E	= 0x83,
	Z80_OP_DDCB_RES_0_mIXd_H	= 0x84,	Z80_OP_DDCB_RES_0_mIXd_L	= 0x85,
	Z80_OP_DDCB_RES_0_mIXd		= 0x86,	Z80_OP_DDCB_RES_0_mIXd_A	= 0x87,
	Z80_OP_DDCB_RES_1_mIXd_B	= 0x88,	Z80_OP_DDCB_RES_1_mIXd_C	= 0x89,
	Z80_OP_DDCB_RES_1_mIXd_D	= 0x8A,	Z80_OP_DDCB_RES_1_mIXd_E	= 0x8B,
	Z80_OP_DDCB_RES_1_mIXd_H	= 0x8C,	Z80_OP_DDCB_RES_1_mIXd_L	= 0x8D,
	Z80_OP_DDCB_RES_1_mIXd		= 0x8E,	Z80_OP_DDCB_RES_1_mIXd_A	= 0x8F,
	
	/* 0x90 - 0x9F */
	Z80_OP_DDCB_RES_2_mIXd_B	= 0x90,	Z80_OP_DDCB_RES_2_mIXd_C	= 0x91,
	Z80_OP_DDCB_RES_2_mIXd_D	= 0x92,	Z80_OP_DDCB_RES_2_mIXd_E	= 0x93,
	Z80_OP_DDCB_RES_2_mIXd_H	= 0x94,	Z80_OP_DDCB_RES_2_mIXd_L	= 0x95,
	Z80_OP_DDCB_RES_2_mIXd		= 0x96,	Z80_OP_DDCB_RES_2_mIXd_A	= 0x97,
	Z80_OP_DDCB_RES_3_mIXd_B	= 0x98,	Z80_OP_DDCB_RES_3_mIXd_C	= 0x99,
	Z80_OP_DDCB_RES_3_mIXd_D	= 0x9A,	Z80_OP_DDCB_RES_3_mIXd_E	= 0x9B,
	Z80_OP_DDCB_RES_3_mIXd_H	= 0x9C,	Z80_OP_DDCB_RES_3_mIXd_L	= 0x9D,
	Z80_OP_DDCB_RES_3_mIXd		= 0x9E,	Z80_OP_DDCB_RES_3_mIXd_A	= 0x9F,
	
	/* 0xA0 - 0xAF */
	Z80_OP_DDCB_RES_4_mIXd_B	= 0xA0,	Z80_OP_DDCB_RES_4_mIXd_C	= 0xA1,
	Z80_OP_DDCB_RES_4_mIXd_D	= 0xA2,	Z80_OP_DDCB_RES_4_mIXd_E	= 0xA3,
	Z80_OP_DDCB_RES_4_mIXd_H	= 0xA4,	Z80_OP_DDCB_RES_4_mIXd_L	= 0xA5,
	Z80_OP_DDCB_RES_4_mIXd		= 0xA6,	Z80_OP_DDCB_RES_4_mIXd_A	= 0xA7,
	Z80_OP_DDCB_RES_5_mIXd_B	= 0xA8,	Z80_OP_DDCB_RES_5_mIXd_C	= 0xA9,
	Z80_OP_DDCB_RES_5_mIXd_D	= 0xAA,	Z80_OP_DDCB_RES_5_mIXd_E	= 0xAB,
	Z80_OP_DDCB_RES_5_mIXd_H	= 0xAC,	Z80_OP_DDCB_RES_5_mIXd_L	= 0xAD,
	Z80_OP_DDCB_RES_5_mIXd		= 0xAE,	Z80_OP_DDCB_RES_5_mIXd_A	= 0xAF,
	
	/* 0xB0 - 0xBF */
	Z80_OP_DDCB_RES_6_mIXd_B	= 0xB0,	Z80_OP_DDCB_RES_6_mIXd_C	= 0xB1,
	Z80_OP_DDCB_RES_6_mIXd_D	= 0xB2,	Z80_OP_DDCB_RES_6_mIXd_E	= 0xB3,
	Z80_OP_DDCB_RES_6_mIXd_H	= 0xB4,	Z80_OP_DDCB_RES_6_mIXd_L	= 0xB5,
	Z80_OP_DDCB_RES_6_mIXd		= 0xB6,	Z80_OP_DDCB_RES_6_mIXd_A	= 0xB7,
	Z80_OP_DDCB_RES_7_mIXd_B	= 0xB8,	Z80_OP_DDCB_RES_7_mIXd_C	= 0xB9,
	Z80_OP_DDCB_RES_7_mIXd_D	= 0xBA,	Z80_OP_DDCB_RES_7_mIXd_E	= 0xBB,
	Z80_OP_DDCB_RES_7_mIXd_H	= 0xBC,	Z80_OP_DDCB_RES_7_mIXd_L	= 0xBD,
	Z80_OP_DDCB_RES_7_mIXd		= 0xBE,	Z80_OP_DDCB_RES_7_mIXd_A	= 0xBF,
	
	/* 0xC0 - 0xCF */
	Z80_OP_DDCB_SET_0_mIXd_B	= 0xC0,	Z80_OP_DDCB_SET_0_mIXd_C	= 0xC1,
	Z80_OP_DDCB_SET_0_mIXd_D	= 0xC2,	Z80_OP_DDCB_SET_0_mIXd_E	= 0xC3,
	Z80_OP_DDCB_SET_0_mIXd_H	= 0xC4,	Z80_OP_DDCB_SET_0_mIXd_L	= 0xC5,
	Z80_OP_DDCB_SET_0_mIXd		= 0xC6,	Z80_OP_DDCB_SET_0_mIXd_A	= 0xC7,
	Z80_OP_DDCB_SET_1_mIXd_B	= 0xC8,	Z80_OP_DDCB_SET_1_mIXd_C	= 0xC9,
	Z80_OP_DDCB_SET_1_mIXd_D	= 0xCA,	Z80_OP_DDCB_SET_1_mIXd_E	= 0xCB,
	Z80_OP_DDCB_SET_1_mIXd_H	= 0xCC,	Z80_OP_DDCB_SET_1_mIXd_L	= 0xCD,
	Z80_OP_DDCB_SET_1_mIXd		= 0xCE,	Z80_OP_DDCB_SET_1_mIXd_A	= 0xCF,
	
	/* 0xD0 - 0xDF */
	Z80_OP_DDCB_SET_2_mIXd_B	= 0xD0,	Z80_OP_DDCB_SET_2_mIXd_C	= 0xD1,
	Z80_OP_DDCB_SET_2_mIXd_D	= 0xD2,	Z80_OP_DDCB_SET_2_mIXd_E	= 0xD3,
	Z80_OP_DDCB_SET_2_mIXd_H	= 0xD4,	Z80_OP_DDCB_SET_2_mIXd_L	= 0xD5,
	Z80_OP_DDCB_SET_2_mIXd		= 0xD6,	Z80_OP_DDCB_SET_2_mIXd_A	= 0xD7,
	Z80_OP_DDCB_SET_3_mIXd_B	= 0xD8,	Z80_OP_DDCB_SET_3_mIXd_C	= 0xD9,
	Z80_OP_DDCB_SET_3_mIXd_D	= 0xDA,	Z80_OP_DDCB_SET_3_mIXd_E	= 0xDB,
	Z80_OP_DDCB_SET_3_mIXd_H	= 0xDC,	Z80_OP_DDCB_SET_3_mIXd_L	= 0xDD,
	Z80_OP_DDCB_SET_3_mIXd		= 0xDE,	Z80_OP_DDCB_SET_3_mIXd_A	= 0xDF,
	
	/* 0xE0 - 0xEF */
	Z80_OP_DDCB_SET_4_mIXd_B	= 0xE0,	Z80_OP_DDCB_SET_4_mIXd_C	= 0xE1,
	Z80_OP_DDCB_SET_4_mIXd_D	= 0xE2,	Z80_OP_DDCB_SET_4_mIXd_E	= 0xE3,
	Z80_OP_DDCB_SET_4_mIXd_H	= 0xE4,	Z80_OP_DDCB_SET_4_mIXd_L	= 0xE5,
	Z80_OP_DDCB_SET_4_mIXd		= 0xE6,	Z80_OP_DDCB_SET_4_mIXd_A	= 0xE7,
	Z80_OP_DDCB_SET_5_mIXd_B	= 0xE8,	Z80_OP_DDCB_SET_5_mIXd_C	= 0xE9,
	Z80_OP_DDCB_SET_5_mIXd_D	= 0xEA,	Z80_OP_DDCB_SET_5_mIXd_E	= 0xEB,
	Z80_OP_DDCB_SET_5_mIXd_H	= 0xEC,	Z80_OP_DDCB_SET_5_mIXd_L	= 0xED,
	Z80_OP_DDCB_SET_5_mIXd		= 0xEE,	Z80_OP_DDCB_SET_5_mIXd_A	= 0xEF,
	
	/* 0xF0 - 0xFF */
	Z80_OP_DDCB_SET_6_mIXd_B	= 0xF0,	Z80_OP_DDCB_SET_6_mIXd_C	= 0xF1,
	Z80_OP_DDCB_SET_6_mIXd_D	= 0xF2,	Z80_OP_DDCB_SET_6_mIXd_E	= 0xF3,
	Z80_OP_DDCB_SET_6_mIXd_H	= 0xF4,	Z80_OP_DDCB_SET_6_mIXd_L	= 0xF5,
	Z80_OP_DDCB_SET_6_mIXd		= 0xF6,	Z80_OP_DDCB_SET_6_mIXd_A	= 0xF7,
	Z80_OP_DDCB_SET_7_mIXd_B	= 0xF8,	Z80_OP_DDCB_SET_7_mIXd_C	= 0xF9,
	Z80_OP_DDCB_SET_7_mIXd_D	= 0xFA,	Z80_OP_DDCB_SET_7_mIXd_E	= 0xFB,
	Z80_OP_DDCB_SET_7_mIXd_H	= 0xFC,	Z80_OP_DDCB_SET_7_mIXd_L	= 0xFD,
	Z80_OP_DDCB_SET_7_mIXd		= 0xFE,	Z80_OP_DDCB_SET_7_mIXd_A	= 0xFF,
};


/**
 * Z80 opcodes: 3-byte opcodes, "FDCB" prefix.
 */
enum mdZ80_opcode_FDCB
{
	/* 0x00 - 0x0F */
	Z80_OP_FDCB_RLC_mIYd_B		= 0x00,	Z80_OP_FDCB_RLC_mIYd_C		= 0x01,
	Z80_OP_FDCB_RLC_mIYd_D		= 0x02,	Z80_OP_FDCB_RLC_mIYd_E		= 0x03,
	Z80_OP_FDCB_RLC_mIYd_H		= 0x04,	Z80_OP_FDCB_RLC_mIYd_L		= 0x05,
	Z80_OP_FDCB_RLC_mIYd		= 0x06,	Z80_OP_FDCB_RLC_mIYd_A		= 0x07,
	Z80_OP_FDCB_RRC_mIYd_B		= 0x08,	Z80_OP_FDCB_RRC_mIYd_C		= 0x09,
	Z80_OP_FDCB_RRC_mIYd_D		= 0x0A,	Z80_OP_FDCB_RRC_mIYd_E		= 0x0B,
	Z80_OP_FDCB_RRC_mIYd_H		= 0x0C,	Z80_OP_FDCB_RRC_mIYd_L		= 0x0D,
	Z80_OP_FDCB_RRC_mIYd		= 0x0E,	Z80_OP_FDCB_RRC_mIYd_A		= 0x0F,
	
	/* 0x10 - 0x1F */
	Z80_OP_FDCB_RL_mIYd_B		= 0x10,	Z80_OP_FDCB_RL_mIYd_C		= 0x11,
	Z80_OP_FDCB_RL_mIYd_D		= 0x12,	Z80_OP_FDCB_RL_mIYd_E		= 0x13,
	Z80_OP_FDCB_RL_mIYd_H		= 0x14,	Z80_OP_FDCB_RL_mIYd_L		= 0x15,
	Z80_OP_FDCB_RL_mIYd		= 0x16,	Z80_OP_FDCB_RL_mIYd_A		= 0x17,
	Z80_OP_FDCB_RR_mIYd_B		= 0x18,	Z80_OP_FDCB_RR_mIYd_C		= 0x19,
	Z80_OP_FDCB_RR_mIYd_D		= 0x1A,	Z80_OP_FDCB_RR_mIYd_E		= 0x1B,
	Z80_OP_FDCB_RR_mIYd_H		= 0x1C,	Z80_OP_FDCB_RR_mIYd_L		= 0x1D,
	Z80_OP_FDCB_RR_mIYd		= 0x1E,	Z80_OP_FDCB_RR_mIYd_A		= 0x1F,
	
	/* 0x20 - 0x2F */
	Z80_OP_FDCB_SLA_mIYd_B		= 0x20,	Z80_OP_FDCB_SLA_mIYd_C		= 0x21,
	Z80_OP_FDCB_SLA_mIYd_D		= 0x22,	Z80_OP_FDCB_SLA_mIYd_E		= 0x23,
	Z80_OP_FDCB_SLA_mIYd_H		= 0x24,	Z80_OP_FDCB_SLA_mIYd_L		= 0x25,
	Z80_OP_FDCB_SLA_mIYd		= 0x26,	Z80_OP_FDCB_SLA_mIYd_A		= 0x27,
	Z80_OP_FDCB_SRA_mIYd_B		= 0x28,	Z80_OP_FDCB_SRA_mIYd_C		= 0x29,
	Z80_OP_FDCB_SRA_mIYd_D		= 0x2A,	Z80_OP_FDCB_SRA_mIYd_E		= 0x2B,
	Z80_OP_FDCB_SRA_mIYd_H		= 0x2C,	Z80_OP_FDCB_SRA_mIYd_L		= 0x2D,
	Z80_OP_FDCB_SRA_mIYd		= 0x2E,	Z80_OP_FDCB_SRA_mIYd_A		= 0x2F,
	
	/* 0x30 - 0x3F */
	Z80_OP_FDCB_SLL_mIYd_B		= 0x30,	Z80_OP_FDCB_SLL_mIYd_C		= 0x31,
	Z80_OP_FDCB_SLL_mIYd_D		= 0x32,	Z80_OP_FDCB_SLL_mIYd_E		= 0x33,
	Z80_OP_FDCB_SLL_mIYd_H		= 0x34,	Z80_OP_FDCB_SLL_mIYd_L		= 0x35,
	Z80_OP_FDCB_SLL_mIYd		= 0x36,	Z80_OP_FDCB_SLL_mIYd_A		= 0x37,
	Z80_OP_FDCB_SRL_mIYd_B		= 0x38,	Z80_OP_FDCB_SRL_mIYd_C		= 0x39,
	Z80_OP_FDCB_SRL_mIYd_D		= 0x3A,	Z80_OP_FDCB_SRL_mIYd_E		= 0x3B,
	Z80_OP_FDCB_SRL_mIYd_H		= 0x3C,	Z80_OP_FDCB_SRL_mIYd_L		= 0x3D,
	Z80_OP_FDCB_SRL_mIYd		= 0x3E,	Z80_OP_FDCB_SRL_mIYd_A		= 0x3F,
	
	/* 0x40 - 0x4F */
	Z80_OP_FDCB_BIT_0_B		= 0x40,	Z80_OP_FDCB_BIT_0_C		= 0x41,
	Z80_OP_FDCB_BIT_0_D		= 0x42,	Z80_OP_FDCB_BIT_0_E		= 0x43,
	Z80_OP_FDCB_BIT_0_H		= 0x44,	Z80_OP_FDCB_BIT_0_L		= 0x45,
	Z80_OP_FDCB_BIT_0_mIYd		= 0x46,	Z80_OP_FDCB_BIT_0_A		= 0x47,
	Z80_OP_FDCB_BIT_1_B		= 0x48,	Z80_OP_FDCB_BIT_1_C		= 0x49,
	Z80_OP_FDCB_BIT_1_D		= 0x4A,	Z80_OP_FDCB_BIT_1_E		= 0x4B,
	Z80_OP_FDCB_BIT_1_H		= 0x4C,	Z80_OP_FDCB_BIT_1_L		= 0x4D,
	Z80_OP_FDCB_BIT_1_mIYd		= 0x4E,	Z80_OP_FDCB_BIT_1_A		= 0x4F,
	
	/* 0x50 - 0x5F */
	Z80_OP_FDCB_BIT_2_B		= 0x50,	Z80_OP_FDCB_BIT_2_C		= 0x51,
	Z80_OP_FDCB_BIT_2_D		= 0x52,	Z80_OP_FDCB_BIT_2_E		= 0x53,
	Z80_OP_FDCB_BIT_2_H		= 0x54,	Z80_OP_FDCB_BIT_2_L		= 0x55,
	Z80_OP_FDCB_BIT_2_mIYd		= 0x56,	Z80_OP_FDCB_BIT_2_A		= 0x57,
	Z80_OP_FDCB_BIT_3_B		= 0x58,	Z80_OP_FDCB_BIT_3_C		= 0x59,
	Z80_OP_FDCB_BIT_3_D		= 0x5A,	Z80_OP_FDCB_BIT_3_E		= 0x5B,
	Z80_OP_FDCB_BIT_3_H		= 0x5C,	Z80_OP_FDCB_BIT_3_L		= 0x5D,
	Z80_OP_FDCB_BIT_3_mIYd		= 0x5E,	Z80_OP_FDCB_BIT_3_A		= 0x5F,
	
	/* 0x60 - 0x6F */
	Z80_OP_FDCB_BIT_4_B		= 0x60,	Z80_OP_FDCB_BIT_4_C		= 0x61,
	Z80_OP_FDCB_BIT_4_D		= 0x62,	Z80_OP_FDCB_BIT_4_E		= 0x63,
	Z80_OP_FDCB_BIT_4_H		= 0x64,	Z80_OP_FDCB_BIT_4_L		= 0x65,
	Z80_OP_FDCB_BIT_4_mIYd		= 0x66,	Z80_OP_FDCB_BIT_4_A		= 0x67,
	Z80_OP_FDCB_BIT_5_B		= 0x68,	Z80_OP_FDCB_BIT_5_C		= 0x69,
	Z80_OP_FDCB_BIT_5_D		= 0x6A,	Z80_OP_FDCB_BIT_5_E		= 0x6B,
	Z80_OP_FDCB_BIT_5_H		= 0x6C,	Z80_OP_FDCB_BIT_5_L		= 0x6D,
	Z80_OP_FDCB_BIT_5_mIYd		= 0x6E,	Z80_OP_FDCB_BIT_5_A		= 0x6F,
	
	/* 0x70 - 0x7F */
	Z80_OP_FDCB_BIT_6_B		= 0x70,	Z80_OP_FDCB_BIT_6_C		= 0x71,
	Z80_OP_FDCB_BIT_6_D		= 0x72,	Z80_OP_FDCB_BIT_6_E		= 0x73,
	Z80_OP_FDCB_BIT_6_H		= 0x74,	Z80_OP_FDCB_BIT_6_L		= 0x75,
	Z80_OP_FDCB_BIT_6_mIYd		= 0x76,	Z80_OP_FDCB_BIT_6_A		= 0x77,
	Z80_OP_FDCB_BIT_7_B		= 0x78,	Z80_OP_FDCB_BIT_7_C		= 0x79,
	Z80_OP_FDCB_BIT_7_D		= 0x7A,	Z80_OP_FDCB_BIT_7_E		= 0x7B,
	Z80_OP_FDCB_BIT_7_H		= 0x7C,	Z80_OP_FDCB_BIT_7_L		= 0x7D,
	Z80_OP_FDCB_BIT_7_mIYd		= 0x7E,	Z80_OP_FDCB_BIT_7_A		= 0x7F,
	
	/* 0x80 - 0x8F */
	Z80_OP_FDCB_RES_0_mIYd_B	= 0x80,	Z80_OP_FDCB_RES_0_mIYd_C	= 0x81,
	Z80_OP_FDCB_RES_0_mIYd_D	= 0x82,	Z80_OP_FDCB_RES_0_mIYd_E	= 0x83,
	Z80_OP_FDCB_RES_0_mIYd_H	= 0x84,	Z80_OP_FDCB_RES_0_mIYd_L	= 0x85,
	Z80_OP_FDCB_RES_0_mIYd		= 0x86,	Z80_OP_FDCB_RES_0_mIYd_A	= 0x87,
	Z80_OP_FDCB_RES_1_mIYd_B	= 0x88,	Z80_OP_FDCB_RES_1_mIYd_C	= 0x89,
	Z80_OP_FDCB_RES_1_mIYd_D	= 0x8A,	Z80_OP_FDCB_RES_1_mIYd_E	= 0x8B,
	Z80_OP_FDCB_RES_1_mIYd_H	= 0x8C,	Z80_OP_FDCB_RES_1_mIYd_L	= 0x8D,
	Z80_OP_FDCB_RES_1_mIYd		= 0x8E,	Z80_OP_FDCB_RES_1_mIYd_A	= 0x8F,
	
	/* 0x90 - 0x9F */
	Z80_OP_FDCB_RES_2_mIYd_B	= 0x90,	Z80_OP_FDCB_RES_2_mIYd_C	= 0x91,
	Z80_OP_FDCB_RES_2_mIYd_D	= 0x92,	Z80_OP_FDCB_RES_2_mIYd_E	= 0x93,
	Z80_OP_FDCB_RES_2_mIYd_H	= 0x94,	Z80_OP_FDCB_RES_2_mIYd_L	= 0x95,
	Z80_OP_FDCB_RES_2_mIYd		= 0x96,	Z80_OP_FDCB_RES_2_mIYd_A	= 0x97,
	Z80_OP_FDCB_RES_3_mIYd_B	= 0x98,	Z80_OP_FDCB_RES_3_mIYd_C	= 0x99,
	Z80_OP_FDCB_RES_3_mIYd_D	= 0x9A,	Z80_OP_FDCB_RES_3_mIYd_E	= 0x9B,
	Z80_OP_FDCB_RES_3_mIYd_H	= 0x9C,	Z80_OP_FDCB_RES_3_mIYd_L	= 0x9D,
	Z80_OP_FDCB_RES_3_mIYd		= 0x9E,	Z80_OP_FDCB_RES_3_mIYd_A	= 0x9F,
	
	/* 0xA0 - 0xAF */
	Z80_OP_FDCB_RES_4_mIYd_B	= 0xA0,	Z80_OP_FDCB_RES_4_mIYd_C	= 0xA1,
	Z80_OP_FDCB_RES_4_mIYd_D	= 0xA2,	Z80_OP_FDCB_RES_4_mIYd_E	= 0xA3,
	Z80_OP_FDCB_RES_4_mIYd_H	= 0xA4,	Z80_OP_FDCB_RES_4_mIYd_L	= 0xA5,
	Z80_OP_FDCB_RES_4_mIYd		= 0xA6,	Z80_OP_FDCB_RES_4_mIYd_A	= 0xA7,
	Z80_OP_FDCB_RES_5_mIYd_B	= 0xA8,	Z80_OP_FDCB_RES_5_mIYd_C	= 0xA9,
	Z80_OP_FDCB_RES_5_mIYd_D	= 0xAA,	Z80_OP_FDCB_RES_5_mIYd_E	= 0xAB,
	Z80_OP_FDCB_RES_5_mIYd_H	= 0xAC,	Z80_OP_FDCB_RES_5_mIYd_L	= 0xAD,
	Z80_OP_FDCB_RES_5_mIYd		= 0xAE,	Z80_OP_FDCB_RES_5_mIYd_A	= 0xAF,
	
	/* 0xB0 - 0xBF */
	Z80_OP_FDCB_RES_6_mIYd_B	= 0xB0,	Z80_OP_FDCB_RES_6_mIYd_C	= 0xB1,
	Z80_OP_FDCB_RES_6_mIYd_D	= 0xB2,	Z80_OP_FDCB_RES_6_mIYd_E	= 0xB3,
	Z80_OP_FDCB_RES_6_mIYd_H	= 0xB4,	Z80_OP_FDCB_RES_6_mIYd_L	= 0xB5,
	Z80_OP_FDCB_RES_6_mIYd		= 0xB6,	Z80_OP_FDCB_RES_6_mIYd_A	= 0xB7,
	Z80_OP_FDCB_RES_7_mIYd_B	= 0xB8,	Z80_OP_FDCB_RES_7_mIYd_C	= 0xB9,
	Z80_OP_FDCB_RES_7_mIYd_D	= 0xBA,	Z80_OP_FDCB_RES_7_mIYd_E	= 0xBB,
	Z80_OP_FDCB_RES_7_mIYd_H	= 0xBC,	Z80_OP_FDCB_RES_7_mIYd_L	= 0xBD,
	Z80_OP_FDCB_RES_7_mIYd		= 0xBE,	Z80_OP_FDCB_RES_7_mIYd_A	= 0xBF,
	
	/* 0xC0 - 0xCF */
	Z80_OP_FDCB_SET_0_mIYd_B	= 0xC0,	Z80_OP_FDCB_SET_0_mIYd_C	= 0xC1,
	Z80_OP_FDCB_SET_0_mIYd_D	= 0xC2,	Z80_OP_FDCB_SET_0_mIYd_E	= 0xC3,
	Z80_OP_FDCB_SET_0_mIYd_H	= 0xC4,	Z80_OP_FDCB_SET_0_mIYd_L	= 0xC5,
	Z80_OP_FDCB_SET_0_mIYd		= 0xC6,	Z80_OP_FDCB_SET_0_mIYd_A	= 0xC7,
	Z80_OP_FDCB_SET_1_mIYd_B	= 0xC8,	Z80_OP_FDCB_SET_1_mIYd_C	= 0xC9,
	Z80_OP_FDCB_SET_1_mIYd_D	= 0xCA,	Z80_OP_FDCB_SET_1_mIYd_E	= 0xCB,
	Z80_OP_FDCB_SET_1_mIYd_H	= 0xCC,	Z80_OP_FDCB_SET_1_mIYd_L	= 0xCD,
	Z80_OP_FDCB_SET_1_mIYd		= 0xCE,	Z80_OP_FDCB_SET_1_mIYd_A	= 0xCF,
	
	/* 0xD0 - 0xDF */
	Z80_OP_FDCB_SET_2_mIYd_B	= 0xD0,	Z80_OP_FDCB_SET_2_mIYd_C	= 0xD1,
	Z80_OP_FDCB_SET_2_mIYd_D	= 0xD2,	Z80_OP_FDCB_SET_2_mIYd_E	= 0xD3,
	Z80_OP_FDCB_SET_2_mIYd_H	= 0xD4,	Z80_OP_FDCB_SET_2_mIYd_L	= 0xD5,
	Z80_OP_FDCB_SET_2_mIYd		= 0xD6,	Z80_OP_FDCB_SET_2_mIYd_A	= 0xD7,
	Z80_OP_FDCB_SET_3_mIYd_B	= 0xD8,	Z80_OP_FDCB_SET_3_mIYd_C	= 0xD9,
	Z80_OP_FDCB_SET_3_mIYd_D	= 0xDA,	Z80_OP_FDCB_SET_3_mIYd_E	= 0xDB,
	Z80_OP_FDCB_SET_3_mIYd_H	= 0xDC,	Z80_OP_FDCB_SET_3_mIYd_L	= 0xDD,
	Z80_OP_FDCB_SET_3_mIYd		= 0xDE,	Z80_OP_FDCB_SET_3_mIYd_A	= 0xDF,
	
	/* 0xE0 - 0xEF */
	Z80_OP_FDCB_SET_4_mIYd_B	= 0xE0,	Z80_OP_FDCB_SET_4_mIYd_C	= 0xE1,
	Z80_OP_FDCB_SET_4_mIYd_D	= 0xE2,	Z80_OP_FDCB_SET_4_mIYd_E	= 0xE3,
	Z80_OP_FDCB_SET_4_mIYd_H	= 0xE4,	Z80_OP_FDCB_SET_4_mIYd_L	= 0xE5,
	Z80_OP_FDCB_SET_4_mIYd		= 0xE6,	Z80_OP_FDCB_SET_4_mIYd_A	= 0xE7,
	Z80_OP_FDCB_SET_5_mIYd_B	= 0xE8,	Z80_OP_FDCB_SET_5_mIYd_C	= 0xE9,
	Z80_OP_FDCB_SET_5_mIYd_D	= 0xEA,	Z80_OP_FDCB_SET_5_mIYd_E	= 0xEB,
	Z80_OP_FDCB_SET_5_mIYd_H	= 0xEC,	Z80_OP_FDCB_SET_5_mIYd_L	= 0xED,
	Z80_OP_FDCB_SET_5_mIYd		= 0xEE,	Z80_OP_FDCB_SET_5_mIYd_A	= 0xEF,
	
	/* 0xF0 - 0xFF */
	Z80_OP_FDCB_SET_6_mIYd_B	= 0xF0,	Z80_OP_FDCB_SET_6_mIYd_C	= 0xF1,
	Z80_OP_FDCB_SET_6_mIYd_D	= 0xF2,	Z80_OP_FDCB_SET_6_mIYd_E	= 0xF3,
	Z80_OP_FDCB_SET_6_mIYd_H	= 0xF4,	Z80_OP_FDCB_SET_6_mIYd_L	= 0xF5,
	Z80_OP_FDCB_SET_6_mIYd		= 0xF6,	Z80_OP_FDCB_SET_6_mIYd_A	= 0xF7,
	Z80_OP_FDCB_SET_7_mIYd_B	= 0xF8,	Z80_OP_FDCB_SET_7_mIYd_C	= 0xF9,
	Z80_OP_FDCB_SET_7_mIYd_D	= 0xFA,	Z80_OP_FDCB_SET_7_mIYd_E	= 0xFB,
	Z80_OP_FDCB_SET_7_mIYd_H	= 0xFC,	Z80_OP_FDCB_SET_7_mIYd_L	= 0xFD,
	Z80_OP_FDCB_SET_7_mIYd		= 0xFE,	Z80_OP_FDCB_SET_7_mIYd_A	= 0xFF,
};


#endif /* _MDZ80_OPCODES_H */
